#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <stdint.h>

int
main(int argc, char *argv[])
{
	int fd;
	volatile void *mem;
	volatile uint16_t *fpga;
	int i;
	FILE *log;

	fd = open("/dev/mem", O_RDWR);
	if (fd < 0) {
		fprintf(stderr, "Can't open /dev/mem: %s\n",
			strerror(errno));
		return 1;
	}

	mem = mmap(NULL, 0x4000000 /* 64 kB */, PROT_READ | PROT_WRITE,
		MAP_SHARED, fd, 0x66000000);
	if (mem == MAP_FAILED) {
		fprintf(stderr, "Can't mmap memory: %s\n", strerror(errno));
		close(fd);
		return 1;
	}
	close(fd);

	fpga = (volatile uint16_t *)mem;
	log = fopen("emifatest.log", "w");
	if (log == NULL) {
		fprintf(stderr, "Cannot open log file: %s\n", strerror(errno));
		munmap((void *)mem, 0x4000000);
		return 1;
	}

	for (i = 0 ; i < 0x10000 / 2 ; ++i) {
		fprintf(log, "{ 0x%04X , 0x%04X }, // [%s]\n",
			i << 1, fpga[i], ((i << 1)!=fpga[i])?"NOK":"OK");
	}

	fclose(log);
	munmap((void *)mem, 0x4000000);
	return 0;
}
