/**
 *      \file   ltc2945.h
 *
 *      \brief  Class for the LTC2945 interface.
 *
 *     o  0
 *     | /       Copyright (c) 2014
 *    (CL)---o   Critical Link, LLC
 *      \
 *       O
 */

#ifndef _LTC2945_H_ 
#define _LTC2945_H_

#include "i2cdevice.h"

#include <stdint.h>

namespace MityDSP
{
    
/**
 *  A simple interface class to the LTC2945 based
 *  power monitor.  By default, sensors will run continuously
 *  in highest resolution mode of operation.
 */
class tcLTC2945 : public tcI2CDevice
{
public:
   
	/**
	 * Constructor.
	 *
	 * @param anBus Bus number. Will open /dev/i2c-%d for I2C communcation.
	 * @param anAddr The I2C address of the battery.
	 */
	tcLTC2945(int anBus, int anAddr, float Rsens, float Vin);

	/**
	 * Destructor.
	 */
	virtual ~tcLTC2945(void) {};

	/**
	 * Get the voltage across Rsens
	 *
	 * \param[out] volts voltage
	 *
	 * @return non-zero on error
	 */
	int GetDeltaSense(float& volts);

	int Initialize(void);

	/**
	 * Get estimated power consumption based on Vin and current estimate.
	 */
	int GetPowerW(float& power);
  	
protected:
	float mnRsens;
	float mnVin;
};

}
#endif
