----------------------------------------------------------------------------------
-- Company:        Envisens Technologies
-- Engineer:       OR
-- 
-- Create Date:    11:55:51 03/31/2014 
-- Design Name:    FPGA to MityDSP interface
-- Module Name:    top - Behavioral 
-- Project Name:   FIFO2
-- Target Devices: Spartan6
-- Tool versions:  14.3
-- Description:    Debug code for MITY DEV board
--
-- Dependencies:   Cloccoman, FIFO8192depth_11wordsize,scaloclock
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------

-------------------------------------------------------------
--------------- Start of SYNTHESIS code ---------------------
-------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
library UNISIM;
use UNISIM.VComponents.all;
LIBRARY XilinxCoreLib;


entity top is
    Port ( --ADC_INPUT        : in  STD_LOGIC_VECTOR (11 downto 0);   	-- These are the input from ADC
           ADC_CLOCK        : in  STD_LOGIC;                        	-- Clock from AD9360 clock generator
			  --RAMP_END         : in  STD_LOGIC;                        	-- End of Chirp signal from ADF4158 PLL Chirp generator 
			  FPGA_to_uPP_DATA : out STD_LOGIC_VECTOR (11 downto 0); 	-- These are the output from FPGA to OMAPL138 (uPP bus)
			  FPGA_to_uPP_ENBL : out STD_LOGIC;									-- uPP Channel A Enable Signal
			  uPP_to_FPGA_WAIT : in  STD_LOGIC;								  	-- uPP Channel A Wait Signal	
			  FPGA_to_uPP_CLK  : out STD_LOGIC;                       	-- uPP Channel A Clock
			  FPGA_to_uPP_START: out STD_LOGIC;							  		-- uPP Channel A Start Signal
			  SINE_GEN_BIT_TEST: out STD_LOGIC;									-- a simple test on MSB of sine generator
			  FPGA_OUT_CLK     : out STD_LOGIC);							  		-- Debug signal (just the outputted clock)
			  --LED_Ports        : out std_logic_vector(3 downto 0):="0000");  	-- LED ports
end top; 			 

architecture Behavioral of top is

----- Components for ADC (ADS 9224) debug ---------
-- Integrated CONtroller
component icon
  PORT (
    CONTROL0 : INOUT STD_LOGIC_VECTOR(35 DOWNTO 0));

end component;

-- Integrated Logic Analyzer
component ILA
  PORT (
    CONTROL : INOUT STD_LOGIC_VECTOR(35 DOWNTO 0);
    CLK : IN STD_LOGIC;
    DATA : IN STD_LOGIC_VECTOR(11 DOWNTO 0);
    TRIG0 : IN STD_LOGIC_VECTOR(0 TO 0));

end component;
----------------------------------------------------

------ For uPP debugging purpose ------------------
-- Component Sine generator declaration
component Sine_generator
  PORT (
	    aclk : IN STD_LOGIC;
       aclken : IN STD_LOGIC;
       aresetn : IN STD_LOGIC;
       m_axis_data_tvalid : OUT STD_LOGIC;
       m_axis_data_tdata : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)
		 );
end component;
----------------------------------------------------

-- Component Core declaration (DCM module)
component core
port
 (-- Clock in ports
  CLK_IN1           : in     std_logic;
  -- Clock out ports
  CLK_OUT1          : out    std_logic;
  CLK_OUT2          : out    std_logic;
  ADC_CLK_OUT	     : out    std_logic;
   -- Status and control signals
  RESET             : in     std_logic;
  INPUT_CLK_STOPPED : out    std_logic;
  LOCKED            : out    std_logic
  );
 end component;
 
-- Component Scale declaration (A simple clock divider) 
component scale_clock
 port 
 (
    clk_20Mhz : in  std_logic;
    rst       : in  std_logic;
	 clk_1Hz   : out std_logic;
	 clk_2Hz   : out std_logic
  );
end component;

---- Component FIFO declaration 
component fifo
  port (
    rst : IN STD_LOGIC;
    wr_clk : IN STD_LOGIC;
    rd_clk : IN STD_LOGIC;
    din : IN STD_LOGIC_VECTOR(11 DOWNTO 0);
    wr_en : IN STD_LOGIC;
    rd_en : IN STD_LOGIC;
    dout : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);
    full : OUT STD_LOGIC;
    almost_full : OUT STD_LOGIC;
    wr_ack : OUT STD_LOGIC;
    overflow : OUT STD_LOGIC;
    empty : OUT STD_LOGIC;
    almost_empty : OUT STD_LOGIC;
    valid : OUT STD_LOGIC;
    underflow : OUT STD_LOGIC;
    rd_data_count : OUT STD_LOGIC_VECTOR(9 DOWNTO 0);
    wr_data_count : OUT STD_LOGIC_VECTOR(9 DOWNTO 0)
  );
end component;

-- Signals
-- DCM signals
signal INPUT_CLK					: std_logic;                 
signal clk_out1 						: std_logic;                 
signal DCM_LOCKED_STATUS 			: std_logic; 			-- Asserted when DCM is LOCKED					 		
signal DCM_INPUT_RESET				: std_logic :='1';	-- Reset input of DCM module
signal DCM_INPUT_CLK_STATUS 		: std_logic;			-- DCM CLOCK input status
signal FPGA_to_uPP_ENBL_sig		: std_logic;			-- FPGA send enable signal to uPP

-- Auziliary signals
signal my_clk_output_buffered_neg : std_logic;  					-- my_clock_output out of phase
signal my_clk_output_buffered_neg2 : std_logic;  					-- my_clock_output out of phase
signal my_ODDR_out				: std_logic;							-- my_clock_output outputted from ODDR2 component
signal my_ODDR_out2				: std_logic;							-- my_clock_output outputted from ODDR2 component
signal BUFFER_CLK					: std_logic;
signal DOUBLE_CLK					: std_logic;

-- Sine generator signals
signal m_axis_data_tvalid:    std_logic;
signal m_axis_data_tdata:		std_logic_vector(15 downto 0);
signal aclken:						std_logic:='1';
signal aresetn:					std_logic:='1';




begin


-------------------- Sine_generator port instantiation ---------------
-- A sine generator for uPP debug purposes
--Sine_gen : Sine_generator
--  PORT MAP (
--    aclk => FIFO_WR_CLK,
--    aclken => aclken,
--    aresetn => aresetn,
--    m_axis_data_tvalid => m_axis_data_tvalid,
--    m_axis_data_tdata => m_axis_data_tdata
--  );
  
  -- m_axis_data_tdata is a 15 bits, but only 11   bits are used.
  -- Prior to assign them to output bus, truncates it.
  FPGA_to_uPP_DATA <= m_axis_data_tdata(11 downto 0);
  m_axis_data_tdata(0)<='1';m_axis_data_tdata(1)<='1';m_axis_data_tdata(2)<='1';
  m_axis_data_tdata(3)<='1';m_axis_data_tdata(4)<='1';m_axis_data_tdata(5)<='1';
  m_axis_data_tdata(6)<='1';m_axis_data_tdata(7)<='1';m_axis_data_tdata(8)<='1';
  m_axis_data_tdata(9)<='1';m_axis_data_tdata(10)<='1';m_axis_data_tdata(11)<='1';
  SINE_GEN_BIT_TEST <=m_axis_data_tdata(0);
-----------------------------------------------------------------------

----------------------------------------------------------------------	 
-- Component "cloccloman" of type "core" instantiation and mapping
-- It is used for clock management
cloccoman : core
  port map
   (-- Clock in ports
    CLK_IN1 => ADC_CLOCK,
    -- Clock out ports
    CLK_OUT1 => DOUBLE_CLK,  -- This is FIFO Read Clock (ADC_INPUT x 2)
	 CLK_OUT2 => BUFFER_CLK,  -- This is FIFO Write Clock (ADC_INPUT x 1)
	 ADC_CLK_OUT => INPUT_CLK,   -- This is a reply of ADC_CLOCK
	 RESET 	 => DCM_INPUT_RESET,
	 INPUT_CLK_STOPPED => DCM_INPUT_CLK_STATUS,
    LOCKED 	 => DCM_LOCKED_STATUS
    );

DCM_reset_management: process(INPUT_CLK,DCM_INPUT_RESET,DCM_INPUT_CLK_STATUS)
variable counter : integer range 0 to 6600000:=0;
constant ONE_SEC_CLOCK_TICKS : integer := 6600000; 
begin 
 
 if DCM_INPUT_RESET = '0' then
         counter   :=  0;
 elsif rising_edge(INPUT_CLK) then               -- Hold Reset to 1 for 1 sec in order
		if counter = ONE_SEC_CLOCK_TICKS then      -- to reset DCM and acquire LOCK
			counter := 0;
			DCM_INPUT_RESET <= '0';
		else
			counter := counter + 1;   
		 end if;
   end if;
	if DCM_INPUT_CLK_STATUS ='1' then -- Input clock fail: Hold DCM in RESET
	DCM_INPUT_RESET <= '1';
	counter   :=  0;
 end if;
end process DCM_reset_management;


FPGA_to_uPP_START <= '1';
FPGA_to_uPP_ENBL_sig <= '1';
FPGA_to_uPP_ENBL <= FPGA_to_uPP_ENBL_sig;

-----------------------------------------------------------------------------------------
-- uPP clock output (From FIFO_RD_CLK)

-- This is the negated version of INPUT_CLK, serves as input of ODDR2 component
my_clk_output_buffered_neg<= not DOUBLE_CLK;
--
-- ODDR2 component: used in order to output a clock (just used for debug)
ODDR2_inst : ODDR2
generic map(
DDR_ALIGNMENT => "NONE", -- Sets output alignment to "NONE", "C0", "C1"
INIT => '0', -- Sets initial state of the Q output to '0' or '1'
SRTYPE => "SYNC") -- Specifies "SYNC" or "ASYNC" set/reset
port map (
Q => my_ODDR_out, -- 1-bit output data
C0 => DOUBLE_CLK, -- 1-bit clock input
C1 => my_clk_output_buffered_neg, -- 1-bit clock input
CE => '1', -- 1-bit clock enable input
D0 => '1', -- 1-bit data input (associated with C0)
D1 => '0', -- 1-bit data input (associated with C1)
R => '0', -- 1-bit reset input
S => '0' -- 1-bit set input
);

-- An output buffer to drive the clock out to the FPGA pin 
OBUF_inst : OBUF
generic map (
DRIVE => 12,
IOSTANDARD => "LVCMOS33",
SLEW => "SLOW")
port map (
O => FPGA_to_uPP_CLK, -- Buffer output (connect directly to top-level port)
I => my_ODDR_out -- Buffer input
);
-------------------------------------------------------------------------------------------

-- Test clock

---- This is the negated version of INPUT_CLK, serves as input of ODDR2 component
--my_clk_output_buffered_neg2<= not BUFFER_CLK;
----
---- ODDR2 component: used in order to output a clock (just used for debug)
--ODDR2_inst2 : ODDR2
--generic map(
--DDR_ALIGNMENT => "NONE", -- Sets output alignment to "NONE", "C0", "C1"
--INIT => '0', -- Sets initial state of the Q output to '0' or '1'
--SRTYPE => "SYNC") -- Specifies "SYNC" or "ASYNC" set/reset
--port map (
--Q => my_ODDR_out2, -- 1-bit output data
--C0 => BUFFER_CLK, -- 1-bit clock input
--C1 => my_clk_output_buffered_neg2, -- 1-bit clock input
--CE => '1', -- 1-bit clock enable input
--D0 => '1', -- 1-bit data input (associated with C0)
--D1 => '0', -- 1-bit data input (associated with C1)
--R => '0', -- 1-bit reset input
--S => '0' -- 1-bit set input
--);
--
---- An output buffer to drive the clock out to the FPGA pin 
--OBUF_inst2 : OBUF
--generic map (
--DRIVE => 12,
--IOSTANDARD => "LVCMOS33",
--SLEW => "SLOW")
--port map (
--O => SINE_GEN_BIT_TEST, -- Buffer output (connect directly to top-level port)
--I => my_ODDR_out2 -- Buffer input
--);


end Behavioral;
-------------------------------------------------------------
--------------- End of SYNTHESIS code -----------------------
-------------------------------------------------------------


