----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    10:34:38 04/02/2014 
-- Design Name: 
-- Module Name:    cloccodivider - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

library IEEE;
use IEEE.STD_LOGIC_1164.all;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.all;

entity scale_clock is
  port (
    clk_20Mhz : in  std_logic;
    rst       : in  std_logic;
	 clk_1Hz	  : out std_logic;
	 clk_2Hz   : out std_logic
	 );
end scale_clock;

architecture Behavioral of scale_clock is

 signal prescaler : integer range 0 to 1500000:=0;
 signal pre_scaler : integer range 0 to 3000000:=0;
  
  signal clk_2Hz_i : std_logic;
  signal clk_1Hz_i : std_logic;
begin

  gen_clk_2Hz : process (clk_20Mhz, rst)
  begin  -- process gen_clk
    if rst = '1' then
      clk_2Hz_i   <= '0';
      prescaler   <=  0;
    elsif rising_edge(clk_20Mhz) then   -- rising clock edge
      if prescaler = 1500000 then     -- 1500000 
        prescaler <= 0;
        clk_2Hz_i   <= not clk_2Hz_i;
      else
        prescaler <= prescaler + 1;
      end if;
    end if;
  end process gen_clk_2Hz;
  
  gen_clk_1Hz : process (clk_20Mhz, rst)
  begin  -- process gen_clk
    if rst = '1' then
      clk_1Hz_i   <= '0';
      pre_scaler   <=  0;
    elsif rising_edge(clk_20Mhz) then   -- rising clock edge
      if pre_scaler = 3000000 then     -- 3000000
        pre_scaler <= 0;
        clk_1Hz_i   <= not clk_1Hz_i;
      else
        pre_scaler <= pre_scaler + 1;
      end if;
    end if;
  end process gen_clk_1Hz;

clk_2Hz <= clk_2Hz_i;
clk_1Hz <= clk_1Hz_i;

end Behavioral;
