// L138_aic3106_init.c
//

#include "L138_aic3106_init.h"
#include "evmomapl138_spi.h"
#include "evmomapl138.h"


//#define PINMUX_GP08_REG_0          (0)
//#define PINMUX_GP08_MASK_0         (0xF0000000)
//#define PINMUX_GP08_VAL_0          (0x80000000)
//#define PINMUX_GP514_REG_0         (11)
//#define PINMUX_GP514_MASK_0        (0x000000F0)
//#define PINMUX_GP514_VAL_0         (0x80000080)


int16_t *pingIN, *pingOUT, *pongIN, *pongOUT;

AIC31_data_type AIC31_data;

typedef struct BITVAL    // used in function prbs()
{
 unsigned int b0:1, b1:1, b2:1, b3:1, b4:1, b5:1, b6:1;
 unsigned int b7:1, b8:1, b9:1, b10:1, b11:1, b12:1,b13:1;
 unsigned int dweebie:2; //Fills the 2 bit hole - bits 14-15
} bitval;

typedef union SHIFT_REG
{
 unsigned int regval;
 bitval bt;
} shift_reg;
int fb = 1;                        // feedback variable
shift_reg sreg = {0xFFFF};         // shift register

uint32_t prand_seed = 1;       // used in function prand()

extern void vectors(void);

void output_sample(int32_t out_data)
{
  AIC31_data.uint = out_data;
  if (poll) while (!CHKBIT(MCASP->SRCTL15, XRDY));
  MCASP->XBUF0 = AIC31_data.uint;
}
   
void output_left_sample(int16_t out_data)
{
  AIC31_data.uint = 0;
  AIC31_data.channel[LEFT]=out_data;
  if (poll) while (!CHKBIT(MCASP->SRCTL15, XRDY));
  MCASP->XBUF0 = AIC31_data.uint;
}


void L138_init_mcasp_poll()
{

	// globally reset McASP0
		MCASP->GBLCTL  = 0;

//		   // configure McASP0 receive registers
		MCASP->RMASK      = 0xFFFFFFFF;
		MCASP->RFMT       = 0x000080F8;
		MCASP->AFSRCTL    = 0x00000000;
		MCASP->ACLKRCTL   = 0x00000000;
		MCASP->AHCLKRCTL  = 0x00000000;
		MCASP->RTDM       = 0x00000001; // TDM timeslot 0
		MCASP->RINTCTL    = 0x00000000;
		MCASP->RCLKCHK    = 0x00000000;

		   // configure McASP0 transmit registers
	    MCASP->XMASK      = 0xFFFFFFFF;
//		MCASP->XFMT       = 0x000080F8;
		MCASP->XFMT       = 0x00018070;
//		MCASP->AFSXCTL    = 0x00000002;
		MCASP->AFSXCTL    = 0x00000112;
	//	MCASP->AFSXCTL    = 0x00000000;
//		MCASP->ACLKXCTL   = 0x00000000;
		MCASP->ACLKXCTL   = 0x000000A3;
//		MCASP->AHCLKXCTL  = 0x00000000;
		MCASP->AHCLKXCTL  = 0x00008004;
		MCASP->XTDM       = 0x00000003; // TDM timeslot 0
		MCASP->XINTCTL    = 0x00000000; // interrupt on transmit
		MCASP->XCLKCHK    = 0x00000000;


		   // config pin function and direction.
		MCASP->PFUNC      = 0;
	//	MCASP->PDIR       = 0x00020000;
		MCASP->PDIR       = 0X14008000;
//		MCASP->PDIR       = 0x00008000;


		   //
		MCASP->XEVTCTL    = 0x00000000;
		MCASP->DITCTL     = 0x00000000;
		MCASP->DLBCTL     = 0x00000000;
		MCASP->AMUTE      = 0x00000000;


		   // Transmitter
		SETBIT(MCASP->XGBLCTL, XHCLKRST);
		while (!CHKBIT(MCASP->XGBLCTL, XHCLKRST)) {}
		SETBIT(MCASP->XGBLCTL, XCLKRST);
	    while (!CHKBIT(MCASP->XGBLCTL, XCLKRST)) {}
		SETBIT(MCASP->XGBLCTL, XSRCLR); //TXSERCLRS
		while (!CHKBIT(MCASP->XGBLCTL, XSRCLR)) {}
		MCASP->XBUF0 = 0;

		SETBIT(MCASP->XGBLCTL, XSMRST);
		while (!CHKBIT(MCASP->XGBLCTL, XSMRST)) {}
		SETBIT(MCASP->XGBLCTL, XFRST);
		while (!CHKBIT(MCASP->XGBLCTL, XFRST)) {}
		MCASP->XBUF0 = 0;

		   // configure serialisers (15 for xmit, 12 for rcv)
	    MCASP->SRCTL15    = 0x000D;
		MCASP->SRCTL12    = 0x000E;

		MCASP->XSTAT = 0xFFFFFFFF;        // Clear all

	    while(!CHKBIT(MCASP->SRCTL15, XRDY)) {}
	    MCASP->XBUF0 = 0;


		   //Receiver
//		SETBIT(MCASP->RGBLCTL, RHCLKRST);
//		while (!CHKBIT(MCASP->RGBLCTL, RHCLKRST)) {}
//		SETBIT(MCASP->RGBLCTL, RSRCLR);
//		while (!CHKBIT(MCASP->RGBLCTL, RSRCLR)) {}
//		SETBIT(MCASP->RGBLCTL, RSMRST);
//		while (!CHKBIT(MCASP->RGBLCTL, RSMRST)) {}
//		SETBIT(MCASP->RGBLCTL, RFRST);
//		while (!CHKBIT(MCASP->RGBLCTL, RFRST)) {}
//
//		MCASP->RSTAT = 0x0000FFFF;        // Clear all
//
//		   // Write zero to serialiser buffers so that no underrun occurs after releasing the state machine
//
//		MCASP->RBUF12 = 0;

	   // wait for transmit ready and send a dummy byte.
}



void L138_initialise_poll()
{
  
  poll = 1;     // used in input_sample() and output_sample() functions

//  spi_config_t spi_config;


//   bsl initialisation functions
//  EVMOMAPL138_init();
//  EVMOMAPL138_initRAM();
//  USTIMER_init();

  EVMOMAPL138_lpscTransition(PSC1, DOMAIN0, LPSC_MCASP0, PSC_ENABLE);
  EVMOMAPL138_lpscTransition(PSC1, DOMAIN0, LPSC_GPIO, PSC_ENABLE);
  EVMOMAPL138_pinmuxConfig(PINMUX_MCASP_REG_0, PINMUX_MCASP_MASK_0, PINMUX_MCASP_VAL_0);
  EVMOMAPL138_pinmuxConfig(PINMUX_MCASP_REG_1, PINMUX_MCASP_MASK_1, PINMUX_MCASP_VAL_1);


  CSR = 0x0000; // disable interrupts globally while initialising

  L138_init_mcasp_poll();

  ICR = 0xFFF0; 
}

int prbs(void) 			       //gen pseudo-random sequence {-1,1}
{
  int prnseq;			 
  if(sreg.bt.b0)
	prnseq = -NOISELEVEL;		           //scaled negative noise level
  else
	prnseq = NOISELEVEL;		           //scaled positive noise level
  fb =(sreg.bt.b0)^(sreg.bt.b1);   //XOR bits 0,1
  fb^=(sreg.bt.b11)^(sreg.bt.b13); //with bits 11,13 -> fb
  sreg.regval<<=1;
  sreg.bt.b0=fb;			       //close feedback path
  return prnseq;			       //return noise sequence value 
}



uint32_t rand31_next()
{
  uint32_t hi, lo;

  lo = 16807 * (prand_seed & 0xFFFF);
  hi = 16807 * (prand_seed >> 16);

  lo += (hi & 0x7FFF) << 16;
  lo += hi >> 15;

  if (lo > 0x7FFFFFFF) lo -= 0x7FFFFFFF;

  return(prand_seed = (uint32_t)lo);
}

int16_t prand()
{
return ((int16_t)(rand31_next()>>18)-4096);
}
