#!/bin/sh
#CAN Bus loopback test script
#Gregory Dias
#Last modified 5/14/2014

if [ $# -lt 1 ]
then
	echo "Please specify a bitrate (bits/second)"
	exit 1
fi

case $1 in
    ''|*[!0-9]*) echo "Please specify an integer bitrate";exit 1;;
    *) BITRATE=$1 ;;
esac

#BITRATE=$1

if [[ $BITRATE -lt 10000 && $BITRATE -gt 1000000 ]]
then
	echo "Please specify a bitrate in the range of 10Kbits to 1Mbits"
	echo "in a numerical format. (EX: 500Kbits is 500000)"
	exit 1
fi

echo "CAN Bus loopback test script - V1"
echo
echo "Configuring devices with bitrate $BITRATE..."
echo
canconfig can0 stop
canconfig can1 stop

canconfig can0 bitrate $BITRATE
canconfig can1 bitrate $BITRATE

canconfig can0 start
canconfig can1 start

echo
echo "Test 1: can1 -> can0"
echo "============================"
#read from can0, write from can1

candump can0 > can0.out &
CAN0_PID=$!

cansend can1 -i 0x00 0x11 0x22 0x33 0x44 0x55 0x66 0x77 0x88 --loop=15
sleep 2
cansend can1 -i 0x88 0x88 0x77 0x66 0x55 0x44 0x33 0x22 0x11 --loop=15
sleep 2

kill $CAN0_PID

#send one last message to ensure candump is closed (odd)
cansend can1 -i 0xAA

WC=`wc -l can0.out | awk '{print $1}'`
LOOP1COUNT=0
LOOP2COUNT=0

while read LINE
do
	if [ "$LINE" == "<0x000> [8] 11 22 33 44 55 66 77 88" ]
	then
		LOOP1COUNT=`expr $LOOP1COUNT + 1`
	fi
	if [ "$LINE" == "<0x088> [8] 88 77 66 55 44 33 22 11" ]
	then
		LOOP2COUNT=`expr $LOOP2COUNT + 1`
	fi
	if [ "$LINE" == "<0x0aa> [0]" ]
	then
		WC=`expr $WC - 2`
	fi
done < can0.out

if [ $WC -eq `expr $LOOP1COUNT + $LOOP2COUNT` ]
then
	CAN0R="PASS"
	CAN1W="PASS"
else
	CAN0R="FAIL"
	CAN1W="FAIL"
fi

if [ $WC -eq 0 ]
then
	CAN0R="FAIL"
	CAN1W="FAIL"
fi

echo
echo "Test 2: can0 -> can1"
echo "============================"

#read from can1, write from can0

candump can1 > can1.out &
CAN1_PID=$!

cansend can0 -i 0xFF 0x99 0xAA 0xBB 0xCC 0xDD 0xEE 0xFF 0x00 --loop=15
sleep 2
cansend can0 -i 0x22 0x00 0xFF 0xEE 0xDD 0xCC 0xBB 0xAA 0x99 --loop=15
sleep 2

kill $CAN1_PID

#send one last message to ensure candump is closed
cansend can0 -i 0x33

WC=`wc -l can1.out | awk '{print $1}'`
LOOP1COUNT=0
LOOP2COUNT=0

while read LINE
do
        if [ "$LINE" == "<0x0ff> [8] 99 aa bb cc dd ee ff 00" ]
        then
                LOOP1COUNT=`expr $LOOP1COUNT + 1`
        fi
        if [ "$LINE" == "<0x022> [8] 00 ff ee dd cc bb aa 99" ]
        then
                LOOP2COUNT=`expr $LOOP2COUNT + 1`
        fi
        if [ "$LINE" == "<0x033> [0]" ]
        then
                WC=`expr $WC - 2`
        fi
done < can1.out

if [ $WC -eq `expr $LOOP1COUNT + $LOOP2COUNT` ]
then
	CAN1R="PASS"
	CAN0W="PASS"
else
	CAN1R="FAIL"
	CAN0W="FAIL"
fi

if [ $WC -eq 0 ]
then
	CAN1R="FAIL"
	CAN0W="FAIL"
fi

echo 
echo "Test results:"
echo "can0: Read - $CAN0R | Write - $CAN0W"
echo "can1: Read - $CAN1R | Write - $CAN1W"

#cleanup
rm can[0-1].out

echo
echo done.

