# example python script for capturing an image from CMV50K EVK
#
# conda create -n gentl_38 matplotlib python=3.8
# conda activate gentl_38
# pip install harvesters numpy
#
# you must have c:\Program Files\Critical Link LLC\GenTL Viewer\bin in your path prior to running this script.
# set PATH=c:\Program Files\Critical Link LLC\GenTL Viewer\bin;%PATH%
#
# To enable simulated camera for testing:
# copy "c:\Program Files\Critical Link LLC\GenTL Viewer\bin\sim_camera.xml" .
# set SIMCAM_XML_FILE=sim_camera.xml
# 
# (gentl_38) C:\Users\jcormier\Documents>python snap.py
from harvesters.core import Harvester
import logging
import matplotlib.pyplot as plt

import os
print(os.getenv('HARVESTERS_XML_FILE_DIR'))

# set up a logger for the harvester library.
# this is not needed but can be useful for debugging your script
logger = logging.getLogger('harvesters');
ch = logging.StreamHandler()
logger.setLevel(logging.DEBUG)
ch.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
ch.setFormatter(formatter)
logger.addHandler(ch)

# Create the harvester
h = Harvester(logger=logger)
# the harvester can load dlls as well as cti files.
if "add_file" in dir(h): # Use updated harvesters api if exists
	h.add_file('c:\\Program Files\\Critical Link LLC\\GenTL Viewer\\bin\\GenTL.dll')
else:
	h.add_cti_file('c:\\Program Files\\Critical Link LLC\\GenTL Viewer\\bin\\GenTL.dll')
if "update" in dir(h): # Use updated harvesters api if exists
	h.update()
else:
	h.update_device_info_list()

print("Found {} devices".format(len(h.device_info_list)))
print(h.device_info_list)

if len(h.device_info_list) == 0:
	print("No devices found")
	exit()

# create an image acquirer
if "create" in dir(h): # Use updated harvesters api if exists
	ia = h.create(0)
else:
	ia = h.create_image_acquirer(list_index=0)
# this is required for larger images (> 16 MiB) with Critical Link's producer.
ia.num_buffers = 5
ia.remote_device.node_map.PixelFormat.value = 'Mono8'
# Uncomment to set the image ROI width, height. Otherwise will get full frame
#ia.remote_device.node_map.Width.value, ia.remote_device.node_map.Height.value = 800, 600

print("Starting Acquistion")

if "start" in dir(ia): # Use updated harvesters api if exists
	ia.start()
else:
	ia.start_image_acquisition()

# just capture 1 frame
for i in range(1):
	if "fetch" in dir(ia): # Use updated harvesters api if exists
		fetch = ia.fetch
	else:
		fetch = ia.fetch_buffer
	with fetch(timeout=4) as buffer:
		payload = buffer.payload
		component = payload.components[0]
		width = component.width
		height = component.height
		data_format = component.data_format
		print("Image details: {}w {}h {}".format(width, height, data_format))
		# for monochrome 8 bit images
		if int(component.num_components_per_pixel) == 1:
			content = component.data.reshape(height, width)
		else:
			content = component.data.reshape(height, width, int(component.num_components_per_pixel))
		if int(component.num_components_per_pixel) == 1:
			plt.imshow(content, cmap='gray')
		else:
			plt.imshow(content)
		plt.show()

#
if "stop" in dir(ia): # Use updated harvesters api if exists
	ia.stop()
else:
	ia.stop_image_acquisition()

ia.destroy()
