# example python script for capturing an image from Critical Link Camera Platforms
#
# conda create -n gentl_38 matplotlib python=3.8
# conda activate gentl_38
# pip install numpy harvesters==1.4.0 genicam==1.2.0
#
# you must have c:\Program Files\Critical Link LLC\GenTL Viewer\bin in your path prior to running this script.
# set PATH=c:\Program Files\Critical Link LLC\GenTL Viewer\bin;%PATH%
#
# set HARVESTERS_XML_FILE_DIR=C:\Users\jcormier\Documents\Critical Link LLC\gentlviewer\xml
#
# To enable simulated camera for testing:
# copy "c:\Program Files\Critical Link LLC\GenTL Viewer\bin\sim_camera.xml" .
# set SIMCAM_XML_FILE=sim_camera.xml
# 
# (gentl_38) C:\Users\jcormier\Documents>python snap.py
import os
document_path = os.path.expanduser('~\\Documents')
os.environ["HARVESTERS_XML_FILE_DIR"] = os.path.join(document_path, "Critical Link LLC\\gentlviewer\\xml")
print(os.getenv('HARVESTERS_XML_FILE_DIR'))
print(os.getenv('PATH'))

from harvesters.core import Harvester
import logging
import matplotlib.pyplot as plt


# set up a logger for the harvester library.
# this is not needed but can be useful for debugging your script
logger = logging.getLogger('harvesters');
ch = logging.StreamHandler()
logger.setLevel(logging.DEBUG)
ch.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
ch.setFormatter(formatter)
logger.addHandler(ch)

# Create the harvester, don't cleanup downloaded camera xml files
h = Harvester(logger=logger, do_clean_up=False)
# the harvester can load dlls as well as cti files.
if "add_file" in dir(h): # Use updated harvesters api if exists
	h.add_file('c:\\Program Files\\Critical Link LLC\\GenTL Viewer\\bin\\GenTL.dll')
else:
	h.add_cti_file('c:\\Program Files\\Critical Link LLC\\GenTL Viewer\\bin\\GenTL.dll')
if "update" in dir(h): # Use updated harvesters api if exists
	h.update()
else:
	h.update_device_info_list()

print("Found {} devices".format(len(h.device_info_list)))
print(h.device_info_list)

if len(h.device_info_list) == 0:
	print("No devices found")
	exit()

index = 0
if len(h.device_info_list) > 1:
	num = None
	while num is None:
		print("More than 1 camera detected,")
		# Print camera name with index
		for idx, dev in enumerate(h.device_info_list):
			print(f"{idx}: {dev.model}")
		num = input("Enter index of camera:")
		try:
			num = int(num)
		except:
			num = None
	index = num

# create an image acquirer
if "create" in dir(h): # Use updated harvesters api if exists
	ia = h.create(index)
else:
	ia = h.create_image_acquirer(list_index=index)
# this is required for larger images (> 16 MiB) with Critical Link's producer.
ia.num_buffers = 5
# Leave default PixelFormat for now
#ia.remote_device.node_map.PixelFormat.value = 'Mono8'
# Uncomment to set the image ROI width, height. Otherwise will get full frame
#ia.remote_device.node_map.Width.value, ia.remote_device.node_map.Height.value = 800, 600

print("Starting Acquistion")

if "start" in dir(ia): # Use updated harvesters api if exists
	ia.start()
else:
	ia.start_image_acquisition()

# just capture 1 frame
for i in range(1):
	if "fetch" in dir(ia): # Use updated harvesters api if exists
		fetch = ia.fetch
	else:
		fetch = ia.fetch_buffer
	with fetch(timeout=4) as buffer:
		payload = buffer.payload
		component = payload.components[0]
		width = component.width
		height = component.height
		data_format = component.data_format
		print("Image details: {}w {}h {}".format(width, height, data_format))
		# for monochrome 8 bit images
		if int(component.num_components_per_pixel) == 1:
			content = component.data.reshape(height, width)
		else:
			content = component.data.reshape(height, width, int(component.num_components_per_pixel))
		if int(component.num_components_per_pixel) == 1:
			plt.imshow(content, cmap='gray')
		else:
			plt.imshow(content)
		plt.show()

#
if "stop" in dir(ia): # Use updated harvesters api if exists
	ia.stop()
else:
	ia.stop_image_acquisition()

ia.destroy()
