#
# NOTE:  typical usage would be "vivado -mode tcl -source ./script/build_devkit_bitstream_batch.tcl"
# make sure you have your license file configuration setup.
#

# MDK source location
set mdk_dir "G:/projects/mityomapl138/hw/fpga"
set part "xc7a15tcsg324-2"
# -- "NONE" or "RAW" - route camera I/O hack to RAW Video input interface 
set camera_config "NONE" 
# -- "LCD", "DVI" or "NONE"  LCD IS NOT SUPPORTED
set disp_config "DVI"
# -- "SHARP" or "NEC"
set lcd_type "SHARP"

if { $::argc > 0 } {
  for {set i 0} {$i < $::argc} {incr i} {
    set option [string trim [lindex $::argv $i]]
    switch -regexp -- $option {
      "--part"         { incr i; set part [lindex $::argv $i] }
      "--mdk_dir"      { incr i; set mdk_dir [lindex $::argv $i] }
      "--origin_dir"   { incr i; set origin_dir [lindex $::argv $i] }
      "--project_name" { incr i; set _xil_proj_name_ [lindex $::argv $i] }
      "--help"         { print_help }
      default {
        if { [regexp {^-} $option] } {
          puts "ERROR: Unknown option '$option' specified, please type '$script_file -tclargs --help' for usage info.\n"
          return 1
        }
      }
    }
  }
}

if { [regexp {^xc7a15*} $part match] } {
    puts "Selected 15KLE part"
    set pext "_A715"
} else {
    puts "Selected 50KLE part"
    set pext "_A750"
}

# Define output directory area
set outputDir ./industrial_io_output
file mkdir $outputDir
#
set_part $part
#

set generic_tupels [list]
set generic_tupels [linsert $generic_tupels 0 "FPGA_FAMILY=Artix7"]
set generic_tupels [linsert $generic_tupels 0 "CAMERA_CONFIG=$camera_config"]
set generic_tupels [linsert $generic_tupels 0 "DISP_CONFIG=$disp_config"]
set generic_tupels [linsert $generic_tupels 0 "LCD_TYPE=$lcd_type"]

# setup design sources and constraints
read_vhdl ../vhdl/IndustrialIO_top.vhd
read_vhdl "${mdk_dir}/vhdl/MityDSP_L138_pkg.vhd"
read_vhdl "${mdk_dir}/vhdl/EMIFA_iface.vhd"
read_vhdl "${mdk_dir}/vhdl/base_module.vhd"
read_vhdl "${mdk_dir}/vhdl/core_version.vhd"
read_vhdl "${mdk_dir}/vhdl/gpio.vhd"
read_xdc ../vhdl/MityDSP_L138.xdc
#
set obj [get_filesets sources_1]
set_property generic $generic_tupels -objects $obj
#
# run synthesis
synth_design -top IndustrialIO_top
write_checkpoint -force $outputDir/post_synth
report_timing_summary -file $outputDir/post_synth_timing_summary.rpt
report_power -file $outputDir/post_synth_power.rpt
#
#
# run placement and logic optimization
opt_design
place_design
phys_opt_design
write_checkpoint -force $outputDir/post_place
report_timing_summary -file $outputDir/post_place_timing_summary.rpt
#
#
# run router
route_design
write_checkpoint -force $outputDir/post_route
report_timing_summary -file $outputDir/post_route_timing_summary.rpt
report_timing -sort_by group -max_paths 100 -path_type summary -file $outputDir/post_route_timing.rpt
report_clock_utilization -file $outputDir/clock_util.rpt
report_utilization -file $outputDir/post_route_util.rpt
report_power -file $outputDir/post_route_power.rpt
report_drc -file $outputDir/post_imp_drc.rpt
#write_verilog -force $outputDir/bft_impl_netlist.v
#write_xdc -no_fixed_only -force $outputDir/bft_impl.xdc
write_xdc $outputDir/post_route_impl.xdc -mode port -force
#
#
# Generate bitstream and binary file
write_bitstream -force -bin_file $outputDir/test_fixture$pext.bit
# Generate file for use with uBoot
# TODO unclear if -disablebitswap is required
write_cfgmem -force -format BIN -size 4 -interface SMAPx8 -loadbit "up 0 $outputDir/test_fixture$pext.bit" -verbose $outputDir/test_fixture$pext.bin
#write_cfgmem -force -format BIN -size 4 -interface SMAPx8 -loadbit "up 0 devkit_top.bit" -verbose fpga_7a15t.bin
exit
