--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   15:21:53 09/05/2010
-- Design Name:   
-- Module Name:   /home/mikew/projects/mityomapl138/hw/fpga/cores/SPI/sim/spi_tb.vhd
-- Project Name:  SPI
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: spi
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
use ieee.std_logic_arith.all;
use IEEE.STD_LOGIC_TEXTIO.ALL;
use std.textio.all;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--USE ieee.numeric_std.ALL;
 
ENTITY spi_tb IS
END spi_tb;
 
ARCHITECTURE behavior OF spi_tb IS 

component fifo_dpram64x32
	port (
	clk: IN std_logic;
	rst: IN std_logic;
	din: IN std_logic_VECTOR(31 downto 0);
	wr_en: IN std_logic;
	rd_en: IN std_logic;
	dout: OUT std_logic_VECTOR(31 downto 0);
	full: OUT std_logic;
	empty: OUT std_logic;
	data_count: OUT std_logic_VECTOR(5 downto 0));
end component; 

--Inputs
signal emif_clk : std_logic := '0';
signal i_ABus : std_logic_vector(5 downto 0) := (others => '0');
signal i_DBus : std_logic_vector(15 downto 0) := (others => '0');
signal i_wr_en : std_logic := '0';
signal i_rd_en : std_logic := '0';
signal i_cs : std_logic := '0';
signal i_ilevel : std_logic_vector(1 downto 0) := (others => '0');
signal i_ivector : std_logic_vector(3 downto 0) := (others => '0');
signal i_clk : std_logic := '0';
signal i_miso : std_logic := '0';
signal i_fifo_depth : std_logic_vector(2 downto 0) := "010";
signal mosi_fifo_out : std_logic_vector(31 downto 0) := (others => '0');
signal mosi_write_cnt : std_logic_vector(11 downto 0) := (others => '0');
signal mosi_empty : std_logic := '0';
signal miso_fifo_out : std_logic_vector(31 downto 0) := (others => '0');
signal miso_read_cnt : std_logic_vector(11 downto 0) := (others => '0');
signal miso_empty : std_logic := '0';

--Outputs
signal o_DBus : std_logic_vector(15 downto 0);
signal o_irq : std_logic;
signal o_sclk : std_logic;
signal o_cs_n : std_logic_vector(7 downto 0);
signal o_mosi : std_logic;

signal mosi_fifo_wr : std_logic;
signal mosi_fifo_rd : std_logic;
signal mosi_fifo_in : std_logic_vector(31 downto 0);
signal miso_fifo_wr : std_logic;
signal miso_fifo_rd : std_logic;
signal miso_fifo_in : std_logic_vector(31 downto 0);

-- Clock period definitions
constant emif_clk_period : time := 10 ns;
procedure do_write(offset   : in integer := 0; 
                   value    : in std_logic_vector(15 downto 0);
						 signal i_ABus   : out std_logic_vector(5 downto 0);
						 signal i_DBus   : out std_logic_vector(15 downto 0);
						 signal i_cs     : out std_logic;
						 signal i_wr_en  : out std_logic) is
begin
    wait until RISING_EDGE(emif_clk);
	 i_ABus <= conv_std_logic_vector(offset, 6);
    i_DBus <= value;
	 i_cs   <= '1';
    wait until rising_edge(emif_clk);
    i_wr_en <= '1';
    wait until rising_edge(emif_clk);
    i_wr_en <= '0';
	 wait until rising_edge(emif_clk);
	 wait until rising_edge(emif_clk);
	 i_cs <= '0';
end procedure do_write;

procedure do_read(offset   : in integer := 0; 
						signal i_ABus   : out std_logic_vector(5 downto 0);
						signal i_DBus   : out std_logic_vector(15 downto 0);
						signal i_cs     : out std_logic;
  					   signal i_rd_en  : out std_logic) is
begin
    wait until RISING_EDGE(emif_clk);
	 i_ABus <= conv_std_logic_vector(offset, 6);
	 i_cs   <= '1';
    wait until rising_edge(emif_clk);
    wait until rising_edge(emif_clk);
    wait until rising_edge(emif_clk);
    wait until rising_edge(emif_clk);
    i_rd_en <= '1';
    wait until rising_edge(emif_clk);
    i_rd_en <= '0';
	 wait until rising_edge(emif_clk);
	 i_cs <= '0';
end procedure do_read;

procedure do_delay(counts : in integer := 1) is
    variable cnt : integer := 0;
begin
    loop
	     exit when cnt >= counts;
		  cnt := cnt + 1;
	     wait until rising_edge(emif_clk);
	 end loop;
end procedure do_delay;

BEGIN

-- Instantiate the Unit Under Test (UUT)
uut: entity work.spi PORT MAP (
		 emif_clk => emif_clk,
		 i_ABus => i_ABus,
		 i_DBus => i_DBus,
		 o_DBus => o_DBus,
		 i_wr_en => i_wr_en,
		 i_rd_en => i_rd_en,
		 i_cs => i_cs,
		 o_irq => o_irq,
		 i_ilevel => i_ilevel,
		 i_ivector => i_ivector,
		 o_sclk => o_sclk,
		 o_cs_n => o_cs_n,
		 o_mosi => o_mosi,
		 i_miso => i_miso,
		 i_fifo_depth => i_fifo_depth,
		 o_mosi_fifo_wr => mosi_fifo_wr,
		 o_mosi_fifo_rd => mosi_fifo_rd,
		 o_mosi_fifo_in => mosi_fifo_in,
		 i_mosi_fifo_out => mosi_fifo_out,
		 i_mosi_write_cnt => mosi_write_cnt,
		 i_mosi_empty => mosi_empty,
		 o_miso_fifo_wr => miso_fifo_wr,
		 o_miso_fifo_rd => miso_fifo_rd,
		 o_miso_fifo_in => miso_fifo_in,
		 i_miso_fifo_out => miso_fifo_out,
		 i_miso_read_cnt => miso_read_cnt,
		 i_miso_empty => miso_empty
	  );
	  
mosi_fifo : fifo_dpram64x32
		port map (
			clk => emif_clk,
			rst => '0',
			din => mosi_fifo_in,
			wr_en => mosi_fifo_wr,
			rd_en => mosi_fifo_rd,
			dout => mosi_fifo_out,
			full => open,
			empty => mosi_empty,
			data_count => mosi_write_cnt(5 downto 0));	

miso_fifo : fifo_dpram64x32
		port map (
			clk => emif_clk,
			rst => '0',
			din => miso_fifo_in,
			wr_en => miso_fifo_wr,
			rd_en => miso_fifo_rd,
			dout => miso_fifo_out,
			full => open,
			empty => miso_empty,
			data_count => miso_read_cnt(5 downto 0));	

-- Clock process definitions
emif_clk_process :process
begin
	emif_clk <= '0';
	wait for emif_clk_period/2;
	emif_clk <= '1';
	wait for emif_clk_period/2;
end process;

-- Stimulus process
stim_proc: process
    file vector_file : text;
	 variable file_line : line;
    variable read_ok  : boolean;
	 variable cmd      : character;
	 variable offset   : integer;
	 variable value    : std_logic_vector(15 downto 0);
begin		
   file_open(vector_file,"test_vector.txt", READ_MODE);
	wait for 1 us;
	while not endfile(vector_file) loop
	   readline(vector_file, file_line);
		next when file_line'length=0;
		
		read(file_line,cmd,read_ok);
		
		-- if a read
		if cmd='R' or cmd='r' then
		   read(file_line, offset, read_ok);
   		do_read(offset, i_ABus, i_DBus, i_cs, i_rd_en);
		-- else if a write
		elsif cmd='W' or cmd='w' then
		   read(file_line, offset, read_ok);
			hread(file_line, value, read_ok);
   		do_write(offset, value, i_ABus, i_DBus, i_cs, i_wr_en);
		-- delay N clocks
		elsif cmd='D' or cmd='d' then
		   read(file_line, offset, read_ok);
			do_delay(offset);
		end if;
	end loop;
	file_close(vector_file);
	wait;
end process;

END;
