/**
 * \file fbfill.cpp
 * very simple VGA frame buffer pattern fill
 * to compile:
 * /usr/local/angstrom/arm/bin/arm-angstrom-linux-gnueabi-g++ -o fbfill fbfill.cpp
 *
 * 2010 (c) Critical Link LLC. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


int main(int argc, char** argv)
{

    int w = 640;
    int h = 480;
    int s = h/(8 *sizeof(unsigned short));
    unsigned short bitlane = 0;
    const char* devname = "/dev/fb";

    for(int aa = 1; aa < argc -1; ++aa)
    {
    	if(0 == strncmp(argv[aa],"-w",2) && argc > (aa+1))
  		{
  			w=atoi(argv[aa+1]);
  			++aa;
  		}
  		if(0 == strncmp(argv[aa],"-h",2) && argc > (aa+1))
  		{
  			h=atoi(argv[aa+1]);
  			++aa;
  		}
    }
    	
    printf("Framebuffer w = %d h = %d\n", w,h);
    	
    FILE* fp = NULL;
    // un-blank the display
    fp = fopen("/sys/devices/platform/da8xx_lcdc.0/graphics/fb0/blank", "w");
    if(fp)
    {
        fwrite("1\n",2,1,fp);
        fclose(fp);
    }

    printf("opening %s\n",devname);
    fp = fopen(devname,"w");
    if (!fp)
    {
        perror(devname);
        return(2);
    }
    unsigned short* pdata = new unsigned short[w];
    for (int xx = 0; xx < (w); ++xx)
    {
        pdata[xx] = 0xFFFF;
    }
    fwrite(pdata,2,w,fp);
    for (int yy = 1; yy < (h-1); ++yy)
    {
        pdata[0] = 0xFFFF;
        for (int xx = 1; xx < (w-1); ++xx)
        {
            pdata[xx] = 1 << bitlane;
        }
        pdata[w-1] = 0xFFFF;
        fwrite(pdata,2,w,fp);
        if (yy && (yy%s == 0))
            ++bitlane;
    }
    for (int xx = 0; xx < (w); ++xx)
    {
        pdata[xx] = 0xFFFF;
    }
    fwrite(pdata,2,w,fp);
    delete [] pdata;
    return 0;
}
