/**
 * \file  hw_control_C6A811x.h
 *
 * \brief Hardware registers and fields for CONTROL module
 */

/*
* Copyright (C) 2012 Texas Instruments Incorporated - http://www.ti.com/
*
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


#ifndef _HW_CONTROL_H_
#define _HW_CONTROL_H_

#ifdef __cplusplus
extern "C" {
#endif

/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define CONTROL_REVISION                        (0x0)
#define CONTROL_HWINFO                          (0x4)
#define CONTROL_SYSCONFIG                       (0x10)
#define CONTROL_STATUS                          (0x40)
#define CONTROL_BOOTSTAT                        (0x44)
#define CONTROL_DSPBOOTADDR                     (0x48)
#define CONTROL_SEC_CTRL                        (0x100)
#define CONTROL_SEC_SW                          (0x104)
#define CONTROL_SEC_EMU                         (0x108)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG        (0x110)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2      (0x114)
#define CONTROL_SW_CFG                          (0x118)
#define CONTROL_SW_CCFG                         (0x11c)
#define CONTROL_MPK(n)                          (0x120 + (n * 4))
#define CONTROL_SWRV(n)                         (0x140 + (n * 4))
#define CONTROL_SEC_TAP                         (0x180)
#define CONTROL_SEC_TAP_CMDIN                   (0x184)
#define CONTROL_SEC_TAP_CMDOUT                  (0x188)
#define CONTROL_SEC_TAP_DATIN                   (0x18c)
#define CONTROL_SEC_TAP_DATOUT                  (0x190)
#define CONTROL_MREQDOMAIN_EXP1                 (0x198)
#define CONTROL_MREQDOMAIN_EXP2                 (0x19c)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0          (0x1a0)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1          (0x1a4)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF           (0x1a8)
#define CONTROL_SEC_LOAD_FW_EXP_VAL             (0x1ac)
#define CONTROL_SEC_CTRL_RO                     (0x1b4)
#define CONTROL_EMIF_OBFUSCATION_KEY            (0x1b8)
#define CONTROL_SEC_CLK_CTRL                    (0x1bc)
#define CONTROL_MREQDOMAIN_EXP3                 (0x1d4)
#define CONTROL_CEK(n)                          (0x200 + (n * 4))
#define CONTROL_CEK_BCH(n)                      (0x210 + (n * 4))
#define CONTROL_MSV_0                           (0x224)
#define CONTROL_MSV_BCH(n)                      (0x228 + (n * 4))
#define CONTROL_SEC_STATUS                      (0x240)
#define CONTROL_SECMEM_STATUS                   (0x244)
#define CONTROL_SEC_ERR_STAT_FUNC(n)            (0x248 + (n * 4))
#define CONTROL_SEC_ERR_STAT_DBUG(n)            (0x250 + (n * 4))
#define CONTROL_KEK_SW(n)                       (0x260 + (n * 4))
#define CONTROL_CMPK_BCH(n)                     (0x280 + (n * 4))
#define CONTROL_CMPK(n)                         (0x2b0 + (n * 4))
#define CONTROL_DUCATI_CLKSRC                   (0x2f8)
#define CONTROL_DSS_CLKSRC                      (0x2fc)
#define CONTROL_SSM_END_FAST_SECRAM             (0x300)
#define CONTROL_SSM_FIREWALL_CONTROLLER         (0x304)
#define CONTROL_SSM_START_SECURE_STACKED_RAM    (0x308)
#define CONTROL_SSM_END_SECURE_STACKED_RAM      (0x30c)
#define CONTROL_SSM_START_SPM_STACK             (0x310)
#define CONTROL_SSM_END_SPM_STACK               (0x314)
#define CONTROL_SSM_START_MONITOR_RAMCODE       (0x318)
#define CONTROL_SSM_END_MONITOR_RAMCODE         (0x31c)
#define CONTROL_SSM_END_MONITOR_RAMDATA         (0x320)
#define CONTROL_SSM_START_MONITOR_CODE          (0x324)
#define CONTROL_SSM_END_MONITOR_CODE            (0x328)
#define CONTROL_SSM_START_MONITOR_PERIPH        (0x32c)
#define CONTROL_SSM_END_MONITOR_PERIPH          (0x330)
#define CONTROL_SSM_START_MONITOR_STACK         (0x334)
#define CONTROL_SSM_END_MONITOR_STACK           (0x338)
#define CONTROL_SSM_START_MONITOR_RAMCODE_ETM   (0x33c)
#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM     (0x340)
#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM     (0x344)
#define CONTROL_SSM_START_MONITOR_CODE_ETM      (0x348)
#define CONTROL_SSM_END_MONITOR_CODE_ETM        (0x34c)
#define CONTROL_SSM_START_MONITOR_STACK_ETM     (0x350)
#define CONTROL_SSM_END_MONITOR_STACK_ETM       (0x354)
#define CONTROL_SSM_START_MONITOR_SHARED_ETM    (0x358)
#define CONTROL_SSM_END_MONITOR_SHARED_ETM      (0x35c)
#define CONTROL_SSM_START_MONITOR_PERIPH_ETM    (0x360)
#define CONTROL_SSM_END_MONITOR_PERIPH_ETM      (0x364)
#define CONTROL_SSM_CPSR_MODE_ENFC              (0x368)
#define CONTROL_SSM_END_L3_SECRAM               (0x36c)
#define CONTROL_SGX_VBBLDO_CTRL                 (0x408)
#define CONTROL_GEM_VBBLDO_CTRL                 (0x418)
#define CONTROL_CORTEX_VBBLDO_CTRL              (0x41c)
#define CONTROL_RAMLDO_CTRL(n)                  (0x428 + (n * 4))
#define CONTROL_REFCLK_LJCBLDO_CTRL             (0x440)
#define CONTROL_BANDGAP_CTRL(n)                 (0x448 + (n * 8))
#define CONTROL_BANDGAP_TRIM(n)                 (0x44c + (n * 8))
#define CONTROL_OSC_CTRL(n)                     (0x468 + (n * 4))
#define CONTROL_PCIE_CFG                        (0x480)
#define CONTROL_PE_SCRATCHPAD(n)                (0x500 + (n * 4))
#define CONTROL_DEVICE_ID                       (0x600)
#define CONTROL_INIT_PRIORITY(n)                (0x608 + (n * 4))
#define CONTROL_MMU_CFG                         (0x610)
#define CONTROL_TPTC_CFG                        (0x614)
#define CONTROL_DSP_IDLE_CFG                    (0x61c)
#define CONTROL_USB_CTRL(n)                     (0x620 + (n * 8))
#define CONTROL_USB_STS(n)                      (0x624 + (n * 8))
#define CONTROL_MAC_ID_LO(n)                    (0x630 + (n * 8))
#define CONTROL_MAC_ID_HI(n)                    (0x634 + (n * 8))
#define CONTROL_SW_REVISION                     (0x640)
#define CONTROL_DCAN_RAMINIT                    (0x644)
#define CONTROL_AUD_CTRL                        (0x64c)
#define CONTROL_GMII_SEL                        (0x650)
#define CONTROL_OCMEM_PWRDN                     (0x654)
#define CONTROL_DUCATIMEM_PWRDN                 (0x65c)
#define CONTROL_PWMSS_CTRL                      (0x664)
#define CONTROL_SD_DAC_CTRL                     (0x670)
#define CONTROL_SD_DAC_CAL(n)                   (0x674 + (n * 4))
#define CONTROL_SD_DAC_REGCTRL(n)               (0x67c + (n * 8))
#define CONTROL_SD_DAC_REGSTATUS(n)             (0x680 + (n * 8))
#define CONTROL_EMIF_CLK_GATE                   (0x694)
#define CONTROL_SMRT_CTRL                       (0x6a0)
#define CONTROL_MODENA_HW_DEBUG_SEL             (0x6a4)
#define CONTROL_MODENA_HW_DBG_INFO              (0x6a8)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT        (0x6b0)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS     (0x6b4)
#define CONTROL_PCIE_PLLCFG(n)                  (0x6d8 + (n * 4))
#define CONTROL_PCIE_PLLSTATUS                  (0x6ec)
#define CONTROL_PCIE_RXSTATUS                   (0x6f0)
#define CONTROL_PCIE_TXSTATUS                   (0x6f4)
#define CONTROL_PCIE_TESTCFG                    (0x6f8)
#define CONTROL_PCIE_MISCCFG                    (0x6fc)
#define CONTROL_VDD_MPU_OPP_050                 (0x770)
#define CONTROL_VDD_MPU_OPP_100                 (0x774)
#define CONTROL_VDD_MPU_OPP_119                 (0x778)
#define CONTROL_VDD_MPU_OPP_TURBO               (0x77c)
#define CONTROL_VDD_CORE_GEM_OPP_050            (0x7b8)
#define CONTROL_VDD_CORE_GEM_OPP_100            (0x7bc)
#define CONTROL_VDD_CORE_GEM_OPP_119            (0x7c0)
#define CONTROL_VDD_CORE_GEM_OPP_TURBO          (0x7c4)
#define CONTROL_BB_SCALE                        (0x7d0)
#define CONTROL_USB_VID_PID                     (0x7f4)
#define CONTROL_PCIE_VID_PID                    (0x7f8)
#define CONTROL_EFUSE_SMA                       (0x7fc)
#define CONTROL_PINCTRL(n)                      (0x7fc + n * 4)
#define CONTROL_CQDETECT_STATUS                 (0xe00)
#define CONTROL_DDR_IO_CTRL                     (0xe04)
#define CONTROL_VTP_CTRL                        (0xe0c)
#define CONTROL_VREF_CTRL                       (0xe14)
#define CONTROL_MLBP_SIG_IO_CTRL                (0xe18)
#define CONTROL_MLBP_DAT_IO_CTRL                (0xe1c)
#define CONTROL_MLBP_CLK_BG_CTRL                (0xe20)
#define CONTROL_SERDES_REFCLK_CTL               (0xe24)
#define CONTROL_DSP_INT_MUX(n)                  (0xf00 + (n * 4))
#define CONTROL_DUCATI_INT_MUX(n)               (0xf54 + (n * 4))
#define CONTROL_TPCC_EVT_MUX(n)                 (0xf90 + (n * 4))
#define CONTROL_TIMER_EVT_CAPT                  (0xfd0)
#define CONTROL_GPIO_MUX                        (0xfd4)
#define CONTROL_ADC_EVT_CAPT                    (0xfd8)
#define CONTROL_ECAP_EVT_CAPT                   (0xfdc)
#define CONTROL_RESET_ISO                       (0x1000)
#define CONTROL_DAC_TRIM(n)                     (0x1310 + (n * 4))
#define CONTROL_SMA(n)                          (0x1318 + (n * 4))
#define CONTROL_RTC_IDLE                        (0x1348)
#define CONTROL_ARM_INT_MUX(n)                  (0x1600 + (n * 4))
#define CONTROL_INITIATOR_PRIO(n)               (0x16c0 + (n * 4))
#define CONTROL_DMAOBS                          (0x16f0)
#define CONTROL_INTOBS                          (0x16f4)
#define CONTROL_DTC_CTRL(n)                     (0x1700 + (n * 4))
#define CONTROL_DTC0_LOAD(n)                    (0x1708 + (n * 4))
#define CONTROL_DTC1_LOAD(n)                    (0x1718 + (n * 4))
#define CONTROL_ICSS_INT_MUX(n)                 (0x1750 + (n * 4))
#define CONTROL_CHIP_HW_DBG_SEL                 (0x1780)


/**************************************************************************\ 
 * Field Definition Macros
\**************************************************************************/

/** @brief CONTROL_REVISION register fields */
#define CONTROL_REVISION_IP_REV_CUSTOM              (0x000000C0u)
#define CONTROL_REVISION_IP_REV_CUSTOM_SHIFT        (0x00000006u)

#define CONTROL_REVISION_IP_REV_FUNC                (0x0FFF0000u)
#define CONTROL_REVISION_IP_REV_FUNC_SHIFT          (0x00000010u)

#define CONTROL_REVISION_IP_REV_MAJOR               (0x00000700u)
#define CONTROL_REVISION_IP_REV_MAJOR_SHIFT         (0x00000008u)

#define CONTROL_REVISION_IP_REV_MINOR               (0x0000003Fu)
#define CONTROL_REVISION_IP_REV_MINOR_SHIFT         (0x00000000u)

#define CONTROL_REVISION_IP_REV_RTL                 (0x0000F800u)
#define CONTROL_REVISION_IP_REV_RTL_SHIFT           (0x0000000Bu)

#define CONTROL_REVISION_IP_REV_SCHEME              (0xC0000000u)
#define CONTROL_REVISION_IP_REV_SCHEME_SHIFT        (0x0000001Eu)

/** @brief CONTROL_HWINFO register fields */
#define CONTROL_HWINFO_IP_HWINFO                    (0xFFFFFFFFu)
#define CONTROL_HWINFO_IP_HWINFO_SHIFT              (0x00000000u)

/** @brief CONTROL_SYSCONFIG register fields */
#define CONTROL_SYSCONFIG_FREEEMU                   (0x00000002u)
#define CONTROL_SYSCONFIG_FREEEMU_SHIFT             (0x00000001u)

#define CONTROL_SYSCONFIG_IDLEMODE                  (0x0000000Cu)
#define CONTROL_SYSCONFIG_IDLEMODE_SHIFT            (0x00000002u)

#define CONTROL_SYSCONFIG_STANDBY                   (0x00000030u)
#define CONTROL_SYSCONFIG_STANDBY_SHIFT             (0x00000004u)

/** @brief CONTROL_STATUS register fields */
#define CONTROL_STATUS_ADMUX                        (0x000C0000u)
#define CONTROL_STATUS_ADMUX_SHIFT                  (0x00000012u)

#define CONTROL_STATUS_BW                           (0x00010000u)
#define CONTROL_STATUS_BW_SHIFT                     (0x00000010u)

#define CONTROL_STATUS_DEVTYPE                      (0x00000700u)
#define CONTROL_STATUS_DEVTYPE_SHIFT                (0x00000008u)

#define CONTROL_STATUS_SYSBOOT0                     (0x000000FFu)
#define CONTROL_STATUS_SYSBOOT0_SHIFT               (0x00000000u)

#define CONTROL_STATUS_SYSBOOT1                     (0x00C00000u)
#define CONTROL_STATUS_SYSBOOT1_SHIFT               (0x00000016u)

#define CONTROL_STATUS_TESTMD                       (0x00300000u)
#define CONTROL_STATUS_TESTMD_SHIFT                 (0x00000014u)

#define CONTROL_STATUS_WAITEN                       (0x00020000u)
#define CONTROL_STATUS_WAITEN_SHIFT                 (0x00000011u)

/** @brief BOOTSTAT register fields */
#define CONTROL_BOOTSTAT_BC                         (0x00000001u)
#define CONTROL_BOOTSTAT_BC_SHIFT                   (0x00000000u)

#define CONTROL_BOOTSTAT_BOOTERR                    (0x000F0000u)
#define CONTROL_BOOTSTAT_BOOTERR_SHIFT              (0x00000010u)

/** @brief CONTROL_DSPBOOTADDR register fields */
#define CONTROL_DSPBOOTADDR_BOOTADDR                (0xFFFFFC00u)
#define CONTROL_DSPBOOTADDR_BOOTADDR_SHIFT          (0xAu)

#define CONTROL_DSPBOOTADDR_RSTDONE                 (0x00000001u)
#define CONTROL_DSPBOOTADDR_RSTDONE_SHIFT           (0x0u)

/** @brief CONTROL_SEC_CTRL register fields */
#define CONTROL_SEC_CTRL_BSCENABLE                  (0x00000200u)
#define CONTROL_SEC_CTRL_BSCENABLE_SHIFT            (0x00000009u)

#define CONTROL_SEC_CTRL_CATSCANEN                  (0x00000100u)
#define CONTROL_SEC_CTRL_CATSCANEN_SHIFT            (0x00000008u)

#define CONTROL_SEC_CTRL_CMPKEFUSENOTDEC            (0x00002000u)
#define CONTROL_SEC_CTRL_CMPKEFUSENOTDEC_SHIFT      (0x0000000Du)

#define CONTROL_SEC_CTRL_CPEFUSELDDONE              (0x00000400u)
#define CONTROL_SEC_CTRL_CPEFUSELDDONE_SHIFT        (0x0000000Au)

#define CONTROL_SEC_CTRL_CPEFUSENOTDEC              (0x00001000u)
#define CONTROL_SEC_CTRL_CPEFUSENOTDEC_SHIFT        (0x0000000Cu)

#define CONTROL_SEC_CTRL_CPEFUSEWRDIS               (0x00000800u)
#define CONTROL_SEC_CTRL_CPEFUSEWRDIS_SHIFT         (0x0000000Bu)

#define CONTROL_SEC_CTRL_DMLEDCOREEN                (0x00000080u)
#define CONTROL_SEC_CTRL_DMLEDCOREEN_SHIFT          (0x00000007u)

#define CONTROL_SEC_CTRL_FASTOCMSECSAVE             (0x30000000u)
#define CONTROL_SEC_CTRL_FASTOCMSECSAVE_SHIFT       (0x0000001Cu)

#define CONTROL_SEC_CTRL_KEKSWENABLE0               (0x00000004u)
#define CONTROL_SEC_CTRL_KEKSWENABLE0_SHIFT         (0x00000002u)

#define CONTROL_SEC_CTRL_KEKSWENABLE1               (0x00000010u)
#define CONTROL_SEC_CTRL_KEKSWENABLE1_SHIFT         (0x00000004u)

#define CONTROL_SEC_CTRL_L3OCMSECSAVE               (0x0C000000u)
#define CONTROL_SEC_CTRL_L3OCMSECSAVE_SHIFT         (0x0000001Au)

#define CONTROL_SEC_CTRL_SECCTRLWRDISABLE           (0x80000000u)
#define CONTROL_SEC_CTRL_SECCTRLWRDISABLE_SHIFT     (0x0000001Fu)

#define CONTROL_SEC_CTRL_SECUREMODEINITDONE         (0x40000000u)
#define CONTROL_SEC_CTRL_SECUREMODEINITDONE_SHIFT   (0x0000001Eu)

#define CONTROL_SEC_CTRL_WDOPDISABLE                (0x00000001u)
#define CONTROL_SEC_CTRL_WDOPDISABLE_SHIFT          (0x00000000u)

#define CONTROL_SEC_CTRL_WDREGENABLE                (0x00000002u)
#define CONTROL_SEC_CTRL_WDREGENABLE_SHIFT          (0x00000001u)

/** @brief CONTROL_SEC_SW register fields */
#define CONTROL_SEC_SW_SW_HW_PARAMETERS             (0xFFFFFFFFu)
#define CONTROL_SEC_SW_SW_HW_PARAMETERS_SHIFT       (0x00000000u)

/** @brief CONTROL_SEC_EMU register fields */
#define CONTROL_SEC_EMU_ETMSECPRIVDBGEN             (0x00001000u)
#define CONTROL_SEC_EMU_ETMSECPRIVDBGEN_SHIFT       (0x0000000Cu)

#define CONTROL_SEC_EMU_GENDBGEN                    (0x00000FFFu)
#define CONTROL_SEC_EMU_GENDBGEN_SHIFT              (0x00000000u)

#define CONTROL_SEC_EMU_GENDBGEN_M3                 (0x0000C000u)
#define CONTROL_SEC_EMU_GENDBGEN_M3_SHIFT           (0x0000000Eu)

#define CONTROL_SEC_EMU_ICESECPRIVDBGEN             (0x00002000u)
#define CONTROL_SEC_EMU_ICESECPRIVDBGEN_SHIFT       (0x0000000Du)

#define CONTROL_SEC_EMU_SECEMUWRDIS                 (0x80000000u)
#define CONTROL_SEC_EMU_SECEMUWRDIS_SHIFT           (0x0000001Fu)

/** @brief SECURE_EMIF_SDRAM_CONFIG register fields */
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_CL         (0x00003C00u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_CL_SHIFT   (0x0000000Au)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_CWL        (0x00030000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_CWL_SHIFT  (0x00000010u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_DDR_TERM   (0x07000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_DDR_TERM_SHIFT (0x00000018u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_DYN_ODT    (0x00600000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_DYN_ODT_SHIFT  (0x00000015u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_EBANK      (0x00000008u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_EBANK_SHIFT    (0x00000003u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_IBANK      (0x00000070u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_IBANK_SHIFT    (0x00000004u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_IBANK_POS  (0x18000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_IBANK_POS_SHIFT    (0x0000001Bu)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_NARROW_MODE    (0x0000C000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_NARROW_MODE_SHIFT  (0x0000000Eu)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_PAGESIZE   (0x00000007u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_PAGESIZE_SHIFT (0x00000000u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_ROWSIZE    (0x00000380u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_ROWSIZE_SHIFT  (0x00000007u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_SDRAM_DRIVE    (0x000C0000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_SDRAM_DRIVE_SHIFT  (0x00000012u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_SDRAM_TYPE (0xE0000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_SDRAM_TYPE_SHIFT   (0x0000001Du)

/** @brief SECURE_EMIF_SDRAM_CONFIG_2 register fields */
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_CS1_NVMEN    (0x40000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_CS1_NVMEN_SHIFT  (0x0000001Eu)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_EBANK_POS    (0x08000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_EBANK_POS_SHIFT  (0x0000001Bu)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RDBNUM   (0x00000030u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RDBNUM_SHIFT (0x00000004u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RDBSIZE  (0x00000007u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RDBSIZE_SHIFT    (0x00000000u)

/** @brief CONTROL_SW_CFG register fields */
#define CONTROL_SW_CFG_SW_CFG                       (0xFFFFFFFFu)
#define CONTROL_SW_CFG_SW_CFG_SHIFT                 (0x00000000u)

/** @brief CONTROL_SW_CCFG register fields */
#define CONTROL_SW_CCFG_SW_CCFG                     (0x0000FFFFu)
#define CONTROL_SW_CCFG_SW_CCFG_SHIFT               (0x00000000u)

#define CONTROL_SW_CCFG_SW_CCFG_RED                 (0xFFFF0000u)
#define CONTROL_SW_CCFG_SW_CCFG_RED_SHIFT           (0x00000010u)

/** @brief CONTROL_MPK(n) register fields */
#define CONTROL_MPK_MPK                             (0xFFFFFFFFu)
#define CONTROL_MPK_MPK_SHIFT                       (0x00000000u)

/** @brief CONTROL_SWRV(n) register fields */
#define CONTROL_SWRV_SWRV                           (0x0000FFFFu)
#define CONTROL_SWRV_SWRV_SHIFT                     (0x00000000u)

#define CONTROL_SWRV_SWRV_RED                       (0xFFFF0000u)
#define CONTROL_SWRV_SWRV_RED_SHIFT                 (0x00000010u)

/** @brief CONTROL_SEC_TAP register fields */
#define CONTROL_SEC_TAP_1500EN                      (0x00000008u)
#define CONTROL_SEC_TAP_1500EN_SHIFT                (0x00000003u)

#define CONTROL_SEC_TAP_DAPTAPEN                    (0x00000001u)
#define CONTROL_SEC_TAP_DAPTAPEN_SHIFT              (0x00000000u)

#define CONTROL_SEC_TAP_PART1500DIS                 (0x00000010u)
#define CONTROL_SEC_TAP_PART1500DIS_SHIFT           (0x00000004u)

#define CONTROL_SEC_TAP_SABERMPUTAPEN               (0x00000200u)
#define CONTROL_SEC_TAP_SABERMPUTAPEN_SHIFT         (0x00000009u)

#define CONTROL_SEC_TAP_SECTAPWRDISABLE             (0x80000000u)
#define CONTROL_SEC_TAP_SECTAPWRDISABLE_SHIFT       (0x0000001Fu)

#define CONTROL_SEC_TAP_WAKEUPTAPEN                 (0x00000004u)
#define CONTROL_SEC_TAP_WAKEUPTAPEN_SHIFT           (0x00000002u)

/** @brief CONTROL_SEC_TAP_CMDIN register fields */
#define CONTROL_SEC_TAP_CMDIN_CMDIN                 (0x000000FFu)
#define CONTROL_SEC_TAP_CMDIN_CMDIN_SHIFT           (0x00000000u)

/** @brief CONTROL_SEC_TAP_CMDOUT register fields */
#define CONTROL_SEC_TAP_CMDOUT_CMDOUT               (0x000000FFu)
#define CONTROL_SEC_TAP_CMDOUT_CMDOUT_SHIFT         (0x00000000u)

/** @brief CONTROL_SEC_TAP_DATIN register fields */
#define CONTROL_SEC_TAP_DATIN_DATAIN                (0x000000FFu)
#define CONTROL_SEC_TAP_DATIN_DATAIN_SHIFT          (0x00000000u)

/** @brief CONTROL_SEC_TAP_DATOUT register fields */
#define CONTROL_SEC_TAP_DATOUT_DATAOUT              (0x000000FFu)
#define CONTROL_SEC_TAP_DATOUT_DATAOUT_SHIFT        (0x00000000u)

/** @brief CONTROL_MREQDOMAIN_EXP1 register fields */
#define CONTROL_MREQDOMAIN_EXP1_2DBITBLT_DOM        (0x001C0000u)
#define CONTROL_MREQDOMAIN_EXP1_2DBITBLT_DOM_SHIFT  (0x00000012u)

#define CONTROL_MREQDOMAIN_EXP1_L3_EXP_DOM          (0x00000007u)
#define CONTROL_MREQDOMAIN_EXP1_L3_EXP_DOM_SHIFT    (0x00000000u)

#define CONTROL_MREQDOMAIN_EXP1_LCD_CTRL_DOM        (0x00038000u)
#define CONTROL_MREQDOMAIN_EXP1_LCD_CTRL_DOM_SHIFT  (0x0000000Fu)

#define CONTROL_MREQDOMAIN_EXP1_LCK                 (0x80000000u)
#define CONTROL_MREQDOMAIN_EXP1_LCK_SHIFT           (0x0000001Fu)

#define CONTROL_MREQDOMAIN_EXP1_MLB_DOM             (0x00007000u)
#define CONTROL_MREQDOMAIN_EXP1_MLB_DOM_SHIFT       (0x0000000Cu)

#define CONTROL_MREQDOMAIN_EXP1_SGX_DOM             (0x07000000u)
#define CONTROL_MREQDOMAIN_EXP1_SGX_DOM_SHIFT       (0x00000018u)

#define CONTROL_MREQDOMAIN_EXP1_WAKE_DOM            (0x00E00000u)
#define CONTROL_MREQDOMAIN_EXP1_WAKE_DOM_SHIFT      (0x00000015u)

/** @brief CONTROL_MREQDOMAIN_EXP2 register fields */
#define CONTROL_MREQDOMAIN_EXP2_GEMAC_DOM           (0x001C0000u)
#define CONTROL_MREQDOMAIN_EXP2_GEMAC_DOM_SHIFT     (0x00000012u)

#define CONTROL_MREQDOMAIN_EXP2_LCK                 (0x80000000u)
#define CONTROL_MREQDOMAIN_EXP2_LCK_SHIFT           (0x0000001Fu)

#define CONTROL_MREQDOMAIN_EXP2_P1500_DOM           (0x00038000u)
#define CONTROL_MREQDOMAIN_EXP2_P1500_DOM_SHIFT     (0x0000000Fu)

#define CONTROL_MREQDOMAIN_EXP2_USB0_DOM            (0x00000E00u)
#define CONTROL_MREQDOMAIN_EXP2_USB0_DOM_SHIFT      (0x00000009u)

#define CONTROL_MREQDOMAIN_EXP2_USB1_DOM            (0x00007000u)
#define CONTROL_MREQDOMAIN_EXP2_USB1_DOM_SHIFT      (0x0000000Cu)

/** @brief L3_HW_FW_EXP_VAL_CONF0 register fields */
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3EXP_SECDBG_EN  (0x00040000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3EXP_SECDBG_EN_SHIFT    (0x00000012u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3EXP_SECLOCK_EN (0x00000004u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3EXP_SECLOCK_EN_SHIFT   (0x00000002u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3RAM_SECDBG_EN  (0x01000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3RAM_SECDBG_EN_SHIFT    (0x00000018u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3RAM_SECLOCK_EN (0x00000100u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3RAM_SECLOCK_EN_SHIFT   (0x00000008u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_SGX_SECDBG_EN    (0x00800000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_SGX_SECDBG_EN_SHIFT  (0x00000017u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_SGX_SECLOCK_EN   (0x00000080u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_SGX_SECLOCK_EN_SHIFT (0x00000007u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPCC_SECDBG_EN   (0x00100000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPCC_SECDBG_EN_SHIFT (0x00000014u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPCC_SECLOCK_EN  (0x00000010u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPCC_SECLOCK_EN_SHIFT    (0x00000004u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPTC_SECDBG_EN   (0x00080000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPTC_SECDBG_EN_SHIFT (0x00000013u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPTC_SECLOCK_EN  (0x00000008u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPTC_SECLOCK_EN_SHIFT    (0x00000003u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_USB_SECDBG_EN    (0x04000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_USB_SECDBG_EN_SHIFT  (0x0000001Au)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_USB_SECLOCK_EN   (0x00000400u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_USB_SECLOCK_EN_SHIFT (0x0000000Au)

/** @brief L3_HW_FW_EXP_VAL_CONF1 register fields */
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_ADCTSC_SECDBG_EN (0x08000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_ADCTSC_SECDBG_EN_SHIFT   (0x0000001Bu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_ADCTSC_SECLOCK_EN    (0x00000800u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_ADCTSC_SECLOCK_EN_SHIFT  (0x0000000Bu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_AES0_SECDBG_EN   (0x10000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_AES0_SECDBG_EN_SHIFT (0x0000001Cu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_AES0_SECLOCK_EN  (0x00001000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_AES0_SECLOCK_EN_SHIFT    (0x0000000Cu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_DEBUG_SECDBG_EN  (0x02000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_DEBUG_SECDBG_EN_SHIFT    (0x00000019u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_DEBUG_SECLOCK_EN (0x00000200u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_DEBUG_SECLOCK_EN_SHIFT   (0x00000009u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_EMIF_SECDBG_EN   (0x01000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_EMIF_SECDBG_EN_SHIFT (0x00000018u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_EMIF_SECLOCK_EN  (0x00000100u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_EMIF_SECLOCK_EN_SHIFT    (0x00000008u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_GPMC_SECDBG_EN   (0x00080000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_GPMC_SECDBG_EN_SHIFT (0x00000013u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_GPMC_SECLOCK_EN  (0x00000008u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_GPMC_SECLOCK_EN_SHIFT    (0x00000003u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP0_SECDBG_EN (0x00100000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP0_SECDBG_EN_SHIFT   (0x00000014u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP0_SECLOCK_EN    (0x00000010u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP0_SECLOCK_EN_SHIFT  (0x00000004u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP1_SECDBG_EN (0x00200000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP1_SECDBG_EN_SHIFT   (0x00000015u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP1_SECLOCK_EN    (0x00000020u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP1_SECLOCK_EN_SHIFT  (0x00000005u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MMCHS2_SECDBG_EN (0x04000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MMCHS2_SECDBG_EN_SHIFT   (0x0000001Au)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MMCHS2_SECLOCK_EN    (0x00000400u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MMCHS2_SECLOCK_EN_SHIFT  (0x0000000Au)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_SHA_SECDBG_EN    (0x40000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_SHA_SECDBG_EN_SHIFT  (0x0000001Eu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_SHA_SECLOCK_EN   (0x00004000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_SHA_SECLOCK_EN_SHIFT (0x0000000Eu)

/** @brief L4_HW_FW_EXP_VAL_CONF register fields */
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FAST_AP_SECDBG_EN   (0x01000000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FAST_AP_SECDBG_EN_SHIFT (0x00000018u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FAST_AP_SECLOCK_EN  (0x00000100u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FAST_AP_SECLOCK_EN_SHIFT    (0x00000008u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_AP_SECDBG_EN (0x00100000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_AP_SECDBG_EN_SHIFT   (0x00000014u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_AP_SECLOCK_EN    (0x00000010u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_AP_SECLOCK_EN_SHIFT  (0x00000004u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_SEC_SECDBG_EN    (0x00200000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_SEC_SECDBG_EN_SHIFT  (0x00000015u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_SEC_SECLOCK_EN   (0x00000020u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_SEC_SECLOCK_EN_SHIFT (0x00000005u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_AP_SECDBG_EN    (0x00010000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_AP_SECDBG_EN_SHIFT  (0x00000010u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_AP_SECLOCK_EN   (0x00000001u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_AP_SECLOCK_EN_SHIFT (0x00000000u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_CRYPTO_SECDBG_EN    (0x00020000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_CRYPTO_SECDBG_EN_SHIFT  (0x00000011u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_CRYPTO_SECLOCK_EN   (0x00000002u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_CRYPTO_SECLOCK_EN_SHIFT (0x00000001u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_AP_SECDBG_EN   (0x10000000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_AP_SECDBG_EN_SHIFT (0x0000001Cu)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_AP_SECLOCK_EN  (0x00001000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_AP_SECLOCK_EN_SHIFT    (0x0000000Cu)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_SEC_SECDBG_EN  (0x20000000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_SEC_SECDBG_EN_SHIFT    (0x0000001Du)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_SEC_SECLOCK_EN (0x00002000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_SEC_SECLOCK_EN_SHIFT   (0x0000000Du)

/** @brief CONTROL_SEC_LOAD_FW_EXP_VAL register fields */
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4FAST_LD_EXPVAL_REQN   (0x00000010u)
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4FAST_LD_EXPVAL_REQN_SHIFT (0x00000004u)

#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4FW_LD_EXPVAL_REQN (0x00000004u)
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4FW_LD_EXPVAL_REQN_SHIFT   (0x00000002u)

#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4PER_LD_EXPVAL_REQN    (0x00000008u)
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4PER_LD_EXPVAL_REQN_SHIFT  (0x00000003u)

#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4WKUP_LD_EXPVAL_REQN   (0x00000020u)
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4WKUP_LD_EXPVAL_REQN_SHIFT (0x00000005u)

/** @brief CONTROL_SEC_CTRL_RO register fields */
#define CONTROL_SEC_CTRL_RO_CUSTMPK                 (0x00000010u)
#define CONTROL_SEC_CTRL_RO_CUSTMPK_SHIFT           (0x00000004u)

#define CONTROL_SEC_CTRL_RO_EMIF_CFG_RO_EN          (0x00000002u)
#define CONTROL_SEC_CTRL_RO_EMIF_CFG_RO_EN_SHIFT    (0x00000001u)

#define CONTROL_SEC_CTRL_RO_EMIF_OBFS_EN            (0x00000004u)
#define CONTROL_SEC_CTRL_RO_EMIF_OBFS_EN_SHIFT      (0x00000002u)

#define CONTROL_SEC_CTRL_RO_SECKEYACCEN             (0x00000008u)
#define CONTROL_SEC_CTRL_RO_SECKEYACCEN_SHIFT       (0x00000003u)

/** @brief EMIF_OBFUSCATION_KEY register fields */
#define CONTROL_EMIF_OBFUSCATION_KEY_OBFUSCATIONKEY (0x0000FFFFu)
#define CONTROL_EMIF_OBFUSCATION_KEY_OBFUSCATIONKEY_SHIFT   (0x00000000u)

/** @brief SEC_CLK_CTRL register fields */
#define CONTROL_SEC_CLK_CTRL_SECCLKLCK              (0x80000000u)
#define CONTROL_SEC_CLK_CTRL_SECCLKLCK_SHIFT        (0x0000001Fu)

#define CONTROL_SEC_CLK_CTRL_SECTIMERCLKSEL         (0x00000030u)
#define CONTROL_SEC_CLK_CTRL_SECTIMERCLKSEL_SHIFT   (0x00000004u)

#define CONTROL_SEC_CLK_CTRL_SECWDCLKSEL            (0x00000001u)
#define CONTROL_SEC_CLK_CTRL_SECWDCLKSEL_SHIFT      (0x00000000u)

/** @brief CONTROL_MREQDOMAIN_EXP3 register fields */
#define CONTROL_MREQDOMAIN_EXP3_LCK                 (0x80000000u)
#define CONTROL_MREQDOMAIN_EXP3_LCK_SHIFT           (0x0000001Fu)

#define CONTROL_MREQDOMAIN_EXP3_PRU0_DOM            (0x00000007u)
#define CONTROL_MREQDOMAIN_EXP3_PRU0_DOM_SHIFT      (0x00000000u)

#define CONTROL_MREQDOMAIN_EXP3_PRU1_DOM            (0x00000038u)
#define CONTROL_MREQDOMAIN_EXP3_PRU1_DOM_SHIFT      (0x00000003u)

#define CONTROL_MREQDOMAIN_EXP3_PRU2_DOM            (0x000001C0u)
#define CONTROL_MREQDOMAIN_EXP3_PRU2_DOM_SHIFT      (0x00000006u)

#define CONTROL_MREQDOMAIN_EXP3_PRU3_DOM            (0x00000E00u)
#define CONTROL_MREQDOMAIN_EXP3_PRU3_DOM_SHIFT      (0x00000009u)

/** @brief CONTROL_CEK(n) register fields */
#define CONTROL_CEK_CEK                             (0xFFFFFFFFu)
#define CONTROL_CEK_CEK_SHIFT                       (0x00000000u)

/** @brief CONTROL_CEK_BCH(n) register fields */
#define CONTROL_CEK_BCH_CEK_BCH                     (0xFFFFFFFFu)
#define CONTROL_CEK_BCH_CEK_BCH_SHIFT               (0x00000000u)

/** @brief CONTROL_MSV_0 register fields */
#define CONTROL_MSV_0_MSV                           (0xFFFFFFFFu)
#define CONTROL_MSV_0_MSV_SHIFT                     (0x00000000u)

/** @brief CONTROL_MSV_BCH(n) register fields */
#define CONTROL_MSV_BCH_MSV_BCH                     (0xFFFFFFFFu)
#define CONTROL_MSV_BCH_MSV_BCH_SHIFT               (0x00000000u)

/** @brief CONTROL_SEC_STATUS register fields */
#define CONTROL_SEC_STATUS_EMURST                   (0x00000020u)
#define CONTROL_SEC_STATUS_EMURST_SHIFT             (0x00000005u)

#define CONTROL_SEC_STATUS_GFXDOMAINRST             (0x00000200u)
#define CONTROL_SEC_STATUS_GFXDOMAINRST_SHIFT       (0x00000009u)

#define CONTROL_SEC_STATUS_GLOBALCOLDRST            (0x00000001u)
#define CONTROL_SEC_STATUS_GLOBALCOLDRST_SHIFT      (0x00000000u)

#define CONTROL_SEC_STATUS_GLOBALWARMRST            (0x00000002u)
#define CONTROL_SEC_STATUS_GLOBALWARMRST_SHIFT      (0x00000001u)

#define CONTROL_SEC_STATUS_ICSS0RST                 (0x00040000u)
#define CONTROL_SEC_STATUS_ICSS0RST_SHIFT           (0x00000012u)

#define CONTROL_SEC_STATUS_ICSS1RST                 (0x00080000u)
#define CONTROL_SEC_STATUS_ICSS1RST_SHIFT           (0x00000013u)

#define CONTROL_SEC_STATUS_MPUDOMAINRST             (0x00000040u)
#define CONTROL_SEC_STATUS_MPUDOMAINRST_SHIFT       (0x00000006u)

#define CONTROL_SEC_STATUS_MPURST                   (0x00020000u)
#define CONTROL_SEC_STATUS_MPURST_SHIFT             (0x00000011u)

#define CONTROL_SEC_STATUS_PERDOMAINRST             (0x00000080u)
#define CONTROL_SEC_STATUS_PERDOMAINRST_SHIFT       (0x00000007u)

#define CONTROL_SEC_STATUS_PUBWDRST                 (0x00000004u)
#define CONTROL_SEC_STATUS_PUBWDRST_SHIFT           (0x00000002u)

#define CONTROL_SEC_STATUS_SECWDRST                 (0x00000008u)
#define CONTROL_SEC_STATUS_SECWDRST_SHIFT           (0x00000003u)

#define CONTROL_SEC_STATUS_SSMVIOLATIONRST          (0x00000010u)
#define CONTROL_SEC_STATUS_SSMVIOLATIONRST_SHIFT    (0x00000004u)

#define CONTROL_SEC_STATUS_WKUPDOMAINRST            (0x00000100u)
#define CONTROL_SEC_STATUS_WKUPDOMAINRST_SHIFT      (0x00000008u)

/** @brief CONTROL_SECMEM_STATUS register fields */
#define CONTROL_SECMEM_STATUS_A8L1DEST              (0x00000001u)
#define CONTROL_SECMEM_STATUS_A8L1DEST_SHIFT        (0x00000000u)

#define CONTROL_SECMEM_STATUS_A8L1NOTACC            (0x00010000u)
#define CONTROL_SECMEM_STATUS_A8L1NOTACC_SHIFT      (0x00000010u)

#define CONTROL_SECMEM_STATUS_A8L2DEST              (0x00000002u)
#define CONTROL_SECMEM_STATUS_A8L2DEST_SHIFT        (0x00000001u)

#define CONTROL_SECMEM_STATUS_A8L2NOTACC            (0x00020000u)
#define CONTROL_SECMEM_STATUS_A8L2NOTACC_SHIFT      (0x00000011u)

#define CONTROL_SECMEM_STATUS_FASTSECRAMDEST        (0x00000004u)
#define CONTROL_SECMEM_STATUS_FASTSECRAMDEST_SHIFT  (0x00000002u)

#define CONTROL_SECMEM_STATUS_FASTSECRAMNOTACC      (0x00040000u)
#define CONTROL_SECMEM_STATUS_FASTSECRAMNOTACC_SHIFT    (0x00000012u)

#define CONTROL_SECMEM_STATUS_L3SECRAMDEST          (0x00000008u)
#define CONTROL_SECMEM_STATUS_L3SECRAMDEST_SHIFT    (0x00000003u)

#define CONTROL_SECMEM_STATUS_L3SECRAMNOTACC        (0x00080000u)
#define CONTROL_SECMEM_STATUS_L3SECRAMNOTACC_SHIFT  (0x00000013u)

/** @brief CONTROL_SEC_ERR_STAT_FUNC0 register fields */
#define CONTROL_SEC_ERR_STAT_FUNC0_EMIFFWERR        (0x00000010u)
#define CONTROL_SEC_ERR_STAT_FUNC0_EMIFFWERR_SHIFT  (0x00000004u)

#define CONTROL_SEC_ERR_STAT_FUNC0_GPMCFWERR        (0x00000004u)
#define CONTROL_SEC_ERR_STAT_FUNC0_GPMCFWERR_SHIFT  (0x00000002u)

#define CONTROL_SEC_ERR_STAT_FUNC0_L3RAMFWERR       (0x00000001u)
#define CONTROL_SEC_ERR_STAT_FUNC0_L3RAMFWERR_SHIFT (0x00000000u)

#define CONTROL_SEC_ERR_STAT_FUNC0_SGXFWERR         (0x00020000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_SGXFWERR_SHIFT   (0x00000011u)

#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC0FWERR       (0x01000000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC0FWERR_SHIFT (0x00000018u)

#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC1FWERR       (0x02000000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC1FWERR_SHIFT (0x00000019u)

#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC2FWERR       (0x04000000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC2FWERR_SHIFT (0x0000001Au)

#define CONTROL_SEC_ERR_STAT_FUNC0_TPTCCFWERR       (0x00800000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_TPTCCFWERR_SHIFT (0x00000017u)

/** @brief CONTROL_SEC_ERR_STAT_FUNC1 register fields */
#define CONTROL_SEC_ERR_STAT_FUNC1_ADCFWERR         (0x00000200u)
#define CONTROL_SEC_ERR_STAT_FUNC1_ADCFWERR_SHIFT   (0x00000009u)

#define CONTROL_SEC_ERR_STAT_FUNC1_AES0FWERR        (0x00100000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_AES0FWERR_SHIFT  (0x00000014u)

#define CONTROL_SEC_ERR_STAT_FUNC1_CRYPTODMAFWERR   (0x00080000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_CRYPTODMAFWERR_SHIFT (0x00000013u)

#define CONTROL_SEC_ERR_STAT_FUNC1_DBGPORTFWERR     (0x00020000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_DBGPORTFWERR_SHIFT   (0x00000011u)

#define CONTROL_SEC_ERR_STAT_FUNC1_L3EXPFWERR       (0x00010000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L3EXPFWERR_SHIFT (0x00000010u)

#define CONTROL_SEC_ERR_STAT_FUNC1_L4FASTFWERR      (0x02000000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L4FASTFWERR_SHIFT    (0x00000019u)

#define CONTROL_SEC_ERR_STAT_FUNC1_L4FWFWERR        (0x08000000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L4FWFWERR_SHIFT  (0x0000001Bu)

#define CONTROL_SEC_ERR_STAT_FUNC1_L4PERFWERR       (0x01000000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L4PERFWERR_SHIFT (0x00000018u)

#define CONTROL_SEC_ERR_STAT_FUNC1_L4WKUPFWERR      (0x04000000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L4WKUPFWERR_SHIFT    (0x0000001Au)

#define CONTROL_SEC_ERR_STAT_FUNC1_MCASP0FWERR      (0x00000001u)
#define CONTROL_SEC_ERR_STAT_FUNC1_MCASP0FWERR_SHIFT    (0x00000000u)

#define CONTROL_SEC_ERR_STAT_FUNC1_MCASP1FWERR      (0x00000002u)
#define CONTROL_SEC_ERR_STAT_FUNC1_MCASP1FWERR_SHIFT    (0x00000001u)

#define CONTROL_SEC_ERR_STAT_FUNC1_MMCHS2FWERR      (0x00008000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_MMCHS2FWERR_SHIFT    (0x0000000Fu)

#define CONTROL_SEC_ERR_STAT_FUNC1_SECMODFWERR      (0x00040000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_SECMODFWERR_SHIFT    (0x00000012u)

#define CONTROL_SEC_ERR_STAT_FUNC1_SHAFWERR         (0x00400000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_SHAFWERR_SHIFT   (0x00000016u)

#define CONTROL_SEC_ERR_STAT_FUNC1_USBFWERR         (0x00000800u)
#define CONTROL_SEC_ERR_STAT_FUNC1_USBFWERR_SHIFT   (0x0000000Bu)

/** @brief CONTROL_SEC_ERR_STAT_DBUG0 register fields */
#define CONTROL_SEC_ERR_STAT_DBUG0_EMIFDBGFWERR     (0x00000010u)
#define CONTROL_SEC_ERR_STAT_DBUG0_EMIFDBGFWERR_SHIFT   (0x00000004u)

#define CONTROL_SEC_ERR_STAT_DBUG0_GPMCDBGFWERR     (0x00000004u)
#define CONTROL_SEC_ERR_STAT_DBUG0_GPMCDBGFWERR_SHIFT   (0x00000002u)

#define CONTROL_SEC_ERR_STAT_DBUG0_L3RAMDBGFWERR    (0x00000001u)
#define CONTROL_SEC_ERR_STAT_DBUG0_L3RAMDBGFWERR_SHIFT  (0x00000000u)

#define CONTROL_SEC_ERR_STAT_DBUG0_SGXDBGFWERR      (0x00020000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_SGXDBGFWERR_SHIFT    (0x00000011u)

#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC0DBGFWERR    (0x01000000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC0DBGFWERR_SHIFT  (0x00000018u)

#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC1DBGFWERR    (0x02000000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC1DBGFWERR_SHIFT  (0x00000019u)

#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC2DBGFWERR    (0x04000000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC2DBGFWERR_SHIFT  (0x0000001Au)

#define CONTROL_SEC_ERR_STAT_DBUG0_TPTCCDBGFWERR    (0x00800000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_TPTCCDBGFWERR_SHIFT  (0x00000017u)

/** @brief CONTROL_SEC_ERR_STAT_DBUG1 register fields */
#define CONTROL_SEC_ERR_STAT_DBUG1_ADCDBGFWERR      (0x00000200u)
#define CONTROL_SEC_ERR_STAT_DBUG1_ADCDBGFWERR_SHIFT    (0x00000009u)

#define CONTROL_SEC_ERR_STAT_DBUG1_AES0DBGFWERR     (0x00100000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_AES0DBGFWERR_SHIFT   (0x00000014u)

#define CONTROL_SEC_ERR_STAT_DBUG1_CRYPTODMADBGFWERR    (0x00080000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_CRYPTODMADBGFWERR_SHIFT  (0x00000013u)

#define CONTROL_SEC_ERR_STAT_DBUG1_DBGPORTDBGFWERR  (0x00020000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_DBGPORTDBGFWERR_SHIFT    (0x00000011u)

#define CONTROL_SEC_ERR_STAT_DBUG1_L3EXPDBGFWERR    (0x00010000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L3EXPDBGFWERR_SHIFT  (0x00000010u)

#define CONTROL_SEC_ERR_STAT_DBUG1_L4FASTDBGFWERR   (0x02000000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L4FASTDBGFWERR_SHIFT (0x00000019u)

#define CONTROL_SEC_ERR_STAT_DBUG1_L4FWDBGFWERR     (0x08000000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L4FWDBGFWERR_SHIFT   (0x0000001Bu)

#define CONTROL_SEC_ERR_STAT_DBUG1_L4PERDBGFWERR    (0x01000000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L4PERDBGFWERR_SHIFT  (0x00000018u)

#define CONTROL_SEC_ERR_STAT_DBUG1_L4WKUPDBGFWERR   (0x04000000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L4WKUPDBGFWERR_SHIFT (0x0000001Au)

#define CONTROL_SEC_ERR_STAT_DBUG1_MCASP0DBGFWERR   (0x00000001u)
#define CONTROL_SEC_ERR_STAT_DBUG1_MCASP0DBGFWERR_SHIFT (0x00000000u)

#define CONTROL_SEC_ERR_STAT_DBUG1_MCASP1DBGFWERR   (0x00000002u)
#define CONTROL_SEC_ERR_STAT_DBUG1_MCASP1DBGFWERR_SHIFT (0x00000001u)

#define CONTROL_SEC_ERR_STAT_DBUG1_MMCHS2DBGFWERR   (0x00008000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_MMCHS2DBGFWERR_SHIFT (0x0000000Fu)

#define CONTROL_SEC_ERR_STAT_DBUG1_SHADBGFWERR      (0x00400000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_SHADBGFWERR_SHIFT    (0x00000016u)

#define CONTROL_SEC_ERR_STAT_DBUG1_USBDBGFWERR      (0x00000800u)
#define CONTROL_SEC_ERR_STAT_DBUG1_USBDBGFWERR_SHIFT    (0x0000000Bu)

/** @brief CONTROL_KEK_SW(n) register fields */
#define CONTROL_KEK_SW_KEK_SW                       (0xFFFFFFFFu)
#define CONTROL_KEK_SW_KEK_SW_SHIFT                 (0x00000000u)

/** @brief CONTROL_CMPK_BCH(n) register fields */
#define CONTROL_CMPK_BCH_CMPK_BCH                   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_CMPK_BCH_SHIFT             (0x00000000u)

/** @brief CONTROL_CMPK(n) register fields */
#define CONTROL_CMPK_CMPK                           (0xFFFFFFFFu)
#define CONTROL_CMPK_CMPK_SHIFT                     (0x00000000u)

/** @brief CONTROL_DUCATI_CLKSRC register fields */
#define CONTROL_DUCATI_CLKSRC_DUCATI_MUX_SRC        (0x00000003u)
#define CONTROL_DUCATI_CLKSRC_DUCATI_MUX_SRC_SHIFT  (0x0u)

/** @brief CONTROL_DSS_CLKSRC register fields */
#define CONTROL_DSS_CLKSRC_DSS_MUX_SRC              (0x00000003u)
#define CONTROL_DSS_CLKSRC_DSS_MUX_SRC_SHIFT        (0x0u)

/** @brief SSM_END_FAST_SECRAM register fields */
#define CONTROL_SSM_END_FAST_SECRAM_END_FAST_SECRAM (0x0000FC00u)
#define CONTROL_SSM_END_FAST_SECRAM_END_FAST_SECRAM_SHIFT   (0x0000000Au)

/** @brief SSM_FIREWALL_CONTROLLER register fields */
#define CONTROL_SSM_FIREWALL_CONTROLLER_CPSR_ENFC_EN    (0x00001000u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_CPSR_ENFC_EN_SHIFT  (0x0000000Cu)

#define CONTROL_SSM_FIREWALL_CONTROLLER_DC_ENFC_EN  (0x00000800u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_DC_ENFC_EN_SHIFT    (0x0000000Bu)

#define CONTROL_SSM_FIREWALL_CONTROLLER_IC_ENFC_EN  (0x00000400u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_IC_ENFC_EN_SHIFT    (0x0000000Au)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MMU_ENFC_EN (0x00000200u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MMU_ENFC_EN_SHIFT   (0x00000009u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MONITOR_EN  (0x00000001u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MONITOR_EN_SHIFT    (0x00000000u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_DATA_TRASH_EN   (0x00000080u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_DATA_TRASH_EN_SHIFT (0x00000007u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_DETM_EN (0x00000020u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_DETM_EN_SHIFT   (0x00000005u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_IETM_EN (0x00000010u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_IETM_EN_SHIFT   (0x00000004u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_RAMCODE_EN  (0x00000100u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_RAMCODE_EN_SHIFT    (0x00000008u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_STACK_EN    (0x00000040u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_STACK_EN_SHIFT  (0x00000006u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_SECRAM_EN   (0x00000002u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_SECRAM_EN_SHIFT (0x00000001u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_SPM_STACK_EN    (0x00000008u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_SPM_STACK_EN_SHIFT  (0x00000003u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_SSM_FC_REG_LOCK (0x00002000u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_SSM_FC_REG_LOCK_SHIFT   (0x0000000Du)

#define CONTROL_SSM_FIREWALL_CONTROLLER_STACKEDRAM_EN   (0x00000004u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_STACKEDRAM_EN_SHIFT (0x00000002u)

/** @brief SSM_START_SECURE_STACKED_RAM register fields */
#define CONTROL_SSM_START_SECURE_STACKED_RAM_START_STACKEDRAM   (0xFFFF0000u)
#define CONTROL_SSM_START_SECURE_STACKED_RAM_START_STACKEDRAM_SHIFT (0x00000010u)

/** @brief SSM_END_SECURE_STACKED_RAM register fields */
#define CONTROL_SSM_END_SECURE_STACKED_RAM_END_STACKEDRAM   (0xFFFF0000u)
#define CONTROL_SSM_END_SECURE_STACKED_RAM_END_STACKEDRAM_SHIFT (0x00000010u)

/** @brief SSM_START_SPM_STACK register fields */
#define CONTROL_SSM_START_SPM_STACK_START_SPM_STACK (0xFFFFFC00u)
#define CONTROL_SSM_START_SPM_STACK_START_SPM_STACK_SHIFT   (0x0000000Au)

/** @brief SSM_END_SPM_STACK register fields */
#define CONTROL_SSM_END_SPM_STACK_END_SPM_STACK     (0x0000FC00u)
#define CONTROL_SSM_END_SPM_STACK_END_SPM_STACK_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_SPM_STACK_START_SPM_STACK   (0xFFFF0000u)
#define CONTROL_SSM_END_SPM_STACK_START_SPM_STACK_SHIFT (0x00000010u)

/** @brief SSM_START_MONITOR_RAMCODE register fields */
#define CONTROL_SSM_START_MONITOR_RAMCODE_START_MON_RAMCODE (0xFFFFFC00u)
#define CONTROL_SSM_START_MONITOR_RAMCODE_START_MON_RAMCODE_SHIFT   (0x0000000Au)

/** @brief SSM_END_MONITOR_RAMCODE register fields */
#define CONTROL_SSM_END_MONITOR_RAMCODE_END_MON_RAMCODE (0x0000FC00u)
#define CONTROL_SSM_END_MONITOR_RAMCODE_END_MON_RAMCODE_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_MONITOR_RAMCODE_START_MON_RAMCODE   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_RAMCODE_START_MON_RAMCODE_SHIFT (0x00000010u)

/** @brief SSM_END_MONITOR_RAMDATA register fields */
#define CONTROL_SSM_END_MONITOR_RAMDATA_END_MON_RAMDATA (0x0000FC00u)
#define CONTROL_SSM_END_MONITOR_RAMDATA_END_MON_RAMDATA_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_MONITOR_RAMDATA_START_MON_RAMCODE   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_RAMDATA_START_MON_RAMCODE_SHIFT (0x00000010u)

/** @brief SSM_START_MONITOR_CODE register fields */
#define CONTROL_SSM_START_MONITOR_CODE_START_MON_CODE   (0xFFFFFC00u)
#define CONTROL_SSM_START_MONITOR_CODE_START_MON_CODE_SHIFT (0x0000000Au)

/** @brief SSM_END_MONITOR_CODE register fields */
#define CONTROL_SSM_END_MONITOR_CODE_END_MON_CODE   (0x0001FC00u)
#define CONTROL_SSM_END_MONITOR_CODE_END_MON_CODE_SHIFT (0x0000000Au)

#define CONTROL_SSM_END_MONITOR_CODE_START_MON_CODE (0xFFFE0000u)
#define CONTROL_SSM_END_MONITOR_CODE_START_MON_CODE_SHIFT   (0x00000011u)

/** @brief SSM_START_MONITOR_PERIPH register fields */
#define CONTROL_SSM_START_MONITOR_PERIPH_START_MON_PERIPH   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_PERIPH_START_MON_PERIPH_SHIFT (0x0000000Cu)

/** @brief SSM_END_MONITOR_PERIPH register fields */
#define CONTROL_SSM_END_MONITOR_PERIPH_END_MON_PERIPH   (0x0FFFF000u)
#define CONTROL_SSM_END_MONITOR_PERIPH_END_MON_PERIPH_SHIFT (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_PERIPH_START_MON_PERIPH (0xF0000000u)
#define CONTROL_SSM_END_MONITOR_PERIPH_START_MON_PERIPH_SHIFT   (0x0000001Cu)

/** @brief SSM_START_MONITOR_STACK register fields */
#define CONTROL_SSM_START_MONITOR_STACK_START_MON_STACK (0xFFFFFC00u)
#define CONTROL_SSM_START_MONITOR_STACK_START_MON_STACK_SHIFT   (0x0000000Au)

/** @brief SSM_END_MONITOR_STACK register fields */
#define CONTROL_SSM_END_MONITOR_STACK_END_MON_STACK (0x00007C00u)
#define CONTROL_SSM_END_MONITOR_STACK_END_MON_STACK_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_MONITOR_STACK_START_MON_STACK   (0xFFFF8000u)
#define CONTROL_SSM_END_MONITOR_STACK_START_MON_STACK_SHIFT (0x0000000Fu)

/** @brief SSM_START_MONITOR_RAMCODE_ETM register fields */
#define CONTROL_SSM_START_MONITOR_RAMCODE_ETM_START_MON_RAMCODE_ETM (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_RAMCODE_ETM_START_MON_RAMCODE_ETM_SHIFT   (0x0000000Cu)

/** @brief SSM_END_MONITOR_RAMCODE_ETM register fields */
#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM_END_MON_RAMCODE_ETM (0x0000F000u)
#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM_END_MON_RAMCODE_ETM_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM_START_MON_RAMCODE_ETM   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM_START_MON_RAMCODE_ETM_SHIFT (0x00000010u)

/** @brief SSM_END_MONITOR_RAMDATA_ETM register fields */
#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM_END_MON_RAMDATA_ETM (0x0000F000u)
#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM_END_MON_RAMDATA_ETM_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM_START_MON_RAMCODE_ETM   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM_START_MON_RAMCODE_ETM_SHIFT (0x00000010u)

/** @brief SSM_START_MONITOR_CODE_ETM register fields */
#define CONTROL_SSM_START_MONITOR_CODE_ETM_START_MON_CODE_ETM   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_CODE_ETM_START_MON_CODE_ETM_SHIFT (0x0000000Cu)

/** @brief SSM_END_MONITOR_CODE_ETM register fields */
#define CONTROL_SSM_END_MONITOR_CODE_ETM_END_MON_CODE_ETM   (0x0001F000u)
#define CONTROL_SSM_END_MONITOR_CODE_ETM_END_MON_CODE_ETM_SHIFT (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_CODE_ETM_START_MON_CODE_ETM (0xFFFE0000u)
#define CONTROL_SSM_END_MONITOR_CODE_ETM_START_MON_CODE_ETM_SHIFT   (0x00000011u)

/** @brief SSM_START_MONITOR_STACK_ETM register fields */
#define CONTROL_SSM_START_MONITOR_STACK_ETM_START_MON_STACK_ETM (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_STACK_ETM_START_MON_STACK_ETM_SHIFT   (0x0000000Cu)

/** @brief SSM_END_MONITOR_STACK_ETM register fields */
#define CONTROL_SSM_END_MONITOR_STACK_ETM_END_MON_STACK_ETM (0x0000F000u)
#define CONTROL_SSM_END_MONITOR_STACK_ETM_END_MON_STACK_ETM_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_STACK_ETM_START_MON_STACK_ETM   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_STACK_ETM_START_MON_STACK_ETM_SHIFT (0x00000010u)

/** @brief SSM_START_MONITOR_SHARED_ETM register fields */
#define CONTROL_SSM_START_MONITOR_SHARED_ETM_START_MON_SHARED_ETM   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_SHARED_ETM_START_MON_SHARED_ETM_SHIFT (0x0000000Cu)

/** @brief SSM_END_MONITOR_SHARED_ETM register fields */
#define CONTROL_SSM_END_MONITOR_SHARED_ETM_END_MON_SHARED_ETM   (0x0000F000u)
#define CONTROL_SSM_END_MONITOR_SHARED_ETM_END_MON_SHARED_ETM_SHIFT (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_SHARED_ETM_START_MON_SHARED_ETM (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_SHARED_ETM_START_MON_SHARED_ETM_SHIFT   (0x00000010u)

/** @brief SSM_START_MONITOR_PERIPH_ETM register fields */
#define CONTROL_SSM_START_MONITOR_PERIPH_ETM_START_MON_PERIPH_ETM   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_PERIPH_ETM_START_MON_PERIPH_ETM_SHIFT (0x0000000Cu)

/** @brief SSM_END_MONITOR_PERIPH_ETM register fields */
#define CONTROL_SSM_END_MONITOR_PERIPH_ETM_END_MON_PERIPH_ETM   (0xFFFFF000u)
#define CONTROL_SSM_END_MONITOR_PERIPH_ETM_END_MON_PERIPH_ETM_SHIFT (0x0000000Cu)

/** @brief SSM_CPSR_MODE_ENFC register fields */
#define CONTROL_SSM_CPSR_MODE_ENFC_EA_TRAPPED_IN_MON    (0x00000100u)
#define CONTROL_SSM_CPSR_MODE_ENFC_EA_TRAPPED_IN_MON_SHIFT  (0x00000008u)

#define CONTROL_SSM_CPSR_MODE_ENFC_FIQ_TRAPPED_IN_MON   (0x00000080u)
#define CONTROL_SSM_CPSR_MODE_ENFC_FIQ_TRAPPED_IN_MON_SHIFT (0x00000007u)

#define CONTROL_SSM_CPSR_MODE_ENFC_IRQ_TRAPPED_IN_MON   (0x00000040u)
#define CONTROL_SSM_CPSR_MODE_ENFC_IRQ_TRAPPED_IN_MON_SHIFT (0x00000006u)

#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_ABORT_ENFC    (0x00000004u)
#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_ABORT_ENFC_SHIFT  (0x00000002u)

#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_SYS_ENFC  (0x00000010u)
#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_SYS_ENFC_SHIFT    (0x00000004u)

#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_UNDEF_ENFC    (0x00000008u)
#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_UNDEF_ENFC_SHIFT  (0x00000003u)

#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_USER_ENFC (0x00000002u)
#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_USER_ENFC_SHIFT   (0x00000001u)

#define CONTROL_SSM_CPSR_MODE_ENFC_SYS_VS_USER_ENFC (0x00000020u)
#define CONTROL_SSM_CPSR_MODE_ENFC_SYS_VS_USER_ENFC_SHIFT   (0x00000005u)

#define CONTROL_SSM_CPSR_MODE_ENFC_TZ_NS_BIT_ENFC   (0x00000001u)
#define CONTROL_SSM_CPSR_MODE_ENFC_TZ_NS_BIT_ENFC_SHIFT (0x00000000u)

/** @brief SSM_END_L3_SECRAM register fields */
#define CONTROL_SSM_END_L3_SECRAM_END_L3_SECRAM     (0x0000FC00u)
#define CONTROL_SSM_END_L3_SECRAM_END_L3_SECRAM_SHIFT   (0x0000000Au)

/** @brief CONTROL_SGX_VBBLDO_CTRL register fields */
#define CONTROL_SGX_VBBLDO_CTRL_VSETFBB             (0x03E00000u)
#define CONTROL_SGX_VBBLDO_CTRL_VSETFBB_SHIFT       (0x15u)

#define CONTROL_SGX_VBBLDO_CTRL_VSETRBB             (0x001F0000u)
#define CONTROL_SGX_VBBLDO_CTRL_VSETRBB_SHIFT       (0x10u)

#define CONTROL_SGX_VBBLDO_CTRL_LDOBYPASSZ          (0x00000020u)
#define CONTROL_SGX_VBBLDO_CTRL_LDOBYPASSZ_SHIFT    (0x5u)

#define CONTROL_SGX_VBBLDO_CTRL_LOWPWR              (0x00000010u)
#define CONTROL_SGX_VBBLDO_CTRL_LOWPWR_SHIFT        (0x4u)

#define CONTROL_SGX_VBBLDO_CTRL_HZ                  (0x00000008u)
#define CONTROL_SGX_VBBLDO_CTRL_HZ_SHIFT            (0x3u)

#define CONTROL_SGX_VBBLDO_CTRL_BBSEL               (0x00000004u)
#define CONTROL_SGX_VBBLDO_CTRL_BBSEL_SHIFT         (0x2u)

#define CONTROL_SGX_VBBLDO_CTRL_NOCAP               (0x00000002u)
#define CONTROL_SGX_VBBLDO_CTRL_NOCAP_SHIFT         (0x1u)

#define CONTROL_SGX_VBBLDO_CTRL_NOVBGBYR            (0x00000001u)
#define CONTROL_SGX_VBBLDO_CTRL_NOVBGBYR_SHIFT      (0x0u)

/** @brief CONTROL_GEM_VBBLDO_CTRL register fields */
#define CONTROL_GEM_VBBLDO_CTRL_VSETFBB             (0x03E00000u)
#define CONTROL_GEM_VBBLDO_CTRL_VSETFBB_SHIFT       (0x15u)

#define CONTROL_GEM_VBBLDO_CTRL_VSETRBB             (0x001F0000u)
#define CONTROL_GEM_VBBLDO_CTRL_VSETRBB_SHIFT       (0x10u)

#define CONTROL_GEM_VBBLDO_CTRL_LDOBYPASSZ          (0x00000020u)
#define CONTROL_GEM_VBBLDO_CTRL_LDOBYPASSZ_SHIFT    (0x5u)

#define CONTROL_GEM_VBBLDO_CTRL_LOWPWR              (0x00000010u)
#define CONTROL_GEM_VBBLDO_CTRL_LOWPWR_SHIFT        (0x4u)

#define CONTROL_GEM_VBBLDO_CTRL_HZ                  (0x00000008u)
#define CONTROL_GEM_VBBLDO_CTRL_HZ_SHIFT            (0x3u)

#define CONTROL_GEM_VBBLDO_CTRL_BBSEL               (0x00000004u)
#define CONTROL_GEM_VBBLDO_CTRL_BBSEL_SHIFT         (0x2u)

#define CONTROL_GEM_VBBLDO_CTRL_NOCAP               (0x00000002u)
#define CONTROL_GEM_VBBLDO_CTRL_NOCAP_SHIFT         (0x1u)

#define CONTROL_GEM_VBBLDO_CTRL_NOVBGBYR            (0x00000001u)
#define CONTROL_GEM_VBBLDO_CTRL_NOVBGBYR_SHIFT      (0x0u)

/** @brief CORTEX_VBBLDO_CTRL register fields */
#define CONTROL_CORTEX_VBBLDO_CTRL_BBSEL            (0x00000004u)
#define CONTROL_CORTEX_VBBLDO_CTRL_BBSEL_SHIFT      (0x00000002u)

#define CONTROL_CORTEX_VBBLDO_CTRL_HZ               (0x00000008u)
#define CONTROL_CORTEX_VBBLDO_CTRL_HZ_SHIFT         (0x00000003u)

#define CONTROL_CORTEX_VBBLDO_CTRL_LDOBYPASSZ       (0x00000020u)
#define CONTROL_CORTEX_VBBLDO_CTRL_LDOBYPASSZ_SHIFT (0x00000005u)

#define CONTROL_CORTEX_VBBLDO_CTRL_LOWPWR           (0x00000010u)
#define CONTROL_CORTEX_VBBLDO_CTRL_LOWPWR_SHIFT     (0x00000004u)

#define CONTROL_CORTEX_VBBLDO_CTRL_NOCAP            (0x00000002u)
#define CONTROL_CORTEX_VBBLDO_CTRL_NOCAP_SHIFT      (0x00000001u)

#define CONTROL_CORTEX_VBBLDO_CTRL_NOVBGBYR         (0x00000001u)
#define CONTROL_CORTEX_VBBLDO_CTRL_NOVBGBYR_SHIFT   (0x00000000u)

#define CONTROL_CORTEX_VBBLDO_CTRL_VSETFBB          (0x03E00000u)
#define CONTROL_CORTEX_VBBLDO_CTRL_VSETFBB_SHIFT    (0x00000015u)

#define CONTROL_CORTEX_VBBLDO_CTRL_VSETRBB          (0x001F0000u)
#define CONTROL_CORTEX_VBBLDO_CTRL_VSETRBB_SHIFT    (0x00000010u)

/** @brief CONTROL_RAMLDO_CTRL register fields */
#define CONTROL_RAMLDO_CTRL_VSET                    (0x03FF0000u)
#define CONTROL_RAMLDO_CTRL_VSET_SHIFT              (0x10u)

#define CONTROL_RAMLDO_CTRL_AIPOFF                  (0x00000080u)
#define CONTROL_RAMLDO_CTRL_AIPOFF_SHIFT            (0x7u)

#define CONTROL_RAMLDO_CTRL_SRAMALLRET              (0x00000040u)
#define CONTROL_RAMLDO_CTRL_SRAMALLRET_SHIFT        (0x6u)

#define CONTROL_RAMLDO_CTRL_ABBOFF                  (0x00000020u)
#define CONTROL_RAMLDO_CTRL_ABBOFF_SHIFT            (0x5u)

#define CONTROL_RAMLDO_CTRL_ENFUNC5                 (0x00000010u)
#define CONTROL_RAMLDO_CTRL_ENFUNC5_SHIFT           (0x4u)

#define CONTROL_RAMLDO_CTRL_ENFUNC4                 (0x00000008u)
#define CONTROL_RAMLDO_CTRL_ENFUNC4_SHIFT           (0x3u)

#define CONTROL_RAMLDO_CTRL_ENFUNC3                 (0x00000004u)
#define CONTROL_RAMLDO_CTRL_ENFUNC3_SHIFT           (0x2u)

#define CONTROL_RAMLDO_CTRL_ENFUNC2                 (0x00000002u)
#define CONTROL_RAMLDO_CTRL_ENFUNC2_SHIFT           (0x1u)

#define CONTROL_RAMLDO_CTRL_ENFUNC1                 (0x00000001u)
#define CONTROL_RAMLDO_CTRL_ENFUNC1_SHIFT           (0x0u)

/** @brief REFCLK_LJCBLDO_CTRL register fields */
#define CONTROL_REFCLK_LJCBLDO_CTRL_ABBOFF          (0x00000040u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ABBOFF_SHIFT    (0x00000006u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_AIPOFF          (0x00000080u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_AIPOFF_SHIFT    (0x00000007u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC1         (0x00000001u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC1_SHIFT   (0x00000000u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC2         (0x00000002u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC2_SHIFT   (0x00000001u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC3         (0x00000004u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC3_SHIFT   (0x00000002u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC4         (0x00000008u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC4_SHIFT   (0x00000003u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC5         (0x00000010u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC5_SHIFT   (0x00000004u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_VSET            (0x03FF0000u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_VSET_SHIFT      (0x00000010u)

/** @brief BANDGAP_CTRL register fields */
#define CONTROL_BANDGAP_CTRL_BGROFF                 (0x00000040u)
#define CONTROL_BANDGAP_CTRL_BGROFF_SHIFT           (0x00000006u)

#define CONTROL_BANDGAP_CTRL_CBIASSEL               (0x00000080u)
#define CONTROL_BANDGAP_CTRL_CBIASSEL_SHIFT         (0x00000007u)

#define CONTROL_BANDGAP_CTRL_CLRZ                   (0x00000008u)
#define CONTROL_BANDGAP_CTRL_CLRZ_SHIFT             (0x00000003u)

#define CONTROL_BANDGAP_CTRL_CONTCONV               (0x00000004u)
#define CONTROL_BANDGAP_CTRL_CONTCONV_SHIFT         (0x00000002u)

#define CONTROL_BANDGAP_CTRL_DTEMP                  (0x0000FF00u)
#define CONTROL_BANDGAP_CTRL_DTEMP_SHIFT            (0x00000008u)

#define CONTROL_BANDGAP_CTRL_ECOZ                   (0x00000002u)
#define CONTROL_BANDGAP_CTRL_ECOZ_SHIFT             (0x00000001u)

#define CONTROL_BANDGAP_CTRL_SOC                    (0x00000010u)
#define CONTROL_BANDGAP_CTRL_SOC_SHIFT              (0x00000004u)

#define CONTROL_BANDGAP_CTRL_TMPSOFF                (0x00000020u)
#define CONTROL_BANDGAP_CTRL_TMPSOFF_SHIFT          (0x00000005u)

#define CONTROL_BANDGAP_CTRL_TSHUT                  (0x00000001u)
#define CONTROL_BANDGAP_CTRL_TSHUT_SHIFT            (0x00000000u)

/** @brief BANDGAP_TRIM register fields */
#define CONTROL_BANDGAP_TRIM_DTRBGAPC               (0xFF000000u)
#define CONTROL_BANDGAP_TRIM_DTRBGAPC_SHIFT         (0x00000018u)

#define CONTROL_BANDGAP_TRIM_DTRBGAPV               (0x00FF0000u)
#define CONTROL_BANDGAP_TRIM_DTRBGAPV_SHIFT         (0x00000010u)

#define CONTROL_BANDGAP_TRIM_DTRTEMPS               (0x0000FF00u)
#define CONTROL_BANDGAP_TRIM_DTRTEMPS_SHIFT         (0x00000008u)

#define CONTROL_BANDGAP_TRIM_DTRTEMPSC              (0x000000FFu)
#define CONTROL_BANDGAP_TRIM_DTRTEMPSC_SHIFT        (0x00000000u)

/** @brief CONTROL_OSC_CTRL(n) register fields */
#define CONTROL_OSC0_CTRL_RESELECT                  (0x00000001u)
#define CONTROL_OSC0_CTRL_RESELECT_SHIFT            (0x0u)

#define CONTROL_OSC1_CTRL_GZ                        (0x00000008u)
#define CONTROL_OSC1_CTRL_GZ_SHIFT                  (0x3u)

#define CONTROL_OSC1_CTRL_SW2                       (0x00000004u)
#define CONTROL_OSC1_CTRL_SW2_SHIFT                 (0x2u)

#define CONTROL_OSC1_CTRL_SW1                       (0x00000002u)
#define CONTROL_OSC1_CTRL_SW1_SHIFT                 (0x1u)

#define CONTROL_OSC1_CTRL_RESELECT                  (0x00000001u)
#define CONTROL_OSC1_CTRL_RESELECT_SHIFT            (0x0u)

/** @brief CONTROL_PCIE_CFG register fields */
#define CONTROL_PCIE_CFG_PCIE_TERM_ENABLE           (0x80000000u)
#define CONTROL_PCIE_CFG_PCIE_TERM_ENABLE_SHIFT     (0x1Fu)

#define CONTROL_PCIE_CFG_PCIE_TERM_VALUE            (0x70000000u)
#define CONTROL_PCIE_CFG_PCIE_TERM_VALUE_SHIFT      (0x1Cu)

#define CONTROL_PCIE_CFG_PCIDEVTYPE                 (0x00000003u)
#define CONTROL_PCIE_CFG_PCIDEVTYPE_SHIFT           (0x0u)

/** @brief PE_SCRATCHPAD(n) register fields */
#define CONTROL_PE_SCRATCHPAD_PE_SCRATCHPAD_0       (0xFFFFFFFFu)
#define CONTROL_PE_SCRATCHPAD_PE_SCRATCHPAD_0_SHIFT (0x00000000u)

/** @brief DEVICE_ID register fields */
#define CONTROL_DEVICE_ID_DEVREV                    (0xF0000000u)
#define CONTROL_DEVICE_ID_DEVREV_SHIFT              (0x0000001Cu)

#define CONTROL_DEVICE_ID_MFGR                      (0x00000FFEu)
#define CONTROL_DEVICE_ID_MFGR_SHIFT                (0x00000001u)

#define CONTROL_DEVICE_ID_PARTNUM                   (0x0FFFF000u)
#define CONTROL_DEVICE_ID_PARTNUM_SHIFT             (0x0000000Cu)

/** @brief INIT_PRIORITY_0 register fields */
#define CONTROL_INIT_PRIORITY_0_HOST_ARM            (0x00000003u)
#define CONTROL_INIT_PRIORITY_0_HOST_ARM_SHIFT      (0x00000000u)

#define CONTROL_INIT_PRIORITY_0_MMU                 (0x000000C0u)
#define CONTROL_INIT_PRIORITY_0_MMU_SHIFT           (0x00000006u)

#define CONTROL_INIT_PRIORITY_0_P1500               (0x0000C000u)
#define CONTROL_INIT_PRIORITY_0_P1500_SHIFT         (0x0000000Eu)

#define CONTROL_INIT_PRIORITY_0_PRUSS0              (0x0000000Cu)
#define CONTROL_INIT_PRIORITY_0_PRUSS0_SHIFT        (0x00000002u)

#define CONTROL_INIT_PRIORITY_0_PRUSS1              (0x00000030u)
#define CONTROL_INIT_PRIORITY_0_PRUSS1_SHIFT        (0x00000004u)

#define CONTROL_INIT_PRIORITY_0_TCRD0               (0x00030000u)
#define CONTROL_INIT_PRIORITY_0_TCRD0_SHIFT         (0x00000010u)

#define CONTROL_INIT_PRIORITY_0_TCRD1               (0x00300000u)
#define CONTROL_INIT_PRIORITY_0_TCRD1_SHIFT         (0x00000014u)

#define CONTROL_INIT_PRIORITY_0_TCRD2               (0x03000000u)
#define CONTROL_INIT_PRIORITY_0_TCRD2_SHIFT         (0x00000018u)

#define CONTROL_INIT_PRIORITY_0_TCWR0               (0x000C0000u)
#define CONTROL_INIT_PRIORITY_0_TCWR0_SHIFT         (0x00000012u)

#define CONTROL_INIT_PRIORITY_0_TCWR1               (0x00C00000u)
#define CONTROL_INIT_PRIORITY_0_TCWR1_SHIFT         (0x00000016u)

#define CONTROL_INIT_PRIORITY_0_TCWR2               (0x0C000000u)
#define CONTROL_INIT_PRIORITY_0_TCWR2_SHIFT         (0x0000001Au)

/** @brief INIT_PRIORITY_1 register fields */
#define CONTROL_INIT_PRIORITY_1_CPSW                (0x00000003u)
#define CONTROL_INIT_PRIORITY_1_CPSW_SHIFT          (0x00000000u)

#define CONTROL_INIT_PRIORITY_1_DEBUG               (0x03000000u)
#define CONTROL_INIT_PRIORITY_1_DEBUG_SHIFT         (0x00000018u)

#define CONTROL_INIT_PRIORITY_1_LCD                 (0x00C00000u)
#define CONTROL_INIT_PRIORITY_1_LCD_SHIFT           (0x00000016u)

#define CONTROL_INIT_PRIORITY_1_SGX                 (0x00300000u)
#define CONTROL_INIT_PRIORITY_1_SGX_SHIFT           (0x00000014u)

#define CONTROL_INIT_PRIORITY_1_USB_DMA             (0x00000030u)
#define CONTROL_INIT_PRIORITY_1_USB_DMA_SHIFT       (0x00000004u)

#define CONTROL_INIT_PRIORITY_1_USB_QMGR            (0x000000C0u)
#define CONTROL_INIT_PRIORITY_1_USB_QMGR_SHIFT      (0x00000006u)

/** @brief MMU_CFG register fields */
#define CONTROL_MMU_CFG_MMU_ABORT                   (0x00008000u)
#define CONTROL_MMU_CFG_MMU_ABORT_SHIFT             (0x0000000Fu)

#define CONTROL_MMU_CFG_MMU_DISABLE                 (0x00000080u)
#define CONTROL_MMU_CFG_MMU_DISABLE_SHIFT           (0x00000007u)

/** @brief TPTC_CFG register fields */
#define CONTROL_TPTC_CFG_TC0DBS                     (0x00000003u)
#define CONTROL_TPTC_CFG_TC0DBS_SHIFT               (0x00000000u)

#define CONTROL_TPTC_CFG_TC1DBS                     (0x0000000Cu)
#define CONTROL_TPTC_CFG_TC1DBS_SHIFT               (0x00000002u)

#define CONTROL_TPTC_CFG_TC2DBS                     (0x00000030u)
#define CONTROL_TPTC_CFG_TC2DBS_SHIFT               (0x00000004u)

/** @brief CONTROL_DSP_IDLE_CFG register fields */
#define CONTROL_DSP_IDLE_CFG_DSPSTBY                (0x00008000u)
#define CONTROL_DSP_IDLE_CFG_DSPSTBY_SHIFT          (0xFu)

#define CONTROL_DSP_IDLE_CFG_STBYMODE               (0x00000030u)
#define CONTROL_DSP_IDLE_CFG_STBYMODE_SHIFT         (0x4u)

#define CONTROL_DSP_IDLE_CFG_IDLEMODE               (0x0000000Cu)
#define CONTROL_DSP_IDLE_CFG_IDLEMODE_SHIFT         (0x2u)

/** @brief USB_CTRL0 register fields */
#define CONTROL_USB_CTRL0_CDET_EXTCTL               (0x00000400u)
#define CONTROL_USB_CTRL0_CDET_EXTCTL_SHIFT         (0x0000000Au)

#define CONTROL_USB_CTRL0_CHGDET_DIS                (0x00000004u)
#define CONTROL_USB_CTRL0_CHGDET_DIS_SHIFT          (0x00000002u)

#define CONTROL_USB_CTRL0_CHGDET_RSTRT              (0x00000008u)
#define CONTROL_USB_CTRL0_CHGDET_RSTRT_SHIFT        (0x00000003u)

#define CONTROL_USB_CTRL0_CHGISINK_EN               (0x00000040u)
#define CONTROL_USB_CTRL0_CHGISINK_EN_SHIFT         (0x00000006u)

#define CONTROL_USB_CTRL0_CHGVSRC_EN                (0x00000080u)
#define CONTROL_USB_CTRL0_CHGVSRC_EN_SHIFT          (0x00000007u)

#define CONTROL_USB_CTRL0_CM_PWRDN                  (0x00000001u)
#define CONTROL_USB_CTRL0_CM_PWRDN_SHIFT            (0x00000000u)

#define CONTROL_USB_CTRL0_DATAPOLARITY_INV          (0x00800000u)
#define CONTROL_USB_CTRL0_DATAPOLARITY_INV_SHIFT    (0x00000017u)

#define CONTROL_USB_CTRL0_DMGPIO_PD                 (0x00040000u)
#define CONTROL_USB_CTRL0_DMGPIO_PD_SHIFT           (0x00000012u)

#define CONTROL_USB_CTRL0_DMPULLUP                  (0x00000100u)
#define CONTROL_USB_CTRL0_DMPULLUP_SHIFT            (0x00000008u)

#define CONTROL_USB_CTRL0_DPGPIO_PD                 (0x00020000u)
#define CONTROL_USB_CTRL0_DPGPIO_PD_SHIFT           (0x00000011u)

#define CONTROL_USB_CTRL0_DPPULLUP                  (0x00000200u)
#define CONTROL_USB_CTRL0_DPPULLUP_SHIFT            (0x00000009u)

#define CONTROL_USB_CTRL0_GPIOMODE                  (0x00001000u)
#define CONTROL_USB_CTRL0_GPIOMODE_SHIFT            (0x0000000Cu)

#define CONTROL_USB_CTRL0_GPIO_SIG_CROSS            (0x00004000u)
#define CONTROL_USB_CTRL0_GPIO_SIG_CROSS_SHIFT      (0x0000000Eu)

#define CONTROL_USB_CTRL0_GPIO_SIG_INV              (0x00002000u)
#define CONTROL_USB_CTRL0_GPIO_SIG_INV_SHIFT        (0x0000000Du)

#define CONTROL_USB_CTRL0_OTGSESSENDEN              (0x00100000u)
#define CONTROL_USB_CTRL0_OTGSESSENDEN_SHIFT        (0x00000014u)

#define CONTROL_USB_CTRL0_OTGVDET_EN                (0x00080000u)
#define CONTROL_USB_CTRL0_OTGVDET_EN_SHIFT          (0x00000013u)

#define CONTROL_USB_CTRL0_OTG_PWRDN                 (0x00000002u)
#define CONTROL_USB_CTRL0_OTG_PWRDN_SHIFT           (0x00000001u)

#define CONTROL_USB_CTRL0_SINKONDP                  (0x00000020u)
#define CONTROL_USB_CTRL0_SINKONDP_SHIFT            (0x00000005u)

#define CONTROL_USB_CTRL0_SPAREIN                   (0xFF000000u)
#define CONTROL_USB_CTRL0_SPAREIN_SHIFT             (0x00000018u)

#define CONTROL_USB_CTRL0_SRCONDM                   (0x00000010u)
#define CONTROL_USB_CTRL0_SRCONDM_SHIFT             (0x00000004u)

#define CONTROL_USB_CTRL0_USB_PHY_SMA1              (0x00200000u)
#define CONTROL_USB_CTRL0_USB_PHY_SMA1_SHIFT        (0x00000015u)

#define CONTROL_USB_CTRL0_USB_PHY_SMA2              (0x00400000u)
#define CONTROL_USB_CTRL0_USB_PHY_SMA2_SHIFT        (0x00000016u)

/** @brief USB_STS0 register fields */
#define CONTROL_USB_STS0_CDET_DATADET               (0x00000004u)
#define CONTROL_USB_STS0_CDET_DATADET_SHIFT         (0x00000002u)

#define CONTROL_USB_STS0_CDET_DMDET                 (0x00000010u)
#define CONTROL_USB_STS0_CDET_DMDET_SHIFT           (0x00000004u)

#define CONTROL_USB_STS0_CDET_DPDET                 (0x00000008u)
#define CONTROL_USB_STS0_CDET_DPDET_SHIFT           (0x00000003u)

#define CONTROL_USB_STS0_CHGDETDONE                 (0x00000001u)
#define CONTROL_USB_STS0_CHGDETDONE_SHIFT           (0x00000000u)

#define CONTROL_USB_STS0_CHGDETECT                  (0x00000002u)
#define CONTROL_USB_STS0_CHGDETECT_SHIFT            (0x00000001u)

#define CONTROL_USB_STS0_CHGDETSTS                  (0x000000E0u)
#define CONTROL_USB_STS0_CHGDETSTS_SHIFT            (0x00000005u)

/** @brief USB_CTRL1 register fields */
#define CONTROL_USB_CTRL1_CDET_EXTCTL               (0x00000400u)
#define CONTROL_USB_CTRL1_CDET_EXTCTL_SHIFT         (0x0000000Au)

#define CONTROL_USB_CTRL1_CHGDET_DIS                (0x00000004u)
#define CONTROL_USB_CTRL1_CHGDET_DIS_SHIFT          (0x00000002u)

#define CONTROL_USB_CTRL1_CHGDET_RSTRT              (0x00000008u)
#define CONTROL_USB_CTRL1_CHGDET_RSTRT_SHIFT        (0x00000003u)

#define CONTROL_USB_CTRL1_CHGISINK_EN               (0x00000040u)
#define CONTROL_USB_CTRL1_CHGISINK_EN_SHIFT         (0x00000006u)

#define CONTROL_USB_CTRL1_CHGVSRC_EN                (0x00000080u)
#define CONTROL_USB_CTRL1_CHGVSRC_EN_SHIFT          (0x00000007u)

#define CONTROL_USB_CTRL1_CM_PWRDN                  (0x00000001u)
#define CONTROL_USB_CTRL1_CM_PWRDN_SHIFT            (0x00000000u)

#define CONTROL_USB_CTRL1_DATAPOLARITY_INV          (0x00800000u)
#define CONTROL_USB_CTRL1_DATAPOLARITY_INV_SHIFT    (0x00000017u)

#define CONTROL_USB_CTRL1_DMGPIO_PD                 (0x00040000u)
#define CONTROL_USB_CTRL1_DMGPIO_PD_SHIFT           (0x00000012u)

#define CONTROL_USB_CTRL1_DMPULLUP                  (0x00000100u)
#define CONTROL_USB_CTRL1_DMPULLUP_SHIFT            (0x00000008u)

#define CONTROL_USB_CTRL1_DPGPIO_PD                 (0x00020000u)
#define CONTROL_USB_CTRL1_DPGPIO_PD_SHIFT           (0x00000011u)

#define CONTROL_USB_CTRL1_DPPULLUP                  (0x00000200u)
#define CONTROL_USB_CTRL1_DPPULLUP_SHIFT            (0x00000009u)

#define CONTROL_USB_CTRL1_GPIOMODE                  (0x00001000u)
#define CONTROL_USB_CTRL1_GPIOMODE_SHIFT            (0x0000000Cu)

#define CONTROL_USB_CTRL1_GPIO_SIG_CROSS            (0x00004000u)
#define CONTROL_USB_CTRL1_GPIO_SIG_CROSS_SHIFT      (0x0000000Eu)

#define CONTROL_USB_CTRL1_GPIO_SIG_INV              (0x00002000u)
#define CONTROL_USB_CTRL1_GPIO_SIG_INV_SHIFT        (0x0000000Du)

#define CONTROL_USB_CTRL1_OTGSESSENDEN              (0x00100000u)
#define CONTROL_USB_CTRL1_OTGSESSENDEN_SHIFT        (0x00000014u)

#define CONTROL_USB_CTRL1_OTGVDET_EN                (0x00080000u)
#define CONTROL_USB_CTRL1_OTGVDET_EN_SHIFT          (0x00000013u)

#define CONTROL_USB_CTRL1_OTG_PWRDN                 (0x00000002u)
#define CONTROL_USB_CTRL1_OTG_PWRDN_SHIFT           (0x00000001u)

#define CONTROL_USB_CTRL1_SINKONDP                  (0x00000020u)
#define CONTROL_USB_CTRL1_SINKONDP_SHIFT            (0x00000005u)

#define CONTROL_USB_CTRL1_SPAREIN                   (0xFF000000u)
#define CONTROL_USB_CTRL1_SPAREIN_SHIFT             (0x00000018u)

#define CONTROL_USB_CTRL1_SRCONDM                   (0x00000010u)
#define CONTROL_USB_CTRL1_SRCONDM_SHIFT             (0x00000004u)

#define CONTROL_USB_CTRL1_USB_PHY_SMA1              (0x00200000u)
#define CONTROL_USB_CTRL1_USB_PHY_SMA1_SHIFT        (0x00000015u)

#define CONTROL_USB_CTRL1_USB_PHY_SMA2              (0x00400000u)
#define CONTROL_USB_CTRL1_USB_PHY_SMA2_SHIFT        (0x00000016u)

/** @brief USB_STS1 register fields */
#define CONTROL_USB_STS1_CDET_DATADET               (0x00000004u)
#define CONTROL_USB_STS1_CDET_DATADET_SHIFT         (0x00000002u)

#define CONTROL_USB_STS1_CDET_DMDET                 (0x00000010u)
#define CONTROL_USB_STS1_CDET_DMDET_SHIFT           (0x00000004u)

#define CONTROL_USB_STS1_CDET_DPDET                 (0x00000008u)
#define CONTROL_USB_STS1_CDET_DPDET_SHIFT           (0x00000003u)

#define CONTROL_USB_STS1_CHGDETDONE                 (0x00000001u)
#define CONTROL_USB_STS1_CHGDETDONE_SHIFT           (0x00000000u)

#define CONTROL_USB_STS1_CHGDETECT                  (0x00000002u)
#define CONTROL_USB_STS1_CHGDETECT_SHIFT            (0x00000001u)

#define CONTROL_USB_STS1_CHGDETSTS                  (0x000000E0u)
#define CONTROL_USB_STS1_CHGDETSTS_SHIFT            (0x00000005u)

/** @brief MAC_ID0_LO register fields */
#define CONTROL_MAC_ID0_LO_MACADDR_15_8             (0x000000FFu)
#define CONTROL_MAC_ID0_LO_MACADDR_15_8_SHIFT       (0x00000000u)

#define CONTROL_MAC_ID0_LO_MACADDR_7_0              (0x0000FF00u)
#define CONTROL_MAC_ID0_LO_MACADDR_7_0_SHIFT        (0x00000008u)

/** @brief MAC_ID0_HI register fields */
#define CONTROL_MAC_ID0_HI_MACADDR_23_16            (0xFF000000u)
#define CONTROL_MAC_ID0_HI_MACADDR_23_16_SHIFT      (0x00000018u)

#define CONTROL_MAC_ID0_HI_MACADDR_31_24            (0x00FF0000u)
#define CONTROL_MAC_ID0_HI_MACADDR_31_24_SHIFT      (0x00000010u)

#define CONTROL_MAC_ID0_HI_MACADDR_39_32            (0x0000FF00u)
#define CONTROL_MAC_ID0_HI_MACADDR_39_32_SHIFT      (0x00000008u)

#define CONTROL_MAC_ID0_HI_MACADDR_47_40            (0x000000FFu)
#define CONTROL_MAC_ID0_HI_MACADDR_47_40_SHIFT      (0x00000000u)

/** @brief MAC_ID1_LO register fields */
#define CONTROL_MAC_ID1_LO_MACADDR_15_8             (0x000000FFu)
#define CONTROL_MAC_ID1_LO_MACADDR_15_8_SHIFT       (0x00000000u)

#define CONTROL_MAC_ID1_LO_MACADDR_7_0              (0x0000FF00u)
#define CONTROL_MAC_ID1_LO_MACADDR_7_0_SHIFT        (0x00000008u)

/** @brief MAC_ID1_HI register fields */
#define CONTROL_MAC_ID1_HI_MACADDR_23_16            (0xFF000000u)
#define CONTROL_MAC_ID1_HI_MACADDR_23_16_SHIFT      (0x00000018u)

#define CONTROL_MAC_ID1_HI_MACADDR_31_24            (0x00FF0000u)
#define CONTROL_MAC_ID1_HI_MACADDR_31_24_SHIFT      (0x00000010u)

#define CONTROL_MAC_ID1_HI_MACADDR_39_32            (0x0000FF00u)
#define CONTROL_MAC_ID1_HI_MACADDR_39_32_SHIFT      (0x00000008u)

#define CONTROL_MAC_ID1_HI_MACADDR_47_40            (0x000000FFu)
#define CONTROL_MAC_ID1_HI_MACADDR_47_40_SHIFT      (0x00000000u)

/** @brief CONTROL_SW_REVISION register fields */
#define CONTROL_SW_REVISION_REV                     (0xFFFFFFFFu)
#define CONTROL_SW_REVISION_REV_SHIFT               (0x0u)

/** @brief DCAN_RAMINIT register fields */
#define CONTROL_DCAN_RAMINIT_DCAN0_RAMINIT_DONE     (0x00000100u)
#define CONTROL_DCAN_RAMINIT_DCAN0_RAMINIT_DONE_SHIFT   (0x00000008u)

#define CONTROL_DCAN_RAMINIT_DCAN0_RAMINIT_START    (0x00000001u)
#define CONTROL_DCAN_RAMINIT_DCAN0_RAMINIT_START_SHIFT  (0x00000000u)

#define CONTROL_DCAN_RAMINIT_DCAN1_RAMINIT_DONE     (0x00000200u)
#define CONTROL_DCAN_RAMINIT_DCAN1_RAMINIT_DONE_SHIFT   (0x00000009u)

#define CONTROL_DCAN_RAMINIT_DCAN1_RAMINIT_START    (0x00000002u)
#define CONTROL_DCAN_RAMINIT_DCAN1_RAMINIT_START_SHIFT  (0x00000001u)

/** @brief CONTROL_AUD_CTRL register fields */
#define CONTROL_AUD_CTRL_MCB_LBFSX                  (0x00000002u)
#define CONTROL_AUD_CTRL_MCB_LBFSX_SHIFT            (0x1u)

#define CONTROL_AUD_CTRL_MCB_LBCLKX                 (0x00000001u)
#define CONTROL_AUD_CTRL_MCB_LBCLKX_SHIFT           (0x0u)

/** @brief GMII_SEL register fields */
#define CONTROL_GMII_SEL_GMII1_SEL                  (0x00000003u)
#define CONTROL_GMII_SEL_GMII1_SEL_SHIFT            (0x00000000u)

#define CONTROL_GMII_SEL_GMII2_SEL                  (0x0000000Cu)
#define CONTROL_GMII_SEL_GMII2_SEL_SHIFT            (0x00000002u)

#define CONTROL_GMII_SEL_RGMII1_IDMODE              (0x00000010u)
#define CONTROL_GMII_SEL_RGMII1_IDMODE_SHIFT        (0x00000004u)

#define CONTROL_GMII_SEL_RGMII2_IDMOE               (0x00000020u)
#define CONTROL_GMII_SEL_RGMII2_IDMOE_SHIFT         (0x00000005u)

#define CONTROL_GMII_SEL_RMII1_IO_CLK_EN            (0x00000040u)
#define CONTROL_GMII_SEL_RMII1_IO_CLK_EN_SHIFT      (0x00000006u)

#define CONTROL_GMII_SEL_RMII2_IO_CLK_EN            (0x00000080u)
#define CONTROL_GMII_SEL_RMII2_IO_CLK_EN_SHIFT      (0x00000007u)

/** @brief CONTROL_OCMEM_PWRDN register fields */
#define CONTROL_OCMEM_PWRDN_MEM_PWRDN_STATUS        (0x00000002u)
#define CONTROL_OCMEM_PWRDN_MEM_PWRDN_STATUS_SHIFT  (0x1u)

#define CONTROL_OCMEM_PWRDN_MEM_PWRDN               (0x00000001u)
#define CONTROL_OCMEM_PWRDN_MEM_PWRDN_SHIFT         (0x0u)

/** @brief CONTROL_DUCATIMEM_PWRDN register fields */
#define CONTROL_DUCATIMEM_PWRDN_MEM_PWRDN_STATUS    (0x00000002u)
#define CONTROL_DUCATIMEM_PWRDN_MEM_PWRDN_STATUS_SHIFT  (0x1u)

#define CONTROL_DUCATIMEM_PWRDN_MEM_PWRDN           (0x00000001u)
#define CONTROL_DUCATIMEM_PWRDN_MEM_PWRDN_SHIFT     (0x0u)

/** @brief PWMSS_CTRL register fields */
#define CONTROL_PWMSS_CTRL_PWMMS1_TBCLKEN           (0x00000002u)
#define CONTROL_PWMSS_CTRL_PWMMS1_TBCLKEN_SHIFT     (0x00000001u)

#define CONTROL_PWMSS_CTRL_PWMSS0_TBCLKEN           (0x00000001u)
#define CONTROL_PWMSS_CTRL_PWMSS0_TBCLKEN_SHIFT     (0x00000000u)

#define CONTROL_PWMSS_CTRL_PWMSS2_TBCLKEN           (0x00000004u)
#define CONTROL_PWMSS_CTRL_PWMSS2_TBCLKEN_SHIFT     (0x00000002u)

/** @brief CONTROL_SD_DAC_CTRL register fields */
#define CONTROL_SD_DAC_CTRL_DAC1_cm4                (0x02000000u)
#define CONTROL_SD_DAC_CTRL_DAC1_cm4_SHIFT          (0x19u)

#define CONTROL_SD_DAC_CTRL_DAC1_cm                 (0x01000000u)
#define CONTROL_SD_DAC_CTRL_DAC1_cm_SHIFT           (0x18u)

#define CONTROL_SD_DAC_CTRL_DAC1_cm2                (0x00800000u)
#define CONTROL_SD_DAC_CTRL_DAC1_cm2_SHIFT          (0x17u)

#define CONTROL_SD_DAC_CTRL_DAC1_cm1                (0x00400000u)
#define CONTROL_SD_DAC_CTRL_DAC1_cm1_SHIFT          (0x16u)

#define CONTROL_SD_DAC_CTRL_DAC1_cm0                (0x00200000u)
#define CONTROL_SD_DAC_CTRL_DAC1_cm0_SHIFT          (0x15u)

#define CONTROL_SD_DAC_CTRL_DAC0_cm4                (0x00100000u)
#define CONTROL_SD_DAC_CTRL_DAC0_cm4_SHIFT          (0x14u)

#define CONTROL_SD_DAC_CTRL_DAC0_cm                 (0x00080000u)
#define CONTROL_SD_DAC_CTRL_DAC0_cm_SHIFT           (0x13u)

#define CONTROL_SD_DAC_CTRL_DAC0_cm2                (0x00040000u)
#define CONTROL_SD_DAC_CTRL_DAC0_cm2_SHIFT          (0x12u)

#define CONTROL_SD_DAC_CTRL_DAC0_cm1                (0x00020000u)
#define CONTROL_SD_DAC_CTRL_DAC0_cm1_SHIFT          (0x11u)

#define CONTROL_SD_DAC_CTRL_DAC0_cm0                (0x00010000u)
#define CONTROL_SD_DAC_CTRL_DAC0_cm0_SHIFT          (0x10u)

#define CONTROL_SD_DAC_CTRL_TVOUTBYPASS             (0x00000100u)
#define CONTROL_SD_DAC_CTRL_TVOUTBYPASS_SHIFT       (0x8u)

#define CONTROL_SD_DAC_CTRL_ACEN                    (0x00000080u)
#define CONTROL_SD_DAC_CTRL_ACEN_SHIFT              (0x7u)

#define CONTROL_SD_DAC_CTRL_INPUTINV                (0x00000040u)
#define CONTROL_SD_DAC_CTRL_INPUTINV_SHIFT          (0x6u)

#define CONTROL_SD_DAC_CTRL_DEMEN                   (0x00000020u)
#define CONTROL_SD_DAC_CTRL_DEMEN_SHIFT             (0x5u)

#define CONTROL_SD_DAC_CTRL_PBNDACz                 (0x00000010u)
#define CONTROL_SD_DAC_CTRL_PBNDACz_SHIFT           (0x4u)

#define CONTROL_SD_DAC_CTRL_PBNBGz                  (0x00000008u)
#define CONTROL_SD_DAC_CTRL_PBNBGz_SHIFT            (0x3u)

#define CONTROL_SD_DAC_CTRL_OFFMODE                 (0x00000004u)
#define CONTROL_SD_DAC_CTRL_OFFMODE_SHIFT           (0x2u)

#define CONTROL_SD_DAC_CTRL_SD_CALSEL               (0x00000002u)
#define CONTROL_SD_DAC_CTRL_SD_CALSEL_SHIFT         (0x1u)

#define CONTROL_SD_DAC_CTRL_RESETz                  (0x00000001u)
#define CONTROL_SD_DAC_CTRL_RESETz_SHIFT            (0x0u)

/** @brief CONTROL_SD_DAC_CAL register fields */
#define CONTROL_SD_DAC_CAL_SDDAC_CAL                (0x000003FFu)
#define CONTROL_SD_DAC_CAL_SDDAC_CAL_SHIFT          (0x0u)

/** @brief CONTROL_SD_DAC_REGCTRL register fields */
#define CONTROL_SD_DAC_REGCTRL_SDDAC_CTL            (0x0000FFFFu)
#define CONTROL_SD_DAC_REGCTRL_SDDAC_CTL_SHIFT      (0x0u)

/** @brief CONTROL_SD_DAC_REGSTATUS register fields */
#define CONTROL_SD_DAC_REGSTATUS_STATUS             (0x00000001u)
#define CONTROL_SD_DAC_REGSTATUS_STATUS_SHIFT       (0x0u)

/** @brief CONTROL_EMIF_CLK_GATE register fields */
#define CONTROL_EMIF_CLK_GATE_DDR0_CKE_STATUS       (0x00000004u)
#define CONTROL_EMIF_CLK_GATE_DDR0_CKE_STATUS_SHIFT (0x2u)

#define CONTROL_EMIF_CLK_GATE_DDRPHY0_CLK_GATE      (0x00000001u)
#define CONTROL_EMIF_CLK_GATE_DDRPHY0_CLK_GATE_SHIFT    (0x0u)

/** @brief SMRT_CTRL register fields */
#define CONTROL_SMRT_CTRL_SR0_SLEEP                 (0x00000001u)
#define CONTROL_SMRT_CTRL_SR0_SLEEP_SHIFT           (0x00000000u)

#define CONTROL_SMRT_CTRL_SR1_SLEEP                 (0x00000002u)
#define CONTROL_SMRT_CTRL_SR1_SLEEP_SHIFT           (0x00000001u)

/** @brief MODENA_HW_DEBUG_SEL register fields */
#define CONTROL_MODENA_HW_DEBUG_SEL_HW_DBG_GATE_EN  (0x00000200u)
#define CONTROL_MODENA_HW_DEBUG_SEL_HW_DBG_GATE_EN_SHIFT    (0x00000009u)

#define CONTROL_MODENA_HW_DEBUG_SEL_HW_DBG_SEL      (0x0000000Fu)
#define CONTROL_MODENA_HW_DEBUG_SEL_HW_DBG_SEL_SHIFT    (0x00000000u)

/** @brief MODENA_HW_DBG_INFO register fields */
#define CONTROL_MODENA_HW_DBG_INFO_HW_DBG_INFO      (0xFFFFFFFFu)
#define CONTROL_MODENA_HW_DBG_INFO_HW_DBG_INFO_SHIFT    (0x00000000u)

/** @brief CONTROL_PRCM_DEBUG_ALWON_DEFAULT register fields */
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_USB_CLK_OFF    (0x20000000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_USB_CLK_OFF_SHIFT  (0x1Du)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_PCI_CLK_OFF    (0x08000000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_PCI_CLK_OFF_SHIFT  (0x1Bu)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_DMM_EMIF_CLK_OFF   (0x02000000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_DMM_EMIF_CLK_OFF_SHIFT (0x19u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_DUCATI_CLK_OFF (0x01000000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_DUCATI_CLK_OFF_SHIFT   (0x18u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_RTC_CLK_OFF    (0x00400000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_RTC_CLK_OFF_SHIFT  (0x16u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_VCP_CLK_OFF    (0x00200000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_VCP_CLK_OFF_SHIFT  (0x15u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_OCMC_RAM_CLK_OFF   (0x00100000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_OCMC_RAM_CLK_OFF_SHIFT (0x14u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_MPU_CLK_OFF    (0x00080000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_MPU_CLK_OFF_SHIFT  (0x13u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_MMU_CFG_CLK_OFF    (0x00040000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_MMU_CFG_CLK_OFF_SHIFT  (0x12u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_MMU_CLK_OFF    (0x00020000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_MMU_CLK_OFF_SHIFT  (0x11u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_ETHERNET_CLK_OFF   (0x00010000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_ETHERNET_CLK_OFF_SHIFT (0x10u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_L3_SLOW_CLK_OFF    (0x00004000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_L3_SLOW_CLK_OFF_SHIFT  (0xEu)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_L3_MED_CLK_OFF (0x00002000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_L3_MED_CLK_OFF_SHIFT   (0xDu)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_L3_FAST_CLK_OFF    (0x00001000u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_L3_FAST_CLK_OFF_SHIFT  (0xCu)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_SYSCLK6_CLK_OFF    (0x00000400u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_SYSCLK6_CLK_OFF_SHIFT  (0xAu)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_SYSCLK5_CLK_OFF    (0x00000200u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_SYSCLK5_CLK_OFF_SHIFT  (0x9u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_SYSCLK4_CLK_OFF    (0x00000100u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_SYSCLK4_CLK_OFF_SHIFT  (0x8u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_DEF_PWR_ON (0x00000010u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_DEF_PWR_ON_SHIFT   (0x4u)

#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_HW_DBG_READ_EN (0x00000008u)
#define CONTROL_PRCM_DEBUG_ALWON_DEFAULT_HW_DBG_READ_EN_SHIFT   (0x3u)

/** @brief CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS register fields */
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_DSS_CLK_STATUS_GLUE  (0x80000000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_DSS_CLK_STATUS_GLUE_SHIFT    (0x1Fu)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_CLK_STATUS_PRCM  (0x40000000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_CLK_STATUS_PRCM_SHIFT    (0x1Eu)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_MEM_ON_GLUE  (0x20000000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_MEM_ON_GLUE_SHIFT    (0x1Du)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_SWITCH_ON_GLUE   (0x10000000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_SWITCH_ON_GLUE_SHIFT (0x1Cu)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_ON_PRCM  (0x08000000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_SGX_PD_ON_PRCM_SHIFT    (0x1Bu)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_DSS_CLK_STATUS_GLUE  (0x02000000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_DSS_CLK_STATUS_GLUE_SHIFT    (0x19u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_CLK_STATUS_PRCM  (0x01000000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_CLK_STATUS_PRCM_SHIFT    (0x18u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_MEM_ON_GLUE  (0x00800000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_MEM_ON_GLUE_SHIFT    (0x17u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_SWITCH_ON_GLUE   (0x00400000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_SWITCH_ON_GLUE_SHIFT (0x16u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_ON_PRCM  (0x00200000u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_DSS_PD_ON_PRCM_SHIFT    (0x15u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_GEM_CLK_STATUS_GLUE   (0x00000100u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_GEM_CLK_STATUS_GLUE_SHIFT (0x8u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_GEM_CLK_STATUS_PRCM   (0x00000080u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_GEM_CLK_STATUS_PRCM_SHIFT (0x7u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_MEM_ON_GLUE   (0x00000040u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_MEM_ON_GLUE_SHIFT (0x6u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_SWITCH_ON_GLUE    (0x00000020u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_SWITCH_ON_GLUE_SHIFT  (0x5u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_ON_PRCM   (0x00000010u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_ACTIVE_PD_ON_PRCM_SHIFT (0x4u)

#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_HW_DBG_READ_EN  (0x00000008u)
#define CONTROL_PRCM_DEBUG_PD_DOMAIN_STATUS_HW_DBG_READ_EN_SHIFT    (0x3u)

/** @brief CONTROL_PCIE_PLLCFG(n) register fields */
#define CONTROL_PCIE_PLLCFG0_SEL_IN_FREQ            (0x80000000u)
#define CONTROL_PCIE_PLLCFG0_SEL_IN_FREQ_SHIFT      (0x1Fu)

#define CONTROL_PCIE_PLLCFG0_DIGCLRZ                (0x40000000u)
#define CONTROL_PCIE_PLLCFG0_DIGCLRZ_SHIFT          (0x1Eu)

#define CONTROL_PCIE_PLLCFG0_AMUXSEL                (0x08000000u)
#define CONTROL_PCIE_PLLCFG0_AMUXSEL_SHIFT          (0x1Bu)

#define CONTROL_PCIE_PLLCFG0_TESTCLKMUXSEL          (0x04000000u)
#define CONTROL_PCIE_PLLCFG0_TESTCLKMUXSEL_SHIFT    (0x1Au)

#define CONTROL_PCIE_PLLCFG0_APLL_MISC_CTRL         (0x03F00000u)
#define CONTROL_PCIE_PLLCFG0_APLL_MISC_CTRL_SHIFT   (0x14u)

#define CONTROL_PCIE_PLLCFG0_DIS_REFCLK             (0x00080000u)
#define CONTROL_PCIE_PLLCFG0_DIS_REFCLK_SHIFT       (0x13u)

#define CONTROL_PCIE_PLLCFG0_EN_3P                  (0x00040000u)
#define CONTROL_PCIE_PLLCFG0_EN_3P_SHIFT            (0x12u)

#define CONTROL_PCIE_PLLCFG0_PFD_CLR                (0x00020000u)
#define CONTROL_PCIE_PLLCFG0_PFD_CLR_SHIFT          (0x11u)

#define CONTROL_PCIE_PLLCFG0_CLK_FLIP               (0x00010000u)
#define CONTROL_PCIE_PLLCFG0_CLK_FLIP_SHIFT         (0x10u)

#define CONTROL_PCIE_PLLCFG0_EN_RTRIM               (0x00008000u)
#define CONTROL_PCIE_PLLCFG0_EN_RTRIM_SHIFT         (0xFu)

#define CONTROL_PCIE_PLLCFG0_EN_MEAS                (0x00004000u)
#define CONTROL_PCIE_PLLCFG0_EN_MEAS_SHIFT          (0xEu)

#define CONTROL_PCIE_PLLCFG0_EN_LATCH               (0x00003000u)
#define CONTROL_PCIE_PLLCFG0_EN_LATCH_SHIFT         (0xCu)

#define CONTROL_PCIE_PLLCFG0_CP_CTRL                (0x00000F00u)
#define CONTROL_PCIE_PLLCFG0_CP_CTRL_SHIFT          (0x8u)

#define CONTROL_PCIE_PLLCFG0_RESVALUE               (0x000000C0u)
#define CONTROL_PCIE_PLLCFG0_RESVALUE_SHIFT         (0x6u)

#define CONTROL_PCIE_PLLCFG0_C1_2X                  (0x00000020u)
#define CONTROL_PCIE_PLLCFG0_C1_2X_SHIFT            (0x5u)

#define CONTROL_PCIE_PLLCFG0_ENDIGLDO               (0x00000010u)
#define CONTROL_PCIE_PLLCFG0_ENDIGLDO_SHIFT         (0x4u)

#define CONTROL_PCIE_PLLCFG0_APLL_CP_CURR           (0x00000008u)
#define CONTROL_PCIE_PLLCFG0_APLL_CP_CURR_SHIFT     (0x3u)

#define CONTROL_PCIE_PLLCFG0_ENBGSC_REF             (0x00000004u)
#define CONTROL_PCIE_PLLCFG0_ENBGSC_REF_SHIFT       (0x2u)

#define CONTROL_PCIE_PLLCFG0_ENPLLLDO               (0x00000002u)
#define CONTROL_PCIE_PLLCFG0_ENPLLLDO_SHIFT         (0x1u)

#define CONTROL_PCIE_PLLCFG0_ENPLL                  (0x00000001u)
#define CONTROL_PCIE_PLLCFG0_ENPLL_SHIFT            (0x0u)

#define CONTROL_PCIE_PLLCFG1_ENSATAMODE             (0x80000000u)
#define CONTROL_PCIE_PLLCFG1_ENSATAMODE_SHIFT       (0x1Fu)

#define CONTROL_PCIE_PLLCFG1_PLLREFSEL              (0x40000000u)
#define CONTROL_PCIE_PLLCFG1_PLLREFSEL_SHIFT        (0x1Eu)

#define CONTROL_PCIE_PLLCFG1_NP1_DIV_INT            (0x3C000000u)
#define CONTROL_PCIE_PLLCFG1_NP1_DIV_INT_SHIFT      (0x1Au)

#define CONTROL_PCIE_PLLCFG1_MDIVINT                (0x03FC0000u)
#define CONTROL_PCIE_PLLCFG1_MDIVINT_SHIFT          (0x12u)

#define CONTROL_PCIE_PLLCFG1_MDIVFRAC               (0x0003FFC0u)
#define CONTROL_PCIE_PLLCFG1_MDIVFRAC_SHIFT         (0x6u)

#define CONTROL_PCIE_PLLCFG1_EN_CLKAUX              (0x00000020u)
#define CONTROL_PCIE_PLLCFG1_EN_CLKAUX_SHIFT        (0x5u)

#define CONTROL_PCIE_PLLCFG1_EN_CLK125M             (0x00000010u)
#define CONTROL_PCIE_PLLCFG1_EN_CLK125M_SHIFT       (0x4u)

#define CONTROL_PCIE_PLLCFG1_EN_CLK100M             (0x00000008u)
#define CONTROL_PCIE_PLLCFG1_EN_CLK100M_SHIFT       (0x3u)

#define CONTROL_PCIE_PLLCFG1_EN_CLK50M              (0x00000004u)
#define CONTROL_PCIE_PLLCFG1_EN_CLK50M_SHIFT        (0x2u)

#define CONTROL_PCIE_PLLCFG1_ENSSC                  (0x00000002u)
#define CONTROL_PCIE_PLLCFG1_ENSSC_SHIFT            (0x1u)

#define CONTROL_PCIE_PLLCFG1_MDIVPULSE              (0x00000001u)
#define CONTROL_PCIE_PLLCFG1_MDIVPULSE_SHIFT        (0x0u)

#define CONTROL_PCIE_PLLCFG2_SSCDNSPREAD            (0x80000000u)
#define CONTROL_PCIE_PLLCFG2_SSCDNSPREAD_SHIFT      (0x1Fu)

#define CONTROL_PCIE_PLLCFG2_SSCMANT                (0x7F000000u)
#define CONTROL_PCIE_PLLCFG2_SSCMANT_SHIFT          (0x18u)

#define CONTROL_PCIE_PLLCFG2_SSCEXPO                (0x00E00000u)
#define CONTROL_PCIE_PLLCFG2_SSCEXPO_SHIFT          (0x15u)

#define CONTROL_PCIE_PLLCFG2_SSCFRSPREAD            (0x001FFFFFu)
#define CONTROL_PCIE_PLLCFG2_SSCFRSPREAD_SHIFT      (0x0u)

#define CONTROL_PCIE_PLLCFG3_DIGLDO_PULLDOWNZ       (0x04000000u)
#define CONTROL_PCIE_PLLCFG3_DIGLDO_PULLDOWNZ_SHIFT (0x1Au)

#define CONTROL_PCIE_PLLCFG3_DIGLDO_DIS_SC_PROT     (0x02000000u)
#define CONTROL_PCIE_PLLCFG3_DIGLDO_DIS_SC_PROT_SHIFT   (0x19u)

#define CONTROL_PCIE_PLLCFG3_DIGLDO_EN_SUB_REGULATION   (0x01000000u)
#define CONTROL_PCIE_PLLCFG3_DIGLDO_EN_SUB_REGULATION_SHIFT (0x18u)

#define CONTROL_PCIE_PLLCFG3_DIGLDO_EN_HP_CAPLESSMODE   (0x00800000u)
#define CONTROL_PCIE_PLLCFG3_DIGLDO_EN_HP_CAPLESSMODE_SHIFT (0x17u)

#define CONTROL_PCIE_PLLCFG3_DIGLDO_EN_CAPLESSMODE  (0x00400000u)
#define CONTROL_PCIE_PLLCFG3_DIGLDO_EN_CAPLESSMODE_SHIFT    (0x16u)

#define CONTROL_PCIE_PLLCFG3_DIGLDO_EN_LP_CAPLESSMODE   (0x00200000u)
#define CONTROL_PCIE_PLLCFG3_DIGLDO_EN_LP_CAPLESSMODE_SHIFT (0x15u)

#define CONTROL_PCIE_PLLCFG3_DIGLDO_VSET            (0x001F0000u)
#define CONTROL_PCIE_PLLCFG3_DIGLDO_VSET_SHIFT      (0x10u)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_CTRL_15_14_13   (0x0000E000u)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_CTRL_15_14_13_SHIFT (0xDu)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_RETENTION    (0x00001000u)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_RETENTION_SHIFT  (0xCu)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_LDO_STABLE   (0x00000800u)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_LDO_STABLE_SHIFT (0xBu)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_BYPASS       (0x00000400u)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_BYPASS_SHIFT (0xAu)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_SC_PROT      (0x00000200u)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_SC_PROT_SHIFT    (0x9u)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_EXT_CAP      (0x00000100u)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_EXT_CAP_SHIFT    (0x8u)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_BUF_CUR      (0x00000080u)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_BUF_CUR_SHIFT    (0x7u)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_LP           (0x00000040u)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_EN_LP_SHIFT     (0x6u)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_CTRL_TRIM       (0x0000003Eu)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_CTRL_TRIM_SHIFT (0x1u)

#define CONTROL_PCIE_PLLCFG3_PLLLDO_CTRL            (0x00000001u)
#define CONTROL_PCIE_PLLCFG3_PLLLDO_CTRL_SHIFT      (0x0u)

#define CONTROL_PCIE_PLLCFG4_AUX_CLK_SEL            (0x01000000u)
#define CONTROL_PCIE_PLLCFG4_AUX_CLK_SEL_SHIFT      (0x18u)

#define CONTROL_PCIE_PLLCFG4_AUX_DIV                (0x00F00000u)
#define CONTROL_PCIE_PLLCFG4_AUX_DIV_SHIFT          (0x14u)

#define CONTROL_PCIE_PLLCFG4_RTRIM_RANGE            (0x000C0000u)
#define CONTROL_PCIE_PLLCFG4_RTRIM_RANGE_SHIFT      (0x12u)

#define CONTROL_PCIE_PLLCFG4_RTRIM_EXT_EN           (0x00020000u)
#define CONTROL_PCIE_PLLCFG4_RTRIM_EXT_EN_SHIFT     (0x11u)

#define CONTROL_PCIE_PLLCFG4_RTRIM_SPEED            (0x00010000u)
#define CONTROL_PCIE_PLLCFG4_RTRIM_SPEED_SHIFT      (0x10u)

#define CONTROL_PCIE_PLLCFG4_RTRIM_MODE             (0x0000C000u)
#define CONTROL_PCIE_PLLCFG4_RTRIM_MODE_SHIFT       (0xEu)

#define CONTROL_PCIE_PLLCFG4_RTRIM_EXT_VAL          (0x00003C00u)
#define CONTROL_PCIE_PLLCFG4_RTRIM_EXT_VAL_SHIFT    (0xAu)

#define CONTROL_PCIE_PLLCFG4_VTUNE_RANGE            (0x00000300u)
#define CONTROL_PCIE_PLLCFG4_VTUNE_RANGE_SHIFT      (0x8u)

#define CONTROL_PCIE_PLLCFG4_VTUNE_EXT_EN           (0x00000080u)
#define CONTROL_PCIE_PLLCFG4_VTUNE_EXT_EN_SHIFT     (0x7u)

#define CONTROL_PCIE_PLLCFG4_VTUNE_SPEED            (0x00000040u)
#define CONTROL_PCIE_PLLCFG4_VTUNE_SPEED_SHIFT      (0x6u)

#define CONTROL_PCIE_PLLCFG4_VTUNE_MODE             (0x00000030u)
#define CONTROL_PCIE_PLLCFG4_VTUNE_MODE_SHIFT       (0x4u)

#define CONTROL_PCIE_PLLCFG4_VTUNE_EXT_VAL          (0x0000000Fu)
#define CONTROL_PCIE_PLLCFG4_VTUNE_EXT_VAL_SHIFT    (0x0u)

/** @brief CONTROL_PCIE_PLLSTATUS register fields */
#define CONTROL_PCIE_PLLSTATUS_RTRIMSTS             (0x00000F00u)
#define CONTROL_PCIE_PLLSTATUS_RTRIMSTS_SHIFT       (0x8u)

#define CONTROL_PCIE_PLLSTATUS_VTUNESTS             (0x000000F0u)
#define CONTROL_PCIE_PLLSTATUS_VTUNESTS_SHIFT       (0x4u)

#define CONTROL_PCIE_PLLSTATUS_APLLDIGSTS5          (0x00000008u)
#define CONTROL_PCIE_PLLSTATUS_APLLDIGSTS5_SHIFT    (0x3u)

#define CONTROL_PCIE_PLLSTATUS_APLLDIGSTS4          (0x00000004u)
#define CONTROL_PCIE_PLLSTATUS_APLLDIGSTS4_SHIFT    (0x2u)

#define CONTROL_PCIE_PLLSTATUS_APLLDIGSTS1          (0x00000002u)
#define CONTROL_PCIE_PLLSTATUS_APLLDIGSTS1_SHIFT    (0x1u)

#define CONTROL_PCIE_PLLSTATUS_APLLDIGSTS0          (0x00000001u)
#define CONTROL_PCIE_PLLSTATUS_APLLDIGSTS0_SHIFT    (0x0u)

/** @brief CONTROL_PCIE_RXSTATUS register fields */
#define CONTROL_PCIE_RXSTATUS_TESTFAIL              (0x00000001u)
#define CONTROL_PCIE_RXSTATUS_TESTFAIL_SHIFT        (0x0u)

/** @brief CONTROL_PCIE_TXSTATUS register fields */
#define CONTROL_PCIE_TXSTATUS_TESTFAIL              (0x00000001u)
#define CONTROL_PCIE_TXSTATUS_TESTFAIL_SHIFT        (0x0u)

/** @brief CONTROL_PCIE_TESTCFG register fields */
#define CONTROL_PCIE_TESTCFG_TX_TESTPATT            (0x00000380u)
#define CONTROL_PCIE_TESTCFG_TX_TESTPATT_SHIFT      (0x7u)

#define CONTROL_PCIE_TESTCFG_RX_TESTPATT            (0x00000007u)
#define CONTROL_PCIE_TESTCFG_RX_TESTPATT_SHIFT      (0x0u)

/** @brief CONTROL_PCIE_MISCCFG register fields */
/* TBD */

/** @brief VDD_MPU_OPP_050 register fields */
#define CONTROL_VDD_MPU_OPP_050_NTARGET             (0x00FFFFFFu)
#define CONTROL_VDD_MPU_OPP_050_NTARGET_SHIFT       (0x00000000u)

/** @brief VDD_MPU_OPP_100 register fields */
#define CONTROL_VDD_MPU_OPP_100_NTARGET             (0x00FFFFFFu)
#define CONTROL_VDD_MPU_OPP_100_NTARGET_SHIFT       (0x00000000u)

/** @brief VDD_MPU_OPP_119 register fields */
#define CONTROL_VDD_MPU_OPP_119_NTARGET             (0x00FFFFFFu)
#define CONTROL_VDD_MPU_OPP_119_NTARGET_SHIFT       (0x00000000u)

/** @brief VDD_MPU_OPP_TURBO register fields */
#define CONTROL_VDD_MPU_OPP_TURBO_NTARGET           (0x00FFFFFFu)
#define CONTROL_VDD_MPU_OPP_TURBO_NTARGET_SHIFT     (0x00000000u)

/** @brief VDD_CORE_GEM_OPP_050 register fields */
#define CONTROL_VDD_CORE_GEM_OPP_050_NTARGET        (0x00FFFFFFu)
#define CONTROL_VDD_CORE_GEM_OPP_050_NTARGET_SHIFT  (0x00000000u)

/** @brief VDD_CORE_GEM_OPP_100 register fields */
#define CONTROL_VDD_CORE_GEM_OPP_100_NTARGET        (0x00FFFFFFu)
#define CONTROL_VDD_CORE_GEM_OPP_100_NTARGET_SHIFT  (0x00000000u)

/** @brief VDD_CORE_GEM_OPP_119 register fields */
#define CONTROL_VDD_CORE_GEM_OPP_119_NTARGET        (0x00FFFFFFu)
#define CONTROL_VDD_CORE_GEM_OPP_119_NTARGET_SHIFT  (0x00000000u)

/** @brief VDD_CORE_GEM_OPP_TURBO register fields */
#define CONTROL_VDD_CORE_GEM_OPP_TURBO_NTARGET      (0x00FFFFFFu)
#define CONTROL_VDD_CORE_GEM_OPP_TURBO_NTARGET_SHIFT    (0x00000000u)

/** @brief BB_SCALE register fields */
#define CONTROL_BB_SCALE_BBIAS                      (0x00000003u)
#define CONTROL_BB_SCALE_BBIAS_SHIFT                (0x00000000u)

#define CONTROL_BB_SCALE_SCALE                      (0x00000F00u)
#define CONTROL_BB_SCALE_SCALE_SHIFT                (0x00000008u)

/** @brief USB_VID_PID register fields */
#define CONTROL_USB_VID_PID_USB_PID                 (0x0000FFFFu)
#define CONTROL_USB_VID_PID_USB_PID_SHIFT           (0x00000000u)

#define CONTROL_USB_VID_PID_USB_VID                 (0xFFFF0000u)
#define CONTROL_USB_VID_PID_USB_VID_SHIFT           (0x00000010u)

/** @brief CONTROL_PCIE_VID_PID register fields */
#define CONTROL_PCIE_VID_PID_PCIE_VID               (0xFFFF0000u)
#define CONTROL_PCIE_VID_PID_PCIE_VID_SHIFT         (0x10u)

#define CONTROL_PCIE_VID_PID_PCIE_PID               (0x0000FFFFu)
#define CONTROL_PCIE_VID_PID_PCIE_PID_SHIFT         (0x0u)

/** @brief EFUSE_SMA register fields */
#define CONTROL_EFUSE_SMA_EFUSE_SMA   (0xFFFFFFFFu)
#define CONTROL_EFUSE_SMA_EFUSE_SMA_SHIFT   (0x00000000u)

/** @brief PINCTRL(n) register fields */
#define CONTROL_PINCTRL_MUXMODE             (0x000007ffu)
#define CONTROL_PINCTRL_MUXMODE_SHIFT       (0x00000000u)

#define CONTROL_PINCTRL_PULLUDEN            (0x00010000u)
#define CONTROL_PINCTRL_PULLUDEN_SHIFT      (0x00000010u)

#define CONTROL_PINCTRL_PULLTYPESEL         (0x00020000u)
#define CONTROL_PINCTRL_PULLTYPESEL_SHIFT   (0x00000011u)

#define CONTROL_PINCTRL_RXACTIVE            (0x00040000u)
#define CONTROL_PINCTRL_RXACTIVE_SHIFT      (0x00000012u)

#define CONTROL_PINCTRL_SLEWCTRL            (0x00080000u)
#define CONTROL_PINCTRL_SLEWCTRL_SHIFT      (0x00000013u)

/* PINCTRL MUXMODE tokens */
#define CONTROL_PINCTRL1_MUXMODE_SD1_CLK            (0x1u)
#define CONTROL_PINCTRL1_MUXMODE_PR1_MII_MT1_CLK    (0x4u)
#define CONTROL_PINCTRL1_MUXMODE_GP411              (0x80u)

#define CONTROL_PINCTRL2_MUXMODE_SD1_CMD            (0x1u)
#define CONTROL_PINCTRL2_MUXMODE_PR1_MII1_TXD3      (0x4u)
#define CONTROL_PINCTRL2_MUXMODE_EHRPWM1_TRIPZONE_INPUT (0x20u)
#define CONTROL_PINCTRL2_MUXMODE_GP00               (0x80u)

#define CONTROL_PINCTRL3_MUXMODE_SD1_DAT0           (0x1u)
#define CONTROL_PINCTRL3_MUXMODE_PR1_MII1_TXD2      (0x4u)
#define CONTROL_PINCTRL3_MUXMODE_GP412              (0x80u)

#define CONTROL_PINCTRL4_MUXMODE_SD1_DAT1_SDIRQ     (0x1u)
#define CONTROL_PINCTRL4_MUXMODE_PR1_MII1_TXD1      (0x4u)
#define CONTROL_PINCTRL4_MUXMODE_EHRPWM1A           (0x20u)
#define CONTROL_PINCTRL4_MUXMODE_GP413              (0x80u)

#define CONTROL_PINCTRL5_MUXMODE_SD1_DAT2_SDRW      (0x1u)
#define CONTROL_PINCTRL5_MUXMODE_PR1_MII1_TXD0      (0x4u)
#define CONTROL_PINCTRL5_MUXMODE_EHRPWM1B           (0x20u)
#define CONTROL_PINCTRL5_MUXMODE_GP414              (0x80u)

#define CONTROL_PINCTRL6_MUXMODE_SD1_DAT3           (0x1u)
#define CONTROL_PINCTRL6_MUXMODE_PR1_MII1_CRS       (0x4u)
#define CONTROL_PINCTRL6_MUXMODE_PR1_PRU0_R3016     (0x8u)
#define CONTROL_PINCTRL6_MUXMODE_PR1_PRU0_R3116     (0x10u)
#define CONTROL_PINCTRL6_MUXMODE_EQEP2_INDEX        (0x20u)
#define CONTROL_PINCTRL6_MUXMODE_GP415              (0x80u)

#define CONTROL_PINCTRL7_MUXMODE_DEVOSC_WAKE        (0x1u)
#define CONTROL_PINCTRL7_MUXMODE_SPI1_SCS1n         (0x2u)
#define CONTROL_PINCTRL7_MUXMODE_PR1_MII1_CRS       (0x4u)
#define CONTROL_PINCTRL7_MUXMODE_PR1_PRU0_R3016     (0x8u)
#define CONTROL_PINCTRL7_MUXMODE_PR1_PRU0_R3116     (0x10u)
#define CONTROL_PINCTRL7_MUXMODE_TIM5_IO            (0x40u)
#define CONTROL_PINCTRL7_MUXMODE_GP17               (0x80u)

#define CONTROL_PINCTRL8_MUXMODE_SD0_CLK            (0x1u)
#define CONTROL_PINCTRL8_MUXMODE_EHRPWM2A           (0x20u)
#define CONTROL_PINCTRL8_MUXMODE_GP01               (0x80u)

#define CONTROL_PINCTRL9_MUXMODE_SD0_CMD            (0x1u)
#define CONTROL_PINCTRL9_MUXMODE_SD1_CMD            (0x2u)
#define CONTROL_PINCTRL9_MUXMODE_EHRPWM2B           (0x20u)
#define CONTROL_PINCTRL9_MUXMODE_GP02               (0x80u)

#define CONTROL_PINCTRL10_MUXMODE_SD0_DAT0          (0x1u)
#define CONTROL_PINCTRL10_MUXMODE_SD1_DAT4          (0x2u)
#define CONTROL_PINCTRL10_MUXMODE_EHRPWM2_TRIPZONE_INPUT    (0x20u)
#define CONTROL_PINCTRL10_MUXMODE_GP03              (0x80u)

#define CONTROL_PINCTRL11_MUXMODE_SD0_DAT1_SDIRQn   (0x1u)
#define CONTROL_PINCTRL11_MUXMODE_SD1_DAT5          (0x2u)
#define CONTROL_PINCTRL11_MUXMODE_GP04              (0x80u)

#define CONTROL_PINCTRL12_MUXMODE_SD0_DAT2_SDRWn    (0x1u)
#define CONTROL_PINCTRL12_MUXMODE_SD1_DAT6          (0x2u)
#define CONTROL_PINCTRL12_MUXMODE_GP05              (0x80u)

#define CONTROL_PINCTRL13_MUXMODE_SD0_DAT3          (0x1u)
#define CONTROL_PINCTRL13_MUXMODE_SD1_DAT7          (0x2u)
#define CONTROL_PINCTRL13_MUXMODE_GP06              (0x80u)

#define CONTROL_PINCTRL14_MUXMODE_AUD_CLKIN0        (0x1u)
#define CONTROL_PINCTRL14_MUXMODE_MCA0_AXR7         (0x2u)
#define CONTROL_PINCTRL14_MUXMODE_MCA0_AHCLKX       (0x4u)
#define CONTROL_PINCTRL14_MUXMODE_MCA3_AHCLKX       (0x8u)
#define CONTROL_PINCTRL14_MUXMODE_ATL_CLKOUT1       (0x10u)
#define CONTROL_PINCTRL14_MUXMODE_ATL_CLKOUT0       (0x20u)
#define CONTROL_PINCTRL14_MUXMODE_USB1_DRVVBUS      (0x80u)
#define CONTROL_PINCTRL14_MUXMODE_PR1_PRU0_R3116    (0x100u)

#define CONTROL_PINCTRL15_MUXMODE_AUD_CLKIN1        (0x1u)
#define CONTROL_PINCTRL15_MUXMODE_MCA0_AXR8         (0x2u)
#define CONTROL_PINCTRL15_MUXMODE_MCA1_AHCLKX       (0x4u)
#define CONTROL_PINCTRL15_MUXMODE_MCA4_AHCLKX       (0x8u)
#define CONTROL_PINCTRL15_MUXMODE_ATL_CLKOUT2       (0x10u)
#define CONTROL_PINCTRL15_MUXMODE_EDMA_EVT3         (0x20u)
#define CONTROL_PINCTRL15_MUXMODE_TIM2_IO           (0x40u)
#define CONTROL_PINCTRL15_MUXMODE_GP08              (0x80u)

#define CONTROL_PINCTRL16_MUXMODE_AUD_CLKIN2        (0x1u)
#define CONTROL_PINCTRL16_MUXMODE_MCA0_AXR9         (0x2u)
#define CONTROL_PINCTRL16_MUXMODE_MCA2_AHCLKX       (0x4u)
#define CONTROL_PINCTRL16_MUXMODE_MCA5_AHCLKX       (0x8u)
#define CONTROL_PINCTRL16_MUXMODE_ATL_CLKOUT3       (0x10u)
#define CONTROL_PINCTRL16_MUXMODE_EDMA_EVT2         (0x20u)
#define CONTROL_PINCTRL16_MUXMODE_TIM3_IO           (0x40u)
#define CONTROL_PINCTRL16_MUXMODE_GP09              (0x80u)

#define CONTROL_PINCTRL17_MUXMODE_MCA0_ACLKX        (0x1u)
#define CONTROL_PINCTRL17_MUXMODE_PR1_MII1_RXD3     (0x4u)
#define CONTROL_PINCTRL17_MUXMODE_PR1_PRU0_R310     (0x8u)
#define CONTROL_PINCTRL17_MUXMODE_PR1_PRU0_R300     (0x10u)
#define CONTROL_PINCTRL17_MUXMODE_EQEP1A_IN         (0x40u)

#define CONTROL_PINCTRL18_MUXMODE_MCA0_AFSX         (0x1u)
#define CONTROL_PINCTRL18_MUXMODE_PR1_MII1_RXD2     (0x4u)
#define CONTROL_PINCTRL18_MUXMODE_PR1_PRU0_R311     (0x8u)
#define CONTROL_PINCTRL18_MUXMODE_PR1_PRU0_R301     (0x10u)
#define CONTROL_PINCTRL18_MUXMODE_EQEP1B_IN         (0x40u)

#define CONTROL_PINCTRL19_MUXMODE_MCA0_ACLKR        (0x1u)
#define CONTROL_PINCTRL19_MUXMODE_MCA5_AXR2         (0x2u)
#define CONTROL_PINCTRL19_MUXMODE_PR1_MII1_RXD1     (0x4u)
#define CONTROL_PINCTRL19_MUXMODE_PR1_PRU0_R312     (0x8u)
#define CONTROL_PINCTRL19_MUXMODE_PR1_PRU0_R302     (0x10u)
#define CONTROL_PINCTRL19_MUXMODE_EQEP1_INDEX       (0x40u)

#define CONTROL_PINCTRL20_MUXMODE_MCA0_AFSR         (0x1u)
#define CONTROL_PINCTRL20_MUXMODE_MCA5_AXR3         (0x2u)
#define CONTROL_PINCTRL20_MUXMODE_PR1_MII1_RXD0     (0x4u)
#define CONTROL_PINCTRL20_MUXMODE_PR1_PRU0_R313     (0x8u)
#define CONTROL_PINCTRL20_MUXMODE_PR1_PRU0_R303     (0x10u)
#define CONTROL_PINCTRL20_MUXMODE_EQEP1_STROBE      (0x40u)

#define CONTROL_PINCTRL21_MUXMODE_MCA0_AXR0         (0x1u)
#define CONTROL_PINCTRL21_MUXMODE_PR1_MII_MR1_CLK   (0x4u)
#define CONTROL_PINCTRL21_MUXMODE_PR1_PRU0_R314     (0x8u)
#define CONTROL_PINCTRL21_MUXMODE_PR1_PRU0_R304     (0x10u)
#define CONTROL_PINCTRL21_MUXMODE_EHRPWM1A          (0x40u)

#define CONTROL_PINCTRL22_MUXMODE_MCA0_AXR1         (0x1u)
#define CONTROL_PINCTRL22_MUXMODE_PR1_MII_MT0_CLK   (0x4u)
#define CONTROL_PINCTRL22_MUXMODE_PR1_PRU0_R315     (0x8u)
#define CONTROL_PINCTRL22_MUXMODE_PR1_PRU0_R305     (0x10u)
#define CONTROL_PINCTRL22_MUXMODE_I2C3_SCL          (0x20u)
#define CONTROL_PINCTRL22_MUXMODE_EHRPWM1B          (0x40u)
#define CONTROL_PINCTRL22_MUXMODE_MMC1_SDWP         (0x100u)

#define CONTROL_PINCTRL23_MUXMODE_MCA0_AXR2         (0x1u)
#define CONTROL_PINCTRL23_MUXMODE_PR1_MII0_RXLINK   (0x4u)
#define CONTROL_PINCTRL23_MUXMODE_PR1_PRU0_R316     (0x8u)
#define CONTROL_PINCTRL23_MUXMODE_PR1_PRU0_R306     (0x10u)
#define CONTROL_PINCTRL23_MUXMODE_I2C3_SDA          (0x20u)
#define CONTROL_PINCTRL23_MUXMODE_EHRPWM1_TRIPZONE_INPUT    (0x40u)
#define CONTROL_PINCTRL23_MUXMODE_MMC1_SDCD         (0x100u)

#define CONTROL_PINCTRL24_MUXMODE_MCA0_AXR3         (0x1u)
#define CONTROL_PINCTRL24_MUXMODE_PR1_MII1_COL      (0x4u)
#define CONTROL_PINCTRL24_MUXMODE_PR1_PRU0_R307     (0x10u)
#define CONTROL_PINCTRL24_MUXMODE_PR1_PRU0_R317     (0x20u)

#define CONTROL_PINCTRL25_MUXMODE_MCA0_AXR4         (0x1u)
#define CONTROL_PINCTRL25_MUXMODE_MCA1_AXR8         (0x2u)
#define CONTROL_PINCTRL25_MUXMODE_PR1_MII0_COL      (0x4u)
#define CONTROL_PINCTRL25_MUXMODE_PR1_PRU0_R318     (0x8u)
#define CONTROL_PINCTRL25_MUXMODE_PR1_PRU0_R308     (0x10u)
#define CONTROL_PINCTRL25_MUXMODE_EQEP2A_IN         (0x40u)

#define CONTROL_PINCTRL26_MUXMODE_MCA0_AXR5         (0x1u)
#define CONTROL_PINCTRL26_MUXMODE_MCA1_AXR9         (0x2u)
#define CONTROL_PINCTRL26_MUXMODE_PR1_MII0_RXER     (0x4u)
#define CONTROL_PINCTRL26_MUXMODE_PR1_PRU0_R319     (0x8u)
#define CONTROL_PINCTRL26_MUXMODE_PR1_PRU0_R309     (0x10u)
#define CONTROL_PINCTRL26_MUXMODE_EQEP2B_IN         (0x40u)

#define CONTROL_PINCTRL27_MUXMODE_MCA0_AXR6         (0x1u)
#define CONTROL_PINCTRL27_MUXMODE_MCB_DR            (0x2u)
#define CONTROL_PINCTRL27_MUXMODE_PR1_PRU0_R3110    (0x8u)
#define CONTROL_PINCTRL27_MUXMODE_PR1_PRU0_R3010    (0x10u)

#define CONTROL_PINCTRL28_MUXMODE_MCA0_AXR7         (0x1u)
#define CONTROL_PINCTRL28_MUXMODE_MCB_DX            (0x2u)
#define CONTROL_PINCTRL28_MUXMODE_PR1_PRU0_R3111    (0x8u)
#define CONTROL_PINCTRL28_MUXMODE_PR1_PRU0_R3011    (0x10u)

#define CONTROL_PINCTRL29_MUXMODE_MCA0_AXR8         (0x1u)
#define CONTROL_PINCTRL29_MUXMODE_MCB_FSX           (0x2u)
#define CONTROL_PINCTRL29_MUXMODE_MCB_FSR           (0x4u)
#define CONTROL_PINCTRL29_MUXMODE_PR1_PRU0_R3112    (0x8u)
#define CONTROL_PINCTRL29_MUXMODE_PR1_PRU0_R3012    (0x10u)
#define CONTROL_PINCTRL29_MUXMODE_MMC0_SDWP         (0x100u)

#define CONTROL_PINCTRL30_MUXMODE_MCA0_AXR9         (0x1u)
#define CONTROL_PINCTRL30_MUXMODE_MCB_CLKX          (0x2u)
#define CONTROL_PINCTRL30_MUXMODE_MCB_CLKR          (0x4u)
#define CONTROL_PINCTRL30_MUXMODE_MMC0_SDCD         (0x100u)

#define CONTROL_PINCTRL31_MUXMODE_MCA1_ACLKX        (0x1u)
#define CONTROL_PINCTRL31_MUXMODE_PR1_MII0_TXEN     (0x4u)

#define CONTROL_PINCTRL32_MUXMODE_MCA1_AFSX         (0x1u)
#define CONTROL_PINCTRL32_MUXMODE_PR1_MII0_TXD3     (0x4u)

#define CONTROL_PINCTRL33_MUXMODE_MCA1_ACLKR        (0x1u)
#define CONTROL_PINCTRL33_MUXMODE_MCA1_AXR4         (0x2u)
#define CONTROL_PINCTRL33_MUXMODE_PR1_MII0_TXD2     (0x4u)

#define CONTROL_PINCTRL34_MUXMODE_MCA1_AFSR         (0x1u)
#define CONTROL_PINCTRL34_MUXMODE_MCA1_AXR5         (0x2u)
#define CONTROL_PINCTRL34_MUXMODE_PR1_MII1_RXER     (0x4u)
#define CONTROL_PINCTRL34_MUXMODE_EHRPWM0A          (0x40u)

#define CONTROL_PINCTRL35_MUXMODE_MCA1_AXR0         (0x1u)
#define CONTROL_PINCTRL35_MUXMODE_SD0_DAT4          (0x2u)
#define CONTROL_PINCTRL35_MUXMODE_PR1_MII1_RXDV     (0x4u)
#define CONTROL_PINCTRL35_MUXMODE_EHRPWM0B          (0x40u)

#define CONTROL_PINCTRL36_MUXMODE_MCA1_AXR1         (0x1u)
#define CONTROL_PINCTRL36_MUXMODE_SD0_DAT5          (0x2u)
#define CONTROL_PINCTRL36_MUXMODE_PR1_MII1_TXEN     (0x4u)
#define CONTROL_PINCTRL36_MUXMODE_EHRPWM0_TRIPZONE_INPUT    (0x40u)

#define CONTROL_PINCTRL37_MUXMODE_MCA1_AXR2         (0x1u)
#define CONTROL_PINCTRL37_MUXMODE_MCB_FSR           (0x2u)
#define CONTROL_PINCTRL37_MUXMODE_ECAP2_IN_PWM2_OUT (0x4u)
#define CONTROL_PINCTRL37_MUXMODE_EHRPWM0_SYNCI     (0x20u)
#define CONTROL_PINCTRL37_MUXMODE_EHRPWM0_SYNCO     (0x40u)

#define CONTROL_PINCTRL38_MUXMODE_MCA1_AXR3         (0x1u)
#define CONTROL_PINCTRL38_MUXMODE_MCB_CLKR          (0x2u)
#define CONTROL_PINCTRL38_MUXMODE_PR1_MII1_RXLINK   (0x4u)
#define CONTROL_PINCTRL38_MUXMODE_EQEP0A_IN         (0x40u)

#define CONTROL_PINCTRL39_MUXMODE_MCA2_ACLKX        (0x1u)
#define CONTROL_PINCTRL39_MUXMODE_PR1_MII0_TXD1     (0x2u)
#define CONTROL_PINCTRL39_MUXMODE_GP010             (0x80u)

#define CONTROL_PINCTRL40_MUXMODE_MCA2_AFSX         (0x1u)
#define CONTROL_PINCTRL40_MUXMODE_PR1_MII0_TXD0     (0x2u)
#define CONTROL_PINCTRL40_MUXMODE_GP011             (0x80u)

#define CONTROL_PINCTRL41_MUXMODE_MCA2_AXR0         (0x1u)
#define CONTROL_PINCTRL41_MUXMODE_SD0_DAT6          (0x2u)
#define CONTROL_PINCTRL41_MUXMODE_EQEP0B_IN         (0x10u)
#define CONTROL_PINCTRL41_MUXMODE_UART5_RXD         (0x20u)
#define CONTROL_PINCTRL41_MUXMODE_GP012             (0x80u)

#define CONTROL_PINCTRL42_MUXMODE_MCA2_AXR1         (0x1u)
#define CONTROL_PINCTRL42_MUXMODE_SD0_DAT7          (0x2u)
#define CONTROL_PINCTRL42_MUXMODE_EQEP0_INDEX       (0x10u)
#define CONTROL_PINCTRL42_MUXMODE_UART5_TXD         (0x20u)
#define CONTROL_PINCTRL42_MUXMODE_GP013             (0x80u)

#define CONTROL_PINCTRL43_MUXMODE_MCA2_AXR2         (0x1u)
#define CONTROL_PINCTRL43_MUXMODE_MCA1_AXR6         (0x2u)
#define CONTROL_PINCTRL43_MUXMODE_PR1_MII_MR0_CLK   (0x4u)
#define CONTROL_PINCTRL43_MUXMODE_EQEP0_STROBE      (0x10u)
#define CONTROL_PINCTRL43_MUXMODE_TIM2_IO           (0x40u)
#define CONTROL_PINCTRL43_MUXMODE_GP014             (0x80u)

#define CONTROL_PINCTRL44_MUXMODE_MCA2_AXR3         (0x1u)
#define CONTROL_PINCTRL44_MUXMODE_MCA1_AXR7         (0x2u)
#define CONTROL_PINCTRL44_MUXMODE_PR1_MII0_RXDV     (0x4u)
#define CONTROL_PINCTRL44_MUXMODE_TIM3_IO           (0x40u)
#define CONTROL_PINCTRL44_MUXMODE_GP015             (0x80u)

#define CONTROL_PINCTRL45_MUXMODE_MCA3_ACLKX        (0x1u)
#define CONTROL_PINCTRL45_MUXMODE_PR1_PRU0_R3120    (0x10u)
#define CONTROL_PINCTRL45_MUXMODE_PR1_PRU0_R3020    (0x20u)
#define CONTROL_PINCTRL45_MUXMODE_GP016             (0x80u)

#define CONTROL_PINCTRL46_MUXMODE_MCA3_AFSX         (0x1u)
#define CONTROL_PINCTRL46_MUXMODE_PR1_PRU0_R3119    (0x10u)
#define CONTROL_PINCTRL46_MUXMODE_PR1_PRU0_R3019    (0x20u)
#define CONTROL_PINCTRL46_MUXMODE_GP017             (0x80u)

#define CONTROL_PINCTRL47_MUXMODE_MCA3_AXR0         (0x1u)
#define CONTROL_PINCTRL47_MUXMODE_PR1_PRU0_R3118    (0x10u)
#define CONTROL_PINCTRL47_MUXMODE_PR1_PRU0_R3018    (0x20u)
#define CONTROL_PINCTRL47_MUXMODE_TIM4_IO           (0x40u)
#define CONTROL_PINCTRL47_MUXMODE_GP018             (0x80u)

#define CONTROL_PINCTRL48_MUXMODE_MCA3_AXR1         (0x1u)
#define CONTROL_PINCTRL48_MUXMODE_PR1_PRU0_R3117    (0x10u)
#define CONTROL_PINCTRL48_MUXMODE_PR1_PRU0_R3017    (0x20u)
#define CONTROL_PINCTRL48_MUXMODE_TIM5_IO           (0x40u)
#define CONTROL_PINCTRL48_MUXMODE_GP019             (0x80u)

#define CONTROL_PINCTRL49_MUXMODE_MCA3_AXR2         (0x1u)
#define CONTROL_PINCTRL49_MUXMODE_MCA1_AXR8         (0x2u)
#define CONTROL_PINCTRL49_MUXMODE_PR1_MII0_RXD3     (0x4u)
#define CONTROL_PINCTRL49_MUXMODE_EQEP2_INDEX       (0x10u)
#define CONTROL_PINCTRL49_MUXMODE_GP020             (0x80u)

#define CONTROL_PINCTRL50_MUXMODE_MCA3_AXR3         (0x1u)
#define CONTROL_PINCTRL50_MUXMODE_MCA1_AXR9         (0x2u)
#define CONTROL_PINCTRL50_MUXMODE_PR1_MII0_RXD2     (0x4u)
#define CONTROL_PINCTRL50_MUXMODE_EQEP2_STROBE      (0x10u)

#define CONTROL_PINCTRL51_MUXMODE_MCA4_ACLKX        (0x1u)
#define CONTROL_PINCTRL51_MUXMODE_PR1_PRU0_R3114    (0x10u)
#define CONTROL_PINCTRL51_MUXMODE_PR1_PRU0_R3014    (0x20u)
#define CONTROL_PINCTRL51_MUXMODE_GP021             (0x80u)

#define CONTROL_PINCTRL52_MUXMODE_MCA4_AFSX         (0x1u)
#define CONTROL_PINCTRL52_MUXMODE_PR1_MII0_RXD1     (0x2u)
#define CONTROL_PINCTRL52_MUXMODE_PR1_PRU0_R3115    (0x10u)
#define CONTROL_PINCTRL52_MUXMODE_PR1_PRU0_R3015    (0x20u)
#define CONTROL_PINCTRL52_MUXMODE_GP022             (0x80u)

#define CONTROL_PINCTRL53_MUXMODE_MCA4_AXR0         (0x1u)
#define CONTROL_PINCTRL53_MUXMODE_PR1_MII0_RXD0     (0x2u)
#define CONTROL_PINCTRL53_MUXMODE_PR1_PRU0_R3113    (0x10u)
#define CONTROL_PINCTRL53_MUXMODE_PR1_PRU0_R3013    (0x20u)
#define CONTROL_PINCTRL53_MUXMODE_GP023             (0x80u)

#define CONTROL_PINCTRL54_MUXMODE_MCA4_AXR1         (0x1u)
#define CONTROL_PINCTRL54_MUXMODE_PR1_MII0_CRS      (0x2u)
#define CONTROL_PINCTRL54_MUXMODE_TIM6_IO           (0x40u)
#define CONTROL_PINCTRL54_MUXMODE_GP024             (0x80u)

#define CONTROL_PINCTRL55_MUXMODE_MCA5_ACLKX        (0x1u)
#define CONTROL_PINCTRL55_MUXMODE_GP025             (0x80u)

#define CONTROL_PINCTRL56_MUXMODE_MCA5_AFSX         (0x1u)
#define CONTROL_PINCTRL56_MUXMODE_GP026             (0x80u)

#define CONTROL_PINCTRL57_MUXMODE_MCA5_AXR0         (0x1u)
#define CONTROL_PINCTRL57_MUXMODE_MCA4_AXR2         (0x2u)
#define CONTROL_PINCTRL57_MUXMODE_PR1_ECAP0_CAPIN_APWM_O    (0x20u)
#define CONTROL_PINCTRL57_MUXMODE_GP027             (0x80u)

#define CONTROL_PINCTRL58_MUXMODE_MCA5_AXR1         (0x1u)
#define CONTROL_PINCTRL58_MUXMODE_MCA4_AXR3         (0x2u)
#define CONTROL_PINCTRL58_MUXMODE_TIM7_IO           (0x40u)
#define CONTROL_PINCTRL58_MUXMODE_GP028             (0x80u)

#define CONTROL_PINCTRL59_MUXMODE_MLB_SIG           (0x1u)
#define CONTROL_PINCTRL59_MUXMODE_UART2_RXD         (0x8u)
#define CONTROL_PINCTRL59_MUXMODE_GP029             (0x80u)

#define CONTROL_PINCTRL60_MUXMODE_MLB_DAT           (0x1u)
#define CONTROL_PINCTRL60_MUXMODE_TCLKIN            (0x8u)
#define CONTROL_PINCTRL60_MUXMODE_GP030             (0x80u)

#define CONTROL_PINCTRL61_MUXMODE_MLB_CLK           (0x1u)
#define CONTROL_PINCTRL61_MUXMODE_UART2_TXD         (0x8u)
#define CONTROL_PINCTRL61_MUXMODE_GP031             (0x80u)

#define CONTROL_PINCTRL62_MUXMODE_MLBP_SIGP         (0x1u)
#define CONTROL_PINCTRL62_MUXMODE_GP17              (0x80u)

#define CONTROL_PINCTRL63_MUXMODE_MLBP_SIGN         (0x1u)
#define CONTROL_PINCTRL63_MUXMODE_GP18              (0x80u)

#define CONTROL_PINCTRL64_MUXMODE_MLBP_DATP         (0x1u)
#define CONTROL_PINCTRL64_MUXMODE_GP19              (0x80u)

#define CONTROL_PINCTRL65_MUXMODE_MLBP_DATN         (0x1u)
#define CONTROL_PINCTRL65_MUXMODE_GP110             (0x80u)

#define CONTROL_PINCTRL66_MUXMODE_MLBP_CLKP         (0x1u)

#define CONTROL_PINCTRL67_MUXMODE_MLBP_CLKN         (0x1u)

#define CONTROL_PINCTRL68_MUXMODE_DCAN0_TX          (0x1u)
#define CONTROL_PINCTRL68_MUXMODE_UART2_TXD         (0x2u)
#define CONTROL_PINCTRL68_MUXMODE_I2C3_SDA          (0x20u)
#define CONTROL_PINCTRL68_MUXMODE_GP10              (0x80u)

#define CONTROL_PINCTRL69_MUXMODE_DCAN0_RX          (0x1u)
#define CONTROL_PINCTRL69_MUXMODE_UART2_RXD         (0x2u)
#define CONTROL_PINCTRL69_MUXMODE_I2C3_SCL          (0x20u)
#define CONTROL_PINCTRL69_MUXMODE_GP11              (0x80u)

#define CONTROL_PINCTRL70_MUXMODE_UART0_RXD         (0x1u)

#define CONTROL_PINCTRL71_MUXMODE_UART0_TXD         (0x1u)

#define CONTROL_PINCTRL72_MUXMODE_UART0_CTSn        (0x1u)
#define CONTROL_PINCTRL72_MUXMODE_UART4_RXD         (0x2u)
#define CONTROL_PINCTRL72_MUXMODE_DCAN1_TX          (0x8u)
#define CONTROL_PINCTRL72_MUXMODE_SPI1_SCS3n        (0x10u)
#define CONTROL_PINCTRL72_MUXMODE_SD0_SDCD          (0x40u)
#define CONTROL_PINCTRL72_MUXMODE_GP416             (0x80u)

#define CONTROL_PINCTRL73_MUXMODE_UART0_RTSn        (0x1u)
#define CONTROL_PINCTRL73_MUXMODE_UART4_TXD         (0x2u)
#define CONTROL_PINCTRL73_MUXMODE_DCAN1_RX          (0x8u)
#define CONTROL_PINCTRL73_MUXMODE_SPI1_SCS2n        (0x10u)
#define CONTROL_PINCTRL73_MUXMODE_SD2_SDCD          (0x40u)
#define CONTROL_PINCTRL73_MUXMODE_GP417             (0x80u)

#define CONTROL_PINCTRL74_MUXMODE_UART0_DCDn        (0x1u)
#define CONTROL_PINCTRL74_MUXMODE_UART3_RXD         (0x2u)
#define CONTROL_PINCTRL74_MUXMODE_SPI0_SCS3n        (0x10u)
#define CONTROL_PINCTRL74_MUXMODE_I2C2_SCL          (0x20u)
#define CONTROL_PINCTRL74_MUXMODE_SD1_POW           (0x40u)
#define CONTROL_PINCTRL74_MUXMODE_GP12              (0x80u)

#define CONTROL_PINCTRL75_MUXMODE_UART0_DSRn        (0x1u)
#define CONTROL_PINCTRL75_MUXMODE_UART3_TXD         (0x2u)
#define CONTROL_PINCTRL75_MUXMODE_SPI0_SCS2n        (0x10u)
#define CONTROL_PINCTRL75_MUXMODE_I2C2_SDA          (0x20u)
#define CONTROL_PINCTRL75_MUXMODE_SD1_SDWP          (0x40u)
#define CONTROL_PINCTRL75_MUXMODE_GP13              (0x80u)

#define CONTROL_PINCTRL76_MUXMODE_UART0_DTRn        (0x1u)
#define CONTROL_PINCTRL76_MUXMODE_UART3_CTSn        (0x2u)
#define CONTROL_PINCTRL76_MUXMODE_UART1_TXD         (0x4u)
#define CONTROL_PINCTRL76_MUXMODE_PR1_PRU1_R3014    (0x8u)
#define CONTROL_PINCTRL76_MUXMODE_PR1_PRU1_R3114    (0x10u)
#define CONTROL_PINCTRL76_MUXMODE_ECAP2_IN_PWM2_OUT (0x20u)
#define CONTROL_PINCTRL76_MUXMODE_GP14              (0x80u)

#define CONTROL_PINCTRL77_MUXMODE_UART0_RIN         (0x1u)
#define CONTROL_PINCTRL77_MUXMODE_UART3_RTSn        (0x2u)
#define CONTROL_PINCTRL77_MUXMODE_UART1_RXD         (0x4u)
#define CONTROL_PINCTRL77_MUXMODE_PR1_PRU1_R3015    (0x8u)
#define CONTROL_PINCTRL77_MUXMODE_PR1_PRU1_R3115    (0x10u)
#define CONTROL_PINCTRL77_MUXMODE_ECAP1_IN_PWM1_OUT (0x20u)
#define CONTROL_PINCTRL77_MUXMODE_GP15              (0x80u)

#define CONTROL_PINCTRL78_MUXMODE_I2C1_SCL          (0x1u)

#define CONTROL_PINCTRL79_MUXMODE_I2C1_SDA          (0x1u)

#define CONTROL_PINCTRL80_MUXMODE_SPI0_SCS1n        (0x1u)
#define CONTROL_PINCTRL80_MUXMODE_SD1_SDCD          (0x2u)
#define CONTROL_PINCTRL80_MUXMODE_EHRPWM0A          (0x8u)
#define CONTROL_PINCTRL80_MUXMODE_PR1_ECAP0_CAPIN_APWM_O    (0x10u)
#define CONTROL_PINCTRL80_MUXMODE_EDMA_EVT1         (0x20u)
#define CONTROL_PINCTRL80_MUXMODE_TIM4_IO           (0x40u)
#define CONTROL_PINCTRL80_MUXMODE_GP16              (0x80u)
#define CONTROL_PINCTRL80_MUXMODE_ECAP0_IN_PWM0_OUT (0x100u)

#define CONTROL_PINCTRL81_MUXMODE_SPI0_SCS0n        (0x1u)
#define CONTROL_PINCTRL81_MUXMODE_GP418             (0x80u)

#define CONTROL_PINCTRL82_MUXMODE_SPI0_SCLK         (0x1u)
#define CONTROL_PINCTRL82_MUXMODE_EHRPWM0_TRIPZONE_INPUT    (0x8u)

#define CONTROL_PINCTRL83_MUXMODE_SPI0_D1           (0x1u)
#define CONTROL_PINCTRL83_MUXMODE_EHRPWM0_SYNCI     (0x4u)
#define CONTROL_PINCTRL83_MUXMODE_EHRPWM0_SYNCO     (0x8u)

#define CONTROL_PINCTRL84_MUXMODE_SPI0_D0           (0x1u)
#define CONTROL_PINCTRL84_MUXMODE_EHRPWM0B          (0x8u)

#define CONTROL_PINCTRL85_MUXMODE_SPI1_SCS0n        (0x1u)
#define CONTROL_PINCTRL85_MUXMODE_GP116             (0x80u)

#define CONTROL_PINCTRL86_MUXMODE_SPI1_SCLK         (0x1u)
#define CONTROL_PINCTRL86_MUXMODE_GP117             (0x80u)

#define CONTROL_PINCTRL87_MUXMODE_SPI1_D1           (0x1u)
#define CONTROL_PINCTRL87_MUXMODE_ECAP2_IN_PWM2_OUT (0x8u)
#define CONTROL_PINCTRL87_MUXMODE_GP118             (0x80u)

#define CONTROL_PINCTRL88_MUXMODE_SPI1_D0           (0x1u)
#define CONTROL_PINCTRL88_MUXMODE_ECAP1_IN_PWM1_OUT (0x8u)
#define CONTROL_PINCTRL88_MUXMODE_GP126             (0x80u)

#define CONTROL_PINCTRL89_MUXMODE_GPMC_D0           (0x1u)
#define CONTROL_PINCTRL89_MUXMODE_SPI2_D1           (0x4u)
#define CONTROL_PINCTRL89_MUXMODE_BTMODE0           (0x80u)

#define CONTROL_PINCTRL90_MUXMODE_GPMC_D1           (0x1u)
#define CONTROL_PINCTRL90_MUXMODE_SPI2_D0           (0x4u)
#define CONTROL_PINCTRL90_MUXMODE_BTMODE1           (0x80u)

#define CONTROL_PINCTRL91_MUXMODE_GPMC_D2           (0x1u)
#define CONTROL_PINCTRL91_MUXMODE_BTMODE2           (0x80u)

#define CONTROL_PINCTRL92_MUXMODE_GPMC_D3           (0x1u)
#define CONTROL_PINCTRL92_MUXMODE_BTMODE3           (0x80u)

#define CONTROL_PINCTRL93_MUXMODE_GPMC_D4           (0x1u)
#define CONTROL_PINCTRL93_MUXMODE_GP56              (0x40u)
#define CONTROL_PINCTRL93_MUXMODE_BTMODE4           (0x80u)

#define CONTROL_PINCTRL94_MUXMODE_GPMC_D5           (0x1u)
#define CONTROL_PINCTRL94_MUXMODE_GP57              (0x40u)
#define CONTROL_PINCTRL94_MUXMODE_BTMODE5           (0x80u)

#define CONTROL_PINCTRL95_MUXMODE_GPMC_D6           (0x1u)
#define CONTROL_PINCTRL95_MUXMODE_EHRPWM2_TRIPZONE_INPUT    (0x10u)
#define CONTROL_PINCTRL95_MUXMODE_GP58              (0x40u)
#define CONTROL_PINCTRL95_MUXMODE_BTMODE6           (0x80u)

#define CONTROL_PINCTRL96_MUXMODE_GPMC_D7           (0x1u)
#define CONTROL_PINCTRL96_MUXMODE_GP59              (0x40u)
#define CONTROL_PINCTRL96_MUXMODE_BTMODE7           (0x80u)

#define CONTROL_PINCTRL97_MUXMODE_GPMC_D8           (0x1u)
#define CONTROL_PINCTRL97_MUXMODE_UART7_TXD         (0x8u)
#define CONTROL_PINCTRL97_MUXMODE_GP40              (0x40u)
#define CONTROL_PINCTRL97_MUXMODE_BTMODE8           (0x80u)

#define CONTROL_PINCTRL98_MUXMODE_GPMC_D9           (0x1u)
#define CONTROL_PINCTRL98_MUXMODE_UART7_RXD         (0x8u)
#define CONTROL_PINCTRL98_MUXMODE_GP41              (0x40u)
#define CONTROL_PINCTRL98_MUXMODE_BTMODE9           (0x80u)

#define CONTROL_PINCTRL99_MUXMODE_GPMC_D10          (0x1u)
#define CONTROL_PINCTRL99_MUXMODE_UART7_RTSn        (0x8u)
#define CONTROL_PINCTRL99_MUXMODE_GP42              (0x40u)
#define CONTROL_PINCTRL99_MUXMODE_BTMODE10          (0x80u)

#define CONTROL_PINCTRL100_MUXMODE_GPMC_D11         (0x1u)
#define CONTROL_PINCTRL100_MUXMODE_UART7_CTSn       (0x8u)
#define CONTROL_PINCTRL100_MUXMODE_GP43             (0x40u)
#define CONTROL_PINCTRL100_MUXMODE_BTMODE11         (0x80u)

#define CONTROL_PINCTRL101_MUXMODE_GPMC_D12         (0x1u)
#define CONTROL_PINCTRL101_MUXMODE_EHRPWM2A         (0x10u)
#define CONTROL_PINCTRL101_MUXMODE_GP44             (0x40u)
#define CONTROL_PINCTRL101_MUXMODE_BTMODE12         (0x80u)

#define CONTROL_PINCTRL102_MUXMODE_GPMC_D13         (0x1u)
#define CONTROL_PINCTRL102_MUXMODE_EHRPWM2B         (0x10u)
#define CONTROL_PINCTRL102_MUXMODE_GP45             (0x40u)
#define CONTROL_PINCTRL102_MUXMODE_BTMODE13         (0x80u)

#define CONTROL_PINCTRL103_MUXMODE_GPMC_D14         (0x1u)
#define CONTROL_PINCTRL103_MUXMODE_GP46             (0x40u)
#define CONTROL_PINCTRL103_MUXMODE_BTMODE14         (0x80u)

#define CONTROL_PINCTRL104_MUXMODE_GPMC_D15         (0x1u)
#define CONTROL_PINCTRL104_MUXMODE_GP47             (0x40u)
#define CONTROL_PINCTRL104_MUXMODE_BTMODE15         (0x80u)

#define CONTROL_PINCTRL105_MUXMODE_GPMC_A16         (0x1u)
#define CONTROL_PINCTRL105_MUXMODE_I2C2_SCL         (0x8u)
#define CONTROL_PINCTRL105_MUXMODE_GP25             (0x80u)

#define CONTROL_PINCTRL106_MUXMODE_GPMC_A17         (0x1u)
#define CONTROL_PINCTRL106_MUXMODE_I2C2_SDA         (0x8u)
#define CONTROL_PINCTRL106_MUXMODE_GP26             (0x80u)

#define CONTROL_PINCTRL107_MUXMODE_GPMC_A18         (0x1u)
#define CONTROL_PINCTRL107_MUXMODE_I2C3_SCL         (0x8u)
#define CONTROL_PINCTRL107_MUXMODE_TIM2_IO          (0x40u)
#define CONTROL_PINCTRL107_MUXMODE_GP113            (0x80u)

#define CONTROL_PINCTRL108_MUXMODE_GPMC_A19         (0x1u)
#define CONTROL_PINCTRL108_MUXMODE_I2C3_SDA         (0x8u)
#define CONTROL_PINCTRL108_MUXMODE_TIM3_IO          (0x40u)
#define CONTROL_PINCTRL108_MUXMODE_GP114            (0x80u)

#define CONTROL_PINCTRL109_MUXMODE_GPMC_A20         (0x1u)
#define CONTROL_PINCTRL109_MUXMODE_GPMC_INVA26      (0x2u)
#define CONTROL_PINCTRL109_MUXMODE_SPI2_SCS1n       (0x4u)
#define CONTROL_PINCTRL109_MUXMODE_GP48             (0x40u)
#define CONTROL_PINCTRL109_MUXMODE_GP115            (0x80u)

#define CONTROL_PINCTRL110_MUXMODE_GPMC_A21         (0x1u)
#define CONTROL_PINCTRL110_MUXMODE_GPMC_INVA27      (0x2u)
#define CONTROL_PINCTRL110_MUXMODE_SPI2_D0          (0x4u)
#define CONTROL_PINCTRL110_MUXMODE_GP116            (0x80u)

#define CONTROL_PINCTRL111_MUXMODE_GPMC_A22         (0x1u)
#define CONTROL_PINCTRL111_MUXMODE_SPI2_D1          (0x4u)
#define CONTROL_PINCTRL111_MUXMODE_TIM4_IO          (0x40u)
#define CONTROL_PINCTRL111_MUXMODE_GP117            (0x80u)

#define CONTROL_PINCTRL112_MUXMODE_GPMC_A23         (0x1u)
#define CONTROL_PINCTRL112_MUXMODE_SPI2_SCLK        (0x4u)
#define CONTROL_PINCTRL112_MUXMODE_TIM5_IO          (0x40u)
#define CONTROL_PINCTRL112_MUXMODE_GP118            (0x80u)

#define CONTROL_PINCTRL113_MUXMODE_SD2_DAT7         (0x1u)
#define CONTROL_PINCTRL113_MUXMODE_GPMC_A24         (0x2u)
#define CONTROL_PINCTRL113_MUXMODE_GPMC_A20         (0x4u)
#define CONTROL_PINCTRL113_MUXMODE_VIN1B_HSYNC      (0x10u)
#define CONTROL_PINCTRL113_MUXMODE_UART2_RXD        (0x20u)
#define CONTROL_PINCTRL113_MUXMODE_GP119            (0x80u)

#define CONTROL_PINCTRL114_MUXMODE_SD2_DAT6         (0x1u)
#define CONTROL_PINCTRL114_MUXMODE_GPMC_A25         (0x2u)
#define CONTROL_PINCTRL114_MUXMODE_GPMC_A21         (0x4u)
#define CONTROL_PINCTRL114_MUXMODE_VIN1B_VSYNC      (0x10u)
#define CONTROL_PINCTRL114_MUXMODE_UART2_TXD        (0x20u)
#define CONTROL_PINCTRL114_MUXMODE_GP120            (0x80u)

#define CONTROL_PINCTRL115_MUXMODE_SD2_DAT5         (0x1u)
#define CONTROL_PINCTRL115_MUXMODE_GPMC_A26         (0x2u)
#define CONTROL_PINCTRL115_MUXMODE_GPMC_A22         (0x4u)
#define CONTROL_PINCTRL115_MUXMODE_TIM6_IO          (0x40u)
#define CONTROL_PINCTRL115_MUXMODE_GP121            (0x80u)

#define CONTROL_PINCTRL116_MUXMODE_SD2_DAT4         (0x1u)
#define CONTROL_PINCTRL116_MUXMODE_GPMC_A27         (0x2u)
#define CONTROL_PINCTRL116_MUXMODE_GPMC_A23         (0x4u)
#define CONTROL_PINCTRL116_MUXMODE_GPMC_CS7n        (0x8u)
#define CONTROL_PINCTRL116_MUXMODE_EDMA_EVT0        (0x20u)
#define CONTROL_PINCTRL116_MUXMODE_TIM7_IO          (0x40u)
#define CONTROL_PINCTRL116_MUXMODE_GP122            (0x80u)

#define CONTROL_PINCTRL117_MUXMODE_SD2_DAT3         (0x1u)
#define CONTROL_PINCTRL117_MUXMODE_GPMC_A1          (0x2u)
#define CONTROL_PINCTRL117_MUXMODE_GP25             (0x80u)

#define CONTROL_PINCTRL118_MUXMODE_SD2_DAT2_SDRWn   (0x1u)
#define CONTROL_PINCTRL118_MUXMODE_GPMC_A2          (0x2u)
#define CONTROL_PINCTRL118_MUXMODE_GP26             (0x80u)

#define CONTROL_PINCTRL119_MUXMODE_SD2_DAT1_SDIRQn  (0x1u)
#define CONTROL_PINCTRL119_MUXMODE_GPMC_A3          (0x2u)
#define CONTROL_PINCTRL119_MUXMODE_GP113            (0x80u)

#define CONTROL_PINCTRL120_MUXMODE_SD2_DAT0         (0x1u)
#define CONTROL_PINCTRL120_MUXMODE_GPMC_A4          (0x2u)
#define CONTROL_PINCTRL120_MUXMODE_GP114            (0x80u)

#define CONTROL_PINCTRL121_MUXMODE_SD2_CLK          (0x1u)
#define CONTROL_PINCTRL121_MUXMODE_GP115            (0x80u)

#define CONTROL_PINCTRL122_MUXMODE_GPMC_CS0n        (0x1u)
#define CONTROL_PINCTRL122_MUXMODE_GP123            (0x80u)

#define CONTROL_PINCTRL123_MUXMODE_GPMC_CS1n        (0x1u)
#define CONTROL_PINCTRL123_MUXMODE_GPMC_A25         (0x2u)
#define CONTROL_PINCTRL123_MUXMODE_GP124            (0x80u)

#define CONTROL_PINCTRL124_MUXMODE_GPMC_CS2n        (0x1u)
#define CONTROL_PINCTRL124_MUXMODE_GPMC_A24         (0x2u)
#define CONTROL_PINCTRL124_MUXMODE_GP125            (0x80u)

#define CONTROL_PINCTRL125_MUXMODE_GPMC_CS3n        (0x1u)
#define CONTROL_PINCTRL125_MUXMODE_VIN1B_CLK        (0x2u)
#define CONTROL_PINCTRL125_MUXMODE_SPI2_SCS0n       (0x4u)
#define CONTROL_PINCTRL125_MUXMODE_GP126            (0x80u)

#define CONTROL_PINCTRL126_MUXMODE_GPMC_CS4n        (0x1u)
#define CONTROL_PINCTRL126_MUXMODE_SD2_CMD          (0x2u)
#define CONTROL_PINCTRL126_MUXMODE_GP18             (0x80u)

#define CONTROL_PINCTRL127_MUXMODE_GPMC_CLK         (0x1u)
#define CONTROL_PINCTRL127_MUXMODE_GPMC_CS5n        (0x2u)
#define CONTROL_PINCTRL127_MUXMODE_SPI2_SCLK        (0x4u)
#define CONTROL_PINCTRL127_MUXMODE_GPMC_WAIT1       (0x8u)
#define CONTROL_PINCTRL127_MUXMODE_CLKOUT1          (0x10u)
#define CONTROL_PINCTRL127_MUXMODE_EDMA_EVT3        (0x20u)
#define CONTROL_PINCTRL127_MUXMODE_TIM4_IO          (0x40u)
#define CONTROL_PINCTRL127_MUXMODE_GP127            (0x80u)

#define CONTROL_PINCTRL128_MUXMODE_GPMC_ADVn_ALE    (0x1u)
#define CONTROL_PINCTRL128_MUXMODE_GPMC_CS6n        (0x2u)
#define CONTROL_PINCTRL128_MUXMODE_TIM5_IO          (0x40u)
#define CONTROL_PINCTRL128_MUXMODE_GP128            (0x80u)

#define CONTROL_PINCTRL129_MUXMODE_GPMC_OEn_Ren     (0x1u)
#define CONTROL_PINCTRL129_MUXMODE_GP49             (0x80u)

#define CONTROL_PINCTRL130_MUXMODE_GPMC_WEn         (0x1u)
#define CONTROL_PINCTRL130_MUXMODE_GP410            (0x80u)

#define CONTROL_PINCTRL131_MUXMODE_GPMC_BE0n_CLE    (0x1u)
#define CONTROL_PINCTRL131_MUXMODE_GPMC_A25         (0x2u)
#define CONTROL_PINCTRL131_MUXMODE_EDMA_EVT2        (0x20u)
#define CONTROL_PINCTRL131_MUXMODE_TIM6_IO          (0x40u)
#define CONTROL_PINCTRL131_MUXMODE_GP129            (0x80u)

#define CONTROL_PINCTRL132_MUXMODE_GPMC_BE1n        (0x1u)
#define CONTROL_PINCTRL132_MUXMODE_GPMC_A24         (0x2u)
#define CONTROL_PINCTRL132_MUXMODE_EDMA_EVT1        (0x20u)
#define CONTROL_PINCTRL132_MUXMODE_TIM7_IO          (0x40u)
#define CONTROL_PINCTRL132_MUXMODE_GP130            (0x80u)

#define CONTROL_PINCTRL133_MUXMODE_GPMC_WAIT0       (0x1u)
#define CONTROL_PINCTRL133_MUXMODE_GPMC_A26         (0x2u)
#define CONTROL_PINCTRL133_MUXMODE_EDMA_EVT0        (0x20u)
#define CONTROL_PINCTRL133_MUXMODE_GP131            (0x80u)

#define CONTROL_PINCTRL134_MUXMODE_VIN0B_CLK        (0x1u)
#define CONTROL_PINCTRL134_MUXMODE_CLKOUT0          (0x20u)
#define CONTROL_PINCTRL134_MUXMODE_GP19             (0x80u)

#define CONTROL_PINCTRL135_MUXMODE_VIN0A_DE         (0x1u)
#define CONTROL_PINCTRL135_MUXMODE_VIN0B_HSYNC      (0x10u)
#define CONTROL_PINCTRL135_MUXMODE_UART5_TXD        (0x20u)
#define CONTROL_PINCTRL135_MUXMODE_I2C2_SDA         (0x40u)
#define CONTROL_PINCTRL135_MUXMODE_GP20             (0x80u)

#define CONTROL_PINCTRL136_MUXMODE_VIN0A_FLD        (0x1u)
#define CONTROL_PINCTRL136_MUXMODE_VIN0B_VSYNC      (0x10u)
#define CONTROL_PINCTRL136_MUXMODE_UART5_RXD        (0x20u)
#define CONTROL_PINCTRL136_MUXMODE_I2C2_SCL         (0x40u)
#define CONTROL_PINCTRL136_MUXMODE_GP21             (0x80u)

#define CONTROL_PINCTRL137_MUXMODE_VIN0A_CLK        (0x1u)
#define CONTROL_PINCTRL137_MUXMODE_GP22             (0x80u)

#define CONTROL_PINCTRL138_MUXMODE_VIN0A_HSYNC      (0x1u)
#define CONTROL_PINCTRL138_MUXMODE_UART5_RTSn       (0x20u)
#define CONTROL_PINCTRL138_MUXMODE_GP23             (0x80u)

#define CONTROL_PINCTRL139_MUXMODE_VIN0A_VSYNC      (0x1u)
#define CONTROL_PINCTRL139_MUXMODE_UART5_CTSn       (0x20u)
#define CONTROL_PINCTRL139_MUXMODE_GP24             (0x80u)

#define CONTROL_PINCTRL140_MUXMODE_VIN0A_D0         (0x1u)
#define CONTROL_PINCTRL140_MUXMODE_PR1_EDC_LATCH0_IN    (0x4u)
#define CONTROL_PINCTRL140_MUXMODE_GP111            (0x80u)

#define CONTROL_PINCTRL141_MUXMODE_VIN0A_D1         (0x1u)
#define CONTROL_PINCTRL141_MUXMODE_PR1_EDC_LATCH1_IN    (0x4u)
#define CONTROL_PINCTRL141_MUXMODE_GP112            (0x80u)

#define CONTROL_PINCTRL142_MUXMODE_VIN0A_D2         (0x1u)
#define CONTROL_PINCTRL142_MUXMODE_GP27             (0x80u)

#define CONTROL_PINCTRL143_MUXMODE_VIN0A_D3         (0x1u)
#define CONTROL_PINCTRL143_MUXMODE_PR1_EDC_SYNC0_OUT    (0x4u)
#define CONTROL_PINCTRL143_MUXMODE_GP28             (0x80u)

#define CONTROL_PINCTRL144_MUXMODE_VIN0A_D4         (0x1u)
#define CONTROL_PINCTRL144_MUXMODE_PR1_EDC_SYNC1_OUT    (0x4u)
#define CONTROL_PINCTRL144_MUXMODE_GP29             (0x80u)

#define CONTROL_PINCTRL145_MUXMODE_VIN0A_D5         (0x1u)
#define CONTROL_PINCTRL145_MUXMODE_PR1_EDIO_SOF     (0x4u)
#define CONTROL_PINCTRL145_MUXMODE_GP210            (0x80u)

#define CONTROL_PINCTRL146_MUXMODE_VIN0A_D6         (0x1u)
#define CONTROL_PINCTRL146_MUXMODE_PR1_MDIO_MDCLK   (0x4u)
#define CONTROL_PINCTRL146_MUXMODE_GP211            (0x80u)

#define CONTROL_PINCTRL147_MUXMODE_VIN0A_D7         (0x1u)
#define CONTROL_PINCTRL147_MUXMODE_PR1_MDIO_DATA    (0x4u)
#define CONTROL_PINCTRL147_MUXMODE_GP212            (0x80u)

#define CONTROL_PINCTRL148_MUXMODE_VIN0A_D8_BD0     (0x1u)
#define CONTROL_PINCTRL148_MUXMODE_PR1_MII_MT1_CLK  (0x4u)
#define CONTROL_PINCTRL148_MUXMODE_GP213            (0x80u)

#define CONTROL_PINCTRL149_MUXMODE_VIN0A_D9_BD1     (0x1u)
#define CONTROL_PINCTRL149_MUXMODE_PR1_MII1_TXD3    (0x4u)
#define CONTROL_PINCTRL149_MUXMODE_GP214            (0x80u)

#define CONTROL_PINCTRL150_MUXMODE_VIN0A_D10_BD2    (0x1u)
#define CONTROL_PINCTRL150_MUXMODE_PR1_MII1_TXD2    (0x4u)
#define CONTROL_PINCTRL150_MUXMODE_GP215            (0x80u)

#define CONTROL_PINCTRL151_MUXMODE_VIN0A_D11_BD3    (0x1u)
#define CONTROL_PINCTRL151_MUXMODE_PR1_MII1_TXD1    (0x4u)
#define CONTROL_PINCTRL151_MUXMODE_GP216            (0x80u)

#define CONTROL_PINCTRL152_MUXMODE_VIN0A_D12_BD4    (0x1u)
#define CONTROL_PINCTRL152_MUXMODE_PR1_MII1_TXD0    (0x4u)
#define CONTROL_PINCTRL152_MUXMODE_PR1_PRU1_R3116   (0x8u)
#define CONTROL_PINCTRL152_MUXMODE_UART7_RTSn       (0x10u)
#define CONTROL_PINCTRL152_MUXMODE_CLKOUT1          (0x20u)
#define CONTROL_PINCTRL152_MUXMODE_PR1_PRU1_R3016   (0x40u)
#define CONTROL_PINCTRL152_MUXMODE_GP217            (0x80u)

#define CONTROL_PINCTRL153_MUXMODE_VIN0A_D13_BD5    (0x1u)
#define CONTROL_PINCTRL153_MUXMODE_PR1_MII1_RXD3    (0x4u)
#define CONTROL_PINCTRL153_MUXMODE_PR1_PRU1_R3120   (0x8u)
#define CONTROL_PINCTRL153_MUXMODE_UART7_CTSn       (0x10u)
#define CONTROL_PINCTRL153_MUXMODE_PR1_PRU1_R3020   (0x40u)
#define CONTROL_PINCTRL153_MUXMODE_GP218            (0x80u)

#define CONTROL_PINCTRL154_MUXMODE_VIN0A_D14_BD6    (0x1u)
#define CONTROL_PINCTRL154_MUXMODE_PR1_MII1_RXD2    (0x4u)
#define CONTROL_PINCTRL154_MUXMODE_PR1_PRU1_R3119   (0x8u)
#define CONTROL_PINCTRL154_MUXMODE_UART7_RXD        (0x10u)
#define CONTROL_PINCTRL154_MUXMODE_PR1_PRU1_R3019   (0x40u)
#define CONTROL_PINCTRL154_MUXMODE_GP219            (0x80u)

#define CONTROL_PINCTRL155_MUXMODE_VIN0A_D15_BD7    (0x1u)
#define CONTROL_PINCTRL155_MUXMODE_PR1_MII1_RXD1    (0x4u)
#define CONTROL_PINCTRL155_MUXMODE_PR1_PRU1_R3118   (0x8u)
#define CONTROL_PINCTRL155_MUXMODE_UART7_TXD        (0x10u)
#define CONTROL_PINCTRL155_MUXMODE_PR1_PRU1_R3018   (0x40u)
#define CONTROL_PINCTRL155_MUXMODE_GP220            (0x80u)

#define CONTROL_PINCTRL156_MUXMODE_VIN0A_D16        (0x1u)
#define CONTROL_PINCTRL156_MUXMODE_PR1_MII1_RXD0    (0x4u)
#define CONTROL_PINCTRL156_MUXMODE_PR1_PRU1_R3117   (0x8u)
#define CONTROL_PINCTRL156_MUXMODE_I2C2_SCL         (0x20u)
#define CONTROL_PINCTRL156_MUXMODE_PR1_PRU1_R3017   (0x40u)
#define CONTROL_PINCTRL156_MUXMODE_GP010            (0x80u)

#define CONTROL_PINCTRL157_MUXMODE_VIN0A_D17        (0x1u)
#define CONTROL_PINCTRL157_MUXMODE_PR1_MII_MR1_CLK  (0x4u)
#define CONTROL_PINCTRL157_MUXMODE_EMAC1_RMRXER     (0x8u)
#define CONTROL_PINCTRL157_MUXMODE_GP011            (0x80u)

#define CONTROL_PINCTRL158_MUXMODE_VIN0A_D18        (0x1u)
#define CONTROL_PINCTRL158_MUXMODE_PR1_MII1_COL     (0x4u)
#define CONTROL_PINCTRL158_MUXMODE_EMAC1_RMRXD1     (0x8u)
#define CONTROL_PINCTRL158_MUXMODE_I2C3_SCL         (0x20u)
#define CONTROL_PINCTRL158_MUXMODE_GP012            (0x80u)

#define CONTROL_PINCTRL159_MUXMODE_VIN0A_D19        (0x1u)
#define CONTROL_PINCTRL159_MUXMODE_PR1_MII1_RXER    (0x4u)
#define CONTROL_PINCTRL159_MUXMODE_EMAC1_RMRXD0     (0x8u)
#define CONTROL_PINCTRL159_MUXMODE_I2C3_SDA         (0x20u)
#define CONTROL_PINCTRL159_MUXMODE_GP013            (0x80u)

#define CONTROL_PINCTRL160_MUXMODE_VIN0A_D20        (0x1u)
#define CONTROL_PINCTRL160_MUXMODE_PR1_MII1_RXDV    (0x4u)
#define CONTROL_PINCTRL160_MUXMODE_EMAC1_RMCRSDV    (0x8u)
#define CONTROL_PINCTRL160_MUXMODE_SPI3_SCS0n       (0x20u)
#define CONTROL_PINCTRL160_MUXMODE_GP014            (0x80u)

#define CONTROL_PINCTRL161_MUXMODE_VIN0A_D21        (0x1u)
#define CONTROL_PINCTRL161_MUXMODE_PR1_MII1_TXEN    (0x4u)
#define CONTROL_PINCTRL161_MUXMODE_EMAC1_RMTXD0     (0x8u)
#define CONTROL_PINCTRL161_MUXMODE_SPI3_SCLK        (0x20u)
#define CONTROL_PINCTRL161_MUXMODE_GP015            (0x80u)

#define CONTROL_PINCTRL162_MUXMODE_VIN0A_D22        (0x1u)
#define CONTROL_PINCTRL162_MUXMODE_PR1_MII1_RXLINK  (0x4u)
#define CONTROL_PINCTRL162_MUXMODE_EMAC1_RMTXD1     (0x8u)
#define CONTROL_PINCTRL162_MUXMODE_SPI3_D1          (0x20u)
#define CONTROL_PINCTRL162_MUXMODE_GP016            (0x80u)

#define CONTROL_PINCTRL163_MUXMODE_VIN0A_D23        (0x1u)
#define CONTROL_PINCTRL163_MUXMODE_PR1_MII1_CRS     (0x4u)
#define CONTROL_PINCTRL163_MUXMODE_EMAC1_RMTXEN     (0x8u)
#define CONTROL_PINCTRL163_MUXMODE_SPI3_D0          (0x20u)
#define CONTROL_PINCTRL163_MUXMODE_GP017            (0x80u)

#define CONTROL_PINCTRL164_MUXMODE_VIN0A_DE         (0x1u)
#define CONTROL_PINCTRL164_MUXMODE_VOUT0_VCOM       (0x4u)
#define CONTROL_PINCTRL164_MUXMODE_UART6_RXD        (0x10u)
#define CONTROL_PINCTRL164_MUXMODE_GP018            (0x80u)

#define CONTROL_PINCTRL166_MUXMODE_VIN0A_FLD        (0x1u)
#define CONTROL_PINCTRL166_MUXMODE_VOUT0_LOAD1      (0x4u)
#define CONTROL_PINCTRL166_MUXMODE_UART6_TXD        (0x10u)
#define CONTROL_PINCTRL166_MUXMODE_GP020            (0x80u)

#define CONTROL_PINCTRL168_MUXMODE_VOUT0_LOAD0      (0x4u)
#define CONTROL_PINCTRL168_MUXMODE_GPMC_A5          (0x10u)
#define CONTROL_PINCTRL168_MUXMODE_UART4_RXD        (0x20u)
#define CONTROL_PINCTRL168_MUXMODE_GP022            (0x80u)

#define CONTROL_PINCTRL169_MUXMODE_VOUT0_LOAD2      (0x4u)
#define CONTROL_PINCTRL169_MUXMODE_GPMC_A6          (0x10u)
#define CONTROL_PINCTRL169_MUXMODE_UART4_TXD        (0x20u)
#define CONTROL_PINCTRL169_MUXMODE_GP023            (0x80u)

#define CONTROL_PINCTRL176_MUXMODE_VOUT0_CLK        (0x1u)

#define CONTROL_PINCTRL177_MUXMODE_VOUT0_HSYNC      (0x1u)
#define CONTROL_PINCTRL177_MUXMODE_GP419            (0x80u)

#define CONTROL_PINCTRL178_MUXMODE_VOUT0_VSYNC      (0x1u)
#define CONTROL_PINCTRL178_MUXMODE_VOUT0_LOAD3      (0x4u)
#define CONTROL_PINCTRL178_MUXMODE_GP420            (0x80u)

#define CONTROL_PINCTRL179_MUXMODE_VOUT0_AVID       (0x1u)
#define CONTROL_PINCTRL179_MUXMODE_VOUT0_FLD        (0x2u)
#define CONTROL_PINCTRL179_MUXMODE_SPI3_SCLK        (0x10u)
#define CONTROL_PINCTRL179_MUXMODE_TIM7_IO          (0x40u)
#define CONTROL_PINCTRL179_MUXMODE_GP221            (0x80u)

#define CONTROL_PINCTRL180_MUXMODE_VOUT0_B_CB_C2    (0x1u)
#define CONTROL_PINCTRL180_MUXMODE_EMU2             (0x2u)
#define CONTROL_PINCTRL180_MUXMODE_PR1_PRU1_R300    (0x8u)
#define CONTROL_PINCTRL180_MUXMODE_PR1_PRU1_R310    (0x10u)
#define CONTROL_PINCTRL180_MUXMODE_EHRPWM1A         (0x20u)
#define CONTROL_PINCTRL180_MUXMODE_GP222            (0x80u)
#define CONTROL_PINCTRL180_MUXMODE_HW_DBG0          (0x400u)

#define CONTROL_PINCTRL181_MUXMODE_VOUT0_B_CB_C3    (0x1u)
#define CONTROL_PINCTRL181_MUXMODE_CLKOUT0          (0x2u)
#define CONTROL_PINCTRL181_MUXMODE_PR1_PRU1_R301    (0x8u)
#define CONTROL_PINCTRL181_MUXMODE_PR1_PRU1_R311    (0x10u)
#define CONTROL_PINCTRL181_MUXMODE_UART6_TXD        (0x40u)
#define CONTROL_PINCTRL181_MUXMODE_GP223            (0x80u)
#define CONTROL_PINCTRL181_MUXMODE_HW_DBG1          (0x400u)

#define CONTROL_PINCTRL182_MUXMODE_VOUT0_B_CB_C4    (0x1u)
#define CONTROL_PINCTRL182_MUXMODE_PR1_PRU1_R306    (0x8u)
#define CONTROL_PINCTRL182_MUXMODE_PR1_PRU1_R316    (0x10u)
#define CONTROL_PINCTRL182_MUXMODE_EQEP2_INDEX      (0x20u)
#define CONTROL_PINCTRL182_MUXMODE_GP421            (0x80u)
#define CONTROL_PINCTRL182_MUXMODE_OBS_IRQ0         (0x200u)
#define CONTROL_PINCTRL182_MUXMODE_HW_DBG2          (0x400u)

#define CONTROL_PINCTRL183_MUXMODE_VOUT0_B_CB_C5    (0x1u)
#define CONTROL_PINCTRL183_MUXMODE_GP422            (0x80u)
#define CONTROL_PINCTRL183_MUXMODE_OBS_DMA0         (0x200u)
#define CONTROL_PINCTRL183_MUXMODE_HW_DBG3          (0x400u)

#define CONTROL_PINCTRL184_MUXMODE_VOUT0_B_CB_C6    (0x1u)
#define CONTROL_PINCTRL184_MUXMODE_GP423            (0x80u)
#define CONTROL_PINCTRL184_MUXMODE_OBS_IRQ1         (0x200u)
#define CONTROL_PINCTRL184_MUXMODE_HW_DBG4          (0x400u)

#define CONTROL_PINCTRL185_MUXMODE_VOUT0_B_CB_C7    (0x1u)
#define CONTROL_PINCTRL185_MUXMODE_GP424            (0x80u)
#define CONTROL_PINCTRL185_MUXMODE_OBS_DMA1         (0x200u)
#define CONTROL_PINCTRL185_MUXMODE_HW_DBG5          (0x400u)

#define CONTROL_PINCTRL186_MUXMODE_VOUT0_B_CB_C8    (0x1u)
#define CONTROL_PINCTRL186_MUXMODE_PR1_MII_MT0_CLK  (0x4u)
#define CONTROL_PINCTRL186_MUXMODE_GP425            (0x80u)
#define CONTROL_PINCTRL186_MUXMODE_HW_DBG6          (0x400u)

#define CONTROL_PINCTRL187_MUXMODE_VOUT0_B_CB_C9    (0x1u)
#define CONTROL_PINCTRL187_MUXMODE_PR1_MII0_RXLINK  (0x4u)
#define CONTROL_PINCTRL187_MUXMODE_GP426            (0x80u)
#define CONTROL_PINCTRL187_MUXMODE_HW_DBG7          (0x400u)

#define CONTROL_PINCTRL188_MUXMODE_VOUT0_G_Y_YC2    (0x1u)
#define CONTROL_PINCTRL188_MUXMODE_EMU3             (0x2u)
#define CONTROL_PINCTRL188_MUXMODE_PR1_MII0_COL     (0x4u)
#define CONTROL_PINCTRL188_MUXMODE_PR1_PRU1_R302    (0x8u)
#define CONTROL_PINCTRL188_MUXMODE_PR1_PRU1_R312    (0x10u)
#define CONTROL_PINCTRL188_MUXMODE_EHRPWM1B         (0x20u)
#define CONTROL_PINCTRL188_MUXMODE_GP224            (0x80u)
#define CONTROL_PINCTRL188_MUXMODE_HW_DBG8          (0x400u)

#define CONTROL_PINCTRL189_MUXMODE_VOUT0_G_Y_YC3    (0x1u)
#define CONTROL_PINCTRL189_MUXMODE_EQEP1_STROBE     (0x2u)
#define CONTROL_PINCTRL189_MUXMODE_PR1_MII0_RXER    (0x4u)
#define CONTROL_PINCTRL189_MUXMODE_PR1_PRU1_R303    (0x8u)
#define CONTROL_PINCTRL189_MUXMODE_PR1_PRU1_R313    (0x10u)
#define CONTROL_PINCTRL189_MUXMODE_EHRPWM1_TRIPZONE_INPUT   (0x20u)
#define CONTROL_PINCTRL189_MUXMODE_UART6_RXD        (0x40u)
#define CONTROL_PINCTRL189_MUXMODE_GP225            (0x80u)
#define CONTROL_PINCTRL189_MUXMODE_HW_DBG9          (0x400u)

#define CONTROL_PINCTRL190_MUXMODE_VOUT0_G_Y_YC4    (0x1u)
#define CONTROL_PINCTRL190_MUXMODE_PR1_MII0_TXEN    (0x4u)
#define CONTROL_PINCTRL190_MUXMODE_GP510            (0x80u)
#define CONTROL_PINCTRL190_MUXMODE_HW_DBG10         (0x400u)

#define CONTROL_PINCTRL191_MUXMODE_VOUT0_G_Y_YC5    (0x1u)
#define CONTROL_PINCTRL191_MUXMODE_PR1_MII0_TXD3    (0x4u)
#define CONTROL_PINCTRL191_MUXMODE_GP511            (0x80u)
#define CONTROL_PINCTRL191_MUXMODE_HW_DBG11         (0x400u)

#define CONTROL_PINCTRL192_MUXMODE_VOUT0_G_Y_YC6    (0x1u)
#define CONTROL_PINCTRL192_MUXMODE_PR1_MII0_TXD2    (0x4u)
#define CONTROL_PINCTRL192_MUXMODE_GP512            (0x80u)
#define CONTROL_PINCTRL192_MUXMODE_HW_DBG12         (0x400u)

#define CONTROL_PINCTRL193_MUXMODE_VOUT0_G_Y_YC7    (0x1u)
#define CONTROL_PINCTRL193_MUXMODE_PR1_MII0_TXD1    (0x4u)
#define CONTROL_PINCTRL193_MUXMODE_GP513            (0x80u)
#define CONTROL_PINCTRL193_MUXMODE_HW_DBG13         (0x400u)

#define CONTROL_PINCTRL194_MUXMODE_VOUT0_G_Y_YC8    (0x1u)
#define CONTROL_PINCTRL194_MUXMODE_PR1_MII0_TXD0    (0x4u)
#define CONTROL_PINCTRL194_MUXMODE_GP514            (0x80u)
#define CONTROL_PINCTRL194_MUXMODE_HW_DBG14         (0x400u)

#define CONTROL_PINCTRL195_MUXMODE_VOUT0_G_Y_YC9    (0x1u)
#define CONTROL_PINCTRL195_MUXMODE_PR1_MII_MR0_CLK  (0x4u)
#define CONTROL_PINCTRL195_MUXMODE_GP515            (0x80u)
#define CONTROL_PINCTRL195_MUXMODE_HW_DBG15         (0x400u)

#define CONTROL_PINCTRL196_MUXMODE_VOUT0_R_CR2      (0x1u)
#define CONTROL_PINCTRL196_MUXMODE_EMU4             (0x2u)
#define CONTROL_PINCTRL196_MUXMODE_PR1_MII0_RXDV    (0x4u)
#define CONTROL_PINCTRL196_MUXMODE_PR1_PRU1_R304    (0x8u)
#define CONTROL_PINCTRL196_MUXMODE_PR1_PRU1_R314    (0x10u)
#define CONTROL_PINCTRL196_MUXMODE_EQEP2A_IN        (0x20u)
#define CONTROL_PINCTRL196_MUXMODE_UART6_CTSn       (0x40u)
#define CONTROL_PINCTRL196_MUXMODE_GP226            (0x80u)
#define CONTROL_PINCTRL196_MUXMODE_HW_DBG16         (0x400u)

#define CONTROL_PINCTRL197_MUXMODE_VOUT0_R_CR3      (0x1u)
#define CONTROL_PINCTRL197_MUXMODE_CLKOUT1          (0x2u)
#define CONTROL_PINCTRL197_MUXMODE_PR1_MII0_RXD3    (0x4u)
#define CONTROL_PINCTRL197_MUXMODE_PR1_PRU1_R305    (0x8u)
#define CONTROL_PINCTRL197_MUXMODE_PR1_PRU1_R315    (0x10u)
#define CONTROL_PINCTRL197_MUXMODE_EQEP2B_IN        (0x20u)
#define CONTROL_PINCTRL197_MUXMODE_UART6_RTSn       (0x40u)
#define CONTROL_PINCTRL197_MUXMODE_GP227            (0x80u)
#define CONTROL_PINCTRL197_MUXMODE_HW_DBG17         (0x400u)

#define CONTROL_PINCTRL198_MUXMODE_VOUT0_R_CR4      (0x1u)
#define CONTROL_PINCTRL198_MUXMODE_PR1_MII0_RXD2    (0x4u)
#define CONTROL_PINCTRL198_MUXMODE_PR1_PRU1_R307    (0x8u)
#define CONTROL_PINCTRL198_MUXMODE_PR1_PRU1_R317    (0x10u)
#define CONTROL_PINCTRL198_MUXMODE_EQEP2_STROBE     (0x20u)
#define CONTROL_PINCTRL198_MUXMODE_GP427            (0x80u)
#define CONTROL_PINCTRL198_MUXMODE_HW_DBG18         (0x400u)

#define CONTROL_PINCTRL199_MUXMODE_VOUT0_R_CR5      (0x1u)
#define CONTROL_PINCTRL199_MUXMODE_PR1_MII0_RXD1    (0x4u)
#define CONTROL_PINCTRL199_MUXMODE_GP428            (0x80u)
#define CONTROL_PINCTRL199_MUXMODE_HW_DBG19         (0x400u)

#define CONTROL_PINCTRL200_MUXMODE_VOUT0_R_CR6      (0x1u)
#define CONTROL_PINCTRL200_MUXMODE_PR1_MII0_RXD0    (0x4u)
#define CONTROL_PINCTRL200_MUXMODE_GP429            (0x80u)
#define CONTROL_PINCTRL200_MUXMODE_HW_DBG20         (0x400u)

#define CONTROL_PINCTRL201_MUXMODE_VOUT0_R_CR7      (0x1u)
#define CONTROL_PINCTRL201_MUXMODE_PR1_MII0_CRS     (0x4u)
#define CONTROL_PINCTRL201_MUXMODE_GP430            (0x80u)
#define CONTROL_PINCTRL201_MUXMODE_HW_DBG21         (0x400u)

#define CONTROL_PINCTRL202_MUXMODE_VOUT0_R_CR8      (0x1u)
#define CONTROL_PINCTRL202_MUXMODE_PR1_MDIO_MDCLK   (0x40u)
#define CONTROL_PINCTRL202_MUXMODE_GP431            (0x80u)
#define CONTROL_PINCTRL202_MUXMODE_HW_DBG22         (0x400u)

#define CONTROL_PINCTRL203_MUXMODE_VOUT0_R_CR9      (0x1u)
#define CONTROL_PINCTRL203_MUXMODE_PR1_MDIO_DATA    (0x40u)
#define CONTROL_PINCTRL203_MUXMODE_GP55             (0x80u)
#define CONTROL_PINCTRL203_MUXMODE_HW_DBG23         (0x400u)

#define CONTROL_PINCTRL204_MUXMODE_VOUT1_CLK        (0x1u)
#define CONTROL_PINCTRL204_MUXMODE_EMAC1_MTCLK      (0x2u)
#define CONTROL_PINCTRL204_MUXMODE_VIN1A_HSYNC      (0x4u)
#define CONTROL_PINCTRL204_MUXMODE_GP228            (0x80u)

#define CONTROL_PINCTRL205_MUXMODE_VOUT1_HSYNC      (0x1u)
#define CONTROL_PINCTRL205_MUXMODE_EMAC1_MCOL       (0x2u)
#define CONTROL_PINCTRL205_MUXMODE_VIN1A_VSYNC      (0x4u)
#define CONTROL_PINCTRL205_MUXMODE_SPI3_D1          (0x10u)
#define CONTROL_PINCTRL205_MUXMODE_UART3_RTSn       (0x20u)
#define CONTROL_PINCTRL205_MUXMODE_VOUT1_LOAD0      (0x40u)
#define CONTROL_PINCTRL205_MUXMODE_GP229            (0x80u)

#define CONTROL_PINCTRL206_MUXMODE_VOUT1_VSYNC      (0x1u)
#define CONTROL_PINCTRL206_MUXMODE_EMAC1_MCRS       (0x2u)
#define CONTROL_PINCTRL206_MUXMODE_VIN1A_FLD        (0x4u)
#define CONTROL_PINCTRL206_MUXMODE_VIN1A_DE         (0x8u)
#define CONTROL_PINCTRL206_MUXMODE_SPI3_D0          (0x10u)
#define CONTROL_PINCTRL206_MUXMODE_UART3_CTSn       (0x20u)
#define CONTROL_PINCTRL206_MUXMODE_VOUT1_LOAD3      (0x40u)
#define CONTROL_PINCTRL206_MUXMODE_GP230            (0x80u)

#define CONTROL_PINCTRL207_MUXMODE_VOUT1_AVID       (0x1u)
#define CONTROL_PINCTRL207_MUXMODE_EMAC1_MRXER      (0x2u)
#define CONTROL_PINCTRL207_MUXMODE_VIN1A_CLK        (0x4u)
#define CONTROL_PINCTRL207_MUXMODE_VOUT1_VCOM       (0x10u)
#define CONTROL_PINCTRL207_MUXMODE_UART4_RTSn       (0x20u)
#define CONTROL_PINCTRL207_MUXMODE_TIM6_IO          (0x40u)
#define CONTROL_PINCTRL207_MUXMODE_GP231            (0x80u)

#define CONTROL_PINCTRL208_MUXMODE_VOUT1_B_CB_C3    (0x1u)
#define CONTROL_PINCTRL208_MUXMODE_EMAC1_MRCLK      (0x2u)
#define CONTROL_PINCTRL208_MUXMODE_VIN1A_D0         (0x4u)
#define CONTROL_PINCTRL208_MUXMODE_PR1_UART0_CTS_N  (0x8u)
#define CONTROL_PINCTRL208_MUXMODE_UART4_CTSn       (0x20u)
#define CONTROL_PINCTRL208_MUXMODE_VOUT1_LOAD1      (0x40u)
#define CONTROL_PINCTRL208_MUXMODE_GP30             (0x80u)

#define CONTROL_PINCTRL209_MUXMODE_VOUT1_B_CB_C4    (0x1u)
#define CONTROL_PINCTRL209_MUXMODE_EMAC1_MRXD0      (0x2u)
#define CONTROL_PINCTRL209_MUXMODE_VIN1A_D1         (0x4u)
#define CONTROL_PINCTRL209_MUXMODE_UART4_RXD        (0x20u)
#define CONTROL_PINCTRL209_MUXMODE_GP31             (0x80u)

#define CONTROL_PINCTRL210_MUXMODE_VOUT1_B_CB_C5    (0x1u)
#define CONTROL_PINCTRL210_MUXMODE_EMAC1_MRXD1      (0x2u)
#define CONTROL_PINCTRL210_MUXMODE_VIN1A_D2         (0x4u)
#define CONTROL_PINCTRL210_MUXMODE_UART4_TXD        (0x20u)
#define CONTROL_PINCTRL210_MUXMODE_GP32             (0x80u)

#define CONTROL_PINCTRL211_MUXMODE_VOUT1_B_CB_C6    (0x1u)
#define CONTROL_PINCTRL211_MUXMODE_EMAC1_MRXD2      (0x2u)
#define CONTROL_PINCTRL211_MUXMODE_VIN1A_D3         (0x4u)
#define CONTROL_PINCTRL211_MUXMODE_UART3_RXD        (0x20u)
#define CONTROL_PINCTRL211_MUXMODE_GP33             (0x80u)

#define CONTROL_PINCTRL212_MUXMODE_VOUT1_B_CB_C7    (0x1u)
#define CONTROL_PINCTRL212_MUXMODE_EMAC1_MRXD3      (0x2u)
#define CONTROL_PINCTRL212_MUXMODE_VIN1A_D4         (0x4u)
#define CONTROL_PINCTRL212_MUXMODE_UART3_TXD        (0x20u)
#define CONTROL_PINCTRL212_MUXMODE_GP34             (0x80u)

#define CONTROL_PINCTRL213_MUXMODE_VOUT1_B_CB_C8    (0x1u)
#define CONTROL_PINCTRL213_MUXMODE_EMAC1_MRXD4      (0x2u)
#define CONTROL_PINCTRL213_MUXMODE_VIN1A_D5         (0x4u)
#define CONTROL_PINCTRL213_MUXMODE_PR1_EDIO_DATA_OUT0   (0x10u)
#define CONTROL_PINCTRL213_MUXMODE_I2C3_SCL         (0x20u)
#define CONTROL_PINCTRL213_MUXMODE_GP35             (0x80u)
#define CONTROL_PINCTRL213_MUXMODE_PR1_EDIO_DATA_IN0    (0x200u)

#define CONTROL_PINCTRL214_MUXMODE_VOUT1_B_CB_C9    (0x1u)
#define CONTROL_PINCTRL214_MUXMODE_EMAC1_MRXD5      (0x2u)
#define CONTROL_PINCTRL214_MUXMODE_VIN1A_D6         (0x4u)
#define CONTROL_PINCTRL214_MUXMODE_PR1_EDIO_DATA_OUT1   (0x10u)
#define CONTROL_PINCTRL214_MUXMODE_I2C3_SDA         (0x20u)
#define CONTROL_PINCTRL214_MUXMODE_GP36             (0x80u)
#define CONTROL_PINCTRL214_MUXMODE_PR1_EDIO_DATA_IN1    (0x200u)

#define CONTROL_PINCTRL215_MUXMODE_VOUT1_G_Y_YC3    (0x1u)
#define CONTROL_PINCTRL215_MUXMODE_EMAC1_MRXD6      (0x2u)
#define CONTROL_PINCTRL215_MUXMODE_VIN1A_D8         (0x4u)
#define CONTROL_PINCTRL215_MUXMODE_PR1_EDIO_DATA_OUT2   (0x10u)
#define CONTROL_PINCTRL215_MUXMODE_PR1_PRU1_R308    (0x20u)
#define CONTROL_PINCTRL215_MUXMODE_PR1_PRU1_R318    (0x40u)
#define CONTROL_PINCTRL215_MUXMODE_GP37             (0x80u)
#define CONTROL_PINCTRL215_MUXMODE_PR1_EDIO_DATA_IN2    (0x200u)

#define CONTROL_PINCTRL216_MUXMODE_VOUT1_G_Y_YC4    (0x1u)
#define CONTROL_PINCTRL216_MUXMODE_EMAC1_MRXD7      (0x2u)
#define CONTROL_PINCTRL216_MUXMODE_VIN1A_D9         (0x4u)
#define CONTROL_PINCTRL216_MUXMODE_PR1_EDIO_DATA_OUT3   (0x10u)
#define CONTROL_PINCTRL216_MUXMODE_PR1_PRU1_R309    (0x20u)
#define CONTROL_PINCTRL216_MUXMODE_PR1_PRU1_R319    (0x40u)
#define CONTROL_PINCTRL216_MUXMODE_GP38             (0x80u)
#define CONTROL_PINCTRL216_MUXMODE_PR1_EDIO_DATA_IN3    (0x200u)
#define CONTROL_PINCTRL216_MUXMODE_UART2_RXD        (0x400u)

#define CONTROL_PINCTRL217_MUXMODE_VOUT1_G_Y_YC5    (0x1u)
#define CONTROL_PINCTRL217_MUXMODE_EMAC1_MRXDV      (0x2u)
#define CONTROL_PINCTRL217_MUXMODE_VIN1A_D10        (0x4u)
#define CONTROL_PINCTRL217_MUXMODE_PR1_EDIO_DATA_OUT4   (0x10u)
#define CONTROL_PINCTRL217_MUXMODE_PR1_PRU1_R3010   (0x20u)
#define CONTROL_PINCTRL217_MUXMODE_PR1_PRU1_R3110   (0x40u)
#define CONTROL_PINCTRL217_MUXMODE_GP39             (0x80u)
#define CONTROL_PINCTRL217_MUXMODE_PR1_EDIO_DATA_IN4    (0x200u)
#define CONTROL_PINCTRL217_MUXMODE_UART2_TXD        (0x400u)

#define CONTROL_PINCTRL218_MUXMODE_VOUT1_G_Y_YC6    (0x1u)
#define CONTROL_PINCTRL218_MUXMODE_EMAC1_GMTCLK     (0x2u)
#define CONTROL_PINCTRL218_MUXMODE_VIN1A_D11        (0x4u)
#define CONTROL_PINCTRL218_MUXMODE_PR1_EDIO_DATA_OUT5   (0x10u)
#define CONTROL_PINCTRL218_MUXMODE_PR1_PRU1_R3011   (0x20u)
#define CONTROL_PINCTRL218_MUXMODE_PR1_PRU1_R3111   (0x40u)
#define CONTROL_PINCTRL218_MUXMODE_GP310            (0x80u)
#define CONTROL_PINCTRL218_MUXMODE_PR1_EDIO_DATA_IN5    (0x200u)
#define CONTROL_PINCTRL218_MUXMODE_UART7_RTSn       (0x400u)

#define CONTROL_PINCTRL219_MUXMODE_VOUT1_G_Y_YC7    (0x1u)
#define CONTROL_PINCTRL219_MUXMODE_EMAC1_MTXD0      (0x2u)
#define CONTROL_PINCTRL219_MUXMODE_VIN1A_D12        (0x4u)
#define CONTROL_PINCTRL219_MUXMODE_PR1_EDIO_DATA_OUT6   (0x10u)
#define CONTROL_PINCTRL219_MUXMODE_PR1_PRU1_R3012   (0x20u)
#define CONTROL_PINCTRL219_MUXMODE_PR1_PRU1_R3112   (0x40u)
#define CONTROL_PINCTRL219_MUXMODE_GP311            (0x80u)
#define CONTROL_PINCTRL219_MUXMODE_PR1_EDIO_DATA_IN6    (0x200u)
#define CONTROL_PINCTRL219_MUXMODE_UART7_CTSn       (0x400u)

#define CONTROL_PINCTRL220_MUXMODE_VOUT1_G_Y_YC8    (0x1u)
#define CONTROL_PINCTRL220_MUXMODE_EMAC1_MTXD1      (0x2u)
#define CONTROL_PINCTRL220_MUXMODE_VIN1A_D13        (0x4u)
#define CONTROL_PINCTRL220_MUXMODE_PR1_EDIO_DATA_OUT7   (0x10u)
#define CONTROL_PINCTRL220_MUXMODE_PR1_PRU1_R3013   (0x20u)
#define CONTROL_PINCTRL220_MUXMODE_PR1_PRU1_R3113   (0x40u)
#define CONTROL_PINCTRL220_MUXMODE_GP312            (0x80u)
#define CONTROL_PINCTRL220_MUXMODE_PR1_EDIO_DATA_IN7    (0x200u)
#define CONTROL_PINCTRL220_MUXMODE_UART7_RXD        (0x400u)

#define CONTROL_PINCTRL221_MUXMODE_VOUT1_G_Y_YC9    (0x1u)
#define CONTROL_PINCTRL221_MUXMODE_EMAC1_MTXD2      (0x2u)
#define CONTROL_PINCTRL221_MUXMODE_VIN1A_D14        (0x4u)
#define CONTROL_PINCTRL221_MUXMODE_PR1_EDIO_SOF     (0x10u)
#define CONTROL_PINCTRL221_MUXMODE_GP313            (0x80u)
#define CONTROL_PINCTRL221_MUXMODE_PR1_UART0_CTS_N  (0x200u)
#define CONTROL_PINCTRL221_MUXMODE_UART7_TXD        (0x400u)

#define CONTROL_PINCTRL222_MUXMODE_VOUT1_R_CR4      (0x1u)
#define CONTROL_PINCTRL222_MUXMODE_EMAC1_MTXD3      (0x2u)
#define CONTROL_PINCTRL222_MUXMODE_VIN1A_D15        (0x4u)
#define CONTROL_PINCTRL222_MUXMODE_PR1_EDIO_LATCH_IN    (0x10u)
#define CONTROL_PINCTRL222_MUXMODE_SPI3_SCS1n       (0x20u)
#define CONTROL_PINCTRL222_MUXMODE_GP314            (0x80u)
#define CONTROL_PINCTRL222_MUXMODE_PR1_UART0_RTS_N  (0x200u)

#define CONTROL_PINCTRL223_MUXMODE_VOUT1_R_CR5      (0x1u)
#define CONTROL_PINCTRL223_MUXMODE_EMAC1_MTXD4      (0x2u)
#define CONTROL_PINCTRL223_MUXMODE_VIN1A_D16        (0x4u)
#define CONTROL_PINCTRL223_MUXMODE_SPI3_SCLK        (0x20u)
#define CONTROL_PINCTRL223_MUXMODE_GP315            (0x80u)
#define CONTROL_PINCTRL223_MUXMODE_PR1_UART0_RXD    (0x200u)

#define CONTROL_PINCTRL224_MUXMODE_VOUT1_R_CR6      (0x1u)
#define CONTROL_PINCTRL224_MUXMODE_EMAC1_MTXD5      (0x2u)
#define CONTROL_PINCTRL224_MUXMODE_VIN1A_D17        (0x4u)
#define CONTROL_PINCTRL224_MUXMODE_SPI3_D1          (0x20u)
#define CONTROL_PINCTRL224_MUXMODE_GP316            (0x80u)
#define CONTROL_PINCTRL224_MUXMODE_PR1_UART0_TXD    (0x200u)

#define CONTROL_PINCTRL225_MUXMODE_VOUT1_R_CR7      (0x1u)
#define CONTROL_PINCTRL225_MUXMODE_EMAC1_MTXD6      (0x2u)
#define CONTROL_PINCTRL225_MUXMODE_VIN1A_D18        (0x4u)
#define CONTROL_PINCTRL225_MUXMODE_SPI3_D0          (0x20u)
#define CONTROL_PINCTRL225_MUXMODE_GP317            (0x80u)
#define CONTROL_PINCTRL225_MUXMODE_PR1_EDC_LATCH0_IN    (0x100u)
#define CONTROL_PINCTRL225_MUXMODE_TIMER4_IO        (0x400u)

#define CONTROL_PINCTRL226_MUXMODE_VOUT1_R_CR8      (0x1u)
#define CONTROL_PINCTRL226_MUXMODE_EMAC1_MTXD7      (0x2u)
#define CONTROL_PINCTRL226_MUXMODE_VIN1A_D19        (0x4u)
#define CONTROL_PINCTRL226_MUXMODE_UART5_RXD        (0x20u)
#define CONTROL_PINCTRL226_MUXMODE_GP318            (0x80u)
#define CONTROL_PINCTRL226_MUXMODE_PR1_EDC_LATCH1_IN    (0x100u)
#define CONTROL_PINCTRL226_MUXMODE_PR1_UART0_RTS_N  (0x200u)
#define CONTROL_PINCTRL226_MUXMODE_TIMER5_IO        (0x400u)

#define CONTROL_PINCTRL227_MUXMODE_VOUT1_R_CR9      (0x1u)
#define CONTROL_PINCTRL227_MUXMODE_EMAC1_MTXEN      (0x2u)
#define CONTROL_PINCTRL227_MUXMODE_VIN1A_D20        (0x4u)
#define CONTROL_PINCTRL227_MUXMODE_UART5_TXD        (0x20u)
#define CONTROL_PINCTRL227_MUXMODE_GP319            (0x80u)

#define CONTROL_PINCTRL228_MUXMODE_VOUT1_G_Y_YC2    (0x1u)
#define CONTROL_PINCTRL228_MUXMODE_GPMC_A13         (0x2u)
#define CONTROL_PINCTRL228_MUXMODE_VIN1A_D21        (0x4u)
#define CONTROL_PINCTRL228_MUXMODE_SPI2_SCS2n       (0x20u)
#define CONTROL_PINCTRL228_MUXMODE_I2C2_SCL         (0x40u)
#define CONTROL_PINCTRL228_MUXMODE_GP320            (0x80u)
#define CONTROL_PINCTRL228_MUXMODE_PR1_EDC_SYNC0_OUT    (0x100u)
#define CONTROL_PINCTRL228_MUXMODE_PR1_UART0_RXD    (0x200u)

#define CONTROL_PINCTRL229_MUXMODE_VOUT1_R_CR3      (0x1u)
#define CONTROL_PINCTRL229_MUXMODE_GPMC_A14         (0x2u)
#define CONTROL_PINCTRL229_MUXMODE_VIN1A_D22        (0x4u)
#define CONTROL_PINCTRL229_MUXMODE_SPI2_SCLK        (0x20u)
#define CONTROL_PINCTRL229_MUXMODE_I2C2_SDA         (0x40u)
#define CONTROL_PINCTRL229_MUXMODE_GP321            (0x80u)
#define CONTROL_PINCTRL229_MUXMODE_PR1_EDC_SYNC1_OUT    (0x100u)
#define CONTROL_PINCTRL229_MUXMODE_PR1_UART0_TXD    (0x200u)

#define CONTROL_PINCTRL230_MUXMODE_VOUT1_R_CR2      (0x1u)
#define CONTROL_PINCTRL230_MUXMODE_GPMC_A15         (0x2u)
#define CONTROL_PINCTRL230_MUXMODE_VIN1A_D23        (0x4u)
#define CONTROL_PINCTRL230_MUXMODE_SPI2_D1          (0x20u)
#define CONTROL_PINCTRL230_MUXMODE_VOUT1_LOAD2      (0x40u)
#define CONTROL_PINCTRL230_MUXMODE_GP322            (0x80u)

#define CONTROL_PINCTRL231_MUXMODE_VOUT1_B_CB_C2    (0x1u)
#define CONTROL_PINCTRL231_MUXMODE_GPMC_A0          (0x2u)
#define CONTROL_PINCTRL231_MUXMODE_VIN1A_D7         (0x4u)
#define CONTROL_PINCTRL231_MUXMODE_SPI2_D0          (0x20u)
#define CONTROL_PINCTRL231_MUXMODE_GP330            (0x80u)

#define CONTROL_PINCTRL232_MUXMODE_EMAC_RMREFCLK    (0x1u)
#define CONTROL_PINCTRL232_MUXMODE_TIM2_IO          (0x40u)
#define CONTROL_PINCTRL232_MUXMODE_GP110            (0x80u)

#define CONTROL_PINCTRL233_MUXMODE_MDCLK            (0x1u)
#define CONTROL_PINCTRL233_MUXMODE_GP111            (0x80u)

#define CONTROL_PINCTRL234_MUXMODE_MDIO             (0x1u)
#define CONTROL_PINCTRL234_MUXMODE_GP112            (0x80u)

#define CONTROL_PINCTRL235_MUXMODE_EMAC0_MTCLK      (0x1u)
#define CONTROL_PINCTRL235_MUXMODE_VIN1B_D0         (0x2u)
#define CONTROL_PINCTRL235_MUXMODE_SPI3_SCS3n       (0x20u)
#define CONTROL_PINCTRL235_MUXMODE_I2C2_SDA         (0x40u)
#define CONTROL_PINCTRL235_MUXMODE_GP323            (0x80u)

#define CONTROL_PINCTRL236_MUXMODE_EMAC0_MCOL       (0x1u)
#define CONTROL_PINCTRL236_MUXMODE_VIN1B_D1         (0x2u)
#define CONTROL_PINCTRL236_MUXMODE_EMAC0_RMRXD0     (0x4u)
#define CONTROL_PINCTRL236_MUXMODE_GP324            (0x80u)

#define CONTROL_PINCTRL237_MUXMODE_EMAC0_MCRS       (0x1u)
#define CONTROL_PINCTRL237_MUXMODE_VIN1B_D2         (0x2u)
#define CONTROL_PINCTRL237_MUXMODE_EMAC0_RMRXD1     (0x4u)
#define CONTROL_PINCTRL237_MUXMODE_GP325            (0x80u)

#define CONTROL_PINCTRL238_MUXMODE_EMAC0_MRXER      (0x1u)
#define CONTROL_PINCTRL238_MUXMODE_VIN1B_D3         (0x2u)
#define CONTROL_PINCTRL238_MUXMODE_EMAC0_RMRXER     (0x4u)
#define CONTROL_PINCTRL238_MUXMODE_GP326            (0x80u)

#define CONTROL_PINCTRL239_MUXMODE_EMAC0_MRCLK      (0x1u)
#define CONTROL_PINCTRL239_MUXMODE_VIN1B_D4         (0x2u)
#define CONTROL_PINCTRL239_MUXMODE_EMAC0_RMCRSDV    (0x4u)
#define CONTROL_PINCTRL239_MUXMODE_SPI3_SCS2n       (0x20u)
#define CONTROL_PINCTRL239_MUXMODE_GP327            (0x80u)

#define CONTROL_PINCTRL240_MUXMODE_EMAC0_MRXD0      (0x1u)
#define CONTROL_PINCTRL240_MUXMODE_VIN1B_D5         (0x2u)
#define CONTROL_PINCTRL240_MUXMODE_EMAC0_RMTXD0     (0x4u)
#define CONTROL_PINCTRL240_MUXMODE_GP328            (0x80u)

#define CONTROL_PINCTRL241_MUXMODE_EMAC0_MRXD1      (0x1u)
#define CONTROL_PINCTRL241_MUXMODE_VIN1B_D6         (0x2u)
#define CONTROL_PINCTRL241_MUXMODE_EMAC0_RMTXD1     (0x4u)
#define CONTROL_PINCTRL241_MUXMODE_GP329            (0x80u)

#define CONTROL_PINCTRL242_MUXMODE_EMAC0_MRXD2      (0x1u)
#define CONTROL_PINCTRL242_MUXMODE_VIN1B_D7         (0x2u)
#define CONTROL_PINCTRL242_MUXMODE_EMAC0_RMTXEN     (0x4u)
#define CONTROL_PINCTRL242_MUXMODE_GP330            (0x80u)

#define CONTROL_PINCTRL243_MUXMODE_EMAC0_MRXD3      (0x1u)
#define CONTROL_PINCTRL243_MUXMODE_GPMC_A27         (0x4u)
#define CONTROL_PINCTRL243_MUXMODE_GPMC_A26         (0x8u)
#define CONTROL_PINCTRL243_MUXMODE_GPMC_A0          (0x10u)
#define CONTROL_PINCTRL243_MUXMODE_UART5_RXD        (0x20u)
#define CONTROL_PINCTRL243_MUXMODE_GP516            (0x80u)

#define CONTROL_PINCTRL244_MUXMODE_EMAC0_MRXD4      (0x1u)
#define CONTROL_PINCTRL244_MUXMODE_GPMC_A1          (0x10u)
#define CONTROL_PINCTRL244_MUXMODE_UART5_TXD        (0x20u)
#define CONTROL_PINCTRL244_MUXMODE_GP517            (0x80u)

#define CONTROL_PINCTRL245_MUXMODE_EMAC0_MRXD5      (0x1u)
#define CONTROL_PINCTRL245_MUXMODE_GPMC_A2          (0x10u)
#define CONTROL_PINCTRL245_MUXMODE_UART5_CTSn       (0x20u)
#define CONTROL_PINCTRL245_MUXMODE_GP518            (0x80u)

#define CONTROL_PINCTRL246_MUXMODE_EMAC0_MRXD6      (0x1u)
#define CONTROL_PINCTRL246_MUXMODE_GPMC_A3          (0x10u)
#define CONTROL_PINCTRL246_MUXMODE_UART5_RTSn       (0x20u)
#define CONTROL_PINCTRL246_MUXMODE_GP519            (0x80u)

#define CONTROL_PINCTRL247_MUXMODE_EMAC0_MRXD7      (0x1u)
#define CONTROL_PINCTRL247_MUXMODE_GPMC_A4          (0x10u)
#define CONTROL_PINCTRL247_MUXMODE_SPI2_SCS3n       (0x20u)
#define CONTROL_PINCTRL247_MUXMODE_GP520            (0x80u)

#define CONTROL_PINCTRL248_MUXMODE_EMAC0_MRXDV      (0x1u)
#define CONTROL_PINCTRL248_MUXMODE_GPMC_A5          (0x10u)
#define CONTROL_PINCTRL248_MUXMODE_SPI2_SCLK        (0x20u)
#define CONTROL_PINCTRL248_MUXMODE_GP521            (0x80u)

#define CONTROL_PINCTRL249_MUXMODE_EMAC0_GMTCLK     (0x1u)
#define CONTROL_PINCTRL249_MUXMODE_GPMC_A6          (0x10u)
#define CONTROL_PINCTRL249_MUXMODE_SPI2_D1          (0x20u)
#define CONTROL_PINCTRL249_MUXMODE_GP522            (0x80u)

#define CONTROL_PINCTRL250_MUXMODE_EMAC0_MTXD0      (0x1u)
#define CONTROL_PINCTRL250_MUXMODE_GPMC_A7          (0x10u)
#define CONTROL_PINCTRL250_MUXMODE_SPI2_D0          (0x20u)
#define CONTROL_PINCTRL250_MUXMODE_GP523            (0x80u)

#define CONTROL_PINCTRL251_MUXMODE_EMAC0_MTXD1      (0x1u)
#define CONTROL_PINCTRL251_MUXMODE_GPMC_A8          (0x10u)
#define CONTROL_PINCTRL251_MUXMODE_UART4_RXD        (0x20u)
#define CONTROL_PINCTRL251_MUXMODE_GP524            (0x80u)

#define CONTROL_PINCTRL252_MUXMODE_EMAC0_MTXD2      (0x1u)
#define CONTROL_PINCTRL252_MUXMODE_EMAC1_RMRXD0     (0x2u)
#define CONTROL_PINCTRL252_MUXMODE_GPMC_A9          (0x10u)
#define CONTROL_PINCTRL252_MUXMODE_UART4_TXD        (0x20u)
#define CONTROL_PINCTRL252_MUXMODE_EHRPWM2A         (0x40u)
#define CONTROL_PINCTRL252_MUXMODE_GP525            (0x80u)

#define CONTROL_PINCTRL253_MUXMODE_EMAC0_MTXD3      (0x1u)
#define CONTROL_PINCTRL253_MUXMODE_EMAC1_RMRXD1     (0x2u)
#define CONTROL_PINCTRL253_MUXMODE_GPMC_A10         (0x10u)
#define CONTROL_PINCTRL253_MUXMODE_UART4_CTSn       (0x20u)
#define CONTROL_PINCTRL253_MUXMODE_EHRPWM2B         (0x40u)
#define CONTROL_PINCTRL253_MUXMODE_GP526            (0x80u)

#define CONTROL_PINCTRL254_MUXMODE_EMAC0_MTXD4      (0x1u)
#define CONTROL_PINCTRL254_MUXMODE_EMAC1_RMRXER     (0x2u)
#define CONTROL_PINCTRL254_MUXMODE_GPMC_A11         (0x10u)
#define CONTROL_PINCTRL254_MUXMODE_UART4_RTSn       (0x20u)
#define CONTROL_PINCTRL254_MUXMODE_EHRPWM2_TRIPZONE_INPUT   (0x40u)
#define CONTROL_PINCTRL254_MUXMODE_GP527            (0x80u)

#define CONTROL_PINCTRL255_MUXMODE_EMAC0_MTXD5      (0x1u)
#define CONTROL_PINCTRL255_MUXMODE_EMAC1_RMCRSDV    (0x2u)
#define CONTROL_PINCTRL255_MUXMODE_GPMC_A12         (0x10u)
#define CONTROL_PINCTRL255_MUXMODE_UART1_RXD        (0x20u)
#define CONTROL_PINCTRL255_MUXMODE_GP528            (0x80u)

#define CONTROL_PINCTRL256_MUXMODE_EMAC0_MTXD6      (0x1u)
#define CONTROL_PINCTRL256_MUXMODE_EMAC1_RMTXD0     (0x2u)
#define CONTROL_PINCTRL256_MUXMODE_GPMC_A13         (0x10u)
#define CONTROL_PINCTRL256_MUXMODE_UART1_TXD        (0x20u)
#define CONTROL_PINCTRL256_MUXMODE_EQEP1A_IN        (0x40u)
#define CONTROL_PINCTRL256_MUXMODE_GP529            (0x80u)

#define CONTROL_PINCTRL257_MUXMODE_EMAC0_MTXD7      (0x1u)
#define CONTROL_PINCTRL257_MUXMODE_EMAC1_RMTXD1     (0x2u)
#define CONTROL_PINCTRL257_MUXMODE_GPMC_A14         (0x10u)
#define CONTROL_PINCTRL257_MUXMODE_UART1_CTSn       (0x20u)
#define CONTROL_PINCTRL257_MUXMODE_EQEP1B_IN        (0x40u)
#define CONTROL_PINCTRL257_MUXMODE_GP530            (0x80u)

#define CONTROL_PINCTRL258_MUXMODE_EMAC0_MTXEN      (0x1u)
#define CONTROL_PINCTRL258_MUXMODE_EMAC1_RMTXEN     (0x2u)
#define CONTROL_PINCTRL258_MUXMODE_GPMC_A15         (0x10u)
#define CONTROL_PINCTRL258_MUXMODE_UART1_RTSn       (0x20u)
#define CONTROL_PINCTRL258_MUXMODE_EQEP1_INDEX      (0x40u)
#define CONTROL_PINCTRL258_MUXMODE_GP531            (0x80u)

#define CONTROL_PINCTRL260_MUXMODE_RESETn           (0x1u)

#define CONTROL_PINCTRL261_MUXMODE_NMIn             (0x1u)

#define CONTROL_PINCTRL262_MUXMODE_RSTOUT_WD_OUTn   (0x1u)

#define CONTROL_PINCTRL263_MUXMODE_I2C0_SCL         (0x1u)

#define CONTROL_PINCTRL264_MUXMODE_I2C0_SDA         (0x1u)

#define CONTROL_PINCTRL270_MUXMODE_USB0_DRVVBUS     (0x1u)
#define CONTROL_PINCTRL270_MUXMODE_GP07             (0x2u)

/** @brief CQDETECT_STATUS register fields */
#define CONTROL_CQDETECT_STATUS_CQERR_GEMAC_A       (0x00000800u)
#define CONTROL_CQDETECT_STATUS_CQERR_GEMAC_A_SHIFT (0x0000000Bu)

#define CONTROL_CQDETECT_STATUS_CQERR_GEMAC_B       (0x00001000u)
#define CONTROL_CQDETECT_STATUS_CQERR_GEMAC_B_SHIFT (0x0000000Cu)

#define CONTROL_CQDETECT_STATUS_CQERR_GENERAL       (0x00002000u)
#define CONTROL_CQDETECT_STATUS_CQERR_GENERAL_SHIFT (0x0000000Du)

#define CONTROL_CQDETECT_STATUS_CQERR_GPMC          (0x00000100u)
#define CONTROL_CQDETECT_STATUS_CQERR_GPMC_SHIFT    (0x00000008u)

#define CONTROL_CQDETECT_STATUS_CQERR_MMCSD_A       (0x00000200u)
#define CONTROL_CQDETECT_STATUS_CQERR_MMCSD_A_SHIFT (0x00000009u)

#define CONTROL_CQDETECT_STATUS_CQERR_MMCSD_B       (0x00000400u)
#define CONTROL_CQDETECT_STATUS_CQERR_MMCSD_B_SHIFT (0x0000000Au)

#define CONTROL_CQDETECT_STATUS_CQMODE_GEMAC_A      (0x00080000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_GEMAC_A_SHIFT    (0x00000013u)

#define CONTROL_CQDETECT_STATUS_CQMODE_GEMAC_B      (0x00100000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_GEMAC_B_SHIFT    (0x00000014u)

#define CONTROL_CQDETECT_STATUS_CQMODE_GENERAL      (0x00200000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_GENERAL_SHIFT    (0x00000015u)

#define CONTROL_CQDETECT_STATUS_CQMODE_GPMC         (0x00010000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_GPMC_SHIFT   (0x00000010u)

#define CONTROL_CQDETECT_STATUS_CQMODE_MMCSD_A      (0x00020000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_MMCSD_A_SHIFT    (0x00000011u)

#define CONTROL_CQDETECT_STATUS_CQMODE_MMCSD_B      (0x00040000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_MMCSD_B_SHIFT    (0x00000012u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_GEMAC_A      (0x00000008u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_GEMAC_A_SHIFT    (0x00000003u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_GEMAC_B      (0x00000010u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_GEMAC_B_SHIFT    (0x00000004u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_GENERAL      (0x00000020u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_GENERAL_SHIFT    (0x00000005u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_GPMC         (0x00000001u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_GPMC_SHIFT   (0x00000000u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_MMCSD_A      (0x00000002u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_MMCSD_A_SHIFT    (0x00000001u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_MMCSD_B      (0x00000004u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_MMCSD_B_SHIFT    (0x00000002u)

/** @brief DDR_IO_CTRL register fields */
#define CONTROL_DDR_IO_CTRL_DDR3_RST_DEF_VAL        (0x80000000u)
#define CONTROL_DDR_IO_CTRL_DDR3_RST_DEF_VAL_SHIFT  (0x0000001Fu)

#define CONTROL_DDR_IO_CTRL_DDR_WUCLK_DISABLE       (0x40000000u)
#define CONTROL_DDR_IO_CTRL_DDR_WUCLK_DISABLE_SHIFT (0x0000001Eu)

#define CONTROL_DDR_IO_CTRL_MDDR_SEL                (0x10000000u)
#define CONTROL_DDR_IO_CTRL_MDDR_SEL_SHIFT          (0x0000001Cu)

/** @brief VTP_CTRL register fields */
#define CONTROL_VTP_CTRL_CLRZ                       (0x00000001u)
#define CONTROL_VTP_CTRL_CLRZ_SHIFT                 (0x00000000u)

#define CONTROL_VTP_CTRL_ENABLE                     (0x00000040u)
#define CONTROL_VTP_CTRL_ENABLE_SHIFT               (0x00000006u)

#define CONTROL_VTP_CTRL_FILTER                     (0x0000000Eu)
#define CONTROL_VTP_CTRL_FILTER_SHIFT               (0x00000001u)

#define CONTROL_VTP_CTRL_LOCK                       (0x00000010u)
#define CONTROL_VTP_CTRL_LOCK_SHIFT                 (0x00000004u)

#define CONTROL_VTP_CTRL_NCIN                       (0x00007F00u)
#define CONTROL_VTP_CTRL_NCIN_SHIFT                 (0x00000008u)

#define CONTROL_VTP_CTRL_PCIN                       (0x007F0000u)
#define CONTROL_VTP_CTRL_PCIN_SHIFT                 (0x00000010u)

#define CONTROL_VTP_CTRL_READY                      (0x00000020u)
#define CONTROL_VTP_CTRL_READY_SHIFT                (0x00000005u)

/** @brief VREF_CTRL register fields */
#define CONTROL_VREF_CTRL_DDR_VREF_CCAP             (0x00000018u)
#define CONTROL_VREF_CTRL_DDR_VREF_CCAP_SHIFT       (0x00000003u)

#define CONTROL_VREF_CTRL_DDR_VREF_EN               (0x00000001u)
#define CONTROL_VREF_CTRL_DDR_VREF_EN_SHIFT         (0x00000000u)

#define CONTROL_VREF_CTRL_DDR_VREF_TAP              (0x00000006u)
#define CONTROL_VREF_CTRL_DDR_VREF_TAP_SHIFT        (0x00000001u)

/** @brief CONTROL_MLBP_SIG_IO_CTRL register fields */
#define CONTROL_MLBP_SIG_IO_CTRL_NC_IN              (0x003F0000u)
#define CONTROL_MLBP_SIG_IO_CTRL_NC_IN_SHIFT        (0x10u)

#define CONTROL_MLBP_SIG_IO_CTRL_PC_IN              (0x00003F00u)
#define CONTROL_MLBP_SIG_IO_CTRL_PC_IN_SHIFT        (0x8u)

#define CONTROL_MLBP_SIG_IO_CTRL_PWRDNRX            (0x00000020u)
#define CONTROL_MLBP_SIG_IO_CTRL_PWRDNRX_SHIFT      (0x5u)

#define CONTROL_MLBP_SIG_IO_CTRL_PWRDNTX            (0x00000010u)
#define CONTROL_MLBP_SIG_IO_CTRL_PWRDNTX_SHIFT      (0x4u)

#define CONTROL_MLBP_SIG_IO_CTRL_EN_EXT_RES         (0x00000008u)
#define CONTROL_MLBP_SIG_IO_CTRL_EN_EXT_RES_SHIFT   (0x3u)

#define CONTROL_MLBP_SIG_IO_CTRL_ENLVCMOS           (0x00000004u)
#define CONTROL_MLBP_SIG_IO_CTRL_ENLVCMOS_SHIFT     (0x2u)

#define CONTROL_MLBP_SIG_IO_CTRL_ENN                (0x00000002u)
#define CONTROL_MLBP_SIG_IO_CTRL_ENN_SHIFT          (0x1u)

#define CONTROL_MLBP_SIG_IO_CTRL_ENP                (0x00000001u)
#define CONTROL_MLBP_SIG_IO_CTRL_ENP_SHIFT          (0x0u)

/** @brief CONTROL_MLBP_DAT_IO_CTRL register fields */
#define CONTROL_MLBP_DAT_IO_CTRL_NC_IN              (0x003F0000u)
#define CONTROL_MLBP_DAT_IO_CTRL_NC_IN_SHIFT        (0x10u)

#define CONTROL_MLBP_DAT_IO_CTRL_PC_IN              (0x00003F00u)
#define CONTROL_MLBP_DAT_IO_CTRL_PC_IN_SHIFT        (0x8u)

#define CONTROL_MLBP_DAT_IO_CTRL_PWRDNRX            (0x00000020u)
#define CONTROL_MLBP_DAT_IO_CTRL_PWRDNRX_SHIFT      (0x5u)

#define CONTROL_MLBP_DAT_IO_CTRL_PWRDNTX            (0x00000010u)
#define CONTROL_MLBP_DAT_IO_CTRL_PWRDNTX_SHIFT      (0x4u)

#define CONTROL_MLBP_DAT_IO_CTRL_EN_EXT_RES         (0x00000008u)
#define CONTROL_MLBP_DAT_IO_CTRL_EN_EXT_RES_SHIFT   (0x3u)

#define CONTROL_MLBP_DAT_IO_CTRL_ENLVCMOS           (0x00000004u)
#define CONTROL_MLBP_DAT_IO_CTRL_ENLVCMOS_SHIFT     (0x2u)

#define CONTROL_MLBP_DAT_IO_CTRL_ENN                (0x00000002u)
#define CONTROL_MLBP_DAT_IO_CTRL_ENN_SHIFT          (0x1u)

#define CONTROL_MLBP_DAT_IO_CTRL_ENP                (0x00000001u)
#define CONTROL_MLBP_DAT_IO_CTRL_ENP_SHIFT          (0x0u)

/** @brief CONTROL_MLBP_CLK_BG_CTRL register fields */
#define CONTROL_MLBP_CLK_BG_CTRL_BG_TRIM            (0x000000FCu)
#define CONTROL_MLBP_CLK_BG_CTRL_BG_TRIM_SHIFT      (0x2u)

#define CONTROL_MLBP_CLK_BG_CTRL_BG_PWRDN           (0x00000002u)
#define CONTROL_MLBP_CLK_BG_CTRL_BG_PWRDN_SHIFT     (0x1u)

#define CONTROL_MLBP_CLK_BG_CTRL_CLK_PWRDN          (0x00000001u)
#define CONTROL_MLBP_CLK_BG_CTRL_CLK_PWRDN_SHIFT    (0x0u)

/** @brief SERDES_REFCLK_CTL register fields */
#define CONTROL_SERDES_REFCLK_CTL_PWRDN             (0x00000001u)
#define CONTROL_SERDES_REFCLK_CTL_PWRDN_SHIFT       (0x00000000u)

#define CONTROL_SERDES_REFCLK_CTL_PWRDN_SE          (0x00000002u)
#define CONTROL_SERDES_REFCLK_CTL_PWRDN_SE_SHIFT    (0x00000001u)

/** @brief CONTROL_DSP_INT_MUX(n) register fields */
/* TBD */

/** @brief CONTROL_DUCATI_INT_MUX(n) register fields */
/* TBD */

/** @brief CONTROL_TPCC_EVT_MUX(n) register fields */
/* TBD */

/** @brief TIMER_EVT_CAPT register fields */
#define CONTROL_TIMER_EVT_CAPT_TIMER5_EVTCAPT       (0x0000001Fu)
#define CONTROL_TIMER_EVT_CAPT_TIMER5_EVTCAPT_SHIFT (0x00000000u)

#define CONTROL_TIMER_EVT_CAPT_TIMER6_EVTCAPT       (0x00001F00u)
#define CONTROL_TIMER_EVT_CAPT_TIMER6_EVTCAPT_SHIFT (0x00000008u)

#define CONTROL_TIMER_EVT_CAPT_TIMER7_EVTCAPT       (0x001F0000u)
#define CONTROL_TIMER_EVT_CAPT_TIMER7_EVTCAPT_SHIFT (0x00000010u)

/** @brief CONTROL_GPIO_MUX register fields */
#define CONTROL_GPIO_MUX_GPIO1_5_MUX                (0x00000020u)
#define CONTROL_GPIO_MUX_GPIO1_5_MUX_SHIFT          (0x5u)

#define CONTROL_GPIO_MUX_GPIO1_4_MUX                (0x00000010u)
#define CONTROL_GPIO_MUX_GPIO1_4_MUX_SHIFT          (0x4u)

#define CONTROL_GPIO_MUX_GPIO1_3_MUX                (0x00000008u)
#define CONTROL_GPIO_MUX_GPIO1_3_MUX_SHIFT          (0x3u)

#define CONTROL_GPIO_MUX_GPIO1_2_MUX                (0x00000004u)
#define CONTROL_GPIO_MUX_GPIO1_2_MUX_SHIFT          (0x2u)

#define CONTROL_GPIO_MUX_GPIO1_1_MUX                (0x00000002u)
#define CONTROL_GPIO_MUX_GPIO1_1_MUX_SHIFT          (0x1u)

#define CONTROL_GPIO_MUX_GPIO1_0_MUX                (0x00000001u)
#define CONTROL_GPIO_MUX_GPIO1_0_MUX_SHIFT          (0x0u)

/** @brief ECAP_EVT_CAPT register fields */
#define CONTROL_ECAP_EVT_CAPT_ECAP0_EVTCAPT         (0x0000001Fu)
#define CONTROL_ECAP_EVT_CAPT_ECAP0_EVTCAPT_SHIFT   (0x00000000u)

#define CONTROL_ECAP_EVT_CAPT_ECAP1_EVTCAPT         (0x00001F00u)
#define CONTROL_ECAP_EVT_CAPT_ECAP1_EVTCAPT_SHIFT   (0x00000008u)

#define CONTROL_ECAP_EVT_CAPT_ECAP2_EVTCAPT         (0x001F0000u)
#define CONTROL_ECAP_EVT_CAPT_ECAP2_EVTCAPT_SHIFT   (0x00000010u)

/** @brief ADC_EVT_CAPT register fields */
#define CONTROL_ADC_EVT_CAPT_ADC_EVTCAPT            (0x0000000Fu)
#define CONTROL_ADC_EVT_CAPT_ADC_EVTCAPT_SHIFT      (0x00000000u)

/** @brief RESET_ISO register fields */
#define CONTROL_RESET_ISO_ISO_CONTROL               (0x00000001u)
#define CONTROL_RESET_ISO_ISO_CONTROL_SHIFT         (0x00000000u)

/** @brief CONTROL_DAC_TRIM(n) register fields */
#define CONTROL_DAC_TRIM_TRIM                       (0xFFFFFFFFu)
#define CONTROL_DAC_TRIM_TRIM_SHIFT                 (0x0u)

/** @brief SMA0 register fields */
#define CONTROL_SMA0_SMA0                           (0xFFFFFFFFu)
#define CONTROL_SMA0_SMA0_SHIFT                     (0x00000000u)

/** @brief SMA2 register fields */
#define CONTROL_SMA2_SMA2                           (0xFFFFFFFFu)
#define CONTROL_SMA2_SMA2_SHIFT                     (0x00000000u)

/** @brief CONTROL_RTC_IDLE register fields */
#define CONTROL_RTC_IDLE_SIDLE_ACK                  (0x00000006u)
#define CONTROL_RTC_IDLE_SIDLE_ACK_SHIFT            (0x1u)

#define CONTROL_RTC_IDLE_SIDLE_REQ                  (0x00000001u)
#define CONTROL_RTC_IDLE_SIDLE_REQ_SHIFT            (0x0u)

/** @brief CONTROL_ARM_INT_MUX(n) register fields */
/* TBD */

/** @brief CONTROL_INITIATOR_PRIO(n) register fields */
#define CONTROL_INITIATOR_PRIO0_GEM_MDMA            (0x07000000u)
#define CONTROL_INITIATOR_PRIO0_GEM_MDMA_SHIFT      (0x18u)

#define CONTROL_INITIATOR_PRIO0_GEM_CFG             (0x00700000u)
#define CONTROL_INITIATOR_PRIO0_GEM_CFG_SHIFT       (0x14u)

#define CONTROL_INITIATOR_PRIO0_SYS_MMU             (0x00070000u)
#define CONTROL_INITIATOR_PRIO0_SYS_MMU_SHIFT       (0x10u)

#define CONTROL_INITIATOR_PRIO0_SGX530              (0x00007000u)
#define CONTROL_INITIATOR_PRIO0_SGX530_SHIFT        (0xCu)

#define CONTROL_INITIATOR_PRIO0_BitBlt_MMU          (0x00000700u)
#define CONTROL_INITIATOR_PRIO0_BitBlt_MMU_SHIFT    (0x8u)

#define CONTROL_INITIATOR_PRIO0_HOST_ARM1           (0x00000070u)
#define CONTROL_INITIATOR_PRIO0_HOST_ARM1_SHIFT     (0x4u)

#define CONTROL_INITIATOR_PRIO0_HOST_ARM0           (0x00000007u)
#define CONTROL_INITIATOR_PRIO0_HOST_ARM0_SHIFT     (0x0u)

#define CONTROL_INITIATOR_PRIO1_TCWR3               (0x70000000u)
#define CONTROL_INITIATOR_PRIO1_TCWR3_SHIFT         (0x1Cu)

#define CONTROL_INITIATOR_PRIO1_TCRD3               (0x07000000u)
#define CONTROL_INITIATOR_PRIO1_TCRD3_SHIFT         (0x18u)

#define CONTROL_INITIATOR_PRIO1_TCWR2               (0x00700000u)
#define CONTROL_INITIATOR_PRIO1_TCWR2_SHIFT         (0x14u)

#define CONTROL_INITIATOR_PRIO1_TCRD2               (0x00070000u)
#define CONTROL_INITIATOR_PRIO1_TCRD2_SHIFT         (0x10u)

#define CONTROL_INITIATOR_PRIO1_TCWR1               (0x00007000u)
#define CONTROL_INITIATOR_PRIO1_TCWR1_SHIFT         (0xCu)

#define CONTROL_INITIATOR_PRIO1_TCRD1               (0x00000700u)
#define CONTROL_INITIATOR_PRIO1_TCRD1_SHIFT         (0x8u)

#define CONTROL_INITIATOR_PRIO1_TCWR0               (0x00000070u)
#define CONTROL_INITIATOR_PRIO1_TCWR0_SHIFT         (0x4u)

#define CONTROL_INITIATOR_PRIO1_TCRD0               (0x00000007u)
#define CONTROL_INITIATOR_PRIO1_TCRD0_SHIFT         (0x0u)

#define CONTROL_INITIATOR_PRIO2_DEBUG               (0x07000000u)
#define CONTROL_INITIATOR_PRIO2_DEBUG_SHIFT         (0x18u)

#define CONTROL_INITIATOR_PRIO2_3PGSW               (0x00700000u)
#define CONTROL_INITIATOR_PRIO2_3PGSW_SHIFT         (0x14u)

#define CONTROL_INITIATOR_PRIO2_SECSS               (0x00070000u)
#define CONTROL_INITIATOR_PRIO2_SECSS_SHIFT         (0x10u)

#define CONTROL_INITIATOR_PRIO2_PCIe                (0x00007000u)
#define CONTROL_INITIATOR_PRIO2_PCIe_SHIFT          (0xCu)

#define CONTROL_INITIATOR_PRIO2_ISS                 (0x00000700u)
#define CONTROL_INITIATOR_PRIO2_ISS_SHIFT           (0x8u)

#define CONTROL_INITIATOR_PRIO3_PRUSS1              (0x00000070u)
#define CONTROL_INITIATOR_PRIO3_PRUSS1_SHIFT        (0x4u)

#define CONTROL_INITIATOR_PRIO3_PRUSS0              (0x00000007u)
#define CONTROL_INITIATOR_PRIO3_PRUSS0_SHIFT        (0x0u)

#define CONTROL_INITIATOR_PRIO4_P1500               (0x00007000u)
#define CONTROL_INITIATOR_PRIO4_P1500_SHIFT         (0xCu)

#define CONTROL_INITIATOR_PRIO4_MLB                 (0x00000700u)
#define CONTROL_INITIATOR_PRIO4_MLB_SHIFT           (0x8u)

#define CONTROL_INITIATOR_PRIO4_USB1                (0x00000070u)
#define CONTROL_INITIATOR_PRIO4_USB1_SHIFT          (0x4u)

#define CONTROL_INITIATOR_PRIO4_USB0                (0x00000007u)
#define CONTROL_INITIATOR_PRIO4_USB0_SHIFT          (0x0u)

/** @brief CONTROL_DMAOBS register fields */
#define CONTROL_DMAOBS_DMAOBS2_EN                   (0x80000000u)
#define CONTROL_DMAOBS_DMAOBS2_EN_SHIFT             (0x1Fu)

#define CONTROL_DMAOBS_DMAOBS2_SEL                  (0x00FF0000u)
#define CONTROL_DMAOBS_DMAOBS2_SEL_SHIFT            (0x10u)

#define CONTROL_DMAOBS_DMAOBS1_EN                   (0x00008000u)
#define CONTROL_DMAOBS_DMAOBS1_EN_SHIFT             (0xFu)

#define CONTROL_DMAOBS_DMAOBS1_SEL                  (0x000000FFu)
#define CONTROL_DMAOBS_DMAOBS1_SEL_SHIFT            (0x0u)

/** @brief CONTROL_INTOBS register fields */
#define CONTROL_INTOBS_INTOBS2_EN                   (0x80000000u)
#define CONTROL_INTOBS_INTOBS2_EN_SHIFT             (0x1Fu)

#define CONTROL_INTOBS_INTOBS2_SEL                  (0x00FF0000u)
#define CONTROL_INTOBS_INTOBS2_SEL_SHIFT            (0x10u)

#define CONTROL_INTOBS_INTOBS1_EN                   (0x00008000u)
#define CONTROL_INTOBS_INTOBS1_EN_SHIFT             (0xFu)

#define CONTROL_INTOBS_INTOBS1_SEL                  (0x000000FFu)
#define CONTROL_INTOBS_INTOBS1_SEL_SHIFT            (0x0u)

/** @brief CONTROL_DTC_CTRL(n) register fields */
#define CONTROL_DTC_CTRL_DTC_RESET                  (0x40000000u)
#define CONTROL_DTC_CTRL_DTC_RESET_SHIFT            (0x1Eu)

#define CONTROL_DTC_CTRL_PCLK_INV                   (0x00010000u)
#define CONTROL_DTC_CTRL_PCLK_INV_SHIFT             (0x10u)

#define CONTROL_DTC_CTRL_TCON_LOAD3_POL             (0x00008000u)
#define CONTROL_DTC_CTRL_TCON_LOAD3_POL_SHIFT       (0xFu)

#define CONTROL_DTC_CTRL_TCON_LOAD2_POL             (0x00004000u)
#define CONTROL_DTC_CTRL_TCON_LOAD2_POL_SHIFT       (0xEu)

#define CONTROL_DTC_CTRL_TCON_LOAD1_POL             (0x00002000u)
#define CONTROL_DTC_CTRL_TCON_LOAD1_POL_SHIFT       (0xDu)

#define CONTROL_DTC_CTRL_TCON_LOAD0_POL             (0x00001000u)
#define CONTROL_DTC_CTRL_TCON_LOAD0_POL_SHIFT       (0xCu)

#define CONTROL_DTC_CTRL_TCON_VCOM_ALT              (0x00000400u)
#define CONTROL_DTC_CTRL_TCON_VCOM_ALT_SHIFT        (0xAu)

#define CONTROL_DTC_CTRL_TCON_VCOM_POL              (0x00000200u)
#define CONTROL_DTC_CTRL_TCON_VCOM_POL_SHIFT        (0x9u)

#define CONTROL_DTC_CTRL_TCON_VCOM_EN               (0x00000100u)
#define CONTROL_DTC_CTRL_TCON_VCOM_EN_SHIFT         (0x8u)

#define CONTROL_DTC_CTRL_DITHER_MODE                (0x0000000Cu)
#define CONTROL_DTC_CTRL_DITHER_MODE_SHIFT          (0x2u)

#define CONTROL_DTC_CTRL_DITHER_ACTVID_POL          (0x00000002u)
#define CONTROL_DTC_CTRL_DITHER_ACTVID_POL_SHIFT    (0x1u)

#define CONTROL_DTC_CTRL_DITHER_ENABLE              (0x00000001u)
#define CONTROL_DTC_CTRL_DITHER_ENABLE_SHIFT        (0x0u)

/** @brief CONTROL_DTC0_LOAD(n) register fields */
#define CONTROL_DTC0_LOAD012_TCON_LOAD_WIDTH        (0x07FF0000u)
#define CONTROL_DTC0_LOAD012_TCON_LOAD_WIDTH_SHIFT  (0x10u)

#define CONTROL_DTC0_LOAD012_TCON_LOAD_ON           (0x000007FFu)
#define CONTROL_DTC0_LOAD012_TCON_LOAD_ON_SHIFT     (0x0u)

#define CONTROL_DTC0_LOAD3_LOAD3_VSMOD              (0x80000000u)
#define CONTROL_DTC0_LOAD3_LOAD3_VSMOD_SHIFT        (0x1Fu)

#define CONTROL_DTC0_LOAD3_LOAD3_VSCNT              (0x78000000u)
#define CONTROL_DTC0_LOAD3_LOAD3_VSCNT_SHIFT        (0x1Bu)

#define CONTROL_DTC0_LOAD3_TCON_LOAD_WIDTH          (0x07FF0000u)
#define CONTROL_DTC0_LOAD3_TCON_LOAD_WIDTH_SHIFT    (0x10u)

#define CONTROL_DTC0_LOAD3_TCON_LOAD_ON             (0x000007FFu)
#define CONTROL_DTC0_LOAD3_TCON_LOAD_ON_SHIFT       (0x0u)

/** @brief CONTROL_DTC1_LOAD(n) register fields */
#define CONTROL_DTC1_LOAD012_TCON_LOAD_WIDTH        (0x07FF0000u)
#define CONTROL_DTC1_LOAD012_TCON_LOAD_WIDTH_SHIFT  (0x10u)

#define CONTROL_DTC1_LOAD012_TCON_LOAD_ON           (0x000007FFu)
#define CONTROL_DTC1_LOAD012_TCON_LOAD_ON_SHIFT     (0x0u)

#define CONTROL_DTC1_LOAD3_LOAD3_VSMOD              (0x80000000u)
#define CONTROL_DTC1_LOAD3_LOAD3_VSMOD_SHIFT        (0x1Fu)

#define CONTROL_DTC1_LOAD3_LOAD3_VSCNT              (0x78000000u)
#define CONTROL_DTC1_LOAD3_LOAD3_VSCNT_SHIFT        (0x1Bu)

#define CONTROL_DTC1_LOAD3_TCON_LOAD_WIDTH          (0x07FF0000u)
#define CONTROL_DTC1_LOAD3_TCON_LOAD_WIDTH_SHIFT    (0x10u)

#define CONTROL_DTC1_LOAD3_TCON_LOAD_ON             (0x000007FFu)
#define CONTROL_DTC1_LOAD3_TCON_LOAD_ON_SHIFT       (0x0u)

/** @brief CONTROL_ICSS_INT_MUX(n) register fields */
/* TBD */

/** @brief CONTROL_CHIP_HW_DBG_SEL register fields */
#define CONTROL_CHIP_HW_DBG_SEL_CHIP_DBG_SEL        (0x00000007u)
#define CONTROL_CHIP_HW_DBG_SEL_CHIP_DBG_SEL_SHIFT  (0x0u)


#ifdef __cplusplus
}
#endif

#endif
