/**
 * \file  notify_pv.h
 *
 * \brief Notify module internal declarations
 */

/* Copyright (c) 2011, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */


#ifndef IPCNOTIFY_PV_H_
#define IPCNOTIFY_PV_H_
#if defined (__cplusplus)
extern "C" {
#endif

/* general IPC header files */
#include "ipc.h"
#include "notify.h"

#define    EMPTY_PTR                    0
/* Event slot status definition */
#define    Notify_EVENT_SLOT_FREE       0xA5A5
#define    Notify_EVENT_SLOT_REGISTED   0x1001
#define    Notify_EVENT_SLOT_HAS_DATA   0x2002
#define    Notify_EVENT_SLOT_DISABLED   0x3003

/* Structure for a Notify event slot (subject to change) */
typedef struct IPC_notifyEventSlot
{
    UInt16 status;              /* event slot status (see defines) */
    UInt16 remoteProcId;        /* remote CPU ID */
    UInt16 remoteIntLine;       /* remote CPU int line ID */
    UInt16 semCnt;              /* semaphore */
    UInt32 cbKey;               /* callback key */
    Notify_FnNotifyCbck cbFxn;  /* registered call back function */
} IPC_notifyEventSlot;

/*     Structure to hold Notify instance settings (subject to change) */
struct IPC_notifyCfg
{
    UInt16 NotifyRcvMethod;                 /* polling or interrupt receive (see define in Ipc.h) */
    UInt16 NotifyChannel;                   /* interrupt channel (ARM CPU AINTC) or number (C6x DSP INTC) */
    UInt16 numRegistedEvents;               /* number of events registered */
    UInt16 maxNumofEvents;                  /* maximum number of events (see define in Notify.h) */
    IPC_notifyEvent *localEventPtr;         /* points to IPC mem space for IPC use to send */
    IPC_notifyEvent *remoteEventPtr;        /* points to IPC mem space of remote CPU for IPC to send event data */
    IPC_notifyEventSlot *eventTblHandle;    /* points to table of local event slots */
    int ( *ipcNotifyFxn)();                 /* notify send function */
    struct IPC_modControl *IpcObjHandle;    /* points to IPC control structure */
    int pendingEventCnt;                    /* total pending (unprocessed) events */
    int overrunEventCnt;                    /* indicate number of missed events (waitClear not used) */
};

/* Internal Notify Module function declarations */

#if defined (__cplusplus)
}
#endif /* defined (__cplusplus) */
#endif /* IPCNOTIFY_PV_H_ */
