/**
 * \file  toneRaw.h
 *
 * \brief Part of game example application.
 */

/*
* Copyright (C) 2012 Texas Instruments Incorporated - http://www.ti.com/ 
*
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __TONERAW_H__
#define __TONERAW_H__

unsigned short const toneRaw[] = {
0x0512, 0x0605, 0x0474, 0x05df, 0x0469, 0x0635, 0x04ce, 0x0638, 0x0583, 0x05c9,
0x0572, 0x0540, 0x04b2, 0x052f, 0x0410, 0x050a, 0x0343, 0x0453, 0x02b6, 0x03b1,
0x027a, 0x0325, 0x0206, 0x0287, 0x0188, 0x0240, 0x00fb, 0x0203, 0x00f3, 0x01a3,
0x0142, 0x01cf, 0x0142, 0x01da, 0x011a, 0x0100, 0x00bf, 0x0096, 0x0068, 0x00e6,
0x003e, 0x00ed, 0xffe9, 0x00e6, 0xffed, 0x011c, 0xfffe, 0x0105, 0xffdf, 0x00b4,
0x0013, 0x0100, 0x008c, 0x01e9, 0x0089, 0x020a, 0xfff5, 0x017a, 0xff59, 0x014a,
0xfe9e, 0x0115, 0xfde3, 0x006d, 0xfd62, 0x0053, 0xfd16, 0x0025, 0xfd36, 0xff97,
0xfd41, 0xffb3, 0xfcba, 0xff94, 0xfbe8, 0xfef3, 0xfbb8, 0xfe1f, 0xfbb1, 0xfd98,
0xfb4a, 0xfe4a, 0xfbe4, 0xff32, 0xfceb, 0xff25, 0xfcfb, 0xfed5, 0xfc4a, 0xff01,
0xfc32, 0xff67, 0xfcb9, 0xffa6, 0xfd01, 0xff54, 0xfd55, 0xff56, 0xfd4a, 0xff5a,
0xfc7a, 0xfeb4, 0xfbe1, 0xfe50, 0xfc31, 0xfe9c, 0xfd48, 0xff87, 0xfdf1, 0xff45,
0xfd80, 0xfe27, 0xfd0b, 0xfdee, 0xfc37, 0xfd89, 0xfbf0, 0xfd55, 0xfcfc, 0xfda1,
0xfe01, 0xfdd4, 0xfee2, 0xfe2c, 0xfee8, 0xfe8f, 0xfe9f, 0xfef4, 0xff02, 0xfe85,
0xfee1, 0xfd54, 0xfeb5, 0xfd0d, 0xfeab, 0xfd5c, 0x0b31, 0x12ca, 0x0b19, 0x03ab,
0xf5ea, 0xfa12, 0xedc1, 0x0453, 0x0078, 0x0004, 0x0b81, 0xf3f1, 0x249b, 0xf993,
0x3e5b, 0x1694, 0x1773, 0x1a55, 0xeb72, 0xeb12, 0xee16, 0xd601, 0xf550, 0xe792,
0xfeed, 0xe780, 0x00ad, 0xe6a6, 0xf23e, 0xde79, 0x11af, 0xdbfa, 0x3285, 0x16c1,
0x0feb, 0x1b4d, 0xd638, 0xc7c7, 0xbe07, 0xd315, 0xeaab, 0xf656, 0x1a04, 0xc1c7,
0xfb4a, 0xccf1, 0xeb0a, 0x075e, 0x0acc, 0x129d, 0x17af, 0x24f4, 0x2f35, 0x39f4,
0x21e5, 0x2fa4, 0xdf69, 0x0530, 0xf068, 0xc8ea, 0x2612, 0xd2bd, 0x0689, 0x0dc2,
0xe02a, 0xfeac, 0xde35, 0xca5f, 0xd623, 0xb94f, 0xda77, 0xb11c, 0x0fca, 0xd119,
0x4e3b, 0x26fc, 0x5185, 0x406c, 0x46a1, 0x1276, 0x3599, 0x00d7, 0xf32a, 0x2b74,
0xdae9, 0x322b, 0x0c2c, 0xdf84, 0xefe5, 0xa77d, 0xa131, 0xc58e, 0xa5f6, 0xdbef,
0xb9c8, 0xd2a0, 0xabf5, 0xcc19, 0xa4be, 0xb1b2, 0xb89e, 0xab6c, 0xde89, 0xcf1c,
0xfc2b, 0xe020, 0x13e6, 0xeac1, 0x386e, 0x191b, 0x4821, 0x3a38, 0x4708, 0x3248,
0x5711, 0x34a5, 0x5850, 0x47e0, 0x4447, 0x41af, 0x3291, 0x20d7, 0x24c4, 0x1a6f,
0x1848, 0x111d, 0x0419, 0xe938, 0xe399, 0xc811, 0xcfe3, 0xbafa, 0xc626, 0xbddd,
0xae2b, 0xaef8, 0x947c, 0x899b, 0x893e, 0x80c8, 0x90ae, 0x9025, 0x9aa0, 0x9996,
0x8760, 0x8d2f, 0x8589, 0x88da, 0xc281, 0xb430, 0xfb2e, 0xf55a, 0xe873, 0xf08d,
0xdaa2, 0xe014, 0xf762, 0x03de, 0x1d00, 0x2ca9, 0x3edd, 0x31ee, 0x5164, 0x24cc,
0x21b1, 0x2468, 0xf2bf, 0x2b78, 0x1f74, 0x146b, 0x4524, 0x1147, 0x16da, 0x2eea,
0x0972, 0x2973, 0x2bec, 0x0ec4, 0x23f7, 0x05fc, 0x1b09, 0x027d, 0x1a48, 0xef9e,
0xf4fe, 0xcb65, 0xdb56, 0xc5b0, 0xfad2, 0xed23, 0x29f2, 0x103a, 0x363f, 0x365d,
0x1b9a, 0x5844, 0xf692, 0x4402, 0xe13b, 0xffae, 0xe413, 0xdef3, 0xec10, 0xe100,
0xe0f8, 0xdece, 0xfa73, 0xeb42, 0x4440, 0x08f4, 0x5838, 0x1f56, 0x3d8e, 0x2472,
0x263f, 0x0c91, 0x0793, 0xe55e, 0xd86d, 0xc222, 0xb245, 0x9b19, 0x9e35, 0x845d,
0x969e, 0x8aad, 0x9f63, 0xa819, 0xbbb8, 0xbd9a, 0xe2e6, 0xc0ef, 0xf5b5, 0xd141,
0xf4fe, 0x0940, 0x072d, 0x3806, 0x2bba, 0x3493, 0x3fdd, 0x27ed, 0x4cd0, 0x235b,
0x57dd, 0x11b1, 0x4139, 0xfcde, 0x0a3c, 0xe950, 0xe448, 0xd5a7, 0xccf0, 0xc835,
0xb561, 0xbc64, 0xb7ff, 0xbbbf, 0xe33a, 0xdc8d, 0x1067, 0x0b23, 0x1e06, 0x2e60,
0x290a, 0x4d68, 0x4854, 0x602b, 0x6174, 0x6e63, 0x604e, 0x6e23, 0x4b97, 0x4d01,
0x3afe, 0x34f7, 0x1d98, 0x2d7d, 0xfc41, 0x0cf9, 0xe3e2, 0xdad3, 0xc2aa, 0xa95a,
0xa843, 0x90a7, 0xa4dc, 0x93cb, 0xa348, 0x9960, 0x9af2, 0x9ab9, 0xa871, 0xac46,
0xd368, 0xcb8a, 0x0322, 0xf05a, 0x2466, 0x0d58, 0x443e, 0x2f5a, 0x6e5a, 0x5b06,
0x7b69, 0x718d, 0x77da, 0x740b, 0x7297, 0x6fc5, 0x6b13, 0x711f, 0x68e9, 0x7317,
0x6031, 0x71d2, 0x34a9, 0x53e3, 0x1538, 0x323a, 0x104c, 0x2dcc, 0xee13, 0x1a4b,
0xc54b, 0xeed1, 0xcda6, 0xd1c4, 0xd53d, 0xc047, 0xbb2d, 0xb9bb, 0xb089, 0xbcb1,
0xc57c, 0xaf30, 0xd4b7, 0x9d52, 0xb967, 0xa7d2, 0x9790, 0xc3c8, 0x96f4, 0xcbe3,
0xacbd, 0xc0be, 0xb86e, 0xaff1, 0xb69a, 0xa674, 0xbbf8, 0xa817, 0xcd1a, 0xb3e7,
0xdcc7, 0xc37e, 0xeddf, 0xe2f7, 0x064f, 0x0ef0, 0x22a6, 0x3ab7, 0x241e, 0x4999,
0x1e6d, 0x4635, 0x23e1, 0x4415, 0x1e0b, 0x40d4, 0x14a1, 0x39a6, 0x1196, 0x317a,
0x1770, 0x244d, 0x27ba, 0x143b, 0x2c95, 0x0e85, 0x2a7d, 0x0e7c, 0x2b1f, 0x0ee7,
0x2346, 0x0d82, 0x2d04, 0x1519, 0x4298, 0x2310, 0x5211, 0x33fc, 0x5527, 0x457d,
0x4fd3, 0x4eb2, 0x4d51, 0x4a74, 0x4ca8, 0x4b5e, 0x4759, 0x522a, 0x3b8e, 0x3f2e,
0x27f7, 0x2634, 0x0b15, 0x1113, 0x031a, 0xfcf3, 0xf13a, 0xe77e, 0xd95a, 0xd9fd,
0xcc72, 0xd2c0, 0xc0e4, 0xce9d, 0xb5be, 0xd11b, 0xc043, 0xe11e, 0xca43, 0xebb6,
0xcdba, 0xf24d, 0xdecb, 0xf68a, 0xeffe, 0xf5ca, 0xf197, 0x0446, 0xef3c, 0x19a1,
0xf579, 0x19fc, 0xf5f9, 0x0dd8, 0x0208, 0x0d31, 0x01ba, 0xffeb, 0xe97c, 0xf473,
0xdc80, 0xfdf4, 0xdda5, 0xf390, 0xdf4f, 0xd593, 0xdfb5, 0xcf12, 0xda29, 0xdfd8,
0xd494, 0xdd0c, 0xcd66, 0xca2b, 0xc264, 0xc58e, 0xc6bb, 0xc398, 0xddb1, 0xc433,
0xe913, 0xd4c6, 0xe516, 0xed79, 0xe313, 0xf5c6, 0xed37, 0xf131, 0x04df, 0xf64a,
0x12de, 0x0456, 0x0c41, 0x0ac3, 0x0a80, 0x13bb, 0x0e4d, 0x221a, 0x0d1d, 0x1eff,
0x1627, 0x1bd4, 0x1e9e, 0x2455, 0x1ca0, 0x2abb, 0x1730, 0x2202, 0x042e, 0x1358,
0xe5fd, 0x0030, 0xe345, 0xf637, 0xf431, 0xf2ad, 0xf6fb, 0xe5c9, 0xf0d5, 0xe4d8,
0xe6de, 0xf29d, 0xeb5b, 0x0ac1, 0x0eae, 0x19d5, 0x31dc, 0x1a7d, 0x37dc, 0x11c4,
0x3a18, 0x084c, 0x413f, 0x1037, 0x3173, 0x1093, 0x22b7, 0x12cd, 0x30be, 0x284b,
0x4774, 0x4452, 0x4c6d, 0x532e, 0x4a03, 0x57de, 0x512c, 0x5088, 0x5c16, 0x471e,
0x5760, 0x4248, 0x348c, 0x313c, 0x1d23, 0x1b2a, 0x2830, 0x1d96, 0x2502, 0x281e,
0x0542, 0x189a, 0xea4d, 0x034e, 0xe99c, 0x01dd, 0x0046, 0x0f31, 0x1627, 0x1dfa,
0x181e, 0x2069, 0x0e31, 0x1386, 0x0139, 0x0d9c, 0xfbbc, 0x0905, 0x06e2, 0xfc8d,
0x0ee1, 0xf9ae, 0x005d, 0xf03b, 0xe4fb, 0xdfd6, 0xdba4, 0xdb92, 0xce60, 0xd0e5,
0xcd5e, 0xd9d6, 0xe1c4, 0xeedc, 0xeeb8, 0xf457, 0xf8ad, 0xfd8e, 0x0636, 0x1074,
0x0b2d, 0x1b97, 0x137c, 0x1e44, 0x2480, 0x20ff, 0x2665, 0x2513, 0x20c0, 0x21dc,
0x192d, 0x12f3, 0x0bd3, 0x0171, 0xfc09, 0xe92f, 0xedfe, 0xcf9b, 0xe21e, 0xc5e4,
0xd9d0, 0xcb5f, 0xcb9b, 0xc1b0, 0xbc70, 0xb847, 0xb493, 0xc107, 0xbaad, 0xceff,
0xcba7, 0xdab8, 0xd4c3, 0xd4cb, 0xd7f9, 0xd12e, 0xe4b4, 0xee02, 0xeaf6, 0xfbdd,
0xdefe, 0xea1c, 0xd91c, 0xe2d8, 0xe53c, 0xe94d, 0xf442, 0xf6c0, 0xf024, 0xf5d5,
0xf182, 0xf30f, 0x03f3, 0x00b2, 0x04e6, 0x0081, 0xff46, 0xf31a, 0xfd79, 0xead4,
0xfa05, 0xf34e, 0xf58e, 0xf7d1, 0xfb27, 0xf1dd, 0x0388, 0xf1cb, 0x0097, 0xfa08,
0x03e0, 0xfe60, 0x05d3, 0xf768, 0xfb41, 0xf771, 0xf393, 0xf6a0, 0xefb8, 0xf27f,
0xe007, 0xe9e9, 0xdc4c, 0xe67f, 0xeb5b, 0xebb9, 0xf49c, 0xefab, 0xf799, 0xf0c1,
0xf4b5, 0xe9e7, 0xf5fd, 0xefdd, 0x02d0, 0xfdcc, 0x0acd, 0x046b, 0x1bbf, 0x1283,
0x2248, 0x1bf2, 0x1989, 0x130a, 0x102e, 0x0c1f, 0x0d43, 0x1136, 0x0397, 0x0b0f,
0x0584, 0x028c, 0x0e48, 0xf836, 0xf641, 0xe696, 0xe5b3, 0xe86d, 0xf495, 0xf23f,
0xfbbf, 0xef29, 0xf064, 0xe82e, 0xf312, 0xe936, 0x01f5, 0xf0f7, 0x021b, 0xf6a8,
0x06f6, 0xff75, 0x1914, 0x1270, 0x2806, 0x2b5a, 0x2e98, 0x39ef, 0x364a, 0x3896,
0x316d, 0x32e2, 0x3140, 0x3c1c, 0x4649, 0x4d06, 0x462e, 0x4530, 0x2e93, 0x2b7c,
0x2167, 0x2567, 0x2c60, 0x2a4b, 0x30ec, 0x20d4, 0x2898, 0x1971, 0x1da3, 0x0fed,
0x190d, 0x04ae, 0x154a, 0x0419, 0x0ba1, 0x0453, 0x0975, 0x015d, 0x09bf, 0x044e,
0x0683, 0x04a1, 0x06dc, 0xfe5c, 0x0307, 0xfc3f, 0x0034, 0xff79, 0x00c7, 0xfe20,
0xfc36, 0xf975, 0xf671, 0xfa71, 0xffa5, 0x016d, 0xfe87, 0x0091, 0xedbf, 0x0037,
0xe992, 0xff2d, 0xfc01, 0xf8ef, 0x0a5c, 0xf713, 0xfb12, 0xee08, 0xeac2, 0xe4a0,
0xf103, 0xe083, 0xff9f, 0xe2ff, 0xfbb7, 0xe66b, 0xf972, 0xef32, 0xfbb7, 0xeec8,
0xfbfa, 0xee8d, 0xfc08, 0x0140, 0xeffc, 0x0a16, 0xebd7, 0x01dd, 0xf1e7, 0xfc0d,
0xf54d, 0x0007, 0x0568, 0x0838, 0x02cf, 0x00d1, 0xf19a, 0xfd6f, 0xf585, 0x025a,
0xfb90, 0xf4f4, 0x00b1, 0xf464, 0x070c, 0x0338, 0x0632, 0xff4b, 0xfc70, 0xf483,
0xfce6, 0xf664, 0x0492, 0xfb31, 0x06e5, 0xfe72, 0x041f, 0xfd9b, 0xfd59, 0xf7d7,
0xf6f7, 0xf9a1, 0xf7e1, 0xfd79, 0xf7a4, 0xf637, 0xf870, 0xf09c, 0xf3c2, 0xeaa1,
0xf05c, 0xe69e, 0xe748, 0xea6b, 0xe296, 0xedbe, 0xdef9, 0xe74e, 0xd7e3, 0xe3af,
0xed08, 0xf058, 0xfd97, 0xf815, 0xf38b, 0xf16f, 0xecf0, 0xeb80, 0xe802, 0xdeeb,
0xec9e, 0xdf5e, 0xfbb3, 0xef7e, 0xf406, 0xedaa, 0xe8f9, 0xe71c, 0xe3c0, 0xea5d,
0xde1f, 0xefd0, 0xe16a, 0xf680, 0xe42a, 0xf0f7, 0xe735, 0xea2d, 0xebb2, 0xe6e2,
0xe4ca, 0xd8c7, 0xdfe9, 0xd94f, 0xe29c, 0xe30f, 0xd259, 0xd93a, 0xd3d6, 0xd9cb,
0xe574, 0xe3b7, 0xe7b7, 0xed70, 0xe062, 0xf02e, 0xdfde, 0xede5, 0xe551, 0xf123,
0xeb2f, 0xf4a0, 0xec21, 0xf181, 0xe7d0, 0xf0c0, 0xe862, 0xf77a, 0xeef4, 0xfbd7,
0xfd54, 0x02c5, 0x00e7, 0xfceb, 0x0352, 0xf3e6, 0x0e89, 0xf5cb, 0x1562, 0xf9cf,
0x0be0, 0xfba2, 0x0498, 0x0148, 0x0bc8, 0x049d, 0x1bd3, 0x0053, 0x2229, 0xfdd4,
0x17ef, 0x0280, 0x0bdd, 0x020c, 0x18c5, 0x0b5b, 0x2822, 0x1e1d, 0x1f4a, 0x274a,
0x1942, 0x27ed, 0x2212, 0x2129, 0x2828, 0x196b, 0x282b, 0x1a77, 0x236d, 0x2100,
0x171c, 0x1809, 0x0faa, 0x101a, 0x137a, 0x12fa, 0x16ad, 0x150a, 0x1090, 0x19cd,
0x1060, 0x1e48, 0x140e, 0x169f, 0x0ea0, 0x0d18, 0x042f, 0x100d, 0x0461, 0x119f,
0x0bee, 0x1064, 0x11cb, 0x1226, 0x12ae, 0x151a, 0x104c, 0x116c, 0x089f, 0x09f5,
0x068a, 0x0ad4, 0x0394, 0x0a2f, 0xf6bc, 0x0894, 0xf93a, 0x0c2c, 0x09d2, 0x0dc6,
0x0c9b, 0x0585, 0x04eb, 0x00fc, 0x03d3, 0x0763, 0x0bc7, 0x0742, 0x148f, 0x0562,
0x16a3, 0x0642, 0x1dc0, 0x0c5d, 0x2152, 0x1607, 0x1b64, 0x1ba4, 0x17c5, 0x1ff8,
0x1e26, 0x2711, 0x226e, 0x255e, 0x1c90, 0x21b9, 0x18d9, 0x1e31, 0x1b06, 0x1425,
0x1c4d, 0x0f11, 0x1a45, 0x11ed, 0x1ab8, 0x1207, 0x113b, 0x083c, 0x07ef, 0xfafd,
0x0666, 0xf64f, 0x0b2a, 0xfb15, 0x0c6c, 0x0096, 0x07cd, 0x02a5, 0x0ab0, 0x05ca,
0x0961, 0x0b72, 0xfb54, 0x12ae, 0xf852, 0x1cea, 0x01bd, 0x197c, 0x0137, 0x0e67,
0x04c0, 0x16fb, 0x0e29, 0x218f, 0x1299, 0x236d, 0x1405, 0x2a9b, 0x18f2, 0x2d40,
0x1e8e, 0x2cc2, 0x2530, 0x31f7, 0x2e51, 0x3625, 0x2dd9, 0x3dd2, 0x1feb, 0x3e90,
0x16ad, 0x3371, 0x17df, 0x328f, 0x1990, 0x2463, 0x16c4, 0x13c6, 0x1681, 0x1a01,
0x15f6, 0x1899, 0x0bed, 0x09b2, 0xfdd0, 0x00aa, 0xf7bf, 0xfbde, 0xf656, 0xf610,
0xe9fb, 0xf239, 0xde7f, 0xee99, 0xe734, 0xefcd, 0xf360, 0xf5e8, 0xf08d, 0x0169,
0xec82, 0x088a, 0xec14, 0xfc74, 0xeedb, 0xf19d, 0xee67, 0xed67, 0xeb19, 0xed2d,
0xedc3, 0xeeee, 0xedd2, 0xecc3, 0xeaf2, 0xebe0, 0xedb3, 0xed53, 0xf169, 0xea97,
0xf574, 0xee81, 0xf1e8, 0xf0c7, 0xe5a3, 0xe60a, 0xe6e9, 0xe73c, 0xe50f, 0xf0ed,
0xd938, 0xf29a, 0xd81c, 0xed5d, 0xd875, 0xe856, 0xceca, 0xe7c2, 0xc9f8, 0xe820,
0xcb62, 0xe430, 0xd08a, 0xe1b6, 0xdbb8, 0xe7fc, 0xde5a, 0xe6b7, 0xd7c7, 0xdfad,
0xd451, 0xe2f1, 0xe4fe, 0xe8bf, 0xf208, 0xeea3, 0xe778, 0xf1d2, 0xdd99, 0xefcb,
0xdf0a, 0xecd1, 0xe36a, 0xea74, 0xec30, 0xf19b, 0xf6d4, 0xf779, 0xfb81, 0xf6d4,
0xf822, 0xf366, 0xf406, 0xf24e, 0xf2bf, 0xf161, 0xeea0, 0xf122, 0xecdf, 0xfdeb,
0xf1c9, 0x062a, 0xf447, 0xfad6, 0xf20e, 0xf1d7, 0xf3c8, 0xf45c, 0xf139, 0xf38d,
0xec2b, 0xf326, 0xf0e0, 0xf3db, 0xfc37, 0xf587, 0x0584, 0xfa6e, 0x04b8, 0xfc6d,
0x0396, 0x014a, 0x0377, 0x020a, 0xff2a, 0xf88f, 0xf942, 0xf7ae, 0xfbaa, 0x009e,
0x0768, 0x0347, 0x071d, 0x0430, 0x0213, 0x041a, 0xfe25, 0xfd1f, 0x0008, 0xf7f8,
0x05b6, 0xfc40, 0x017f, 0xfb0c, 0x05c4, 0xf3e0, 0x104f, 0xfb4e, 0x0c57, 0x0b04,
0x0abe, 0x1005, 0x077e, 0x0d4f, 0xf9c2, 0x0a17, 0xf7f5, 0x0aea, 0xffc5, 0x0e5a,
0x033b, 0x0b81, 0x0100, 0x0973, 0xfb9c, 0x08ec, 0x02ab, 0x07d2, 0x0ea8, 0x0d2a,
0x0938, 0x0f42, 0x0139, 0x0b31, 0x090e, 0x0ee8, 0x15a8, 0x157d, 0x20b7, 0x189a,
0x1d55, 0x171a, 0x15ad, 0x1c4e, 0x12b5, 0x25d6, 0x0f7c, 0x259c, 0x1288, 0x278b,
0x1d1f, 0x28ac, 0x1c93, 0x1c57, 0x1155, 0x1a37, 0x153b, 0x2069, 0x2adc, 0x1f86,
0x36f6, 0x21b5, 0x2d28, 0x2165, 0x2296, 0x1d6a, 0x28f1, 0x1ce6, 0x2ff2, 0x2014,
0x309e, 0x2b51, 0x3177, 0x302b, 0x3526, 0x2b0b, 0x3191, 0x2cc6, 0x28a2, 0x313a,
0x2776, 0x37e8, 0x2d20, 0x3c42, 0x3014, 0x328c, 0x2f51, 0x32ed, 0x2f2d, 0x3c22,
0x30dd, 0x3c88, 0x2bbb, 0x3852, 0x208b, 0x3210, 0x1e79, 0x32cd, 0x21ee, 0x3703,
0x220b, 0x352f, 0x21c6, 0x351b, 0x1cc8, 0x3472, 0x1818, 0x3026, 0x1b7c, 0x2b7d,
0x189a, 0x2145, 0x1286, 0x1be8, 0x13a6, 0x1dd6, 0x1642, 0x1f75, 0x156a, 0x2155,
0x1557, 0x232f, 0x1363, 0x2061, 0x1308, 0x2022, 0x143e, 0x1ebf, 0x11f8, 0x1876,
0x0b8c, 0x0f41, 0x0539, 0x0908, 0x05bb, 0x10e4, 0x0e14, 0x15bd, 0x08ec, 0x0415,
0xfa02, 0xf681, 0x0205, 0x000b, 0x11e1, 0x0975, 0x0b8e, 0x0381, 0xfd11, 0xfb9b,
0xfe18, 0xff32, 0xfd7e, 0xfd83, 0xfae2, 0xf5c5, 0xfe9a, 0xf1ba, 0xfe37, 0xed3a,
0xf9d3, 0xe5f6, 0xf4f4, 0xe75c, 0xf43a, 0xeb06, 0xf5c9, 0xe7e8, 0xea23, 0xe6ad,
0xdf10, 0xe508, 0xec5a, 0xe92a, 0xebd3, 0xe86d, 0xde3a, 0xe2b0, 0xe24a, 0xe8b6,
0xe633, 0xe940, 0xe915, 0xe229, 0xebeb, 0xded7, 0xeb62, 0xe12d, 0xeaae, 0xdd18,
0xe6c4, 0xd770, 0xe502, 0xdb86, 0xe9a3, 0xde03, 0xe388, 0xd578, 0xdaa2, 0xcf2d,
0xe0b3, 0xd737, 0xe050, 0xd971, 0xd449, 0xd022, 0xd135, 0xcc5d, 0xd3fd, 0xd402,
0xd4c7, 0xd6e2, 0xd466, 0xd550, 0xdc4d, 0xd989, 0xe31f, 0xdc97, 0xdc0a, 0xd6cf,
0xd95e, 0xd1a0, 0xe17b, 0xd487, 0xe110, 0xd1cd, 0xd922, 0xc9a3, 0xd661, 0xc9c5,
0xd36c, 0xcb6c, 0xcbd5, 0xc65b, 0xc7c3, 0xb9b5, 0xc7ff, 0xb482, 0xc59c, 0xb438,
0xc5b5, 0xb5d1, 0xca74, 0xbb25, 0xc45f, 0xb776, 0xbb64, 0xb4cb, 0xc26e, 0xba1e,
0xc8ae, 0xb4d5, 0xba66, 0xaa41, 0xb835, 0xa97a, 0xc53f, 0xae30, 0xca28, 0xb476,
0xcaf8, 0xb96c, 0xcbe2, 0xb7e5, 0xcac2, 0xbaf2, 0xcbf5, 0xbeda, 0xcdfa, 0xbaa9,
0xd100, 0xc099, 0xd18f, 0xc97b, 0xcf2d, 0xc7a6, 0xd2a0, 0xcb8b, 0xd52e, 0xd14d,
0xce07, 0xcebf, 0xc972, 0xc6cc, 0xce6a, 0xc071, 0xd427, 0xc193, 0xd2da, 0xc4c1,
0xcc1d, 0xc481, 0xc952, 0xc14b, 0xcd1b, 0xc364, 0xd19a, 0xcac6, 0xcd99, 0xcca0,
0xcb72, 0xccb1, 0xd6f2, 0xd1ac, 0xdd51, 0xd50a, 0xd266, 0xd132, 0xd147, 0xd000,
0xd9ce, 0xcc5c, 0xdbcf, 0xc862, 0xda0a, 0xce34, 0xdaa5, 0xd360, 0xde28, 0xd654,
0xe2cd, 0xd5ae, 0xe7e3, 0xd5ef, 0xed69, 0xdb93, 0xf14b, 0xe0a9, 0xf9d2, 0xe91e,
0xff02, 0xed30, 0xf5a8, 0xeb28, 0xf14d, 0xeb81, 0xf391, 0xf028, 0xfb0b, 0xf60a,
0x02d9, 0xfc42, 0x0663, 0x02ba, 0x0bc7, 0x0728, 0x0f69, 0x092e, 0x13db, 0x0be3,
0x133a, 0x0d9b, 0x0f11, 0x0e3d, 0x1d12, 0x10c5, 0x2a3e, 0x1308, 0x2016, 0x0ebf,
0x17b9, 0x0ee0, 0x20d1, 0x1702, 0x2bd6, 0x1947, 0x2dcc, 0x16ef, 0x2fea, 0x1884,
0x32a4, 0x1d46, 0x3046, 0x2573, 0x3406, 0x2a86, 0x3c95, 0x2f47, 0x3532, 0x36a8,
0x2bc9, 0x37ae, 0x37e1, 0x3e35, 0x3c8f, 0x4234, 0x3785, 0x3fe6, 0x4113, 0x41f8,
0x479d, 0x3d0f, 0x4111, 0x357c, 0x3b5b, 0x3b02, 0x3a14, 0x3dcb, 0x3d56, 0x3b78,
0x432d, 0x3a09, 0x4271, 0x378c, 0x4602, 0x3ca8, 0x4c19, 0x3f8a, 0x48df, 0x3b55,
0x44d7, 0x3ba2, 0x471f, 0x4138, 0x4581, 0x4584, 0x4255, 0x4ac8, 0x4572, 0x4a2c,
0x491d, 0x4985, 0x4c48, 0x4ba3, 0x4eb7, 0x4d4b, 0x4e4c, 0x4e5d, 0x4d58, 0x4e14,
0x5169, 0x5054, 0x4c32, 0x4d1c, 0x42b2, 0x48cb, 0x4ac4, 0x4a22, 0x4fd9, 0x44fb,
0x4698, 0x42b1, 0x41c0, 0x42be, 0x3d94, 0x3fdd, 0x42e8, 0x3f3d, 0x49fb, 0x3c13,
0x450b, 0x365f, 0x3d4f, 0x3823, 0x3c97, 0x3f1b, 0x3f21, 0x3efc, 0x3cfa, 0x3c62,
0x3dea, 0x3c4c, 0x3ee0, 0x358b, 0x2dd0, 0x305b, 0x27e6, 0x38cd, 0x2e7b, 0x390b,
0x2493, 0x301e, 0x2307, 0x2c21, 0x2c35, 0x2c0a, 0x2c89, 0x2a63, 0x27e5, 0x2bc3,
0x251f, 0x2e7f, 0x2b3d, 0x2ece, 0x2ce3, 0x2fae, 0x22e7, 0x2f93, 0x1c49, 0x2c54,
0x1b6a, 0x2945, 0x13f7, 0x293b, 0x11e1, 0x25a7, 0x175e, 0x1e1c, 0x10f0, 0x16c2,
0x082e, 0x14ee, 0x0d4d, 0x1407, 0x1203, 0x0ef9, 0x0c4c, 0x0b1e, 0x026e, 0x0a2c,
0x043d, 0x0b44, 0x0de9, 0x0864, 0x0299, 0x0123, 0xeceb, 0xf980, 0xf09d, 0xfa15,
0xfc61, 0xf8fd, 0xfcfb, 0xf32a, 0xf787, 0xf206, 0xf464, 0xef9f, 0xefca, 0xe63f,
0xe97f, 0xe2a9, 0xe42f, 0xe518, 0xe4d4, 0xe928, 0xeae6, 0xe5e4, 0xf163, 0xdf17,
0xf114, 0xddf1, 0xe100, 0xddd4, 0xd62b, 0xddfa, 0xda45, 0xe105, 0xdf20, 0xe249,
0xd968, 0xdf6b, 0xd373, 0xdcf9, 0xd328, 0xd89b, 0xd5db, 0xd46d, 0xd896, 0xd0ba,
0xd705, 0xcbc6, 0xd606, 0xc8b2, 0xd639, 0xc854, 0xcf61, 0xc62f, 0xd455, 0xcb71,
0xdc22, 0xd2f4, 0xce8a, 0xc9c0, 0xc265, 0xc208, 0xc2c4, 0xbff7, 0xc339, 0xbed0,
0xc106, 0xbbe6, 0xbed9, 0xb93e, 0xbdc7, 0xb8ed, 0xbca8, 0xb575, 0xb7de, 0xb190,
0xb524, 0xb642, 0xaf22, 0xb18b, 0xacfe, 0xac8b, 0xb0e2, 0xb71f, 0xb29b, 0xb4c0,
0xb4b2, 0xaaab, 0xb723, 0xa891, 0xb965, 0xad16, 0xb978, 0xaece, 0xb926, 0xaef2,
0xb6b4, 0xb065, 0xb1d9, 0xb1f4, 0xb204, 0xaf34, 0xb5eb, 0xb0dc, 0xbcf5, 0xbd55,
0xba80, 0xbefb, 0xab85, 0xb418, 0xb124, 0xb381, 0xbf41, 0xb725, 0xc152, 0xbbbc,
0xbea1, 0xc160, 0xc247, 0xc533, 0xc5e2, 0xc672, 0xc651, 0xc17f, 0xc6d6, 0xbd79,
0xc8e3, 0xc045, 0xcafe, 0xc455, 0xc0f2, 0xbdf4, 0xaedf, 0xb381, 0xb8a9, 0xb4cb,
0xce9d, 0xbc82, 0xcf87, 0xc3da, 0xc98d, 0xc133, 0xc945, 0xbcec, 0xc924, 0xc305,
0xccf3, 0xca87, 0xd036, 0xccea, 0xd32c, 0xd187, 0xd869, 0xd54d, 0xd84d, 0xd8ed,
0xd51c, 0xdd26, 0xd6a4, 0xdeb2, 0xdc90, 0xdc94, 0xda72, 0xd925, 0xdad7, 0xdf92,
0xe1cf, 0xe888, 0xe488, 0xef76, 0xe4e1, 0xf32d, 0xe59c, 0xf3c7, 0xe5da, 0xf1c2,
0xe87a, 0xeffc, 0xec7c, 0xf0a9, 0xf36e, 0xf607, 0xfbdb, 0xf705, 0xfc07, 0xfa10,
0xfc84, 0x0387, 0x0242, 0x0693, 0x0452, 0x0484, 0x08a3, 0x0439, 0x13c0, 0x07ce,
0x1811, 0x0a5f, 0x196b, 0x0f13, 0x1c50, 0x14fa, 0x1ed2, 0x1549, 0x1fd7, 0x10dd,
0x1e2f, 0x11af, 0x1f09, 0x195c, 0x245c, 0x2390, 0x2240, 0x2206, 0x175e, 0x1733,
0x17b3, 0x1b1c, 0x23c2, 0x2572, 0x266e, 0x298b, 0x2224, 0x29a7, 0x1df4, 0x2a7f,
0x2034, 0x2a19, 0x24bb, 0x2bc2, 0x2570, 0x2ec4, 0x2920, 0x328a, 0x2924, 0x3407,
0x2972, 0x330d, 0x3892, 0x3982, 0x3e96, 0x3de1, 0x3084, 0x3b0b, 0x3116, 0x3f94,
0x3d24, 0x45ac, 0x3c72, 0x4300, 0x3cd5, 0x446c, 0x3dd9, 0x458a, 0x41c1, 0x4713,
0x4310, 0x4c34, 0x407d, 0x508f, 0x4499, 0x5281, 0x4598, 0x5186, 0x3e8f, 0x526f,
0x4009, 0x545d, 0x3ed7, 0x4a8d, 0x35a3, 0x4331, 0x39cb, 0x4c37, 0x4768, 0x553b,
0x45f4, 0x52ee, 0x41b2, 0x4c40, 0x4129, 0x48a6, 0x3ef0, 0x4c33, 0x3ee5, 0x5030,
0x3ff4, 0x4c3c, 0x3fd5, 0x49c2, 0x41c9, 0x4b25, 0x430c, 0x4b84, 0x3b95, 0x4760,
0x3f3a, 0x4761, 0x3f9f, 0x4948, 0x3371, 0x43c9, 0x30ae, 0x3bf8, 0x32f8, 0x3a01,
0x32c1, 0x3f72, 0x3280, 0x4341, 0x3283, 0x4493, 0x35c7, 0x47f5, 0x36d1, 0x46b8,
0x318e, 0x40d2, 0x3906, 0x3e3a, 0x3e49, 0x3d5a, 0x3694, 0x3a86, 0x325a, 0x3d48,
0x37f6, 0x42c2, 0x39ce, 0x3f88, 0x3622, 0x3d62, 0x2df1, 0x3808, 0x27db, 0x363c,
0x283b, 0x3c1d, 0x22d9, 0x3cea, 0x1bd0, 0x3640, 0x1e32, 0x332c, 0x2386, 0x3055,
0x2634, 0x2a68, 0x1e9c, 0x2561, 0x0f52, 0x1e70, 0x141a, 0x2065, 0x1c8c, 0x2194,
0x1975, 0x1a07, 0x1442, 0x189e, 0x127d, 0x1bf3, 0x13cc, 0x1949, 0x0d4b, 0x10d6,
0x076d, 0x0cfd, 0x0fbe, 0x0d99, 0x0b97, 0x05ce, 0xfccd, 0x01e4, 0x02cd, 0x09bc,
0x0c87, 0x0ed8, 0x0908, 0x0beb, 0x004d, 0x0816, 0xfd12, 0x04b7, 0xfc57, 0x0096,
0xfd4e, 0xfe60, 0xfba3, 0xfe31, 0xf690, 0xfc4c, 0xf243, 0xfb0f, 0xf2b0, 0xfae4,
0xf3f7, 0xf554, 0xf16b, 0xf049, 0xeedb, 0xe9d2, 0xf344, 0xeb58, 0xf511, 0xf00b,
0xefd1, 0xe95f, 0xe990, 0xe668, 0xe64e, 0xe791, 0xe64e, 0xe3f2, 0xe244, 0xe382,
0xdd3d, 0xe51a, 0xe013, 0xe447, 0xdc5a, 0xddbf, 0xd4a8, 0xd976, 0xdcc6, 0xddc0,
0xe295, 0xe205, 0xdc9e, 0xda02, 0xe0ac, 0xd2cc, 0xe6c4, 0xd796, 0xe3d5, 0xd980,
0xdcd3, 0xd7f2, 0xd91d, 0xd730, 0xd7fe, 0xd522, 0xd5b7, 0xd4ca, 0xd388, 0xd42e,
0xd58e, 0xd2dc, 0xcfc5, 0xd626, 0xc67f, 0xdbe3, 0xc9d9, 0xd70a, 0xce75, 0xc972,
0xc5f2, 0xc40c, 0xc404, 0xc730, 0xca53, 0xc699, 0xc51b, 0xc1e2, 0xc1f4, 0xc32c,
0xc06d, 0xc4c4, 0xc1e4, 0xc3f9, 0xc154, 0xc56c, 0xbeca, 0xc967, 0xc4f8, 0xc95d,
0xc3d8, 0xc7fa, 0xbdca, 0xcdb1, 0xc8e6, 0xd654, 0xd029, 0xd57d, 0xcdea, 0xd3a0,
0xcfd4, 0xd498, 0xcce0, 0xd0c5, 0xcbda, 0xd2df, 0xcf5a, 0xd3a9, 0xcd03, 0xd00e,
0xca72, 0xcf28, 0xcc59, 0xd009, 0xcdd2, 0xd28c, 0xd421, 0xd2db, 0xd6fa, 0xd17f,
0xcfe5, 0xd4d1, 0xd25e, 0xce38, 0xd544, 0xc79f, 0xd16d, 0xccf2, 0xd274, 0xd527,
0xd63f, 0xd9e7, 0xd5e9, 0xdd4c, 0xd546, 0xe060, 0xd4da, 0xe388, 0xd2a3, 0xe563,
0xd34d, 0xebc2, 0xd18b, 0xf142, 0xd491, 0xeff8, 0xd6c5, 0xe983, 0xdcdb, 0xe834,
0xe590, 0xf2c4, 0xe565, 0xf064, 0xe587, 0xebfb, 0xe99a, 0xf1ab, 0xee18, 0xf45d,
0xf158, 0xf4d8, 0xf23c, 0xf5b4, 0xf55e, 0xf729, 0xfe6a, 0xf821, 0x02b6, 0xf597,
0xfd49, 0xf918, 0xfb1e, 0x003d, 0xf4e6, 0xfdbe, 0xf434, 0xfcca, 0xff09, 0x0518,
0xfd1b, 0x0465, 0xf985, 0x0527, 0xfb96, 0x0bf6, 0xfe1f, 0x0da5, 0x0128, 0x1015,
0x00e6, 0x153f, 0x0563, 0x1972, 0x0c79, 0x17f3, 0x05c9, 0x1322, 0x049b, 0x17ec,
0x140f, 0x1f64, 0x149d, 0x1b41, 0x0a6a, 0x1b7b, 0x0dcd, 0x2225, 0x11ec, 0x206e,
0x0edc, 0x1b21, 0x0f4f, 0x1dce, 0x1515, 0x2665, 0x1de7, 0x2906, 0x1ad6, 0x2755,
0x169b, 0x244d, 0x2280, 0x225d, 0x25f2, 0x2aa4, 0x1dbf, 0x31bf, 0x203b, 0x2f7b,
0x2596, 0x3274, 0x260d, 0x3826, 0x285a, 0x36ab, 0x2b65, 0x36d1, 0x2bc9, 0x3a30,
0x31b5, 0x3f13, 0x3a01, 0x44a8, 0x399b, 0x4666, 0x36fe, 0x45b2, 0x3865, 0x474c,
0x3556, 0x43a9, 0x2eed, 0x3a90, 0x3383, 0x38d2, 0x3d5b, 0x408a, 0x39bc, 0x466a,
0x30db, 0x4612, 0x310f, 0x4201, 0x2cd7, 0x3dde, 0x2a13, 0x3fc4, 0x2d96, 0x44c1,
0x2ef6, 0x4499, 0x28ab, 0x3e20, 0x2852, 0x3cd2, 0x3397, 0x3e21, 0x3ac2, 0x3e0f,
0x3bdd, 0x4064, 0x3767, 0x3f4b, 0x3262, 0x4152, 0x3278, 0x4486, 0x32e3, 0x4189,
0x348b, 0x4024, 0x333d, 0x42a9, 0x2e7e, 0x45de, 0x2d93, 0x464b, 0x3068, 0x4290,
0x31d2, 0x40c2, 0x3056, 0x4155, 0x2c38, 0x3fab, 0x2d03, 0x3e54, 0x3152, 0x4021,
0x2f3c, 0x432d, 0x282d, 0x3ef9, 0x27f4, 0x3757, 0x26cd, 0x3422, 0x1eeb, 0x3638,
0x1b68, 0x39b9, 0x1d5b, 0x38bd, 0x2099, 0x3584, 0x231f, 0x33f9, 0x265f, 0x33f8,
0x264c, 0x3171, 0x2598, 0x2bd5, 0x2480, 0x2b43, 0x21c2, 0x30ce, 0x241a, 0x3075,
0x233e, 0x29a0, 0x1d96, 0x2515, 0x183d, 0x23cb, 0x1507, 0x22aa, 0x1698, 0x2055,
0x189f, 0x1dca, 0x1822, 0x1983, 0x130c, 0x1259, 0x0c69, 0x152c, 0x0fc3, 0x19ec,
0x15a3, 0x0feb, 0x1043, 0x0a65, 0x05c1, 0x0a36, 0x042f, 0x058b, 0x063f, 0x05c4,
0x006e, 0x0448, 0xfa13, 0x02e6, 0xf8e4, 0x0766, 0xf993, 0x077f, 0xf94c, 0x02fb,
0xf637, 0x001d, 0xfa5a, 0xfade, 0xfbcc, 0xfb23, 0xf101, 0xfc7d, 0xea29, 0xfc54,
0xeb9d, 0xfb2f, 0xea67, 0xff02, 0xe5bc, 0xfe65, 0xe134, 0xf84b, 0xdbbf, 0xf52f,
0xd852, 0xf3c6, 0xd81d, 0xf364, 0xd931, 0xf385, 0xdcb6, 0xf05d, 0xe013, 0xec16,
0xded5, 0xea77, 0xdb26, 0xe939, 0xd218, 0xe8e9, 0xc81a, 0xe363, 0xccd3, 0xe1d8,
0xd2f5, 0xe47d, 0xd0fb, 0xdcdd, 0xd3b1, 0xd518, 0xd4bd, 0xd436, 0xd076, 0xcff8,
0xd371, 0xcc95, 0xd28d, 0xca83, 0xcce8, 0xcc15, 0xcf64, 0xcc9c, 0xd09f, 0xc624,
0xcc00, 0xc318, 0xcc88, 0xc6a1, 0xce92, 0xc70e, 0xccc6, 0xc5f1, 0xc9e9, 0xc5c2,
0xc783, 0xc2b5, 0xc678, 0xc240, 0xc401, 0xc0a5, 0xc0f4, 0xbf04, 0xbfb0, 0xc049,
0xbd06, 0xc25c, 0xc070, 0xc4db, 0xbe09, 0xc386, 0xb0e3, 0xbfc8, 0xb73e, 0xbd3e,
0xc125, 0xbba3, 0xb669, 0xbca6, 0xb0d1, 0xbe55, 0xb55d, 0xbcee, 0xb351, 0xbacb,
0xb281, 0xbbd8, 0xb57b, 0xbb84, 0xb8f7, 0xbd06, 0xb863, 0xbcf9, 0xb545, 0xb9bb,
0xb931, 0xb8ed, 0xbc8d, 0xbc14, 0xbacf, 0xba14, 0xbd81, 0xb749, 0xbff6, 0xbc51,
0xbbd4, 0xbbd2, 0xbe0a, 0xbc30, 0xbe48, 0xbdb8, 0xbc08, 0xbd09, 0xbada, 0xbe74,
0xb955, 0xc141, 0xb8de, 0xc043, 0xb897, 0xbfa0, 0xbae0, 0xbb26, 0xbd30, 0xb73c,
0xba12, 0xc224, 0xbabb, 0xc517, 0xc1ec, 0xb9b6, 0xc009, 0xb4f7, 0xbf32, 0xbcd1,
0xc579, 0xc0e3, 0xc79c, 0xbf9c, 0xc778, 0xbfa3, 0xc573, 0xbd9d, 0xc4d1, 0xbdea,
0xc94a, 0xc1d9, 0xccd6, 0xcd1c, 0xcd24, 0xd2c0, 0xcf4e, 0xd05b, 0xd0ce, 0xd0d0,
0xd1d0, 0xd169, 0xd7b4, 0xd175, 0xd829, 0xd488, 0xd686, 0xd6e7, 0xd91b, 0xd961,
0xd953, 0xd7fa, 0xdacf, 0xd5f0, 0xdba6, 0xd833, 0xd9c4, 0xda7e, 0xdb0e, 0xd74c,
0xdbad, 0xd8c2, 0xda20, 0xe37a, 0xdff4, 0xe91b, 0xe612, 0xe855, 0xde7b, 0xeaba,
0xdd64, 0xf14b, 0xe77b, 0xf827, 0xe790, 0xf7cd, 0xe551, 0xf4de, 0xe998, 0xf64f,
0xf125, 0xfa5e, 0xf5ce, 0xfd3d, 0xf70c, 0xfbcc, 0xfb71, 0xfa1e, 0xfe44, 0xf9e9,
0xfdc7, 0xfed8, 0xfab3, 0xfdfb, 0x0272, 0xffc7, 0x09fa, 0x015a, 0x08e2, 0xff28,
0x0863, 0xffb3, 0x0542, 0x0029, 0x056f, 0x0212, 0x0ab2, 0x0424, 0x0f78, 0x0629,
0x10a7, 0x05e9, 0x1197, 0x0476, 0x184d, 0x02d1, 0x22c0, 0x04ee, 0x178f, 0x0b1a,
0x0e3e, 0x0bae, 0x168e, 0x0ee5, 0x1a01, 0x1498, 0x1f94, 0x19af, 0x230a, 0x1d91,
0x21be, 0x1df7, 0x1fff, 0x1877, 0x1cbc, 0x16f8, 0x1e99, 0x1af6, 0x24db, 0x1c9e,
0x219d, 0x1cfa, 0x1d6e, 0x1bea, 0x291a, 0x1e04, 0x2a3d, 0x21f0, 0x219f, 0x1fb6,
0x267f, 0x1f2e, 0x2c32, 0x2585, 0x2952, 0x2693, 0x27f8, 0x244f, 0x2afd, 0x2305,
0x2f25, 0x2480, 0x2ee6, 0x27bd, 0x321a, 0x2cfa, 0x3651, 0x2df0, 0x2e63, 0x2c46,
0x2744, 0x2a8c, 0x3249, 0x2b04, 0x34e4, 0x2b25, 0x2a8c, 0x29a1, 0x2f96, 0x2b4c,
0x3920, 0x2b05, 0x3bbe, 0x29ea, 0x3d99, 0x2b2e, 0x411a, 0x2f11, 0x41f5, 0x2f96,
0x3dd0, 0x2f78, 0x3c27, 0x2e88, 0x4274, 0x3011, 0x426d, 0x314c, 0x3c5b, 0x2b01,
0x3c5b, 0x2881, 0x3d14, 0x2c51, 0x3b45, 0x2f82, 0x3b37, 0x328c, 0x3bfa, 0x34cd,
0x3e38, 0x31e8, 0x3f56, 0x2f03, 0x3e38, 0x2e5c, 0x42c1, 0x2f60, 0x3f8d, 0x2b44,
0x36e9, 0x260c, 0x36cf, 0x26ce, 0x3b36, 0x270d, 0x3a47, 0x24f7, 0x3b95, 0x28bd,
0x3d5b, 0x2d04, 0x3a10, 0x3083, 0x3a0e, 0x3288, 0x3c11, 0x33a6, 0x3a8e, 0x33fe,
0x3aa9, 0x3357, 0x3b16, 0x32a0, 0x3b58, 0x2dde, 0x3ce8, 0x258d, 0x3a74, 0x216a,
0x373c, 0x25f2, 0x3b97, 0x2b7b, 0x390c, 0x271c, 0x3244, 0x2486, 0x34a5, 0x2b05,
0x38da, 0x2aa4, 0x3a7a, 0x263c, 0x3848, 0x269e, 0x33e7, 0x2678, 0x2fff, 0x2506,
0x2d5b, 0x2305, 0x2bbb, 0x1f7c, 0x2e20, 0x2002, 0x2d4c, 0x1c36, 0x2909, 0x1ba1,
0x2d16, 0x2333, 0x2e98, 0x231c, 0x2b7a, 0x1e11, 0x28b0, 0x1cf5, 0x26f0, 0x1b76,
0x29cc, 0x1a51, 0x2de4, 0x1c96, 0x2f25, 0x1b12, 0x2ea8, 0x1721, 0x28d0, 0x155f,
0x2648, 0x14f6, 0x22b6, 0x13bf, 0x18df, 0x0dad, 0x1905, 0x0c84, 0x1eda, 0x105c,
0x1b1c, 0x0dd8, 0x153c, 0x0a05, 0x149d, 0x0ba3, 0x1366, 0x0d81, 0x128d, 0x09fa,
0x1419, 0x0587, 0x1604, 0x0532, 0x1064, 0x027f, 0x08c3, 0xff4b, 0x104c, 0x0088,
0x141a, 0x02d1, 0x0d2c, 0x0088, 0x0839, 0xf98a, 0x097c, 0xf602, 0x07a8, 0xf6d1,
0x05cb, 0xf93e, 0x07df, 0xfa33, 0x088d, 0xf958, 0x0436, 0xf755, 0x01b1, 0xf792,
0x0152, 0xf530, 0xfe23, 0xf2d4, 0xfc5f, 0xf305, 0xf6ba, 0xee7a, 0xef63, 0xe8b6,
0xf18e, 0xe8ec, 0xf5e8, 0xea51, 0xf4b3, 0xe825, 0xf1ae, 0xe4bc, 0xf0ed, 0xe27f,
0xf1eb, 0xe2c5, 0xf1f3, 0xe167, 0xf03c, 0xdfda, 0xefc0, 0xdff5, 0xf168, 0xdf51,
0xf11e, 0xdc84, 0xf095, 0xdca4, 0xeee3, 0xdcce, 0xea08, 0xdd65, 0xe5f7, 0xdeb9,
0xe60e, 0xdcc5, 0xe9a3, 0xd917, 0xeb15, 0xd849, 0xeb16, 0xdaae, 0xe948, 0xda4d,
0xe9b4, 0xd93d, 0xea5f, 0xd893, 0xeab6, 0xd59b, 0xeb13, 0xd3ab, 0xea64, 0xd467,
0xe4b9, 0xd64b, 0xdf11, 0xd489, 0xe2a8, 0xce43, 0xe3dc, 0xcda2, 0xe21c, 0xd10d,
0xe482, 0xd4be, 0xe594, 0xd52a, 0xe4d2, 0xd442, 0xe5b1, 0xd675, 0xe7f1, 0xd996,
0xe95b, 0xd8d2, 0xe5e3, 0xd5e9, 0xe4f9, 0xd09a, 0xe77e, 0xcf61, 0xe2aa, 0xd41a,
0xe1cc, 0xd65c, 0xe2e5, 0xd5b0, 0xe299, 0xd614, 0xe3dc, 0xd7ca, 0xe359, 0xd659,
0xe4ec, 0xd469, 0xe65a, 0xd4e7, 0xe701, 0xd2db, 0xea99, 0xd07b, 0xedd1, 0xd3d7,
0xe841, 0xd3f7, 0xe49d, 0xd020, 0xe9f5, 0xd57d, 0xeab2, 0xdaa8, 0xe5e3, 0xd807,
0xe5dd, 0xd876, 0xe9a9, 0xdbe4, 0xec93, 0xde16, 0xec28, 0xde2e, 0xe836, 0xdd51,
0xe451, 0xe051, 0xe37c, 0xe3e1, 0xe721, 0xe3c2, 0xeacd, 0xe327, 0xf237, 0xde93,
0xf81f, 0xda2a, 0xf66d, 0xd994, 0xf40b, 0xda65, 0xf2ec, 0xdaec, 0xf353, 0xdc45,
0xf126, 0xdcf9, 0xf0b2, 0xddc3, 0xf266, 0xdcda, 0xf290, 0xdb73, 0xf0ff, 0xde8b,
0xf1c6, 0xe0e5, 0xf48b, 0xe05f, 0xed82, 0xdc67, 0xe304, 0xdef2, 0xe983, 0xe8cb,
0xf516, 0xe917, 0xf7f2, 0xdf79, 0xf935, 0xdaf8, 0xfcd1, 0xdb4e, 0xfe19, 0xde0e,
0xfd38, 0xdfd9, 0xfcb6, 0xe112, 0xfe6b, 0xe4b0, 0xff66, 0xe726, 0xf827, 0xe8d6,
0xf3ba, 0xef05, 0xfab7, 0xf689, 0x0086, 0xfa47, 0xfceb, 0xf76e, 0xfadd, 0xf091,
0xfe4e, 0xf13c, 0x0057, 0xf483, 0x0156, 0xf538, 0x0611, 0xf5c7, 0x08ec, 0xf6db,
0x08c5, 0xf5d0, 0x0910, 0xf552, 0x0d0c, 0xf55b, 0x13b3, 0xf72f, 0x0fb4, 0xf54f,
0x0c09, 0xf4fb, 0x1360, 0xfc8b, 0x1777, 0xfd1a, 0x168d, 0xfa76, 0x1461, 0xfb13,
0x12c2, 0xfbda, 0x1378, 0x004f, 0x1380, 0x045f, 0x12ee, 0x023b, 0x14df, 0x00d1,
0x1718, 0x01d8, 0x1c0d, 0x07e9, 0x20b9, 0x0dca, 0x1e15, 0x06f8, 0x1b4c, 0x017d,
0x1ec7, 0x036d, 0x239a, 0x0244, 0x239b, 0x00b9, 0x1f62, 0x0220, 0x2100, 0x0481,
0x239a, 0x0146, 0x2306, 0xfc99, 0x25db, 0xfde0, 0x28a4, 0x04dd, 0x287f, 0x095a,
0x27f0, 0x0a09, 0x28c2, 0x0765, 0x25e3, 0x052e, 0x254d, 0x0929, 0x24b4, 0x1035,
0x2245, 0x13d5, 0x247b, 0x1513, 0x2638, 0x1568, 0x25f2, 0x15f4, 0x25f1, 0x16e1,
0x253e, 0x1815, 0x272d, 0x1870, 0x2b93, 0x176e, 0x2ac0, 0x1614, 0x2768, 0x14dd,
0x2b2f, 0x16ae, 0x3264, 0x160e, 0x3241, 0x14f7, 0x2f57, 0x152f, 0x314f, 0x16ca,
0x32f9, 0x1742, 0x3150, 0x13d0, 0x2eec, 0x151b, 0x30c8, 0x17af, 0x34a5, 0x16c1,
0x3302, 0x1ab7, 0x3088, 0x1c2c, 0x3123, 0x154b, 0x2fd5, 0x17f8, 0x2dc7, 0x208d,
0x2fe4, 0x1d9d, 0x2d94, 0x17f4, 0x2a47, 0x1937, 0x2d90, 0x1d1a, 0x2f6d, 0x1d85,
0x2e4c, 0x1c11, 0x2bc8, 0x1abe, 0x285d, 0x19c1, 0x27cc, 0x1728, 0x26d4, 0x1557,
0x2764, 0x1636, 0x2ba6, 0x190e, 0x28ac, 0x1cfb, 0x23de, 0x1baa, 0x247f, 0x19a8,
0x258e, 0x1a78, 0x2375, 0x1c6a, 0x240c, 0x1bc2, 0x2104, 0x16fb, 0x1cc7, 0x12d1,
0x1b30, 0x111a, 0x1998, 0x11c0, 0x1c19, 0x1355, 0x1ec6, 0x11e3, 0x18d6, 0x0e06,
0x17d4, 0x1156, 0x1ca0, 0x119d, 0x1734, 0x0cef, 0x1474, 0x0e47, 0x1744, 0x0fe3,
0x1642, 0x0cee, 0x1727, 0x09a4, 0x1a5e, 0x0759, 0x1b3e, 0x07bd, 0x1c1f, 0x0a80,
0x16da, 0x07ed, 0x126e, 0x08e4, 0x1506, 0x0ae9, 0x168d, 0x089c, 0x1786, 0x0b63,
0x16cd, 0x0d4f, 0x127c, 0x0791, 0x115d, 0x0236, 0x1055, 0xffc8, 0x0d83, 0xfd6f,
0x0cc2, 0xfc34, 0x0be3, 0xf9f0, 0x0a18, 0xf5e4, 0x06e9, 0xf58d, 0x0788, 0xf546,
0x09f4, 0xf37b, 0x0847, 0xf48f, 0x0702, 0xf1e9, 0x0654, 0xf1b1, 0x03a6, 0xf37f,
0xffad, 0xf141, 0x005b, 0xefa1, 0xfe2d, 0xef91, 0xf6de, 0xeda0, 0xf305, 0xebd8,
0xeee3, 0xef4c, 0xeb2d, 0xf0ef, 0xf162, 0xf13d, 0xf5e6, 0xf163, 0xee54, 0xec58,
0xecb9, 0xeef0, 0xf173, 0xf190, 0xeded, 0xefb3, 0xec63, 0xeed6, 0xed4c, 0xeee6,
0xec23, 0xed52, 0xeb45, 0xea28, 0xe947, 0xe801, 0xe5cd, 0xe451, 0xe027, 0xdeb7,
0xdb21, 0xdb58, 0xe553, 0xdcbe, 0xea89, 0xdc13, 0xe186, 0xda3c, 0xdcfa, 0xdc63,
0xdbdc, 0xde15, 0xd9bf, 0xdb45, 0xd7ed, 0xd99a, 0xda6b, 0xd9c2, 0xdde1, 0xd77f,
0xe131, 0xd829, 0xe32d, 0xd77b, 0xe057, 0xd50b, 0xdad0, 0xd488, 0xdaa5, 0xd50a,
0xddab, 0xd692, 0xdc3e, 0xd4cf, 0xd73d, 0xd28b, 0xd5c5, 0xd294, 0xd714, 0xd20d,
0xd7e8, 0xd315, 0xd703, 0xd359, 0xd7dc, 0xd3cf, 0xd6bb, 0xd422, 0xd4e0, 0xd48c,
0xd5d5, 0xd501, 0xd48a, 0xd528, 0xd315, 0xd36e, 0xdaaa, 0xca5e, 0xdfa7, 0xc2da,
0xdaf4, 0xc6c2, 0xdb1f, 0xccee, 0xde84, 0xcadf, 0xdc4e, 0xcaa4, 0xd8b1, 0xcd7f,
0xd739, 0xce73, 0xd5db, 0xcec7, 0xd4c3, 0xd0b4, 0xd40c, 0xd180, 0xd679, 0xcf3d,
0xd74e, 0xcb8c, 0xd4b2, 0xce62, 0xd5f9, 0xd1d6, 0xd913, 0xcdca, 0xd95d, 0xced8,
0xd71e, 0xd103, 0xd4a1, 0xcdc1, 0xd58c, 0xcb2d, 0xd8d6, 0xcb70, 0xd94f, 0xcb8a,
0xda2b, 0xcb50, 0xdc2c, 0xccd1, 0xdc71, 0xd0ad, 0xd815, 0xd082, 0xd186, 0xc9e9,
0xd17a, 0xceda, 0xd3f9, 0xd323, 0xd0c0, 0xcda7, 0xd417, 0xd2f7, 0xd953, 0xd904,
0xd9bb, 0xd70b, 0xdaec, 0xd94c, 0xdab4, 0xd9b6, 0xdb38, 0xd7f3, 0xda34, 0xd724,
0xdaa4, 0xd747, 0xdb7e, 0xdbdd, 0xd828, 0xdc90, 0xd73f, 0xd5a8, 0xdabc, 0xd4c5,
0xdc1e, 0xda2f, 0xd75b, 0xd780, 0xd759, 0xd47e, 0xdabc, 0xd432, 0xdc12, 0xd2d2,
0xdf30, 0xd2f4, 0xe2d5, 0xd274, 0xe520, 0xd501, 0xe409, 0xd951, 0xe0c8, 0xddbc,
0xdfd6, 0xddc8, 0xdf46, 0xdb87, 0xe07f, 0xde28, 0xdf0f, 0xe59a, 0xdb76, 0xe5d3,
0xde46, 0xe5c5, 0xe12d, 0xe962, 0xe078, 0xe734, 0xe247, 0xe580, 0xe275, 0xe684,
0xe1d1, 0xe695, 0xe170, 0xe4d1, 0xe4e7, 0xe586, 0xe9f5, 0xe581, 0xe8fc, 0xe0ec,
0xe898, 0xdc8e, 0xeba4, 0xe0c3, 0xed38, 0xe4f0, 0xe99e, 0xe2fe, 0xe5e4, 0xe330,
0xe487, 0xe543, 0xe60e, 0xe6af, 0xe864, 0xe869, 0xe797, 0xe9e5, 0xe515, 0xebd3,
0xe831, 0xeea4, 0xedf4, 0xeff4, 0xecfe, 0xf36f, 0xedd9, 0xf573, 0xec94, 0xf011,
0xecfd, 0xee39, 0xf116, 0xed9e, 0xf279, 0xedaa, 0xf3d1, 0xf038, 0xf6b5, 0xf3de,
0xf92c, 0xf64a, 0xfaaa, 0xfb4b, 0xfb02, 0xfe80, 0xfa7f, 0x0056, 0xf8a4, 0x03e5,
0xf9b1, 0x0168, 0xff7b, 0xffab, 0xfbe8, 0x03a4, 0xf70c, 0x0713, 0xfc41, 0x0883,
0xfeb8, 0x0934, 0xfc42, 0x086f, 0xfd0f, 0x078f, 0xff89, 0x07ff, 0x018e, 0x0972,
0x048d, 0x0ca3, 0x06a7, 0x0d8f, 0x0c07, 0x0cf7, 0x0e7d, 0x0f49, 0x0aa1, 0x0d4b,
0x0c54, 0x068c, 0x1031, 0x03e3, 0x0bd6, 0x0a0a, 0x0c6f, 0x0da6, 0x1259, 0x103f,
0x1202, 0x1349, 0x1032, 0x1483, 0x0f53, 0x163e, 0x10c2, 0x18f4, 0x124d, 0x1b87,
0x114b, 0x1b79, 0x1643, 0x1a6a, 0x1ae0, 0x1c08, 0x15c1, 0x1fee, 0x1403, 0x2083,
0x14ca, 0x2325, 0x1584, 0x2793, 0x1730, 0x2857, 0x1994, 0x2a68, 0x1cf7, 0x2d6d,
0x1e98, 0x2da5, 0x1ff2, 0x2daf, 0x2215, 0x2e42, 0x224e, 0x2f46, 0x24c1, 0x2ffa,
0x287c, 0x3131, 0x277a, 0x3489, 0x2422, 0x345e, 0x247a, 0x30af, 0x25ff, 0x3679,
0x227d, 0x38b8, 0x2335, 0x3567, 0x2487, 0x3679, 0x24a6, 0x3735, 0x243f, 0x3871,
0x25ed, 0x3bb9, 0x2892, 0x3e18, 0x2b0a, 0x3f43, 0x2e1d, 0x3f69, 0x315b, 0x3f00,
0x2f07, 0x40d2, 0x2c2a, 0x42d7, 0x3120, 0x4149, 0x353f, 0x3f78, 0x32fd, 0x4062,
0x2f7f, 0x4046, 0x2ca5, 0x4183, 0x2ba2, 0x4430, 0x2df1, 0x4709, 0x3407, 0x4742,
0x3761, 0x4452, 0x334e, 0x3f05, 0x3009, 0x3eab, 0x3266, 0x40af, 0x2e84, 0x4078,
0x2c16, 0x3d2a, 0x32fc, 0x3a07, 0x36dd, 0x3865, 0x3315, 0x3afa, 0x31ce, 0x4120,
0x32f9, 0x4474, 0x3354, 0x4592, 0x3163, 0x464d, 0x3224, 0x490c, 0x37bd, 0x4ae5,
0x36c5, 0x4b39, 0x2ecb, 0x49ea, 0x2f8a, 0x4803, 0x332b, 0x4689, 0x2adc, 0x44cd,
0x2a93, 0x4551, 0x31a9, 0x46d0, 0x32d8, 0x4628, 0x33c5, 0x47c9, 0x34d7, 0x49f3,
0x3401, 0x4912, 0x3088, 0x4924, 0x3094, 0x4ad0, 0x353c, 0x4b11, 0x3192, 0x4b98,
0x2ef9, 0x4dab, 0x3687, 0x4bf3, 0x3759, 0x4444, 0x3346, 0x4232, 0x34ae, 0x4266,
0x3309, 0x41e0, 0x30a8, 0x4257, 0x32c3, 0x4578, 0x324d, 0x4866, 0x3151, 0x4892,
0x2fb9, 0x4929, 0x2d20, 0x47e8, 0x31f9, 0x45e8, 0x358e, 0x45ec, 0x303f, 0x43bc,
0x2d12, 0x4253, 0x2ebd, 0x4306, 0x2c48, 0x4264, 0x29d6, 0x3d39, 0x28b3, 0x3796,
0x297d, 0x3788, 0x2c2a, 0x37a2, 0x2cc4, 0x3878, 0x2e32, 0x3940, 0x2f11, 0x35fe,
0x2bee, 0x3648, 0x2bd3, 0x3627, 0x2cb3, 0x363f, 0x2790, 0x3a7b, 0x251b, 0x3ac0,
0x23d8, 0x3ae5, 0x2000, 0x3b8e, 0x1f62, 0x3836, 0x2042, 0x365e, 0x2085, 0x3729,
0x201e, 0x366d, 0x210f, 0x35e6, 0x2459, 0x32e2, 0x247d, 0x2f5b, 0x1e6d, 0x2ea2,
0x1b06, 0x2c8c, 0x1bb4, 0x2ef0, 0x18f2, 0x324d, 0x1489, 0x3029, 0x1805, 0x2f35,
0x1a69, 0x305a, 0x1747, 0x2d4b, 0x13b4, 0x29e0, 0x131f, 0x2a30, 0x11eb, 0x2aa2,
0x0c7a, 0x2a1c, 0x0b80, 0x2857, 0x1039, 0x2861, 0x0c99, 0x2894, 0x063e, 0x22c9,
0x08fb, 0x1f4f, 0x0bea, 0x2008, 0x0bd3, 0x1df2, 0x0b81, 0x1d62, 0x0923, 0x1c70,
0x05cf, 0x1a1d, 0x0459, 0x1766, 0x053e, 0x1492, 0x06de, 0x1362, 0x0622, 0x10e9,
0x04c8, 0x0dcf, 0x045c, 0x0f0a, 0x02e8, 0x118e, 0x023d, 0x10a3, 0xffa9, 0x12a8,
0xff5d, 0x160b, 0x011d, 0x17b9, 0xffdb, 0x161e, 0xfe07, 0x1376, 0xfe3d, 0x129d,
0xfe2e, 0x139c, 0xfc48, 0x1591, 0xfaba, 0x15fb, 0xf9d2, 0x1157, 0xfa39, 0x0b35,
0xfa50, 0x0a7f, 0xf70f, 0x0d19, 0xf23f, 0x0e97, 0xf20f, 0x0d05, 0xf2ed, 0x0a49,
0xf2cb, 0x0970, 0xf164, 0x07ea, 0xefc7, 0x0778, 0xef58, 0x082b, 0xef83, 0x08ba,
0xefa7, 0x09ba, 0xf045, 0x099b, 0xef0d, 0x0802, 0xe5d1, 0x0733, 0xdfdd, 0x08a5,
0xe0f0, 0x0427, 0xe41f, 0x00c9, 0xe1ea, 0x0067, 0xe0c1, 0xff59, 0xe124, 0xfe01,
0xe137, 0xfb3c, 0xe14b, 0xf94b, 0xe26b, 0xf752, 0xe2fb, 0xf528, 0xe15b, 0xf1e4,
0xe0ce, 0xed77, 0xdd92, 0xed55, 0xd909, 0xf053, 0xd8b5, 0xefb2, 0xd77f, 0xee58,
0xd320, 0xeec0, 0xd43c, 0xf00f, 0xd69c, 0xf196, 0xd567, 0xf17b, 0xd419, 0xeff1,
0xd319, 0xece1, 0xd131, 0xeaed, 0xcd93, 0xec33, 0xcd59, 0xea59, 0xd143, 0xe33e,
0xd246, 0xe214, 0xd123, 0xe75b, 0xd303, 0xe9e6, 0xcfd8, 0xeac0, 0xc9d6, 0xea85,
0xc8b3, 0xe990, 0xc86b, 0xe908, 0xc931, 0xe71b, 0xc824, 0xe3f7, 0xc71c, 0xe247,
0xc607, 0xe04d, 0xc237, 0xde70, 0xc1c1, 0xdd8e, 0xc847, 0xd895, 0xca9f, 0xd4d3,
0xc7f9, 0xd350, 0xc900, 0xd241, 0xc782, 0xd4f1, 0xc42f, 0xd810, 0xc41e, 0xd881,
0xc43f, 0xd7ed, 0xc1eb, 0xd8e1, 0xbfa2, 0xd9ef, 0xbd06, 0xd85b, 0xbad8, 0xd64e,
0xb8e3, 0xd62c, 0xb78b, 0xd2f5, 0xbb68, 0xd140, 0xbd0c, 0xd336, 0xbbad, 0xd4cf,
0xb9a1, 0xd7e9, 0xb788, 0xd737, 0xb7c3, 0xd230, 0xb8ba, 0xccd7, 0xb88c, 0xc876,
0xb961, 0xc496, 0xba0a, 0xc410, 0xb963, 0xc6cc, 0xbbaa, 0xc5d2, 0xbcf4, 0xc33d,
0xbb50, 0xc448, 0xb8e0, 0xc668, 0xb8d1, 0xc74e, 0xb780, 0xcbd9, 0xb605, 0xcf00,
0xb788, 0xccd2, 0xb937, 0xcb64, 0xb9d7, 0xcc6f, 0xb901, 0xcc23, 0xbac2, 0xce60,
0xbbe0, 0xd171, 0xb63d, 0xd1fd, 0xb357, 0xd02e, 0xb7b6, 0xce05, 0xbb55, 0xcca6,
0xbdf8, 0xc9f4, 0xbd2f, 0xc8d3, 0xba9d, 0xc895, 0xb9a4, 0xc9a9, 0xba49, 0xccec,
0xba61, 0xd107, 0xba61, 0xd521, 0xbad6, 0xd6b6, 0xb77d, 0xd340, 0xb4b6, 0xd160,
0xb6aa, 0xd322, 0xb89d, 0xd1dc, 0xb994, 0xd207, 0xbd44, 0xd396, 0xbd54, 0xd3c0,
0xbd0d, 0xd38d, 0xc0cc, 0xd2fa, 0xc1e2, 0xd36a, 0xc245, 0xd506, 0xc2ac, 0xd1e1,
0xc31d, 0xd0d1, 0xc0a5, 0xd27e, 0xbf6b, 0xd166, 0xc4d7, 0xcfa7, 0xc71b, 0xcdbe,
0xc085, 0xcfbb, 0xbd1f, 0xd2b5, 0xc30f, 0xd1fc, 0xc37a, 0xd32f, 0xc300, 0xd85e,
0xc5b6, 0xdcca, 0xc6b6, 0xdd05, 0xc58c, 0xdc7b, 0xc680, 0xde05, 0xcc05, 0xdf86,
0xd1a1, 0xddf6, 0xd17d, 0xdd9d, 0xd3e5, 0xe267, 0xda5c, 0xe2ef, 0xd7ea, 0xde86,
0xd2b0, 0xe0f2, 0xd2e3, 0xe5cc, 0xd399, 0xe820, 0xd313, 0xe973, 0xd2cf, 0xea38,
0xd2b5, 0xea69, 0xd620, 0xed71, 0xd7fd, 0xefa6, 0xd630, 0xedcd, 0xd986, 0xecb9,
0xda51, 0xebde, 0xd903, 0xeb90, 0xe1f3, 0xeab3, 0xe735, 0xe962, 0xe406, 0xeabf,
0xe481, 0xed19, 0xe62b, 0xee7e, 0xe4ed, 0xefcc, 0xe3e5, 0xf194, 0xe466, 0xf291,
0xe60e, 0xf438, 0xe634, 0xf666, 0xe586, 0xf807, 0xe6ce, 0xf959, 0xe8fc, 0xf811,
0xe8ff, 0xf736, 0xe96e, 0xf8cf, 0xe91a, 0xf924, 0xe896, 0xfb05, 0xec04, 0xfe32,
0xef5e, 0x00be, 0xf2c3, 0x02c9, 0xf4fc, 0x02fc, 0xf593, 0x007a, 0xf590, 0xff7f,
0xf4aa, 0x0207, 0xf757, 0x047f, 0xf9ac, 0x0379, 0xf5fc, 0x0521, 0xf5df, 0x08dc,
0xf875, 0x093b, 0xf70a, 0x07a1, 0xf5b2, 0x0523, 0xf788, 0x05ef, 0xf9ec, 0x072d,
0xfb84, 0x085e, 0xfbbc, 0x0a4a, 0xfb2b, 0x0b57, 0xfb5e, 0x0b30, 0xfd78, 0x0b53,
0xfc82, 0x09de, 0xfc3e, 0x0960, 0x00f2, 0x0b7c, 0x0354, 0x0aad, 0x03dd, 0x0bab,
0x05b1, 0x0ddf, 0x0879, 0x0e9a, 0x0712, 0x0ee6, 0x0329, 0x11d6, 0x023b, 0x14bc,
0x0314, 0x15bc, 0x0342, 0x15db, 0x024a, 0x16e8, 0x01c9, 0x15c3, 0x028c, 0x144a,
0x0360, 0x16e8, 0x0654, 0x1978, 0x0b66, 0x18b4, 0x0ec7, 0x176a, 0x1058, 0x1822,
0x129c, 0x198e, 0x1088, 0x1a13, 0x0e64, 0x19ad, 0x1113, 0x1acd, 0x12af, 0x1b4a,
0x0f32, 0x1962, 0x0a81, 0x1ac3, 0x0c3b, 0x1a8b, 0x10b3, 0x186d, 0x1015, 0x1bea,
0x0df7, 0x1e79, 0x102b, 0x1d4e, 0x10a9, 0x1be1, 0x0ed0, 0x1c8a, 0x1022, 0x1d20,
0x137a, 0x1dbd, 0x162b, 0x1faa, 0x16a0, 0x21a3, 0x1793, 0x2351, 0x18ab, 0x2269,
0x1485, 0x2193, 0x1282, 0x251b, 0x1501, 0x266e, 0x1698, 0x24d7, 0x175d, 0x25ff,
0x1761, 0x2718, 0x19a9, 0x2565, 0x1baf, 0x23ba, 0x1c50, 0x22dc, 0x1d76, 0x22b7,
0x1fa5, 0x21c4, 0x22cc, 0x21ab, 0x24af, 0x221b, 0x244c, 0x1fb1, 0x2413, 0x1c07,
0x21d9, 0x1e5b, 0x213c, 0x2322, 0x22c7, 0x24a6, 0x202c, 0x242b, 0x1f8c, 0x26cf,
0x1ff0, 0x2b80, 0x1f38, 0x2c09, 0x1f33, 0x29ad, 0x1fad, 0x27be, 0x2012, 0x2784,
0x2020, 0x2796, 0x237f, 0x285d, 0x2573, 0x2519, 0x2355, 0x21c0, 0x2286, 0x2490,
0x22bd, 0x26c7, 0x2299, 0x2729, 0x2543, 0x2854, 0x2881, 0x2816, 0x29ef, 0x2790,
0x29a4, 0x2630, 0x27f9, 0x249b, 0x29b9, 0x272b, 0x2c47, 0x2b03, 0x2aab, 0x2c54,
0x2885, 0x2bf3, 0x29bb, 0x2e97, 0x2914, 0x3228, 0x2640, 0x2ef9, 0x27bf, 0x2b43,
0x2841, 0x2b9d, 0x26f9, 0x29a4, 0x2880, 0x275e, 0x28ef, 0x2648, 0x28b0, 0x25c5,
0x283a, 0x25d5, 0x26a3, 0x25dd, 0x286b, 0x266b, 0x287c, 0x2a53, 0x2781, 0x2d31,
0x2698, 0x2b30, 0x26ab, 0x2963, 0x2538, 0x282b, 0x22ea, 0x2754, 0x2360, 0x27d7,
0x22f1, 0x277b, 0x2434, 0x269c, 0x27a4, 0x24e7, 0x2aa2, 0x2653, 0x29e9, 0x277c,
0x2a24, 0x257d, 0x29bb, 0x26c9, 0x2579, 0x291f, 0x23f5, 0x2525, 0x26d3, 0x236b,
0x239b, 0x229f, 0x201d, 0x1f22, 0x234d, 0x1f54, 0x264b, 0x22d8, 0x274c, 0x2364,
0x2580, 0x2131, 0x2362, 0x1f4c, 0x20a1, 0x1f72, 0x20d8, 0x2210, 0x242d, 0x2393,
0x24e7, 0x27e4, 0x21ce, 0x2bb2, 0x1ffb, 0x29c6, 0x2076, 0x28b0, 0x1fcc, 0x27ca,
0x1ed7, 0x2504, 0x21bf, 0x2385, 0x2638, 0x23bf, 0x28d2, 0x2299, 0x290f, 0x209f,
0x2701, 0x1efe, 0x2549, 0x1ee2, 0x25fc, 0x1ec9, 0x269f, 0x1b1f, 0x24be, 0x186e,
0x2663, 0x1b76, 0x28c0, 0x1c54, 0x226d, 0x1879, 0x1ead, 0x166c, 0x1f01, 0x1663,
0x1d7a, 0x1694, 0x1b0e, 0x165a, 0x19cc, 0x145a, 0x1b38, 0x15ae, 0x1996, 0x162b,
0x157a, 0x1485, 0x18ae, 0x171d, 0x195a, 0x1882, 0x14fe, 0x14f6, 0x1698, 0x13f9,
0x18bb, 0x1690, 0x160d, 0x1424, 0x1275, 0x1022, 0x118a, 0x0fb8, 0x1184, 0x0eb8,
0x1241, 0x0c71, 0x13e3, 0x0b37, 0x1667, 0x0b99, 0x16b5, 0x0944, 0x1593, 0x0752,
0x159c, 0x0a54, 0x125c, 0x0c65, 0x0ef6, 0x0982, 0x101a, 0x0760, 0x0f18, 0x0811,
0x0cf1, 0x075f, 0x0d27, 0x05db, 0x0ebc, 0x0620, 0x0de2, 0x0533, 0x0d26, 0x03fb,
0x0db7, 0x0494, 0x0a7b, 0x0500, 0x07b6, 0x01b9, 0x074b, 0xfe99, 0x063a, 0x0088,
0x06e1, 0x03fa, 0x0be4, 0x034e, 0x0c20, 0x0119, 0x09cd, 0x01f8, 0x0a4a, 0x00cc,
0x0a46, 0xfed6, 0x0890, 0xfd6a, 0x05c3, 0xfbc1, 0x036b, 0xfb21, 0x00ea, 0xfb7f,
0xfc48, 0xfca0, 0xfac2, 0xfae4, 0xff6a, 0xf9d1, 0xfdda, 0xf99d, 0xf8a8, 0xf7b6,
0xfa85, 0xf62e, 0xf973, 0xf2f7, 0xf797, 0xf23c, 0xf7c9, 0xf251, 0xf7cb, 0xf118,
0xf956, 0xf14c, 0xf84e, 0xf055, 0xf7a4, 0xedb2, 0xf86e, 0xebf9, 0xf541, 0xec4f,
0xf452, 0xeddc, 0xf823, 0xf2ae, 0xf84e, 0xf539, 0xf424, 0xf364, 0xf32f, 0xf341,
0xf50d, 0xf2d7, 0xf407, 0xef34, 0xf3f7, 0xecca, 0xf590, 0xec9b, 0xf51b, 0xebed,
0xf418, 0xeb41, 0xf374, 0xea6a, 0xf3ae, 0xe9c8, 0xf4b0, 0xe79d, 0xf4a0, 0xe5be,
0xf5b4, 0xe3e6, 0xf7a6, 0xe1ee, 0xf56a, 0xdeaf, 0xf3fb, 0xdd7b, 0xf48d, 0xdfa9,
0xf384, 0xe1f2, 0xf132, 0xe29a, 0xef51, 0xe30f, 0xee0e, 0xe37f, 0xecb2, 0xe3fa,
0xebb6, 0xe318, 0xec14, 0xe22e, 0xecb6, 0xe52d, 0xeaa7, 0xe60a, 0xe9bb, 0xe287,
0xe8a8, 0xdf59, 0xe6f5, 0xe003, 0xe753, 0xe15e, 0xe97b, 0xe18a, 0xeaaf, 0xe0d0,
0xeb27, 0xe0fe, 0xebe9, 0xe3b8, 0xea67, 0xe2d9, 0xeb73, 0xe146, 0xeb88, 0xe055,
0xe7d4, 0xdd68, 0xe832, 0xdbcf, 0xe971, 0xe076, 0xe9c8, 0xe22f, 0xea44, 0xdc69,
0xea4f, 0xdaf0, 0xe9fe, 0xdcb9, 0xe8e9, 0xde4a, 0xe767, 0xddc7, 0xe5a0, 0xdb0c,
0xe36e, 0xd738, 0xe3d8, 0xd664, 0xe606, 0xd5ae, 0xe860, 0xd5eb, 0xe9de, 0xd58a,
0xe96c, 0xd82b, 0xe65b, 0xdfa6, 0xe307, 0xdedf, 0xe144, 0xda1e, 0xe0e9, 0xd805,
0xe196, 0xd625, 0xe351, 0xd50c, 0xe4b4, 0xd60a, 0xe29a, 0xd82f, 0xde6e, 0xd98d,
0xdf61, 0xd80a, 0xe2f8, 0xd84b, 0xe055, 0xd9fa, 0xe157, 0xd606, 0xe60e, 0xd472,
0xe4f8, 0xd524, 0xe4af, 0xd4be, 0xe4d6, 0xd61a, 0xe2a6, 0xd765, 0xe120, 0xd8e2,
0xe072, 0xd965, 0xe046, 0xd7d7, 0xe225, 0xd776, 0xe2c7, 0xd8cc, 0xe295, 0xd8bb,
0xe106, 0xd65b, 0xdfe6, 0xd233, 0xe2eb, 0xd077, 0xe4e3, 0xd23b, 0xe2ef, 0xd428,
0xdf3f, 0xd51b, 0xe0e4, 0xd64c, 0xe5d3, 0xd78d, 0xe573, 0xd579, 0xe42e, 0xd354,
0xe55c, 0xd288, 0xe43f, 0xd436, 0xe454, 0xd86f, 0xe97b, 0xd8f1, 0xe7b3, 0xd9c5,
0xe104, 0xdaca, 0xe373, 0xd9d5, 0xe6b6, 0xd975, 0xe765, 0xd7fc, 0xea23, 0xd5fe,
0xea70, 0xd57c, 0xe95f, 0xd529, 0xe937, 0xd405, 0xe85a, 0xd39e, 0xe982, 0xd5a9,
0xe8c0, 0xd6e5, 0xe79d, 0xd484, 0xe97f, 0xd447, 0xed48, 0xda5d, 0xee79, 0xdefc,
0xef5d, 0xdf1b, 0xed75, 0xdd6f, 0xe9f3, 0xdb51, 0xe945, 0xd956, 0xeb94, 0xd8ba,
0xec90, 0xda6b, 0xe8f0, 0xda26, 0xe6a2, 0xd7cd, 0xe9d5, 0xd71d, 0xecf8, 0xd920,
0xed86, 0xd9f7, 0xebee, 0xd98a, 0xeb31, 0xdb2b, 0xecc8, 0xdafc, 0xed7d, 0xdca5,
0xeca9, 0xddd6, 0xecaf, 0xdc60, 0xee4c, 0xdc48, 0xef15, 0xde5e, 0xef58, 0xe0ea,
0xef1e, 0xe1ae, 0xef06, 0xe15a, 0xf0af, 0xe1b5, 0xf49b, 0xe0b6, 0xf320, 0xe063,
0xefdc, 0xe108, 0xf2a1, 0xdf2f, 0xf49f, 0xdd4c, 0xf54b, 0xdf9f, 0xf66c, 0xe232,
0xf73c, 0xe281, 0xf7a8, 0xe231, 0xf776, 0xe2f6, 0xf7e6, 0xe30c, 0xf7ff, 0xe19d,
0xf5ca, 0xe3c6, 0xf384, 0xe422, 0xf54c, 0xe213, 0xf674, 0xe3c3, 0xf71f, 0xe456,
0xfb56, 0xe136, 0xfcac, 0xe317, 0xfba6, 0xe733, 0xfd42, 0xe9df, 0xff43, 0xecf9,
0xffcf, 0xf08e, 0x00c2, 0xf1e0, 0x0327, 0xf094, 0x0498, 0xf259, 0x0417, 0xf5e3,
0x0538, 0xf47d, 0x0520, 0xf2ce, 0x03de, 0xf590, 0x0317, 0xf4be, 0x028f, 0xf2ba,
0x00f1, 0xf472, 0x00f4, 0xf49a, 0x02c3, 0xf416, 0x0521, 0xf56d, 0x0792, 0xf790,
0x0762, 0xf865, 0x080f, 0xf8d1, 0x0947, 0xfbd4, 0x079d, 0xfda9, 0x0904, 0xff5c,
0x0c7d, 0x006f, 0x0cf1, 0x0194, 0x0d8e, 0x00e3, 0x0e7a, 0x0002, 0x0f83, 0x01f1,
0x117f, 0x0305, 0x1267, 0x0214, 0x125e, 0x0122, 0x11b2, 0x00b8, 0x11e0, 0xffcd,
0x130c, 0xffa6, 0x1700, 0x017b, 0x199b, 0x0362, 0x1773, 0x0363, 0x1585, 0x02c8,
0x1600, 0x0611, 0x1616, 0x0993, 0x15a3, 0x09a4, 0x144d, 0x088a, 0x130c, 0x07fd,
0x1363, 0x07aa, 0x1497, 0x08a3, 0x1652, 0x09f0, 0x179c, 0x09bc, 0x18f2, 0x09f9,
0x19a8, 0x0a94, 0x1cef, 0x0bb1, 0x1eb7, 0x0b69, 0x1cb8, 0x0ae9, 0x1a33, 0x099a,
0x192e, 0x0ae6, 0x19ab, 0x0e17, 0x1b33, 0x0ffd, 0x1cb7, 0x1125, 0x1d91, 0x12cf,
0x1cd2, 0x12a4, 0x1a00, 0x0fa0, 0x183d, 0x0f76, 0x1ae9, 0x12e6, 0x1e1f, 0x11b5,
0x1f0a, 0x1066, 0x20cc, 0x14d1, 0x2395, 0x1581, 0x2562, 0x1357, 0x2522, 0x12f1,
0x259f, 0x1415, 0x261b, 0x142a, 0x2652, 0x13bc, 0x2665, 0x166e, 0x2829, 0x1983,
0x2824, 0x1a85, 0x2491, 0x1d00, 0x2621, 0x2064, 0x2b09, 0x1db2, 0x2b81, 0x1a19,
0x2bdc, 0x1a86, 0x2c1c, 0x198d, 0x2a40, 0x1746, 0x2b3a, 0x1760, 0x2ca6, 0x1859,
0x2a76, 0x1904, 0x275c, 0x19c0, 0x2728, 0x1c27, 0x26c4, 0x1f17, 0x26c7, 0x1e97,
0x27c8, 0x1edc, 0x29b9, 0x202f, 0x2d0e, 0x1e29, 0x2fe9, 0x1cab, 0x30eb, 0x1ef8,
0x30b4, 0x1e4e, 0x2fc4, 0x1d4b, 0x2d55, 0x1f1a, 0x2c10, 0x223d, 0x2c7d, 0x2371,
0x2cdc, 0x2135, 0x2f1e, 0x20c0, 0x2fe3, 0x228d, 0x2ff6, 0x222e, 0x3212, 0x2098,
0x339f, 0x1f8b, 0x33da, 0x1d77, 0x33fa, 0x1d2d, 0x3396, 0x1e7f, 0x321c, 0x1ed2,
0x3008, 0x1ec1, 0x2e33, 0x1fcc, 0x2c8f, 0x1ec3, 0x2a94, 0x1e94, 0x2b36, 0x224c,
0x2c48, 0x2520, 0x2b04, 0x2535, 0x2c1c, 0x224b, 0x2d7f, 0x214c, 0x2cde, 0x2229,
0x2e00, 0x1f97, 0x2f94, 0x1e12, 0x307a, 0x1d2c, 0x3188, 0x1bd3, 0x30c7, 0x1a28,
0x301f, 0x1a28, 0x2fb1, 0x1bf3, 0x2dd8, 0x1b56, 0x2e20, 0x1992, 0x2f16, 0x18d0,
0x2e9f, 0x1a1d, 0x2c94, 0x1a86, 0x2c7d, 0x1990, 0x2ed9, 0x1a94, 0x2f9f, 0x1cf7,
0x2f09, 0x1d5b, 0x2d78, 0x1b69, 0x2b72, 0x19bf, 0x2b6f, 0x1b18, 0x2be4, 0x1df4,
0x2a89, 0x1ee9, 0x2898, 0x1f69, 0x2613, 0x1f11, 0x2545, 0x1dd2, 0x262b, 0x1adb,
0x2714, 0x18c4, 0x25c1, 0x185c, 0x24b1, 0x1886, 0x24fa, 0x1a0a, 0x2301, 0x19d0,
0x2125, 0x1944, 0x2268, 0x197b, 0x227d, 0x1832, 0x2268, 0x15bb, 0x2294, 0x1581,
0x21fe, 0x1694, 0x2473, 0x180c, 0x25a5, 0x18d8, 0x2252, 0x1815, 0x20ca, 0x1658,
0x2249, 0x171d, 0x20a2, 0x17df, 0x1db4, 0x17f8, 0x1d55, 0x180b, 0x1e05, 0x16cb,
0x1e51, 0x161a, 0x1f2a, 0x156e, 0x1f46, 0x15b6, 0x1eda, 0x13b2, 0x1e1f, 0x10fa,
0x1cf7, 0x0ff8, 0x1c76, 0x103a, 0x1d01, 0x10de, 0x1b1a, 0x104e, 0x18b6, 0x0f1f,
0x185e, 0x0e03, 0x17a7, 0x0d19, 0x16a9, 0x0cec, 0x157c, 0x0d39, 0x1538, 0x0ca7,
0x141f, 0x0b4f, 0x12ca, 0x0b14, 0x120a, 0x0c45, 0x11dc, 0x0d80, 0x11bb, 0x0be9,
0x1021, 0x0c36, 0x1062, 0x0e20, 0x0fc8, 0x0bea, 0x0ee9, 0x09e4, 0x0df2, 0x0965,
0x0d2a, 0x08d5, 0x0ceb, 0x0879, 0x0c6d, 0x0827, 0x0cc3, 0x08b8, 0x0c06, 0x074d,
0x0a02, 0x063c, 0x09cc, 0x0700, 0x0c31, 0x04d2, 0x0ba1, 0x0111, 0x0935, 0x0162,
0x089a, 0x0402, 0x0714, 0x03a3, 0x04e1, 0x0256, 0x041b, 0x01df, 0x045d, 0x0145,
0x0457, 0x002b, 0x03cc, 0xff48, 0x0260, 0xff5b, 0x0171, 0xfdfe, 0x0192, 0xfdbc,
0x003f, 0xfe78, 0x0058, 0xfc64, 0x0037, 0xf9c3, 0xfec0, 0xfa43, 0xfddf, 0xfb20,
0xfdf8, 0xfa55, 0xfd73, 0xf97b, 0xfc28, 0xf86a, 0xfc21, 0xf7e5, 0xfc03, 0xf6cb,
0xfbe1, 0xf582, 0xf9d7, 0xf59a, 0xf870, 0xf5da, 0xfa3f, 0xf3d1, 0xf948, 0xf1db,
0xf589, 0xf272, 0xf551, 0xf1d9, 0xf713, 0xf170, 0xf6ce, 0xf263, 0xf5bc, 0xf24f,
0xf4fe, 0xf1de, 0xf46e, 0xf106, 0xf386, 0xf082, 0xf271, 0xf07a, 0xf3bc, 0xef6b,
0xf4f2, 0xee24, 0xf12a, 0xed5e, 0xedbc, 0xecdd, 0xee62, 0xed22, 0xef49, 0xedef,
0xed3a, 0xedc7, 0xed0c, 0xec9d, 0xeda4, 0xec49, 0xec9e, 0xebe7, 0xeb7e, 0xeb81,
0xea9e, 0xeb19, 0xeaeb, 0xea18, 0xeaf5, 0xe957, 0xe9f9, 0xe83e, 0xeaec, 0xe60b,
0xea11, 0xe602, 0xe7cb, 0xe6cc, 0xe67b, 0xe524, 0xe5e1, 0xe430, 0xe6f3, 0xe537,
0xe65e, 0xe4e2, 0xe54c, 0xe480, 0xe456, 0xe3c2, 0xe411, 0xe370, 0xe422, 0xe334,
0xe2dd, 0xe272, 0xe184, 0xe287, 0xe13d, 0xe1fe, 0xe1e7, 0xdfc0, 0xe0ba, 0xdfd7,
0xdfb1, 0xe0c9, 0xdf6a, 0xe083, 0xde56, 0xdfd1, 0xdd19, 0xde1c, 0xdc90, 0xddbf,
0xdbfc, 0xdd1d, 0xdbaa, 0xdc8b, 0xdbb1, 0xdd2e, 0xdbb5, 0xdcd6, 0xd9b5, 0xdbdc,
0xd8bc, 0xdc41, 0xda7b, 0xdcca, 0xda53, 0xdc30, 0xd802, 0xdae6, 0xd78a, 0xda2e,
0xd776, 0xdac5, 0xd71a, 0xdb30, 0xd77b, 0xdac5, 0xd761, 0xda73, 0xd6f2, 0xd9fc,
0xd6f0, 0xda04, 0xd6b8, 0xda63, 0xd527, 0xda36, 0xd55d, 0xd99d, 0xd71f, 0xd870,
0xd5f6, 0xd820, 0xd3a0, 0xd95b, 0xd4a6, 0xd90d, 0xd57f, 0xd7b1, 0xd52b, 0xd84f,
0xd4f3, 0xd8a3, 0xd4b8, 0xd876, 0xd469, 0xd83f, 0xd3b5, 0xd787, 0xd32a, 0xd76e,
0xd3e2, 0xd64a, 0xd3c7, 0xd6a1, 0xd175, 0xd69c, 0xd103, 0xd5fe, 0xd2cf, 0xd6b5,
0xd36a, 0xd61d, 0xd251, 0xd5e0, 0xd289, 0xd61a, 0xd26c, 0xd614, 0xd278, 0xd5b3,
0xd2b2, 0xd671, 0xd27e, 0xd6f4, 0xd333, 0xd747, 0xd261, 0xd69a, 0xd2bf, 0xd780,
0xd51b, 0xd7e4, 0xd4ef, 0xd727, 0xd31f, 0xd73e, 0xd2be, 0xd82d, 0xd41e, 0xd840,
0xd4aa, 0xd7f8, 0xd455, 0xd86a, 0xd40c, 0xd835, 0xd473, 0xd84f, 0xd45a, 0xd875,
0xd427, 0xd867, 0xd461, 0xd896, 0xd3c5, 0xd841, 0xd325, 0xd8ba, 0xd634, 0xd922,
0xd5f1, 0xd7ca, 0xd278, 0xd82e, 0xd40e, 0xda0b, 0xd63f, 0xd9cc, 0xd608, 0xd9b8,
0xd605, 0xda37, 0xd5d0, 0xd99f, 0xd5c7, 0xd96e, 0xd63c, 0xd98c, 0xd632, 0xda79,
0xd7e5, 0xdafa, 0xd99f, 0xdaf9, 0xd880, 0xdc3c, 0xd69e, 0xdd20, 0xd76b, 0xdbf1,
0xd85c, 0xdc1a, 0xd825, 0xdcb4, 0xd8d8, 0xdcb1, 0xd92c, 0xdd45, 0xd99d, 0xddb9,
0xd99d, 0xdde0, 0xd964, 0xde1d, 0xd916, 0xdea5, 0xd95c, 0xdfa4, 0xdb34, 0xdfac,
0xdc76, 0xe100, 0xdb40, 0xe10c, 0xdb00, 0xe03c, 0xdcdf, 0xe1c1, 0xdcf6, 0xe252,
0xdce0, 0xe377, 0xde2b, 0xe450, 0xdeda, 0xe46e, 0xdfb8, 0xe51d, 0xe024, 0xe5bf,
0xe0de, 0xe69e, 0xe1b6, 0xe798, 0xe0f7, 0xe846, 0xe2d3, 0xe9a1, 0xe49e, 0xe9cf,
0xe37c, 0xe995, 0xe3e4, 0xeaf7, 0xe553, 0xec05, 0xe606, 0xebb3, 0xe6b6, 0xec3a,
0xe701, 0xec9a, 0xe78d, 0xecf8, 0xe859, 0xee0f, 0xe995, 0xee7c, 0xeaed, 0xef35,
0xeadc, 0xef89, 0xea0f, 0xef34, 0xea6b, 0xf0df, 0xec16, 0xf238, 0xed18, 0xf17b,
0xee08, 0xf1d2, 0xeea3, 0xf312, 0xef60, 0xf394, 0xefea, 0xf409, 0xf0bb, 0xf50a,
0xf12b, 0xf587, 0xf212, 0xf61e, 0xf2e0, 0xf697, 0xf3ca, 0xf7c3, 0xf4ef, 0xf8ba,
0xf610, 0xf843, 0xf6e9, 0xf9c5, 0xf794, 0xfba6, 0xf841, 0xfb4b, 0xf88c, 0xfb96,
0xfa45, 0xfcee, 0xfb8f, 0xfdc1, 0xfcc5, 0xff0d, 0xfdbc, 0xff8b, 0xff09, 0x005e,
0x0031, 0x0109, 0x008a, 0x0156, 0x0066, 0x0314, 0x0202, 0x03a1, 0x0396, 0x03af,
0x02d6, 0x0570, 0x02de, 0x0574, 0x02f9, 0x03dc, 0x03c8, 0x0510, 0x051d, 0x068b,
0x0634, 0x073c, 0x071d, 0x0854, 0x0865, 0x090b, 0x0979, 0x0999, 0x0a24, 0x0a11,
0x0a92, 0x0afd, 0x0baa, 0x0d07, 0x0b9d, 0x0d4b, 0x0b67, 0x0cab, 0x0c65, 0x0dda,
0x0efe, 0x0e74, 0x0ecc, 0x0ef2, 0x0ea5, 0x103f, 0x0f82, 0x1113, 0x1059, 0x1190,
0x11a4, 0x1266, 0x1274, 0x1314, 0x13a6, 0x145d, 0x138c, 0x1484, 0x134e, 0x1534,
0x147b, 0x16ce, 0x15ca, 0x1616, 0x16ba, 0x1643, 0x18b2, 0x1878, 0x183d, 0x18f0,
0x1891, 0x1965, 0x1939, 0x1a1c, 0x192b, 0x1a83, 0x19f3, 0x1b0d, 0x1aab, 0x1b9a,
0x1b89, 0x1c92, 0x1c0b, 0x1d71, 0x1bf2, 0x1dc1, 0x1b63, 0x1cf9, 0x1cd1, 0x1e33,
0x1d8f, 0x2078, 0x1e63, 0x21fe, 0x1f4f, 0x2215, 0x2045, 0x21db, 0x2148, 0x22c4,
0x2177, 0x241e, 0x2179, 0x2545, 0x21fc, 0x2605, 0x22b6, 0x26b2, 0x23ac, 0x26f9,
0x25a3, 0x28d5, 0x2535, 0x2965, 0x24b9, 0x287d, 0x2560, 0x2948, 0x2650, 0x2a63,
0x26c4, 0x2aa1, 0x27be, 0x2b6e, 0x27a4, 0x2c29, 0x2822, 0x2ce1, 0x28bc, 0x2d4f,
0x28e3, 0x2daa, 0x29d5, 0x2e77, 0x2ab7, 0x2f50, 0x2aa8, 0x2f2b, 0x2b1d, 0x3053,
0x2b38, 0x316b, 0x2a6a, 0x3095, 0x2ba1, 0x3090, 0x2c47, 0x307b, 0x2ce7, 0x3177,
0x2ca5, 0x3206, 0x2c92, 0x32aa, 0x2cd3, 0x3315, 0x2d2f, 0x334e, 0x2dd2, 0x33db,
0x2e45, 0x3494, 0x2eaf, 0x34eb, 0x2ed7, 0x34bd, 0x2ee5, 0x3571, 0x2f68, 0x3686,
0x3081, 0x362b, 0x2ff5, 0x35f7, 0x3026, 0x37ef, 0x30a9, 0x380c, 0x30e9, 0x3768,
0x3124, 0x3783, 0x3127, 0x373c, 0x3161, 0x373a, 0x3195, 0x37a6, 0x31b9, 0x3805,
0x3263, 0x37e2, 0x3185, 0x3783, 0x30f0, 0x3895, 0x3299, 0x39b2, 0x3377, 0x3908,
0x31c1, 0x38f5, 0x31e3, 0x3957, 0x330e, 0x39d7, 0x32ba, 0x39e5, 0x32de, 0x39a6,
0x32dd, 0x3925, 0x32c7, 0x38f4, 0x31ff, 0x38ba, 0x326e, 0x3965, 0x3228, 0x398c,
0x31c9, 0x38ff, 0x32dc, 0x3a33, 0x34e4, 0x3ae9, 0x349a, 0x3aca, 0x327e, 0x3b46,
0x33a4, 0x3b9c, 0x344c, 0x3b29, 0x33e1, 0x3aba, 0x33c1, 0x3ad3, 0x33f0, 0x3b5a,
0x33c5, 0x3b28, 0x3343, 0x3ad3, 0x334d, 0x3a8d, 0x33f4, 0x3968, 0x32a1, 0x383c,
0x30fc, 0x389f, 0x3191, 0x3903, 0x3197, 0x384d, 0x3162, 0x383d, 0x310b, 0x37b0,
0x30db, 0x3782, 0x305b, 0x378a, 0x2ff9, 0x3773, 0x2f4f, 0x36e6, 0x2fb0, 0x366b,
0x2e92, 0x360e, 0x2e4a, 0x36c9, 0x2ece, 0x37a4, 0x2ef1, 0x3727, 0x2f16, 0x3747,
0x2f41, 0x3714, 0x2f79, 0x370e, 0x2e0f, 0x36b6, 0x2e78, 0x36ed, 0x2f01, 0x36e4,
0x2ec5, 0x362f, 0x2e1f, 0x3592, 0x2dc5, 0x354b, 0x2e66, 0x3573, 0x2e3a, 0x349d,
0x2cc2, 0x3390, 0x2bd5, 0x32d5, 0x2cb6, 0x3288, 0x2c14, 0x31e0, 0x2a95, 0x30f9,
0x2ad0, 0x3085, 0x2aa5, 0x2fee, 0x297b, 0x2f49, 0x28c1, 0x2edc, 0x2828, 0x2e67,
0x27f8, 0x2de0, 0x272a, 0x2d71, 0x271c, 0x2d8b, 0x27e3, 0x2ccc, 0x2695, 0x2b7b,
0x24b3, 0x2d0b, 0x257d, 0x2d26, 0x2624, 0x2b04, 0x24b8, 0x2abe, 0x2474, 0x2b1d,
0x2462, 0x2ac8, 0x24a1, 0x2ac9, 0x2469, 0x2abc, 0x2396, 0x2a19, 0x2340, 0x296c,
0x2306, 0x28f1, 0x223a, 0x2937, 0x2090, 0x27ac, 0x1fc5, 0x2610, 0x1f65, 0x273d,
0x1f6a, 0x270d, 0x1dc2, 0x253e, 0x1c8a, 0x2423, 0x1c1b, 0x238b, 0x1bb3, 0x22e6,
0x1b11, 0x22c9, 0x1a01, 0x221b, 0x1953, 0x2136, 0x18f3, 0x1fd7, 0x1795, 0x1f01,
0x167a, 0x1f13, 0x17a4, 0x1d86, 0x1810, 0x1d43, 0x15be, 0x1dd6, 0x1453, 0x1d26,
0x1402, 0x1b0c, 0x137a, 0x1a1a, 0x12d9, 0x1926, 0x120a, 0x1887, 0x10f0, 0x1838,
0x1000, 0x179a, 0x0f73, 0x17ad, 0x0ef4, 0x1733, 0x0ee1, 0x1636, 0x0e05, 0x1612,
0x0d01, 0x161c, 0x0cbb, 0x1521, 0x0bba, 0x143f, 0x0b15, 0x1367, 0x0a5c, 0x12e4,
0x09c7, 0x11c8, 0x090a, 0x1146, 0x07e7, 0x1086, 0x07cf, 0x0f45, 0x06fc, 0x0e1a,
0x04cc, 0x0ce6, 0x04fa, 0x0cc5, 0x0571, 0x0c0f, 0x02ba, 0x09b4, 0x0191, 0x0885,
0x01f2, 0x0900, 0x01c2, 0x08c3, 0x016d, 0x07fe, 0x0076, 0x0736, 0xff9e, 0x0637,
0xff10, 0x0540, 0xfeaa, 0x04b7, 0xff13, 0x0439, 0xfe64, 0x0330, 0xfc0c, 0x020d,
0xfb8f, 0x019a, 0xfc0e, 0x0133, 0xfb1b, 0x0092, 0xf96b, 0xfec3, 0xf952, 0xfdd7,
0xf94a, 0xfd71, 0xf852, 0xfcb1, 0xf7d0, 0xfc5b, 0xf6da, 0xfbc8, 0xf627, 0xfb10,
0xf4d2, 0xfa1b, 0xf3f9, 0xf988, 0xf3ec, 0xf922, 0xf37c, 0xf890, 0xf36f, 0xf80e,
0xf3e7, 0xf77b, 0xf287, 0xf614, 0xf0b3, 0xf4d4, 0xf05f, 0xf4a2, 0xef35, 0xf3b5,
0xee47, 0xf2b9, 0xec98, 0xf15a, 0xebed, 0xf066, 0xeadb, 0xef28, 0xe9a8, 0xeddd,
0xe88f, 0xecd9, 0xe7a3, 0xed2b, 0xe732, 0xec7c, 0xe727, 0xeb45, 0xe649, 0xeadb,
0xe4a7, 0xea9a, 0xe44a, 0xea67, 0xe3b7, 0xe957, 0xe371, 0xe901, 0xe32b, 0xe87a,
0xe2d2, 0xe7be, 0xe1ba, 0xe6ba, 0xe008, 0xe5e2, 0xe099, 0xe4d9, 0xe1b3, 0xe40e,
0xdfc6, 0xe4c7, 0xde31, 0xe48a, 0xdec5, 0xe258, 0xdeb9, 0xe16c, 0xddb1, 0xe1be,
0xdd43, 0xe114, 0xdce5, 0xe06c, 0xdbe3, 0xdf4c, 0xdb6c, 0xdf29, 0xdb89, 0xdeb1,
0xdb34, 0xddf7, 0xda17, 0xdcd3, 0xd8b8, 0xdd0c, 0xd813, 0xdd5a, 0xd7bd, 0xdbfd,
0xd655, 0xda77, 0xd55f, 0xd948, 0xd49f, 0xd983, 0xd44a, 0xd96f, 0xd463, 0xd93c,
0xd3f5, 0xd8d5, 0xd3cd, 0xd889, 0xd358, 0xd7e3, 0xd2c8, 0xd7bb, 0xd26b, 0xd7c9,
0xd1cd, 0xd73d, 0xd1ce, 0xd5df, 0xd23c, 0xd691, 0xd226, 0xd644, 0xd1ce, 0xd59e,
0xd151, 0xd56f, 0xd0b7, 0xd4bd, 0xd00f, 0xd47c, 0xd015, 0xd424, 0xcfb2, 0xd3b5,
0xceed, 0xd328, 0xce5f, 0xd2ff, 0xcd85, 0xd2a9, 0xcca0, 0xd181, 0xcc94, 0xd098,
0xcc60, 0xd143, 0xcc58, 0xd096, 0xcd45, 0xcfd4, 0xcc8e, 0xcf5e, 0xcc24, 0xcfb3,
0xccc2, 0xcf9f, 0xccea, 0xcf5f, 0xcc92, 0xcef6, 0xcc55, 0xce4f, 0xcc0b, 0xcde6,
0xcb2c, 0xcdae, 0xcab9, 0xcde7, 0xcc4c, 0xcd8d, 0xccc5, 0xccfb, 0xcaf6, 0xccea,
0xca19, 0xcd1c, 0xcb94, 0xcd22, 0xcb3b, 0xccec, 0xc9fe, 0xcc53, 0xca32, 0xcc26,
0xc9db, 0xcc02, 0xc950, 0xcb76, 0xc8bb, 0xcae8, 0xc8e8, 0xcab9, 0xc919, 0xca88,
0xc918, 0xca8d, 0xc97b, 0xca73, 0xca17, 0xca9d, 0xc92f, 0xca7d, 0xc97f, 0xc9f1,
0xcab7, 0xca3e, 0xc994, 0xc9da, 0xc96c, 0xc966, 0xc985, 0xc943, 0xc989, 0xc96c,
0xc96d, 0xc979, 0xc9a3, 0xc95c, 0xc937, 0xc93a, 0xc8f7, 0xc9be, 0xc8f5, 0xca27,
0xca81, 0xc95b, 0xcba8, 0xc8e3, 0xca6f, 0xc9a8, 0xcab4, 0xc98f, 0xcafb, 0xc91e,
0xcacc, 0xc9d0, 0xcaf2, 0xc9e6, 0xcb4f, 0xc99a, 0xcbe6, 0xc997, 0xcbe5, 0xc9cf,
0xcb1d, 0xca0e, 0xcbe6, 0xc99e, 0xccfb, 0xc9f2, 0xcc73, 0xcab1, 0xcb8c, 0xca27,
0xcbd6, 0xca69, 0xccad, 0xca78, 0xcd6a, 0xca3d, 0xccff, 0xcb21, 0xcd88, 0xcbdf,
0xcdfe, 0xcbd0, 0xcdcb, 0xcb8b, 0xce0e, 0xcb7f, 0xce70, 0xcbcb, 0xce6c, 0xcc0a,
0xcd2c, 0xcbda, 0xce8a, 0xcbc1, 0xd1f5, 0xcb48, 0xd148, 0xcc0a, 0xd01b, 0xcd40,
0xd0f6, 0xcd18, 0xd13b, 0xcd2a, 0xd17c, 0xcda0, 0xd1ad, 0xcdb4, 0xd16c, 0xcdc8,
0xd128, 0xce0d, 0xd173, 0xce5f, 0xd274, 0xced2, 0xd3b0, 0xcea5, 0xd2d8, 0xce6b,
0xd2f5, 0xce6d, 0xd473, 0xcfcb, 0xd524, 0xd17a, 0xd5c9, 0xd131, 0xd6a3, 0xd10d,
0xd6db, 0xd0a2, 0xd793, 0xd107, 0xd834, 0xd13e, 0xd89f, 0xd163, 0xd98d, 0xd20e,
0xda1c, 0xd205, 0xdb42, 0xd2aa, 0xdaaf, 0xd40a, 0xd9f7, 0xd4c9, 0xdbe9, 0xd358,
0xdd0a, 0xd3ea, 0xdc23, 0xd595, 0xdc89, 0xd662, 0xdcc4, 0xd63f, 0xdd04, 0xd6ad,
0xddcb, 0xd758, 0xde64, 0xd7a6, 0xdf31, 0xd82d, 0xdf10, 0xd853, 0xdf6a, 0xd8a7,
0xe088, 0xd8ea, 0xe1d5, 0xd9ea, 0xe2a0, 0xdade, 0xe328, 0xdb14, 0xe3f8, 0xdbac,
0xe42c, 0xdcce, 0xe4b5, 0xdd5d, 0xe540, 0xddb7, 0xe5c5, 0xdde0, 0xe606, 0xde19,
0xe720, 0xde4b, 0xe795, 0xdf00, 0xe7db, 0xe009, 0xe8d6, 0xe105, 0xe885, 0xe08a,
0xe939, 0xe0f3, 0xeb5f, 0xe2bd, 0xebe1, 0xe324, 0xeb4c, 0xe381, 0xec43, 0xe46a,
0xeca5, 0xe571, 0xed88, 0xe640, 0xee9c, 0xe6c3, 0xef30, 0xe730, 0xefb8, 0xe7a5,
0xef99, 0xe7cd, 0xf126, 0xe980, 0xf2bf, 0xeadc, 0xf339, 0xeae2, 0xf33b, 0xeb3a,
0xf42c, 0xebd9, 0xf56f, 0xecbc, 0xf542, 0xece0, 0xf620, 0xed23, 0xf733, 0xed94,
0xf783, 0xee2a, 0xf73e, 0xee6f, 0xf717, 0xef12, 0xf7e5, 0xefca, 0xf8b4, 0xf0fc,
0xf910, 0xf211, 0xfab1, 0xf1a9, 0xfb09, 0xf1ec, 0xf9d6, 0xf2e9, 0xf9e4, 0xf3ee,
0xfb5b, 0xf501, 0xfbe2, 0xf53e, 0xfc87, 0xf57c, 0xfd1d, 0xf5ec, 0xfd9c, 0xf683,
0xfefd, 0xf79f, 0xff62, 0xf886, 0x0133, 0xf8f7, 0x02a5, 0xf9a0, 0x0179, 0xfa11,
0x02e2, 0xfa61, 0x050c, 0xfaf5, 0x0494, 0xfb10, 0x04d7, 0xfbbd, 0x062c, 0xfd4f,
0x0709, 0xfe4c, 0x07eb, 0xfee8, 0x08eb, 0xff61, 0x0936, 0xffce, 0x08e5, 0x0057,
0x09a5, 0x00a8, 0x0ba4, 0x00ca, 0x0c74, 0x00fb, 0x0b12, 0x0164, 0x0bbf, 0x030a,
0x0e89, 0x0387, 0x0e3d, 0x02d9, 0x0dcd, 0x03bb, 0x0ec2, 0x0499, 0x0f53, 0x050c,
0x1048, 0x05ea, 0x1121, 0x0679, 0x11e6, 0x07b8, 0x1276, 0x0854, 0x11a2, 0x0894,
0x12dc, 0x08f3, 0x14e6, 0x091f, 0x1474, 0x0a3a, 0x1455, 0x0c44, 0x16e5, 0x0cea,
0x187c, 0x0c2c, 0x1862, 0x0c95, 0x1852, 0x0d29, 0x18e9, 0x0d88, 0x19db, 0x0ddc,
0x1a6b, 0x0e67, 0x1ac4, 0x0f00, 0x1b81, 0x0f8b, 0x1bf7, 0x1018, 0x1bbc, 0x1101,
0x1da7, 0x11a3, 0x1e7d, 0x11ad, 0x1de8, 0x11d8, 0x1dc9, 0x11e7, 0x1df5, 0x1252,
0x1e80, 0x12be, 0x1eb4, 0x12f0, 0x1f0e, 0x136b, 0x1f92, 0x1454, 0x1fe0, 0x1534,
0x2038, 0x15fa, 0x211b, 0x1643, 0x2214, 0x16bd, 0x22b1, 0x1787, 0x2334, 0x1722,
0x2410, 0x171e, 0x236b, 0x1812, 0x22ef, 0x1860, 0x23c7, 0x18bd, 0x2456, 0x197b,
0x24ba, 0x19e5, 0x24c6, 0x1a17, 0x25ab, 0x1a77, 0x25bc, 0x1b25, 0x26ac, 0x1c38,
0x26f3, 0x1be4, 0x26b2, 0x1c97, 0x26da, 0x1d4e, 0x2710, 0x1c3f, 0x2718, 0x1c1c,
0x26e0, 0x1d15, 0x275b, 0x1dff, 0x27cc, 0x1e30, 0x2939, 0x1f1f, 0x2966, 0x1f44,
0x293c, 0x1f69, 0x2950, 0x1fe6, 0x2a4d, 0x208b, 0x2a8a, 0x2133, 0x28e2, 0x2065,
0x28a5, 0x2157, 0x28f5, 0x2227, 0x2944, 0x219a, 0x29f3, 0x218a, 0x299d, 0x2209,
0x2963, 0x2273, 0x29ee, 0x229a, 0x2a1f, 0x22c5, 0x2a3c, 0x2290, 0x2a35, 0x2247,
0x2a73, 0x2235, 0x2ab7, 0x234e, 0x2b87, 0x2439, 0x2c08, 0x23fc, 0x2a98, 0x23cf,
0x2abd, 0x23f5, 0x2cc1, 0x246a, 0x2ca2, 0x247f, 0x2c9d, 0x24a6, 0x2cce, 0x2513,
0x2cea, 0x257d, 0x2d21, 0x25e6, 0x2d4e, 0x2649, 0x2dd0, 0x2670, 0x2db2, 0x262e,
0x2cc1, 0x2615, 0x2c97, 0x26f8, 0x2eb0, 0x2732, 0x2e88, 0x268d, 0x2cb3, 0x2693,
0x2cf8, 0x26b3, 0x2dbd, 0x26e5, 0x2d8f, 0x2739, 0x2d2d, 0x278a, 0x2ce3, 0x27d5,
0x2cb0, 0x276a, 0x2cc5, 0x274a, 0x2d06, 0x27e2, 0x2d87, 0x2787, 0x2d6b, 0x2666,
0x2e64, 0x271a, 0x2edf, 0x27d3, 0x2d92, 0x26fe, 0x2cbc, 0x272e, 0x2cfd, 0x2757,
0x2d21, 0x26eb, 0x2ccc, 0x26a8, 0x2cf7, 0x26c6, 0x2d0b, 0x272f, 0x2d14, 0x270c,
0x2bf0, 0x267e, 0x2bcf, 0x268d, 0x2cf1, 0x2694, 0x2c5c, 0x25f3, 0x2b43, 0x2622,
0x2c26, 0x26ae, 0x2b7a, 0x25bf, 0x2aa5, 0x24fe, 0x2a91, 0x2504, 0x2aa3, 0x24e2,
0x2ac0, 0x24ef, 0x2a02, 0x24d3, 0x299a, 0x24d0, 0x2994, 0x247d, 0x291e, 0x240f,
0x289c, 0x2414, 0x28f7, 0x23d2, 0x2878, 0x2328, 0x2836, 0x2323, 0x2803, 0x239b,
0x2826, 0x2379, 0x271b, 0x22f3, 0x2702, 0x22f6, 0x2723, 0x2300, 0x2723, 0x22fd,
0x26b4, 0x22dd, 0x2641, 0x2261, 0x262b, 0x21fb, 0x258a, 0x21a1, 0x24f1, 0x215e,
0x2430, 0x201e, 0x241b, 0x1f67, 0x23e7, 0x1f98, 0x233f, 0x1f84, 0x226e, 0x1f5f,
0x2301, 0x1f92, 0x2315, 0x1f98, 0x22e3, 0x1f2f, 0x2203, 0x1ebe, 0x213d, 0x1e93,
0x2079, 0x1e72, 0x1f67, 0x1dfa, 0x1f98, 0x1dad, 0x1ee9, 0x1c9d, 0x1e4f, 0x1cd3,
0x1e62, 0x1d9b, 0x1e47, 0x1d79, 0x1dcb, 0x1d3c, 0x1d54, 0x1d49, 0x1cd3, 0x1cfb,
0x1c36, 0x1c66, 0x1b38, 0x1b91, 0x1ab3, 0x1b52, 0x1a78, 0x1b41, 0x18ab, 0x1a00,
0x1798, 0x19b0, 0x1936, 0x1900, 0x18a6, 0x1751, 0x165a, 0x1771, 0x1703, 0x17dc,
0x1770, 0x16c8, 0x16c2, 0x16e0, 0x1662, 0x1735, 0x1678, 0x172a, 0x1665, 0x1715,
0x1620, 0x161a, 0x1514, 0x15e2, 0x1391, 0x1562, 0x134c, 0x1460, 0x1340, 0x13f2,
0x12a5, 0x1410, 0x1189, 0x1385, 0x10e3, 0x1292, 0x0ffa, 0x1240, 0x0ef9, 0x1181,
0x0ead, 0x113a, 0x0e56, 0x109d, 0x0de2, 0x10a8, 0x0d5b, 0x104e, 0x0c57, 0x0f6c,
0x0c95, 0x0e5a, 0x0b08, 0x0e22, 0x0922, 0x0d91, 0x0aac, 0x0c91, 0x0bfb, 0x0bde,
0x0a6c, 0x0b7b, 0x0880, 0x0aed, 0x0889, 0x09cf, 0x07ec, 0x090f, 0x0704, 0x08dd,
0x0646, 0x0829, 0x059d, 0x076c, 0x055f, 0x0782, 0x043a, 0x0684, 0x040c, 0x0673,
0x0559, 0x05f6, 0x0490, 0x0524, 0x0342, 0x053a, 0x0350, 0x051b, 0x02de, 0x045f,
0x014d, 0x038e, 0x00cf, 0x02fb, 0x0064, 0x026d, 0xff99, 0x0229, 0xfefd, 0x016f,
0xfe5b, 0x0099, 0xfdf6, 0xff6d, 0xfd6d, 0xfe75, 0xfcc3, 0xfe30, 0xfadd, 0xfd11,
0xf97d, 0xfd7a, 0xf9fd, 0xfd2c, 0xf9cf, 0xfb39, 0xf8af, 0xfafe, 0xf815, 0xfb7a,
0xf7c2, 0xfaad, 0xf770, 0xfa43, 0xf74c, 0xf9d2, 0xf6bf, 0xf924, 0xf607, 0xf89e,
0xf4d9, 0xf814, 0xf49e, 0xf80c, 0xf4d0, 0xf72d, 0xf32f, 0xf566, 0xf2d3, 0xf578,
0xf2ca, 0xf5c6, 0xf1af, 0xf4c4, 0xf0f4, 0xf429, 0xf02e, 0xf3c4, 0xef26, 0xf32e,
0xeeb8, 0xf278, 0xee46, 0xf1e4, 0xed67, 0xf171, 0xec3d, 0xf0b7, 0xead3, 0xefb1,
0xea1a, 0xefac, 0xeb4b, 0xef44, 0xeae3, 0xee36, 0xe977, 0xeddb, 0xe8ef, 0xedf6,
0xe8ca, 0xedb3, 0xe867, 0xed1d, 0xe7d3, 0xecd2, 0xe797, 0xecb9, 0xe716, 0xecd7,
0xe6a6, 0xec71, 0xe5fb, 0xebaa, 0xe59f, 0xeba4, 0xe4ca, 0xeabf, 0xe50d, 0xea14,
0xe408, 0xe94f, 0xe34d, 0xe91e, 0xe3a3, 0xe91c, 0xe2f5, 0xe842, 0xe24f, 0xe7dc,
0xe1ca, 0xe6c6, 0xe132, 0xe6b9, 0xe095, 0xe614, 0xe006, 0xe5ab, 0xdec0, 0xe523,
0xddbd, 0xe458, 0xdd8e, 0xe38b, 0xde3e, 0xe381, 0xde14, 0xe3fa, 0xdcdd, 0xe350,
0xdbd6, 0xe232, 0xdb40, 0xe170, 0xdae5, 0xe12f, 0xda01, 0xe035, 0xd988, 0xe057,
0xd931, 0xdf7a, 0xd8c3, 0xdf32, 0xd857, 0xdf18, 0xd885, 0xde74, 0xd8bc, 0xde21,
0xd849, 0xde6b, 0xd737, 0xde15, 0xd679, 0xddbd, 0xd68b, 0xdd36, 0xd687, 0xdc79,
0xd653, 0xdc28, 0xd596, 0xdb32, 0xd500, 0xdb19, 0xd49d, 0xdaed, 0xd499, 0xdaf2,
0xd4cd, 0xda42, 0xd4c0, 0xda1b, 0xd3f0, 0xdaba, 0xd42c, 0xdaa1, 0xd49c, 0xd971,
0xd36f, 0xd974, 0xd326, 0xda76, 0xd35a, 0xd9cb, 0xd23d, 0xd911, 0xd180, 0xd8cf,
0xd1cb, 0xd8b3, 0xd1ca, 0xd828, 0xd162, 0xd7f7, 0xd0ee, 0xd7ac, 0xd014, 0xd6fe,
0xcf3a, 0xd683, 0xcebd, 0xd6ae, 0xcf27, 0xd6f1, 0xcf13, 0xd5f3, 0xced8, 0xd57b,
0xcebb, 0xd5e7, 0xceb6, 0xd550, 0xced9, 0xd50d, 0xcebc, 0xd51a, 0xcebd, 0xd519,
0xcee5, 0xd4cb, 0xcf0f, 0xd477, 0xcf33, 0xd491, 0xcf11, 0xd459, 0xced1, 0xd4e9,
0xcea9, 0xd502, 0xcee2, 0xd4b0, 0xce82, 0xd4fa, 0xce94, 0xd500, 0xcf42, 0xd4ed,
0xcf2a, 0xd504, 0xced1, 0xd56d, 0xcebc, 0xd599, 0xcede, 0xd57b, 0xcf25, 0xd54b,
0xcf4f, 0xd5ba, 0xcea0, 0xd5a2, 0xcec5, 0xd58e, 0xceb4, 0xd59e, 0xcf3a, 0xd607,
0xcfbf, 0xd5db, 0xcf0a, 0xd57b, 0xced5, 0xd550, 0xcef7, 0xd557, 0xcf26, 0xd5a9,
0xcee3, 0xd5a7, 0xcf37, 0xd5fd, 0xcf8c, 0xd632, 0xcfc0, 0xd66c, 0xcfd2, 0xd6bb,
0xd06e, 0xd738, 0xd10c, 0xd7ac, 0xd11e, 0xd786, 0xd036, 0xd71f, 0xd015, 0xd78d,
0xd10f, 0xd7f8, 0xd1bd, 0xd771, 0xd1ef, 0xd74d, 0xd166, 0xd731, 0xd19d, 0xd74c,
0xd19f, 0xd743, 0xd1fb, 0xd79d, 0xd2ca, 0xd870, 0xd274, 0xd936, 0xd24e, 0xd9b9,
0xd326, 0xd90c, 0xd3f9, 0xd888, 0xd3f2, 0xd945, 0xd49b, 0xd97c, 0xd498, 0xd9aa,
0xd43e, 0xda42, 0xd481, 0xda70, 0xd4db, 0xdad1, 0xd521, 0xdac5, 0xd537, 0xdb0d,
0xd5a8, 0xdb63, 0xd5a7, 0xdb80, 0xd50b, 0xdbee, 0xd54b, 0xdc3f, 0xd65f, 0xdcca,
0xd687, 0xdd5a, 0xd6bd, 0xdde4, 0xd6fd, 0xdf1e, 0xd745, 0xdfca, 0xd840, 0xe061,
0xd89a, 0xe0bf, 0xd89b, 0xe13c, 0xd8b8, 0xe190, 0xd930, 0xe17c, 0xd993, 0xe151,
0xd93a, 0xe16f, 0xda5c, 0xe27e, 0xdb4d, 0xe289, 0xdb63, 0xe3ef, 0xdbef, 0xe3de,
0xdc68, 0xe3aa, 0xdcb2, 0xe418, 0xdd12, 0xe49e, 0xdd9d, 0xe564, 0xde48, 0xe62d,
0xde90, 0xe682, 0xdebf, 0xe672, 0xdf6d, 0xe67f, 0xe009, 0xe6ee, 0xe09f, 0xe7c0,
0xe0bd, 0xe76b, 0xe23e, 0xe8e3, 0xe2b1, 0xe8c3, 0xe241, 0xe880, 0xe299, 0xe962,
0xe3a4, 0xe993, 0xe42e, 0xe987, 0xe45b, 0xe9ac, 0xe4c2, 0xea43, 0xe535, 0xeb34,
0xe629, 0xebd5, 0xe6b4, 0xeca8, 0xe6e8, 0xed01, 0xe730, 0xed25, 0xe7e3, 0xedac,
0xe81a, 0xee37, 0xe8de, 0xeeea, 0xe948, 0xefb9, 0xea16, 0xf092, 0xeb2c, 0xf10e,
0xebf3, 0xf198, 0xeca8, 0xf237, 0xed5c, 0xf2f6, 0xeddb, 0xf387, 0xee4a, 0xf435,
0xef6f, 0xf445, 0xefcd, 0xf47d, 0xef9b, 0xf4bd, 0xf11c, 0xf5ef, 0xf278, 0xf593,
0xf23a, 0xf550, 0xf225, 0xf69a, 0xf2ee, 0xf79b, 0xf3c2, 0xf83a, 0xf488, 0xf8a9,
0xf526, 0xf8f5, 0xf593, 0xf97b, 0xf67d, 0xfa46, 0xf748, 0xfaa7, 0xf7e0, 0xfbc3,
0xf803, 0xfb80, 0xf816, 0xfbb8, 0xf8b8, 0xfcfe, 0xf9fb, 0xfdbf, 0xfaea, 0xfe02,
0xfacf, 0xfeca, 0xfaf3, 0xffdc, 0xfae7, 0x0059, 0xfbfd, 0x0105, 0xfd15, 0x01ce,
0xfdca, 0x0271, 0xfdd6, 0x0216, 0xfdf1, 0x027d, 0xfe9a, 0x03f2, 0xfed3, 0x0490,
0xfee1, 0x04bf, 0x0076, 0x057a, 0x022b, 0x0607, 0x01e8, 0x0670, 0x02cc, 0x074f,
0x0381, 0x0803, 0x04bb, 0x08eb, 0x052d, 0x0960, 0x05ec, 0x0a33, 0x06ad, 0x0adb,
0x075c, 0x0b30, 0x081a, 0x0c5c, 0x0830, 0x0d82, 0x08a2, 0x0dda, 0x089c, 0x0e39,
0x08c6, 0x0ef5, 0x08a6, 0x0f2e, 0x0954, 0x0fca, 0x0989, 0x0fd9, 0x0a24, 0x105a,
0x0b1e, 0x1127, 0x0bef, 0x11c3, 0x0c32, 0x1273, 0x0be1, 0x12de, 0x0d80, 0x1321,
0x0eba, 0x1393, 0x0e66, 0x14e3, 0x0eca, 0x159a, 0x0fd3, 0x165b, 0x1034, 0x16c4,
0x101e, 0x172d, 0x10c5, 0x17ae, 0x11d0, 0x1835, 0x1277, 0x18ad, 0x12bc, 0x1910,
0x1357, 0x19f1, 0x13b7, 0x1aa7, 0x1436, 0x1b16, 0x14e8, 0x1b11, 0x154a, 0x1b8c,
0x158c, 0x1bcf, 0x1610, 0x1cc2, 0x1783, 0x1e2a, 0x1832, 0x1e53, 0x1884, 0x1f67,
0x18ee, 0x2020, 0x192f, 0x205a, 0x19d6, 0x20dd, 0x1a75, 0x20f2, 0x1af6, 0x2200,
0x1b82, 0x22a1, 0x1c47, 0x2367, 0x1cfb, 0x24c1, 0x1d90, 0x24d6, 0x1da8, 0x2451,
0x1e42, 0x2568, 0x1f1a, 0x25e4, 0x1f49, 0x25ec, 0x2054, 0x265a, 0x20fa, 0x2689,
0x2192, 0x26eb, 0x2221, 0x2747, 0x22bc, 0x2819, 0x2350, 0x283f, 0x2422, 0x2865,
0x23f0, 0x28e1, 0x2463, 0x2a2c, 0x2574, 0x2a34, 0x2559, 0x2a2f, 0x25c0, 0x2b3c,
0x263b, 0x2b72, 0x26e5, 0x2bc8, 0x2754, 0x2c0d, 0x27c1, 0x2c85, 0x28a1, 0x2d2b,
0x2974, 0x2dc7, 0x29ce, 0x2e8f, 0x2a02, 0x2ec8, 0x2a07, 0x2e1c, 0x2a25, 0x2e81,
0x2a56, 0x2f2a, 0x2a7e, 0x2f11, 0x2a0d, 0x2f1a, 0x2a5d, 0x2fa5, 0x2b47, 0x2fbb,
0x2b69, 0x2fce, 0x2b71, 0x2ffa, 0x2b56, 0x304c, 0x2bf3, 0x30ba, 0x2c97, 0x30a7,
0x2d03, 0x30d6, 0x2cdd, 0x317a, 0x2dbb, 0x3233, 0x2edd, 0x3329, 0x2ec6, 0x33d1,
0x2f2c, 0x33ab, 0x2faf, 0x33e2, 0x2fd6, 0x346b, 0x2fc9, 0x34a8, 0x303f, 0x3487,
0x3046, 0x3478, 0x3041, 0x344a, 0x2ffd, 0x3465, 0x302e, 0x34d1, 0x303f, 0x34d4,
0x307b, 0x3525, 0x30d8, 0x346c, 0x30d5, 0x33c0, 0x3142, 0x3460, 0x3188, 0x34ff,
0x3233, 0x3553, 0x32a5, 0x359d, 0x32da, 0x35dc, 0x3319, 0x3625, 0x33a2, 0x3657,
0x3388, 0x3675, 0x3357, 0x3668, 0x3441, 0x36d2, 0x33fc, 0x3713, 0x3300, 0x36ba,
0x343c, 0x3768, 0x349d, 0x3763, 0x331d, 0x36d1, 0x3332, 0x36db, 0x33a0, 0x36ac,
0x33cf, 0x36d0, 0x33fe, 0x36ac, 0x33fb, 0x3698, 0x340f, 0x3672, 0x33ce, 0x3649,
0x33dc, 0x3757, 0x34b3, 0x380f, 0x342e, 0x3764, 0x3437, 0x36d1, 0x3595, 0x3711,
0x359f, 0x3775, 0x357f, 0x387c, 0x35c5, 0x38a1, 0x360e, 0x389b, 0x35ce, 0x3861,
0x3585, 0x388e, 0x3590, 0x38c8, 0x3580, 0x38cb, 0x3484, 0x384f, 0x34d9, 0x3822,
0x355e, 0x386a, 0x3469, 0x377c, 0x3449, 0x376d, 0x3540, 0x378b, 0x3523, 0x377d,
0x3417, 0x36fb, 0x33e9, 0x36dd, 0x33be, 0x3698, 0x33c2, 0x36d5, 0x334e, 0x3683,
0x3300, 0x367a, 0x33cd, 0x365f, 0x33bb, 0x3655, 0x3367, 0x3701, 0x33c0, 0x36f6,
0x339a, 0x36c2, 0x333f, 0x3659, 0x3383, 0x365c, 0x3303, 0x363b, 0x32b4, 0x3653,
0x32a5, 0x3638, 0x3214, 0x356e, 0x31b5, 0x351c, 0x3142, 0x347d, 0x3194, 0x34e7,
0x31cb, 0x35fe, 0x30de, 0x35a3, 0x3185, 0x354e, 0x3239, 0x3527, 0x30dc, 0x34a4,
0x2fd2, 0x3422, 0x3052, 0x343a, 0x3004, 0x3424, 0x2f1d, 0x340a, 0x2ef5, 0x33ff,
0x2f0f, 0x3359, 0x2ec6, 0x331f, 0x2e12, 0x32c9, 0x2e0e, 0x3224, 0x2deb, 0x3132,
0x2d68, 0x3117, 0x2ca5, 0x30e7, 0x2c36, 0x30b0, 0x2b91, 0x308d, 0x2b20, 0x2feb,
0x2abb, 0x2f70, 0x2ab4, 0x2f49, 0x2ac4, 0x2f5d, 0x2ab9, 0x2f18, 0x2a38, 0x2e72,
0x2a06, 0x2deb, 0x2ad7, 0x2db1, 0x2a72, 0x2dbc, 0x29f0, 0x2dad, 0x28c5, 0x2d3f,
0x27c8, 0x2cb2, 0x285d, 0x2c57, 0x28b2, 0x2c36, 0x27cd, 0x2bda, 0x278b, 0x2b82,
0x2765, 0x2af9, 0x26e9, 0x2a12, 0x2674, 0x297f, 0x2606, 0x290e, 0x261d, 0x288e,
0x250d, 0x27da, 0x2397, 0x2778, 0x23f9, 0x26c2, 0x2452, 0x263a, 0x2379, 0x261f,
0x239c, 0x25d6, 0x2421, 0x2533, 0x2389, 0x24ae, 0x22eb, 0x240e, 0x221f, 0x2391,
0x21aa, 0x2317, 0x2144, 0x2287, 0x20ee, 0x22cb, 0x2179, 0x224e, 0x2183, 0x21b8,
0x2037, 0x2184, 0x1ffa, 0x21f4, 0x1fd6, 0x2125, 0x1efd, 0x2005, 0x1e95, 0x1fa4,
0x1e6a, 0x1f13, 0x1df1, 0x1e7a, 0x1d4d, 0x1d95, 0x1cbc, 0x1d06, 0x1c7e, 0x1c98,
0x1c3e, 0x1c16, 0x1b93, 0x1c26, 0x1b29, 0x1ba8, 0x1a85, 0x1a29, 0x1a4c, 0x19cd,
0x1947, 0x19a8, 0x18f4, 0x1900, 0x189a, 0x17db, 0x1792, 0x1719, 0x169a, 0x167b,
0x15ad, 0x1619, 0x155a, 0x1586, 0x157d, 0x1517, 0x15ad, 0x1488, 0x14a5, 0x13e7,
0x137e, 0x13ad, 0x12e8, 0x12fb, 0x1427, 0x1274, 0x13e9, 0x1246, 0x12cd, 0x11fd,
0x11f7, 0x10f4, 0x1147, 0x104a, 0x10a1, 0x101d, 0x0fb3, 0x0fbd, 0x0f18, 0x0f00,
0x0ebf, 0x0e80, 0x0eae, 0x0e5d, 0x0dc7, 0x0e21, 0x0cdb, 0x0d3b, 0x0c75, 0x0c90,
0x0be9, 0x0cd6, 0x0ab1, 0x0bc7, 0x09ec, 0x0ae6, 0x0975, 0x0ac8, 0x0901, 0x0a68,
0x0899, 0x0935, 0x081f, 0x0881, 0x0780, 0x07d3, 0x06e2, 0x0752, 0x0623, 0x0667,
0x0527, 0x0578, 0x043f, 0x0555, 0x0403, 0x049c, 0x0401, 0x03ee, 0x0324, 0x0406,
0x022a, 0x03b1, 0x01af, 0x0262, 0x0175, 0x0224, 0x00d0, 0x01ff, 0x004b, 0x015b,
0xffb7, 0x00b3, 0xfead, 0x0011, 0xfe11, 0xff4a, 0xfd59, 0xfe96, 0xfc71, 0xfe37,
0xfc07, 0xfddd, 0xfc29, 0xfd68, 0xfc08, 0xfcf3, 0xfb6a, 0xfc7d, 0xfa5e, 0xfc32,
0xf97f, 0xfb67, 0xf8db, 0xfa79, 0xf85c, 0xfa10, 0xf801, 0xf969, 0xf77a, 0xf8ad,
0xf6b2, 0xf7b1, 0xf5f2, 0xf6f6, 0xf4d2, 0xf6af, 0xf461, 0xf66d, 0xf465, 0xf5aa,
0xf3e9, 0xf4e0, 0xf3cb, 0xf485, 0xf345, 0xf3e4, 0xf2bb, 0xf316, 0xf1d3, 0xf2a0,
0xf0e4, 0xf229, 0xf056, 0xf150, 0xef84, 0xf051, 0xef33, 0xefc1, 0xeecf, 0xefa8,
0xee2d, 0xef08, 0xedb3, 0xeef3, 0xeca4, 0xeed6, 0xec38, 0xee53, 0xec4d, 0xed2d,
0xeb19, 0xeb77, 0xea1b, 0xeb04, 0xe9ce, 0xea96, 0xe990, 0xe9fc, 0xe8e5, 0xe969,
0xe879, 0xe90e, 0xe81e, 0xe866, 0xe7b9, 0xe803, 0xe77c, 0xe76b, 0xe714, 0xe709,
0xe6b8, 0xe659, 0xe5fd, 0xe54f, 0xe598, 0xe452, 0xe4f7, 0xe3e6, 0xe4d1, 0xe3c1,
0xe489, 0xe313, 0xe3b2, 0xe2b1, 0xe355, 0xe209, 0xe2ee, 0xe192, 0xe272, 0xe144,
0xe21f, 0xe153, 0xe1c7, 0xe10b, 0xe17f, 0xe0a9, 0xe17c, 0xdf9f, 0xe1c4, 0xdf84,
0xe0d5, 0xdf19, 0xdfb0, 0xdecc, 0xdf35, 0xde3a, 0xde75, 0xdd84, 0xddfb, 0xdce8,
0xdd85, 0xdc06, 0xdd37, 0xdba8, 0xdce1, 0xdaed, 0xdc65, 0xda9c, 0xdbbc, 0xd9ec,
0xdb62, 0xd99d, 0xda95, 0xd92b, 0xda45, 0xd85e, 0xdad3, 0xd83a, 0xdad6, 0xd7ed,
0xda55, 0xd74a, 0xd9bd, 0xd6f7, 0xd908, 0xd6d4, 0xd8a8, 0xd685, 0xd829, 0xd5f1,
0xd7e7, 0xd566, 0xd7a2, 0xd551, 0xd724, 0xd51b, 0xd6fa, 0xd4fc, 0xd70e, 0xd479,
0xd76b, 0xd3a3, 0xd6bc, 0xd355, 0xd688, 0xd3c7, 0xd64a, 0xd339, 0xd602, 0xd27e,
0xd5a1, 0xd20c, 0xd5dd, 0xd249, 0xd59f, 0xd24e, 0xd523, 0xd1f9, 0xd499, 0xd15e,
0xd3d1, 0xd0af, 0xd391, 0xd07e, 0xd285, 0xd04d, 0xd250, 0xcfd9, 0xd2a6, 0xcfe2,
0xd254, 0xd005, 0xd1ea, 0xcf47, 0xd1b1, 0xcef7, 0xd1b9, 0xcec2, 0xd132, 0xce57,
0xd113, 0xce58, 0xd102, 0xce5a, 0xd0d2, 0xcddf, 0xd031, 0xcd70, 0xcf58, 0xcc80,
0xcf64, 0xcc6d, 0xcf99, 0xcc77, 0xcf90, 0xcbd6, 0xcf10, 0xcb29, 0xced6, 0xcb91,
0xcf00, 0xcbc9, 0xcee7, 0xcb65, 0xce7c, 0xcbac, 0xce39, 0xcb67, 0xcdc7, 0xcb0d,
0xcd6f, 0xcac6, 0xcd06, 0xcadd, 0xccd7, 0xca95, 0xcd27, 0xca52, 0xcd3f, 0xca02,
0xcd22, 0xca24, 0xcc83, 0xca38, 0xccef, 0xca4a, 0xcd53, 0xca21, 0xcce9, 0xc9c0,
0xccad, 0xc9b9, 0xcc60, 0xc990, 0xcc39, 0xc948, 0xcbd6, 0xc89f, 0xcbcf, 0xc876,
0xcb91, 0xc840, 0xcb8e, 0xc81c, 0xcb9a, 0xc854, 0xcbf8, 0xc885, 0xcc09, 0xc892,
0xcb91, 0xc880, 0xcbdc, 0xc859, 0xcb95, 0xc82f, 0xcb6f, 0xc7c6, 0xcbb0, 0xc7cb,
0xcbe8, 0xc7be, 0xcc25, 0xc7e2, 0xccb6, 0xc7f2, 0xcc82, 0xc7bb, 0xcc76, 0xc7eb,
0xcc81, 0xc7ca, 0xcd06, 0xc799, 0xcd0a, 0xc782, 0xcb90, 0xc7bf, 0xcbd3, 0xc7d3,
0xccff, 0xc7e7, 0xccd7, 0xc7e6, 0xcc7b, 0xc7c4, 0xccc0, 0xc7ca, 0xccab, 0xc856,
0xcca6, 0xc8ad, 0xcc81, 0xc8b9, 0xccfc, 0xc875, 0xcdd3, 0xc858, 0xcd82, 0xc8c9,
0xcd51, 0xc89f, 0xcdc0, 0xc854, 0xcd6b, 0xc89e, 0xcdb4, 0xc90d, 0xceb4, 0xc930,
0xce9f, 0xc92f, 0xce6e, 0xc96a, 0xcec7, 0xc9dc, 0xcf3d, 0xc9e3, 0xcf91, 0xc9ea,
0xcf76, 0xc9c6, 0xcf85, 0xc9fc, 0xd02f, 0xc9e8, 0xd076, 0xca07, 0xd01f, 0xca73,
0xd09f, 0xcaf5, 0xd15b, 0xcb78, 0xd15e, 0xcb78, 0xd195, 0xcbce, 0xd1e3, 0xcc4d,
0xd237, 0xcc7b, 0xd27f, 0xccbb, 0xd2a4, 0xcd1d, 0xd2cf, 0xcd5f, 0xd310, 0xcd88,
0xd37f, 0xcdd1, 0xd447, 0xcdcd, 0xd499, 0xce5d, 0xd47e, 0xcef7, 0xd43c, 0xce56,
0xd43d, 0xceb9, 0xd4f9, 0xcfb3, 0xd59a, 0xd06b, 0xd5db, 0xd0b3, 0xd5b2, 0xd111,
0xd5e0, 0xd129, 0xd62d, 0xd134, 0xd6a7, 0xd17c, 0xd6b5, 0xd20a, 0xd6fb, 0xd2a3,
0xd7d0, 0xd25f, 0xd83e, 0xd2a4, 0xd8a5, 0xd27a, 0xd8a8, 0xd2da, 0xd862, 0xd395,
0xd8fc, 0xd3d2, 0xd973, 0xd426, 0xd994, 0xd443, 0xda07, 0xd4ab, 0xda68, 0xd53f,
0xdb59, 0xd60e, 0xdb9d, 0xd683, 0xdcbd, 0xd6c9, 0xdd6c, 0xd6e6, 0xdd53, 0xd7c2,
0xddb3, 0xd84c, 0xded1, 0xd886, 0xdee7, 0xd91a, 0xded8, 0xd932, 0xdf64, 0xd96a,
0xdf49, 0xd961, 0xdfd0, 0xd9e5, 0xdf8e, 0xda1e, 0xdfed, 0xdaae, 0xe008, 0xdab6,
0xe028, 0xdb31, 0xdfd6, 0xdb3c, 0xe050, 0xdb7c, 0xe0c2, 0xdc01, 0xe150, 0xdcad,
0xe218, 0xdd03, 0xe232, 0xdd37, 0xe290, 0xddbf, 0xe2fa, 0xdde3, 0xe3b0, 0xdead,
0xe43f, 0xdf15, 0xe539, 0xe027, 0xe599, 0xe0db, 0xe64e, 0xe1c1, 0xe6c3, 0xe1d0,
0xe787, 0xe1c7, 0xe7ab, 0xe22e, 0xe800, 0xe2bf, 0xe909, 0xe391, 0xea04, 0xe43d,
0xea56, 0xe493, 0xea70, 0xe4ee, 0xeae1, 0xe531, 0xeb22, 0xe582, 0xebc0, 0xe650,
0xec6d, 0xe6a1, 0xece4, 0xe767, 0xecf3, 0xe707, 0xedb4, 0xe772, 0xee03, 0xe792,
0xedea, 0xe7b4, 0xee76, 0xe8a8, 0xef83, 0xe97e, 0xefec, 0xea68, 0xf05f, 0xeb03,
0xf095, 0xeb8c, 0xf111, 0xec13, 0xf12e, 0xecd2, 0xf1c1, 0xed60, 0xf262, 0xee39,
0xf2c6, 0xeeb9, 0xf34e, 0xeed2, 0xf43d, 0xef80, 0xf547, 0xf0cb, 0xf584, 0xf198,
0xf6ae, 0xf211, 0xf74c, 0xf284, 0xf858, 0xf333, 0xf8ea, 0xf3c4, 0xf9e1, 0xf460,
0xfa69, 0xf4fa, 0xfa93, 0xf5c0, 0xfb53, 0xf684, 0xfb6c, 0xf66e, 0xfb6f, 0xf68b,
0xfc12, 0xf764, 0xfd3e, 0xf83c, 0xfcc0, 0xf841, 0xfcf9, 0xf912, 0xfdb3, 0xf9a7,
0xfe0e, 0xf9e6, 0xfe26, 0xfa4e, 0xfeb6, 0xfaea, 0xff67, 0xfb7e, 0xffde, 0xfc0b,
0x008b, 0xfccc, 0x0146, 0xfd98, 0x026b, 0xfdd7, 0x023e, 0xfe53, 0x01ee, 0xfef5,
0x031e, 0xff9c, 0x0458, 0x00dc, 0x04bb, 0x0144, 0x0502, 0x01a5, 0x055c, 0x0247,
0x0633, 0x032b, 0x06eb, 0x03ef, 0x0708, 0x048d, 0x0776, 0x0512, 0x0830, 0x0581,
0x092c, 0x066d, 0x09aa, 0x06fb, 0x09e4, 0x07c7, 0x0a44, 0x0820, 0x0a59, 0x085a,
0x0a37, 0x08e1, 0x0acf, 0x094c, 0x0b92, 0x09a6, 0x0bc2, 0x0a29, 0x0c05, 0x0ad4,
0x0c6d, 0x0b40, 0x0d00, 0x0bc0, 0x0d71, 0x0c59, 0x0e34, 0x0cb2, 0x0e8a, 0x0d47,
0x0fdb, 0x0e68, 0x10e5, 0x0f1c, 0x1090, 0x0fb5, 0x107d, 0x1021, 0x1166, 0x104d,
0x121c, 0x10cb, 0x123d, 0x118f, 0x128b, 0x1252, 0x1287, 0x1329, 0x130c, 0x13c8,
0x132f, 0x1447, 0x13df, 0x14a4, 0x14cd, 0x14af, 0x151c, 0x14bc, 0x15ae, 0x1599,
0x1604, 0x1614, 0x1569, 0x162e, 0x15f8, 0x16a9, 0x16ba, 0x16ed, 0x1726, 0x1772,
0x1770, 0x1754, 0x17bb, 0x17b9, 0x1871, 0x1842, 0x1908, 0x18d8, 0x19b9, 0x1964,
0x1a34, 0x19af, 0x1aa9, 0x1a0a, 0x1b27, 0x1a2d, 0x1aba, 0x1aa7, 0x1aef, 0x1bb4,
0x1c64, 0x1cab, 0x1d0d, 0x1cbf, 0x1da6, 0x1d37, 0x1dde, 0x1dca, 0x1e93, 0x1ebd,
0x1f3b, 0x1f16, 0x1f99, 0x1f59, 0x1fd9, 0x1fae, 0x2053, 0x1fd1, 0x20fa, 0x1fe4,
0x2126, 0x202c, 0x20e7, 0x20d0, 0x21a7, 0x2180, 0x227d, 0x21b9, 0x22dd, 0x218f,
0x2318, 0x219d, 0x2301, 0x21af, 0x236c, 0x2219, 0x235b, 0x228b, 0x23cb, 0x22f0,
0x23ea, 0x22fc, 0x240c, 0x233e, 0x2400, 0x2349, 0x24f2, 0x23be, 0x2543, 0x2405,
0x24e5, 0x246b, 0x2540, 0x2475, 0x25b2, 0x24ac, 0x25a2, 0x2505, 0x2614, 0x254a,
0x2725, 0x2626, 0x276a, 0x267c, 0x27d3, 0x26f6, 0x2801, 0x2763, 0x289e, 0x27d6,
0x294d, 0x2878, 0x2998, 0x28fd, 0x2950, 0x291c, 0x2983, 0x2a3a, 0x29a5, 0x2a0f,
0x2a37, 0x2a6f, 0x2aaf, 0x2b17, 0x2ae7, 0x2b5e, 0x2b02, 0x2b9a, 0x2b46, 0x2b71,
0x2bb8, 0x2bce, 0x2bef, 0x2c0a, 0x2c09, 0x2c76, 0x2bbd, 0x2ca8, 0x2bf9, 0x2ce7,
0x2c74, 0x2d0d, 0x2c9a, 0x2d01, 0x2b9e, 0x2ca9, 0x2b1a, 0x2d20, 0x2b3b, 0x2d13,
0x2bd0, 0x2d59, 0x2bf5, 0x2dc6, 0x2c10, 0x2e1b, 0x2c01, 0x2e50, 0x2bec, 0x2e50,
0x2bf7, 0x2e4a, 0x2bee, 0x2e8c, 0x2cb1, 0x2ec1, 0x2cdc, 0x2e9b, 0x2ca1, 0x2f17,
0x2c98, 0x2fcd, 0x2c43, 0x2fa3, 0x2c21, 0x2f48, 0x2c70, 0x2ff0, 0x2cb8, 0x304b,
0x2ca2, 0x307b, 0x2cca, 0x3092, 0x2cdc, 0x30d4, 0x2d20, 0x3100, 0x2d2f, 0x30f8,
0x2ca9, 0x3151, 0x2d3e, 0x324e, 0x2db5, 0x31f7, 0x2d35, 0x31bb, 0x2cc6, 0x3255,
0x2dcd, 0x32ab, 0x2dfd, 0x326f, 0x2d8b, 0x3210, 0x2d5e, 0x321a, 0x2d5a, 0x31de,
0x2d5b, 0x3213, 0x2cde, 0x31ff, 0x2cb3, 0x31cb, 0x2c96, 0x3136, 0x2c82, 0x316f,
0x2c42, 0x3229, 0x2cc1, 0x3209, 0x2cff, 0x31dd, 0x2cde, 0x3225, 0x2d01, 0x324a,
0x2cb9, 0x322d, 0x2c43, 0x3275, 0x2c61, 0x3268, 0x2cba, 0x3281, 0x2ca7, 0x32b5,
0x2cf9, 0x32b3, 0x2d5f, 0x326a, 0x2d4d, 0x326f, 0x2cd4, 0x3298, 0x2cfc, 0x32de,
0x2d43, 0x32cb, 0x2d99, 0x3275, 0x2da0, 0x32a0, 0x2d94, 0x3252, 0x2d54, 0x320f,
0x2d94, 0x322c, 0x2dda, 0x3246, 0x2dc3, 0x31f0, 0x2d6a, 0x31ae, 0x2c6c, 0x312a,
0x2c56, 0x3138, 0x2cb3, 0x30bb, 0x2c95, 0x30a7, 0x2bea, 0x3152, 0x2c57, 0x30ec,
0x2c6b, 0x30fc, 0x2bdd, 0x30d1, 0x2bd0, 0x30bc, 0x2baf, 0x3081, 0x2bab, 0x306c,
0x2b6c, 0x300c, 0x2b5b, 0x2ff1, 0x2af4, 0x2fbc, 0x2a5f, 0x2f4e, 0x2a95, 0x2f1d,
0x2a96, 0x2ea4, 0x2a14, 0x2e1d, 0x29c1, 0x2e23, 0x2962, 0x2e15, 0x2943, 0x2d7a,
0x2935, 0x2cfa, 0x294d, 0x2c9e, 0x2920, 0x2c77, 0x288f, 0x2c21, 0x2866, 0x2bf2,
0x27f4, 0x2b58, 0x2775, 0x2ae3, 0x2704, 0x2ae7, 0x2715, 0x2acb, 0x26d3, 0x2a44,
0x264e, 0x29ce, 0x2600, 0x29b7, 0x25f8, 0x29b3, 0x25d0, 0x29b6, 0x256d, 0x2970,
0x2520, 0x28c8, 0x24dc, 0x284a, 0x2503, 0x27a2, 0x2497, 0x2759, 0x2404, 0x2747,
0x2341, 0x268b, 0x22a6, 0x26c2, 0x22cb, 0x26f4, 0x2334, 0x2606, 0x22d4, 0x250c,
0x2279, 0x251c, 0x21ff, 0x2510, 0x213c, 0x24e6, 0x20b6, 0x2486, 0x2006, 0x23f8,
0x1fbe, 0x2373, 0x1f26, 0x231f, 0x1e8f, 0x22e0, 0x1e7b, 0x2261, 0x1e28, 0x2195,
0x1d24, 0x21e9, 0x1c5d, 0x217e, 0x1b3d, 0x1f6c, 0x1abb, 0x2068, 0x1c84, 0x219b,
0x1ccc, 0x2012, 0x19ad, 0x1e19, 0x180d, 0x1c39, 0x1900, 0x1ca0, 0x1a07, 0x1dd8,
0x175c, 0x1b02, 0x145c, 0x1810, 0x1463, 0x187d, 0x147d, 0x193d, 0x1707, 0x1b03,
0x1f4e, 0x20e5, 0x1e44, 0x22fc, 0x132b, 0x1bf3, 0x1058, 0x16c7, 0x1380, 0x173d,
0x1492, 0x1ab3, 0x1549, 0x1c08, 0x136c, 0x19f8, 0x12c7, 0x198d, 0x11dd, 0x183d,
0x0bfd, 0x105a, 0x0826, 0x0b25, 0x04fa, 0x0c47, 0x0b5f, 0x1410, 0x1909, 0x1d50,
0x1760, 0x1968, 0xff6b, 0x0734, 0x01a0, 0x09bf, 0x0d81, 0x1289, 0x0bc3, 0x1141,
0x07c6, 0x0de2, 0x048c, 0x0a91, 0x0203, 0x0864, 0x0697, 0x0daa, 0x05d4, 0x0dd3,
0xffa5, 0x0868, 0xfcf0, 0x036a, 0xfd30, 0x0439, 0xffab, 0x0923, 0x07ee, 0x0f29,
0x08a7, 0x0e7a, 0x0117, 0x0a61, 0xfcc2, 0x0612, 0xf89c, 0x00b3, 0xf765, 0xff89,
0xfb75, 0x04b3, 0xfe01, 0x08b3, 0xfd36, 0x079a, 0xfc58, 0x053d, 0xf93a, 0x01f1,
0xf576, 0xfe8b, 0xf5b1, 0xfc99, 0xf5d3, 0xff22, 0xf91c, 0x0271, 0xfba7, 0x041f,
0xfb90, 0x04c2, 0xf784, 0x0089, 0xf221, 0xfa91, 0xedb6, 0xf59b, 0xefad, 0xf7c9,
0xf4a4, 0xfd69, 0xf346, 0xfb76, 0xf20e, 0xf94e, 0xf1f7, 0xf91d, 0xf20c, 0xfa6d,
0xed24, 0xf97d, 0xeb57, 0xf682, 0xf0d2, 0xf654, 0xeeee, 0xf54f, 0xece8, 0xf5a2,
0xf009, 0xf8d9, 0xec1b, 0xf44a, 0xe565, 0xeca3, 0xeda8, 0xf731, 0xf5b8, 0xff16,
0xefdb, 0xf6c8, 0xe69f, 0xecdb, 0xe397, 0xeb99, 0xf0f9, 0xfb7b, 0xfcfd, 0x0588,
0xf6e4, 0xfbb7, 0xeed9, 0xf524, 0xedb3, 0xf590, 0xebfe, 0xf2cf, 0xe7b9, 0xedec,
0xe349, 0xe930, 0xe9db, 0xf111, 0xf230, 0xfa79, 0xed85, 0xf5ae, 0xe90c, 0xf004,
0xea42, 0xec69, 0xe56f, 0xe9e0, 0xdf4b, 0xe93a, 0xdf72, 0xe7a1, 0xe3fd, 0xea4f,
0xe60c, 0xec5a, 0xe72a, 0xee69, 0xe81d, 0xeeb7, 0xe409, 0xe99e, 0xe454, 0xe89d,
0xe775, 0xec61, 0xe8d4, 0xef0c, 0xe973, 0xee8f, 0xe804, 0xeab4, 0xe755, 0xe5bd,
0xe18b, 0xe22c, 0xdced, 0xe3e1, 0xe161, 0xe95d, 0xe86f, 0xed24, 0xe3b8, 0xe7d4,
0xdcf9, 0xe0e5, 0xdf36, 0xe343, 0xe09a, 0xe4f8, 0xdea1, 0xe208, 0xe138, 0xe6c1,
0xe341, 0xe8c3, 0xde58, 0xdf7c, 0xd582, 0xdbb8, 0xd47f, 0xe062, 0xdb65, 0xe4e5,
0xdac5, 0xe046, 0xd4e6, 0xd9d8, 0xda1e, 0xdf51, 0xdc41, 0xe144, 0xd8e2, 0xdd8b,
0xd9d7, 0xdfa9, 0xd78f, 0xdc13, 0xdaf8, 0xde06, 0xd93d, 0xe020, 0xcc41, 0xd37c,
0xd5f7, 0xda35, 0xeb22, 0xed1e, 0xeb65, 0xea01, 0xe768, 0xe519, 0xdfc9, 0xe220,
0xd743, 0xdbb9, 0xd6df, 0xdc87, 0xd845, 0xde49, 0xd688, 0xdc9e, 0xd1b5, 0xd847,
0xc8b0, 0xd2e0, 0xcaa3, 0xd867, 0xd766, 0xdf06, 0xdb11, 0xdcf7, 0xde29, 0xe0ba,
0xdcaf, 0xdff8, 0xd9d3, 0xda3d, 0xd449, 0xd70a, 0xcfdf, 0xd611, 0xd408, 0xda08,
0xdbaf, 0xe220, 0xd924, 0xdf55, 0xd371, 0xd8a6, 0xd0a6, 0xd610, 0xc899, 0xce56,
0xcb48, 0xce96, 0xdd87, 0xdeb6, 0xd54c, 0xdcbc, 0xcb24, 0xd752, 0xd9b9, 0xdbf0,
0xdd64, 0xdb69, 0xd1ed, 0xd5f6, 0xccfd, 0xd3d9, 0xce57, 0xd4af, 0xcf5f, 0xd5b4,
0xcf8f, 0xd5cd, 0xcdca, 0xd39a, 0xcabc, 0xd0c7, 0xc8d5, 0xcf0b, 0xd1eb, 0xd7a1,
0xd535, 0xdb60, 0xce94, 0xd7a5, 0xd00e, 0xd86a, 0xd803, 0xdac8, 0xd1ca, 0xd325,
0xc8cf, 0xcdc1, 0xcfe5, 0xd54a, 0xd4e2, 0xda42, 0xd244, 0xd6de, 0xccce, 0xd1ee,
0xcb0b, 0xd1ad, 0xd5ff, 0xd408, 0xd963, 0xd7f7, 0xcfc9, 0xd972, 0xc98a, 0xd585,
0xc7dc, 0xceb8, 0xcae7, 0xccf7, 0xcd77, 0xd204, 0xcb7c, 0xd16f, 0xca50, 0xcf52,
0xcc0a, 0xd01e, 0xcb01, 0xced7, 0xcd56, 0xd06b, 0xcf6a, 0xd4ba, 0xcd5c, 0xd306,
0xc9ec, 0xcdfe, 0xc3ee, 0xcb9c, 0xd02d, 0xd3ea, 0xd449, 0xd6f9, 0xd248, 0xd58e,
0xd36e, 0xd6ad, 0xd27d, 0xd436, 0xcd29, 0xceb2, 0xcf8b, 0xd25d, 0xd137, 0xd3f9,
0xd148, 0xd3eb, 0xd468, 0xd71f, 0xd39e, 0xd734, 0xd1e2, 0xd36f, 0xcf55, 0xd011,
0xc9d9, 0xcae6, 0xc5c2, 0xca01, 0xd394, 0xd6e8, 0xdd95, 0xdb21, 0xd6d9, 0xd646,
0xd2ae, 0xd4b3, 0xd22d, 0xd263, 0xcf9b, 0xcf66, 0xce0e, 0xcd3f, 0xd1a4, 0xd0d4,
0xdc45, 0xd90a, 0xdcf6, 0xdb7d, 0xceb0, 0xd46d, 0xc867, 0xcd19, 0xd52e, 0xcf5c,
0xd8e2, 0xd270, 0xd22d, 0xd498, 0xd327, 0xd609, 0xd715, 0xd3a8, 0xd5e2, 0xd2f9,
0xd7e1, 0xd6b6, 0xd700, 0xd52b, 0xd856, 0xd5cc, 0xdab1, 0xd8f9, 0xd4f2, 0xd69c,
0xdc3f, 0xd948, 0xecad, 0xe2a8, 0xf310, 0xea88, 0xee1d, 0xe5bf, 0xe3fd, 0xdd80,
0xd628, 0xd3b3, 0xd1b9, 0xd025, 0xd71a, 0xd51e, 0xdb7c, 0xd73e, 0xdc2d, 0xd79a,
0xdd2a, 0xd841, 0xe015, 0xd9ee, 0xddb3, 0xd6e9, 0xdc08, 0xd773, 0xe10e, 0xe03e,
0xe23b, 0xe0b5, 0xe627, 0xe3fa, 0xe5b6, 0xdfe8, 0xda9c, 0xd5ff, 0xdbaa, 0xd70a,
0xe514, 0xde42, 0xe2b2, 0xdba9, 0xdd85, 0xd662, 0xdbd3, 0xd575, 0xe231, 0xdaea,
0xec43, 0xe317, 0xe424, 0xdf40, 0xdb51, 0xd927, 0xe520, 0xdef6, 0xe86e, 0xe212,
0xe1af, 0xdb65, 0xda54, 0xd431, 0xd9d7, 0xd3c1, 0xe33b, 0xdb7b, 0xe9f8, 0xe2cc,
0xeac1, 0xe41d, 0xe83f, 0xe152, 0xe690, 0xdefc, 0xe457, 0xdbad, 0xe175, 0xdd5f,
0xe69e, 0xe09c, 0xea2c, 0xddec, 0xe5ca, 0xe1d6, 0xebe9, 0xe888, 0xe791, 0xde4e,
0xe1fd, 0xdb34, 0xeaef, 0xe3e9, 0xef10, 0xe686, 0xeadd, 0xe209, 0xe98e, 0xe0d4,
0xeba6, 0xe42f, 0xeda9, 0xe46c, 0xef0b, 0xe30e, 0xeb05, 0xe489, 0xe878, 0xe523,
0xecb3, 0xe3c8, 0xf270, 0xe690, 0xece0, 0xe2df, 0xe659, 0xe14f, 0xecf1, 0xe5cb,
0xf295, 0xe86e, 0xed88, 0xe35d, 0xed39, 0xe2e4, 0xf07a, 0xe78d, 0xedd9, 0xe4f6,
0xf06c, 0xe634, 0xf47d, 0xe936, 0xf6e3, 0xead7, 0xfad2, 0xed5c, 0xf923, 0xea38,
0xefa6, 0xe39d, 0xe730, 0xe147, 0xec5d, 0xe39e, 0xf333, 0xe8e9, 0xf3bb, 0xe9b7,
0xf5f8, 0xec06, 0xfa08, 0xf0e5, 0xf755, 0xedb8, 0xf62b, 0xeada, 0xf696, 0xe9ed,
0xf44d, 0xeaee, 0xf360, 0xeaee, 0xf6ef, 0xec3b, 0xff38, 0xf127, 0x031c, 0xf1bc,
0xffcd, 0xf216, 0xfe3d, 0xf4b2, 0xff35, 0xf49c, 0xfb16, 0xef57, 0xfa16, 0xee81,
0xfbe1, 0xf046, 0x0180, 0xf590, 0x0351, 0xf88a, 0xfcb8, 0xf448, 0xfe41, 0xf3b8,
0x03d3, 0xf31e, 0x020d, 0xf29a, 0xffe5, 0xf132, 0xf805, 0xecc2, 0x00a7, 0xf527,
0x08cd, 0xfd61, 0x04c8, 0xf925, 0x04d9, 0xf945, 0x0bd0, 0xffa1, 0x094d, 0xfc88,
0x0adf, 0xfc43, 0x0d6c, 0xfe08, 0xfca4, 0xf396, 0xf860, 0xf1aa, 0x097f, 0xfc89,
0x127b, 0x015a, 0x0caf, 0xfff9, 0x0985, 0xff34, 0x0c89, 0xffa3, 0x0a51, 0xfcfa,
0x09df, 0xfd2c, 0x0c82, 0x0095, 0x0ca5, 0xffea, 0x0cfd, 0xfe20, 0x0b9b, 0xfdda,
0x01f8, 0xfd33, 0x067c, 0x01e1, 0x197f, 0x08a8, 0x1829, 0x04fe, 0x0a2e, 0xfd96,
0x06f2, 0xfe95, 0x0d45, 0x0202, 0x0c78, 0xfeb5, 0x0a17, 0xfd1b, 0x0d28, 0x00db,
0x1156, 0x057f, 0x11c7, 0x071a, 0x0ec9, 0x0262, 0x0fa2, 0xff54, 0x0e33, 0x03cc,
0x0839, 0x0537, 0x0efe, 0x05af, 0x14c2, 0x0613, 0x1193, 0x0628, 0x0df2, 0x042b,
0x113d, 0x0637, 0x1415, 0x0a4c, 0x148f, 0x0af4, 0x13e5, 0x0a8e, 0x1169, 0x0923,
0x0edb, 0x0772, 0x118c, 0x0b43, 0x1a72, 0x10ed, 0x19b1, 0x0df6, 0x0da9, 0x085e,
0x0eec, 0x0678, 0x1a6d, 0x0b28, 0x164e, 0x0c92, 0x1161, 0x0ac4, 0x1128, 0x07ae,
0x1280, 0x095d, 0x179b, 0x0f0d, 0x16c6, 0x1125, 0x1541, 0x0e5e, 0x1903, 0x0eaf,
0x1aec, 0x137d, 0x20b8, 0x15fd, 0x177a, 0x0a2f, 0x0909, 0x060a, 0x12b1, 0x1143,
0x1c88, 0x132e, 0x1c1b, 0x1369, 0x19fa, 0x13d9, 0x18be, 0x11f0, 0x1971, 0x131b,
0x1eeb, 0x1699, 0x20c3, 0x18f4, 0x1b16, 0x14e9, 0x1504, 0x10c5, 0x18fe, 0x1470,
0x22d9, 0x1a33, 0x22fb, 0x19ea, 0x18b1, 0x14ab, 0x182d, 0x1443, 0x1a29, 0x1588,
0x1fac, 0x1be2, 0x21cf, 0x1dc5, 0x2073, 0x1ba4, 0x1c40, 0x1755, 0x18c5, 0x13e9,
0x239c, 0x1cb8, 0x2c0a, 0x227e, 0x23e4, 0x1bbf, 0x1e28, 0x1bea, 0x1831, 0x161b,
0x188c, 0x1546, 0x268a, 0x21f3, 0x2402, 0x1f54, 0x1c70, 0x1884, 0x2016, 0x1b95,
0x2396, 0x1fb5, 0x264e, 0x22b4, 0x2428, 0x206b, 0x240f, 0x20c5, 0x27db, 0x21af,
0x1dbf, 0x1a65, 0x1a35, 0x1cbe, 0x28bd, 0x228d, 0x2106, 0x1c6c, 0x1e87, 0x23c2,
0x2d39, 0x2bdf, 0x3335, 0x2db6, 0x2f78, 0x2c4e, 0x2a88, 0x2766, 0x2ac6, 0x27bd,
0x2d34, 0x2907, 0x2bd1, 0x288e, 0x28ed, 0x2a73, 0x26ae, 0x26dc, 0x22f5, 0x21d0,
0x2d6e, 0x2e6e, 0x3288, 0x3330, 0x2cf0, 0x2da1, 0x2e65, 0x2d62, 0x32df, 0x2f98,
0x2e6a, 0x2cae, 0x2b66, 0x29ff, 0x2c0e, 0x2b5b, 0x2ce6, 0x2cf7, 0x2c01, 0x2b29,
0x291a, 0x28d5, 0x2477, 0x2631, 0x2e39, 0x2b2b, 0x3b29, 0x30b1, 0x3430, 0x2f25,
0x2c64, 0x328d, 0x2f94, 0x3397, 0x2fc2, 0x2efb, 0x2e6e, 0x2cfa, 0x31be, 0x315b,
0x315c, 0x3108, 0x2ea6, 0x2db0, 0x2ed3, 0x2c9a, 0x2f37, 0x2d23, 0x2d35, 0x2fd4,
0x3022, 0x3292, 0x3332, 0x3188, 0x2c72, 0x2cd5, 0x2748, 0x2b9e, 0x2c71, 0x2dfa,
0x3164, 0x31ec, 0x2f42, 0x302a, 0x2d5d, 0x2fd4, 0x2eb0, 0x30c3, 0x2cd6, 0x2ed2,
0x2ffb, 0x3191, 0x32d4, 0x3503, 0x2c0f, 0x333f, 0x2c12, 0x2fd3, 0x3af5, 0x3272,
0x3958, 0x336a, 0x299a, 0x3089, 0x2742, 0x3082, 0x2d55, 0x2f04, 0x2f1e, 0x2ec1,
0x2f8b, 0x30f7, 0x3143, 0x3409, 0x312a, 0x3488, 0x2fd2, 0x329f, 0x2e76, 0x31a3,
0x319d, 0x32c8, 0x3020, 0x32e7, 0x2b9e, 0x3845, 0x3130, 0x3b7c, 0x3611, 0x3506,
0x2e94, 0x3151, 0x2a11, 0x31fb, 0x31be, 0x32ce, 0x313c, 0x326c, 0x3012, 0x3379,
0x3106, 0x33f7, 0x30c5, 0x3357, 0x317b, 0x33c4, 0x3181, 0x35a1, 0x35b8, 0x382a,
0x36f0, 0x35ca, 0x30f9, 0x32df, 0x2e08, 0x35e3, 0x2b97, 0x3087, 0x2566, 0x27ca,
0x2a23, 0x2d42, 0x30a3, 0x32ca, 0x310a, 0x329b, 0x32ff, 0x351a, 0x3384, 0x358e,
0x2fc1, 0x30da, 0x3035, 0x2e5c, 0x34a8, 0x30c1, 0x35d8, 0x375d, 0x305c, 0x3814,
0x2b05, 0x32f7, 0x2e4a, 0x3778, 0x325d, 0x3415, 0x2fe3, 0x2ece, 0x32c3, 0x3441,
0x32f7, 0x34d4, 0x31ec, 0x33d9, 0x320a, 0x3388, 0x2eea, 0x2f7c, 0x2f50, 0x2e55,
0x2d76, 0x2fec, 0x28af, 0x2dcc, 0x2ba9, 0x2d6b, 0x333f, 0x2f37, 0x37b0, 0x327f,
0x35e7, 0x3648, 0x2f65, 0x3199, 0x2efa, 0x3028, 0x2f6d, 0x2f90, 0x2ce0, 0x2cfa,
0x2de2, 0x2e27, 0x2f94, 0x2f72, 0x2f4f, 0x2e8d, 0x2ea6, 0x2e7a, 0x2bd3, 0x2b4f,
0x31ee, 0x2d12, 0x3578, 0x3042, 0x296a, 0x274d, 0x296c, 0x2807, 0x327f, 0x31a4,
0x30e5, 0x305f, 0x2c72, 0x2b13, 0x2c4c, 0x2af7, 0x2b2e, 0x2a27, 0x2abf, 0x29b6,
0x29b8, 0x29ab, 0x2991, 0x29f2, 0x2eff, 0x2eb4, 0x2e37, 0x2be7, 0x2626, 0x2669,
0x1e5b, 0x247c, 0x2777, 0x22bb, 0x31be, 0x28c7, 0x2b65, 0x2c47, 0x26c5, 0x27e3,
0x2633, 0x25db, 0x251c, 0x24fb, 0x25ea, 0x2601, 0x2675, 0x2708, 0x2718, 0x25e5,
0x23d8, 0x2429, 0x208e, 0x23ea, 0x2454, 0x204f, 0x26e9, 0x1e6e, 0x2513, 0x26a5,
0x25d4, 0x2985, 0x247b, 0x2433, 0x1fa9, 0x202a, 0x20b1, 0x2122, 0x226f, 0x2117,
0x216c, 0x1fb2, 0x2147, 0x1f68, 0x21df, 0x1f14, 0x25fc, 0x21d0, 0x255f, 0x2373,
0x25a9, 0x2750, 0x224d, 0x2225, 0x1b50, 0x171f, 0x1c84, 0x17d8, 0x1f0d, 0x1cd1,
0x1f38, 0x1ada, 0x1d16, 0x1a8e, 0x1dab, 0x1c49, 0x1a3f, 0x1812, 0x19b8, 0x17b5,
0x19c2, 0x197d, 0x13d9, 0x1415, 0x1964, 0x143c, 0x20f1, 0x1ad6, 0x1a79, 0x1fe3,
0x18f7, 0x1d61, 0x1824, 0x1469, 0x1087, 0x0fe7, 0x12bb, 0x1306, 0x16a5, 0x1576,
0x151c, 0x13d5, 0x15c8, 0x1462, 0x164e, 0x1507, 0x15af, 0x13ed, 0x17f9, 0x1610,
0x13da, 0x11a6, 0x1267, 0x0bcb, 0x15c8, 0x0d93, 0x145d, 0x1374, 0x1770, 0x183b,
0x154d, 0x11d8, 0x10d9, 0x0deb, 0x0d36, 0x0d29, 0x0cd0, 0x0bae, 0x0cc1, 0x0af1,
0x0e14, 0x0c14, 0x0f36, 0x0d67, 0x0d53, 0x0cb4, 0x0c08, 0x076f, 0x11ad, 0x0674,
0x1818, 0x0dc5, 0x11a4, 0x0edf, 0x06d9, 0x0b14, 0x074a, 0x099a, 0x0a93, 0x07c2,
0x0b3e, 0x0744, 0x0a17, 0x0764, 0x091a, 0x0692, 0x092a, 0x06b1, 0x06dc, 0x03e0,
0x05ec, 0x02e3, 0x0615, 0x04d8, 0x055d, 0x007c, 0x084a, 0xfdb1, 0x0b4f, 0x0201,
0x0b8b, 0x0728, 0x07d0, 0x0352, 0xff30, 0xfb8f, 0xfe34, 0xfe81, 0x0137, 0x0039,
0x015f, 0xfeb2, 0x026e, 0xfffb, 0x0390, 0x0154, 0x0257, 0x0096, 0xfffa, 0xfeee,
0xfd32, 0xfa80, 0xfe15, 0xf9f2, 0x006a, 0xfd47, 0xfef8, 0xfd87, 0x0054, 0xfc4f,
0x03b8, 0xfb1b, 0xff11, 0xfb2b, 0xf876, 0xfab5, 0xf93c, 0xf8c5, 0xfa4c, 0xf779,
0xf90a, 0xf62e, 0xf6a7, 0xf35e, 0xf819, 0xf5cd, 0xfea4, 0xfac6, 0xf8f2, 0xf55d,
0xeb3c, 0xef7a, 0xf50c, 0xf917, 0x032f, 0xfc55, 0xf89a, 0xf0d2, 0xed80, 0xecd9,
0xf46c, 0xf482, 0xf7f8, 0xf5f0, 0xf53a, 0xf417, 0xf4ee, 0xf428, 0xf1ed, 0xf0f9,
0xf2b0, 0xf165, 0xf252, 0xf415, 0xf27b, 0xf3fa, 0xf5ec, 0xeff3, 0xed3f, 0xedea,
0xe410, 0xed18, 0xf137, 0xef29, 0xf468, 0xedee, 0xe6de, 0xe782, 0xeadd, 0xec02,
0xec94, 0xec9e, 0xe997, 0xe97e, 0xe8e9, 0xe8d3, 0xe907, 0xe912, 0xea8a, 0xe845,
0xe462, 0xe50d, 0xe487, 0xe4af, 0xecfc, 0xe88b, 0xe630, 0xe433, 0xdcfe, 0xde82,
0xe617, 0xe894, 0xe9a6, 0xeb56, 0xe267, 0xe43b, 0xe06e, 0xe1a0, 0xe3ea, 0xe5fc,
0xe4bb, 0xe6f5, 0xe0c1, 0xe31e, 0xe1a3, 0xe499, 0xe40d, 0xe661, 0xdea1, 0xe1c3,
0xda6a, 0xde12, 0xe13e, 0xe18a, 0xe3fa, 0xe105, 0xdc90, 0xd98d, 0xd8ae, 0xdbd5,
0xdca8, 0xe231, 0xdc7a, 0xe193, 0xd983, 0xdddb, 0xd855, 0xdc3e, 0xd5e8, 0xd995,
0xd476, 0xd837, 0xd96c, 0xdc96, 0xd490, 0xdb1f, 0xcbab, 0xd831, 0xd518, 0xdda7,
0xdfd0, 0xdc6a, 0xd17f, 0xd6ec, 0xc8be, 0xd68c, 0xd1a0, 0xd6d9, 0xd4f0, 0xd72d,
0xd35a, 0xd8e1, 0xd2f6, 0xd8d5, 0xd1f7, 0xd7d2, 0xd0f1, 0xd5dd, 0xcf0f, 0xd1e8,
0xd002, 0xd4e4, 0xd36e, 0xdcbb, 0xd48d, 0xdaa0, 0xd8db, 0xd8f2, 0xd62a, 0xda1d,
0xcd0a, 0xd87f, 0xcaab, 0xd4f7, 0xcde8, 0xd3dd, 0xcfdd, 0xd5f0, 0xcf29, 0xd5ef,
0xce1d, 0xd4d7, 0xce4c, 0xd446, 0xd159, 0xd711, 0xd65c, 0xdb72, 0xd427, 0xdbc9,
0xd080, 0xd9a8, 0xd934, 0xdbd7, 0xe000, 0xdd6b, 0xd7b9, 0xdb79, 0xd219, 0xdc30,
0xd281, 0xda63, 0xd1f6, 0xd6f5, 0xd1b9, 0xd798, 0xd225, 0xd7ef, 0xd3b2, 0xd98e,
0xd235, 0xd733, 0xcc25, 0xd3e9, 0xcf1a, 0xda65, 0xd459, 0xde4d, 0xd808, 0xe179,
0xd839, 0xdd42, 0xd14c, 0xd6ea, 0xcc1b, 0xd2ca, 0xcaca, 0xd2ac, 0xce4b, 0xd651,
0xd260, 0xd85a, 0xd22e, 0xd7d0, 0xd1a5, 0xd66e, 0xcfbf, 0xd3ed, 0xcd48, 0xd03b,
0xcb0c, 0xd09c, 0xc863, 0xd23e, 0xd1e9, 0xd534, 0xd764, 0xd663, 0xcd9b, 0xd26e,
0xc859, 0xcda0, 0xcfcb, 0xd241, 0xd228, 0xd59f, 0xcda9, 0xd1ce, 0xcc22, 0xcff2,
0xcdbc, 0xd199, 0xceef, 0xd289, 0xd09e, 0xd282, 0xd1e2, 0xd52f, 0xc999, 0xd639,
0xc443, 0xcf94, 0xcf17, 0xd101, 0xd1f3, 0xd630, 0xcb7f, 0xd2f4, 0xd071, 0xd3f4,
0xd262, 0xd48d, 0xce23, 0xd222, 0xce50, 0xd325, 0xd03c, 0xd564, 0xd04a, 0xd4f6,
0xcf4f, 0xd48f, 0xcd17, 0xd33b, 0xd57b, 0xd776, 0xd98a, 0xd5d1, 0xcd69, 0xce49,
0xc6f6, 0xcf3b, 0xcb9a, 0xd3fa, 0xce83, 0xd59f, 0xce25, 0xd59b, 0xce76, 0xd35b,
0xcc3f, 0xd08c, 0xcaf0, 0xcf44, 0xca11, 0xce4f, 0xcc7b, 0xcf81, 0xcbef, 0xcd8b,
0xccee, 0xd058, 0xcb53, 0xd02f, 0xc609, 0xceba, 0xcd79, 0xd48c, 0xd1af, 0xd08e,
0xcd1d, 0xce8d, 0xccb5, 0xd0df, 0xcd97, 0xd1ba, 0xcf1b, 0xd1eb, 0xcfb2, 0xd327,
0xcf23, 0xd22a, 0xccf4, 0xd122, 0xce62, 0xd30f, 0xd246, 0xd43b, 0xd247, 0xd5ff,
0xd511, 0xd6b2, 0xd881, 0xd1c9, 0xcc62, 0xcb69, 0xc889, 0xd037, 0xd18e, 0xd4d6,
0xd07d, 0xd3ec, 0xcf94, 0xd509, 0xd1b6, 0xd5db, 0xd254, 0xd637, 0xd1d6, 0xd65e,
0xd0d4, 0xd574, 0xd445, 0xd468, 0xd777, 0xd57a, 0xd440, 0xd97f, 0xd16a, 0xd7f3,
0xd616, 0xd402, 0xd2b8, 0xd3fc, 0xce6f, 0xd429, 0xd315, 0xd3ff, 0xd48e, 0xd548,
0xd29d, 0xd478, 0xd316, 0xd4d4, 0xd3b6, 0xd56f, 0xd3aa, 0xd4bc, 0xd31c, 0xd7f9,
0xd7da, 0xdb76, 0xdfc3, 0xdbb7, 0xd4f6, 0xd787, 0xc607, 0xd135, 0xcef7, 0xd54a,
0xd8dc, 0xda4e, 0xd844, 0xd854, 0xd847, 0xd9ad, 0xd9a7, 0xdbac, 0xd76f, 0xd925,
0xd661, 0xd7ed, 0xd46b, 0xd71d, 0xd54c, 0xd9a0, 0xd59e, 0xda73, 0xda56, 0xd946,
0xdfe9, 0xd8db, 0xd78b, 0xda90, 0xceb6, 0xd57c, 0xd36c, 0xd41d, 0xdbd5, 0xda24,
0xdbc8, 0xdc03, 0xda8a, 0xdb70, 0xda96, 0xdb14, 0xdc28, 0xdc79, 0xde16, 0xddd3,
0xde37, 0xdf61, 0xdcaf, 0xe15f, 0xdc41, 0xdd8a, 0xd7a4, 0xd7c3, 0xde30, 0xe21e,
0xea30, 0xe9ea, 0xe532, 0xe278, 0xdcc4, 0xdee7, 0xdeab, 0xdf55, 0xe093, 0xe04c,
0xdf28, 0xe002, 0xe02e, 0xe0f6, 0xe2cc, 0xe421, 0xe22b, 0xe314, 0xdf8d, 0xe19a,
0xe1d0, 0xe58d, 0xe14b, 0xe028, 0xe102, 0xddad, 0xe286, 0xe63e, 0xe483, 0xe3a6,
0xe494, 0xdf25, 0xe37f, 0xe0dc, 0xe400, 0xe325, 0xe538, 0xe34c, 0xe516, 0xe336,
0xe5ac, 0xe3cc, 0xe53f, 0xe4f3, 0xe4c4, 0xe34c, 0xe75c, 0xe28f, 0xeedc, 0xe876,
0xedb1, 0xe787, 0xddfb, 0xdf67, 0xe1e9, 0xe370, 0xede5, 0xe74c, 0xf1e7, 0xea33,
0xedb5, 0xeaa4, 0xec8a, 0xea49, 0xedbb, 0xeab9, 0xeca2, 0xe958, 0xecde, 0xe8b9,
0xf08b, 0xecd9, 0xf401, 0xf0d2, 0xed2d, 0xed80, 0xe067, 0xe5af, 0xe95c, 0xe4e3,
0xf62e, 0xeac7, 0xf0fc, 0xedf2, 0xef02, 0xebf8, 0xf1ec, 0xe9aa, 0xf1be, 0xec00,
0xf17f, 0xebec, 0xf20f, 0xebbd, 0xf27d, 0xec44, 0xf3e0, 0xeb58, 0xf4f7, 0xec1a,
0xf2ae, 0xee6e, 0xefae, 0xf053, 0xf210, 0xeb09, 0xf0ca, 0xe597, 0xeee5, 0xea9f,
0xf11c, 0xee14, 0xf372, 0xeef9, 0xf63f, 0xf01b, 0xf6b9, 0xf0bd, 0xf617, 0xefd2,
0xf583, 0xef4e, 0xf689, 0xf08b, 0xfa65, 0xf3b4, 0xfd2c, 0xf29b, 0xf961, 0xefb7,
0xf86c, 0xf203, 0xfaab, 0xf29f, 0xf74e, 0xf16b, 0xf5a8, 0xf22d, 0xf96c, 0xf46b,
0xfa8a, 0xf3e8, 0xfa5d, 0xf3dc, 0xfb56, 0xf57d, 0xfbb4, 0xf64e, 0xfc14, 0xf5c9,
0xfb98, 0xf55f, 0xfd19, 0xf6f5, 0x02ba, 0xfb34, 0x007b, 0xf7ac, 0xf1cf, 0xed21,
0xf011, 0xf154, 0xfcba, 0xf86d, 0xfed6, 0xf9af, 0xfda7, 0xf84a, 0xfcb1, 0xf6d1,
0xfd0c, 0xf774, 0xfe7d, 0xf91b, 0x0027, 0xfa8c, 0x0139, 0xf9e5, 0xfd6a, 0xf7cd,
0xfb59, 0xf77a, 0x08e8, 0x006c, 0x0dec, 0x030e, 0xfd0b, 0xfe5f, 0xf84f, 0x00bb,
0x0064, 0xfff8, 0x010b, 0xfadf, 0x01c4, 0xfcbb, 0x020c, 0xfe14, 0x019c, 0xfd5a,
0x0147, 0xfd45, 0x020b, 0xffb9, 0x073b, 0x02cf, 0x0715, 0x00bd, 0xffdb, 0x01ab,
0x03c6, 0x0395, 0x05c6, 0xfb0d, 0xfe51, 0xf7b1, 0x00ee, 0xffb8, 0x0b64, 0x0495,
0x0afb, 0x043b, 0x08e6, 0x040b, 0x0850, 0x0384, 0x07ea, 0x0383, 0x0925, 0x04d3,
0x09b4, 0x05c8, 0x0873, 0x062e, 0x0bb5, 0x0632, 0x1011, 0x06d1, 0x0a39, 0x0387,
0x0c9c, 0x034f, 0x1084, 0x079c, 0x0bf9, 0x08ec, 0x0db3, 0x0b7f, 0x137d, 0x0eb4,
0x1620, 0x1144, 0x1486, 0x0fa8, 0x124b, 0x0e1b, 0x1656, 0x1057, 0x1678, 0x0dc5,
0x1008, 0x0b8e, 0x1743, 0x0ff4, 0x1c4f, 0x12e1, 0x138b, 0x0f88, 0x0f1a, 0x106f,
0x15d4, 0x143d, 0x1811, 0x1079, 0x178c, 0x1006, 0x1720, 0x0fec, 0x17c1, 0x10dd,
0x1938, 0x12ae, 0x172c, 0x1238, 0x16fd, 0x12d1, 0x1bfb, 0x1681, 0x1d1d, 0x1320,
0x1d88, 0x102c, 0x1b60, 0x119f, 0x126b, 0x0eeb, 0x1864, 0x130d, 0x1d73, 0x16d8,
0x192e, 0x147d, 0x1860, 0x12c0, 0x1969, 0x136e, 0x1b0b, 0x1544, 0x1b0e, 0x1508,
0x18c8, 0x13fa, 0x1bee, 0x1447, 0x17bc, 0x1183, 0x1187, 0x1144, 0x186b, 0x15e1,
0x1dea, 0x1882, 0x1e9d, 0x15cc, 0x1d94, 0x1567, 0x1c65, 0x14ba, 0x1bba, 0x146f,
0x1caa, 0x15d8, 0x1c3f, 0x15b9, 0x1d3b, 0x1710, 0x1e17, 0x18af, 0x1f29, 0x1972,
0x1d71, 0x16b5, 0x1a04, 0x1726, 0x1a30, 0x1822, 0x2376, 0x1a7e, 0x242f, 0x1998,
0x1d5a, 0x18a3, 0x1cd3, 0x1a03, 0x20aa, 0x1bfc, 0x20ce, 0x1c7c, 0x2062, 0x1bcd,
0x2086, 0x1c66, 0x22ba, 0x1e76, 0x1efd, 0x1a01, 0x18e4, 0x1611, 0x251e, 0x1ef7,
0x27f3, 0x2470, 0x1c7e, 0x1db4, 0x1b82, 0x160d, 0x21fd, 0x1bcb, 0x207a, 0x1d7d,
0x1d11, 0x1a32, 0x1e9f, 0x1b4f, 0x1fd0, 0x1ca7, 0x211e, 0x1e0f, 0x21f0, 0x1e5f,
0x2549, 0x201a, 0x210e, 0x220c, 0x1bc7, 0x233e, 0x2079, 0x1e14, 0x263c, 0x199f,
0x2281, 0x1c99, 0x24a0, 0x215f, 0x289b, 0x215c, 0x2552, 0x213f, 0x25c3, 0x2298,
0x26ea, 0x23f9, 0x2610, 0x22db, 0x25ae, 0x23a3, 0x255f, 0x2610, 0x282a, 0x2253,
0x24a4, 0x1e5a, 0x1c0a, 0x1f49, 0x282a, 0x2686, 0x2d86, 0x2445, 0x2481, 0x202b,
0x20bf, 0x1fad, 0x225b, 0x1df4, 0x2428, 0x2043, 0x254d, 0x21d0, 0x24e9, 0x216d,
0x257c, 0x2136, 0x2529, 0x1f76, 0x23f6, 0x20ae, 0x2742, 0x22e9, 0x284d, 0x22e7,
0x221e, 0x2807, 0x215c, 0x22ff, 0x240e, 0x1d28, 0x2490, 0x1ec7, 0x277f, 0x23cc,
0x286b, 0x258d, 0x29b5, 0x2673, 0x2c98, 0x28fc, 0x3128, 0x2d35, 0x3350, 0x2e14,
0x3281, 0x2f2f, 0x2c67, 0x2fa9, 0x2e4d, 0x3074, 0x30fc, 0x2ed0, 0x3445, 0x2bd5,
0x387c, 0x32cf, 0x33c1, 0x2eb8, 0x2fba, 0x2973, 0x2fb8, 0x2ce4, 0x3118, 0x2e7e,
0x310b, 0x2e10, 0x2f6f, 0x2c70, 0x2f43, 0x2c40, 0x3173, 0x2ced, 0x2f9c, 0x2a39,
0x2d72, 0x2b60, 0x30e7, 0x2e7f, 0x2d4b, 0x2b3b, 0x2b82, 0x27bc, 0x32a7, 0x2b1b,
0x30f4, 0x2aa2, 0x2e97, 0x2a7e, 0x304f, 0x2bfd, 0x2f41, 0x2abe, 0x30a0, 0x2be3,
0x301e, 0x2ce9, 0x3111, 0x2e77, 0x3404, 0x2c7b, 0x2d3a, 0x28a5, 0x2b20, 0x2c87,
0x373e, 0x31e6, 0x3669, 0x2c14, 0x2b99, 0x29aa, 0x2dd3, 0x2d65, 0x317d, 0x2c8e,
0x2f7c, 0x2c39, 0x3007, 0x2d2a, 0x3007, 0x2d69, 0x2fac, 0x2d0f, 0x2da8, 0x2d0a,
0x2d38, 0x2b10, 0x35ff, 0x2c5e, 0x3144, 0x2e4f, 0x28f7, 0x2f17, 0x2c07, 0x2b8a,
0x2d12, 0x2a84, 0x2cbc, 0x2dd0, 0x2d2a, 0x2cc5, 0x2eba, 0x2caf, 0x2e36, 0x2ca9,
0x2e89, 0x2dac, 0x2e07, 0x2d1c, 0x2de2, 0x2d4d, 0x2f32, 0x2e85, 0x31b0, 0x3073,
0x2f78, 0x2d8a, 0x27a2, 0x27b8, 0x2ae0, 0x2809, 0x3521, 0x2dc1, 0x3138, 0x3107,
0x2acd, 0x2f0d, 0x2d3c, 0x2c57, 0x2de2, 0x2ccd, 0x2d8e, 0x2cb9, 0x2e02, 0x2d55,
0x2e67, 0x2e91, 0x2b9c, 0x2cf6, 0x2a0c, 0x2b5e, 0x2a4e, 0x29c8, 0x2b84, 0x2a4b,
0x2d65, 0x2ae7, 0x2c11, 0x29a4, 0x2669, 0x2920, 0x26a8, 0x2a51, 0x275a, 0x2873,
0x2761, 0x27ee, 0x278d, 0x287f, 0x2755, 0x2879, 0x27ba, 0x2875, 0x2751, 0x27d3,
0x2700, 0x2749, 0x277d, 0x25ef, 0x2888, 0x26a8, 0x288a, 0x28fe, 0x29fa, 0x2bee,
0x2966, 0x2d56, 0x2777, 0x2be9, 0x2790, 0x28b0, 0x27dc, 0x277a, 0x27c1, 0x286d,
0x27be, 0x2948, 0x275c, 0x2945, 0x2671, 0x284b, 0x26de, 0x291b, 0x2686, 0x28cf,
0x2523, 0x27f7, 0x260d, 0x2505, 0x24ea, 0x2365, 0x20b0, 0x27f4, 0x248a, 0x2940,
0x26d9, 0x270f, 0x2362, 0x2625, 0x2341, 0x2604, 0x22e9, 0x254c, 0x22af, 0x252f,
0x22e2, 0x2556, 0x2188, 0x23e6, 0x2015, 0x21c9, 0x1d9f, 0x24c3, 0x219b, 0x28d1,
0x274e, 0x22e2, 0x22f3, 0x22d5, 0x1c88, 0x286d, 0x1e50, 0x23a5, 0x2223, 0x20c7,
0x20a5, 0x21c1, 0x20c2, 0x2340, 0x2084, 0x230d, 0x1f82, 0x21d0, 0x1dff, 0x220e,
0x1b0b, 0x2152, 0x2100, 0x1fc8, 0x238d, 0x2272, 0x1c1b, 0x2136, 0x1aaa, 0x1f2a,
0x1f58, 0x1ea8, 0x1c36, 0x2025, 0x1a40, 0x206c, 0x1b52, 0x1f9d, 0x1c51, 0x2140,
0x1b87, 0x20a7, 0x18cf, 0x1e13, 0x18a6, 0x1e7d, 0x1920, 0x20a2, 0x1820, 0x1e3e,
0x1797, 0x1a31, 0x1a03, 0x1bfc, 0x1646, 0x1f42, 0x11a7, 0x1d73, 0x1551, 0x1cc2,
0x1a25, 0x1f1a, 0x17e3, 0x1cd6, 0x1522, 0x1b4c, 0x14ea, 0x1b85, 0x139c, 0x1a0c,
0x1470, 0x1a12, 0x136e, 0x18d1, 0x131b, 0x1ade, 0x154e, 0x1d0f, 0x12d1, 0x18b8,
0x0f09, 0x15d4, 0x11e2, 0x1919, 0x12a3, 0x19a6, 0x1106, 0x18f3, 0x124a, 0x193e,
0x10fa, 0x170f, 0x1007, 0x170c, 0x0fad, 0x16a8, 0x0f4c, 0x16df, 0x0e93, 0x163a,
0x0b24, 0x1609, 0x0ed6, 0x17b2, 0x0d02, 0x1688, 0x00be, 0x14cd, 0x0599, 0x1127,
0x106e, 0x119b, 0x08ff, 0x118f, 0x040d, 0x0ec3, 0x0817, 0x1022, 0x07a7, 0x102f,
0x075c, 0x0fde, 0x06dc, 0x0fdb, 0x076e, 0x0fa3, 0x072e, 0x0dd6, 0x01d6, 0x094c,
0x02e3, 0x0a75, 0x071b, 0x100d, 0x03f7, 0x0c6a, 0x02aa, 0x08ec, 0x0536, 0x0d52,
0x01dc, 0x0d41, 0x01bf, 0x0b98, 0x02db, 0x0ba3, 0x01ab, 0x0aa5, 0x016d, 0x0a5e,
0x00f2, 0x09c5, 0x0083, 0x08de, 0xfdf3, 0x0a0d, 0xffd3, 0x08f5, 0x0307, 0x0727,
0xff04, 0x0d46, 0xfe8f, 0x0d54, 0x0135, 0x0675, 0xff8b, 0x06c0, 0xfc77, 0x07fd,
0xfca5, 0x06e7, 0xfbce, 0x05c4, 0xfb58, 0x0580, 0xf8c0, 0x0418, 0xf88f, 0x02b8,
0xfcd9, 0x0251, 0xface, 0x06e7, 0xf6db, 0x0447, 0xf778, 0xfc92, 0xf623, 0xfbfa,
0xf470, 0x0059, 0xf91a, 0x0233, 0xfa5f, 0x0217, 0xf87c, 0x0253, 0xf814, 0x019c,
0xf7fc, 0x0149, 0xf780, 0x00d1, 0xf639, 0x01ac, 0xf5b2, 0x013a, 0xf73e, 0xfd5a,
0xf3f6, 0xfcc6, 0xf133, 0x0217, 0xf8a6, 0x02ec, 0xfa02, 0xff1a, 0xef5d, 0xfe10,
0xee8e, 0xfde0, 0xf2c2, 0xfcbf, 0xf1a2, 0xfc4c, 0xf02c, 0xfae5, 0xef68, 0xf9ae,
0xf194, 0xfaac, 0xf100, 0xfaf5, 0xec78, 0xfa57, 0xeee4, 0xf761, 0xf2e7, 0xf62c,
0xefdc, 0xf9dc, 0xea47, 0xf7ed, 0xee6e, 0xf74d, 0xf348, 0xf954, 0xf011, 0xf842,
0xee18, 0xf6c7, 0xed68, 0xf62f, 0xed49, 0xf636, 0xed43, 0xf616, 0xeb2d, 0xf4ed,
0xe95e, 0xf627, 0xe775, 0xf56e, 0xebca, 0xf424, 0xf463, 0xf4b4, 0xe8f4, 0xf527,
0xe208, 0xf0a4, 0xe835, 0xee67, 0xe722, 0xf080, 0xe55f, 0xefb6, 0xe5b3, 0xef2e,
0xe56e, 0xeec6, 0xe499, 0xedca, 0xe27f, 0xedda, 0xe581, 0xee8b, 0xea5e, 0xf015,
0xe22e, 0xee58, 0xdb71, 0xea4e, 0xe4fd, 0xeb04, 0xe507, 0xee03, 0xdd08, 0xeb53,
0xde71, 0xe7a1, 0xe08e, 0xe8b5, 0xdfdd, 0xe8e2, 0xdfbb, 0xe8c5, 0xdfd9, 0xe8e2,
0xdec1, 0xe796, 0xdb1e, 0xe633, 0xdd50, 0xe750, 0xe1aa, 0xe7ee, 0xd93f, 0xe64b,
0xd25f, 0xe2c7, 0xdec7, 0xe4f3, 0xe21c, 0xe855, 0xd7a1, 0xe4e8, 0xd780, 0xe2b4,
0xd970, 0xe2de, 0xd8af, 0xe2e1, 0xd86c, 0xe263, 0xd85a, 0xe22b, 0xd948, 0xe1ea,
0xd5dd, 0xe0eb, 0xd333, 0xdeac, 0xda15, 0xe02e, 0xdb42, 0xe2c6, 0xd3b1, 0xde16,
0xd34b, 0xdd7e, 0xd65f, 0xe07a, 0xd5e1, 0xdff2, 0xd5d2, 0xdf32, 0xd5b7, 0xdebb,
0xd4f2, 0xde1c, 0xd4cc, 0xde08, 0xd35e, 0xdcb7, 0xd81e, 0xdd12, 0xd841, 0xdeb5,
0xcffc, 0xde18, 0xd16a, 0xdf0b, 0xd621, 0xdc12, 0xd28b, 0xd6fd, 0xd217, 0xd9fd,
0xd40c, 0xdb85, 0xd304, 0xda23, 0xd246, 0xd962, 0xd2c1, 0xd994, 0xd49d, 0xdaed,
0xd740, 0xdd24, 0xd925, 0xdf9a, 0xda82, 0xe130, 0xde7c, 0xe310, 0xdec4, 0xe225,
0xda65, 0xe27c, 0xdf79, 0xe731, 0xdfe7, 0xe3b1, 0xdaa2, 0xdf77, 0xdc34, 0xe199,
0xdd9c, 0xe2b3, 0xdc8e, 0xe214, 0xdc2e, 0xe18d, 0xdb73, 0xe10b, 0xdbbd, 0xe17b,
0xdabf, 0xe030, 0xd8db, 0xdef9, 0xda51, 0xe038, 0xd9f7, 0xdab3, 0xd53c, 0xd800,
0xd74f, 0xde3c, 0xd9de, 0xdf68, 0xd9e4, 0xdccc, 0xdb01, 0xdce4, 0xda22, 0xdc46,
0xdab8, 0xdc1b, 0xd9d7, 0xdb80, 0xdb7a, 0xdbb4, 0xdc1c, 0xdaeb, 0xd9be, 0xdbc1,
0xdbf9, 0xdd48, 0xdca5, 0xdeba, 0xd686, 0xda2c, 0xd598, 0xd70e, 0xde00, 0xdc13,
0xdddb, 0xdad6, 0xdb26, 0xda14, 0xdacc, 0xda1f, 0xda79, 0xd961, 0xd9aa, 0xd8d8,
0xda40, 0xd800, 0xdc1d, 0xd831, 0xd917, 0xd965, 0xd2cc, 0xd872, 0xdb04, 0xd989,
0xe158, 0xdadc, 0xdc69, 0xd8fd, 0xd79a, 0xd729, 0xd92f, 0xd7b7, 0xda6a, 0xd875,
0xd9f5, 0xd7ee, 0xda19, 0xd81e, 0xda6e, 0xd7d3, 0xdab0, 0xd7f7, 0xda92, 0xd81e,
0xdc80, 0xd86f, 0xdc66, 0xd8a9, 0xdf34, 0xdb46, 0xdc48, 0xd8d3, 0xd64f, 0xd482,
0xd962, 0xd674, 0xdf11, 0xd806, 0xdea2, 0xd740, 0xdd07, 0xd7a4, 0xdda7, 0xd7c1,
0xdd42, 0xd77a, 0xdcc9, 0xd6ff, 0xdbd0, 0xd6cc, 0xdd92, 0xd758, 0xdd86, 0xd5ad,
0xda75, 0xd5f7, 0xda48, 0xd7fd, 0xdde0, 0xd712, 0xdd89, 0xd4f5, 0xdcbd, 0xd5ff,
0xded5, 0xd853, 0xdf65, 0xd7a7, 0xdf04, 0xd77b, 0xdf4f, 0xd7ac, 0xdf5e, 0xd819,
0xe043, 0xd852, 0xe06c, 0xd829, 0xe16e, 0xd777, 0xe2ba, 0xd6a6, 0xe1a7, 0xd75e,
0xdce1, 0xdb19, 0xd9b7, 0xdb65, 0xdf63, 0xd6c7, 0xe100, 0xd5e7, 0xdf27, 0xd6e4,
0xe051, 0xd7e4, 0xe042, 0xd735, 0xe08f, 0xd762, 0xe06c, 0xd74e, 0xe060, 0xd6ba,
0xdfe7, 0xd64b, 0xddea, 0xd8b3, 0xdf7f, 0xd609, 0xe368, 0xd356, 0xdfd7, 0xd6ed,
0xdfd9, 0xd7fd, 0xe1ed, 0xd7a8, 0xe01c, 0xd77b, 0xe1d8, 0xd7ff, 0xe2d5, 0xd86b,
0xe354, 0xd8c7, 0xe31c, 0xd8c6, 0xe2db, 0xd8d7, 0xe439, 0xd8c4, 0xe7cb, 0xdd6e,
0xe600, 0xde34, 0xe3c8, 0xd796, 0xe7d9, 0xd875, 0xe70f, 0xdb4f, 0xe436, 0xdaae,
0xe470, 0xdaf5, 0xe536, 0xdb31, 0xe4b1, 0xdb25, 0xe4f6, 0xdb8e, 0xe595, 0xdbeb,
0xe6a9, 0xdca3, 0xe6df, 0xdbb4, 0xe57b, 0xda62, 0xe408, 0xdd2c, 0xe814, 0xde38,
0xed69, 0xdd25, 0xeb16, 0xdd1f, 0xe6af, 0xdd62, 0xe5fa, 0xdd42, 0xe848, 0xddb4,
0xe88b, 0xddc6, 0xe897, 0xddea, 0xe8ed, 0xde80, 0xe935, 0xde70, 0xe9e9, 0xdf4e,
0xeab6, 0xdf26, 0xeccd, 0xdf97, 0xe74a, 0xdd15, 0xdf20, 0xdd67, 0xe557, 0xe1e7,
0xee1d, 0xe1da, 0xed5c, 0xdeee, 0xeade, 0xdff2, 0xec32, 0xe127, 0xec56, 0xe100,
0xecfe, 0xe1d5, 0xedf8, 0xe320, 0xef8a, 0xe3e5, 0xf0fb, 0xe175, 0xedbc, 0xdfb4,
0xec6e, 0xe38b, 0xeee3, 0xe553, 0xf071, 0xe5ac, 0xee4d, 0xe5f7, 0xee22, 0xe1e4,
0xefa3, 0xe1ea, 0xf03f, 0xe41f, 0xf066, 0xe47d, 0xf0b0, 0xe48e, 0xf122, 0xe4d4,
0xf314, 0xe62d, 0xf378, 0xe7ac, 0xf47c, 0xe652, 0xf8ad, 0xe68e, 0xf2a8, 0xe4d7,
0xedab, 0xe4d3, 0xf39b, 0xea1d, 0xf616, 0xebc7, 0xf49f, 0xe9d2, 0xf57e, 0xe95f,
0xf5f2, 0xe925, 0xf5c1, 0xe900, 0xf5e4, 0xe8de, 0xf5e6, 0xe8a1, 0xf73e, 0xe836,
0xf8d3, 0xe6f0, 0xfa46, 0xeb7d, 0xfacb, 0xf0a7, 0xf757, 0xeb48, 0xf52f, 0xe86b,
0xf5ac, 0xead8, 0xf544, 0xe96b, 0xf767, 0xe9f1, 0xf834, 0xea67, 0xf7da, 0xea53,
0xf79c, 0xea54, 0xf7cb, 0xea67, 0xf981, 0xea97, 0xfa3c, 0xeb44, 0xf928, 0xec7c,
0xf798, 0xec3f, 0xf904, 0xe956, 0xfab7, 0xe8ab, 0xfbb4, 0xea71, 0xfb2a, 0xed3f,
0xfac8, 0xedd5, 0xfb35, 0xed47, 0xfb7b, 0xed35, 0xfbb0, 0xed88, 0xfb8c, 0xed94,
0xfbd2, 0xed61, 0xfd9e, 0xede8, 0xff35, 0xeef1, 0xfd31, 0xf050, 0xf8fd, 0xf0b7,
0xf9d8, 0xf12a, 0xff43, 0xf0c9, 0xfec7, 0xf158, 0xfbb5, 0xf0f1, 0xfc6a, 0xefc4,
0xfcff, 0xf04c, 0xfcf7, 0xf0c2, 0xfcca, 0xf10e, 0xfd9f, 0xf1b3, 0xfebf, 0xf223,
0xfc9b, 0xf523, 0xfabe, 0xf3a1, 0xfc15, 0xec54, 0xfca2, 0xf075, 0xfb5c, 0xf71d,
0xfed8, 0xf4ae, 0xfe8a, 0xf283, 0xfbcf, 0xf2fb, 0xfcd0, 0xf37c, 0xfd02, 0xf3ac,
0xfdad, 0xf43b, 0xfe9d, 0xf538, 0xfe1e, 0xf576, 0xfc83, 0xf303, 0xfbc7, 0xf38e,
0xfe8a, 0xf597, 0x02da, 0xf6f4, 0xffb8, 0xf9c3, 0xfcb9, 0xf91a, 0xff66, 0xf80c,
0x0115, 0xf85d, 0x000c, 0xf89c, 0x006a, 0xf95f, 0x004f, 0xf959, 0x00b3, 0xf9f5,
0x0040, 0xfa3c, 0xfeb3, 0xf8a9, 0x00b2, 0xf917, 0x0167, 0xf864, 0xfe27, 0xf78a,
0xffba, 0xfbd2, 0x032c, 0xfd32, 0x0100, 0xfa7d, 0xff32, 0xfa25, 0x014c, 0xfb33,
0x01a5, 0xfba0, 0x0140, 0xfbd2, 0x010b, 0xfc23, 0x0252, 0xfd11, 0x04db, 0xfdba,
0x027a, 0xfc6e, 0x006f, 0xfd5b, 0x02a0, 0xff6b, 0x0554, 0xfe3e, 0x0790, 0x006f,
0x07a6, 0x0360, 0x0613, 0x0317, 0x089b, 0x03d4, 0x0a6e, 0x050b, 0x0b79, 0x0665,
0x0c87, 0x076b, 0x0cf3, 0x0841, 0x0eaf, 0x0985, 0x0e77, 0x0a30, 0x0fba, 0x0b1a,
0x1098, 0x0bd6, 0x0fa5, 0x0d94, 0x0fd3, 0x0bbf, 0x0f1f, 0x0c0e, 0x102d, 0x0dc3,
0x10fb, 0x0d02, 0x106a, 0x0ca4, 0x10d8, 0x0cad, 0x10ef, 0x0cf1, 0x1192, 0x0ce8,
0x0fd7, 0x0e6c, 0x0bd2, 0x0da4, 0x10f8, 0x0cd2, 0x154f, 0x0b93, 0x1023, 0x07f8,
0x0f84, 0x0993, 0x13a5, 0x0c2e, 0x1045, 0x0bda, 0x0f0f, 0x0b22, 0x10b9, 0x0c34,
0x10a6, 0x0c65, 0x1169, 0x0d83, 0x1150, 0x0d9e, 0x1224, 0x0e90, 0x1043, 0x0e0e,
0x0c3f, 0x0d4f, 0x1347, 0x0fe0, 0x1674, 0x10f8, 0x10c2, 0x0f35, 0x0ffc, 0x0dd4,
0x0f95, 0x0e5d, 0x0f79, 0x0dff, 0x10ea, 0x0de5, 0x114b, 0x0e91, 0x1143, 0x0e97,
0x1106, 0x0e49, 0x1139, 0x0e02, 0x104a, 0x0de0, 0x0d9e, 0x0ec7, 0x0fc0, 0x0ef1,
0x1509, 0x1174, 0x14c4, 0x11ef, 0x0faa, 0x0e6f, 0x10cd, 0x0e65, 0x12a7, 0x1010,
0x11cd, 0x1064, 0x116a, 0x101b, 0x1173, 0x1075, 0x116f, 0x10a9, 0x1173, 0x121c,
0x125a, 0x1296, 0x10bb, 0x1263, 0x0e96, 0x12b4, 0x1359, 0x107b, 0x15b0, 0x0f40,
0x0e16, 0x140a, 0x0d78, 0x179b, 0x131a, 0x138b, 0x12d1, 0x12b9, 0x11ca, 0x14a5,
0x124c, 0x154d, 0x12b5, 0x15da, 0x12d6, 0x163d, 0x134b, 0x17b1, 0x11fb, 0x1616,
0x1359, 0x14a4, 0x143c, 0x1944, 0x14ac, 0x1c17, 0x16ae, 0x159e, 0x1647, 0x1430,
0x1426, 0x17ef, 0x126e, 0x1687, 0x1338, 0x1697, 0x132a, 0x16c6, 0x13aa, 0x1716,
0x13b4, 0x1767, 0x13d0, 0x1792, 0x15e1, 0x19b4, 0x1553, 0x17f0, 0x11f5, 0x13ce,
0x12b9, 0x18e7, 0x1562, 0x1bad, 0x13ba, 0x17f3, 0x14fb, 0x1987, 0x15a9, 0x1abb,
0x13c8, 0x17ba, 0x13f7, 0x1794, 0x143b, 0x180a, 0x1495, 0x1889, 0x149d, 0x18a6,
0x1600, 0x1836, 0x184e, 0x1aa4, 0x15b7, 0x1ab8, 0x1369, 0x147d, 0x1627, 0x159b,
0x1805, 0x1d23, 0x1480, 0x1bc2, 0x14f6, 0x1976, 0x16e0, 0x1a6b, 0x16fd, 0x1aa9,
0x1742, 0x1b46, 0x1735, 0x1bd2, 0x181c, 0x1cf6, 0x18b2, 0x1dde, 0x17ef, 0x1e97,
0x1982, 0x1de5, 0x1b90, 0x1c8d, 0x1dd3, 0x1fe2, 0x1d81, 0x25ca, 0x1bd9, 0x244c,
0x1e2c, 0x22a1, 0x1fb6, 0x2519, 0x2011, 0x25d1, 0x2064, 0x25a6, 0x20ad, 0x2620,
0x2113, 0x267d, 0x207e, 0x26a1, 0x211f, 0x274e, 0x2211, 0x28e3, 0x2220, 0x28c7,
0x23cb, 0x2535, 0x26da, 0x27e9, 0x263b, 0x2a75, 0x2273, 0x281f, 0x2118, 0x2832,
0x22ff, 0x28bb, 0x23fb, 0x2806, 0x2370, 0x279f, 0x2370, 0x2777, 0x21b6, 0x26c7,
0x22e2, 0x2681, 0x244b, 0x2559, 0x212e, 0x288a, 0x2137, 0x295f, 0x214e, 0x2451,
0x21ac, 0x2506, 0x2317, 0x2651, 0x235f, 0x26d6, 0x239c, 0x2719, 0x23dc, 0x280b,
0x2377, 0x27da, 0x2377, 0x2858, 0x2345, 0x280f, 0x2271, 0x28a0, 0x218f, 0x2a72,
0x237e, 0x2632, 0x289a, 0x236d, 0x26b1, 0x2672, 0x21f2, 0x28ba, 0x23d4, 0x2869,
0x238d, 0x270d, 0x20f2, 0x26b5, 0x21ea, 0x26b7, 0x2328, 0x2788, 0x2300, 0x27ae,
0x2305, 0x281a, 0x21cd, 0x2733, 0x245d, 0x26a6, 0x24af, 0x28a6, 0x1fb0, 0x2741,
0x2175, 0x24ab, 0x23fa, 0x234a, 0x1f2c, 0x272e, 0x1f08, 0x26f8, 0x22b1, 0x25b7,
0x2200, 0x26c4, 0x215c, 0x264b, 0x217b, 0x266d, 0x217e, 0x266e, 0x2179, 0x26f3,
0x204d, 0x2748, 0x22ba, 0x27c6, 0x2417, 0x2789, 0x2021, 0x2841, 0x2159, 0x26f7,
0x23db, 0x2834, 0x22ae, 0x28b3, 0x2201, 0x26ad, 0x21e0, 0x2730, 0x220b, 0x2779,
0x2223, 0x273d, 0x21cb, 0x26b4, 0x2244, 0x2678, 0x2213, 0x276d, 0x219e, 0x2788,
0x2129, 0x25b9, 0x2091, 0x26f6, 0x200d, 0x2630, 0x21e1, 0x21d4, 0x2268, 0x2465,
0x1f16, 0x26cb, 0x1f40, 0x2424, 0x1f9d, 0x23f1, 0x1f4c, 0x243f, 0x1f13, 0x2403,
0x1f15, 0x23dc, 0x1f30, 0x2325, 0x1eb5, 0x23b0, 0x1e04, 0x24ff, 0x20a4, 0x2513,
0x1f39, 0x23d4, 0x1b62, 0x2439, 0x1e70, 0x2466, 0x2178, 0x22ca, 0x1edc, 0x22cf,
0x1dbb, 0x2272, 0x1df3, 0x2291, 0x1df3, 0x22be, 0x1def, 0x22dc, 0x1f0d, 0x2365,
0x1ef7, 0x2248, 0x1cf3, 0x21d0, 0x1c78, 0x23fd, 0x1ed9, 0x2445, 0x1b05, 0x23d4,
0x19f2, 0x22b9, 0x1ec9, 0x2125, 0x1fa1, 0x21c7, 0x1c9f, 0x2270, 0x1c70, 0x21f3,
0x1cba, 0x21ab, 0x1c57, 0x214b, 0x1b99, 0x2167, 0x1b52, 0x2111, 0x1e68, 0x1fc6,
0x1cac, 0x1f14, 0x16f5, 0x1fbc, 0x19b9, 0x1fe0, 0x1d8d, 0x1e65, 0x174c, 0x1e80,
0x1881, 0x1ee8, 0x1da2, 0x1f8c, 0x1c4d, 0x1fb5, 0x1b6f, 0x201a, 0x1b11, 0x1fbd,
0x1a82, 0x1fb9, 0x19b9, 0x1ffb, 0x1b3e, 0x1ea1, 0x1e85, 0x1c67, 0x1a16, 0x1c62,
0x1650, 0x202f, 0x1a1d, 0x2056, 0x184e, 0x1b86, 0x143b, 0x1b4c, 0x1749, 0x1bcb,
0x1976, 0x1b61, 0x183a, 0x1b52, 0x182e, 0x1b4e, 0x17ca, 0x1ae8, 0x174a, 0x19e9,
0x1563, 0x1a91, 0x1265, 0x18fb, 0x164f, 0x17d5, 0x1835, 0x19fd, 0x126c, 0x190c,
0x103b, 0x1747, 0x1479, 0x179a, 0x1540, 0x18b0, 0x13bc, 0x180b, 0x13f8, 0x1801,
0x13d3, 0x1801, 0x142c, 0x1890, 0x1334, 0x188e, 0x13d2, 0x18a4, 0x1538, 0x1813,
0x1242, 0x18b0, 0x11b9, 0x1597, 0x136f, 0x1416, 0x114c, 0x16ae, 0x1060, 0x13e3,
0x1075, 0x12ae, 0x0ee6, 0x137e, 0x0ed4, 0x130c, 0x0dbe, 0x11b7, 0x0d29, 0x1138,
0x0c0b, 0x1049, 0x0a56, 0x1056, 0x0bee, 0x0ebc, 0x0e41, 0x0f60, 0x0ae7, 0x0ffc,
0x09fd, 0x0cdf, 0x0c3d, 0x0d98, 0x0ade, 0x0f40, 0x081c, 0x0e04, 0x0935, 0x0cf3,
0x09f2, 0x0d49, 0x093f, 0x0cad, 0x09ba, 0x0d4f, 0x09a7, 0x0ce0, 0x0a2c, 0x0cc9,
0x0837, 0x0cc4, 0x087b, 0x0b63, 0x0b00, 0x0a71, 0x0844, 0x0c7b, 0x0622, 0x0bd6,
0x09ad, 0x0b07, 0x0a72, 0x0b7a, 0x06dc, 0x093b, 0x0653, 0x0967, 0x066c, 0x0966,
0x05f0, 0x08d5, 0x0585, 0x084f, 0x0440, 0x07ac, 0x03af, 0x07e7, 0x0534, 0x0828,
0x0668, 0x05bf, 0x068c, 0x061b, 0x0376, 0x06ac, 0x02bd, 0x042a, 0x04c7, 0x0589,
0x0501, 0x0722, 0x040a, 0x06a3, 0x0355, 0x05a7, 0x028e, 0x0524, 0x0202, 0x048f,
0x014c, 0x03fe, 0x0044, 0x0378, 0x0024, 0x038e, 0xff41, 0x02fc, 0xff66, 0x01ef,
0x00e6, 0x020a, 0x010d, 0x03a6, 0xfe07, 0x0326, 0xfcb3, 0x0101, 0xfd96, 0xffae,
0xfcf3, 0x0019, 0xfc3d, 0xffd4, 0xfb47, 0xfedf, 0xfb16, 0xfed3, 0xfa16, 0xfdeb,
0xf93c, 0xfd9b, 0xfb41, 0xfcb6, 0xfccc, 0xfc38, 0xf76e, 0xfbde, 0xf59a, 0xfcce,
0xf81d, 0xfb2f, 0xf9ed, 0xfb1e, 0xf8b7, 0xfbf4, 0xf7fa, 0xfb0f, 0xf85f, 0xfb3e,
0xf84c, 0xfaf5, 0xf84a, 0xfae5, 0xf896, 0xfac2, 0xf831, 0xfb68, 0xf770, 0xfa9f,
0xf90c, 0xf891, 0xf6b5, 0xf82d, 0xf459, 0xfa34, 0xf7a5, 0xfa45, 0xf8e9, 0xf8a4,
0xf50e, 0xf745, 0xf46f, 0xf701, 0xf518, 0xf6a2, 0xf4c1, 0xf605, 0xf439, 0xf581,
0xf3bc, 0xf4fc, 0xf3fd, 0xf3e9, 0xf0bd, 0xf435, 0xeecf, 0xf3e8, 0xf2a5, 0xeedb,
0xf252, 0xee6e, 0xed38, 0xf1cd, 0xefd5, 0xf131, 0xf004, 0xeee7, 0xec9f, 0xeed1,
0xecc9, 0xeee2, 0xecad, 0xee79, 0xec86, 0xeec7, 0xeb99, 0xee89, 0xeba5, 0xed52,
0xec44, 0xec8d, 0xe97a, 0xed50, 0xe77d, 0xee0f, 0xea28, 0xea89, 0xea25, 0xe888,
0xe812, 0xe9be, 0xe8da, 0xe99b, 0xe8e4, 0xe9c7, 0xe796, 0xe9f8, 0xe724, 0xea12,
0xe6c3, 0xe9d5, 0xe624, 0xe9fb, 0xe654, 0xe96e, 0xe5b3, 0xe89e, 0xe415, 0xe974,
0xe1be, 0xead0, 0xe065, 0xe899, 0xe567, 0xe7dc, 0xe76d, 0xe877, 0xe47b, 0xe7b3,
0xe246, 0xe857, 0xe1ea, 0xe7d2, 0xe1a8, 0xe6b1, 0xe13b, 0xe59d, 0xe0e2, 0xe52d,
0xe08a, 0xe3ff, 0xdee9, 0xe393, 0xdd27, 0xe480, 0xdfc0, 0xe3d9, 0xe013, 0xe122,
0xdd1d, 0xe13b, 0xdb73, 0xe201, 0xde61, 0xe07f, 0xdee6, 0xe177, 0xdd35, 0xe21e,
0xdd44, 0xe1d2, 0xdd10, 0xe1ce, 0xdce9, 0xe217, 0xdcae, 0xe25a, 0xddfa, 0xe2d4,
0xe06f, 0xe2be, 0xde69, 0xe491, 0xdcc9, 0xe4de, 0xdff9, 0xe447, 0xe0cc, 0xe6a4,
0xe27f, 0xe755, 0xe3d2, 0xe75e, 0xe3a0, 0xe8b0, 0xe3fd, 0xe9cd, 0xe4ed, 0xea8c,
0xe525, 0xeace, 0xe58d, 0xeb1b, 0xe586, 0xeb77, 0xe491, 0xea50, 0xe550, 0xeb78,
0xe578, 0xee0e, 0xe2e6, 0xea29, 0xe367, 0xe839, 0xe5e5, 0xe9f2, 0xe434, 0xe9dd,
0xe300, 0xe95d, 0xe361, 0xe8e5, 0xe327, 0xe86d, 0xe2e4, 0xe833, 0xe29c, 0xe7ed,
0xe2b7, 0xe7c7, 0xe0a7, 0xe75f, 0xdea0, 0xe7cc, 0xe349, 0xe6ff, 0xe6ca, 0xe590,
0xe054, 0xe6a5, 0xdd7b, 0xe85b, 0xe3ac, 0xe745, 0xe369, 0xe687, 0xe10c, 0xe66d,
0xe18d, 0xe69c, 0xe193, 0xe688, 0xe180, 0xe5fe, 0xe142, 0xe5f6, 0xe1ea, 0xe53f,
0xe330, 0xe497, 0xdf50, 0xe49c, 0xdf17, 0xe652, 0xe554, 0xe58c, 0xe2e7, 0xe27a,
0xdde2, 0xe2f8, 0xdfa2, 0xe4e2, 0xe127, 0xe51b, 0xe086, 0xe448, 0xe004, 0xe3bb,
0xdffc, 0xe3b6, 0xdfc8, 0xe38e, 0xdf46, 0xe373, 0xde65, 0xe3a6, 0xe130, 0xe3c0,
0xde6b, 0xe42c, 0xd997, 0xe476, 0xe05e, 0xe3e3, 0xe477, 0xe337, 0xdfee, 0xe2e8,
0xdd96, 0xe280, 0xdf41, 0xe339, 0xdf5a, 0xe32b, 0xdf64, 0xe357, 0xdf4f, 0xe339,
0xdfa7, 0xe3ab, 0xdf8d, 0xe3df, 0xdec1, 0xe34a, 0xdefd, 0xe318, 0xdff6, 0xe1ab,
0xe003, 0xe127, 0xe05e, 0xe34c, 0xdf15, 0xe2c7, 0xddf6, 0xe173, 0xde97, 0xe1fa,
0xde67, 0xe1cf, 0xde79, 0xe1a4, 0xde4a, 0xe199, 0xdea9, 0xe170, 0xde2b, 0xe253,
0xdba4, 0xe2f9, 0xdd42, 0xe22c, 0xe0b5, 0xe0b5, 0xdd96, 0xe188, 0xdc4a, 0xe1fd,
0xde17, 0xe0cf, 0xdd86, 0xe1d2, 0xdd05, 0xe232, 0xddee, 0xe201, 0xde47, 0xe242,
0xde19, 0xe228, 0xdeba, 0xe24a, 0xde72, 0xe1e3, 0xdf39, 0xe323, 0xe0c0, 0xe432,
0xdf55, 0xe37a, 0xddd3, 0xe333, 0xdf89, 0xe2e7, 0xe09d, 0xe1be, 0xe047, 0xe307,
0xdf24, 0xe3c9, 0xdf0a, 0xe2d1, 0xdf09, 0xe29f, 0xde05, 0xe1bb, 0xde19, 0xe1df,
0xde3a, 0xe1ec, 0xded1, 0xe16d, 0xdc10, 0xe1ff, 0xdb21, 0xe174, 0xdc58, 0xe033,
0xdc3d, 0xe1d9, 0xdd67, 0xe49d, 0xdf02, 0xe3de, 0xde52, 0xe352, 0xdd15, 0xe3b6,
0xddbe, 0xe38e, 0xddc6, 0xe3a7, 0xdda0, 0xe374, 0xdda7, 0xe3d2, 0xded9, 0xe414,
0xde45, 0xe3db, 0xdc0a, 0xe612, 0xde31, 0xe596, 0xe2be, 0xe334, 0xe074, 0xe40a,
0xdd43, 0xe53d, 0xdf57, 0xe55e, 0xe0f9, 0xe53d, 0xe060, 0xe5a1, 0xe090, 0xe5ab,
0xe09a, 0xe5c4, 0xe08e, 0xe607, 0xe01a, 0xe61e, 0xdfd1, 0xe6e4, 0xe260, 0xe624,
0xe1e1, 0xe57a, 0xdfca, 0xe773, 0xdff7, 0xe6c2, 0xe175, 0xe59e, 0xe286, 0xe642,
0xe165, 0xe6fa, 0xe0dd, 0xe637, 0xe128, 0xe618, 0xe17c, 0xe6ab, 0xe1fe, 0xe711,
0xe1af, 0xe6b7, 0xe212, 0xe6ee, 0xe36f, 0xe880, 0xe3a1, 0xe849, 0xe29f, 0xe49d,
0xe2d3, 0xe7c1, 0xe454, 0xeb81, 0xe585, 0xe8b0, 0xe5a2, 0xe7ea, 0xe55c, 0xe8d8,
0xe66b, 0xe9a9, 0xe6db, 0xe9e0, 0xe767, 0xea36, 0xe81b, 0xea90, 0xe787, 0xea73,
0xe606, 0xead9, 0xe80a, 0xebbc, 0xeae2, 0xe978, 0xe9ed, 0xe872, 0xe91c, 0xeb0a,
0xe92b, 0xeb64, 0xe897, 0xea55, 0xe8f6, 0xeafd, 0xe9b0, 0xeab2, 0xe9bf, 0xea86,
0xe9e6, 0xea97, 0xe984, 0xea8e, 0xea94, 0xea77, 0xeab6, 0xea03, 0xe8c6, 0xe978,
0xe98a, 0xe9e9, 0xeb1d, 0xea97, 0xea0c, 0xeaed, 0xe998, 0xea81, 0xebdf, 0xe99d,
0xebcb, 0xea74, 0xeafd, 0xea14, 0xeb6d, 0xea37, 0xebb5, 0xea58, 0xebe0, 0xea49,
0xeba6, 0xea83, 0xec0e, 0xea2b, 0xeeaf, 0xeada, 0xee59, 0xecc5, 0xed57, 0xed46,
0xed93, 0xebde, 0xed71, 0xeb23, 0xecb5, 0xeb49, 0xec9c, 0xeaf8, 0xed8e, 0xeb6f,
0xedce, 0xeb4d, 0xede9, 0xeb3d, 0xedfa, 0xeb0c, 0xede5, 0xeb3f, 0xed5b, 0xeb9d,
0xef88, 0xeb1e, 0xef87, 0xebc0, 0xeca7, 0xec86, 0xed1b, 0xea50, 0xf03c, 0xeab1,
0xee15, 0xec4c, 0xec57, 0xec20, 0xee69, 0xec04, 0xeec5, 0xec54, 0xeeae, 0xec89,
0xeeab, 0xec93, 0xef1b, 0xec4a, 0xee98, 0xed13, 0xee92, 0xee3a, 0xf10e, 0xec82,
0xf1f1, 0xecc0, 0xf050, 0xeed2, 0xf12c, 0xecb9, 0xf1e1, 0xebe1, 0xf1bd, 0xed3c,
0xf0e3, 0xedcd, 0xf0d2, 0xed3c, 0xf110, 0xed69, 0xf0e7, 0xedb5, 0xf0dd, 0xedec,
0xf118, 0xed3a, 0xf0f7, 0xed92, 0xf070, 0xeece, 0xf14e, 0xed28, 0xf07d, 0xebf6,
0xf223, 0xee37, 0xf427, 0xef5e, 0xf058, 0xee6b, 0xef82, 0xedbd, 0xf103, 0xee5e,
0xf14a, 0xeec1, 0xf1b8, 0xef18, 0xf223, 0xf01d, 0xf2c9, 0xf092, 0xf243, 0xf156,
0xf054, 0xf085, 0xf458, 0xf283, 0xf4bc, 0xf401, 0xf0c7, 0xf24d, 0xf25d, 0xf1e5,
0xf494, 0xf30e, 0xf477, 0xf2a4, 0xf34c, 0xf178, 0xf3a8, 0xf254, 0xf388, 0xf18d,
0xf3ba, 0xf192, 0xf3a1, 0xf15b, 0xf3a7, 0xf1db, 0xf37e, 0xf049, 0xf526, 0xf019,
0xf658, 0xf32e, 0xf40f, 0xf445, 0xf38c, 0xf1fa, 0xf5e3, 0xf185, 0xf6cb, 0xf31f,
0xf6fe, 0xf39e, 0xf783, 0xf3de, 0xf826, 0xf494, 0xf934, 0xf5a6, 0xfa22, 0xf662,
0xfbd9, 0xf879, 0xfb10, 0xf95d, 0xfb8a, 0xf882, 0xfea1, 0xf870, 0xff63, 0xfb94,
0xff65, 0xff3d, 0x02eb, 0xfe4a, 0x0412, 0xfd32, 0x036e, 0xff50, 0x03f3, 0xff9a,
0x047b, 0x0043, 0x04bd, 0x00b1, 0x04e9, 0x0124, 0x0604, 0x0166, 0x064b, 0x0122,
0x03df, 0x01c9, 0x0549, 0x0230, 0x09c9, 0x0225, 0x07ea, 0x01be, 0x042f, 0x0102,
0x0564, 0xffd6, 0x06a3, 0x0056, 0x0570, 0x0015, 0x05c3, 0x0006, 0x05d1, 0xffe4,
0x05fa, 0xfff4, 0x0631, 0x00d6, 0x0735, 0x00cd, 0x0926, 0x01d6, 0x0570, 0x01c8,
0x0471, 0xffd9, 0x093a, 0x008c, 0x0a59, 0x024e, 0x0788, 0x02b1, 0x06f7, 0x02f5,
0x0834, 0x0289, 0x07a6, 0x0283, 0x078a, 0x0272, 0x0745, 0x0277, 0x0775, 0x0298,
0x07bd, 0x02af, 0x0788, 0x02a6, 0x06c1, 0x020a, 0x0750, 0x0237, 0x0745, 0x02cc,
0x0850, 0x027d, 0x0a82, 0x031b, 0x08b9, 0x031e, 0x083b, 0x02ef, 0x08d3, 0x0311,
0x0985, 0x037e, 0x099f, 0x03be, 0x0a78, 0x0466, 0x0adc, 0x04c8, 0x0a61, 0x0580,
0x0953, 0x049e, 0x0bb7, 0x0448, 0x0d1e, 0x0637, 0x09d0, 0x076c, 0x0979, 0x0689,
0x0a44, 0x04de, 0x0a33, 0x0597, 0x09ee, 0x0615, 0x0a7c, 0x061a, 0x0a2a, 0x05e8,
0x0a56, 0x062a, 0x0971, 0x0687, 0x0a1f, 0x060b, 0x0cbc, 0x0560, 0x0c71, 0x0646,
0x0921, 0x06cf, 0x0996, 0x06ad, 0x0b31, 0x0a2b, 0x0b8a, 0x0a6a, 0x0c94, 0x077a,
0x0c40, 0x0893, 0x0bbc, 0x08f2, 0x0beb, 0x0940, 0x0baa, 0x0948, 0x0bba, 0x097d,
0x0baf, 0x09a4, 0x0b47, 0x0a3f, 0x0bf5, 0x0a92, 0x0d4e, 0x0b70, 0x0d15, 0x08d7,
0x0c78, 0x07c0, 0x0cfe, 0x0c97, 0x0dcb, 0x0c7d, 0x0e7a, 0x0b91, 0x0e51, 0x0c99,
0x0e80, 0x0d4c, 0x0e9a, 0x0d5e, 0x0f0a, 0x0dc8, 0x0eca, 0x0e69, 0x0dcf, 0x100d,
0x1086, 0x0e4a, 0x136d, 0x0e30, 0x0f6e, 0x108e, 0x0e30, 0x0d8d, 0x1144, 0x0d4d,
0x10a3, 0x0fba, 0x0fd8, 0x0f23, 0x1068, 0x0ea2, 0x10e6, 0x0f2f, 0x1104, 0x0f39,
0x1163, 0x0f8d, 0x1168, 0x0f20, 0x1114, 0x0f49, 0x1087, 0x0f86, 0x1274, 0x103a,
0x12b5, 0x105d, 0x11ec, 0x1069, 0x1419, 0x1075, 0x151e, 0x1103, 0x1450, 0x1178,
0x14a8, 0x1214, 0x153b, 0x12c9, 0x15de, 0x1369, 0x167d, 0x143f, 0x1793, 0x14dd,
0x18de, 0x164b, 0x15d4, 0x16af, 0x170e, 0x185a, 0x1e47, 0x18b8, 0x1c9c, 0x19a8,
0x17f0, 0x1ad4, 0x1bcd, 0x1b57, 0x1e17, 0x1b82, 0x1dd6, 0x1c57, 0x1e69, 0x1cbf,
0x1f2c, 0x1d19, 0x1fac, 0x1d96, 0x1fe6, 0x1e06, 0x2051, 0x1eab, 0x20a0, 0x1eb6,
0x203a, 0x1ec7, 0x1fe4, 0x1d61, 0x2118, 0x1e54, 0x22d0, 0x2064, 0x2293, 0x20a2,
0x22b0, 0x1e34, 0x224d, 0x1de6, 0x219b, 0x1e90, 0x220c, 0x1eb6, 0x2225, 0x1e3c,
0x229f, 0x1e6a, 0x2299, 0x1e47, 0x224b, 0x1e8c, 0x2391, 0x1f7f, 0x2388, 0x1f33,
0x23ec, 0x1f72, 0x245b, 0x1ec1, 0x238a, 0x1fe4, 0x23b3, 0x1f8d, 0x24c5, 0x203c,
0x24e8, 0x20d1, 0x24f9, 0x20c4, 0x253a, 0x20ea, 0x25c7, 0x217f, 0x25f5, 0x2166,
0x26ec, 0x217a, 0x267f, 0x229f, 0x2638, 0x2360, 0x2755, 0x21b3, 0x2662, 0x2148,
0x261b, 0x234c, 0x2731, 0x2248, 0x26e2, 0x21c6, 0x2651, 0x223a, 0x266e, 0x21f6,
0x25d3, 0x21fc, 0x25c8, 0x21d5, 0x254b, 0x2212, 0x2608, 0x2201, 0x2717, 0x2239,
0x2545, 0x2346, 0x23bc, 0x21e8, 0x25f6, 0x1f97, 0x2674, 0x215f, 0x2487, 0x2383,
0x2588, 0x21b2, 0x25c5, 0x2121, 0x2532, 0x21c0, 0x2562, 0x21fa, 0x256e, 0x2222,
0x2560, 0x2265, 0x2583, 0x2292, 0x25f7, 0x2120, 0x25e2, 0x2183, 0x240e, 0x240a,
0x25dd, 0x24b9, 0x276e, 0x23ba, 0x258d, 0x245f, 0x24a3, 0x239b, 0x2687, 0x22bd,
0x2655, 0x2365, 0x256b, 0x22e4, 0x2580, 0x22ea, 0x251b, 0x2207, 0x24cb, 0x2227,
0x23d4, 0x21c1, 0x256c, 0x21d7, 0x261f, 0x2260, 0x237c, 0x21d2, 0x2372, 0x222f,
0x249b, 0x21cb, 0x22df, 0x21f2, 0x2334, 0x2210, 0x2502, 0x2253, 0x2466, 0x222c,
0x245e, 0x2296, 0x244b, 0x228c, 0x247f, 0x22b1, 0x2404, 0x22e3, 0x2321, 0x2301,
0x235c, 0x234f, 0x249d, 0x22b7, 0x2425, 0x2158, 0x2298, 0x2120, 0x228d, 0x21b6,
0x2336, 0x223e, 0x22d2, 0x2262, 0x223a, 0x220d, 0x223f, 0x21f8, 0x225f, 0x2206,
0x2227, 0x21b6, 0x2189, 0x2141, 0x22bf, 0x2259, 0x22c3, 0x227c, 0x20ab, 0x2173,
0x1ed9, 0x210c, 0x20db, 0x213e, 0x2216, 0x2118, 0x2109, 0x216f, 0x20d8, 0x20da,
0x210c, 0x20ed, 0x20e0, 0x213b, 0x20d3, 0x213c, 0x20a9, 0x212f, 0x20f6, 0x2106,
0x219c, 0x2164, 0x2104, 0x211e, 0x2017, 0x212b, 0x2038, 0x231f, 0x21c4, 0x22b3,
0x20ed, 0x2010, 0x1f73, 0x20b8, 0x2082, 0x21af, 0x2134, 0x2143, 0x2072, 0x2104,
0x205a, 0x212b, 0x2015, 0x210b, 0x1ffc, 0x20fc, 0x1f7e, 0x2105, 0x1ff2, 0x1ffd,
0x2038, 0x1e65, 0x1cb1, 0x1e08, 0x1cc1, 0x20ce, 0x1ff2, 0x1fe3, 0x1e9d, 0x1d85,
0x1b98, 0x1d67, 0x1c17, 0x1db6, 0x1c83, 0x1d9c, 0x1bf1, 0x1d5a, 0x1c1d, 0x1d53,
0x1bae, 0x1d2d, 0x1bff, 0x1d12, 0x1be9, 0x1cdb, 0x19ee, 0x1c42, 0x1a46, 0x1ba1,
0x19c5, 0x1bc8, 0x17ba, 0x1c26, 0x1953, 0x1be9, 0x1b03, 0x1b1a, 0x1b2a, 0x1d0b,
0x1a0c, 0x1cda, 0x1a0a, 0x1cf0, 0x19b7, 0x1cb0, 0x198d, 0x1c8a, 0x18df, 0x1c6b,
0x1973, 0x1cd1, 0x1a56, 0x1c36, 0x1761, 0x1bf9, 0x1670, 0x1c28, 0x17b9, 0x1b92,
0x17a7, 0x1ae8, 0x1699, 0x1995, 0x169d, 0x199e, 0x1563, 0x18b8, 0x150c, 0x189c,
0x14b9, 0x17f4, 0x1462, 0x1779, 0x136f, 0x1679, 0x12bc, 0x161e, 0x1350, 0x1695,
0x126e, 0x167c, 0x0fb6, 0x14bf, 0x119a, 0x13de, 0x1370, 0x14ca, 0x105c, 0x1571,
0x1120, 0x14a6, 0x11d7, 0x1423, 0x10d4, 0x142b, 0x1078, 0x13fb, 0x1068, 0x13f3,
0x1094, 0x13dc, 0x1036, 0x1399, 0x0f10, 0x13b8, 0x101a, 0x1466, 0x10f1, 0x1457,
0x1011, 0x13af, 0x0f8b, 0x1332, 0x0fea, 0x13d4, 0x10c9, 0x14a2, 0x0fe7, 0x14a1,
0x0f5f, 0x140d, 0x0f53, 0x13d2, 0x0f18, 0x13b7, 0x0eac, 0x135e, 0x0e76, 0x12ba,
0x0e4c, 0x1206, 0x0d13, 0x1238, 0x0b37, 0x1259, 0x0b31, 0x11a2, 0x0cdb, 0x1147,
0x0c78, 0x1111, 0x0b22, 0x108e, 0x0a8f, 0x0fa2, 0x0a03, 0x0f85, 0x09a5, 0x0f48,
0x0943, 0x0eea, 0x08a8, 0x0e5a, 0x0878, 0x0e4a, 0x08d5, 0x0e13, 0x0784, 0x0d03,
0x0503, 0x0cf8, 0x0569, 0x0d08, 0x0692, 0x0c70, 0x0430, 0x0b2f, 0x039b, 0x0aff,
0x0592, 0x0bc1, 0x058b, 0x0b9f, 0x04cf, 0x0b81, 0x045d, 0x0b5b, 0x03f0, 0x0afa,
0x03cb, 0x0a8e, 0x0313, 0x0a31, 0x0232, 0x0b19, 0x028a, 0x0ab0, 0x0209, 0x0902,
0xffe6, 0x070e, 0x0094, 0x07e4, 0x02ed, 0x0824, 0x016d, 0x06f8, 0xff8e, 0x065a,
0x003b, 0x0680, 0x001b, 0x069e, 0xffb3, 0x0653, 0xfffd, 0x068c, 0xffe9, 0x061b,
0x001d, 0x0671, 0xff7b, 0x0612, 0xff15, 0x079a, 0xff02, 0x0732, 0xff5b, 0x0492,
0xfed7, 0x0528, 0xfffa, 0x0722, 0xff53, 0x05ef, 0xfddb, 0x0477, 0xfd97, 0x043d,
0xfd61, 0x03d1, 0xfd4c, 0x038b, 0xfc97, 0x02f3, 0xfc8e, 0x0327, 0xfb66, 0x00dd,
0xf9dd, 0xffeb, 0xf96c, 0x0098, 0xfabd, 0xffb6, 0xf9d8, 0xfc76, 0xf8a7, 0xfcec,
0xf8d4, 0xfe13, 0xf833, 0xfcf7, 0xf79a, 0xfc65, 0xf762, 0xfc40, 0xf732, 0xfc65,
0xf6f1, 0xfc04, 0xf71a, 0xfbcd, 0xf5e0, 0xfb53, 0xf5d8, 0xfb4c, 0xf6bd, 0xfbc4,
0xf669, 0xfcb0, 0xf67a, 0xfb64, 0xf711, 0xf9c6, 0xf544, 0xf9d1, 0xf390, 0xfac4,
0xf3e8, 0xfa45, 0xf377, 0xfa22, 0xf327, 0xf9cc, 0xf2db, 0xf955, 0xf2c2, 0xf917,
0xf299, 0xf876, 0xf0fe, 0xf895, 0xefbe, 0xf8ac, 0xf206, 0xf754, 0xf1ba, 0xf5cb,
0xee7f, 0xf653, 0xee12, 0xf5bb, 0xef55, 0xf53b, 0xeeea, 0xf4dd, 0xeea0, 0xf4ae,
0xeeb6, 0xf46a, 0xee93, 0xf44e, 0xee5c, 0xf477, 0xed9d, 0xf4db, 0xef8b, 0xf45f,
0xf127, 0xf3c0, 0xeeba, 0xf376, 0xec57, 0xf376, 0xedef, 0xf365, 0xefda, 0xf43a,
0xeea5, 0xf4d3, 0xeeab, 0xf48d, 0xef9b, 0xf50d, 0xefb5, 0xf52a, 0xf071, 0xf5c7,
0xf098, 0xf612, 0xf21c, 0xf6c9, 0xf2a1, 0xf7a4, 0xf1fb, 0xf837, 0xf406, 0xf71c,
0xf479, 0xf8a0, 0xf39f, 0xf9d2, 0xf32e, 0xf97e, 0xf396, 0xf99d, 0xf4aa, 0xfa91,
0xf4b6, 0xfa4d, 0xf48c, 0xfa18, 0xf49a, 0xfa10, 0xf47a, 0xfa07, 0xf4cd, 0xf9f2,
0xf3fb, 0xf8cd, 0xf376, 0xf955, 0xf3cd, 0xf866, 0xf493, 0xf63b, 0xf318, 0xf62c,
0xf26c, 0xf750, 0xf2d9, 0xf709, 0xf267, 0xf66d, 0xf279, 0xf58a, 0xf286, 0xf552,
0xf2b1, 0xf527, 0xf2ad, 0xf4e7, 0xf316, 0xf511, 0xf365, 0xf46b, 0xf1a9, 0xf3c0,
0xf12c, 0xf427, 0xf3c0, 0xf4c9, 0xf439, 0xf493, 0xf2f9, 0xf3ea, 0xf2d0, 0xf3b0,
0xf28f, 0xf3ca, 0xf2e2, 0xf40e, 0xf2fe, 0xf3ed, 0xf2df, 0xf3c1, 0xf2ba, 0xf3b7,
0xf2c8, 0xf39e, 0xf2f4, 0xf3d7, 0xf1e1, 0xf3ba, 0xf270, 0xf38a, 0xf408, 0xf28c,
0xf330, 0xf2af, 0xf1b9, 0xf43b, 0xf31e, 0xf47a, 0xf3cc, 0xf305, 0xf381, 0xf2c9,
0xf335, 0xf2ba, 0xf309, 0xf217, 0xf2c3, 0xf1d8, 0xf1f2, 0xf170, 0xf1e8, 0xf175,
0xf2b6, 0xf080, 0xf232, 0xf064, 0xef81, 0xf088, 0xeef2, 0xf006, 0xf17c, 0xf09a,
0xf2a8, 0xefe2, 0xf193, 0xef5c, 0xf15b, 0xef3a, 0xf142, 0xef87, 0xf12d, 0xef54,
0xf12a, 0xef3a, 0xf135, 0xef1c, 0xf164, 0xeede, 0xf06b, 0xee74, 0xf021, 0xef1f,
0xf1e2, 0xeef1, 0xf103, 0xed07, 0xef47, 0xec9b, 0xee49, 0xece6, 0xeefd, 0xecf1,
0xef51, 0xec59, 0xef31, 0xec6b, 0xeec7, 0xebd4, 0xeea1, 0xeb95, 0xee17, 0xeb65,
0xedc4, 0xeb60, 0xee73, 0xeb6a, 0xedda, 0xeabb, 0xed6d, 0xebab, 0xf024, 0xebc9,
0xf01c, 0xeabc, 0xec2c, 0xeb23, 0xed94, 0xeccf, 0xef7e, 0xebdf, 0xef0e, 0xeb3e,
0xee7e, 0xeb49, 0xeddf, 0xeadf, 0xedac, 0xeaac, 0xecf4, 0xea1d, 0xec81, 0xea4b,
0xed5c, 0xea08, 0xee3a, 0xe95c, 0xecbf, 0xea91, 0xead4, 0xeb19, 0xeb72, 0xe9fa,
0xebc4, 0xe9f6, 0xeb90, 0xea36, 0xec02, 0xe9d1, 0xec1e, 0xe9d1, 0xebfa, 0xe9d1,
0xebd7, 0xe93c, 0xebe2, 0xe92e, 0xeb81, 0xe8d6, 0xeb2b, 0xe8f4, 0xec3d, 0xe835,
0xec7b, 0xe916, 0xea59, 0xe8da, 0xe9e8, 0xe77c, 0xeb93, 0xe7e7, 0xeb56, 0xe7ad,
0xea48, 0xe7f6, 0xea9d, 0xe857, 0xeac2, 0xe863, 0xeabe, 0xe84f, 0xeadf, 0xe8fa,
0xeb34, 0xe8dc, 0xeb3c, 0xe90e, 0xe9b2, 0xe934, 0xeabb, 0xea1e, 0xebfa, 0xea00,
0xea12, 0xe8c2, 0xe9f2, 0xe936, 0xea67, 0xe8f2, 0xea24, 0xe7cb, 0xe9a0, 0xe7cc,
0xe99f, 0xe802, 0xe93c, 0xe74b, 0xe937, 0xe72e, 0xe913, 0xe6e6, 0xe979, 0xe72a,
0xe8fd, 0xe6e3, 0xe808, 0xe61a, 0xe85d, 0xe6b0, 0xe95e, 0xe77a, 0xe9b6, 0xe681,
0xe95a, 0xe5f6, 0xea08, 0xe74c, 0xea35, 0xe728, 0xeabb, 0xe749, 0xead2, 0xe779,
0xeae6, 0xe7a5, 0xeada, 0xe7ac, 0xeb38, 0xe79d, 0xebf4, 0xe801, 0xebbf, 0xe7b5,
0xeb97, 0xe69d, 0xeb59, 0xe75c, 0xeb78, 0xe8b7, 0xeb13, 0xe79e, 0xeac8, 0xe748,
0xeb80, 0xe786, 0xec05, 0xe758, 0xeb96, 0xe6ed, 0xeb81, 0xe6e0, 0xeb13, 0xe659,
0xeb5b, 0xe5f1, 0xeaaa, 0xe536, 0xe9d5, 0xe617, 0xeb4a, 0xe5eb, 0xec10, 0xe4bf,
0xea5d, 0xe576, 0xe996, 0xe53c, 0xe9d0, 0xe41a, 0xea38, 0xe4af, 0xea80, 0xe565,
0xea76, 0xe4a3, 0xeaf9, 0xe4db, 0xeaf4, 0xe4c7, 0xeb43, 0xe590, 0xeafe, 0xe50c,
0xeb5f, 0xe53f, 0xebfb, 0xe642, 0xeb51, 0xe54d, 0xea30, 0xe429, 0xea98, 0xe4af,
0xec45, 0xe436, 0xeb71, 0xe369, 0xea83, 0xe40d, 0xe9ff, 0xe3c2, 0xe9f9, 0xe388,
0xe977, 0xe349, 0xe979, 0xe32c, 0xe97b, 0xe300, 0xe8b8, 0xe244, 0xe7fd, 0xe26c,
0xe8b9, 0xe381, 0xe961, 0xe272, 0xe958, 0xe196, 0xe9f8, 0xe307, 0xe8d1, 0xe28d,
0xe878, 0xe235, 0xe8c7, 0xe261, 0xe8af, 0xe21a, 0xe8a1, 0xe213, 0xe895, 0xe1b0,
0xe8a0, 0xe1cf, 0xe89f, 0xe1c2, 0xe7ee, 0xe115, 0xe7d7, 0xe025, 0xe8e0, 0xe070,
0xe920, 0xe1fb, 0xe87b, 0xe2e2, 0xe86d, 0xe2b5, 0xe8a1, 0xe1c1, 0xe92b, 0xe1bc,
0xe8fb, 0xe1d4, 0xe8ad, 0xe1c6, 0xe877, 0xe1cc, 0xe7e1, 0xe1b7, 0xe861, 0xe199,
0xe8a4, 0xe21c, 0xe7d2, 0xe204, 0xe67a, 0xe082, 0xe67e, 0xe0b7, 0xe698, 0xe195,
0xe65e, 0xe14e, 0xe6e3, 0xe103, 0xe68d, 0xe146, 0xe5ea, 0xe155, 0xe5ca, 0xe134,
0xe5ab, 0xe134, 0xe5cc, 0xe15b, 0xe57d, 0xe0ce, 0xe4ef, 0xe037, 0xe514, 0xe0be,
0xe4b3, 0xe163, 0xe495, 0xe0c3, 0xe573, 0xe070, 0xe62f, 0xe118, 0xe606, 0xe1a8,
0xe584, 0xe170, 0xe570, 0xe133, 0xe5a2, 0xe11a, 0xe59b, 0xe12d, 0xe5da, 0xe136,
0xe5c0, 0xe161, 0xe64c, 0xe1b0, 0xe6c7, 0xe1b5, 0xe5f7, 0xe1ea, 0xe644, 0xe2af,
0xe733, 0xe1fb, 0xe694, 0xe19e, 0xe742, 0xe400, 0xe800, 0xe44f, 0xe85e, 0xe46e,
0xe858, 0xe490, 0xe88b, 0xe4e9, 0xe8ce, 0xe50e, 0xe8c5, 0xe54f, 0xe94d, 0xe5c2,
0xe9a6, 0xe55a, 0xe88d, 0xe4c4, 0xe76f, 0xe57a, 0xe9cc, 0xe738, 0xeb0b, 0xe63c,
0xe987, 0xe64b, 0xea08, 0xe6ca, 0xeb44, 0xe739, 0xeb47, 0xe777, 0xebc7, 0xe7e5,
0xec25, 0xe809, 0xec95, 0xe845, 0xecc5, 0xe874, 0xed81, 0xe90f, 0xedea, 0xe93e,
0xed6f, 0xe8ea, 0xef77, 0xeaf1, 0xf207, 0xebeb, 0xf210, 0xebef, 0xf062, 0xec78,
0xf120, 0xece0, 0xf1fc, 0xed15, 0xf204, 0xed9b, 0xf23c, 0xedd6, 0xf275, 0xee4b,
0xf2c0, 0xee4c, 0xf266, 0xee6a, 0xf33c, 0xeec3, 0xf3b4, 0xedb8, 0xf2b3, 0xed65,
0xf16e, 0xedc0, 0xf2c0, 0xee34, 0xf2c8, 0xedc1, 0xf2a4, 0xee3c, 0xf384, 0xee8c,
0xf3d0, 0xee9a, 0xf429, 0xef00, 0xf44f, 0xef0e, 0xf4cf, 0xef4a, 0xf55a, 0xeeed,
0xf504, 0xeeea, 0xf4cc, 0xefc1, 0xf579, 0xf11a, 0xf5ae, 0xf074, 0xf5c2, 0xf06d,
0xf609, 0xf0dd, 0xf661, 0xf15c, 0xf61d, 0xf179, 0xf644, 0xf18e, 0xf663, 0xf1a6,
0xf654, 0xf12c, 0xf65c, 0xf149, 0xf5bf, 0xf122, 0xf677, 0xf1c2, 0xf626, 0xf10c,
0xf584, 0xf0c6, 0xf4d5, 0xf033, 0xf5ef, 0xf061, 0xf5d4, 0xf058, 0xf4e3, 0xf08f,
0xf617, 0xf0f1, 0xf68e, 0xf102, 0xf6a4, 0xf1a4, 0xf6ab, 0xf1d4, 0xf6ec, 0xf26e,
0xf722, 0xf24a, 0xf77a, 0xf281, 0xf7d5, 0xf2ea, 0xf8ff, 0xf35a, 0xf7f3, 0xf31d,
0xf607, 0xf50e, 0xf789, 0xf578, 0xf8d6, 0xf3dc, 0xf7bc, 0xf41b, 0xf7ed, 0xf508,
0xf839, 0xf510, 0xf8c3, 0xf5b3, 0xf8f7, 0xf625, 0xf900, 0xf67f, 0xf906, 0xf643,
0xf916, 0xf689, 0xf93a, 0xf801, 0xf8e6, 0xf733, 0xf8e6, 0xf63a, 0xf8d1, 0xf7a5,
0xf9f3, 0xf84c, 0xf8ed, 0xf6fa, 0xf8cb, 0xf72a, 0xf908, 0xf757, 0xf921, 0xf7ac,
0xf92a, 0xf7ea, 0xf93c, 0xf85a, 0xf934, 0xf850, 0xf984, 0xf7fb, 0xf95d, 0xf8a7,
0xf905, 0xf980, 0xfaf5, 0xf8ed, 0xfbf0, 0xf95b, 0xfabb, 0xfb23, 0xfab0, 0xfb3c,
0xfbd7, 0xfb1d, 0xfbf7, 0xfb5c, 0xfc5e, 0xfbe7, 0xfc90, 0xfc20, 0xfce7, 0xfc56,
0xfd5c, 0xfc82, 0xfdf9, 0xfd5b, 0xfe0a, 0xfdc5, 0xfea2, 0xfd02, 0xfeb4, 0xfdaa,
0xfdd3, 0xfdfa, 0xfebb, 0xfe0b, 0xfe8c, 0xfdb0, 0xfeb7, 0xfdff, 0xfef4, 0xfe7a,
0xff62, 0xfed5, 0xffe1, 0xff5c, 0x0057, 0xffce, 0x0156, 0x006b, 0x01a1, 0x00ac,
0x00c8, 0x014b, 0x023a, 0x025d, 0x0417, 0x02db, 0x0299, 0x01bb, 0x0295, 0x0247,
0x0424, 0x03b8, 0x04bf, 0x0478, 0x0549, 0x04d9, 0x05aa, 0x0508, 0x0617, 0x057f,
0x0648, 0x05c4, 0x06d0, 0x0672, 0x0865, 0x06cf, 0x08a8, 0x0695, 0x081f, 0x0642,
0x091d, 0x076c, 0x0b70, 0x0949, 0x0bb3, 0x09d1, 0x0bfe, 0x0977, 0x0d2f, 0x09c0,
0x0d5e, 0x09be, 0x0d65, 0x0a4a, 0x0db1, 0x0aad, 0x0e1c, 0x0b13, 0x0e8e, 0x0b88,
0x0ea1, 0x0bcc, 0x0f48, 0x0cba, 0x1056, 0x0d41, 0x109c, 0x0e59, 0x1155, 0x0ee7,
0x1213, 0x0f62, 0x11df, 0x0efe, 0x1166, 0x0ede, 0x1234, 0x0f8f, 0x1264, 0x0fd1,
0x12ab, 0x1002, 0x12ac, 0x0fc7, 0x131b, 0x1012, 0x12c2, 0x0ff5, 0x1314, 0x0fe8,
0x1361, 0x0faa, 0x133a, 0x10da, 0x1388, 0x10f4, 0x1477, 0x1089, 0x14de, 0x10d4,
0x1495, 0x1196, 0x1595, 0x11ec, 0x1618, 0x11f5, 0x16ca, 0x1271, 0x16fd, 0x1296,
0x17e9, 0x1333, 0x1815, 0x135a, 0x17e2, 0x13cc, 0x18c0, 0x13b1, 0x1a80, 0x1328,
0x195b, 0x1484, 0x1817, 0x14e3, 0x191a, 0x13a9, 0x190a, 0x1325, 0x18a3, 0x13ea,
0x18b1, 0x140d, 0x192c, 0x13fb, 0x18e6, 0x1449, 0x1906, 0x147f, 0x18ef, 0x14c5,
0x193e, 0x14b1, 0x1908, 0x1449, 0x1885, 0x14b3, 0x18d3, 0x1588, 0x194f, 0x1530,
0x196d, 0x14aa, 0x19c8, 0x147e, 0x1a4a, 0x15d9, 0x1a37, 0x163d, 0x1ae0, 0x169f,
0x1b05, 0x16af, 0x1b22, 0x16ab, 0x1aed, 0x16a0, 0x1b42, 0x16e6, 0x1bad, 0x175f,
0x1b0b, 0x171a, 0x1ad9, 0x16e9, 0x1b0a, 0x175c, 0x1b3a, 0x173e, 0x1b3b, 0x167c,
0x1b7d, 0x170b, 0x1ad3, 0x16cf, 0x1a83, 0x16c5, 0x1a25, 0x16b6, 0x1a25, 0x16c8,
0x1a10, 0x1692, 0x19fe, 0x1699, 0x19c8, 0x1666, 0x1943, 0x15e7, 0x19ff, 0x15e6,
0x1a3b, 0x1701, 0x1a55, 0x16f3, 0x1afe, 0x1660, 0x1a48, 0x16b2, 0x19cf, 0x170d,
0x1a93, 0x17a7, 0x1a9b, 0x1793, 0x1adf, 0x17d6, 0x1ae5, 0x180a, 0x1ac1, 0x1857,
0x1a1a, 0x1850, 0x19e8, 0x18e6, 0x1b88, 0x18e8, 0x1bd6, 0x184c, 0x19bd, 0x1877,
0x193b, 0x191b, 0x1b16, 0x1920, 0x1abd, 0x191f, 0x19de, 0x18f4, 0x1a13, 0x18cb,
0x1a11, 0x1907, 0x1a07, 0x18ce, 0x1a06, 0x188f, 0x19f1, 0x1820, 0x1a51, 0x1828,
0x19b7, 0x17af, 0x196e, 0x17d2, 0x1993, 0x1811, 0x18de, 0x17a9, 0x195f, 0x1743,
0x1a07, 0x17c0, 0x1967, 0x180f, 0x1951, 0x17f2, 0x1997, 0x17e2, 0x19b4, 0x17e9,
0x1a16, 0x1801, 0x1a5a, 0x1826, 0x1a62, 0x180e, 0x19f8, 0x1859, 0x199a, 0x18e8,
0x1ac4, 0x17f2, 0x1ad8, 0x17f6, 0x1964, 0x1907, 0x1958, 0x18c0, 0x19c9, 0x1858,
0x190c, 0x188c, 0x18d6, 0x1876, 0x18e6, 0x1892, 0x18e8, 0x1885, 0x1904, 0x18ba,
0x1873, 0x18ad, 0x18e6, 0x185f, 0x1993, 0x184c, 0x192b, 0x1925, 0x184c, 0x1917,
0x18cd, 0x198c, 0x1944, 0x1962, 0x1974, 0x1855, 0x18cf, 0x18a1, 0x181d, 0x1812,
0x1800, 0x17d3, 0x177d, 0x170c, 0x1746, 0x1704, 0x1797, 0x1701, 0x1710, 0x1708,
0x15d5, 0x16ac, 0x16ca, 0x1688, 0x1947, 0x15cf, 0x17d3, 0x15f8, 0x15ec, 0x1689,
0x1664, 0x15dd, 0x16ca, 0x159b, 0x1672, 0x15a4, 0x1630, 0x15b3, 0x15e0, 0x1595,
0x15fa, 0x15ff, 0x159f, 0x15cc, 0x157a, 0x15bd, 0x15d8, 0x1576, 0x143c, 0x153c,
0x13ac, 0x1488, 0x140f, 0x1531, 0x13f1, 0x15a5, 0x13e5, 0x14fe, 0x1400, 0x14a4,
0x1395, 0x14e8, 0x135b, 0x14d8, 0x13b8, 0x1502, 0x1397, 0x14f6, 0x13b6, 0x1508,
0x13e5, 0x147f, 0x1410, 0x1433, 0x131c, 0x1570, 0x112b, 0x154d, 0x127a, 0x1360,
0x131f, 0x12eb, 0x11da, 0x141a, 0x120f, 0x1422, 0x125d, 0x13fe, 0x11f3, 0x13a0,
0x11fc, 0x13c2, 0x11b0, 0x136f, 0x11b3, 0x1360, 0x11d2, 0x135d, 0x1169, 0x137f,
0x1237, 0x1359, 0x128d, 0x1353, 0x1225, 0x1327, 0x11e0, 0x12d5, 0x1200, 0x133c,
0x11a0, 0x13df, 0x115c, 0x13f2, 0x1168, 0x13a4, 0x115f, 0x13c6, 0x10f9, 0x1394,
0x10c2, 0x1375, 0x103e, 0x1321, 0x0ff0, 0x133b, 0x1033, 0x1376, 0x0f80, 0x1270,
0x0f30, 0x1259, 0x0fd1, 0x1342, 0x0f17, 0x12dc, 0x0dc4, 0x1223, 0x0e12, 0x122a,
0x0e4e, 0x12c7, 0x0de7, 0x12af, 0x0df0, 0x12ab, 0x0dc3, 0x128c, 0x0db1, 0x1290,
0x0cda, 0x123b, 0x0cd1, 0x1270, 0x0da9, 0x1295, 0x0cda, 0x11f2, 0x0bd7, 0x1181,
0x0baa, 0x11bc, 0x0bd6, 0x11f9, 0x0aae, 0x10d8, 0x0ac0, 0x109b, 0x0ac3, 0x1046,
0x0a8c, 0x1048, 0x0a6c, 0x102b, 0x0a3c, 0x1020, 0x0a20, 0x0fcc, 0x09d0, 0x0fb7,
0x09c5, 0x100f, 0x0aea, 0x0f54, 0x0a67, 0x0f0c, 0x0873, 0x0f33, 0x08de, 0x0f42,
0x099c, 0x0f6b, 0x09dc, 0x0f50, 0x099c, 0x0efe, 0x09cc, 0x0ed7, 0x09c1, 0x0ebf,
0x09d9, 0x0ee3, 0x0986, 0x0ed4, 0x09f7, 0x0e4a, 0x0a64, 0x0e3a, 0x07dd, 0x0d81,
0x0854, 0x0d34, 0x097b, 0x0d5a, 0x0852, 0x0ce6, 0x077f, 0x0ce0, 0x07a3, 0x0d58,
0x077c, 0x0d4d, 0x0740, 0x0ce3, 0x074b, 0x0cd1, 0x071c, 0x0cb3, 0x06fe, 0x0cb5,
0x06ae, 0x0c6f, 0x0791, 0x0c1b, 0x07b6, 0x0bc5, 0x0536, 0x0b92, 0x0524, 0x0c55,
0x06bc, 0x0bac, 0x059c, 0x0a56, 0x0493, 0x0a09, 0x04e3, 0x0a39, 0x04e0, 0x099a,
0x0490, 0x0985, 0x04a5, 0x092e, 0x048e, 0x090a, 0x0467, 0x08c0, 0x0353, 0x08a2,
0x03c9, 0x0863, 0x04db, 0x07c0, 0x0379, 0x07c8, 0x022b, 0x086a, 0x0396, 0x087e,
0x0441, 0x0766, 0x0349, 0x07e1, 0x02ea, 0x0837, 0x02cf, 0x083b, 0x02a3, 0x0809,
0x026a, 0x0820, 0x0256, 0x0817, 0x02be, 0x0824, 0x01f6, 0x07f4, 0x00c9, 0x0877,
0x0201, 0x087e, 0x02f7, 0x0893, 0x0277, 0x08e4, 0x021b, 0x08b4, 0x0221, 0x08b3,
0x01cd, 0x085a, 0x01d5, 0x0851, 0x01c5, 0x07db, 0x0210, 0x07ee, 0x025e, 0x07bf,
0x021b, 0x081c, 0x0266, 0x078d, 0x0316, 0x07e3, 0x0319, 0x08c8, 0x037b, 0x0857,
0x043b, 0x0890, 0x0388, 0x097b, 0x0389, 0x0a04, 0x0444, 0x0a1c, 0x043d, 0x0a4f,
0x049e, 0x0a98, 0x04da, 0x0ae1, 0x053b, 0x0b1e, 0x0559, 0x0ba9, 0x05d5, 0x0c1b,
0x0604, 0x0b5c, 0x0540, 0x0bd2, 0x059c, 0x0cfb, 0x064e, 0x0c98, 0x0672, 0x0c31,
0x065a, 0x0ce8, 0x063e, 0x0cd5, 0x068e, 0x0ca9, 0x06d6, 0x0ce1, 0x06eb, 0x0cd4,
0x073a, 0x0d7a, 0x0774, 0x0d73, 0x0851, 0x0e44, 0x0853, 0x0e11, 0x0774, 0x0d38,
0x0781, 0x0dcd, 0x0821, 0x0e94, 0x086b, 0x0deb, 0x08fd, 0x0d34, 0x08c2, 0x0d50,
0x08af, 0x0d5d, 0x08cc, 0x0d44, 0x08b5, 0x0d24, 0x08b2, 0x0d0d, 0x083f, 0x0c99,
0x0815, 0x0c3a, 0x07aa, 0x0c4d, 0x088d, 0x0c4d, 0x08a8, 0x0b57, 0x06f3, 0x0b1d,
0x0735, 0x0b4d, 0x08b5, 0x0bc9, 0x082b, 0x0b45, 0x07bd, 0x0ae4, 0x078b, 0x0b09,
0x0783, 0x0b14, 0x0761, 0x0abf, 0x072c, 0x0aa3, 0x0790, 0x0ae3, 0x07e5, 0x0a94,
0x077a, 0x0aa2, 0x070d, 0x0aca, 0x0877, 0x0ac6, 0x085e, 0x0a5f, 0x06d6, 0x0a73,
0x0730, 0x0abd, 0x0774, 0x0a24, 0x0745, 0x0a10, 0x074d, 0x09fa, 0x0727, 0x09cf,
0x0741, 0x09a3, 0x06f5, 0x0990, 0x0746, 0x0a17, 0x0769, 0x09bc, 0x06a7, 0x0880,
0x06f0, 0x0903, 0x0766, 0x0990, 0x065a, 0x088a, 0x05eb, 0x0885, 0x0654, 0x08b6,
0x068b, 0x08a3, 0x0663, 0x0889, 0x063b, 0x0838, 0x0619, 0x0805, 0x0611, 0x07fe,
0x0517, 0x0775, 0x04a5, 0x07ca, 0x05ac, 0x0794, 0x04d0, 0x06f8, 0x03be, 0x0750,
0x0433, 0x0770, 0x03f2, 0x0684, 0x02ec, 0x0616, 0x0315, 0x064f, 0x033a, 0x0629,
0x0322, 0x0602, 0x0349, 0x05c6, 0x0339, 0x05c9, 0x038e, 0x0588, 0x0306, 0x0541,
0x0287, 0x0513, 0x0300, 0x04f5, 0x028b, 0x041a, 0x022c, 0x03ee, 0x0217, 0x044c,
0x0225, 0x042d, 0x01d7, 0x037e, 0x0171, 0x035a, 0x019f, 0x03a7, 0x0169, 0x0386,
0x01a8, 0x03d1, 0x0163, 0x03c7, 0x0170, 0x038a, 0x00d4, 0x0369, 0x004c, 0x0410,
0x0034, 0x0350, 0x0006, 0x02f8, 0xfffd, 0x0327, 0xff4f, 0x0320, 0xfefc, 0x02ff,
0xfe64, 0x02ab, 0xfe16, 0x0299, 0xfdd1, 0x0291, 0xfdab, 0x0281, 0xfd8f, 0x0222,
0xfd20, 0x0233, 0xfc60, 0x01dc, 0xfd03, 0x0173, 0xfcf7, 0xffe7, 0xfc90, 0x0032,
0xfcd2, 0x000e, 0xfc49, 0xffbe, 0xfbd4, 0xff8f, 0xfbb3, 0xff72, 0xfbd7, 0xff1a,
0xfbb0, 0xff04, 0xfba8, 0xff30, 0xfb92, 0xff21, 0xfb10, 0xff53, 0xf9b5, 0xfece,
0xf934, 0xff4e, 0xfb05, 0xff28, 0xface, 0xfdde, 0xf8b6, 0xfe47, 0xf925, 0xffd9,
0xfa12, 0xff2e, 0xf9b0, 0xff25, 0xf953, 0xff20, 0xf961, 0xfefa, 0xf948, 0xfee4,
0xf9a7, 0xfea0, 0xf95f, 0xfea3, 0xf8fc, 0xfea9, 0xf92f, 0xfde4, 0xf9d5, 0xfe2c,
0xf968, 0xfe91, 0xf871, 0xfe2b, 0xf8f7, 0xfdc8, 0xf8a9, 0xfd56, 0xf835, 0xfd08,
0xf809, 0xfca1, 0xf7d1, 0xfc6e, 0xf799, 0xfbea, 0xf780, 0xfbc8, 0xf740, 0xfb50,
0xf7c6, 0xfad4, 0xf658, 0xfade, 0xf47e, 0xfae0, 0xf5ab, 0xfa2c, 0xf737, 0xf9bf,
0xf5c1, 0xf9bf, 0xf452, 0xf9ad, 0xf4b6, 0xf92b, 0xf493, 0xf8c9, 0xf439, 0xf8ca,
0xf3fd, 0xf87e, 0xf444, 0xf899, 0xf3fe, 0xf871, 0xf34e, 0xf832, 0xf362, 0xf7cf,
0xf506, 0xf7f3, 0xf3e5, 0xf744, 0xf228, 0xf76b, 0xf2d3, 0xf77b, 0xf34c, 0xf6c1,
0xf29b, 0xf696, 0xf25a, 0xf620, 0xf225, 0xf5c8, 0xf1e8, 0xf5af, 0xf1ab, 0xf565,
0xf1a1, 0xf549, 0xf17c, 0xf4c6, 0xf11b, 0xf3c4, 0xf118, 0xf3b6, 0xef79, 0xf1dd,
0xee6a, 0xf250, 0xeecf, 0xf23d, 0xef06, 0xf0af, 0xede8, 0xf067, 0xedbb, 0xf0a4,
0xed56, 0xf036, 0xed2e, 0xefd6, 0xed18, 0xefc5, 0xece5, 0xef87, 0xec9e, 0xef71,
0xec05, 0xef32, 0xec91, 0xf033, 0xed05, 0xefd2, 0xec6b, 0xeed0, 0xec18, 0xef27,
0xecb8, 0xefdd, 0xec2b, 0xef41, 0xec06, 0xeefd, 0xebb8, 0xeedf, 0xeba5, 0xeecc,
0xeb89, 0xee7e, 0xeb58, 0xee53, 0xeb18, 0xee18, 0xea6c, 0xed84, 0xe97c, 0xed57,
0xe8cf, 0xed30, 0xe9fe, 0xed21, 0xe95a, 0xebf3, 0xe81b, 0xeba0, 0xe76e, 0xeb88,
0xe76d, 0xeb2e, 0xe774, 0xeaad, 0xe71c, 0xea69, 0xe731, 0xea64, 0xe6f7, 0xea3d,
0xe70e, 0xe9c7, 0xe6b9, 0xe960, 0xe636, 0xe948, 0xe5f5, 0xe8fe, 0xe5f5, 0xe8cc,
0xe517, 0xe8b9, 0xe4f6, 0xe8eb, 0xe58a, 0xe8c4, 0xe515, 0xe8dd, 0xe46f, 0xe8ac,
0xe45e, 0xe8b4, 0xe42c, 0xe891, 0xe40e, 0xe8bd, 0xe3b9, 0xe89b, 0xe3c7, 0xe8dc,
0xe34b, 0xe8a3, 0xe348, 0xe86f, 0xe3c4, 0xe830, 0xe3be, 0xe879, 0xe355, 0xe8c2,
0xe2ac, 0xe7d4, 0xe2c9, 0xe7af, 0xe286, 0xe72b, 0xe284, 0xe6f8, 0xe25b, 0xe671,
0xe251, 0xe675, 0xe220, 0xe633, 0xe1f3, 0xe5fb, 0xe200, 0xe58b, 0xe276, 0xe5c7,
0xe2cc, 0xe6b7, 0xe1f1, 0xe68a, 0xe1df, 0xe6a8, 0xe268, 0xe692, 0xe302, 0xe6b0,
0xe319, 0xe6ce, 0xe2d0, 0xe6f6, 0xe2f2, 0xe720, 0xe361, 0xe75a, 0xe38e, 0xe76d,
0xe3f4, 0xe72a, 0xe420, 0xe741, 0xe393, 0xe8a0, 0xe425, 0xe890, 0xe4c4, 0xe79d,
0xe42a, 0xe7bc, 0xe39d, 0xe88e, 0xe44b, 0xe85f, 0xe401, 0xe80d, 0xe3f4, 0xe851,
0xe416, 0xe7f6, 0xe454, 0xe815, 0xe499, 0xe7c6, 0xe4ba, 0xe7df, 0xe53d, 0xe7f5,
0xe544, 0xe7df, 0xe568, 0xe820, 0xe5fd, 0xe8ae, 0xe65b, 0xe873, 0xe64f, 0xe860,
0xe629, 0xe8c3, 0xe67b, 0xe871, 0xe704, 0xe8dd, 0xe705, 0xe916, 0xe75d, 0xe94e,
0xe77d, 0xe945, 0xe79b, 0xe9c2, 0xe7e2, 0xe98f, 0xe7c8, 0xe943, 0xe74d, 0xe9b6,
0xe6fb, 0xe9c4, 0xe74b, 0xe979, 0xe71f, 0xe9d7, 0xe775, 0xe9d7, 0xe837, 0xe9c8,
0xe843, 0xe9ca, 0xe834, 0xe9be, 0xe849, 0xe9d1, 0xe87b, 0xe9e6, 0xe87f, 0xe9e8,
0xe8d2, 0xe9f5, 0xe8d4, 0xe9c7, 0xe92b, 0xe953, 0xe8f7, 0xe92b, 0xe91f, 0xe985,
0xe9b2, 0xe9bf, 0xe93e, 0xe9df, 0xe95e, 0xe995, 0xe9a8, 0xe98d, 0xe9bf, 0xe9c9,
0xe9ac, 0xe99a, 0xe9ae, 0xe9b1, 0xe973, 0xe9b3, 0xe99e, 0xe9bb, 0xe93e, 0xe9c5,
0xe953, 0xe9bd, 0xe952, 0xe999, 0xe957, 0xe984, 0xe881, 0xe8eb, 0xe85c, 0xe96d,
0xe894, 0xe9bb, 0xe91d, 0xe998, 0xe959, 0xe937, 0xe925, 0xe949, 0xe957, 0xe95e,
0xe950, 0xe96a, 0xe992, 0xe96b, 0xe9b0, 0xe979, 0xe952, 0xea83, 0xe8f7, 0xeaeb,
0xea80, 0xea86, 0xeae5, 0xe9e6, 0xeabf, 0xeaaa, 0xeb01, 0xeb0e, 0xeb64, 0xeb3b,
0xeb38, 0xeb39, 0xeb67, 0xeb7f, 0xeb96, 0xebad, 0xeb84, 0xebaf, 0xeba2, 0xebba,
0xeb4a, 0xeb5b, 0xeb46, 0xeb84, 0xea98, 0xeb8d, 0xeae0, 0xeb8d, 0xeb5d, 0xeb84,
0xeb41, 0xebca, 0xeaad, 0xebbd, 0xeaa0, 0xebfa, 0xeaa8, 0xebe6, 0xeb15, 0xebc0,
0xeb99, 0xebc7, 0xebb7, 0xebf0, 0xec87, 0xec9d, 0xecac, 0xecba, 0xed1e, 0xed01,
0xecd7, 0xed50, 0xee0b, 0xee0d, 0xeeb5, 0xedd9, 0xeea9, 0xef0a, 0xeec2, 0xef32,
0xede2, 0xeeb0, 0xedbc, 0xeedf, 0xeda9, 0xeee9, 0xee16, 0xef29, 0xee70, 0xef55,
0xeeb4, 0xef90, 0xeebc, 0xefa9, 0xeefb, 0xefdb, 0xef91, 0xf023, 0xef89, 0xf084,
0xef2f, 0xf065, 0xefdc, 0xf11e, 0xefd9, 0xf0b8, 0xefad, 0xf05e, 0xf03a, 0xf0e8,
0xf0ec, 0xf172, 0xf1a0, 0xf1f4, 0xf1df, 0xf226, 0xf232, 0xf287, 0xf269, 0xf2cb,
0xf288, 0xf294, 0xf2cc, 0xf2f4, 0xf2dc, 0xf2e7, 0xf338, 0xf281, 0xf3a8, 0xf25d,
0xf3df, 0xf2a7, 0xf48f, 0xf330, 0xf4c5, 0xf38e, 0xf529, 0xf3ee, 0xf56a, 0xf424,
0xf5b9, 0xf46d, 0xf618, 0xf498, 0xf65b, 0xf4ce, 0xf68f, 0xf515, 0xf6d0, 0xf52d,
0xf7a1, 0xf568, 0xf764, 0xf596, 0xf70e, 0xf5ed, 0xf872, 0xf6bb, 0xf9a3, 0xf63f,
0xf87d, 0xf5e4, 0xf7ee, 0xf6cf, 0xf87b, 0xf6d2, 0xf921, 0xf6f6, 0xf9ab, 0xf6ff,
0xf9fb, 0xf715, 0xfa15, 0xf725, 0xfaac, 0xf742, 0xfb95, 0xf761, 0xfb98, 0xf822,
0xfb8d, 0xf790, 0xfb8f, 0xf74b, 0xfc19, 0xf8a7, 0xfcf6, 0xf8a9, 0xfda4, 0xf912,
0xfd91, 0xf949, 0xfdfd, 0xf9e8, 0xfe3e, 0xf9f4, 0xfe45, 0xf9dd, 0xfe89, 0xfa06,
0xfeba, 0xfa87, 0xfeb7, 0xfa50, 0xfec9, 0xfa83, 0xff79, 0xfb13, 0xff79, 0xfaeb,
0xff20, 0xfb13, 0x005f, 0xfbaf, 0x00ec, 0xfb81, 0x0075, 0xfb1a, 0x009d, 0xfb51,
0x009e, 0xfafa, 0x00bf, 0xfb22, 0x00b7, 0xfb2b, 0x00d9, 0xfb8b, 0x0104, 0xfb66,
0x0180, 0xfb01, 0x01bc, 0xfb39, 0x01b3, 0xfbfc, 0x01c8, 0xfc23, 0x0219, 0xfbd1,
0x0260, 0xfc60, 0x02d4, 0xfc7b, 0x0337, 0xfc83, 0x0344, 0xfcad, 0x0396, 0xfccf,
0x03ab, 0xfcdd, 0x0403, 0xfce2, 0x03f3, 0xfd14, 0x03aa, 0xfcd2, 0x046f, 0xfc7f,
0x0543, 0xfc5a, 0x047c, 0xfcce, 0x0475, 0xfd6b, 0x0556, 0xfd67, 0x054e, 0xfd60,
0x052d, 0xfd87, 0x058a, 0xfdd9, 0x05b4, 0xfddc, 0x05ea, 0xfdb3, 0x05ee, 0xfd96,
0x063d, 0xfdc2, 0x063e, 0xfe3b, 0x0694, 0xfe55, 0x06f9, 0xfe36, 0x072a, 0xfea1,
0x06af, 0xfe4a, 0x063d, 0xfec2, 0x06d0, 0xff32, 0x065a, 0xfe56, 0x0655, 0xfe54,
0x0623, 0xfe6d, 0x0633, 0xfe99, 0x0616, 0xfe75, 0x0615, 0xfe67, 0x0589, 0xfe0c,
0x05a8, 0xfdd4, 0x054c, 0xfd9e, 0x054e, 0xfe68, 0x053d, 0xfe11, 0x052d, 0xfd64,
0x0571, 0xfdfc, 0x05d0, 0xfe4c, 0x05e8, 0xfdf6, 0x05e3, 0xfe04, 0x062f, 0xfe68,
0x0661, 0xfe7e, 0x06a5, 0xff10, 0x0654, 0xff5f, 0x06e8, 0xff93, 0x073a, 0xff5f,
0x075f, 0xffc9, 0x0785, 0x0068, 0x0841, 0x003a, 0x07e6, 0x0001, 0x07de, 0x00f7,
0x083e, 0x00b4, 0x07df, 0x0065, 0x07d4, 0x0085, 0x07c3, 0x0064, 0x07ef, 0x0078,
0x07ec, 0x0079, 0x07bd, 0x00c4, 0x07a6, 0x00f8, 0x07de, 0x0054, 0x07fc, 0x00ac,
0x0807, 0x012d, 0x082c, 0x00ae, 0x081b, 0x00b1, 0x07e5, 0x00a7, 0x0816, 0x00a8,
0x0836, 0x00d8, 0x084e, 0x00d9, 0x08be, 0x00cf, 0x08fd, 0x00fd, 0x0996, 0x0106,
0x0976, 0x00ec, 0x08c2, 0x016d, 0x092f, 0x015a, 0x09ce, 0x0200, 0x097b, 0x0260,
0x094a, 0x0184, 0x0961, 0x010e, 0x098c, 0x0136, 0x09a2, 0x0159, 0x095d, 0x00f3,
0x095a, 0x00fb, 0x097c, 0x0115, 0x0965, 0x010e, 0x09e6, 0x0140, 0x09c3, 0x0140,
0x09a8, 0x0193, 0x09d5, 0x014a, 0x09cb, 0x011f, 0x09da, 0x01ab, 0x09dd, 0x01e8,
0x09ec, 0x017c, 0x09a1, 0x0184, 0x09a3, 0x019c, 0x0999, 0x016c, 0x09b4, 0x015d,
0x0995, 0x010c, 0x0996, 0x011e, 0x0a6b, 0x00d4, 0x0a01, 0x00b7, 0x08e4, 0xffe5,
0x0a56, 0x008b, 0x0a58, 0x006c, 0x091c, 0xffca, 0x099a, 0x000c, 0x09cb, 0x0036,
0x09d5, 0x0027, 0x09e9, 0x0012, 0x0a81, 0x0038, 0x0aa0, 0x0035, 0x0a84, 0x0064,
0x0a88, 0x00f6, 0x0b55, 0x0202, 0x0ac5, 0x0191, 0x0a33, 0x0164, 0x0b37, 0x0152,
0x0b2b, 0x0160, 0x0ac3, 0x019b, 0x0b26, 0x01f8, 0x0b57, 0x0239, 0x0b4b, 0x0218,
0x0b5c, 0x021f, 0x0b44, 0x023c, 0x0ba0, 0x0272, 0x0aa8, 0x0246, 0x0af3, 0x02db,
0x0bce, 0x038a, 0x0b1e, 0x02f1, 0x0ae4, 0x029d, 0x0bf6, 0x02e0, 0x0be0, 0x0374,
0x0bad, 0x03ae, 0x0b73, 0x039b, 0x0b91, 0x03cc, 0x0b77, 0x03cb, 0x0b7f, 0x0401,
0x0b89, 0x0413, 0x0be0, 0x03cf, 0x0c06, 0x0410, 0x0b99, 0x04ec, 0x0d1f, 0x05da,
0x0d39, 0x05be, 0x0d02, 0x060e, 0x0d62, 0x0619, 0x0d5e, 0x061b, 0x0d4f, 0x061a,
0x0d4c, 0x0669, 0x0d52, 0x06a5, 0x0d64, 0x067a, 0x0d5c, 0x0649, 0x0dc2, 0x066c,
0x0dc0, 0x06f9, 0x0cf7, 0x06ac, 0x0d94, 0x06c4, 0x0eb9, 0x06ed, 0x0de6, 0x06bb,
0x0d84, 0x0673, 0x0e11, 0x06d6, 0x0e67, 0x070f, 0x0e4f, 0x06f1, 0x0e98, 0x0789,
0x0e9c, 0x0792, 0x0e99, 0x07c0, 0x0e82, 0x0805, 0x0e6b, 0x0796, 0x0e77, 0x0737,
0x0dc4, 0x077b, 0x0dc2, 0x079f, 0x0dcf, 0x0835, 0x0de6, 0x08a5, 0x0dac, 0x08ac,
0x0db9, 0x08aa, 0x0dcd, 0x08c5, 0x0dd4, 0x08c7, 0x0da4, 0x08ca, 0x0d98, 0x090f,
0x0e33, 0x0950, 0x0ea0, 0x0940, 0x0ee0, 0x09bf, 0x0f1c, 0x09c9, 0x0e05, 0x09a6,
0x0d63, 0x099d, 0x0e10, 0x0983, 0x0eb7, 0x0975, 0x0e63, 0x0962, 0x0e4e, 0x0990,
0x0ea0, 0x0936, 0x0eaa, 0x093c, 0x0ea8, 0x08ff, 0x0eba, 0x090e, 0x0f18, 0x08e2,
0x0e9c, 0x0903, 0x0d7e, 0x0925, 0x0e70, 0x08fe, 0x0f88, 0x08bf, 0x0ea7, 0x0908,
0x0eee, 0x0918, 0x0f61, 0x091b, 0x0fa0, 0x09ec, 0x0fbd, 0x09ed, 0x0fdb, 0x0a6a,
0x0fee, 0x0a6f, 0x0fac, 0x0ab8, 0x0f72, 0x0b04, 0x103c, 0x0b10, 0x1080, 0x0aa6,
0x0f5e, 0x0afe, 0x0f9d, 0x0ba7, 0x100b, 0x0b97, 0x0fb4, 0x0b24, 0x0f39, 0x0af1,
0x0f4c, 0x0b0b, 0x0f31, 0x0a9c, 0x0f57, 0x0ab8, 0x0f4c, 0x0abd, 0x0f5d, 0x0ab9,
0x0f92, 0x0a76, 0x0f74, 0x0ada, 0x0f78, 0x0b38, 0x0f8e, 0x0ab0, 0x0fab, 0x0b05,
0x0f6c, 0x0bef, 0x0f55, 0x0ba5, 0x0fc8, 0x0b54, 0x0f75, 0x0b31, 0x0f63, 0x0b50,
0x0fce, 0x0b48, 0x0fdb, 0x0b75, 0x104f, 0x0c0a, 0x1058, 0x0c3e, 0x1078, 0x0cd6,
0x1021, 0x0cce, 0x104f, 0x0d31, 0x11b1, 0x0d47, 0x11bc, 0x0d9f, 0x1101, 0x0e1b,
0x1136, 0x0dee, 0x1189, 0x0dff, 0x119a, 0x0e67, 0x11a9, 0x0eb0, 0x11e8, 0x0ed9,
0x1223, 0x0f06, 0x12d2, 0x0f6a, 0x12cf, 0x0fb9, 0x1325, 0x100d, 0x140a, 0x108d,
0x139e, 0x119e, 0x130e, 0x113f, 0x12cd, 0x109c, 0x1324, 0x114c, 0x1339, 0x119c,
0x1398, 0x11bc, 0x13bb, 0x11d7, 0x13fb, 0x1214, 0x140f, 0x11dd, 0x144e, 0x11dc,
0x14a9, 0x11ee, 0x1449, 0x1262, 0x146f, 0x1230, 0x1529, 0x11c6, 0x1515, 0x127f,
0x147d, 0x12fc, 0x1533, 0x12de, 0x15a6, 0x131b, 0x15e4, 0x1394, 0x15ee, 0x13a2,
0x1644, 0x141f, 0x1661, 0x1457, 0x16d1, 0x148f, 0x16ea, 0x1494, 0x171a, 0x1512,
0x1757, 0x1552, 0x175e, 0x1514, 0x1764, 0x14d1, 0x16cb, 0x14a1, 0x1687, 0x14f7,
0x168b, 0x1460, 0x16c7, 0x144b, 0x172f, 0x1499, 0x1749, 0x148b, 0x17b7, 0x1534,
0x17b9, 0x1550, 0x1788, 0x15cc, 0x176d, 0x1596, 0x174c, 0x154d, 0x17aa, 0x1565,
0x176a, 0x14b3, 0x1757, 0x14a5, 0x1746, 0x1451, 0x173d, 0x140a, 0x16fb, 0x13b9,
0x16f1, 0x13cd, 0x1728, 0x138d, 0x1716, 0x1372, 0x16ab, 0x1341, 0x16a7, 0x134a,
0x1729, 0x1364, 0x174f, 0x135f, 0x169a, 0x13cb, 0x166e, 0x13c9, 0x16ec, 0x1369,
0x16e3, 0x12f5, 0x1679, 0x12f1, 0x167a, 0x130b, 0x169d, 0x136e, 0x1692, 0x1372,
0x16ac, 0x13ad, 0x16a2, 0x13ab, 0x167b, 0x1361, 0x162b, 0x12fc, 0x15f0, 0x12e2,
0x161d, 0x1329, 0x1684, 0x12e8, 0x1655, 0x12c9, 0x1652, 0x12b1, 0x1644, 0x12a2,
0x1659, 0x128f, 0x1644, 0x12a8, 0x1650, 0x12ec, 0x163b, 0x12c2, 0x164e, 0x12de,
0x1638, 0x12b8, 0x1622, 0x131f, 0x15e7, 0x12f6, 0x15ff, 0x12a2, 0x1656, 0x12c0,
0x15b2, 0x12dc, 0x1514, 0x12a7, 0x149f, 0x1204, 0x1479, 0x1215, 0x1412, 0x11cd,
0x1417, 0x11a2, 0x139a, 0x1130, 0x135e, 0x10ff, 0x130c, 0x10bd, 0x1318, 0x10a7,
0x133e, 0x10ca, 0x1276, 0x10af, 0x124f, 0x103e, 0x12ba, 0x107a, 0x12cf, 0x1001,
0x1255, 0x0fce, 0x11fc, 0x0fd2, 0x11f5, 0x0fc7, 0x1166, 0x0f30, 0x1133, 0x0f0d,
0x110c, 0x0eca, 0x10dd, 0x0ed5, 0x10b3, 0x0eb3, 0x1070, 0x0e92, 0x107d, 0x0e9d,
0x1087, 0x0e1d, 0x1032, 0x0e5b, 0x100b, 0x0ee4, 0x108a, 0x0f19, 0x1067, 0x0eb5,
0x10cf, 0x0f53, 0x1088, 0x0f68, 0x1077, 0x0fcb, 0x104e, 0x0fa5, 0x1011, 0x0fdb,
0x0fdc, 0x0fc1, 0x0fa0, 0x0fa1, 0x0f3d, 0x0f58, 0x0eda, 0x0f1a, 0x0f35, 0x0f39,
0x0e9b, 0x0f64, 0x0de2, 0x0f24, 0x0d27, 0x0e43, 0x0d3b, 0x0e26, 0x0c90, 0x0d5e,
0x0c5b, 0x0d3d, 0x0c18, 0x0cba, 0x0c08, 0x0c8d, 0x0bd2, 0x0c22, 0x0bb2, 0x0bf0,
0x0b96, 0x0c1a, 0x0b7a, 0x0c92, 0x0ba5, 0x0c18, 0x0b3f, 0x0b65, 0x0b27, 0x0be6,
0x0ad6, 0x0bb7, 0x0ae3, 0x0b33, 0x0aea, 0x0b44, 0x0ae1, 0x0ae9, 0x0aa4, 0x0aaf,
0x0aac, 0x0ad6, 0x0a85, 0x0ab8, 0x0a38, 0x0ab6, 0x09f4, 0x0a69, 0x0a33, 0x0a39,
0x09f7, 0x0a05, 0x08c5, 0x0a01, 0x08b4, 0x09d7, 0x0904, 0x09e0, 0x08b4, 0x09bf,
0x084c, 0x09a3, 0x0819, 0x097b, 0x07f9, 0x0920, 0x07d3, 0x08ee, 0x07fb, 0x0916,
0x07af, 0x08f6, 0x0741, 0x08ec, 0x06e6, 0x08d9, 0x0742, 0x08b1, 0x0731, 0x086d,
0x061e, 0x07e9, 0x062d, 0x07de, 0x05be, 0x07a5, 0x0566, 0x075c, 0x0571, 0x072a,
0x052e, 0x0718, 0x04db, 0x0690, 0x049a, 0x065c, 0x0414, 0x05fb, 0x03e4, 0x05c2,
0x03ac, 0x0549, 0x03ec, 0x0518, 0x0422, 0x04ec, 0x0316, 0x0502, 0x0377, 0x055c,
0x0439, 0x04ef, 0x0406, 0x0510, 0x0352, 0x04f3, 0x037e, 0x054b, 0x0359, 0x0534,
0x0385, 0x052d, 0x0351, 0x04f7, 0x034b, 0x04df, 0x0343, 0x04ce, 0x0270, 0x04de,
0x0288, 0x0473, 0x0259, 0x0357, 0x0188, 0x0344, 0x0099, 0x0343, 0x0103, 0x031f,
0x00d1, 0x02ff, 0x0086, 0x02e5, 0x00f8, 0x0359, 0x00e2, 0x0357, 0x00c6, 0x037b,
0x006a, 0x0344, 0x0027, 0x0311, 0x009a, 0x02e9, 0x002b, 0x021c, 0xff39, 0x022f,
0xff35, 0x0194, 0xff72, 0x017c, 0xff2e, 0x00e6, 0xfee2, 0x0090, 0xff19, 0x0060,
0xfeee, 0x002b, 0xfeb4, 0x0042, 0xfe70, 0x0009, 0xfe4b, 0x0004, 0xfe11, 0xffe1,
0xfde2, 0x002d, 0xfdee, 0xffd0, 0xfd46, 0xffcb, 0xfce2, 0x0023, 0xfc68, 0xff98,
0xfbee, 0xff49, 0xfbdc, 0xffb8, 0xfbea, 0xff82, 0xfb76, 0xff48, 0xfb3d, 0xff35,
0xfb03, 0xff07, 0xfab2, 0xfed2, 0xfa6b, 0xfe79, 0xfa25, 0xfea1, 0xfa13, 0xfe67,
0xf9e9, 0xfe32, 0xfa16, 0xfe65, 0xfa4c, 0xfdec, 0xfa79, 0xfe56, 0xf9ce, 0xfea6,
0xfa0b, 0xfea2, 0xf9f5, 0xfe90, 0xf9ed, 0xfe97, 0xf9c8, 0xfe7e, 0xf9cc, 0xfeca,
0xf9af, 0xfeb0, 0xf951, 0xfed0, 0xf952, 0xfead, 0xf90e, 0xfe29, 0xf860, 0xfe44,
0xf7c1, 0xfdb6, 0xf838, 0xfd40, 0xf73b, 0xfc63, 0xf6f3, 0xfc7e, 0xf6e9, 0xfc90,
0xf6bd, 0xfc7b, 0xf6bc, 0xfc9d, 0xf69f, 0xfca5, 0xf68d, 0xfcd2, 0xf6b1, 0xfcc2,
0xf687, 0xfcf1, 0xf66e, 0xfce3, 0xf700, 0xfca3, 0xf6c3, 0xfc85, 0xf6ce, 0xfcdc,
0xf6e5, 0xfcd3, 0xf6eb, 0xfcf9, 0xf6c2, 0xfcec, 0xf6d7, 0xfcf9, 0xf6cb, 0xfcf9,
0xf69b, 0xfc7d, 0xf68a, 0xfc79, 0xf638, 0xfc04, 0xf61a, 0xfc14, 0xf612, 0xfbe6,
0xf630, 0xfbd6, 0xf5e3, 0xfc0f, 0xf5cc, 0xfbdf, 0xf654, 0xfc77, 0xf640, 0xfc7d,
0xf5a5, 0xfc6f, 0xf5a1, 0xfc45, 0xf59a, 0xfc14, 0xf5a1, 0xfc02, 0xf5bd, 0xfbbe,
0xf5ac, 0xfbbf, 0xf5a3, 0xfbf0, 0xf5b2, 0xfbb5, 0xf61e, 0xfbda, 0xf636, 0xfbff,
0xf5e8, 0xfb78, 0xf5a6, 0xfb50, 0xf5fd, 0xfb5a, 0xf5e7, 0xfb21, 0xf592, 0xfabf,
0xf59d, 0xfab6, 0xf579, 0xfa44, 0xf567, 0xfa43, 0xf53c, 0xfa0b, 0xf52e, 0xf9f6,
0xf540, 0xf9ea, 0xf52a, 0xf998, 0xf57b, 0xf9f3, 0xf56f, 0xfa04, 0xf50a, 0xf9f5,
0xf531, 0xf9b5, 0xf59d, 0xf99d, 0xf589, 0xf9b9, 0xf548, 0xf9bc, 0xf52f, 0xf98e,
0xf55e, 0xf9a7, 0xf54d, 0xf99a, 0xf588, 0xfa35, 0xf52d, 0xf9f1, 0xf4a0, 0xf99d,
0xf519, 0xf9e6, 0xf4e0, 0xf9c9, 0xf44d, 0xf957, 0xf398, 0xf920, 0xf40f, 0xf92f,
0xf419, 0xf8b4, 0xf3c5, 0xf8ad, 0xf3ee, 0xf90b, 0xf3dd, 0xf8ee, 0xf3e3, 0xf8d0,
0xf3b9, 0xf8bb, 0xf32b, 0xf850, 0xf365, 0xf807, 0xf2bf, 0xf77f, 0xf21c, 0xf788,
0xf2c5, 0xf7bc, 0xf302, 0xf7f8, 0xf2b3, 0xf82e, 0xf277, 0xf7c7, 0xf2c1, 0xf7de,
0xf2c0, 0xf7e2, 0xf2fd, 0xf7e2, 0xf2e0, 0xf7e5, 0xf2e4, 0xf797, 0xf2c2, 0xf792,
0xf325, 0xf792, 0xf311, 0xf76b, 0xf31c, 0xf7b7, 0xf349, 0xf7be, 0xf2e1, 0xf7c2,
0xf28c, 0xf7d8, 0xf2a0, 0xf809, 0xf2d9, 0xf7df, 0xf2b4, 0xf7be, 0xf2a3, 0xf7cd,
0xf261, 0xf7b1, 0xf261, 0xf79d, 0xf263, 0xf7bd, 0xf24b, 0xf7b9, 0xf1f6, 0xf7b4,
0xf235, 0xf7ce, 0xf295, 0xf7c7, 0xf1f8, 0xf7c8, 0xf136, 0xf7ca, 0xf192, 0xf791,
0xf165, 0xf774, 0xf13d, 0xf7a8, 0xf126, 0xf7a6, 0xf114, 0xf7a4, 0xf133, 0xf7ab,
0xf123, 0xf7ed, 0xf1bb, 0xf7c0, 0xf1cd, 0xf77e, 0xf1bd, 0xf730, 0xf1dc, 0xf7ad,
0xf1e5, 0xf7a5, 0xf169, 0xf783, 0xf1dc, 0xf783, 0xf244, 0xf7ae, 0xf2aa, 0xf823,
0xf2b2, 0xf813, 0xf275, 0xf834, 0xf26f, 0xf85a, 0xf23d, 0xf887, 0xf253, 0xf875,
0xf216, 0xf87e, 0xf24d, 0xf865, 0xf215, 0xf819, 0xf152, 0xf814, 0xf0e9, 0xf8bf,
0xf17d, 0xf8da, 0xf1be, 0xf8be, 0xf195, 0xf8ad, 0xf203, 0xf904, 0xf207, 0xf902,
0xf259, 0xf936, 0xf26f, 0xf917, 0xf26f, 0xf8a6, 0xf261, 0xf8a8, 0xf233, 0xf7ea,
0xf1fa, 0xf7d2, 0xf1e9, 0xf80b, 0xf292, 0xf84c, 0xf30f, 0xf82c, 0xf2d5, 0xf825,
0xf270, 0xf7c7, 0xf26a, 0xf7bb, 0xf22f, 0xf7b9, 0xf222, 0xf7a5, 0xf23c, 0xf7ac,
0xf258, 0xf7ae, 0xf246, 0xf7e9, 0xf223, 0xf811, 0xf2c1, 0xf8af, 0xf318, 0xf8a1,
0xf2e8, 0xf8b2, 0xf2e4, 0xf883, 0xf36e, 0xf882, 0xf375, 0xf89a, 0xf39e, 0xf86b,
0xf3b4, 0xf862, 0xf326, 0xf804, 0xf332, 0xf806, 0xf315, 0xf795, 0xf338, 0xf783,
0xf39d, 0xf7eb, 0xf3a2, 0xf7e5, 0xf367, 0xf7d4, 0xf32f, 0xf82a, 0xf355, 0xf7e1,
0xf386, 0xf781, 0xf399, 0xf7bf, 0xf3c0, 0xf7c8, 0xf37b, 0xf7b4, 0xf35b, 0xf7a0,
0xf375, 0xf786, 0xf39f, 0xf79f, 0xf421, 0xf821, 0xf3fd, 0xf7f6, 0xf3ed, 0xf7d0,
0xf461, 0xf7e9, 0xf483, 0xf82d, 0xf3e7, 0xf806, 0xf35a, 0xf812, 0xf3eb, 0xf80d,
0xf3d5, 0xf799, 0xf38c, 0xf7a1, 0xf367, 0xf797, 0xf36e, 0xf76e, 0xf394, 0xf72d,
0xf37b, 0xf717, 0xf372, 0xf728, 0xf3c1, 0xf729, 0xf3a6, 0xf6c7, 0xf359, 0xf6db,
0xf3ab, 0xf775, 0xf376, 0xf73a, 0xf367, 0xf6c9, 0xf3c9, 0xf719, 0xf403, 0xf73c,
0xf3e4, 0xf730, 0xf3f6, 0xf74a, 0xf3f4, 0xf74a, 0xf421, 0xf745, 0xf42c, 0xf70e,
0xf3b5, 0xf732, 0xf400, 0xf78f, 0xf4ae, 0xf716, 0xf46b, 0xf69d, 0xf41d, 0xf6fb,
0xf495, 0xf725, 0xf473, 0xf6d1, 0xf436, 0xf6d3, 0xf426, 0xf6fd, 0xf419, 0xf6ff,
0xf440, 0xf6f9, 0xf422, 0xf6e9, 0xf3f0, 0xf6a4, 0xf3f8, 0xf657, 0xf39e, 0xf661,
0xf3a2, 0xf6e6, 0xf425, 0xf6a9, 0xf439, 0xf674, 0xf425, 0xf6f6, 0xf40b, 0xf6e7,
0xf460, 0xf73d, 0xf459, 0xf759, 0xf483, 0xf79a, 0xf477, 0xf77a, 0xf44a, 0xf7d2,
0xf451, 0xf7f8, 0xf43c, 0xf7e1, 0xf3e4, 0xf7c1, 0xf2e9, 0xf75a, 0xf339, 0xf7ad,
0xf31d, 0xf75f, 0xf304, 0xf723, 0xf2a2, 0xf6ef, 0xf2c1, 0xf718, 0xf276, 0xf69c,
0xf265, 0xf698, 0xf29d, 0xf665, 0xf28c, 0xf666, 0xf2d4, 0xf677, 0xf27d, 0xf689,
0xf2d7, 0xf765, 0xf358, 0xf701, 0xf339, 0xf70c, 0xf28a, 0xf783, 0xf32a, 0xf722,
0xf36e, 0xf6f3, 0xf2cb, 0xf6b7, 0xf2c0, 0xf6ca, 0xf293, 0xf6bb, 0xf28a, 0xf6c6,
0xf247, 0xf6c8, 0xf256, 0xf6c3, 0xf22c, 0xf6e4, 0xf1dc, 0xf6ba, 0xf239, 0xf708,
0xf2a2, 0xf70c, 0xf2ae, 0xf739, 0xf272, 0xf794, 0xf25c, 0xf7bd, 0xf241, 0xf761,
0xf228, 0xf762, 0xf228, 0xf763, 0xf238, 0xf741, 0xf23b, 0xf73e, 0xf2ae, 0xf720,
0xf2ad, 0xf70e, 0xf309, 0xf6f3, 0xf30b, 0xf736, 0xf32f, 0xf6d3, 0xf31f, 0xf672,
0xf25f, 0xf5a7, 0xf29f, 0xf5ef, 0xf214, 0xf5b4, 0xf208, 0xf597, 0xf1fa, 0xf593,
0xf203, 0xf57c, 0xf250, 0xf5a4, 0xf255, 0xf5a4, 0xf2c1, 0xf655, 0xf2cd, 0xf654,
0xf2f7, 0xf618, 0xf2ba, 0xf645, 0xf2b7, 0xf6dd, 0xf2db, 0xf655, 0xf2ab, 0xf62c,
0xf2d4, 0xf6b4, 0xf3a8, 0xf795, 0xf39c, 0xf757, 0xf383, 0xf775, 0xf394, 0xf772,
0xf32d, 0xf6ff, 0xf31c, 0xf706, 0xf2f2, 0xf683, 0xf0a7, 0xf3db, 0xf05e, 0xf361,
0xf06c, 0xf3cc, 0xf029, 0xf400, 0xefc0, 0xf390, 0xeeab, 0xf253, 0xee59, 0xf1d0,
0xef77, 0xf2b9, 0xf201, 0xf576, 0xefec, 0xf2f0, 0xf02b, 0xf32b, 0xf1f4, 0xf4fe,
0xefdf, 0xf298, 0xe735, 0xe996, 0xe372, 0xe5d8, 0xe7e9, 0xead6, 0xf6f8, 0xf9db,
0xfe0d, 0xff96, 0xe730, 0xe900, 0xdb7f, 0xdd5d, 0xe96a, 0xea0f, 0x055d, 0x060f,
0x033e, 0x0564, 0xe4d3, 0xe6a1, 0xdbcc, 0xdded, 0xec9b, 0xee19, 0xef89, 0xf14a,
0xdde4, 0xde55, 0xdff8, 0xe020, 0xd23a, 0xd3ce, 0xf0ef, 0xf3d9, 0x09da, 0x0c77,
0x00a1, 0x0278, 0xdd29, 0xde41, 0xcee7, 0xd107, 0xd7ef, 0xdad6, 0xe72d, 0xe9b0,
0xf572, 0xf7ef, 0xf900, 0xfb84, 0xeef4, 0xf153, 0xe943, 0xec63, 0xe86e, 0xeb87,
0xe845, 0xeaf4, 0xd21d, 0xd442, 0xda41, 0xdc69, 0xebd1, 0xee6f, 0xed91, 0xf0cb,
0xe0d0, 0xe46a, 0xe045, 0xe444, 0xea7b, 0xedc9, 0xef38, 0xf14d, 0xe461, 0xe656,
0xdb20, 0xde13, 0xe9e3, 0xedfc, 0xee3e, 0xf22b, 0xea4d, 0xed40, 0xdcd7, 0xdf61,
0xd891, 0xdad4, 0xd812, 0xda4e, 0xe1c9, 0xe47b, 0xe850, 0xeb27, 0xf343, 0xf609,
0xf2da, 0xf59f, 0xe680, 0xe908, 0xe7b9, 0xe9cc, 0xe7d6, 0xe953, 0xe526, 0xe75c,
0xdb01, 0xde26, 0xe76a, 0xe954, 0xea6c, 0xebc5, 0xe3a0, 0xe5de, 0xd4cf, 0xd7cd,
0xde4c, 0xe116, 0xe889, 0xeabb, 0xe838, 0xea22, 0xe2b8, 0xe3f6, 0xea1f, 0xeb3a,
0xfac2, 0xfc2c, 0xef2a, 0xf10d, 0xeaa9, 0xee2d, 0xf543, 0xfb2a, 0x01c9, 0x075a,
0xf2e7, 0xf5a6, 0xe9ff, 0xebf2, 0xec25, 0xeef2, 0xf0ed, 0xf521, 0xfa26, 0xfe65,
0xfd31, 0x00ad, 0x05eb, 0x0963, 0xf237, 0xf588, 0xe7cd, 0xeacb, 0xe8ee, 0xeb0f,
0xe932, 0xea5e, 0xeb61, 0xedd8, 0xee88, 0xf232, 0xf07e, 0xf381, 0xf5e0, 0xf839,
0xf3ef, 0xf571, 0xe7c0, 0xe835, 0xe251, 0xe169, 0xea0f, 0xe8aa, 0xff00, 0xfddf,
0x0f8f, 0x0f17, 0xfbaf, 0xfb73, 0xf7de, 0xf78a, 0xf900, 0xf819, 0xe5a6, 0xe46b,
0xf11c, 0xf06c, 0xfc53, 0xfb8e, 0x0295, 0x026a, 0xf2b7, 0xf290, 0xe826, 0xe662,
0xea0b, 0xe774, 0xebb9, 0xeb00, 0x02cd, 0x03f5, 0x0437, 0x0737, 0xedf5, 0xef1e,
0xdf4a, 0xddad, 0xed31, 0xed20, 0x02e2, 0x05e2, 0x0590, 0x088d, 0x10d2, 0x11c8,
0x0627, 0x04f4, 0xecb0, 0xeaba, 0xeaf5, 0xeb11, 0xf586, 0xf58b, 0xffb7, 0xffcf,
0x04f6, 0x0389, 0xea27, 0xe83d, 0xec68, 0xee21, 0xfdfd, 0x0042, 0xf319, 0xf2ba,
0xf9cf, 0xf7e5, 0xfc7c, 0xf94c, 0x0483, 0x0333, 0xf520, 0xf6d4, 0xf4b8, 0xf5cb,
0x00fa, 0x01ef, 0xe502, 0xe6b3, 0xeadf, 0xebc4, 0xfe7c, 0xfeca, 0x04eb, 0x04a4,
0x0190, 0x0074, 0xf6ed, 0xf7cc, 0xf3a7, 0xf567, 0xe873, 0xe996, 0x15dd, 0x15fb,
0x2d99, 0x2d97, 0x0855, 0x0a1c, 0xff45, 0x00b0, 0xe4e9, 0xe44e, 0xdfcc, 0xdfb3,
0xf6ca, 0xf7af, 0x0450, 0x04d1, 0x0a62, 0x0a48, 0x052e, 0x0454, 0x029c, 0x01cd,
0xfe87, 0xfe67, 0xf99f, 0xf9e1, 0x1148, 0x1159, 0xf046, 0xf05b, 0xe09c, 0xdedd,
0x0314, 0x008e, 0x0cb4, 0x0c39, 0x23d6, 0x23c4, 0x1fac, 0x1e78, 0x05be, 0x0475,
0xe40b, 0xe2d5, 0xe4b8, 0xe29c, 0xfb4d, 0xf81c, 0x1cf9, 0x1998, 0x1353, 0x119c,
0xfe0d, 0xfce1, 0x00f1, 0xff40, 0x0001, 0xfd91, 0x01f3, 0x00ae, 0x0ce1, 0x0c05,
0x0025, 0xfcc5, 0x19dc, 0x1637, 0x217f, 0x1f37, 0xe88b, 0xe5c9, 0xee5f, 0xea3b,
0x07e0, 0x03cc, 0x22a3, 0x1f8c, 0x1e05, 0x1b57, 0x1235, 0x0f7b, 0x0465, 0x02b6,
0xeee8, 0xec0e, 0xf769, 0xf19b, 0x0bfb, 0x071c, 0x1f74, 0x1ccd, 0x0e98, 0x0b39,
0x0b5b, 0x065d, 0x1076, 0x0b4c, 0x154a, 0x116b, 0xf4dd, 0xf17d, 0xeb79, 0xe6f0,
0x02e4, 0xfd86, 0xfb15, 0xf57b, 0x0706, 0x0271, 0x0e38, 0x0bea, 0x112a, 0x0f1e,
0xf45b, 0xf054, 0x0fc5, 0x0b63, 0x3a39, 0x356a, 0x0a3f, 0x053d, 0x06d7, 0x035b,
0x0b2d, 0x0780, 0xf64a, 0xf159, 0x0a37, 0x0453, 0x0c44, 0x0748, 0x03fa, 0xffe6,
0x0b14, 0x07c7, 0x114a, 0x0ec8, 0x0ea8, 0x0a4d, 0x07e2, 0x0141, 0x1fbf, 0x194e,
0x1b57, 0x174d, 0x0af4, 0x08f3, 0x2732, 0x25cc, 0x0633, 0x0433, 0xee0c, 0xe9c8,
0xef0c, 0xe995, 0x21d4, 0x1d60, 0x1e4b, 0x1a00, 0x0036, 0xfc65, 0x0d7e, 0x08ed,
0x1a89, 0x14da, 0x1493, 0x110e, 0xf97a, 0xf6da, 0x1bba, 0x178c, 0x1d78, 0x1a5b,
0x10b6, 0x0eac, 0x09fd, 0x078c, 0x166b, 0x1308, 0x16f3, 0x13ed, 0x032a, 0xfe96,
0x12b3, 0x0cd2, 0x0748, 0x03b2, 0x07e1, 0x051f, 0x172b, 0x1570, 0x338a, 0x3085,
0x2a93, 0x2547, 0x0cdc, 0x07bd, 0xf63f, 0xf3d0, 0x124f, 0x12e3, 0x2844, 0x2696,
0x03cb, 0xff08, 0xffae, 0xfa5e, 0x104b, 0x08e9, 0x2396, 0x1d30, 0xf71d, 0xf315,
0xfde6, 0xfaae, 0x1b94, 0x1846, 0x33ca, 0x2fe1, 0x0f87, 0x0b61, 0xf945, 0xf4ba,
0x02b1, 0xff83, 0x0621, 0x025f, 0x10a7, 0x0a5a, 0x1392, 0x0f83, 0x1ee7, 0x1db5,
0x1fd4, 0x1f3e, 0x1eb6, 0x1e95, 0x14a5, 0x11e4, 0xfd80, 0xf80a, 0x0165, 0xfb5a,
0x14ec, 0x11eb, 0x22cc, 0x22ed, 0x0825, 0x0799, 0x0923, 0x067a, 0x1f17, 0x1c8c,
0x2161, 0x1edb, 0x147d, 0x109d, 0x136d, 0x1074, 0x283d, 0x2512, 0x1d35, 0x1ade,
0x0617, 0x05b7, 0xf3d6, 0xeff3, 0xec85, 0xe61f, 0x0a48, 0x06b8, 0x1f99, 0x1df7,
0x1848, 0x176d, 0x0a94, 0x085b, 0x05a7, 0x01fd, 0x10fa, 0x0c23, 0x1863, 0x1300,
0x1540, 0x11cd, 0x0e3a, 0x0ce2, 0x0cc1, 0x0ab8, 0x0ce9, 0x08b0, 0x1020, 0x0c80,
0x11da, 0x0f65, 0x1d33, 0x18ce, 0x0d59, 0x06c4, 0x060d, 0x0104, 0x06fe, 0x033d,
0x110f, 0x0c65, 0x07b1, 0x03b3, 0x0b7a, 0x0794, 0x1da2, 0x17fd, 0x253c, 0x206c,
0x0694, 0x066c, 0xe050, 0xde9e, 0xec0d, 0xe657, 0x1612, 0x11f0, 0x273b, 0x2229,
0x1480, 0x0fa4, 0x029e, 0xfeef, 0x004b, 0xfa9b, 0x0ef7, 0x0a3b, 0x0674, 0x0297,
0x0b04, 0x066e, 0x102a, 0x0b9b, 0x059c, 0x024c, 0x0ecd, 0x0d56, 0x0ddd, 0x0a87,
0x123c, 0x0f8a, 0x2425, 0x220f, 0x2d7f, 0x277d, 0x1d8b, 0x16f6, 0xfcd2, 0xf973,
0xf4a6, 0xf304, 0x0dfa, 0x0a57, 0x2149, 0x1d60, 0xfa80, 0xf7c9, 0xf680, 0xf2c0,
0x0079, 0xfafa, 0xfd11, 0xf98b, 0x1300, 0x1239, 0x088a, 0x05e0, 0xfd91, 0xf995,
0x0acb, 0x0752, 0x1086, 0x0e56, 0x113e, 0x0e41, 0x0d7a, 0x08cb, 0x0727, 0x0395,
0x0208, 0xfe79, 0x026f, 0x0045, 0x22dd, 0x24d0, 0x1119, 0x13d2, 0x0868, 0x070b,
0x2381, 0x1f89, 0x1ed1, 0x1ba6, 0x0bda, 0x0b5d, 0x014c, 0xffe0, 0x0999, 0x04ee,
0x0ced, 0x09a3, 0x2777, 0x25c5, 0x454b, 0x41a6, 0x0489, 0xff41, 0xea02, 0xe76c,
0x0678, 0x06f2, 0x2f45, 0x2e1e, 0x35a0, 0x30a4, 0x1808, 0x137a, 0xfdbf, 0xfa3f,
0xf37a, 0xf0f0, 0x109f, 0x0ee1, 0x1f68, 0x1d1a, 0x085e, 0x05e4, 0x078c, 0x0541,
0x0371, 0x010c, 0xfdb7, 0xfa11, 0xf7f5, 0xf35e, 0x0fae, 0x0bb8, 0x2193, 0x1f09,
0x0430, 0x0140, 0xf9bb, 0xf59e, 0xf879, 0xf47e, 0x0100, 0xfe71, 0xf690, 0xf480,
0x0acb, 0x092c, 0x19ae, 0x18da, 0x0572, 0x03fd, 0x0315, 0xff3f, 0x0013, 0xfb2d,
0x0294, 0xfd48, 0xfb1b, 0xf744, 0x1bcf, 0x1b33, 0x2d2b, 0x2cad, 0x0b0b, 0x08ac,
0xfc85, 0xf995, 0x03cd, 0x025c, 0x0aba, 0x0a5d, 0xe972, 0xe9b7, 0xf037, 0xf025,
0xfb70, 0xfa17, 0xfaf4, 0xf9ab, 0x13b5, 0x1382, 0x24cb, 0x24e9, 0x209a, 0x2142,
0xfd98, 0xfe4d, 0xe557, 0xe505, 0xe7f6, 0xe713, 0xf7dc, 0xf755, 0xe7f0, 0xe723,
0xf0a3, 0xefee, 0x093d, 0x0aed, 0x03ec, 0x07a8, 0x1564, 0x1640, 0x1431, 0x1050,
0xf81a, 0xf3d1, 0x0048, 0xfeee, 0x01e2, 0x02c8, 0x0438, 0x04e6, 0x0792, 0x065d,
0x165e, 0x1447, 0x119c, 0x10b2, 0xf916, 0xf7f0, 0x0352, 0x0144, 0x132d, 0x1277,
0x1550, 0x13fa, 0xfb99, 0xf9be, 0xfa4b, 0xf9cd, 0xf724, 0xf560, 0xf576, 0xf427,
0x1b28, 0x1c58, 0x1955, 0x19aa, 0x002b, 0xfd34, 0xf22f, 0xed81, 0xe650, 0xe2b5,
0xf536, 0xf43d, 0x0e66, 0x0b94, 0x054e, 0xffa2, 0x028d, 0xfdb0, 0x05da, 0x0099,
0x0df7, 0x09cf, 0xefd3, 0xed1e, 0xe1c7, 0xddb0, 0xfc40, 0xf7c9, 0xfa8e, 0xf5cf,
0x15fa, 0x119f, 0x2af4, 0x2863, 0x187e, 0x14c4, 0xf7ae, 0xf28b, 0xf4c4, 0xefc5,
0x054c, 0x021a, 0xff5d, 0xfcb0, 0x0f5e, 0x0b27, 0x12c0, 0x0fe6, 0xffa2, 0xfe8e,
0x0b36, 0x0b81, 0x1310, 0x13af, 0x13ed, 0x133a, 0x1f8f, 0x1edd, 0x2281, 0x243e,
0x2446, 0x28b7, 0x37be, 0x399f, 0x1882, 0x151b, 0x0446, 0x0199, 0x072d, 0x07f5,
0x2aec, 0x2dd6, 0x0a13, 0x0af3, 0xf060, 0xee91, 0x0e00, 0x0b34, 0x116e, 0x0f6c,
0x2918, 0x29e1, 0x2e4d, 0x2dcc, 0x0b35, 0x0941, 0x02cd, 0x0160, 0x0260, 0xff6e,
0xf6b4, 0xf210, 0x112f, 0x0d58, 0x245c, 0x2308, 0x24b8, 0x2231, 0xf252, 0xec9a,
0x104d, 0x0a87, 0x21ce, 0x1d86, 0x03a4, 0xffa4, 0x1874, 0x14ec, 0x1464, 0x12fd,
0x0e93, 0x0cf7, 0x114a, 0x0f4b, 0x1590, 0x1331, 0x1a0c, 0x1743, 0x1ae1, 0x18d5,
0x0eaf, 0x0dd1, 0xfbf2, 0xfd4e, 0xfb2e, 0xfa73, 0x1884, 0x14a0, 0x17cb, 0x15b8,
0x0cb7, 0x0c84, 0x045d, 0x020b, 0x188e, 0x1484, 0x0bad, 0x094d, 0x05c0, 0x0432,
0x2a29, 0x299c, 0x2108, 0x22c5, 0x0e85, 0x107b, 0x0396, 0x0398, 0x0d47, 0x096b,
0x1717, 0x12aa, 0x16b2, 0x144f, 0x0fd1, 0x0d7c, 0x0d3c, 0x0b1a, 0x137e, 0x1328,
0x1780, 0x179d, 0x2d70, 0x2e40, 0x19ca, 0x1b6b, 0x03d2, 0x0338, 0x03cd, 0x0290,
0x1c11, 0x1c24, 0x1823, 0x1813, 0xfe1c, 0xfe8e, 0x1ba7, 0x1d59, 0x0b16, 0x0d57,
0x033b, 0x03e7, 0x24e2, 0x2457, 0x0ae0, 0x0c17, 0x06fe, 0x0941, 0x14e9, 0x149a,
0x2042, 0x1e1e, 0x119f, 0x1057, 0x029a, 0x01bd, 0x134c, 0x13cd, 0x0b30, 0x0d8b,
0x1ea1, 0x1ffd, 0x2bd1, 0x2ad3, 0x0097, 0xfe4b, 0xf550, 0xf3c1, 0x016b, 0x0280,
0x1629, 0x1781, 0x1808, 0x1741, 0x16bc, 0x16f5, 0x1b5c, 0x1c41, 0x405c, 0x3ecc,
0x14d8, 0x1145, 0xef9e, 0xed91, 0xf83e, 0xf72c, 0x2dbd, 0x2dfd, 0x3054, 0x3335,
0x0909, 0x0aed, 0x0bf2, 0x0bd9, 0x1361, 0x127d, 0x1194, 0x1200, 0xf2dc, 0xf24b,
0x108c, 0x0e7e, 0x194e, 0x1a38, 0x174b, 0x1810, 0x087a, 0x06ce, 0x227c, 0x1e9f,
0x2cf4, 0x2872, 0x2c34, 0x2c4d, 0x0cf6, 0x0fd5, 0x2629, 0x291f, 0x3b84, 0x3e4e,
0xf917, 0xfa00, 0x0b0c, 0x09c1, 0x1cfb, 0x1c34, 0x19a3, 0x1b3e, 0x1530, 0x1409,
0xfc76, 0xf668, 0xfcc2, 0xf9c6, 0x3228, 0x33a0, 0x25f4, 0x290a, 0x0b32, 0x0f11,
0xfc6b, 0xfde5, 0xfaf1, 0xf8af, 0xff6d, 0xfc92, 0xfddd, 0xfad0, 0xf04c, 0xecb4,
0x1f88, 0x1f60, 0x2c54, 0x2c79, 0x0438, 0x0185, 0xf2a4, 0xeedf, 0x0793, 0x06ed,
0x2320, 0x2189, 0x1f85, 0x1d50, 0x26a8, 0x250a, 0x1067, 0x0c9a, 0xfe81, 0xfafe,
0x1f87, 0x1dec, 0x1955, 0x18bb, 0x0c97, 0x0b99, 0x09bd, 0x0722, 0x1e49, 0x1abd,
0x1ef2, 0x1c59, 0x0f61, 0x0e8a, 0x05c3, 0x06c9, 0x2604, 0x25ae, 0x2900, 0x26f9,
0xf544, 0xf339, 0x0256, 0x001c, 0x1938, 0x167f, 0x25c8, 0x24eb, 0x097c, 0x0a57,
0x0e24, 0x0e5d, 0x14b6, 0x13a7, 0x0061, 0xfea9, 0x1d45, 0x1c27, 0x08d2, 0x08ef,
0xf511, 0xf5e6, 0x12ed, 0x12ef, 0x0dde, 0x0c81, 0x0a77, 0x09a4, 0x1263, 0x1337,
0xf4e5, 0xf592, 0x061c, 0x042e, 0x2770, 0x2374, 0x2137, 0x1f75, 0x0891, 0x07d0,
0xfbc9, 0xf908, 0x0f04, 0x0d89, 0xee3f, 0xed04, 0x0504, 0x01c0, 0x231d, 0x2236,
0x1a17, 0x18cb, 0x1415, 0x0fba, 0x1245, 0x10fd, 0x0f12, 0x1021, 0x09b7, 0x0b89,
0xff02, 0xfe91, 0xf29e, 0xf1d7, 0xfd9d, 0xfe55, 0x0003, 0x0038, 0xf4c3, 0xf68c,
0xeb29, 0xe96c, 0xffc9, 0xfa6f, 0x0849, 0x03f2, 0x05fc, 0x04b5, 0xfe4b, 0xfe9c,
0x0353, 0x01df, 0x0e32, 0x0b31, 0x0b9e, 0x0c32, 0xff6f, 0xff71, 0xf688, 0xf1a8,
0xfd04, 0xf9a1, 0x1026, 0x10e8, 0x0ae0, 0x0d78, 0x0f53, 0x0ec0, 0x1839, 0x179b,
0x0ac5, 0x0d50, 0xf6c3, 0xf8aa, 0xeb88, 0xea00, 0xf456, 0xf0fc, 0xf1fc, 0xf11a,
0xf185, 0xf2f7, 0xef58, 0xf088, 0x1209, 0x12d1, 0xfc92, 0xfd8d, 0xe8a6, 0xea07,
0xeecb, 0xef5a, 0x1b61, 0x1c2c, 0x1d7b, 0x2207, 0xfd08, 0xfe54, 0x0d34, 0x0a1f,
0xf107, 0xf16b, 0xe51b, 0xe6f2, 0xfb3d, 0xff39, 0xf6fb, 0xfae5, 0xf938, 0xfa83,
0xfbae, 0xffa0, 0xfc0d, 0x01e9, 0xe910, 0xead0, 0xef33, 0xee03, 0x0d00, 0x0daf,
0x0266, 0x0443, 0xe23a, 0xe349, 0xd884, 0xdada, 0xf615, 0xfb18, 0x092f, 0x0eeb,
0x07a1, 0x0a89, 0x02cb, 0x02fb, 0xef90, 0xf0d2, 0x00be, 0x059d, 0x164f, 0x1c7d,
0x0d08, 0x0efa, 0xf8e8, 0xf709, 0xe3f0, 0xe3cc, 0xda8b, 0xddd4, 0xead9, 0xf0f7,
0xe9fe, 0xf088, 0xe66e, 0xeaa5, 0xf0f5, 0xf419, 0xfb20, 0xfda8, 0xfb98, 0xfe46,
0xfa48, 0xfea4, 0x1228, 0x1963, 0x0c9c, 0x1387, 0xfb6d, 0xfd99, 0xdc63, 0xde3c,
0xde92, 0xe3d6, 0xe5c4, 0xe9f1, 0xf17e, 0xf403, 0xf5b2, 0xf769, 0x0403, 0x059f,
0x0de4, 0x1018, 0xf4b1, 0xfa71, 0xea47, 0xf1c8, 0xf3d4, 0xf50c, 0x0293, 0x01c1,
0xf31f, 0xf4a7, 0xe197, 0xe418, 0xe009, 0xe2a0, 0xff82, 0x013e, 0xe5f4, 0xe64c,
0xecd3, 0xed8a, 0x0cad, 0x0f6c, 0x19f8, 0x1a12, 0xf289, 0xeebd, 0xd22a, 0xd281,
0xe232, 0xe3dd, 0xe836, 0xe63d, 0xf66b, 0xf61b, 0xeca5, 0xed6f, 0xd000, 0xd0a9,
0xc5ed, 0xc76d, 0xe21d, 0xe520, 0x08b5, 0x0b4b, 0x01c9, 0x012b, 0xe53e, 0xe3b0,
0xd373, 0xd3b9, 0xc60d, 0xc879, 0xda3a, 0xdaa4, 0xf5ce, 0xf413, 0x10e7, 0x125b,
0xe9d6, 0xef2a, 0xc7c4, 0xcad7, 0xce7d, 0xd06b, 0xec0b, 0xef32, 0xfb0c, 0xfca0,
0xef23, 0xf038, 0xdd6d, 0xdf21, 0xc384, 0xc3f2, 0xc2c5, 0xbeaf, 0xcea4, 0xce68,
0xe3d6, 0xe79b, 0xe93e, 0xe9fd, 0xea13, 0xec41, 0xeaeb, 0xee1f, 0xe81a, 0xe8b6,
0xdbd4, 0xdd12, 0xde20, 0xe043, 0xf2f7, 0xf3a5, 0xe47c, 0xe57c, 0xd8bb, 0xda2c,
0xda46, 0xdbcc, 0xd74b, 0xd836, 0xe12f, 0xe1a9, 0xdff2, 0xdf24, 0xcfa8, 0xd2e7,
0xdd00, 0xe66d, 0xec5e, 0xf341, 0xeb70, 0xee43, 0xcfb4, 0xd194, 0xc34d, 0xc3e4,
0xd03d, 0xd022, 0xd3bf, 0xd39b, 0xe590, 0xe2b9, 0xd505, 0xd42a, 0xcee7, 0xcf8c,
0xd9a2, 0xd7f4, 0x0670, 0x0964, 0x23ad, 0x2ca5, 0x07d4, 0x1380, 0xed2b, 0xf59a,
0xe95e, 0xf1a0, 0xfc8f, 0x0867, 0x0104, 0x0b48, 0x0213, 0x0b8c, 0x0218, 0x07b5,
0x0955, 0x09e5, 0xe44b, 0xe522, 0xeb59, 0xf276, 0x0583, 0x109c, 0x00c3, 0x094e,
0xea0b, 0xedb0, 0xe1c3, 0xe3a5, 0xf820, 0xfbd1, 0xf36f, 0xf7d2, 0xf212, 0xf51c,
0xf0a8, 0xf41e, 0xf84f, 0xfdfc, 0xf329, 0xf6f9, 0xecdd, 0xecd0, 0xeb59, 0xebeb,
0x0fef, 0x1233, 0x0a99, 0x0a43, 0xeb31, 0xe6ef, 0xddf5, 0xd89f, 0xdc56, 0xd9ae,
0xe11d, 0xe08d, 0xe7a7, 0xe773, 0xf1fb, 0xf258, 0x0ab1, 0x0bc6, 0x15fb, 0x16eb,
0xfb09, 0xfaa5, 0xe534, 0xe482, 0xeb4a, 0xeb6b, 0x05ea, 0x06ae, 0x0fff, 0x0f40,
0x08f4, 0x0584, 0xf202, 0xf110, 0xeedc, 0xf047, 0xd956, 0xda0a, 0xf439, 0xf60c,
0x2007, 0x23fc, 0x357d, 0x38ba, 0x093a, 0x0b7a, 0xd93b, 0xdcd0, 0xcfbe, 0xd208,
0xeb0c, 0xeb11, 0xf9ad, 0xf84b, 0xf49e, 0xf289, 0xdf57, 0xdd38, 0xf6a2, 0xf49d,
0x0873, 0x08bd, 0xe949, 0xeaea, 0xf12e, 0xf083, 0xf31b, 0xf16a, 0xf36a, 0xf022,
0xf396, 0xf058, 0xf1ed, 0xf1a9, 0xf409, 0xf755, 0x0130, 0x04d4, 0xf8eb, 0xf8e7,
0xfeeb, 0xfe00, 0x024c, 0x02c5, 0xe989, 0xebbb, 0xe7b0, 0xea05, 0xfb75, 0xf9e0,
0x1123, 0x0beb, 0xef23, 0xeaeb, 0xe084, 0xe0de, 0xedfb, 0xf20c, 0xef3d, 0xf214,
0x0164, 0x0374, 0x0581, 0x080f, 0xfc81, 0xffc7, 0x0020, 0x0337, 0xfdb0, 0xfd8c,
0xf10f, 0xef9b, 0xf64f, 0xf48d, 0xe879, 0xe6c4, 0xef1a, 0xef0b, 0x02d3, 0x0303,
0xfae0, 0xf8d9, 0xf248, 0xf0e3, 0xf4f0, 0xf2c2, 0xfcf5, 0xf84c, 0x0aa8, 0x081c,
0x03ba, 0x052b, 0xf09f, 0xf1fa, 0xf5ac, 0xf3f0, 0xff41, 0xfcf8, 0x00d0, 0xff82,
0xf6bc, 0xf711, 0xf4be, 0xf511, 0xf3ec, 0xf35d, 0xf9e6, 0xf974, 0x0424, 0x0609,
0x1c30, 0x206f, 0x1ded, 0x207d, 0xf56b, 0xf387, 0xdc36, 0xd87c, 0xeeae, 0xeba9,
0x10a4, 0x0f29, 0xf205, 0xf0dc, 0xf161, 0xf144, 0xff6d, 0x0102, 0xfdc4, 0xfb88,
0xfae8, 0xf5cf, 0xfe63, 0xf9d0, 0x07d5, 0x044c, 0xf097, 0xee23, 0xf079, 0xecd5,
0x0386, 0xfddd, 0x00cf, 0xfb54, 0x10a1, 0x0dba, 0x0a39, 0x07b1, 0xfb1e, 0xf872,
0xf6c4, 0xf746, 0x0a64, 0x0b32, 0x19f5, 0x16b2, 0x048f, 0xfeeb, 0x05ec, 0x0169,
0xfc0a, 0xf7c7, 0xf827, 0xf48d, 0x0657, 0x037f, 0x0b72, 0x06f7, 0x03c8, 0xfd29,
0xfa0d, 0xf57e, 0xf74a, 0xf808, 0x0f33, 0x1274, 0x2602, 0x293f, 0x1741, 0x1684,
0x0465, 0x0104, 0xf77e, 0xf4d2, 0xec3b, 0xea5f, 0x0844, 0x06d4, 0x05a2, 0x0296,
0xf596, 0xf2bb, 0x069a, 0x0431, 0x0255, 0xfeb6, 0xfd5d, 0xfc98, 0xf9a2, 0xfd1e,
0x1b97, 0x1e27, 0x170c, 0x14f2, 0xff49, 0xfbf1, 0x04ac, 0x0292, 0x004e, 0xfbc1,
0xf9d2, 0xf434, 0xf53c, 0xf13e, 0x004e, 0xfed7, 0x0be9, 0x0a7b, 0x1af0, 0x185d,
0x2010, 0x1f59, 0x242b, 0x2480, 0x0a1f, 0x08b7, 0xeb66, 0xe990, 0xeb09, 0xe8a5,
0x03fb, 0xffa1, 0x1b17, 0x15b5, 0x0ff5, 0x0b71, 0x059f, 0x0593, 0xf975, 0xfc30,
0xf960, 0xfcd0, 0x00ad, 0x02ae, 0x0dc3, 0x0ddc, 0x17e5, 0x177b, 0x225c, 0x212b,
0x0f18, 0x0ae9, 0x10c2, 0x0b5a, 0x19a4, 0x16a3, 0x0066, 0xff58, 0xec2b, 0xeced,
0xf7af, 0xf728, 0x1383, 0x11eb, 0x2ce7, 0x2b3b, 0x187a, 0x170a, 0xf327, 0xf38f,
0xefc7, 0xed5b, 0x0165, 0xfab6, 0x0a3d, 0x0607, 0xfb8f, 0xfcd4, 0x07e5, 0x0823,
0x0b99, 0x087d, 0x0abf, 0x06f1, 0x1284, 0x0d02, 0x0c75, 0x0822, 0x0229, 0x016e,
0xf787, 0xf789, 0xff6a, 0x0075, 0x19e3, 0x1a4a, 0x293e, 0x275f, 0xf5f9, 0xf3de,
0x02a6, 0x0161, 0x0a13, 0x07fd, 0xed4a, 0xed1e, 0x057a, 0x0890, 0x137f, 0x16f1,
0x128b, 0x126d, 0x0e4e, 0x0b40, 0x052d, 0x01a8, 0x00a5, 0xfaba, 0x02fd, 0xfc3b,
0x099a, 0x038e, 0x0732, 0x0445, 0xff4d, 0xff3c, 0x00c9, 0x028f, 0x0b35, 0x0ac2,
0x09f0, 0x0534, 0xf90b, 0xf475, 0xf1ae, 0xef7f, 0xf188, 0xf0e2, 0xff63, 0xfdb5,
0x0726, 0x02b9, 0x092d, 0x0449, 0x0155, 0xfb6d, 0xfda3, 0xf577, 0xec9f, 0xe76c,
0x054b, 0x049b, 0x15cd, 0x13f4, 0xef83, 0xea7e, 0xecf9, 0xe9d5, 0xf895, 0xf869,
0x01fa, 0xff3f, 0x0512, 0x00a2, 0x0258, 0xfc54, 0x0475, 0xfc50, 0x0861, 0x02f2,
0x0644, 0x0395, 0xf993, 0xf80b, 0xf0ce, 0xf12c, 0xebe8, 0xece0, 0xf352, 0xf108,
0xf9a3, 0xf779, 0xfa8c, 0xfc8a, 0xf849, 0xfa1c, 0xf6b2, 0xf435, 0xfac7, 0xfabe,
0x08ff, 0x0a40, 0xffad, 0xfd03, 0xf4e6, 0xf315, 0xf670, 0xf612, 0x0141, 0x0054,
0xf9f9, 0xf786, 0xee17, 0xeb68, 0x000d, 0xfc9e, 0x007f, 0xfdbd, 0xfe5c, 0xfed4,
0xfd1f, 0xfdb0, 0xf95c, 0xfaa7, 0xfe59, 0x0183, 0x0933, 0x0c2c, 0xf701, 0xf7e4,
0xfc5e, 0xfa0e, 0xf911, 0xf604, 0xf06f, 0xebc2, 0xeb4c, 0xe7aa, 0x024f, 0x0267,
0x1c16, 0x1d98, 0x2ae4, 0x2a4f, 0x075f, 0x05df, 0xf362, 0xf25b, 0x0398, 0x0549,
0xfb00, 0x01af, 0x08d7, 0x1023, 0x1ca0, 0x22d4, 0x23ab, 0x2687, 0x1803, 0x19de,
0x0a1c, 0x10d2, 0xff52, 0x076a, 0x0318, 0x070b, 0x0c85, 0x0f86, 0x165f, 0x1b0f,
0x0e1a, 0x152c, 0x0a11, 0x1222, 0x06e8, 0x0d91, 0x01ef, 0x03ab, 0xf879, 0xfa28,
0xf091, 0xf64f, 0xf725, 0xfc83, 0xfee3, 0x0174, 0x1c31, 0x1dcd, 0x1960, 0x1bc8,
0x00bf, 0x0173, 0x01f7, 0x0270, 0xfd0f, 0xfb3f, 0xfd52, 0xf61d, 0x0c54, 0x0410,
0xf4e9, 0xf54f, 0xf7f0, 0xff34, 0x11da, 0x15b7, 0xe623, 0xe6b8, 0xe524, 0xe589,
0xfbb6, 0xf901, 0x17dd, 0x138f, 0x0853, 0x0472, 0xf72a, 0xf726, 0xf887, 0xfbc9,
0xf2b4, 0xf260, 0xef44, 0xea2f, 0xf721, 0xf1d8, 0x1147, 0x10a1, 0x0697, 0x076a,
0xef6b, 0xf3a6, 0xe3f5, 0xec89, 0xf7c4, 0x000a, 0x0b79, 0x0edc, 0x07e5, 0x06fd,
0xea99, 0xeb97, 0xee20, 0xf043, 0xf969, 0xf8d5, 0x002a, 0xffd2, 0xf89a, 0xfc67,
0x00c8, 0x06f9, 0xfccf, 0xffe9, 0xe000, 0xe502, 0xf708, 0xfe28, 0xfeb7, 0x028a,
0xf8a1, 0xf8e1, 0x031b, 0x0227, 0xe8e1, 0xeb17, 0xe000, 0xe3b2, 0xedb7, 0xf172,
0xf46d, 0xf302, 0xf9b6, 0xf719, 0xf77c, 0xf6f7, 0xf3c7, 0xf6dd, 0xefae, 0xf6ba,
0xf2f5, 0xf6f0, 0xf89c, 0xfa3f, 0xfc18, 0xff04, 0xf568, 0xfa2c, 0xef06, 0xf355,
0xe938, 0xedfe, 0xe1a8, 0xe7bb, 0xe716, 0xecce, 0xf989, 0xfb6f, 0x0a44, 0x0a1f,
0x00df, 0x02e2, 0xee60, 0xf36a, 0xed42, 0xf1b6, 0xf106, 0xf13a, 0xf639, 0xf5bc,
0xf54f, 0xf4bf, 0xf24d, 0xf26e, 0xe644, 0xe683, 0xe6a2, 0xe676, 0xf81f, 0xf94c,
0xf5f0, 0xf838, 0xe9c5, 0xec80, 0xe5bc, 0xe7d8, 0xe8d0, 0xeae6, 0xee9f, 0xf03e,
0xef79, 0xee1b, 0xeed0, 0xec03, 0xf83e, 0xf727, 0xfe10, 0xff02, 0xfbcc, 0xfcd8,
0x0c75, 0x0aeb, 0xf0e9, 0xec96, 0xe0d1, 0xdeb8, 0xefe6, 0xf139, 0x02a9, 0x02ee,
0x0f7d, 0x0f08, 0x0eb2, 0x0d42, 0xdff5, 0xdf0a, 0xe792, 0xe796, 0x0143, 0xfebb,
0x028e, 0xfe8e, 0xf71b, 0xf79e, 0x0013, 0x065f, 0x1b8b, 0x23f5, 0x18c3, 0x20eb,
0x1c91, 0x261d, 0x1173, 0x1a11, 0x0130, 0x0561, 0x0728, 0x08e7, 0x1fdc, 0x20ed,
0x2cf1, 0x3030, 0x0824, 0x0f18, 0x0688, 0x0f07, 0x13a1, 0x195a, 0x1547, 0x19de,
0x0306, 0x0705, 0x029e, 0x049d, 0x106f, 0x13c5, 0x024e, 0x0878, 0x114b, 0x17c4,
0x2431, 0x28fb, 0x29da, 0x2b75, 0x1fb6, 0x1df6, 0x0891, 0x0756, 0xff4f, 0xffa1,
0x0213, 0x003f, 0x1b14, 0x177e, 0x1fdb, 0x1d92, 0x0999, 0x06fc, 0x03e6, 0xfffe,
0xfec7, 0xfac0, 0x0980, 0x07d6, 0x1cee, 0x1a7d, 0x1ea1, 0x195c, 0x12b8, 0x0dbc,
0x0444, 0x0181, 0x0c66, 0x0c8e, 0x0e1d, 0x0e27, 0x0f36, 0x0d68, 0x128b, 0x0f16,
0x1a61, 0x1716, 0x0b72, 0x09b5, 0xfa35, 0xfa4f, 0x0718, 0x074a, 0x1afb, 0x18a4,
0x1d1a, 0x1726, 0xfdda, 0xf956, 0xffcd, 0xfecf, 0x0a2e, 0x0914, 0x17ea, 0x1994,
0x2237, 0x229b, 0x1e12, 0x1bca, 0x105b, 0x0fa1, 0x08e1, 0x0735, 0xfe8a, 0xfb8b,
0x0748, 0x03a9, 0x165c, 0x14e3, 0x2d71, 0x2aa2, 0x1713, 0x1166, 0xfa72, 0xf704,
0x0502, 0x045a, 0x0ec5, 0x0f3b, 0x1412, 0x1332, 0x0bd2, 0x098b, 0x2718, 0x215d,
0x0aa2, 0x05d7, 0xf42c, 0xf43a, 0x0497, 0x05bc, 0x271d, 0x25d3, 0x293f, 0x27c0,
0x0473, 0x04f8, 0xea80, 0xeb89, 0xed6e, 0xeeab, 0x0004, 0x013e, 0x07b4, 0x075e,
0x20ac, 0x1bdf, 0x1f5e, 0x18f9, 0x1985, 0x1607, 0x0240, 0x02b7, 0x1a4a, 0x1d5d,
0x2a23, 0x2a09, 0x1bd2, 0x17e2, 0x015f, 0xfeed, 0xffed, 0xfeb4, 0x0a12, 0x0878,
0x0c69, 0x092b, 0x02f7, 0xff3e, 0x0871, 0x0400, 0x1cbd, 0x1807, 0x2540, 0x226d,
0x124f, 0x0e7e, 0x0568, 0x0062, 0x2546, 0x2261, 0x1814, 0x1896, 0x0710, 0x0811,
0xfc39, 0xf89b, 0xfaae, 0xf30c, 0x05fa, 0x0253, 0x1901, 0x18f3, 0x2395, 0x1d74,
0x2a2a, 0x2229, 0x1c89, 0x17c2, 0x0abe, 0x085a, 0x0680, 0x0430, 0x19e8, 0x1658,
0x1acf, 0x1704, 0xfe6d, 0xf91d, 0xf9dc, 0xf968, 0x06ce, 0x0c90, 0x1041, 0x15b5,
0x21bc, 0x20fb, 0x13fd, 0x1142, 0x074f, 0x07a9, 0x0f2f, 0x0fb8, 0x1214, 0x112c,
0x036d, 0x0151, 0xf7ac, 0xf17e, 0x201d, 0x17e4, 0x26ca, 0x2404, 0x180d, 0x1a68,
0xff60, 0x0289, 0x0c9b, 0x0d63, 0x06f3, 0x0377, 0xfdc8, 0xf89d, 0x22de, 0x209d,
0x2099, 0x2362, 0x14af, 0x1726, 0x0bda, 0x0a5e, 0xfdce, 0xfa24, 0xf818, 0xf6d5,
0x02c3, 0x0393, 0x0d3d, 0x0c81, 0x13cb, 0x13e9, 0x11d7, 0x1151, 0x0db0, 0x0e16,
0x1732, 0x16fa, 0x1f85, 0x1d36, 0x22e6, 0x22b5, 0x292d, 0x2a70, 0x0f18, 0x0f5e,
0xfefa, 0xfda2, 0x040b, 0x01c8, 0x1bac, 0x1afc, 0x1f8c, 0x1eb9, 0x152f, 0x13df,
0x05a1, 0x05b3, 0x1339, 0x1404, 0x0ef2, 0x0e88, 0xf529, 0xf319, 0x0857, 0x0624,
0x0bf3, 0x0b7d, 0x04ec, 0x07af, 0x0059, 0x02b6, 0xfe05, 0xfecc, 0xff9d, 0xff6a,
0x0b7e, 0x0d70, 0x09a7, 0x0cad, 0x14f5, 0x1824, 0x19fe, 0x1bfe, 0x0826, 0x0860,
0x0cbb, 0x0d14, 0x167e, 0x1503, 0x150f, 0x138a, 0xf82e, 0xf6a7, 0xfa17, 0xf605,
0x047e, 0x0063, 0x0260, 0x005f, 0x13e2, 0x1374, 0x1db3, 0x1d8b, 0x1637, 0x1605,
0x099e, 0x087b, 0xfc03, 0xf82c, 0xf7dc, 0xf47c, 0x04a6, 0x02f4, 0x0ece, 0x0c23,
0x1685, 0x15b7, 0x1603, 0x177d, 0xf7f8, 0xf7aa, 0xef3e, 0xef94, 0xfd63, 0xf9b4,
0x15e3, 0x0f5d, 0xffe2, 0xfce0, 0xefae, 0xf046, 0xf6db, 0xf7a5, 0xf785, 0xf439,
0xec68, 0xebcf, 0xeb02, 0xebce, 0x05de, 0x04d0, 0xf0b8, 0xf11c, 0xff7d, 0x004f,
0x16c5, 0x199e, 0x0ed3, 0x102a, 0x023d, 0xffba, 0xffca, 0xff41, 0x0786, 0x0876,
0x0cd3, 0x0f70, 0x06da, 0x0949, 0xf974, 0xfbd4, 0xf521, 0xf8c9, 0xfbec, 0xfe1f,
0xfe25, 0xfdff, 0xf23f, 0xf172, 0x0da1, 0x1030, 0x08b9, 0x0b9b, 0xf24f, 0xf3ee,
0xee92, 0xf192, 0xf175, 0xf648, 0xfc93, 0x0153, 0x0090, 0x024f, 0xf3a2, 0xf611,
0xe34b, 0xe87c, 0xea00, 0xf02e, 0x0a0f, 0x0f16, 0x00ed, 0x0122, 0xf38f, 0xf04c,
0xfc80, 0xff7f, 0xf11f, 0xfab7, 0xf6da, 0xff14, 0x00c2, 0x0534, 0x16d4, 0x1a28,
0xfb02, 0x0122, 0xeac9, 0xef89, 0xf2dc, 0xf852, 0xfb9c, 0x0154, 0x0218, 0x033e,
0xf7d5, 0xfb2d, 0xe4d6, 0xeb33, 0xf20c, 0xf457, 0xefb9, 0xf049, 0xe5ab, 0xe632,
0xea98, 0xebfc, 0x01e8, 0x0688, 0x0626, 0x0e95, 0xef7a, 0xf9c4, 0xe9fa, 0xf2aa,
0xf375, 0xfd51, 0xfff6, 0x0ae4, 0x040f, 0x0bb3, 0xf436, 0xf964, 0xf02c, 0xf5e9,
0xff12, 0x066a, 0xfe27, 0x079d, 0xfac6, 0x01e2, 0xef81, 0xf5bc, 0xdf29, 0xea38,
0xe794, 0xf264, 0xff26, 0x0128, 0x0c8a, 0x0d2c, 0xed50, 0xf4fa, 0xdd3b, 0xe992,
0xeba4, 0xf737, 0xf287, 0xfaba, 0xf921, 0xfeb0, 0xf10b, 0xf275, 0xeabe, 0xea0f,
0xe240, 0xe203, 0xea5d, 0xeee0, 0xf0ee, 0xf721, 0xe781, 0xea6d, 0xdd5d, 0xdf41,
0xde92, 0xe1cf, 0xe8de, 0xe94b, 0xfc06, 0xf72d, 0xf492, 0xf4c2, 0xe2a9, 0xe962,
0xe4cc, 0xe91d, 0xe72f, 0xe808, 0xe007, 0xe3b0, 0xdd6d, 0xe490, 0xdb54, 0xe1d1,
0xe60c, 0xe7c6, 0xedc3, 0xea82, 0xe4e4, 0xe2da, 0xd7dd, 0xdc9c, 0xd330, 0xdc68,
0xdc1a, 0xe634, 0xdd48, 0xe494, 0xf00b, 0xf497, 0xf674, 0xfa67, 0xdad8, 0xdb63,
0xe137, 0xe313, 0xe29e, 0xe77b, 0xdb4d, 0xdf1e, 0xcf6d, 0xd2c3, 0xda89, 0xdc2a,
0xea24, 0xec8c, 0xe827, 0xec74, 0xe5ef, 0xec1b, 0xdd7b, 0xe559, 0xd1b1, 0xd957,
0xca65, 0xd17d, 0xce16, 0xd297, 0xcf81, 0xd14f, 0xc9f0, 0xc951, 0xdb9d, 0xdc03,
0xe211, 0xe44b, 0xd1b2, 0xd451, 0xd886, 0xda6e, 0xd511, 0xd8a5, 0xd727, 0xdc3c,
0xdf86, 0xe319, 0xe917, 0xedf7, 0xd81d, 0xdc80, 0xc727, 0xcba7, 0xce45, 0xd33d,
0xe06e, 0xe726, 0xe4b3, 0xec79, 0xdc35, 0xdf09, 0xd961, 0xdaa8, 0xe50b, 0xe8db,
0xf7ee, 0xfe9a, 0x05ca, 0x0eff, 0xf035, 0xfb79, 0xe5e9, 0xf228, 0xfefb, 0x09ae,
0xf84a, 0xfee4, 0xfe50, 0x0670, 0x07dd, 0x1403, 0x05ea, 0x12f2, 0x0c5d, 0x1700,
0x0c11, 0x1631, 0x07c7, 0x144b, 0x0ff4, 0x19c7, 0x0717, 0x0f6c, 0xf444, 0xfcad,
0xf4a5, 0xfee2, 0xf131, 0xfbfe, 0xf3c9, 0xffa1, 0xff51, 0x0de1, 0xf1b7, 0xff1f,
0xf5e5, 0xfdeb, 0xfd95, 0xfe8c, 0xf18b, 0xf170, 0xfaff, 0xfeae, 0xfeeb, 0x0476,
0xf891, 0xfb54, 0xe85b, 0xe73f, 0xed23, 0xe984, 0xfa3c, 0xf5a2, 0xf89f, 0xf62e,
0xfcf5, 0xfd06, 0xff0d, 0xfd65, 0xf8a5, 0xf522, 0x0538, 0x03e4, 0x0b75, 0x0ba2,
0x11ab, 0x1173, 0x0d0e, 0x0ad3, 0x0ed7, 0x0923, 0x0854, 0x0581, 0xfb81, 0xfeb1,
0x0158, 0x04e8, 0x138d, 0x1734, 0x1e55, 0x1fde, 0x0401, 0x0221, 0xfe4e, 0xff47,
0xfc4a, 0xfd02, 0xfb39, 0xf8c6, 0xfdc5, 0xfefe, 0xff13, 0x0337, 0x0088, 0x03af,
0x0900, 0x0888, 0xf507, 0xf4f0, 0xf36c, 0xf688, 0x00cb, 0x0324, 0xf381, 0xf3e8,
0xf339, 0xf35e, 0xffd6, 0x009a, 0x076c, 0x0acd, 0x0019, 0x046d, 0xf8e6, 0xf882,
0xf306, 0xefa6, 0xffe8, 0xfa47, 0xfaa2, 0xf5d2, 0xf408, 0xf1c4, 0xf713, 0xf7f9,
0xf706, 0xf833, 0x032e, 0x052f, 0x122d, 0x1113, 0x0347, 0xfc65, 0x053a, 0x00dd,
0x02e8, 0x0098, 0xfc3c, 0xfa05, 0xf700, 0xf4cb, 0xfde8, 0xf9e7, 0x0956, 0x04e7,
0x13ed, 0x1175, 0x090e, 0x0ae5, 0x011e, 0x0428, 0x0c4d, 0x0ada, 0x150c, 0x110a,
0x0d13, 0x099f, 0xfb37, 0xfa01, 0xfac0, 0xfbc0, 0xf732, 0xf8f5, 0xfe3d, 0xfcff,
0x0930, 0x0606, 0x1172, 0x0fca, 0x0c62, 0x0d80, 0x0393, 0x05c3, 0xf7ec, 0xf9ff,
0x03d6, 0x0403, 0x11ac, 0x0f14, 0x1389, 0x116e, 0xffa4, 0xffae, 0xf43a, 0xf49f,
0xf6bf, 0xf66b, 0xff44, 0xfe7d, 0x110f, 0x0d29, 0x12da, 0x0d6a, 0x01dc, 0x0013,
0x009e, 0x0197, 0xfdc3, 0xfd12, 0x01a4, 0xfcf1, 0x0286, 0xff18, 0x0d09, 0x0900,
0x0f5b, 0x03ea, 0xfd03, 0xf2d6, 0xf9cf, 0xf884, 0x05f1, 0x09f8, 0x11cc, 0x1636,
0x0b63, 0x0cbc, 0x154f, 0x138f, 0x125c, 0x0d39, 0x01a7, 0xfdba, 0x04b9, 0x0232,
0x0622, 0x0134, 0x0783, 0x02fd, 0x08da, 0x03da, 0x0c1e, 0x0778, 0x0815, 0x052a,
0x0282, 0xfe8c, 0x11ce, 0x09c8, 0x0d52, 0x050e, 0x04f4, 0xfdc9, 0x0403, 0xff97,
0x04de, 0x02f3, 0x0d29, 0x0a73, 0x17b6, 0x10f7, 0x184d, 0x0d5e, 0x082a, 0x0073,
0xfef1, 0xfb48, 0x009b, 0x0106, 0x09cb, 0x0c87, 0x1194, 0x0f32, 0x10db, 0x0a28,
0x0a9c, 0x0848, 0x0a3a, 0x08b1, 0x1172, 0x0d1c, 0x0d66, 0x0cf6, 0x1390, 0x15c7,
0x15f5, 0x145f, 0x15d7, 0x0f04, 0x0f40, 0x091c, 0x1f62, 0x1d9b, 0x218f, 0x1f6d,
0x0c87, 0x097d, 0x0682, 0x02ac, 0x1135, 0x0a48, 0x158d, 0x1076, 0x10d1, 0x0f01,
0x0207, 0x0047, 0x03a7, 0x03ed, 0x118c, 0x11ef, 0x1279, 0x103a, 0x1281, 0x0f23,
0x175c, 0x15eb, 0x1dd7, 0x1f58, 0x16f2, 0x19c1, 0x0c25, 0x0cc0, 0x07ec, 0x04d9,
0x107a, 0x0e84, 0x1d6e, 0x1b08, 0x2342, 0x1db3, 0x1684, 0x1091, 0x1b0f, 0x1772,
0x1d6a, 0x1a9a, 0x1434, 0x1165, 0x131f, 0x1630, 0x11c2, 0x1818, 0x1060, 0x1162,
0x0d04, 0x07ea, 0x14f8, 0x1184, 0x19b6, 0x1997, 0x1837, 0x16d3, 0x0634, 0x0473,
0x03fc, 0x039c, 0x10ac, 0x1000, 0x20c8, 0x2052, 0x119a, 0x11c5, 0x0892, 0x047f,
0x0696, 0x038d, 0x1aa4, 0x1a96, 0x0dae, 0x0b0f, 0xfa39, 0xf6cf, 0x0422, 0x00e2,
0x099b, 0x0707, 0x0d00, 0x0baa, 0x0470, 0x0267, 0x1044, 0x0e60, 0x0497, 0x02df,
0xfc21, 0xfae4, 0x06bd, 0x0524, 0x090d, 0x06a1, 0x15d7, 0x10b2, 0x1ab9, 0x13b2,
0x1c31, 0x1d07, 0x087b, 0x0bb7, 0x005e, 0xfef4, 0x115c, 0x0c80, 0x143b, 0x0e33,
0x0d38, 0x0958, 0x02b4, 0xfded, 0x0b8b, 0x0686, 0x0731, 0x023a, 0x055a, 0xfd37,
0x00fc, 0xf8d9, 0x07ba, 0x01ca, 0xff3d, 0xff81, 0xf8bb, 0xfd53, 0xf918, 0xfbe4,
0x06fe, 0x0773, 0x044b, 0x03c1, 0xf2b5, 0xf2e7, 0xef36, 0xef0c, 0xf9a8, 0xf669,
0x045b, 0x017a, 0xf917, 0xf93d, 0x0310, 0x0294, 0x0c85, 0x0a6a, 0x1528, 0x0f69,
0x0def, 0x09b0, 0x00be, 0xfea0, 0x02cf, 0x006b, 0x1301, 0x109e, 0x18b8, 0x13fc,
0x0429, 0xfde7, 0xf1be, 0xee45, 0xfab3, 0xf9eb, 0x04dc, 0x02fe, 0x006f, 0xff22,
0xf62c, 0xf57a, 0xfbf5, 0xfb29, 0xfa7a, 0xf8d4, 0xed8b, 0xedf4, 0xf9a3, 0xfae5,
0xee5f, 0xef0d, 0xe348, 0xe39d, 0xeb4e, 0xe99d, 0xf03c, 0xf0d4, 0xffca, 0x0050,
0x0b67, 0x0988, 0x0228, 0x0073, 0xf712, 0xf811, 0xf8b5, 0xfafa, 0x03e6, 0x03d8,
0xf745, 0xf956, 0xeb16, 0xed98, 0xebd4, 0xe825, 0xf924, 0xf557, 0xf8cc, 0xf703,
0xf42a, 0xf55b, 0xf0ec, 0xf6fa, 0x078e, 0x0d10, 0x0e7d, 0x10c1, 0xfca1, 0xfe0b,
0xec89, 0xf1e0, 0xe6ff, 0xec86, 0xf2f7, 0xf6ae, 0xfc8a, 0xff9f, 0x0495, 0x02e5,
0x021a, 0xfd6e, 0x01a0, 0x0122, 0x05eb, 0x0ca8, 0x0b79, 0x14fe, 0x0ab2, 0x10f5,
0x042e, 0x07ae, 0x079d, 0x0ca7, 0x0a74, 0x10bd, 0x0978, 0x0e66, 0x09c2, 0x0f50,
0x0560, 0x0d0a, 0x01cf, 0x0a47, 0x0236, 0x0987, 0x08e3, 0x1285, 0x0fc3, 0x1d4a,
0x1999, 0x22f5, 0x240e, 0x2b8a, 0x13c3, 0x1a87, 0x03f0, 0x096c, 0x0395, 0x097f,
0x0626, 0x0c0f, 0x0f60, 0x139a, 0x0e7f, 0x0cb2, 0x0cd4, 0x0a76, 0x0116, 0x008c,
0x0895, 0x0a9f, 0x10f7, 0x1836, 0x209f, 0x2762, 0x10fe, 0x11a3, 0xfe25, 0xfcf9,
0x0e4d, 0x0d44, 0xfed6, 0xfead, 0xfc61, 0xfc0a, 0xfcaf, 0xfcf1, 0xfc72, 0xfc2f,
0xf587, 0xf2d2, 0xf501, 0xf643, 0x0412, 0x06e3, 0x0bf5, 0x0cba, 0x1009, 0x0ce1,
0x0a28, 0x0771, 0xf80f, 0xf702, 0xf8ab, 0xf66c, 0xfbaf, 0xf7a7, 0xf631, 0xf209,
0xf80a, 0xf27f, 0xfce4, 0xf536, 0x0122, 0xfa57, 0xf2e7, 0xefb3, 0x07ee, 0x0a06,
0x0d7b, 0x100a, 0xf47a, 0xf35b, 0xf4d2, 0xf209, 0xf8f4, 0xf546, 0xfa8f, 0xf1cb,
0xfa14, 0xf028, 0xee1f, 0xe97c, 0xf3e3, 0xf335, 0x0476, 0x0678, 0x03e6, 0x0560,
0xf5b8, 0xf3f1, 0xe082, 0xe307, 0xeb11, 0xf283, 0xe30a, 0xe865, 0xe880, 0xebac,
0xfb54, 0xfdc6, 0xeb95, 0xed98, 0xdb00, 0xdd56, 0xd996, 0xdbbe, 0xe867, 0xe8d5,
0x030c, 0x0292, 0x0d86, 0x0b57, 0xfe87, 0xfc03, 0xec26, 0xeca2, 0xec6e, 0xecd2,
0xeece, 0xee1b, 0xe912, 0xe81c, 0xe748, 0xe378, 0xf295, 0xee2b, 0xfe5c, 0xfc4c,
0xed4b, 0xef1d, 0xe4a4, 0xea09, 0xeb3c, 0xedbb, 0xf416, 0xf3f9, 0xf733, 0xf6dd,
0xefbb, 0xef30, 0xe730, 0xe762, 0xfaac, 0xf741, 0x01a8, 0xf934, 0xf49c, 0xef60,
0xdfdf, 0xe4dd, 0xd7e0, 0xe149, 0xea2f, 0xebb5, 0xfdd6, 0xf5d4, 0xf9c6, 0xf345,
0xeded, 0xf042, 0xf418, 0xf6ef, 0xffda, 0xff16, 0xf57c, 0xf2c3, 0xe8f2, 0xe6d7,
0xead5, 0xe8b3, 0xe516, 0xdf0e, 0xe9a5, 0xe487, 0xe83e, 0xe8a6, 0xeb46, 0xec08,
0xe9d0, 0xe437, 0xe741, 0xdf5e, 0xecb3, 0xe7e8, 0xf43a, 0xeff2, 0xfbde, 0xf89f,
0xf6dc, 0xf345, 0xf22a, 0xed15, 0xf35e, 0xee83, 0x03ee, 0xfdb9, 0x0c4a, 0x07e1,
0x06c4, 0x04ad, 0xfc9d, 0xf938, 0x0183, 0x00a7, 0x18a5, 0x1c76, 0x18ba, 0x1b79,
0x1345, 0x131c, 0x0cc6, 0x0b85, 0x123d, 0x1265, 0x0d7a, 0x0d1a, 0x0b66, 0x0c88,
0x17bd, 0x2062, 0x1693, 0x2027, 0x1d48, 0x24a3, 0x1ee7, 0x234e, 0x1616, 0x15e2,
0x1bf7, 0x1ac1, 0x1e30, 0x1f80, 0x15e2, 0x1afb, 0x2389, 0x2c84, 0x15bc, 0x1c92,
0x0590, 0x0471, 0x1374, 0x10fe, 0x1c2c, 0x1aa8, 0x1926, 0x1936, 0x141d, 0x147e,
0x1ecc, 0x1d38, 0x1cf5, 0x1ba8, 0x1198, 0x0e6f, 0x0c8e, 0x0752, 0x07a8, 0x0248,
0x1114, 0x0a7c, 0x2092, 0x19b3, 0x1518, 0x0fb2, 0x082c, 0x0360, 0x06fb, 0x007c,
0x14a0, 0x0e02, 0x13da, 0x0e7c, 0x1788, 0x1099, 0x269a, 0x1ead, 0x2f9d, 0x2735,
0x20ae, 0x1908, 0x13a6, 0x0d60, 0x1f01, 0x198c, 0x1663, 0x1321, 0x0da0, 0x0957,
0x1101, 0x0923, 0x16f8, 0x0b94, 0x1c46, 0x1133, 0x1810, 0x135d, 0x0dfc, 0x0bcb,
0x1483, 0x11c1, 0x0b18, 0x0660, 0x0678, 0xfc51, 0x1531, 0x0cbe, 0x2207, 0x1d4f,
0x21ca, 0x1e16, 0x134b, 0x0d72, 0x09e9, 0x0036, 0x0afd, 0x0028, 0x1105, 0x0627,
0x0e28, 0x04dd, 0x19fa, 0x131c, 0x1d7b, 0x18ba, 0x17df, 0x1184, 0x0ab5, 0x0323,
0x0c6a, 0x0673, 0x0fd9, 0x0954, 0x072f, 0x017e, 0x00f8, 0xfb1c, 0x0516, 0xfcd2,
0x10a9, 0x0c52, 0x1cc7, 0x1ba5, 0x1d3e, 0x17f5, 0x0e71, 0x0517, 0x0772, 0xff8a,
0x0ab3, 0x0540, 0x1c90, 0x187b, 0x2965, 0x24e8, 0x2571, 0x2216, 0x0dac, 0x0a1c,
0xff40, 0xf9d2, 0x0a6a, 0x01d0, 0x1454, 0x07f6, 0x0ed3, 0x08c2, 0x0305, 0x0467,
0x0e00, 0x0f01, 0x131b, 0x0f57, 0x1242, 0x0a5e, 0x136f, 0x0c81, 0x07d5, 0x0330,
0x02c1, 0x026d, 0x0d90, 0x0d48, 0x0897, 0x0114, 0x1280, 0x0b4d, 0x188c, 0x1347,
0x1817, 0x1412, 0x0237, 0xff71, 0x0ced, 0x0702, 0x2af9, 0x2321, 0x1963, 0x1365,
0x095a, 0x076f, 0x0438, 0x04b6, 0x08dd, 0x0d0a, 0x1907, 0x1add, 0x2065, 0x1bf2,
0x1d32, 0x16e8, 0x0909, 0x04ca, 0x0ef1, 0x0bf3, 0x11bc, 0x0e64, 0x0576, 0x03ca,
0x0290, 0xfd22, 0x0623, 0xfb3c, 0x0df2, 0x00c0, 0x1494, 0x0eb5, 0x0ad8, 0x0a9a,
0x0509, 0x023f, 0x11b9, 0x0f28, 0x134a, 0x0f73, 0x1353, 0x0bcb, 0x0fbf, 0x0984,
0x0bfa, 0x0d29, 0x0eb0, 0x104a, 0x10b0, 0x0d03, 0x0c19, 0x060f, 0x0620, 0x0582,
0x0888, 0x0a76, 0x0892, 0x0977, 0x07b1, 0x06dd, 0x0aae, 0x0956, 0x135a, 0x11d2,
0x1132, 0x0dc8, 0x1744, 0x164f, 0x0cda, 0x0b7c, 0xfecc, 0xff8f, 0x029e, 0x07a9,
0x12ad, 0x1371, 0x15b4, 0x1052, 0x017a, 0xfd33, 0xff1f, 0xff6a, 0xfd4a, 0xffd4,
0x070a, 0x09c2, 0x1b73, 0x1c68, 0x1b0b, 0x187b, 0x08e8, 0x0795, 0xfd8d, 0x038f,
0x04f1, 0x0b5b, 0x0cc1, 0x0e60, 0x0c49, 0x0cf5, 0xfb65, 0xff53, 0x01f2, 0x0397,
0x097f, 0x00aa, 0x05f9, 0xfc31, 0xfff9, 0xfc81, 0x06bf, 0x0ab8, 0x0f4c, 0x17da,
0x025c, 0x02d9, 0x0362, 0xfeed, 0x05f1, 0x0491, 0x0c54, 0x0e00, 0xfafb, 0xfc7f,
0xf7d0, 0xf764, 0x0050, 0xfdf5, 0x10dc, 0x0eca, 0xfc1a, 0xfc4a, 0xf679, 0xf6d2,
0x0618, 0x0562, 0x0764, 0x02d2, 0xffa2, 0xfd2e, 0xf7f1, 0xf7cb, 0xfc1e, 0xf90b,
0x0101, 0xfdee, 0xf644, 0xf787, 0xead7, 0xec86, 0xf505, 0xf234, 0xf9e6, 0xf7f3,
0xfc9e, 0xfabd, 0x0064, 0x015f, 0xf02f, 0xf5e8, 0xf1f3, 0xf18b, 0xfa0c, 0xf548,
0x0014, 0xff48, 0xf5b0, 0xf796, 0xec68, 0xf0b5, 0xf658, 0xfb4c, 0x02f1, 0x086a,
0x03c9, 0x0a7f, 0xfe78, 0x0023, 0xfd5b, 0xf922, 0xfc1e, 0xfbf7, 0xfbeb, 0x035d,
0xfbd2, 0x05bc, 0xfc85, 0x0297, 0xfd44, 0xfdba, 0xfd06, 0xfa2e, 0xf5c7, 0xf3d6,
0xe48a, 0xe930, 0xed90, 0xf256, 0x066e, 0x0958, 0xf820, 0xfaff, 0xeb06, 0xe9a9,
0xe8cb, 0xe42a, 0xf55c, 0xf382, 0xe7bd, 0xed77, 0xe2f8, 0xeb92, 0xf109, 0xf3a4,
0xf034, 0xefbc, 0xf065, 0xf153, 0xf14e, 0xf297, 0xeebe, 0xf03a, 0xf25f, 0xf2ec,
0xee18, 0xf202, 0xe7a0, 0xf0a0, 0xee07, 0xf8bf, 0xf839, 0xffab, 0xff22, 0x02f9,
0xee7c, 0xf41b, 0xf4f1, 0xfc8d, 0xf1dd, 0xf751, 0xe73c, 0xe90a, 0xe771, 0xe94c,
0xf364, 0xf53c, 0xf285, 0xf65f, 0xe3e4, 0xe9c0, 0xe9c7, 0xeda5, 0xf157, 0xf5a9,
0xf27b, 0xf74a, 0xff33, 0x0518, 0xf15d, 0xfa1f, 0xe209, 0xeefd, 0xeb2d, 0xf59b,
0xeaad, 0xf04e, 0xe77c, 0xed24, 0xe01c, 0xe7be, 0xe347, 0xeba9, 0xe2e9, 0xe7dd,
0xe48c, 0xe9c4, 0xe21b, 0xeaad, 0xe436, 0xecc5, 0xe842, 0xec7e, 0xeb10, 0xee18,
0xe125, 0xe66a, 0xe5c0, 0xead9, 0xe6d0, 0xe92d, 0xdfef, 0xe13a, 0xdfdc, 0xe0c1,
0xea3f, 0xed53, 0xf37f, 0xf8e1, 0xe7dd, 0xed5a, 0xe787, 0xeb70, 0xe807, 0xe8c3,
0xe190, 0xe306, 0xf159, 0xf27e, 0xebf6, 0xea44, 0xd960, 0xd976, 0xdb9f, 0xdda7,
0xe441, 0xe57d, 0xe7cd, 0xe904, 0xe145, 0xe138, 0xdfe4, 0xe039, 0xd8a7, 0xdb1a,
0xda65, 0xdc73, 0xe3ea, 0xe4fa, 0xe8c1, 0xea19, 0xdf80, 0xdf6c, 0xcd3c, 0xcee3,
0xd2d1, 0xd66c, 0xd67b, 0xd695, 0xd955, 0xd5b4, 0xdc6f, 0xda29, 0xdd9b, 0xdec1,
0xe51a, 0xe2c8, 0xe36e, 0xe10a, 0xe056, 0xe336, 0xdb9e, 0xdde8, 0xda13, 0xda08,
0xd7a4, 0xd8c2, 0xcfa5, 0xd462, 0xcffd, 0xd3d0, 0xcdfb, 0xd028, 0xd2b7, 0xd619,
0xced1, 0xd207, 0xccc8, 0xcea1, 0xcd59, 0xceeb, 0xd538, 0xd79d, 0xd149, 0xd6d3,
0xc6ef, 0xcc7d, 0xc6c4, 0xc8d2, 0xc333, 0xc4f6, 0xc76d, 0xc780, 0xcc2c, 0xcc50,
0xd16f, 0xd0d5, 0xd4e0, 0xd4a0, 0xd8a0, 0xdc4c, 0xcf4b, 0xd434, 0xd239, 0xd57b,
0xd68b, 0xd6f4, 0xd975, 0xdab8, 0xc926, 0xcdac, 0xc5f3, 0xca31, 0xcebb, 0xd0ed,
0xd410, 0xd54a, 0xd52c, 0xd724, 0xd695, 0xd8d2, 0xd824, 0xdb14, 0xdb51, 0xe03c,
0xd9aa, 0xe273, 0xda41, 0xe3bc, 0xdffe, 0xe5e2, 0xf11e, 0xf50e, 0xf33e, 0xf5fb,
0xd7e4, 0xdcfa, 0xe608, 0xf168, 0xe94f, 0xf7c6, 0xe540, 0xf1e1, 0xebd3, 0xf52f,
0xeef7, 0xf776, 0xf335, 0xfcfc, 0xf8c7, 0x02b3, 0xf21b, 0xff2c, 0xedfc, 0xff4b,
0xf237, 0x021a, 0xf2d2, 0xfc71, 0xfc5e, 0x0351, 0xfa6e, 0x021d, 0xf74c, 0xfdb9,
0xf68e, 0xfd3a, 0xff5a, 0x0752, 0x04ab, 0x0df0, 0x014c, 0x086a, 0xfd22, 0x030f,
0xfc03, 0x0362, 0xfe7d, 0x042d, 0x06bd, 0x084f, 0x07e3, 0x0477, 0xfce7, 0xfd56,
0xf9a5, 0xffa2, 0xf2bc, 0xf8f6, 0xfc5c, 0xfefb, 0x0707, 0x0544, 0x0430, 0x007d,
0xf981, 0xf34f, 0xf07e, 0xeb30, 0xf597, 0xf239, 0xef9a, 0xec29, 0xf869, 0xf568,
0x022c, 0x0103, 0x06ce, 0x03b5, 0x04c1, 0xfdb4, 0xf852, 0xf489, 0xf2c1, 0xf360,
0xf63f, 0xf682, 0x02ab, 0x00b4, 0x0d6e, 0x0726, 0x06e3, 0x002d, 0x001c, 0xfcee,
0x035a, 0x00f4, 0x0e0d, 0x0b32, 0xff34, 0xfdd1, 0xf75e, 0xf7b6, 0x01af, 0x011e,
0x1aa0, 0x181e, 0x13e8, 0x12d0, 0x05bb, 0x047e, 0x03d3, 0x0259, 0xff43, 0x022f,
0xfb66, 0xfe05, 0xf927, 0xf952, 0x0912, 0x0961, 0x0e16, 0x0fca, 0x1064, 0x1145,
0x08ba, 0x09cc, 0x015e, 0x042f, 0xfba6, 0xfa8b, 0xfcf7, 0xfad4, 0x0c10, 0x0c06,
0x10d4, 0x0dab, 0x0a94, 0x03ec, 0x01e7, 0xfb8f, 0x01b4, 0xff86, 0x0423, 0x040c,
0x051d, 0x023b, 0x020f, 0xfe10, 0x06af, 0x054d, 0x0945, 0x0833, 0x0909, 0x05ec,
0x0b10, 0x0982, 0x064e, 0x0552, 0x03ca, 0x01b3, 0x095b, 0x0887, 0x0a92, 0x0a05,
0x0aa1, 0x09c2, 0x0b37, 0x0b51, 0x0a0f, 0x0882, 0x0707, 0x04ad, 0x0216, 0x0396,
0x0204, 0x0522, 0x073e, 0x0736, 0x06d5, 0x03a4, 0xfe65, 0xfb48, 0x06fd, 0x0759,
0x0d43, 0x0f91, 0x0a17, 0x0cea, 0xfaad, 0xfe13, 0x021f, 0x02e4, 0x0b8b, 0x0abe,
0x0910, 0x0912, 0xf716, 0xfb3e, 0xfea3, 0x04bd, 0x0b19, 0x0c66, 0x05fd, 0x024f,
0x0864, 0x025c, 0x0a5a, 0x07da, 0x1142, 0x135f, 0x0443, 0x06a2, 0x09dd, 0x08df,
0x11a4, 0x0fbd, 0x17de, 0x15f2, 0x1630, 0x1446, 0x0e3f, 0x101e, 0x08e3, 0x0e01,
0x097c, 0x0cd7, 0x120a, 0x0f7d, 0x168c, 0x10b3, 0x1f1c, 0x1d4e, 0x07e3, 0x0ea5,
0x0197, 0x0a4c, 0x0441, 0x0a9f, 0x0f19, 0x1165, 0x032a, 0x0190, 0xfa3c, 0xf7b2,
0x0241, 0x0172, 0xfd1c, 0x0114, 0xff20, 0x00ac, 0x021c, 0xfe01, 0x0fae, 0x0c36,
0x0f4b, 0x113d, 0x1335, 0x174b, 0x141e, 0x1690, 0x1471, 0x16ca, 0x119b, 0x14af,
0x11b8, 0x12c7, 0x108d, 0x0f2e, 0x1691, 0x16bf, 0x18e5, 0x1b5f, 0x198c, 0x1b96,
0x133a, 0x153e, 0x1127, 0x11e0, 0x16a3, 0x16f5, 0x1f42, 0x2233, 0x160c, 0x1b1c,
0x0d36, 0x11d4, 0x0e38, 0x10f8, 0x1771, 0x15c7, 0x1ba4, 0x16ef, 0x14e0, 0x1415,
0x0f3a, 0x13d9, 0x0e4c, 0x13b3, 0x1625, 0x183c, 0x1d4e, 0x1ec9, 0x1eda, 0x2094,
0x192e, 0x1d5b, 0x1053, 0x13e8, 0x0638, 0x04d5, 0x063d, 0x036f, 0x0a7d, 0x06b0,
0x1167, 0x0c79, 0x12ad, 0x0d18, 0x1450, 0x1156, 0x13e3, 0x1561, 0x1232, 0x159c,
0x101d, 0x12a1, 0x0bcc, 0x0b64, 0x0c11, 0x0aa9, 0x1fa9, 0x1f06, 0x1e62, 0x1eef,
0x16df, 0x177e, 0x1c49, 0x1afb, 0x1a4c, 0x1721, 0x1102, 0x10aa, 0x0f00, 0x126d,
0x278e, 0x2b93, 0x26a8, 0x27ea, 0x131a, 0x1275, 0x00fb, 0x016f, 0x05c8, 0x054d,
0x0d82, 0x0aa1, 0x0fa1, 0x0c2a, 0x1180, 0x0ef3, 0x1170, 0x10dc, 0x0ec4, 0x0f54,
0x0b4a, 0x0906, 0x0c5d, 0x084b, 0x14a7, 0x1177, 0x1938, 0x19b9, 0x1114, 0x1530,
0x1102, 0x1264, 0x0eb1, 0x0ad2, 0x0b76, 0x05ef, 0x0ea5, 0x0ae6, 0x0e6f, 0x0d30,
0x0ba2, 0x0bd9, 0x04c4, 0x04a4, 0x0d61, 0x0ec3, 0x1268, 0x1268, 0x0abb, 0x085b,
0x0aa8, 0x0827, 0x05bb, 0x0574, 0x05bb, 0x0511, 0x05d1, 0xff09, 0x0a80, 0x020a,
0x09e0, 0x049b, 0x0818, 0x051b, 0x021d, 0xfe90, 0x0302, 0xffd6, 0x072d, 0x04de,
0x07dd, 0x05ef, 0x03e2, 0x008f, 0x072d, 0x0477, 0x0e73, 0x1053, 0x021a, 0x0414,
0xfddb, 0xf8c4, 0xffca, 0xf5ea, 0xfd51, 0xf5c7, 0x079e, 0x03ba, 0x0b33, 0x0a90,
0x0644, 0x0809, 0xfa08, 0xfb35, 0xfad0, 0xfa02, 0xff97, 0xffdb, 0x07a8, 0x05aa,
0xf873, 0xf330, 0xf3b2, 0xeee4, 0xfa25, 0xf735, 0xf74b, 0xf99f, 0xf6f7, 0xf9f9,
0xf979, 0xf99c, 0x0a20, 0x079c, 0x08d0, 0x064d, 0xff3b, 0x0274, 0xf15a, 0xfa83,
0xefac, 0xf8b9, 0xf83e, 0xfb01, 0xfa2a, 0xf7bd, 0xf4f0, 0xf1f8, 0xf060, 0xed39,
0xf2b9, 0xf05c, 0xf70e, 0xf4f5, 0xf802, 0xf678, 0xf15e, 0xf38f, 0xed5b, 0xf1ad,
0xee20, 0xf3ab, 0xe491, 0xebbc, 0xe46d, 0xe933, 0xeb8e, 0xed22, 0xf901, 0xfbb1,
0xf4c6, 0xf8d4, 0xf04e, 0xf690, 0xf23b, 0xfab0, 0xfa3f, 0x0179, 0xf748, 0xfb41,
0xf3df, 0xf452, 0xfda4, 0xfedb, 0xfcde, 0x006a, 0xf8dd, 0xfd51, 0xf425, 0xfa05,
0xfe59, 0x020d, 0xfe1c, 0x0194, 0xf943, 0xfd91, 0xf511, 0xf968, 0xf66a, 0xff3e,
0xf701, 0x01a2, 0xfc77, 0x0429, 0xff73, 0x0611, 0x00b3, 0x0793, 0x004a, 0x0903,
0x0253, 0x0b8e, 0xfb4f, 0xff26, 0xf752, 0xfa7f, 0xfba5, 0x01f7, 0x00d5, 0x0772,
0x088b, 0x0eeb, 0x02ef, 0x0a1b, 0xfab1, 0x0053, 0xff07, 0x050e, 0x0934, 0x0fff,
0x0dae, 0x12c1, 0x1510, 0x1a95, 0x133f, 0x1b1f, 0x0e97, 0x175f, 0x0b25, 0x0f12,
0x0afc, 0x0e7c, 0x06c1, 0x0e28, 0x0291, 0x0b3a, 0x0b57, 0x11c3, 0x0f6c, 0x15be,
0x0c92, 0x1380, 0x0704, 0x082d, 0xfffb, 0x00d1, 0xfaf2, 0xfeb9, 0xfd69, 0xffbe,
0x0817, 0x0541, 0x11c6, 0x0cd5, 0x0fb1, 0x0e41, 0x09b0, 0x07fd, 0x0796, 0x0160,
0x05de, 0x0011, 0x05a2, 0x0545, 0x04ea, 0x0672, 0x0303, 0x02d8, 0x0318, 0x029a,
0x070f, 0x07cf, 0x0204, 0x00b3, 0xfdff, 0xfa03, 0x0014, 0xfb15, 0x08ff, 0x0475,
0x0548, 0x0150, 0xfdb1, 0xf8de, 0xffd1, 0xfaf9, 0xfc67, 0xf93c, 0xfb10, 0xf862,
0xfd06, 0xf6a7, 0xf3a9, 0xecb0, 0xf703, 0xf271, 0x0140, 0xfcba, 0x081f, 0x00c8,
0xfd14, 0xf3c4, 0xf1ad, 0xea13, 0xf1f3, 0xf05e, 0xf621, 0xf74b, 0xff06, 0xff33,
0xfb41, 0xfb5f, 0xf36f, 0xf02f, 0xecfe, 0xe846, 0xf063, 0xeeaf, 0xf147, 0xf01f,
0xf0cf, 0xecb0, 0xee0b, 0xe6cf, 0xf499, 0xefdc, 0xfae5, 0xfbe6, 0xfa29, 0xfa1f,
0xf1ef, 0xf0a0, 0xe8dd, 0xe728, 0xe9e3, 0xe8e7, 0xefd7, 0xf23b, 0xf9e9, 0xfa22,
0xfd39, 0xf887, 0x0213, 0xfc0a, 0xfaea, 0xf7a5, 0xef1a, 0xf1c7, 0xeb50, 0xee88,
0xefb5, 0xf233, 0xf5d8, 0xf87c, 0xf605, 0xf585, 0xfb60, 0xf64c, 0xf1a6, 0xed88,
0xe3e3, 0xe718, 0xdf56, 0xe3ab, 0xe4cc, 0xe61b, 0xe998, 0xe661, 0xec93, 0xe549,
0xf378, 0xee7d, 0xf225, 0xf16c, 0xf32c, 0xf3a5, 0xf58c, 0xf5c1, 0xec97, 0xed02,
0xea7d, 0xec65, 0xedae, 0xf019, 0xecc6, 0xee5e, 0xed2b, 0xeedd, 0xf107, 0xf0f9,
0xf9ba, 0xf51c, 0xfdfd, 0xf6fc, 0xf788, 0xf5bb, 0xec0f, 0xf0a4, 0xe6e4, 0xe8b9,
0xe67f, 0xe477, 0xf0c3, 0xede3, 0xfea9, 0xfb6d, 0x013a, 0xff01, 0xfb83, 0xfa20,
0xf54d, 0xf5c9, 0xf630, 0xf4b2, 0xfd3d, 0xfb51, 0x05af, 0x05e9, 0x0fb0, 0x0f12,
0xff84, 0xfe79, 0xf7e3, 0xf6f4, 0xfb63, 0xfb79, 0xf5a4, 0xf7eb, 0xfb1f, 0xfd18,
0xfefd, 0xfd49, 0x00e9, 0xff2d, 0x021d, 0x0176, 0x089e, 0x0802, 0x0e9d, 0x0c28,
0x0e50, 0x0b7d, 0x107a, 0x0e3a, 0x0f34, 0x0d25, 0x0e72, 0x0ded, 0x1210, 0x121b,
0x1e13, 0x1ef2, 0x20c5, 0x2276, 0x16c3, 0x16fb, 0x1391, 0x12f6, 0x16e5, 0x183a,
0x1e07, 0x20bd, 0x287a, 0x2955, 0x28ae, 0x2763, 0x2278, 0x1fa3, 0x1bcd, 0x19aa,
0x12ae, 0x14b1, 0x165f, 0x18c7, 0x2226, 0x21bb, 0x1cd3, 0x1934, 0x1d48, 0x191a,
0x2115, 0x1df9, 0x2433, 0x2222, 0x1f76, 0x1b59, 0x1f8a, 0x1b9b, 0x2542, 0x21f2,
0x2168, 0x1d15, 0x2059, 0x1c4f, 0x21e5, 0x1ad2, 0x21e2, 0x1a61, 0x20fc, 0x1a69,
0x20cf, 0x199a, 0x20b7, 0x1a97, 0x1f99, 0x1a5a, 0x278d, 0x2147, 0x294c, 0x2115,
0x1c57, 0x1205, 0x1f75, 0x1545, 0x26e1, 0x1ca3, 0x25ee, 0x1ee3, 0x1ca7, 0x165a,
0x1a77, 0x0dcc, 0x1fd1, 0x12ec, 0x29a8, 0x22e6, 0x2373, 0x1e85, 0x1ed4, 0x17dd,
0x21b2, 0x1659, 0x2358, 0x16aa, 0x1ed5, 0x1695, 0x1ab7, 0x144f, 0x19e9, 0x0f7a,
0x2698, 0x1a6c, 0x1f01, 0x182b, 0x10f8, 0x0de5, 0x148a, 0x1077, 0x199f, 0x1600,
0x1b92, 0x18d9, 0x18b9, 0x151f, 0x1a0d, 0x155d, 0x1b42, 0x1529, 0x1cb7, 0x130d,
0x16a3, 0x0a2c, 0x161d, 0x0cea, 0x1749, 0x13a2, 0x1c1d, 0x17cd, 0x17ae, 0x0e47,
0x188d, 0x0e72, 0x1a57, 0x14be, 0x185b, 0x14dd, 0x1129, 0x0de8, 0x13ad, 0x0fd1,
0x1e10, 0x1708, 0x173c, 0x0eed, 0x1482, 0x0c0b, 0x13eb, 0x0be1, 0x13d6, 0x0f5f,
0x0e03, 0x0cba, 0x13f5, 0x1193, 0x1969, 0x16ff, 0x0c82, 0x0b9a, 0x078e, 0x05bb,
0x0d92, 0x08f3, 0x13bb, 0x0c84, 0x2096, 0x1aa9, 0x1b34, 0x1796, 0x0af5, 0x0832,
0x0b8a, 0x086d, 0x11a4, 0x0d2b, 0x1796, 0x13cf, 0x1831, 0x1533, 0x1554, 0x10e6,
0x1132, 0x0d96, 0x115f, 0x0d9a, 0x13eb, 0x0faa, 0x1713, 0x13a2, 0x17f7, 0x10e3,
0x1522, 0x0aaf, 0x0df0, 0x05d7, 0x1066, 0x0e8f, 0x17e7, 0x18a2, 0x12b7, 0x0e58,
0x0d21, 0x06c8, 0x0c55, 0x094c, 0x1517, 0x123a, 0x0cc9, 0x075a, 0x0975, 0x03a7,
0x0dc3, 0x069d, 0x10b4, 0x0665, 0x0e1d, 0x040b, 0x0a18, 0x0598, 0x0cb7, 0x0d5c,
0x1160, 0x1180, 0x0ff3, 0x0e78, 0x0ec4, 0x098c, 0x0c53, 0x056a, 0x0fbd, 0x0c80,
0x0a50, 0x0b54, 0x03ba, 0x03db, 0x023d, 0xface, 0x0e33, 0x03ba, 0x1772, 0x1001,
0x0f3a, 0x0d9d, 0x03a9, 0x03b4, 0xfff9, 0xfef4, 0x09df, 0x0a4e, 0x09fe, 0x0913,
0x0e03, 0x0bf7, 0x0c3c, 0x09d0, 0x07db, 0x0502, 0x01a6, 0xfe0a, 0x0357, 0xfed0,
0x0920, 0x047b, 0x0c1a, 0x09e0, 0x081d, 0x0acb, 0x0419, 0x0701, 0xff5c, 0x0010,
0x06b4, 0x08b4, 0x0935, 0x0bc5, 0x031b, 0x024f, 0xfa29, 0xf6b6, 0xfc47, 0xf8c3,
0x016f, 0xff1e, 0xfdc9, 0xfa0d, 0x0504, 0x001e, 0x04ac, 0x0221, 0xfe23, 0xfff8,
0xf907, 0xfd24, 0xfb61, 0xfdd5, 0xff45, 0xff39, 0xff41, 0xfc8e, 0x01f3, 0xfe06,
0x015e, 0xfc44, 0xfa51, 0xf619, 0xfa67, 0xf81a, 0xfb99, 0xfa9b, 0xfcb4, 0xfef0,
0x012e, 0x0395, 0xf95e, 0xfa34, 0xf352, 0xf2ef, 0xf49e, 0xf2ee, 0xf36f, 0xf2af,
0xf26b, 0xf2d1, 0xf3d9, 0xf31b, 0xf7d5, 0xf5dd, 0xf262, 0xee14, 0xf5c6, 0xf04c,
0xfb99, 0xfabe, 0xf97f, 0xfc94, 0xf96c, 0xfc97, 0xf683, 0xf9f9, 0xf135, 0xf72a,
0xf359, 0xf8cc, 0xf2ab, 0xf6e6, 0xf0cb, 0xf2a0, 0xf2ae, 0xf170, 0xf38d, 0xf22b,
0xf54a, 0xf718, 0xf661, 0xfb87, 0xef67, 0xf709, 0xea6e, 0xf4a5, 0xee7a, 0xf35f,
0xef01, 0xee71, 0xf03e, 0xf184, 0xe8ad, 0xee7b, 0xe4ed, 0xebce, 0xec0a, 0xeff4,
0xf2d6, 0xf533, 0xf224, 0xf481, 0xe862, 0xeb23, 0xead0, 0xed16, 0xe961, 0xed91,
0xe62f, 0xecc3, 0xe8a9, 0xef0b, 0xe757, 0xee13, 0xe1c7, 0xe843, 0xd8b0, 0xdd5f,
0xdd5e, 0xe039, 0xe86d, 0xec1a, 0xed6c, 0xf140, 0xe65e, 0xe9f9, 0xe342, 0xe85e,
0xe39c, 0xeb70, 0xe7d2, 0xf09a, 0xe7a3, 0xecc4, 0xe585, 0xe9fb, 0xe45f, 0xe941,
0xe58b, 0xeacc, 0xe405, 0xebc2, 0xe3cc, 0xee1c, 0xe957, 0xf281, 0xec75, 0xf11e,
0xeb6b, 0xed66, 0xe533, 0xe77d, 0xe1ec, 0xe753, 0xdb26, 0xe2af, 0xde16, 0xe529,
0xe522, 0xeb8e, 0xe70c, 0xecce, 0xe2c5, 0xe5ce, 0xdda3, 0xdfc8, 0xe14f, 0xe3f4,
0xe348, 0xe693, 0xe298, 0xe7df, 0xdacb, 0xe10e, 0xdfd7, 0xe73e, 0xe4ce, 0xed69,
0xe453, 0xebea, 0xdeaf, 0xe282, 0xe0da, 0xe13c, 0xe37e, 0xe2b2, 0xdb6a, 0xdc9b,
0xe3af, 0xe825, 0xe53a, 0xea2a, 0xe1fd, 0xe4a6, 0xded4, 0xdfcd, 0xd96b, 0xda29,
0xd80b, 0xda75, 0xd9cd, 0xde76, 0xda34, 0xe023, 0xd983, 0xdd25, 0xd875, 0xd71b,
0xdac1, 0xd870, 0xd4b6, 0xd6e4, 0xd118, 0xd64d, 0xd5a8, 0xd9ad, 0xda73, 0xdb3b,
0xde3e, 0xdede, 0xdcdf, 0xdeaf, 0xd885, 0xd90e, 0xdae4, 0xdb0f, 0xda12, 0xd9a2,
0xd43f, 0xd46f, 0xd4f2, 0xd5bd, 0xd9f9, 0xd996, 0xdf98, 0xe0bf, 0xdc92, 0xdf34,
0xe128, 0xe1c3, 0xdf38, 0xdc63, 0xda88, 0xd4d5, 0xd848, 0xd36e, 0xd613, 0xd6eb,
0xd51e, 0xd8f8, 0xd96a, 0xddee, 0xd6da, 0xdb74, 0xd444, 0xd72f, 0xd458, 0xd5fc,
0xd5b9, 0xd938, 0xcf67, 0xd35f, 0xcc19, 0xcd49, 0xd39b, 0xd2a0, 0xd0eb, 0xd107,
0xca4a, 0xcc9f, 0xca65, 0xca66, 0xd08c, 0xcf44, 0xd31c, 0xd42f, 0xce18, 0xd22d,
0xc505, 0xcadb, 0xc2ed, 0xc87c, 0xc8ca, 0xcce2, 0xcf17, 0xd13a, 0xd17a, 0xceff,
0xce02, 0xc849, 0xc9e1, 0xc6b1, 0xc5e0, 0xc6b6, 0xcabb, 0xceed, 0xd152, 0xd6f3,
0xd3a4, 0xd9f0, 0xcebb, 0xd460, 0xccaf, 0xd2f6, 0xcf29, 0xd37b, 0xd501, 0xd7e8,
0xd2de, 0xd8ad, 0xd335, 0xda73, 0xd436, 0xdb30, 0xd6fb, 0xdbfa, 0xd402, 0xd93d,
0xd803, 0xdda7, 0xe638, 0xe959, 0xe81e, 0xeccc, 0xd9f4, 0xe432, 0xd0ae, 0xdb45,
0xddb1, 0xe5e7, 0xe1d8, 0xe82b, 0xe452, 0xe9e7, 0xe3d0, 0xe8b7, 0xe969, 0xee17,
0xec4c, 0xf205, 0xeb85, 0xf52a, 0xee4c, 0xfb1f, 0xefcf, 0xfaea, 0xf248, 0xfcba,
0xf1f4, 0xfb77, 0xf1c5, 0xfa14, 0xf0bc, 0xfaa4, 0xf04f, 0xfd39, 0xf422, 0xfff5,
0xff65, 0x060e, 0xff31, 0x0392, 0xf4d4, 0xf9a6, 0xf523, 0xfa22, 0xf4b5, 0xfcf0,
0xf572, 0xffed, 0xf979, 0x0208, 0xfea2, 0x039b, 0x0003, 0x03a4, 0xfad2, 0xfe22,
0xfab5, 0xfb49, 0xfc3e, 0xfa1a, 0x022f, 0xffb9, 0x054b, 0x0444, 0x0514, 0x0710,
0x05fe, 0x06c3, 0x033e, 0x032d, 0xffb0, 0x01a0, 0xfe8f, 0xfdb2, 0x00be, 0xfb8c,
0x02fb, 0xfc9b, 0x010b, 0xfb97, 0x024f, 0xfaad, 0x065b, 0xfee7, 0x0cb6, 0x0747,
0x0a4d, 0x034a, 0x054f, 0xfddf, 0xffe3, 0xfe0e, 0x0486, 0x061c, 0x0c93, 0x0be7,
0x0ebb, 0x0be1, 0x0958, 0x04d6, 0x09ed, 0x0594, 0x0ec0, 0x0b45, 0x1004, 0x0b53,
0x1096, 0x0c04, 0x0c28, 0x08c0, 0x0891, 0x06fb, 0x0637, 0x0669, 0x0a06, 0x0a42,
0x0b02, 0x0a99, 0x0a6a, 0x078d, 0x08d6, 0x03f1, 0x0af8, 0x06a9, 0x0ec7, 0x0bb3,
0x0a04, 0x059e, 0x0b69, 0x06c5, 0x0d40, 0x0808, 0x0caf, 0x032f, 0x062e, 0x003a,
0x06b0, 0x0664, 0x0e33, 0x0a5a, 0x1198, 0x0b6c, 0x14df, 0x1025, 0x136e, 0x0e1c,
0x10e0, 0x093e, 0x1030, 0x083f, 0x1219, 0x0d51, 0x12ab, 0x116a, 0x161d, 0x14a3,
0x19a9, 0x14d4, 0x158d, 0x0fc2, 0x0c28, 0x0897, 0x0d2e, 0x0be4, 0x10c4, 0x0df5,
0x1264, 0x0c87, 0x1327, 0x0e27, 0x0e17, 0x0b81, 0x10dd, 0x0f63, 0x1877, 0x16ca,
0x0d57, 0x0b5e, 0x0aa9, 0x0856, 0x0d37, 0x0a13, 0x1215, 0x0d6c, 0x0dd8, 0x0954,
0x0e88, 0x0df0, 0x1970, 0x1a34, 0x15e1, 0x1434, 0x10c9, 0x0d73, 0x0e83, 0x0b25,
0x187e, 0x1715, 0x123a, 0x1206, 0x0d77, 0x101d, 0x109c, 0x138e, 0x1286, 0x120a,
0x12b7, 0x1153, 0x0f3d, 0x0fc6, 0x0a0f, 0x0d2a, 0x12e4, 0x15ff, 0x17c2, 0x17c0,
0x1549, 0x1450, 0x155a, 0x1664, 0x1412, 0x1732, 0x12b3, 0x144f, 0x1257, 0x0e80,
0x0fcb, 0x0e95, 0x0f97, 0x1386, 0x1342, 0x168d, 0x1315, 0x172b, 0x0d82, 0x1313,
0x0b42, 0x0f4a, 0x11b8, 0x11c5, 0x14d6, 0x128b, 0x12c3, 0x127f, 0x1085, 0x1159,
0x0b3d, 0x0c93, 0x1090, 0x128c, 0x11e9, 0x1424, 0x0de9, 0x0f8b, 0x0dde, 0x0e21,
0x13ba, 0x15e3, 0x1c65, 0x21ab, 0x1d78, 0x22c0, 0x18de, 0x1c76, 0x177d, 0x18ec,
0x1815, 0x1b14, 0x1876, 0x1c75, 0x1621, 0x18d5, 0x1627, 0x192f, 0x1b8e, 0x1f44,
0x1c1c, 0x2045, 0x18aa, 0x1ba0, 0x13d9, 0x14fe, 0x1e19, 0x2054, 0x1b32, 0x1f01,
0x13c9, 0x158a, 0x1021, 0x0fb7, 0x13d9, 0x1548, 0x1a4e, 0x1d16, 0x1a2b, 0x1b56,
0x116c, 0x126b, 0x0bdf, 0x0cf5, 0x0f6d, 0x0ffe, 0x158c, 0x1618, 0x1a2c, 0x1caa,
0x19b7, 0x1c2f, 0x179d, 0x1800, 0x0c86, 0x0b69, 0x0a71, 0x0ad7, 0x101b, 0x110b,
0x19e4, 0x1713, 0x1937, 0x151b, 0x1b77, 0x1877, 0x1ee9, 0x1c82, 0x187e, 0x146d,
0x1383, 0x0f07, 0x1207, 0x11b4, 0x170c, 0x199d, 0x1d9f, 0x1b3e, 0x1d66, 0x1876,
0x19b9, 0x17f4, 0x150f, 0x1458, 0x1981, 0x18ff, 0x1987, 0x17f6, 0x15f4, 0x1368,
0x1978, 0x1654, 0x1c5c, 0x1c2b, 0x1eca, 0x2009, 0x18c6, 0x18f9, 0x1294, 0x13a9,
0x0c01, 0x0ce1, 0x0c1f, 0x0aec, 0x0dd8, 0x0a85, 0x127b, 0x0f21, 0x15b3, 0x1462,
0x1057, 0x10c7, 0x0d83, 0x0c87, 0x0e38, 0x0d00, 0x103e, 0x11e4, 0x0936, 0x0d25,
0x08f7, 0x0b13, 0x0e2c, 0x0ca7, 0x11ea, 0x0f35, 0x102a, 0x0deb, 0x0f33, 0x0e6f,
0x1038, 0x11c6, 0x0bd4, 0x0dcd, 0x0ed1, 0x0d4c, 0x0eb6, 0x0e73, 0x0cee, 0x0fd7,
0x0b09, 0x0cf2, 0x073f, 0x0840, 0x02e3, 0x034f, 0x056f, 0x0545, 0x07ad, 0x0540,
0x08f2, 0x0478, 0x0af2, 0x06af, 0x0a60, 0x082a, 0x0ad3, 0x09b3, 0x0683, 0x060f,
0x038a, 0x03da, 0x02eb, 0x02ed, 0x0236, 0x02c6, 0x03e3, 0x047d, 0x05a7, 0x0813,
0x040a, 0x0914, 0x031e, 0x0495, 0x015f, 0xfdd5, 0xfe2a, 0xfb3a, 0xffd8, 0xfe9c,
0x025d, 0x01c8, 0x017e, 0x0381, 0xfe90, 0x02c6, 0xfd0c, 0x000c, 0xfb53, 0xfd01,
0xfc19, 0xfce8, 0x000e, 0xfef0, 0xff39, 0xffbf, 0xfd50, 0x0118, 0xfcba, 0x0094,
0xfdd8, 0xfee4, 0x0674, 0x04d6, 0xfc06, 0xfd0e, 0xef02, 0xf5e1, 0xef9c, 0xf688,
0xf4c8, 0xf734, 0xf799, 0xf7e2, 0xf6cd, 0xf690, 0xf862, 0xfaef, 0xf117, 0xf782,
0xee41, 0xf4ad, 0xef2a, 0xf3b1, 0xf35c, 0xf71b, 0xf20e, 0xf6d8, 0xef2d, 0xf611,
0xf347, 0xf9a4, 0xf3ac, 0xf9cb, 0xeffc, 0xf745, 0xe7e4, 0xefe3, 0xedaa, 0xf430,
0xf06f, 0xf412, 0xef00, 0xf4f0, 0xee9e, 0xf576, 0xf446, 0xfa7d, 0xf662, 0xff82,
0xf403, 0xfbcf, 0xe9dc, 0xf120, 0xed2c, 0xf431, 0xf280, 0xfb23, 0xf511, 0xfd5b,
0xf0b4, 0xf653, 0xe865, 0xf0e0, 0xee33, 0xf565, 0xf9c0, 0xfe37, 0xff1e, 0x03a7,
0xf90f, 0xfeb2, 0xf51e, 0xfd06, 0xef9b, 0xf796, 0xf36f, 0xf8eb, 0xf49f, 0xfc06,
0xf753, 0x0126, 0xf760, 0xfead, 0xf64c, 0xfa49, 0xfbb3, 0xfe69, 0xfd75, 0x01ab,
0x00c3, 0x064a, 0x00ca, 0x069a, 0xf374, 0xfa63, 0xf2d3, 0xfa74, 0xfc75, 0x00cc,
0x0477, 0x08c2, 0x012a, 0x089f, 0xffda, 0x08ce, 0x0375, 0x0ca1, 0xfd90, 0x0560,
0xfe93, 0x05ae, 0x00bc, 0x057b, 0x0306, 0x052c, 0x015e, 0x02d7, 0xfe8f, 0x00ed,
0xfd2b, 0x02da, 0xfe40, 0x03e5, 0x0119, 0x03a5, 0x0170, 0x00f9, 0x0470, 0x0390,
0x09d2, 0x0aae, 0x0749, 0x0939, 0x042e, 0x0482, 0x06a8, 0x0449, 0x05ed, 0x0541,
0x0284, 0x0311, 0xfd27, 0xfd54, 0x00c5, 0x011a, 0x0348, 0x01e7, 0x010d, 0xfd4c,
0x00de, 0xfc7f, 0xfc58, 0xfa31, 0xfe40, 0xfe8a, 0x08bd, 0x066d, 0x0b70, 0x0764,
0x09d4, 0x0701, 0x05c1, 0x038d, 0x0372, 0xfff7, 0x01f8, 0xfe0e, 0x0142, 0xfda5,
0x0591, 0x0067, 0x02d5, 0xff59, 0x05d0, 0x039b, 0x0426, 0x02de, 0x039c, 0x032d,
0xf862, 0xf84d, 0xf3a4, 0xf1e2, 0xf90f, 0xf5d4, 0xfe91, 0xfd5a, 0xff57, 0xfd83,
0xfc71, 0xf808, 0xffc7, 0xfab9, 0xfdec, 0xfb64, 0xf69d, 0xf86d, 0xf1f3, 0xf366,
0xfa93, 0xf7b3, 0xfd67, 0xf8a2, 0xfd71, 0xf7ba, 0xf955, 0xf4a4, 0xfbac, 0xf9b8,
0xf735, 0xf825, 0xf15b, 0xf237, 0xf4f8, 0xf2c6, 0xf88a, 0xf6ce, 0xfe78, 0xfd53,
0x05b8, 0x03fb, 0xfdcb, 0xfac5, 0xf6e3, 0xf351, 0xf5ca, 0xf4ae, 0xf04e, 0xefff,
0xf66e, 0xf3ac, 0xfbfb, 0xf7fb, 0xfbc8, 0xf96e, 0xf1f0, 0xf123, 0xf39d, 0xf359,
0xfae8, 0xfb08, 0xfbe3, 0xfab7, 0xfb0a, 0xf90f, 0xf70d, 0xf77f, 0xef87, 0xefcb,
0xf8a8, 0xf51c, 0xfaec, 0xf7fb, 0xf35e, 0xf537, 0xe88b, 0xec64, 0xea7b, 0xea76,
0xf08b, 0xecd5, 0xf0db, 0xedb5, 0xfaef, 0xfa25, 0xfd3f, 0xfcc7, 0xfd5a, 0xfe9a,
0xf785, 0xfc2f, 0xf5de, 0xf918, 0xf6dc, 0xf592, 0xf957, 0xf564, 0xfa0b, 0xf850,
0xfad0, 0xfb14, 0xfc61, 0xfbaa, 0xfe8d, 0xfc0b, 0xfce8, 0xf869, 0xfb14, 0xf8db,
0xfc31, 0xfc8c, 0xffd4, 0xfeac, 0x03b9, 0x02e0, 0x02a1, 0x0253, 0xfbd9, 0xf9cd,
0xfc14, 0xfa2b, 0xfd22, 0xfc84, 0xfd9a, 0xfc37, 0x02be, 0xfe46, 0x03ec, 0x007f,
0x07a0, 0x05d0, 0x097f, 0x065c, 0x0921, 0x081b, 0x03b2, 0x042b, 0x00ed, 0xfe48,
0x06bb, 0x0095, 0x0892, 0x01cb, 0x0ad3, 0x0564, 0x0dea, 0x0b3e, 0x17fe, 0x14d9,
0x1981, 0x1532, 0x11ee, 0x0e91, 0x14d2, 0x1130, 0x13aa, 0x115c, 0x13e8, 0x1399,
0x1330, 0x1318, 0x1656, 0x157b, 0x18b3, 0x1552, 0x16ab, 0x0ef0, 0x10a9, 0x08e8,
0x1242, 0x0e05, 0x1d4e, 0x17bf, 0x252f, 0x1f12, 0x2518, 0x1f0b, 0x2141, 0x19d7,
0x1eeb, 0x183d, 0x2057, 0x1ab5, 0x1c14, 0x16aa, 0x1a00, 0x133f, 0x1e9c, 0x1767,
0x21b3, 0x1b0b, 0x2438, 0x2101, 0x24f7, 0x243b, 0x20dc, 0x1c0d, 0x231f, 0x1989,
0x242f, 0x1953, 0x2171, 0x17b4, 0x2106, 0x18df, 0x227b, 0x1c68, 0x233c, 0x1d40,
0x23c0, 0x1bdd, 0x208c, 0x155c, 0x1f13, 0x1197, 0x21ff, 0x17e0, 0x25bc, 0x1e2a,
0x2bd4, 0x23bc, 0x2c20, 0x2470, 0x2d11, 0x25d0, 0x24a9, 0x1e7a, 0x1fc3, 0x18ee,
0x1fb2, 0x1750, 0x2065, 0x1a0b, 0x232f, 0x1ddd, 0x24c6, 0x1d21, 0x2410, 0x1ddc,
0x2138, 0x1d56, 0x23bb, 0x1d5c, 0x246a, 0x1990, 0x23f2, 0x1753, 0x1f89, 0x1622,
0x1cb3, 0x191e, 0x19f1, 0x1609, 0x20fa, 0x1a17, 0x2296, 0x1c27, 0x1dd5, 0x182f,
0x1b11, 0x1472, 0x17b8, 0x10da, 0x17d6, 0x12d0, 0x1ca7, 0x1a64, 0x1f9f, 0x1c60,
0x1d13, 0x174f, 0x1a81, 0x1542, 0x17d7, 0x1357, 0x15d8, 0x13ac, 0x17ff, 0x146f,
0x1b30, 0x13a8, 0x1f47, 0x17cc, 0x1d68, 0x17ee, 0x18cd, 0x1264, 0x1674, 0x1112,
0x1714, 0x15bc, 0x181d, 0x1731, 0x1727, 0x142b, 0x158f, 0x117e, 0x1463, 0x1315,
0x16ef, 0x17c3, 0x10ea, 0x0f91, 0x139c, 0x0fc3, 0x16b0, 0x12e1, 0x1523, 0x12ca,
0x169f, 0x1529, 0x1758, 0x14a5, 0x1756, 0x1308, 0x15c1, 0x1008, 0x113d, 0x0b88,
0x0fb3, 0x09ca, 0x0f62, 0x0afb, 0x11b9, 0x0eb8, 0x11a8, 0x0d9c, 0x11ed, 0x0c41,
0x1876, 0x123b, 0x18e9, 0x12cc, 0x13e0, 0x0ec3, 0x0d0b, 0x09eb, 0x0e3e, 0x09bb,
0x0f15, 0x0876, 0x0e1a, 0x07e7, 0x11f8, 0x0bd8, 0x15b7, 0x1091, 0x12c2, 0x0f20,
0x0cea, 0x081d, 0x0db2, 0x07b9, 0x0f60, 0x097a, 0x0f36, 0x0940, 0x0c4d, 0x072b,
0x0e97, 0x0a26, 0x0f37, 0x0b61, 0x0b37, 0x07e3, 0x0353, 0xffc4, 0x05a0, 0x00ee,
0x0b0f, 0x0683, 0x0901, 0x045b, 0x07c0, 0x0410, 0x086b, 0x0451, 0x0927, 0x043d,
0x08ae, 0x04eb, 0x05ab, 0x00c6, 0x0070, 0xfdcd, 0xfdd1, 0xfe13, 0x01f8, 0x0140,
0x098b, 0x081a, 0x0e5b, 0x0aa4, 0x094f, 0x038e, 0x0271, 0xfc19, 0xffe4, 0xfbb2,
0x0023, 0xfc85, 0xff82, 0xfb4c, 0xff6d, 0xfb9e, 0x00cb, 0xff10, 0xfe80, 0xfe1b,
0x00f3, 0xfef2, 0x02fc, 0xffef, 0x0035, 0xfe42, 0xfaad, 0xfa2d, 0xfd6c, 0xfb41,
0x00fe, 0xfe6b, 0xfb02, 0xfc41, 0xf7d3, 0xf9fc, 0xf851, 0xf87b, 0xf7e7, 0xf971,
0xfb9a, 0xff1d, 0xffa4, 0x0198, 0xfd43, 0xfc86, 0xf33a, 0xf2ef, 0xf0f3, 0xf335,
0xf40a, 0xf7df, 0xf67b, 0xf840, 0xf6e4, 0xf7f8, 0xf1aa, 0xf629, 0xed52, 0xf427,
0xeace, 0xf007, 0xf090, 0xf31c, 0xf2ba, 0xf469, 0xef1a, 0xf039, 0xef23, 0xf012,
0xedf9, 0xeebf, 0xeb8a, 0xed91, 0xec9f, 0xf25f, 0xee31, 0xf503, 0xf102, 0xf590,
0xf143, 0xf4d2, 0xf0be, 0xf315, 0xef8b, 0xf235, 0xed74, 0xf04a, 0xeeab, 0xf2ae,
0xebad, 0xf2a6, 0xeaa8, 0xf0a3, 0xe9da, 0xec8f, 0xe835, 0xea55, 0xea08, 0xef00,
0xec42, 0xf279, 0xee35, 0xf333, 0xe737, 0xed12, 0xe06c, 0xe769, 0xe029, 0xe7c1,
0xe3cb, 0xea79, 0xe4ea, 0xeac1, 0xe4e2, 0xec3b, 0xe33b, 0xeb5c, 0xe41b, 0xec01,
0xe223, 0xe8e4, 0xde31, 0xe4a5, 0xdd37, 0xe55a, 0xdd76, 0xe709, 0xdff3, 0xe797,
0xddc0, 0xe269, 0xdf29, 0xe2df, 0xdf14, 0xe4cd, 0xdd00, 0xe592, 0xde2f, 0xe88b,
0xde95, 0xe6da, 0xdf14, 0xe52c, 0xdb88, 0xe26a, 0xda3b, 0xe38b, 0xda27, 0xe42c,
0xdc57, 0xe441, 0xda44, 0xe0c2, 0xdfae, 0xe6d2, 0xe37c, 0xeb8d, 0xdfdd, 0xe750,
0xdd61, 0xe37f, 0xdb4e, 0xe095, 0xdcbc, 0xe2bc, 0xdcee, 0xe2c8, 0xdcd9, 0xe216,
0xdae9, 0xe1ad, 0xd8f0, 0xe2d5, 0xd8e6, 0xe289, 0xdc34, 0xe137, 0xdd74, 0xdf6a,
0xd865, 0xdb93, 0xd94c, 0xdd35, 0xdc2f, 0xdfd4, 0xdfa7, 0xe2c7, 0xdf62, 0xe296,
0xd90d, 0xdcb3, 0xd572, 0xd881, 0xd677, 0xd95e, 0xd8ee, 0xdd27, 0xdb84, 0xdfaa,
0xdd44, 0xde0f, 0xe012, 0xe0c4, 0xdd99, 0xdfb7, 0xd8cc, 0xd944, 0xd8bf, 0xd850,
0xda5b, 0xda8e, 0xd9d0, 0xdb27, 0xd8e3, 0xdb50, 0xdd51, 0xde96, 0xde16, 0xde95,
0xdc67, 0xddae, 0xd97c, 0xdaf0, 0xd993, 0xd9f9, 0xda96, 0xd9cd, 0xd96f, 0xd857,
0xd5a9, 0xd531, 0xd766, 0xd68a, 0xda0e, 0xd8f8, 0xdabf, 0xdae8, 0xd865, 0xd9a6,
0xd8b3, 0xd72d, 0xd579, 0xd13c, 0xcfa0, 0xcce4, 0xce56, 0xcc17, 0xd2d2, 0xd0e7,
0xd6c4, 0xd359, 0xd96c, 0xd5ec, 0xd5c6, 0xd5ab, 0xcf63, 0xd122, 0xce7a, 0xceec,
0xd0bd, 0xd01b, 0xd5b2, 0xd4fb, 0xd76c, 0xd60a, 0xd5a3, 0xd576, 0xd1e0, 0xd4a5,
0xd187, 0xd28e, 0xd6e1, 0xd3a8, 0xd45a, 0xd0b9, 0xcead, 0xcda5, 0xcd3c, 0xcd10,
0xcff2, 0xcf09, 0xcf2f, 0xd128, 0xce1d, 0xd288, 0xd284, 0xd5c5, 0xcfd8, 0xd36d,
0xcdec, 0xd2a5, 0xce02, 0xcf9d, 0xd226, 0xd149, 0xd3d3, 0xd1cd, 0xd459, 0xd2a9,
0xd5c2, 0xd7a1, 0xd187, 0xd521, 0xcfd5, 0xd1b2, 0xcf8a, 0xcf40, 0xd007, 0xd103,
0xce62, 0xd2f7, 0xd075, 0xd455, 0xd4ec, 0xd5a9, 0xd30d, 0xd3c2, 0xcfe9, 0xcf55,
0xce81, 0xcd47, 0xd40c, 0xd465, 0xd7a0, 0xda38, 0xd803, 0xdd13, 0xd707, 0xdd73,
0xd58c, 0xda41, 0xd50f, 0xd8c5, 0xd47d, 0xd971, 0xd92b, 0xddfa, 0xdc33, 0xe04f,
0xdb43, 0xe005, 0xda57, 0xdeef, 0xdb54, 0xddb3, 0xde89, 0xe2a3, 0xe247, 0xe891,
0xe117, 0xe6c3, 0xdd6d, 0xe319, 0xde03, 0xe35c, 0xe23c, 0xe852, 0xe62d, 0xed2c,
0xe7c4, 0xede4, 0xe8a0, 0xed46, 0xe8c7, 0xeccc, 0xea96, 0xefbd, 0xed91, 0xf2cf,
0xf352, 0xf875, 0xf24d, 0xf97d, 0xf16f, 0xfa03, 0xf1d8, 0xfa67, 0xf31f, 0xfa2b,
0xf52a, 0xf9e6, 0xf4de, 0xfaab, 0xf6e1, 0xfe1a, 0xf7ff, 0xfd25, 0xf9c7, 0xfb5e,
0xf9df, 0xfba0, 0xfa69, 0xfe12, 0xfb57, 0xfe82, 0xfa29, 0xfd6c, 0xf8a6, 0xfc41,
0xf8b7, 0xfa19, 0xf97c, 0xf8bc, 0xfd5d, 0xfbed, 0xff0b, 0xfd93, 0xff6b, 0xfc41,
0xfddd, 0xf83b, 0xfff4, 0xfa84, 0xfce4, 0xf8bc, 0x00f6, 0xfe8a, 0x07f1, 0x0607,
0x0421, 0x014e, 0x01c4, 0xfe2c, 0x03c9, 0x000d, 0x0af6, 0x0895, 0x0881, 0x0482,
0x080a, 0x01da, 0x0ad5, 0x03cd, 0x10e4, 0x081d, 0x0f5a, 0x074d, 0x0bc1, 0x0620,
0x0c07, 0x06f2, 0x0afe, 0x05f8, 0x0a5c, 0x051e, 0x09db, 0x0414, 0x0b29, 0x05ca,
0x0b4b, 0x0747, 0x0c35, 0x07db, 0x0ebd, 0x0a8b, 0x0ee7, 0x0a75, 0x0f46, 0x06fe,
0x10a3, 0x04f2, 0x151f, 0x08f7, 0x13de, 0x0a65, 0x109a, 0x0a1d, 0x1182, 0x0bd1,
0x134f, 0x0c89, 0x112e, 0x0a04, 0x0f47, 0x07f5, 0x131f, 0x0937, 0x14a1, 0x0893,
0x1662, 0x0cdf, 0x1866, 0x116b, 0x193e, 0x12e9, 0x1702, 0x10ea, 0x1452, 0x0ca4,
0x1193, 0x08a2, 0x13c6, 0x0b76, 0x14f0, 0x0ee0, 0x1461, 0x0f01, 0x118b, 0x0b9e,
0x1260, 0x0bf4, 0x13bb, 0x0c1f, 0x16bf, 0x0e47, 0x18c9, 0x0f83, 0x1891, 0x1080,
0x179b, 0x120d, 0x13db, 0x0de1, 0x14bb, 0x0f09, 0x162d, 0x1131, 0x1565, 0x1143,
0x180f, 0x1175, 0x17c0, 0x0d76, 0x1777, 0x0fdd, 0x1806, 0x1606, 0x1b33, 0x1cf6,
0x19ae, 0x1b69, 0x11c8, 0x0f55, 0x0dbe, 0x09e1, 0x11a6, 0x0e4d, 0x18c2, 0x151d,
0x175e, 0x16e5, 0x173d, 0x17c1, 0x14f3, 0x15bf, 0x1563, 0x164a, 0x1865, 0x17b1,
0x1d67, 0x1bb1, 0x2028, 0x1ca7, 0x1aee, 0x196f, 0x16e2, 0x17d9, 0x18b5, 0x156b,
0x18f1, 0x14a2, 0x18d1, 0x199f, 0x15cc, 0x1924, 0x141a, 0x15c9, 0x1324, 0x1460,
0x1a2a, 0x1b38, 0x1f10, 0x1d11, 0x1b10, 0x1a6b, 0x14da, 0x16a7, 0x14c8, 0x1777,
0x189b, 0x1ad2, 0x191b, 0x1b30, 0x173b, 0x1b8c, 0x14a0, 0x187b, 0x15c6, 0x1738,
0x14d0, 0x1827, 0x17cf, 0x1d06, 0x1b5a, 0x1e38, 0x1c6e, 0x1cb3, 0x185f, 0x18d2,
0x14bc, 0x17cd, 0x1876, 0x1bf9, 0x1a03, 0x1cce, 0x1c8b, 0x1f34, 0x1a60, 0x1bf2,
0x16b9, 0x18da, 0x11ed, 0x15e4, 0x1457, 0x1826, 0x1bcb, 0x1f92, 0x1dca, 0x2062,
0x1cc2, 0x1f28, 0x1b34, 0x1e15, 0x1a2f, 0x1e98, 0x1535, 0x192c, 0x1295, 0x1434,
0x1395, 0x1499, 0x168d, 0x16be, 0x171c, 0x1816, 0x186f, 0x19d4, 0x187e, 0x1995,
0x18bb, 0x1abf, 0x1525, 0x1915, 0x1528, 0x169c, 0x18c1, 0x144c, 0x1692, 0x13f8,
0x109b, 0x12b5, 0x0f3b, 0x0f9f, 0x1238, 0x1055, 0x137c, 0x139a, 0x1479, 0x15fe,
0x1a86, 0x1a83, 0x18df, 0x171f, 0x1386, 0x1308, 0x1535, 0x163f, 0x1b54, 0x1981,
0x1da3, 0x1a9a, 0x1838, 0x1614, 0x1425, 0x1286, 0x12d8, 0x12bb, 0x1529, 0x15bb,
0x1929, 0x180f, 0x1aad, 0x1860, 0x1674, 0x1517, 0x1536, 0x13d1, 0x18e2, 0x15de,
0x1a5b, 0x1582, 0x1869, 0x146e, 0x1484, 0x1261, 0x1003, 0x0fad, 0x0e03, 0x0ddc,
0x1092, 0x102f, 0x13c3, 0x1454, 0x15a0, 0x1710, 0x143e, 0x1489, 0x0fd9, 0x1108,
0x1162, 0x1396, 0x1193, 0x129b, 0x10fb, 0x10b8, 0x0d50, 0x0d96, 0x0ce0, 0x0e77,
0x0e7e, 0x1012, 0x0f77, 0x1076, 0x11ea, 0x11cc, 0x1414, 0x1686, 0x11f0, 0x1661,
0x0b4b, 0x0eb9, 0x09a2, 0x09e8, 0x0a9f, 0x09fc, 0x0d6f, 0x0e66, 0x0b18, 0x0cd6,
0x0a85, 0x0c8a, 0x0ae6, 0x0cc8, 0x0969, 0x0cda, 0x0822, 0x0c23, 0x075f, 0x08b9,
0x07d7, 0x0918, 0x063c, 0x08fc, 0x0709, 0x0a19, 0x064b, 0x0948, 0x0338, 0x071a,
0xffd7, 0x0389, 0xff69, 0xff65, 0x0383, 0x0312, 0x0609, 0x07d5, 0x084d, 0x0a5c,
0x0586, 0x089f, 0x01e9, 0x080e, 0xfedb, 0x0441, 0x0067, 0x050a, 0x0365, 0x095d,
0x0288, 0x08c0, 0xfdeb, 0x0454, 0xfb45, 0x0077, 0xfd07, 0x00ca, 0x0000, 0x0400,
0x007e, 0x0504, 0xfe27, 0x026d, 0xfb4c, 0x0164, 0xf9fb, 0x008c, 0xfb27, 0xff6f,
0xfd75, 0x001f, 0xfaf0, 0x00bb, 0xf943, 0x01ec, 0xf8cc, 0xfe50, 0xf595, 0xf7eb,
0xf35c, 0xf67e, 0xf4c7, 0xf997, 0xf75e, 0xfd11, 0xf839, 0xfcd4, 0xf4f9, 0xfac9,
0xf0b6, 0xf89a, 0xf08b, 0xf8f9, 0xf55c, 0xfedd, 0xf80c, 0x01d9, 0xf63b, 0xfeb3,
0xf492, 0xfbaa, 0xf478, 0xfb1a, 0xf535, 0xfb02, 0xf3b3, 0xfa11, 0xf51d, 0xfd7c,
0xf197, 0xfbb1, 0xefc7, 0xf908, 0xf752, 0xfd8b, 0xfacb, 0xfed3, 0xf887, 0xfb76,
0xf4f2, 0xf6e3, 0xf445, 0xf8df, 0xf503, 0xfe98, 0xf6a8, 0x0042, 0xf8d2, 0xffdb,
0xfafc, 0x0062, 0xf8a9, 0xfe36, 0xf380, 0xf921, 0xf4aa, 0xf92c, 0xf33a, 0xf7e4,
0xf0fb, 0xf6fe, 0xed9f, 0xf4ba, 0xf311, 0xfb2a, 0xf851, 0x0018, 0xf7c8, 0xfe7d,
0xf5c3, 0xfa45, 0xf28e, 0xf5cf, 0xf265, 0xf848, 0xf2c8, 0xfccd, 0xf6f9, 0x043a,
0xf87e, 0x03d1, 0xf673, 0xfb5d, 0xf620, 0xf78c, 0xf67f, 0xfa93, 0xf892, 0x01a3,
0xfaf8, 0x0327, 0xfeb4, 0x0183, 0x0000, 0x005f, 0xfb91, 0xfda6, 0xf89b, 0xfc46,
0xf96c, 0xfd9e, 0xf9be, 0xfe69, 0xf810, 0xfcb4, 0xfa9e, 0xfd89, 0xfc9a, 0xfdab,
0xfe12, 0xfe13, 0xfff7, 0x00e7, 0x0054, 0x0303, 0xff3a, 0x01ea, 0xfcd7, 0xfd44,
0xfc47, 0xfa4e, 0xfd0d, 0xfb38, 0x00f3, 0xff33, 0x009a, 0x01e6, 0xfde5, 0x024a,
0xfee8, 0x0259, 0x003b, 0x00d6, 0x0002, 0xfdc1, 0x00eb, 0xfdce, 0x0249, 0x021c,
0x0047, 0x03e8, 0xff54, 0xffa9, 0xfe0e, 0xfb41, 0xfe09, 0xfd47, 0xfac4, 0xfa54,
0xfc64, 0xf92b, 0x03e7, 0x00bb, 0x080d, 0x086a, 0x0358, 0x062f, 0xfd41, 0xff87,
0xfd82, 0xfe7a, 0xfe0a, 0xfd46, 0xfddd, 0xfc51, 0xfdc6, 0xfc7a, 0x00e2, 0xfcb6,
0x0524, 0xff1e, 0x03f0, 0xffe9, 0xfd34, 0xfbc1, 0x0105, 0x0136, 0x054f, 0x051f,
0x0485, 0x0361, 0x02be, 0x0119, 0x0390, 0x0186, 0x0379, 0x03cf, 0xfe04, 0xfed5,
0x00eb, 0x015a, 0x0116, 0x0139, 0xfdfb, 0xfdd7, 0xfcdc, 0xfe64, 0xfec6, 0x0177,
0x01a6, 0x04a2, 0x00c1, 0x0296, 0x031b, 0x02bb, 0xfe98, 0xfd7b, 0xf941, 0xf859,
0xfcab, 0xf9b3, 0xffe5, 0xfc49, 0xff24, 0xfe07, 0xfe54, 0xff94, 0xff61, 0x010a,
0xffc7, 0xffab, 0xfef7, 0xfd88, 0x0152, 0x0215, 0x0052, 0x0263, 0xff82, 0x01af,
0x01a7, 0x033d, 0x027f, 0x024a, 0x007b, 0xff78, 0xfc8c, 0xfbee, 0xfab3, 0xfb0a,
0xfc05, 0xfca2, 0xfe5a, 0x0085, 0xfdee, 0xffb0, 0x0051, 0x0223, 0x00a0, 0x00dd,
0xfeeb, 0xfd17, 0xfda7, 0xfbec, 0xfd83, 0xfb31, 0xfff3, 0xfea6, 0xfe35, 0xff40,
0xfabe, 0xfa00, 0xfd76, 0xfa56, 0xfff9, 0xfea1, 0x0198, 0x031e, 0xfeb4, 0x00cf,
0xfdad, 0xfdf6, 0xff47, 0x006a, 0x040b, 0x04c7, 0x07a4, 0x043c, 0x05b8, 0x0117,
0x038f, 0x00b6, 0x02b9, 0xff77, 0x04c7, 0xffd7, 0x0853, 0x04a2, 0x0832, 0x06b8,
0x063c, 0x0513, 0x05fe, 0x05e4, 0x02c7, 0x00c0, 0x0885, 0x0493, 0x0a2c, 0x0572,
0x0999, 0x0428, 0x0919, 0x03fb, 0x074e, 0x02a9, 0x06d4, 0x01b2, 0x0733, 0xffb6,
0x0ace, 0x05ff, 0x0e09, 0x0ce4, 0x115f, 0x0e1d, 0x125b, 0x0bbe, 0x0f10, 0x0707,
0x0d1f, 0x058d, 0x1215, 0x0bae, 0x1082, 0x0a09, 0x0bfa, 0x056f, 0x0aa7, 0x044d,
0x0f2d, 0x0822, 0x10f3, 0x094b, 0x102b, 0x0897, 0x139b, 0x0d22, 0x13de, 0x0def,
0x1635, 0x0f12, 0x17dc, 0x0e66, 0x19a6, 0x0f02, 0x13c8, 0x0840, 0x124f, 0x0923,
0x14b7, 0x0f7f, 0x1660, 0x1114, 0x1589, 0x0d45, 0x12e4, 0x09d4, 0x130a, 0x0cc6,
0x1835, 0x1200, 0x1ab2, 0x134e, 0x190c, 0x10f3, 0x17ec, 0x0e74, 0x171c, 0x0d44,
0x1679, 0x0ede, 0x157f, 0x0ffb, 0x17b2, 0x10b3, 0x168e, 0x0d53, 0x148c, 0x09e3,
0x1515, 0x0bd4, 0x182e, 0x1119, 0x1a5f, 0x15d4, 0x1b0c, 0x1607, 0x1894, 0x1068,
0x1775, 0x0e96, 0x152d, 0x0bcf, 0x16a4, 0x0d86, 0x160a, 0x0dc3, 0x1559, 0x0f25,
0x16ed, 0x0fdc, 0x1773, 0x0f7a, 0x16d7, 0x0f5e, 0x15bd, 0x0edf, 0x1562, 0x11c3,
0x15cc, 0x1134, 0x165e, 0x0f01, 0x1542, 0x0d97, 0x1490, 0x0e48, 0x153d, 0x0f02,
0x1466, 0x0de8, 0x161f, 0x1293, 0x13af, 0x1327, 0x11fe, 0x1001, 0x14e2, 0x0edb,
0x1697, 0x1010, 0x1955, 0x1564, 0x16a9, 0x154f, 0x1388, 0x1260, 0x10dd, 0x0e59,
0x101a, 0x0bda, 0x0eee, 0x08f3, 0x0d2b, 0x0736, 0x0e48, 0x0a7a, 0x1355, 0x105f,
0x149f, 0x0f8a, 0x14fd, 0x1119, 0x11bd, 0x111f, 0x0ebc, 0x0f24, 0x0c22, 0x0b3c,
0x0c21, 0x0aa0, 0x0f61, 0x0de2, 0x0de9, 0x0adf, 0x0c5f, 0x05a8, 0x0bb7, 0x0531,
0x0d6c, 0x0d0e, 0x0d85, 0x0ea1, 0x0ef2, 0x0cf5, 0x1074, 0x0b61, 0x10be, 0x0b03,
0x0f97, 0x0a21, 0x0e86, 0x08db, 0x0da5, 0x0857, 0x0b54, 0x07af, 0x089e, 0x073f,
0x0632, 0x064c, 0x096d, 0x0532, 0x0ae3, 0x0263, 0x0b59, 0x0615, 0x0b44, 0x0980,
0x09fd, 0x07de, 0x0816, 0x04be, 0x06d9, 0x0347, 0x0890, 0x051e, 0x09e9, 0x04fc,
0x0ba7, 0x047d, 0x09b1, 0x0341, 0x061c, 0x039f, 0x0200, 0xffd2, 0x0087, 0xfb95,
0x03a2, 0xfee0, 0x0868, 0x037a, 0x0ab7, 0x047f, 0x0898, 0x0184, 0x05f6, 0xfe73,
0x0293, 0xfb7f, 0x02ed, 0xfb56, 0x024f, 0xfbf9, 0x05d3, 0x01bd, 0x0703, 0x026f,
0x0459, 0xfc93, 0x03b5, 0xfbcb, 0xfecb, 0xf9f6, 0xfd5c, 0xf9ee, 0xfe4d, 0xfa38,
0x01c4, 0xfe93, 0x0054, 0xfd1b, 0xfe37, 0xf8d3, 0x0180, 0xfa78, 0x02ae, 0xfb76,
0xffa3, 0xfa97, 0xfabe, 0xf809, 0xfbb1, 0xf76a, 0xfe9e, 0xfaa7, 0xff1b, 0xfe92,
0xfe16, 0xfeaf, 0x0076, 0xff43, 0xffed, 0xfe28, 0xfcee, 0xfb27, 0xf9e3, 0xf5e6,
0xf907, 0xf62f, 0xf983, 0xfc13, 0xf9fb, 0xfeb3, 0xfadd, 0xfc68, 0xf90a, 0xf8bc,
0xf8bd, 0xf7e7, 0xf753, 0xf6d7, 0xf664, 0xf66f, 0xf76f, 0xf827, 0xfb54, 0xfc6e,
0xfaa2, 0xfb57, 0xf5c7, 0xf7e5, 0xf231, 0xf4a1, 0xf32a, 0xf445, 0xf242, 0xf304,
0xf153, 0xf424, 0xf3d3, 0xf782, 0xf64d, 0xfa41, 0xf64f, 0xfbc1, 0xf202, 0xf689,
0xefd4, 0xf25d, 0xef5f, 0xf1d8, 0xed94, 0xf3f4, 0xe94e, 0xf189, 0xebb1, 0xf1ca,
0xee86, 0xf386, 0xf028, 0xf497, 0xebcc, 0xf05c, 0xeb1f, 0xf0d5, 0xecfd, 0xf43c,
0xed21, 0xf2fa, 0xed39, 0xf1c6, 0xed7a, 0xf302, 0xef36, 0xf56b, 0xecf9, 0xf28d,
0xec20, 0xef41, 0xeb76, 0xef3e, 0xe7bf, 0xeee0, 0xe8de, 0xf299, 0xeace, 0xf4dd,
0xe96b, 0xf2c4, 0xe71e, 0xee24, 0xe72c, 0xeb5a, 0xe8c0, 0xee1e, 0xe772, 0xee69,
0xe875, 0xf076, 0xe87d, 0xf075, 0xe917, 0xf026, 0xeb48, 0xefe9, 0xeadd, 0xefc7,
0xe962, 0xf0e2, 0xe77b, 0xeeeb, 0xe8b8, 0xf002, 0xe9cb, 0xf17c, 0xe92b, 0xf219,
0xee09, 0xf6ab, 0xee48, 0xf66b, 0xec73, 0xf407, 0xea8b, 0xf0a9, 0xe84a, 0xef1e,
0xe5e4, 0xef3d, 0xe497, 0xef31, 0xe78a, 0xf1dd, 0xe70c, 0xeeb4, 0xe685, 0xeb8c,
0xe8a8, 0xece6, 0xe790, 0xed1e, 0xe631, 0xef17, 0xe801, 0xf0a8, 0xeb42, 0xf202,
0xeb14, 0xf0e5, 0xe713, 0xee3e, 0xe54f, 0xee3d, 0xe564, 0xeb47, 0xe64a, 0xe84c,
0xe6ad, 0xe9f9, 0xe6fd, 0xed48, 0xeb0f, 0xf1f0, 0xee8e, 0xf4b8, 0xef32, 0xf7ad,
0xeda6, 0xf713, 0xe9eb, 0xefc1, 0xe89c, 0xeba7, 0xe72c, 0xea65, 0xe916, 0xedf1,
0xed1c, 0xf178, 0xeeef, 0xf217, 0xeec7, 0xf237, 0xed54, 0xf1ff, 0xe9b1, 0xef6c,
0xe8d2, 0xef4d, 0xe932, 0xef79, 0xebba, 0xeff5, 0xeee6, 0xed3c, 0xf388, 0xef50,
0xefbe, 0xef11, 0xe8f2, 0xecdd, 0xe5d7, 0xea11, 0xe7dd, 0xe77c, 0xeb62, 0xe72c,
0xec1e, 0xe88f, 0xec8f, 0xec68, 0xed20, 0xee71, 0xeda8, 0xedd9, 0xeb97, 0xe924,
0xed56, 0xea30, 0xede8, 0xedb2, 0xeec1, 0xf25d, 0xed36, 0xf09d, 0xea86, 0xeb56,
0xeac7, 0xe791, 0xef2b, 0xeaff, 0xedd5, 0xecef, 0xed36, 0xefed, 0xee7a, 0xf1ca,
0xede0, 0xecf9, 0xed17, 0xe7d5, 0xeb56, 0xe645, 0xeb12, 0xe82f, 0xeae7, 0xe87d,
0xe9b8, 0xe93f, 0xe91f, 0xea72, 0xeb30, 0xebf8, 0xecf5, 0xec48, 0xee0a, 0xed6d,
0xf09d, 0xf024, 0xeda4, 0xedd9, 0xee64, 0xee7d, 0xee68, 0xed6e, 0xeedb, 0xef57,
0xecb6, 0xedfe, 0xea5a, 0xec76, 0xeded, 0xee6e, 0xec91, 0xead6, 0xec20, 0xeb5e,
0xec59, 0xee74, 0xee1f, 0xf267, 0xef4b, 0xf273, 0xf114, 0xf1a7, 0xf352, 0xf271,
0xeec8, 0xef9c, 0xec78, 0xeea7, 0xed89, 0xec72, 0xf037, 0xeeb4, 0xf01f, 0xf2ae,
0xf064, 0xf3bd, 0xf32b, 0xf382, 0xf2c0, 0xf343, 0xeffd, 0xf487, 0xedd9, 0xf351,
0xef2e, 0xf310, 0xee37, 0xf160, 0xee6b, 0xf08d, 0xf04e, 0xf179, 0xed71, 0xef50,
0xec91, 0xf1ba, 0xeeb3, 0xf6e3, 0xf1e4, 0xf9b8, 0xf221, 0xf77b, 0xefde, 0xf2c8,
0xf082, 0xf40d, 0xf338, 0xf8d5, 0xf2ff, 0xf8f0, 0xf275, 0xf89a, 0xf4e1, 0xf9c7,
0xf508, 0xf778, 0xf64b, 0xfabf, 0xf9b2, 0x00b0, 0xfe25, 0x044d, 0xfb00, 0x0031,
0xf63f, 0xfa32, 0xfa3a, 0xfde5, 0xf9f7, 0xffd5, 0xfb4b, 0x028b, 0xffe2, 0x04d4,
0x0076, 0x033c, 0x01d7, 0x04a7, 0x00a6, 0x0541, 0xfd4b, 0x01f0, 0xfd0a, 0x0204,
0xfefa, 0x0560, 0x0213, 0x0731, 0x02f4, 0x041f, 0x08be, 0x06df, 0x0a02, 0x090f,
0x041e, 0x04c0, 0xfef1, 0x0003, 0x0094, 0x0386, 0x0400, 0x08fa, 0x02d1, 0x0709,
0x04c2, 0x034d, 0x06f1, 0x03aa, 0x097b, 0x0931, 0x076a, 0x0971, 0x049a, 0x0789,
0x02a9, 0x03fb, 0x0420, 0x0402, 0x05f5, 0x0559, 0x0824, 0x05cd, 0x0ce6, 0x0876,
0x09b2, 0x0497, 0x05ec, 0x01bf, 0x066a, 0x039c, 0x091e, 0x05e1, 0x0b93, 0x079f,
0x0d25, 0x097c, 0x0f93, 0x0b37, 0x0dc5, 0x06a6, 0x0b4c, 0x0259, 0x0ad5, 0x015c,
0x0d3a, 0x051c, 0x0d1c, 0x07de, 0x0aaf, 0x06cf, 0x0b40, 0x06fd, 0x0dae, 0x06e1,
0x1043, 0x08eb, 0x0f24, 0x091c, 0x09fe, 0x064c, 0x076b, 0x0348, 0x0ada, 0x035c,
0x0cc6, 0x0440, 0x0fbe, 0x07a8, 0x0f31, 0x075c, 0x0fef, 0x076e, 0x0fa3, 0x076d,
0x11c2, 0x0bac, 0x1246, 0x0bb6, 0x101b, 0x0804, 0x10a8, 0x08c0, 0x108f, 0x0817,
0x1068, 0x07fe, 0x0f31, 0x0920, 0x0f02, 0x09c5, 0x0fde, 0x0791, 0x1201, 0x0886,
0x131a, 0x0b03, 0x10e5, 0x0aab, 0x0dd2, 0x06cc, 0x0d92, 0x0590, 0x0fe5, 0x090c,
0x0fa6, 0x0aba, 0x0d5f, 0x094b, 0x0d7d, 0x082f, 0x0d89, 0x049e, 0x0d20, 0x03f0,
0x0efd, 0x0847, 0x1008, 0x0a53, 0x0fd6, 0x0b1f, 0x0ecf, 0x0b96, 0x0eb1, 0x0cda,
0x0fd0, 0x0c49, 0x0f47, 0x0ab6, 0x0ebc, 0x0a56, 0x0e99, 0x099a, 0x0eb1, 0x09bc,
0x0d9a, 0x08b3, 0x0d4b, 0x0982, 0x0f1e, 0x0e55, 0x1123, 0x114c, 0x1248, 0x1059,
0x102a, 0x0c63, 0x0eec, 0x0b32, 0x0efe, 0x0ca8, 0x0ed6, 0x0f55, 0x109a, 0x12e7,
0x125a, 0x116a, 0x1328, 0x0fea, 0x0cfa, 0x0bca, 0x0951, 0x0978, 0x0976, 0x0b65,
0x0c22, 0x0fb5, 0x0e9b, 0x1175, 0x0ce7, 0x11e9, 0x0a2f, 0x11eb, 0x0a0c, 0x0f78,
0x0c67, 0x0ea7, 0x0dc4, 0x0f81, 0x0917, 0x0a39, 0x07bc, 0x096d, 0x0a38, 0x0e7c,
0x0b96, 0x0ea7, 0x09cd, 0x0bdc, 0x0956, 0x0d9f, 0x0ac7, 0x0efe, 0x0c55, 0x0f2e,
0x09c2, 0x0e12, 0x07eb, 0x0d58, 0x0a00, 0x0d63, 0x0ae0, 0x0c61, 0x0b98, 0x0dd0,
0x0b5f, 0x0ee7, 0x0c98, 0x10f3, 0x0bd8, 0x0fac, 0x0b5d, 0x0c7d, 0x0aa6, 0x0bd7,
0x09df, 0x0d48, 0x0e0f, 0x0fff, 0x0fce, 0x0f35, 0x0c0a, 0x0cae, 0x08c4, 0x0a75,
0x0714, 0x07c5, 0x0910, 0x093b, 0x0b43, 0x0b10, 0x0c81, 0x0b00, 0x0b21, 0x07e7,
0x0729, 0x0513, 0x081f, 0x081a, 0x0c81, 0x0d61, 0x0eb8, 0x0f24, 0x0b6b, 0x0a58,
0x070e, 0x04c2, 0x0580, 0x03c0, 0x05b6, 0x0403, 0x0604, 0x03eb, 0x05f6, 0x0451,
0x05fa, 0x061f, 0x0a35, 0x0bac, 0x0bfe, 0x0c20, 0x098c, 0x058d, 0x07aa, 0x0240,
0x0832, 0x05d4, 0x0ab6, 0x094e, 0x0af6, 0x0691, 0x08e2, 0x031c, 0x065b, 0x038e,
0x06af, 0x042f, 0x072e, 0x03ae, 0x0910, 0x0748, 0x0a88, 0x0966, 0x0a2b, 0x075a,
0x083a, 0x0546, 0x0632, 0x03af, 0x051b, 0x047c, 0x0555, 0x045b, 0x0b14, 0x0791,
0x0802, 0x04d0, 0x03e7, 0xfeef, 0x019a, 0xfbc1, 0x035f, 0x00ea, 0x03e0, 0x04c2,
0x02e6, 0x034f, 0x05bb, 0x02b6, 0x0650, 0x0328, 0x07ed, 0x06a6, 0x06f2, 0x05fd,
0x0674, 0x064b, 0x064e, 0x069a, 0x0775, 0x06a3, 0x06b1, 0x0510, 0x0557, 0x0442,
0x05ec, 0x0631, 0x0832, 0x095b, 0x09a8, 0x09f2, 0x0736, 0x060c, 0x038f, 0x035a,
0xffef, 0x005f, 0xffda, 0x0048, 0x02bb, 0x0454, 0x0513, 0x071b, 0x063c, 0x07a0,
0x0396, 0x02cf, 0x01b4, 0xff8e, 0x0034, 0x0026, 0x01bc, 0x03dc, 0x023d, 0x044b,
0xffd5, 0x005a, 0x003a, 0x017b, 0x00fb, 0x0488, 0x0143, 0x0611, 0xffab, 0x036f,
0xff55, 0x010f, 0xfd18, 0xff25, 0xf976, 0xfc45, 0xfc6b, 0xfeab, 0x0023, 0x030e,
0x0045, 0x0745, 0xfec4, 0x0648, 0x0159, 0x035c, 0x01b6, 0xffd3, 0xfb0d, 0xfb90,
0xfa50, 0x0016, 0xfa8d, 0x02ef, 0xf9ed, 0x0250, 0xfac7, 0x0179, 0xfe34, 0x024c,
0xff92, 0x01ca, 0xfb22, 0xfdc5, 0xfa77, 0xfece, 0xfb80, 0x0335, 0xfcbb, 0x06c4,
0xfe18, 0x06a8, 0xfcb0, 0x0317, 0xf936, 0xffbd, 0xf70a, 0xff30, 0xf7a5, 0xfe2b,
0xfb2e, 0xff64, 0xfcb0, 0x0280, 0xfaa7, 0x03b9, 0xf8ae, 0x046a, 0xf80a, 0x0320,
0xf892, 0xff2b, 0xf93f, 0xfc2d, 0xf96e, 0xfcb5, 0xf748, 0xf9b1, 0xf51e, 0xf9f3,
0xf69c, 0xff5e, 0xf869, 0x01d2, 0xf94a, 0x01e6, 0xf5bd, 0xfc3f, 0xf72f, 0xfb87,
0xfa43, 0xfe30, 0xfb7b, 0x0156, 0xfcd5, 0x0549, 0xfbf0, 0x04c2, 0xfb05, 0x02dd,
0xf9d5, 0x005b, 0xf84b, 0xfdce, 0xf7bb, 0xfd4d, 0xf855, 0xfd07, 0xfa61, 0xfe76,
0xfaae, 0xff4c, 0xf8f9, 0xfe39, 0xf876, 0xfdd4, 0xf836, 0xfe79, 0xf9cb, 0xff7e,
0xf9bc, 0xfc98, 0xf8a3, 0xfae5, 0xf888, 0xfc7d, 0xf95b, 0xfe89, 0xfa7c, 0xff3f,
0xfa42, 0xfd1c, 0xf9b8, 0xfbe5, 0xf990, 0xfc44, 0xfc1c, 0xfe8c, 0xfdd8, 0xff5b,
0xfc88, 0xfcbd, 0xf8b5, 0xfa5e, 0xf7f3, 0xfbe4, 0xfa00, 0xfb7b, 0xfbe9, 0xfc56,
0xfad6, 0xfc7c, 0xfab0, 0xfc7f, 0xfba7, 0xfcd5, 0xfea3, 0xfdcf, 0x0030, 0xfeb7,
0xff17, 0xfe68, 0xfc91, 0xfb19, 0xfc9e, 0xf961, 0xfcb1, 0xfae2, 0xfb9c, 0xfae8,
0xfbe5, 0xfb53, 0xffe6, 0xfdf3, 0xff47, 0xfc88, 0xf978, 0xf4fb, 0xf97f, 0xf197,
0xfcf9, 0xf7cd, 0x001e, 0xfeb4, 0xff6b, 0xff9c, 0xfd79, 0xfc74, 0xfb63, 0xf958,
0xfbe7, 0xfa6b, 0xfd3f, 0xfa77, 0xfdf6, 0xf8de, 0xfde4, 0xf883, 0xfc90, 0xf98f,
0xfd05, 0xfc90, 0xfdd8, 0xfcc9, 0xfdaf, 0xfc0b, 0xfe08, 0xfc8b, 0xff6d, 0xfdee,
0x00ad, 0xfe34, 0xfd9e, 0xf98c, 0xfdb2, 0xf9c3, 0xfc3c, 0xfb2a, 0xfd45, 0xfd95,
0xfe66, 0xfdf6, 0xffe9, 0xfdbc, 0x00e4, 0xfb0c, 0xfef7, 0xf8b0, 0xfd1c, 0xfa69,
0xfdfd, 0xfded, 0x0087, 0x0085, 0x03cb, 0x0334, 0x0394, 0x00fa, 0x0006, 0xfb60,
0xfcfc, 0xf8bb, 0xfd86, 0xfbaf, 0x0066, 0xff96, 0x0107, 0xfe00, 0x02bc, 0xfbfa,
0xffac, 0xfa5c, 0xff50, 0xfe21, 0x037f, 0x0410, 0x0495, 0x048b, 0x03d0, 0x024a,
0x00ef, 0xff93, 0xfe39, 0xfb9c, 0xfe6e, 0xfb0b, 0xfee8, 0xfe08, 0xfd78, 0xffa3,
0xffff, 0x020d, 0x00ac, 0x00f8, 0xff94, 0xfebe, 0xfca3, 0xfc01, 0xfdc9, 0xffd7,
0x01af, 0x0417, 0x0193, 0x02a4, 0x0336, 0x0428, 0x00ea, 0x01ed, 0x001b, 0xfe2f,
0x0251, 0xfe02, 0x04aa, 0x00ff, 0x041a, 0x0082, 0x01d9, 0xffea, 0x0044, 0x0115,
0xff23, 0x02b6, 0x00fa, 0x0491, 0x03f8, 0x06f5, 0x045a, 0x0695, 0x0203, 0x0224,
0xffbb, 0xfe76, 0x0001, 0xfd69, 0xfdc2, 0xfc36, 0xfe06, 0xff56, 0x0323, 0x068c,
0x036a, 0x050f, 0x0258, 0x0282, 0x022f, 0x0415, 0x0256, 0x043e, 0x014b, 0x007d,
0x0175, 0x000f, 0x0315, 0x031d, 0x01ca, 0x0352, 0xffcd, 0x02a4, 0xff77, 0x0144,
0xfe9c, 0xfcea, 0xffb0, 0xfc92, 0x0248, 0xff9d, 0x03b4, 0x01b4, 0x051a, 0x03a8,
0x0526, 0x0422, 0x0479, 0x0391, 0x036c, 0x021f, 0x0306, 0x02c2, 0x0284, 0x01ca,
0x00ed, 0xfed1, 0x027f, 0xff4b, 0x03e2, 0x0160, 0x048e, 0x03d7, 0x061e, 0x059c,
0x05ae, 0x02aa, 0x052a, 0x0072, 0x0686, 0x02b0, 0x0540, 0x0218, 0x06c7, 0x02ab,
0x077e, 0x03df, 0x0684, 0x0365, 0x02c0, 0xfd1c, 0x003b, 0xf963, 0x01b8, 0xfa5e,
0x0701, 0x0110, 0x0adf, 0x07c8, 0x096d, 0x05b3, 0x086e, 0x0157, 0x0998, 0x0031,
0x0b1f, 0x0145, 0x08e0, 0xff9e, 0x051e, 0xfe34, 0x04df, 0xff97, 0x0611, 0xfe81,
0x08d9, 0x0019, 0x0773, 0x006f, 0x0735, 0xff15, 0x0801, 0xfe8d, 0x095d, 0x0053,
0x09a0, 0x025b, 0x076d, 0x01ec, 0x06d1, 0x034d, 0x04dc, 0x01ca, 0x035e, 0xfe2e,
0x0434, 0xfca4, 0x05eb, 0xfcb5, 0x06ef, 0xfff4, 0x0880, 0x04f3, 0x080f, 0x0372,
0x0a03, 0x0355, 0x0af6, 0x0535, 0x0d61, 0x072c, 0x0c53, 0x0367, 0x0b92, 0x0231,
0x094c, 0x030e, 0x06c2, 0x0506, 0x0871, 0x065a, 0x086e, 0x04e0, 0x0a7c, 0x06c0,
0x09df, 0x0477, 0x074c, 0x008f, 0x05f9, 0xfed4, 0x0827, 0x0221, 0x05db, 0x02f5,
0x05c2, 0x0518, 0x0881, 0x0803, 0x077c, 0x062d, 0x027d, 0x0174, 0x00a9, 0xff6b,
0x0409, 0x0089, 0x04ee, 0x02d7, 0x0791, 0x04a0, 0x07f8, 0x01ec, 0x0b08, 0x062f,
0x067f, 0x0514, 0x02cd, 0x04bc, 0x054b, 0x06b9, 0x05b5, 0x05e5, 0x054b, 0x058d,
0x03dd, 0x033a, 0x04bb, 0x0311, 0x04a2, 0x0144, 0x0452, 0x00c7, 0x00d8, 0xfe6b,
0x01c8, 0x0023, 0x0194, 0x0053, 0xffd9, 0xfe55, 0xff4e, 0xffd3, 0xffd7, 0x0110,
0x0194, 0xfff6, 0x025e, 0x0143, 0x01a0, 0x00b3, 0x0181, 0xffeb, 0x0253, 0x02ef,
0x0049, 0x016c, 0x0010, 0xfea2, 0x0190, 0xff1f, 0x02de, 0x0269, 0x01eb, 0x0352,
0xff11, 0x0088, 0xfe25, 0xfe2e, 0x02e7, 0x0379, 0x04d6, 0x0656, 0x0513, 0x06aa,
0x02df, 0x04af, 0x012c, 0x01d3, 0x01d9, 0x00db, 0x02f0, 0x0273, 0x0307, 0x03c6,
0x0131, 0x020a, 0x0058, 0x00ca, 0x0126, 0xff8a, 0x022f, 0xff23, 0x02f9, 0xfdd2,
0x029a, 0xfc72, 0x00f7, 0xfee2, 0x00b2, 0x01bf, 0xffa3, 0x00a6, 0xfef9, 0xfd58,
0x01c8, 0xfe46, 0x006a, 0xfcc6, 0xfcac, 0xf936, 0xfbf6, 0xf95f, 0xffe4, 0x0023,
0x0123, 0x0144, 0xff2e, 0xfc76, 0xfb95, 0xf774, 0xfac2, 0xf736, 0xfc4f, 0xf94f,
0x0109, 0xfb63, 0x015b, 0xfbbe, 0xfe3c, 0xfb39, 0xfccb, 0xfd50, 0xfcd6, 0xff05,
0xfdd9, 0xfcef, 0xfde5, 0xfb7a, 0xfc82, 0xf977, 0xfd1e, 0xfa39, 0xfe2e, 0xfb9f,
0xfdfc, 0xfc0c, 0xfc53, 0xfc7b, 0xfb27, 0xfd7e, 0xfc56, 0xfe51, 0xfc96, 0xfbc9,
0xfb7a, 0xf9dc, 0xfaeb, 0xfc8b, 0xfb9e, 0xffc9, 0xfbeb, 0xfe91, 0xfa36, 0xfc10,
0xf8a3, 0xf9f7, 0xf8f0, 0xf97e, 0xfa54, 0xf987, 0xf94f, 0xf7b0, 0xf7b6, 0xf993,
0xf9fc, 0xfe7f, 0xfb4b, 0xff37, 0xfb43, 0xff91, 0xfa91, 0xfeb3, 0xfa0d, 0xfd4a,
0xfa4f, 0xfb06, 0xf9e5, 0xf9ff, 0xf955, 0xfc38, 0xf717, 0xfc55, 0xf5b3, 0xfbd7,
0xf5c0, 0xf952, 0xf725, 0xf8e4, 0xf799, 0xfa8e, 0xf7c8, 0xfc63, 0xf8c9, 0xfd4e,
0xf676, 0xfbea, 0xf568, 0xfd09, 0xf69c, 0xfd04, 0xf53e, 0xf9e0, 0xf3ea, 0xf8d5,
0xf2d9, 0xf7b3, 0xf35d, 0xf875, 0xf276, 0xf7f9, 0xf1a8, 0xf768, 0xf54f, 0xfa93,
0xf762, 0xfc23, 0xf686, 0xfacd, 0xf360, 0xf688, 0xf20e, 0xf687, 0xf0c2, 0xf768,
0xf251, 0xf9a9, 0xf538, 0xfc5f, 0xf077, 0xf8af, 0xf12d, 0xf7b6, 0xf486, 0xf77d,
0xf860, 0xfac8, 0xf836, 0xfd6b, 0xf866, 0xfe9c, 0xf795, 0xfbb4, 0xf02b, 0xf3a2,
0xe0d6, 0xe724, 0xde87, 0xe78d, 0xe455, 0xecb2, 0xde1c, 0xe4c0, 0xe20f, 0xe6b2,
0xdc67, 0xe2e6, 0xe71b, 0xf137, 0xdeb6, 0xe915, 0xdece, 0xe497, 0xd5f1, 0xdbc5,
0xdcfa, 0xe54b, 0xd67b, 0xe0a0, 0xd833, 0xe127, 0xd4b2, 0xdb32, 0xd502, 0xda10,
0xcbaf, 0xd3f6, 0xcab7, 0xd49d, 0xd12a, 0xda56, 0xd8ed, 0xdfd8, 0xd728, 0xdeb0,
0xd1ef, 0xdc53, 0xcd96, 0xd96c, 0xd298, 0xdd69, 0xd604, 0xdddc, 0xd22b, 0xd901,
0xd1ae, 0xd981, 0xd199, 0xd93f, 0xd300, 0xd9c3, 0xd5c2, 0xdc72, 0xd70c, 0xdd88,
0xd234, 0xd956, 0xd03a, 0xd7f0, 0xd19e, 0xd875, 0xd2cf, 0xd97d, 0xd434, 0xdbcb,
0xd175, 0xd884, 0xd1df, 0xd6d1, 0xce56, 0xd217, 0xc8aa, 0xcc9a, 0xc638, 0xcbcc,
0xcd67, 0xd458, 0xd686, 0xdb7d, 0xd47d, 0xd74a, 0xcc8e, 0xd13c, 0xc62c, 0xcc8c,
0xc360, 0xc91b, 0xc524, 0xcc3f, 0xca96, 0xd1f6, 0xca3d, 0xcfb6, 0xcbbc, 0xd003,
0xcea5, 0xd1ab, 0xcbed, 0xcc57, 0xc914, 0xc705, 0xc682, 0xc4df, 0xc805, 0xc987,
0xc9f8, 0xcf2c, 0xc781, 0xcb8c, 0xc24c, 0xc451, 0xc1de, 0xc42f, 0xc80e, 0xcbfb,
0xdd40, 0xe002, 0xf9b7, 0xf733, 0xfcd7, 0xf8d1, 0xf6e1, 0xf414, 0xf218, 0xef65,
0xf3f0, 0xf237, 0xec73, 0xec45, 0xe595, 0xe49a, 0xf03e, 0xee72, 0xf6e1, 0xf370,
0xeb77, 0xe7af, 0xe1d3, 0xdf50, 0xe3c9, 0xe1eb, 0xed44, 0xeca1, 0xef03, 0xeed7,
0xe79d, 0xe582, 0xe6e0, 0xe3a1, 0xe784, 0xe521, 0xe4b9, 0xe297, 0xde88, 0xdbd4,
0xd945, 0xd52c, 0xdc4a, 0xdb50, 0xe8e6, 0xe90a, 0xf6d9, 0xf5af, 0xf878, 0xf87f,
0xeeb9, 0xef18, 0xe9e4, 0xe791, 0xe971, 0xe5c4, 0xe69b, 0xe3d6, 0xe8b6, 0xe597,
0xee93, 0xeb30, 0xf310, 0xef4b, 0xf07f, 0xecc6, 0xeba5, 0xe769, 0xed4a, 0xe92e,
0xef3b, 0xed29, 0xef91, 0xed1e, 0xf329, 0xf00b, 0xf339, 0xf244, 0xed21, 0xeb51,
0xe839, 0xe5ab, 0xed14, 0xeda0, 0xf342, 0xf551, 0xf37f, 0xf63c, 0xee93, 0xef97,
0xe9d5, 0xe7f6, 0xec1f, 0xeb2a, 0xeddb, 0xede0, 0xebe8, 0xebfe, 0xf029, 0xee13,
0xf2ab, 0xeebb, 0xeb4f, 0xe7cb, 0xe9a1, 0xe85a, 0xef5e, 0xf085, 0xf4e5, 0xf5c0,
0xf247, 0xf182, 0xeba7, 0xea25, 0xeebe, 0xef1e, 0xf19f, 0xf2d4, 0xf06c, 0xf1f7,
0xf413, 0xf404, 0xf197, 0xef8b, 0xf368, 0xf1da, 0xf96c, 0xf968, 0xf14f, 0xf0f6,
0xf05a, 0xf0f0, 0xfaec, 0xfc4e, 0xfa07, 0xf85c, 0xf5e0, 0xf25e, 0xf6b8, 0xf2a1,
0xf6db, 0xf400, 0xfa4a, 0xfac7, 0xfc01, 0xfe44, 0xfa07, 0xfc50, 0xf7c1, 0xf6e8,
0xf640, 0xf2c0, 0xfd33, 0xfa33, 0xfe3b, 0xfb67, 0xfab4, 0xf7ca, 0x00fa, 0x0022,
0x02f5, 0x0234, 0xfbad, 0xf8c2, 0xf940, 0xf62d, 0xf9ec, 0xf78f, 0x0051, 0xfdfd,
0x062c, 0x045b, 0x0195, 0xfe22, 0xfa83, 0xf7b9, 0xfc15, 0xf82c, 0xf9d0, 0xf459,
0xf59c, 0xf044, 0xfda3, 0xfa06, 0x0466, 0x0221, 0x0783, 0x0276, 0x0647, 0x021f,
0x0543, 0x009e, 0x0312, 0xfc3f, 0x0375, 0xf9cb, 0x02e9, 0xf81f, 0x046d, 0xfb61,
0x0622, 0xfe5b, 0x03de, 0xfef9, 0x006f, 0xfc24, 0x00f2, 0xf97e, 0x05c2, 0xfca9,
0x07fd, 0xffdb, 0x0657, 0xff6a, 0x05d2, 0xff7b, 0x088d, 0x00b9, 0x07b0, 0xfd2a,
0x04b9, 0xfa0a, 0x087c, 0xfed0, 0x0d53, 0x03a4, 0x0b58, 0x0187, 0x0a5d, 0x0051,
0x08b2, 0x004f, 0x0638, 0xfe76, 0x0618, 0xfe34, 0x0a68, 0x01d8, 0x0e2a, 0x0487,
0x0f17, 0x0462, 0x0edf, 0x03ce, 0x0fa6, 0x0715, 0x0cf7, 0x065c, 0x092a, 0x0371,
0x0ac5, 0x039a, 0x0a6c, 0x010a, 0x0dc0, 0x02f7, 0x1357, 0x09e9, 0x10eb, 0x0b64,
0x0e5e, 0x0a35, 0x0bd0, 0x0747, 0x0ba2, 0x04ad, 0x0f0d, 0x0849, 0x1151, 0x0cc5,
0x1225, 0x0b65, 0x0ebb, 0x0708, 0x0bac, 0x055d, 0x0d8c, 0x0947, 0x0dc4, 0x0a17,
0x0e8e, 0x0a04, 0x124b, 0x0cea, 0x11ae, 0x0b70, 0x1022, 0x0cdf, 0x0c69, 0x0b98,
0x0b24, 0x0a77, 0x1171, 0x1002, 0x14dc, 0x1334, 0x1222, 0x114f, 0x1069, 0x0f06,
0x0f9f, 0x0d60, 0x0db8, 0x0a69, 0x0e00, 0x0a6f, 0x0eac, 0x0e4f, 0x0fda, 0x1165,
0x12e3, 0x127d, 0x13f3, 0x12d2, 0x133d, 0x120a, 0x11f2, 0x113d, 0x0fdb, 0x1068,
0x10b3, 0x1362, 0x115b, 0x1698, 0x0e0d, 0x1326, 0x09d6, 0x0cc9, 0x0b5b, 0x0d50,
0x1330, 0x1620, 0x11ea, 0x14e1, 0x1199, 0x13d9, 0x1637, 0x1ab8, 0x11df, 0x1808,
0x0d3e, 0x13c7, 0x111f, 0x17bb, 0x12ff, 0x1875, 0x0dcb, 0x1235, 0x0a89, 0x0f0b,
0x0a14, 0x0fdf, 0x0eda, 0x154d, 0x1222, 0x15f9, 0x112d, 0x1537, 0x0e1f, 0x14f3,
0x0d71, 0x12ca, 0x0cef, 0x13be, 0x0acb, 0x130c, 0x0dfd, 0x15cf, 0x1447, 0x1bbe,
0x1494, 0x1b1f, 0x0c77, 0x124b, 0x0aa0, 0x0f31, 0x09ff, 0x0f6e, 0x0d82, 0x1325,
0x107b, 0x15b3, 0x0d7f, 0x10a1, 0x0983, 0x0a79, 0x0782, 0x09cb, 0x0a37, 0x0ff9,
0x0db7, 0x152c, 0x0bb1, 0x0ea3, 0x07a7, 0x08a7, 0x0a74, 0x0e34, 0x0db6, 0x13b7,
0x0c59, 0x107c, 0x064f, 0x087c, 0x051f, 0x0631, 0x0aaa, 0x09f3, 0x0fbd, 0x101d,
0x0eff, 0x122f, 0x0b3d, 0x1020, 0x0a18, 0x0e40, 0x0941, 0x0ace, 0x0a0c, 0x0abf,
0x0d8b, 0x0ee5, 0x0b67, 0x0bfb, 0x08da, 0x09ba, 0x0a0a, 0x0bb3, 0x09c6, 0x0c35,
0x076d, 0x099b, 0x08c0, 0x0aa1, 0x0931, 0x09aa, 0x0423, 0x02fd, 0x03fc, 0x0401,
0x083b, 0x0945, 0x05be, 0x04bf, 0x0143, 0xfea7, 0x020a, 0x0048, 0x05c4, 0x06a9,
0x0796, 0x097f, 0x054b, 0x0537, 0x03a9, 0x01ab, 0x008b, 0xfec2, 0x040b, 0x05a9,
0x0733, 0x0a05, 0x00e1, 0x00b8, 0x0125, 0xffb8, 0x053e, 0x06ea, 0x0283, 0x03ea,
0x014a, 0x01e7, 0x051d, 0x0720, 0x00f0, 0x021c, 0x00fd, 0x0181, 0x02a1, 0x0218,
0xff13, 0xfdcb, 0xfeb3, 0xfc32, 0xfe25, 0xfc80, 0xff73, 0x028c, 0x0025, 0x05f6,
0x01a1, 0x0701, 0x043e, 0x07a2, 0xffc0, 0xff84, 0xfda3, 0xfc4e, 0xfef7, 0xfe82,
0xfb90, 0xfcf0, 0xfee0, 0x0262, 0x01e3, 0x0702, 0xfdd0, 0x016f, 0xfc1b, 0xfd5a,
0xfb83, 0xfcc1, 0xfe97, 0x017f, 0xfdef, 0x01f2, 0xfa25, 0xfd05, 0xf8ad, 0xfad2,
0xfd22, 0xfef6, 0x24ce, 0x2572, 0x3578, 0x3596, 0x18a6, 0x19d8, 0x0a50, 0x0da1,
0x1212, 0x164c, 0x0edb, 0x139e, 0x0e88, 0x123f, 0x092a, 0x0a61, 0x08cd, 0x0b99,
0x11b0, 0x175e, 0x0d15, 0x11a4, 0x0837, 0x0b6a, 0x0650, 0x0a17, 0x057b, 0x089b,
0x06c2, 0x09bb, 0x03b5, 0x0777, 0xfcc9, 0x008f, 0xfd7e, 0x006c, 0x0243, 0x026e,
0x04c3, 0x057f, 0x049b, 0x0711, 0x0150, 0x04af, 0x004c, 0x049e, 0xfc5c, 0x011e,
0xfc40, 0x012c, 0x0079, 0x041b, 0xfea5, 0x0283, 0xfc75, 0x0262, 0xfccc, 0x00e1,
0xfca4, 0xfe58, 0xfce2, 0xffe9, 0xfd5f, 0x02cc, 0xf525, 0xfd1d, 0xf392, 0xfa6e,
0xfa9a, 0x0168, 0xfb3d, 0x0385, 0xf78d, 0x008a, 0xf551, 0xfe96, 0xf848, 0x0086,
0xf7d3, 0xfd5a, 0xf4ce, 0xfadf, 0xf40b, 0xfb68, 0xf4af, 0xfa8d, 0xf80f, 0xfe9d,
0xf9d4, 0x02ac, 0xf9e6, 0x0244, 0xf8bd, 0x0087, 0xf86a, 0xffb8, 0xf529, 0xf8e9,
0xf4ab, 0xf95e, 0xfb79, 0x0010, 0xfcfe, 0x01bc, 0xfb7f, 0x0136, 0xfa2c, 0xffd9,
0xf7a3, 0xfc64, 0xf7e3, 0xfb03, 0xf605, 0xf97a, 0xf7f2, 0xfa62, 0xf942, 0xfd00,
0xf9fb, 0x0019, 0xf691, 0xfc68, 0xf440, 0xf6fa, 0xf43d, 0xf5bb, 0xf45d, 0xf7b9,
0xf423, 0xf90f, 0xf48f, 0xfa3e, 0xf67c, 0xfc72, 0xf7c3, 0xfced, 0xf87e, 0xfd69,
0xf500, 0xfa03, 0xf3ac, 0xf7a5, 0xf4c0, 0xf836, 0xf7c9, 0xfa73, 0xf705, 0xf9a3,
0xf5f1, 0xf88a, 0xf6ee, 0xf9f2, 0xfab9, 0xfaf2, 0xf72e, 0xf3cc, 0xf753, 0xf4b9,
0xfabe, 0xfb68, 0xfc19, 0xfd4c, 0xfdad, 0xfcf3, 0xf9f7, 0xf688, 0xfa1b, 0xf5a1,
0xfe2c, 0xfa96, 0xfac2, 0xf779, 0xf75a, 0xf756, 0xf919, 0xf928, 0xf8a3, 0xf6d6,
0xfc4b, 0xf97e, 0xff00, 0xfbdb, 0xfd4e, 0xfb1d, 0xf7a9, 0xf590, 0xf55f, 0xf1c9,
0xf764, 0xf4f5, 0xfcd7, 0xfa5e, 0xfba0, 0xf67b, 0xfa1a, 0xf54d, 0xf9b0, 0xf1ee,
0xf9c9, 0xf24a, 0x01de, 0xfd2d, 0xfe3c, 0xf7ea, 0x0533, 0xfcf1, 0x2f95, 0x251a,
0x3d26, 0x34af, 0x2b47, 0x2644, 0x2751, 0x20c5, 0x277f, 0x1f55, 0x206b, 0x1923,
0x1ff3, 0x1896, 0x249f, 0x1dd2, 0x2597, 0x1e43, 0x2033, 0x1896, 0x2296, 0x1c00,
0x2647, 0x1e74, 0x2373, 0x1aea, 0x21ad, 0x1a60, 0x1eac, 0x185c, 0x181d, 0x13e0,
0x1868, 0x137e, 0x15e6, 0x0fb9, 0x152c, 0x105f, 0x15f8, 0x13eb, 0x15f9, 0x130d,
0x1dbe, 0x1802, 0x1dcd, 0x184d, 0x1fc4, 0x1b07, 0x1fa7, 0x1a84, 0x1f81, 0x183a,
0x1d5a, 0x17d7, 0x1a49, 0x16b1, 0x1956, 0x1524, 0x16eb, 0x1204, 0x1520, 0x1220,
0x138c, 0x11de, 0x16a4, 0x1626, 0x1ca0, 0x1be6, 0x1af7, 0x1938, 0x1cc1, 0x1913,
0x206d, 0x1b08, 0x25a0, 0x2423, 0x1f02, 0x204f, 0x1adc, 0x1be3, 0x1eeb, 0x1dca,
0x1ece, 0x1cf7, 0x1cc3, 0x1c0b, 0x1806, 0x15e9, 0x16ee, 0x1318, 0x1cd2, 0x1996,
0x2022, 0x1e56, 0x1fc8, 0x1ff6, 0x1e7f, 0x1dd0, 0x1b0e, 0x1906, 0x1b80, 0x1b51,
0x19cb, 0x1a2b, 0x199f, 0x19b6, 0x18f2, 0x18c4, 0x1810, 0x1778, 0x13a7, 0x1226,
0x16d8, 0x1437, 0x17a8, 0x1866, 0x1672, 0x19a7, 0x15a6, 0x1791, 0x157e, 0x15fd,
0x1879, 0x174c, 0x1761, 0x144c, 0x1675, 0x141a, 0x1544, 0x1549, 0x16c8, 0x1742,
0x1a64, 0x19e7, 0x1e3e, 0x1c8e, 0x1de8, 0x1bfd, 0x1dda, 0x1ed1, 0x1c4e, 0x1ec6,
0x1aeb, 0x1c7b, 0x1d7e, 0x1dd8, 0x2045, 0x1d4c, 0x21dd, 0x1e9e, 0x2342, 0x1e7a,
0x23fb, 0x1e32, 0x2261, 0x1d00, 0x20be, 0x1c61, 0x1f29, 0x1ba5, 0x2072, 0x1b36,
0x1f6f, 0x18ea, 0x1e92, 0x18ae, 0x1b39, 0x18ab, 0x1bf8, 0x1a90, 0x1dab, 0x1cfa,
0x1d41, 0x1b65, 0x1da5, 0x1d78, 0x2075, 0x20ab, 0x2761, 0x2612, 0x251e, 0x222d,
0x23d5, 0x20a1, 0x23c3, 0x20bb, 0x25bf, 0x20fc, 0x2a42, 0x2777, 0x2b99, 0x27dc,
0x26b4, 0x209a, 0x261c, 0x1d96, 0x259d, 0x1d79, 0x25f8, 0x1fe3, 0x26d5, 0x208b,
0x263b, 0x1fca, 0x2816, 0x22c8, 0x2108, 0x1b1d, 0x1d95, 0x1671, 0x203a, 0x19f4,
0x21af, 0x1b4e, 0x1f86, 0x1a19, 0x2022, 0x1bb0, 0x1d1f, 0x182a, 0x1b25, 0x15ee,
0x1d3a, 0x1713, 0x1b98, 0x15ff, 0x21ad, 0x1e2e, 0x22f0, 0x1fb1, 0x24f0, 0x2214,
0x21e3, 0x1f73, 0x206a, 0x1bbe, 0x22f7, 0x1ddb, 0x239c, 0x1da5, 0x202b, 0x1a56,
0x1f11, 0x18de, 0x1f5e, 0x1acf, 0x1dd9, 0x195d, 0x1c0d, 0x14c5, 0x1bea, 0x13bc,
0x1bf9, 0x153d, 0x196a, 0x1531, 0x1538, 0x105d, 0x10ff, 0x0abe, 0x15c7, 0x1156,
0x1655, 0x118a, 0x156a, 0x0fea, 0x169c, 0x1074, 0x1545, 0x0f33, 0x1559, 0x0f57,
0x163a, 0x10bf, 0x1763, 0x145d, 0x1696, 0x14c0, 0x173e, 0x16f4, 0x1a19, 0x170b,
0x1881, 0x166e, 0x1520, 0x16ec, 0x15ce, 0x1879, 0x16ff, 0x183f, 0x164a, 0x16cc,
0x142b, 0x14d3, 0x1461, 0x143c, 0x13cd, 0x13d3, 0x1547, 0x15f2, 0x145c, 0x14cb,
0x1922, 0x1a8b, 0x1a8c, 0x1c52, 0x1c0d, 0x1d0c, 0x1b4b, 0x1b78, 0x1bc3, 0x1ccd,
0x1ccc, 0x1ea0, 0x1735, 0x19ea, 0x1431, 0x16cb, 0x1781, 0x1b4d, 0x1901, 0x1e56,
0x17d7, 0x1b29, 0x1540, 0x16b3, 0x1116, 0x1382, 0x1085, 0x1394, 0x080d, 0x0b4e,
0x0889, 0x0dd2, 0x0865, 0x0d24, 0x0435, 0x078d, 0x042a, 0x086a, 0x07d7, 0x0dbc,
0x0b85, 0x1036, 0x0ffd, 0x12d8, 0x0c64, 0x0fae, 0x06d3, 0x0aae, 0x079c, 0x09b3,
0x0ab8, 0x0b1c, 0x0af8, 0x09c6, 0x0c0f, 0x0cc1, 0x0fb1, 0x1245, 0x0c29, 0x0e1f,
0x0ce8, 0x1108, 0x0baa, 0x0f12, 0x0ad5, 0x0baa, 0x0cf4, 0x0e41, 0x0fe4, 0x1095,
0x0cf6, 0x0dbc, 0x0a88, 0x0b68, 0x0a82, 0x09b2, 0x0652, 0x048a, 0x06e4, 0x0650,
0xfdf3, 0xff73, 0xfc58, 0xfe95, 0xfa85, 0xfc29, 0xfeda, 0xfef6, 0xfe23, 0xfbd5,
0xf977, 0xf762, 0xf849, 0xf5a4, 0xf7f8, 0xf626, 0xfafd, 0xf8d7, 0xfbb5, 0xf9e5,
0x002d, 0xff93, 0xfe1f, 0xfd5d, 0xfc37, 0xfd17, 0xf9cd, 0xfad3, 0xf839, 0xfa4d,
0xf954, 0xfb93, 0xf6c2, 0xf74b, 0xf75a, 0xf70d, 0xface, 0xfb99, 0xf789, 0xf9c0,
0xf537, 0xf9f6, 0xf4ec, 0xfb59, 0xf625, 0xfdbc, 0xf6f5, 0xfd40, 0xf268, 0xf629,
0xf028, 0xf2c0, 0xf329, 0xf56c, 0xeff7, 0xf46a, 0xeee1, 0xf67d, 0xf0a8, 0xf896,
0xf0dd, 0xf88d, 0xf047, 0xf85b, 0xeade, 0xf51d, 0xe954, 0xf445, 0xeb2a, 0xf642,
0xed2a, 0xf795, 0xecc0, 0xf7a7, 0xeb73, 0xf58e, 0xe774, 0xf057, 0xe713, 0xf0cf,
0xe57c, 0xeed7, 0xe7d6, 0xef97, 0xebda, 0xf56c, 0xf130, 0xfc27, 0x07a6, 0x10fe,
0x1673, 0x1df2, 0xfcdd, 0x075c, 0xe8eb, 0xf552, 0xed9b, 0xf492, 0xf071, 0xf502,
0xf2e1, 0xf654, 0xf4b3, 0xf962, 0xf919, 0xfe41, 0xf65c, 0xfb1f, 0xf31b, 0xf866,
0xf007, 0xf503, 0xed45, 0xf1c3, 0xefb8, 0xf4a7, 0xea2e, 0xf119, 0xe49c, 0xeb7f,
0xe574, 0xe8ff, 0xe915, 0xed8a, 0xe870, 0xeb85, 0xe677, 0xe606, 0xe39d, 0xe168,
0xe162, 0xe25a, 0xe337, 0xe814, 0xe27c, 0xe800, 0xe468, 0xe990, 0xe248, 0xe507,
0xdcf4, 0xdfae, 0xdcfa, 0xe213, 0xd89d, 0xe180, 0xd6c5, 0xddb1, 0xd5b6, 0xda9c,
0xd91c, 0xde75, 0xd33a, 0xd7b4, 0xd2dc, 0xd849, 0xd6c5, 0xdbca, 0xd21a, 0xd5f7,
0xd2ba, 0xd3d7, 0xd364, 0xd3cc, 0xd77c, 0xd8ea, 0xd688, 0xd94c, 0xd521, 0xd7c5,
0xd55d, 0xd57e, 0xd2fb, 0xd2dc, 0xd02c, 0xd293, 0xcf1b, 0xd3ef, 0xd347, 0xd834,
0xd232, 0xd6fe, 0xccf0, 0xd20b, 0xcc03, 0xd3d3, 0xced0, 0xd6eb, 0xd0ce, 0xd94a,
0xd014, 0xd6fd, 0xd28c, 0xd99a, 0xd323, 0xdad9, 0xd50b, 0xdc8b, 0xd3db, 0xdb2a,
0xd3ee, 0xdb5a, 0xd30e, 0xda99, 0xd077, 0xd98c, 0xd02f, 0xd9dd, 0xce8a, 0xd691,
0xcd38, 0xd537, 0xcfc7, 0xd84e, 0xcf2c, 0xd61f, 0xd05e, 0xd57a, 0xd1c5, 0xd8cf,
0xd3bb, 0xdb15, 0xd10e, 0xd721, 0xcc60, 0xd13c, 0xccb6, 0xd2e5, 0xca15, 0xd254,
0xc8ec, 0xd080, 0xc570, 0xcb65, 0xc45f, 0xca7f, 0xc727, 0xcafd, 0xc61a, 0xc7b6,
0xd1c5, 0xd1b5, 0xf0f1, 0xeffc, 0x0ed0, 0x0ef3, 0x1210, 0x134e, 0x0a20, 0x0e29,
0x0513, 0x0728, 0xfbe1, 0xff83, 0xfc2a, 0x01de, 0xf407, 0xf81e, 0xf385, 0xf5be,
0xedc8, 0xece7, 0xed0f, 0xee74, 0xedc2, 0xebbf, 0xed84, 0xeafe, 0xf6af, 0xf277,
0xf213, 0xecf8, 0xf6b0, 0xf2b5, 0xf7ed, 0xf3d1, 0xfa70, 0xfa0a, 0xfa07, 0xfb1b,
0xf539, 0xf5dc, 0xf3aa, 0xf16b, 0xf01e, 0xed6b, 0xec86, 0xec0a, 0xe88d, 0xec49,
0xe829, 0xeca5, 0xe835, 0xeb01, 0xe8f6, 0xe93a, 0xece0, 0xeaa2, 0xf44a, 0xf162,
0xfc86, 0xfc43, 0xfd5e, 0xfe11, 0xfa66, 0xfa0e, 0xfa73, 0xf984, 0xfa7a, 0xf772,
0xfa70, 0xf555, 0xf7d9, 0xf2c3, 0xf684, 0xf310, 0xf8e6, 0xf647, 0xf86b, 0xf48b,
0xfcdd, 0xf8a3, 0xfded, 0xf9f5, 0x002d, 0xf9b6, 0x0225, 0xfa9e, 0xfade, 0xf20f,
0xf9be, 0xf1e6, 0xf80e, 0xf416, 0xf7b4, 0xf409, 0xf461, 0xef5b, 0xf2d7, 0xecb9,
0xf978, 0xf382, 0xfb8e, 0xf693, 0xfc8f, 0xf741, 0xfad6, 0xf6af, 0xf36c, 0xef8e,
0xf5b3, 0xf10b, 0xf668, 0xf198, 0xf71a, 0xf169, 0xf42a, 0xefee, 0xf437, 0xf07a,
0xf7df, 0xf657, 0xf698, 0xf652, 0xfd0e, 0xfc3e, 0xff4d, 0xfc1f, 0xffae, 0xfa8d,
0xff8e, 0xf961, 0xfcd5, 0xf62c, 0xfd17, 0xf941, 0xfc9b, 0xf7ac, 0xfa01, 0xf37d,
0xf812, 0xf298, 0xf8bc, 0xf3bd, 0xf677, 0xf415, 0xf717, 0xf4e3, 0xf6bf, 0xf4ea,
0xf61e, 0xf2d4, 0xfdb5, 0xf7d9, 0x000e, 0xf9b2, 0x064a, 0xff40, 0x01b6, 0xfd48,
0x08bd, 0x0222, 0x0b6a, 0x048a, 0x0794, 0xff57, 0x07fc, 0x003d, 0x0532, 0xfdff,
0x05d9, 0xfe0c, 0x018e, 0xfaa0, 0x0106, 0xf976, 0x0245, 0xfa7a, 0x0579, 0xfec7,
0x00d3, 0xfb4d, 0xfdbb, 0xf7de, 0xfe5d, 0xf929, 0xff8e, 0xfa23, 0x01d3, 0xfc76,
0x044d, 0xff41, 0x07e6, 0x01bd, 0x0696, 0xfeba, 0x070e, 0x0000, 0x05b1, 0xffd2,
0x02a5, 0x008a, 0x04d3, 0x031c, 0x03d7, 0x0123, 0x04ee, 0x0303, 0xfe47, 0xfe87,
0xfd9a, 0xfcaa, 0x0092, 0xfdd0, 0x0073, 0xfc4e, 0x0508, 0x0100, 0x0596, 0x021d,
0x01d0, 0xffa4, 0x00b4, 0x00cf, 0xfc7c, 0xfe56, 0xfdf5, 0xfe13, 0xfb7b, 0xfa33,
0xfe1f, 0xfc1d, 0x02b7, 0xfddd, 0x014c, 0xfc35, 0x0ca6, 0x01e8, 0x131b, 0x07aa,
0x1fc8, 0x125b, 0x1ce8, 0x1047, 0x1bd1, 0x0e1a, 0x19c8, 0x0be2, 0x1443, 0x068a,
0x190b, 0x0a9a, 0x12aa, 0x07f4, 0x1258, 0x08f2, 0x0a4f, 0x0328, 0x08dd, 0x007e,
0x02cc, 0xfa4a, 0x0241, 0xfa5b, 0x05eb, 0xfc6e, 0x0981, 0x0026, 0x0fed, 0x05f2,
0x0ca6, 0x0329, 0x0cb2, 0x044d, 0x0da3, 0x04a8, 0x1571, 0x0cc1, 0x14a8, 0x0b86,
0x155c, 0x0d4f, 0x155d, 0x0f62, 0x16d8, 0x13ce, 0x165e, 0x11b6, 0x1231, 0x0d2b,
0x136d, 0x0e70, 0x10e0, 0x0bf7, 0x0dd1, 0x09bd, 0x1050, 0x0922, 0x1244, 0x0ae4,
0x15d9, 0x0f18, 0x14ea, 0x0f6f, 0x17b9, 0x13d2, 0x1b23, 0x1441, 0x13a3, 0x1146,
0x10fd, 0x0ff1, 0x0c43, 0x0e6d, 0x0b6e, 0x0ec3, 0x0963, 0x0a91, 0x0ad5, 0x0d10,
0x1427, 0x1439, 0x1193, 0x0f22, 0x1372, 0x0d69, 0x1630, 0x1019, 0x0fe6, 0x0bf0,
0x0fc3, 0x0e60, 0x0c2a, 0x0be3, 0x0b14, 0x0ac8, 0x0a87, 0x071e, 0x0a35, 0x05f7,
0x0dc6, 0x0bc7, 0x0eba, 0x0dfe, 0x0d01, 0x0e89, 0x0981, 0x0bed, 0x0cf9, 0x09ec,
0x14c2, 0x1108, 0x1eb2, 0x17c8, 0x1c40, 0x13e8, 0x179c, 0x1194, 0x13c4, 0x1120,
0x0a6f, 0x0c8b, 0x0bf1, 0x0ccd, 0x0b98, 0x0b7a, 0x0bd7, 0x0b24, 0x0ad3, 0x096f,
0x0c2f, 0x0b26, 0x0ccc, 0x0bc5, 0x0b28, 0x0a61, 0x0c53, 0x0e4c, 0x0d31, 0x0f87,
0x0bba, 0x0f3f, 0x0a2e, 0x0dc6, 0x04fa, 0x0581, 0x05b4, 0x0614, 0x0353, 0x03c6,
0x00ec, 0x0286, 0xfdaa, 0x0280, 0xfd28, 0x0097, 0x00c0, 0xfd26, 0x0167, 0xfd79,
0x0cb5, 0x0835, 0x0ca3, 0x098a, 0x1651, 0x12e3, 0x16b9, 0x139c, 0x1404, 0x1438,
0x1143, 0x1016, 0x0b37, 0x09a7, 0x0bf0, 0x0a2e, 0x0630, 0x068b, 0x03e0, 0x0512,
0xffc0, 0x026d, 0x0017, 0x02ad, 0xff92, 0x0349, 0x0041, 0x034c, 0x0179, 0x03b9,
0x015c, 0x04b9, 0xff02, 0x0265, 0xfa4c, 0xfd86, 0xfb1c, 0xfd65, 0xff46, 0xff0a,
0x0199, 0x0061, 0x073c, 0x073b, 0x0d3c, 0x0eaf, 0x096c, 0x0b6d, 0x0749, 0x09a4,
0x0587, 0x08aa, 0x081a, 0x0b38, 0x09fe, 0x0aff, 0x1149, 0x10b9, 0x0efb, 0x0f00,
0x0978, 0x0930, 0x080e, 0x080a, 0x07b1, 0x095f, 0x099f, 0x0bd9, 0x022e, 0x03bc,
0x021f, 0x0373, 0xff03, 0x0291, 0xffda, 0x03f8, 0xfa8d, 0xfd06, 0xf6cf, 0xf6d9,
0xf5ee, 0xf43f, 0xf824, 0xf7f4, 0xf8af, 0xf9b2, 0xf7e8, 0xf8b9, 0xfe1d, 0xfce3,
0x0088, 0xfff6, 0x0309, 0x032a, 0xff50, 0xff29, 0xff09, 0x0022, 0xfdc3, 0xff38,
0xfb52, 0xfead, 0xfc66, 0xff21, 0xfc6d, 0xfd5b, 0xfc28, 0xfda7, 0xf614, 0xf798,
0xf1f8, 0xf435, 0xf23f, 0xf279, 0xf467, 0xf2f3, 0xf6b7, 0xf42b, 0xf87e, 0xf61a,
0xf975, 0xf691, 0xffc2, 0xfd51, 0x1cee, 0x163e, 0x2d3b, 0x22ac, 0x2b9f, 0x2214,
0x22c0, 0x1cf3, 0x21d5, 0x1ebc, 0x1e19, 0x1a40, 0x1a7c, 0x175a, 0x1c0f, 0x172a,
0x1778, 0x146d, 0x1692, 0x1553, 0x1118, 0x1415, 0x0b42, 0x106f, 0x06c6, 0x0af6,
0x08bf, 0x0c7f, 0x045c, 0x089b, 0x03d9, 0x0603, 0x0977, 0x0451, 0x0a9d, 0x05fb,
0x0ab0, 0x0695, 0x093a, 0x079c, 0x0a44, 0x0b00, 0x0750, 0x075b, 0x07f8, 0x09b0,
0x0731, 0x08fd, 0x0033, 0x020f, 0xff55, 0x0113, 0xfacf, 0xfd95, 0xf9b4, 0xfe17,
0xf8e7, 0xfdbc, 0xf6a2, 0xfb88, 0xf71d, 0xfb9a, 0xf83d, 0xfc43, 0xf712, 0xfaa9,
0xf8c7, 0xfd12, 0xfb74, 0x0041, 0xf8de, 0xfd1c, 0xf8d5, 0xfc33, 0xf913, 0xfc4c,
0xfc42, 0x0073, 0xfaa4, 0xffd5, 0xfcbd, 0x030b, 0xfe25, 0x0460, 0xfdf5, 0x02d1,
0xfd0b, 0x00b0, 0xfae6, 0xff88, 0xf89f, 0xff7c, 0xf505, 0xfd6a, 0xf5aa, 0xfd87,
0xf5d6, 0xffde, 0xf6c9, 0x00c1, 0xf577, 0x00fc, 0xf435, 0x0075, 0xf3ff, 0x00ec,
0xf436, 0x005c, 0xf2db, 0xfd38, 0xf2c3, 0xfe54, 0xf5bb, 0x00a0, 0xf63c, 0x0186,
0xf56a, 0x0063, 0xf2c2, 0xfd0f, 0xf054, 0xfbc2, 0xf06a, 0xfc9b, 0xee2e, 0xfcd0,
0xef9e, 0xff55, 0xf04e, 0xfdae, 0xece1, 0xf951, 0xeae5, 0xf425, 0xec16, 0xf5a5,
0xef57, 0xf639, 0xf023, 0xf7d6, 0xf2b0, 0xfc08, 0xf2c3, 0xfb43, 0xf191, 0xfc97,
0xf25a, 0xfba3, 0xef29, 0xf9da, 0xeddb, 0xf8f9, 0xeda6, 0xf74f, 0xec94, 0xf53b,
0xf1fe, 0xf7e3, 0xf40d, 0xf982, 0xf602, 0xfc8e, 0xf4d8, 0xfba3, 0xf019, 0xf99f,
0xee54, 0xf70e, 0xe62d, 0xeaf1, 0xe8c3, 0xec88, 0xe95c, 0xeb3e, 0xe9a0, 0xeb00,
0xea69, 0xea33, 0xeb1e, 0xeb2c, 0xec9c, 0xecff, 0xecf6, 0xec9d, 0xedf9, 0xeea5,
0xedce, 0xef72, 0xef74, 0xedf1, 0xee73, 0xebbd, 0xf4d5, 0xf119, 0xf4b1, 0xf030,
0xf50e, 0xf253, 0xf500, 0xf275, 0xf45f, 0xf109, 0xf446, 0xf030, 0xf21d, 0xf0ac,
0xf30a, 0xf2e3, 0xef50, 0xf108, 0xefad, 0xf125, 0xed78, 0xef0c, 0xef3d, 0xf053,
0xfab3, 0xfb48, 0x0f6b, 0x0d2b, 0x238f, 0x1cd0, 0x25f1, 0x2053, 0x254e, 0x1f50,
0x2715, 0x1f58, 0x2ae4, 0x2197, 0x2804, 0x1fe6, 0x268c, 0x1f46, 0x26b1, 0x1d3c,
0x23be, 0x1c97, 0x230c, 0x1dc0, 0x1f5d, 0x1a32, 0x1dd7, 0x183c, 0x1c14, 0x1508,
0x1a2f, 0x1433, 0x1d75, 0x195d, 0x1d75, 0x19d3, 0x1998, 0x17e8, 0x1731, 0x1508,
0x141d, 0x122e, 0x1346, 0x10ff, 0x1083, 0x10ae, 0x12a4, 0x14cf, 0x143b, 0x165d,
0x1376, 0x144f, 0x0e9e, 0x0e4e, 0x0c25, 0x0cb7, 0x111a, 0x0dd8, 0x122e, 0x109b,
0x18bc, 0x14a2, 0x18f0, 0x1336, 0x1d65, 0x15fa, 0x1f96, 0x1669, 0x1d22, 0x1756,
0x1ab5, 0x181f, 0x1919, 0x1663, 0x1a96, 0x154e, 0x1864, 0x1317, 0x17ea, 0x1384,
0x176c, 0x13d4, 0x16eb, 0x134a, 0x17b4, 0x142a, 0x18b8, 0x13f6, 0x18d8, 0x14ad,
0x1502, 0x132b, 0x12c9, 0x12be, 0x1743, 0x1419, 0x19b6, 0x1461, 0x178b, 0x13ea,
0x125f, 0x1123, 0x11a1, 0x1121, 0x10da, 0x0dd7, 0x10d0, 0x0c80, 0x0fd0, 0x0ecd,
0x11dd, 0x11d6, 0x10a0, 0x0e84, 0x0eaf, 0x0beb, 0x0ad8, 0x08d5, 0x0b02, 0x0a2c,
0x0f6b, 0x0ab8, 0x113e, 0x09e7, 0x1292, 0x09cd, 0x1087, 0x089a, 0x119f, 0x0b60,
0x118e, 0x0c9a, 0x12eb, 0x0e50, 0x1338, 0x0dba, 0x157f, 0x0ff2, 0x176a, 0x1209,
0x1550, 0x11cf, 0x1408, 0x0fd6, 0x0f9c, 0x0c22, 0x0ec2, 0x0c8d, 0x1001, 0x0bee,
0x0ff7, 0x0a30, 0x10c4, 0x0a69, 0x1138, 0x0c29, 0x122c, 0x0d6c, 0x1346, 0x0f71,
0x14c0, 0x11bd, 0x1577, 0x1151, 0x1739, 0x1321, 0x1426, 0x111d, 0x15a6, 0x1151,
0x1bf7, 0x165a, 0x1bde, 0x162a, 0x1557, 0x1029, 0x1335, 0x0fc0, 0x1625, 0x129e,
0x16c5, 0x1269, 0x15ba, 0x1005, 0x169f, 0x12bb, 0x18b1, 0x16ce, 0x18a8, 0x173c,
0x1710, 0x158a, 0x17e3, 0x1511, 0x1711, 0x1306, 0x1bf2, 0x1545, 0x1cff, 0x1731,
0x1f18, 0x18d0, 0x1ee6, 0x17ff, 0x1c2f, 0x150d, 0x1b39, 0x138e, 0x16fa, 0x1181,
0x19b5, 0x141a, 0x13e2, 0x10db, 0x1188, 0x0e6d, 0x10f6, 0x0de5, 0x11ba, 0x0f3a,
0x1178, 0x0e07, 0x101c, 0x0bc7, 0x1492, 0x0c59, 0x14a5, 0x0e58, 0x187b, 0x1195,
0x195a, 0x10b7, 0x1bea, 0x13f7, 0x1a56, 0x1405, 0x184b, 0x150f, 0x16fa, 0x12b9,
0x12c3, 0x0f63, 0x13b2, 0x0fcd, 0x124b, 0x0e01, 0x138c, 0x1007, 0x1240, 0x0e39,
0x1321, 0x0fbe, 0x1246, 0x0f06, 0x10db, 0x0b9e, 0x12c1, 0x0a3b, 0x127d, 0x0a36,
0x133a, 0x0e1c, 0x13a9, 0x1051, 0x1346, 0x0eb4, 0x11ff, 0x0bf4, 0x0f5f, 0x09d6,
0x0f19, 0x0ae7, 0x0f5d, 0x0a17, 0x0d84, 0x08a7, 0x0c89, 0x0972, 0x0e75, 0x0ab7,
0x0ba8, 0x091d, 0x08a8, 0x06f2, 0x0a95, 0x063e, 0x11b6, 0x0a8d, 0x176b, 0x1092,
0x1313, 0x0fac, 0x0baa, 0x0970, 0x0bb0, 0x086c, 0x0ddc, 0x0872, 0x0c79, 0x06fe,
0x10ce, 0x0a0c, 0x1030, 0x0901, 0x117e, 0x0b73, 0x0ea6, 0x0ab6, 0x0dc3, 0x0f4e,
0x10f0, 0x1371, 0x1061, 0x0ec5, 0x0e1a, 0x09ae, 0x0a94, 0x06b0, 0x0936, 0x0756,
0x0884, 0x0a68, 0x0c54, 0x0edd, 0x0bcf, 0x102d, 0x0c38, 0x0fa3, 0x08e9, 0x0ac6,
0x087f, 0x0ab4, 0x0843, 0x0809, 0x072b, 0x084d, 0x0ac9, 0x0bc9, 0x0aad, 0x0ba2,
0x0d65, 0x0dbc, 0x0c1b, 0x0c0e, 0x0985, 0x0a1b, 0x08a7, 0x0a7e, 0x06a6, 0x0a95,
0x05e0, 0x08a0, 0x0060, 0x0317, 0xff45, 0x02b5, 0x01f0, 0x0460, 0x008d, 0x043b,
0x060c, 0x0850, 0x06fb, 0x07c8, 0x07f5, 0x0919, 0x0542, 0x081f, 0x0041, 0x0829,
0xff42, 0x05af, 0xfd7f, 0x00e2, 0xfd97, 0xffb9, 0xfaae, 0xfbfe, 0xfa1b, 0xfca5,
0xfa36, 0xfe12, 0xfb34, 0xfea3, 0xfa73, 0xfd9d, 0xfb5f, 0xfd7f, 0xfc40, 0xff6c,
0xf98b, 0xfdae, 0xf5ee, 0xf965, 0xf6f7, 0xf9aa, 0xf4fd, 0xfa45, 0xf281, 0xf8ff,
0xf283, 0xf8d0, 0xf350, 0xf8cd, 0xf59d, 0xf745, 0xf363, 0xf437, 0xf908, 0xf659,
0xf729, 0xf74f, 0xf679, 0xf92a, 0xf729, 0xf990, 0xf8ef, 0xfae3, 0xf7e9, 0xf924,
0xf4fa, 0xf628, 0xf5f7, 0xf7bb, 0xf32f, 0xf6e5, 0xf0f7, 0xf776, 0xe7a9, 0xf3e6,
0xe885, 0xf471, 0xe802, 0xf36e, 0xe5ba, 0xf03a, 0xe01b, 0xebb2, 0xe046, 0xecd7,
0xeb7a, 0xf1ce, 0xef39, 0xf430, 0xf692, 0xf905, 0xf4e6, 0xf983, 0xf800, 0x007e,
0xf5d0, 0xfb61, 0xeeab, 0xf5fd, 0xeed0, 0xf7d3, 0xe868, 0xf474, 0xe673, 0xf192,
0xe4b6, 0xed4b, 0xea6d, 0xf2c2, 0xeee1, 0xf75e, 0xefed, 0xf901, 0xf027, 0xf7ba,
0xf0a6, 0xf7d8, 0xf512, 0xfc19, 0xf43e, 0xfaec, 0xf31a, 0xf7cf, 0xf07a, 0xf51e,
0xef6a, 0xf5f5, 0xeebd, 0xf609, 0xe9ab, 0xf000, 0xe79f, 0xed98, 0xe839, 0xec9b,
0xe979, 0xecbc, 0xeb14, 0xef3c, 0xe8e1, 0xed83, 0xe75d, 0xec7e, 0xe817, 0xec42,
0xe567, 0xe96e, 0xe2b6, 0xe824, 0xe250, 0xe782, 0xe35f, 0xe736, 0xe387, 0xe7d5,
0xe082, 0xe6e6, 0xe0da, 0xe831, 0xe016, 0xe5d4, 0xddd9, 0xe2f8, 0xdc4d, 0xe319,
0xdae0, 0xe27d, 0xda3f, 0xe1a9, 0xd7c2, 0xde13, 0xd6cf, 0xdbe9, 0xd9e5, 0xdf57,
0xd983, 0xe008, 0xda4d, 0xe22f, 0xda7c, 0xe1f9, 0xdc46, 0xe34a, 0xdc06, 0xe1b7,
0xdbf0, 0xe056, 0xda6b, 0xdfec, 0xd351, 0xdc12, 0xd0da, 0xdc11, 0xcf77, 0xdb1a,
0xd0b5, 0xda18, 0xd119, 0xd783, 0xd14a, 0xd77d, 0xd1ad, 0xd759, 0xcff0, 0xd644,
0xca2a, 0xd54a, 0xc98f, 0xd5cd, 0xc845, 0xd3a7, 0xc8e9, 0xd4a7, 0xc7a8, 0xd428,
0xc62b, 0xd317, 0xc52f, 0xd159, 0xc4b5, 0xcf2b, 0xcaad, 0xd419, 0xcb7b, 0xd62d,
0xcd00, 0xd8fa, 0xc9a4, 0xd65f, 0xc674, 0xd21a, 0xc8a6, 0xd2d0, 0xc866, 0xd11c,
0xc63b, 0xcee8, 0xc51c, 0xcdfb, 0xc519, 0xcf9e, 0xcab8, 0xd3f8, 0xca83, 0xd2ea,
0xc998, 0xd41f, 0xca1c, 0xd342, 0xca5c, 0xd34f, 0xcb2c, 0xd4e3, 0xcb70, 0xd47b,
0xcbd9, 0xd50a, 0xca18, 0xd179, 0xce10, 0xd549, 0xd82e, 0xdd1b, 0xe159, 0xe57f,
0xf16d, 0xf320, 0x0085, 0xff4d, 0x055c, 0x0469, 0x0825, 0x076d, 0x0658, 0x09b7,
0x06ce, 0x0b02, 0x0263, 0x0991, 0x01a7, 0x07e5, 0x03b2, 0x082d, 0x03ca, 0x09eb,
0x0124, 0x0918, 0x0009, 0x07af, 0xffdb, 0x03cd, 0xfef0, 0x024f, 0xfffc, 0x0262,
0xfe53, 0x018f, 0xfc42, 0x01de, 0xfb34, 0x015e, 0xf665, 0xfcad, 0xf3a6, 0xf8ff,
0xf3b1, 0xf70b, 0xf312, 0xf668, 0xf59d, 0xf7fe, 0xf2dd, 0xf589, 0xf3cc, 0xf9fa,
0xf20a, 0xf77b, 0xf09c, 0xf52a, 0xf310, 0xf6ab, 0xec2d, 0xf2ad, 0xea82, 0xf1fa,
0xe8ad, 0xecb7, 0xed59, 0xedd9, 0xf244, 0xf0ce, 0xf4a0, 0xf404, 0xfbb7, 0xf996,
0xfd6d, 0xfa35, 0x00e6, 0xfb3d, 0x0261, 0xfcb1, 0x0681, 0xff97, 0x04d7, 0xfed5,
0x04c2, 0xfff9, 0x0663, 0x011b, 0x085f, 0x0240, 0x0827, 0x0197, 0x068c, 0x012a,
0x06d3, 0x0052, 0x0506, 0x00f0, 0x03e3, 0x00c7, 0x0090, 0xfff2, 0x0180, 0x00b1,
0x0071, 0xff15, 0x006e, 0xfdc8, 0xff37, 0xf926, 0xffae, 0xf97a, 0x008c, 0xf83f,
0xff29, 0xf844, 0x01b8, 0xfb68, 0x01fb, 0xfb26, 0x0105, 0xfaae, 0x00bf, 0xfa37,
0xff96, 0xf8b5, 0x010a, 0xf813, 0xfeec, 0xf713, 0xfecb, 0xf938, 0xfd1f, 0xf935,
0xfbfd, 0xf755, 0xfc8c, 0xf534, 0xfe42, 0xf5c0, 0x012c, 0xf970, 0x0154, 0xfb7e,
0x03bc, 0xfd2a, 0x03c1, 0xfb73, 0x035d, 0xfb18, 0x01f4, 0xfae2, 0x056f, 0xfde1,
0x07dc, 0xff20, 0x09b6, 0xff58, 0x0838, 0xfe90, 0x0520, 0xfd03, 0x040c, 0xfd7b,
0x02f0, 0xff58, 0x055a, 0x0068, 0x0351, 0xfb1d, 0x013a, 0xf90c, 0x0242, 0xf98b,
0x03c6, 0xf9f8, 0x0898, 0xff3e, 0x062f, 0xff61, 0x06f5, 0x026e, 0x07dc, 0x0305,
0x0b0c, 0x04ff, 0x0d58, 0x06c2, 0x0cde, 0x060a, 0x0d28, 0x061e, 0x0cc4, 0x052b,
0x09b9, 0x028f, 0x027c, 0xfcd8, 0x0462, 0xff34, 0x0501, 0x0006, 0x07e7, 0x024c,
0x0625, 0xff1c, 0x03de, 0xfb7e, 0x02f9, 0xfbdd, 0x0442, 0xfe0b, 0x0698, 0x0081,
0x034f, 0xfefe, 0x063e, 0x0236, 0x0a6f, 0x05cb, 0x0bc0, 0x0553, 0x0c28, 0x04b1,
0x0cd7, 0x0646, 0x0efa, 0x08d2, 0x0c24, 0x07d1, 0x0dfc, 0x08e5, 0x0994, 0x0712,
0x08b2, 0x085e, 0x07b7, 0x0662, 0x068f, 0x0513, 0x0abd, 0x081c, 0x0bcc, 0x0866,
0x10a0, 0x0a10, 0x10d4, 0x093e, 0x10bd, 0x0a2a, 0x0e48, 0x0a07, 0x0f72, 0x0d1d,
0x0fc8, 0x0da3, 0x13d8, 0x0ef4, 0x1738, 0x10dc, 0x1c27, 0x1671, 0x1a6b, 0x14e4,
0x1790, 0x148a, 0x1652, 0x1410, 0x152d, 0x14aa, 0x165c, 0x14dc, 0x14ee, 0x123f,
0x164f, 0x130a, 0x1519, 0x10f0, 0x13fb, 0x104d, 0x127a, 0x0d11, 0x1186, 0x0c25,
0x11a6, 0x09c6, 0x12cd, 0x0a29, 0x11d8, 0x0859, 0x112f, 0x0756, 0x13d2, 0x0a37,
0x1446, 0x0a5a, 0x1022, 0x07c9, 0x0e68, 0x063f, 0x0c2a, 0x07dd, 0x0d5b, 0x0962,
0x0f0a, 0x070a, 0x0ff9, 0x059b, 0x1566, 0x0985, 0x170f, 0x0ba9, 0x18fa, 0x0ecb,
0x167d, 0x0d2a, 0x130d, 0x0a9b, 0x13e3, 0x0b66, 0x12d0, 0x0a05, 0x129a, 0x09c5,
0x116e, 0x080c, 0x124b, 0x09db, 0x0ed9, 0x06a9, 0x0e59, 0x05ad, 0x1143, 0x0819,
0x0e78, 0x0632, 0x1085, 0x07c7, 0x112a, 0x0876, 0x1625, 0x0dfc, 0x1769, 0x0eb0,
0x13a6, 0x0eec, 0x1490, 0x1140, 0x1187, 0x1189, 0x12f7, 0x12ca, 0x12be, 0x10d3,
0x131f, 0x11e9, 0x1349, 0x0f70, 0x116f, 0x0cd9, 0x1223, 0x0bbf, 0x10b5, 0x0ca5,
0x10d0, 0x0ea7, 0x1222, 0x0e65, 0x123d, 0x0eaf, 0x105d, 0x0e32, 0x0f86, 0x0e0a,
0x0ebe, 0x0de8, 0x122a, 0x0fe9, 0x12ae, 0x0f89, 0x0f4e, 0x0b87, 0x0d3f, 0x095c,
0x0c99, 0x09c8, 0x0b87, 0x09fc, 0x0aa2, 0x0bce, 0x0b12, 0x0b44, 0x0ac1, 0x0dde,
0x09ad, 0x0e34, 0x060b, 0x08ea, 0x055e, 0x0787, 0x0693, 0x0836, 0x0693, 0x0921,
0x06d9, 0x08ff, 0x0629, 0x0847, 0x041f, 0x0813, 0x028b, 0x05f9, 0xffe2, 0x028c,
0xfe4e, 0x02c4, 0xfc89, 0x0109, 0xfd85, 0x0273, 0xf98b, 0xff9b, 0xf813, 0xfdc7,
0xf4e2, 0xfb95, 0xf558, 0xfcff, 0xf56c, 0xfd11, 0xf548, 0xfc00, 0xf881, 0xfe8d,
0xf623, 0xfdfb, 0xfc19, 0x0386, 0xfd24, 0x046e, 0x0610, 0x0c68, 0x0a04, 0x0faa,
0x0c64, 0x128d, 0x0d0b, 0x1374, 0x0885, 0x11fb, 0x079a, 0x10ef, 0x02ba, 0x0c14,
0x01c2, 0x0c46, 0x009d, 0x09ed, 0xff22, 0x07e6, 0xfe2d, 0x077c, 0xfec3, 0x0888,
0xfee0, 0x0719, 0xfdf9, 0x065f, 0xfc5f, 0x0440, 0xfccd, 0x042e, 0xf9f8, 0x00f5,
0xf75c, 0xff0b, 0xf601, 0xfe05, 0xf6d9, 0xfce8, 0xf40a, 0xfc74, 0xf133, 0xfb37,
0xeefb, 0xf99f, 0xf07e, 0xfa75, 0xf058, 0xf80e, 0xef4b, 0xf70e, 0xf0ca, 0xf644,
0xf100, 0xf649, 0xf16c, 0xf745, 0xf255, 0xf80d, 0xf40c, 0xfb6b, 0xf16a, 0xf8f9,
0xf126, 0xf974, 0xf2cc, 0xfa52, 0xf4c2, 0xfafa, 0xf2ec, 0xf8ba, 0xefd3, 0xf50e,
0xef12, 0xf4e8, 0xf0b7, 0xf62e, 0xf07d, 0xf469, 0xf42b, 0xf6aa, 0xf8d7, 0xfb32,
0x00a4, 0x0108, 0x04f8, 0x041f, 0x0b06, 0x0b07, 0x10c5, 0x114c, 0x1124, 0x1360,
0x1282, 0x12b5, 0x110d, 0x1043, 0x12f5, 0x11f2, 0x137f, 0x11c0, 0x1266, 0x124d,
0x0f48, 0x0f63, 0x0df3, 0x0d2f, 0x0db6, 0x0c51, 0x0cf7, 0x0bd7, 0x0a3f, 0x0aff,
0x0c49, 0x0c72, 0x0a72, 0x09bd, 0x0552, 0x069b, 0x03d2, 0x04d8, 0x0573, 0x0509,
0x0a21, 0x083c, 0x0d42, 0x0a8f, 0x10ec, 0x0d98, 0x0e6c, 0x0cc5, 0x10f9, 0x1094,
0x105f, 0x1006, 0x113c, 0x1126, 0x1132, 0x0fc0, 0x0da8, 0x0deb, 0x0afa, 0x0c5e,
0x0411, 0x0487, 0x04ca, 0x0474, 0x0050, 0x02e0, 0xfd7b, 0x03b4, 0xfa37, 0xffca,
0xfa62, 0xfc33, 0xfe3c, 0xfbf9, 0xfd85, 0xfc07, 0xfc8d, 0xff5d, 0xf991, 0x0094,
0xfea7, 0x04fd, 0x0037, 0x02bd, 0x018b, 0x0388, 0x0027, 0x0309, 0xfeb1, 0x01e2,
0xfec8, 0x010f, 0xfc6b, 0xfecb, 0xfb44, 0xff0b, 0xf834, 0xfc66, 0xf5a5, 0xf9d9,
0xf75b, 0xfc8e, 0xf7fd, 0xfde0, 0xf9a1, 0xff19, 0xf8ef, 0xfe4f, 0xf747, 0xfe35,
0xf695, 0xfe52, 0xf2be, 0xf92c, 0xf369, 0xf9a3, 0xf073, 0xf613, 0xf153, 0xf6c2,
0xf258, 0xf855, 0xef1c, 0xf8c4, 0xee3b, 0xf8cc, 0xf0f6, 0xfa36, 0xf061, 0xf808,
0xf111, 0xf752, 0xf2b1, 0xfafe, 0xf1b5, 0xfc84, 0xf185, 0xfda8, 0xf122, 0xfaf7,
0xf1f3, 0xf9c2, 0xf112, 0xf8d3, 0xf007, 0xf787, 0xeedc, 0xf607, 0xec40, 0xf5dd,
0xec39, 0xf48b, 0xedf1, 0xf427, 0xef63, 0xf502, 0xed66, 0xf2b7, 0xeca5, 0xf32a,
0xefc2, 0xf4f1, 0xf044, 0xf2bf, 0xf2b7, 0xf2a7, 0xf0cf, 0xf180, 0xefd3, 0xf28c,
0xf0f9, 0xf364, 0xef96, 0xf18f, 0xef49, 0xf173, 0xf08b, 0xf0bb, 0xf0f2, 0xef41,
0xefd4, 0xee84, 0xee09, 0xefed, 0xee91, 0xf198, 0xef10, 0xee93, 0xed93, 0xebc0,
0xee0a, 0xecc4, 0xed29, 0xed39, 0xec38, 0xedec, 0xe876, 0xeb5d, 0xe6d4, 0xe9c4,
0xea80, 0xeaa3, 0xedfe, 0xec31, 0xf070, 0xee9e, 0xf085, 0xedf6, 0xf02c, 0xedf3,
0xef97, 0xee74, 0xf2f1, 0xf015, 0xf332, 0xef6a, 0xf804, 0xf294, 0xf7f8, 0xf284,
0xfbac, 0xf88a, 0xff0d, 0xfc73, 0xff57, 0xfcdc, 0x0297, 0xfd02, 0x0012, 0xf913,
0x0302, 0xfd47, 0x0495, 0xffc5, 0x09f5, 0x055e, 0x102d, 0x0bcf, 0x1639, 0x10a3,
0x1c55, 0x1559, 0x1da6, 0x1770, 0x21e4, 0x1d0c, 0x23d3, 0x1fb4, 0x241b, 0x1fef,
0x25e8, 0x20a8, 0x28aa, 0x1f1d, 0x28a0, 0x1e45, 0x2406, 0x1cba, 0x21f9, 0x1d49,
0x1ddf, 0x1b41, 0x1fab, 0x1b58, 0x1c20, 0x1859, 0x19fc, 0x1652, 0x179c, 0x1467,
0x1808, 0x13cf, 0x1aaf, 0x15dc, 0x19dc, 0x16c3, 0x170b, 0x1646, 0x167c, 0x1555,
0x1947, 0x15f0, 0x192a, 0x154d, 0x1b33, 0x1676, 0x19ac, 0x15e6, 0x1af0, 0x156d,
0x1c74, 0x14e7, 0x1d72, 0x14bb, 0x1c98, 0x1507, 0x1bbd, 0x1281, 0x1c3b, 0x117b,
0x1cc6, 0x109a, 0x1bbe, 0x10ee, 0x1a13, 0x0e8b, 0x1bc9, 0x0e3c, 0x1be9, 0x10e6,
0x1b6b, 0x1307, 0x19fe, 0x127c, 0x1ab9, 0x10bd, 0x1a31, 0x0f7c, 0x1adf, 0x0f15,
0x1810, 0x0d09, 0x14c9, 0x0cc0, 0x1519, 0x0d3e, 0x163d, 0x0c5d, 0x19a5, 0x0dac,
0x18a2, 0x0ddd, 0x1a2d, 0x1092, 0x1987, 0x1071, 0x1c44, 0x13c1, 0x1d1f, 0x1317,
0x1cda, 0x1398, 0x1db0, 0x1484, 0x1b45, 0x1468, 0x19a5, 0x156d, 0x169c, 0x110a,
0x16ac, 0x0ec6, 0x164e, 0x0c32, 0x1827, 0x0f0b, 0x164a, 0x0e3c, 0x14ab, 0x0cad,
0x14df, 0x0c14, 0x13af, 0x0ba9, 0x139a, 0x0e26, 0x1487, 0x0fe6, 0x17a5, 0x122f,
0x1761, 0x108a, 0x1920, 0x131d, 0x1844, 0x13a1, 0x1a7e, 0x15eb, 0x1c73, 0x17d2,
0x1dbb, 0x1a78, 0x1e7a, 0x1a41, 0x1bc3, 0x18d1, 0x1ae9, 0x192e, 0x1790, 0x1638,
0x185f, 0x15c7, 0x1828, 0x11e4, 0x1806, 0x10f8, 0x153f, 0x0ecf, 0x1475, 0x0ffd,
0x1461, 0x105d, 0x148c, 0x108d, 0x1549, 0x0fcb, 0x1406, 0x0dc7, 0x12f6, 0x0e19,
0x121d, 0x0e89, 0x136b, 0x1175, 0x14ff, 0x11b0, 0x17bb, 0x127e, 0x1732, 0x1274,
0x15f3, 0x1206, 0x148b, 0x1222, 0x14d0, 0x11c6, 0x163f, 0x11e2, 0x1742, 0x11e5,
0x168a, 0x105e, 0x12a0, 0x0cbf, 0x1116, 0x0c73, 0x11a0, 0x0cf0, 0x129b, 0x0ddf,
0x153e, 0x111a, 0x1440, 0x10ba, 0x140f, 0x13d4, 0x15cf, 0x15a5, 0x1560, 0x14bf,
0x12a1, 0x1112, 0x10eb, 0x0dce, 0x1202, 0x0e65, 0x0ea1, 0x0ae7, 0x0e0d, 0x0b03,
0x0a42, 0x074b, 0x0a4f, 0x0717, 0x0bd2, 0x0501, 0x0aaa, 0x044f, 0x0ae6, 0x06df,
0x0c35, 0x085e, 0x0f21, 0x0d3f, 0x0e0e, 0x0cd8, 0x0eeb, 0x0cc4, 0x0ef9, 0x0b7c,
0x10dd, 0x0b3f, 0x0f21, 0x09e1, 0x0ec2, 0x0aee, 0x0f73, 0x0bb5, 0x0e81, 0x0d79,
0x0f24, 0x0ee3, 0x07aa, 0x09c0, 0x0511, 0x071a, 0x01b9, 0x01fa, 0x0206, 0x029e,
0x01a5, 0x01f1, 0x01bf, 0x01c3, 0x066b, 0x0498, 0x0738, 0x0619, 0x0a1d, 0x0965,
0x0a38, 0x0868, 0x0cc0, 0x081a, 0x0a08, 0x0609, 0x0f48, 0x0b26, 0x10c4, 0x0d10,
0x128f, 0x110f, 0x10ab, 0x0fe3, 0x0ac4, 0x0c5c, 0x0a68, 0x0b8b, 0x07e1, 0x0858,
0x0bd6, 0x0c10, 0x0c81, 0x0d06, 0x0de9, 0x0e3e, 0x0aa7, 0x0b31, 0x0917, 0x0ba9,
0x076a, 0x0ae6, 0x06cd, 0x0a45, 0x06aa, 0x0958, 0x0789, 0x0a19, 0x08f1, 0x0c4b,
0x062a, 0x0949, 0x05b4, 0x081a, 0x04d2, 0x085e, 0x04e0, 0x0c08, 0x0351, 0x0bc3,
0x0491, 0x0c5f, 0x041d, 0x0b58, 0xff9f, 0x0921, 0xfd5c, 0x06d5, 0xfc2d, 0x04d8,
0xfcfc, 0x049f, 0xfb8d, 0x010e, 0xfa67, 0x01ab, 0xfa09, 0x017b, 0xf9d7, 0x0086,
0xfc7b, 0x0302, 0xfbfe, 0x02a0, 0xf88d, 0x0285, 0xf5ca, 0x0008, 0xf348, 0xfdb4,
0xf3db, 0xfe06, 0xf485, 0xfde2, 0xf44e, 0xfcec, 0xf5de, 0xfaee, 0xf6dd, 0xfa6b,
0xf526, 0xf83b, 0xf253, 0xf653, 0xee4f, 0xf32a, 0xee4d, 0xf3b6, 0xee25, 0xf483,
0xee59, 0xf487, 0xeed3, 0xf2e2, 0xee99, 0xf15b, 0xf473, 0xf303, 0xf2f1, 0xf284,
0xf4cd, 0xf655, 0xf3e8, 0xf6b8, 0xf7d3, 0xfa61, 0xfa84, 0xf94c, 0xf531, 0xf797,
0xf2cd, 0xf87f, 0xecf8, 0xf3e3, 0xe9fe, 0xf0de, 0xe9b5, 0xedfa, 0xe9f7, 0xed49,
0xe9c7, 0xeca8, 0xea3b, 0xee13, 0xe964, 0xef63, 0xe86d, 0xef4e, 0xe609, 0xec7f,
0xe4fc, 0xeb32, 0xe3e3, 0xeae0, 0xe421, 0xec50, 0xe3f0, 0xeb50, 0xe6ea, 0xed17,
0xe9b4, 0xeecd, 0xeb0f, 0xef1d, 0xeb4a, 0xf119, 0xe9ee, 0xf01a, 0xeae1, 0xf293,
0xecaf, 0xf3fd, 0xecbe, 0xf65e, 0xeab7, 0xf638, 0xeaf6, 0xf548, 0xea01, 0xf42a,
0xeb60, 0xf451, 0xec67, 0xf36f, 0xec70, 0xf2de, 0xeda4, 0xf2e1, 0xecfe, 0xf186,
0xed42, 0xf24a, 0xeb24, 0xee65, 0xe9c9, 0xec7e, 0xe7a2, 0xe9ac, 0xe7fa, 0xe9d1,
0xe618, 0xe876, 0xe4f5, 0xe844, 0xe4dd, 0xe97d, 0xe633, 0xea66, 0xe710, 0xe970,
0xe47b, 0xe562, 0xe507, 0xe599, 0xe3fa, 0xe5a1, 0xe5db, 0xe822, 0xe7d3, 0xe84e,
0xe88a, 0xe6ef, 0xe627, 0xe4e6, 0xe30d, 0xe22c, 0xe38e, 0xe254, 0xe27a, 0xe1be,
0xe105, 0xe104, 0xe079, 0xdfd9, 0xdf72, 0xde58, 0xe42a, 0xe1e6, 0xe45b, 0xe19f,
0xe446, 0xe262, 0xe366, 0xe151, 0xe470, 0xe14d, 0xe338, 0xe189, 0xe206, 0xe264,
0xe080, 0xdf5c, 0xdfb9, 0xdd86, 0xdf96, 0xde47, 0xdc52, 0xdc33, 0xdb61, 0xdaf4,
0xd77a, 0xd7ae, 0xd83c, 0xd8d0, 0xd708, 0xd69e, 0xd57e, 0xd52b, 0xd45b, 0xd5ae,
0xd22f, 0xd56f, 0xd09f, 0xd5e0, 0xcf78, 0xd4e5, 0xcde5, 0xd42b, 0xce68, 0xd43d,
0xcde5, 0xd33f, 0xce11, 0xd403, 0xccfa, 0xd25a, 0xca98, 0xd094, 0xca6d, 0xd065,
0xcb12, 0xd0ee, 0xcade, 0xd004, 0xca04, 0xcf76, 0xc786, 0xcd98, 0xc54d, 0xcc7d,
0xc6d6, 0xcd32, 0xc805, 0xcc8b, 0xc7a6, 0xcdad, 0xc78e, 0xcf4a, 0xc81c, 0xcfee,
0xc892, 0xcec7, 0xc63c, 0xcce8, 0xc58f, 0xcca0, 0xc55f, 0xcb92, 0xc459, 0xcbac,
0xc729, 0xce2e, 0xc843, 0xcec1, 0xcc2d, 0xd196, 0xcd3d, 0xd14b, 0xcb22, 0xd185,
0xcb9d, 0xd224, 0xca4a, 0xd053, 0xca8c, 0xd01e, 0xcc55, 0xcf8f, 0xd01f, 0xd2aa,
0xd41f, 0xd6b6, 0xd7fb, 0xda9e, 0xdcb4, 0xdf2e, 0xe093, 0xe2ef, 0xe4f0, 0xe815,
0xeaa5, 0xee2b, 0xf1e5, 0xf37b, 0xf703, 0xf729, 0xf862, 0xf787, 0xfc36, 0xf9c8,
0xfcb8, 0xfa48, 0xfdad, 0xfcec, 0xfdab, 0xff1f, 0xfd28, 0xfeab, 0xffce, 0x0172,
0x00bb, 0x023f, 0x0400, 0x04da, 0x048c, 0x0569, 0x01b6, 0x036b, 0x00a8, 0x01f9,
0xfe53, 0xfd76, 0xff25, 0xfdcd, 0xff0d, 0xfe13, 0xfd19, 0xfd97, 0xfc51, 0xfc7e,
0xfbdc, 0xfa89, 0xfca9, 0xfb74, 0xfba2, 0xfc24, 0xf8b3, 0xfba4, 0xf95f, 0xfadd,
0xfc65, 0xfa0a, 0xfdf7, 0xf9d4, 0xfd55, 0xf88b, 0xfb92, 0xf7a1, 0xfccf, 0xf815,
0xfcd6, 0xf743, 0xfe7c, 0xf8d9, 0x00ca, 0xfafa, 0x027f, 0xfd23, 0x020f, 0xfd30,
0xffd4, 0xfdba, 0x0215, 0xfe69, 0x03a4, 0xfba4, 0x04ee, 0xfb9e, 0x0676, 0xfd6a,
0x0677, 0xfe52, 0x081c, 0x0031, 0x0805, 0xff03, 0x05ee, 0xff97, 0x06db, 0x01ed,
0x041c, 0xff71, 0x038d, 0xfe0f, 0x0443, 0xfd0c, 0x05da, 0xfe08, 0x071b, 0xfc9e,
0x070b, 0xfcb3, 0x07a6, 0xfdb1, 0x072e, 0xfd78, 0x0769, 0xfca6, 0x06f2, 0xfaf4,
0x08f7, 0xfcc4, 0x0792, 0xfd97, 0x074f, 0xff4c, 0x08f1, 0xff58, 0x0ca4, 0x00dd,
0x0ce9, 0x00df, 0x09f4, 0x0015, 0x097b, 0x0026, 0x06b4, 0xfed8, 0x06ed, 0xff17,
0x0483, 0xfa2f, 0x04ef, 0xfac0, 0x037e, 0xfb2a, 0x01ed, 0xfb06, 0x0567, 0xfd11,
0x08b2, 0xfde7, 0x0a19, 0x002b, 0x08aa, 0xff7d, 0x060d, 0xfec6, 0x0683, 0xffa2,
0x075f, 0xff21, 0x05ce, 0xfe92, 0x0777, 0xffd2, 0x0786, 0xff87, 0x0bd5, 0x049b,
0x0bc6, 0x05bc, 0x0cee, 0x06be, 0x0e29, 0x0643, 0x0e39, 0x0424, 0x0da4, 0x03dd,
0x0d31, 0x0276, 0x0d0d, 0x0247, 0x0c10, 0x042f, 0x0bac, 0x0640, 0x0917, 0x04d9,
0x09a9, 0x03b2, 0x0a07, 0x046e, 0x09f5, 0x0632, 0x0af4, 0x05dc, 0x0c4e, 0x05dd,
0x0927, 0x0472, 0x081e, 0x0531, 0x088a, 0x0493, 0x0905, 0x0413, 0x0a4a, 0x043f,
0x0ac5, 0x048d, 0x0f10, 0x098e, 0x0f4c, 0x0a75, 0x10fd, 0x0cbc, 0x137f, 0x0f47,
0x141d, 0x113c, 0x1455, 0x110d, 0x11c7, 0x0f7f, 0x1067, 0x0f08, 0x0df9, 0x0cc2,
0x0eb6, 0x0d09, 0x0dc1, 0x0aa8, 0x0d38, 0x0ae4, 0x0f2e, 0x0c23, 0x10a4, 0x0cf7,
0x11a4, 0x0f73, 0x107c, 0x105c, 0x12ca, 0x1351, 0x12f4, 0x128b, 0x12a6, 0x1290,
0x1250, 0x1291, 0x139a, 0x135a, 0x12b9, 0x11ab, 0x1069, 0x10f3, 0x11bc, 0x1387,
0x12d8, 0x13aa, 0x1426, 0x13ff, 0x1385, 0x13df, 0x11bf, 0x12e9, 0x0f99, 0x1087,
0x0fce, 0x101f, 0x0e95, 0x0ea1, 0x0f5f, 0x0f82, 0x0f30, 0x0ce8, 0x0e3b, 0x0ae2,
0x107e, 0x0c7f, 0x118f, 0x0de7, 0x153d, 0x13e1, 0x14c9, 0x138a, 0x158e, 0x133d,
0x15f7, 0x1297, 0x169d, 0x1297, 0x1654, 0x123f, 0x14cf, 0x115b, 0x13ce, 0x1129,
0x1286, 0x0f4e, 0x13e1, 0x0fff, 0x12b4, 0x0ed0, 0x1249, 0x0dce, 0x0e4c, 0x09b7,
0x0d80, 0x08c9, 0x0de7, 0x08a5, 0x0f56, 0x09ab, 0x10a1, 0x098f, 0x0da6, 0x07d0,
0x1016, 0x0baa, 0x1164, 0x0d82, 0x14ba, 0x1079, 0x15dc, 0x1039, 0x15e5, 0x0fe5,
0x14c9, 0x0f1d, 0x1317, 0x0f6c, 0x1151, 0x0f0d, 0x10c3, 0x0e16, 0x120e, 0x0f09,
0x1476, 0x109e, 0x1634, 0x11f6, 0x14d3, 0x1360, 0x1540, 0x150b, 0x1424, 0x1344,
0x1475, 0x1372, 0x1248, 0x115f, 0x1008, 0x10d4, 0x111d, 0x129c, 0x12f4, 0x13e2,
0x15d6, 0x15d3, 0x13c8, 0x1516, 0x152b, 0x16b3, 0x164d, 0x15a0, 0x1854, 0x1884,
0x16dd, 0x18b3, 0x14db, 0x17db, 0x1593, 0x172c, 0x15df, 0x16f3, 0x1430, 0x161b,
0x0eb2, 0x10af, 0x0dc6, 0x0fe2, 0x0ab2, 0x0d98, 0x0b51, 0x0e37, 0x0a62, 0x0cf1,
0x0a87, 0x0bfb, 0x0adc, 0x0b34, 0x078a, 0x0a06, 0x0975, 0x0c65, 0x093f, 0x0cb1,
0x097a, 0x0d9b, 0x081b, 0x0c41, 0x0787, 0x0bf4, 0x0721, 0x0b16, 0x05df, 0x088c,
0x0729, 0x097b, 0x07ad, 0x0ab0, 0x071e, 0x0aa0, 0x064c, 0x0a37, 0x0575, 0x09fe,
0x03d4, 0x090c, 0x0213, 0x07dd, 0xfc64, 0x0250, 0xfac5, 0x0177, 0xf89f, 0x0063,
0xf980, 0x00a2, 0xfc60, 0x031a, 0xfc72, 0x0414, 0xfd0c, 0x0401, 0xfcc2, 0x0253,
0xff43, 0x055c, 0xff6a, 0x07e8, 0xfda8, 0x078a, 0xfd2a, 0x0641, 0xfcb6, 0x04d8,
0xfd65, 0x04b1, 0xfe94, 0x05dd, 0xfdd9, 0x0663, 0xfda4, 0x0869, 0xfcb7, 0x07d3,
0xfb91, 0x04e0, 0xfb5a, 0x037e, 0xf97b, 0x016f, 0xf9cd, 0x01e7, 0xf7ed, 0xff0c,
0xf5c1, 0xfdcd, 0xf1e2, 0xfb1c, 0xf0cb, 0xfa14, 0xf2cd, 0xfafa, 0xf4ec, 0xfc4b,
0xf594, 0xff04, 0xf4dc, 0xfdc3, 0xf4f6, 0xfdaf, 0xf31a, 0xfda6, 0xf23f, 0xfe37,
0xf2ce, 0xfcc9, 0xf370, 0xfb62, 0xf1e6, 0xfa38, 0xf3fa, 0xfb05, 0xf3ee, 0xfab6,
0xf6db, 0xfcda, 0xf7c9, 0xfdcd, 0xf7e7, 0xfe2f, 0xf7d9, 0xfd09, 0xf3c9, 0xf8f2,
0xf2c0, 0xf874, 0xf31b, 0xf800, 0xf4bd, 0xf9f0, 0xf3ea, 0xf925, 0xf362, 0xf7d8,
0xf457, 0xf84d, 0xf6cd, 0xf90d, 0xf8bf, 0xfa4a, 0xfada, 0xfd03, 0xface, 0xfe52,
0xfa9d, 0xfe66, 0xf9b9, 0xfd0a, 0xfaf4, 0xfd16, 0xf9d7, 0xfb21, 0xfba4, 0xfcba,
0xfd85, 0xfd46, 0xff1e, 0xff0d, 0x00f1, 0x0069, 0x011e, 0x00b1, 0x04a9, 0x05b8,
0x0692, 0x0732, 0x0817, 0x089e, 0x06e6, 0x0655, 0x075c, 0x0754, 0x08b0, 0x09c4,
0x08a5, 0x09d7, 0x06c9, 0x07d2, 0x04e7, 0x05b2, 0x0496, 0x0550, 0x0601, 0x071f,
0x08f5, 0x09e1, 0x0976, 0x0965, 0x0985, 0x0835, 0x0741, 0x065f, 0x06ac, 0x07c5,
0x053a, 0x062f, 0x05b4, 0x05e7, 0x07e3, 0x05ea, 0x07e0, 0x05da, 0x0873, 0x0838,
0x072d, 0x0785, 0x0805, 0x0a29, 0x083b, 0x0a51, 0x07d0, 0x0a74, 0x06ee, 0x08ca,
0x0403, 0x0498, 0x02b9, 0x044e, 0x01d0, 0x026f, 0x00ef, 0x00ba, 0x0222, 0x0177,
0x03f6, 0x03d8, 0x0565, 0x05ba, 0x0347, 0x035c, 0x0016, 0x0054, 0xfe83, 0xff4f,
0xfbbf, 0xfccc, 0xfcba, 0xfdc7, 0xf9de, 0xfaf1, 0xf7ac, 0xf92c, 0xf866, 0xf9fc,
0xf7c7, 0xf9dd, 0xf714, 0xf92f, 0xf55b, 0xf788, 0xf7bb, 0xf85e, 0xf904, 0xf8ff,
0xf970, 0xfb0e, 0xf849, 0xfba3, 0xf84b, 0xfc33, 0xf825, 0xfc2d, 0xf6c7, 0xfbcc,
0xf633, 0xfa49, 0xf5f6, 0xf99d, 0xf5ed, 0xfadc, 0xf5d0, 0xfc32, 0xf657, 0xfc93,
0xf630, 0xfbcd, 0xf526, 0xfa78, 0xf330, 0xf87f, 0xf376, 0xf94f, 0xf290, 0xf86d,
0xf270, 0xf72e, 0xf04c, 0xf486, 0xef8b, 0xf397, 0xf266, 0xf598, 0xf341, 0xf5d2,
0xf343, 0xf80b, 0xf187, 0xf73c, 0xf339, 0xf825, 0xf3bd, 0xf7d6, 0xf25a, 0xf645,
0xf263, 0xf60b, 0xf0a2, 0xf39f, 0xf0d1, 0xf38b, 0xee31, 0xf08c, 0xec97, 0xef8a,
0xed1b, 0xeead, 0xee48, 0xef3d, 0xf14d, 0xf325, 0xf0d9, 0xf227, 0xf084, 0xf18a,
0xf08e, 0xf19b, 0xf0ba, 0xf226, 0xf0c2, 0xf1cd, 0xef1a, 0xeec3, 0xef48, 0xeef8,
0xf020, 0xeee2, 0xf046, 0xeef0, 0xf29f, 0xf049, 0xf2d5, 0xef71, 0xf31a, 0xf10a,
0xf2ff, 0xf23f, 0xf309, 0xf2ae, 0xf3e4, 0xf266, 0xf37c, 0xf0c4, 0xf2e5, 0xefc3,
0xf35b, 0xf0f1, 0xf483, 0xf37c, 0xf4f5, 0xf4a5, 0xf4df, 0xf3eb, 0xf6b8, 0xf482,
0xf941, 0xf57b, 0xf9c0, 0xf6cf, 0xfa11, 0xf7fa, 0xfb8b, 0xf97e, 0xfcc4, 0xfa28,
0xfba8, 0xf9e3, 0xfc1e, 0xfb73, 0xff91, 0xfcba, 0x0290, 0xfed1, 0x0416, 0xff95,
0x05ed, 0x00bd, 0x0747, 0x02b8, 0x08aa, 0x05a1, 0x08d5, 0x084b, 0x09fb, 0x092e,
0x0d3d, 0x0a1e, 0x0fcf, 0x0bd2, 0x1310, 0x0e96, 0x1502, 0x10a6, 0x1663, 0x11e2,
0x17fa, 0x1280, 0x199f, 0x11f6, 0x1aaa, 0x122e, 0x1bf5, 0x13d6, 0x1c29, 0x1444,
0x1e45, 0x16f9, 0x1f33, 0x1829, 0x1d95, 0x17c7, 0x1d67, 0x17a3, 0x1c40, 0x1559,
0x1d4b, 0x1601, 0x1e94, 0x1663, 0x1f3a, 0x16d0, 0x23b4, 0x1ae1, 0x23fc, 0x1a3f,
0x235b, 0x1b34, 0x2262, 0x1b3b, 0x21af, 0x1a3a, 0x22f0, 0x1a13, 0x2221, 0x1894,
0x21ce, 0x193a, 0x1ecf, 0x1668, 0x1e43, 0x1531, 0x1c86, 0x12c9, 0x1bc2, 0x137b,
0x1d81, 0x157a, 0x1e4c, 0x153c, 0x1ff0, 0x152f, 0x1f45, 0x141b, 0x2022, 0x1777,
0x1edf, 0x18d9, 0x1fea, 0x1ab1, 0x211c, 0x1a5d, 0x20db, 0x195b, 0x207e, 0x1945,
0x1fb7, 0x195a, 0x1e25, 0x1870, 0x1c15, 0x162d, 0x1b71, 0x16b6, 0x1e43, 0x18b8,
0x1e20, 0x177e, 0x1cc7, 0x17ec, 0x1cb2, 0x1809, 0x1da2, 0x18c8, 0x1dac, 0x18d4,
0x1bcd, 0x17b2, 0x1af7, 0x17f2, 0x1a5c, 0x1915, 0x1afd, 0x19d2, 0x1a58, 0x19d6,
0x1a47, 0x1a59, 0x1a6e, 0x19fa, 0x1a65, 0x196a, 0x1852, 0x1583, 0x1773, 0x147c,
0x18b4, 0x1588, 0x1a83, 0x17d2, 0x1b35, 0x1758, 0x1b69, 0x1650, 0x19fa, 0x1568,
0x1979, 0x1534, 0x18cf, 0x1399, 0x1804, 0x13d9, 0x1847, 0x14c4, 0x18c9, 0x1466,
0x1b13, 0x1651, 0x1b51, 0x1611, 0x1a85, 0x171b, 0x19c4, 0x1775, 0x1946, 0x17aa,
0x194c, 0x1729, 0x17b7, 0x15a5, 0x17c6, 0x1546, 0x17d1, 0x1497, 0x174a, 0x152b,
0x1489, 0x130b, 0x1354, 0x114f, 0x12ac, 0x0fcc, 0x13e7, 0x10ea, 0x1641, 0x1317,
0x1591, 0x135d, 0x10c6, 0x114c, 0x0fcf, 0x0ffb, 0x0ff1, 0x0d60, 0x106e, 0x0dc5,
0x1067, 0x0e8b, 0x0fb9, 0x0dd0, 0x130c, 0x0f6d, 0x1330, 0x0ede, 0x1345, 0x0fc1,
0x11ad, 0x0fbc, 0x1199, 0x119f, 0x1105, 0x111c, 0x109f, 0x0f25, 0x10b5, 0x0e65,
0x1086, 0x0e03, 0x0f97, 0x0e33, 0x0fbc, 0x0eb0, 0x0f83, 0x0d96, 0x0fd6, 0x0d70,
0x0f06, 0x0c8e, 0x0faf, 0x0dbe, 0x11b2, 0x0e83, 0x0ff7, 0x0c88, 0x0dad, 0x0b9a,
0x0a73, 0x0974, 0x09ab, 0x09a4, 0x090c, 0x0898, 0x090e, 0x07cd, 0x0a52, 0x0922,
0x0a97, 0x08a4, 0x0876, 0x074a, 0x068d, 0x071f, 0x03bb, 0x064d, 0x02ec, 0x05af,
0x023d, 0x03ff, 0x03e0, 0x0501, 0x0598, 0x04af, 0x042a, 0x03a8, 0x03ef, 0x046a,
0x0240, 0x03cb, 0x03bd, 0x05ae, 0x04cd, 0x05d4, 0x06f7, 0x074b, 0x082b, 0x0883,
0x0620, 0x09d7, 0x04a6, 0x09ef, 0x01c3, 0x068e, 0x032e, 0x079a, 0x035b, 0x066c,
0x03ff, 0x06ca, 0x035c, 0x0623, 0x030e, 0x06c0, 0x03c4, 0x0796, 0x047c, 0x0716,
0x03a1, 0x0667, 0x0284, 0x06df, 0x03db, 0x08d2, 0x04ea, 0x094f, 0x050b, 0x0a16,
0x01f4, 0x08d1, 0x0146, 0x0983, 0x01cc, 0x08fe, 0x0024, 0x0837, 0xfdae, 0x0706,
0xfcdb, 0x059c, 0xfdd7, 0x054e, 0xfeb3, 0x059c, 0xfcc5, 0x04bd, 0xfb2a, 0x034d,
0xfa04, 0x020c, 0xf852, 0x00ea, 0xf775, 0xffec, 0xf52a, 0xfe1f, 0xf3ed, 0xfd5d,
0xf3f0, 0xfbdb, 0xf46c, 0xfb05, 0xf32c, 0xf95e, 0xf052, 0xf811, 0xf1ac, 0xf803,
0xf3cb, 0xf850, 0xf4ea, 0xf8e9, 0xf390, 0xf827, 0xefa7, 0xf647, 0xedcc, 0xf53c,
0xed37, 0xf44a, 0xedf0, 0xf35a, 0xee20, 0xf2c1, 0xedc1, 0xf273, 0xec6d, 0xf1ee,
0xeb42, 0xf163, 0xea9a, 0xf0a4, 0xeaa1, 0xf06b, 0xe862, 0xef51, 0xe6ed, 0xedf7,
0xe506, 0xecb0, 0xe45d, 0xec24, 0xe452, 0xec4c, 0xe3a2, 0xec36, 0xe63d, 0xec6a,
0xe6e7, 0xeb83, 0xe998, 0xecaa, 0xe842, 0xec26, 0xe9d3, 0xed9c, 0xe9d4, 0xedb7,
0xea04, 0xeebe, 0xe8f7, 0xeee1, 0xe37e, 0xec21, 0xe1e1, 0xea7e, 0xe009, 0xe70e,
0xe163, 0xe6c5, 0xe17f, 0xe715, 0xe14d, 0xe779, 0xdf51, 0xe656, 0xdd18, 0xe5d6,
0xdcd6, 0xe595, 0xdd51, 0xe560, 0xde0e, 0xe5d7, 0xddf4, 0xe68a, 0xdef0, 0xe92e,
0xdf84, 0xea55, 0xe1e5, 0xec91, 0xe2a0, 0xec51, 0xe3f8, 0xec0c, 0xe3bd, 0xeac6,
0xe3ed, 0xeb86, 0xe38d, 0xec66, 0xe14d, 0xeaf9, 0xe17e, 0xeb85, 0xdef7, 0xe96f,
0xdf0b, 0xe8d9, 0xdea9, 0xe6eb, 0xdf02, 0xe5be, 0xdfc8, 0xe4f5, 0xdef0, 0xe4d6,
0xde60, 0xe4e7, 0xdf06, 0xe431, 0xdf00, 0xe30c, 0xddf2, 0xe2b2, 0xdcee, 0xe28d,
0xdb70, 0xe129, 0xdab6, 0xe04a, 0xdbc7, 0xe0ae, 0xdc7d, 0xe0da, 0xdc1f, 0xdf9f,
0xdbc8, 0xde63, 0xdb10, 0xdc90, 0xdbfa, 0xde36, 0xdca9, 0xdefb, 0xdde0, 0xe064,
0xddba, 0xe035, 0xdbb9, 0xdec1, 0xdb0a, 0xde9c, 0xdd86, 0xdeba, 0xdd3c, 0xddcd,
0xdcfc, 0xdd33, 0xddc3, 0xdd88, 0xdd65, 0xdcfe, 0xdc97, 0xdc20, 0xdaf4, 0xd9e7,
0xdb75, 0xd927, 0xd9ad, 0xd824, 0xd7ee, 0xd7e0, 0xd792, 0xd6ec, 0xd859, 0xd70c,
0xd900, 0xd7e2, 0xd8b0, 0xd741, 0xd95a, 0xd6f9, 0xd881, 0xd702, 0xd8f6, 0xd808,
0xd8be, 0xd719, 0xd8c2, 0xd6c3, 0xd774, 0xd6ba, 0xd579, 0xd615, 0xd3a2, 0xd4e0,
0xd2a6, 0xd39b, 0xd278, 0xd34e, 0xcfa4, 0xd2a7, 0xce41, 0xd23c, 0xccae, 0xcfbd,
0xcd62, 0xcf1e, 0xcebe, 0xd001, 0xce42, 0xd01b, 0xccb0, 0xcfff, 0xcad3, 0xcf03,
0xc8e1, 0xce99, 0xc936, 0xcf48, 0xc9fc, 0xd077, 0xc9cb, 0xd0cc, 0xcaf2, 0xd19e,
0xcc03, 0xd109, 0xcbd8, 0xce9d, 0xcb53, 0xcd35, 0xcac5, 0xccec, 0xca3b, 0xce36,
0xca62, 0xcefa, 0xc8ee, 0xce31, 0xc917, 0xce4b, 0xcaca, 0xce7b, 0xcb2b, 0xcf51,
0xcb59, 0xcff1, 0xcb99, 0xd00d, 0xccf0, 0xd167, 0xccc7, 0xd126, 0xccf9, 0xd090,
0xceaa, 0xcfcd, 0xd0ba, 0xd0c3, 0xd19a, 0xd2fe, 0xd1a6, 0xd535, 0xd1b9, 0xd667,
0xd41a, 0xd7f0, 0xd8bd, 0xda95, 0xdaa1, 0xdc5b, 0xdd4e, 0xdefe, 0xdfbc, 0xe0bf,
0xe3ed, 0xe4e6, 0xe62c, 0xe7e1, 0xe97d, 0xeafb, 0xedca, 0xed56, 0xf031, 0xef12,
0xf1f3, 0xf0f6, 0xf154, 0xf1fd, 0xf336, 0xf46b, 0xf5ae, 0xf625, 0xf75b, 0xf829,
0xf94c, 0xf8fe, 0xfa98, 0xf942, 0xfb20, 0xfab4, 0xfaa8, 0xfbde, 0xfaea, 0xfc1f,
0xfc40, 0xfabc, 0xfd54, 0xfb64, 0xfc4c, 0xfc03, 0xfa48, 0xfc16, 0xfd6c, 0xfeb8,
0xfe22, 0xfca3, 0xfdf1, 0xfb0c, 0xfdc8, 0xfaed, 0xfd47, 0xfb6b, 0xfdf9, 0xfcca,
0xfe14, 0xfd2f, 0xffd4, 0xfdba, 0x0255, 0xfe0a, 0x038d, 0xfea8, 0x0286, 0xfe22,
0x0281, 0xfeb4, 0x0392, 0xff40, 0x0531, 0x000b, 0x0636, 0x0024, 0x0748, 0xffac,
0x07e5, 0x009a, 0x082c, 0x015c, 0x0846, 0x01e7, 0x0850, 0x0184, 0x08ca, 0x0123,
0x08fd, 0x017b, 0x0a56, 0x0299, 0x0adf, 0x03b8, 0x0c15, 0x0475, 0x0b21, 0x016a,
0x0ad7, 0x0148, 0x094e, 0x0071, 0x099e, 0x0094, 0x0a92, 0x012a, 0x0aaf, 0x0102,
0x0b2b, 0x022b, 0x0a8b, 0x0186, 0x0a64, 0x018c, 0x0b48, 0x0295, 0x0be0, 0x0390,
0x0aed, 0x0316, 0x0bc6, 0x0335, 0x0d05, 0x039b, 0x0e03, 0x0332, 0x0daf, 0x0392,
0x0f5a, 0x0607, 0x1050, 0x05b0, 0x10b9, 0x056e, 0x11d1, 0x0646, 0x142f, 0x08a3,
0x13ab, 0x091d, 0x11ae, 0x087e, 0x1073, 0x07cc, 0x0f6d, 0x0721, 0x10df, 0x07bd,
0x1106, 0x06ad, 0x1082, 0x06df, 0x107a, 0x07bb, 0x118a, 0x0836, 0x126e, 0x088c,
0x1110, 0x07ac, 0x0fca, 0x081d, 0x1184, 0x09b6, 0x1139, 0x08a7, 0x0fb3, 0x0777,
0x0f63, 0x0817, 0x1077, 0x0986, 0x12fa, 0x0b67, 0x11fe, 0x0a54, 0x13c6, 0x0be6,
0x14c0, 0x0d57, 0x1454, 0x0dc6, 0x1470, 0x0d6b, 0x1382, 0x0b6e, 0x139b, 0x0bb1,
0x1418, 0x0b81, 0x134a, 0x0b86, 0x140e, 0x0e56, 0x14e5, 0x0fbb, 0x148f, 0x0fef,
0x1588, 0x1040, 0x1339, 0x0f42, 0x129c, 0x0fbe, 0x126a, 0x0dd1, 0x13dd, 0x0e69,
0x1564, 0x0f82, 0x1543, 0x0fe7, 0x15b5, 0x10b8, 0x1580, 0x10df, 0x16b2, 0x1219,
0x176f, 0x127a, 0x17c6, 0x13f8, 0x17c5, 0x13c7, 0x1709, 0x13c5, 0x1710, 0x14eb,
0x171f, 0x155b, 0x16be, 0x14c2, 0x1611, 0x1430, 0x1585, 0x1468, 0x1559, 0x13e6,
0x16af, 0x1418, 0x1764, 0x14e4, 0x16a3, 0x152e, 0x174a, 0x1690, 0x17d8, 0x1682,
0x174a, 0x1575, 0x1682, 0x1590, 0x1756, 0x15e2, 0x1825, 0x1676, 0x1842, 0x16bc,
0x1881, 0x170e, 0x1847, 0x1710, 0x1767, 0x1667, 0x15aa, 0x1517, 0x1599, 0x1504,
0x15f7, 0x14bf, 0x163c, 0x150c, 0x15c5, 0x1450, 0x16ad, 0x1532, 0x1782, 0x1592,
0x172c, 0x1427, 0x1760, 0x155a, 0x16b1, 0x1656, 0x17a8, 0x18d2, 0x17c1, 0x1788,
0x1852, 0x1673, 0x17d9, 0x169a, 0x1a1a, 0x180e, 0x1a8e, 0x1820, 0x1a52, 0x17ab,
0x19b3, 0x177b, 0x1767, 0x164c, 0x1782, 0x15aa, 0x160c, 0x132d, 0x1653, 0x13d4,
0x1513, 0x1361, 0x1503, 0x12f0, 0x15c8, 0x129c, 0x1582, 0x1350, 0x175b, 0x156d,
0x183a, 0x14f5, 0x186d, 0x158e, 0x18a3, 0x1686, 0x1762, 0x156f, 0x16cc, 0x14c7,
0x164a, 0x153e, 0x1629, 0x1601, 0x1703, 0x16ea, 0x183e, 0x17d8, 0x1914, 0x17c0,
0x183f, 0x16eb, 0x1785, 0x1702, 0x1828, 0x17a1, 0x160a, 0x171e, 0x153b, 0x178f,
0x142a, 0x15e2, 0x1486, 0x1548, 0x150e, 0x1455, 0x13c8, 0x141f, 0x15dc, 0x160a,
0x16b9, 0x16e2, 0x16ed, 0x1897, 0x1636, 0x17ac, 0x1468, 0x15db, 0x1448, 0x156f,
0x1549, 0x1609, 0x1569, 0x1629, 0x163d, 0x1757, 0x1416, 0x160d, 0x1313, 0x164f,
0x133e, 0x1683, 0x1352, 0x1575, 0x132a, 0x1445, 0x1015, 0x11a0, 0x0e6e, 0x11d9,
0x0c77, 0x0ffa, 0x0bf7, 0x0e8a, 0x0c71, 0x0dcf, 0x0c22, 0x0d77, 0x0b51, 0x0c94,
0x09a5, 0x0b56, 0x0a78, 0x0d17, 0x09e1, 0x0cf8, 0x0810, 0x0c27, 0x069a, 0x0aaa,
0x037b, 0x0917, 0x01d2, 0x08eb, 0x00ca, 0x07cc, 0x022c, 0x07f6, 0x02ef, 0x0707,
0x0166, 0x0623, 0x00b4, 0x065d, 0x0017, 0x062b, 0x00e0, 0x071e, 0xffa5, 0x0620,
0xffad, 0x06cb, 0x0024, 0x076b, 0xff57, 0x06d0, 0xfe8b, 0x060e, 0xfd4c, 0x049a,
0xfc84, 0x03f0, 0xfba8, 0x03ec, 0xfbbd, 0x040f, 0xfd6d, 0x056d, 0xfd20, 0x058a,
0xfbaf, 0x04ab, 0xfb6f, 0x0471, 0xfa2c, 0x026f, 0xf8cf, 0x0157, 0xf964, 0x00de,
0xf94b, 0x00c6, 0xf88d, 0x0062, 0xf806, 0xff41, 0xf7a5, 0xfec3, 0xf8c2, 0xff99,
0xf838, 0x00f0, 0xf63e, 0xffdb, 0xf564, 0xfecc, 0xf505, 0xfdd5, 0xf3f7, 0xfcce,
0xf3d5, 0xfc55, 0xf2fd, 0xfb53, 0xf2b0, 0xfb31, 0xf1da, 0xf9e2, 0xf1c4, 0xf95b,
0xf25c, 0xf988, 0xf368, 0xf9f4, 0xf406, 0xf971, 0xf347, 0xf82b, 0xf333, 0xf849,
0xf2fa, 0xf8a0, 0xf359, 0xf900, 0xf44b, 0xf978, 0xf653, 0xf925, 0xf760, 0xf8e1,
0xf855, 0xf852, 0xf818, 0xf79e, 0xf79c, 0xf7b1, 0xf7aa, 0xf822, 0xf7fc, 0xf990,
0xf891, 0xfa38, 0xf776, 0xfa3e, 0xf743, 0xfa0f, 0xf665, 0xf94d, 0xf91d, 0xfaf5,
0xfa19, 0xfa21, 0xf9ab, 0xf9a9, 0xf98e, 0xf9a0, 0xfa70, 0xfad5, 0xfa82, 0xfb53,
0xfabe, 0xfa9a, 0xfd27, 0xfb06, 0xfcae, 0xfb00, 0xfedd, 0xfe2e, 0xff01, 0xfee9,
0x01c8, 0x020f, 0x0341, 0x02a3, 0x0414, 0x03d3, 0x0457, 0x04c7, 0x02ec, 0x0382,
0x0230, 0x02eb, 0xff96, 0x0142, 0xffa9, 0x0206, 0xff8a, 0x0128, 0x003c, 0x0111,
0xff09, 0xff2b, 0xfd25, 0xfd9d, 0xfd43, 0xfd6e, 0xfeb9, 0xff05, 0x0058, 0x0086,
0x0075, 0x0014, 0x01d8, 0x0124, 0x01ed, 0x0127, 0x02d6, 0x0329, 0x0389, 0x041c,
0x03e0, 0x04df, 0x032a, 0x041d, 0x01cc, 0x02e4, 0x0291, 0x0319, 0x005d, 0x00e7,
0x0124, 0x00dd, 0xff01, 0xfe87, 0xfe26, 0xfe8e, 0xfed2, 0xfda4, 0xfe49, 0xfcfb,
0xff45, 0xfdd1, 0xffeb, 0xfe9b, 0x0289, 0x0011, 0x0133, 0xff24, 0x00dd, 0x00a2,
0x025c, 0x023c, 0x017e, 0x022e, 0x001e, 0x0114, 0xff6d, 0xfffb, 0xff55, 0xfff4,
0x0176, 0x00fd, 0x0197, 0x00fb, 0xff9d, 0x00b0, 0xfed6, 0xffd2, 0xfc7b, 0xfdcf,
0xfc6b, 0xfe29, 0xfbc8, 0xfd7f, 0xfcb7, 0xfd44, 0xfd65, 0xfc3f, 0xfd00, 0xfc10,
0xfd7a, 0xfcdb, 0xfb3a, 0xfbcc, 0xfad6, 0xfc7c, 0xfc19, 0xfde4, 0xfcd2, 0xfe41,
0xfcfd, 0xfddf, 0xfc3e, 0xfcb9, 0xfb4e, 0xfc43, 0xfade, 0xfbe0, 0xfb00, 0xfba5,
0xfb48, 0xfc6d, 0xf9f7, 0xfbf3, 0xf977, 0xfc69, 0xf9cc, 0xfcb6, 0xf9f3, 0xfcc0,
0xfa40, 0xfc8f, 0xfaf1, 0xfc67, 0xfbac, 0xfbe3, 0xf938, 0xf9a0, 0xf732, 0xf8ed,
0xf6e3, 0xf79e, 0xf85b, 0xf807, 0xf710, 0xf76b, 0xf54b, 0xf746, 0xf501, 0xf782,
0xf635, 0xf728, 0xf799, 0xf65a, 0xf75f, 0xf5d8, 0xf927, 0xf783, 0xf8c2, 0xf723,
0xf91e, 0xf7c4, 0xf93b, 0xf6f2, 0xf90a, 0xf6cc, 0xf936, 0xf6dd, 0xf73f, 0xf681,
0xf815, 0xf7f1, 0xf7e9, 0xf734, 0xf7e0, 0xf6d6, 0xf84b, 0xf65f, 0xf876, 0xf538,
0xf8ba, 0xf537, 0xf905, 0xf5f1, 0xfa10, 0xf702, 0xfa9c, 0xf71a, 0xfb20, 0xf749,
0xfb3f, 0xf765, 0xfbab, 0xf7bf, 0xfc6c, 0xf903, 0xfe43, 0xfab7, 0xfecc, 0xfb06,
0x0035, 0xfbc4, 0x00d2, 0xfb95, 0x02ba, 0xfd11, 0x02f6, 0xfd87, 0x0207, 0xfce5,
0x0225, 0xfe2c, 0x0067, 0xfd49, 0x0154, 0xfdf6, 0x02b2, 0xfefb, 0x0504, 0x0124,
0x05c8, 0x0173, 0x0670, 0x016e, 0x0718, 0x00a8, 0x0899, 0x00e9, 0x0a43, 0x021b,
0x0afc, 0x03be, 0x0cc8, 0x0653, 0x0ca9, 0x0701, 0x0ef2, 0x09f8, 0x10c8, 0x0af3,
0x126c, 0x0c75, 0x1443, 0x0e2c, 0x1466, 0x0f52, 0x145f, 0x0f4d, 0x14b6, 0x0dd7,
0x160a, 0x0e7a, 0x17a5, 0x1094, 0x1897, 0x11b8, 0x1871, 0x124e, 0x189f, 0x12cf,
0x1841, 0x1271, 0x196f, 0x138a, 0x1b0e, 0x131e, 0x1d0c, 0x13c1, 0x1e44, 0x14bf,
0x1dcf, 0x149d, 0x1c0a, 0x1398, 0x1ad5, 0x13c7, 0x1b5a, 0x150a, 0x1d11, 0x15da,
0x1ebd, 0x1684, 0x1f23, 0x16f2, 0x1f15, 0x185e, 0x1e07, 0x1893, 0x2026, 0x1ab4,
0x2295, 0x1c0f, 0x268c, 0x1e13, 0x2665, 0x1de8, 0x22f2, 0x1cb6, 0x20fd, 0x1b83,
0x1fc1, 0x1a80, 0x204a, 0x1ba9, 0x1f7f, 0x1bf8, 0x1fe1, 0x1d1f, 0x1fc5, 0x1c53,
0x1f59, 0x1b8c, 0x2083, 0x1c2b, 0x2062, 0x1bd0, 0x1e4d, 0x19d7, 0x1d90, 0x19cc,
0x1c11, 0x19c9, 0x1c87, 0x1a9e, 0x1cfd, 0x1a64, 0x1ee9, 0x1c11, 0x1e24, 0x1c8f,
0x1b8f, 0x1aa0, 0x1c3c, 0x1b13, 0x1d96, 0x1c64, 0x1f8e, 0x1e14, 0x1f64, 0x1d66,
0x1ea0, 0x1c1b, 0x1ddd, 0x1b54, 0x1cd2, 0x1a40, 0x1c22, 0x19a0, 0x1b99, 0x190e,
0x1c4a, 0x1988, 0x1c77, 0x1a56, 0x1af7, 0x1994, 0x1b5c, 0x18b0, 0x1cb8, 0x18a5,
0x1e03, 0x1a59, 0x1d6f, 0x1a1c, 0x1d2f, 0x19d3, 0x1c25, 0x1913, 0x1c6e, 0x18c6,
0x1c98, 0x1892, 0x1c11, 0x189c, 0x1b78, 0x1881, 0x1abf, 0x1809, 0x19ef, 0x17a0,
0x1957, 0x167d, 0x1987, 0x150d, 0x184d, 0x13b9, 0x181d, 0x13d3, 0x1846, 0x13a6,
0x185a, 0x13f6, 0x1887, 0x142f, 0x1769, 0x12f0, 0x1775, 0x1331, 0x181e, 0x13d2,
0x1723, 0x13f4, 0x15ba, 0x135c, 0x1666, 0x12a7, 0x1639, 0x115d, 0x1356, 0x0f71,
0x1185, 0x0f52, 0x114a, 0x0fc5, 0x121c, 0x0fb0, 0x1136, 0x0e7d, 0x1034, 0x0d5a,
0x10e7, 0x0c63, 0x10c2, 0x0c97, 0x0f82, 0x0cfe, 0x0f5f, 0x0ce6, 0x1101, 0x0e3e,
0x10a1, 0x0d82, 0x0f0e, 0x0c21, 0x0db9, 0x0b53, 0x0c3a, 0x0a86, 0x0c6f, 0x0b32,
0x0bdf, 0x0a35, 0x0b42, 0x08f2, 0x0ac1, 0x0797, 0x09af, 0x078d, 0x095c, 0x07d7,
0x0a0a, 0x0886, 0x09be, 0x086f, 0x0967, 0x0814, 0x064f, 0x068f, 0x03e1, 0x04a8,
0x03dc, 0x03a8, 0x0501, 0x0414, 0x05de, 0x0455, 0x045d, 0x03bc, 0x0336, 0x04da,
0x02a4, 0x0514, 0x029d, 0x0575, 0x02f9, 0x05ef, 0x0379, 0x069d, 0x0357, 0x05f3,
0x036e, 0x05ef, 0x0181, 0x05f7, 0xffeb, 0x0632, 0x0008, 0x05ec, 0x0143, 0x05ab,
0x024a, 0x0690, 0x02e5, 0x07fe, 0x014e, 0x077f, 0x0031, 0x0677, 0x000d, 0x0615,
0x0187, 0x071d, 0x031a, 0x07c6, 0x0208, 0x0671, 0x0081, 0x056a, 0xfec6, 0x03f6,
0xfef3, 0x045d, 0xfee6, 0x0422, 0xfdd3, 0x0369, 0xfe4d, 0x045e, 0xfd72, 0x041f,
0xfd3d, 0x0468, 0xfd4c, 0x039f, 0xfd07, 0x0280, 0xfbfe, 0x017f, 0xf9d9, 0xffc9,
0xf90e, 0xffae, 0xf808, 0xff13, 0xf7f0, 0xfe5d, 0xf7b4, 0xfe84, 0xf5c3, 0xfda7,
0xf21e, 0xfae8, 0xf142, 0xfa10, 0xf0d3, 0xf93b, 0xefee, 0xf810, 0xef7a, 0xf6f3,
0xeeee, 0xf5ae, 0xee1d, 0xf5a0, 0xee03, 0xf607, 0xece6, 0xf50a, 0xeb32, 0xf3ce,
0xeb5f, 0xf314, 0xeb26, 0xf24f, 0xeb2f, 0xf26e, 0xeb6e, 0xf26a, 0xeb6a, 0xf1de,
0xea49, 0xf087, 0xe88a, 0xeed8, 0xe7c1, 0xee85, 0xe657, 0xedbe, 0xe551, 0xec8d,
0xe46d, 0xead8, 0xe43d, 0xea47, 0xe37b, 0xea97, 0xe2c7, 0xea85, 0xe20a, 0xe9fd,
0xe054, 0xe918, 0xdf4b, 0xe865, 0xdf34, 0xe7ee, 0xe08f, 0xe88b, 0xe0cf, 0xe7d2,
0xe13d, 0xe77f, 0xe00d, 0xe6a0, 0xdf59, 0xe657, 0xde02, 0xe59d, 0xdd27, 0xe610,
0xdc0d, 0xe577, 0xd975, 0xe2ae, 0xd8e4, 0xe1b1, 0xd82b, 0xe165, 0xd93c, 0xe17f,
0xd946, 0xe0ac, 0xd852, 0xe0dc, 0xd924, 0xe280, 0xd963, 0xe26a, 0xdaa6, 0xe2c0,
0xd930, 0xe24c, 0xd8af, 0xe3fd, 0xd8e6, 0xe464, 0xd823, 0xe379, 0xd8c7, 0xe344,
0xd7d1, 0xe2ea, 0xd74c, 0xe293, 0xd89b, 0xe2e1, 0xd94b, 0xe3e7, 0xd9bd, 0xe4ab,
0xd8da, 0xe3eb, 0xd8d9, 0xe316, 0xd944, 0xe361, 0xda5c, 0xe3e5, 0xdb3d, 0xe446,
0xda73, 0xe3b0, 0xda45, 0xe329, 0xd90e, 0xe300, 0xd828, 0xe363, 0xd85a, 0xe205,
0xd95e, 0xe147, 0xd8ec, 0xe005, 0xd802, 0xdeda, 0xd818, 0xdf0f, 0xd801, 0xdefd,
0xd729, 0xde54, 0xd64a, 0xddd3, 0xd3ec, 0xdc8e, 0xd551, 0xdd33, 0xd525, 0xdbcc,
0xd43b, 0xd9c8, 0xd4da, 0xd994, 0xd4ba, 0xd9d5, 0xd387, 0xd8b0, 0xd1cb, 0xd74e,
0xd3a6, 0xd6d4, 0xd42c, 0xd569, 0xd635, 0xd59e, 0xd6ef, 0xd671, 0xd75d, 0xd867,
0xd6e6, 0xd833, 0xd526, 0xd7b0, 0xd49a, 0xd699, 0xd39e, 0xd4fc, 0xd2ba, 0xd398,
0xd262, 0xd340, 0xd262, 0xd374, 0xd2ee, 0xd467, 0xd428, 0xd4e4, 0xd355, 0xd373,
0xd25f, 0xd2e0, 0xd199, 0xd1f1, 0xd0e9, 0xd178, 0xcfec, 0xd034, 0xd06d, 0xcfc5,
0xd120, 0xcebe, 0xcfba, 0xcd80, 0xcfa2, 0xcd97, 0xcf50, 0xcdc6, 0xd04e, 0xcfee,
0xd04e, 0xcfd8, 0xd0cd, 0xd0ef, 0xd0fa, 0xd11e, 0xd0c0, 0xd072, 0xd070, 0xd034,
0xcf93, 0xcf9a, 0xceb7, 0xcf75, 0xcf45, 0xcff3, 0xcf4a, 0xcfb1, 0xcee9, 0xcece,
0xcf0f, 0xcec2, 0xcef7, 0xceee, 0xcf17, 0xcfbc, 0xce1f, 0xcf2b, 0xce8a, 0xcf02,
0xcde4, 0xcdc0, 0xcdea, 0xcdbd, 0xce66, 0xce78, 0xce5f, 0xceb0, 0xce8e, 0xcf17,
0xceff, 0xcee0, 0xcf8b, 0xcffd, 0xcff4, 0xd0db, 0xd0d8, 0xd130, 0xd208, 0xd246,
0xd299, 0xd35f, 0xd314, 0xd43a, 0xd135, 0xd370, 0xd186, 0xd43e, 0xd1e1, 0xd45b,
0xd2e5, 0xd4ee, 0xd4cb, 0xd534, 0xd632, 0xd608, 0xd8a8, 0xd87c, 0xd921, 0xd9a6,
0xda06, 0xdc48, 0xda55, 0xddfb, 0xdbf9, 0xdfbd, 0xde26, 0xe081, 0xde7c, 0xdfc9,
0xdf3c, 0xe0d4, 0xdfb2, 0xe10c, 0xe1ae, 0xe210, 0xe2fa, 0xe332, 0xe43d, 0xe52d,
0xe5d1, 0xe761, 0xe68f, 0xe8fb, 0xe8af, 0xeac9, 0xeb1f, 0xeb78, 0xeeb3, 0xedd1,
0xef77, 0xef66, 0xefa2, 0xf183, 0xf106, 0xf30d, 0xf2e0, 0xf328, 0xf4aa, 0xf347,
0xf5c9, 0xf349, 0xf7af, 0xf4fd, 0xf80b, 0xf653, 0xf796, 0xf70e, 0xf7c4, 0xf818,
0xfab6, 0xf9bf, 0xfc9b, 0xf9aa, 0xfc8e, 0xf8c2, 0xfcbc, 0xf89f, 0xfd64, 0xf876,
0xfe55, 0xf85f, 0xfe29, 0xf90c, 0xff3c, 0xfacc, 0x00c8, 0xfc14, 0x022c, 0xfd53,
0x0327, 0xfd89, 0x0545, 0xfe16, 0x05b4, 0xfe20, 0x060e, 0xff2d, 0x0665, 0xff66,
0x0659, 0xff7d, 0x0746, 0xff8c, 0x07db, 0xfec7, 0x08eb, 0xff6e, 0x08ae, 0xffb9,
0x07ee, 0xff46, 0x075c, 0xfead, 0x0800, 0xfee8, 0x090e, 0xff5d, 0x09ba, 0x0041,
0x0995, 0x0052, 0x0a41, 0x003b, 0x0b68, 0x0015, 0x0c42, 0x0009, 0x0d6c, 0x017a,
0x0d74, 0x031d, 0x0e54, 0x04b8, 0x0e9c, 0x0515, 0x0f14, 0x05bd, 0x1022, 0x05eb,
0x10c5, 0x0698, 0x116a, 0x0782, 0x11cb, 0x07e4, 0x1233, 0x0826, 0x12b8, 0x0876,
0x125a, 0x0808, 0x1137, 0x0789, 0x1199, 0x07c2, 0x1207, 0x07b8, 0x1237, 0x086d,
0x113f, 0x07df, 0x1166, 0x07e4, 0x12f5, 0x08c9, 0x1387, 0x0948, 0x13b1, 0x0992,
0x1404, 0x0956, 0x1302, 0x087d, 0x1207, 0x0883, 0x11ec, 0x087d, 0x13d1, 0x0a19,
0x13b0, 0x0a54, 0x1217, 0x09aa, 0x10d7, 0x08d0, 0x117b, 0x0944, 0x1451, 0x0ae9,
0x15ec, 0x0b81, 0x1686, 0x0bca, 0x1675, 0x0d2d, 0x1647, 0x0e0d, 0x1606, 0x0e68,
0x171d, 0x0f58, 0x187d, 0x1093, 0x1818, 0x10ca, 0x16e0, 0x10b1, 0x1807, 0x1289,
0x1927, 0x133f, 0x1a64, 0x1418, 0x1ac6, 0x13f6, 0x1968, 0x1407, 0x186d, 0x145e,
0x17bd, 0x13ac, 0x18a9, 0x1438, 0x1a30, 0x1612, 0x19a6, 0x165b, 0x1930, 0x159b,
0x1992, 0x151c, 0x19c4, 0x16b7, 0x1a63, 0x17b2, 0x1a2e, 0x166c, 0x1a02, 0x15fa,
0x1a4c, 0x1617, 0x19eb, 0x16cd, 0x1a8e, 0x16a9, 0x1ade, 0x16ab, 0x1c87, 0x18ea,
0x1c49, 0x19b2, 0x1bc4, 0x1a55, 0x1bf6, 0x1a98, 0x1c84, 0x1b85, 0x1d2e, 0x1bd1,
0x1cc1, 0x1b9b, 0x1c8f, 0x1bb2, 0x1b18, 0x1b76, 0x1b19, 0x1b9a, 0x1b5a, 0x1a75,
0x1b30, 0x1a48, 0x1b1e, 0x1aaf, 0x1af1, 0x1afa, 0x1bcf, 0x1be4, 0x1c42, 0x1c33,
0x1cfc, 0x1d06, 0x1d68, 0x1d66, 0x1d91, 0x1de2, 0x1d4c, 0x1d70, 0x1b6f, 0x1b69,
0x1b14, 0x1b52, 0x1a8f, 0x1b44, 0x1b19, 0x1c85, 0x1a62, 0x1c54, 0x1a38, 0x1c2c,
0x1942, 0x1b34, 0x18aa, 0x19e3, 0x1865, 0x1935, 0x179b, 0x190a, 0x19c7, 0x19df,
0x1a79, 0x19e7, 0x1a48, 0x19fd, 0x19d4, 0x18ea, 0x18b5, 0x1752, 0x1890, 0x17d8,
0x1785, 0x188d, 0x1726, 0x18e7, 0x1713, 0x1868, 0x1846, 0x1812, 0x18eb, 0x1833,
0x1788, 0x16ff, 0x18d9, 0x17ff, 0x1a20, 0x1892, 0x19b2, 0x18b7, 0x18d7, 0x18c5,
0x18a0, 0x1857, 0x1850, 0x17b7, 0x1a83, 0x18da, 0x1b67, 0x19a9, 0x1c17, 0x19fd,
0x1a88, 0x1846, 0x1993, 0x177e, 0x19d6, 0x17b9, 0x1961, 0x1772, 0x18c3, 0x1780,
0x171a, 0x1760, 0x16d8, 0x17b9, 0x1547, 0x161e, 0x159b, 0x159d, 0x169e, 0x1596,
0x15d3, 0x15c6, 0x166a, 0x1659, 0x15b6, 0x15ac, 0x1557, 0x167b, 0x1608, 0x1717,
0x15cb, 0x1656, 0x151d, 0x15d3, 0x130f, 0x148b, 0x12de, 0x1496, 0x132d, 0x1418,
0x123c, 0x1343, 0x136b, 0x14d2, 0x1324, 0x1491, 0x13cf, 0x159f, 0x14a2, 0x162a,
0x13f7, 0x155b, 0x11d3, 0x13bd, 0x0e20, 0x1198, 0x0df4, 0x11ac, 0x0c68, 0x1097,
0x0c50, 0x1091, 0x0ba9, 0x1027, 0x0b17, 0x0fbd, 0x0a18, 0x0ec3, 0x0820, 0x0d95,
0x0766, 0x0cf6, 0x06fa, 0x0c20, 0x0716, 0x0bea, 0x06bb, 0x0b9e, 0x05f9, 0x0b39,
0x04e1, 0x0b50, 0x0353, 0x0a31, 0x037d, 0x098c, 0x027b, 0x0825, 0x0148, 0x07c7,
0x0048, 0x07dc, 0x004e, 0x08d7, 0x01c1, 0x098c, 0x0166, 0x07f4, 0x00ab, 0x06d9,
0xfec4, 0x0624, 0xfe64, 0x0775, 0xfdbf, 0x06f5, 0xfe37, 0x06f6, 0xfe88, 0x076a,
0xfe6c, 0x06d9, 0xfdfd, 0x05b7, 0xfd96, 0x05af, 0xfc96, 0x054f, 0xfc7f, 0x04d8,
0xfd84, 0x04ba, 0xfc0b, 0x0426, 0xfaf7, 0x03ee, 0xfab9, 0x0345, 0xf997, 0x0270,
0xf947, 0x0220, 0xfa19, 0x0270, 0xf989, 0x01e8, 0xf929, 0x0199, 0xf8e2, 0x0127,
0xf831, 0x0061, 0xf6d7, 0xffc9, 0xf5ab, 0xff24, 0xf4b0, 0xfdfe, 0xf57c, 0xfe88,
0xf643, 0xfdd1, 0xf5f3, 0xfce1, 0xf4cb, 0xfd36, 0xf561, 0xfdc7, 0xf7fe, 0xfea8,
0xf7f5, 0xfe03, 0xf72f, 0xfcc4, 0xf73e, 0xfc5e, 0xf7b6, 0xfd62, 0xf74f, 0xfd42,
0xf600, 0xfc69, 0xf635, 0xfce2, 0xf67a, 0xfcaa, 0xf6f3, 0xfc72, 0xf5db, 0xfc48,
0xf587, 0xfc68, 0xf846, 0xfd35, 0xfa51, 0xfcd5, 0xfadd, 0xfd3e, 0xfa28, 0xfd26,
0xfafd, 0xfdc2, 0xfc71, 0xfe5f, 0xfd74, 0xfe14, 0xfd2c, 0xfe84, 0xfc50, 0xfe0e,
0xfc34, 0xfdcb, 0xfa8c, 0xfba8, 0xfa61, 0xfb02, 0xf9da, 0xfa84, 0xf9c3, 0xfabe,
0xfa33, 0xfac8, 0xfbac, 0xfb89, 0xfc96, 0xfc7c, 0xfbb6, 0xfbdb, 0xfc9c, 0xfc7a,
0xfcfd, 0xfd2c, 0xfd91, 0xfe9d, 0xfdb8, 0xfebb, 0xfee2, 0xff36, 0xfe98, 0xfe94,
0xfe3f, 0xffb1, 0xfeea, 0x000c, 0xfeb3, 0xff53, 0xfd8c, 0xfe7b, 0xfd21, 0xfdd2,
0xfe23, 0xfef3, 0xfe13, 0xfee7, 0xfdc4, 0xff3f, 0xfcbb, 0xfea3, 0xfd64, 0xfe6d,
0xfce2, 0xfd3e, 0xfc1f, 0xfc2c, 0xfbaf, 0xfbfe, 0xfbce, 0xfcdf, 0xfe59, 0xfe30,
0x0008, 0xfea1, 0x0037, 0xff2d, 0xfe89, 0xfe72, 0xfc6d, 0xfcac, 0xfd99, 0xfd67,
0xfd0b, 0xfcd3, 0xfc30, 0xfcf6, 0xfb65, 0xfc4f, 0xfcbb, 0xfc1e, 0xfda6, 0xfc36,
0xfc28, 0xfbf2, 0xfce8, 0xfd5e, 0xfd03, 0xfdb1, 0xfe5e, 0xff13, 0xff37, 0xff38,
0x00ab, 0x003f, 0x01f2, 0x00b3, 0x01bd, 0x0176, 0x00c8, 0x01ad, 0xff71, 0x0090,
0x0042, 0x0073, 0x018d, 0xffda, 0x01e8, 0x0082, 0x032e, 0x0205, 0x0400, 0x029d,
0x050d, 0x0398, 0x036f, 0x033d, 0x0269, 0x030b, 0x024b, 0x0262, 0x018d, 0x00bb,
0x0113, 0x0038, 0xff41, 0xff57, 0xfec2, 0xff45, 0xfee0, 0xfef5, 0xff9e, 0xff9b,
0x001a, 0x009a, 0x00b2, 0x011b, 0xffa1, 0x008e, 0xff41, 0xfff2, 0xfdb4, 0xff4f,
0xfd3e, 0xff41, 0xfd45, 0xfeb8, 0xfdac, 0xff4d, 0xfe16, 0xff14, 0xfdc2, 0xfdaa,
0xfe38, 0xfddf, 0xfd66, 0xfda4, 0xfd2b, 0xfdeb, 0xfdc4, 0xfe3f, 0xfee4, 0xfe05,
0xfecc, 0xfdb1, 0xfde3, 0xfd98, 0xfd32, 0xfde1, 0xfee8, 0xff5f, 0xfef2, 0xfea1,
0xff4e, 0xff7a, 0xff61, 0xffd3, 0x000a, 0x006b, 0x0136, 0x010f, 0x01f7, 0x00f2,
0x01fc, 0xfffc, 0x0143, 0xfe4f, 0x019f, 0xfec5, 0x0122, 0xfe69, 0x0059, 0xfe16,
0xff3b, 0xfc3e, 0xff8c, 0xfc3d, 0xffdd, 0xfc90, 0x007c, 0xfdaa, 0x02c8, 0xff83,
0x0343, 0xff7f, 0x0465, 0x009b, 0x0542, 0x004d, 0x055d, 0x0035, 0x03ee, 0x004d,
0x0321, 0x0146, 0x03c9, 0x0144, 0x04d6, 0x012a, 0x05a5, 0x0118, 0x04f4, 0x00ce,
0x05c3, 0x01d2, 0x0610, 0x0163, 0x06c2, 0x017f, 0x0774, 0x0243, 0x08db, 0x02f3,
0x0943, 0x0340, 0x0955, 0x0409, 0x088c, 0x03cd, 0x08ff, 0x0400, 0x090f, 0x0204,
0x08f1, 0x0244, 0x09a9, 0x035f, 0x0a1c, 0x0394, 0x0c50, 0x0539, 0x0d6d, 0x05ce,
0x0ddb, 0x06e5, 0x0cc2, 0x0646, 0x0daf, 0x06d1, 0x0f35, 0x07a6, 0x1003, 0x0761,
0x0fb9, 0x06f8, 0x0ff5, 0x07c0, 0x1096, 0x087a, 0x1188, 0x08fa, 0x11b2, 0x07d2,
0x1254, 0x080a, 0x12db, 0x0948, 0x1386, 0x0a55, 0x13c1, 0x0a69, 0x12f2, 0x09d8,
0x1321, 0x0afb, 0x1225, 0x0ac1, 0x125a, 0x0ae2, 0x1201, 0x09e7, 0x1329, 0x0ad4,
0x143d, 0x0bd9, 0x1442, 0x0b90, 0x1452, 0x0bd1, 0x14d9, 0x0c61, 0x146f, 0x0c24,
0x13f0, 0x0bca, 0x13e1, 0x0b1e, 0x1437, 0x0ba4, 0x1645, 0x0e5a, 0x166e, 0x0ecd,
0x16c6, 0x0f35, 0x16bc, 0x0f7a, 0x1746, 0x102c, 0x1757, 0x0fc7, 0x1796, 0x0fde,
0x1835, 0x1103, 0x1831, 0x1209, 0x16d0, 0x110d, 0x14cb, 0x0fc3, 0x1602, 0x10ad,
0x179d, 0x10d0, 0x18b9, 0x10c1, 0x1835, 0x104f, 0x1723, 0x1122, 0x16f2, 0x123a,
0x16f1, 0x12f3, 0x162d, 0x129f, 0x14cf, 0x1124, 0x1460, 0x1031, 0x14bd, 0x0fe6,
0x1528, 0x1011, 0x141a, 0x0feb, 0x141b, 0x1008, 0x14a7, 0x10ab, 0x1571, 0x11ba,
0x14be, 0x11b8, 0x1396, 0x11de, 0x1394, 0x116e, 0x1404, 0x0faa, 0x146b, 0x0f6f,
0x138e, 0x0f9e, 0x1332, 0x103c, 0x1328, 0x1020, 0x12f8, 0x0f9d, 0x1291, 0x0f87,
0x12b5, 0x0f7d, 0x1278, 0x0fbd, 0x11a7, 0x0fdc, 0x10c3, 0x0f72, 0x118a, 0x0f6e,
0x119a, 0x0f59, 0x1100, 0x0ee4, 0x0f2f, 0x0d4c, 0x0e20, 0x0c4a, 0x0e77, 0x0b9a,
0x0ec5, 0x0b72, 0x0f08, 0x0b4a, 0x0e8e, 0x0adc, 0x0d42, 0x09b6, 0x0c16, 0x09c9,
0x0d0d, 0x0b26, 0x0dd4, 0x0b48, 0x0f03, 0x0b35, 0x0f2e, 0x0ac5, 0x0eae, 0x0b09,
0x0ce6, 0x0ab5, 0x0cd3, 0x0b43, 0x0c23, 0x0b22, 0x0bb8, 0x0aea, 0x0b65, 0x096e,
0x0a7f, 0x091a, 0x097d, 0x0992, 0x07ae, 0x088a, 0x0760, 0x071d, 0x06a5, 0x0642,
0x0676, 0x06d9, 0x059a, 0x0646, 0x0503, 0x05f2, 0x04f7, 0x05ff, 0x05a3, 0x066a,
0x0698, 0x0771, 0x068d, 0x06c3, 0x05e3, 0x0648, 0x04e6, 0x05e9, 0x04ec, 0x0708,
0x046b, 0x0757, 0x041a, 0x06ee, 0x03c2, 0x05e0, 0x0276, 0x041a, 0x019e, 0x03fe,
0xff47, 0x01b4, 0xfddb, 0x0105, 0xfe25, 0x009d, 0xff74, 0x012a, 0x006c, 0x0236,
0xff3c, 0x0287, 0xfe32, 0x020a, 0xfe81, 0x0129, 0xfebb, 0x00e3, 0xfd96, 0x0157,
0xfb58, 0x00f6, 0xfa3d, 0x0052, 0xfae3, 0x009c, 0xfac4, 0x00c6, 0xfb27, 0x01cb,
0xfb8f, 0x0204, 0xfb2e, 0x0216, 0xfb2a, 0x0246, 0xfa63, 0x0139, 0xfa78, 0x00e9,
0xfa1a, 0x0187, 0xf951, 0x01a8, 0xf8af, 0x0184, 0xf922, 0x016d, 0xf94d, 0x00b8,
0xf949, 0x000c, 0xf7dc, 0xfef5, 0xf71b, 0xfe96, 0xf744, 0xfe6b, 0xf7a3, 0xfe71,
0xf74c, 0xfdef, 0xf678, 0xfcfc, 0xf697, 0xfc42, 0xf782, 0xfca7, 0xf866, 0xfd12,
0xf789, 0xfc9b, 0xf8ee, 0xfd36, 0xf907, 0xfd1f, 0xf9f4, 0xfddc, 0xf8e8, 0xfcb5,
0xf836, 0xfcd1, 0xf775, 0xfcba, 0xf631, 0xfc27, 0xf565, 0xfac2, 0xf3fa, 0xf93b,
0xf3a3, 0xf8f9, 0xf2bd, 0xf822, 0xf26d, 0xf7ee, 0xf24b, 0xf733, 0xf284, 0xf6df,
0xf278, 0xf7c6, 0xf201, 0xf761, 0xf131, 0xf68b, 0xf1b5, 0xf6a2, 0xf028, 0xf5a5,
0xef2b, 0xf507, 0xee20, 0xf350, 0xee5c, 0xf387, 0xee41, 0xf309, 0xee1d, 0xf290,
0xee83, 0xf2a4, 0xed81, 0xf26b, 0xec99, 0xf1d0, 0xeb41, 0xf092, 0xeb28, 0xf0e2,
0xeb2e, 0xf0d2, 0xeb00, 0xf0fa, 0xe9f1, 0xf03f, 0xe886, 0xef36, 0xe7e4, 0xee92,
0xe76b, 0xee72, 0xe82c, 0xeebc, 0xe91b, 0xee83, 0xe8af, 0xee49, 0xe782, 0xedf2,
0xe699, 0xee1a, 0xe632, 0xee7d, 0xe693, 0xeed6, 0xe639, 0xedd9, 0xe5bb, 0xed8f,
0xe55d, 0xed78, 0xe5a0, 0xed9a, 0xe5ea, 0xee3e, 0xe518, 0xee07, 0xe53a, 0xed64,
0xe547, 0xec33, 0xe58a, 0xec6c, 0xe499, 0xec36, 0xe579, 0xec60, 0xe612, 0xec94,
0xe6a9, 0xed9f, 0xe724, 0xedb8, 0xe6d8, 0xed6a, 0xe732, 0xee1f, 0xe636, 0xee44,
0xe609, 0xee98, 0xe532, 0xed65, 0xe524, 0xed27, 0xe4aa, 0xec8d, 0xe44a, 0xec78,
0xe4c8, 0xecbf, 0xe561, 0xed73, 0xe5d2, 0xee4c, 0xe64a, 0xedf5, 0xe65d, 0xed56,
0xe5c7, 0xecce, 0xe58a, 0xed20, 0xe57e, 0xed3d, 0xe613, 0xed01, 0xe631, 0xec84,
0xe61c, 0xed14, 0xe6a5, 0xed93, 0xe656, 0xed97, 0xe656, 0xee32, 0xe773, 0xee21,
0xe904, 0xee17, 0xe91e, 0xee26, 0xe80c, 0xedb1, 0xe878, 0xedee, 0xe94b, 0xee64,
0xea2b, 0xef0e, 0xea70, 0xee4e, 0xe998, 0xec9f, 0xe990, 0xec76, 0xe8af, 0xeb93,
0xe804, 0xeb74, 0xe83b, 0xeb6e, 0xe81b, 0xeaf9, 0xe8ee, 0xeb70, 0xe8c3, 0xea72,
0xe8c8, 0xe9de, 0xe844, 0xe9bc, 0xe90e, 0xeb1e, 0xe8bb, 0xeb31, 0xe903, 0xeb1c,
0xe92e, 0xeaa3, 0xe928, 0xeac4, 0xe968, 0xeaee, 0xe896, 0xe9ca, 0xe8b8, 0xe97a,
0xe6bf, 0xe776, 0xe6c1, 0xe6fe, 0xe79e, 0xe709, 0xe8d7, 0xe7dc, 0xea08, 0xe887,
0xea9c, 0xe8e1, 0xeae8, 0xe86c, 0xeb0c, 0xe7fb, 0xeb8e, 0xe897, 0xeb6c, 0xe965,
0xebd3, 0xe996, 0xebf0, 0xe89d, 0xec49, 0xe83a, 0xeb91, 0xe7f6, 0xebd4, 0xe830,
0xebd6, 0xe7d7, 0xeaf1, 0xe789, 0xeae5, 0xe819, 0xebc5, 0xe8dd, 0xed16, 0xe91c,
0xec24, 0xe7f7, 0xec08, 0xe75b, 0xed00, 0xe812, 0xeca6, 0xe8ad, 0xec48, 0xe924,
0xeca0, 0xe870, 0xedf6, 0xe832, 0xef0f, 0xe944, 0xeeaf, 0xea86, 0xee9d, 0xeb28,
0xef19, 0xeb94, 0xf0ba, 0xec17, 0xf167, 0xec34, 0xf152, 0xec71, 0xf172, 0xed62,
0xf247, 0xef28, 0xf39e, 0xf015, 0xf44a, 0xf046, 0xf50d, 0xf023, 0xf411, 0xeffe,
0xf392, 0xf0f7, 0xf49a, 0xf21a, 0xf677, 0xf349, 0xf6f6, 0xf361, 0xf67e, 0xf288,
0xf539, 0xf163, 0xf53b, 0xf1e3, 0xf703, 0xf462, 0xf888, 0xf5ee, 0xfa2e, 0xf71e,
0xfa9d, 0xf794, 0xfb01, 0xf7b4, 0xfc08, 0xf8b4, 0xfcf2, 0xfaa7, 0xfdd2, 0xfc25,
0xfe76, 0xfbc7, 0xfec9, 0xfbd7, 0xff52, 0xfc43, 0xff7e, 0xfcae, 0xff1c, 0xfdc5,
0xfe85, 0xfe2d, 0xff3b, 0xfea1, 0xff41, 0xfe1c, 0xff7a, 0xfd88, 0x000c, 0xfd9c,
0x0123, 0xfeb2, 0x023a, 0x0045, 0x02d1, 0x00c8, 0x036b, 0x0149, 0x03bd, 0x01bb,
0x04cb, 0x0154, 0x0525, 0x0109, 0x06bd, 0x02af, 0x072b, 0x03e4, 0x081b, 0x048b,
0x08c4, 0x0419, 0x09b5, 0x04b2, 0x0a73, 0x0525, 0x0a87, 0x04fb, 0x0b0c, 0x053f,
0x0b1c, 0x050f, 0x0a3c, 0x04ec, 0x08f2, 0x0428, 0x08fc, 0x0370, 0x089e, 0x02df,
0x0943, 0x0319, 0x090c, 0x02bd, 0x0a68, 0x02cd, 0x0b6d, 0x02e0, 0x0af7, 0x027c,
0x0a5c, 0x0272, 0x0a12, 0x0375, 0x0a74, 0x046b, 0x0acd, 0x039c, 0x0a8a, 0x02be,
0x0b17, 0x0369, 0x0be9, 0x03ce, 0x0c09, 0x0442, 0x0c21, 0x05cb, 0x0af7, 0x05ab,
0x0b43, 0x05d3, 0x0b04, 0x0456, 0x0aa5, 0x0354, 0x0b32, 0x035a, 0x0bcb, 0x039e,
0x0b9d, 0x043e, 0x0a00, 0x0307, 0x09d3, 0x031d, 0x0b22, 0x0293, 0x0c0d, 0x025c,
0x0d3e, 0x042e, 0x0dcf, 0x05f6, 0x0e2e, 0x0712, 0x0e48, 0x06e0, 0x0e15, 0x06ac,
0x0e34, 0x070f, 0x0d57, 0x0732, 0x0d5a, 0x076d, 0x0d73, 0x06f5, 0x0e10, 0x06cc,
0x0dce, 0x0728, 0x0d00, 0x075b, 0x0d1f, 0x07ae, 0x0d42, 0x077f, 0x0cee, 0x0727,
0x0c4a, 0x0769, 0x0c58, 0x078e, 0x0cd6, 0x082d, 0x0ca7, 0x0882, 0x0c8f, 0x08f1,
0x0cf5, 0x08f9, 0x0e8c, 0x095e, 0x0fbe, 0x0a6d, 0x1085, 0x0b95, 0x1069, 0x0c68,
0x0f3d, 0x0c03, 0x1008, 0x0c63, 0x101b, 0x0bfd, 0x1004, 0x0c05, 0x1023, 0x0c5e,
0x1059, 0x0c0d, 0x1079, 0x0c99, 0x1030, 0x0d5f, 0x0f7b, 0x0d70, 0x0ed5, 0x0d1d,
0x0e92, 0x0c79, 0x0eb8, 0x0c1e, 0x0f05, 0x0cf8, 0x0ec6, 0x0dc5, 0x0e0e, 0x0e04,
0x0d47, 0x0d72, 0x0e50, 0x0d85, 0x0e5e, 0x0e25, 0x0ebc, 0x0f64, 0x0df6, 0x0e71,
0x0e64, 0x0e43, 0x0e9f, 0x0f98, 0x0ec5, 0x1028, 0x0fa4, 0x10d1, 0x0fc7, 0x10c8,
0x1065, 0x1075, 0x0f7d, 0x100f, 0x104d, 0x107f, 0x1032, 0x1020, 0x108e, 0x109d,
0x0fdd, 0x107d, 0x0fb9, 0x1107, 0x0f20, 0x105e, 0x0e9b, 0x1011, 0x0de1, 0x100c,
0x0d4b, 0x0ffd, 0x0dc0, 0x10da, 0x0ceb, 0x109d, 0x0d33, 0x10ae, 0x0c9a, 0x0f9f,
0x0d09, 0x0f5e, 0x0c93, 0x0f39, 0x0cb8, 0x0f50, 0x0cc1, 0x0ff3, 0x0d4f, 0x10e4,
0x0d51, 0x102f, 0x0b7c, 0x0e9b, 0x0ab0, 0x0e4e, 0x0aea, 0x0e64, 0x0a7c, 0x0d98,
0x0a29, 0x0cdb, 0x0a5e, 0x0cae, 0x0a8f, 0x0cb3, 0x0ad5, 0x0cb0, 0x0aed, 0x0d00,
0x0bac, 0x0d3e, 0x0b63, 0x0c62, 0x0ba9, 0x0c94, 0x0b28, 0x0c8c, 0x0b49, 0x0cec,
0x0b84, 0x0cea, 0x0bc4, 0x0d52, 0x0b42, 0x0bfe, 0x0a03, 0x0a55, 0x0950, 0x0a73,
0x07dc, 0x09b6, 0x0875, 0x0a79, 0x08e1, 0x0a2c, 0x089f, 0x09ae, 0x07d6, 0x097d,
0x072e, 0x09b5, 0x077f, 0x0971, 0x0801, 0x090b, 0x090f, 0x0a6d, 0x0949, 0x0aed,
0x08c5, 0x0abb, 0x07ce, 0x0a13, 0x085c, 0x0a25, 0x093c, 0x0a55, 0x09ce, 0x0ab9,
0x0ac5, 0x0b13, 0x09e0, 0x0ac0, 0x094e, 0x0b4a, 0x0826, 0x0add, 0x0868, 0x0b31,
0x0959, 0x0afe, 0x0957, 0x0aac, 0x07f6, 0x0983, 0x065a, 0x07b9, 0x068c, 0x07b3,
0x05fa, 0x078f, 0x0619, 0x0852, 0x064e, 0x08dd, 0x0657, 0x08dc, 0x0609, 0x0820,
0x06a4, 0x089a, 0x067d, 0x0806, 0x0546, 0x0702, 0x04da, 0x0795, 0x044f, 0x0891,
0x0404, 0x08e6, 0x03e2, 0x0884, 0x0410, 0x08c5, 0x0385, 0x086f, 0x021f, 0x07a4,
0x016c, 0x077a, 0x016c, 0x0798, 0x013f, 0x0753, 0x01b3, 0x0719, 0x0168, 0x0642,
0x0147, 0x063a, 0x0118, 0x06d6, 0xfef5, 0x065b, 0xfe75, 0x061d, 0xff55, 0x067a,
0xff4f, 0x05f7, 0xff34, 0x05f3, 0xfe90, 0x05c3, 0xfed9, 0x064e, 0xfefb, 0x0690,
0xfdf6, 0x05e3, 0xfd9d, 0x0556, 0xfd76, 0x03a1, 0xfd4e, 0x032a, 0xfcf9, 0x033d,
0xfbaf, 0x02e2, 0xfa9f, 0x01bc, 0xfa52, 0xfff9, 0xfa8f, 0xffa6, 0xfa34, 0xffba,
0xf99d, 0x0015, 0xfa6c, 0x00ba, 0xfa2e, 0xffa1, 0xf9f9, 0xff21, 0xf975, 0xff13,
0xf96c, 0xff7b, 0xfa31, 0xffd0, 0xf9d1, 0x0019, 0xfb0f, 0x00e4, 0xfc76, 0x00c3,
0xfd37, 0x019a, 0xfc7d, 0x0200, 0xfba5, 0x0247, 0xfb4d, 0x0132, 0xfb75, 0xffd1,
0xfb37, 0xfed3, 0xfaf9, 0xfe44, 0xfa91, 0xfe55, 0xf948, 0xfe54, 0xf887, 0xfe9a,
0xf816, 0xfda7, 0xf8a9, 0xfd63, 0xf8d8, 0xfd56, 0xf954, 0xfe1b, 0xf9be, 0xfe7d,
0xfb83, 0xfeb8, 0xfb8b, 0xfdd8, 0xfae9, 0xfd4f, 0xfa25, 0xfd5b, 0xf9c3, 0xfd41,
0xfabf, 0xfd7c, 0xfabb, 0xfc7f, 0xfb3f, 0xfcd3, 0xfbeb, 0xfdc9, 0xfc38, 0xfe60,
0xfc35, 0xfe6a, 0xfc0c, 0xfd9f, 0xfbdf, 0xfd7f, 0xfbf7, 0xfd99, 0xfae6, 0xfd0e,
0xfb3f, 0xfca7, 0xfb90, 0xfc26, 0xfbfb, 0xfcd8, 0xfcb0, 0xfd16, 0xfd65, 0xfd0e,
0xfe7b, 0xfd85, 0xfec4, 0xfcfa, 0x000d, 0xfdf9, 0x0074, 0xfe13, 0x0088, 0xfe03,
0xffa1, 0xfd4c, 0xfed8, 0xfc7c, 0xff1c, 0xfc0e, 0x0008, 0xfbdd, 0x014a, 0xfc97,
0x0109, 0xfc96, 0xffeb, 0xfbfa, 0xff08, 0xfacf, 0xff16, 0xf970, 0xfee0, 0xf925,
0xff2b, 0xfa22, 0xfef3, 0xfa34, 0xffea, 0xfa89, 0x0011, 0xf9a2, 0xffe5, 0xfa3e,
0xffb4, 0xfb67, 0xff5d, 0xfb16, 0x007e, 0xfae6, 0x00f7, 0xfa5c, 0x018b, 0xfab4,
0x00ff, 0xfae2, 0x0120, 0xfabc, 0x014d, 0xf9dc, 0x0199, 0xf9ae, 0x01a5, 0xf9f4,
0x0175, 0xfab2, 0x01a0, 0xfaa4, 0x017c, 0xfa81, 0x01b8, 0xfb43, 0x010d, 0xfa66,
0x004e, 0xfa16, 0x00d5, 0xfa32, 0x0155, 0xfaa0, 0x00f4, 0xfb18, 0x006d, 0xfb37,
0x0093, 0xfb75, 0x00d4, 0xfaaa, 0xffc5, 0xfa12, 0xff5b, 0xfb0f, 0xff66, 0xfb7b,
0x0046, 0xfc15, 0x00c3, 0xfc08, 0x00db, 0xfc83, 0x0034, 0xfd6c, 0xfe80, 0xfcff,
0xfe1b, 0xfcbf, 0xfe6f, 0xfc05, 0xff76, 0xfc1c, 0x003d, 0xfc95, 0xffcc, 0xfc62,
0xff18, 0xfce1, 0xfefe, 0xfd4a, 0xff00, 0xfd9a, 0xff4f, 0xfeae, 0xfe95, 0xfdcb,
0xfdfb, 0xfc41, 0xfd93, 0xfbca, 0xfe1a, 0xfc02, 0xfeff, 0xfc78, 0xff48, 0xfc92,
0xffa0, 0xfc92, 0x0067, 0xfdfa, 0x0091, 0xff78, 0x0040, 0xffe8, 0x0094, 0xfe8b,
0x001f, 0xfd44, 0xffda, 0xfda9, 0xfef4, 0xfd5f, 0xfec0, 0xfd78, 0xff0a, 0xfd54,
0xff18, 0xfdcf, 0xffa7, 0xfe37, 0xffeb, 0xfe6e, 0xff0a, 0xfdf8, 0xfdb4, 0xfcb2,
0xfd8a, 0xfc0a, 0xff71, 0xfd20, 0x00b5, 0xfe5d, 0x015b, 0xff46, 0x01b6, 0xff5c,
0x01b4, 0xfec5, 0x01af, 0xfec1, 0x01b0, 0xfe14, 0x013f, 0xfdcd, 0x0126, 0xfdd9,
0x01bd, 0xfe29, 0x018e, 0xfe09, 0x01c7, 0xfe90, 0x01cb, 0xfee3, 0x01d9, 0xfe22,
0x0112, 0xfd85, 0x00ab, 0xfe04, 0x0124, 0xfe70, 0x0203, 0xfec7, 0x0296, 0xfedd,
0x0327, 0xff7b, 0x028c, 0xff53, 0x020a, 0x0004, 0x01cb, 0x00d7, 0x0141, 0xff50,
0x016e, 0xfe06, 0x0250, 0xfe4c, 0x0393, 0xff92, 0x03e3, 0xff92, 0x04b4, 0xfefd,
0x0460, 0xfe10, 0x03fb, 0xfee3, 0x03f4, 0xff2d, 0x044f, 0x0012, 0x0465, 0x00ba,
0x0464, 0x0087, 0x0364, 0xff16, 0x020d, 0xfdc2, 0x0315, 0xfeb6, 0x045c, 0xff40,
0x0579, 0xfec5, 0x04de, 0xfea8, 0x057d, 0x000c, 0x05f2, 0x0070, 0x068f, 0x010c,
0x072b, 0x00d8, 0x0698, 0x0063, 0x0690, 0x010f, 0x0707, 0x01c4, 0x0803, 0x0191,
0x07f6, 0x00d9, 0x08c3, 0x0128, 0x08cf, 0x002e, 0x089a, 0x0064, 0x0785, 0x00d5,
0x07a0, 0x00fe, 0x07a8, 0x0108, 0x06c3, 0x008f, 0x0708, 0x012d, 0x0752, 0x0131,
0x0748, 0x008e, 0x06dd, 0x001e, 0x06ba, 0xffa0, 0x0747, 0x007d, 0x0750, 0x0196,
0x06a5, 0x01aa, 0x068c, 0x01c7, 0x060c, 0x0144, 0x0667, 0x01f9, 0x0581, 0x01e8,
0x042e, 0x0163, 0x0475, 0x011b, 0x05e9, 0x01d5, 0x0667, 0x027d, 0x0657, 0x0221,
0x0644, 0x024e, 0x0577, 0x0365, 0x0549, 0x04c8, 0x05ad, 0x0549, 0x05d5, 0x05c5,
0x05df, 0x0544, 0x0600, 0x052f, 0x05ce, 0x052b, 0x067b, 0x05ba, 0x06af, 0x0697,
0x0620, 0x0702, 0x0554, 0x06b8, 0x0535, 0x05b4, 0x06c3, 0x061b, 0x065b, 0x066e,
0x0462, 0x058f, 0x02db, 0x044f, 0x02cc, 0x049d, 0x0440, 0x0634, 0x0506, 0x06c8,
0x0574, 0x06ff, 0x05c1, 0x06b0, 0x066f, 0x06ca, 0x0651, 0x07d6, 0x0628, 0x0862,
0x057f, 0x07f9, 0x05c9, 0x085a, 0x0516, 0x0844, 0x0401, 0x078e, 0x0436, 0x0715,
0x0379, 0x0749, 0x03f1, 0x07e5, 0x02da, 0x0646, 0x028f, 0x05a3, 0x032f, 0x05a3,
0x0364, 0x04ec, 0x047b, 0x0602, 0x04c2, 0x0716, 0x05f7, 0x0853, 0x0483, 0x07f9,
0x03b4, 0x07d6, 0x0512, 0x0810, 0x0334, 0x0664, 0x0222, 0x0526, 0x003f, 0x0361,
0xfff3, 0x0374, 0xfff3, 0x027c, 0x0042, 0x022b, 0x0185, 0x0379, 0x0124, 0x03ba,
0x01a5, 0x04d0, 0x0167, 0x0460, 0x0104, 0x04d2, 0xfff1, 0x0457, 0xffb8, 0x03e7,
0xffbb, 0x043a, 0xfe2b, 0x0386, 0xfe06, 0x037c, 0xfc97, 0x013a, 0xfc30, 0x00e5,
0xfcb3, 0x0097, 0xfcd1, 0x006d, 0xfd31, 0x0103, 0xfc61, 0x00f9, 0xfcbf, 0x0152,
0xfcf3, 0x005d, 0xffcb, 0x0191, 0xffa4, 0x0151, 0xffbf, 0x02bc, 0x0019, 0x0309,
0xfe27, 0x02ab, 0xfd47, 0x02aa, 0xfbc5, 0x0086, 0xfc06, 0x006f, 0xf9f6, 0xffa9,
0xfa13, 0xff6f, 0xfad6, 0xfe0e, 0xfa91, 0xfe04, 0xfa81, 0xfe83, 0xf9aa, 0xfdf7,
0xfa02, 0xfef1, 0xf9f8, 0xff9a, 0xfaf0, 0xffcf, 0xfa5f, 0xff3d, 0xfa26, 0xff8f,
0xfa4e, 0xffc7, 0xf9c1, 0xfff8, 0xfa27, 0x0174, 0xfa07, 0x0147, 0xfa45, 0x0030,
0xfa05, 0xffe0, 0xf98e, 0xff59, 0xf93f, 0xfec8, 0xf94d, 0xff0e, 0xf782, 0xfe71,
0xf6ad, 0xfe87, 0xf689, 0xff05, 0xf6c5, 0xff32, 0xf5f1, 0xfe0f, 0xf5ae, 0xfd5f,
0xf5cb, 0xfd3d, 0xf588, 0xfd42, 0xf53a, 0xfcfa, 0xf4d4, 0xfd02, 0xf77e, 0xfe20,
0xf84e, 0xfda9, 0xfa47, 0xfffb, 0xf99b, 0x0089, 0xfac5, 0x0244, 0xfb36, 0x01c5,
0xfa5d, 0x012e, 0xfa14, 0x00b4, 0xf960, 0x0088, 0xfaa8, 0x014e, 0xf9b6, 0xfecf,
0xf93e, 0xfe3f, 0xf76f, 0xfcd8, 0xf7b3, 0xfd63, 0xf6c6, 0xfcb1, 0xf730, 0xfce0,
0xf70c, 0xfb7b, 0xf600, 0xfa7b, 0xf674, 0xfb1c, 0xf689, 0xfba4, 0xf869, 0xfdca,
0xf91e, 0xfe1c, 0xfa04, 0xfedc, 0xf905, 0xfdd8, 0xf8aa, 0xfdd8, 0xf932, 0xfe37,
0xfa33, 0xfe2b, 0xfad5, 0xfdc9, 0xfa5a, 0xfe07, 0xfa76, 0xfe62, 0xf899, 0xfd3c,
0xf7dd, 0xfd6f, 0xf6df, 0xfc04, 0xf7c8, 0xfc64, 0xf8d2, 0xfc0e, 0xf81b, 0xfb63,
0xf8ec, 0xfd2d, 0xf93a, 0xfdd1, 0xfa54, 0xfeb9, 0x06cd, 0x13ea, 0x0619, 0x0485,
0xefd6, 0xfa82, 0xe711, 0x0556, 0xf984, 0x0233, 0x0449, 0xf671, 0x3345, 0x1212,
0x5b1a, 0x3d1a, 0x3d1b, 0x48ca, 0x10e6, 0x19a0, 0x0b19, 0xfb28, 0x0746, 0x02b1,
0xfe88, 0xf074, 0xeb1a, 0xda67, 0xbd6a, 0xb28c, 0xced8, 0xa1ae, 0x0849, 0xf686,
0xed1e, 0x02ec, 0x9b4e, 0x9632, 0x8000, 0x9233, 0xaa1c, 0xbf03, 0xe2ee, 0x958d,
0xc0aa, 0x9f23, 0xc261, 0xebe7, 0x06cb, 0x196f, 0x1db7, 0x3459, 0x2917, 0x3f5b,
0x3e89, 0x58a7, 0x1762, 0x4994, 0x16ae, 0xfc4e, 0x48c4, 0x028c, 0x3d18, 0x5125,
0x1986, 0x43c3, 0x0256, 0xf9dc, 0xf2d3, 0xe21f, 0xfc36, 0xdf74, 0x2c32, 0xfa15,
0x5c55, 0x4058, 0x57f7, 0x5130, 0x482c, 0x1db7, 0x239e, 0xf7cf, 0xd642, 0x178f,
0xc420, 0x242c, 0xf9d9, 0xd55f, 0xc77a, 0x86f5, 0x8000, 0xa13d, 0x8002, 0xa919,
0x809d, 0xa1ef, 0x97be, 0xbf0b, 0xb44d, 0xc6df, 0xcb31, 0xc350, 0xd0bf, 0xc7aa,
0xeaf2, 0xd4d4, 0x1e61, 0xf978, 0x511a, 0x34f8, 0x55fe, 0x4ae3, 0x507c, 0x3da7,
0x6471, 0x4362, 0x6030, 0x51dc, 0x4b18, 0x4b6b, 0x4342, 0x342c, 0x2866, 0x1f8d,
0x13bc, 0x0ce5, 0x07d8, 0xec02, 0xf891, 0xdc86, 0xdf79, 0xcb4f, 0xe1f2, 0xdb8a,
0xc538, 0xc799, 0x84c8, 0x8001, 0x8000, 0x8001, 0x8001, 0x8000, 0x8001, 0x8000,
0x8000, 0x8000, 0x8001, 0x8000, 0xad05, 0x9e6d, 0xecc7, 0xe693, 0xebb8, 0xf24b,
0xe90d, 0xed6a, 0x0801, 0x138d, 0x2d4f, 0x3b67, 0x56fd, 0x4642, 0x62d8, 0x3277,
0x28c0, 0x2998, 0xf40a, 0x2b6a, 0x2050, 0x1274, 0x4ea4, 0x17a2, 0x2e72, 0x4555,
0x2a3f, 0x49bc, 0x48ff, 0x2ae7, 0x3552, 0x1577, 0x12fc, 0xf9a8, 0x0dfc, 0xe34d,
0xea47, 0xc1f5, 0xd33b, 0xbe09, 0xf166, 0xe284, 0x17be, 0xfcef, 0x3072, 0x2f6e,
0x2426, 0x5ffc, 0xf55f, 0x4256, 0xe419, 0x0383, 0xfd2e, 0xf925, 0xff32, 0xf4fb,
0xe979, 0xe718, 0xf156, 0xe0ce, 0x361b, 0xfadc, 0x4ff6, 0x17eb, 0x44c1, 0x2bd2,
0x27f6, 0x0cfd, 0xfe00, 0xda46, 0xd655, 0xbe6b, 0xa4de, 0x8cdf, 0x8c3e, 0x8002,
0x8f29, 0x849c, 0xa4fa, 0xaf35, 0xd912, 0xdb04, 0xfa0d, 0xd7d2, 0x0a49, 0xe577,
0x0068, 0x1447, 0x11d7, 0x4189, 0x3cf9, 0x44d3, 0x4cca, 0x3414, 0x5335, 0x28bb,
0x5bce, 0x144d, 0x4bf9, 0x0747, 0x177c, 0xf78a, 0xebc0, 0xdec9, 0xd351, 0xd1e2,
0xba7e, 0xc351, 0xba4a, 0xbfeb, 0xecca, 0xe8c9, 0x0545, 0x02e7, 0x1284, 0x2444,
0x258c, 0x49bd, 0x5d3f, 0x739a, 0x7394, 0x7d47, 0x5dd3, 0x690c, 0x42db, 0x419e,
0x3f16, 0x35c4, 0x1f47, 0x2ad0, 0xf6b6, 0x0372, 0xed21, 0xe04c, 0xcd89, 0xb083,
0xb40c, 0x9993, 0xb352, 0x9f18, 0xa716, 0x9a9f, 0x8f88, 0x8ca9, 0xa79f, 0xa7c2,
0xd994, 0xccf1, 0x0cdf, 0xf3c5, 0x2cdf, 0x0f65, 0x4e98, 0x336c, 0x6aa8, 0x5066,
0x6fa1, 0x5e16, 0x73e2, 0x6909, 0x7972, 0x6fee, 0x7b84, 0x7a3c, 0x785d, 0x7a5a,
0x6af0, 0x73b8, 0x3942, 0x51e1, 0x18d9, 0x2ea9, 0x1daa, 0x3339, 0xfb0f, 0x1f1e,
0xc638, 0xe632, 0xd823, 0xd2bf, 0xe048, 0xc20a, 0xbc6e, 0xb388, 0xb860, 0xbc5f,
0xde17, 0xbed6, 0xec8a, 0xab38, 0xcf68, 0xb29c, 0xaf0e, 0xd0b5, 0xad03, 0xd71e,
0xbbe3, 0xc43b, 0xc85d, 0xb5e1, 0xc1c0, 0xa828, 0xc52a, 0xa6b5, 0xd3ae, 0xaf7d,
0xe1da, 0xbcc3, 0xf75e, 0xe1f1, 0x143e, 0x12b2, 0x25f1, 0x3510, 0x2390, 0x3fbc,
0x28fd, 0x470d, 0x2a5d, 0x40b2, 0x2128, 0x38c8, 0x16d8, 0x3214, 0x050c, 0x1b7f,
0x0bfc, 0x102c, 0x2788, 0x0b4b, 0x2232, 0xfb7d, 0x1ad2, 0xf647, 0x19fe, 0xf45a,
0x1fdc, 0xffce, 0x20e1, 0xff5d, 0x369c, 0x0dec, 0x4eaf, 0x264d, 0x5c1f, 0x442e,
0x52c8, 0x4a81, 0x4d7f, 0x44ab, 0x4827, 0x4056, 0x40ed, 0x445e, 0x355d, 0x3219,
0x2963, 0x2012, 0x185b, 0x16f1, 0x07f3, 0xfa98, 0xea61, 0xd9b1, 0xdcaf, 0xd770,
0xdf51, 0xdfae, 0xc974, 0xd06d, 0xbce4, 0xd2c9, 0xc8f1, 0xe561, 0xdd9f, 0xf9e3,
0xe754, 0x0605, 0xe7db, 0xf993, 0xf99e, 0xfaa4, 0x0b5c, 0x1944, 0xfa56, 0x2090,
0xf9e2, 0x1c09, 0xf572, 0x0a46, 0x037b, 0x0b09, 0x08ee, 0x01b6, 0xe348, 0xe839,
0xe076, 0xfc34, 0xdd0f, 0xed66, 0xe107, 0xd206, 0xe71b, 0xd0df, 0xd4ec, 0xd3be,
0xcfbd, 0xd223, 0xca99, 0xc20c, 0xc14b, 0xc035, 0xd112, 0xcce1, 0xe95d, 0xcdfd,
0xe5c4, 0xceb3, 0xe36f, 0xe79a, 0xe7fb, 0xf97d, 0xefce, 0xf429, 0x089c, 0xfa83,
0x1351, 0x056d, 0x0b33, 0x08c1, 0x104f, 0x18b6, 0x0b05, 0x1cc7, 0x099c, 0x1b35,
0x1dda, 0x2438, 0x1fc0, 0x25de, 0x1599, 0x23c6, 0x1da1, 0x28a7, 0x0c65, 0x1b60,
0xef9c, 0x09a3, 0xe5b3, 0xf929, 0xee2f, 0xee8e, 0xfc12, 0xeeed, 0xfa08, 0xf1c0,
0xee42, 0xfd8c, 0xec08, 0x0f04, 0x16f0, 0x26b9, 0x3f34, 0x2bc4, 0x3a89, 0x18bb,
0x3a99, 0x0e2b, 0x3ab0, 0x0f35, 0x2718, 0x0bad, 0x1a12, 0x0f68, 0x2e32, 0x2af4,
0x4869, 0x49ba, 0x44d4, 0x509f, 0x3fe2, 0x53db, 0x4a29, 0x5037, 0x571c, 0x44da,
0x5a4a, 0x4646, 0x402f, 0x3fc8, 0x2162, 0x22d2, 0x20cc, 0x1957, 0x2252, 0x28ac,
0x04e1, 0x1d9c, 0xede0, 0x0e22, 0xe65b, 0x0816, 0xfc08, 0x1406, 0x0e1d, 0x1e8d,
0x0cff, 0x1d57, 0x04ab, 0x1047, 0x07e5, 0x16c9, 0xfda5, 0x08ac, 0x01b3, 0xf4fc,
0x0ad5, 0xf272, 0xfe92, 0xe9c3, 0xecf3, 0xe0f0, 0xe62b, 0xdef3, 0xd3fc, 0xd0fe,
0xc93c, 0xd0b8, 0xe766, 0xf08a, 0xfa0a, 0xffbf, 0x0116, 0x0760, 0xf933, 0x03f2,
0xfdd0, 0x10f9, 0x134f, 0x246d, 0x26b5, 0x29b0, 0x1c8a, 0x2096, 0x1545, 0x1d37,
0x0d1e, 0x0ec9, 0x0809, 0x0486, 0xfb05, 0xed6b, 0xe8cc, 0xd135, 0xe10a, 0xca8e,
0xd161, 0xc73e, 0xc708, 0xc0ed, 0xb7d0, 0xb72e, 0xb36b, 0xc158, 0xbb8d, 0xcfd4,
0xcb08, 0xd925, 0xcd0d, 0xccdc, 0xce5f, 0xc82f, 0xe72c, 0xeec3, 0xf4ab, 0xffa7,
0xdd50, 0xe121, 0xd80a, 0xdf67, 0xe7a3, 0xed52, 0xfad9, 0x0076, 0xee72, 0xf4ce,
0xee4b, 0xf0e7, 0x09ce, 0x09f8, 0x016d, 0x0175, 0xf98f, 0xf1de, 0xf559, 0xe751,
0xf4c8, 0xf23d, 0xf354, 0xf92d, 0xf60a, 0xeee4, 0xfe75, 0xeec9, 0xf87b, 0xf4f8,
0x037a, 0x0009, 0x0537, 0xf9cd, 0xf634, 0xf695, 0xebab, 0xf3cd, 0xe97b, 0xf300,
0xdced, 0xeeb7, 0xdc10, 0xec76, 0xeb3c, 0xf21f, 0xf775, 0xf939, 0xfb94, 0xf7c5,
0xf5df, 0xecc3, 0xfb26, 0xf6dd, 0xfb5c, 0xf969, 0x116c, 0x0e25, 0x1ae2, 0x158c,
0x1c11, 0x1a6e, 0x1756, 0x1590, 0x153b, 0x169c, 0x0e58, 0x17b7, 0xfdee, 0x0c9d,
0x0132, 0x04ac, 0x0cc7, 0xfb7b, 0xf2dd, 0xe829, 0xdb9f, 0xe28f, 0xf05a, 0xf343,
0xf55b, 0xef99, 0xea6b, 0xe947, 0xe9c2, 0xe7f1, 0xf7c9, 0xee13, 0xf807, 0xf137,
0x0582, 0x011b, 0x133b, 0x0dc5, 0x238a, 0x286a, 0x2f51, 0x397a, 0x39fe, 0x3a52,
0x2fa0, 0x334f, 0x3101, 0x3fa8, 0x48d6, 0x55ab, 0x48b0, 0x50f1, 0x2f16, 0x370a,
0x1d4a, 0x2c83, 0x2cca, 0x342e, 0x2e85, 0x27c2, 0x2460, 0x2308, 0x226e, 0x24f7,
0x1668, 0x112c, 0x0d86, 0x09ed, 0x08b3, 0x0cac, 0x0672, 0x07b8, 0x10d3, 0x119f,
0x0547, 0x07d5, 0x01d8, 0xfe59, 0xfaa7, 0xf872, 0xec9b, 0xefdd, 0xcc7a, 0xccdf,
0xbfba, 0xbfdf, 0xbf70, 0xc55e, 0xd970, 0xdd17, 0xfd50, 0x0225, 0x0134, 0x1522,
0xf9a2, 0x102a, 0x1429, 0x12b7, 0x3e19, 0x2d35, 0x2145, 0x175a, 0x000b, 0xfd7b,
0x009b, 0xf3d3, 0x034f, 0xecd5, 0x244a, 0x17d1, 0x40fe, 0x3d49, 0x24a0, 0x1bb2,
0x0be0, 0x036e, 0x2274, 0x2fb8, 0x0d14, 0x2fad, 0xf67e, 0x1033, 0x049a, 0x0e75,
0x0780, 0x0fc6, 0x15a5, 0x15ab, 0x0548, 0x003d, 0xd4d5, 0xdc4e, 0xd906, 0xe0e6,
0x0002, 0xf608, 0x1446, 0x03f8, 0x0d13, 0x037d, 0xf747, 0xeacc, 0xd3dd, 0xc697,
0xd435, 0xca9c, 0xf8ea, 0xedc1, 0xea1e, 0xdfef, 0xdc02, 0xd1e8, 0xfcfe, 0xf121,
0x0581, 0x0093, 0xfafc, 0xf9e0, 0x03f6, 0xfcd2, 0x0a88, 0xfe0e, 0x0278, 0xf4c1,
0x0615, 0xf858, 0xeafa, 0xecd1, 0xd697, 0xe1de, 0xeab3, 0xf237, 0xf78e, 0xfffb,
0xf93c, 0xf7de, 0x0602, 0xfb1a, 0x039c, 0xfc23, 0xf1b6, 0xea57, 0xbe2f, 0xaec1,
0xc03e, 0xac0c, 0xe842, 0xd6ce, 0xf2e1, 0xeafd, 0xdd3a, 0xdb29, 0xc0d6, 0xc5d5,
0xb092, 0xbeda, 0xcb5b, 0xdbcb, 0xe1d8, 0xe921, 0xdf79, 0xddfb, 0xfce4, 0xf416,
0xfe43, 0xef48, 0xf64f, 0xee02, 0x0172, 0xffdf, 0x01fc, 0x06b5, 0xe73c, 0xed0d,
0xeb17, 0xeb34, 0xf0d8, 0xf80c, 0xffcb, 0x0e67, 0x0523, 0x1179, 0xfda6, 0x0868,
0x1153, 0x193a, 0x1c5c, 0x20d1, 0x064b, 0x0df6, 0xe6ab, 0xf4e8, 0xe51f, 0xf2d3,
0xfb7e, 0x0138, 0x0b4f, 0x070e, 0xf765, 0xe7ee, 0xe0af, 0xc852, 0xf55a, 0xdb27,
0x0565, 0xf5b7, 0x0767, 0x05cf, 0x0e9e, 0x083b, 0x112f, 0xf40d, 0x18e4, 0xf246,
0x0434, 0xec1c, 0xea90, 0xdf22, 0xff88, 0xf05a, 0x1573, 0x0a21, 0x11db, 0x1899,
0x095f, 0x1628, 0x1a89, 0x1829, 0x1e5d, 0x0f13, 0x0e3a, 0x00c2, 0x1878, 0x1671,
0x054b, 0x0741, 0xf562, 0xf637, 0x0a64, 0x08c4, 0x0a5a, 0x081c, 0xfd7d, 0x06b5,
0x0d20, 0x1bd1, 0x28cd, 0x2be5, 0x3041, 0x2e5f, 0x2cde, 0x3539, 0x29a4, 0x3263,
0x3a42, 0x3bcf, 0x458e, 0x452c, 0x3292, 0x3577, 0x220e, 0x21a6, 0x1830, 0x1756,
0x1967, 0x19b0, 0x0c06, 0x0dcb, 0x020b, 0x0e91, 0xf810, 0x0516, 0x0812, 0x0671,
0x070b, 0xfae1, 0xf159, 0xe987, 0xf62e, 0xf5b4, 0x0cc9, 0x032c, 0x1505, 0x0017,
0x08d7, 0xf1a2, 0x1e5e, 0x06c2, 0x25a2, 0x142f, 0x2afa, 0x24f5, 0x2a2b, 0x2bca,
0x18df, 0x1b32, 0x192a, 0x15ca, 0x20eb, 0x1f09, 0x16e0, 0x161e, 0x0243, 0xf654,
0x015d, 0xf043, 0x05eb, 0xfa03, 0x10b5, 0x041b, 0x1769, 0x0ac9, 0x179e, 0x07a8,
0x05de, 0xf1d6, 0xfae2, 0xe641, 0xff57, 0xef31, 0x0906, 0xff10, 0x1645, 0x0b59,
0x1d9a, 0x1924, 0x098a, 0x1890, 0x0202, 0x1e67, 0x0fe0, 0x1f29, 0x0a0f, 0x0ef9,
0x1b7f, 0x2545, 0x39e7, 0x44c8, 0x2850, 0x3204, 0x16a7, 0x2682, 0x2192, 0x3016,
0x2100, 0x296d, 0x2926, 0x30ad, 0x2976, 0x2b2f, 0x21ee, 0x2c6a, 0x1547, 0x2d98,
0x0877, 0x1e0b, 0x0d2d, 0x22ad, 0x1602, 0x1d38, 0x11f8, 0x0bd0, 0x12b6, 0x1263,
0x1d33, 0x1d36, 0x1454, 0x106e, 0xf3f2, 0xf66b, 0xfaa7, 0xfd76, 0xfbab, 0xf99a,
0xe96a, 0xefc4, 0xd4be, 0xe2f3, 0xdf79, 0xe530, 0xe4df, 0xe335, 0xe0a3, 0xef03,
0xe6a2, 0x0189, 0xd7b9, 0xe891, 0xe407, 0xe74e, 0xeb5c, 0xe95a, 0xdc1d, 0xdccf,
0xe01c, 0xde12, 0xe370, 0xde21, 0xe4c7, 0xdea0, 0xe703, 0xdfb0, 0xe7d9, 0xd977,
0xf1de, 0xe2a0, 0xf935, 0xf13b, 0xf289, 0xeb9c, 0xf5d4, 0xf1a1, 0xec9d, 0xf55f,
0xd7e5, 0xefec, 0xdf8a, 0xf211, 0xe1be, 0xed11, 0xdb92, 0xf0ed, 0xe11c, 0xfcfa,
0xd65c, 0xed19, 0xccd4, 0xdb30, 0xe449, 0xeee0, 0xec16, 0xf29f, 0xe044, 0xe610,
0xd594, 0xe29d, 0xcfb9, 0xd205, 0xd63c, 0xd281, 0xd4b2, 0xdef8, 0xd000, 0xe24e,
0xd45c, 0xe1e0, 0xcaac, 0xd1ca, 0xd3e6, 0xd8f3, 0xe6a7, 0xe47e, 0xe683, 0xdec3,
0xf151, 0xe952, 0xefaf, 0xeab2, 0xee52, 0xeb20, 0xdec9, 0xdf57, 0xe017, 0xef75,
0xe403, 0xf630, 0xe4f4, 0xe83b, 0xe853, 0xe539, 0xeae4, 0xe8cb, 0xe668, 0xe74f,
0xeb2d, 0xf1ca, 0xed24, 0xf0a8, 0xf289, 0xec48, 0x04d3, 0xfa50, 0x0bd3, 0x0567,
0x05db, 0x0563, 0x0289, 0x03f8, 0x04a3, 0x0138, 0xfe6f, 0x00e1, 0x0a8e, 0x154f,
0x025d, 0x05a8, 0xfed8, 0x0352, 0xf7b0, 0x0200, 0xf699, 0xfcea, 0xefe2, 0xecb3,
0xeba2, 0xe845, 0xedf1, 0xed68, 0xf3b3, 0xe73a, 0x0291, 0xf15f, 0xf4a3, 0xf76a,
0xf846, 0x0231, 0xfcf6, 0x06dc, 0xf3b9, 0x0749, 0xedff, 0x057c, 0xf6b3, 0x09e5,
0xfbea, 0x08dc, 0xfacf, 0x0821, 0xf76a, 0x08ad, 0xf3ed, 0xfdd5, 0x0544, 0x0925,
0x0378, 0x0f8c, 0xfad0, 0x09ed, 0x05b2, 0x1103, 0x11ca, 0x1856, 0x1d45, 0x19a4,
0x0d48, 0x0a5c, 0x05d5, 0x1086, 0x08fe, 0x2032, 0xfdd8, 0x17e6, 0x0385, 0x1ca9,
0x15dc, 0x270c, 0x0e71, 0x14a1, 0xf6e4, 0x0713, 0xfe7b, 0x1102, 0x18f6, 0x166f,
0x1a5d, 0x0d2e, 0x1e9e, 0x15c6, 0x1680, 0x132b, 0x2133, 0x14b2, 0x2997, 0x16f6,
0x3c84, 0x3119, 0x3fa4, 0x3612, 0x44b9, 0x34ea, 0x3ccd, 0x359d, 0x2df3, 0x3827,
0x3bdf, 0x4e38, 0x41e5, 0x5450, 0x4024, 0x46e9, 0x365c, 0x3e26, 0x3c22, 0x4bf2,
0x34d1, 0x43f3, 0x301d, 0x3ff6, 0x22c9, 0x38aa, 0x1318, 0x2e2f, 0x1714, 0x31d4,
0x1525, 0x2ce0, 0x12a8, 0x2aa8, 0x0dd2, 0x2931, 0x104e, 0x2aed, 0x1257, 0x2635,
0x097a, 0x1591, 0x0c33, 0x16e4, 0x0f64, 0x18db, 0x147d, 0x1b4c, 0x0b91, 0x1454,
0x0e0a, 0x1af1, 0x097c, 0x1917, 0x0388, 0x1450, 0x0bf4, 0x1915, 0x10aa, 0x1626,
0x03bd, 0x044e, 0xf01f, 0xf45a, 0xf2a6, 0xffcc, 0x09b1, 0x11e7, 0x0486, 0x016c,
0xeb0d, 0xebb5, 0xfa1f, 0xfbcc, 0x1149, 0x0be1, 0x0f0a, 0x0a3c, 0xf0a5, 0xf3aa,
0xf6f5, 0xfd5c, 0x02c3, 0x05c7, 0x0064, 0xfc0c, 0xf88f, 0xed22, 0xf748, 0xead3,
0x0336, 0xf395, 0xf8ce, 0xeff5, 0xf581, 0xf3a1, 0xf7df, 0xf179, 0xee99, 0xf07e,
0xdc00, 0xe605, 0xe98e, 0xed76, 0xee11, 0xf485, 0xdbd1, 0xeb34, 0xdda7, 0xee27,
0xdd44, 0xe91e, 0xee42, 0xf1a6, 0xeb34, 0xe9df, 0xe07a, 0xe22f, 0xd90c, 0xd8bc,
0xdf54, 0xdef3, 0xda7d, 0xdfba, 0xd4fc, 0xd85b, 0xd41e, 0xd3ef, 0xd074, 0xd09c,
0xdabb, 0xdc04, 0xd87d, 0xdda5, 0xd756, 0xdf5a, 0xc863, 0xce21, 0xced9, 0xd849,
0xd8d7, 0xe58d, 0xcbd5, 0xd95e, 0xd5ab, 0xdf4f, 0xe2fe, 0xe6b6, 0xdde5, 0xe0a0,
0xdcbb, 0xdd6a, 0xe237, 0xde8d, 0xe329, 0xdbcd, 0xe050, 0xd776, 0xdd5f, 0xd5d6,
0xdaf1, 0xd8bb, 0xd3d8, 0xd51b, 0xc361, 0xbbcd, 0xc109, 0xb470, 0xd2fa, 0xc8d9,
0xd209, 0xc993, 0xc41e, 0xbc34, 0xbbe5, 0xb731, 0xbded, 0xc022, 0xccfe, 0xccf0,
0xcb82, 0xbc38, 0xbb30, 0xabe2, 0xc658, 0xb661, 0xd06d, 0xb425, 0xcc03, 0xaeec,
0xd53c, 0xbdb5, 0xd1b3, 0xb932, 0xd201, 0xbf1d, 0xdbb1, 0xcd71, 0xdcbc, 0xc58b,
0xd2fc, 0xbbce, 0xcd8e, 0xc145, 0xd446, 0xcd0c, 0xddb0, 0xd83f, 0xd120, 0xcecd,
0xc391, 0xc6d5, 0xc3c4, 0xc345, 0xce79, 0xc13a, 0xceda, 0xbbfc, 0xd105, 0xc34c,
0xc9e8, 0xc4b7, 0xc028, 0xbb3d, 0xcb4e, 0xc293, 0xda2c, 0xcfaf, 0xd240, 0xccbd,
0xccdb, 0xcb43, 0xd8dd, 0xd299, 0xe713, 0xdd34, 0xda1f, 0xd335, 0xd748, 0xd16e,
0xdc25, 0xcd47, 0xdd28, 0xc72f, 0xdeb9, 0xcc26, 0xe256, 0xd5e0, 0xe6a8, 0xdca4,
0xded9, 0xce69, 0xed31, 0xd680, 0xfb94, 0xe4c7, 0xfc29, 0xe735, 0xffef, 0xec0c,
0x04d9, 0xef22, 0xffd2, 0xef5d, 0xff47, 0xf454, 0x01c3, 0xfb04, 0x0162, 0xf98c,
0x10f4, 0x0790, 0x0fd2, 0x0c3f, 0x1378, 0x1158, 0x1977, 0x1519, 0x1ee5, 0x1872,
0x156d, 0x12d4, 0x0e41, 0x1138, 0x1fc2, 0x1738, 0x27d6, 0x1359, 0x2068, 0x1102,
0x1b5c, 0x15b3, 0x22c8, 0x1ca4, 0x29db, 0x18c1, 0x2f61, 0x174a, 0x2ea5, 0x143e,
0x2e0f, 0x1479, 0x3026, 0x226f, 0x3b2b, 0x309a, 0x48e6, 0x3a0c, 0x357e, 0x34d7,
0x2cd0, 0x358b, 0x434b, 0x459f, 0x47b5, 0x4959, 0x3b14, 0x3e1f, 0x450d, 0x410e,
0x476e, 0x39eb, 0x4655, 0x3a8f, 0x43c1, 0x43f1, 0x38d3, 0x3d7e, 0x45a0, 0x457b,
0x5020, 0x4b58, 0x4b0c, 0x449e, 0x5485, 0x4d24, 0x5912, 0x4c1d, 0x519d, 0x429d,
0x5ad0, 0x4f9d, 0x5ac1, 0x525f, 0x51d4, 0x5204, 0x440b, 0x4da2, 0x599c, 0x5efd,
0x6ddf, 0x6c78, 0x75cc, 0x7156, 0x7fff, 0x7c91, 0x6517, 0x61b4, 0x39f8, 0x3773,
0x2336, 0x216d, 0x1884, 0x19f4, 0x17f8, 0x1eb4, 0x27eb, 0x2ade, 0x3c4b, 0x358e,
0x3b13, 0x39f4, 0x3512, 0x375e, 0x401c, 0x420e, 0x5706, 0x5194, 0x6c24, 0x5a12,
0x5d02, 0x47ed, 0x366d, 0x2a10, 0x28e3, 0x236e, 0x4330, 0x3aeb, 0x439d, 0x3ace,
0x4ea2, 0x44fa, 0x63a1, 0x50c4, 0x6acf, 0x6280, 0x5862, 0x5df2, 0x36ab, 0x3635,
0x272d, 0x28e1, 0x233c, 0x24e0, 0x240a, 0x1cfa, 0x274b, 0x1f61, 0x301e, 0x2ebd,
0x1717, 0x1b24, 0x1f14, 0x1e2c, 0x2bb1, 0x2944, 0x3489, 0x3c2b, 0x327f, 0x3ca2,
0x1950, 0x1eb2, 0x052e, 0x0ec2, 0x083d, 0x1167, 0xfaba, 0xf8a4, 0xfbbc, 0xf8cd,
0x1b20, 0x1f64, 0x149b, 0x142c, 0x1610, 0x0c22, 0x2218, 0x1914, 0x0eab, 0x0e2e,
0x0dfa, 0x0cbe, 0x2f74, 0x2148, 0x0de5, 0x0358, 0xe93d, 0xed3e, 0xeb66, 0xeba0,
0xe1de, 0xd625, 0xd9c0, 0xc743, 0xd898, 0xc6da, 0xef3a, 0xdc74, 0x024c, 0xecce,
0xfd4a, 0xeb95, 0xfdfa, 0xf543, 0x090c, 0x048e, 0x0506, 0xf771, 0x1de4, 0x0333,
0x2a42, 0x0eb2, 0x13e7, 0x087d, 0xe857, 0xe947, 0xeb66, 0xede8, 0x0d3d, 0x0c3b,
0x0a21, 0x0b5c, 0xeada, 0xee70, 0xdfa5, 0xdfcf, 0xda69, 0xd479, 0xd13c, 0xc4b1,
0xca18, 0xb99d, 0xcb88, 0xb8ee, 0xce48, 0xba1e, 0xbe5b, 0xace8, 0xb2da, 0xa264,
0xb748, 0xa7d8, 0xb345, 0xa8c7, 0x962e, 0x90e8, 0x9344, 0x8cb6, 0x9210, 0x8a5f,
0x9081, 0x88ee, 0xa129, 0x9a9d, 0xa582, 0xa03e, 0xab3f, 0xa360, 0xb742, 0xaee9,
0xbd5d, 0xbc10, 0xb257, 0xb3b1, 0xb0ff, 0xb159, 0xbddd, 0xc568, 0xc31b, 0xc578,
0xd451, 0xcb0d, 0xdd33, 0xcfb0, 0xe717, 0xdb2f, 0xe219, 0xd6c6, 0xcb6a, 0xc0d1,
0xc346, 0xbcd8, 0xc71f, 0xc6b5, 0xc4b4, 0xc18f, 0xc6fd, 0xc1f9, 0xe37a, 0xe35c,
0xee26, 0xf1c8, 0xd283, 0xdadf, 0xcb45, 0xce45, 0xcf7f, 0xc790, 0xbca3, 0xb67f,
0xbec4, 0xc172, 0xc374, 0xc790, 0xb779, 0xbaaa, 0xb8a6, 0xb957, 0xc712, 0xc59d,
0xbe0c, 0xbddb, 0xae20, 0xaf73, 0xa8c9, 0xade8, 0xadc8, 0xba78, 0xbcbe, 0xc144,
0xc780, 0xbfca, 0xb6c2, 0xb45f, 0xaba6, 0xa9d0, 0xbbe2, 0xb3d4, 0xd25b, 0xd047,
0xe2e3, 0xe620, 0xd06e, 0xd3ea, 0xbfd0, 0xc496, 0xc8c3, 0xccca, 0xd083, 0xd890,
0xcc15, 0xda80, 0xcc19, 0xd979, 0xda5b, 0xe026, 0xda8d, 0xe145, 0xd0aa, 0xde47,
0xc426, 0xd31b, 0xc8ea, 0xdb99, 0xd324, 0xe8e6, 0xcee3, 0xe44e, 0xd7ce, 0xe9c0,
0xd9b1, 0xe56d, 0xd765, 0xe042, 0xe173, 0xe9a6, 0xfe9e, 0xffa9, 0x06bf, 0x0b29,
0xfafb, 0x0951, 0x01f4, 0x0df5, 0x16c7, 0x1e27, 0x3265, 0x3411, 0x3582, 0x2f04,
0x3aea, 0x31de, 0x3658, 0x2fd2, 0x2543, 0x21aa, 0x172d, 0x11bf, 0x1713, 0x0c66,
0x150a, 0x0c44, 0x169e, 0x1402, 0x1d61, 0x1ed5, 0x1892, 0x1ae7, 0x11fa, 0x1489,
0x1f0e, 0x24b1, 0x3146, 0x3430, 0x29aa, 0x2dad, 0x248b, 0x2cda, 0x20dd, 0x2db5,
0x2106, 0x2afc, 0x19b1, 0x20c4, 0x1326, 0x1cb6, 0x1b15, 0x250b, 0x28f6, 0x348e,
0x1ec8, 0x29b1, 0x34a8, 0x3666, 0x3e38, 0x3ba5, 0x22c1, 0x29a2, 0x33dc, 0x3faa,
0x474d, 0x4f24, 0x4b38, 0x5182, 0x422f, 0x48f3, 0x38ce, 0x3f9c, 0x3ccd, 0x410c,
0x3da7, 0x4564, 0x37e9, 0x45e5, 0x386e, 0x44eb, 0x4197, 0x4cd8, 0x4224, 0x54a7,
0x3d26, 0x4f9f, 0x326d, 0x3bfe, 0x3130, 0x3cd1, 0x33b3, 0x4496, 0x3dd8, 0x49e5,
0x37d0, 0x430c, 0x4152, 0x4b29, 0x4132, 0x4857, 0x3eac, 0x4b6c, 0x466d, 0x5733,
0x429e, 0x4f55, 0x519b, 0x5d5a, 0x5aac, 0x662c, 0x4f6a, 0x5a08, 0x3310, 0x4036,
0x36c9, 0x417d, 0x3dd9, 0x4a9a, 0x3b42, 0x4eac, 0x3aa6, 0x4893, 0x36b1, 0x405e,
0x3df2, 0x4e31, 0x32d1, 0x45f9, 0x2dc7, 0x4171, 0x39f0, 0x4d1b, 0x3933, 0x49e3,
0x2cf7, 0x3e4e, 0x3aa7, 0x42d4, 0x3ec1, 0x40b6, 0x3eff, 0x45e1, 0x2876, 0x36c5,
0x29d9, 0x38f4, 0x3cb3, 0x4643, 0x2e86, 0x396f, 0x20f5, 0x2e91, 0x20a4, 0x31cb,
0x28d9, 0x3f21, 0x24c3, 0x4158, 0x1e0b, 0x3ae5, 0x29a3, 0x4133, 0x2a19, 0x3a25,
0x2806, 0x3023, 0x23cd, 0x2e4b, 0x17d1, 0x29c7, 0x157c, 0x24a7, 0x2159, 0x29aa,
0x2136, 0x25cb, 0x1283, 0x1a47, 0x11a1, 0x1d04, 0x1a4c, 0x217f, 0x1c03, 0x2266,
0x165e, 0x1ee4, 0x1d42, 0x1cbd, 0x0724, 0x0347, 0xf580, 0xfe22, 0x0698, 0x1338,
0x0d7d, 0x15d6, 0x0243, 0x0b18, 0xf83c, 0x0644, 0xf6b7, 0x050b, 0xfbe3, 0x07b3,
0xf9e3, 0x0237, 0xf06e, 0xf956, 0xf03a, 0xfd2f, 0xf705, 0x0822, 0xf5db, 0x057f,
0xeb64, 0xf325, 0xeb66, 0xf07a, 0xec5f, 0xedb1, 0xf197, 0xf01e, 0xf1a3, 0xf252,
0xec69, 0xeacf, 0xeeaa, 0xf0a5, 0xf138, 0xf748, 0xead5, 0xec50, 0xe5ca, 0xe994,
0xdf79, 0xea6c, 0xdd6f, 0xe649, 0xe0d7, 0xe6ee, 0xdcfc, 0xe4e0, 0xdace, 0xdd9a,
0xdcbe, 0xdd93, 0xe162, 0xe095, 0xe611, 0xd98f, 0xe06b, 0xd156, 0xe195, 0xd935,
0xe371, 0xe1cf, 0xd0e8, 0xd310, 0xc6fb, 0xc925, 0xc7a8, 0xcba6, 0xd3bb, 0xd707,
0xe09c, 0xdd0b, 0xd27f, 0xd46b, 0xc581, 0xd531, 0xca4b, 0xd36a, 0xcca8, 0xc5d8,
0xc453, 0xc13b, 0xca62, 0xcab1, 0xc985, 0xc3b7, 0xc462, 0xbf56, 0xc530, 0xc440,
0xcba2, 0xcb8d, 0xc8a1, 0xc3a0, 0xc670, 0xc347, 0xca31, 0xce5f, 0xcee2, 0xcc97,
0xd851, 0xd4bf, 0xc60d, 0xd1a3, 0xcf32, 0xdc5f, 0xce56, 0xd3c0, 0xd23f, 0xd6d3,
0xd011, 0xd455, 0xc24b, 0xc4c8, 0xc4d4, 0xc88b, 0xc2e2, 0xc4ea, 0xc482, 0xc719,
0xc0d2, 0xc410, 0xc7a9, 0xc8bf, 0xc352, 0xc5fa, 0xc5f0, 0xc528, 0xd5fa, 0xd452,
0xd3ab, 0xdc0d, 0xce47, 0xcb48, 0xd19e, 0xc33b, 0xdc14, 0xd3ff, 0xdb0a, 0xd8f9,
0xd49e, 0xd610, 0xcc09, 0xd1cb, 0xd25a, 0xdaba, 0xda9d, 0xe5af, 0xd310, 0xe02c,
0xcba9, 0xdf69, 0xc910, 0xe60b, 0xd706, 0xeddf, 0xdd46, 0xe9f9, 0xdb0e, 0xdfea,
0xe83f, 0xedf4, 0xecbd, 0xef3c, 0xe436, 0xe2d7, 0xe7fa, 0xea53, 0xef2d, 0xf113,
0xf595, 0xf580, 0xec92, 0xee80, 0xeb41, 0xecdd, 0xf94f, 0xf1ba, 0xfdf7, 0xf134,
0xf3f3, 0xf352, 0xf350, 0xfbc5, 0xfc13, 0x05d8, 0xecf3, 0xf672, 0xeea7, 0xf763,
0xfa77, 0x03d4, 0xfad8, 0x077b, 0xfb9a, 0x0dc6, 0xfa3a, 0x09ed, 0x0564, 0x115b,
0x08d1, 0x19a4, 0x0889, 0x1a10, 0x1319, 0x1c11, 0x0ec1, 0x18f4, 0x12ac, 0x207d,
0x20a4, 0x252d, 0x1f09, 0x1fcb, 0x10b5, 0x1a93, 0x1788, 0x21ca, 0x1ace, 0x1df3,
0x1992, 0x1b6d, 0x1ade, 0x216a, 0x22c6, 0x2ce8, 0x230d, 0x2786, 0x18cb, 0x20d4,
0x1864, 0x228b, 0x2d3f, 0x2811, 0x30b4, 0x2e3e, 0x1ab4, 0x2591, 0x2597, 0x2ae2,
0x236e, 0x2a29, 0x2c51, 0x3dbd, 0x2cfc, 0x3e40, 0x2e01, 0x3d7c, 0x3486, 0x4569,
0x3106, 0x3e94, 0x2d43, 0x35ee, 0x3b8c, 0x4544, 0x3d94, 0x4947, 0x3152, 0x3d9f,
0x2959, 0x34f5, 0x23be, 0x2d56, 0x2c52, 0x314c, 0x3335, 0x379c, 0x357b, 0x421a,
0x2a44, 0x3d23, 0x28c3, 0x371c, 0x2aa9, 0x3978, 0x29ff, 0x3a22, 0x2397, 0x318e,
0x2dbd, 0x3b89, 0x2905, 0x3830, 0x25d6, 0x336f, 0x3384, 0x388b, 0x3aba, 0x3b9d,
0x3cac, 0x3d72, 0x3b08, 0x3b0e, 0x372c, 0x3e20, 0x325c, 0x3e4a, 0x340d, 0x3c96,
0x3996, 0x3db3, 0x3795, 0x3b73, 0x2f3b, 0x399b, 0x2c91, 0x3be1, 0x3014, 0x3c9b,
0x398a, 0x458f, 0x3515, 0x426e, 0x2ecf, 0x3afa, 0x3091, 0x3a9d, 0x35bd, 0x3f0a,
0x37f1, 0x4528, 0x2fff, 0x3f9c, 0x26df, 0x2f33, 0x26ef, 0x2c62, 0x1c63, 0x2cb3,
0x0888, 0x21e2, 0x0189, 0x187a, 0x05b2, 0x1868, 0x10ca, 0x23c0, 0x1a2b, 0x2a36,
0x14dc, 0x1f70, 0x0327, 0x0802, 0xec9c, 0xf2ad, 0xf0fd, 0xfe9a, 0x08e2, 0x133e,
0x121b, 0x1811, 0x29a3, 0x2ce5, 0x41fd, 0x4350, 0x4510, 0x47d2, 0x3995, 0x3aa6,
0x38db, 0x37fe, 0x2a21, 0x2477, 0x2765, 0x1ebe, 0x1966, 0x1b7b, 0x125e, 0x1608,
0x17c4, 0x0d3f, 0x12c8, 0x0b7e, 0x004c, 0x0483, 0xfb5d, 0xfb70, 0x0bf8, 0x0908,
0x0467, 0x06d7, 0xfd9a, 0x06ed, 0xf72e, 0x0621, 0xe2a8, 0xf0d6, 0xe7b0, 0xf201,
0xf8fd, 0x03a9, 0xff39, 0x017b, 0xf0bb, 0xf223, 0xe8df, 0xf580, 0xe00b, 0xf31e,
0xefa3, 0xff31, 0xf20b, 0x0532, 0xdd12, 0xf3f3, 0xd8f1, 0xee26, 0xcd1b, 0xe431,
0xa286, 0xb993, 0xa546, 0xba08, 0xc920, 0xdc21, 0xd169, 0xdff1, 0xcea8, 0xd681,
0xde4a, 0xe4f6, 0xe966, 0xf3b0, 0xcfc8, 0xe3b9, 0xc913, 0xe188, 0xd145, 0xe467,
0xdd1e, 0xec76, 0xc212, 0xcb42, 0xbe78, 0xbdb2, 0xd47f, 0xd173, 0xdf78, 0xdd86,
0xda42, 0xd356, 0xdd88, 0xd677, 0xec07, 0xebad, 0xda11, 0xd6a8, 0xd26e, 0xc6aa,
0xe0ae, 0xd77d, 0xd28b, 0xcd48, 0xb83f, 0xb002, 0xbac5, 0xb39d, 0xbc56, 0xb94a,
0xad2c, 0xaa14, 0x9beb, 0x9839, 0x8ad1, 0x88f4, 0x9488, 0x970e, 0xb18c, 0xb7ac,
0xb5fb, 0xbe43, 0xab7d, 0xb05e, 0xbfc5, 0xc67a, 0xcbdc, 0xde77, 0xb60f, 0xc169,
0xad6e, 0xac6d, 0xb649, 0xbee8, 0xb65e, 0xc4b8, 0xb20b, 0xba54, 0xcaeb, 0xd501,
0xda18, 0xe72c, 0xd226, 0xdaf4, 0xd15f, 0xd7d9, 0xbd85, 0xc63f, 0x9d99, 0xa7b1,
0xb443, 0xba6b, 0xd7ef, 0xddac, 0xd443, 0xd8d1, 0xd02c, 0xce79, 0xce78, 0xcd4e,
0xd59e, 0xd68e, 0xd5ab, 0xd4ef, 0xd690, 0xd93e, 0xbbe4, 0xc113, 0x957f, 0x9ac4,
0x8b11, 0x922e, 0x9c2e, 0xa404, 0x96e9, 0x9eda, 0x9e1d, 0x9f66, 0xb6ea, 0xb36a,
0xa147, 0xac7a, 0x823b, 0x90c0, 0x88f9, 0x871d, 0x972a, 0x9387, 0x952a, 0x9902,
0xb1f2, 0xb295, 0xccb1, 0xc923, 0xd21b, 0xcc78, 0xc5b1, 0xbe24, 0xb23f, 0xab66,
0xabd1, 0xa2fd, 0xd5e6, 0xd3c9, 0x0542, 0x0719, 0x019f, 0xfed6, 0xf521, 0xf383,
0xf1c4, 0xf014, 0xeff5, 0xe931, 0xd8cd, 0xd539, 0xbf2d, 0xbfc5, 0xc661, 0xc691,
0xc8e1, 0xc939, 0xec7b, 0xeba2, 0xf58f, 0xf5a6, 0xd80f, 0xdadd, 0xd67b, 0xd5cf,
0xcea5, 0xd0a3, 0xbc5f, 0xcac7, 0xccb9, 0xda41, 0xd4b2, 0xdaa5, 0xcd2f, 0xdca2,
0xd743, 0xecd0, 0xefae, 0x00b4, 0x0169, 0x1236, 0x0a5c, 0x1bad, 0x05c2, 0x14f6,
0xeb3b, 0xf787, 0xf11a, 0xfaed, 0xfaac, 0x012e, 0x0510, 0x04dd, 0xfe5a, 0xf9f3,
0x0bcb, 0x0d3d, 0x0eda, 0x1409, 0x0197, 0x01e0, 0xf9c4, 0xf3e8, 0xe573, 0xddc4,
0xe77f, 0xe1c4, 0xedbd, 0xeeea, 0xdc29, 0xe012, 0xe4f6, 0xe46e, 0xfe1b, 0xfad7,
0x0044, 0xfc21, 0xfdcd, 0xf6d6, 0xfd17, 0xec86, 0x1e8a, 0x04f0, 0x31f4, 0x2972,
0x18d5, 0x1a76, 0x1075, 0x0d7c, 0x1bab, 0x1a3f, 0x2eeb, 0x2bac, 0x44a2, 0x42c6,
0x3fee, 0x41c4, 0x36f7, 0x34de, 0x3a8b, 0x39af, 0x35b7, 0x380d, 0x2c67, 0x2af3,
0x2948, 0x2c6a, 0x097d, 0x1038, 0x079b, 0x042a, 0x13ab, 0x12a8, 0x0868, 0x0e8d,
0x1ad6, 0x1bd4, 0x17a2, 0x18a3, 0xf5ea, 0xfaf1, 0x0328, 0x06c4, 0x1a8a, 0x19df,
0x14e0, 0x1212, 0x1394, 0x1468, 0x1f9c, 0x2218, 0x333f, 0x32a1, 0x3e4e, 0x4500,
0x5853, 0x6511, 0x6ae3, 0x6c26, 0x589d, 0x568e, 0x3a59, 0x4093, 0x3521, 0x36f7,
0x4e9a, 0x4628, 0x5833, 0x4b86, 0x4483, 0x36e6, 0x3bd8, 0x2d53, 0x3228, 0x2220,
0x3375, 0x2725, 0x3091, 0x2530, 0x4732, 0x385b, 0x4189, 0x3669, 0x178c, 0x0d83,
0x289a, 0x1a80, 0x5ec7, 0x50b8, 0x6961, 0x5fef, 0x4987, 0x454d, 0x3ea1, 0x3d4e,
0x4c2a, 0x471d, 0x4e72, 0x4613, 0x303e, 0x2876, 0x321e, 0x250b, 0x33e6, 0x237b,
0x2202, 0x1334, 0x2c8d, 0x1df6, 0x4d16, 0x3946, 0x3d68, 0x271c, 0x3aba, 0x27b2,
0x5b5a, 0x4c05, 0x4367, 0x39fe, 0x3113, 0x2842, 0x367e, 0x2caa, 0x2a60, 0x22e8,
0x32bb, 0x29ce, 0x3fb7, 0x3469, 0x47bf, 0x380f, 0x4f39, 0x36ea, 0x4c17, 0x321b,
0x45ad, 0x322f, 0x4cae, 0x3a81, 0x4399, 0x2eda, 0x2dd9, 0x1c80, 0x4cc8, 0x3f75,
0x50c0, 0x3efc, 0x3491, 0x1dcd, 0x2cc9, 0x18c0, 0x267b, 0x14f3, 0x33eb, 0x2389,
0x4965, 0x3aa9, 0x4861, 0x390a, 0x4aae, 0x386b, 0x4482, 0x2e90, 0x2ec0, 0x1def,
0x28ce, 0x1dcb, 0x212e, 0x13dc, 0x171a, 0x061c, 0x17ae, 0x07f4, 0x2547, 0x157b,
0x2f1f, 0x1c0a, 0x3346, 0x1fcb, 0x2f6a, 0x1a82, 0x14ce, 0xfd09, 0x118c, 0xfdce,
0x2ff0, 0x1df7, 0x3b00, 0x2ae2, 0x2e1a, 0x2147, 0x2634, 0x18da, 0x157e, 0x0698,
0x1af9, 0x0e95, 0x23be, 0x1a6a, 0x1284, 0x0b20, 0x1101, 0x0c1b, 0x0fab, 0x082a,
0x1d77, 0x1072, 0x325e, 0x2145, 0x2bdc, 0x1cc3, 0x0907, 0xfed0, 0x07ba, 0xf8b9,
0x2230, 0x11d2, 0x274e, 0x1bbb, 0x19b8, 0x0d81, 0x1a6c, 0x0a08, 0x155e, 0x0740,
0xfd55, 0xf28c, 0xf989, 0xeb37, 0xe9b4, 0xd836, 0xd016, 0xc1cf, 0xdb48, 0xcff6,
0xedcb, 0xe1ae, 0xeaa0, 0xdfeb, 0xf277, 0xe88f, 0xe7f0, 0xdd24, 0xd8ff, 0xce8b,
0xf68f, 0xe9c9, 0x0ec5, 0xff6a, 0x1dc2, 0x0feb, 0x269f, 0x1a42, 0x181b, 0x0a2e,
0x0fe3, 0xff53, 0xf9b6, 0xe6bf, 0xf6cc, 0xe564, 0x0746, 0xf8ae, 0x0ed1, 0x001d,
0x0d75, 0xfc08, 0x048f, 0xf154, 0xe7a8, 0xd404, 0xe4bc, 0xd696, 0xf72c, 0xefdd,
0xf3f4, 0xecb4, 0xf4fc, 0xe6ed, 0xec9d, 0xdb8d, 0xd161, 0xc10f, 0xc895, 0xb6fb,
0xce8f, 0xbb13, 0xce10, 0xb90f, 0xddc5, 0xc389, 0xe970, 0xcb2c, 0xe6a1, 0xc96b,
0xdbb3, 0xc5f2, 0xdc20, 0xcb8f, 0xe839, 0xce9e, 0xea33, 0xcee1, 0xdcd8, 0xc594,
0xe8da, 0xceef, 0xfb53, 0xdf83, 0xf0c3, 0xd8c4, 0xdeb2, 0xca8d, 0xe3f3, 0xcfb5,
0xedab, 0xd858, 0xe972, 0xd75b, 0xed46, 0xd72f, 0xf9a4, 0xdf36, 0xefee, 0xdeb3,
0xe41b, 0xd5a1, 0xec88, 0xda8b, 0xe82d, 0xd562, 0xdab0, 0xc99f, 0xe140, 0xd115,
0xe6a4, 0xd25d, 0xe471, 0xcedb, 0xe51d, 0xcd9e, 0xd950, 0xbac2, 0xdcf6, 0xbed1,
0xf687, 0xe0ff, 0x0377, 0xeda8, 0x000a, 0xe89d, 0x0192, 0xee3a, 0xfc3c, 0xea2c,
0x02f9, 0xf07f, 0xfb2a, 0xe706, 0xf85f, 0xe0cd, 0xff6a, 0xe758, 0xf836, 0xe612,
0xfa9f, 0xf12f, 0xff7d, 0xf916, 0xdc8a, 0xd3af, 0xe5a7, 0xda78, 0x02fe, 0xe9aa,
0xf481, 0xcd5f, 0xe899, 0xc26f, 0xf11b, 0xcfdb, 0xed19, 0xcd58, 0xe596, 0xc6cb,
0xe8be, 0xce19, 0xf1b9, 0xd939, 0x0c3b, 0xf1f6, 0x001a, 0xe308, 0xf3d9, 0xd7c7,
0xf236, 0xd79e, 0xe884, 0xcdc7, 0xd426, 0xbe43, 0xcccf, 0xc5f8, 0xd065, 0xce28,
0xdfd9, 0xd20e, 0xe6a3, 0xcc66, 0xd2b9, 0xb4cd, 0xe7e4, 0xc7ba, 0x0509, 0xe420,
0x0bdf, 0xedc3, 0x0fd3, 0xf5cc, 0x2015, 0x0907, 0x11f7, 0xfc8a, 0xf08b, 0xe1e4,
0xea68, 0xe362, 0x02a5, 0xfb3d, 0x028b, 0xf953, 0x00c6, 0xf932, 0x0718, 0xfa32,
0xfbe2, 0xee2f, 0xe9a1, 0xe073, 0xede3, 0xe55e, 0xf8ea, 0xec66, 0xf3be, 0xe464,
0xfa6d, 0xe847, 0x141f, 0x0065, 0x1a57, 0x04c8, 0x2d51, 0x15ce, 0x2758, 0x1260,
0x20a0, 0x0f9f, 0x2e68, 0x1e20, 0x207c, 0x0ccd, 0x1abe, 0x054e, 0x13dd, 0x0278,
0x09a2, 0xfae9, 0xfea9, 0xf575, 0xf3e8, 0xf129, 0xf04a, 0xea4f, 0x0b1b, 0x01f0,
0x195c, 0x0f26, 0x1716, 0x0c23, 0x1919, 0x1153, 0x17d3, 0x0e62, 0x19f0, 0x0b32,
0x225e, 0x1165, 0x3547, 0x1f16, 0x47ea, 0x2f2d, 0x2790, 0x1342, 0x0671, 0xf148,
0x0b80, 0xeefa, 0x0ac9, 0xe9e7, 0x0ed8, 0xedf0, 0x11a4, 0xf7a5, 0x180e, 0x0509,
0x1e1d, 0x0c97, 0x2387, 0x0dce, 0x2ab5, 0x145b, 0x317e, 0x1d20, 0x1ceb, 0x0b47,
0x1286, 0x059d, 0x291a, 0x1c3a, 0x24fa, 0x15ad, 0x20f4, 0x14a8, 0x30a1, 0x287a,
0x34ca, 0x2f11, 0x3861, 0x31ca, 0x47fc, 0x3c54, 0x4889, 0x3db7, 0x3a2c, 0x34fc,
0x3775, 0x2f7e, 0x47c9, 0x3392, 0x482b, 0x31b7, 0x397c, 0x268b, 0x2d31, 0x1b44,
0x180e, 0x061d, 0x195d, 0x0716, 0x2e91, 0x21d2, 0x372d, 0x2a36, 0x3155, 0x1ce1,
0x30d7, 0x1f51, 0x3862, 0x281c, 0x1e76, 0x04c0, 0x084e, 0xf1d9, 0x0c77, 0xff14,
0x2fc0, 0x1f2f, 0x3f25, 0x2e78, 0x40a0, 0x32a3, 0x34fc, 0x2351, 0x2a1a, 0x1536,
0x3347, 0x1d7e, 0x37ee, 0x2239, 0x2763, 0x13a4, 0x1bfc, 0x0702, 0x1ee1, 0x099c,
0x21cf, 0x103c, 0x25d2, 0x17ab, 0x1f57, 0x17b0, 0x2abe, 0x24b6, 0x29c8, 0x208d,
0x1c75, 0x12a8, 0x2201, 0x1a44, 0x2988, 0x20b2, 0x189e, 0x0f1a, 0x0efc, 0x059b,
0x105f, 0x0693, 0x257a, 0x1cb1, 0x35c1, 0x29b5, 0x3073, 0x1bf8, 0x3335, 0x1ec8,
0x2840, 0x1ad1, 0x1aa6, 0x0f8b, 0x1074, 0x09a6, 0x021a, 0xfd34, 0xfc47, 0xf0a5,
0x0d2b, 0xfd8d, 0x2064, 0x0d1d, 0x2076, 0x0775, 0x2810, 0x0f15, 0x35a1, 0x1f8b,
0x2a83, 0x1785, 0x1aea, 0x0cdb, 0x176a, 0x0a82, 0x0ca1, 0xfad0, 0x0756, 0xf4f0,
0x08d0, 0xf9b6, 0x110c, 0x00d7, 0x1a0d, 0x03c5, 0x1aca, 0x0534, 0x210e, 0x0da3,
0x1bd6, 0x06d7, 0x1b6e, 0x0559, 0x1674, 0xff1d, 0x021e, 0xedc0, 0xf931, 0xe17d,
0xf0eb, 0xd31b, 0xf749, 0xde01, 0x0d12, 0xf71d, 0x0d47, 0xfb91, 0x153a, 0x0850,
0x113f, 0x0333, 0xffe4, 0xecd7, 0x0236, 0xee82, 0x092d, 0xfa78, 0xff96, 0xf5d4,
0xf662, 0xf84f, 0xeba7, 0xf5e7, 0xe1d0, 0xe623, 0xe45c, 0xe1fc, 0xec58, 0xe8c3,
0xfddf, 0xfcbc, 0xff22, 0xfcad, 0xedc7, 0xebf9, 0xe2aa, 0xe039, 0xe260, 0xe0df,
0xe8ae, 0xe7a4, 0x0264, 0xfef7, 0x04ee, 0x0197, 0xef2c, 0xeae6, 0xe0a0, 0xdf56,
0xe3ed, 0xe89e, 0xf1b0, 0xec97, 0xf0a0, 0xe497, 0xe90a, 0xe28b, 0xe0bf, 0xdda0,
0xdc5a, 0xdd52, 0xd5e5, 0xd77b, 0xd8d0, 0xd9b7, 0xf5b5, 0xf610, 0xef21, 0xeabf,
0xd302, 0xcb65, 0xd9ce, 0xd0fb, 0xe649, 0xdfb5, 0xe227, 0xdfc7, 0xdd2a, 0xd965,
0xde54, 0xd983, 0xe0b7, 0xdcc1, 0xe0be, 0xdf41, 0xd7a5, 0xda47, 0xd6f0, 0xd9c0,
0xdae3, 0xdb4c, 0xe2d8, 0xe19c, 0xddec, 0xd8bd, 0xddfc, 0xd618, 0xd221, 0xce40,
0xc900, 0xc872, 0xd9a9, 0xdc29, 0xe665, 0xe8e8, 0xe25f, 0xd2de, 0xe0b1, 0xc38b,
0xea8e, 0xd94a, 0xeb68, 0xe443, 0xdd08, 0xd345, 0xc851, 0xc2f2, 0xbce0, 0xbae5,
0xc328, 0xc2ee, 0xbef6, 0xc25c, 0xc05e, 0xc5d8, 0xd3e2, 0xd63c, 0xded3, 0xd8e0,
0xd45e, 0xc9b1, 0xcb8f, 0xc4f3, 0xcec8, 0xc60e, 0xda22, 0xc8ba, 0xe16a, 0xd3dd,
0xca6c, 0xc52d, 0xb15c, 0xad81, 0xbe16, 0xb5f7, 0xd1fe, 0xc438, 0xcbae, 0xbb8f,
0xdf43, 0xcd6e, 0xf34d, 0xe0a8, 0xed62, 0xddde, 0xe6b2, 0xdc02, 0xe14b, 0xd925,
0xdc94, 0xd95e, 0xd146, 0xd01b, 0xbc1b, 0xba7b, 0xb0ef, 0xb052, 0xcec9, 0xcb12,
0xdcd2, 0xd40e, 0xd989, 0xd1a5, 0xe7ca, 0xe016, 0xe9d5, 0xdf32, 0xdcfa, 0xd0ba,
0xdd65, 0xcf88, 0xdfd1, 0xd596, 0xe0f9, 0xdd70, 0xe429, 0xde0c, 0xd71b, 0xcf5b,
0xcaeb, 0xc94c, 0xc90d, 0xca8b, 0xd118, 0xcbed, 0xdb38, 0xce0c, 0xe369, 0xd368,
0xe663, 0xd547, 0xe36b, 0xd217, 0xe52b, 0xd5f0, 0xe239, 0xd54c, 0xdfc9, 0xd955,
0xe429, 0xe162, 0xe960, 0xe5fe, 0xe58e, 0xe3a7, 0xdbf1, 0xe33d, 0xe24a, 0xef06,
0xea11, 0xf6fd, 0xe665, 0xf211, 0xd38a, 0xd903, 0xd295, 0xd32f, 0xd0ff, 0xd163,
0xceec, 0xd165, 0xc685, 0xc92f, 0xc456, 0xc010, 0xccd6, 0xc2a3, 0xd7d0, 0xce66,
0xe72c, 0xd81c, 0xea4d, 0xd961, 0xee8a, 0xe1f9, 0xf180, 0xe6b8, 0xef48, 0xe699,
0xe91b, 0xe367, 0xfa84, 0xf864, 0xfbda, 0xfd53, 0xf45c, 0xf88e, 0xea3a, 0xf238,
0xeb55, 0xf1f5, 0xf01e, 0xef01, 0xde55, 0xe015, 0xea10, 0xeeb0, 0xf6d0, 0xf9fd,
0xf864, 0xfaf4, 0x008e, 0xfc05, 0x021f, 0xf964, 0x03c9, 0xfcb4, 0x0b59, 0x0563,
0x04b1, 0xfff7, 0xfa07, 0xfaf6, 0xf4d4, 0xf9d2, 0xf681, 0xfb22, 0xfb32, 0xff15,
0xfe5f, 0xfb90, 0xf66f, 0xed91, 0xefd1, 0xee79, 0xf205, 0xf833, 0xf726, 0xfa49,
0xf960, 0xfb59, 0xf652, 0xfa1d, 0xf66c, 0xf823, 0xfb69, 0xfd7f, 0xfc34, 0x0189,
0xf73a, 0xfe70, 0xebe8, 0xf10d, 0xf803, 0xf5a7, 0xf9c7, 0xf745, 0xf920, 0xfa94,
0xff52, 0xf954, 0x0032, 0xf49c, 0x0765, 0x092c, 0x1c3f, 0x22c3, 0x1f9b, 0x205d,
0x1d16, 0x1dfb, 0x2746, 0x29d5, 0x2679, 0x2b2e, 0x278c, 0x2d1c, 0x2507, 0x2c13,
0x1cca, 0x26c3, 0x230e, 0x2a89, 0x2527, 0x2a3e, 0x156b, 0x2215, 0x1480, 0x24e1,
0x0f5a, 0x22bc, 0x06b5, 0x1e82, 0x09e2, 0x20fc, 0x15ef, 0x2a8d, 0x1482, 0x22c9,
0x14b5, 0x1d4c, 0x1d43, 0x23be, 0x1b24, 0x202e, 0x1665, 0x1b19, 0x20e8, 0x22d2,
0x28f4, 0x2929, 0x2898, 0x2dff, 0x3373, 0x3c57, 0x387b, 0x3d2c, 0x2b17, 0x32de,
0x1910, 0x2826, 0x2171, 0x2f2a, 0x3354, 0x3e82, 0x3259, 0x3cf5, 0x3a29, 0x494c,
0x42c9, 0x57a7, 0x3025, 0x46e0, 0x20c4, 0x3702, 0x2814, 0x3c31, 0x29ff, 0x3b99,
0x1dac, 0x343d, 0x154a, 0x2fd7, 0x15d8, 0x2853, 0x1de7, 0x2906, 0x1607, 0x2575,
0x1090, 0x220b, 0x0cfd, 0x21e1, 0x084b, 0x2470, 0x0445, 0x21eb, 0x1354, 0x28ac,
0x2880, 0x356f, 0x367c, 0x4213, 0x444e, 0x537a, 0x434f, 0x4f63, 0x4620, 0x512c,
0x3d24, 0x4711, 0x3e27, 0x4074, 0x4285, 0x415b, 0x3d7e, 0x441e, 0x4341, 0x5195,
0x4652, 0x58c1, 0x41a6, 0x56ca, 0x36e2, 0x4ca0, 0x3b3d, 0x50b9, 0x3f60, 0x520b,
0x48f7, 0x5eb8, 0x3f19, 0x59cc, 0x2b5d, 0x4130, 0x3134, 0x42a3, 0x3203, 0x49e6,
0x2f16, 0x46cf, 0x3b92, 0x4fb4, 0x32e8, 0x4591, 0x2961, 0x3b3c, 0x2c5f, 0x3eb0,
0x257a, 0x3756, 0x180b, 0x2da2, 0x0801, 0x2169, 0x11ad, 0x2abf, 0x0e9c, 0x2d8d,
0x151a, 0x36fe, 0x2423, 0x3be7, 0x1d56, 0x2e97, 0x1fb4, 0x31a8, 0x2aad, 0x374c,
0x22f1, 0x2f3e, 0x28dc, 0x38bd, 0x39f5, 0x4b7d, 0x358b, 0x4b93, 0x3f6e, 0x5706,
0x5289, 0x6bde, 0x52fa, 0x6dec, 0x554f, 0x6921, 0x64c5, 0x73a0, 0x4643, 0x577e,
0x2794, 0x3ad0, 0x284e, 0x3b29, 0x3c14, 0x50fe, 0x34f8, 0x4920, 0x23ff, 0x36d2,
0x1e3f, 0x30c1, 0x1c15, 0x2b65, 0x1e99, 0x2d30, 0x1721, 0x23ea, 0x10c2, 0x17ed,
0x0769, 0x11cc, 0x0c34, 0x1946, 0x103b, 0x200c, 0x0b6a, 0x2643, 0x07a0, 0x25cc,
0x0427, 0x2408, 0x0c53, 0x30d0, 0x1b48, 0x3e0d, 0x19aa, 0x3aaa, 0x2411, 0x44b9,
0x3258, 0x50d9, 0x2a6d, 0x46f9, 0x30e3, 0x45c1, 0x3f47, 0x4f1f, 0x3b83, 0x5148,
0x3536, 0x4b11, 0x245b, 0x376e, 0x1de7, 0x3163, 0x1859, 0x291f, 0x272d, 0x3245,
0x29a4, 0x353e, 0x1df0, 0x2b0c, 0x21bb, 0x2f75, 0x173a, 0x2766, 0x0900, 0x1ccd,
0xffa0, 0x19c2, 0x0a94, 0x24f5, 0x0c79, 0x24e2, 0x0b93, 0x2a49, 0x0ad5, 0x2913,
0x0c71, 0x24c8, 0x02e2, 0x1d1e, 0xfd11, 0x1a67, 0x018a, 0x20c5, 0x0076, 0x22a1,
0xfffc, 0x24fd, 0xf59f, 0x1a9c, 0xf69b, 0x161f, 0xf6ab, 0x0f29, 0xf658, 0x0a6e,
0xf543, 0x0677, 0xf561, 0x07b6, 0xf993, 0x0df6, 0x061e, 0x1848, 0x0263, 0x1730,
0x02bb, 0x1a2a, 0x040a, 0x1aba, 0x001e, 0x15b5, 0xfa52, 0x0c6e, 0x006b, 0x105f,
0x042d, 0x153f, 0xfa0b, 0x103e, 0xf774, 0x134d, 0xf6d3, 0x0e6e, 0xfcd4, 0x0e22,
0xfc2a, 0x0eb6, 0xfadb, 0x14c9, 0xf9b5, 0x1ab7, 0xe66f, 0x053b, 0xdf70, 0xf81e,
0xe8e1, 0xfe49, 0xef14, 0x02ec, 0xeb6a, 0x0297, 0xeed7, 0x0b00, 0xf2e3, 0x0fa7,
0xf517, 0x1323, 0xfb03, 0x184c, 0xf9d9, 0x13e3, 0xf413, 0x14f1, 0xe6b3, 0x0f27,
0xe5e6, 0x060a, 0xf86d, 0x106c, 0xf630, 0x1347, 0xe56d, 0x05ce, 0xe9b6, 0x0a14,
0xe445, 0x04eb, 0xd5ff, 0xf777, 0xd146, 0xefab, 0xcadb, 0xe5d1, 0xc9b7, 0xe1ec,
0xd4ae, 0xe58e, 0xdf31, 0xee99, 0xe0d6, 0xf394, 0xd7ea, 0xe771, 0xcac8, 0xdaf7,
0xc574, 0xddaf, 0xce3b, 0xe83d, 0xca71, 0xe4bf, 0xb9c1, 0xd7b4, 0xc1a9, 0xdf09,
0xb855, 0xd283, 0xb531, 0xcf35, 0xc5fc, 0xe290, 0xcf0b, 0xe7af, 0xcfe2, 0xdbd6,
0xd4d1, 0xddfe, 0xd366, 0xe425, 0xe31d, 0xf581, 0xefd7, 0x075d, 0xdd8a, 0xffc9,
0xca5e, 0xf1be, 0xc18b, 0xeb1a, 0xc7ca, 0xeeb1, 0xcaa5, 0xed6b, 0xcd09, 0xee05,
0xc9e4, 0xea99, 0xc716, 0xeb43, 0xcb42, 0xeeac, 0xd6c5, 0xee98, 0xd7e8, 0xe974,
0xd34f, 0xe4c3, 0xd2ad, 0xdfd5, 0xca7c, 0xdb36, 0xc04b, 0xd7c6, 0xc5e4, 0xda88,
0xc58a, 0xd80d, 0xc115, 0xd8ad, 0xc34d, 0xde8e, 0xbf24, 0xdb72, 0xc140, 0xddad,
0xc46a, 0xdf1f, 0xbdeb, 0xd6ab, 0xb820, 0xcdd2, 0xb009, 0xc652, 0xa80a, 0xc290,
0xaab6, 0xcd65, 0xb1b1, 0xd920, 0xb1c7, 0xd485, 0xb07a, 0xc9f2, 0xb781, 0xc92a,
0xbb6b, 0xc69d, 0xbbdf, 0xc500, 0xbcac, 0xc87c, 0xbcdc, 0xc59f, 0xb480, 0xb9db,
0xb47f, 0xbd8f, 0xaaa6, 0xb8fc, 0xa3b0, 0xb3e8, 0xacda, 0xc393, 0xa343, 0xbd05,
0xb16e, 0xc644, 0xbf40, 0xcfcf, 0xaed6, 0xbf3b, 0xaf9f, 0xc17b, 0xbd7a, 0xd0c5,
0xbe94, 0xd3cb, 0xbe8b, 0xdb74, 0xc73d, 0xe7ef, 0xd316, 0xedb4, 0xcf9d, 0xe33e,
0xc418, 0xd03f, 0xcbf1, 0xd6fe, 0xc8ad, 0xd49d, 0xca59, 0xd4fb, 0xc702, 0xd1f9,
0xc2f5, 0xd333, 0xc47c, 0xd769, 0xbe76, 0xd053, 0xc1e8, 0xd47b, 0xbf11, 0xd3c5,
0xc681, 0xd9ac, 0xc11e, 0xcf5f, 0xbeb1, 0xcd0c, 0xc2ca, 0xd0e1, 0xc235, 0xd266,
0xbd8e, 0xcfa0, 0xb924, 0xca26, 0xbc71, 0xd154, 0xb945, 0xd214, 0xbacd, 0xcfc4,
0xbf0c, 0xd25d, 0xc37d, 0xd9d5, 0xc5fe, 0xdb53, 0xcb8a, 0xda28, 0xc2e6, 0xce6a,
0xc133, 0xd557, 0xc6eb, 0xdf51, 0xd741, 0xe79d, 0xda8e, 0xeba1, 0xce68, 0xe51d,
0xc6f7, 0xde62, 0xc27f, 0xd86c, 0xc927, 0xde57, 0xc7de, 0xde26, 0xd07b, 0xe343,
0xcdfe, 0xd87b, 0xc0a8, 0xcae1, 0xbc27, 0xc9bc, 0xc380, 0xc987, 0xc9aa, 0xcb2a,
0xceab, 0xd638, 0xd00f, 0xddb7, 0xd715, 0xe719, 0xcca4, 0xddac, 0xc74a, 0xdd25,
0xcb75, 0xe573, 0xd335, 0xebe0, 0xd64a, 0xed34, 0xd426, 0xed8a, 0xe314, 0xf907,
0xe7de, 0xfa04, 0xe350, 0xf65a, 0xe943, 0xf2f7, 0xf5ad, 0xf6a2, 0xefab, 0xf51a,
0xe86c, 0xef29, 0xe5b8, 0xe879, 0xed16, 0xf189, 0xf42b, 0xfae2, 0xec19, 0xf1a6,
0xeeee, 0xf6d0, 0xf8d2, 0x06d4, 0xf2b1, 0x031b, 0xee4c, 0xfd43, 0xf084, 0xfea2,
0xebdb, 0xfb76, 0xe643, 0xf663, 0xe884, 0xfa39, 0xe9f9, 0xfff7, 0xe79d, 0xfd66,
0xeaf3, 0xfd13, 0xed97, 0xfd78, 0xeea5, 0xfc86, 0xe44b, 0xef37, 0xeeee, 0xf979,
0xfe0f, 0x0a3d, 0x027a, 0x0b66, 0xfa9d, 0xff57, 0xfa5b, 0x0508, 0xf85d, 0x0773,
0xf8b0, 0x0492, 0xfc7b, 0x077b, 0xfbc1, 0x083e, 0xf831, 0x044d, 0xeefa, 0xfad3,
0xf125, 0xff11, 0xfcf3, 0x0c2d, 0x0e3d, 0x1b07, 0x0d1e, 0x17a8, 0x0ae5, 0x1367,
0xfffc, 0x0895, 0x022e, 0x0c19, 0x102d, 0x161b, 0x17df, 0x18f7, 0x12fc, 0x15d1,
0x1598, 0x1b13, 0x14fe, 0x1726, 0x0705, 0x0887, 0x0317, 0x0c81, 0xfd11, 0x0fdc,
0xfb2d, 0x11a5, 0x020c, 0x161f, 0xf91f, 0x0d07, 0xf407, 0x0672, 0x0242, 0x1065,
0xf5a0, 0x03d0, 0xf723, 0x0757, 0x0377, 0x116e, 0x0d5e, 0x18a0, 0x1972, 0x21fe,
0x1f23, 0x23f6, 0x1dc4, 0x2192, 0x1619, 0x184f, 0x1a89, 0x1c78, 0x16d8, 0x17ab,
0x1c1e, 0x1cfe, 0x1436, 0x1ba3, 0x0f9d, 0x1696, 0x1efe, 0x1f23, 0x1b9b, 0x2030,
0x1fe5, 0x292b, 0x2365, 0x2a24, 0x25b1, 0x2cbe, 0x1352, 0x1bab, 0x0e60, 0x147f,
0x15e8, 0x1a7f, 0x202e, 0x275b, 0x20ce, 0x2ba9, 0x2176, 0x2e80, 0x26cb, 0x3422,
0x1408, 0x22ab, 0x1343, 0x2076, 0x1a7c, 0x21d5, 0x1645, 0x1b0a, 0x0fd5, 0x1769,
0x1268, 0x1c01, 0x143b, 0x195e, 0x1c1f, 0x1cb2, 0x211a, 0x1f88, 0x23bd, 0x2100,
0x25e9, 0x215f, 0x24e0, 0x1e81, 0x2b79, 0x26a4, 0x3048, 0x2da4, 0x2c86, 0x296b,
0x1d64, 0x2122, 0x1c1c, 0x2544, 0x1c76, 0x233e, 0x1d1a, 0x234e, 0x1f98, 0x28e2,
0x2365, 0x3207, 0x233e, 0x3376, 0x1975, 0x273f, 0x1352, 0x2041, 0x21a8, 0x2d24,
0x2bfa, 0x3496, 0x27c7, 0x2ea9, 0x21af, 0x24ba, 0x22d6, 0x23d6, 0x23f1, 0x27c4,
0x19c7, 0x2057, 0x1a9a, 0x20ea, 0x1fd1, 0x2471, 0x218a, 0x2390, 0x1f48, 0x2044,
0x265d, 0x275f, 0x2b41, 0x2d61, 0x1f0d, 0x2292, 0x21c7, 0x2693, 0x2bab, 0x3191,
0x3089, 0x376a, 0x2d9e, 0x34e4, 0x246a, 0x2eb7, 0x22db, 0x2f02, 0x21b8, 0x2d19,
0x272c, 0x363a, 0x330e, 0x4209, 0x30e1, 0x3c17, 0x23f2, 0x2e29, 0x26df, 0x3176,
0x2d5c, 0x39ca, 0x2915, 0x398f, 0x2984, 0x386f, 0x2ad9, 0x3acf, 0x253c, 0x3856,
0x1e19, 0x2ee3, 0x216a, 0x2c1c, 0x24e1, 0x2bdf, 0x21bd, 0x2809, 0x13b1, 0x1912,
0x1a80, 0x1de7, 0x2473, 0x24b9, 0x25f6, 0x23cd, 0x2f28, 0x2dae, 0x2e07, 0x2f19,
0x27be, 0x2722, 0x2121, 0x2402, 0x1cc1, 0x2841, 0x19f4, 0x23e7, 0x2074, 0x25d1,
0x1700, 0x2058, 0x1b1e, 0x26cf, 0x1f82, 0x2720, 0x1fb3, 0x24f1, 0x2523, 0x2948,
0x2b81, 0x30cd, 0x1c71, 0x2216, 0x14e0, 0x1ba2, 0x21e2, 0x291e, 0x2ecf, 0x3391,
0x3377, 0x3be0, 0x268e, 0x3404, 0x2be4, 0x37c6, 0x29df, 0x34a3, 0x2bee, 0x35c3,
0x2e64, 0x3626, 0x3211, 0x3517, 0x305b, 0x2fdb, 0x2ffe, 0x2e5f, 0x2551, 0x236a,
0x1db2, 0x1b98, 0x1652, 0x12c2, 0x185b, 0x134c, 0x221b, 0x19da, 0x1b1b, 0x14ce,
0x1cf0, 0x19a4, 0x1f1c, 0x1ab8, 0x22ee, 0x20aa, 0x1953, 0x194b, 0x155d, 0x13e0,
0x17ba, 0x13c2, 0x1751, 0x11a2, 0x1c27, 0x1467, 0x1ada, 0x153f, 0x0fa9, 0x0db3,
0x0c64, 0x0b99, 0x1443, 0x11ae, 0x15b6, 0x125a, 0x0a18, 0x0714, 0x14f2, 0x10b5,
0x195f, 0x14b6, 0x08fd, 0x05bb, 0x08c9, 0x0773, 0x16d9, 0x1561, 0x15ee, 0x1388,
0x1286, 0x0d8a, 0x1438, 0x0ae1, 0x1a8e, 0x0d6d, 0x1efa, 0x0ebe, 0x1a20, 0x0be3,
0x0f83, 0x07a3, 0x0a43, 0x06c0, 0x0be0, 0x0327, 0x1036, 0xfe69, 0x12c0, 0xff43,
0x1766, 0x045a, 0x221a, 0x0ec9, 0x24b4, 0x12a7, 0x10d9, 0x0088, 0x0bc4, 0xfc38,
0x132f, 0x0425, 0x14da, 0x06d4, 0x0b94, 0xfd07, 0x04a4, 0xf721, 0x0d94, 0x0450,
0x0cdb, 0x03ac, 0x1441, 0x04dc, 0x1d11, 0x0a67, 0x12ba, 0xff1e, 0x0841, 0xf2f5,
0x0366, 0xedab, 0x0ca6, 0xf804, 0x0c6f, 0xfa63, 0x0285, 0xf425, 0x00a4, 0xf5c7,
0x00b9, 0xfb2c, 0xfb95, 0xf661, 0xfa71, 0xf1f8, 0x03b2, 0x008a, 0xff9a, 0x00f8,
0x0458, 0xfe1c, 0x027c, 0xf780, 0xf7eb, 0xf077, 0xf88b, 0xf04b, 0xf51f, 0xe950,
0xeda5, 0xe215, 0xe7c2, 0xddf4, 0xee41, 0xe13d, 0xf07b, 0xdebe, 0xed51, 0xdeff,
0xea3c, 0xe065, 0xf4d3, 0xed4c, 0xf762, 0xf1b9, 0xee2e, 0xea9b, 0xec04, 0xea49,
0xf0db, 0xec70, 0xf580, 0xea93, 0xf0c8, 0xe2aa, 0xf301, 0xe7f5, 0xf74a, 0xee83,
0xfb12, 0xf184, 0xf122, 0xe54c, 0xf124, 0xe13a, 0xf7ce, 0xe29e, 0xfe31, 0xe7d6,
0x0413, 0xeb5a, 0x0c33, 0xeefc, 0x086e, 0xe97b, 0x0619, 0xe583, 0x04cc, 0xe44e,
0x0144, 0xe567, 0x0102, 0xeb1a, 0x049e, 0xf294, 0x0569, 0xf69c, 0xfe9a, 0xf4ce,
0x0354, 0xf9f2, 0xfa17, 0xee93, 0xf38c, 0xec5b, 0xea56, 0xe892, 0xe546, 0xe0de,
0xe297, 0xd994, 0xddae, 0xd536, 0xdef5, 0xd744, 0xd3ea, 0xca27, 0xd88c, 0xcd6c,
0xe7c2, 0xdc4e, 0xeecf, 0xe631, 0xe154, 0xda50, 0xd5b1, 0xc957, 0xda68, 0xca2a,
0xd5f1, 0xc7ba, 0xd901, 0xc9c9, 0xd437, 0xc77b, 0xd869, 0xcd43, 0xd4ad, 0xc478,
0xda7a, 0xcb35, 0xe330, 0xd665, 0xe6a7, 0xda8e, 0xedff, 0xe355, 0xe76a, 0xdec3,
0xe029, 0xd7f1, 0xe1c0, 0xdbb6, 0xeaad, 0xe3e6, 0xeeba, 0xe3e7, 0xf202, 0xe337,
0xefa0, 0xe18b, 0xefd1, 0xe9cd, 0xf30e, 0xf0d7, 0xef64, 0xe8ea, 0xea23, 0xdbb5,
0xeb1f, 0xd5ae, 0xec61, 0xd303, 0xe615, 0xcbe5, 0xe2e3, 0xcd77, 0xd914, 0xcbde,
0xdc7a, 0xccba, 0xe2e5, 0xcd93, 0xdd8b, 0xccaf, 0xda89, 0xc6cb, 0xd7e9, 0xbf0d,
0xe1e6, 0xcc24, 0xe544, 0xd20f, 0xde6c, 0xcd90, 0xdc0b, 0xce69, 0xe424, 0xd9bd,
0xdc37, 0xd418, 0xda7d, 0xcfbc, 0xe275, 0xd36a, 0xde60, 0xcdde, 0xdbf4, 0xc8d4,
0xd93c, 0xc21e, 0xd2f7, 0xb66f, 0xd64a, 0xb4a1, 0xde50, 0xbfac, 0xdb45, 0xc647,
0xd7c7, 0xc82f, 0xdeea, 0xd070, 0xe78f, 0xda6e, 0xdea7, 0xd0fe, 0xe1df, 0xd346,
0xe234, 0xd204, 0xd5ce, 0xc77a, 0xcf41, 0xc66a, 0xd5a1, 0xcd31, 0xe3b4, 0xdf4d,
0xe38d, 0xe3d9, 0xe587, 0xe02b, 0xe3b6, 0xd8d3, 0xe8c5, 0xd963, 0xea9b, 0xd630,
0xeb22, 0xd8c0, 0xecb2, 0xdcae, 0xee67, 0xdce8, 0xedb6, 0xdb95, 0xee85, 0xdc40,
0xeaec, 0xda98, 0xeaa7, 0xdad1, 0xf172, 0xdd83, 0xf5ac, 0xdf5a, 0xefc9, 0xda36,
0xe970, 0xd149, 0xebda, 0xd5a2, 0xe9db, 0xd667, 0xe6cf, 0xd217, 0xf115, 0xdb2e,
0xf700, 0xe221, 0xec30, 0xd702, 0xe864, 0xd058, 0xf46a, 0xda30, 0xf804, 0xdee3,
0xf40e, 0xdc39, 0xe770, 0xceef, 0xe6bf, 0xceb5, 0xe55c, 0xccad, 0xde2d, 0xcad2,
0xdc5c, 0xce93, 0xdeba, 0xd118, 0xdefa, 0xcf0f, 0xddfb, 0xcda9, 0xe445, 0xd547,
0xe697, 0xd91e, 0xe9e6, 0xde97, 0xecbc, 0xe09d, 0xece7, 0xdddd, 0xea65, 0xdeb4,
0xee73, 0xe52c, 0xf586, 0xe60c, 0xfa2c, 0xe6b5, 0xf5c4, 0xe161, 0xfcef, 0xe802,
0xfdb4, 0xeaee, 0x0470, 0xf1ad, 0x024e, 0xef69, 0x00ba, 0xed59, 0x02a7, 0xee29,
0xf5f3, 0xe616, 0xf5ae, 0xe91a, 0xf65d, 0xe3e6, 0xf99b, 0xe4a0, 0x017d, 0xec0f,
0x02e9, 0xe80b, 0xfae4, 0xe3be, 0xf2e4, 0xe59f, 0xfda6, 0xf439, 0x0416, 0xf9ed,
0xf9a8, 0xf245, 0xf31f, 0xeba7, 0xf311, 0xe51b, 0xfe46, 0xee58, 0x01e4, 0xf591,
0xfc73, 0xeec2, 0xf9a8, 0xeb73, 0xfecb, 0xf14a, 0x004f, 0xee6a, 0x0346, 0xee74,
0xffdb, 0xebd4, 0x0573, 0xf1db, 0x0777, 0xf52c, 0x084d, 0xf6af, 0x0c5b, 0xfa3e,
0x0e6f, 0xfe1a, 0x0f54, 0x0157, 0x0762, 0xfeaf, 0x0bc5, 0x07ad, 0x0ca6, 0x067b,
0x1134, 0x069f, 0x0f04, 0x0565, 0x0fea, 0x0586, 0x09e0, 0xfd6f, 0x079c, 0xfd83,
0x0c7d, 0x01c0, 0x14a1, 0x06d7, 0x0d94, 0x00e0, 0x0aff, 0x00ca, 0x1169, 0x079c,
0x08e5, 0x00af, 0x0b77, 0x000a, 0x1589, 0x0454, 0x1480, 0x03fd, 0x0739, 0xf850,
0x0ff4, 0x0116, 0x116b, 0x054c, 0x1583, 0x08ff, 0x10e8, 0x0254, 0x0878, 0xfb2c,
0x0eda, 0x0201, 0x1982, 0x0e42, 0x161e, 0x0c24, 0x0c9b, 0x00ae, 0x108c, 0x0233,
0x160c, 0x0659, 0x2400, 0x10f8, 0x1fb4, 0x0ce7, 0x1736, 0x0c00, 0x1b5e, 0x15fc,
0x1f33, 0x1bc5, 0x20e3, 0x1c52, 0x1a2c, 0x1482, 0x1f54, 0x1830, 0x2664, 0x1cb4,
0x2411, 0x19d3, 0x1a3b, 0x0f44, 0x19e8, 0x10f4, 0x1de1, 0x193d, 0x19b7, 0x1343,
0x16db, 0x0d57, 0x21ce, 0x1a17, 0x2882, 0x210e, 0x1b12, 0x1359, 0x20e2, 0x1a19,
0x253d, 0x1bcf, 0x244d, 0x16eb, 0x22cc, 0x16c4, 0x1f82, 0x1902, 0x1806, 0x11e0,
0x1e8e, 0x19e0, 0x16a6, 0x1936, 0x1939, 0x189d, 0x20c4, 0x1432, 0x2a3c, 0x1996,
0x321c, 0x20aa, 0x2d8f, 0x1aac, 0x2511, 0x11e9, 0x2311, 0x0ed6, 0x2b52, 0x178f,
0x2aa4, 0x1c0b, 0x2d10, 0x23ea, 0x1fcd, 0x1b41, 0x1f40, 0x1d98, 0x2016, 0x1b95,
0x1f18, 0x19a0, 0x227c, 0x1dd6, 0x236a, 0x1959, 0x3336, 0x2485, 0x344b, 0x26e7,
0x2b43, 0x1d2a, 0x2d30, 0x207d, 0x2de8, 0x255b, 0x2cd4, 0x264c, 0x2b64, 0x2815,
0x2a15, 0x2858, 0x3419, 0x302f, 0x3687, 0x368e, 0x3270, 0x3242, 0x3ffb, 0x381e,
0x4404, 0x378b, 0x426f, 0x3487, 0x3b65, 0x2d29, 0x3346, 0x2523, 0x3923, 0x2964,
0x3c58, 0x2d85, 0x3057, 0x2543, 0x2b9a, 0x2073, 0x311a, 0x2731, 0x2a7c, 0x23c6,
0x27b6, 0x24fc, 0x22ea, 0x2216, 0x1de8, 0x1a50, 0x1f70, 0x1a30, 0x1a8a, 0x14f4,
0x1c4a, 0x1138, 0x21a2, 0x1270, 0x2439, 0x122b, 0x226b, 0x1118, 0x29b7, 0x1a8b,
0x28a8, 0x18f9, 0x27f6, 0x1911, 0x2747, 0x18f3, 0x2c4d, 0x1c24, 0x2938, 0x18f5,
0x2813, 0x1ab5, 0x2db0, 0x2157, 0x3227, 0x2359, 0x31de, 0x2138, 0x2d8e, 0x2160,
0x33e1, 0x2c29, 0x2a61, 0x2485, 0x2999, 0x2463, 0x30f3, 0x2b3a, 0x356d, 0x2f2e,
0x376e, 0x3084, 0x3347, 0x2b34, 0x2e53, 0x2615, 0x2c91, 0x2412, 0x33e2, 0x2808,
0x3a52, 0x2e30, 0x3017, 0x2777, 0x2a91, 0x21cd, 0x2783, 0x1d79, 0x1d74, 0x1405,
0x1c14, 0x129d, 0x1bd0, 0x127a, 0x1fe5, 0x17d6, 0x1ac8, 0x1110, 0x1952, 0x0bc2,
0x1b7b, 0x0b76, 0x1cd6, 0x0c4a, 0x1ef9, 0x1172, 0x1f6a, 0x1472, 0x1fad, 0x1238,
0x1be2, 0x0dc4, 0x1864, 0x0e67, 0x145d, 0x0d9a, 0x1e3d, 0x17f3, 0x23af, 0x1e26,
0x23e5, 0x1f67, 0x1d4f, 0x18d2, 0x1d5d, 0x19a0, 0x1cd9, 0x1577, 0x1edf, 0x1374,
0x1a9a, 0x11e3, 0x0c05, 0x087c, 0x0f91, 0x0d9b, 0x1359, 0x1069, 0x1046, 0x09c1,
0x0f31, 0x0546, 0x10d5, 0x05d7, 0x0df5, 0x0266, 0x1267, 0x0753, 0x1931, 0x0eae,
0x1abf, 0x0fba, 0x1c4e, 0x1144, 0x1fab, 0x1745, 0x1b26, 0x14f6, 0x0fec, 0x09c6,
0x0888, 0x05e9, 0x0c19, 0x099a, 0x0eef, 0x07aa, 0x1277, 0x0945, 0x1871, 0x0eb6,
0x1a68, 0x0f46, 0x1c1f, 0x0f18, 0x1bcc, 0x0e92, 0x1664, 0x0b5c, 0x10a3, 0x0528,
0x0b00, 0x0054, 0x117d, 0x0ac7, 0x0bfb, 0x0358, 0x0621, 0xfb7a, 0x05de, 0x01dc,
0x0a33, 0x0bf4, 0x0b47, 0x0c26, 0x0af5, 0x098b, 0x09e8, 0x068d, 0x0054, 0xfb3d,
0x032a, 0xfea6, 0x0361, 0x01aa, 0x08b6, 0x07c8, 0x0893, 0x051f, 0x02dd, 0xfe01,
0x057c, 0x010d, 0x0b47, 0x03a0, 0x0b6e, 0x009f, 0x0151, 0xfa17, 0xff31, 0xfdbe,
0xfeb8, 0xfdde, 0x01da, 0xfe0a, 0x046e, 0xfe85, 0x00da, 0xf8d1, 0x02bf, 0xf95d,
0xffa0, 0xf747, 0xf73e, 0xf109, 0xede3, 0xe8e3, 0xf720, 0xec96, 0xfabc, 0xeba9,
0xf0f8, 0xe715, 0xe534, 0xdec9, 0xea38, 0xe354, 0xf06b, 0xec12, 0xea91, 0xe83b,
0xec45, 0xea28, 0xe966, 0xe80c, 0xe8ba, 0xe8dd, 0xef90, 0xf12d, 0xf7cb, 0xf6f1,
0xf4bf, 0xf0c8, 0xf2b1, 0xefc5, 0xeb39, 0xea36, 0xefb3, 0xef3d, 0xed1f, 0xec68,
0xecdb, 0xe9d8, 0xf1f0, 0xeb23, 0xf733, 0xefc1, 0xf4ec, 0xef01, 0xf758, 0xf291,
0xfebf, 0xf8fb, 0xf7fa, 0xf1a2, 0xf744, 0xf0e1, 0xf641, 0xecae, 0xf409, 0xe461,
0xf45e, 0xe6d8, 0xf63e, 0xee1b, 0xe4c1, 0xe1fd, 0xde27, 0xe098, 0xde2f, 0xdfdb,
0xe32e, 0xe2d5, 0xe22c, 0xe1c4, 0xde54, 0xdc49, 0xe0d8, 0xdad7, 0xdb59, 0xd333,
0xdb78, 0xd41a, 0xdebc, 0xd83b, 0xe64e, 0xdd2d, 0xeaca, 0xdf24, 0xde6a, 0xd922,
0xdc44, 0xdd7a, 0xde4d, 0xe018, 0xdc09, 0xde03, 0xda8e, 0xdd33, 0xe47c, 0xe779,
0xe8ab, 0xe8af, 0xe524, 0xe0a7, 0xe6c8, 0xe06c, 0xe429, 0xdfa8, 0xe55f, 0xe467,
0xe343, 0xe58c, 0xe1c0, 0xe53a, 0xe440, 0xe898, 0xe3c7, 0xea02, 0xdf17, 0xe5b2,
0xdea6, 0xe4db, 0xe014, 0xe3fb, 0xddb4, 0xdc73, 0xdf7e, 0xd97b, 0xe6bb, 0xe146,
0xddf9, 0xd991, 0xdc4f, 0xd587, 0xd2f9, 0xcdae, 0xcfd0, 0xcde6, 0xda67, 0xd669,
0xd9be, 0xd765, 0xd54e, 0xd8ac, 0xd39f, 0xd53d, 0xdd7a, 0xdbfe, 0xda9d, 0xda87,
0xd478, 0xd58d, 0xd6b4, 0xd9b2, 0xda22, 0xde95, 0xd483, 0xd93a, 0xd181, 0xd86d,
0xcf6c, 0xd711, 0xcd99, 0xd542, 0xcdb6, 0xd69a, 0xcbf1, 0xd46d, 0xd101, 0xd6fc,
0xd971, 0xdbd8, 0xdcf8, 0xdd6c, 0xdcfe, 0xda1a, 0xdd6d, 0xd5f2, 0xdd94, 0xd23f,
0xd545, 0xccfb, 0xd1a8, 0xd010, 0xd7f8, 0xd514, 0xd65f, 0xce98, 0xd537, 0xce16,
0xd7e5, 0xcfb8, 0xd164, 0xc800, 0xd586, 0xcf04, 0xd38b, 0xd009, 0xd3c1, 0xd0a0,
0xdd97, 0xdb1e, 0xd683, 0xd739, 0xd04e, 0xd4b5, 0xd1f2, 0xda8e, 0xdc86, 0xe6fc,
0xd47b, 0xdbe0, 0xcdc3, 0xd08a, 0xc66a, 0xca08, 0xcecb, 0xd6cb, 0xdc03, 0xe32b,
0xd8a8, 0xdf52, 0xd62a, 0xe057, 0xd9ec, 0xe47f, 0xde75, 0xe548, 0xd844, 0xde00,
0xdd16, 0xe41c, 0xd602, 0xdd8a, 0xd643, 0xddc4, 0xd6a5, 0xdc01, 0xdecd, 0xe016,
0xdd4f, 0xd945, 0xd9fd, 0xd3c1, 0xdda1, 0xdb60, 0xdab5, 0xdc98, 0xd851, 0xd866,
0xd509, 0xd3d5, 0xd6d8, 0xd4cd, 0xd79a, 0xd3d5, 0xd995, 0xd6fc, 0xda0b, 0xd7a8,
0xdc6b, 0xd969, 0xde3c, 0xdb84, 0xe094, 0xdf4a, 0xe385, 0xe39b, 0xe4f1, 0xe37e,
0xdf16, 0xe04a, 0xddb7, 0xe341, 0xe1c2, 0xe71d, 0xe35c, 0xe734, 0xe815, 0xead6,
0xe6b4, 0xe932, 0xedb3, 0xf1b9, 0xf058, 0xf506, 0xec75, 0xef52, 0xe6ba, 0xe8c7,
0xe475, 0xe818, 0xebf0, 0xf304, 0xef64, 0xf8cd, 0xe76f, 0xee2b, 0xe1a2, 0xe6c2,
0xe1df, 0xec08, 0xda9c, 0xea95, 0xdc61, 0xeebf, 0xd9d4, 0xe9f8, 0xdb7b, 0xe874,
0xe169, 0xea96, 0xe7c5, 0xee7d, 0xe7d3, 0xecff, 0xed4d, 0xf008, 0xf956, 0xfc13,
0xed05, 0xf0c7, 0xe800, 0xebdb, 0xe978, 0xee23, 0xed45, 0xf0a0, 0xf569, 0xf5e7,
0xf37f, 0xf278, 0xf0fa, 0xeeaa, 0xef6d, 0xecec, 0xf339, 0xf29b, 0xf7c3, 0xf8e1,
0xf275, 0xf472, 0xee57, 0xf275, 0xef5e, 0xf61d, 0xf386, 0xfac6, 0xf1b8, 0xf7c9,
0xeee2, 0xf6bb, 0xed0d, 0xf96b, 0xedba, 0xf8d7, 0xf19e, 0xf880, 0xf4a3, 0xfcff,
0xf8d8, 0x0113, 0xfcfd, 0x0387, 0xfd0d, 0x03f9, 0xfff2, 0x089f, 0x0568, 0x1039,
0x02e6, 0x0bf7, 0x02d2, 0x07c0, 0x0bcb, 0x0c41, 0x053a, 0xfe2e, 0x00b4, 0xf81f,
0xfa7a, 0xfa2c, 0xf543, 0xf87b, 0xf8a0, 0xfc2d, 0xfbf9, 0x01d8, 0x034c, 0x082e,
0x0006, 0x0679, 0x00bf, 0x0cab, 0x0313, 0x0ebe, 0x096e, 0x129e, 0x065d, 0x0dad,
0x07a2, 0x0cd7, 0x0998, 0x0d16, 0x06f4, 0x09e1, 0x07fe, 0x0bb1, 0x0302, 0x0744,
0x0afa, 0x0d9f, 0x0abc, 0x101c, 0x09f2, 0x10dc, 0x115f, 0x159b, 0x189c, 0x1b87,
0x1ccd, 0x1fda, 0x1abc, 0x1f6e, 0x17c2, 0x1e21, 0x19fb, 0x20f7, 0x1bd2, 0x27ad,
0x1a88, 0x29d8, 0x1c1c, 0x278b, 0x1b03, 0x241b, 0x18f7, 0x2114, 0x15d2, 0x1c45,
0x15d2, 0x1c72, 0x185d, 0x2004, 0x138a, 0x1ccc, 0x0a78, 0x1530, 0x0a2e, 0x12a8,
0x142d, 0x1992, 0x1448, 0x189c, 0x111d, 0x1435, 0x0fbe, 0x0d8b, 0x1fff, 0x1a0a,
0x27e7, 0x2512, 0x228a, 0x21dd, 0x1ddc, 0x1bb8, 0x1ae1, 0x1b3b, 0x1dcb, 0x22aa,
0x21d1, 0x2716, 0x1f13, 0x22f2, 0x1aeb, 0x1d73, 0x25a0, 0x267b, 0x21cc, 0x23b0,
0x1b5b, 0x2046, 0x1a56, 0x21fe, 0x1f92, 0x28e1, 0x1c4b, 0x254a, 0x1a99, 0x2445,
0x1a7b, 0x25f6, 0x2435, 0x2d80, 0x232c, 0x2d44, 0x1d91, 0x2a01, 0x2414, 0x2ee0,
0x29bc, 0x34ed, 0x2dcd, 0x3a21, 0x2fc8, 0x39da, 0x34e1, 0x3db0, 0x316c, 0x3bff,
0x2575, 0x33ca, 0x29c5, 0x36c3, 0x31fe, 0x3857, 0x2cb8, 0x2f68, 0x316e, 0x31b6,
0x3bf7, 0x3a37, 0x326d, 0x3145, 0x2bbd, 0x2999, 0x2f55, 0x2cda, 0x312e, 0x31e4,
0x350d, 0x3697, 0x3157, 0x31db, 0x2c9f, 0x2eb1, 0x308c, 0x33c8, 0x354a, 0x397b,
0x3919, 0x3c09, 0x2f86, 0x30fb, 0x23f9, 0x2725, 0x2c6f, 0x3099, 0x313e, 0x37d6,
0x2ab9, 0x3509, 0x2914, 0x31eb, 0x3205, 0x3440, 0x2f7d, 0x2e90, 0x29d1, 0x291f,
0x3071, 0x3063, 0x2de0, 0x3096, 0x312f, 0x3622, 0x333f, 0x3512, 0x3888, 0x358c,
0x3f08, 0x3b36, 0x3ada, 0x34cb, 0x3d1e, 0x3775, 0x3f82, 0x3ca4, 0x39d5, 0x3709,
0x32b7, 0x30a2, 0x2aa6, 0x2b81, 0x2b38, 0x2f6c, 0x2fab, 0x345a, 0x36ac, 0x3b18,
0x3927, 0x3f36, 0x3206, 0x3bf6, 0x3701, 0x3eac, 0x3966, 0x3ae3, 0x39ac, 0x383c,
0x37e8, 0x3311, 0x381d, 0x31da, 0x3866, 0x3573, 0x3998, 0x3be6, 0x3832, 0x3d29,
0x32c3, 0x3968, 0x3843, 0x3fbc, 0x3aff, 0x3e9c, 0x398e, 0x3809, 0x3197, 0x2de2,
0x345c, 0x2f76, 0x3e67, 0x372c, 0x37a6, 0x3337, 0x2f9e, 0x2f00, 0x2b5d, 0x2b3a,
0x34fe, 0x3585, 0x35b6, 0x3953, 0x332b, 0x38fb, 0x2c86, 0x31a8, 0x3416, 0x387c,
0x3777, 0x399c, 0x390e, 0x38e8, 0x3935, 0x3a74, 0x355c, 0x3842, 0x34c5, 0x3853,
0x2818, 0x2d67, 0x28cc, 0x2e7f, 0x2881, 0x2ec2, 0x2e91, 0x3538, 0x30f3, 0x34f1,
0x34e1, 0x3843, 0x37e1, 0x3ace, 0x343e, 0x33c6, 0x3580, 0x31f0, 0x33e2, 0x2e33,
0x3314, 0x2b55, 0x3262, 0x2bb6, 0x3055, 0x2bfd, 0x2c32, 0x2d64, 0x2915, 0x3252,
0x2c4b, 0x3635, 0x2da4, 0x33ff, 0x2fc6, 0x33ef, 0x2bbb, 0x2e11, 0x2a4e, 0x2b72,
0x28d5, 0x29de, 0x2ad2, 0x2e54, 0x2505, 0x2b87, 0x1e31, 0x2540, 0x1ffc, 0x2a98,
0x1b22, 0x2964, 0x1e3e, 0x2778, 0x1e6f, 0x2547, 0x1c3b, 0x2344, 0x223d, 0x244a,
0x20a6, 0x2247, 0x1f80, 0x2419, 0x23ed, 0x28a6, 0x26d4, 0x2c28, 0x21f7, 0x2566,
0x1f16, 0x212e, 0x22bf, 0x2716, 0x18fa, 0x1b9a, 0x1bf2, 0x1ca4, 0x1f3d, 0x2468,
0x1dc5, 0x2611, 0x1d8f, 0x25cf, 0x156c, 0x1c8f, 0x1317, 0x1789, 0x10b0, 0x12f8,
0x19ea, 0x1d44, 0x18cc, 0x1f2d, 0x0ea3, 0x18ef, 0x0e82, 0x19d3, 0x0edb, 0x187e,
0x121b, 0x1b16, 0x0f8d, 0x164a, 0x0f9a, 0x14ac, 0x0ce0, 0x13ad, 0x0995, 0x0fc4,
0x0f27, 0x128a, 0x1728, 0x1b00, 0x1927, 0x1c04, 0x1843, 0x1864, 0x151d, 0x14d0,
0x1ae7, 0x1a7e, 0x1b9d, 0x1e3e, 0x143e, 0x1c28, 0x0ea8, 0x1642, 0x0c4a, 0x12b0,
0x114e, 0x1795, 0x113b, 0x150d, 0x0b42, 0x0dfa, 0x0523, 0x0673, 0x0718, 0x0887,
0x0cbb, 0x0fb4, 0x0998, 0x0aee, 0x0650, 0x0686, 0x0502, 0x08ab, 0xfc98, 0x02a6,
0xfbeb, 0x00ea, 0x035a, 0x06ed, 0xff82, 0x04d0, 0xfe89, 0x06dc, 0xfb9c, 0x02fe,
0xfd10, 0x0472, 0xf940, 0x02f5, 0xfbf3, 0x06e7, 0xf7db, 0x041d, 0xf864, 0x049b,
0xfa67, 0x0343, 0xf9e7, 0x01bc, 0xf59c, 0xfd68, 0xfc43, 0x0224, 0xfb20, 0x003d,
0xf6d4, 0xfcb8, 0xfd4a, 0x0398, 0xfa8a, 0x021c, 0xf89c, 0x01dc, 0xf22d, 0xfe80,
0xee01, 0xffd8, 0xed6e, 0x00ce, 0xf0c5, 0x0282, 0xec05, 0xfc4b, 0xf05e, 0xffef,
0xf565, 0x04cc, 0xeb09, 0xf83d, 0xe917, 0xf3f4, 0xe979, 0xf267, 0xf068, 0xf42a,
0xf0aa, 0xf1d9, 0xe7a6, 0xedae, 0xe554, 0xee17, 0xe527, 0xeb43, 0xeae3, 0xf05a,
0xe623, 0xedc5, 0xe50d, 0xec01, 0xe368, 0xe755, 0xe881, 0xeb9f, 0xea6b, 0xebdd,
0xe812, 0xea17, 0xe3e1, 0xe9e8, 0xe7bd, 0xedc5, 0xea34, 0xef8d, 0xe337, 0xebba,
0xe104, 0xea5a, 0xe719, 0xed55, 0xee55, 0xf266, 0xe7e5, 0xeaa6, 0xeba7, 0xef28,
0xe760, 0xee15, 0xdfd7, 0xeb33, 0xdf26, 0xed67, 0xe488, 0xef1d, 0xde24, 0xe60e,
0xd5c7, 0xe419, 0xd535, 0xe50d, 0xd659, 0xe1d9, 0xd598, 0xe0b5, 0xda98, 0xe466,
0xdebd, 0xe4c4, 0xd64c, 0xdbc2, 0xd8d2, 0xde21, 0xd9f7, 0xdf05, 0xda9f, 0xde4a,
0xdaae, 0xd858, 0xd3ec, 0xd021, 0xd07c, 0xd354, 0xce27, 0xd8e7, 0xc71b, 0xd7ce,
0xc58d, 0xd665, 0xd0a0, 0xddfc, 0xd184, 0xe2c0, 0xcd13, 0xe235, 0xcd03, 0xdf1a,
0xcfc0, 0xde23, 0xd36c, 0xdcd9, 0xd445, 0xda02, 0xd2c6, 0xd908, 0xd6ec, 0xdc83,
0xd4a4, 0xdd22, 0xcfe6, 0xdd46, 0xd188, 0xdd6c, 0xcbf3, 0xd59e, 0xd04c, 0xda43,
0xd17f, 0xd804, 0xd00a, 0xd0b0, 0xd055, 0xd0e5, 0xd135, 0xd49b, 0xcea4, 0xd3c7,
0xc824, 0xce1d, 0xcf96, 0xd5f6, 0xce41, 0xd677, 0xca51, 0xd58d, 0xc5f8, 0xcfb5,
0xcda0, 0xd502, 0xcc0a, 0xd369, 0xc6ee, 0xcde1, 0xcc71, 0xd171, 0xcf48, 0xd263,
0xccc6, 0xcf7a, 0xca36, 0xcc2b, 0xd062, 0xd0f9, 0xcf9a, 0xd378, 0xcaa7, 0xd233,
0xc58d, 0xca59, 0xc9b6, 0xc94c, 0xd0c9, 0xcd04, 0xd489, 0xd089, 0xca99, 0xc7d8,
0xcca2, 0xc9b7, 0xce1b, 0xc849, 0xcf3b, 0xc8b1, 0xc94f, 0xc5eb, 0xcbff, 0xcbf9,
0xca32, 0xcb52, 0xc850, 0xcb31, 0xcd69, 0xd1dc, 0xc935, 0xcbb5, 0xccf9, 0xcde4,
0xca2f, 0xcddd, 0xcbb7, 0xd09c, 0xd0d4, 0xd3b8, 0xc789, 0xcbf2, 0xc48a, 0xc9d2,
0xc6f7, 0xcc1b, 0xcadf, 0xd321, 0xc635, 0xcde7, 0xc88e, 0xcc20, 0xc7a3, 0xca70,
0xc167, 0xc460, 0xc276, 0xc6c3, 0xc313, 0xcdfd, 0xbd60, 0xcb6c, 0xbf94, 0xc9cb,
0xcadc, 0xd15f, 0xcb82, 0xd1c6, 0xc7de, 0xcff3, 0xc57c, 0xcc57, 0xc242, 0xc729,
0xc3ac, 0xc757, 0xcad9, 0xc9c4, 0xcc0d, 0xc418, 0xcd4c, 0xc27a, 0xcafc, 0xc352,
0xcaf5, 0xc60e, 0xd4c2, 0xcfe9, 0xcdfd, 0xca56, 0xc006, 0xc0b1, 0xbeda, 0xc1ec,
0xc899, 0xc945, 0xcdec, 0xcc4c, 0xc730, 0xc901, 0xcacf, 0xd038, 0xd037, 0xd08e,
0xd281, 0xce9f, 0xccf5, 0xca16, 0xcd15, 0xccbf, 0xce86, 0xcdda, 0xca9c, 0xc8e0,
0xc9fa, 0xc804, 0xd2e6, 0xcf12, 0xe079, 0xdae4, 0xdde5, 0xde51, 0xd58f, 0xdc98,
0xd358, 0xd96b, 0xd538, 0xd794, 0xddcd, 0xdec0, 0xddce, 0xe089, 0xd494, 0xd99b,
0xd4bf, 0xda1e, 0xd704, 0xdb94, 0xda01, 0xdcd7, 0xd276, 0xd4b6, 0xceb7, 0xd261,
0xd5d5, 0xd652, 0xd5ef, 0xd3e3, 0xd0a7, 0xd03a, 0xced0, 0xccdd, 0xcf6e, 0xca7d,
0xcd2c, 0xc934, 0xcef3, 0xccb5, 0xcbbc, 0xca35, 0xce07, 0xccca, 0xd31f, 0xd113,
0xd217, 0xd0b0, 0xd3d2, 0xd429, 0xcffb, 0xd073, 0xd3e6, 0xd123, 0xdd84, 0xd501,
0xdebe, 0xd383, 0xdd95, 0xd34c, 0xde4d, 0xd7bb, 0xdfaf, 0xdc45, 0xe4e4, 0xde67,
0xe5b7, 0xdd91, 0xe62c, 0xdf51, 0xe911, 0xe219, 0xe64e, 0xe2a3, 0xdf8d, 0xe077,
0xddb6, 0xdf96, 0xe366, 0xe268, 0xe0af, 0xdab7, 0xe1a1, 0xdc7f, 0xe2a8, 0xe356,
0xe339, 0xe3fa, 0xe2a1, 0xde6b, 0xe181, 0xdcbc, 0xe5aa, 0xe206, 0xe651, 0xe0f9,
0xeb7b, 0xe48e, 0xec7b, 0xe5be, 0xec2c, 0xe5d5, 0xf0c4, 0xe7bb, 0xf479, 0xe61a,
0xf3bb, 0xe352, 0xf513, 0xe5ee, 0xef92, 0xe2eb, 0xef9b, 0xe5d8, 0xed17, 0xe61d,
0xeb6e, 0xe7a2, 0xebb6, 0xe5f1, 0xf0e5, 0xe750, 0xed96, 0xe44c, 0xf14c, 0xe7b3,
0xf36e, 0xe509, 0xf1a6, 0xde78, 0xf7e3, 0xe134, 0xf6af, 0xe30e, 0xf523, 0xe95e,
0xf67d, 0xef04, 0xf150, 0xeb98, 0xece5, 0xeabf, 0xf5e4, 0xf344, 0xf2f9, 0xf06b,
0xe8cc, 0xe881, 0xed8d, 0xeb1e, 0xf54d, 0xf071, 0xf6c9, 0xf0f0, 0xf618, 0xf03f,
0xf71f, 0xf51b, 0xf755, 0xf767, 0xfb47, 0xf986, 0xfecc, 0xfa43, 0xfd85, 0xf32e,
0xfa9f, 0xe9f1, 0x0055, 0xec8f, 0x09ca, 0xf4d4, 0x03c9, 0xf027, 0x0317, 0xf3ab,
0x06f5, 0xf607, 0x11bf, 0xf9a2, 0x1215, 0xf684, 0x0eb6, 0xf584, 0x0b26, 0xf6a7,
0x0b8e, 0xf8d3, 0x0e76, 0xfc2e, 0x08b9, 0xf8dd, 0x0c6b, 0xfd98, 0x0c14, 0xfa27,
0x0a66, 0xf681, 0x0b01, 0xfcb0, 0x07ee, 0x022d, 0x0b49, 0x09b1, 0x0ce2, 0x0ae3,
0x08d2, 0x0374, 0x0728, 0xfe5e, 0x0e6d, 0x04a8, 0x0bac, 0x0445, 0x0b91, 0x0423,
0x1025, 0x02ed, 0x1209, 0x04df, 0x1066, 0x07d6, 0x15b8, 0x0b19, 0x16cd, 0x08b9,
0x1267, 0x03a3, 0x1518, 0x0180, 0x15a3, 0xfe5b, 0x1118, 0xfd5c, 0x0dd2, 0xfdd1,
0x1307, 0x035b, 0x12cd, 0x07d1, 0x11b2, 0x0e2a, 0x0fc4, 0x10a9, 0x1380, 0x1413,
0x15af, 0x0d85, 0x1ad5, 0x07ab, 0x24dc, 0x0f68, 0x1e85, 0x0fbe, 0x1c03, 0x13b4,
0x16d5, 0x108d, 0x1d83, 0x151c, 0x202f, 0x13a7, 0x1f05, 0x1013, 0x1e0b, 0x0b51,
0x20b6, 0x09ad, 0x21e0, 0x0eda, 0x1feb, 0x1319, 0x2384, 0x146d, 0x1e5b, 0x0ea1,
0x1bee, 0x1196, 0x1e82, 0x1488, 0x2421, 0x179d, 0x2113, 0x1501, 0x1ad6, 0x0da3,
0x1990, 0x0983, 0x27b9, 0x14d6, 0x25fe, 0x0f11, 0x228c, 0x0aef, 0x276b, 0x12e6,
0x29ad, 0x1977, 0x2952, 0x1d1a, 0x1e3c, 0x160d, 0x194e, 0x13e2, 0x1eae, 0x18cf,
0x2426, 0x1cc2, 0x208b, 0x198c, 0x1a68, 0x1234, 0x202a, 0x12d2, 0x2e99, 0x1b95,
0x2d4c, 0x1915, 0x28a9, 0x16d4, 0x29bb, 0x189d, 0x30e6, 0x1f66, 0x2d59, 0x1d94,
0x28b8, 0x1cbd, 0x2c23, 0x2079, 0x2c2e, 0x1fe0, 0x2b37, 0x22ab, 0x274c, 0x2301,
0x24f4, 0x23d0, 0x288e, 0x29cb, 0x2ad6, 0x2d09, 0x294b, 0x2d8b, 0x22fe, 0x2958,
0x253b, 0x2b64, 0x22fa, 0x287a, 0x23bd, 0x28cc, 0x2508, 0x2648, 0x2860, 0x2547,
0x286e, 0x2250, 0x2617, 0x1a73, 0x2b70, 0x19d6, 0x34bb, 0x2100, 0x3554, 0x2193,
0x3512, 0x2069, 0x3764, 0x2470, 0x2fc1, 0x1f08, 0x307e, 0x1fea, 0x335a, 0x2427,
0x3642, 0x27d5, 0x36d7, 0x25bd, 0x32d5, 0x201c, 0x2f39, 0x1ef0, 0x2b17, 0x1ba2,
0x28ac, 0x1686, 0x2591, 0x13d8, 0x2c76, 0x1cbe, 0x3070, 0x1eb7, 0x319a, 0x1ef6,
0x313b, 0x227d, 0x32bf, 0x2646, 0x35cc, 0x2671, 0x3297, 0x249e, 0x3183, 0x27a5,
0x2fc0, 0x2630, 0x2ae3, 0x2397, 0x28e4, 0x25f9, 0x2c8a, 0x29cb, 0x2a5f, 0x247b,
0x2df4, 0x253c, 0x2a05, 0x240a, 0x2872, 0x298e, 0x2bee, 0x3039, 0x2d2d, 0x3171,
0x2c32, 0x2c8c, 0x2f89, 0x2908, 0x3293, 0x2993, 0x3317, 0x2b45, 0x3369, 0x2de3,
0x2893, 0x28dd, 0x2a12, 0x2ed6, 0x2d1d, 0x2fe5, 0x2e58, 0x2b12, 0x2e23, 0x2440,
0x2970, 0x1fa8, 0x28cd, 0x21dc, 0x28de, 0x200d, 0x2c85, 0x2284, 0x2d5d, 0x22fd,
0x3039, 0x224c, 0x3196, 0x21f7, 0x3489, 0x2612, 0x2cdf, 0x1ef0, 0x29f3, 0x1f2d,
0x2b19, 0x229c, 0x2a27, 0x212d, 0x31a0, 0x2879, 0x334c, 0x2603, 0x33e0, 0x21ac,
0x3243, 0x21b6, 0x2f0e, 0x1f96, 0x2bcd, 0x1a78, 0x29c5, 0x1bc9, 0x280b, 0x2029,
0x2556, 0x2142, 0x225e, 0x1fc6, 0x2725, 0x2478, 0x2a54, 0x25e2, 0x2744, 0x20a7,
0x22bb, 0x1d4d, 0x2332, 0x20f6, 0x27d9, 0x26a2, 0x213e, 0x23af, 0x1efd, 0x25cb,
0x214b, 0x2616, 0x258e, 0x260f, 0x284e, 0x2402, 0x2b6e, 0x22a4, 0x337b, 0x28d4,
0x31c2, 0x26bc, 0x2bf3, 0x2147, 0x26f2, 0x1cef, 0x2ad1, 0x1fd6, 0x2e40, 0x1f93,
0x28d9, 0x1b00, 0x272b, 0x1ce9, 0x261c, 0x1ec9, 0x22ed, 0x21a0, 0x2202, 0x26a7,
0x1df0, 0x2417, 0x1976, 0x1fd2, 0x182b, 0x213a, 0x1a3a, 0x2636, 0x1373, 0x1f63,
0x1146, 0x1c98, 0x0e4c, 0x16ef, 0x0f8b, 0x1456, 0x1430, 0x1af2, 0x0a50, 0x1684,
0x0a59, 0x17be, 0x0e22, 0x196a, 0x0fbc, 0x1618, 0x1822, 0x1753, 0x1bdc, 0x16ee,
0x1a3a, 0x158a, 0x1c77, 0x16c9, 0x235f, 0x1bbb, 0x2448, 0x1c5a, 0x1f3f, 0x15ba,
0x1f22, 0x12ef, 0x22dd, 0x17f1, 0x1e37, 0x1917, 0x12c8, 0x0f55, 0x0fec, 0x0a72,
0x12aa, 0x0c2e, 0x0f5b, 0x0bea, 0x0b71, 0x0b9b, 0x0d53, 0x0f2c, 0x0a5f, 0x0d3f,
0x09dd, 0x0ee3, 0x07a4, 0x112c, 0x0aeb, 0x1b07, 0x070b, 0x1aca, 0x0621, 0x16b3,
0x0b3d, 0x17bc, 0x0baf, 0x17ab, 0x100d, 0x1a42, 0x0c16, 0x1250, 0x095a, 0x0d1d,
0x0461, 0x08c8, 0x0553, 0x0b93, 0x024f, 0x06f1, 0x000e, 0x0003, 0x0356, 0xfc97,
0x053d, 0xfc56, 0x04e7, 0x01ca, 0x0203, 0x032c, 0x00cc, 0x03a7, 0x0342, 0x08f6,
0x052b, 0x0b54, 0xfec9, 0x043b, 0xfe06, 0x0686, 0x00d3, 0x0ed7, 0x04d4, 0x1507,
0xff45, 0x0e7b, 0xfb2a, 0x079a, 0xffc4, 0x0608, 0x05c3, 0x0909, 0xfdc0, 0x041f,
0xf889, 0xfeaa, 0xf9df, 0xfc09, 0xf918, 0xfa1f, 0xfafd, 0xfd5a, 0xf8d3, 0xfb9b,
0xf8be, 0xfcfd, 0xf822, 0xfd03, 0xf52b, 0xfa36, 0xf455, 0xfb2f, 0xf22b, 0xfb51,
0xf385, 0xfaf8, 0xefe6, 0xf445, 0xf21b, 0xf8c9, 0xed5f, 0xf829, 0xe9b4, 0xf642,
0xe7d8, 0xf79a, 0xe918, 0xfbd8, 0xefdc, 0xfbd0, 0xf314, 0xf6e7, 0xf2cf, 0xf75f,
0xf54f, 0xf98c, 0xf7a2, 0xfa84, 0xf54e, 0xfd15, 0xf69a, 0x00b8, 0xf6ee, 0x004e,
0xf554, 0x0030, 0xf86e, 0x012a, 0xfc75, 0xff76, 0xfb29, 0xfb10, 0xf6f5, 0xf5eb,
0xf2c3, 0xf12d, 0xf0e4, 0xed69, 0xeda4, 0xea9b, 0xe9ed, 0xe8ef, 0xe6cd, 0xe2d2,
0xe3eb, 0xde6b, 0xe27a, 0xe0af, 0xe28f, 0xe59b, 0xdcc4, 0xe593, 0xdc23, 0xe889,
0xde52, 0xec29, 0xda5d, 0xe993, 0xd350, 0xe240, 0xd402, 0xe132, 0xd8bd, 0xe40c,
0xdad0, 0xe48b, 0xda33, 0xe4b1, 0xdcf3, 0xe829, 0xdc4a, 0xe60b, 0xdc1d, 0xe5d5,
0xdecc, 0xeda1, 0xdb84, 0xefec, 0xd7ad, 0xeace, 0xdd60, 0xeb9e, 0xe1a4, 0xeb6a,
0xe1f5, 0xe8f9, 0xe131, 0xe6fd, 0xde34, 0xe3eb, 0xe415, 0xea90, 0xe465, 0xebe9,
0xe1e8, 0xea27, 0xd921, 0xe0fd, 0xd6b0, 0xdeb6, 0xddad, 0xe74d, 0xd8be, 0xe12c,
0xd63f, 0xd8ce, 0xda5f, 0xd73a, 0xdac4, 0xd610, 0xd71e, 0xd158, 0xd9b2, 0xd21d,
0xd62c, 0xd09f, 0xd43c, 0xd161, 0xd54e, 0xd221, 0xd307, 0xd127, 0xd4c2, 0xd608,
0xd6db, 0xdaf3, 0xd2da, 0xda11, 0xd5ad, 0xddb1, 0xd6e2, 0xe069, 0xd2f0, 0xe0a7,
0xd2d0, 0xe159, 0xd40a, 0xe363, 0xd23a, 0xe553, 0xcd2c, 0xe008, 0xceea, 0xe249,
0xd126, 0xe3e3, 0xd075, 0xdc6d, 0xd58d, 0xdd5e, 0xd4b2, 0xdd4d, 0xd9d7, 0xdede,
0xdb35, 0xdcdd, 0xd5d5, 0xda70, 0xd081, 0xd746, 0xd1a1, 0xd601, 0xd648, 0xd79c,
0xda5f, 0xd9ea, 0xd83b, 0xd7f6, 0xd5da, 0xd7eb, 0xde1f, 0xde2e, 0xe028, 0xdccc,
0xd6ac, 0xd5e7, 0xd06a, 0xd08c, 0xdae5, 0xd501, 0xd8b4, 0xccd6, 0xd6cd, 0xcda3,
0xd5c0, 0xd462, 0xcd36, 0xd21c, 0xcc6c, 0xd539, 0xca6a, 0xd75e, 0xc956, 0xd987,
0xc8a2, 0xd8bd, 0xc42e, 0xd280, 0xc378, 0xcf9c, 0xca58, 0xd4ee, 0xc8b0, 0xd32d,
0xc903, 0xd5e9, 0xc8d7, 0xd6a9, 0xcb12, 0xd799, 0xcd1c, 0xdb63, 0xc973, 0xd8cf,
0xcb40, 0xd5b9, 0xd0a3, 0xd5d4, 0xd392, 0xd6e3, 0xd691, 0xd7e4, 0xd37d, 0xd2a1,
0xcccb, 0xca9b, 0xd365, 0xd11a, 0xd916, 0xd567, 0xd630, 0xd3f0, 0xd658, 0xd3b3,
0xd519, 0xcee4, 0xd598, 0xcfea, 0xd7f7, 0xd454, 0xd6d2, 0xd013, 0xd355, 0xcadd,
0xcf24, 0xcbba, 0xceb3, 0xcf9f, 0xcdaf, 0xcf2e, 0xcbed, 0xce47, 0xcb6a, 0xd026,
0xd081, 0xd964, 0xd37f, 0xe0ae, 0xd834, 0xe4f9, 0xd47a, 0xdf2b, 0xd347, 0xde1d,
0xd0fe, 0xdb49, 0xd349, 0xdb69, 0xd747, 0xdcb4, 0xd938, 0xdcb1, 0xdae2, 0xddba,
0xdcee, 0xdec3, 0xdc4d, 0xde2b, 0xd8ba, 0xde16, 0xdf0c, 0xe48a, 0xe2ea, 0xe2ab,
0xdc4f, 0xdaa3, 0xd5df, 0xd9d1, 0xd18d, 0xd78d, 0xd4ae, 0xd86a, 0xdc4e, 0xdde2,
0xd610, 0xd6c1, 0xd659, 0xd6f2, 0xd9bd, 0xd87b, 0xda6e, 0xd58f, 0xdba4, 0xd60e,
0xd535, 0xd43e, 0xce5e, 0xd100, 0xcd2d, 0xce71, 0xd24d, 0xd28f, 0xd152, 0xd4cb,
0xceb6, 0xd406, 0xd0c5, 0xd3f3, 0xd111, 0xd5ab, 0xd4ae, 0xd819, 0xde86, 0xdae9,
0xe1db, 0xdbc2, 0xe16f, 0xde64, 0xe182, 0xe288, 0xda52, 0xe1b7, 0xd812, 0xe25a,
0xd41a, 0xdcd4, 0xd96e, 0xe336, 0xd8d9, 0xe6a0, 0xdb51, 0xe8d3, 0xdda1, 0xe690,
0xdc9e, 0xe60f, 0xddb2, 0xea93, 0xd70e, 0xe5b5, 0xda54, 0xe58c, 0xe112, 0xe645,
0xe6ee, 0xe847, 0xe2c0, 0xe06d, 0xe524, 0xe065, 0xe4f9, 0xe2c4, 0xe3cd, 0xe5b1,
0xe3c3, 0xe5fc, 0xe3c6, 0xe579, 0xe6e8, 0xe69d, 0xee75, 0xea5e, 0xf15a, 0xea42,
0xeec5, 0xe79c, 0xefe1, 0xec7a, 0xec7a, 0xecc8, 0xeed4, 0xeec8, 0xeda3, 0xedf8,
0xee9c, 0xf065, 0xebaf, 0xedd1, 0xea2b, 0xef1d, 0xe8ba, 0xf1dc, 0xe7bf, 0xf277,
0xe6f0, 0xf0cd, 0xea0d, 0xf220, 0xe9c5, 0xf0b1, 0xe292, 0xebbc, 0xe326, 0xf022,
0xe891, 0xf301, 0xe852, 0xedd2, 0xea12, 0xedd7, 0xeccd, 0xee2b, 0xf37e, 0xf2d6,
0xf5d9, 0xf7c3, 0xf066, 0xf4ee, 0xedec, 0xf3a9, 0xf70d, 0xff5c, 0xf53d, 0xfef2,
0xee42, 0xf871, 0xeb56, 0xf569, 0xe973, 0xf394, 0xed60, 0xfa0a, 0xec1b, 0xfc49,
0xec25, 0xfc3a, 0xec5c, 0xfd64, 0xec87, 0x0103, 0xecfa, 0x01f5, 0xf301, 0x07a5,
0xf33b, 0x0658, 0xf572, 0x03aa, 0xfa5d, 0x034a, 0xfa89, 0xffe3, 0xfab2, 0xfdda,
0xfd15, 0x01e0, 0xfe28, 0x064d, 0xfe3b, 0x051c, 0x03f2, 0x080f, 0x0628, 0x0934,
0x05a6, 0x0734, 0x050a, 0x05d8, 0x0787, 0x08ba, 0x05d3, 0x07f5, 0x031f, 0x06a9,
0x0821, 0x0b90, 0x015f, 0x0542, 0xffee, 0x05a2, 0x03ae, 0x05d5, 0x08a9, 0x075b,
0x05bf, 0x0484, 0x00f2, 0xfc24, 0x03c3, 0xfccd, 0x0b66, 0x057b, 0x0c77, 0x04db,
0x02ee, 0x0019, 0xfa5e, 0x0288, 0xfcdd, 0x0862, 0x0027, 0x0c34, 0x0146, 0x11da,
0xff15, 0x12db, 0xffd0, 0x14c4, 0xfff3, 0x1871, 0xf966, 0x13ef, 0x037f, 0x19c1,
0x0820, 0x1b77, 0x0609, 0x1dac, 0x0344, 0x1baf, 0x0510, 0x1602, 0x119c, 0x1972,
0x1470, 0x17f8, 0x1274, 0x1558, 0x16e3, 0x1a85, 0x1a86, 0x221a, 0x1500, 0x20cb,
0x1477, 0x1fde, 0x142b, 0x1da9, 0x1946, 0x230f, 0x1aa1, 0x25cf, 0x1bb3, 0x2768,
0x1988, 0x228f, 0x13d8, 0x1cc3, 0x1518, 0x1f7f, 0x1aba, 0x245a, 0x1bc8, 0x2397,
0x17c6, 0x1d13, 0x1ada, 0x1d7f, 0x1b7d, 0x1d48, 0x1ea2, 0x1e5e, 0x1c03, 0x19cb,
0x1b9a, 0x19ce, 0x1e00, 0x1e64, 0x1fd8, 0x20e2, 0x218e, 0x1dd7, 0x2129, 0x1960,
0x21be, 0x1b64, 0x1eba, 0x19d4, 0x2067, 0x1b1e, 0x20e1, 0x1cb4, 0x1c68, 0x1e1f,
0x19db, 0x22b2, 0x1e09, 0x27da, 0x1c2c, 0x262b, 0x19ab, 0x26f4, 0x1f7a, 0x2ec2,
0x1df2, 0x316f, 0x19a6, 0x32e4, 0x16dd, 0x30a7, 0x1aec, 0x3329, 0x1321, 0x2a7f,
0x1086, 0x2544, 0x15f8, 0x27ee, 0x1c6e, 0x28bd, 0x262e, 0x2bb4, 0x2742, 0x2b3e,
0x25be, 0x2a76, 0x241d, 0x2859, 0x2445, 0x26b1, 0x2a99, 0x2ac0, 0x3005, 0x2fce,
0x2d43, 0x2bcb, 0x2bc5, 0x2a59, 0x2b4e, 0x2fbb, 0x2af8, 0x3580, 0x293c, 0x3682,
0x261f, 0x3579, 0x2651, 0x35aa, 0x29eb, 0x36ee, 0x2f46, 0x3980, 0x3262, 0x3722,
0x3073, 0x336a, 0x2aed, 0x3288, 0x28fb, 0x34a4, 0x2eec, 0x3cdd, 0x2e0e, 0x3c3a,
0x2956, 0x368c, 0x27af, 0x334e, 0x2d7b, 0x346b, 0x2e10, 0x3506, 0x2d4d, 0x39e4,
0x29f1, 0x367f, 0x2ccd, 0x35a2, 0x3196, 0x36f5, 0x2ea1, 0x2efc, 0x2933, 0x25f6,
0x2d17, 0x2a73, 0x354e, 0x31cb, 0x31ed, 0x2a83, 0x334d, 0x2c07, 0x33f6, 0x3083,
0x3a1c, 0x38a8, 0x3968, 0x3a7d, 0x38aa, 0x3da5, 0x341a, 0x3ba5, 0x2f1a, 0x3a46,
0x31e1, 0x3f49, 0x2eb9, 0x3ba1, 0x2674, 0x339f, 0x270b, 0x364d, 0x2a0d, 0x3c17,
0x2b53, 0x3ffa, 0x2e4e, 0x4303, 0x2bfb, 0x3e93, 0x2eff, 0x40cb, 0x3044, 0x40f3,
0x327a, 0x3e7d, 0x354c, 0x3c48, 0x362c, 0x3a92, 0x325e, 0x340c, 0x35a6, 0x3746,
0x3aae, 0x3e0a, 0x3aa9, 0x3e46, 0x363f, 0x3bd6, 0x3331, 0x3d91, 0x33c1, 0x4098,
0x33c4, 0x401a, 0x3201, 0x3c30, 0x2f7f, 0x36f6, 0x2e69, 0x328e, 0x2c3a, 0x2d65,
0x2f23, 0x31cf, 0x3172, 0x352b, 0x3182, 0x3414, 0x2f9a, 0x3017, 0x320d, 0x31b9,
0x337c, 0x381d, 0x2cbe, 0x3500, 0x2fed, 0x3478, 0x3644, 0x3858, 0x315c, 0x3680,
0x2f9d, 0x34d5, 0x36e2, 0x39d9, 0x3d0a, 0x3f3d, 0x3b2c, 0x3e18, 0x3692, 0x3c0d,
0x33f9, 0x3a56, 0x3763, 0x3b7f, 0x3622, 0x3871, 0x3aa7, 0x3912, 0x3ce2, 0x37e2,
0x3cde, 0x3bc2, 0x3caa, 0x3baa, 0x3ce7, 0x36aa, 0x3dc6, 0x36f8, 0x3ae6, 0x35ce,
0x3c04, 0x398c, 0x3ba6, 0x3cd8, 0x3289, 0x357f, 0x2dd4, 0x3199, 0x3086, 0x368c,
0x3005, 0x3792, 0x29b5, 0x330f, 0x201d, 0x2b5e, 0x21a8, 0x2eec, 0x287a, 0x3895,
0x2b46, 0x3bb0, 0x24b3, 0x3548, 0x2380, 0x351a, 0x2a54, 0x3b03, 0x2dd7, 0x3b87,
0x309a, 0x3804, 0x3036, 0x317a, 0x2bb4, 0x2b4d, 0x301d, 0x31c8, 0x3028, 0x3996,
0x2f47, 0x3cb9, 0x2f0a, 0x34ea, 0x3678, 0x345d, 0x3c99, 0x357c, 0x3c7f, 0x3302,
0x362d, 0x2bf5, 0x330e, 0x259f, 0x34c7, 0x24e7, 0x3241, 0x2575, 0x345a, 0x2ad8,
0x2fe9, 0x2839, 0x2b1a, 0x2465, 0x28e2, 0x24e9, 0x2dd5, 0x2c7f, 0x2dc1, 0x2d77,
0x31a4, 0x302a, 0x30a4, 0x2c85, 0x346f, 0x30fb, 0x3143, 0x335b, 0x2de1, 0x319a,
0x31fd, 0x33e6, 0x2c3b, 0x2e8f, 0x2980, 0x2983, 0x2cdc, 0x2962, 0x33c3, 0x2dd4,
0x32f8, 0x2b6c, 0x2ccd, 0x25bd, 0x28a2, 0x204e, 0x2e0b, 0x21c1, 0x2e04, 0x2148,
0x2526, 0x1db4, 0x21d4, 0x224c, 0x24a7, 0x2977, 0x258f, 0x2b9e, 0x2007, 0x2a9c,
0x1aed, 0x28a4, 0x193b, 0x2449, 0x1dfd, 0x25de, 0x21f3, 0x27c2, 0x250e, 0x294f,
0x1f48, 0x2683, 0x1d8a, 0x27dc, 0x1eac, 0x2798, 0x1cf5, 0x226f, 0x228e, 0x2385,
0x220f, 0x2005, 0x1e0d, 0x1d4d, 0x1e2f, 0x1f0b, 0x1ea3, 0x1e35, 0x1db4, 0x1954,
0x2133, 0x19d9, 0x1dd5, 0x17eb, 0x1706, 0x1301, 0x1540, 0x12e5, 0x1578, 0x1378,
0x186f, 0x1266, 0x16f0, 0x0d18, 0x14eb, 0x0cbb, 0x159a, 0x104c, 0x1d58, 0x1891,
0x1d1f, 0x1857, 0x1cd9, 0x1630, 0x1e85, 0x168a, 0x2075, 0x1ae0, 0x1d00, 0x1b25,
0x176d, 0x17c1, 0x171a, 0x1978, 0x1aba, 0x1e41, 0x1852, 0x1b04, 0x1373, 0x14f9,
0x1189, 0x0fb5, 0x10ef, 0x0c1f, 0x12a9, 0x0d1b, 0x0f51, 0x0854, 0x10ad, 0x097d,
0x0acf, 0x04a0, 0x0c55, 0x0640, 0x0b52, 0x07dc, 0x0add, 0x0b98, 0x0c2e, 0x0e10,
0x0562, 0x0a79, 0x03d9, 0x0d56, 0x024f, 0x0c84, 0x01cf, 0x09ef, 0x0453, 0x0af2,
0x0424, 0x0914, 0x07bb, 0x0920, 0x0812, 0x07c8, 0x0a6f, 0x0940, 0x0cc1, 0x0a50,
0x0e52, 0x0dcb, 0x0e6b, 0x0e35, 0x0e19, 0x09f9, 0x0c7e, 0x079b, 0x0e0f, 0x0905,
0x0f84, 0x0657, 0x117d, 0x0500, 0x1081, 0x03bd, 0x0b3c, 0xfec8, 0x0583, 0xfc62,
0x050a, 0x0018, 0x0a41, 0x09fd, 0x0326, 0x0a2a, 0xfb20, 0x0605, 0xfb24, 0x02ee,
0xfec6, 0x03a7, 0xfd02, 0x034e, 0xf52f, 0xfbbe, 0xf25f, 0xf6fc, 0xf5a7, 0xfa10,
0xf4d5, 0xfb29, 0xefc9, 0xf8d0, 0xea30, 0xf37c, 0xe9cc, 0xee8a, 0xf24b, 0xf221,
0xf507, 0xf048, 0xee38, 0xe924, 0xeb1f, 0xeb7a, 0xed94, 0xee2e, 0xe994, 0xe879,
0xe6b7, 0xe6bf, 0xf0c7, 0xeaf8, 0xfa80, 0xecc8, 0xf6b9, 0xe9b3, 0xf4dc, 0xebb5,
0xf6c4, 0xf082, 0xf3b3, 0xf155, 0xf666, 0xf7d4, 0xf2f6, 0xf55a, 0xee90, 0xefdd,
0xeeb0, 0xed30, 0xf32c, 0xf0c7, 0xf6e3, 0xf635, 0xf417, 0xf151, 0xf531, 0xef7f,
0xf495, 0xf1cb, 0xf307, 0xf2dc, 0xf014, 0xebfd, 0xf4a0, 0xedf9, 0xf31a, 0xea96,
0xef56, 0xe49c, 0xee01, 0xe5e7, 0xeda3, 0xe84f, 0xec00, 0xe721, 0xea8d, 0xe58b,
0xeda3, 0xe71e, 0xeccd, 0xe80f, 0xe5ca, 0xe469, 0xe33b, 0xe289, 0xe4c9, 0xe9f5,
0xe00d, 0xeb5c, 0xdce8, 0xe539, 0xdc3d, 0xe213, 0xda91, 0xe28f, 0xdb6a, 0xe1dc,
0xe128, 0xe420, 0xd7a5, 0xda25, 0xd7a9, 0xda5d, 0xd9ba, 0xd99d, 0xde9c, 0xd9f4,
0xe4dd, 0xdec6, 0xdcf6, 0xd96a, 0xd5b2, 0xd42b, 0xd4ff, 0xd456, 0xd840, 0xd6ad,
0xd87c, 0xd5e3, 0xd34b, 0xd2b6, 0xd270, 0xcfa9, 0xdb70, 0xd0d3, 0xda28, 0xccd2,
0xd55b, 0xcb95, 0xd7ff, 0xcfde, 0xdc15, 0xd380, 0xdb17, 0xd27f, 0xdb2f, 0xd337,
0xda0d, 0xd629, 0xdff4, 0xdb9a, 0xe694, 0xdc1d, 0xe255, 0xd758, 0xdf04, 0xd8a1,
0xdecd, 0xdc14, 0xd9bf, 0xdc03, 0xd6db, 0xdd3d, 0xd6e1, 0xdc62, 0xde50, 0xe278,
0xdfa9, 0xe2a5, 0xe1e6, 0xdf56, 0xe5ca, 0xddae, 0xe247, 0xda49, 0xdff0, 0xd810,
0xddb6, 0xd640, 0xd6a9, 0xd3df, 0xd116, 0xcf33, 0xd7bf, 0xcee3, 0xdb7c, 0xcc36,
0xd75f, 0xc863, 0xd1c0, 0xc913, 0xd0bc, 0xcf94, 0xc5e7, 0xcc37, 0xbeb2, 0xccb2,
0xbeac, 0xcd1d, 0xc4bf, 0xcf98, 0xc930, 0xd523, 0xc876, 0xd3b7, 0xca32, 0xd0a2,
0xcb93, 0xcd91, 0xcfc4, 0xd060, 0xcb75, 0xce81, 0xc8a9, 0xcf25, 0xcc02, 0xced1,
0xcd72, 0xc7e4, 0xcfc3, 0xc5ae, 0xce4b, 0xc106, 0xd1a9, 0xc241, 0xcfa0, 0xc2ee,
0xceeb, 0xc3e3, 0xcadb, 0xbedb, 0xcaab, 0xc3b4, 0xcc56, 0xcb08, 0xccb2, 0xca88,
0xcbbc, 0xc680, 0xc91a, 0xc42c, 0xc8cd, 0xc350, 0xcdb9, 0xc6cc, 0xced7, 0xc9bf,
0xc8bd, 0xc845, 0xc7fd, 0xcdd4, 0xc85b, 0xd146, 0xcfc2, 0xd6af, 0xccfc, 0xd1bd,
0xc9ad, 0xd013, 0xca61, 0xd179, 0xcd67, 0xd2eb, 0xcba4, 0xd281, 0xc329, 0xccc1,
0xc675, 0xcc2e, 0xcf77, 0xcba1, 0xd715, 0xcdc7, 0xd5a8, 0xcd22, 0xd507, 0xcdaf,
0xd183, 0xca3c, 0xcf32, 0xc7dd, 0xcd44, 0xc6fc, 0xccf6, 0xc844, 0xcd2c, 0xc865,
0xcf6b, 0xcd37, 0xd0f3, 0xd1dd, 0xd0ee, 0xce63, 0xd0b6, 0xca6d, 0xcfcf, 0xcae3,
0xcf91, 0xcb4b, 0xcd5d, 0xca5c, 0xc7ae, 0xc9f9, 0xc3e9, 0xc9dd, 0xbf04, 0xc460,
0xbf2b, 0xc323, 0xc40a, 0xc466, 0xc6fd, 0xc50c, 0xc69d, 0xc689, 0xc240, 0xc2b3,
0xc602, 0xc6bf, 0xc769, 0xc938, 0xc790, 0xc85a, 0xc4e5, 0xc6a5, 0xc2a4, 0xc2e3,
0xca38, 0xc28a, 0xd4a3, 0xcb44, 0xca3a, 0xc81a, 0xc2d7, 0xc72f, 0xc82f, 0xcb99,
0xcea0, 0xcb5d, 0xd577, 0xcc8d, 0xd151, 0xc67a, 0xcf91, 0xc6ed, 0xd094, 0xcce5,
0xd348, 0xcf9a, 0xd09e, 0xc866, 0xcbac, 0xc273, 0xd11c, 0xca02, 0xd359, 0xcdf0,
0xd4e8, 0xcd20, 0xd5fc, 0xcb00, 0xd83c, 0xcb95, 0xdea3, 0xce62, 0xdc51, 0xca1a,
0xd960, 0xca50, 0xda31, 0xcb16, 0xd95c, 0xc977, 0xd53d, 0xcab1, 0xcf7f, 0xcaa8,
0xcdb3, 0xcdbf, 0xc9ff, 0xcd7b, 0xcb2c, 0xd17d, 0xc97d, 0xd25b, 0xc6d7, 0xcc03,
0xcd35, 0xcdfe, 0xd083, 0xd2fa, 0xd208, 0xd603, 0xce19, 0xd39a, 0xd029, 0xdc48,
0xd152, 0xe084, 0xd2af, 0xdd91, 0xd2e6, 0xd9b3, 0xd4b2, 0xdaf0, 0xd8ca, 0xdabc,
0xde66, 0xd96c, 0xdf24, 0xdcba, 0xd996, 0xdde4, 0xdafa, 0xdc3f, 0xdbdd, 0xd808,
0xda9b, 0xd9d7, 0xd885, 0xd8d5, 0xda07, 0xd6c5, 0xdde9, 0xd888, 0xdf81, 0xd78f,
0xda0c, 0xcfb0, 0xdad8, 0xcf20, 0xda47, 0xca3a, 0xdd9b, 0xc65a, 0xdfa7, 0xc2ff,
0xe13b, 0xc1ab, 0xe2bb, 0xc206, 0xde5d, 0xc403, 0xd4bc, 0xc42c, 0xd574, 0xc695,
0xdf0d, 0xd0b7, 0xdc6b, 0xd42e, 0xd8e1, 0xd30b, 0xdc08, 0xd566, 0xe1d3, 0xdd0b,
0xdf55, 0xdedc, 0xdffc, 0xe2c1, 0xe3e6, 0xe4eb, 0xe851, 0xea1c, 0xe572, 0xf060,
0xe7b8, 0xf314, 0xee60, 0xefca, 0xea4d, 0xeb7d, 0xe913, 0xef1e, 0xe838, 0xf041,
0xe384, 0xefad, 0xe16a, 0xe9a6, 0xe166, 0xe1f8, 0xe054, 0xe39b, 0xe39c, 0xe440,
0xeb42, 0xdf29, 0xed68, 0xdabf, 0xec8e, 0xd69c, 0xec67, 0xd217, 0xe9ce, 0xd536,
0xe799, 0xdff8, 0xe8a0, 0xe4f4, 0xea55, 0xe42f, 0xeb18, 0xe52f, 0xef7c, 0xe5b8,
0xf599, 0xe409, 0xf5ed, 0xe299, 0xf779, 0xe6c0, 0xf82b, 0xea95, 0xf768, 0xee75,
0xf887, 0xf145, 0xf6ea, 0xefde, 0xf662, 0xf3db, 0xf77a, 0xf620, 0xf535, 0xf15f,
0xf261, 0xf008, 0xf845, 0xf5c6, 0xfc2e, 0xf64f, 0xfb2d, 0xf54a, 0xf94a, 0xf668,
0xf623, 0xf98f, 0xf36b, 0xfd79, 0xf0ef, 0xfed1, 0xea86, 0xfbdc, 0xeb9e, 0xf994,
0xebea, 0xf149, 0xed5b, 0xf025, 0xec31, 0xef32, 0xeba5, 0xead3, 0xf4f9, 0xec73,
0x02a7, 0xf091, 0x011e, 0xee5f, 0xfb13, 0xed3d, 0x00b4, 0xf3dc, 0x0238, 0xf907,
0xfbad, 0xf48f, 0xf93b, 0xec19, 0x011d, 0xf1dd, 0x04fb, 0xf7cb, 0x048b, 0xf500,
0x067b, 0xf59b, 0x07b2, 0xf9eb, 0x073b, 0xfcb4, 0x09b3, 0x003f, 0x07ea, 0xfed4,
0x06cf, 0xff4d, 0x0275, 0xfd36, 0x0933, 0x04a8, 0x1154, 0x0bd7, 0x0dbe, 0x0633,
0x0af6, 0x0334, 0x0bed, 0x04b3, 0x116c, 0x0a85, 0x0642, 0x0260, 0x0402, 0x0266,
0x0940, 0x0561, 0x07bb, 0x003a, 0x0508, 0xfcd2, 0x0477, 0x0009, 0x00a9, 0xfdd2,
0x03dc, 0xfbe3, 0x0df1, 0x03a1, 0x108a, 0x06fb, 0x0c2a, 0x0099, 0x0c91, 0x00e6,
0x0eb0, 0x0331, 0x110a, 0x016b, 0x17a2, 0x04aa, 0x163e, 0x05a8, 0x13c9, 0x0874,
0x1163, 0x0a67, 0x11d7, 0x0d40, 0x1557, 0x12a4, 0x13b8, 0x110a, 0x1075, 0x0c17,
0x0d88, 0x09ac, 0x1100, 0x115a, 0x0ee6, 0x1331, 0x0a50, 0x0d9f, 0x0c93, 0x0b71,
0x1403, 0x0d3f, 0x1bc6, 0x13ed, 0x15f1, 0x1162, 0x1002, 0x0e25, 0x12df, 0x134d,
0x13bb, 0x162f, 0x1642, 0x1880, 0x19dd, 0x159b, 0x1e25, 0x1120, 0x20c3, 0x129d,
0x1b2f, 0x1336, 0x194f, 0x15fd, 0x18cd, 0x179f, 0x1aaf, 0x1978, 0x1be4, 0x1a16,
0x16cd, 0x154a, 0x15ec, 0x10ab, 0x1730, 0x0c79, 0x19ae, 0x0f16, 0x15de, 0x0b31,
0x1a84, 0x0acd, 0x1f93, 0x0b17, 0x1f77, 0x0d1a, 0x1eb0, 0x129a, 0x1f12, 0x151a,
0x211c, 0x17e3, 0x1e59, 0x18d5, 0x2074, 0x1dac, 0x2000, 0x1ef9, 0x1ff8, 0x1e0c,
0x1ff4, 0x19c6, 0x20d1, 0x1921, 0x2420, 0x1df1, 0x2342, 0x1c70, 0x2041, 0x180d,
0x1d27, 0x1704, 0x1dcc, 0x1d3d, 0x1912, 0x1f09, 0x1627, 0x1cd2, 0x169b, 0x1b2f,
0x1322, 0x1a63, 0x1245, 0x1b4a, 0x1258, 0x1b50, 0x1513, 0x1f93, 0x198d, 0x21e6,
0x1ca7, 0x21ca, 0x1d65, 0x2410, 0x235c, 0x2cbb, 0x28e1, 0x32bd, 0x2545, 0x2f17,
0x2507, 0x2e3e, 0x2ab8, 0x3072, 0x2d7e, 0x2f30, 0x2c36, 0x2cba, 0x2bdc, 0x2b5b,
0x2c9c, 0x28c5, 0x2bf0, 0x276e, 0x2b01, 0x27ab, 0x2b26, 0x24fc, 0x2dc8, 0x2654,
0x2c23, 0x2827, 0x2735, 0x22c6, 0x253d, 0x1f0f, 0x25d4, 0x1fba, 0x29a5, 0x1ede,
0x2d0b, 0x1d37, 0x2ac8, 0x1c1d, 0x2691, 0x1b21, 0x2490, 0x1d06, 0x29b1, 0x268a,
0x315d, 0x3148, 0x2bb3, 0x2fb9, 0x20ac, 0x29d7, 0x230c, 0x2d7a, 0x271a, 0x3084,
0x2e6f, 0x374f, 0x2f49, 0x34e7, 0x27f2, 0x2fcb, 0x21d1, 0x3321, 0x1dcb, 0x322f,
0x1e77, 0x3262, 0x1aed, 0x30fc, 0x1afd, 0x2e33, 0x1b1c, 0x2aa9, 0x1bbf, 0x29fb,
0x1d77, 0x27ee, 0x20b0, 0x2668, 0x2198, 0x235c, 0x2790, 0x24f8, 0x2d77, 0x28db,
0x2edb, 0x2986, 0x3098, 0x26f7, 0x3436, 0x278b, 0x3080, 0x260a, 0x2f34, 0x28fc,
0x337f, 0x318a, 0x2c67, 0x3168, 0x2df1, 0x39eb, 0x2af5, 0x3690, 0x2a92, 0x3212,
0x27e8, 0x2fd5, 0x2a75, 0x338e, 0x2a43, 0x32d2, 0x223f, 0x2ecc, 0x21c9, 0x302f,
0x2895, 0x30cd, 0x2de4, 0x315c, 0x2bb7, 0x303d, 0x28de, 0x3203, 0x2bb9, 0x3808,
0x2d9e, 0x3722, 0x28b0, 0x2ea4, 0x2c4f, 0x2f86, 0x3485, 0x35bf, 0x378d, 0x3890,
0x32e1, 0x2f52, 0x3287, 0x2a2e, 0x343f, 0x2cd6, 0x3548, 0x304a, 0x34c0, 0x317f,
0x2d87, 0x2c00, 0x293f, 0x29b7, 0x26e2, 0x2b6d, 0x2815, 0x2c00, 0x2bed, 0x2c6b,
0x2bcc, 0x2d1d, 0x2e44, 0x2f90, 0x2e95, 0x3086, 0x2afc, 0x3369, 0x2a87, 0x3720,
0x287a, 0x347f, 0x2486, 0x3060, 0x21f7, 0x2f1b, 0x2708, 0x33d5, 0x2983, 0x33b1,
0x2d2d, 0x32ac, 0x2f44, 0x300a, 0x2bf6, 0x2cec, 0x23e1, 0x2b25, 0x22bb, 0x2f65,
0x2564, 0x32fd, 0x225a, 0x2fb7, 0x207f, 0x2dc0, 0x2221, 0x2c5b, 0x2498, 0x2934,
0x2618, 0x2a0e, 0x2c2e, 0x318a, 0x2ac5, 0x2e94, 0x2b20, 0x2d75, 0x2e8a, 0x3173,
0x2944, 0x2da9, 0x27c8, 0x2e61, 0x2b09, 0x34b1, 0x26bc, 0x31ee, 0x1fbe, 0x29df,
0x205d, 0x2c52, 0x201c, 0x2e39, 0x2871, 0x33d9, 0x27f4, 0x2e0b, 0x1fc1, 0x2175,
0x2256, 0x24d6, 0x2359, 0x2b78, 0x208d, 0x29c3, 0x220a, 0x2783, 0x295c, 0x2916,
0x2d20, 0x27e6, 0x3079, 0x2df1, 0x2ab4, 0x2e32, 0x26c1, 0x2dc9, 0x2388, 0x2d3b,
0x232e, 0x2e30, 0x2be2, 0x3502, 0x2ac3, 0x3113, 0x287e, 0x2d33, 0x2461, 0x2b16,
0x234a, 0x2d15, 0x24f8, 0x3066, 0x1feb, 0x2dc1, 0x21a7, 0x2e8e, 0x24c5, 0x2fca,
0x1c1c, 0x2b87, 0x1512, 0x2c4f, 0x1668, 0x2db5, 0x1797, 0x26ef, 0x14e0, 0x1cfa,
0x1aff, 0x22d2, 0x1c72, 0x2703, 0x1ad2, 0x2197, 0x1c75, 0x1dbe, 0x1c90, 0x1e7f,
0x157b, 0x1b4f, 0x1381, 0x1c5d, 0x141a, 0x1fa7, 0x1402, 0x21cf, 0x1583, 0x23a3,
0x1704, 0x24ae, 0x1a07, 0x25a0, 0x1aa1, 0x2348, 0x1cd9, 0x248c, 0x1f79, 0x2796,
0x1ab9, 0x25ba, 0x1339, 0x2468, 0x12d0, 0x23f4, 0x10a9, 0x1e9c, 0x1401, 0x1fc1,
0x1676, 0x1e77, 0x1bcd, 0x1ff2, 0x21ba, 0x211d, 0x25e1, 0x1fdc, 0x282b, 0x1f26,
0x2c80, 0x24ee, 0x284f, 0x2797, 0x1a58, 0x23aa, 0x1002, 0x1fda, 0x0cc4, 0x1d6a,
0x0fc3, 0x1f0c, 0x13fd, 0x1e58, 0x11d5, 0x1865, 0x10be, 0x17e5, 0x10d5, 0x18b0,
0x0890, 0x0e49, 0x0571, 0x0855, 0x06aa, 0x0c41, 0x07bc, 0x0fd5, 0x14df, 0x1873,
0x1051, 0x139a, 0xf764, 0x0717, 0xf86e, 0x0d9b, 0x06fa, 0x16ac, 0x0dd3, 0x1779,
0x0fda, 0x14f6, 0x0be2, 0x10ed, 0x06ac, 0x0df4, 0x0c29, 0x1358, 0x1006, 0x1927,
0x09dc, 0x1737, 0x068e, 0x1280, 0x05ec, 0x0eae, 0x07f1, 0x1030, 0x0cfc, 0x14c8,
0x1239, 0x1b1e, 0x0a7b, 0x168c, 0x0019, 0x0d13, 0xfc4b, 0x0933, 0xfecb, 0x0945,
0xffc1, 0x05e0, 0x0207, 0x072c, 0x0502, 0x0a9e, 0x05ee, 0x088c, 0xfd9f, 0xfe5a,
0xf955, 0xfeda, 0xfa82, 0x039d, 0xfbd9, 0x06b3, 0xfd81, 0x0521, 0x0038, 0x0538,
0xfedf, 0x03c1, 0xfc4e, 0xff2e, 0xf8f1, 0xf9cc, 0xf008, 0xf2e4, 0xec33, 0xf2c1,
0xf0f1, 0xfa0a, 0xefbb, 0xf6f6, 0xf82b, 0xfbd3, 0xf7a0, 0xfc94, 0xf2e3, 0xfb25,
0xf1f1, 0xfa75, 0xf225, 0xf704, 0xf1fb, 0xf2fa, 0xebe6, 0xeec0, 0xeee8, 0xf4b2,
0xf568, 0xfbbf, 0xede1, 0xf665, 0xe236, 0xed59, 0xe99b, 0xf76c, 0xf21e, 0xff47,
0xee35, 0xf756, 0xe4a9, 0xe9b7, 0xe075, 0xe30d, 0xeec0, 0xf144, 0xfb0e, 0xfa4a,
0xf433, 0xed38, 0xef27, 0xe8b2, 0xed95, 0xebb9, 0xead1, 0xea1c, 0xe985, 0xeb6c,
0xdf9a, 0xe90f, 0xe510, 0xf663, 0xf218, 0x048f, 0xf1aa, 0xfed7, 0xefa6, 0xf730,
0xf250, 0xf569, 0xec54, 0xf1bd, 0xe2c0, 0xed17, 0xe260, 0xeb80, 0xead7, 0xf1d1,
0xec6d, 0xf4ad, 0xee1c, 0xf6e6, 0xf7c4, 0xfe05, 0xf508, 0xfc65, 0xef08, 0xf7ed,
0xecd4, 0xf31a, 0xecea, 0xefcb, 0xee81, 0xee55, 0xec72, 0xe9da, 0xe972, 0xe0f2,
0xe71f, 0xe120, 0xdd26, 0xe424, 0xd9fe, 0xe667, 0xe54e, 0xedc4, 0xe1ec, 0xe9a1,
0xd983, 0xddfb, 0xdb4f, 0xdd02, 0xdc5f, 0xdf78, 0xd99c, 0xd8e7, 0xd9f2, 0xd82f,
0xd7f0, 0xd7f3, 0xd587, 0xd15b, 0xd87d, 0xd683, 0xd3b6, 0xd974, 0xd8c7, 0xde12,
0xde27, 0xdd01, 0xd6f3, 0xd51e, 0xdee1, 0xdfae, 0xe067, 0xe1ba, 0xdf4d, 0xdee5,
0xe2a9, 0xe3b1, 0xdea3, 0xe0a1, 0xdfd1, 0xe1e2, 0xdb69, 0xe368, 0xd18b, 0xdb4e,
0xdc7d, 0xe52a, 0xecb5, 0xf705, 0xed23, 0xf5c3, 0xed06, 0xf34a, 0xe42e, 0xee54,
0xd8a7, 0xe63c, 0xd6f0, 0xe856, 0xdbc0, 0xeb87, 0xdd2f, 0xe632, 0xd6a3, 0xdb5d,
0xce00, 0xd2a0, 0xd1d5, 0xd6bc, 0xd8e0, 0xdae9, 0xd6b7, 0xd891, 0xdc91, 0xdec5,
0xdf1a, 0xdecc, 0xdbe6, 0xd3d4, 0xd86b, 0xcf0c, 0xd7a8, 0xd39e, 0xd6a8, 0xd667,
0xde40, 0xe0dd, 0xdf06, 0xe17e, 0xd9d5, 0xd8e5, 0xd6fa, 0xd423, 0xcb58, 0xca4d,
0xca29, 0xca9f, 0xd9ea, 0xde12, 0xd5a1, 0xdfa3, 0xc996, 0xd653, 0xd15b, 0xda16,
0xd319, 0xdba5, 0xca51, 0xd72a, 0xc70f, 0xd4a5, 0xcdd1, 0xd22e, 0xd1c8, 0xcd1a,
0xcb08, 0xc70a, 0xccdb, 0xca02, 0xcf49, 0xcf2e, 0xc977, 0xd199, 0xcbf9, 0xd907,
0xcb98, 0xda29, 0xc918, 0xd91e, 0xcff2, 0xd2e9, 0xdf02, 0xcead, 0xd852, 0xc994,
0xcd32, 0xcce3, 0xd1a1, 0xd589, 0xd2bc, 0xd85e, 0xd0c8, 0xd637, 0xcb61, 0xcecc,
0xc77f, 0xcb8e, 0xd412, 0xd036, 0xdb00, 0xd7b7, 0xcdeb, 0xd951, 0xc3e3, 0xd5ca,
0xc9a6, 0xd25f, 0xd2b3, 0xd1c5, 0xd5ee, 0xd759, 0xd044, 0xcd47, 0xcff2, 0xc347,
0xd377, 0xc797, 0xd5a9, 0xce8a, 0xd9cb, 0xd08a, 0xda8e, 0xd0e4, 0xd840, 0xce04,
0xd131, 0xc5ca, 0xcb13, 0xc7ee, 0xcd14, 0xcd61, 0xcbef, 0xcbee, 0xcdb0, 0xcbc7,
0xcf1a, 0xd318, 0xc994, 0xcfe4, 0xc57b, 0xc4f0, 0xc877, 0xc6d7, 0xc72c, 0xca4a,
0xcd0e, 0xd049, 0xd373, 0xd5fe, 0xcf36, 0xd764, 0xcce8, 0xd5ef, 0xcec9, 0xd461,
0xcc07, 0xcf23, 0xc914, 0xd08c, 0xd8a6, 0xe009, 0xe3d0, 0xe3a3, 0xd5a9, 0xd56a,
0xd182, 0xd209, 0xd234, 0xce86, 0xd3fe, 0xcffb, 0xd480, 0xd527, 0xcb5a, 0xd42b,
0xd335, 0xdd60, 0xd935, 0xe14d, 0xc8f5, 0xd38f, 0xc142, 0xc820, 0xcee2, 0xc7bc,
0xd868, 0xcbd7, 0xd6cb, 0xd096, 0xd636, 0xd120, 0xd805, 0xc8b9, 0xdc2e, 0xc56d,
0xe182, 0xca4c, 0xd976, 0xc69f, 0xd5e1, 0xc9f5, 0xd786, 0xd6ac, 0xd20b, 0xdb30,
0xdd30, 0xe07b, 0xec6c, 0xe427, 0xf204, 0xe73c, 0xeb7b, 0xe13a, 0xdc52, 0xd7f9,
0xced4, 0xcfc3, 0xc633, 0xc763, 0xd04c, 0xd10a, 0xd5de, 0xd5c4, 0xd752, 0xd8a8,
0xdf79, 0xdfcf, 0xe0ea, 0xdf55, 0xde2d, 0xdbd2, 0xdd29, 0xd928, 0xe4df, 0xdcdb,
0xe3cd, 0xdc25, 0xe2de, 0xe2bd, 0xe295, 0xe050, 0xda08, 0xd42f, 0xe0d4, 0xd85f,
0xea0a, 0xdde5, 0xe2fe, 0xd4d6, 0xdb16, 0xce9c, 0xd9dd, 0xd1c6, 0xe25e, 0xdda6,
0xeb42, 0xeabf, 0xe195, 0xe9b2, 0xdc02, 0xe597, 0xe5f2, 0xe792, 0xe90c, 0xe80d,
0xe2f3, 0xe1d3, 0xd8fa, 0xd7cf, 0xd8e3, 0xd9c2, 0xe206, 0xe5c7, 0xe8ef, 0xec92,
0xe76d, 0xe965, 0xe261, 0xe3cf, 0xe19f, 0xe02d, 0xe35a, 0xe311, 0xddb1, 0xe34d,
0xe13e, 0xdd8f, 0xe3f7, 0xd4b2, 0xdd3f, 0xd544, 0xe95a, 0xe126, 0xe610, 0xd995,
0xdbe0, 0xce82, 0xeb04, 0xd6ea, 0xf67b, 0xe22a, 0xea8e, 0xdb60, 0xe584, 0xdb42,
0xea19, 0xe195, 0xee0b, 0xe116, 0xefa2, 0xe08d, 0xe9a0, 0xe112, 0xe9d8, 0xe366,
0xec55, 0xe3f9, 0xee81, 0xe73a, 0xe762, 0xe42e, 0xe010, 0xe631, 0xe8c4, 0xee9a,
0xeb22, 0xeb83, 0xe63e, 0xe20b, 0xe7f2, 0xe006, 0xec5d, 0xe88f, 0xe6d5, 0xe903,
0xea56, 0xebc1, 0xf396, 0xf13c, 0xf771, 0xf434, 0x0091, 0xfaff, 0x00c4, 0xf569,
0xf94e, 0xecbb, 0xf255, 0xeaf2, 0xf74d, 0xecee, 0xfe19, 0xedc3, 0xffd1, 0xebd3,
0x0165, 0xeeff, 0x04b3, 0xf198, 0x0491, 0xeb52, 0x04c3, 0xe97b, 0xfe68, 0xe704,
0xf414, 0xe767, 0xf3c7, 0xec7c, 0xf620, 0xed95, 0xfbfd, 0xf083, 0xfa9a, 0xef3a,
0xf315, 0xf144, 0xf103, 0xf551, 0xf4be, 0xf646, 0xf1ea, 0xeee5, 0xf020, 0xe8f8,
0xf324, 0xeaad, 0xf860, 0xf47c, 0xf83c, 0xfbb8, 0xf2f5, 0xf9a5, 0xf5dd, 0xf492,
0xff90, 0xefcd, 0x030a, 0xefe9, 0x0137, 0xeb60, 0xfc23, 0xe5f5, 0x02cf, 0xec69,
0x0934, 0xf659, 0x0618, 0xf675, 0x05ac, 0xf7bc, 0x09e0, 0xf85c, 0x0325, 0xee20,
0x0917, 0xf37f, 0x0f1c, 0xfa40, 0xfb3f, 0xef47, 0xf6bc, 0xf0e4, 0x03c4, 0xfb46,
0x0b2f, 0x01e0, 0x08a2, 0x03e7, 0x05ce, 0x0215, 0x07f1, 0x0325, 0x02d8, 0x0249,
0x06b2, 0x0c11, 0x0db3, 0x12b5, 0x1181, 0x0d61, 0x1128, 0x04ee, 0x0ff0, 0x01bb,
0x07bd, 0x0091, 0x0c3a, 0x05bf, 0x2325, 0x0ee3, 0x1eda, 0x0527, 0x10a3, 0xfdad,
0x0698, 0xf63b, 0x0e4e, 0xf76f, 0x0d66, 0xf42d, 0x0d08, 0xf5b6, 0x10a0, 0xfb00,
0x11be, 0x01d6, 0x0f46, 0x0791, 0x0965, 0x082a, 0x0a22, 0x0d25, 0x06a9, 0x0fdb,
0x0260, 0x0de1, 0x0bc6, 0x0d2b, 0x16c0, 0x0ca9, 0x1622, 0x06d1, 0x16ff, 0x0904,
0x183a, 0x0fae, 0x151e, 0x12cc, 0x1629, 0x114b, 0x1a09, 0x112d, 0x13c3, 0x0a65,
0x0c85, 0x0377, 0x0cbb, 0x0495, 0x1456, 0x092a, 0x1245, 0x0715, 0x059b, 0x03a2,
0x07e4, 0x0296, 0x1565, 0x0876, 0x0f96, 0x0b8c, 0x0b78, 0x0b95, 0x0c16, 0x0905,
0x0b35, 0x0a5e, 0x13f8, 0x1224, 0x15d9, 0x11e4, 0x15af, 0x09a9, 0x1f4a, 0x0776,
0x2697, 0x1050, 0x2e0f, 0x17ed, 0x2523, 0x0b6d, 0x1955, 0x0af9, 0x2354, 0x1817,
0x2d39, 0x16ce, 0x27cc, 0x1078, 0x24e6, 0x123b, 0x27af, 0x17d6, 0x27b7, 0x1b2e,
0x2f85, 0x1dcd, 0x3253, 0x1c85, 0x2a63, 0x165d, 0x1fcc, 0x0eab, 0x1e5e, 0x1243,
0x2433, 0x1b13, 0x2064, 0x19fc, 0x126e, 0x1576, 0x0f6e, 0x13b8, 0x11e6, 0x13f0,
0x1158, 0x167c, 0x1137, 0x1756, 0x13d0, 0x1815, 0x0c9f, 0x1299, 0x02f0, 0x0923,
0x0e54, 0x1175, 0x2142, 0x2244, 0x1f41, 0x20b4, 0x1d0a, 0x2246, 0x17a7, 0x1cd1,
0x16cd, 0x1968, 0x2979, 0x2736, 0x27a2, 0x270a, 0x1edd, 0x1ef9, 0x29fc, 0x21b2,
0x312c, 0x2581, 0x30ff, 0x254f, 0x30ba, 0x2186, 0x3248, 0x2506, 0x3695, 0x298c,
0x2d37, 0x21dc, 0x243a, 0x1cef, 0x299b, 0x1847, 0x26ce, 0x1847, 0x2741, 0x25ea,
0x3261, 0x297d, 0x309a, 0x2084, 0x2d65, 0x1d0d, 0x31e8, 0x1d23, 0x2ec9, 0x1910,
0x2f13, 0x17ce, 0x30dc, 0x18bf, 0x2ebc, 0x1f4d, 0x23a6, 0x18a9, 0x1cbd, 0x127c,
0x28b9, 0x23bc, 0x2ec1, 0x2f16, 0x2924, 0x2c8c, 0x2b00, 0x2f16, 0x2dbd, 0x3260,
0x2834, 0x2e3a, 0x28f5, 0x2dcc, 0x2a9c, 0x2e3e, 0x2717, 0x2ec1, 0x24ea, 0x30f2,
0x264b, 0x35b5, 0x2341, 0x3583, 0x2d09, 0x36ec, 0x3945, 0x353b, 0x3609, 0x33b8,
0x3408, 0x3af0, 0x3438, 0x39c1, 0x2e5e, 0x3602, 0x2be9, 0x38cc, 0x2ff7, 0x3ad3,
0x2cba, 0x2ebe, 0x2c06, 0x28f4, 0x2fa8, 0x2b8d, 0x33f0, 0x305d, 0x343c, 0x352d,
0x3608, 0x3484, 0x3add, 0x2f83, 0x3450, 0x2762, 0x2f08, 0x26eb, 0x318a, 0x2384,
0x32f2, 0x20cf, 0x2fad, 0x1deb, 0x306c, 0x22ca, 0x316e, 0x269a, 0x307b, 0x2767,
0x30b7, 0x2b84, 0x34b9, 0x3382, 0x343f, 0x3993, 0x317b, 0x3403, 0x3ec2, 0x3292,
0x40d9, 0x3635, 0x2a88, 0x335a, 0x22b0, 0x3363, 0x2ca5, 0x342c, 0x2e01, 0x321a,
0x291a, 0x32b2, 0x2ab3, 0x3612, 0x2d3f, 0x3346, 0x2dde, 0x2fcd, 0x2cc8, 0x2e54,
0x2fbf, 0x2e43, 0x2f6e, 0x303d, 0x2920, 0x33ee, 0x338d, 0x3ac1, 0x3be0, 0x3578,
0x32f8, 0x2bdc, 0x2c34, 0x287e, 0x34f6, 0x2bae, 0x36b3, 0x29f6, 0x312d, 0x23aa,
0x33e8, 0x25d2, 0x39c7, 0x2a25, 0x385a, 0x2bf0, 0x2fe6, 0x2819, 0x3357, 0x28da,
0x37b8, 0x2f18, 0x2e6f, 0x32c7, 0x24de, 0x344a, 0x2053, 0x2f68, 0x1a02, 0x28e1,
0x232e, 0x3355, 0x2bbf, 0x3bda, 0x27c0, 0x3724, 0x2984, 0x3625, 0x305f, 0x38ea,
0x2cc4, 0x33d2, 0x303e, 0x347f, 0x3be3, 0x3c41, 0x3d31, 0x4435, 0x3526, 0x44c0,
0x2f97, 0x3c68, 0x2f00, 0x396b, 0x2d47, 0x3190, 0x2b3b, 0x2c57, 0x2a82, 0x2deb,
0x278f, 0x27c2, 0x29ea, 0x23d2, 0x2a63, 0x2408, 0x249d, 0x22cc, 0x2257, 0x2493,
0x1cef, 0x251b, 0x1a00, 0x21d8, 0x224c, 0x1f6c, 0x2e44, 0x2192, 0x3101, 0x2456,
0x30ad, 0x2997, 0x2b3b, 0x24c1, 0x2c4d, 0x260b, 0x2de7, 0x2a5c, 0x2ba7, 0x2d99,
0x2c38, 0x2e68, 0x35e5, 0x30ae, 0x397d, 0x30dc, 0x377b, 0x30bb, 0x3675, 0x2ff8,
0x387b, 0x3277, 0x39ae, 0x35ea, 0x2c86, 0x299c, 0x2f98, 0x2e2b, 0x368c, 0x3b73,
0x2c12, 0x379b, 0x280b, 0x3237, 0x29ab, 0x3114, 0x26a1, 0x32d3, 0x1a98, 0x2bb7,
0x1716, 0x29b4, 0x1ce0, 0x3037, 0x217a, 0x3091, 0x246d, 0x2bb1, 0x1c80, 0x24c3,
0x13f4, 0x2675, 0x1b0a, 0x2574, 0x2787, 0x2cc9, 0x1d51, 0x2d3f, 0x19a9, 0x2511,
0x2532, 0x238f, 0x26f7, 0x2065, 0x283b, 0x205c, 0x2af1, 0x2318, 0x2a27, 0x2599,
0x27c9, 0x24a1, 0x25b4, 0x2079, 0x280e, 0x1aac, 0x2881, 0x19fb, 0x2462, 0x23da,
0x2543, 0x2b87, 0x1fee, 0x2480, 0x1ab9, 0x1f07, 0x220b, 0x2349, 0x26b0, 0x23ee,
0x2210, 0x210c, 0x1fdc, 0x257c, 0x1831, 0x220f, 0x149f, 0x1c24, 0x1b51, 0x1efd,
0x2501, 0x2585, 0x2048, 0x1a67, 0x19ae, 0x0eb6, 0x1991, 0x11ea, 0x1967, 0x18cc,
0x1a1d, 0x1b34, 0x14f4, 0x1c00, 0x1641, 0x1e51, 0x1644, 0x18cd, 0x16b9, 0x1799,
0x1578, 0x1872, 0x0e7c, 0x13b8, 0x1443, 0x150e, 0x1d2f, 0x1c0c, 0x156f, 0x20aa,
0x11c9, 0x1f99, 0x1032, 0x15b8, 0x0d95, 0x1471, 0x1149, 0x18ea, 0x16ff, 0x1994,
0x1ba0, 0x1816, 0x2096, 0x19ff, 0x1f0c, 0x18ed, 0x1b1b, 0x1592, 0x1e9a, 0x1a61,
0x1bbb, 0x17e0, 0x1950, 0x0fdb, 0x1be9, 0x0e62, 0x15e1, 0x114d, 0x15b7, 0x190d,
0x148f, 0x1556, 0x12d5, 0x11c5, 0x1051, 0x1456, 0x0d96, 0x13fe, 0x0baa, 0x1279,
0x0ede, 0x1382, 0x1199, 0x124b, 0x10ed, 0x12f8, 0x1221, 0x10c5, 0x1ae7, 0x100b,
0x1d8c, 0x151a, 0x1279, 0x1442, 0x0728, 0x1178, 0x03a2, 0x1124, 0x07aa, 0x1284,
0x0437, 0x0ba6, 0x0009, 0x06b0, 0xfed8, 0x0291, 0x030a, 0x03fb, 0x0594, 0x05f2,
0x043d, 0x053d, 0x050c, 0x0467, 0x0793, 0xfbfa, 0x0adf, 0xfafc, 0x0b68, 0x044b,
0x0913, 0x0775, 0x0745, 0x0445, 0xfcc8, 0xf999, 0xf637, 0xf190, 0x0111, 0xf588,
0x03c2, 0xf63f, 0x0120, 0xf7d8, 0x0376, 0xfa3f, 0x0410, 0xf9ed, 0xfcac, 0xf883,
0xf7bb, 0xf58b, 0xfa0e, 0xfc34, 0xf802, 0x060f, 0xf5b2, 0x08d1, 0xfb6e, 0x0830,
0xfb1a, 0x01f3, 0xf93f, 0x0498, 0xf43c, 0x06f3, 0xf443, 0x05e4, 0xf443, 0x028f,
0xf27a, 0xfe98, 0xf55c, 0xfe2e, 0xfa8e, 0x0317, 0xfd62, 0x04b5, 0xeace, 0xf3bc,
0xdce1, 0xef9c, 0xe7f2, 0xf990, 0xf870, 0xf818, 0xf732, 0xeb8a, 0xf235, 0xe13e,
0xff0a, 0xe83a, 0x04d4, 0xf0be, 0xfe85, 0xf55c, 0xfae8, 0xf82c, 0xf388, 0xf3d9,
0xf189, 0xf27e, 0xf2be, 0xf562, 0xf0a4, 0xf505, 0xf369, 0xf4f7, 0xed61, 0xf70e,
0xdfc8, 0xef7e, 0xe8f6, 0xee06, 0xea00, 0xeef2, 0xe0a5, 0xecf9, 0xe8ca, 0xf0ab,
0xf106, 0xf60c, 0xf0b3, 0xf3e4, 0xec47, 0xee2b, 0xe94d, 0xef18, 0xea23, 0xeed7,
0xe637, 0xea98, 0xe441, 0xe77e, 0xf037, 0xebf1, 0xea45, 0xe313, 0xe42f, 0xe0f6,
0xec31, 0xf0ce, 0xecd2, 0xf1e1, 0xe7a7, 0xe82f, 0xe5f1, 0xe620, 0xe822, 0xeca6,
0xe4c8, 0xeb65, 0xdd42, 0xe45b, 0xde6c, 0xe5bd, 0xe028, 0xe4a9, 0xdec5, 0xe018,
0xe041, 0xdfb1, 0xe4b6, 0xe44a, 0xe49d, 0xe65a, 0xda69, 0xe068, 0xd5ca, 0xe556,
0xd9be, 0xeab2, 0xde87, 0xec73, 0xd834, 0xe499, 0xd235, 0xddf0, 0xda16, 0xdff3,
0xdf97, 0xde15, 0xe43a, 0xdfec, 0xe15b, 0xdf60, 0xd645, 0xd8ff, 0xdf8e, 0xdce2,
0xeb98, 0xddc6, 0xe2ad, 0xdf24, 0xdbbb, 0xe341, 0xe0b7, 0xe5de, 0xdd2f, 0xe26e,
0xd9e2, 0xdf65, 0xdc53, 0xdd5d, 0xdaec, 0xdbb2, 0xd20d, 0xd147, 0xceb7, 0xc79a,
0xd645, 0xce2f, 0xd6c0, 0xd84e, 0xd816, 0xdbec, 0xdb7e, 0xd85c, 0xdbca, 0xd901,
0xd317, 0xd4a1, 0xcc85, 0xcf9d, 0xcfb4, 0xd442, 0xd469, 0xd8f1, 0xd85d, 0xdabb,
0xd884, 0xda00, 0xd878, 0xd981, 0xd343, 0xd6f9, 0xce5a, 0xd370, 0xcfaa, 0xd691,
0xcf0a, 0xd914, 0xd531, 0xd8ba, 0xd7da, 0xd58e, 0xcf0b, 0xd44f, 0xcb91, 0xd88a,
0xca18, 0xd5a1, 0xc91e, 0xccb1, 0xd076, 0xcf49, 0xd1f0, 0xd443, 0xce5d, 0xd6a9,
0xc8fc, 0xd206, 0xc2a0, 0xd07b, 0xc4a4, 0xd705, 0xc8c5, 0xd785, 0xcc9b, 0xd6b2,
0xccab, 0xd296, 0xc5fc, 0xcf17, 0xcaeb, 0xd21c, 0xd10f, 0xd47b, 0xd51a, 0xd864,
0xd9ba, 0xdc7e, 0xd787, 0xdbaf, 0xd40c, 0xdaee, 0xd07b, 0xd5a1, 0xd412, 0xd202,
0xd21a, 0xceb3, 0xced8, 0xd181, 0xd634, 0xd4a7, 0xddcb, 0xd863, 0xd659, 0xd7db,
0xd0b8, 0xd373, 0xd94e, 0xd648, 0xdeaf, 0xd9aa, 0xd908, 0xd68a, 0xd385, 0xd54b,
0xd4bc, 0xda9d, 0xcecd, 0xd904, 0xcd83, 0xd6d4, 0xd5a4, 0xdce2, 0xd0bc, 0xde0a,
0xc717, 0xd083, 0xd251, 0xd162, 0xd3af, 0xd8ff, 0xca3a, 0xd752, 0xd1d7, 0xd997,
0xd6f1, 0xdb8f, 0xd225, 0xdb1d, 0xd50a, 0xdfe8, 0xd641, 0xdecb, 0xd0d8, 0xd8ce,
0xccff, 0xd5d2, 0xca38, 0xd11a, 0xd032, 0xd2d0, 0xd595, 0xd311, 0xce5d, 0xcc62,
0xccd7, 0xd00c, 0xccff, 0xd23b, 0xcf59, 0xd057, 0xd273, 0xcd36, 0xd41a, 0xc895,
0xd06e, 0xc63b, 0xc92b, 0xc63a, 0xc8d9, 0xcd51, 0xcac2, 0xd231, 0xd04a, 0xd7b3,
0xd492, 0xdc88, 0xd3a2, 0xd9fa, 0xcde5, 0xd481, 0xd602, 0xdb53, 0xdd13, 0xd9c2,
0xd6f9, 0xd755, 0xd2af, 0xd9ff, 0xd50f, 0xdbc5, 0xd971, 0xd92c, 0xd947, 0xd70f,
0xd868, 0xd52c, 0xda1d, 0xd9e4, 0xde84, 0xe229, 0xe16d, 0xde04, 0xdeb7, 0xda6e,
0xdf3d, 0xdca9, 0xde63, 0xd677, 0xcee0, 0xd1b3, 0xc544, 0xd71b, 0xcaad, 0xd654,
0xc94a, 0xd433, 0xc7c5, 0xda04, 0xcd77, 0xde0d, 0xcbd0, 0xd880, 0xc925, 0xd79f,
0xc82e, 0xd8ff, 0xcd96, 0xd780, 0xcfb2, 0xd68a, 0xcf02, 0xdce6, 0xce76, 0xd517,
0xd62f, 0xc46c, 0xdb31, 0xc39e, 0xd848, 0xc716, 0xdab5, 0xc83a, 0xd7e3, 0xc60d,
0xd6d3, 0xc9c7, 0xd603, 0xcd7f, 0xd236, 0xcd2a, 0xcf21, 0xcd36, 0xcb0b, 0xcf19,
0xcfea, 0xd3b0, 0xd6c4, 0xd42a, 0xcee8, 0xd4e4, 0xc140, 0xd132, 0xc83d, 0xd240,
0xd44b, 0xd77c, 0xdb6f, 0xdbb8, 0xdf27, 0xde4e, 0xe270, 0xdf8f, 0xdd01, 0xdbc9,
0xd780, 0xd71a, 0xd8b0, 0xd45c, 0xdb29, 0xd862, 0xdb60, 0xdd97, 0xde23, 0xd91d,
0xe755, 0xda98, 0xdd34, 0xdb6e, 0xd838, 0xd792, 0xe104, 0xd5d1, 0xe6d7, 0xd66d,
0xe195, 0xd11c, 0xdbb7, 0xd03f, 0xdbc5, 0xd663, 0xdb46, 0xd748, 0xdcbe, 0xd935,
0xd938, 0xd911, 0xdb16, 0xde5c, 0xd770, 0xdaa0, 0xd0cc, 0xd8ae, 0xda5e, 0xe6c4,
0xe461, 0xeda3, 0xdcff, 0xe8ae, 0xd587, 0xe8be, 0xd7cc, 0xe8a2, 0xd97f, 0xe6ae,
0xdb34, 0xe269, 0xe16f, 0xe1a6, 0xe5b3, 0xe360, 0xe62b, 0xe050, 0xe3f8, 0xdd97,
0xe5cc, 0xe30b, 0xe596, 0xdc9b, 0xe5cf, 0xd499, 0xe842, 0xdc21, 0xe649, 0xd874,
0xe329, 0xd463, 0xe215, 0xd8fd, 0xe0de, 0xdbae, 0xde4c, 0xd87f, 0xdb5c, 0xd664,
0xde39, 0xd839, 0xe3ed, 0xdc52, 0xe1c8, 0xd977, 0xe258, 0xdc83, 0xe91b, 0xe628,
0xed56, 0xe973, 0xe037, 0xe099, 0xde79, 0xdff7, 0xe7f0, 0xe357, 0xed4c, 0xeb5d,
0xec90, 0xf38d, 0xe909, 0xef3c, 0xe619, 0xebd7, 0xe3eb, 0xec21, 0xe62d, 0xebfd,
0xea81, 0xeead, 0xeaf4, 0xef5d, 0xe375, 0xeb12, 0xd4f3, 0xe1d4, 0xdd48, 0xdc8c,
0xeb0d, 0xe050, 0xe458, 0xe52c, 0xe479, 0xe398, 0xeb60, 0xe199, 0xec0e, 0xe5ba,
0xf359, 0xeca9, 0xfe0a, 0xf15a, 0x007c, 0xee64, 0x0308, 0xee11, 0xfee8, 0xec10,
0xfbbe, 0xee0f, 0xf844, 0xf423, 0xfbf0, 0xf774, 0xf870, 0xf1fc, 0xf5db, 0xf38b,
0xf807, 0xf385, 0xf729, 0xeff7, 0xf6f2, 0xf029, 0xf49f, 0xf3df, 0xf22d, 0xf643,
0xeea0, 0xf505, 0xed6c, 0xf31f, 0xf0b8, 0xf492, 0xf35b, 0xf5a9, 0xee90, 0xf2eb,
0xf127, 0xf450, 0xf14f, 0xeed9, 0xeb4d, 0xe8d5, 0xef0e, 0xedaa, 0xf125, 0xee0c,
0xf129, 0xed2a, 0xf150, 0xefc0, 0xf29e, 0xf371, 0xf1cf, 0xf4b4, 0xf242, 0xf6a1,
0xf697, 0xf957, 0xf857, 0xf7de, 0xffcc, 0xfc3f, 0xfd70, 0xf480, 0xf0e6, 0xe894,
0xf095, 0xee80, 0xfc37, 0xf5bb, 0xfca7, 0xf6aa, 0xfb8c, 0xf6da, 0xfdb6, 0xf910,
0xfdd6, 0xf9d2, 0xfee7, 0xf84e, 0x04ba, 0xf7c3, 0x0ccc, 0xfc34, 0x072b, 0xf8b0,
0x028e, 0xf51c, 0x0b27, 0xfcd2, 0x0e3a, 0x0261, 0x012e, 0xfe3e, 0x02e9, 0xff8c,
0x0a1a, 0xf9d9, 0x0261, 0xf2dd, 0x0109, 0xfbe8, 0xffc1, 0xff5d, 0xfd9c, 0xfee1,
0xfc2e, 0xff67, 0xff0a, 0x03ad, 0x057d, 0x0613, 0x09b6, 0x05ce, 0x0426, 0x06ba,
0x01f6, 0x0473, 0x00e8, 0xfa02, 0xfe82, 0xf988, 0x00d4, 0x0100, 0x0b6b, 0x0a8a,
0x0bb0, 0x0862, 0x0c2d, 0x0309, 0x0e30, 0x04e3, 0x0a3e, 0x0340, 0x0e27, 0x043d,
0x0b51, 0x058f, 0x01a7, 0x0713, 0x02f4, 0x045b, 0x09f4, 0x00e5, 0x07b2, 0xfe26,
0x06a8, 0xfb83, 0x09cd, 0x02e0, 0x0668, 0x0561, 0x050f, 0x022d, 0x05ba, 0xfde3,
0x07f5, 0xfc45, 0x0bc4, 0x0242, 0x0907, 0x03e4, 0x0db0, 0x071f, 0x0c63, 0x03b1,
0x0496, 0x001e, 0x0c38, 0x0712, 0x0bb8, 0x092b, 0x0595, 0x086f, 0x04a1, 0x0c92,
0x0c23, 0x13ac, 0x10c2, 0x0df0, 0x1651, 0x0c01, 0x1d26, 0x0bea, 0x1ecc, 0x0a5a,
0x1da4, 0x0cc8, 0x16a0, 0x0bde, 0x16f0, 0x0fa7, 0x1ee1, 0x169a, 0x2126, 0x1206,
0x235f, 0x0cd6, 0x261b, 0x12cf, 0x1bd1, 0x1371, 0x1b72, 0x15fd, 0x1b4a, 0x1554,
0x13e5, 0x11dc, 0x1004, 0x0fce, 0x134e, 0x1130, 0x1a05, 0x1387, 0x1672, 0x0da8,
0x1363, 0x0e14, 0x182f, 0x1288, 0x1407, 0x1294, 0x0e17, 0x157e, 0x133e, 0x192b,
0x1611, 0x179e, 0x18b0, 0x1411, 0x19b9, 0x17a9, 0x1a82, 0x1de7, 0x1bd7, 0x1f10,
0x1c98, 0x20fd, 0x1e78, 0x23d6, 0x249e, 0x2470, 0x283e, 0x2734, 0x291a, 0x2b35,
0x2a10, 0x2a0f, 0x26e4, 0x26f0, 0x2484, 0x2269, 0x2cb7, 0x2510, 0x297c, 0x2593,
0x1dd0, 0x2117, 0x1bdb, 0x1f88, 0x195c, 0x1890, 0x19f5, 0x119c, 0x1d2d, 0x0f53,
0x1b64, 0x1026, 0x1c23, 0x12c6, 0x1853, 0x0de0, 0x0fd6, 0x077a, 0x18a4, 0x0cbb,
0x2184, 0x1697, 0x1d0d, 0x134a, 0x1eb0, 0x09c9, 0x23ad, 0x0dc8, 0x2510, 0x1521,
0x25b3, 0x1727, 0x24e8, 0x18ad, 0x2045, 0x17bb, 0x1c08, 0x13a7, 0x1f5d, 0x1af4,
0x2595, 0x29f1, 0x1f73, 0x2bfe, 0x1c85, 0x2ada, 0x227b, 0x261d, 0x29a5, 0x2292,
0x2afe, 0x270c, 0x2d54, 0x28ba, 0x3176, 0x28ac, 0x2e2d, 0x287e, 0x2ec4, 0x273a,
0x2f0e, 0x2449, 0x2a0a, 0x2011, 0x265f, 0x2260, 0x2052, 0x23fa, 0x23bc, 0x2245,
0x21fd, 0x20cb, 0x1764, 0x223d, 0x20e6, 0x23ca, 0x2c93, 0x20dd, 0x2400, 0x1d41,
0x1e84, 0x2194, 0x2156, 0x2798, 0x251b, 0x30da, 0x20da, 0x2cfc, 0x1fbf, 0x2a0c,
0x1dce, 0x2a1d, 0x1c0c, 0x2926, 0x1dd8, 0x2c92, 0x256f, 0x3066, 0x2b71, 0x3083,
0x2857, 0x3178, 0x28cd, 0x26e0, 0x2bad, 0x1e17, 0x2e0b, 0x235a, 0x2f47, 0x25cd,
0x3213, 0x23ec, 0x34b5, 0x2224, 0x35e7, 0x2156, 0x32ac, 0x1f7c, 0x31f5, 0x1ecd,
0x3173, 0x1f7a, 0x2b33, 0x230e, 0x2a61, 0x21e2, 0x2ff7, 0x1ed7, 0x355b, 0x1dd6,
0x3697, 0x24c1, 0x2eed, 0x1ed1, 0x2738, 0x183e, 0x2189, 0x1a65, 0x215e, 0x1e06,
0x25a4, 0x21b9, 0x22b2, 0x1ea5, 0x1f6a, 0x1e84, 0x2505, 0x2388, 0x256c, 0x2385,
0x23ec, 0x279e, 0x2b52, 0x320c, 0x25e5, 0x31d4, 0x26e8, 0x3225, 0x3292, 0x3483,
0x35d8, 0x3504, 0x355d, 0x3559, 0x3580, 0x3829, 0x347c, 0x39a3, 0x3844, 0x3c2a,
0x389f, 0x3b3d, 0x3a70, 0x3398, 0x40d2, 0x2d8b, 0x39f6, 0x2e01, 0x3652, 0x2f18,
0x41ba, 0x2df2, 0x3923, 0x2755, 0x2886, 0x2816, 0x32b3, 0x33fa, 0x3635, 0x3274,
0x31d1, 0x2fe6, 0x30e2, 0x2f82, 0x327a, 0x3063, 0x3639, 0x310d, 0x33cf, 0x2e62,
0x3378, 0x2a26, 0x39c4, 0x28c9, 0x383b, 0x30b1, 0x2d64, 0x2fed, 0x301c, 0x2c6d,
0x2ea0, 0x2a52, 0x2d3b, 0x2c92, 0x2ffd, 0x2e74, 0x2d84, 0x2be5, 0x2cc8, 0x29a2,
0x2cbf, 0x276a, 0x3175, 0x2d9c, 0x2e3d, 0x2ff3, 0x294b, 0x3135, 0x2923, 0x32f3,
0x2788, 0x30c2, 0x1fe7, 0x2a46, 0x22c4, 0x2c08, 0x2bad, 0x32af, 0x268c, 0x3114,
0x239b, 0x2a9b, 0x2cdc, 0x2679, 0x2f3f, 0x245b, 0x2bc0, 0x213a, 0x2bc7, 0x25d5,
0x25d5, 0x25be, 0x217f, 0x2271, 0x238a, 0x1fcd, 0x271b, 0x1c71, 0x2911, 0x1a4f,
0x2eab, 0x1b29, 0x3530, 0x1d6f, 0x3665, 0x21c0, 0x3416, 0x22c6, 0x2cc2, 0x1b94,
0x2c75, 0x207b, 0x2e34, 0x2b17, 0x309f, 0x31d3, 0x3184, 0x35dd, 0x32e7, 0x3ce9,
0x3106, 0x3ec9, 0x2bfd, 0x3a0d, 0x28da, 0x3689, 0x2927, 0x37fc, 0x217d, 0x36fb,
0x1c44, 0x3371, 0x1fa5, 0x2f15, 0x23cc, 0x2921, 0x24b5, 0x216c, 0x25ae, 0x218d,
0x25be, 0x2549, 0x2782, 0x2422, 0x2a0e, 0x1dd7, 0x2fe8, 0x1d6a, 0x2fd8, 0x1ac5,
0x2d23, 0x1980, 0x329b, 0x1dc1, 0x3512, 0x2277, 0x2efe, 0x272b, 0x2f7b, 0x2b84,
0x27ec, 0x2a79, 0x1cd5, 0x26da, 0x1e3c, 0x27b0, 0x1c89, 0x2706, 0x1b9b, 0x20fb,
0x1c14, 0x1a41, 0x1b39, 0x1b90, 0x14f0, 0x174e, 0x1551, 0x20ad, 0x1bee, 0x2b73,
0x247e, 0x27a4, 0x25d8, 0x2c8c, 0x1b2c, 0x2f5c, 0x17f6, 0x236a, 0x1bdd, 0x1c0e,
0x1e3c, 0x1c1d, 0x24b0, 0x22a1, 0x24c4, 0x231e, 0x2498, 0x212b, 0x218a, 0x1f85,
0x1c73, 0x1e8f, 0x220d, 0x2130, 0x1dfd, 0x2350, 0x15d3, 0x220c, 0x1594, 0x2126,
0x19ea, 0x2614, 0x1686, 0x27e4, 0x1230, 0x226f, 0x115d, 0x1fbe, 0x17dd, 0x2476,
0x1c87, 0x25b0, 0x1a68, 0x242b, 0x1bc3, 0x2469, 0x1b70, 0x23ef, 0x17a5, 0x2150,
0x12ab, 0x18e2, 0x14d1, 0x18ca, 0x109a, 0x1af8, 0x0e65, 0x1833, 0x1738, 0x177e,
0x1dd7, 0x1a6c, 0x1b6a, 0x194d, 0x1a1c, 0x18cc, 0x20ed, 0x1fee, 0x2211, 0x23ba,
0x1f67, 0x2098, 0x1d2c, 0x18af, 0x1d0f, 0x1aac, 0x196c, 0x1c52, 0x14f6, 0x15f1,
0x1211, 0x117e, 0x16cf, 0x1591, 0x1629, 0x137b, 0x0bf0, 0x0e4e, 0x0b51, 0x115b,
0x0deb, 0x1101, 0x1027, 0x13f4, 0x12c7, 0x18a2, 0x1463, 0x1d98, 0x1236, 0x20e3,
0x0e7b, 0x2106, 0x0f2e, 0x1cdf, 0x0c66, 0x1967, 0xfdca, 0x171d, 0xfecb, 0x1440,
0x0834, 0x1328, 0x0122, 0x10de, 0xfcd5, 0x0fe0, 0x012b, 0x110a, 0x02b2, 0x10a0,
0x02d7, 0x0fc5, 0x01e8, 0x1041, 0xfd9a, 0x11d4, 0xf997, 0x10a4, 0xf416, 0x0a7b,
0xfa55, 0x0d2d, 0x0569, 0x12e5, 0x0708, 0x0f2f, 0x04be, 0x0b46, 0x0423, 0x0c4b,
0x02eb, 0x0d48, 0x06cd, 0x1123, 0x0156, 0x0c71, 0x0054, 0x0ab6, 0x06db, 0x0e19,
0x0621, 0x0d50, 0x01f1, 0x08a5, 0x031c, 0x081b, 0x0652, 0x045e, 0x0ab1, 0x05cf,
0x0989, 0x0f53, 0x022e, 0x0bd9, 0xff07, 0x0960, 0xff76, 0x10f6, 0xfeb3, 0x11a1,
0xfbd8, 0x0c8c, 0xfa69, 0x0b8e, 0xfb15, 0x0a84, 0xff2d, 0x0be9, 0x0247, 0x0a6b,
0x0661, 0x08af, 0x0185, 0x0bd6, 0xfc5a, 0x0706, 0xfe52, 0xfbcf, 0xfdce, 0xf8f3,
0xf984, 0xfa6b, 0xfba4, 0xfbfc, 0xff99, 0x033e, 0xfd5f, 0x05d3, 0xff2d, 0x08b4,
0xfe69, 0x08c4, 0xfa3e, 0x018f, 0xf484, 0xfeb7, 0xeefe, 0xfeda, 0xf3cc, 0xfe29,
0xeb8c, 0xfbc6, 0xe244, 0x01eb, 0xe9e6, 0x035d, 0xe984, 0xfb3a, 0xdbf7, 0xf67e,
0xe096, 0xfa1a, 0xea7e, 0xfe08, 0xe8a0, 0xfc4b, 0xe760, 0xf8ec, 0xe9f7, 0xf705,
0xea97, 0xf43b, 0xe9ff, 0xf6df, 0xe869, 0xf8f3, 0xec24, 0xf644, 0xf0c5, 0xf4e2,
0xeb0e, 0xf450, 0xe45a, 0xf6f3, 0xe705, 0xfd0a, 0xebd7, 0xfb4f, 0xed02, 0xf6ac,
0xf186, 0xf5e5, 0xf625, 0xf4d7, 0xf6a6, 0xf3ee, 0xf59d, 0xf3f9, 0xf23f, 0xf4da,
0xeb53, 0xf6a1, 0xe9b3, 0xf98d, 0xedfc, 0xf999, 0xf4c5, 0xf9bb, 0xedfe, 0xff42,
0xe928, 0xfd21, 0xef32, 0xfc49, 0xef4a, 0x01a5, 0xf491, 0x0451, 0xf13e, 0xfd1a,
0xe9ce, 0xf932, 0xe4c9, 0xf76c, 0xdf3d, 0xf788, 0xdf18, 0xf9f7, 0xe26c, 0xf871,
0xdaa0, 0xf1d9, 0xd9ab, 0xeff5, 0xec27, 0xf657, 0xebad, 0xf5fd, 0xe143, 0xee91,
0xe348, 0xe8da, 0xe74a, 0xe918, 0xe34d, 0xe671, 0xdc8f, 0xe4d5, 0xd726, 0xe590,
0xd45c, 0xe369, 0xd337, 0xe05e, 0xd9ec, 0xe53d, 0xe237, 0xe9c6, 0xd9df, 0xe4fe,
0xd094, 0xe1c9, 0xdcba, 0xe747, 0xe218, 0xe84c, 0xd6eb, 0xe202, 0xd67a, 0xe09f,
0xde4d, 0xe5a6, 0xe2fd, 0xe9f6, 0xe479, 0xe852, 0xe874, 0xe852, 0xeab4, 0xea1e,
0xe472, 0xe934, 0xde38, 0xe580, 0xe2a2, 0xe59a, 0xe725, 0xe95f, 0xde7e, 0xe317,
0xdc78, 0xe357, 0xdfa7, 0xe6f5, 0xde77, 0xe702, 0xdf36, 0xe5a4, 0xdf7b, 0xe44f,
0xe019, 0xe9fd, 0xde76, 0xeadb, 0xda6b, 0xe6da, 0xd95b, 0xe6be, 0xd564, 0xe642,
0xcde2, 0xe47b, 0xcbf5, 0xe37c, 0xcc22, 0xdd9d, 0xc7f6, 0xd7e3, 0xc5cf, 0xd718,
0xc4dd, 0xd6ca, 0xc196, 0xd69e, 0xc62f, 0xd853, 0xcc2a, 0xd655, 0xcfdd, 0xd41c,
0xd1af, 0xcfdf, 0xd506, 0xd09d, 0xd5f0, 0xd4d9, 0xda92, 0xdce8, 0xda2a, 0xdd0e,
0xdb68, 0xde21, 0xe3fb, 0xe2ea, 0xe384, 0xde62, 0xdcce, 0xd85a, 0xdcde, 0xdbf9,
0xdb2d, 0xdfcc, 0xd6c4, 0xda73, 0xd78b, 0xd71f, 0xd530, 0xd12d, 0xd64e, 0xccef,
0xd8b7, 0xce11, 0xd724, 0xd089, 0xd6ec, 0xd3d1, 0xd1d4, 0xd04e, 0xcbab, 0xd333,
0xd6c6, 0xdfae, 0xe0bd, 0xe27b, 0xe9af, 0xe6d2, 0xecec, 0xe80e, 0xeb7a, 0xe97f,
0xe944, 0xea7c, 0xe414, 0xe2ee, 0xe665, 0xe22b, 0xe758, 0xe271, 0xe5a9, 0xe397,
0xe4c0, 0xe32e, 0xe508, 0xe423, 0xe075, 0xe111, 0xd82b, 0xdd43, 0xd8bd, 0xe24a,
0xd612, 0xe16b, 0xd215, 0xdee8, 0xd4b1, 0xde9b, 0xd497, 0xdbc0, 0xd645, 0xdbb2,
0xdaeb, 0xdde5, 0xda99, 0xda73, 0xd424, 0xd42f, 0xd0bf, 0xd4c8, 0xdf89, 0xdf79,
0xe49c, 0xdf93, 0xdeb1, 0xda40, 0xda16, 0xd6c3, 0xdc65, 0xd7a8, 0xe1f7, 0xe01f,
0xe40e, 0xe42b, 0xdfe5, 0xdfbf, 0xdcdc, 0xdd34, 0xddd7, 0xdfb0, 0xdbfe, 0xdf2a,
0xd8be, 0xda2e, 0xd3dc, 0xd260, 0xd52d, 0xd1d1, 0xd61f, 0xd174, 0xd147, 0xcbd4,
0xd3d7, 0xccee, 0xdaa5, 0xceec, 0xdbd5, 0xd00d, 0xd8b0, 0xd19e, 0xd9d2, 0xd1df,
0xd8f2, 0xcfa3, 0xd89d, 0xd0f2, 0xdcb4, 0xd66d, 0xde23, 0xd803, 0xe0ae, 0xd8bd,
0xe201, 0xd9fa, 0xe1ab, 0xd826, 0xe920, 0xda23, 0xeb99, 0xdd74, 0xec8b, 0xdffd,
0xeb95, 0xdc85, 0xe893, 0xdc69, 0xe34f, 0xded7, 0xe3bc, 0xe31d, 0xe551, 0xe543,
0xe7e1, 0xe2d3, 0xe5f5, 0xdb66, 0xe605, 0xd5c3, 0xeea1, 0xd89e, 0xed0c, 0xdb09,
0xe3c3, 0xdc25, 0xdec1, 0xd713, 0xe3f9, 0xd49a, 0xe613, 0xd9a4, 0xe726, 0xddb3,
0xe2ed, 0xda22, 0xdf25, 0xda98, 0xdb0e, 0xdc76, 0xd9aa, 0xdf40, 0xd9e9, 0xde33,
0xda5a, 0xddab, 0xd8d5, 0xdcf5, 0xdd6b, 0xd4cf, 0xe4d2, 0xcdcf, 0xde29, 0xca21,
0xdd79, 0xcc50, 0xde30, 0xcf26, 0xdad6, 0xcfff, 0xda26, 0xce3e, 0xdf2d, 0xd134,
0xdf9b, 0xd193, 0xdc3e, 0xd00c, 0xdc5f, 0xd38b, 0xe22e, 0xda7d, 0xe7d5, 0xdf51,
0xe878, 0xdf8b, 0xe86a, 0xd929, 0xed19, 0xdb24, 0xeaee, 0xddcf, 0xe1ff, 0xd632,
0xdfcc, 0xd65e, 0xdc2c, 0xd7f8, 0xdf15, 0xd48f, 0xe5b7, 0xd20f, 0xe547, 0xd398,
0xe2a1, 0xd238, 0xe230, 0xd01f, 0xe5a5, 0xd4fe, 0xe6e8, 0xd881, 0xea43, 0xd53d,
0xf0e5, 0xd542, 0xf369, 0xdaa9, 0xf1f8, 0xe03c, 0xee9a, 0xdf05, 0xece7, 0xdb03,
0xeaca, 0xd92b, 0xec0a, 0xdab9, 0xef28, 0xde15, 0xed79, 0xdb4b, 0xedfe, 0xda69,
0xeeaf, 0xdcea, 0xf2f5, 0xe2c9, 0xede1, 0xdfd8, 0xe45e, 0xdf9d, 0xe825, 0xe3d7,
0xefec, 0xe05a, 0xec49, 0xd8a3, 0xe5fc, 0xd535, 0xe78a, 0xd60d, 0xe883, 0xdb58,
0xe93f, 0xe207, 0xe902, 0xe09e, 0xee17, 0xdeca, 0xf1a8, 0xdb73, 0xedbd, 0xdacc,
0xeed9, 0xe0a5, 0xf225, 0xdf3d, 0xf00a, 0xdcdb, 0xe6de, 0xdb41, 0xe91c, 0xdb72,
0xecbe, 0xddd6, 0xed42, 0xe0a2, 0xea9e, 0xdbc7, 0xe7da, 0xd8b1, 0xe520, 0xd87a,
0xe473, 0xd7b7, 0xe3fd, 0xdbba, 0xe3d4, 0xddd2, 0xed5b, 0xe1c4, 0xeb7f, 0xded4,
0xe9b2, 0xdc6c, 0xf33c, 0xe33e, 0xf398, 0xe5d1, 0xf00e, 0xe623, 0xf38e, 0xebd9,
0xf755, 0xefe6, 0xfb22, 0xee8a, 0xfbca, 0xea3f, 0xf8cc, 0xe99f, 0xf993, 0xeab1,
0xf889, 0xe6b4, 0xf96e, 0xe963, 0xfa51, 0xed4f, 0xf76f, 0xe731, 0xf58c, 0xe20b,
0xf580, 0xe242, 0xf972, 0xe35d, 0xfb93, 0xe274, 0xf887, 0xe167, 0xefec, 0xdf9c,
0xed1f, 0xe1d5, 0xec67, 0xe0f2, 0xefc3, 0xe209, 0xf0d5, 0xe7e2, 0xed82, 0xec1e,
0xee67, 0xec6a, 0xf4e8, 0xe94a, 0xfa86, 0xeaa1, 0xf83a, 0xeb61, 0xf9d0, 0xf0b8,
0xfb03, 0xf138, 0xfdec, 0xf56e, 0xff1d, 0xfae8, 0xfc65, 0xfa2c, 0xf8da, 0xf9b0,
0xf52f, 0xf689, 0xf780, 0xf089, 0xfbcc, 0xec34, 0xfbb7, 0xeb9c, 0xf655, 0xe64e,
0xfc7e, 0xe7ac, 0x02ce, 0xe742, 0xfcd3, 0xe8b1, 0xf2ad, 0xeb06, 0xf4d3, 0xeef9,
0xf9cd, 0xf250, 0xf694, 0xef74, 0xf734, 0xf139, 0xf902, 0xf162, 0xfd55, 0xef91,
0xfe9c, 0xeeb6, 0x00a5, 0xeef3, 0x014d, 0xea5c, 0x034a, 0xf2dc, 0x05ff, 0x008d,
0x07ff, 0x0429, 0x00a4, 0x00c3, 0xf815, 0xfb0a, 0xfd69, 0xf887, 0x03c8, 0xf68d,
0x063e, 0xf740, 0x0004, 0xf6d0, 0xfc0d, 0xf9b0, 0xfccb, 0xf7f9, 0xfc6e, 0xf59c,
0xfe7d, 0xf8e2, 0x02c4, 0xf8d9, 0xfe66, 0xf852, 0xf705, 0xfacf, 0xf5b8, 0xfa4a,
0xf958, 0xf370, 0xfed2, 0xeee7, 0x0276, 0xefce, 0x0158, 0xf440, 0x019b, 0xf917,
0x0225, 0xf7f0, 0xfbd5, 0xf064, 0xf7ad, 0xef35, 0xfa0b, 0xf465, 0xfb9b, 0xf4fe,
0x01a5, 0xf641, 0x04c7, 0xf4db, 0xff26, 0xf2ff, 0xfe77, 0xf682, 0x055b, 0xfef7,
0x039f, 0x0505, 0xfe68, 0x0748, 0x02b9, 0x0d50, 0x0751, 0x0b71, 0x0a65, 0x040f,
0x094b, 0x02dd, 0x04e7, 0x0416, 0xfe18, 0x007f, 0xfb49, 0xfd9c, 0x00ee, 0x0305,
0x07d7, 0x077e, 0x0a80, 0x045d, 0x09cd, 0xfff7, 0x0874, 0xfe66, 0x0a54, 0xfef7,
0x06e1, 0xfefe, 0x008f, 0xfe5c, 0x010c, 0xfc18, 0x00e7, 0xfbf9, 0x02cd, 0x0201,
0x010c, 0x0112, 0x01b8, 0xffad, 0x0436, 0xfbeb, 0x037c, 0xf631, 0x0535, 0xf4fc,
0x071e, 0xf8d4, 0x02c0, 0xf99a, 0x011a, 0xfb92, 0x01b2, 0xffaa, 0x040a, 0x03a1,
0x0274, 0x07fc, 0xffb8, 0x0b6e, 0x0703, 0x0bd4, 0x118a, 0x0db3, 0x0fb5, 0x0a2b,
0x0e93, 0x0a20, 0x1236, 0x0c1c, 0x12fa, 0x0ffd, 0x14e8, 0x159d, 0x1491, 0x18cd,
0x126d, 0x1838, 0x14fe, 0x1af2, 0x16cc, 0x1d8d, 0x14c3, 0x1d58, 0x0f5d, 0x1bef,
0x0798, 0x1901, 0x1137, 0x1e8a, 0x1a62, 0x1efa, 0x1a89, 0x1990, 0x17f4, 0x14c8,
0x13ad, 0x143d, 0x0f46, 0x1469, 0x0d9d, 0x15d6, 0x127d, 0x1439, 0x132f, 0x0a7d,
0x1051, 0x064f, 0x0fe4, 0x05f6, 0x1010, 0x02c3, 0x0fa0, 0x012f, 0x1370, 0x05ef,
0x1625, 0x0e25, 0x13ef, 0x12e6, 0x1232, 0x1726, 0x15db, 0x1b1a, 0x16af, 0x1b8d,
0x1163, 0x1c25, 0x0ce4, 0x1c60, 0x0db5, 0x1dba, 0x1129, 0x20eb, 0x1335, 0x1e3e,
0x137a, 0x1487, 0x1589, 0x1188, 0x1893, 0x1584, 0x1bdb, 0x127a, 0x1b5f, 0x0dfe,
0x12d3, 0x11af, 0x10f9, 0x15ca, 0x10b9, 0x0ca2, 0x1057, 0x0a92, 0x1099, 0x0acb,
0x13d4, 0x0a37, 0x158d, 0x0d94, 0x12cb, 0x1146, 0x1324, 0x1292, 0x130a, 0x0ec9,
0x1526, 0x116c, 0x193b, 0x1db4, 0x1694, 0x20c7, 0x1886, 0x1a6d, 0x198d, 0x19df,
0x1437, 0x1e90, 0x0e90, 0x1c2e, 0x0d92, 0x1b9b, 0x0ef3, 0x201d, 0x0f39, 0x219f,
0x1352, 0x2219, 0x12ca, 0x1d4d, 0x1090, 0x1beb, 0x10da, 0x1dcc, 0x0a4e, 0x171b,
0x0912, 0x1987, 0x0fed, 0x1db5, 0x10bf, 0x19eb, 0x1173, 0x1a64, 0x13b5, 0x1c98,
0x13c3, 0x1ca9, 0x1650, 0x1f83, 0x16ac, 0x1b3b, 0x12a7, 0x1434, 0x0fcf, 0x0fcf,
0x1754, 0x0e8c, 0x20bd, 0x1666, 0x1bbd, 0x1a34, 0x14e1, 0x1308, 0x1956, 0x1586,
0x24a4, 0x23a8, 0x25bf, 0x25e5, 0x1f8d, 0x22d5, 0x17e1, 0x1f9c, 0x1b0a, 0x2194,
0x2325, 0x2515, 0x212f, 0x1fcd, 0x1ec5, 0x1bd0, 0x219f, 0x1ded, 0x1d7a, 0x1e75,
0x18bf, 0x1d75, 0x195d, 0x1d0f, 0x1e85, 0x238b, 0x1b43, 0x2854, 0x1868, 0x20c2,
0x1b70, 0x177c, 0x1c4a, 0x1da4, 0x1a7c, 0x24f5, 0x1938, 0x2279, 0x1a06, 0x20f3,
0x1ab8, 0x230b, 0x1843, 0x1fcf, 0x1451, 0x1b9f, 0x14f9, 0x1f03, 0x14d3, 0x1e22,
0x165f, 0x1d19, 0x16ca, 0x2046, 0x19ce, 0x2346, 0x1969, 0x203a, 0x1c38, 0x24ac,
0x21ae, 0x2888, 0x22c9, 0x2773, 0x21e0, 0x2884, 0x241d, 0x2b1f, 0x25ea, 0x2b7e,
0x2658, 0x2615, 0x2962, 0x2333, 0x28dd, 0x2617, 0x2b44, 0x24f2, 0x28cb, 0x1bd3,
0x2471, 0x1837, 0x20fc, 0x1097, 0x21b2, 0x0fd1, 0x26e7, 0x1997, 0x2a69, 0x1fde,
0x2be8, 0x26ab, 0x2855, 0x2d1e, 0x28b2, 0x2ecc, 0x29eb, 0x2d68, 0x2806, 0x311f,
0x28ff, 0x2f0a, 0x30c6, 0x2bbe, 0x3196, 0x2f61, 0x2a05, 0x3399, 0x2777, 0x3714,
0x267e, 0x38ed, 0x2568, 0x37d9, 0x2391, 0x3201, 0x26da, 0x320d, 0x2a05, 0x322b,
0x29c6, 0x3395, 0x2687, 0x361d, 0x2486, 0x36e4, 0x2320, 0x3afa, 0x20e4, 0x3926,
0x23ea, 0x30a7, 0x25a6, 0x2925, 0x2016, 0x271c, 0x212c, 0x228b, 0x27c2, 0x2019,
0x26cf, 0x1c07, 0x266e, 0x15bd, 0x24fa, 0x1225, 0x25a5, 0x150f, 0x2754, 0x182c,
0x24b7, 0x17ec, 0x2649, 0x1a1d, 0x29f0, 0x1da2, 0x2a59, 0x2342, 0x296a, 0x241e,
0x262c, 0x2677, 0x23a9, 0x2ad0, 0x22cd, 0x2a94, 0x2077, 0x284a, 0x194b, 0x21d5,
0x135a, 0x1d6e, 0x1227, 0x1fb3, 0x1376, 0x261f, 0x17e0, 0x2e69, 0x1d02, 0x3157,
0x1c88, 0x2c64, 0x1b7e, 0x2da0, 0x197d, 0x2ed8, 0x1a08, 0x281f, 0x1ca2, 0x2961,
0x18a8, 0x2a59, 0x1de5, 0x28fe, 0x23dd, 0x286c, 0x29ed, 0x2aa1, 0x29fa, 0x26d9,
0x28bd, 0x2601, 0x2624, 0x27ba, 0x2341, 0x28ed, 0x2470, 0x2aa7, 0x2472, 0x274c,
0x23a6, 0x2541, 0x24d2, 0x26d2, 0x285e, 0x2726, 0x28dd, 0x2610, 0x26e7, 0x2629,
0x2857, 0x2725, 0x2792, 0x24ac, 0x2afe, 0x2405, 0x2bca, 0x24f6, 0x273a, 0x2462,
0x2417, 0x230a, 0x1f83, 0x1eeb, 0x216a, 0x2296, 0x222f, 0x21b5, 0x1cf1, 0x1d14,
0x1bc6, 0x1bce, 0x1f6a, 0x21b5, 0x213f, 0x265d, 0x1f16, 0x21c6, 0x2055, 0x1f73,
0x1f88, 0x1d0c, 0x1cc6, 0x190a, 0x19db, 0x16cd, 0x1a4d, 0x1802, 0x1c70, 0x1a54,
0x168b, 0x1b95, 0x0e17, 0x1c56, 0x0eba, 0x1de6, 0x12a0, 0x203c, 0x1012, 0x2382,
0x1618, 0x262e, 0x1deb, 0x25af, 0x1eb8, 0x24ad, 0x1e7d, 0x25b0, 0x1fd0, 0x2996,
0x1e2c, 0x2af6, 0x1bac, 0x2ab6, 0x1be1, 0x2763, 0x1d10, 0x2315, 0x164e, 0x2201,
0x117c, 0x24c1, 0x172c, 0x25fd, 0x14ed, 0x1d39, 0x1118, 0x1d05, 0x135e, 0x1eb9,
0x17f2, 0x1cf4, 0x1bc1, 0x1c14, 0x1b5c, 0x1b90, 0x1966, 0x1871, 0x1a3c, 0x1477,
0x18a8, 0x139a, 0x1983, 0x152d, 0x1cb8, 0x145a, 0x190d, 0x11a6, 0x14b6, 0x1058,
0x1610, 0x122b, 0x1a57, 0x190c, 0x13b5, 0x1bd3, 0x0f23, 0x1f54, 0x108d, 0x2425,
0x12a5, 0x242f, 0x1139, 0x1d98, 0x0dcc, 0x19e6, 0x0df7, 0x1bf1, 0x0f2e, 0x1d89,
0x1173, 0x2338, 0x1683, 0x1ed5, 0x1bf5, 0x18bc, 0x16c4, 0x17e2, 0x102b, 0x1274,
0x0fbd, 0x0d7c, 0x10db, 0x0ee0, 0x10be, 0x0f61, 0x0e1b, 0x0dc0, 0x0b24, 0x0ef8,
0x0703, 0x0de1, 0x055a, 0x114a, 0x0722, 0x1559, 0x073b, 0x10b8, 0x091d, 0x0ba0,
0x0beb, 0x0623, 0x0f4e, 0x0721, 0x0dc2, 0x0947, 0x0e02, 0x0b01, 0x11cf, 0x0c0f,
0x0f22, 0x0f2a, 0x0ba7, 0x1427, 0x0cad, 0x168d, 0x0b7c, 0x17d9, 0x0b07, 0x1a61,
0x0f12, 0x199f, 0x1329, 0x14ac, 0x1572, 0x1345, 0x1140, 0x13b8, 0x1065, 0x147f,
0x12b5, 0x1410, 0x0e57, 0x10d2, 0x0a8b, 0x10b9, 0x0a4f, 0x1113, 0x08a6, 0x10c1,
0x04e4, 0x0ffd, 0x029c, 0x0a19, 0x016e, 0x07ab, 0xfe95, 0x071a, 0xfb8d, 0x01a2,
0xfa8b, 0xff9a, 0xfa55, 0x02f6, 0xf779, 0x01ea, 0xf75b, 0xfc51, 0xfac1, 0xfb2b,
0xfced, 0xfbc6, 0xfb5b, 0xfb41, 0xfca7, 0xfecc, 0xfac8, 0xfe8d, 0xfca3, 0xfe4e,
0xfe03, 0x010e, 0xf9d6, 0x03f7, 0xf9b8, 0x04f6, 0xfd47, 0x0588, 0x0050, 0x064c,
0x05b4, 0x0712, 0x04f0, 0x053a, 0xfda0, 0x0301, 0xfb04, 0x0048, 0xff34, 0x003e,
0x02db, 0x03b6, 0x03b8, 0x04ed, 0x0181, 0x04d4, 0xfda0, 0x0540, 0xfe43, 0x05f7,
0xff11, 0x02a5, 0xfe47, 0xfb09, 0xfd74, 0xf70d, 0xf877, 0xf5f7, 0xf823, 0xf6c2,
0xf834, 0xf582, 0xf339, 0xf2de, 0xf055, 0xf2dc, 0xf1e5, 0xf57f, 0xf5dd, 0xfc74,
0xf31f, 0xfc0e, 0xf133, 0xfcf4, 0xf208, 0xfdd2, 0xf10b, 0xfac4, 0xf38f, 0xfa4b,
0xf6dc, 0xf8a3, 0xf659, 0xf883, 0xf615, 0xfca2, 0xfa65, 0xffae, 0xfccc, 0xfe52,
0xfa62, 0xf853, 0xfe21, 0xf728, 0x02e2, 0xfc7c, 0xfeb5, 0xff21, 0xfb59, 0xff39,
0xf7ae, 0xfac8, 0xfa10, 0xfb0f, 0xf8a4, 0xfb46, 0xf259, 0xf88a, 0xef1c, 0xf2c1,
0xea6b, 0xf229, 0xe48e, 0xf832, 0xe47f, 0xf691, 0xe56a, 0xf24e, 0xde72, 0xeee8,
0xd904, 0xea4b, 0xd98b, 0xea68, 0xdbc4, 0xedd9, 0xdea5, 0xecff, 0xe5ee, 0xec2e,
0xe786, 0xe9fd, 0xe754, 0xe7f1, 0xeb83, 0xeb07, 0xf27e, 0xebc6, 0xf7f9, 0xecd1,
0xf6d8, 0xf07b, 0xf4df, 0xef02, 0xf5db, 0xeea6, 0xf2b1, 0xeff3, 0xf29f, 0xeed4,
0xf828, 0xed9e, 0xfc1f, 0xef3a, 0xfe97, 0xf04e, 0xfb12, 0xf03e, 0xf915, 0xf4de,
0xf451, 0xf2a1, 0xec02, 0xe993, 0xe85f, 0xe665, 0xe814, 0xece7, 0xe5ae, 0xec8b,
0xe02d, 0xe6b8, 0xdd48, 0xe51a, 0xdc9d, 0xe14c, 0xe1ac, 0xde0a, 0xe3b7, 0xda44,
0xe0c6, 0xd909, 0xd8ed, 0xdee1, 0xd399, 0xe64a, 0xd775, 0xe4a2, 0xd869, 0xe123,
0xd770, 0xe27d, 0xd8d6, 0xdfb0, 0xe1ff, 0xe188, 0xe432, 0xe5f9, 0xde46, 0xe41b,
0xdb4d, 0xe4d2, 0xdc77, 0xe75a, 0xdc83, 0xe555, 0xd83c, 0xe3fc, 0xd16f, 0xe25d,
0xd100, 0xe025, 0xd1ef, 0xe455, 0xd230, 0xe82e, 0xd57c, 0xe4cd, 0xd83c, 0xe183,
0xe204, 0xe4c4, 0xeb04, 0xe72c, 0xec1b, 0xe27c, 0xeb1e, 0xe03b, 0xea7b, 0xe34d,
0xe7c8, 0xe37b, 0xe607, 0xe21e, 0xe2d7, 0xdd5b, 0xe2ed, 0xd878, 0xe1f0, 0xd361,
0xe3de, 0xd52d, 0xe352, 0xcf4e, 0xe2ff, 0xcc50, 0xe432, 0xd3d8, 0xe039, 0xd827,
0xe037, 0xdc00, 0xe07c, 0xdf94, 0xdd42, 0xe32d, 0xdbcf, 0xe3f6, 0xddff, 0xe399,
0xda1a, 0xe19f, 0xd5e1, 0xe192, 0xd83e, 0xe267, 0xde81, 0xe4c7, 0xe3a1, 0xe74b,
0xe0c0, 0xe866, 0xda94, 0xe868, 0xdf2b, 0xe9ca, 0xdf70, 0xe93e, 0xdc39, 0xe9ab,
0xdd24, 0xeacf, 0xdeca, 0xe9f2, 0xdf37, 0xe92c, 0xe19b, 0xe571, 0xe480, 0xdecd,
0xe6fc, 0xdc8c, 0xe538, 0xdcc4, 0xe6c0, 0xde1b, 0xecf9, 0xe0bd, 0xe931, 0xe146,
0xe32f, 0xe337, 0xe0f6, 0xe11c, 0xde39, 0xdd61, 0xdc36, 0xdcb3, 0xdee0, 0xdf69,
0xe174, 0xe1d6, 0xe5e6, 0xe5bc, 0xe894, 0xeac7, 0xe81e, 0xf02d, 0xe981, 0xf011,
0xe4f3, 0xeafc, 0xdc51, 0xe844, 0xe45b, 0xeb3f, 0xe81f, 0xeabc, 0xe19b, 0xeafd,
0xdd9b, 0xec14, 0xdcbb, 0xebbd, 0xe2a6, 0xee03, 0xe80f, 0xecd6, 0xe508, 0xe778,
0xe0a9, 0xe3fc, 0xe2c5, 0xe61c, 0xe4b5, 0xe515, 0xe681, 0xde8f, 0xe7d9, 0xda06,
0xe46b, 0xda41, 0xe134, 0xdc5e, 0xe06b, 0xd8fb, 0xdf7f, 0xd44a, 0xdff1, 0xd84e,
0xe089, 0xe20d, 0xdd5c, 0xe6d5, 0xdb13, 0xe715, 0xd927, 0xe616, 0xd471, 0xe747,
0xd461, 0xe9d4, 0xdae0, 0xe58e, 0xe310, 0xe1d3, 0xe245, 0xe10a, 0xe328, 0xe2c9,
0xe165, 0xe0ea, 0xd90d, 0xddb3, 0xd476, 0xdc42, 0xda00, 0xe017, 0xdfe6, 0xe110,
0xe353, 0xe2c5, 0xe232, 0xe539, 0xdc1a, 0xe40d, 0xd867, 0xe328, 0xda63, 0xe0df,
0xdbfa, 0xded9, 0xdca2, 0xde4a, 0xe0c3, 0xde47, 0xdf5d, 0xdd63, 0xdc82, 0xe1eb,
0xdb2a, 0xe3ea, 0xdcc9, 0xe55b, 0xe00e, 0xe743, 0xe317, 0xe6ff, 0xe153, 0xe2f9,
0xdf09, 0xdfbc, 0xdfda, 0xe16b, 0xdfde, 0xe763, 0xe073, 0xe9b5, 0xe504, 0xe997,
0xe713, 0xeaec, 0xea4e, 0xec41, 0xebb4, 0xe7a7, 0xea8d, 0xe4bd, 0xe8b8, 0xe29e,
0xe64f, 0xde5d, 0xe37d, 0xde31, 0xe075, 0xddac, 0xe0ab, 0xdde6, 0xde6b, 0xd9c9,
0xdafe, 0xd562, 0xdc0b, 0xd7b9, 0xde56, 0xd6ea, 0xe2ae, 0xd836, 0xdbf4, 0xdaf3,
0xd0e4, 0xdbd5, 0xd496, 0xdc92, 0xd969, 0xdd02, 0xd6aa, 0xdf4e, 0xd6de, 0xe287,
0xdb4b, 0xe6ed, 0xddc1, 0xe8a3, 0xe082, 0xe871, 0xe12a, 0xe5f9, 0xe252, 0xdf10,
0xe28c, 0xddc8, 0xe13b, 0xe6ab, 0xdf45, 0xe9a5, 0xe1ea, 0xe9a0, 0xe76d, 0xebb8,
0xe5ab, 0xeaa9, 0xdfd3, 0xe80a, 0xdd6b, 0xe7d3, 0xe123, 0xe905, 0xe0fc, 0xe975,
0xdd10, 0xea04, 0xd8e5, 0xe746, 0xd82b, 0xe495, 0xdcbe, 0xe46b, 0xe103, 0xe27a,
0xe564, 0xe81c, 0xea60, 0xebfb, 0xee90, 0xe4b6, 0xefbb, 0xe18e, 0xee67, 0xe5df,
0xefa2, 0xeafc, 0xf129, 0xee07, 0xf0ce, 0xed4c, 0xee2c, 0xe78e, 0xe6fb, 0xe21d,
0xe0e8, 0xe1d5, 0xe20b, 0xe350, 0xe461, 0xe239, 0xe183, 0xdfc1, 0xdd8c, 0xdcb3,
0xd903, 0xdb19, 0xd338, 0xdb39, 0xd31a, 0xdd80, 0xd521, 0xdf79, 0xd937, 0xe0c3,
0xdc4f, 0xdf29, 0xde0a, 0xdf04, 0xe2bb, 0xe104, 0xe6fc, 0xe29e, 0xe9c2, 0xe438,
0xed6e, 0xe85b, 0xee25, 0xec98, 0xed3c, 0xeeba, 0xf166, 0xf126, 0xf358, 0xee99,
0xf50b, 0xec5c, 0xf4ea, 0xe5bc, 0xf20e, 0xe438, 0xee89, 0xeb55, 0xebd7, 0xedda,
0xedd3, 0xf035, 0xef4f, 0xf2fb, 0xf1d2, 0xf4c6, 0xef20, 0xf891, 0xee40, 0xffeb,
0xeea8, 0xfc9e, 0xebb0, 0xf326, 0xe80a, 0xf087, 0xe65e, 0xeee5, 0xe92a, 0xef23,
0xeb55, 0xf0c3, 0xec1a, 0xf13d, 0xea98, 0xecaf, 0xea18, 0xe826, 0xeb4c, 0xe8e9,
0xee78, 0xea47, 0xf09a, 0xedc8, 0xe9d8, 0xf2dd, 0xe41c, 0xf3a3, 0xe5cc, 0xf16a,
0xe6b2, 0xeeca, 0xe6ca, 0xe748, 0xebaa, 0xe217, 0xed3a, 0xe79e, 0xe9f0, 0xe94c,
0xeaf7, 0xe429, 0xf080, 0xe0a5, 0xf1ab, 0xdf94, 0xf022, 0xe00d, 0xf327, 0xdff5,
0xf416, 0xe25e, 0xf447, 0xe7c1, 0xf677, 0xea25, 0xf647, 0xf05d, 0xf0da, 0xf647,
0xf00a, 0xf99d, 0xf425, 0xfac1, 0xf9da, 0xfe1a, 0xf980, 0xfaf7, 0xf56d, 0xf59f,
0xf341, 0xf558, 0xee2e, 0xf79c, 0xe79c, 0xf933, 0xe5ca, 0xf3e5, 0xe710, 0xef9a,
0xeec0, 0xf7a6, 0xf073, 0xfb96, 0xe742, 0xf5fd, 0xe6e2, 0xf006, 0xeb99, 0xeef8,
0xeb4d, 0xeb8e, 0xec37, 0xe650, 0xeebd, 0xe6d1, 0xf042, 0xea3c, 0xf44f, 0xed1d,
0xf95e, 0xef57, 0xff0d, 0xf030, 0xfadb, 0xe926, 0xf568, 0xe719, 0xf6e3, 0xee9a,
0xf848, 0xf620, 0xf1e7, 0xf555, 0xf0cf, 0xf763, 0xf445, 0xf853, 0xf779, 0xf9ea,
0xf91a, 0xfcf8, 0xf938, 0xfa95, 0xfdae, 0xf837, 0x00fb, 0xf363, 0x06c1, 0xf2c2,
0x081c, 0xf7e6, 0x0029, 0xfcca, 0xf6b0, 0xfbc6, 0xf19d, 0xfa24, 0xeea7, 0xf88a,
0xef46, 0xf5db, 0xec8e, 0xefb6, 0xec65, 0xef30, 0xf153, 0xee84, 0xf561, 0xeb7a,
0xf5e2, 0xf061, 0xf0f4, 0xf4e6, 0xec08, 0xef7f, 0xeb65, 0xecae, 0xeb43, 0xf055,
0xedf9, 0xf432, 0xf15e, 0xf214, 0xf5f1, 0xf3ba, 0xf79f, 0xf877, 0xf458, 0xfb23,
0xf181, 0xfbe3, 0xf0ef, 0xf9cd, 0xf5d1, 0xfa9b, 0xfca4, 0xfb4c, 0x0244, 0xfcf1,
0x05a3, 0x023d, 0x0a66, 0x0376, 0x11cc, 0x00a5, 0x12fd, 0x006e, 0x0bbc, 0xff8a,
0x0acb, 0x0018, 0x0b22, 0xfffd, 0x0821, 0xff23, 0x0ab6, 0x0169, 0x0e5d, 0x021f,
0x0ce5, 0xfead, 0x0890, 0xfc7d, 0x04d8, 0xf920, 0x026d, 0xf5fc, 0xfcf9, 0xf7b8,
0xfa64, 0xfa42, 0xfe53, 0xfb8e, 0x0039, 0xfaec, 0xfc92, 0xfcd8, 0x008c, 0x0417,
0x0703, 0x0686, 0x072e, 0x0856, 0x0381, 0x08da, 0x009b, 0x0342, 0x0378, 0x0055,
0x070f, 0x02b0, 0x0965, 0x06d4, 0x08f5, 0x07f9, 0x0940, 0x0997, 0x080d, 0x0ada,
0x062c, 0x0948, 0x0394, 0x06e3, 0x0220, 0x0580, 0x067f, 0x05ab, 0x08a0, 0x02b6,
0x06ff, 0xff77, 0x07de, 0xffb0, 0x0c14, 0x02a2, 0x0d6f, 0x0719, 0x0ab6, 0x0a4c,
0x08a3, 0x08fb, 0x0972, 0x08b0, 0x099c, 0x0d47, 0x09b8, 0x1160, 0x0c30, 0x0edf,
0x0e45, 0x0afa, 0x0e8c, 0x0df3, 0x0cc7, 0x1122, 0x09c4, 0x0f89, 0x096d, 0x0d7e,
0x098d, 0x08a3, 0x0e04, 0x0a0b, 0x1125, 0x0c19, 0x1334, 0x0b94, 0x13b6, 0x0c66,
0x11dc, 0x0ca2, 0x1542, 0x0a9f, 0x1806, 0x0bfc, 0x1a4d, 0x0fe1, 0x1a78, 0x0dac,
0x18e7, 0x0bc6, 0x18e9, 0x0ae2, 0x17ba, 0x0c62, 0x162c, 0x10a7, 0x1131, 0x104f,
0x0b92, 0x1073, 0x05b3, 0x11c6, 0x063f, 0x12b7, 0x07f1, 0x11df, 0x0207, 0x075e,
0x0096, 0x022b, 0x0326, 0x05e5, 0x0171, 0x0387, 0xfcaa, 0xff6c, 0xff5e, 0x008d,
0x05ab, 0x017a, 0x0923, 0x0538, 0x0861, 0x06f7, 0x08e9, 0x0790, 0x0bf4, 0x0b6e,
0x1469, 0x0d5a, 0x1aaa, 0x0d48, 0x1561, 0x0e38, 0x1505, 0x0e2d, 0x1b86, 0x12f6,
0x1c84, 0x1b10, 0x1c5a, 0x1ef1, 0x1c56, 0x2023, 0x1aa8, 0x2009, 0x1a12, 0x1c5c,
0x1ba2, 0x1ae4, 0x1bf7, 0x1ae5, 0x1801, 0x1986, 0x14ab, 0x1a73, 0x13c9, 0x1a24,
0x1253, 0x1755, 0x138f, 0x129a, 0x18ac, 0x0d6c, 0x1afa, 0x0ba2, 0x161e, 0x085a,
0x154b, 0x077e, 0x1566, 0x09f1, 0x10ae, 0x0ab2, 0x0edc, 0x0d1f, 0x0e4a, 0x0d81,
0x0df3, 0x0b46, 0x0ce6, 0x0bc9, 0x1481, 0x1092, 0x1ea1, 0x1287, 0x1c3a, 0x13a9,
0x146f, 0x1377, 0x1734, 0x144b, 0x1aea, 0x1427, 0x19f7, 0x119e, 0x1a64, 0x12ec,
0x1c46, 0x11ad, 0x21cc, 0x121e, 0x2356, 0x1540, 0x22e8, 0x17df, 0x2446, 0x193b,
0x2256, 0x18df, 0x1dc8, 0x16bb, 0x19c7, 0x179f, 0x16ef, 0x1b3f, 0x1913, 0x1fc0,
0x21c7, 0x2227, 0x25f2, 0x210c, 0x2755, 0x2000, 0x268c, 0x1d8c, 0x2419, 0x1c82,
0x22ea, 0x1d21, 0x2537, 0x1f50, 0x24f7, 0x211d, 0x21e3, 0x2044, 0x21d1, 0x215d,
0x229a, 0x245d, 0x21d0, 0x23ca, 0x2123, 0x2196, 0x2391, 0x2089, 0x28d7, 0x24c0,
0x2b26, 0x26c0, 0x269e, 0x21cf, 0x248d, 0x1f45, 0x2745, 0x21c3, 0x2a72, 0x23bb,
0x2c34, 0x24f6, 0x276a, 0x22fa, 0x220f, 0x220f, 0x21a3, 0x1fbf, 0x2639, 0x1d07,
0x2b59, 0x1e3e, 0x2f8c, 0x224e, 0x28bf, 0x216b, 0x2163, 0x22c2, 0x2009, 0x2601,
0x1e19, 0x24ee, 0x1e61, 0x232d, 0x207b, 0x2245, 0x2191, 0x1dab, 0x278e, 0x1d07,
0x2aec, 0x1e73, 0x289f, 0x1d58, 0x2a19, 0x1d75, 0x29f8, 0x1f2b, 0x26d4, 0x2061,
0x27dc, 0x218c, 0x2685, 0x22cb, 0x2437, 0x25a2, 0x2515, 0x2cc9, 0x25e2, 0x3007,
0x29da, 0x3040, 0x2d06, 0x2ecd, 0x2e66, 0x2cd3, 0x2c09, 0x2ccd, 0x26cd, 0x3223,
0x2353, 0x3140, 0x2837, 0x2dbc, 0x298e, 0x2bdd, 0x2597, 0x29b1, 0x276c, 0x2837,
0x259c, 0x2543, 0x2508, 0x24b0, 0x26e7, 0x210a, 0x28ba, 0x1ef4, 0x28d1, 0x213f,
0x2670, 0x2109, 0x25ca, 0x20eb, 0x253e, 0x211d, 0x2272, 0x1e28, 0x1e1c, 0x1cc9,
0x1b03, 0x1aa0, 0x1aa2, 0x18e7, 0x1e5e, 0x1a2e, 0x2193, 0x1ccb, 0x2169, 0x1ddc,
0x2388, 0x20c7, 0x2372, 0x2471, 0x22c7, 0x2561, 0x279c, 0x255d, 0x2af3, 0x282c,
0x2962, 0x2b0c, 0x2d93, 0x2c7f, 0x320d, 0x2d1a, 0x33a8, 0x2f1f, 0x340f, 0x2de6,
0x2f8f, 0x2ae9, 0x2b58, 0x2af8, 0x2cd2, 0x2b24, 0x2fe0, 0x2b52, 0x2d67, 0x28ea,
0x28cb, 0x2947, 0x25b9, 0x2bb0, 0x25bb, 0x2c4d, 0x225a, 0x2a2a, 0x1ab9, 0x27a8,
0x1134, 0x20f4, 0x13c2, 0x1dfe, 0x194c, 0x1d03, 0x1860, 0x1b9a, 0x1b43, 0x1d5c,
0x1c3b, 0x1edb, 0x1b1d, 0x224b, 0x1918, 0x23f3, 0x1ae7, 0x2553, 0x1d77, 0x20a6,
0x1f0a, 0x1ada, 0x1f62, 0x1a74, 0x2111, 0x19f1, 0x2849, 0x1f5e, 0x2b97, 0x25e9,
0x2c02, 0x2732, 0x2d8d, 0x25da, 0x33f7, 0x29a3, 0x3305, 0x2b74, 0x2b05, 0x2a5a,
0x2760, 0x2a14, 0x2447, 0x2a77, 0x2035, 0x28da, 0x1ac4, 0x2126, 0x154f, 0x1865,
0x13e9, 0x1318, 0x148f, 0x1347, 0x179f, 0x1851, 0x1bd2, 0x19f6, 0x1836, 0x1741,
0x136f, 0x1a8e, 0x12ea, 0x2222, 0x14b9, 0x27db, 0x1639, 0x257b, 0x1977, 0x2342,
0x1b7d, 0x24ef, 0x1cef, 0x221c, 0x1d93, 0x20da, 0x1b42, 0x25a0, 0x1f15, 0x24e7,
0x1ee3, 0x1f7b, 0x19d9, 0x2177, 0x19ab, 0x215e, 0x1d8a, 0x21a1, 0x1f79, 0x26ed,
0x1e9a, 0x251f, 0x1eb1, 0x1eac, 0x21d5, 0x1e04, 0x218e, 0x1dc5, 0x1c0e, 0x1b0d,
0x1c53, 0x19a1, 0x21d0, 0x19ea, 0x1e96, 0x1ab6, 0x19e2, 0x1b8a, 0x17f5, 0x1b60,
0x157d, 0x1c98, 0x148f, 0x1f80, 0x156b, 0x1f91, 0x12ef, 0x1b57, 0x11ad, 0x183b,
0x12d2, 0x153a, 0x1239, 0x1269, 0x1129, 0x123f, 0x0e61, 0x10fb, 0x0fa8, 0x1388,
0x153b, 0x19d8, 0x178a, 0x1a0c, 0x1714, 0x149e, 0x150d, 0x1290, 0x11af, 0x169c,
0x1116, 0x19d4, 0x10e4, 0x1b68, 0x11bd, 0x1f5d, 0x1298, 0x235c, 0x14a7, 0x237a,
0x1919, 0x205d, 0x1932, 0x1d60, 0x15a3, 0x1f6e, 0x14f0, 0x1fd1, 0x1543, 0x1a11,
0x1215, 0x15cb, 0x0e4b, 0x1600, 0x0acb, 0x13d6, 0x0877, 0x11d6, 0x05d0, 0x131e,
0x0581, 0x156f, 0x096f, 0x1962, 0x0ab8, 0x1751, 0x07d8, 0x0d8a, 0x06a7, 0x07f1,
0x04e1, 0x0739, 0x015f, 0x0650, 0x02a2, 0x0809, 0x06bb, 0x09ca, 0x0ad8, 0x0ad8,
0x0aa1, 0x0848, 0x04c8, 0x057e, 0x0054, 0x0816, 0x028b, 0x0ec2, 0x07d1, 0x14c2,
0x0c3e, 0x1498, 0x0dbd, 0x1033, 0x0947, 0x0ce4, 0x096e, 0x0fde, 0x09f5, 0x1202,
0x0b15, 0x1526, 0x0fca, 0x155f, 0x11da, 0x1373, 0x0dea, 0x0fb4, 0x0fc1, 0x0c23,
0x1154, 0x08f8, 0x0ba6, 0x0128, 0x0ba1, 0xfdc8, 0x0af4, 0x01bf, 0x0a60, 0x0743,
0x0b1b, 0x0636, 0x035c, 0x027b, 0xfa39, 0x02f6, 0xfc9d, 0x0240, 0x0019, 0xff4a,
0xff18, 0x0354, 0xfc26, 0x0886, 0xfd93, 0x0875, 0xfc9d, 0x06e6, 0xf8b1, 0x07f2,
0xfbb6, 0x0a32, 0xfbee, 0x086e, 0xfc6f, 0x0850, 0x0036, 0x0a26, 0x00f5, 0x0d0a,
0xfc19, 0x0cf9, 0xfa27, 0x096b, 0xfaff, 0x09b8, 0xfb2f, 0x0b57, 0xfd5f, 0x07c9,
0xfeac, 0x047f, 0x006d, 0x04d7, 0xfeb1, 0x044a, 0xf914, 0x001c, 0xf709, 0xfce3,
0xf743, 0xfdb2, 0xf74d, 0x0002, 0xf404, 0xfe2a, 0xf42b, 0xfe72, 0xf3b0, 0xfda1,
0xf20c, 0x008d, 0xf2c6, 0x0192, 0xf9d5, 0xfd58, 0xfde5, 0xf9dd, 0xfff2, 0xff5b,
0x0141, 0x0421, 0x01e9, 0x03ed, 0x099c, 0x0791, 0x0cd9, 0x05a4, 0x0b66, 0x0187,
0x0745, 0xfd09, 0x05c4, 0xfae4, 0x02b5, 0xf922, 0x0064, 0xfa6f, 0x0129, 0xfc63,
0xff3a, 0xfa20, 0xfcbb, 0xf76a, 0xfab6, 0xf83e, 0xf619, 0xfdee, 0xf2a6, 0x0193,
0xf28f, 0x005f, 0xf1b8, 0x0035, 0xf025, 0xfc4b, 0xee84, 0xf406, 0xecb7, 0xf073,
0xe8bf, 0xeff5, 0xe939, 0xf5c5, 0xeae2, 0xf9f7, 0xed4d, 0xf609, 0xef32, 0xf362,
0xeda0, 0xf3ab, 0xefeb, 0xf372, 0xf2ff, 0xf11a, 0xf2e0, 0xedce, 0xef56, 0xec92,
0xed19, 0xeedf, 0xee68, 0xf0d1, 0xf23c, 0xf548, 0xf749, 0xf7f4, 0xfebf, 0xf74f,
0xfe9e, 0xf979, 0xf717, 0xfbb8, 0xf4ee, 0xfb3e, 0xf261, 0xf80b, 0xed54, 0xf34b,
0xea5d, 0xed12, 0xebdf, 0xed89, 0xedc6, 0xf1f5, 0xedfd, 0xf1d3, 0xef67, 0xedbf,
0xf151, 0xe89c, 0xf19c, 0xe48f, 0xf1f3, 0xe3dc, 0xf07a, 0xe4b7, 0xed3e, 0xe527,
0xecae, 0xe9e7, 0xf00d, 0xef89, 0xefaa, 0xf00e, 0xeda8, 0xed23, 0xef2e, 0xed96,
0xee81, 0xee12, 0xedb3, 0xf02d, 0xec5d, 0xf1c4, 0xeab3, 0xf00e, 0xeb45, 0xedfc,
0xed54, 0xf061, 0xecbb, 0xf21e, 0xec06, 0xf0d4, 0xecb0, 0xf04b, 0xeae2, 0xf48a,
0xea51, 0xf8be, 0xea51, 0xf672, 0xebbc, 0xf1c9, 0xef12, 0xed50, 0xf1f3, 0xebfb,
0xf5e3, 0xf1b3, 0xf868, 0xf80e, 0xf7ad, 0xf6bd, 0xf793, 0xf133, 0xf645, 0xec97,
0xf64f, 0xee87, 0xf923, 0xf343, 0xf90f, 0xf376, 0xf865, 0xf135, 0xf8dd, 0xf2a1,
0xfd48, 0xf7a6, 0x0217, 0xf775, 0xfd33, 0xefee, 0xf3c8, 0xe86e, 0xf025, 0xe54f,
0xef85, 0xe632, 0xed95, 0xe830, 0xea75, 0xe78c, 0xe93a, 0xe955, 0xe9fc, 0xec0c,
0xec0a, 0xf0d5, 0xeb17, 0xf471, 0xeefa, 0xf479, 0xf1fd, 0xef6a, 0xf12d, 0xeb1f,
0xf3c2, 0xe9fb, 0xf40e, 0xed20, 0xefa7, 0xf267, 0xefd6, 0xf31d, 0xf2f2, 0xf03f,
0xf645, 0xecf7, 0xf74b, 0xeb8a, 0xf1d5, 0xebc0, 0xebfd, 0xeb3b, 0xe975, 0xeaea,
0xe4bf, 0xe8e7, 0xe057, 0xe961, 0xe10b, 0xee22, 0xe435, 0xf2e5, 0xea9b, 0xf458,
0xf18b, 0xf388, 0xf803, 0xf44e, 0xfec8, 0xf6bf, 0x0089, 0xf666, 0x0160, 0xf83e,
0x0179, 0xf80f, 0x006a, 0xf3bf, 0xfe8c, 0xef3a, 0xf9e5, 0xeecc, 0xf5bc, 0xefc6,
0xf501, 0xf0ea, 0xf345, 0xf054, 0xf2cb, 0xedd9, 0xf3a0, 0xebaf, 0xf29f, 0xeb0a,
0xefc2, 0xe7b7, 0xebc1, 0xe48a, 0xec1c, 0xe874, 0xebea, 0xe818, 0xecf8, 0xe5e9,
0xeaaf, 0xe3b3, 0xe715, 0xe409, 0xe866, 0xe93e, 0xe862, 0xe90e, 0xe72f, 0xe867,
0xe57f, 0xeb84, 0xe0db, 0xe83f, 0xddb3, 0xe393, 0xdbd1, 0xe2a3, 0xdfc8, 0xe4db,
0xe532, 0xe6a1, 0xe7c0, 0xea71, 0xebff, 0xf067, 0xeef4, 0xefe9, 0xf1f1, 0xea32,
0xf166, 0xe59d, 0xf088, 0xe65a, 0xeec5, 0xe89d, 0xecaf, 0xead0, 0xf07e, 0xeb40,
0xf464, 0xe7a1, 0xf54d, 0xe79d, 0xf362, 0xe932, 0xf20d, 0xe8d0, 0xef9f, 0xe862,
0xf02e, 0xee83, 0xee89, 0xefcd, 0xece0, 0xeeee, 0xee8a, 0xf09f, 0xed35, 0xef26,
0xe8e4, 0xef2b, 0xe814, 0xed47, 0xe8e3, 0xe806, 0xe7ab, 0xe5b0, 0xe8c9, 0xe641,
0xe891, 0xe0df, 0xe7d7, 0xdbe8, 0xe58f, 0xdcec, 0xe774, 0xe154, 0xe8e6, 0xe036,
0xe843, 0xe0d3, 0xe771, 0xe576, 0xe9cd, 0xe81a, 0xe9c3, 0xe6ed, 0xe36e, 0xe521,
0xe4c6, 0xe4c7, 0xecac, 0xe569, 0xef4a, 0xe4de, 0xeea5, 0xe378, 0xefe9, 0xe7b7,
0xe95a, 0xea73, 0xe529, 0xed5f, 0xe6ff, 0xed03, 0xec8c, 0xe9fb, 0xed5e, 0xe501,
0xeb0a, 0xe29b, 0xeb1a, 0xe21d, 0xe88d, 0xdfc1, 0xe5e6, 0xe252, 0xe487, 0xe4a1,
0xe294, 0xe2a3, 0xe235, 0xe4c5, 0xe495, 0xe778, 0xe9be, 0xe79c, 0xef2b, 0xe835,
0xf16a, 0xe808, 0xee52, 0xe88d, 0xebbd, 0xea02, 0xea74, 0xeafd, 0xe4c5, 0xeb06,
0xe55f, 0xed59, 0xe6bd, 0xef20, 0xe562, 0xf101, 0xe34b, 0xed66, 0xe159, 0xe7e2,
0xe25a, 0xe274, 0xe7b9, 0xdea5, 0xea70, 0xde7e, 0xeb76, 0xdb50, 0xeddd, 0xd7e0,
0xe95c, 0xd6b7, 0xe83d, 0xd599, 0xeb7b, 0xd5a2, 0xed1d, 0xdc4f, 0xebbd, 0xde68,
0xeca4, 0xdbce, 0xed9d, 0xdb8c, 0xea59, 0xdb1d, 0xe55d, 0xdb0b, 0xe57b, 0xdf70,
0xe723, 0xe447, 0xe8cf, 0xe6ef, 0xe9f9, 0xeaba, 0xe63b, 0xeff5, 0xe572, 0xf3c1,
0xe830, 0xef57, 0xe4c8, 0xea8d, 0xe35b, 0xe9d0, 0xe5bf, 0xe664, 0xe715, 0xe645,
0xe93c, 0xe96f, 0xef25, 0xebee, 0xf485, 0xef14, 0xf7d4, 0xefdc, 0xf77e, 0xeaa4,
0xf317, 0xe775, 0xedeb, 0xe525, 0xebb2, 0xe2f1, 0xeb47, 0xe5ff, 0xe5de, 0xe42b,
0xe5fe, 0xe17a, 0xe93a, 0xdf7f, 0xe88a, 0xdc12, 0xe552, 0xdb10, 0xe49a, 0xdcfb,
0xe4e3, 0xde90, 0xe181, 0xe043, 0xde54, 0xe305, 0xe282, 0xe655, 0xe279, 0xe44d,
0xdf55, 0xe2f2, 0xe053, 0xe439, 0xe2ee, 0xe646, 0xe624, 0xe749, 0xe712, 0xe603,
0xe846, 0xe581, 0xeb1d, 0xe671, 0xf0b3, 0xe815, 0xf322, 0xe630, 0xf35d, 0xe88b,
0xf551, 0xee6b, 0xf66d, 0xeffb, 0xf71c, 0xf177, 0xf810, 0xf28a, 0xf706, 0xecc9,
0xf80e, 0xe7dc, 0xfa73, 0xe3f1, 0xf768, 0xe03f, 0xefb8, 0xdcb8, 0xeb0b, 0xd9c3,
0xe76b, 0xdafe, 0xe2bc, 0xdfe9, 0xdf51, 0xe1f5, 0xdd95, 0xe064, 0xdd66, 0xdde8,
0xdb4a, 0xd638, 0xdbc8, 0xd47c, 0xdc64, 0xd9e8, 0xdb8d, 0xdd97, 0xdb1e, 0xdde2,
0xdc50, 0xe002, 0xde4b, 0xe3db, 0xdf5b, 0xe56d, 0xe322, 0xe605, 0xe6de, 0xe2d6,
0xea02, 0xe22b, 0xea60, 0xe2c6, 0xeb20, 0xe527, 0xed16, 0xea5c, 0xf006, 0xee07,
0xf145, 0xec62, 0xf1d2, 0xef12, 0xf4bc, 0xf412, 0xf774, 0xf36b, 0xf3d2, 0xf0bc,
0xee98, 0xed61, 0xecab, 0xe91d, 0xe887, 0xe519, 0xe5f8, 0xe370, 0xe5f9, 0xe227,
0xe70e, 0xe3c5, 0xe4c3, 0xe399, 0xdfd0, 0xe0cf, 0xde7c, 0xe073, 0xdfc6, 0xe042,
0xdeb4, 0xe0b5, 0xdda0, 0xe1bc, 0xe03b, 0xe686, 0xe033, 0xe8c4, 0xe1ab, 0xe5e1,
0xe6ba, 0xdf94, 0xeabb, 0xda63, 0xeba5, 0xdb54, 0xec2e, 0xdeba, 0xecf0, 0xe1b0,
0xec1f, 0xe62f, 0xeb74, 0xe88f, 0xeeb4, 0xe5f5, 0xf177, 0xe522, 0xf001, 0xe588,
0xf1ef, 0xe71e, 0xf149, 0xeaa5, 0xf125, 0xed9d, 0xf57f, 0xee25, 0xf91d, 0xf057,
0xf9b2, 0xf104, 0xf6be, 0xec8b, 0xf517, 0xec10, 0xf23d, 0xebb4, 0xed80, 0xe9cb,
0xe8d9, 0xe94a, 0xea4f, 0xead9, 0xf006, 0xeca9, 0xf2dc, 0xeb9a, 0xf126, 0xead0,
0xeff0, 0xedaf, 0xee9b, 0xee73, 0xeee2, 0xee71, 0xf086, 0xecbc, 0xee54, 0xe911,
0xec6d, 0xec0a, 0xed15, 0xf20b, 0xedb9, 0xf5d1, 0xec2e, 0xf3a9, 0xeca8, 0xf28c,
0xedcd, 0xf42b, 0xf12f, 0xf78e, 0xf14f, 0xf734, 0xf267, 0xf682, 0xf40d, 0xf51e,
0xf70d, 0xf597, 0xf77f, 0xf41d, 0xf88c, 0xf285, 0xfb6d, 0xf379, 0xf9d8, 0xf0b6,
0xf3c0, 0xed6b, 0xf262, 0xedbe, 0xfa2f, 0xecea, 0x017c, 0xec73, 0x0075, 0xeb1a,
0xfb8d, 0xe8a8, 0xf8f7, 0xec68, 0xf672, 0xef7c, 0xf678, 0xefb2, 0xf59f, 0xefcb,
0xf471, 0xedab, 0xf6f7, 0xee5b, 0xfae5, 0xf5c2, 0xfe56, 0xfd16, 0x00ab, 0xfe98,
0xff0e, 0xfe1b, 0xfd3a, 0xfdd3, 0xfbfe, 0xfcba, 0xfa86, 0xfad2, 0xf907, 0xf696,
0xf869, 0xf647, 0xf8e0, 0xf861, 0xf89a, 0xfaee, 0xf88a, 0xfd66, 0xf5e8, 0xfa42,
0xf0f7, 0xf680, 0xf07a, 0xf48b, 0xf5a7, 0xf306, 0xf87a, 0xf138, 0xfa19, 0xf0ae,
0xfb73, 0xefdd, 0xfbba, 0xf3a9, 0xfe28, 0xf9ac, 0x0014, 0xffe8, 0xfdfd, 0x0301,
0xfae8, 0x013c, 0xf802, 0xffee, 0xf784, 0xffda, 0xfa6c, 0xffa6, 0xf96a, 0x0172,
0xfa6d, 0x02f9, 0x0105, 0x024a, 0x06b9, 0x0737, 0x055b, 0x04e7, 0x05ce, 0xff8b,
0x0442, 0xff82, 0x0133, 0x011d, 0x0010, 0xff1c, 0x00c1, 0xfe86, 0xfefd, 0xfc64,
0xfcb8, 0xf98e, 0xfb9f, 0xf9ee, 0xf5e8, 0xf59f, 0xf506, 0xf325, 0xf7de, 0xf3c8,
0xfce5, 0xf617, 0xfe89, 0xf58e, 0xfda3, 0xf5c7, 0xfb0c, 0xf885, 0xf6f3, 0xfa19,
0xf840, 0xfd66, 0xfc18, 0x0027, 0xffb8, 0x0082, 0x039f, 0xfe98, 0x038a, 0xfc73,
0xfd54, 0xfb72, 0xfda8, 0xfe98, 0x00d8, 0x0274, 0xffcb, 0x00d3, 0x002c, 0xfdeb,
0xffbe, 0xfdd8, 0xfe3a, 0xfd9d, 0x011c, 0x0047, 0x061e, 0x050c, 0x09d3, 0x0356,
0x0e11, 0x0292, 0x0ea7, 0x0555, 0x1177, 0x09de, 0x1310, 0x0c9e, 0x0fc1, 0x09d0,
0x0e2c, 0x06b3, 0x0f77, 0x07dd, 0x0f7e, 0x06fa, 0x0b8d, 0x00f5, 0x0589, 0xfc91,
0x04a8, 0xfd07, 0x0852, 0x0184, 0x09c5, 0x0625, 0x0a33, 0x079f, 0x0899, 0x06b8,
0x07fb, 0x05f9, 0x0781, 0x04a1, 0x0765, 0x08aa, 0x06a8, 0x0bbb, 0x086d, 0x0a84,
0x0b65, 0x08b0, 0x0dd1, 0x0659, 0x1065, 0x065e, 0x13f8, 0x0a30, 0x14ca, 0x0c4c,
0x13c0, 0x0d7b, 0x1207, 0x0e64, 0x12bb, 0x0f74, 0x146b, 0x10dc, 0x1587, 0x1352,
0x156d, 0x13a6, 0x124e, 0x10d4, 0x11d1, 0x0e78, 0x1546, 0x0c13, 0x1818, 0x0cdc,
0x17c5, 0x10d8, 0x17c8, 0x132d, 0x1672, 0x1330, 0x13f1, 0x12f8, 0x13d5, 0x1191,
0x1535, 0x1137, 0x152c, 0x1070, 0x15a8, 0x0f6b, 0x15d9, 0x107d, 0x1397, 0x159a,
0x108f, 0x1959, 0x0f29, 0x174a, 0x0dfd, 0x11c2, 0x0f40, 0x0f10, 0x146c, 0x1198,
0x194e, 0x14be, 0x1b7a, 0x14bb, 0x1c2f, 0x154b, 0x1c82, 0x15af, 0x1df5, 0x1338,
0x1f4b, 0x12ae, 0x1e3f, 0x1457, 0x1dbe, 0x17e6, 0x1d78, 0x1d79, 0x1d22, 0x2380,
0x1e10, 0x26ff, 0x209e, 0x2764, 0x20e3, 0x26b6, 0x20db, 0x2678, 0x20d9, 0x2626,
0x1e25, 0x22bd, 0x1d65, 0x1f8a, 0x1c6c, 0x1f11, 0x16c6, 0x1b55, 0x15a9, 0x16fc,
0x1ab6, 0x16cf, 0x1c84, 0x139f, 0x1d40, 0x0f0e, 0x18af, 0x07f3, 0x1527, 0x0701,
0x14c1, 0x0c46, 0x1490, 0x0ebc, 0x1623, 0x0fd7, 0x11b6, 0x0ead, 0x107f, 0x122b,
0x135d, 0x15b8, 0x1712, 0x1a53, 0x1868, 0x1d04, 0x1a39, 0x1d6b, 0x1b27, 0x1ec0,
0x1b1a, 0x20e0, 0x1d65, 0x2044, 0x1eb7, 0x1e93, 0x1e16, 0x23fa, 0x1c1c, 0x2b24,
0x1c9f, 0x2f90, 0x201b, 0x31d3, 0x22e7, 0x3048, 0x2310, 0x2ccb, 0x20c6, 0x29f5,
0x1b0f, 0x24f9, 0x1972, 0x210e, 0x1afd, 0x1cf8, 0x1df9, 0x1a3d, 0x2216, 0x1a17,
0x2559, 0x1a83, 0x25d4, 0x1a60, 0x20d3, 0x1856, 0x20af, 0x1917, 0x224b, 0x19a9,
0x2131, 0x172c, 0x1dc0, 0x12a1, 0x172c, 0x1339, 0x118e, 0x19e8, 0x0cea, 0x1c1e,
0x0a9c, 0x1a0b, 0x0e44, 0x1800, 0x164c, 0x1800, 0x1d36, 0x187c, 0x207d, 0x1a92,
0x1f4d, 0x2010, 0x1b3e, 0x2161, 0x19bf, 0x1db3, 0x1d39, 0x1daf, 0x1f34, 0x1af5,
0x1db5, 0x1906, 0x1dde, 0x1d67, 0x1f4a, 0x1dc7, 0x203a, 0x1e53, 0x1e83, 0x213b,
0x1d67, 0x2022, 0x1c83, 0x1e80, 0x1edb, 0x210b, 0x1ff7, 0x1e78, 0x1c43, 0x1c56,
0x183f, 0x1b05, 0x18d2, 0x1b5d, 0x16aa, 0x1c8f, 0x127b, 0x17e0, 0x109e, 0x1333,
0x0f6f, 0x155d, 0x1165, 0x1679, 0x15d5, 0x14ed, 0x1981, 0x18f6, 0x1cf5, 0x21dc,
0x1ea8, 0x2717, 0x1f18, 0x289a, 0x203b, 0x2735, 0x20d6, 0x2577, 0x1f0a, 0x23aa,
0x1da2, 0x20fe, 0x1e13, 0x1dd1, 0x1ce4, 0x1ef7, 0x1c7f, 0x2231, 0x1a9d, 0x1ed5,
0x15fa, 0x1aeb, 0x11b1, 0x185e, 0x1410, 0x183c, 0x1598, 0x17e0, 0x1679, 0x17cb,
0x19f6, 0x157f, 0x1ce1, 0x11eb, 0x1c53, 0x10ee, 0x1b9e, 0x1541, 0x1c1d, 0x16e6,
0x1bdf, 0x15a8, 0x18ea, 0x15fc, 0x17df, 0x16a0, 0x1a3d, 0x184e, 0x1740, 0x1827,
0x14d3, 0x16ca, 0x1438, 0x166f, 0x185b, 0x1cef, 0x1be1, 0x1f62, 0x1e78, 0x1d61,
0x1e5a, 0x1bd1, 0x1bdb, 0x1ad2, 0x1899, 0x180c, 0x1393, 0x154a, 0x0fea, 0x16e7,
0x0e03, 0x17f5, 0x0e04, 0x1a88, 0x0d54, 0x1cba, 0x0cc7, 0x1b40, 0x0b22, 0x150f,
0x0d88, 0x1232, 0x1330, 0x1473, 0x17a8, 0x1b8c, 0x1664, 0x1f12, 0x13f3, 0x1ed9,
0x109f, 0x1d00, 0x10b4, 0x1ac6, 0x14d4, 0x1b79, 0x147a, 0x1c1f, 0x1356, 0x188f,
0x1331, 0x132e, 0x113d, 0x1377, 0x0e44, 0x1465, 0x0a4e, 0x1055, 0x0776, 0x0e35,
0x0652, 0x0e07, 0x08fb, 0x10ce, 0x06e0, 0x1386, 0x0488, 0x1552, 0x0779, 0x13c6,
0x0d32, 0x1248, 0x109b, 0x0f85, 0x1554, 0x0d24, 0x1a24, 0x0e5d, 0x16eb, 0x0e0b,
0x158d, 0x10ff, 0x1506, 0x14c9, 0x1054, 0x15b6, 0x0e5b, 0x1485, 0x1272, 0x1615,
0x12d4, 0x1677, 0x1402, 0x14d2, 0x12c8, 0x0f02, 0x1091, 0x0c4b, 0x1113, 0x0e2a,
0x122d, 0x1055, 0x11b0, 0x10b7, 0x11c1, 0x111b, 0x1148, 0x12e8, 0x108b, 0x13a5,
0x1309, 0x16ae, 0x1196, 0x1a75, 0x0e48, 0x1c42, 0x0e4a, 0x1b10, 0x0cfd, 0x19be,
0x0c15, 0x1b72, 0x0d20, 0x1c26, 0x0c1e, 0x1812, 0x0cf2, 0x1349, 0x0ba5, 0x1016,
0x05ea, 0x0c15, 0x05f0, 0x0ad2, 0x094b, 0x0d57, 0x0690, 0x0b93, 0x04cc, 0x0860,
0x05a2, 0x07e9, 0x04cc, 0x062f, 0x034f, 0x0271, 0x032d, 0xff95, 0x05cc, 0xffa8,
0x08d2, 0x03cd, 0x076f, 0x07ee, 0x0509, 0x0a69, 0x0675, 0x0bfd, 0x056e, 0x0b68,
0x0557, 0x0bea, 0x0676, 0x0cd9, 0x0727, 0x0dbb, 0x0864, 0x111a, 0x09ea, 0x1694,
0x0bb1, 0x175c, 0x0a55, 0x133f, 0x09c6, 0x0fac, 0x0bb1, 0x0d36, 0x0beb, 0x0af9,
0x0d08, 0x08f8, 0x0e6b, 0x06fd, 0x0e93, 0x0828, 0x0e13, 0x0b1c, 0x0e3a, 0x0ad1,
0x0cfa, 0x09bb, 0x06f5, 0x0898, 0x03ff, 0x07d0, 0x06a4, 0x0b45, 0x080e, 0x10ac,
0x05a3, 0x0dff, 0x03ea, 0x07cb, 0x0250, 0x06f9, 0x01e1, 0x0883, 0x01b8, 0x074c,
0x03b8, 0x05db, 0x0746, 0x02cb, 0x07ae, 0x00b8, 0x0590, 0x05f3, 0x044a, 0x0c52,
0x0388, 0x0b93, 0x0120, 0x08a2, 0x00f9, 0x05f4, 0x0067, 0x02a8, 0x004d, 0x0370,
0x008e, 0x047d, 0x0192, 0x0424, 0x0332, 0x0416, 0x071b, 0x0865, 0x096a, 0x0b76,
0x0c3e, 0x0ce7, 0x0e5a, 0x0ce7, 0x0d89, 0x0b33, 0x0e4d, 0x0988, 0x0e42, 0x06bc,
0x0b82, 0x02d7, 0x0662, 0xfe08, 0x0384, 0xfedf, 0x0071, 0xffc1, 0xffe4, 0xfe9e,
0x0068, 0xfd01, 0x0201, 0xfde6, 0x01d8, 0xfecf, 0xff60, 0x003b, 0xfc2f, 0xfcfa,
0xf8cd, 0xf92f, 0xfabb, 0xfe8e, 0xfabf, 0x0019, 0xf976, 0x0026, 0xf87f, 0x0375,
0xf906, 0x055d, 0xfa44, 0x03d8, 0xfafd, 0x033b, 0xf9cc, 0x03c5, 0xfb91, 0x062b,
0xff15, 0x06c3, 0x01c7, 0x07b0, 0x05e8, 0x092a, 0x0b7a, 0x0916, 0x0c67, 0x06a7,
0x09bc, 0x047b, 0x0950, 0x02f7, 0x0b62, 0x01db, 0x0c2c, 0x00a8, 0x0e41, 0x0098,
0x0c3f, 0xfeb9, 0x0a2e, 0x0058, 0x0daa, 0x0481, 0x0f5e, 0x0674, 0x0ad5, 0x052c,
0x09ed, 0x01fe, 0x0cfd, 0x00de, 0x0c0e, 0xfef8, 0x0b9d, 0xfc67, 0x099c, 0xfc74,
0x0816, 0x00cc, 0x07ac, 0x01f6, 0x0742, 0x0556, 0x03cc, 0x0991, 0xff2d, 0x0959,
0xfc69, 0x0816, 0xfaab, 0x09e6, 0xfaac, 0x0a10, 0xfc59, 0x0888, 0xfdd2, 0x08ec,
0x0099, 0x0a27, 0x0309, 0x0d36, 0x03a5, 0x0e0e, 0x06ac, 0x0d22, 0x0532, 0x083e,
0x0485, 0x063d, 0x06cc, 0x05e5, 0x07c9, 0x06fe, 0x06d3, 0x0969, 0x05d5, 0x0850,
0x0719, 0x0659, 0x0a23, 0x07fc, 0x0d06, 0x0a0b, 0x0bb0, 0x07dc, 0x081c, 0x056d,
0x0773, 0x063b, 0x0854, 0x06f1, 0x0740, 0x0411, 0x083c, 0xfe25, 0x0a8a, 0xfa6e,
0x0b5e, 0xfcd9, 0x0932, 0xfff2, 0x0814, 0x0329, 0x0631, 0x03bc, 0x0591, 0x0437,
0x08f6, 0x062d, 0x0b42, 0x063b, 0x0787, 0x055c, 0x0062, 0x05e7, 0xfdf0, 0x063a,
0x0074, 0x06b9, 0x056f, 0x071e, 0x0a94, 0x05f4, 0x0e8e, 0x06c9, 0x1197, 0x09cf,
0x0ced, 0x08bc, 0x03a8, 0x0716, 0xfedc, 0x07ef, 0xff84, 0x0a0d, 0x0055, 0x0c1f,
0x0151, 0x0d7b, 0xffb9, 0x0b44, 0x0043, 0x081b, 0x023d, 0x055a, 0x03d2, 0x05c7,
0x03d4, 0x04f6, 0x046b, 0x0258, 0x03cd, 0xfedc, 0x0243, 0xff16, 0x012c, 0x01e5,
0xfeb2, 0x0344, 0xfec1, 0x0578, 0xfc5d, 0x055f, 0xfa5c, 0x04a9, 0xfd36, 0x040c,
0xfe0b, 0x01c5, 0xf91f, 0x007d, 0xfb69, 0x0479, 0x0125, 0x046a, 0x05e6, 0x0364,
0x0a60, 0x0367, 0x0d89, 0x030a, 0x0d26, 0x0248, 0x09f8, 0x02c3, 0x0418, 0x00fb,
0x03cc, 0x01de, 0x05c0, 0x039b, 0x037b, 0x0263, 0xfe83, 0x0095, 0xfd2a, 0x0279,
0xfbfe, 0x0436, 0xf96e, 0x0366, 0xfaf1, 0x0270, 0xfc60, 0x00e2, 0xfdb0, 0x02c0,
0xfbe1, 0x0566, 0xf8c6, 0x045b, 0xf912, 0x006e, 0xfb26, 0xfd42, 0xfb78, 0xfc9b,
0xfe05, 0xff30, 0xff8a, 0x00be, 0xfff3, 0x01c5, 0xfc7f, 0xfe42, 0xfa86, 0xfc78,
0xfbee, 0xff38, 0xfbba, 0x00cc, 0xfbf7, 0xffc3, 0xfd16, 0xfe1b, 0xfeee, 0xff97,
0xffbc, 0xfe91, 0x00b4, 0xfe2e, 0xfe11, 0x0007, 0xfbf1, 0x0326, 0xfd2e, 0x04b7,
0xfc91, 0xffc6, 0xfaf4, 0xf970, 0xf691, 0xf792, 0xf1cc, 0xfa82, 0xf0f6, 0xfe8e,
0xef4f, 0xffad, 0xecfd, 0xfcb3, 0xeff7, 0xfb4f, 0xf33e, 0xf926, 0xf1c6, 0xf766,
0xedfc, 0xf871, 0xe98b, 0xf650, 0xe89c, 0xf476, 0xebbc, 0xf99f, 0xefd2, 0xfd30,
0xf080, 0xf9f7, 0xee69, 0xf68b, 0xf0d6, 0xf8ed, 0xf4d5, 0xfe72, 0xf4c9, 0x002a,
0xf6b7, 0xfdda, 0xfa4f, 0xfd7d, 0xfad9, 0xffcb, 0xfda9, 0x01eb, 0x00ce, 0xfff7,
0x0109, 0xfe20, 0xfeea, 0xffdd, 0xfb67, 0xfe8d, 0xf72b, 0xf7d6, 0xf5ed, 0xf5c3,
0xf4ed, 0xf442, 0xf464, 0xefed, 0xf242, 0xef4d, 0xef42, 0xf3fe, 0xee63, 0xf6de,
0xed91, 0xf4af, 0xea09, 0xf1f4, 0xe5f5, 0xee58, 0xe811, 0xecb3, 0xeb10, 0xeec4,
0xeb0c, 0xf1c1, 0xed0d, 0xf3aa, 0xeea8, 0xf410, 0xee76, 0xf36c, 0xeecd, 0xf3c8,
0xee80, 0xf64d, 0xed69, 0xf628, 0xeefe, 0xf5e1, 0xefbd, 0xf8c3, 0xecf7, 0xf9bb,
0xef6c, 0xfd10, 0xf347, 0xfe73, 0xf125, 0xfce0, 0xf0d2, 0xff51, 0xf054, 0xfe22,
0xeea7, 0xf92a, 0xf0ec, 0xf687, 0xf2a4, 0xf3b0, 0xf0a8, 0xf05a, 0xee0c, 0xeeca,
0xee95, 0xf029, 0xf047, 0xefd9, 0xf0fb, 0xef1f, 0xebda, 0xee4f, 0xe91a, 0xeda5,
0xea8d, 0xeac0, 0xedf5, 0xeaca, 0xf119, 0xebc0, 0xee73, 0xea28, 0xe962, 0xeb60,
0xe7a3, 0xec8f, 0xe8f2, 0xea16, 0xebb0, 0xec28, 0xeb42, 0xf0c7, 0xe622, 0xefca,
0xe39b, 0xf05b, 0xe1f7, 0xf0bb, 0xe130, 0xefde, 0xde8b, 0xee6a, 0xdef1, 0xee4b,
0xe410, 0xeea9, 0xe771, 0xf149, 0xe971, 0xf481, 0xea6d, 0xf629, 0xe9af, 0xf77d,
0xea07, 0xf61b, 0xeb63, 0xf2c8, 0xe8d3, 0xef6f, 0xe813, 0xebf0, 0xe8b8, 0xe865,
0xe58b, 0xe3b8, 0xe63a, 0xe03d, 0xe7dd, 0xddb0, 0xe995, 0xdf7b, 0xeb57, 0xe1ab,
0xed77, 0xe513, 0xecf7, 0xe6a5, 0xeba7, 0xe44a, 0xe89e, 0xe212, 0xe7a6, 0xe46d,
0xe941, 0xe92a, 0xe95f, 0xec9a, 0xea59, 0xee45, 0xeae3, 0xf00d, 0xe954, 0xf69f,
0xe4ce, 0xf77e, 0xe12d, 0xf278, 0xdd47, 0xed7c, 0xdd75, 0xea64, 0xde5b, 0xe720,
0xdfc9, 0xe649, 0xe310, 0xe5cf, 0xe434, 0xe953, 0xe1b0, 0xee48, 0xe2c7, 0xefdc,
0xe813, 0xf11e, 0xe83d, 0xf0a5, 0xe56a, 0xeb5f, 0xe39a, 0xe619, 0xe3c5, 0xe85b,
0xe0bc, 0xe918, 0xe0d7, 0xe909, 0xe1dc, 0xe6c7, 0xe2c7, 0xe43a, 0xe089, 0xe28f,
0xdcad, 0xe3fe, 0xdc31, 0xe617, 0xdd7c, 0xe925, 0xdf47, 0xebe8, 0xe189, 0xebed,
0xe205, 0xe96a, 0xe1bd, 0xe722, 0xe1e5, 0xe4c1, 0xe092, 0xe06e, 0xe2bb, 0xe06b,
0xe4d5, 0xe1d3, 0xe4ea, 0xe01f, 0xe4b3, 0xdc5d, 0xe708, 0xdc5e, 0xe569, 0xda77,
0xe09b, 0xda98, 0xdfba, 0xe00b, 0xe29a, 0xe3c4, 0xe552, 0xe281, 0xea5b, 0xe218,
0xed28, 0xe44c, 0xedd8, 0xe850, 0xeeab, 0xea31, 0xed10, 0xead2, 0xe91e, 0xee30,
0xe7d5, 0xeffb, 0xe64e, 0xedf6, 0xe273, 0xecf6, 0xdfbb, 0xed9a, 0xddd4, 0xed97,
0xde03, 0xed7c, 0xe07d, 0xe974, 0xe41f, 0xe5bd, 0xe6f9, 0xe78a, 0xe599, 0xe70b,
0xe428, 0xe74b, 0xe2d9, 0xe996, 0xe543, 0xe8bc, 0xea9a, 0xe734, 0xed3a, 0xe97c,
0xed71, 0xe977, 0xed50, 0xe614, 0xecbc, 0xe3a6, 0xecb7, 0xe178, 0xef9d, 0xe37b,
0xee99, 0xe5c0, 0xeacc, 0xe6b8, 0xe966, 0xe949, 0xeb5c, 0xeb44, 0xedb5, 0xecde,
0xea30, 0xecd5, 0xe4ea, 0xe7d8, 0xe5e9, 0xe51e, 0xe588, 0xe421, 0xe302, 0xe1e5,
0xe2a3, 0xe164, 0xe83e, 0xe59a, 0xf041, 0xeae8, 0xf2f7, 0xf11f, 0xf1e5, 0xf567,
0xf4bd, 0xf68f, 0xf459, 0xf51f, 0xef54, 0xf479, 0xed47, 0xf55f, 0xebdd, 0xf2e3,
0xeb6a, 0xf0b4, 0xee27, 0xf1cb, 0xedce, 0xf30c, 0xea05, 0xf2e2, 0xeb69, 0xf2a3,
0xeb83, 0xed9a, 0xea28, 0xeb27, 0xe6fb, 0xe93c, 0xe52f, 0xe802, 0xe005, 0xe3c5,
0xdc36, 0xe12f, 0xdd66, 0xe487, 0xdf25, 0xe730, 0xe2f7, 0xe7d5, 0xe7f0, 0xe669,
0xeea8, 0xe84c, 0xf092, 0xeb2c, 0xf1e0, 0xede1, 0xf1e3, 0xe922, 0xf4b8, 0xe5f4,
0xf4e9, 0xe59a, 0xf34e, 0xe6d5, 0xf39f, 0xe94e, 0xf621, 0xee8a, 0xf617, 0xf3c5,
0xf63a, 0xf5e0, 0xf93e, 0xf86e, 0xf67c, 0xf84f, 0xf314, 0xf722, 0xf049, 0xf586,
0xec42, 0xf201, 0xead0, 0xef09, 0xeb73, 0xeed6, 0xebb2, 0xef57, 0xee23, 0xf1c1,
0xecb7, 0xf187, 0xeb42, 0xeeed, 0xeaa8, 0xedd9, 0xeacf, 0xee01, 0xea12, 0xebd3,
0xe5ca, 0xe785, 0xe414, 0xe50a, 0xe599, 0xe53d, 0xe7ef, 0xe874, 0xe836, 0xea56,
0xe7d2, 0xe9f9, 0xec4a, 0xecba, 0xf13d, 0xecd1, 0xf44b, 0xeab5, 0xf52a, 0xeae6,
0xf3b6, 0xef39, 0xf049, 0xf362, 0xf12f, 0xf5d0, 0xf654, 0xf71e, 0xfb74, 0xf7f2,
0x0000, 0xf94f, 0x0244, 0xfc07, 0x0065, 0xfcc2, 0xff87, 0xfbf8, 0xfea1, 0xfb1f,
0xfe92, 0xf91a, 0xff6a, 0xf794, 0xfdbf, 0xf708, 0xfdcb, 0xf547, 0xfd38, 0xf27a,
0xfb51, 0xf34b, 0xf8a1, 0xf0c5, 0xf2eb, 0xea78, 0xec62, 0xe8a7, 0xe96e, 0xe7e7,
0xea6e, 0xe95a, 0xed24, 0xeafa, 0xefc2, 0xea32, 0xf021, 0xeb33, 0xf1d1, 0xedc7,
0xf22e, 0xf135, 0xeda2, 0xf491, 0xf087, 0xf961, 0xf584, 0xfc21, 0xf5fc, 0xfba1,
0xf99d, 0xfc94, 0xfbef, 0xfd6a, 0xfb36, 0xfdb7, 0xfde1, 0xff30, 0x0037, 0xff7c,
0xfeb7, 0xfaa9, 0xfda0, 0xf521, 0xff02, 0xf6a1, 0xffbe, 0xf8d2, 0x018c, 0xf836,
0x03cd, 0xf884, 0x0235, 0xf81b, 0xfd32, 0xf683, 0xf921, 0xf69f, 0xf894, 0xf705,
0xfb19, 0xf63c, 0xfe08, 0xf625, 0xfc9a, 0xf567, 0xf9e9, 0xf47b, 0xf74e, 0xf584,
0xf830, 0xf990, 0xfb27, 0xfaac, 0xfe93, 0xfaef, 0x02a3, 0xfd7d, 0x05cc, 0xff55,
0x0717, 0x006a, 0x0421, 0xfe09, 0x02da, 0xfcf3, 0x0241, 0xfe91, 0x0199, 0x0019,
0x02cb, 0xfdf8, 0x060b, 0xf903, 0x088f, 0xf73c, 0x0b59, 0xfb4b, 0x0912, 0xff17,
0x04db, 0x018a, 0x06a0, 0x0166, 0x0910, 0xfe17, 0x0c28, 0xfce2, 0x0d2e, 0xfa4c,
0x0792, 0xf91d, 0x0227, 0xfc82, 0x02ee, 0x017e, 0x02e4, 0x0480, 0x029c, 0x0518,
0x02bc, 0x07c8, 0xfea2, 0x0a58, 0xfba9, 0x0753, 0xfb0f, 0x0387, 0xfcd0, 0x04f1,
0x0074, 0x045e, 0x00be, 0x02b9, 0xfda3, 0x033a, 0xfc83, 0x01f5, 0xff53, 0x0177,
0x03c4, 0x0267, 0x0649, 0x02b2, 0x053d, 0xfef6, 0x0547, 0xfc9a, 0x05a9, 0xfe14,
0x03be, 0xfea8, 0x0366, 0xfe1a, 0x065d, 0x00a8, 0x08ff, 0x01eb, 0x0a79, 0x0446,
0x071f, 0x07ee, 0x070a, 0x0858, 0x0a73, 0x04b4, 0x0b81, 0x027a, 0x0c74, 0x02c0,
0x0bdc, 0x016e, 0x08f9, 0x01db, 0x0857, 0x0564, 0x0929, 0x0842, 0x0727, 0x0675,
0x06c5, 0x07bd, 0x0692, 0x0b06, 0x05cd, 0x0aa5, 0x0392, 0x051f, 0x0011, 0xfe9e,
0xfe7a, 0xfb83, 0xff99, 0xfbbc, 0x02f6, 0xfeca, 0x0639, 0xfff8, 0x079f, 0xfea1,
0x0c12, 0x012b, 0x0ea1, 0x0307, 0x0e25, 0x02fb, 0x0d67, 0x0613, 0x0c70, 0x0af2,
0x0b16, 0x08b4, 0x0cc5, 0x04a9, 0x0e4d, 0x02df, 0x1007, 0x043a, 0x0fdf, 0x056a,
0x0cdb, 0x06b3, 0x09e9, 0x07a4, 0x09fe, 0x08ea, 0x0c80, 0x0c0b, 0x11a7, 0x0f1a,
0x13b7, 0x0fe3, 0x0f12, 0x1028, 0x0d27, 0x111d, 0x0c6e, 0x0e6b, 0x09fd, 0x0bee,
0x0303, 0x0809, 0xfc7b, 0x03e7, 0xf96b, 0x0122, 0xfcef, 0x0012, 0x00d8, 0xfe37,
0x01ff, 0xfe56, 0x02b4, 0xfded, 0x0528, 0xfd75, 0x0723, 0x0059, 0x0598, 0xfeb0,
0x0487, 0xfaaa, 0x020a, 0xf8f1, 0x0236, 0xfa18, 0x04f1, 0xf96b, 0x085d, 0xf9b5,
0x0ad3, 0xf9f9, 0x0d99, 0xfa46, 0x0b93, 0xfb1d, 0x0ad8, 0xfe59, 0x0b87, 0x0041,
0x0988, 0x0333, 0x0c6e, 0x07b9, 0x0ff5, 0x0590, 0x0e53, 0x065e, 0x06bf, 0x08b7,
0x0349, 0x0aa4, 0x05e2, 0x0d8d, 0x09fa, 0x0ce6, 0x0d93, 0x0b1b, 0x0c62, 0x09cd,
0x09e9, 0x091b, 0x094b, 0x091f, 0x0a1b, 0x0a24, 0x07e9, 0x06af, 0x0857, 0x02fa,
0x0c8a, 0x03af, 0x0e83, 0x07b5, 0x0e01, 0x0b15, 0x0d16, 0x0bdc, 0x0e39, 0x0d8d,
0x0e1c, 0x0a8a, 0x1208, 0x094d, 0x15a7, 0x0815, 0x1709, 0x0749, 0x12b9, 0x0594,
0x1283, 0x096b, 0x13d4, 0x0b54, 0x1284, 0x08e8, 0x1434, 0x0798, 0x1563, 0x03e0,
0x124e, 0x00fb, 0x0b90, 0xfde8, 0x0905, 0xfc57, 0x06ae, 0xfa0f, 0x0648, 0xfa2a,
0x080b, 0xfb82, 0x085b, 0xfb5e, 0x0755, 0xf9ab, 0x0693, 0xf92e, 0x064f, 0xfcfd,
0x066f, 0x026c, 0x0544, 0x03e3, 0x0698, 0x065f, 0x08f1, 0x09b8, 0x08f9, 0x0b1f,
0x0a1b, 0x0e02, 0x0aed, 0x12be, 0x0c2c, 0x1576, 0x0f06, 0x13ef, 0x1119, 0x1252,
0x0d3e, 0x1004, 0x0a5f, 0x0d15, 0x0bda, 0x0c32, 0x0ce5, 0x0c36, 0x0df0, 0x09ef,
0x0e50, 0x085c, 0x0dc3, 0x08d8, 0x0ce6, 0x0885, 0x0c0b, 0x06f2, 0x0b50, 0x0615,
0x0954, 0x036f, 0x0743, 0xfffb, 0x0684, 0xfe58, 0x05b6, 0xf9d4, 0x077b, 0xf652,
0x0a8e, 0xf819, 0x0d0e, 0xfd08, 0x1045, 0xfe4b, 0x153e, 0xfccd, 0x16a8, 0xfd5d,
0x15c8, 0x00e3, 0x134b, 0xfea5, 0x0f53, 0xf9aa, 0x0dad, 0xfabb, 0x0cad, 0xfd20,
0x0cd4, 0x00f2, 0x10c8, 0x095c, 0x11f2, 0x0e34, 0x10dc, 0x0ebb, 0x1060, 0x0e49,
0x0ca3, 0x0d47, 0x09ff, 0x0eb2, 0x095b, 0x0f2c, 0x08ca, 0x0d68, 0x0891, 0x0b1d,
0x0ab2, 0x0b8f, 0x0d2a, 0x0d12, 0x0f96, 0x0d91, 0x1031, 0x0dfe, 0x0f6c, 0x103c,
0x102c, 0x111f, 0x0f6d, 0x0e14, 0x0b11, 0x0b09, 0x08be, 0x0857, 0x0871, 0x05f4,
0x0a4b, 0x071d, 0x0dfe, 0x08c5, 0x0d22, 0x05c6, 0x0b0b, 0x03d0, 0x0c32, 0x0792,
0x0e37, 0x0da6, 0x0cd2, 0x0ace, 0x0d9b, 0x069b, 0x0fe0, 0x06bf, 0x14ba, 0x0776,
0x1529, 0x0683, 0x1300, 0x0a75, 0x13e8, 0x0cc4, 0x147c, 0x08a1, 0x14b0, 0x04ad,
0x1339, 0x00a3, 0x11ec, 0xff36, 0x0e6e, 0xfd0c, 0x0c82, 0xfd48, 0x0aa3, 0x0033,
0x0a9e, 0x028f, 0x0df6, 0x03a8, 0x10fb, 0x05b5, 0x1017, 0x03bd, 0x0ffc, 0x02eb,
0x0fb0, 0x0633, 0x0d24, 0x0a1a, 0x0c43, 0x0d7e, 0x0c6b, 0x0e5b, 0x0c2b, 0x0f4f,
0x0aee, 0x0f97, 0x0a8a, 0x0d76, 0x0cbe, 0x09dc, 0x1104, 0x0786, 0x1262, 0x06d5,
0x1055, 0x0789, 0x1099, 0x0952, 0x125c, 0x09e2, 0x12fb, 0x0b0b, 0x1231, 0x0aab,
0x13bb, 0x0aac, 0x1252, 0x083a, 0x1034, 0x04b4, 0x12de, 0x0511, 0x1598, 0x057b,
0x17bd, 0x0557, 0x188b, 0x074e, 0x17e4, 0x0ce8, 0x1572, 0x1087, 0x14de, 0x11aa,
0x14de, 0x1245, 0x1513, 0x13b3, 0x13a8, 0x11ea, 0x115f, 0x0fed, 0x1189, 0x0fd3,
0x13fd, 0x0ec5, 0x15ed, 0x0c14, 0x175f, 0x09e3, 0x14c2, 0x065f, 0x122c, 0x0547,
0x1199, 0x07c6, 0x0e97, 0x09a6, 0x0bce, 0x0a87, 0x0b1e, 0x09ec, 0x0d32, 0x0c16,
0x0bfa, 0x0c0a, 0x0a60, 0x04f2, 0x0d97, 0xfec2, 0x1059, 0xff29, 0x132a, 0x03fe,
0x1516, 0x0852, 0x17f0, 0x0db2, 0x1a70, 0x12d6, 0x1770, 0x11e8, 0x1558, 0x0dae,
0x1648, 0x0ba5, 0x173c, 0x0d1f, 0x165a, 0x0d17, 0x165f, 0x0e6b, 0x12ea, 0x110d,
0x0eb8, 0x11e5, 0x0ffc, 0x1227, 0x110f, 0x1281, 0x1084, 0x1441, 0x1104, 0x165d,
0x0d78, 0x128d, 0x0bcb, 0x0e51, 0x0cf7, 0x0dd7, 0x0b77, 0x0c9c, 0x0d0d, 0x0a69,
0x0f69, 0x0a73, 0x1039, 0x0e6d, 0x0f4e, 0x1020, 0x1141, 0x1137, 0x14f3, 0x11ad,
0x166f, 0x1010, 0x180a, 0x0f24, 0x1cd1, 0x0e10, 0x1f4c, 0x0d9d, 0x1b68, 0x0c32,
0x1689, 0x0900, 0x137e, 0x085b, 0x1303, 0x0c26, 0x154d, 0x12b4, 0x1758, 0x15a1,
0x1a13, 0x1541, 0x1b9c, 0x16bc, 0x1abe, 0x15fa, 0x1cfb, 0x12b5, 0x1eab, 0x0f7b,
0x1f51, 0x0e96, 0x21f7, 0x1121, 0x23d0, 0x13b2, 0x23be, 0x14f9, 0x2248, 0x16ea,
0x1fa9, 0x16d9, 0x1db4, 0x1538, 0x1b45, 0x1695, 0x15c7, 0x141e, 0x1114, 0x0f75,
0x0c5f, 0x0b98, 0x09bd, 0x0a29, 0x0a4c, 0x0b41, 0x0cce, 0x0d5e, 0x108d, 0x0ff7,
0x142f, 0x1215, 0x17c8, 0x144f, 0x1864, 0x1631, 0x16ea, 0x18ea, 0x12ff, 0x1ad0,
0x1097, 0x19b2, 0x1281, 0x14c2, 0x1430, 0x11c0, 0x13c7, 0x11cb, 0x134c, 0x0f8e,
0x121f, 0x0aa3, 0x1274, 0x08c2, 0x15fa, 0x09e9, 0x1829, 0x0a80, 0x1722, 0x09d4,
0x15b3, 0x0b76, 0x1624, 0x0dc2, 0x160f, 0x0cca, 0x1569, 0x0da0, 0x1536, 0x0ef3,
0x16b9, 0x1136, 0x152a, 0x1394, 0x146d, 0x15d2, 0x1446, 0x15ef, 0x129c, 0x1432,
0x1305, 0x1343, 0x1515, 0x143b, 0x141e, 0x14b8, 0x1248, 0x15b9, 0x1304, 0x178c,
0x152f, 0x19c8, 0x17cc, 0x1b88, 0x1b83, 0x19bb, 0x1b7e, 0x17ca, 0x1917, 0x17e8,
0x1ca5, 0x1726, 0x1e9e, 0x1296, 0x1a68, 0x0ddc, 0x10f3, 0x0837, 0x0a02, 0x0645,
0x086c, 0x07b2, 0x0947, 0x097c, 0x0a09, 0x0af4, 0x0d97, 0x0a3c, 0x1154, 0x086f,
0x117c, 0x0850, 0x11f4, 0x09e7, 0x1485, 0x0e94, 0x12ee, 0x0fa9, 0x10dc, 0x0f2e,
0x0e2f, 0x10a2, 0x0910, 0x1037, 0x0a93, 0x11e8, 0x0d52, 0x1360, 0x0ee0, 0x13d1,
0x0f07, 0x1359, 0x0fd5, 0x13df, 0x0e18, 0x0f74, 0x0ca4, 0x0986, 0x0bc6, 0x071f,
0x0a19, 0x072d, 0x0697, 0x0786, 0x029a, 0x0719, 0x02ca, 0x0736, 0x0269, 0x066f,
0x01df, 0x08a5, 0x058a, 0x0b1a, 0x0bfb, 0x0c28, 0x0fb7, 0x0f41, 0x1156, 0x11b7,
0x128e, 0x1171, 0x123a, 0x12d2, 0x0fe9, 0x1272, 0x0d67, 0x1127, 0x0b4f, 0x13ea,
0x092c, 0x14fd, 0x06ab, 0x1348, 0x0685, 0x1468, 0x08b2, 0x11b3, 0x0b75, 0x0b32,
0x0a02, 0x081c, 0x0790, 0x06d3, 0x081b, 0x0536, 0x0905, 0x0561, 0x0ade, 0x0557,
0x0a33, 0x0474, 0x0921, 0x066c, 0x0b36, 0x07e2, 0x0c36, 0x07a2, 0x0b8b, 0x08a9,
0x0a4c, 0x0a04, 0x0775, 0x0bc7, 0x01ee, 0x0c1a, 0xffab, 0x0cdb, 0x010f, 0x0d16,
0x0415, 0x0d31, 0x02b7, 0x0cb6, 0xff70, 0x0bfc, 0xffb3, 0x0bcb, 0x005a, 0x0b70,
0xffd1, 0x09dc, 0xff0d, 0x07af, 0xfe2b, 0x07bf, 0xfe1e, 0x0821, 0x01a3, 0x0939,
0x01f2, 0x07b9, 0x00e9, 0x0395, 0x0307, 0xfee4, 0x087a, 0x0021, 0x0965, 0x017e,
0x09cc, 0x0140, 0x0881, 0xff17, 0x05ba, 0xfef5, 0x0487, 0xfec4, 0x0590, 0xfc6d,
0x074e, 0xfc80, 0x06e3, 0xfdaa, 0x0915, 0x01e3, 0x0c7c, 0x05f2, 0x0b66, 0x0707,
0x0541, 0x0761, 0x00f9, 0x074c, 0x019f, 0x05fc, 0x0106, 0x08d4, 0xfc46, 0x0e02,
0xfbfd, 0x0c9d, 0x00af, 0x0a23, 0x000b, 0x099d, 0xff26, 0x08a1, 0x0069, 0x08cf,
0xfe34, 0x08c2, 0xfeb7, 0x07e5, 0x0384, 0x06a2, 0x0353, 0x04d1, 0x00a3, 0x02c7,
0xff8a, 0x0178, 0xfe6a, 0x01e1, 0xfd80, 0x002c, 0x016b, 0xfebf, 0x0444, 0xfeac,
0x015c, 0xfe08, 0xfefc, 0xfe07, 0xfec2, 0xfee3, 0xfe9f, 0xffcc, 0xfcf3, 0xfe51,
0xfbab, 0xffa1, 0xfc30, 0x042c, 0xfe8e, 0x0665, 0xffc9, 0x0798, 0xfd4f, 0x09f4,
0xf978, 0x0b2a, 0xf732, 0x0b64, 0xf424, 0x0b54, 0xf32e, 0x0b3d, 0xf1d0, 0x04a3,
0xf322, 0x003d, 0xf8c4, 0x00e3, 0xfbb6, 0xffa2, 0xf9de, 0xfc51, 0xf8e2, 0xf9ad,
0xf8c3, 0xf978, 0xf729, 0xfa48, 0xf8ed, 0xfa6b, 0xfca4, 0xf84a, 0xfe78, 0xf72e,
0xfe6b, 0xf9a7, 0xfe9b, 0xfb8b, 0xffa6, 0xfaf4, 0x01a7, 0xfd8e, 0x01f0, 0xfebb,
0x03aa, 0xfe8f, 0x054d, 0xfdf7, 0x07c4, 0xfd50, 0x0545, 0xfc30, 0xfeab, 0xfdf3,
0xfcfc, 0x02de, 0xfab7, 0x06b2, 0xf9a9, 0x0a92, 0xf892, 0x07d2, 0xf880, 0x0687,
0xf94f, 0x07fe, 0xf9da, 0x05bc, 0xf741, 0x016b, 0xf399, 0x0023, 0xf259, 0x00c1,
0xf443, 0x00ed, 0xf58f, 0x01f8, 0xf44d, 0x024e, 0xf203, 0xfe0a, 0xf156, 0xf8ff,
0xf123, 0xf4c6, 0xf15a, 0xf317, 0xeffd, 0xf253, 0xedb1, 0xf0b8, 0xf141, 0xf3ee,
0xf554, 0xf48b, 0xf91b, 0xf514, 0xfaff, 0xf7e7, 0xfa35, 0xfb4b, 0xf811, 0xfc2d,
0xfa1c, 0xfd7f, 0xfaf7, 0xfd5e, 0xfa7d, 0xfd5e, 0xfa8c, 0xfe29, 0xfa46, 0xfd03,
0xfbf9, 0xfee0, 0xfb36, 0xffa2, 0xf975, 0xfd57, 0xf8cc, 0xfa07, 0xf75c, 0xf9b3,
0xf477, 0xfad6, 0xf311, 0xf9fa, 0xf2a2, 0xf6d2, 0xf107, 0xf408, 0xf0e1, 0xf607,
0xf484, 0xfcc9, 0xf94d, 0x0303, 0xfaf6, 0x05c9, 0xf9d0, 0x0951, 0xf7a5, 0x09db,
0xf51d, 0x058d, 0xf384, 0x02b4, 0xf21c, 0x00bf, 0xf19a, 0xff83, 0xf1c5, 0xfb70,
0xf5b5, 0xf815, 0xf93b, 0xf803, 0xfa41, 0xf79e, 0xfb48, 0xf56e, 0xfdac, 0xf683,
0xfe83, 0xf75f, 0xfcca, 0xf4a8, 0xfa25, 0xf276, 0xf711, 0xf11f, 0xf575, 0xf21e,
0xf3ab, 0xf259, 0xf1f9, 0xf3d6, 0xf244, 0xf600, 0xf45b, 0xf57f, 0xf62a, 0xf6e3,
0xf8b9, 0xf9b7, 0xfa34, 0xf8c3, 0xf9b6, 0xf778, 0xf96c, 0xf8e9, 0xf8d0, 0xfa68,
0xf89a, 0xfd6f, 0xf567, 0xfc70, 0xf3bd, 0xfbfd, 0xf3dc, 0xfb5a, 0xf6ec, 0xfa82,
0xf779, 0xfac0, 0xf662, 0xfcf5, 0xf615, 0xfeaa, 0xf2aa, 0xfc88, 0xf0ce, 0xfa72,
0xeef7, 0xf884, 0xee65, 0xf97b, 0xf0a3, 0xf92e, 0xf3a7, 0xfa93, 0xf28c, 0xfaee,
0xf319, 0xfb07, 0xf3e1, 0xfbb4, 0xf27f, 0xfae4, 0xf362, 0xfaf7, 0xf405, 0xfb27,
0xf308, 0xf923, 0xf129, 0xf615, 0xf1d9, 0xf600, 0xf33e, 0xf5e6, 0xf448, 0xf720,
0xf3b0, 0xf7f3, 0xf39b, 0xf6ac, 0xf578, 0xf57e, 0xf896, 0xf6c7, 0xf97e, 0xf81f,
0xf8ba, 0xf943, 0xf7ec, 0xfa31, 0xf743, 0xfbbd, 0xf76a, 0xfc68, 0xf8f6, 0xf9d2,
0xf95e, 0xf891, 0xf654, 0xf945, 0xf4c7, 0xfaae, 0xf3df, 0xfaed, 0xf3ac, 0xfa7c,
0xf4b1, 0xf9db, 0xf4ee, 0xf89b, 0xf3ae, 0xf7b5, 0xf22e, 0xf7cc, 0xefd8, 0xf789,
0xed8f, 0xf5f6, 0xedbd, 0xf512, 0xef25, 0xf5f9, 0xf01a, 0xf744, 0xf2fe, 0xfa23,
0xf3c9, 0xfc66, 0xf4b0, 0xfe15, 0xf477, 0xfd1f, 0xf212, 0xfafa, 0xf115, 0xf937,
0xf046, 0xf6e7, 0xf09c, 0xf67d, 0xf1ba, 0xf755, 0xf2cc, 0xf97b, 0xf34b, 0xfa44,
0xf4e7, 0xf9c1, 0xf64d, 0xf84f, 0xf4a1, 0xf571, 0xf24e, 0xf3c9, 0xefaf, 0xf14f,
0xeecd, 0xefd1, 0xee37, 0xeffa, 0xee94, 0xf1a4, 0xef13, 0xf264, 0xef86, 0xf3a7,
0xf004, 0xf4ce, 0xf125, 0xf64a, 0xf1e2, 0xf949, 0xf234, 0xf9d5, 0xf4d9, 0xf8b1,
0xf51d, 0xf734, 0xf402, 0xf685, 0xf4d3, 0xf781, 0xf5bf, 0xf9fa, 0xf5dd, 0xfbd4,
0xf612, 0xfd1f, 0xf690, 0xfec6, 0xf74e, 0xff85, 0xf6e8, 0xff7a, 0xf693, 0xfdf7,
0xf502, 0xfa0b, 0xf3b4, 0xf82e, 0xf39b, 0xf767, 0xf3c1, 0xf6de, 0xf3b6, 0xf5dd,
0xf417, 0xf582, 0xf3f1, 0xf682, 0xf39a, 0xf78b, 0xf2f3, 0xf6bf, 0xf114, 0xf583,
0xee17, 0xf439, 0xecf7, 0xf29b, 0xee22, 0xf12d, 0xf094, 0xf0c8, 0xf31d, 0xf368,
0xf52b, 0xf738, 0xf738, 0xfb31, 0xf711, 0xfcf9, 0xf732, 0xfcb9, 0xf7c3, 0xfb29,
0xf7f7, 0xfac9, 0xf6be, 0xf9ae, 0xf5ad, 0xf885, 0xf558, 0xf8f5, 0xf595, 0xf924,
0xf461, 0xf8ae, 0xf331, 0xf8a7, 0xf284, 0xf789, 0xf05f, 0xf5ca, 0xef5b, 0xf68d,
0xee4d, 0xf75b, 0xed85, 0xf735, 0xed38, 0xf59c, 0xeca2, 0xf434, 0xeb79, 0xf239,
0xedb1, 0xf342, 0xef8d, 0xf510, 0xef5e, 0xf63d, 0xf07f, 0xf75d, 0xf228, 0xf797,
0xf37f, 0xf8b3, 0xf43a, 0xf9d6, 0xf524, 0xfaba, 0xf67e, 0xfb1e, 0xf7a1, 0xfbcf,
0xf7c1, 0xfbee, 0xf7c7, 0xfc0e, 0xf7d6, 0xfc22, 0xf770, 0xfc00, 0xf60d, 0xfab9,
0xf554, 0xfaa9, 0xf5b2, 0xfb15, 0xf6c9, 0xfad8, 0xf73f, 0xfb3f, 0xf7b8, 0xfba6,
0xf726, 0xfb87, 0xf65c, 0xfb02, 0xf574, 0xfa43, 0xf400, 0xf91a, 0xf30f, 0xf855,
0xf29b, 0xf7fd, 0xf16d, 0xf73f, 0xf03d, 0xf64c, 0xef90, 0xf628, 0xef28, 0xf76f,
0xefe2, 0xf8c3, 0xefcc, 0xf909, 0xef62, 0xf935, 0xefe5, 0xf93a, 0xf0a1, 0xf8ea,
0xf105, 0xf9e4, 0xf1ba, 0xfb97, 0xf34c, 0xfd36, 0xf484, 0xfd9f, 0xf464, 0xfdad,
0xf44f, 0xfdbc, 0xf44e, 0xfcc2, 0xf448, 0xfc14, 0xf391, 0xfb3d, 0xf30d, 0xf9e2,
0xf1f8, 0xf804, 0xf055, 0xf687, 0xef92, 0xf69f, 0xef09, 0xf729, 0xf02c, 0xf8c9,
0xf1a7, 0xf9db, 0xf297, 0xf9c7, 0xf26b, 0xf966, 0xf181, 0xf8c2, 0xf204, 0xf93f,
0xf246, 0xf8e4, 0xf23e, 0xf877, 0xf1e0, 0xf80d, 0xf1af, 0xf7fb, 0xf208, 0xf879,
0xf271, 0xf89f, 0xf2e0, 0xf8a4, 0xf271, 0xf881, 0xf1f4, 0xf88c, 0xf1d3, 0xf877,
0xf129, 0xf893, 0xf110, 0xf842, 0xf088, 0xf86d, 0xf0d7, 0xf980, 0xf220, 0xf94e,
0xf201, 0xf864, 0xf160, 0xf7af, 0xf0f3, 0xf761, 0xf094, 0xf724, 0xefee, 0xf6cb,
0xef9b, 0xf684, 0xefdb, 0xf692, 0xf024, 0xf63d, 0xf01f, 0xf690, 0xf0a1, 0xf7a2,
0xf2a8, 0xf90e, 0xf3c8, 0xfa5a, 0xf494, 0xfbb6, 0xf547, 0xfc94, 0xf52c, 0xfc7f,
0xf52f, 0xfc2f, 0xf4d2, 0xfbcf, 0xf469, 0xfb05, 0xf3e5, 0xfa35, 0xf322, 0xf9aa,
0xf263, 0xf8d8, 0xf1c0, 0xf7af, 0xf12f, 0xf719, 0xf143, 0xf6d5, 0xf11f, 0xf67b,
0xf0b9, 0xf633, 0xf0ad, 0xf627, 0xf0c9, 0xf680, 0xf09d, 0xf61b, 0xf05b, 0xf5f5,
0xef39, 0xf4da, 0xee09, 0xf411, 0xedf1, 0xf3ca, 0xedfe, 0xf3b5, 0xee5d, 0xf3ff,
0xeebf, 0xf417, 0xef3f, 0xf505, 0xf084, 0xf64f, 0xf12a, 0xf677, 0xf0ff, 0xf614,
0xf1e2, 0xf735, 0xf352, 0xf824, 0xf4b4, 0xf95e, 0xf57d, 0xf9ec, 0xf63e, 0xfaa0,
0xf67b, 0xfae0, 0xf61d, 0xfa91, 0xf613, 0xfad7, 0xf40b, 0xf891, 0xf38d, 0xf833,
0xf2c9, 0xf7d4, 0xf1d2, 0xf6be, 0xf0ed, 0xf5b9, 0xf042, 0xf4fc, 0xef74, 0xf3fd,
0xf0fb, 0xf555, 0xf3c4, 0xf840, 0xf129, 0xf593, 0xf0b9, 0xf51e, 0xf167, 0xf54d,
0xeda1, 0xf153, 0xe4cb, 0xe83b, 0xe0e6, 0xe478, 0xe636, 0xead6, 0xf698, 0xfb46,
0xfd7c, 0x01b7, 0xeb4c, 0xf06d, 0xdea6, 0xe464, 0xec6a, 0xf0d1, 0x0a9d, 0x0f9c,
0x0818, 0x0e09, 0xed79, 0xf33c, 0xe306, 0xe8ae, 0xf711, 0xfc68, 0xf722, 0xfc5e,
0xe7f3, 0xebfc, 0xe7b6, 0xeae2, 0xdbd6, 0xe09a, 0xf95a, 0xff2c, 0x14ac, 0x19be,
0x0aae, 0x0ec9, 0xe82a, 0xebf9, 0xd96c, 0xddcd, 0xe0d3, 0xe69d, 0xefd0, 0xf532,
0xfaea, 0x006e, 0xffa5, 0x04a9, 0xf85a, 0xfc92, 0xef5e, 0xf49f, 0xf0b8, 0xf5e6,
0xed08, 0xf1ea, 0xd932, 0xdd33, 0xde01, 0xe263, 0xf243, 0xf675, 0xf03c, 0xf54e,
0xe4a6, 0xe9cf, 0xe086, 0xe650, 0xeb58, 0xf098, 0xede4, 0xf23f, 0xe3e1, 0xe74c,
0xd88c, 0xdcf5, 0xe777, 0xecdb, 0xeaf9, 0xf03a, 0xe7eb, 0xebf1, 0xdbb1, 0xdf57,
0xd8f3, 0xdca9, 0xd92d, 0xdce4, 0xe3c2, 0xe82a, 0xead9, 0xef5d, 0xf60b, 0xfaf1,
0xf608, 0xfb00, 0xea23, 0xee82, 0xeb40, 0xef0d, 0xeab9, 0xedf5, 0xe7cf, 0xeb9b,
0xde08, 0xe252, 0xeaf5, 0xee3b, 0xed1c, 0xefaa, 0xe58f, 0xe8f0, 0xd738, 0xda45,
0xe063, 0xe304, 0xeb3e, 0xed0c, 0xeac5, 0xebc5, 0xe5e5, 0xe690, 0xedee, 0xee54,
0xfe88, 0xffc8, 0xec38, 0xecdc, 0xda78, 0xdb56, 0xe144, 0xe431, 0xefba, 0xf270,
0xe3df, 0xe429, 0xdb42, 0xdab2, 0xdf45, 0xdfb5, 0xe503, 0xe649, 0xee0c, 0xef5f,
0xf132, 0xf24d, 0xf9f3, 0xfb23, 0xe7ce, 0xe852, 0xddf5, 0xde42, 0xe098, 0xe04a,
0xe0bf, 0xdfbe, 0xe37c, 0xe3c6, 0xe62e, 0xe7b6, 0xe7fd, 0xe916, 0xedad, 0xedcf,
0xf386, 0xf1ce, 0xf4b2, 0xf0bb, 0xf180, 0xed9a, 0xf31a, 0xef43, 0xfde0, 0xfa60,
0x0c29, 0x0954, 0xfa40, 0xf832, 0xf607, 0xf43f, 0xf71f, 0xf49e, 0xe35e, 0xe05a,
0xee31, 0xeaaa, 0xf88e, 0xf50f, 0xfeea, 0xfc9e, 0xf02f, 0xedec, 0xe687, 0xe27c,
0xe9bb, 0xe544, 0xec01, 0xe904, 0x0338, 0x0126, 0x041a, 0x01e7, 0xed37, 0xea36,
0xddf2, 0xd998, 0xea10, 0xe613, 0x01cf, 0xfd84, 0x0b99, 0x0521, 0x1b26, 0x15f9,
0x0eaa, 0x0b11, 0xf516, 0xf07d, 0xf1fc, 0xec89, 0xfad2, 0xf5a3, 0x0460, 0x0132,
0x0a99, 0x0870, 0xf067, 0xecc3, 0xf151, 0xeca8, 0x01ca, 0xfc4c, 0xf58c, 0xf14f,
0xfcce, 0xf9b4, 0xfe0f, 0xf959, 0x0693, 0x01ee, 0xf7c5, 0xf31b, 0xf7e3, 0xf2e2,
0x0468, 0x0115, 0xe748, 0xe4f1, 0xecb2, 0xe6ae, 0xfef6, 0xf698, 0x0533, 0xfe28,
0x0185, 0xfc25, 0xf681, 0xf317, 0xf2dd, 0xf014, 0xe721, 0xe41b, 0x1489, 0x1063,
0x2c71, 0x27a5, 0x07b5, 0x0330, 0xfd78, 0xf7b7, 0xe2e1, 0xdcd3, 0xdcc6, 0xd8ff,
0xf36e, 0xef86, 0x0083, 0xfad9, 0x06d7, 0x010f, 0x0200, 0xfceb, 0xff40, 0xfb2c,
0xfc3d, 0xf741, 0xf6d8, 0xf0ab, 0x0e7e, 0x088c, 0xede7, 0xe863, 0xde6d, 0xd83b,
0x0127, 0xf9e7, 0x0b5d, 0x048d, 0x2287, 0x1c78, 0x1f5e, 0x1a5e, 0x05ae, 0x014a,
0xe3ec, 0xdf1e, 0xe3cd, 0xde8c, 0xf951, 0xf432, 0x1ae3, 0x1631, 0x1132, 0x0d84,
0xfcf5, 0xf87b, 0x0146, 0xfb9f, 0x01e6, 0xfc12, 0x0575, 0x0070, 0x10ff, 0x0be2,
0x04a0, 0xfd73, 0x1d76, 0x16db, 0x2345, 0x1e76, 0xe91a, 0xe3fa, 0xec42, 0xe5cf,
0x0457, 0xfe45, 0x1df0, 0x19a7, 0x18b5, 0x13f9, 0x0cb4, 0x066c, 0xff10, 0xf90a,
0xea85, 0xe4bc, 0xf401, 0xecf9, 0x0ac2, 0x0448, 0x1f0d, 0x1a76, 0x0e1b, 0x0923,
0x0a2b, 0x042d, 0x0e40, 0x0902, 0x122b, 0x0dd7, 0xf0da, 0xebd4, 0xe753, 0xe0a2,
0xfd2e, 0xf690, 0xf435, 0xedc1, 0xfe9c, 0xf7b1, 0x0510, 0xfee9, 0x09fc, 0x0423,
0xee54, 0xe87f, 0x0e71, 0x06bc, 0x3a7e, 0x3294, 0x0c0b, 0x05c0, 0x08df, 0x0303,
0x0ac5, 0x06b3, 0xf67c, 0xf29e, 0x088a, 0x0338, 0x0ac6, 0x054a, 0x0246, 0xfcf6,
0x0950, 0x0357, 0x0f2f, 0x098d, 0x0cf0, 0x0852, 0x0721, 0x0106, 0x1e83, 0x16d7,
0x1a3b, 0x1286, 0x08aa, 0x0285, 0x243e, 0x1f0a, 0x03cd, 0xff20, 0xed28, 0xe7e3,
0xef13, 0xe7df, 0x21ae, 0x1aeb, 0x1d6c, 0x17b0, 0xfd81, 0xf96b, 0x0a37, 0x0702,
0x173c, 0x1576, 0x1239, 0x10b9, 0xf7c5, 0xf4d2, 0x1b1c, 0x16ec, 0x1ce8, 0x18e9,
0x0f58, 0x0cbe, 0x09f4, 0x080b, 0x1628, 0x1304, 0x175b, 0x1178, 0x0412, 0xff30,
0x14a5, 0x101e, 0x0914, 0x043b, 0x09db, 0x064f, 0x1984, 0x1716, 0x3712, 0x3360,
0x2de2, 0x290d, 0x0ef8, 0x0cb2, 0xf611, 0xf274, 0x0ef7, 0x09dc, 0x24e7, 0x2246,
0xff89, 0xfdfc, 0xfc58, 0xfa95, 0x0c5e, 0x0a31, 0x2020, 0x1ca6, 0xf37d, 0xef95,
0xfae7, 0xfa0b, 0x190e, 0x1a0a, 0x30d4, 0x2f07, 0x0ccf, 0x0970, 0xf6c3, 0xf2e3,
0x0125, 0xfb95, 0x03f3, 0x000e, 0x0f6f, 0x0e3a, 0x11b0, 0x10ff, 0x1ccc, 0x1c5e,
0x1e30, 0x1d5d, 0x1f0d, 0x1c51, 0x16ae, 0x137b, 0x00bc, 0x0010, 0x0534, 0x03a1,
0x17b5, 0x15c1, 0x2474, 0x258c, 0x0740, 0x07cc, 0x0848, 0x0947, 0x1e2a, 0x1f54,
0x20aa, 0x1e58, 0x139b, 0x0e8e, 0x12af, 0x0dd6, 0x2763, 0x2629, 0x1ca1, 0x1e4c,
0x052c, 0x0658, 0xf296, 0xf1ac, 0xec8b, 0xeac9, 0x09d5, 0x0858, 0x1fdb, 0x1f35,
0x191b, 0x1998, 0x0b9e, 0x0b55, 0x0783, 0x07d2, 0x12e8, 0x145c, 0x1a65, 0x180b,
0x175c, 0x131d, 0x10d0, 0x10c5, 0x107b, 0x11d7, 0x0fb2, 0x0fd8, 0x121f, 0x112b,
0x12ba, 0x1109, 0x1dcf, 0x1a90, 0x0e44, 0x0af2, 0x069e, 0x0690, 0x0737, 0x0882,
0x0fb5, 0x1083, 0x0625, 0x05bc, 0x0a7b, 0x0a08, 0x1d08, 0x1c03, 0x24b5, 0x21db,
0x056b, 0x0210, 0xde84, 0xdbc6, 0xea95, 0xe81e, 0x1564, 0x119a, 0x27ac, 0x24cd,
0x16b2, 0x138f, 0x0466, 0xffd3, 0x01e8, 0xff2a, 0x10ab, 0x1213, 0x0643, 0x05e6,
0x0a9e, 0x0708, 0x1088, 0x0e8e, 0x06bc, 0x038f, 0x106b, 0x0e58, 0x1011, 0x0f30,
0x13d1, 0x11a7, 0x2498, 0x2397, 0x2d76, 0x2d34, 0x1d52, 0x1c80, 0xfb5b, 0xfa6a,
0xf2f8, 0xf2f1, 0x0dc9, 0x0e0e, 0x2080, 0x1fc1, 0xfa64, 0xf9e6, 0xf6c8, 0xf497,
0x00f6, 0xfb92, 0xfe0f, 0xfaaf, 0x12ba, 0x146d, 0x08b9, 0x0af9, 0xfdcf, 0xfc6f,
0x0b89, 0x09f8, 0x12f4, 0x1330, 0x150d, 0x1359, 0x117c, 0x0cbd, 0x0ad8, 0x08a2,
0x05a4, 0x0687, 0x00f6, 0x0040, 0x0f8f, 0x0de8, 0xf8de, 0xf753, 0xfd49, 0xfd72,
0x1ccc, 0x1d3c, 0x156e, 0x14a1, 0x0476, 0x043a, 0xf997, 0xf7ec, 0x00f4, 0x0008,
0x04d1, 0x0674, 0x1fba, 0x215e, 0x3e87, 0x3d11, 0xfdb3, 0xfa9a, 0xe38f, 0xe3ac,
0xfff3, 0x02bc, 0x28b0, 0x2a56, 0x305d, 0x2fd7, 0x1265, 0x13b2, 0xf722, 0xf939,
0xef78, 0xedf6, 0x1ef5, 0x1a1f, 0x3351, 0x301c, 0x0da3, 0x0e56, 0x09ae, 0x0838,
0x088f, 0x03ae, 0x00ad, 0xfcf9, 0xfb47, 0xf914, 0x147b, 0x11dc, 0x2689, 0x249e,
0x08e0, 0x07d5, 0xff2f, 0xfe78, 0xfcef, 0xfc37, 0x04e2, 0x03e9, 0xf9f4, 0xf8b4,
0x0e39, 0x0cbb, 0x1c34, 0x1ccb, 0x07e6, 0x0910, 0x06a8, 0x0695, 0x03b1, 0x0337,
0x06db, 0x0828, 0xff68, 0x0136, 0x200f, 0x217d, 0x31c5, 0x3352, 0x1075, 0x11d3,
0x027d, 0x02fe, 0x08a1, 0x06bd, 0x0efd, 0x0b83, 0xec42, 0xe898, 0xf23c, 0xf12d,
0xfcec, 0xfd13, 0xfb39, 0xfa57, 0x14ea, 0x13a3, 0x2581, 0x2437, 0x21f9, 0x20e9,
0xff4d, 0xff5a, 0xe552, 0xe699, 0xe77b, 0xe7af, 0xf583, 0xf351, 0xe525, 0xe2fe,
0xef63, 0xec63, 0x06e2, 0x04e6, 0x0316, 0x0348, 0x1511, 0x1419, 0x152f, 0x148e,
0xfae9, 0xfa3d, 0x0179, 0x023e, 0x0369, 0x0391, 0x0523, 0x053c, 0x089e, 0x0b0c,
0x16b9, 0x19fc, 0x113f, 0x118f, 0xf8bd, 0xf39d, 0x02ae, 0xfddc, 0x1264, 0x10c5,
0x1486, 0x14c8, 0xfb31, 0xfa04, 0xf99c, 0xf705, 0xf7ec, 0xf599, 0xf5f5, 0xf450,
0x1b56, 0x1bb2, 0x19d9, 0x19a9, 0x0236, 0x0197, 0xf500, 0xf427, 0xe781, 0xe73b,
0xf58f, 0xf68d, 0x0d20, 0x0dec, 0x038d, 0x04f7, 0x012f, 0x024f, 0x043b, 0x03e2,
0x0baf, 0x0886, 0xec6f, 0xe87e, 0xddf8, 0xdb9f, 0xf8e5, 0xf77b, 0xf7ac, 0xf30e,
0x140f, 0x0e76, 0x2a5f, 0x281b, 0x18e7, 0x1582, 0xf953, 0xf61c, 0xf821, 0xf594,
0x0a35, 0x05f1, 0x04cd, 0x016b, 0x11ad, 0x1094, 0x13e1, 0x11f6, 0xf8b6, 0xf424,
0xf2b5, 0xedab, 0xfa35, 0xf3d6, 0x0322, 0xfc86, 0x100a, 0x0980, 0x1157, 0x0b67,
0x1376, 0x0ecf, 0x27fe, 0x251d, 0x0862, 0x05fa, 0xf41d, 0xefb0, 0xf73c, 0xf2ec,
0x1b83, 0x17e2, 0xfb90, 0xf8d4, 0xe2bb, 0xe26a, 0x0050, 0x033d, 0x0331, 0x0285,
0x194c, 0x1514, 0x1ed0, 0x1cfb, 0xfdd2, 0xfe95, 0xfb98, 0xfd23, 0x101a, 0x0aef,
0x072b, 0xfe28, 0x18ea, 0x1040, 0x2baa, 0x252f, 0x2c52, 0x29cb, 0xf846, 0xf43a,
0x14eb, 0x10b3, 0x2774, 0x2449, 0x09b7, 0x064a, 0x1dbe, 0x1a22, 0x1b65, 0x1838,
0x151a, 0x1435, 0x16f6, 0x146f, 0x1997, 0x144b, 0x1ca6, 0x17ee, 0x1d3d, 0x19fd,
0x0f2b, 0x0c0d, 0xfc3f, 0xf93e, 0xf8ee, 0xf84b, 0x15f0, 0x13bf, 0x12a7, 0x10f5,
0x07b6, 0x077c, 0x0089, 0xfe90, 0x1518, 0x12e4, 0x0ad6, 0x0a62, 0x046e, 0x0694,
0x29c6, 0x2924, 0x1fb6, 0x1c42, 0x0d22, 0x0bcd, 0x02ad, 0x01bf, 0x0a16, 0x07a2,
0x13b6, 0x10b1, 0x0ff5, 0x1107, 0x0925, 0x09f2, 0x07db, 0x05e1, 0x0e30, 0x0ebe,
0x1612, 0x13f5, 0x2c40, 0x27ac, 0x1c0a, 0x1470, 0x07f6, 0xfffc, 0x0b49, 0x0691,
0x243e, 0x1f67, 0x1efa, 0x1b57, 0x0427, 0x02f1, 0x1eb6, 0x1d58, 0x0c36, 0x0b47,
0x0139, 0x00ef, 0x2112, 0x1def, 0x067a, 0x0290, 0x0375, 0x011b, 0x117c, 0x0ede,
0x1d4d, 0x1ac2, 0x0c5b, 0x0ad7, 0xfd7f, 0xfc8a, 0x0cdf, 0x0979, 0x049e, 0x0104,
0x1c60, 0x1a42, 0x2cd9, 0x29ee, 0x034b, 0xff26, 0xf6f9, 0xf271, 0x0156, 0xfe30,
0x162a, 0x12d8, 0x180a, 0x15a5, 0x16de, 0x168d, 0x1b52, 0x18de, 0x400f, 0x3b0c,
0x1631, 0x10aa, 0xf084, 0xebb0, 0xfa9c, 0xf8cb, 0x303d, 0x2f01, 0x339e, 0x317a,
0x0ccb, 0x0b24, 0x0eb3, 0x0c1d, 0x1613, 0x1152, 0x13a8, 0x0cb3, 0xf57c, 0xf05b,
0x1223, 0x0e0c, 0x1ab9, 0x186b, 0x1673, 0x1606, 0x0927, 0x06cb, 0x1e72, 0x1aa2,
0x28e6, 0x2451, 0x251a, 0x2298, 0x0535, 0x0311, 0x1fbb, 0x1d48, 0x349c, 0x3352,
0xf436, 0xf182, 0x0615, 0x0291, 0x1d78, 0x1a88, 0x1937, 0x16ca, 0x18f7, 0x1909,
0x0132, 0x0144, 0x0569, 0x0547, 0x3aab, 0x3c2d, 0x30de, 0x3104, 0x14d3, 0x11d4,
0x08ff, 0x06d5, 0x0875, 0x08c4, 0x0e22, 0x0df3, 0x0d32, 0x08e7, 0xff9f, 0xfc10,
0x2fb1, 0x2f16, 0x3754, 0x36fc, 0x10c9, 0x11c2, 0xf785, 0xf5ca, 0x0ac7, 0x078b,
0x220f, 0x1ea7, 0x1d48, 0x1898, 0x2258, 0x1f8e, 0x0cda, 0x0d12, 0xfaf5, 0xfcbd,
0x1b0d, 0x19d4, 0x1559, 0x15d9, 0x0864, 0x0cc0, 0x06ab, 0x076c, 0x1aef, 0x1b5e,
0x1d1f, 0x1f9a, 0x0da7, 0x0e37, 0x082d, 0x0743, 0x2aa4, 0x2abd, 0x3263, 0x317c,
0xfebe, 0xfdeb, 0x0c1e, 0x0b02, 0x2193, 0x1f56, 0x2b9c, 0x294d, 0x0ea5, 0x0ec4,
0x1539, 0x1686, 0x1c0e, 0x1b40, 0x0853, 0x0561, 0x25a0, 0x23eb, 0x1003, 0x0ebc,
0xfc08, 0xfa3f, 0x1869, 0x18dc, 0x12e1, 0x143b, 0x0dea, 0x0dcf, 0x15a3, 0x14d6,
0xf8de, 0xf973, 0x0b03, 0x0cf2, 0x2946, 0x2ba0, 0x2339, 0x2472, 0x0736, 0x07e0,
0xfabb, 0xfc60, 0x0ae1, 0x0d85, 0xe8fc, 0xec29, 0xfd4a, 0x00f6, 0x1b06, 0x1d27,
0x1113, 0x12f2, 0x0d81, 0x112c, 0x0d0a, 0x10b4, 0x09cc, 0x097b, 0x0bc5, 0x0b1a,
0x011a, 0x037d, 0xffbc, 0xfd2f, 0x0a29, 0x07a5, 0x10dc, 0x109b, 0x0444, 0x03c1,
0xf741, 0xfc91, 0x0cad, 0x118b, 0x10b6, 0x1262, 0x0f42, 0x108b, 0x05a5, 0x08bc,
0x0c61, 0x1025, 0x142c, 0x1832, 0x1168, 0x154a, 0x0260, 0x022b, 0xf932, 0xf845,
0x00c3, 0x04b0, 0x142a, 0x1a86, 0x1129, 0x1928, 0x1766, 0x1d2b, 0x2280, 0x2730,
0x15f7, 0x1d86, 0x01e7, 0x08ee, 0xf5ab, 0xf829, 0xfb8f, 0xfea9, 0xf839, 0x00d2,
0xf6f4, 0x0051, 0xf440, 0xf87f, 0x14b0, 0x193a, 0xfe5b, 0x06e3, 0xe9b1, 0xf0b0,
0xef5b, 0xf19f, 0x1fb1, 0x1fe9, 0x2225, 0x2661, 0x021c, 0x087c, 0x1288, 0x1747,
0xf123, 0xf654, 0xe54f, 0xec59, 0xfa06, 0x01cf, 0xf736, 0xfea9, 0xfa39, 0x01ea,
0xfbe8, 0x059d, 0xfc44, 0xff1b, 0xe925, 0xe877, 0xf1fe, 0xf552, 0x0eb1, 0x1384,
0x0461, 0x0991, 0xe3bf, 0xe701, 0xd805, 0xd959, 0xf63d, 0xfca7, 0x0537, 0x0c23,
0x03cc, 0x055e, 0xfe41, 0xfcea, 0xeb37, 0xeb5a, 0xfde2, 0xff32, 0x13de, 0x13fc,
0x0aa5, 0x0a40, 0xf79f, 0xfae0, 0xe4b9, 0xed5f, 0xda88, 0xde3d, 0xedfc, 0xed91,
0xf0f0, 0xf20d, 0xf422, 0xf6e3, 0xfe2b, 0x01dd, 0x06de, 0x09e0, 0x0095, 0x02d8,
0xf102, 0xf1eb, 0x022e, 0x0546, 0x0a8a, 0x1141, 0x00cf, 0x056e, 0xd998, 0xdccb,
0xdb7c, 0xe069, 0xe2c0, 0xead4, 0xeca8, 0xf3e8, 0xeb39, 0xef6a, 0xf9d8, 0xff69,
0xffce, 0x08a4, 0xe631, 0xebdf, 0xdc1f, 0xdca1, 0xe757, 0xea25, 0xffc7, 0x0296,
0xf147, 0xf413, 0xe369, 0xe82f, 0xe369, 0xe833, 0x096e, 0x0d50, 0x0154, 0x0403,
0x0bb0, 0x1062, 0x17ba, 0x1b5b, 0x1d63, 0x2548, 0xfc52, 0x05ea, 0xdc2d, 0xe3a4,
0xe8d5, 0xf0f6, 0xef10, 0xf52c, 0xfd03, 0x03b6, 0xf207, 0xfbab, 0xd535, 0xdf13,
0xca9c, 0xd098, 0xe6ba, 0xe9bc, 0x1087, 0x1503, 0x0a9b, 0x0fb0, 0xf141, 0xf616,
0xdf25, 0xe65c, 0xd0be, 0xd7e5, 0xe515, 0xea6b, 0xffae, 0x0490, 0x198c, 0x2025,
0xf29d, 0xf7c3, 0xd03e, 0xd34d, 0xd6b5, 0xd8f7, 0xf472, 0xf7f6, 0x0018, 0x0640,
0xf490, 0xfa46, 0xdf71, 0xe3b8, 0xc55f, 0xca18, 0xc29e, 0xc7a5, 0xcd36, 0xd1a1,
0xe228, 0xe52d, 0xe765, 0xeb2a, 0xe801, 0xed26, 0xe837, 0xebe7, 0xe48c, 0xe6ed,
0xd775, 0xdaef, 0xd80c, 0xdbc3, 0xec92, 0xf05a, 0xe05f, 0xe272, 0xd591, 0xd799,
0xda35, 0xdfbc, 0xd910, 0xdfdd, 0xe1d5, 0xe5b7, 0xe050, 0xdff0, 0xcba5, 0xca9f,
0xd725, 0xd889, 0xe703, 0xe907, 0xe67e, 0xe9e4, 0xcf06, 0xd4c5, 0xc2bd, 0xc676,
0xd093, 0xcf77, 0xd509, 0xd2b6, 0xe571, 0xe63e, 0xd6cc, 0xd9d9, 0xceb3, 0xce73,
0xd929, 0xd6c3, 0x0179, 0xfe5d, 0x0b80, 0x06a5, 0xe7be, 0xe61a, 0xcd93, 0xcabd,
0xcb99, 0xc899, 0xdf7b, 0xdcdd, 0xe771, 0xe592, 0xe9d5, 0xead8, 0xeb09, 0xeb0a,
0xf2f0, 0xf355, 0xcee7, 0xcd43, 0xd4b3, 0xcf8b, 0xeb7f, 0xeb0a, 0xe893, 0xed13,
0xd08e, 0xd67a, 0xc8eb, 0xccd9, 0xdebb, 0xe0be, 0xd9ba, 0xd9c7, 0xddcc, 0xde79,
0xe414, 0xe6c7, 0x055b, 0x0606, 0x0e17, 0x0d86, 0x0fb5, 0x0bd7, 0x0d40, 0x049e,
0x2a69, 0x2256, 0x2166, 0x1b96, 0xfe3c, 0xf7d5, 0xf0c7, 0xec05, 0xea38, 0xe915,
0xeab3, 0xea82, 0xe7d6, 0xe526, 0xefe6, 0xed13, 0x06f5, 0x0351, 0x110c, 0x0b31,
0xf5da, 0xec58, 0xe010, 0xd800, 0xe597, 0xe291, 0xfef5, 0xfcfc, 0x0808, 0x035a,
0x0173, 0xfd77, 0xe848, 0xe52f, 0xe3bb, 0xdeea, 0xcd0d, 0xc5f7, 0xe752, 0xe14f,
0x1369, 0x0e92, 0x2973, 0x226d, 0x02c9, 0xfc22, 0xd5e9, 0xcf9c, 0xd77c, 0xd4f9,
0xf90e, 0xf7c2, 0x09eb, 0x0762, 0x0371, 0x030f, 0xecce, 0xed4e, 0x0310, 0xffd6,
0x1257, 0x0aed, 0xf240, 0xebab, 0xf93e, 0xf5ae, 0xfa01, 0xf58d, 0xf999, 0xf4d9,
0xf916, 0xf327, 0xf5c6, 0xeb01, 0xf76c, 0xef0d, 0x052b, 0x00d1, 0xfd4b, 0xf918,
0x0293, 0xfaf7, 0x053a, 0xfb61, 0xea0e, 0xe348, 0xe7a0, 0xe157, 0xf7be, 0xf3fe,
0x0fb4, 0x1114, 0xf0b7, 0xf135, 0xe039, 0xd9d6, 0xf2bf, 0xe98b, 0xf552, 0xef84,
0x0d36, 0x092c, 0x1165, 0x0caf, 0x0583, 0xfeba, 0x07f7, 0xff99, 0x0039, 0xf824,
0xf25f, 0xeb75, 0xf028, 0xebc1, 0xe206, 0xdd82, 0xe7c0, 0xe1b0, 0xfca3, 0xf75d,
0xf6d6, 0xf361, 0xee6a, 0xeb52, 0xf0aa, 0xe9d8, 0xf7ff, 0xef28, 0x04b6, 0xfe85,
0xfcc5, 0xf86a, 0xe5d4, 0xe0c5, 0xe9d8, 0xe36e, 0xf379, 0xef67, 0xf5df, 0xf332,
0xefe4, 0xe823, 0xeed3, 0xe536, 0xf50c, 0xf066, 0xfc4b, 0xfb4a, 0x08ca, 0x05b1,
0x1e8d, 0x17e4, 0x1ee3, 0x1a09, 0xf995, 0xf4ec, 0xde93, 0xda5a, 0xefa6, 0xeb25,
0x0ed8, 0x070a, 0xefbd, 0xe8c9, 0xf504, 0xf289, 0x0442, 0x0573, 0x0375, 0xfff7,
0xfe66, 0xf4ac, 0x0330, 0xf6eb, 0x0c86, 0x03a1, 0xf2e9, 0xeb31, 0xf1bb, 0xe8b0,
0xfdfc, 0xf465, 0xfb5a, 0xf2f6, 0x0b6f, 0x008e, 0x074e, 0xfa3b, 0xf9a7, 0xf0fc,
0xf430, 0xefa3, 0x069f, 0x0300, 0x1475, 0x0c66, 0xfcca, 0xf560, 0x0174, 0xfb58,
0xfa6f, 0xf5ff, 0xf77a, 0xf450, 0x0587, 0x0261, 0x0c09, 0x08b5, 0x04a5, 0xffab,
0xf97c, 0xf4db, 0xf81c, 0xf3f8, 0x100d, 0x0c17, 0x2764, 0x2172, 0x16ee, 0x0fab,
0x058c, 0x0134, 0xfb41, 0xf6ae, 0xeece, 0xed40, 0x0a30, 0x0a5b, 0x05de, 0x091a,
0xf5f5, 0xfb3b, 0x094c, 0x09c2, 0x0453, 0x007c, 0x0381, 0xfb90, 0xfeb4, 0xf9c4,
0x21be, 0x2055, 0x1cac, 0x1b64, 0x031b, 0xfe23, 0x055f, 0xfe58, 0x0007, 0xf843,
0xfbcc, 0xf583, 0xf324, 0xf089, 0xfe92, 0xfed5, 0x0142, 0x00f9, 0x0f62, 0x0a9e,
0x10f3, 0x084a, 0x13e3, 0x0da6, 0xfd1b, 0xf783, 0xdfb5, 0xd8f1, 0xe76b, 0xdd4d,
0x00d7, 0xf76e, 0x19a8, 0x1479, 0x111e, 0x0a0e, 0x0905, 0x034c, 0xfc2c, 0xf8b5,
0xf44f, 0xf1d3, 0xf7fb, 0xf5a1, 0x0b22, 0x091f, 0x1774, 0x163a, 0x236f, 0x20a4,
0x10c8, 0x0ca6, 0x1403, 0x107f, 0x1cd9, 0x1a9b, 0x0648, 0x055f, 0xf3f7, 0xefd2,
0xf7a8, 0xf4bf, 0x10d9, 0x1220, 0x2688, 0x27b7, 0x132a, 0x1072, 0xef90, 0xed8e,
0xf134, 0xf012, 0x00fe, 0x0350, 0x0610, 0x0ae9, 0xf914, 0xfec9, 0x05e6, 0x09c3,
0x0db9, 0x0fe0, 0x0a8f, 0x0e9c, 0x17dd, 0x185b, 0x137d, 0x1187, 0x04a7, 0x02ac,
0xf990, 0xf951, 0xfe17, 0xfb71, 0x18e8, 0x15fb, 0x2621, 0x27e8, 0xf1f6, 0xf3df,
0x01d6, 0xfe20, 0x0a29, 0x052b, 0xef33, 0xea9b, 0x058f, 0x0366, 0x10e6, 0x1283,
0x11cb, 0x12fd, 0x0e7d, 0x0d8a, 0x06fd, 0x05bb, 0x017c, 0x035d, 0x030f, 0x0471,
0x0705, 0x0c7f, 0x0441, 0x0cad, 0xff28, 0x04e1, 0x0035, 0x01f5, 0x0bd4, 0x0a93,
0x0af8, 0x0c2e, 0xfea7, 0xfe5e, 0xf5e2, 0xf48e, 0xf3bb, 0xf3ea, 0x01a0, 0x0459,
0x0920, 0x0b2a, 0x0cbf, 0x0eec, 0x040f, 0x05e5, 0x0033, 0xff70, 0xf21e, 0xf1a6,
0x0a65, 0x0bee, 0x1b0a, 0x1e16, 0xf5cb, 0xf560, 0xf802, 0xf6e1, 0x02bd, 0x048a,
0x096d, 0x0bb3, 0x0d08, 0x0e91, 0x0893, 0x0c21, 0x0c30, 0x11fa, 0x0e34, 0x109a,
0x0aa6, 0x0aa0, 0xf578, 0xf669, 0xe9fd, 0xeaf8, 0xe711, 0xe79d, 0xf102, 0xf2e0,
0xf85a, 0xfbb3, 0xf883, 0xfc0e, 0xf401, 0xf68d, 0xf1e5, 0xf504, 0xf5b5, 0xfd1a,
0x0343, 0x0a21, 0xfb28, 0x0047, 0xf1cd, 0xf4bc, 0xf720, 0xf6f1, 0x032e, 0x0440,
0xfd9b, 0x0216, 0xf11d, 0xf6d8, 0xfdec, 0x0377, 0xfbee, 0x021f, 0xf5d1, 0xf8d5,
0xf372, 0xf3a1, 0xf6f2, 0xf825, 0xfe48, 0x01c0, 0x0a63, 0x0a53, 0xf530, 0xf3a1,
0xfaea, 0xfd15, 0xf9c0, 0xfd1d, 0xf320, 0xf81f, 0xec33, 0xf19e, 0xfca8, 0x02ae,
0x1730, 0x19be, 0x2370, 0x2628, 0xfad8, 0xffae, 0xd384, 0xd885, 0xde82, 0xe188,
0xd8e5, 0xd9e2, 0xe9a8, 0xecd2, 0x01ea, 0x0815, 0x081f, 0x0e16, 0x0278, 0x0416,
0xf513, 0xf80e, 0xee00, 0xf333, 0xf4c0, 0xf816, 0x012e, 0x0489, 0x0880, 0x0d66,
0x0454, 0x0714, 0x024a, 0x0391, 0xffec, 0x0347, 0xfac7, 0x01f6, 0xf169, 0xf78e,
0xeaba, 0xee42, 0xf74f, 0xfae2, 0x1495, 0x1396, 0x3599, 0x3764, 0x2cea, 0x32ce,
0x0816, 0x0bca, 0x0647, 0x079a, 0x0205, 0xff91, 0x036f, 0xff33, 0x1a1e, 0x12bd,
0x021b, 0xfd9a, 0x0a4a, 0x0b22, 0x230e, 0x26d6, 0xfa0a, 0x02b2, 0xf88a, 0xfed2,
0x0c77, 0x0e10, 0x2a16, 0x2b95, 0x1351, 0x15b2, 0xff70, 0x0413, 0xfc16, 0x037d,
0xf5a1, 0xfb73, 0xf34a, 0xf5a3, 0xfb63, 0x0054, 0x1289, 0x1849, 0x09b4, 0x0d12,
0xf2fd, 0xf72b, 0xe927, 0xec1f, 0xf7e8, 0xf974, 0x0564, 0x09d3, 0xfb4c, 0x01eb,
0xdf49, 0xe484, 0xe4b5, 0xe94b, 0xf245, 0xf6bb, 0xfc1e, 0xff09, 0xf32f, 0xf85a,
0xfc1e, 0x02f0, 0xf723, 0xfbed, 0xe16c, 0xe3de, 0xf92b, 0xf969, 0x00ba, 0x0396,
0xfadf, 0xfeb1, 0x09cc, 0x0c12, 0xec5e, 0xf1f6, 0xdf1f, 0xe68f, 0xf27d, 0xf74e,
0xfa82, 0xfccd, 0xfd8b, 0xfe8f, 0xfa1d, 0xf9f3, 0xf8b2, 0xf856, 0xf82d, 0xf5ba,
0xf97c, 0xf7be, 0xffbb, 0x00f3, 0x071a, 0x08b7, 0x0169, 0x052d, 0xf70c, 0xfb5c,
0xedfa, 0xf4c8, 0xe8ed, 0xef8d, 0xefce, 0xf49a, 0xfcc0, 0x0208, 0x0c55, 0x0cd4,
0x0444, 0x0375, 0xf49c, 0xf52a, 0xf32a, 0xf47a, 0xf122, 0xf609, 0xf452, 0xf8b1,
0xefcb, 0xf49e, 0xf1a0, 0xf49a, 0xe684, 0xec67, 0xe30c, 0xeafa, 0xfae5, 0xfe86,
0xf903, 0xfddf, 0xf0f2, 0xf3af, 0xed0b, 0xeec4, 0xecab, 0xf10c, 0xf3aa, 0xf7f1,
0xf1b7, 0xf675, 0xf0c1, 0xf53a, 0xf898, 0xfb8b, 0x01a5, 0x0310, 0xfaea, 0xfc44,
0x059a, 0x073e, 0xe9ac, 0xea6c, 0xdcb3, 0xe045, 0xec9f, 0xf438, 0x009d, 0x06bb,
0x13c8, 0x14a9, 0x1324, 0x128f, 0xe5c6, 0xe62b, 0xeeae, 0xecbc, 0x0768, 0xfe52,
0x05ca, 0xfd16, 0xef0f, 0xeb33, 0xeb84, 0xe689, 0x007c, 0xf956, 0xfc1a, 0xf649,
0xfe17, 0xfa38, 0xf43f, 0xeeab, 0xe6f4, 0xde61, 0xed81, 0xe8b1, 0x0a81, 0x088b,
0x17ff, 0x149a, 0xf45f, 0xf0c0, 0xf2e5, 0xef99, 0x0178, 0xfe50, 0x03eb, 0xfef4,
0xe901, 0xe449, 0xe3ca, 0xe043, 0xf343, 0xf0fd, 0xedc5, 0xea24, 0xfd0a, 0xfebf,
0x1357, 0x1a8f, 0x2577, 0x26f3, 0x26a2, 0x20f6, 0x14e3, 0x0f6f, 0x0889, 0x055f,
0x130d, 0x0bf8, 0x2e52, 0x24a8, 0x33ca, 0x2a81, 0x19c1, 0x16a5, 0x1197, 0x0ed9,
0x0db7, 0x06b0, 0x16d4, 0x113c, 0x2abf, 0x2701, 0x2b69, 0x26af, 0x1cb1, 0x158a,
0x0a07, 0x021d, 0x1353, 0x0b56, 0x1357, 0x0f75, 0x125f, 0x117f, 0x169c, 0x15ec,
0x20c0, 0x1de9, 0x1473, 0x1038, 0x001b, 0xfd07, 0x0b45, 0x0bc7, 0x1edb, 0x1f56,
0x1cb0, 0x1a18, 0xfd6b, 0xf9c0, 0xfec9, 0xfb04, 0x0912, 0x0581, 0x129d, 0x1032,
0x1bd4, 0x1ac6, 0x181a, 0x1af3, 0x0bdc, 0x0ed5, 0x0afe, 0x04d8, 0xffbb, 0xf75a,
0x08c8, 0x06fc, 0x17a5, 0x1756, 0x2fe1, 0x29f8, 0x197a, 0x118a, 0x01ec, 0xf98f,
0x0c7b, 0x062b, 0x160c, 0x0e38, 0x1b79, 0x128d, 0x1315, 0x0b2b, 0x3089, 0x297b,
0x1193, 0x0e70, 0x00a1, 0xfb2b, 0x0f0c, 0x09b8, 0x2dd4, 0x2a2b, 0x2ddd, 0x2b55,
0x097f, 0x0847, 0xf0d1, 0xedd0, 0xf5ef, 0xedb6, 0x0ab7, 0x0235, 0x0e6a, 0x0c98,
0x23e5, 0x2724, 0x2335, 0x265a, 0x23f8, 0x233e, 0x0fee, 0x0c45, 0x2b5b, 0x2120,
0x3837, 0x2f3d, 0x28eb, 0x236d, 0x0e38, 0x08b0, 0x09cd, 0x05fe, 0x142e, 0x0f90,
0x112e, 0x0ea9, 0x075a, 0x0661, 0x09d2, 0x08d9, 0x1c2a, 0x1a09, 0x248d, 0x22e4,
0x13c6, 0x134f, 0x0aea, 0x09ef, 0x2ae6, 0x2787, 0x1bbc, 0x1a1c, 0x0793, 0x0927,
0xfcc1, 0xfd17, 0xfdce, 0xfda6, 0x0881, 0x08a6, 0x1946, 0x1865, 0x2239, 0x1f85,
0x2b5b, 0x2ac7, 0x1d02, 0x1c58, 0x0a46, 0x0969, 0x01f8, 0x0215, 0x152f, 0x116e,
0x1d6d, 0x1949, 0x0198, 0x009c, 0x01ba, 0xff73, 0x0dfe, 0x0aee, 0x1fae, 0x1b38,
0x3237, 0x2f05, 0x2803, 0x2501, 0x1ac5, 0x1626, 0x1bc2, 0x19e7, 0x1ba4, 0x1a46,
0x0805, 0x09f0, 0xff5c, 0x0201, 0x1f92, 0x20ae, 0x2547, 0x2690, 0x13a6, 0x1487,
0xfc6c, 0xfe0c, 0x106e, 0x0f26, 0x08e7, 0x05b0, 0xf9fe, 0xfab9, 0x1e76, 0x1fd8,
0x1ed4, 0x1d93, 0x14bf, 0x136f, 0x0bd7, 0x0e66, 0xfb8b, 0x01bf, 0xfa5f, 0xfe9c,
0x0791, 0x06de, 0x14b0, 0x1139, 0x1b46, 0x1abe, 0x14d0, 0x1705, 0x0eaf, 0x0f76,
0x159b, 0x1611, 0x1f93, 0x21bb, 0x2592, 0x2722, 0x2d76, 0x2bb8, 0x1101, 0x0ee3,
0xfee3, 0x00fc, 0x0457, 0x090f, 0x1b80, 0x2043, 0x2158, 0x26db, 0x187a, 0x1c6a,
0x0f88, 0x1015, 0x1d9e, 0x1f10, 0x1a77, 0x1bdf, 0xfde2, 0xfc1f, 0x0d0f, 0x0c08,
0x1308, 0x1644, 0x1183, 0x1617, 0x0f13, 0x102b, 0x09ce, 0x0af6, 0x0916, 0x0db7,
0x0dd3, 0x143b, 0x0982, 0x0eeb, 0x140d, 0x1cc8, 0x1af2, 0x2566, 0x0846, 0x0eb5,
0x0c9b, 0x0ff8, 0x1911, 0x1a8d, 0x1b13, 0x1dbf, 0x02bf, 0x0735, 0x012f, 0x0711,
0x0c0c, 0x113a, 0x0b9b, 0x10a3, 0x204a, 0x21df, 0x2763, 0x2785, 0x2090, 0x21ef,
0x191d, 0x1bb2, 0x047c, 0x082e, 0xfed0, 0xff83, 0x067a, 0x08c1, 0x0dd3, 0x1602,
0x17d4, 0x2395, 0x1a82, 0x23ba, 0xff49, 0x02f7, 0xf596, 0xf601, 0x058b, 0x061c,
0x1c67, 0x2153, 0x05de, 0x0b8d, 0xf884, 0xfd06, 0x00de, 0x0536, 0xfedd, 0x035a,
0xf54d, 0xfe16, 0xf443, 0x008d, 0x0e0a, 0x1b74, 0xf885, 0x0094, 0x0552, 0x06df,
0x1bde, 0x1d06, 0x0b24, 0x1271, 0xfc4e, 0x0710, 0xf609, 0x0069, 0xfe43, 0x07dd,
0x0297, 0x0cf7, 0xfacc, 0x0745, 0xeec9, 0xf856, 0xecf5, 0xf516, 0xf9fe, 0x007f,
0xfa02, 0x004d, 0xeec5, 0xf415, 0x0a1e, 0x0dc7, 0x0a22, 0x0bbc, 0xf56b, 0xf720,
0xf8ff, 0xfd17, 0xff26, 0x0722, 0x0420, 0x0ee4, 0x0215, 0x09e9, 0xef56, 0xf722,
0xe231, 0xe908, 0xe63a, 0xeed6, 0x03eb, 0x0e1d, 0xf2a6, 0xfe32, 0xe191, 0xee3f,
0xec1b, 0xf4e7, 0xe577, 0xebac, 0xed85, 0xf517, 0xf730, 0x004b, 0x1243, 0x18b4,
0xf84b, 0xfc95, 0xf0b8, 0xf0b8, 0xf778, 0xf82b, 0x07e0, 0x0e49, 0x12f6, 0x1bb2,
0x0e4a, 0x1656, 0xfda5, 0x016d, 0x0309, 0x065f, 0xff36, 0x055f, 0xf0a2, 0xf77b,
0xf5b7, 0xfbf7, 0x0a7d, 0x0fc8, 0x0c54, 0x126c, 0xf1e4, 0xf731, 0xe4c2, 0xe8f4,
0xedba, 0xf21f, 0xfd9e, 0x0313, 0xfeb4, 0x081b, 0xec3e, 0xf4e0, 0xe694, 0xecce,
0xf843, 0xff20, 0xf764, 0x032e, 0xee38, 0xfb69, 0xe3f6, 0xee29, 0xda24, 0xe371,
0xe3de, 0xeb8a, 0xf5d6, 0xfb35, 0x0471, 0x077b, 0xeb64, 0xeef1, 0xe0ef, 0xe906,
0xf140, 0xfc3f, 0xfa6c, 0x0539, 0x0494, 0x0dbe, 0xfdaa, 0x05a5, 0xf5af, 0xfdce,
0xeeaa, 0xf606, 0xf901, 0x0139, 0xfc26, 0x03bf, 0xf013, 0xf621, 0xe17a, 0xe455,
0xe5b5, 0xe691, 0xe8f0, 0xf025, 0xf7f9, 0x0439, 0xf07c, 0xfd11, 0xe2b1, 0xec77,
0xe4a4, 0xeca4, 0xe1e4, 0xea5d, 0xe30a, 0xeda1, 0xe573, 0xf283, 0xe9c9, 0xf527,
0xf2c7, 0xf7f6, 0xf711, 0xf629, 0xec1d, 0xedc8, 0xdb75, 0xe47c, 0xd973, 0xe75e,
0xe3a3, 0xf043, 0xe274, 0xec0c, 0xf141, 0xf69c, 0xf5f3, 0xf95d, 0xd3d9, 0xd9c3,
0xda06, 0xe043, 0xe0fc, 0xe788, 0xda9b, 0xe499, 0xd359, 0xde75, 0xdd81, 0xe395,
0xefd7, 0xf194, 0xec94, 0xf00a, 0xeeab, 0xf4be, 0xe487, 0xebf5, 0xdaf6, 0xe0cb,
0xd898, 0xd9c3, 0xdbc9, 0xda09, 0xd816, 0xd91a, 0xce9e, 0xd606, 0xe1b4, 0xec7f,
0xe4e9, 0xeea8, 0xd698, 0xddd8, 0xd5db, 0xdd09, 0xd5ae, 0xd7eb, 0xdd4e, 0xdd3d,
0xdf0c, 0xe4a6, 0xe402, 0xed43, 0xd96e, 0xdea5, 0xcdda, 0xcda8, 0xd0fb, 0xd056,
0xdfd0, 0xe182, 0xe2da, 0xe6f5, 0xd79f, 0xda4b, 0xd4ea, 0xd570, 0xe1b4, 0xe1f1,
0xec75, 0xead4, 0xebd7, 0xe905, 0xce0b, 0xcd41, 0xc5cd, 0xc627, 0xdf88, 0xddb8,
0xd806, 0xd4ce, 0xdc08, 0xd929, 0xe1e6, 0xdf22, 0xe1ba, 0xdd63, 0xe218, 0xde1a,
0xe0ab, 0xdd4a, 0xdf54, 0xd886, 0xe79c, 0xe21d, 0xdd20, 0xd9f0, 0xcc76, 0xca8c,
0xcf3e, 0xd065, 0xcfd9, 0xce88, 0xe2e1, 0xdb8e, 0xf68f, 0xf03b, 0xf5fe, 0xf55d,
0x0611, 0x030c, 0x16d2, 0x0fab, 0x0d06, 0x0738, 0x145e, 0x0e16, 0x194a, 0x10bf,
0x1360, 0x0a49, 0x03c6, 0xfbf0, 0x01f8, 0xfe4c, 0x0a57, 0x0989, 0x07b5, 0x0833,
0x0ed2, 0x0b08, 0x0b62, 0x03a2, 0xffa2, 0xf9eb, 0x0989, 0x0302, 0x0e9c, 0x07f2,
0x0cfd, 0x0728, 0x0567, 0x01d0, 0x00c6, 0xfed7, 0xf6c4, 0xf439, 0xec3e, 0xea49,
0xf322, 0xf045, 0x03dd, 0x005d, 0x0daa, 0x0986, 0xfe36, 0xf60a, 0xf84d, 0xf41f,
0xf383, 0xf131, 0xefaf, 0xebde, 0xf964, 0xf619, 0xfffb, 0xfabe, 0x0279, 0xfbd9,
0x07bf, 0x00ce, 0xf454, 0xf0e1, 0xf4e5, 0xf425, 0x0693, 0x05a2, 0xf901, 0xf48b,
0xfd75, 0xf6cd, 0x0ca9, 0x05e8, 0x149e, 0x0ee5, 0x0cee, 0x08b4, 0xfe04, 0xfb54,
0xf665, 0xf514, 0x026b, 0x002d, 0x0184, 0xfb03, 0xf9ce, 0xf3fb, 0xf7b0, 0xf455,
0xf633, 0xf0f2, 0x04cd, 0x005e, 0x1168, 0x0ea2, 0x02fd, 0x0017, 0x0632, 0xfd81,
0x0694, 0xf999, 0xfd29, 0xf268, 0xf266, 0xecd6, 0xf227, 0xf097, 0xfe92, 0xfd6c,
0x0977, 0x08c2, 0xffa8, 0xfb6c, 0xf98d, 0xf464, 0x04db, 0x007d, 0x0acf, 0x0697,
0x0394, 0xfea5, 0xf545, 0xeefd, 0xf55d, 0xf032, 0xefba, 0xea84, 0xf5d9, 0xf0b8,
0x02fd, 0xfa42, 0x07ce, 0xfe7e, 0x06ee, 0xfb93, 0x0220, 0xf55c, 0xfc93, 0xf4ae,
0x0996, 0x02b3, 0x1818, 0x1194, 0x1696, 0x0eae, 0x001b, 0xf604, 0xf660, 0xeda8,
0xf95f, 0xf617, 0x017f, 0x0158, 0x0e3b, 0x0c43, 0x0ac2, 0x0581, 0xfa43, 0xf4b3,
0xfd70, 0xf783, 0xfc65, 0xf61e, 0xfb91, 0xf5dd, 0xfe09, 0xf60a, 0x0c65, 0x0345,
0x08d1, 0x0082, 0xf5eb, 0xef3c, 0xf36e, 0xec20, 0x0089, 0xf6cc, 0x0afc, 0xff37,
0x0505, 0xfcdd, 0x116f, 0x09ea, 0x0e5c, 0x03b6, 0xffa4, 0xf4b3, 0x0357, 0xf7c8,
0x06b0, 0xfa95, 0x0443, 0xfcae, 0x047f, 0x0203, 0x0d4f, 0x0756, 0x102c, 0x0739,
0x098a, 0x00e1, 0x10ba, 0x094d, 0x0912, 0x01e4, 0x0037, 0xf81c, 0x0319, 0xfb4d,
0x0b08, 0x01f8, 0x16fa, 0x0bfd, 0x1dfe, 0x1390, 0x1ab7, 0x1383, 0x0c71, 0x06a6,
0x06bf, 0xffda, 0x060e, 0x0081, 0x0b44, 0x072f, 0x0e53, 0x08e3, 0x0e43, 0x06e2,
0x08d8, 0x0529, 0x05fa, 0x0491, 0x0e03, 0x0760, 0x0f8d, 0x08cf, 0x1882, 0x12d0,
0x1005, 0x0ad7, 0x0dd6, 0x095b, 0x092b, 0x0346, 0x1c9c, 0x1940, 0x1da7, 0x1d36,
0x041a, 0x02fe, 0xfddd, 0xfa31, 0x0594, 0xff40, 0x0f0b, 0x0a7c, 0x0e85, 0x0ab2,
0xfcbc, 0xf769, 0xfb8f, 0xf64c, 0x0bce, 0x061b, 0x0d5d, 0x0aba, 0x0aba, 0x0b4f,
0x09e1, 0x0af1, 0x1076, 0x10cb, 0x0c4d, 0x0dce, 0x0502, 0x0569, 0xf9a7, 0xfa1a,
0x02ca, 0x020d, 0x14d8, 0x0d34, 0x171a, 0x0e89, 0x08af, 0x0449, 0x0bc0, 0x0b28,
0x143e, 0x142d, 0x0eda, 0x0d33, 0x1215, 0x11f5, 0x100b, 0x1117, 0x0956, 0x0a9f,
0x03c7, 0x033b, 0x132e, 0x0e41, 0x1e9b, 0x1685, 0x1e8f, 0x1909, 0x0b5a, 0x0a39,
0x0c57, 0x0adf, 0x1756, 0x1412, 0x2a17, 0x217b, 0x1d61, 0x13f2, 0x0c82, 0x0b0d,
0x0b48, 0x0ce6, 0x19d9, 0x1d77, 0x0a1c, 0x0deb, 0xf87c, 0xf818, 0x03e2, 0x012d,
0x0e91, 0x0b79, 0x1125, 0x107f, 0x0c81, 0x0be9, 0x16d0, 0x186c, 0x0724, 0x08b2,
0x00d6, 0xfdbe, 0x06e1, 0x0351, 0x086d, 0x06d3, 0x0dbb, 0x0bb0, 0x139d, 0x1228,
0x1cb3, 0x1cc2, 0x0bcd, 0x0a35, 0x0793, 0x024b, 0x122f, 0x0fea, 0x12ac, 0x15be,
0x0cb2, 0x0e6d, 0xffe3, 0x041e, 0x0a83, 0x0e26, 0x06b2, 0x08c7, 0x035a, 0x0641,
0x008d, 0x001c, 0x0620, 0x055f, 0x044f, 0x053a, 0x03e1, 0x03f8, 0x0a42, 0x0911,
0x179c, 0x18f3, 0x11e1, 0x159a, 0xfe6e, 0xff9d, 0xf7fb, 0xf708, 0x00dd, 0x00df,
0x0a4f, 0x0a87, 0x029e, 0x033f, 0x05ce, 0x086f, 0x0b86, 0x1008, 0x083c, 0x0c1c,
0x059f, 0x0574, 0xf970, 0xfb3c, 0xfbb7, 0x0094, 0x0b6c, 0x1071, 0x0eaf, 0x11a5,
0xfecf, 0xfff7, 0xeae8, 0xedf9, 0xfd28, 0x009f, 0x0ace, 0x0d90, 0x0bcf, 0x0e50,
0xfc3a, 0xff8c, 0xf954, 0x02a9, 0xfa18, 0x0429, 0xf2cf, 0xf97c, 0x02a0, 0x0804,
0xf6b6, 0xfb6a, 0xe7c0, 0xef55, 0xec26, 0xf318, 0xf004, 0xf4ff, 0x0387, 0x0779,
0x12ff, 0x14a1, 0x07bc, 0x0ada, 0xfadf, 0x028c, 0xfb2b, 0x0378, 0x042c, 0x0a4c,
0xf8a7, 0xfef6, 0xed78, 0xf5c5, 0xefbc, 0xf823, 0xff3d, 0x04f0, 0xfb24, 0xff8d,
0xf432, 0xfa75, 0xf408, 0xfad4, 0x0997, 0x0e67, 0x0e79, 0x1121, 0x010a, 0x0108,
0xf66e, 0xf65d, 0xeb50, 0xee78, 0xf295, 0xf6a3, 0xfb3c, 0x0042, 0xfdda, 0x0262,
0xfa11, 0xf891, 0xf65d, 0xf34a, 0xf544, 0xf7de, 0xf1c5, 0xfac1, 0xee48, 0xf68e,
0xe9a3, 0xec45, 0xee11, 0xedf1, 0xef67, 0xee63, 0xec95, 0xedb7, 0xf08e, 0xeee6,
0xee0e, 0xea5d, 0xea38, 0xe9c0, 0xe5a6, 0xea04, 0xedb7, 0xf462, 0xf7e3, 0xfab0,
0x03df, 0x0345, 0x10bc, 0x0f73, 0x04c2, 0x03dd, 0xf96c, 0xfae6, 0xfd4f, 0x0008,
0x0302, 0x03c0, 0x0a35, 0x07ea, 0x0de0, 0x08be, 0x0dcf, 0x0d60, 0x0623, 0x086f,
0x0bab, 0x08dc, 0x1496, 0x0fe3, 0x2143, 0x21a2, 0x120f, 0x1505, 0x03fc, 0x05c9,
0x1571, 0x14ec, 0x0ae0, 0x09c4, 0x073c, 0x0584, 0x071b, 0x06aa, 0x032b, 0x07c1,
0xfddb, 0x0264, 0x025a, 0x0128, 0x1321, 0x0cdd, 0x1709, 0x1586, 0x1a79, 0x1aca,
0x1576, 0x1541, 0x025f, 0x054a, 0x0674, 0x0ab2, 0x0e96, 0x1290, 0x0d4b, 0x0c3e,
0x0c6d, 0x0b4a, 0x053a, 0x0770, 0x09a7, 0x0ab3, 0x0224, 0x0242, 0x180f, 0x1b67,
0x1a8c, 0x1fd5, 0xfcdc, 0xff72, 0xff66, 0xfed6, 0x0057, 0x009b, 0xfd74, 0xfdee,
0xf7f9, 0xf8d3, 0xea4c, 0xef4b, 0xeb7b, 0xf51a, 0xfe38, 0x061e, 0x05e2, 0x050f,
0xf71b, 0xf377, 0xe470, 0xe438, 0xedd1, 0xef87, 0xe918, 0xeaa0, 0xf428, 0xf5b0,
0x0a3b, 0x0a3f, 0xf89c, 0xf598, 0xe5ee, 0xe118, 0xdf5a, 0xe05c, 0xe998, 0xf05c,
0x02b0, 0x0a10, 0x0a88, 0x1066, 0x0436, 0x032b, 0xf902, 0xf4a8, 0xf62e, 0xf773,
0xf19d, 0xf7fb, 0xeccf, 0xef91, 0xef16, 0xe921, 0xf779, 0xf21b, 0x0450, 0x036f,
0xf747, 0xf932, 0xecdb, 0xf3f0, 0xf09a, 0xf3a9, 0xf7f7, 0xf583, 0xfb5f, 0xf8f2,
0xefee, 0xf0ba, 0xe72e, 0xece4, 0xf3c8, 0xf976, 0xf8e7, 0xfb29, 0xeb55, 0xeb3c,
0xd9cf, 0xdae5, 0xd597, 0xd551, 0xe50e, 0xe1d9, 0xf473, 0xf382, 0xece9, 0xf044,
0xe8bd, 0xede2, 0xf392, 0xf3fa, 0x044d, 0x0312, 0xf788, 0xfbff, 0xee90, 0xf613,
0xf268, 0xf609, 0xef4b, 0xed30, 0xf2db, 0xed92, 0xf619, 0xf229, 0xf65a, 0xf801,
0xec6b, 0xf1bd, 0xeaf8, 0xedef, 0xf016, 0xed23, 0xf99a, 0xf46a, 0x0047, 0xfb14,
0xf900, 0xf65d, 0xec8a, 0xec19, 0xee1d, 0xed80, 0xf621, 0xf858, 0xfba0, 0xfb63,
0xf395, 0xeb4d, 0xe687, 0xdc7d, 0xf06b, 0xe9c3, 0x03b8, 0x00cf, 0x036d, 0xfe57,
0xf8c8, 0xf130, 0xf2cb, 0xeea7, 0xfa91, 0xf954, 0xf293, 0xf3a6, 0xf2af, 0xefc6,
0xfc34, 0xf489, 0xf668, 0xeeb3, 0xfcc0, 0xf44d, 0xfba2, 0xf73b, 0xefaf, 0xef4d,
0xfb06, 0xf7a6, 0x055d, 0xfd66, 0x0313, 0xf7b3, 0x1890, 0x0f30, 0x0902, 0x06ad,
0xfbcd, 0xf7c0, 0x0f1f, 0x049c, 0x1c4e, 0x0fe7, 0x1d26, 0x12c1, 0x1645, 0x0fc7,
0x24d8, 0x1c49, 0x218e, 0x1b3d, 0x1773, 0x1417, 0x143d, 0x0df8, 0x0f11, 0x035f,
0x1bc7, 0x0cb1, 0x2b09, 0x1f5f, 0x2579, 0x1b73, 0x191b, 0x106e, 0x1074, 0x0dce,
0x1daa, 0x1bfe, 0x1aae, 0x0f03, 0x1978, 0x0c63, 0x20a6, 0x176e, 0x29e3, 0x2219,
0x1ea6, 0x18c1, 0x130a, 0x0c60, 0x1eab, 0x184e, 0x1956, 0x0fdb, 0x16cf, 0x0d33,
0x15e3, 0x0fb3, 0x1cc3, 0x19f3, 0x261d, 0x2338, 0x294a, 0x2384, 0x2318, 0x1a4f,
0x2651, 0x1d3c, 0x1a23, 0x16eb, 0x0ec8, 0x0d5e, 0x20c8, 0x1ae7, 0x28f1, 0x1ef2,
0x281c, 0x19d8, 0x1f01, 0x0c8f, 0x1244, 0x059d, 0x1415, 0x08ef, 0x1977, 0x0e20,
0x1ec6, 0x129c, 0x2b49, 0x1b64, 0x276d, 0x1e2d, 0x1d6d, 0x1948, 0x153b, 0x0fde,
0x1f63, 0x1899, 0x2221, 0x1b5b, 0x17d1, 0x0edb, 0x0989, 0x00e5, 0x0aa6, 0x025e,
0x13f5, 0x0d39, 0x1e12, 0x1e43, 0x212b, 0x206c, 0x11dd, 0x0c41, 0x0b0b, 0x0592,
0x10c4, 0x0bc4, 0x239e, 0x20c7, 0x2e88, 0x2bb2, 0x311d, 0x2b4c, 0x1aff, 0x1524,
0x0c89, 0x074a, 0x131c, 0x0fc4, 0x1b22, 0x15f1, 0x1c55, 0x1569, 0x172a, 0x10ef,
0x2071, 0x1bd3, 0x1f17, 0x1bab, 0x1d06, 0x1621, 0x1e44, 0x1805, 0x10e2, 0x1213,
0x0e7b, 0x127f, 0x1c29, 0x1b6b, 0x0e01, 0x0bd6, 0x13fe, 0x137e, 0x1884, 0x1963,
0x1d0f, 0x1cfa, 0x03d8, 0x03ec, 0x0aba, 0x0b25, 0x24d6, 0x2250, 0x10e1, 0x0c1e,
0x05f3, 0xfe87, 0x04dc, 0xffb6, 0x0ae2, 0x0a76, 0x1b31, 0x1d2e, 0x2197, 0x23ec,
0x1714, 0x1a42, 0x02b6, 0x0978, 0x0ced, 0x0fe4, 0x17eb, 0x15c5, 0x11ef, 0x100e,
0x1094, 0x0eb1, 0x0d1d, 0x0b51, 0x0e97, 0x0bb5, 0x19a0, 0x1701, 0x13e9, 0x10e1,
0x0d5b, 0x0a73, 0x1c31, 0x1ac1, 0x1c27, 0x19db, 0x1b12, 0x1940, 0x1791, 0x162e,
0x188d, 0x14bb, 0x1a3f, 0x1715, 0x1844, 0x187a, 0x13ed, 0x13c9, 0x0f2b, 0x0db3,
0x1500, 0x1552, 0x18da, 0x19fd, 0x16e9, 0x15ac, 0x11d4, 0x1226, 0x14e8, 0x154a,
0x0e33, 0x0dc3, 0x177b, 0x1751, 0x1040, 0x0ccb, 0x0477, 0x035c, 0x0be6, 0x0b56,
0x1d4e, 0x17ce, 0x2087, 0x18ee, 0x0b3b, 0x0711, 0x04ae, 0x074a, 0x015a, 0x0401,
0x07ae, 0x08e5, 0x1b1b, 0x1cf2, 0x17fe, 0x1aae, 0x09a8, 0x09b3, 0xff9b, 0xff3a,
0x04ce, 0x0788, 0x0d73, 0x12ec, 0x0f2c, 0x13c5, 0x09e7, 0x089b, 0x0f3a, 0x0d78,
0x11d9, 0x1243, 0x0b30, 0x0cf4, 0x0c9f, 0x0e39, 0x186c, 0x19fe, 0x230d, 0x260d,
0x12ad, 0x1647, 0x0e40, 0x1476, 0x125c, 0x1aac, 0x16ef, 0x1c64, 0x09ba, 0x0a24,
0x00ba, 0x0584, 0x04a5, 0x0daa, 0x1144, 0x17e3, 0xfcc2, 0x03e7, 0xf68a, 0xfd08,
0x03d1, 0x0765, 0x06ab, 0x0b18, 0x009c, 0x08fa, 0x00bf, 0x08bb, 0x0144, 0x0927,
0x0588, 0x0ee2, 0x00c5, 0x08c5, 0xf4e3, 0xfcaa, 0xf94f, 0x020e, 0x0041, 0x07e9,
0x056d, 0x0c97, 0x097e, 0x0fe4, 0xfc47, 0x02a6, 0xfd1f, 0x00a1, 0x046a, 0x0765,
0x0b42, 0x10a0, 0x0070, 0x04a4, 0xf60e, 0xfad0, 0xfac8, 0x013c, 0x0296, 0x0dbe,
0x0687, 0x13bb, 0x0081, 0x090f, 0xf71c, 0xfdc2, 0xf3e3, 0xfb91, 0xfcd5, 0x01ac,
0x02c9, 0x04f6, 0xff1f, 0x0619, 0xff87, 0x07a2, 0xfe1d, 0x027b, 0xf7dd, 0xfdd1,
0xeb92, 0xf5a6, 0xf21c, 0xfd37, 0x0770, 0x1137, 0xf6e9, 0x0148, 0xe874, 0xefec,
0xe3d8, 0xeac6, 0xf321, 0xfd8f, 0xe89d, 0xf6c8, 0xe839, 0xf32f, 0xf6e6, 0xfb84,
0xf2d9, 0xfae9, 0xec4a, 0xf877, 0xe461, 0xf03d, 0xe693, 0xee5e, 0xf051, 0xf365,
0xee87, 0xf672, 0xe7a0, 0xf47e, 0xf2ae, 0xfd85, 0xfc41, 0x04f0, 0x00f2, 0x0958,
0xf835, 0xfea9, 0x05f5, 0x060f, 0xfd04, 0xfeed, 0xe659, 0xed36, 0xe8c8, 0xf011,
0xf49d, 0xfa8a, 0xf48a, 0xfa1c, 0xe36b, 0xe8ad, 0xe5d6, 0xea31, 0xe870, 0xeed7,
0xe67b, 0xf222, 0xf607, 0x016f, 0xf21d, 0xf7a4, 0xe563, 0xedea, 0xe769, 0xf383,
0xe6af, 0xeea6, 0xe28d, 0xe785, 0xe42f, 0xe6fc, 0xe823, 0xecb8, 0xe90c, 0xf2e4,
0xe7be, 0xf393, 0xe3d1, 0xf187, 0xe638, 0xf24f, 0xe639, 0xf15a, 0xe7e2, 0xf3d0,
0xde7b, 0xe68e, 0xe4ba, 0xea6f, 0xe68c, 0xed7c, 0xdd97, 0xe8d7, 0xd8ec, 0xe63a,
0xe425, 0xef11, 0xeee8, 0xf644, 0xe642, 0xeb09, 0xe30c, 0xeab4, 0xe328, 0xed41,
0xe054, 0xe76b, 0xf11b, 0xf758, 0xe3e2, 0xefd0, 0xd130, 0xdeb1, 0xd5d9, 0xdf4b,
0xdf20, 0xe5cf, 0xe2b8, 0xeb39, 0xdb67, 0xe71e, 0xdfb9, 0xe802, 0xdc74, 0xdfee,
0xdce1, 0xe221, 0xe082, 0xed8d, 0xe390, 0xf50d, 0xddea, 0xea85, 0xd09f, 0xd6ca,
0xd6dc, 0xdcb0, 0xd55c, 0xdf4e, 0xd3be, 0xdeff, 0xdaba, 0xe53d, 0xe0c5, 0xeca7,
0xe5b1, 0xf0af, 0xe2bf, 0xead0, 0xe79a, 0xedf2, 0xe271, 0xeae9, 0xda04, 0xe57a,
0xd91e, 0xe2d1, 0xd72d, 0xe1d4, 0xd967, 0xe328, 0xd9f2, 0xdfbc, 0xdf04, 0xe517,
0xd3bd, 0xde49, 0xcac1, 0xd8f3, 0xc80e, 0xd378, 0xd464, 0xdbb5, 0xd60f, 0xd94c,
0xcc3c, 0xce75, 0xd0a9, 0xd62c, 0xcdb3, 0xd68b, 0xcf28, 0xd6cf, 0xd27c, 0xd2f7,
0xd359, 0xd143, 0xd604, 0xd985, 0xd913, 0xe2e1, 0xd012, 0xd9d5, 0xcb41, 0xd57c,
0xcac2, 0xd6c0, 0xd089, 0xd9f8, 0xc7fb, 0xcb80, 0xc8d8, 0xc7ce, 0xce0a, 0xcf2a,
0xd168, 0xd71f, 0xd115, 0xd6db, 0xd36c, 0xd40f, 0xd447, 0xd33e, 0xd734, 0xd8d1,
0xd579, 0xd843, 0xd337, 0xd42a, 0xd52f, 0xd403, 0xe857, 0xe3a8, 0xe8ec, 0xe01c,
0xc992, 0xc0b5, 0xd323, 0xce04, 0xd309, 0xd1ee, 0xcc2a, 0xc9a1, 0xcddb, 0xc773,
0xcaa5, 0xc53b, 0xca99, 0xcab9, 0xd510, 0xd5b9, 0xd60e, 0xd199, 0xd5a3, 0xd069,
0xd620, 0xd29e, 0xd3fe, 0xd12b, 0xdf11, 0xd810, 0xe2bf, 0xd805, 0xe202, 0xdb87,
0xe1eb, 0xdc89, 0xeb2e, 0xe565, 0xf11c, 0xebb8, 0xf2e6, 0xe9b7, 0xf8a9, 0xed45,
0xf92e, 0xf361, 0xfb0c, 0xf8f1, 0x03a6, 0xff58, 0x03f6, 0xfe8a, 0xff34, 0xf6cc,
0x0440, 0xf887, 0xfc59, 0xf644, 0xfe8b, 0xfbf9, 0x066c, 0x035b, 0x037a, 0x0085,
0xfae4, 0xf64c, 0xf418, 0xefda, 0xfcc3, 0xf8af, 0xf3b6, 0xee2e, 0xfa27, 0xf55d,
0x070f, 0x0341, 0x0e1d, 0x06e7, 0x0954, 0xfee3, 0xfbcd, 0xf39f, 0xf26a, 0xef74,
0xf398, 0xf08c, 0xffac, 0xfb85, 0x0b4b, 0x0878, 0x0456, 0x01b7, 0xfc54, 0xfab2,
0xfebd, 0xfbbe, 0x03bc, 0x00be, 0xf81f, 0xf1e5, 0xf343, 0xeaec, 0xfc44, 0xf67d,
0x0d8a, 0x08f5, 0x06ee, 0x0455, 0xf7bf, 0xf426, 0xf5c3, 0xf0bb, 0xf782, 0xed15,
0xf6d8, 0xea03, 0xf451, 0xe9d9, 0x045a, 0xf865, 0x0bdb, 0xff6d, 0x07f9, 0xffa6,
0x02e9, 0xfbe6, 0x0229, 0xf6fe, 0xf504, 0xed18, 0xf017, 0xeedf, 0x0547, 0x0143,
0x0f35, 0x04ac, 0x05a6, 0xfd73, 0xfa04, 0xf382, 0x00a4, 0xf937, 0x0442, 0xfea0,
0xff8d, 0xfb50, 0xfb8f, 0xf4fe, 0x02b7, 0xfae8, 0x092b, 0x0144, 0x09fa, 0xfe26,
0x0a99, 0x00e9, 0x051a, 0x01a0, 0x017f, 0xfef3, 0x04bd, 0xfdbd, 0x05c1, 0xfc61,
0x0b19, 0x005c, 0x1170, 0x0598, 0x0b82, 0x02ae, 0x055f, 0xfe52, 0x009b, 0xfa95,
0x0083, 0xf829, 0x0780, 0xfd9c, 0x058a, 0xfe59, 0xfb1c, 0xf6c2, 0x0672, 0x0196,
0x0e73, 0x0448, 0x0c47, 0x0153, 0xfb29, 0xf305, 0xffa1, 0xf7f9, 0x0a16, 0xfecb,
0x0b59, 0xfd94, 0xfd06, 0xf29c, 0x002a, 0xf8a1, 0x0874, 0x0174, 0x028e, 0xfbdf,
0xfff4, 0xf9d9, 0x0434, 0xfc5f, 0x1048, 0x0471, 0x0475, 0xf834, 0x0418, 0xf956,
0x0b39, 0x02c4, 0x1325, 0x0c40, 0x1037, 0x07f8, 0x0a21, 0xff4c, 0x0955, 0xfbe2,
0x04c0, 0xfba6, 0x0406, 0x00bc, 0x0be7, 0x0682, 0x1c8b, 0x12e4, 0x0b4b, 0x012c,
0x049a, 0xfafe, 0x0940, 0x011e, 0x1416, 0x0d60, 0x0c2a, 0x02e5, 0x041b, 0xf89c,
0x09c4, 0x01f9, 0x0358, 0x00e5, 0x0879, 0x044e, 0x0b8e, 0x02f5, 0x1996, 0x0e3f,
0x1b5c, 0x108b, 0x1974, 0x143a, 0x1714, 0x1450, 0x173c, 0x14d8, 0x1530, 0x148e,
0x1537, 0x11d6, 0x1559, 0x0ac6, 0x1d68, 0x10d5, 0x1b45, 0x16c3, 0x11a7, 0x12e1,
0x0d26, 0x0b7f, 0x0ba1, 0x06c7, 0x0e7a, 0x08d2, 0x17ab, 0x14ba, 0x10c0, 0x101b,
0x05fc, 0x04e9, 0x04e5, 0x00fb, 0x0afd, 0x068e, 0x0a95, 0x0bce, 0x0272, 0x0780,
0x0158, 0x03e0, 0x07fb, 0x0404, 0x11e0, 0x095b, 0x15a9, 0x0f95, 0x1129, 0x1214,
0x0b80, 0x109a, 0x07fb, 0x0cd1, 0x0270, 0x0531, 0x01b0, 0x00d8, 0x0396, 0x020b,
0x08be, 0x07d1, 0x0d8a, 0x0a46, 0x10b5, 0x0df1, 0x0fe0, 0x1314, 0x0f84, 0x14da,
0x1369, 0x1388, 0x0dbf, 0x0b57, 0x0a7c, 0x060f, 0x2056, 0x19fa, 0x1b52, 0x187e,
0x10f0, 0x0f9f, 0x13d0, 0x1022, 0x17bf, 0x1308, 0x16f5, 0x1281, 0x15b5, 0x10ff,
0x2d09, 0x27ea, 0x288d, 0x23ed, 0x18b2, 0x1275, 0x0a30, 0x0390, 0x0e65, 0x0a4b,
0x12c9, 0x0fe9, 0x0f27, 0x0deb, 0x12f6, 0x1114, 0x1060, 0x0f67, 0x0952, 0x0be2,
0xff7f, 0x04f3, 0x04c6, 0x083a, 0x0dce, 0x0e3b, 0x0fa3, 0x1287, 0x0a8c, 0x0d8b,
0x0ec2, 0x0eb0, 0x13f3, 0x1399, 0x0ec8, 0x10dc, 0x1578, 0x1a3f, 0x1699, 0x18e1,
0x10d7, 0x10f1, 0x097b, 0x0a21, 0x14b5, 0x1267, 0x179a, 0x17fb, 0x0a1d, 0x0e27,
0x0a26, 0x0d4c, 0x0484, 0x0ae5, 0x052f, 0x0e12, 0x07ed, 0x0e2a, 0x0a40, 0x0e95,
0x1183, 0x121c, 0x14c2, 0x1400, 0x0cdb, 0x112c, 0x08b2, 0x0e8d, 0x09c9, 0x0d9c,
0x0d54, 0x10dc, 0x08d6, 0x09a4, 0x0dbe, 0x0f48, 0x1107, 0x19ad, 0x0628, 0x0e1d,
0xfe66, 0x00af, 0xfb20, 0xfcac, 0xf0a2, 0xf6ba, 0xf994, 0x030e, 0x058f, 0x0a45,
0x0853, 0x07a8, 0xfcb1, 0xfcdd, 0xfc53, 0xfeec, 0x061d, 0x0943, 0x0b98, 0x0fb5,
0xfe63, 0x0565, 0xf8e1, 0x023a, 0x04fd, 0x088b, 0x075f, 0x0492, 0x0888, 0x078f,
0x04a5, 0x0ad3, 0x0679, 0x105e, 0x0683, 0x0d97, 0x056f, 0x0893, 0xff17, 0x027c,
0xf907, 0xff6a, 0xfb28, 0x018b, 0xfa49, 0x008e, 0xf467, 0xfb0d, 0xf2a4, 0xfce0,
0xf403, 0x01e1, 0xf6b6, 0x028b, 0xf876, 0x00b4, 0xf570, 0xfc13, 0xf57e, 0xfbc6,
0xf75c, 0xfe95, 0xea63, 0xf563, 0xe492, 0xf2df, 0xea04, 0xf685, 0xfa8d, 0x04ea,
0xf9f1, 0x010b, 0xfb6a, 0xfd59, 0xf876, 0xfc7d, 0xf8d3, 0x01b7, 0xf4d3, 0xfe72,
0xef5c, 0xf71a, 0xfaf8, 0x0028, 0xf698, 0xfa72, 0xf0dc, 0xf801, 0xeb57, 0xf731,
0xf385, 0xfe67, 0xf3cd, 0xfac9, 0xee07, 0xf299, 0xe8c0, 0xecce, 0xeb7f, 0xf164,
0xeaca, 0xf5cf, 0xebdd, 0xf439, 0xf20d, 0xf507, 0xf382, 0xf8b0, 0xf38d, 0xfd0c,
0xf5b6, 0xff61, 0xebd2, 0xf3e1, 0xe5be, 0xedba, 0xed33, 0xf2d1, 0xf4e0, 0xf521,
0xf7cf, 0xf880, 0xf2b9, 0xf717, 0xe7c3, 0xeb91, 0xe8f3, 0xef92, 0xf328, 0xf7ac,
0xfa70, 0xfa1f, 0x0602, 0x0314, 0x09de, 0x082d, 0x0815, 0x0c11, 0x0162, 0x05e3,
0x04f8, 0x06ae, 0x0327, 0x02a1, 0x02b2, 0x04b7, 0x0d3c, 0x0f19, 0x1706, 0x156a,
0x151f, 0x1314, 0x0714, 0x06ec, 0x043b, 0x0425, 0x0549, 0x026f, 0x0a2b, 0x0770,
0x0a68, 0x0a95, 0x0df3, 0x0d4f, 0x11ea, 0x0ebf, 0x0ddb, 0x0d5d, 0x0479, 0x0759,
0x0713, 0x069c, 0x0b62, 0x0a3e, 0x073e, 0x09f8, 0xfecf, 0x02ea, 0x02f3, 0x0495,
0x1416, 0x1233, 0x0e8b, 0x0c09, 0x07d8, 0x07fc, 0x057d, 0x08b0, 0x0f6c, 0x130c,
0x0e80, 0x0dff, 0x08fd, 0x05b2, 0x09ad, 0x0676, 0x07da, 0x0710, 0x065d, 0x08e1,
0x0138, 0x02c7, 0xf6aa, 0xf7a9, 0xfc1b, 0x0053, 0x0930, 0x0c90, 0x1033, 0x0e13,
0x0136, 0xffce, 0xf3db, 0xf53f, 0xf529, 0xf89a, 0xfc59, 0xfe87, 0x0b29, 0x0797,
0x06b2, 0x0568, 0xf96d, 0xfdf8, 0xf6a6, 0xf82d, 0xfd3f, 0xf961, 0xfc88, 0xf8df,
0xfa26, 0xfba3, 0xf145, 0xf4b6, 0xf70b, 0xf69b, 0x01c7, 0xfdbc, 0x02f1, 0xff8d,
0xf908, 0xf918, 0xeef7, 0xf17f, 0xeb73, 0xef12, 0xf1bd, 0xf4ad, 0xf7f7, 0xf9a9,
0xf7f6, 0xfb46, 0xfdfe, 0xffd7, 0xfc74, 0xfa46, 0xf98d, 0xf6f5, 0xf166, 0xefd9,
0xf732, 0xf7ec, 0xfb35, 0x0043, 0xf824, 0xff4c, 0xfca1, 0xfef1, 0xfc17, 0xf9c7,
0xf647, 0xf574, 0xf058, 0xf295, 0xf2b6, 0xf3cb, 0xf219, 0xf34d, 0xee91, 0xf28c,
0xf1d1, 0xf612, 0xf490, 0xf5aa, 0xf6ef, 0xf47d, 0xfb35, 0xf9f3, 0xed1f, 0xed9f,
0xe808, 0xea02, 0xeb18, 0xeb9d, 0xede3, 0xebb0, 0xefd6, 0xee87, 0xf2cb, 0xf3c0,
0xf721, 0xf5d1, 0xf87a, 0xf3e2, 0xfa55, 0xf5cf, 0xf41f, 0xf385, 0xedd5, 0xefcd,
0xe97b, 0xe97c, 0xf1b9, 0xefbd, 0xfeb3, 0xf8e1, 0xfd94, 0xf76d, 0xf51b, 0xf414,
0xec39, 0xef2f, 0xeb3f, 0xeda7, 0xf044, 0xf110, 0xf81c, 0xf8ca, 0x0219, 0x0070,
0xf1e6, 0xeffa, 0xebac, 0xeb50, 0xee96, 0xeb2f, 0xe7f5, 0xe476, 0xeab0, 0xe8ad,
0xf32f, 0xee30, 0xf9c7, 0xf37f, 0xfd2a, 0xf6e8, 0xfe9e, 0xf7a2, 0x0454, 0xfdef,
0x0300, 0xfc35, 0x041a, 0xff20, 0x0355, 0xff78, 0x0591, 0x0215, 0x080b, 0x05c9,
0x0960, 0x05f0, 0x0d49, 0x06c8, 0xffcd, 0xf66a, 0xfc75, 0xf1cc, 0xfee6, 0xf475,
0x06ba, 0xff51, 0x1373, 0x0aa8, 0x14b2, 0x0911, 0x09af, 0x0166, 0x011b, 0xfbe0,
0xffe3, 0xf7bc, 0x0c39, 0xff65, 0x18eb, 0x0a2d, 0x0fc8, 0x03ef, 0x14c3, 0x0aae,
0x1c4f, 0x0ebc, 0x24c8, 0x1379, 0x21a3, 0x132f, 0x216f, 0x18de, 0x23bb, 0x1c47,
0x20c6, 0x188f, 0x2658, 0x1beb, 0x2b1e, 0x2145, 0x2f5e, 0x24c2, 0x2adc, 0x1dd0,
0x2469, 0x1917, 0x26da, 0x1b70, 0x27ac, 0x1d30, 0x2fd3, 0x2750, 0x3250, 0x2817,
0x2a61, 0x1d01, 0x2ee6, 0x2266, 0x3600, 0x2d05, 0x3748, 0x2c8f, 0x312d, 0x25e7,
0x2a75, 0x2120, 0x27c9, 0x2178, 0x34f3, 0x2d36, 0x2f24, 0x20d9, 0x2a9d, 0x1bcc,
0x2583, 0x17bf, 0x2664, 0x1b91, 0x24e9, 0x1a37, 0x1fed, 0x1600, 0x1d48, 0x147f,
0x29ff, 0x1f5b, 0x2658, 0x1bb0, 0x1b65, 0x0f73, 0x2304, 0x157e, 0x28de, 0x1d7f,
0x2943, 0x2331, 0x201f, 0x1e39, 0x20fe, 0x1ef4, 0x262a, 0x1f71, 0x28c0, 0x2004,
0x2292, 0x1ae5, 0x2211, 0x1c9c, 0x1f7c, 0x1d34, 0x23d9, 0x2053, 0x1ebd, 0x185f,
0x26c9, 0x1f00, 0x2f32, 0x260c, 0x2d56, 0x27d9, 0x210d, 0x2119, 0x1a78, 0x1945,
0x2448, 0x1fd8, 0x2004, 0x182e, 0x1d94, 0x1627, 0x19da, 0x16f3, 0x191c, 0x15db,
0x15c6, 0x120b, 0x1cc9, 0x193d, 0x2431, 0x2113, 0x1a1b, 0x18c5, 0x16b2, 0x1612,
0x19af, 0x193c, 0x1b85, 0x18d4, 0x2a30, 0x24b9, 0x2631, 0x2229, 0x172c, 0x14f6,
0x16b3, 0x15e3, 0x17bf, 0x1856, 0x18f8, 0x18e0, 0x1d19, 0x1b29, 0x1b3b, 0x1915,
0x1758, 0x1671, 0x14f2, 0x1571, 0x129c, 0x162f, 0x14df, 0x1902, 0x1594, 0x1651,
0x1516, 0x1561, 0x119f, 0x12e5, 0x1ab1, 0x1991, 0x1efc, 0x1d67, 0x1233, 0x12dd,
0x0e3a, 0x0e56, 0x1462, 0x1298, 0x1d0a, 0x1d57, 0x11c5, 0x14be, 0x103f, 0x11f5,
0x0fc4, 0x102f, 0x0edc, 0x0f23, 0x087e, 0x097a, 0x07a8, 0x0908, 0x0dae, 0x0dc6,
0x1131, 0x12d7, 0x0cc5, 0x0f11, 0x0b54, 0x0d27, 0x0f41, 0x0fb3, 0x1507, 0x1564,
0x196b, 0x1753, 0x1280, 0x0fa9, 0x0d01, 0x11a9, 0x141c, 0x1a2e, 0x2294, 0x235c,
0x24e7, 0x20a6, 0x1418, 0x1489, 0x1034, 0x1407, 0x188b, 0x1c15, 0x1347, 0x199a,
0x12d9, 0x1724, 0x128f, 0x149f, 0x0f13, 0x100a, 0x06eb, 0x086f, 0x086f, 0x0871,
0x0d5d, 0x0a68, 0x10bc, 0x0df5, 0x0ece, 0x0e34, 0x0b87, 0x0cef, 0x0865, 0x0b89,
0x12ed, 0x163f, 0x152c, 0x1782, 0x0c5e, 0x0e0f, 0x0248, 0x0424, 0x04e7, 0x081d,
0x09b4, 0x0f03, 0x07f0, 0x0e82, 0x0f41, 0x1361, 0x1484, 0x1515, 0x12bc, 0x12fd,
0x0ef5, 0x1546, 0x0ed9, 0x19d4, 0x0ca9, 0x1850, 0x0a94, 0x1469, 0x0515, 0x0e7d,
0x04b5, 0x0cba, 0xfe50, 0x050a, 0xfc75, 0x0484, 0xfa9b, 0x0250, 0xfe97, 0x0679,
0x0b1f, 0x0fa7, 0x0214, 0x065d, 0xfb51, 0x062c, 0xfc9d, 0x08de, 0xfd5c, 0x06f3,
0xfd38, 0x04fc, 0xfce1, 0x048a, 0xfdb5, 0x073a, 0xf53b, 0xfec5, 0xf8fe, 0x0231,
0xfc40, 0x07c0, 0xfcf6, 0x0813, 0x0048, 0x0568, 0xfc71, 0x0038, 0xf3c8, 0xff7e,
0xf532, 0x0532, 0xfbaa, 0x0921, 0xfa35, 0x0398, 0xfac0, 0x0184, 0xf70b, 0xfe6b,
0xf548, 0xfd8b, 0xf826, 0x0071, 0xf5e7, 0x0003, 0xf44e, 0x0070, 0xf690, 0x0142,
0xf37b, 0xfd93, 0xf64d, 0x008d, 0xf49c, 0xfc09, 0xf233, 0xf840, 0xf21e, 0xfcb0,
0xf269, 0xfffc, 0xf510, 0xfef3, 0xec6f, 0xf3a5, 0xefc7, 0xf7c3, 0xf13e, 0xfb31,
0xf1b8, 0xfc60, 0xf1ad, 0xfc57, 0xedb5, 0xf7bb, 0xe2cf, 0xeeb1, 0xd7ee, 0xe4cf,
0xe0c5, 0xeca1, 0xe9b6, 0xf4f5, 0xee74, 0xf837, 0xe81f, 0xefef, 0xe717, 0xee64,
0xe74b, 0xf0a4, 0xe76b, 0xf74f, 0xe6f7, 0xf855, 0xe837, 0xf4a2, 0xe9cb, 0xf330,
0xe79d, 0xf0ab, 0xe2ac, 0xec67, 0xe409, 0xeb46, 0xeb9d, 0xf268, 0xee02, 0xf6e6,
0xeb65, 0xf4b9, 0xe8b2, 0xef21, 0xe6c9, 0xebb5, 0xe184, 0xe72e, 0xe576, 0xebba,
0xeb8f, 0xf3aa, 0xe9e1, 0xf454, 0xe120, 0xec3d, 0xd9fd, 0xe564, 0xdebb, 0xe87a,
0xe4a1, 0xeb7b, 0xe257, 0xe881, 0xdbd0, 0xe339, 0xdf3c, 0xeb15, 0xe10d, 0xef67,
0xdd3a, 0xeace, 0xd47a, 0xe223, 0xd5ee, 0xe269, 0xd974, 0xe244, 0xd533, 0xdd7a,
0xdcd0, 0xe942, 0xdfb4, 0xed3c, 0xdd55, 0xe7bf, 0xda50, 0xe568, 0xd439, 0xe149,
0xd42f, 0xdbdd, 0xd854, 0xdc1e, 0xd974, 0xdf87, 0xd6ca, 0xdea5, 0xd4a3, 0xdccf,
0xd577, 0xddf2, 0xd47d, 0xdd8c, 0xd37f, 0xdca0, 0xd6e6, 0xdeef, 0xd808, 0xe134,
0xda83, 0xe770, 0xde7e, 0xeae5, 0xd9b2, 0xe33b, 0xd938, 0xe40d, 0xd482, 0xe100,
0xd2d8, 0xdb31, 0xd221, 0xd878, 0xd3ef, 0xdd21, 0xd8cf, 0xe42e, 0xd652, 0xe117,
0xd844, 0xe2c2, 0xd76c, 0xdea1, 0xd480, 0xdac9, 0xcec9, 0xd910, 0xcab3, 0xd5c4,
0xcd7c, 0xd68e, 0xd3c8, 0xdc58, 0xd272, 0xdb39, 0xcfa3, 0xda04, 0xcd53, 0xd655,
0xd5e7, 0xda18, 0xd19f, 0xd5e1, 0xcf74, 0xd557, 0xd469, 0xdb34, 0xd370, 0xd973,
0xd029, 0xd665, 0xd1dc, 0xd5f9, 0xd7cc, 0xd94a, 0xdcd8, 0xdeba, 0xd89a, 0xdd40,
0xd0c3, 0xd66b, 0xce5a, 0xd02e, 0xd29f, 0xd356, 0xd9a7, 0xdc4c, 0xd7f0, 0xdc77,
0xd062, 0xd58f, 0xc770, 0xcbf3, 0xc68f, 0xc99c, 0xce40, 0xd07e, 0xd441, 0xd69a,
0xd3c2, 0xd628, 0xcf09, 0xd194, 0xd0bb, 0xd256, 0xd4c6, 0xd3c3, 0xd428, 0xd24f,
0xce2e, 0xccbd, 0xceec, 0xcb78, 0xcecf, 0xce0d, 0xcc70, 0xcf6f, 0xc935, 0xc833,
0xce72, 0xc8c9, 0xd68a, 0xd052, 0xd575, 0xd083, 0xcca8, 0xc8c9, 0xc736, 0xc3b3,
0xd042, 0xcccc, 0xd124, 0xcb05, 0xd0ae, 0xc949, 0xce85, 0xc919, 0xd2d1, 0xce4f,
0xd5f6, 0xd0d8, 0xd736, 0xd0f0, 0xd9ab, 0xd2d0, 0xd72e, 0xd31b, 0xd973, 0xd689,
0xdbf6, 0xd602, 0xe04f, 0xd83b, 0xdd88, 0xd78c, 0xdf90, 0xda35, 0xe479, 0xdf30,
0xe868, 0xe678, 0xea7a, 0xe4eb, 0xe333, 0xda21, 0xe437, 0xdd78, 0xe9a0, 0xe13c,
0xec54, 0xe290, 0xea06, 0xe379, 0xecae, 0xe976, 0xf1d3, 0xed0e, 0xf188, 0xea3d,
0xec55, 0xe697, 0xeafd, 0xe670, 0xf13e, 0xeb0e, 0xf91f, 0xf12d, 0xfff0, 0xf83c,
0x032b, 0xfaa0, 0x0409, 0xf8a2, 0xff85, 0xf3b5, 0xfadf, 0xf286, 0xf7bc, 0xf450,
0xfb3d, 0xf794, 0xfd5f, 0xf638, 0xfe34, 0xf791, 0xfe5e, 0xfb2e, 0x0542, 0x0138,
0x0262, 0xfa18, 0xfad4, 0xf17e, 0xfb44, 0xefd1, 0x023a, 0xf4a0, 0x054f, 0xfa2d,
0xff17, 0xfaef, 0xf8bd, 0xf5bf, 0xfa75, 0xf440, 0x0151, 0xf981, 0x039e, 0xf9ed,
0x0386, 0xf95f, 0x00a0, 0xf617, 0xfdbd, 0xf41c, 0xffbf, 0xf4fe, 0x06fa, 0xf78c,
0x0747, 0xf6a1, 0x0195, 0xf642, 0xfe4b, 0xf3f4, 0x0459, 0xf75c, 0x07b7, 0xfa2e,
0xfcf3, 0xf2da, 0xfd07, 0xf7e0, 0x04c6, 0xfe1a, 0x04e5, 0xfcf4, 0xfd2c, 0xf5ab,
0xfc5d, 0xf2d3, 0x066c, 0xfaba, 0x0bca, 0x0159, 0x1031, 0x0910, 0x0951, 0x0608,
0x01bc, 0xfd7d, 0x0184, 0xf89b, 0x055e, 0xfcf7, 0x0ba9, 0x04ba, 0x0dc7, 0x065a,
0x0db7, 0x07ca, 0x0a1d, 0x03f7, 0x08f0, 0xff82, 0x0b8b, 0x013a, 0x0c41, 0x03d4,
0x0c7a, 0x0632, 0x121b, 0x09d0, 0x105c, 0x06d9, 0x15af, 0x0b07, 0x1ccc, 0x1057,
0x0d17, 0x01e1, 0x06f4, 0xfdf1, 0x0983, 0x01f3, 0x1267, 0x07b0, 0x0d8a, 0x00db,
0x0d9b, 0x0418, 0x1025, 0x0f6c, 0x06f8, 0x0b0d, 0x0705, 0x0403, 0x0bb9, 0x025e,
0x1351, 0x0a36, 0x0830, 0x0265, 0x074a, 0xff59, 0x10f4, 0x049f, 0x12b9, 0x062f,
0x104b, 0x0743, 0x0cb9, 0x0560, 0x09f5, 0x01a6, 0x1353, 0x0aba, 0x13b1, 0x0c29,
0x1045, 0x0c3e, 0x131e, 0x1117, 0x164b, 0x116f, 0x14ab, 0x0ce7, 0x0dca, 0x05ed,
0x09ac, 0x01ea, 0x0e20, 0x0552, 0x1625, 0x0d48, 0x1719, 0x0e45, 0x11a8, 0x08d4,
0x0bdc, 0x05e1, 0x0cc2, 0x0af6, 0x106e, 0x0f1b, 0x12af, 0x0e70, 0x1331, 0x0cca,
0x0c0b, 0x03da, 0x17da, 0x0e6d, 0x1d4c, 0x13d1, 0x1822, 0x10ca, 0x12c9, 0x100f,
0x1583, 0x13d7, 0x1d6e, 0x17ae, 0x1eba, 0x180d, 0x1c5d, 0x16c8, 0x16c3, 0x11f5,
0x174d, 0x1449, 0x155e, 0x11a8, 0x12e2, 0x0c10, 0x0d1e, 0x060f, 0x1074, 0x09d8,
0x12de, 0x0e25, 0x109c, 0x112b, 0x0bc0, 0x0c14, 0x1486, 0x10fa, 0x1412, 0x0df6,
0x0ae3, 0x05f0, 0x0608, 0x02f2, 0x09f6, 0x07b1, 0x1416, 0x119b, 0x15ae, 0x137f,
0x0f50, 0x0e45, 0x0aa0, 0x08ec, 0x0a78, 0x0c65, 0x0e45, 0x131c, 0x1326, 0x17aa,
0x13ab, 0x17e2, 0x1230, 0x13e0, 0x0a93, 0x0a31, 0x0d65, 0x0b85, 0x0fd5, 0x0e10,
0x19ab, 0x16dc, 0x1b92, 0x18dc, 0x1b1e, 0x1b9f, 0x1bd1, 0x1d51, 0x1737, 0x16d7,
0x17d8, 0x1572, 0x1768, 0x1678, 0x1a3f, 0x18e8, 0x1a45, 0x15c6, 0x15e5, 0x128e,
0x1025, 0x1113, 0x1029, 0x109e, 0x16ad, 0x12eb, 0x166a, 0x1207, 0x11ed, 0x0f00,
0x12e1, 0x1069, 0x1b2b, 0x17a9, 0x1e00, 0x1b2e, 0x17cf, 0x18a8, 0x11e4, 0x141e,
0x0be0, 0x0db6, 0x0c88, 0x0d44, 0x0519, 0x0654, 0x0a9f, 0x0a45, 0x156b, 0x0fec,
0x13bf, 0x0eeb, 0x14e2, 0x12df, 0x140f, 0x1550, 0x1978, 0x1b76, 0x139f, 0x120e,
0x1360, 0x1218, 0x147c, 0x1527, 0x1447, 0x1616, 0x130a, 0x1567, 0x0d74, 0x1052,
0x101b, 0x127b, 0x0be3, 0x0e06, 0x0fe9, 0x10ca, 0x15a0, 0x1391, 0x1480, 0x11f2,
0x0f20, 0x0f2b, 0x0810, 0x0bb8, 0x02b0, 0x0998, 0x071a, 0x0dc2, 0x097b, 0x0e16,
0x0a67, 0x0daa, 0x0b26, 0x0c98, 0x0909, 0x0a1c, 0x0a0a, 0x0b70, 0x095e, 0x0ba8,
0x07d5, 0x0cd4, 0x0510, 0x0ba8, 0x0416, 0x0a36, 0x054b, 0x09d2, 0x0bfe, 0x0e19,
0x0bad, 0x0e10, 0x07be, 0x0b1f, 0x0666, 0x08d3, 0x09b6, 0x0b48, 0x0ddf, 0x10b6,
0x0a25, 0x1087, 0x067a, 0x0ee1, 0x04ee, 0x09ce, 0x0556, 0x05f6, 0x03c7, 0x045e,
0x0439, 0x053b, 0x06fd, 0x0833, 0x05ca, 0x09de, 0x046e, 0x09a7, 0x0270, 0x08c6,
0xfe8b, 0x0715, 0x07ca, 0x0ed7, 0x028d, 0x065c, 0xf842, 0xfd2b, 0xf86f, 0xffc3,
0xfb66, 0x004c, 0xfd5f, 0x01ad, 0xfbb0, 0x017c, 0xfd93, 0x0524, 0xf94c, 0x0141,
0xf3e7, 0xfc97, 0xf2ec, 0xfed7, 0xf8a6, 0x02a2, 0xfa05, 0x0001, 0xf62c, 0xfbb9,
0xf773, 0xff37, 0xf7b6, 0x0216, 0xf677, 0x00b9, 0xf304, 0xfa52, 0xf75d, 0xfc98,
0xf4ff, 0xfc69, 0xf35b, 0xfb25, 0xf0b3, 0xf7e1, 0xf280, 0xfbc0, 0xf4e9, 0xfda3,
0xf2cb, 0xf989, 0xe9e6, 0xef9b, 0xeb33, 0xf296, 0xef26, 0xf6db, 0xede4, 0xf477,
0xe82e, 0xefc6, 0xe4b6, 0xed4e, 0xedd3, 0xf644, 0xf512, 0xff19, 0xf650, 0x011c,
0xf4a7, 0xfc61, 0xf650, 0xfa7f, 0xf0ca, 0xf4b0, 0xef5f, 0xf68e, 0xf157, 0xf970,
0xf2ac, 0xfcce, 0xecc6, 0xf7b3, 0xeb08, 0xf308, 0xf1eb, 0xf650, 0xf63c, 0xf837,
0xfa79, 0xfd9e, 0xfcaf, 0x00b5, 0xf104, 0xf535, 0xec38, 0xf197, 0xef71, 0xf528,
0xfc7f, 0xfe21, 0x039e, 0x0088, 0x03e3, 0x026a, 0x03c1, 0x0631, 0xfc7a, 0x00d8,
0xff08, 0x02ee, 0x0012, 0x0368, 0xff3b, 0x01ae, 0xfcc0, 0xfccf, 0xff52, 0xfcb5,
0xfe3d, 0xfc30, 0xfd68, 0xfcda, 0xf9da, 0xfc41, 0xf9a5, 0xfd59, 0xfc00, 0xfe75,
0x036d, 0x045b, 0x057b, 0x04ea, 0x02fd, 0x0173, 0x03c5, 0x0205, 0x0154, 0x01ce,
0x043f, 0x0325, 0x01bf, 0x0095, 0x093a, 0x0ad3, 0x0aca, 0x0c22, 0x0c83, 0x082d,
0x105d, 0x06e7, 0x0f00, 0x07cc, 0x0c5a, 0x0c07, 0x0d3c, 0x11ef, 0x1181, 0x133c,
0x0e50, 0x0af4, 0x077e, 0x0656, 0xfe47, 0x01a2, 0xffd3, 0x0238, 0x006f, 0x010a,
0x023f, 0x0129, 0x00fa, 0xfd90, 0x0553, 0x003f, 0x0a67, 0x0738, 0x09c0, 0x0a51,
0x0041, 0x01df, 0xfc39, 0xfb61, 0xfb64, 0xfafa, 0xff40, 0x0038, 0x02d5, 0x0188,
0x00b0, 0xff2f, 0xffa0, 0xfee0, 0xfe41, 0xfd95, 0xfb83, 0xfbf5, 0xf939, 0xfae6,
0x00b2, 0x0283, 0x01c1, 0x0246, 0x0175, 0x010f, 0xfedd, 0xff23, 0x04c8, 0x06c9,
0x00ae, 0x0407, 0xf817, 0xfa6b, 0xf9e0, 0xf6bf, 0xfedb, 0xf8c8, 0x0360, 0x0234,
0x074e, 0x0aee, 0xfdea, 0x02eb, 0xf788, 0xfb90, 0xf9c9, 0xf93c, 0xf64b, 0xf323,
0xf9fa, 0xfa22, 0xfd66, 0x008b, 0xfe0e, 0xffc2, 0xf650, 0xf379, 0xf9ff, 0xf59f,
0xfcbf, 0xfec7, 0xf826, 0xfe80, 0xfaaf, 0xfe86, 0xfd1a, 0xfd72, 0xf389, 0xf582,
0xf7cf, 0xfb17, 0xfc49, 0xfe36, 0xfa86, 0xfc62, 0xf60c, 0xf777, 0xf52f, 0xf5a7,
0xf7e1, 0xf661, 0xf752, 0xf476, 0x01a5, 0xff48, 0x065d, 0x03a2, 0x04dd, 0x027a,
0xfd69, 0xfe1c, 0xf77e, 0xf8b3, 0xf433, 0xf468, 0xf603, 0xf55e, 0xf9fa, 0xf6e4,
0xfbd6, 0xfb09, 0xfab9, 0xfc41, 0xf9c5, 0xf8b0, 0xf986, 0xf492, 0xf656, 0xf39f,
0xf484, 0xf75d, 0xf688, 0xf89a, 0xfacc, 0xfa56, 0xfa72, 0xfb0e, 0xf2d3, 0xf28e,
0xf308, 0xf073, 0xf634, 0xf142, 0xf51b, 0xf204, 0xf536, 0xf5b9, 0xf851, 0xf8c9,
0xfd17, 0xfbd9, 0x0494, 0xffde, 0x06b0, 0xff4d, 0x021f, 0xfbf2, 0xfc66, 0xf929,
0xfed3, 0xfcf7, 0x000d, 0xfcbf, 0x001f, 0xfbcf, 0x02ad, 0xfc94, 0x0843, 0x025f,
0x09d5, 0x0572, 0x05d0, 0xff2f, 0x0b21, 0x02ad, 0x092f, 0x0106, 0x0728, 0x00f7,
0x07b4, 0x0332, 0x0b83, 0x082c, 0x0deb, 0x0967, 0x0c40, 0x03bc, 0x0934, 0xfcf9,
0x0cca, 0x001e, 0x1312, 0x088a, 0x1924, 0x1164, 0x19da, 0x12a1, 0x1775, 0x0f1d,
0x14c9, 0x0bd9, 0x17bf, 0x0de8, 0x1a63, 0x0eb1, 0x1b12, 0x0f3b, 0x1c84, 0x155e,
0x1dcb, 0x1925, 0x245c, 0x1cd2, 0x2acd, 0x1eb2, 0x272e, 0x1b56, 0x25c8, 0x1d51,
0x24a4, 0x1dc8, 0x21d8, 0x19c2, 0x22c0, 0x1adb, 0x2281, 0x1cb6, 0x25ce, 0x1f72,
0x2ab1, 0x217c, 0x26ea, 0x1d17, 0x2297, 0x1b52, 0x26ca, 0x1d7f, 0x2e30, 0x1f90,
0x30b7, 0x22e9, 0x2eb4, 0x24ba, 0x316b, 0x294a, 0x2cd8, 0x2631, 0x2747, 0x2244,
0x246b, 0x1f89, 0x1fb2, 0x1b9a, 0x2204, 0x1d58, 0x2396, 0x1d2e, 0x2511, 0x1e83,
0x25ba, 0x1c3a, 0x275b, 0x1db6, 0x2bb0, 0x2162, 0x2bf2, 0x2293, 0x2b90, 0x24b2,
0x2836, 0x224b, 0x253a, 0x2203, 0x2d9c, 0x2abf, 0x3110, 0x2972, 0x2bfd, 0x1f69,
0x2536, 0x1a03, 0x2077, 0x19f3, 0x2087, 0x1e72, 0x25bd, 0x24e3, 0x24ac, 0x1f46,
0x22fb, 0x19e6, 0x1e68, 0x1850, 0x18e1, 0x1877, 0x18db, 0x1a12, 0x1bf3, 0x1bd0,
0x2040, 0x1ec7, 0x24ec, 0x1fff, 0x2498, 0x1ec7, 0x1fb7, 0x1b8e, 0x1c7a, 0x1c2a,
0x1d31, 0x1f83, 0x1ed8, 0x1ffc, 0x1ebd, 0x1ca9, 0x1e4a, 0x1b01, 0x2174, 0x1ffe,
0x249e, 0x23a8, 0x1905, 0x18da, 0x19e4, 0x1a3a, 0x1d65, 0x1d0b, 0x1d87, 0x1b8d,
0x2228, 0x20b2, 0x2093, 0x224a, 0x1f25, 0x224e, 0x1c29, 0x1c4b, 0x1532, 0x1424,
0x126e, 0x125e, 0x1252, 0x136b, 0x139f, 0x14c8, 0x10be, 0x1356, 0x143d, 0x17aa,
0x1c2e, 0x1e3a, 0x1f4c, 0x2022, 0x1bb0, 0x1994, 0x14a2, 0x136f, 0x1522, 0x1863,
0x1487, 0x1935, 0x12c9, 0x1718, 0x15a0, 0x186f, 0x1b18, 0x1ce6, 0x1a15, 0x1cf2,
0x13b7, 0x183c, 0x120f, 0x1849, 0x14ef, 0x1867, 0x15ba, 0x1886, 0x13ea, 0x17c3,
0x18ab, 0x1d6b, 0x195a, 0x1fe4, 0x15e1, 0x1de4, 0x0d48, 0x14e2, 0x0e6e, 0x12dd,
0x141a, 0x189f, 0x0e48, 0x1374, 0x0b7f, 0x10ae, 0x0b33, 0x0d3c, 0x0d57, 0x0c1a,
0x0f5f, 0x0fbb, 0x0d82, 0x0f8e, 0x087f, 0x0c93, 0x02ea, 0x066b, 0x0487, 0x0725,
0x0b73, 0x0fe1, 0x107e, 0x1388, 0x0b79, 0x0df0, 0x06e4, 0x09c8, 0x03e6, 0x06e7,
0x0351, 0x0845, 0x05aa, 0x08ea, 0x0691, 0x0699, 0x0a53, 0x0a8a, 0x0a7f, 0x0ce7,
0x0ac4, 0x109f, 0x0ab6, 0x0f28, 0x08f3, 0x0bec, 0x080d, 0x0cc9, 0x0b1a, 0x0f0c,
0x0b51, 0x11ab, 0x053f, 0x0f93, 0x0334, 0x0a11, 0x03fa, 0x0448, 0x0679, 0x04a9,
0x09cb, 0x0d98, 0x0b14, 0x1113, 0x05e2, 0x0aba, 0xfe49, 0x0374, 0x0045, 0x045c,
0x0352, 0x091f, 0x03f0, 0x0b2a, 0xfe8c, 0x079e, 0xf8b8, 0x0316, 0xf7c2, 0xff1a,
0xf729, 0xfa86, 0xfd14, 0xffda, 0xfd47, 0x0318, 0xf7f2, 0x0276, 0xf6af, 0x0195,
0xf5bc, 0xfdcb, 0xf6d3, 0xfc87, 0xfaaf, 0x0002, 0xfa5e, 0x02ea, 0xf9bb, 0x04f2,
0xf7a7, 0x034c, 0xf88f, 0x02eb, 0xfa2c, 0x0328, 0xfadb, 0x03ac, 0xfc41, 0x0493,
0xf838, 0xff6f, 0xf4bc, 0xfc59, 0xf4d0, 0xfd44, 0xf531, 0xfe5e, 0xf380, 0xfdca,
0xf427, 0xfe48, 0xf3ef, 0xfbd9, 0xee73, 0xf3a0, 0xe6c6, 0xed07, 0xe548, 0xed9a,
0xe993, 0xf169, 0xe9d4, 0xf257, 0xeb01, 0xf5e7, 0xe75b, 0xf4be, 0xe939, 0xf6a3,
0xe957, 0xf454, 0xe7d1, 0xf349, 0xe8eb, 0xf223, 0xe904, 0xf147, 0xe9b1, 0xf3cb,
0xe4bc, 0xf03f, 0xe67a, 0xf38c, 0xeb44, 0xf536, 0xebf9, 0xf36a, 0xe8ed, 0xf24c,
0xe506, 0xf091, 0xe0e3, 0xebf2, 0xddbd, 0xe95a, 0xdc31, 0xea20, 0xdc61, 0xeb6e,
0xdf32, 0xeaf2, 0xdc0a, 0xe3cb, 0xe142, 0xe96a, 0xe44f, 0xee91, 0xe271, 0xee78,
0xe06d, 0xeb0d, 0xdf18, 0xe619, 0xdf5e, 0xe5d6, 0xe093, 0xea89, 0xe141, 0xec5e,
0xe30c, 0xeabf, 0xe2d3, 0xe9b6, 0xe126, 0xe8bf, 0xe0a2, 0xe605, 0xdd64, 0xe35e,
0xd8bb, 0xe1c5, 0xd7e4, 0xe31c, 0xdba0, 0xe653, 0xdb9f, 0xe78a, 0xda0d, 0xe5f8,
0xd98e, 0xe0c6, 0xd727, 0xdc97, 0xd87e, 0xde7e, 0xda1f, 0xe312, 0xdaef, 0xe757,
0xd9c7, 0xe4f5, 0xdcf7, 0xe4e0, 0xdc1a, 0xe22e, 0xd69c, 0xdff4, 0xd6d4, 0xe35e,
0xd7ca, 0xe341, 0xd751, 0xdefa, 0xd205, 0xd834, 0xd3a6, 0xdc3c, 0xd516, 0xdd46,
0xd5df, 0xdcb1, 0xd30a, 0xd87d, 0xd0d9, 0xd615, 0xcf46, 0xd675, 0xcda1, 0xd581,
0xcb2e, 0xd199, 0xcd08, 0xd3ae, 0xd36d, 0xdb76, 0xd6cc, 0xde90, 0xd648, 0xdc59,
0xd477, 0xd94d, 0xd585, 0xdb99, 0xd394, 0xda8f, 0xd119, 0xd8a3, 0xd18b, 0xd929,
0xd369, 0xdae9, 0xd92a, 0xe06e, 0xd7db, 0xddf1, 0xd35f, 0xda5e, 0xccf6, 0xd66e,
0xcc95, 0xd5fe, 0xce45, 0xd4d1, 0xd0d1, 0xd556, 0xd167, 0xd82a, 0xce2c, 0xd54c,
0xcbe2, 0xd171, 0xcd55, 0xd3f3, 0xcfa8, 0xd387, 0xd02e, 0xd2ee, 0xd2ae, 0xd4eb,
0xd4a0, 0xd788, 0xd602, 0xda72, 0xd269, 0xd85d, 0xd598, 0xdaa7, 0xd6ef, 0xd866,
0xd5af, 0xd5df, 0xd48e, 0xd376, 0xd303, 0xd560, 0xd63b, 0xda22, 0xd684, 0xd738,
0xd565, 0xd5c7, 0xcd09, 0xcefd, 0xc9b5, 0xcd52, 0xcb25, 0xcdc4, 0xccff, 0xce5a,
0xced7, 0xcf37, 0xd15e, 0xcebd, 0xd72b, 0xd4cf, 0xd571, 0xd4a9, 0xd388, 0xd3fa,
0xd203, 0xd37d, 0xd5d6, 0xd565, 0xd761, 0xd536, 0xd880, 0xd47c, 0xd785, 0xd33a,
0xd4c1, 0xd218, 0xd2b1, 0xd096, 0xd34e, 0xcfa0, 0xda81, 0xd374, 0xd9ef, 0xd5d0,
0xd497, 0xd414, 0xcf9b, 0xcd69, 0xd27e, 0xce8d, 0xd5c6, 0xcf71, 0xd7fb, 0xd167,
0xd66c, 0xd36c, 0xd42b, 0xd1b3, 0xd55e, 0xcf9a, 0xd714, 0xce39, 0xdc33, 0xd2e9,
0xdc8f, 0xd478, 0xdc5e, 0xd47e, 0xda34, 0xd3ce, 0xdc96, 0xd65f, 0xe1ff, 0xd971,
0xe502, 0xde15, 0xe0ed, 0xdbc3, 0xdcdd, 0xd5e9, 0xdea5, 0xd51d, 0xdd90, 0xd58a,
0xdd1c, 0xd89b, 0xdfaf, 0xda68, 0xe457, 0xdcb1, 0xe3f8, 0xdd3b, 0xe356, 0xdf0a,
0xe635, 0xe093, 0xea23, 0xdf8c, 0xed18, 0xe11f, 0xea9d, 0xe153, 0xe764, 0xe008,
0xe44a, 0xdeec, 0xe671, 0xe159, 0xea7f, 0xe425, 0xeb59, 0xe58a, 0xf08b, 0xe81a,
0xf208, 0xe9a3, 0xf367, 0xee47, 0xf00a, 0xea9d, 0xf652, 0xed82, 0xfeb2, 0xf2ec,
0xf921, 0xeff6, 0xf6bc, 0xef94, 0xf882, 0xf248, 0xfd1b, 0xf782, 0xfa06, 0xf362,
0xf76d, 0xf00c, 0xfaf8, 0xefa1, 0x0523, 0xf8a4, 0x053a, 0xfb2f, 0x032a, 0xf959,
0x0387, 0xf9bf, 0x02e0, 0xf7cf, 0x002a, 0xf454, 0xfa6a, 0xefbe, 0xfc63, 0xef44,
0x0087, 0xf302, 0x0431, 0xf89a, 0x06af, 0xf96d, 0x03cd, 0xf60a, 0x0475, 0xf761,
0x05e2, 0xf922, 0x07d9, 0xf97d, 0x069e, 0xf7d7, 0x035f, 0xf80d, 0x0279, 0xf9b1,
0x0258, 0xfb49, 0x04bf, 0xfcec, 0x0454, 0xfa51, 0x0714, 0xfc80, 0x0662, 0xfadf,
0x0959, 0xfd65, 0x0c54, 0x0140, 0x0c31, 0x03b3, 0x0c03, 0x0490, 0x0b76, 0x011e,
0x08e4, 0xfd53, 0x076a, 0xfc76, 0x0b06, 0x004c, 0x0d79, 0x0434, 0x0b8a, 0x04ba,
0x0920, 0x03a5, 0x0b4e, 0x035a, 0x106a, 0x05d7, 0x125e, 0x07ff, 0x1201, 0x05ce,
0x10da, 0x0525, 0x0cd9, 0x0395, 0x09fd, 0x00d0, 0x0bbc, 0x05fd, 0x0ab0, 0x056c,
0x0dc6, 0x0541, 0x0ddc, 0x0619, 0x0da8, 0x060e, 0x0fa9, 0x061b, 0x1642, 0x0b5b,
0x196b, 0x0e88, 0x0ff3, 0x0610, 0x09f8, 0x0074, 0x0ba1, 0x0541, 0x0f90, 0x09cc,
0x10f9, 0x0806, 0x1522, 0x0c09, 0x1479, 0x0dea, 0x11b0, 0x0d2b, 0x13b6, 0x0cda,
0x1b4c, 0x0fbb, 0x1ef2, 0x1476, 0x1bfe, 0x142e, 0x1629, 0x0f6d, 0x13ba, 0x0fa8,
0x127e, 0x0f2d, 0x1352, 0x114d, 0x1073, 0x0e15, 0x0eef, 0x0b30, 0x107e, 0x0ad5,
0x198e, 0x1217, 0x1d7c, 0x16f9, 0x18e5, 0x1322, 0x128c, 0x0ee5, 0x0f33, 0x0d6d,
0x1201, 0x0f3e, 0x112d, 0x0d67, 0x0fe5, 0x0d33, 0x10cf, 0x0e77, 0x1434, 0x11fe,
0x163f, 0x12fe, 0x1a3e, 0x16a8, 0x1c64, 0x1972, 0x1d33, 0x180f, 0x19a5, 0x1393,
0x1729, 0x12da, 0x189e, 0x151a, 0x1630, 0x10b8, 0x14e9, 0x129b, 0x13cf, 0x161c,
0x13cc, 0x15bb, 0x0ec7, 0x0dac, 0x1334, 0x0fde, 0x19c8, 0x1456, 0x19fd, 0x1469,
0x19ec, 0x160a, 0x16b1, 0x1311, 0x16a8, 0x11ec, 0x107d, 0x0d0e, 0x0ab7, 0x0b0a,
0x07dc, 0x068a, 0x0c15, 0x07af, 0x0d2a, 0x0a87, 0x0dbb, 0x0db8, 0x104d, 0x1120,
0x1271, 0x152c, 0x1091, 0x1386, 0x0d58, 0x0e24, 0x1384, 0x1110, 0x1445, 0x1182,
0x1441, 0x1410, 0x1044, 0x1263, 0x1111, 0x166e, 0x137c, 0x1931, 0x1355, 0x1647,
0x1b3f, 0x1a05, 0x17c7, 0x1218, 0x13ab, 0x1000, 0x0e89, 0x0fab, 0x11ec, 0x141c,
0x15e2, 0x157c, 0x124d, 0x110b, 0x122f, 0x0ed6, 0x0ef3, 0x0ad9, 0x110f, 0x1113,
0x1228, 0x150e, 0x12c0, 0x1475, 0x12bc, 0x1081, 0x1274, 0x0f36, 0x1330, 0x12b8,
0x10be, 0x115d, 0x1112, 0x0f9b, 0x0ee8, 0x0da6, 0x0cf8, 0x0d71, 0x0ac4, 0x0a6e,
0x0ab3, 0x0a2b, 0x0e87, 0x0fb6, 0x1339, 0x152c, 0x152e, 0x1523, 0x12ad, 0x0e2e,
0x138c, 0x0e8d, 0x112f, 0x1209, 0x0f38, 0x1204, 0x0e77, 0x0fed, 0x1260, 0x11f1,
0x11dc, 0x1179, 0x0fc4, 0x11de, 0x105b, 0x12bb, 0x1435, 0x1476, 0x1465, 0x14d2,
0x0b5c, 0x0f2f, 0x05db, 0x094d, 0x0856, 0x05c6, 0x0fa8, 0x0b88, 0x0eae, 0x0fab,
0x0bcc, 0x10d4, 0x0ac9, 0x0e5c, 0x093f, 0x0c77, 0x07a8, 0x0a37, 0x081b, 0x09f2,
0x0aee, 0x0e62, 0x0c7a, 0x10ca, 0x0a3d, 0x0eb2, 0x0a14, 0x0cc9, 0x0ba6, 0x0de2,
0x0b24, 0x0f51, 0x0990, 0x0cd3, 0x07b7, 0x09cf, 0x0b6a, 0x0e99, 0x0b88, 0x1081,
0x08f5, 0x0dbd, 0x05d8, 0x08fd, 0x01a2, 0x066b, 0x0213, 0x090b, 0x0488, 0x0967,
0x054c, 0x07ed, 0x025f, 0x03da, 0x0097, 0x0115, 0x0137, 0x0403, 0x0535, 0x094a,
0x04cf, 0x08fe, 0x02c0, 0x0757, 0x0168, 0x04b9, 0x0297, 0x053b, 0x00dd, 0x068f,
0x0041, 0x06aa, 0xfdcd, 0x016d, 0xff82, 0x0304, 0x0187, 0x0889, 0xfdde, 0x07bd,
0xfd9b, 0x050d, 0xff57, 0x0476, 0xff94, 0x06e0, 0xfb2d, 0x044e, 0xf541, 0xffab,
0xf452, 0xfdfa, 0xf6e6, 0xfea7, 0xfde9, 0x057a, 0x02e8, 0x084f, 0x0006, 0x0398,
0xfab0, 0xffa9, 0xf824, 0x0003, 0xf99e, 0x02eb, 0xf741, 0xffce, 0xfa10, 0x0162,
0xf961, 0xff56, 0xf57b, 0xfb39, 0xf6f5, 0xfc7e, 0xf8fb, 0xfedc, 0xf992, 0x00a9,
0xf78f, 0xfe65, 0xf546, 0xfc0e, 0xf41a, 0xfbd0, 0xf465, 0xfc34, 0xf4b4, 0xfd39,
0xf5a9, 0xfe66, 0xf5f5, 0x0007, 0xf0f4, 0xfbee, 0xee38, 0xf77c, 0xefcc, 0xf60b,
0xf13d, 0xf677, 0xf298, 0xf8c6, 0xf762, 0xfcca, 0xfae1, 0x0116, 0xfd08, 0x04b9,
0xfa70, 0x00ff, 0xf7c9, 0xfbd3, 0xf828, 0xfc74, 0xfc3c, 0x023c, 0xfeb2, 0x0579,
0xfd5a, 0x027a, 0xfa52, 0xfab9, 0xf75a, 0xf66a, 0xf802, 0xfa24, 0xf8c9, 0xfd01,
0xfa57, 0xfe48, 0xfc60, 0xfdc7, 0xfe7d, 0xfe77, 0xfc27, 0xfe15, 0xf9f4, 0xfd79,
0xf955, 0xfdb4, 0xf93b, 0xfeff, 0xf88e, 0xfde0, 0xfa40, 0xfba2, 0xfc02, 0xfacf,
0xfc9d, 0xfcd0, 0x005d, 0x043f, 0x02ec, 0x0754, 0x0575, 0x0571, 0x0261, 0x0023,
0x0268, 0x02f1, 0x02df, 0x04ae, 0x056a, 0x066b, 0x0783, 0x08aa, 0x0312, 0x0420,
0x0508, 0x0540, 0x0376, 0x0379, 0x016f, 0x0297, 0x01a9, 0x019e, 0x0618, 0x037a,
0x099a, 0x05ad, 0x07c4, 0x06a6, 0x04c0, 0x052c, 0x01de, 0x0267, 0x0260, 0x002a,
0x072f, 0x0286, 0x0c73, 0x07d8, 0x0dde, 0x0986, 0x0ba7, 0x091a, 0x0817, 0x0691,
0x05d3, 0x06a2, 0x04d0, 0x05df, 0x0393, 0x03d8, 0x0287, 0x02ca, 0x01fe, 0x0073,
0x040b, 0xffff, 0x0302, 0xffc3, 0xfd5a, 0xfe36, 0xfeea, 0x01f8, 0x0025, 0x009a,
0x00bd, 0xfde1, 0x0099, 0xfdf2, 0x03ef, 0x044e, 0x0694, 0x07b9, 0x0372, 0x038e,
0x05cd, 0x05fd, 0x0596, 0x02d4, 0x04aa, 0xffac, 0x0674, 0x0237, 0x0ac7, 0x07f0,
0x0cf6, 0x0a8a, 0x08f0, 0x0790, 0x0714, 0x084f, 0x02c8, 0x03bd, 0xfda8, 0xfd65,
0xfc06, 0xfdba, 0xfd21, 0xff33, 0xfe9d, 0xfd96, 0x0167, 0xfbe4, 0x01e9, 0xfd6e,
0xfe26, 0xfd39, 0xfa6c, 0xfc16, 0x0024, 0x026b, 0x052d, 0x0426, 0x068c, 0x03a7,
0x05fe, 0x054b, 0x0753, 0x0a6a, 0x0691, 0x0ab5, 0x036b, 0x050f, 0x0317, 0x0198,
0x058a, 0x0294, 0x06ff, 0x0643, 0x03ef, 0x04f9, 0x069a, 0x04e8, 0x06db, 0x01f4,
0x063d, 0x00e2, 0x0539, 0x0200, 0x0013, 0xffa3, 0xfe26, 0xff6c, 0x0142, 0xfec8,
0x02b2, 0xfce0, 0x0452, 0x0024, 0x05da, 0x0554, 0x03b5, 0x04b6, 0xff5b, 0xff9c,
0xff9e, 0xfe1d, 0x03cc, 0x00b8, 0x0965, 0x0821, 0x0967, 0x0824, 0x06a7, 0x0330,
0x05c2, 0x00ff, 0x04d7, 0x0186, 0x06af, 0x05f4, 0x09a6, 0x08d5, 0x07c6, 0x0807,
0x06f4, 0x078d, 0x0351, 0x031a, 0xff34, 0xfd91, 0x00ec, 0xff77, 0x02d6, 0x02fa,
0x01d8, 0x02d8, 0x0013, 0x00b1, 0x0116, 0xfe3c, 0xffca, 0xf9c6, 0x007b, 0xf8c4,
0x0279, 0xfd2f, 0x06c8, 0x0406, 0x08c8, 0x05a5, 0x0bee, 0x0709, 0x0974, 0x03b0,
0x0978, 0x046e, 0x0ec9, 0x0806, 0x0fc4, 0x0880, 0x0c12, 0x085c, 0x0939, 0x05f3,
0x0bfb, 0x0592, 0x0b4c, 0x04d2, 0x0adc, 0x06dc, 0x0c9c, 0x09d8, 0x0dcb, 0x0a70,
0x114c, 0x0d0b, 0x1450, 0x1084, 0x1559, 0x1251, 0x1060, 0x0b3a, 0x100b, 0x08f7,
0x14bb, 0x0f6f, 0x18b3, 0x132f, 0x16cf, 0x0f12, 0x1409, 0x0d1e, 0x1428, 0x10ea,
0x1867, 0x176a, 0x1cb2, 0x1922, 0x1b94, 0x1473, 0x197a, 0x11ee, 0x1938, 0x1398,
0x1a8d, 0x1467, 0x1a11, 0x10e5, 0x19e6, 0x1298, 0x142c, 0x1272, 0x1338, 0x116f,
0x157d, 0x0ff0, 0x191b, 0x11b1, 0x19e5, 0x12b5, 0x1a76, 0x1663, 0x16b9, 0x157c,
0x1408, 0x12f1, 0x167d, 0x1169, 0x18df, 0x1095, 0x1a4c, 0x13a3, 0x16b4, 0x139c,
0x1a4d, 0x17fb, 0x1e8e, 0x1bd4, 0x20bd, 0x1cd1, 0x1dfe, 0x1abf, 0x1ab7, 0x1848,
0x1ab1, 0x1735, 0x182a, 0x14d1, 0x1885, 0x1387, 0x1703, 0x1187, 0x172d, 0x1243,
0x15ef, 0x10cb, 0x165d, 0x1389, 0x1536, 0x1311, 0x1424, 0x0f36, 0x1805, 0x120e,
0x1926, 0x1304, 0x180c, 0x14d9, 0x1546, 0x1524, 0x13cb, 0x1268, 0x12c4, 0x0f69,
0x1194, 0x0eb4, 0x10c9, 0x0fbc, 0x0dea, 0x0dff, 0x0f87, 0x0f63, 0x11b6, 0x1092,
0x12d0, 0x11df, 0x15c8, 0x14e0, 0x149b, 0x14c8, 0x1365, 0x122a, 0x0eb6, 0x0b9d,
0x1263, 0x0d7e, 0x17f2, 0x12f8, 0x1780, 0x15dc, 0x13fe, 0x14c4, 0x145c, 0x1509,
0x163c, 0x15d3, 0x138b, 0x15d7, 0x0fc0, 0x147b, 0x0dce, 0x11e5, 0x0e7e, 0x0f3e,
0x0cc8, 0x0b01, 0x0c09, 0x0b6d, 0x0c88, 0x0c7e, 0x0bda, 0x0a19, 0x0851, 0x07e6,
0x076b, 0x099c, 0x086c, 0x0b5d, 0x089f, 0x0a8e, 0x08fb, 0x0976, 0x0971, 0x0c25,
0x07e1, 0x0c0b, 0x074a, 0x0c69, 0x0767, 0x0c19, 0x0745, 0x0b63, 0x0705, 0x093d,
0x08a6, 0x0949, 0x0961, 0x0b13, 0x092a, 0x0cb7, 0x0786, 0x0a49, 0x06de, 0x0a6d,
0x0af3, 0x0ffc, 0x0e89, 0x1377, 0x12f3, 0x16d6, 0x1108, 0x13d4, 0x0fbc, 0x132c,
0x0b9b, 0x0ef6, 0x0969, 0x0e06, 0x0a20, 0x0e9b, 0x0c36, 0x0f03, 0x0b25, 0x0df5,
0x035e, 0x0791, 0x01fc, 0x0746, 0xfe99, 0x0280, 0xfd05, 0xfed8, 0xfc89, 0xfdc7,
0xfed7, 0xff34, 0xfd03, 0xff2f, 0xf89a, 0xff49, 0xfd86, 0x0480, 0x0018, 0x04d9,
0xfe92, 0x03b9, 0xf9ac, 0xff21, 0xf671, 0xfd5f, 0xf97d, 0x01d3, 0xfef4, 0x0604,
0x00c8, 0x0778, 0x024a, 0x050f, 0x01df, 0x0375, 0x00d9, 0x0519, 0xffa1, 0x0649,
0x00b8, 0x065b, 0x0394, 0x06d8, 0x04c7, 0x0874, 0x02eb, 0x06ab, 0xff15, 0x025d,
0xff5a, 0x03c0, 0xfe39, 0x0508, 0xfd3b, 0x029d, 0xfd70, 0xff2b, 0x0031, 0x00a3,
0xfece, 0x0037, 0xfa68, 0xfe6c, 0xf93b, 0xfd5c, 0xfb9a, 0xfff0, 0xfad5, 0x0286,
0xf780, 0xfffe, 0xf8f3, 0xfe86, 0xfbd0, 0xfded, 0xfc80, 0x0086, 0xf9b0, 0xffff,
0xf79a, 0xfcf8, 0xf66d, 0xfa67, 0xf52a, 0xfa0e, 0xf26e, 0xfa01, 0xf488, 0xfb0d,
0xf7b4, 0xfbfd, 0xf8a1, 0xfc8a, 0xf299, 0xf7f0, 0xf0b2, 0xf975, 0xf4ce, 0xff33,
0xf577, 0xfea5, 0xf43f, 0xfd5d, 0xf4b5, 0xfb44, 0xf5c9, 0xf8ec, 0xf33a, 0xf5c0,
0xf0d6, 0xf537, 0xeed8, 0xf5a7, 0xedd1, 0xf56d, 0xf2af, 0xf9a6, 0xf444, 0xfb7e,
0xedec, 0xf538, 0xeb48, 0xf02a, 0xe981, 0xed98, 0xe8d0, 0xf0e2, 0xe8c7, 0xf2cb,
0xea51, 0xf2e0, 0xebe4, 0xf342, 0xeb14, 0xf1f9, 0xee2d, 0xf520, 0xefec, 0xf6a4,
0xf0e7, 0xf806, 0xf09e, 0xf6a0, 0xf118, 0xf5cd, 0xef06, 0xf488, 0xec46, 0xf53e,
0xf03d, 0xfa5c, 0xf0fc, 0xf9e5, 0xef59, 0xf5d4, 0xed21, 0xf068, 0xed11, 0xf1bf,
0xec62, 0xf319, 0xea6f, 0xf33b, 0xedc4, 0xf6f0, 0xef19, 0xf424, 0xf077, 0xf374,
0xf08b, 0xf765, 0xef6e, 0xf83a, 0xed16, 0xf4cf, 0xeb71, 0xf3f1, 0xee9f, 0xf77c,
0xf001, 0xf5cc, 0xeebc, 0xf082, 0xea11, 0xed21, 0xeb68, 0xf086, 0xeb3e, 0xf18a,
0xeb7e, 0xf2a8, 0xeada, 0xf029, 0xeb85, 0xf176, 0xec51, 0xf5ab, 0xeaa1, 0xf347,
0xe945, 0xee49, 0xe7ef, 0xea86, 0xe8f9, 0xebbb, 0xe669, 0xea2c, 0xe8c3, 0xeda0,
0xeb45, 0xf0c1, 0xed46, 0xf1e1, 0xea2c, 0xf042, 0xe884, 0xf157, 0xe7c5, 0xf044,
0xe7a8, 0xebb8, 0xe6ce, 0xe77b, 0xe870, 0xe89e, 0xe995, 0xe939, 0xeb98, 0xec2d,
0xe873, 0xe9ea, 0xe100, 0xe572, 0xe044, 0xe5ef, 0xe51e, 0xe8b7, 0xe958, 0xecbb,
0xebb9, 0xeec4, 0xec9b, 0xedf1, 0xec70, 0xecc6, 0xed4c, 0xecf5, 0xeab3, 0xeb44,
0xea79, 0xed24, 0xeb55, 0xed9b, 0xee1a, 0xef9c, 0xedea, 0xef7a, 0xece2, 0xedd3,
0xec4a, 0xec34, 0xf225, 0xf1b6, 0xefbc, 0xf172, 0xecd2, 0xf1f5, 0xed51, 0xf2e8,
0xed32, 0xf15a, 0xece0, 0xee98, 0xecca, 0xecf6, 0xeede, 0xed40, 0xf0e0, 0xed9c,
0xeebc, 0xee4f, 0xe81f, 0xed4a, 0xe91f, 0xeefd, 0xed14, 0xeea4, 0xef03, 0xedf7,
0xedbd, 0xed37, 0xe9c7, 0xeb40, 0xeb09, 0xeaff, 0xed6e, 0xed21, 0xef0c, 0xefb0,
0xec65, 0xed88, 0xeb2b, 0xecdf, 0xefac, 0xf0dd, 0xf206, 0xf093, 0xf228, 0xef03,
0xf037, 0xef73, 0xf052, 0xf24a, 0xf254, 0xf498, 0xf4b6, 0xf518, 0xf732, 0xf50a,
0xf63b, 0xf057, 0xf526, 0xef1d, 0xf5a8, 0xf278, 0xf596, 0xf504, 0xf35f, 0xf304,
0xf312, 0xf1bf, 0xf239, 0xf13f, 0xf0af, 0xefac, 0xf171, 0xefae, 0xf3d8, 0xef78,
0xf60b, 0xeeb3, 0xf4a7, 0xec9c, 0xf4ee, 0xee2e, 0xf67e, 0xf010, 0xf32f, 0xedb2,
0xf17c, 0xeda4, 0xf3c3, 0xf036, 0xf721, 0xf3ca, 0xf6ef, 0xf1cc, 0xf465, 0xeced,
0xf26e, 0xeed7, 0xf2f0, 0xf162, 0xf483, 0xef98, 0xf56b, 0xecbd, 0xf673, 0xeffc,
0xf430, 0xf20e, 0xf60f, 0xf413, 0xf9d0, 0xf6c5, 0xff63, 0xfb2d, 0xfb25, 0xf700,
0xf5e3, 0xef87, 0xf7fb, 0xee6c, 0xf951, 0xef80, 0xfb66, 0xf2a5, 0xfcb7, 0xf5e4,
0xfb0a, 0xf660, 0xf9b4, 0xf4b7, 0xfa11, 0xf387, 0xf8a6, 0xf1b8, 0xfcc5, 0xf4da,
0xfe51, 0xf69d, 0xfd18, 0xf79d, 0xf8b2, 0xf40c, 0xfb8b, 0xf571, 0xfcdc, 0xf693,
0xf82b, 0xf2fe, 0xf4a6, 0xeeb2, 0xf635, 0xf062, 0xf931, 0xf30b, 0xf81c, 0xf130,
0xf97d, 0xf3e9, 0xfb63, 0xf6a0, 0xfd9f, 0xf8be, 0xfc1f, 0xf4fb, 0xfbe9, 0xf2ec,
0xfbeb, 0xf2ce, 0xff3e, 0xf5f2, 0x01a6, 0xf79e, 0x041c, 0xfa93, 0x0911, 0x003a,
0x04cd, 0xfe25, 0x03e4, 0xfecd, 0x0683, 0xff0f, 0x06ef, 0xff75, 0x064c, 0xffd5,
0x0680, 0xfd74, 0x0851, 0xfd87, 0x0308, 0xf91d, 0xff76, 0xf74c, 0x020e, 0xf9b4,
0x07d5, 0xfe0a, 0x0767, 0xfd00, 0x03a4, 0xfb20, 0x0293, 0xfae9, 0x0305, 0xfb10,
0x05cd, 0xfdcd, 0x063a, 0xfd25, 0x0486, 0xfafa, 0x04f1, 0xf867, 0x074a, 0xfcc9,
0x06a7, 0x0101, 0x07cd, 0x0118, 0x076e, 0xfe58, 0x0729, 0xff03, 0x07dc, 0xff9f,
0x0bf4, 0x013e, 0x0e3d, 0x018d, 0x0d0a, 0x0041, 0x0dca, 0x03ce, 0x0d97, 0x05a9,
0x0c4d, 0x0601, 0x0bc1, 0x0469, 0x0a66, 0x028b, 0x08d6, 0x0207, 0x0833, 0x01a8,
0x0b93, 0x0590, 0x0bcb, 0x05d1, 0x09f6, 0x03d7, 0x0866, 0x0155, 0x0ad0, 0x02ca,
0x0c46, 0x0518, 0x09b5, 0x0385, 0x0af7, 0x0585, 0x09be, 0x045b, 0x0b30, 0x067c,
0x0a7c, 0x06c4, 0x08ac, 0x04d1, 0x079c, 0x0346, 0x089d, 0x03e7, 0x09c2, 0x041b,
0x08f3, 0x02fc, 0x0917, 0x01df, 0x0727, 0xffe8, 0x065e, 0x02d2, 0x0656, 0x0544,
0x0930, 0x073b, 0x09a3, 0x0600, 0x09d7, 0x05a4, 0x0a6d, 0x0621, 0x0b6e, 0x06fd,
0x09ce, 0x03e2, 0x08d9, 0x0207, 0x0ae1, 0x04ad, 0x0ae9, 0x0668, 0x0b1e, 0x08ea,
0x0b70, 0x0bc2, 0x0b8a, 0x0be9, 0x064c, 0x06b9, 0x050d, 0x045a, 0x0a51, 0x0604,
0x0d82, 0x0882, 0x0d0c, 0x0a7f, 0x0a25, 0x0a44, 0x079c, 0x0825, 0x087b, 0x09a0,
0x0894, 0x0be1, 0x0b8b, 0x0e1c, 0x0822, 0x0a3c, 0x0850, 0x0ac6, 0x0900, 0x0a85,
0x07d5, 0x0b29, 0x0717, 0x0a74, 0x0949, 0x0b10, 0x0c40, 0x0daa, 0x0a6f, 0x0c12,
0x0687, 0x0927, 0x0624, 0x0b26, 0x09b7, 0x11df, 0x0887, 0x0e7d, 0x0786, 0x0a3b,
0x069c, 0x09ff, 0x0782, 0x0c1a, 0x06d1, 0x0b9d, 0x07b6, 0x0b02, 0x0859, 0x097f,
0x06e2, 0x074b, 0x074f, 0x090c, 0x05dc, 0x0a60, 0x0374, 0x09ba, 0x0275, 0x077f,
0x01e7, 0x0517, 0x0103, 0x0412, 0x037d, 0x06ad, 0x052e, 0x0640, 0x0492, 0x0307,
0x0363, 0x037f, 0x0364, 0x06ed, 0x06d8, 0x0b72, 0x08e4, 0x0ccb, 0x0415, 0x0906,
0xfea5, 0x04bb, 0xfd36, 0x02ba, 0xfdad, 0x01a7, 0x00ee, 0x03cf, 0x0067, 0x0342,
0xffb8, 0x01fe, 0x038c, 0x03ff, 0x0699, 0x0462, 0x0549, 0x02eb, 0x01da, 0x015b,
0x009c, 0x0311, 0x0380, 0x07b3, 0x0497, 0x08c2, 0x012e, 0x0486, 0xfec9, 0x025e,
0xfea4, 0x0205, 0x0028, 0x0161, 0x04b4, 0x04a4, 0x07bc, 0x055d, 0x0684, 0x0392,
0x0462, 0x04f0, 0x0196, 0x057c, 0x00cb, 0x0350, 0x005c, 0xffe5, 0x03ba, 0x03e7,
0x0252, 0x053b, 0xff24, 0x044e, 0xfdf2, 0x0149, 0xffa5, 0xfdce, 0xfea1, 0xfb42,
0xfb05, 0xf96c, 0xfbf8, 0xfc14, 0xfeb2, 0x0106, 0x00a4, 0x0546, 0x00f1, 0x0452,
0x01e3, 0x0413, 0x0345, 0x0676, 0x032f, 0x04ac, 0xff85, 0xfea7, 0xfdd2, 0xfd05,
0xffd0, 0x0121, 0x0670, 0x0847, 0x05e0, 0x06f3, 0x014f, 0x0251, 0xfd59, 0xff81,
0xf9b2, 0xfcbf, 0xfa8a, 0xfe37, 0xfe08, 0x0061, 0x0102, 0x014a, 0x0326, 0x0132,
0x0247, 0xff4a, 0x013a, 0xfef5, 0xff43, 0xfe29, 0x0001, 0x0221, 0x01c1, 0x04c4,
0xff32, 0x0199, 0x01d0, 0x02fd, 0x0411, 0x0428, 0x03fe, 0x063d, 0x010a, 0x058d,
0x0050, 0x058e, 0x009a, 0x0362, 0xfd7a, 0xfcdb, 0x0147, 0x0167, 0x0478, 0x07a7,
0x0629, 0x0a1a, 0x0227, 0x04f3, 0x00f1, 0x03bc, 0xfeb8, 0x02a2, 0xf976, 0xfe44,
0xfa82, 0xfdcb, 0xf9ed, 0xfb94, 0xfcac, 0xff3f, 0xfe81, 0x0190, 0xfe8e, 0x03eb,
0xfa8b, 0xff2a, 0xf6c8, 0xf789, 0xf750, 0xf85d, 0xf882, 0xfd57, 0xfbb6, 0x02b4,
0xfe5d, 0x0476, 0xfd21, 0x0195, 0xfa68, 0xff75, 0xf941, 0xfd92, 0xfa93, 0xfce5,
0xfd95, 0x003a, 0xff0d, 0x0223, 0xff68, 0x0284, 0xff80, 0x0189, 0x008d, 0x01b5,
0xffa7, 0x0411, 0xfd37, 0x05b4, 0xfa22, 0x0283, 0xfa04, 0xfefa, 0xfbbc, 0xfe3d,
0xfd34, 0x00f5, 0xfe43, 0x0389, 0xfe0e, 0x031a, 0xf920, 0xfda5, 0xf782, 0xfc64,
0xf88d, 0xfecb, 0xfb82, 0xff21, 0xfe75, 0xff7a, 0xfd0c, 0xff80, 0xfa7e, 0xfd94,
0xfb10, 0xfe0a, 0xfa2c, 0xfc10, 0xf926, 0xf981, 0xfa92, 0xfb78, 0xfcbf, 0x0002,
0xfd32, 0x02b5, 0xfafe, 0x00c4, 0xfc3a, 0x02c6, 0xfbcf, 0x02c5, 0xfbd1, 0x00ef,
0xfbf9, 0xff68, 0xfdd7, 0x004a, 0xff91, 0x01fb, 0xfffe, 0x00a7, 0xff70, 0xfeeb,
0xfcf3, 0xff8f, 0xfce0, 0x011f, 0xfc84, 0xffd8, 0xff7c, 0x01c6, 0x01a3, 0x0311,
0x02a5, 0x0471, 0x0153, 0x016e, 0xfef2, 0xfede, 0x008b, 0x0208, 0x0426, 0x05fb,
0x0488, 0x057d, 0x030e, 0x0286, 0x0074, 0x0217, 0xfe48, 0x00eb, 0xfec0, 0xfe3c,
0xfdf6, 0xfb05, 0xfb1e, 0xf9f6, 0xfca5, 0xfc7a, 0xfe93, 0xfdaa, 0x0262, 0xfefe,
0x05d6, 0xff62, 0x095a, 0x03ba, 0x0680, 0x04cd, 0xfea7, 0xfeb4, 0xfe7c, 0xfc5c,
0x02ba, 0x00a6, 0x0712, 0x067f, 0x07b5, 0x0797, 0x0588, 0x04f6, 0x02ea, 0x02aa,
0x03df, 0x01bd, 0x0448, 0xffac, 0x0400, 0x0050, 0x0280, 0x013f, 0x00c7, 0xfe65,
0x017d, 0xfbc1, 0x0358, 0xfc8e, 0x04a9, 0xfe25, 0x0366, 0xff78, 0x0625, 0x028b,
0x089d, 0x039e, 0x0652, 0x020f, 0x0711, 0x045f, 0x0719, 0x0368, 0x058e, 0x002f,
0x00b1, 0xfcb3, 0x00f4, 0xff57, 0x0248, 0x0179, 0x0211, 0x0058, 0x018e, 0xfd93,
0x02e7, 0xfdb0, 0x0690, 0x029e, 0x0a75, 0x0761, 0x08a6, 0x0538, 0x0292, 0xff64,
0xffb0, 0xfcde, 0x0259, 0xfef2, 0x06bf, 0x0447, 0x09f2, 0x079a, 0x0bcd, 0x07dc,
0x086a, 0x03cc, 0x078e, 0x035f, 0x0968, 0x068f, 0x09d0, 0x0792, 0x09cb, 0x075d,
0x0aa6, 0x07ef, 0x099e, 0x05eb, 0x076b, 0x035b, 0x05de, 0x026d, 0x0344, 0x003a,
0x0456, 0x03b1, 0x04cc, 0x05ad, 0x04c0, 0x05a5, 0x01bc, 0x0018, 0x02ce, 0xfd5f,
0x0510, 0xfdc9, 0x0438, 0xfebd, 0x05f9, 0x0373, 0x04d2, 0x02d4, 0x0473, 0x02e0,
0x05d4, 0x0464, 0x084e, 0x05c1, 0x0693, 0x03f3, 0x0476, 0x029a, 0x0597, 0x0176,
0x062f, 0x02bc, 0x0683, 0x0577, 0x08d7, 0x08e2, 0x0938, 0x09c8, 0x05e0, 0x04e0,
0x03b0, 0xffa3, 0x049e, 0xfe7a, 0x03fd, 0xffa3, 0x03bf, 0x0401, 0x0731, 0x08e1,
0x074f, 0x066e, 0x06e7, 0x014f, 0x07ab, 0xff2b, 0x077c, 0x0057, 0x0661, 0x0103,
0x05e2, 0x01ee, 0x068f, 0x03e3, 0x0488, 0x0277, 0x047c, 0x0112, 0x0626, 0x01ae,
0x0663, 0x019e, 0x06a7, 0x025f, 0x0806, 0x0405, 0x0b22, 0x0835, 0x0d41, 0x0bd2,
0x0d70, 0x0d1c, 0x0b39, 0x0b99, 0x0a75, 0x0932, 0x0b80, 0x088d, 0x0c27, 0x099f,
0x0afc, 0x0833, 0x0b6d, 0x08f9, 0x0a1b, 0x0a18, 0x07a7, 0x0664, 0x05dc, 0x01d0,
0x02c2, 0xfedc, 0x025b, 0x011d, 0x030e, 0x024f, 0x0203, 0x0065, 0x02a0, 0x0226,
0x05fe, 0x0703, 0x04ce, 0x0705, 0x025c, 0x03b3, 0x0336, 0x0152, 0x0526, 0x03b6,
0x08fe, 0x0931, 0x07dc, 0x06d4, 0x07a8, 0x0547, 0x05cb, 0x04c8, 0x0806, 0x08bf,
0x0937, 0x0997, 0x0840, 0x080a, 0x064c, 0x06cc, 0x064f, 0x075c, 0x0978, 0x083e,
0x0a5e, 0x09ac, 0x099e, 0x0a03, 0x0795, 0x0715, 0x08a5, 0x0923, 0x09f6, 0x0c35,
0x0a11, 0x0c9a, 0x06fd, 0x0a6d, 0x078f, 0x0c94, 0x06be, 0x09ed, 0x051c, 0x0516,
0x03b2, 0x0354, 0x02d8, 0x0639, 0x05df, 0x09c9, 0x06da, 0x071e, 0x06e8, 0x05e1,
0x05dc, 0x06c7, 0x06e0, 0x0941, 0x072c, 0x0a02, 0x0537, 0x0a13, 0x01e4, 0x0801,
0x0025, 0x035e, 0x0056, 0x0065, 0x01af, 0x00fd, 0x04ee, 0x07c4, 0x0690, 0x0e67,
0x0775, 0x0dca, 0x05bb, 0x082e, 0x0579, 0x079e, 0x07ad, 0x0bae, 0x0726, 0x0bfc,
0x07f8, 0x0c13, 0x09d2, 0x0cdb, 0x082f, 0x09bf, 0x045e, 0x0538, 0x030a, 0x03ce,
0x04b7, 0x0666, 0x058d, 0x0ad4, 0x0463, 0x0c63, 0x03b2, 0x09c7, 0x048d, 0x0879,
0xff26, 0x020e, 0xfabf, 0xfc09, 0xfbc2, 0xfd5b, 0xff8e, 0x02fa, 0x0295, 0x038a,
0x021c, 0x0025, 0x00c1, 0xff81, 0x00ba, 0x01ca, 0x021d, 0x05b6, 0x04c4, 0x0818,
0x061e, 0x0977, 0x06cf, 0x0ab2, 0x06b5, 0x098d, 0x06fc, 0x08ad, 0x077f, 0x08bc,
0x0426, 0x078c, 0x0151, 0x07dc, 0xfeb8, 0x03cc, 0xff20, 0x0263, 0x008b, 0x043f,
0xfe01, 0x008a, 0xfce9, 0xfdff, 0xfdb9, 0xffde, 0xfe72, 0x0113, 0xfea7, 0xfee4,
0xfb1b, 0xf9d1, 0xfa8b, 0xfaac, 0xfcdc, 0xffdd, 0xfe50, 0x02a4, 0xfdee, 0x0122,
0xfb7f, 0xfe13, 0xf83d, 0xfc41, 0xf64a, 0xfac4, 0xf98d, 0xfc2e, 0xfbfc, 0xfe4b,
0xfc27, 0xffdc, 0xfce8, 0xfef9, 0xfc56, 0xfb01, 0xfa47, 0xfa94, 0xfabf, 0xfd82,
0xfcfd, 0x00fe, 0xfef0, 0x0300, 0xffae, 0x03ad, 0xff4d, 0x03e1, 0xfd68, 0x01f9,
0xfe67, 0x0595, 0xfd5f, 0x043b, 0xfaef, 0xfe93, 0xf9b1, 0xfd57, 0xfebc, 0x0227,
0x0146, 0x03ec, 0xfee6, 0x0292, 0xfb47, 0x00ac, 0xf734, 0xff43, 0xf676, 0xffb7,
0xf935, 0xfed9, 0xf85f, 0xfa90, 0xf776, 0xfa5e, 0xf6bb, 0xfa4e, 0xf62d, 0xfa50,
0xf3db, 0xf786, 0xf22f, 0xf658, 0xf37f, 0xf89f, 0xf701, 0xfc13, 0xf8ad, 0xfc47,
0xf88f, 0xfb8b, 0xf8f6, 0x0065, 0xf974, 0x03df, 0xfa4d, 0x01d0, 0xfb16, 0x00c9,
0xf9cf, 0xffa4, 0xfabf, 0x012d, 0xfefa, 0x0532, 0x01c1, 0x0591, 0xff2e, 0x033e,
0xf924, 0xff1c, 0xf6f4, 0x004a, 0xf679, 0xfe34, 0xf76b, 0xfb9c, 0xf7a9, 0xfbb0,
0xf909, 0xfccf, 0xf922, 0xfb29, 0xf87e, 0xfa20, 0xf434, 0xf908, 0xf33b, 0xf9a7,
0xf4aa, 0xfa7b, 0xf4bf, 0xfab4, 0xf573, 0xfb8e, 0xf2f4, 0xf7b3, 0xf263, 0xf57a,
0xf278, 0xf43f, 0xf4c3, 0xf95d, 0xf4d4, 0xfba2, 0xf42b, 0xf8fa, 0xf537, 0xf8ed,
0xf530, 0xfb55, 0xf5c0, 0xfecf, 0xf94f, 0x00c6, 0xf99e, 0xfd28, 0xf9e0, 0xfc13,
0xf8b4, 0xfd45, 0xf91c, 0xfe67, 0xf85a, 0xfc63, 0xfac0, 0xfe12, 0xff74, 0x03a9,
0xff20, 0x0358, 0xfce6, 0xffa2, 0xf730, 0xfa82, 0xf519, 0xf9eb, 0xf2ec, 0xf804,
0xf707, 0xfb6c, 0xfaab, 0xfec1, 0xf679, 0xfa0f, 0xf351, 0xf746, 0xf250, 0xf5fc,
0xf4b8, 0xf5a9, 0xf54d, 0xf4db, 0xf443, 0xf5c2, 0xf54f, 0xf9cb, 0xf1bd, 0xf767,
0xef76, 0xf1fe, 0xefc4, 0xf188, 0xf25f, 0xf697, 0xf39a, 0xf78f, 0xf196, 0xf24b,
0xf391, 0xf3b4, 0xfaa4, 0xfd87, 0xfdb9, 0x0093, 0xf87f, 0xf9cb, 0xf7c0, 0xfa41,
0xfa03, 0xff00, 0xf92e, 0xfd04, 0xf871, 0xf908, 0xf907, 0xf8bb, 0xf6d9, 0xf87e,
0xefd7, 0xf0d4, 0xe82a, 0xe829, 0xee51, 0xef53, 0xea63, 0xebc1, 0xead5, 0xed77,
0xe9c1, 0xeae5, 0xdff3, 0xdd14, 0xe93f, 0xe506, 0xe2d8, 0xdf4f, 0xe2e0, 0xe33b,
0xda2c, 0xd79a, 0xded8, 0xd8cd, 0xda06, 0xd370, 0xe2ae, 0xe067, 0xdfe6, 0xdd57,
0xdf14, 0xdaca, 0xdb0f, 0xd4dd, 0xe0de, 0xdac6, 0xdf97, 0xd95d, 0xe24d, 0xdd5f,
0xdcd8, 0xd965, 0xde00, 0xdab9, 0xd8ab, 0xd1e1, 0xd5b3, 0xcb6f, 0xd3b1, 0xca07,
0xd7ad, 0xd166, 0xdcbb, 0xd836, 0xda3a, 0xd47b, 0xd54d, 0xcd58, 0xd02c, 0xc6de,
0xcea9, 0xc2a3, 0xcf68, 0xc2a3, 0xd583, 0xca98, 0xd5a1, 0xcbe4, 0xd728, 0xccc2,
0xd964, 0xce18, 0xd6dd, 0xcdfc, 0xd294, 0xca41, 0xce2e, 0xc3fc, 0xd0cc, 0xc3d1,
0xd732, 0xc9c0, 0xd8b6, 0xcb5e, 0xd4f5, 0xc85b, 0xd311, 0xc862, 0xd35f, 0xc85c,
0xd734, 0xc97c, 0xd7ea, 0xc906, 0xd5c9, 0xca49, 0xd87f, 0xce19, 0xd896, 0xcd1b,
0xd95f, 0xcd27, 0xd31a, 0xc5f0, 0xceb9, 0xc12f, 0xdbac, 0xce79, 0xe422, 0xd6cb,
0xd8e5, 0xc9a8, 0xcd57, 0xbcdb, 0xce28, 0xbfd6, 0xd94f, 0xcdf8, 0xdc07, 0xd194,
0xd32a, 0xc683, 0xd1de, 0xc335, 0xd63d, 0xc618, 0xe51d, 0xd6eb, 0xfb69, 0xf189,
0xfca6, 0xf290, 0xfab1, 0xf05e, 0xfbe2, 0xf29b, 0xfc04, 0xf369, 0xf912, 0xf05a,
0xf521, 0xece2, 0xf1f5, 0xe995, 0xeeac, 0xe712, 0xedec, 0xe630, 0xef64, 0xe5a0,
0xf3ab, 0xe9f3, 0xf7de, 0xee38, 0xf55b, 0xeb2b, 0xefc5, 0xe422, 0xf00d, 0xe40c,
0xf109, 0xe5af, 0xf0c5, 0xe6b6, 0xf35f, 0xeb49, 0xf463, 0xea92, 0xeb51, 0xdd38,
0xe9d0, 0xdc10, 0xf9a4, 0xf161, 0x0373, 0xfe19, 0xfde5, 0xf670, 0xf68e, 0xeb3d,
0xf2f6, 0xe690, 0xf479, 0xec75, 0xf7fc, 0xf261, 0xf6fa, 0xecd6, 0xfa74, 0xeecd,
0xfaa4, 0xf112, 0xf1d4, 0xe9fd, 0xef62, 0xe815, 0xf4c6, 0xedc5, 0xf990, 0xf26a,
0xf605, 0xec2a, 0xefda, 0xe516, 0xf251, 0xe805, 0xf3c7, 0xeaef, 0xf254, 0xea24,
0xf5bf, 0xee4c, 0xf4d1, 0xeb4c, 0xf6be, 0xeb0e, 0xfcd2, 0xf26c, 0xf51a, 0xe999,
0xf1f4, 0xe731, 0xfa21, 0xf147, 0xf888, 0xede7, 0xf54b, 0xe820, 0xf491, 0xe6a6,
0xf376, 0xe714, 0xf6ad, 0xed7f, 0xf76f, 0xef28, 0xf7ab, 0xed23, 0xf6ca, 0xeaa2,
0xf44d, 0xe74a, 0xf82a, 0xeaf0, 0xf76c, 0xe982, 0xf79b, 0xe9e6, 0xff00, 0xf3be,
0xfed3, 0xf40d, 0xf607, 0xe962, 0xf2de, 0xe63a, 0xf4ce, 0xe918, 0xfd5b, 0xf2f7,
0x0568, 0xfa5b, 0x009c, 0xf2cf, 0xf777, 0xe972, 0xf836, 0xea99, 0xf617, 0xe968,
0xf252, 0xe7ee, 0xfa41, 0xf054, 0x0062, 0xf4b5, 0x044a, 0xf639, 0x044a, 0xf514,
0x04a6, 0xf4b2, 0x0041, 0xf208, 0xfd41, 0xf25f, 0xfb4a, 0xf0a9, 0xfc5b, 0xf003,
0xffad, 0xf039, 0xfee2, 0xee5c, 0xfb77, 0xecb0, 0xf979, 0xee4b, 0xfe07, 0xf416,
0x00e7, 0xf3e3, 0xffc8, 0xf162, 0xff53, 0xf2d2, 0xff9f, 0xf463, 0xfdac, 0xf1a6,
0xfb41, 0xefc9, 0xff97, 0xf6cc, 0x0485, 0xfcea, 0x01cc, 0xf7f2, 0x0126, 0xf555,
0x039a, 0xf972, 0x044d, 0xfb12, 0x059a, 0xf9fc, 0x09a0, 0xfd46, 0x0add, 0x01b4,
0x09f0, 0x02b4, 0x06a5, 0xff6a, 0x062e, 0xfef1, 0x016d, 0xf9e3, 0xfd6f, 0xf547,
0xff3d, 0xf687, 0xff4e, 0xf6c6, 0x01b5, 0xf9ce, 0x0791, 0x0058, 0x0844, 0xff15,
0x0402, 0xfa74, 0x014f, 0xfb48, 0x01bb, 0xff52, 0x075a, 0x0422, 0x0984, 0x0408,
0x098c, 0x0415, 0x06b5, 0x023a, 0x05a0, 0x0281, 0x0a3f, 0x07a5, 0x0bc3, 0x092c,
0x0bf8, 0x0916, 0x0ddd, 0x0d99, 0x0cd5, 0x0ed8, 0x09cc, 0x0a8c, 0x0544, 0x0448,
0x05d0, 0x0497, 0x0d29, 0x0dea, 0x0f05, 0x1149, 0x0abc, 0x0db7, 0x08e2, 0x09ea,
0x08e3, 0x0800, 0x07a8, 0x0909, 0x0798, 0x0a72, 0x0729, 0x0a2c, 0x083b, 0x0ad8,
0x0c03, 0x0f42, 0x0e29, 0x12a9, 0x0e87, 0x132b, 0x0bb6, 0x0f1f, 0x09a2, 0x0c8d,
0x0c03, 0x1003, 0x0ede, 0x12de, 0x0c75, 0x0fd2, 0x06f1, 0x0b37, 0x06f2, 0x0ba3,
0x0b08, 0x109e, 0x09d4, 0x1271, 0x0801, 0x11c3, 0x0d20, 0x16bf, 0x0930, 0x11ea,
0x05cb, 0x0cb5, 0x0c0d, 0x114a, 0x0eb0, 0x14dc, 0x0d54, 0x14f2, 0x0aac, 0x1220,
0x0b22, 0x12b0, 0x10aa, 0x1a02, 0x136a, 0x1f1d, 0x0fd1, 0x1bf7, 0x0cbc, 0x1704,
0x0cb1, 0x1643, 0x0ba2, 0x1517, 0x0a83, 0x1358, 0x0cd8, 0x185f, 0x1267, 0x1e78,
0x10d9, 0x1b1c, 0x08f7, 0x1221, 0x06bb, 0x101b, 0x05f6, 0x0fdc, 0x0a00, 0x144e,
0x0c17, 0x17d8, 0x088a, 0x133e, 0x03bb, 0x0c75, 0x02ab, 0x0add, 0x06af, 0x0ecc,
0x0a46, 0x143a, 0x0966, 0x1462, 0x066d, 0x1103, 0x0a5f, 0x13fe, 0x0e2e, 0x1598,
0x0cb5, 0x1394, 0x056d, 0x0ebb, 0x01fb, 0x0e03, 0x06eb, 0x1392, 0x0d1f, 0x1912,
0x0d1e, 0x1809, 0x096f, 0x1259, 0x087f, 0x104b, 0x065f, 0x0e83, 0x073b, 0x103e,
0x0b5d, 0x14da, 0x0ae1, 0x123f, 0x085a, 0x0f02, 0x0858, 0x0ef8, 0x0727, 0x0dee,
0x0568, 0x0c3f, 0x084a, 0x0f51, 0x09e1, 0x104f, 0x0590, 0x08ef, 0x04f2, 0x0675,
0x0871, 0x0b6a, 0x05d0, 0x0a64, 0x00ba, 0x0609, 0x0019, 0x05f1, 0x03cf, 0x093c,
0x061b, 0x0b54, 0x0449, 0x0954, 0x0269, 0x07c0, 0xfeec, 0x035e, 0x014e, 0x047c,
0x0578, 0x07af, 0x0053, 0x01ec, 0x010f, 0x041a, 0x040c, 0x093b, 0x01a9, 0x0739,
0x01ff, 0x0714, 0x04cf, 0x097f, 0x0094, 0x050a, 0x001b, 0x0406, 0x01b4, 0x03e1,
0xff5c, 0x0098, 0xfe40, 0x0053, 0xfdf0, 0xfdcb, 0x01c7, 0x0100, 0x0324, 0x058f,
0x05fd, 0x09bc, 0x07e0, 0x0bc9, 0x0301, 0x073e, 0x0100, 0x03e3, 0x02df, 0x01f3,
0x00b3, 0xfd9b, 0x0100, 0x00ee, 0x01fc, 0x0481, 0xfc5b, 0x004a, 0xfaeb, 0xfec2,
0xfc50, 0xfe13, 0x0108, 0x024c, 0xffb0, 0x01c4, 0xf9d4, 0xfd11, 0xfb5a, 0xff58,
0xfb31, 0xffab, 0xfd0d, 0x007c, 0x0046, 0x0251, 0xffbb, 0x0122, 0xfbfc, 0xfcbd,
0xfe54, 0xffe5, 0x0303, 0x0729, 0x03cf, 0x072d, 0xfaa7, 0xfa34, 0xfaa8, 0xfaf7,
0x0480, 0x0878, 0xff8d, 0x060b, 0xfa80, 0x0122, 0xf9a0, 0xfe47, 0xf8f7, 0xfb88,
0xfb27, 0xfdcb, 0xf971, 0xfd95, 0xf393, 0xf880, 0xfd73, 0x02fa, 0x254c, 0x2d50,
0x31ed, 0x39d9, 0x143e, 0x1a6e, 0x092b, 0x1027, 0x0eff, 0x169d, 0x0662, 0x0cde,
0x06fd, 0x0e75, 0x0d04, 0x14ef, 0x0c89, 0x11eb, 0x0a0a, 0x0e92, 0x091e, 0x0f5a,
0x080c, 0x0f54, 0x0885, 0x1027, 0x0744, 0x0ead, 0xff30, 0x05da, 0xfdf7, 0x0441,
0x0397, 0x0a2f, 0x0347, 0x08f6, 0xfe65, 0x017d, 0xfb32, 0xfdb5, 0xfe52, 0x008e,
0xfead, 0x011f, 0xfdb4, 0x02b5, 0xfdff, 0x028a, 0xfc81, 0xfeef, 0xfdb2, 0x0167,
0xfece, 0x0378, 0xff26, 0x0362, 0xfd4a, 0x00bc, 0xfb7b, 0xfe9c, 0xf7a0, 0xfa8b,
0xfa71, 0xfc20, 0x004b, 0xffe0, 0x007c, 0x0025, 0xfbe8, 0xff1e, 0xf996, 0xffc1,
0xf8e9, 0xfdc9, 0xfb1c, 0xfcc3, 0xfe20, 0xfd76, 0xfe99, 0xfd79, 0xfed9, 0xff2b,
0xfdad, 0xff27, 0xf919, 0xfaf7, 0xf776, 0xf824, 0xf5c6, 0xf5fb, 0xf4e0, 0xf3df,
0xf31a, 0xefc9, 0xf37b, 0xf044, 0xf832, 0xf6a5, 0xf7e8, 0xf81c, 0xf7d7, 0xf7da,
0xf33a, 0xf106, 0xf2db, 0xefce, 0xf450, 0xf200, 0xfa1e, 0xf748, 0xfabc, 0xf743,
0xfb9a, 0xf799, 0xfc1a, 0xf801, 0xfcd9, 0xfa85, 0xf884, 0xf721, 0xf85d, 0xf8bd,
0xfc70, 0xfca3, 0xff67, 0xfdc0, 0x009b, 0xfe55, 0xf90a, 0xf648, 0xf721, 0xf5ce,
0xf9af, 0xfa3c, 0xfa17, 0xf8a2, 0xfa92, 0xf759, 0xfc8f, 0xfb41, 0xfac9, 0xfa52,
0xfce1, 0xfa5a, 0xfc4c, 0xf813, 0xf93c, 0xf7c7, 0xf42d, 0xf4cf, 0xf101, 0xf0cd,
0xf7c9, 0xf74a, 0xfd68, 0xfca8, 0xfa76, 0xf95a, 0xf805, 0xf50d, 0xf751, 0xf162,
0xfa22, 0xf482, 0x0457, 0x00a0, 0xff6d, 0xfaba, 0xf97c, 0xf4d3, 0xfd12, 0xfb34,
0xfedc, 0xfe91, 0x0323, 0x0191, 0xffad, 0xfe35, 0xfa41, 0xfab6, 0xf300, 0xf38c,
0xf477, 0xf2c6, 0xf8e9, 0xf65d, 0xf880, 0xf6ed, 0xf546, 0xf44e, 0xf9ba, 0xfbc8,
0xff6d, 0x0307, 0xfca2, 0xff38, 0xfe67, 0x016d, 0xfd84, 0x00d8, 0xfefc, 0x01aa,
0x014c, 0x03c3, 0x1094, 0x148e, 0x33c8, 0x3e21, 0x3a46, 0x47a6, 0x2968, 0x3450,
0x2ccc, 0x36a7, 0x2ff7, 0x3a11, 0x2a59, 0x33c2, 0x28c1, 0x314b, 0x2870, 0x3037,
0x26a3, 0x2d83, 0x2414, 0x2b22, 0x2319, 0x2a3d, 0x230b, 0x2916, 0x21a4, 0x26e3,
0x1ed7, 0x24ba, 0x1e99, 0x2567, 0x2049, 0x27b1, 0x1f00, 0x2579, 0x1ef4, 0x23a7,
0x2112, 0x2654, 0x25e6, 0x2a45, 0x2118, 0x24ec, 0x201b, 0x2600, 0x2569, 0x2bd1,
0x23c0, 0x293b, 0x1f82, 0x24aa, 0x1823, 0x1d3d, 0x1614, 0x1b6e, 0x17ca, 0x1e6b,
0x1c2b, 0x2389, 0x1b56, 0x2223, 0x182a, 0x1c08, 0x145e, 0x1595, 0x1483, 0x176c,
0x1697, 0x1a9d, 0x16f1, 0x19f0, 0x1b86, 0x1c70, 0x1bad, 0x1d04, 0x1cff, 0x1edc,
0x1d66, 0x1ecc, 0x20b6, 0x2299, 0x1fd5, 0x2281, 0x1e2f, 0x240b, 0x1e56, 0x258c,
0x1dd3, 0x24a2, 0x1cd1, 0x210e, 0x1c7c, 0x1e2c, 0x1df3, 0x1e52, 0x1c8e, 0x1df3,
0x1ee2, 0x229d, 0x1f8f, 0x2450, 0x1f34, 0x250a, 0x1e91, 0x2401, 0x1c82, 0x21dd,
0x1a1c, 0x1f16, 0x1af4, 0x209f, 0x1b2a, 0x21c1, 0x1db9, 0x22ba, 0x1cc2, 0x2219,
0x1d90, 0x2567, 0x1ad9, 0x2517, 0x1957, 0x2320, 0x1a08, 0x20a8, 0x19c9, 0x1eff,
0x1908, 0x1ff1, 0x17f0, 0x20ac, 0x160d, 0x1ece, 0x1762, 0x1ffc, 0x1795, 0x1ee7,
0x1673, 0x1bc9, 0x15f3, 0x1a72, 0x1909, 0x1fa9, 0x1f5d, 0x280a, 0x1cd7, 0x2633,
0x1da1, 0x26d3, 0x1e64, 0x25d4, 0x20a2, 0x2706, 0x249d, 0x2c48, 0x23f9, 0x2cd4,
0x1e6d, 0x2785, 0x1ecd, 0x2979, 0x1f53, 0x2a6d, 0x20a5, 0x2c0c, 0x215c, 0x2c1b,
0x229d, 0x2de0, 0x24af, 0x31e1, 0x1b56, 0x2781, 0x15d9, 0x208a, 0x1913, 0x23ba,
0x1bae, 0x26e3, 0x1cf8, 0x2742, 0x1e20, 0x2712, 0x1acc, 0x221c, 0x16a0, 0x1f03,
0x17ad, 0x21a7, 0x183c, 0x216e, 0x1d29, 0x25d4, 0x1e9e, 0x288f, 0x1fbb, 0x2c8c,
0x1ce6, 0x2933, 0x1af6, 0x2668, 0x1efe, 0x2b5c, 0x213c, 0x2f14, 0x1f29, 0x2b9a,
0x1dce, 0x2981, 0x1eb9, 0x2be5, 0x1dc9, 0x2b1d, 0x1d9f, 0x2a55, 0x1c3d, 0x271e,
0x1c37, 0x2616, 0x1c53, 0x2698, 0x1946, 0x24ba, 0x13b5, 0x1fbc, 0x1747, 0x235b,
0x15ec, 0x225e, 0x1798, 0x232f, 0x181e, 0x2039, 0x14d7, 0x1c64, 0x128c, 0x1d0e,
0x1360, 0x211c, 0x14a1, 0x2164, 0x1607, 0x1f9a, 0x1938, 0x2190, 0x1987, 0x23aa,
0x1af4, 0x28ba, 0x1865, 0x26e4, 0x1c3f, 0x28f3, 0x1f90, 0x2a55, 0x2158, 0x2b64,
0x1e52, 0x2818, 0x1a9b, 0x2388, 0x17a8, 0x1f29, 0x15c2, 0x1e3a, 0x17bb, 0x21f1,
0x1766, 0x2248, 0x1841, 0x2212, 0x13a4, 0x1b26, 0x13ba, 0x1c0d, 0x139f, 0x1c44,
0x16b5, 0x1f1d, 0x11f8, 0x1979, 0x0f07, 0x162b, 0x11b2, 0x1afa, 0x133f, 0x1dca,
0x1055, 0x1a08, 0x0e97, 0x15f5, 0x0ea7, 0x1439, 0x0fac, 0x16f2, 0x0fc4, 0x188b,
0x0fc8, 0x1961, 0x11cc, 0x19a8, 0x0ee5, 0x13a4, 0x0e59, 0x1348, 0x1108, 0x17a0,
0x0f3c, 0x1444, 0x0ebc, 0x1275, 0x0e06, 0x11e9, 0x0a80, 0x0fc7, 0x0c8a, 0x1443,
0x106b, 0x17fd, 0x0e0c, 0x1233, 0x0cce, 0x1024, 0x0c3f, 0x1186, 0x0a9c, 0x0f70,
0x0aea, 0x0fd7, 0x0962, 0x0f3d, 0x03a8, 0x0940, 0x0408, 0x0929, 0x0465, 0x0abb,
0x0142, 0x0893, 0x0102, 0x08d0, 0x0236, 0x0947, 0x01f3, 0x0712, 0x0315, 0x0703,
0x017f, 0x03c6, 0x01d6, 0x0415, 0x01fd, 0x0578, 0x0224, 0x073e, 0x031b, 0x0899,
0x011f, 0x04d8, 0x0112, 0x032a, 0x0179, 0x0590, 0xfdfa, 0x0434, 0xfbe6, 0x009b,
0xfe74, 0x01a2, 0xff74, 0x03aa, 0xffc4, 0x0406, 0xfce7, 0xff92, 0xfc3c, 0xfe32,
0xfdab, 0xff73, 0xfc20, 0xfdc0, 0xfe31, 0x01ac, 0x04c6, 0x09d6, 0x0427, 0x0806,
0x0235, 0x04eb, 0x036d, 0x0557, 0x03dd, 0x06aa, 0x0341, 0x076a, 0xfa94, 0xfdb2,
0xf70f, 0xf85b, 0xf890, 0xf9ff, 0xf8b4, 0xfc1d, 0xf7af, 0xfce9, 0xf7f9, 0xfd7f,
0xf68b, 0xf9e6, 0xf5a8, 0xf7ee, 0xf50d, 0xf746, 0xf2a2, 0xf4f0, 0xf1c7, 0xf3df,
0xef9b, 0xf202, 0xef8c, 0xf30b, 0xef21, 0xf1e8, 0xeebb, 0xef8b, 0xf01c, 0xf17d,
0xf135, 0xf4bc, 0xf453, 0xf7b7, 0xf644, 0xf8cd, 0xf424, 0xf6d8, 0xf1bc, 0xf4ac,
0xefad, 0xf0df, 0xf157, 0xf168, 0xefb2, 0xf196, 0xeb14, 0xeef2, 0xebc6, 0xee2c,
0xecff, 0xeecb, 0xecb7, 0xf017, 0xebc9, 0xefe1, 0xec4d, 0xf027, 0xe91c, 0xec4a,
0xe48c, 0xe65c, 0xe372, 0xe320, 0xe61d, 0xe521, 0xe762, 0xe639, 0xe3a8, 0xe26f,
0xe4ed, 0xe40f, 0xef27, 0xef97, 0x0582, 0x0bd0, 0x0e16, 0x1711, 0xeee0, 0xf37b,
0xdf0a, 0xe216, 0xe9c2, 0xed90, 0xec84, 0xede6, 0xec94, 0xea79, 0xed08, 0xea65,
0xeaa8, 0xe982, 0xe8cc, 0xe912, 0xe7da, 0xe87b, 0xe489, 0xe4c7, 0xe5b2, 0xe529,
0xe8ac, 0xe780, 0xe574, 0xe39c, 0xe4a0, 0xe2dd, 0xe5ae, 0xe46d, 0xdffc, 0xddf7,
0xde28, 0xdaff, 0xdfc7, 0xdd7e, 0xe428, 0xe331, 0xe727, 0xe68c, 0xe4b1, 0xe3da,
0xe0cc, 0xe003, 0xde57, 0xddee, 0xdc07, 0xda2f, 0xdabb, 0xd827, 0xdec0, 0xdce2,
0xdefd, 0xdb39, 0xdae5, 0xd419, 0xd93a, 0xd2b7, 0xda9d, 0xd5bd, 0xd7ff, 0xd2d7,
0xd8ad, 0xd317, 0xd8e5, 0xd39a, 0xd95b, 0xd23f, 0xd746, 0xcd44, 0xd528, 0xcb82,
0xd9ec, 0xcf97, 0xdc7b, 0xd009, 0xdb8f, 0xcec2, 0xdab1, 0xceee, 0xd7c6, 0xcc22,
0xd5da, 0xc942, 0xd838, 0xcd15, 0xd881, 0xce6e, 0xd769, 0xcbec, 0xd763, 0xcac3,
0xd640, 0xcbb4, 0xd31e, 0xc929, 0xd255, 0xc788, 0xd3ba, 0xc745, 0xd638, 0xc843,
0xd45b, 0xc5ac, 0xd1f8, 0xc38a, 0xce51, 0xc1e4, 0xd0ab, 0xc329, 0xd12a, 0xc1ed,
0xd442, 0xc572, 0xd4ee, 0xc679, 0xd50f, 0xc576, 0xd4ba, 0xc440, 0xd0a7, 0xbf72,
0xce3f, 0xbc3d, 0xcec0, 0xbdcc, 0xd1fd, 0xc2a9, 0xd186, 0xc1fe, 0xd292, 0xc27c,
0xd225, 0xc260, 0xd2b2, 0xc32e, 0xd09c, 0xc11c, 0xd110, 0xc0d1, 0xd2d1, 0xc201,
0xd0ab, 0xc003, 0xcec5, 0xbf1d, 0xd179, 0xc239, 0xdef5, 0xcfa2, 0xfe43, 0xf31d,
0x0f49, 0x0808, 0x0d13, 0x06fa, 0x0c38, 0x06f9, 0x0acf, 0x0454, 0x0826, 0xfed6,
0x0584, 0xfbaf, 0x0136, 0xf8a8, 0xffee, 0xf7fd, 0xff14, 0xf58c, 0x008d, 0xf581,
0xfcac, 0xf359, 0xf8c3, 0xf110, 0xf535, 0xef75, 0xf2bd, 0xed88, 0xf603, 0xee8a,
0xf6e0, 0xee51, 0xf674, 0xecdc, 0xf4b6, 0xe9ae, 0xf520, 0xe9e7, 0xf499, 0xea87,
0xf749, 0xed7e, 0xf8a4, 0xef19, 0xfb1b, 0xf29b, 0xfb2a, 0xf30d, 0xf70b, 0xee97,
0xf6a8, 0xed3e, 0xf81f, 0xef1e, 0xfcb3, 0xf3d6, 0xffea, 0xf740, 0x011b, 0xf96d,
0x0146, 0xfcf2, 0x0092, 0xfd99, 0x019c, 0xfaeb, 0x0207, 0xf7cc, 0xfe60, 0xf2b5,
0xfe0b, 0xf459, 0xfff1, 0xf85f, 0x00cb, 0xfb70, 0xff2c, 0xfa1b, 0xff5a, 0xf76e,
0xfded, 0xf5c2, 0xf93d, 0xf2d4, 0xf8b1, 0xf442, 0xfd94, 0xfac0, 0x0334, 0xff60,
0x046a, 0xff3d, 0x00cb, 0xfb4b, 0xfffe, 0xfbe1, 0x01bc, 0xfef1, 0xfe37, 0xfa73,
0xff4f, 0xfa85, 0xff76, 0xfa53, 0x00c9, 0xfcb0, 0x030a, 0xff5b, 0x030f, 0xfe47,
0x0146, 0xfbd7, 0x0209, 0xfb7e, 0x0400, 0xfcc2, 0x0514, 0xfef6, 0x0143, 0xfba6,
0x01fc, 0xfbfb, 0x048f, 0xfb8b, 0xfed0, 0xf40b, 0x003d, 0xf6d8, 0xfd6a, 0xf4d3,
0xfb82, 0xf288, 0xfce0, 0xf19e, 0xfd42, 0xf004, 0x0041, 0xf377, 0x03f8, 0xf7a3,
0x0275, 0xf785, 0xffdf, 0xf5d1, 0x012c, 0xf6ea, 0x0187, 0xf750, 0x0360, 0xf82b,
0x0602, 0xf8ea, 0x0881, 0xfa1d, 0x0649, 0xf930, 0x03e5, 0xf93b, 0x0326, 0xf7ef,
0x00d7, 0xf430, 0x0179, 0xf54e, 0x027c, 0xf6aa, 0x03a8, 0xf8cf, 0x0198, 0xf66e,
0x00aa, 0xf367, 0x0692, 0xf81f, 0x06f7, 0xf9ed, 0x0d5c, 0x018c, 0x0de3, 0x0242,
0x09bc, 0xffad, 0x07d4, 0xfe26, 0x0737, 0xfe46, 0x0877, 0xfef9, 0x043a, 0xfb25,
0x069f, 0xfdf4, 0x02eb, 0xf9a2, 0xffab, 0xf6cd, 0xfc2b, 0xf3cc, 0xfd4b, 0xf4af,
0x0157, 0xf720, 0x0428, 0xfa1b, 0x05d3, 0xfd04, 0x040b, 0xfc5d, 0x03d2, 0xfaa3,
0x0697, 0xfcb8, 0x08f6, 0xfec5, 0x0a8f, 0x0006, 0x0dda, 0x0434, 0x0a69, 0x02f6,
0x0868, 0x02ae, 0x0850, 0x0318, 0x08c1, 0x048a, 0x0bd5, 0x064e, 0x0d4e, 0x058a,
0x0c46, 0x04f8, 0x0a3f, 0x04f9, 0x0970, 0x0501, 0x09eb, 0x0647, 0x0728, 0x03fb,
0x06d3, 0x04ad, 0x0a4b, 0x07f2, 0x0cb0, 0x0a33, 0x0a48, 0x07a3, 0x0666, 0x02a3,
0x06ed, 0x031c, 0x0936, 0x03b8, 0x099c, 0x0450, 0x0ac3, 0x06e6, 0x0b47, 0x08d1,
0x0b0a, 0x0795, 0x09ff, 0x06b8, 0x0ac2, 0x08a2, 0x0e8b, 0x0cc0, 0x0b7d, 0x0b68,
0x0a05, 0x096e, 0x0bbb, 0x0d57, 0x0dd4, 0x0fe3, 0x0aa7, 0x0b6c, 0x0a6a, 0x0bfe,
0x0ed7, 0x12c1, 0x0ac8, 0x0fcd, 0x0995, 0x0de4, 0x0c60, 0x0e53, 0x0c1f, 0x0d8e,
0x0d6d, 0x1145, 0x0f5c, 0x13eb, 0x0de0, 0x1208, 0x0e94, 0x105d, 0x0df3, 0x0e04,
0x0d9d, 0x0d2f, 0x0e88, 0x109c, 0x0fc0, 0x140e, 0x0d26, 0x11d1, 0x0b42, 0x0f0e,
0x0bdc, 0x0eaf, 0x0e60, 0x10b0, 0x0fc0, 0x121f, 0x1060, 0x144b, 0x102e, 0x148a,
0x0d1e, 0x11f3, 0x0bf0, 0x120a, 0x0b87, 0x12b6, 0x0c5e, 0x131c, 0x0cf7, 0x144a,
0x0ebe, 0x16bd, 0x091a, 0x12d7, 0x054c, 0x1010, 0x04c5, 0x0f01, 0x0780, 0x10f8,
0x08ce, 0x1013, 0x0853, 0x0ea3, 0x0721, 0x0bbd, 0x06a8, 0x0d5b, 0x09e5, 0x1285,
0x0780, 0x0f17, 0x09fa, 0x11b7, 0x0840, 0x1060, 0x05ee, 0x0e59, 0x0705, 0x0ca9,
0x05d2, 0x08eb, 0x07ca, 0x0b4e, 0x080a, 0x0d1b, 0x0887, 0x1026, 0x056f, 0x0f6a,
0x0267, 0x0b87, 0x030a, 0x095e, 0x04fd, 0x09de, 0x0380, 0x0a39, 0xffc5, 0x07be,
0xfcf1, 0x05c7, 0xfc77, 0x06a2, 0xfd44, 0x076b, 0xfff9, 0x08fe, 0x0510, 0x0c8e,
0x0481, 0x0b88, 0x0498, 0x0c00, 0x007d, 0x07b7, 0x00ef, 0x0737, 0x0279, 0x093a,
0x031c, 0x08ee, 0x04bc, 0x0a44, 0x08ee, 0x0e60, 0x08d0, 0x0d61, 0x0668, 0x0aa2,
0x0527, 0x07d1, 0x0314, 0x067c, 0x0347, 0x07fa, 0x01c7, 0x0859, 0xff8a, 0x0604,
0xf93a, 0xfd9b, 0xf93a, 0xfdd9, 0xfc70, 0xff8e, 0xfc74, 0xfebf, 0xfb37, 0xfda7,
0xfcc5, 0xff40, 0x034e, 0x0459, 0x0518, 0x047c, 0x04a4, 0x04d9, 0x00be, 0x008b,
0xfdfb, 0xfda4, 0xfee7, 0xff5e, 0xfe66, 0xff9d, 0xfe75, 0x0055, 0xfc82, 0xfffc,
0xff70, 0x0227, 0xf9a6, 0xfbc4, 0xf5b8, 0xf869, 0xf4f1, 0xf666, 0xf55b, 0xf4bf,
0xf6ac, 0xf2eb, 0xf7d8, 0xf446, 0xfb6e, 0xf885, 0xf96c, 0xf942, 0xfa20, 0xfbad,
0xf87d, 0xf792, 0xf9d8, 0xf7c2, 0xfaf2, 0xf8e9, 0xfb39, 0xfc27, 0x0356, 0x04c0,
0x01b1, 0x011e, 0xfd0b, 0xfc9f, 0xfb7a, 0xfbc9, 0xf9ed, 0xf9b3, 0xf900, 0xf81a,
0xf699, 0xf731, 0xf785, 0xf9d9, 0xf98c, 0xfa60, 0xf717, 0xf6d2, 0xf73a, 0xf732,
0xf5a2, 0xf603, 0xf458, 0xf75a, 0xf438, 0xf7fe, 0xf25b, 0xf3c8, 0xf495, 0xf2ad,
0xf761, 0xf601, 0xf755, 0xf852, 0xf4b0, 0xf651, 0xf65f, 0xf93a, 0x0033, 0x050a,
0x187d, 0x1fd0, 0x2356, 0x2b11, 0x1ee1, 0x25dd, 0x1834, 0x1f59, 0x15ef, 0x1dcc,
0x129a, 0x1ae6, 0x104c, 0x17a2, 0x0ff6, 0x15b9, 0x0ea1, 0x1304, 0x0ecd, 0x134c,
0x0fad, 0x142f, 0x0e0e, 0x12f4, 0x0bfe, 0x115a, 0x0a7b, 0x1034, 0x068d, 0x0cfc,
0x0919, 0x0f17, 0x0e7b, 0x14b7, 0x0f8e, 0x1621, 0x09b1, 0x0fb6, 0x083c, 0x0c16,
0x0805, 0x0b5d, 0x0533, 0x0af9, 0x01a0, 0x0982, 0x01cd, 0x09d5, 0x02a6, 0x0959,
0x0222, 0x0585, 0x00f4, 0x0339, 0xff3e, 0x0204, 0xfa8a, 0xfe12, 0xfa78, 0xff9f,
0xf83a, 0xfd29, 0xf6f3, 0xfa5b, 0xf620, 0xf686, 0xf631, 0xf6eb, 0xf7a6, 0xf94e,
0xf812, 0xf8dc, 0xf7fe, 0xf7a3, 0xf8d0, 0xf780, 0xfc26, 0xf981, 0xfc83, 0xf889,
0xfe5f, 0xfa2b, 0xfc00, 0xf8ef, 0xfbc2, 0xfceb, 0xfa0d, 0xfaab, 0xf999, 0xf967,
0xfa48, 0xfbd9, 0xfbd7, 0xff09, 0xf9ed, 0xfd7c, 0xf866, 0xfa16, 0xf8c0, 0xf90e,
0xf7a1, 0xf62f, 0xf8c3, 0xf5af, 0xf6d5, 0xf374, 0xf7c7, 0xf554, 0xf782, 0xf644,
0xf73f, 0xf615, 0xf3b7, 0xf299, 0xf2ed, 0xf23b, 0xf221, 0xf092, 0xf2ca, 0xedd8,
0xf44d, 0xec1e, 0xf46a, 0xed43, 0xf623, 0xf025, 0xf701, 0xf0da, 0xf9a2, 0xf27f,
0xf652, 0xef6a, 0xf353, 0xee29, 0xf51e, 0xf0f3, 0xf589, 0xefe6, 0xf578, 0xee9a,
0xf709, 0xf14c, 0xf99c, 0xf534, 0xfa9e, 0xf650, 0xf9d5, 0xf405, 0xfca5, 0xf74a,
0xfe64, 0xf883, 0xfb0f, 0xf450, 0xf762, 0xf141, 0xf5cf, 0xf008, 0xf5ca, 0xf0c6,
0xf60e, 0xf09f, 0xf627, 0xef7d, 0xf600, 0xeed4, 0xf4d4, 0xeec9, 0xf4f3, 0xf038,
0xf621, 0xeff8, 0xf708, 0xf00c, 0xf8a1, 0xf200, 0xf882, 0xf1bb, 0xf7da, 0xf22f,
0xf7e5, 0xf3b8, 0xf936, 0xf6ed, 0xfe52, 0xfdbb, 0x00fc, 0xffd0, 0x029f, 0x0006,
0x05df, 0x03df, 0x07a4, 0x07bc, 0x05a1, 0x060a, 0x0357, 0x025c, 0x03e8, 0x038c,
0x06f1, 0x07bf, 0x070f, 0x0879, 0x0893, 0x0bb3, 0x0822, 0x0bed, 0x084d, 0x0b2c,
0x0715, 0x0883, 0x092c, 0x0890, 0x0da1, 0x0cf2, 0x1538, 0x16e6, 0x262f, 0x2a93,
0x3180, 0x37dd, 0x32fa, 0x3802, 0x2fad, 0x33f1, 0x2f12, 0x3537, 0x2c5f, 0x35b4,
0x2953, 0x331e, 0x2393, 0x2900, 0x2524, 0x2600, 0x2847, 0x264d, 0x2988, 0x280a,
0x2754, 0x278b, 0x26ee, 0x283d, 0x2772, 0x2801, 0x26e7, 0x278c, 0x2909, 0x2979,
0x26c8, 0x271a, 0x269b, 0x2846, 0x267c, 0x28b4, 0x22a0, 0x268c, 0x20be, 0x24e2,
0x204c, 0x2279, 0x1ebf, 0x1f3a, 0x1e2d, 0x1eb1, 0x1db6, 0x1fc2, 0x1d41, 0x2073,
0x19f3, 0x1d94, 0x1a0c, 0x1cdd, 0x1d0f, 0x1eab, 0x1faa, 0x2197, 0x1d8e, 0x21c7,
0x1d09, 0x21d1, 0x1ee2, 0x20c7, 0x1c78, 0x1b22, 0x1b7c, 0x19eb, 0x1a0c, 0x1965,
0x1b11, 0x1c62, 0x19a8, 0x1c91, 0x1793, 0x1a2d, 0x18c4, 0x1b58, 0x18e6, 0x1ab6,
0x1a7e, 0x1bda, 0x1a9a, 0x1bc5, 0x17c4, 0x1a67, 0x1586, 0x18a7, 0x139f, 0x1530,
0x1507, 0x1577, 0x13bb, 0x1517, 0x1217, 0x165f, 0x11b9, 0x15ae, 0x1407, 0x1656,
0x1434, 0x1721, 0x13bd, 0x187f, 0x15f5, 0x1a6b, 0x1520, 0x18c7, 0x1734, 0x1ae6,
0x15a2, 0x1ac5, 0x1765, 0x1dc0, 0x196e, 0x1f5a, 0x1b71, 0x2224, 0x1ce7, 0x2425,
0x1d21, 0x24bc, 0x1cba, 0x24ed, 0x1b99, 0x23bd, 0x18a1, 0x1f5c, 0x18a9, 0x1e7d,
0x17ed, 0x1e97, 0x134a, 0x1a49, 0x136d, 0x1ab9, 0x171d, 0x1ea8, 0x17d2, 0x2009,
0x14b1, 0x1ef7, 0x13a6, 0x1ef9, 0x1427, 0x1de9, 0x150f, 0x1e5b, 0x14c6, 0x1fcb,
0x1495, 0x2027, 0x1514, 0x2058, 0x148e, 0x1e05, 0x1582, 0x1f0a, 0x15a4, 0x200c,
0x1693, 0x21cc, 0x167b, 0x224b, 0x156b, 0x1f9d, 0x13ef, 0x1fbb, 0x11e3, 0x1f85,
0x13b8, 0x2107, 0x11d2, 0x1e27, 0x0f98, 0x1b9a, 0x0f21, 0x1adc, 0x103b, 0x1b54,
0x0ee8, 0x1bbb, 0x0bc0, 0x18d7, 0x0d23, 0x1949, 0x0fe3, 0x1b2e, 0x1196, 0x1be1,
0x11ab, 0x1ca6, 0x11b0, 0x1d74, 0x1077, 0x1cdd, 0x1061, 0x1bf4, 0x0fc7, 0x1971,
0x0f3f, 0x19eb, 0x0f46, 0x1b26, 0x117d, 0x2051, 0x14ea, 0x2548, 0x149f, 0x2349,
0x1488, 0x1fca, 0x1496, 0x1eb0, 0x12f1, 0x2088, 0x0f96, 0x1f97, 0x0edc, 0x1d56,
0x10db, 0x1c9a, 0x11ad, 0x1def, 0x119a, 0x1e88, 0x0f6c, 0x1ce0, 0x0f5a, 0x1c39,
0x11e9, 0x1d7b, 0x110d, 0x1ac8, 0x0f80, 0x196a, 0x0f4b, 0x19c8, 0x114c, 0x1b54,
0x1211, 0x1d27, 0x0e9b, 0x1b34, 0x0ba9, 0x190a, 0x0cfe, 0x19e0, 0x0f6d, 0x1c05,
0x0f5f, 0x1c1e, 0x10d3, 0x1d2c, 0x1386, 0x1edd, 0x1149, 0x1e1d, 0x0e5a, 0x1c0e,
0x0c2b, 0x1ad9, 0x0adf, 0x1948, 0x0743, 0x1476, 0x058a, 0x11dc, 0x04ab, 0x11c4,
0x05f1, 0x150e, 0x0422, 0x12b0, 0x0213, 0x0f3c, 0x0484, 0x0d1a, 0x0566, 0x0d0e,
0x09f7, 0x142a, 0x0898, 0x13b3, 0x085a, 0x1354, 0x05f8, 0x1226, 0x0807, 0x1547,
0x0849, 0x1336, 0x09e6, 0x1257, 0x0b49, 0x137f, 0x0ab1, 0x15b9, 0x0bab, 0x16ee,
0x0859, 0x1164, 0x072d, 0x0f73, 0x033a, 0x0d33, 0x033d, 0x0ed8, 0x0304, 0x0f7d,
0x0135, 0x0c87, 0xfd9f, 0x0920, 0xfdd4, 0x095e, 0xff55, 0x07e9, 0xff9c, 0x069f,
0x00e7, 0x0595, 0x00c3, 0x04ec, 0x000d, 0x04f1, 0xff72, 0x04bf, 0xfc0c, 0x0411,
0xf8ab, 0x0251, 0xf810, 0x00ce, 0xf7bf, 0xff3d, 0xf898, 0xfe6b, 0xf598, 0xfb5b,
0xf865, 0xfea9, 0xfb20, 0x0128, 0xfa50, 0x00a7, 0xfa1a, 0xfe79, 0xf809, 0xfb0b,
0xf6c4, 0xfa1e, 0xf3c2, 0xf6c4, 0xf587, 0xf9bc, 0xf903, 0xfde1, 0xfbec, 0x008e,
0x038a, 0x0752, 0x0429, 0x06f7, 0x05df, 0x075b, 0x0451, 0x051f, 0x0464, 0x0658,
0x04f7, 0x06c2, 0xfff9, 0x0305, 0x001f, 0x0400, 0xfdb2, 0x00c5, 0xfb95, 0xff7d,
0xf617, 0xfb53, 0xf682, 0xfaad, 0xf4e6, 0xf720, 0xf315, 0xf48b, 0xec97, 0xedf1,
0xed5f, 0xee76, 0xf20a, 0xf25b, 0xf062, 0xf1b9, 0xf04e, 0xf06b, 0xeeb7, 0xee83,
0xee89, 0xf188, 0xeba6, 0xeeb5, 0xe9c2, 0xeadb, 0xe94d, 0xe9c8, 0xedfd, 0xed47,
0xeb69, 0xea51, 0xedb6, 0xed2c, 0xef54, 0xee83, 0xf36a, 0xf249, 0xf258, 0xf0e1,
0xecbb, 0xec6c, 0xedbf, 0xedc9, 0xebce, 0xecc1, 0xea3c, 0xec1c, 0xe569, 0xe588,
0xe702, 0xe6a5, 0xe92f, 0xe7d7, 0xe804, 0xe501, 0xe4e7, 0xe38f, 0xe2e1, 0xe3c4,
0xe611, 0xe658, 0xe6c9, 0xe5e0, 0xe494, 0xe436, 0xe1c0, 0xe1c8, 0xe275, 0xe223,
0xe5ab, 0xe4d5, 0xe5db, 0xe5c3, 0xe75d, 0xe5d4, 0xe879, 0xe566, 0xea3c, 0xe8df,
0xec72, 0xec1c, 0xee43, 0xed74, 0xef16, 0xed6a, 0xefd8, 0xef00, 0xec58, 0xeb99,
0xea18, 0xe98e, 0xe9a1, 0xe98a, 0xe790, 0xe6ea, 0xe995, 0xe7d4, 0xecbd, 0xea22,
0xf10a, 0xf049, 0xefe5, 0xf075, 0xecb2, 0xebb3, 0xea50, 0xe940, 0xe73e, 0xe968,
0xe66e, 0xe967, 0xe635, 0xe782, 0xe627, 0xe567, 0xe8fa, 0xe5d2, 0xe937, 0xe6f4,
0xe8e5, 0xe842, 0xe652, 0xe440, 0xe3f1, 0xe0e6, 0xe472, 0xdf7e, 0xe46a, 0xdd90,
0xe1e5, 0xdb31, 0xdd36, 0xd881, 0xdd28, 0xd9d2, 0xde5b, 0xd871, 0xde0f, 0xd550,
0xda51, 0xcfb6, 0xd8ac, 0xcd84, 0xd873, 0xcd70, 0xd874, 0xcc52, 0xd8f2, 0xcb64,
0xd988, 0xccc5, 0xdc94, 0xce27, 0xdbd6, 0xcab4, 0xd99f, 0xcc0e, 0xd90b, 0xccd9,
0xda07, 0xcb60, 0xd916, 0xc816, 0xd66a, 0xc63e, 0xd57f, 0xc6f6, 0xd53f, 0xc5ad,
0xd3c9, 0xc430, 0xd1d8, 0xc208, 0xd3f9, 0xc434, 0xd5bd, 0xc55b, 0xd51c, 0xc2f5,
0xd331, 0xc11f, 0xd47b, 0xc2dc, 0xd41b, 0xc31d, 0xd3ab, 0xc394, 0xd3ec, 0xc377,
0xd34b, 0xc24f, 0xd2a5, 0xbfa1, 0xd291, 0xbf65, 0xd699, 0xc3e1, 0xd4c2, 0xc19e,
0xd364, 0xc0a9, 0xd30f, 0xc04a, 0xd4ab, 0xc1e8, 0xd5ee, 0xc434, 0xd447, 0xc530,
0xd30a, 0xc345, 0xcdce, 0xbc06, 0xce2a, 0xbc81, 0xcf80, 0xbd1e, 0xd041, 0xbe3c,
0xd14b, 0xc07c, 0xcfc1, 0xc106, 0xd04e, 0xc3da, 0xd129, 0xc377, 0xd43f, 0xc60e,
0xd9e7, 0xcc69, 0xe1b0, 0xd533, 0xecd6, 0xe21a, 0xfab0, 0xf07d, 0x0537, 0xfb2b,
0x08c5, 0xfecb, 0x096d, 0x016a, 0x0967, 0x0389, 0x0a3e, 0x03b7, 0x0cb6, 0x04c1,
0x0b5c, 0x0300, 0x07c6, 0xff8a, 0x07ef, 0x00bb, 0x06a8, 0x0081, 0x047f, 0xfecf,
0xffce, 0xfb08, 0xfd75, 0xf6fd, 0xfdcb, 0xf643, 0xfcf2, 0xf555, 0xfefb, 0xf642,
0xfed5, 0xf517, 0x01e5, 0xf782, 0xfff8, 0xf58d, 0xfd8c, 0xf349, 0xfb00, 0xf1c9,
0xf92a, 0xf07e, 0xfb07, 0xf225, 0xf72a, 0xf02a, 0xf6d0, 0xefd6, 0xf4db, 0xebcb,
0xf48b, 0xeb85, 0xf6af, 0xec18, 0xf6d8, 0xeb6d, 0xf5a8, 0xea73, 0xf80f, 0xed02,
0xfa48, 0xefed, 0xfc28, 0xf2fc, 0xfaf1, 0xf444, 0xfbe5, 0xf6bc, 0xfb32, 0xf76f,
0xfc08, 0xf860, 0x03bc, 0xfc9f, 0x0886, 0x00dd, 0x0e16, 0x0838, 0x0cb2, 0x08cb,
0x0b5f, 0x0930, 0x0a57, 0x080d, 0x0b9e, 0x088b, 0x0c25, 0x0974, 0x0de6, 0x0c0d,
0x0c96, 0x0b81, 0x0892, 0x0a63, 0x08c3, 0x0b84, 0x0822, 0x09b8, 0x0960, 0x08d2,
0x07e7, 0x0615, 0x07c6, 0x05d2, 0x06bc, 0x0492, 0x057b, 0x0327, 0x02df, 0x0119,
0x017c, 0x016b, 0x010a, 0x00a9, 0x014e, 0x0114, 0x073c, 0x03b9, 0x08b0, 0x0273,
0x0bdb, 0x0452, 0x0cb4, 0x0436, 0x0a66, 0x0241, 0x0764, 0xffbd, 0x0705, 0x0237,
0x07f9, 0x0324, 0x0784, 0x0233, 0x0648, 0xff7b, 0x0828, 0x01cb, 0x0929, 0x02d5,
0x07d5, 0x000f, 0x0832, 0x0165, 0x056f, 0xfe7c, 0x0530, 0xfc2f, 0x03ed, 0xf8ce,
0x02fd, 0xf7c4, 0x0183, 0xf7e6, 0x00f7, 0xf947, 0x0052, 0xfa4c, 0x011b, 0xfbbd,
0x03ae, 0xfcda, 0x03ad, 0xfbb4, 0x04a4, 0xfb0e, 0x04f6, 0xfad3, 0x052f, 0xfba6,
0x036c, 0xf9ec, 0x0600, 0xfdae, 0x0828, 0x015b, 0x0635, 0x019e, 0x0511, 0x010d,
0x0408, 0xfdc8, 0x0263, 0xfc20, 0x0083, 0xfb94, 0x0431, 0xffcc, 0x06b7, 0x027d,
0x06cc, 0x014a, 0x0356, 0xfdaf, 0x02b7, 0xfc4d, 0x03d5, 0xfcd5, 0x03a2, 0xfe97,
0x0658, 0x0313, 0x0396, 0x026f, 0x061e, 0x057a, 0x0782, 0x05a4, 0x08c5, 0x060f,
0x0a1f, 0x05f7, 0x046f, 0x011f, 0x0430, 0x0331, 0x03a8, 0x01cc, 0x0318, 0x00b5,
0x01c6, 0x0110, 0x01b7, 0x012b, 0x02dd, 0x039c, 0x0288, 0x0490, 0x00a7, 0x04c7,
0x02b8, 0x064d, 0x0164, 0x01dd, 0xffcb, 0xffae, 0xfedb, 0xfd40, 0xff02, 0xfe07,
0x0379, 0x0301, 0x03b1, 0x03e3, 0x0790, 0x087c, 0x0739, 0x090a, 0x0ae6, 0x0cba,
0x09f1, 0x0b25, 0x0a7a, 0x0c51, 0x0b49, 0x0e7d, 0x1165, 0x15e7, 0x157e, 0x1993,
0x1401, 0x19b0, 0x1408, 0x18fb, 0x0eff, 0x141e, 0x0ee5, 0x151c, 0x076b, 0x0fab,
0x06bc, 0x0e68, 0x0666, 0x08e9, 0x0660, 0x09eb, 0x0b2a, 0x0ee0, 0x0c82, 0x0f30,
0x1153, 0x13d3, 0x1285, 0x1493, 0x0de8, 0x11a3, 0x0c17, 0x1112, 0x0955, 0x1075,
0x0730, 0x0eb3, 0x02eb, 0x0ae2, 0x0316, 0x0ab2, 0x0616, 0x0a7c, 0x0753, 0x0c4f,
0x0e88, 0x12cf, 0x0fa4, 0x1385, 0x12f3, 0x17ef, 0x1157, 0x16b4, 0x131f, 0x1984,
0x138d, 0x19fa, 0x0b01, 0x157e, 0x0ad3, 0x16a0, 0x054a, 0x0f9e, 0x0666, 0x0f1f,
0x0387, 0x0a5b, 0x01a3, 0x08ce, 0x0497, 0x0bd1, 0x0483, 0x0d8f, 0x09e0, 0x1293,
0x0a9e, 0x118b, 0x0d14, 0x1408, 0x0c70, 0x1494, 0x09bd, 0x120c, 0x07d7, 0x117d,
0x0492, 0x105e, 0x02a7, 0x0dd4, 0x0145, 0x0b70, 0x028e, 0x0ab3, 0x0796, 0x1075,
0x0789, 0x11eb, 0x05c8, 0x1203, 0x057e, 0x111f, 0x0587, 0x0e6c, 0x06f4, 0x0fc6,
0x052c, 0x0d01, 0x0512, 0x0c2e, 0x0152, 0x08e5, 0xfdfb, 0x06a3, 0xfe51, 0x067d,
0xfe3d, 0x04fd, 0x0182, 0x080d, 0x02a4, 0x0980, 0x06f9, 0x0e34, 0x06dd, 0x0ddd,
0x0394, 0x0b22, 0x042c, 0x0cdb, 0x04d7, 0x0d57, 0x0529, 0x0c71, 0x017c, 0x096f,
0x01a3, 0x0ad5, 0xffc3, 0x0858, 0xff67, 0x0629, 0xff15, 0x025c, 0xffe1, 0x03d2,
0x0064, 0x06ef, 0x0012, 0x0751, 0xffe8, 0x0680, 0xfea6, 0x0502, 0xfcea, 0x0499,
0xfd9c, 0x0416, 0xfc1f, 0x0116, 0xfa3f, 0xff45, 0xf8b1, 0xfeee, 0xf867, 0xff56,
0xf795, 0xfe93, 0xf7bb, 0xfd47, 0xf991, 0xfb16, 0xfb19, 0xfb36, 0xfe28, 0xfe60,
0xfa36, 0xfc86, 0xfd87, 0x0061, 0xff63, 0x009b, 0x04c8, 0x05ad, 0x03c7, 0x03e6,
0xffad, 0x0279, 0xff77, 0x036f, 0xf916, 0xfd8f, 0xf7b9, 0xfc28, 0xf614, 0xf782,
0xf761, 0xf7a9, 0xf637, 0xf5a9, 0xf58e, 0xf584, 0xf806, 0xf781, 0xf68b, 0xf5a8,
0xf4a8, 0xf4e5, 0xf5d2, 0xf4cc, 0xf7a7, 0xf59e, 0xf617, 0xf4fc, 0xf485, 0xf3cb,
0xf548, 0xf4a3, 0xfa7c, 0xf92f, 0xfc99, 0xfb2d, 0xfdab, 0xfcb2, 0xfe29, 0xfc87,
0xfcd8, 0xfc29, 0xfd0a, 0xfcb7, 0xfb1a, 0xfbc5, 0xf9f7, 0xfb56, 0xf69e, 0xf72d,
0xf51b, 0xf591, 0xf674, 0xf695, 0xf749, 0xf77f, 0xfa9a, 0xf9da, 0xf9e7, 0xf8aa,
0xf918, 0xf875, 0xf80b, 0xf645, 0xf6bc, 0xf5cc, 0xf5e7, 0xf5e3, 0xf2ad, 0xf43c,
0xf612, 0xf7a5, 0xfa00, 0xf68d, 0xfc04, 0xf863, 0xffd4, 0xfe8f, 0x04a1, 0x0407,
0x09b6, 0x085e, 0x0dd3, 0x0cdc, 0x0c81, 0x0de3, 0x0c96, 0x0e72, 0x110f, 0x10ed,
0x13cf, 0x12a4, 0x159c, 0x1639, 0x15e4, 0x1804, 0x16b3, 0x16ef, 0x1544, 0x14b5,
0x14b4, 0x168c, 0x1575, 0x1747, 0x153a, 0x16aa, 0x13ab, 0x1532, 0x126a, 0x1385,
0x0fcb, 0x111c, 0x0ea7, 0x0ef8, 0x0ee4, 0x0ec2, 0x0e2e, 0x0ceb, 0x0d72, 0x0a50,
0x0d29, 0x08e4, 0x0c74, 0x0874, 0x0afd, 0x0829, 0x0912, 0x065a, 0x0726, 0x0561,
0x061e, 0x03db, 0x0434, 0x0132, 0x0325, 0xfef4, 0x009f, 0xfabe, 0xfecc, 0xf9d6,
0xff8f, 0xfd3e, 0xfeb0, 0xfd76, 0xfe32, 0xfb6d, 0xfe16, 0xf9d7, 0x0035, 0xf9c3,
0x00f4, 0xf866, 0x0220, 0xf8e3, 0x019c, 0xfabf, 0xff89, 0xfc1c, 0xff3c, 0xfb5a,
0x0065, 0xfc30, 0xff16, 0xfa51, 0xfbd5, 0xf6dc, 0xfcf1, 0xf66d, 0xfc1c, 0xf485,
0xfc12, 0xf548, 0xfddf, 0xf6b1, 0xfec0, 0xf76b, 0xfd13, 0xf4ca, 0xfad4, 0xf358,
0xf7d6, 0xf2be, 0xf64a, 0xf135, 0xf6c4, 0xef1b, 0xf755, 0xee9e, 0xf5d7, 0xed35,
0xf490, 0xec6d, 0xf3da, 0xed6d, 0xf480, 0xefa4, 0xf619, 0xf0b2, 0xf824, 0xf031,
0xf96e, 0xf0ac, 0xf7ad, 0xf0dd, 0xf6bf, 0xf1c4, 0xf650, 0xf0c2, 0xf8a7, 0xf079,
0xfa87, 0xf11b, 0xfac7, 0xf223, 0xfaf0, 0xf2b7, 0xfc4e, 0xf51f, 0xfb05, 0xf40e,
0xf7dc, 0xf0e9, 0xf794, 0xf0c5, 0xf978, 0xf2dc, 0xf934, 0xf2e8, 0xf914, 0xf0eb,
0xf98d, 0xf08d, 0xfa75, 0xf25d, 0xfa4a, 0xf2b3, 0xf813, 0xf046, 0xf6d6, 0xefef,
0xf7c5, 0xf184, 0xfb52, 0xf557, 0x007f, 0xfa90, 0x0199, 0xfd63, 0x00f1, 0xff05,
0x00ac, 0xfed1, 0x0048, 0xfe0e, 0xffa3, 0xfdec, 0xfd1e, 0xfca6, 0xfe0a, 0xff56,
0x0002, 0x025d, 0x00ec, 0x0374, 0x0212, 0x03d0, 0x0192, 0x032d, 0x0227, 0x05cb,
0x0127, 0x054f, 0x015d, 0x04dd, 0x0201, 0x0497, 0x01e8, 0x0478, 0x0387, 0x04fc,
0x02bd, 0x0290, 0x00b0, 0x0170, 0xff56, 0x004b, 0x0034, 0x0112, 0xffa5, 0x0045,
0xffb0, 0x0027, 0x00aa, 0x01d4, 0x011a, 0x0291, 0xffee, 0x0188, 0x0163, 0x0220,
0x0284, 0x02c3, 0x061b, 0x064d, 0x0cd8, 0x0bb3, 0x10c1, 0x0fef, 0x1781, 0x18f4,
0x1b75, 0x1e82, 0x2163, 0x24e0, 0x2627, 0x2a1b, 0x2775, 0x2bc2, 0x2a73, 0x2e1e,
0x28d7, 0x2c8b, 0x2703, 0x2b0d, 0x2554, 0x29bd, 0x25d4, 0x2a27, 0x26da, 0x2b86,
0x2820, 0x2d82, 0x2920, 0x2da5, 0x29d1, 0x2d1c, 0x296a, 0x2c98, 0x2787, 0x2bbd,
0x2660, 0x2baa, 0x2440, 0x2ae1, 0x215f, 0x29b4, 0x2158, 0x2807, 0x2437, 0x27ad,
0x2606, 0x282a, 0x24cc, 0x27d6, 0x22f6, 0x2761, 0x2272, 0x26c6, 0x2268, 0x2780,
0x1eaf, 0x255a, 0x1cc2, 0x2323, 0x1b9c, 0x1ff7, 0x1bb3, 0x1e47, 0x19ad, 0x1c1c,
0x181c, 0x1be5, 0x1910, 0x1ca8, 0x1857, 0x1bab, 0x1841, 0x1bc5, 0x1843, 0x1c75,
0x1922, 0x1e81, 0x198e, 0x1e46, 0x1a68, 0x1b76, 0x1a34, 0x1a5e, 0x197f, 0x1c20,
0x1858, 0x1b2a, 0x17e8, 0x19fa, 0x18e0, 0x1bdf, 0x19a3, 0x1cd1, 0x193d, 0x1acb,
0x18d4, 0x1a6b, 0x16d7, 0x1a04, 0x140a, 0x19ab, 0x145c, 0x1a9f, 0x16e5, 0x1b45,
0x16de, 0x1a60, 0x15fa, 0x1ac5, 0x1615, 0x1af3, 0x1807, 0x1b01, 0x1849, 0x1ae5,
0x157b, 0x19e5, 0x14de, 0x1a1b, 0x163b, 0x1afa, 0x1709, 0x1acf, 0x15e0, 0x1999,
0x1485, 0x19b6, 0x138e, 0x18d6, 0x1257, 0x1823, 0x1629, 0x1c84, 0x19a2, 0x1f35,
0x196b, 0x1f63, 0x17c1, 0x1e99, 0x1789, 0x1eab, 0x186e, 0x1f92, 0x16d3, 0x1df5,
0x14f3, 0x1cbb, 0x1407, 0x1bde, 0x1511, 0x1c3d, 0x1392, 0x1c5f, 0x12cf, 0x1d2f,
0x12d4, 0x1b25, 0x137f, 0x19b9, 0x13e1, 0x1aa0, 0x1232, 0x1c9f, 0x1050, 0x1c59,
0x0fe3, 0x1ada, 0x1148, 0x1985, 0x1209, 0x1a06, 0x1370, 0x1c55, 0x124a, 0x1cc4,
0x1204, 0x1d82, 0x1173, 0x1be4, 0x12ff, 0x1ca7, 0x1555, 0x1e82, 0x12c8, 0x1cfa,
0x0f97, 0x1be8, 0x0fd7, 0x1da0, 0x119a, 0x1e8b, 0x10ac, 0x1daf, 0x106b, 0x1cd9,
0x0f70, 0x1bb2, 0x0fd3, 0x1ce2, 0x0f62, 0x1d15, 0x0d28, 0x1a9b, 0x0afb, 0x15c7,
0x0b92, 0x153f, 0x0d5a, 0x1728, 0x0eac, 0x1950, 0x0fc0, 0x18ba, 0x0e01, 0x1505,
0x0d5c, 0x14df, 0x0c66, 0x151b, 0x0c7e, 0x167b, 0x0d2e, 0x1812, 0x0d9c, 0x17ee,
0x0eb7, 0x175f, 0x107b, 0x17b0, 0x107b, 0x17d0, 0x0e06, 0x15c3, 0x0c97, 0x144f,
0x0e18, 0x14ff, 0x0cef, 0x14b7, 0x0b58, 0x1559, 0x0b43, 0x1492, 0x0d2e, 0x14cf,
0x0d3d, 0x13c8, 0x0b9a, 0x12d4, 0x09ec, 0x130b, 0x08f4, 0x1341, 0x0879, 0x1270,
0x091e, 0x109f, 0x0b26, 0x10f6, 0x0aef, 0x1107, 0x08dc, 0x108b, 0x06d6, 0x0fda,
0x0730, 0x109e, 0x0802, 0x1182, 0x097c, 0x130d, 0x06df, 0x121b, 0x04cf, 0x110d,
0x0577, 0x0f80, 0x055a, 0x0d48, 0x04e6, 0x0daa, 0x05f8, 0x0f64, 0x0663, 0x1024,
0x0310, 0x0d86, 0x01fb, 0x0c2f, 0x0251, 0x0b9f, 0x0335, 0x0c23, 0x03ff, 0x0d0c,
0x0686, 0x0de4, 0x064c, 0x0c7e, 0x034c, 0x096a, 0x016d, 0x07c0, 0xff5d, 0x0709,
0xfffc, 0x074f, 0xfdf3, 0x04b1, 0xfbda, 0x0373, 0xf93b, 0x0141, 0xfa8f, 0x0189,
0xf935, 0xfeb4, 0xf80f, 0xfd0b, 0xf7e7, 0xfb91, 0xf621, 0xf99a, 0xf465, 0xf8c6,
0xf3e5, 0xf7c8, 0xf5be, 0xf984, 0xf4d3, 0xf8aa, 0xf71b, 0xfa8a, 0xf864, 0xfae8,
0xf9ee, 0xfb4b, 0xf7a4, 0xfa01, 0xf8b8, 0xfcb2, 0xfb0d, 0xfe38, 0x00b6, 0x0210,
0x024e, 0x034d, 0x022e, 0x04a7, 0x01aa, 0x0517, 0x0134, 0x04a6, 0x0270, 0x0429,
0x0096, 0x01a6, 0x00b1, 0x023d, 0xfcd1, 0x009b, 0xfb89, 0x005d, 0xfa98, 0xfbfc,
0xfb57, 0xfac8, 0xfa32, 0xf9a3, 0xf7e4, 0xf70d, 0xf549, 0xf4f6, 0xf194, 0xf2a6,
0xf005, 0xf0e8, 0xf08f, 0xf13b, 0xf3a9, 0xf377, 0xf30e, 0xf290, 0xf13a, 0xf111,
0xf029, 0xefd6, 0xeeaa, 0xeec9, 0xeecf, 0xef79, 0xed33, 0xee83, 0xed0e, 0xee20,
0xeba2, 0xebe0, 0xe947, 0xe838, 0xe900, 0xe7c8, 0xe9a8, 0xe8f9, 0xe8c9, 0xe840,
0xe6c8, 0xe7a6, 0xe50e, 0xe729, 0xe4bf, 0xe66c, 0xe656, 0xe5e2, 0xe6f2, 0xe4df,
0xe724, 0xe667, 0xe5ec, 0xe62b, 0xe5ff, 0xe530, 0xe69f, 0xe59a, 0xe704, 0xe754,
0xe5ec, 0xe715, 0xe449, 0xe57e, 0xe3a5, 0xe40a, 0xe120, 0xe03f, 0xe1c4, 0xdfee,
0xe085, 0xddf4, 0xdf48, 0xdda8, 0xdef2, 0xde9c, 0xdea9, 0xde9c, 0xdc02, 0xdba8,
0xdc29, 0xd9bc, 0xde31, 0xda91, 0xde6e, 0xdd0a, 0xdde7, 0xe085, 0xdeef, 0xe26a,
0xe1b8, 0xe386, 0xe359, 0xe37c, 0xe7d0, 0xe484, 0xe7d3, 0xe42a, 0xe9dd, 0xe993,
0xe97a, 0xebea, 0xe983, 0xecb2, 0xe8e5, 0xeac9, 0xe621, 0xe703, 0xe58a, 0xe726,
0xe6d0, 0xe7cb, 0xe8a7, 0xe7da, 0xe90f, 0xe947, 0xe7dc, 0xe873, 0xe855, 0xe8a8,
0xe6fc, 0xe5cd, 0xe678, 0xe4a8, 0xe843, 0xe4b8, 0xe836, 0xe18a, 0xe696, 0xe0a9,
0xe26c, 0xddb8, 0xe39d, 0xde99, 0xe243, 0xdaaf, 0xe1e5, 0xd881, 0xe0ee, 0xd600,
0xe096, 0xd4da, 0xe192, 0xd484, 0xe00d, 0xd2f4, 0xdeef, 0xd35e, 0xdf65, 0xd2df,
0xe350, 0xd3f2, 0xe2af, 0xd23d, 0xe2ff, 0xd327, 0xe49e, 0xd3c8, 0xe6bb, 0xd506,
0xe52e, 0xd385, 0xe105, 0xd17d, 0xdf0d, 0xd012, 0xdbf9, 0xcc6a, 0xdb1b, 0xc992,
0xdad7, 0xc682, 0xda7e, 0xc606, 0xd817, 0xc424, 0xd6bc, 0xc362, 0xd8f5, 0xc50d,
0xd8ac, 0xc56c, 0xd856, 0xc688, 0xd7e9, 0xc5b5, 0xd6da, 0xc3bd, 0xd6cc, 0xc2a2,
0xd54e, 0xc11d, 0xd425, 0xc109, 0xd1bc, 0xc0c0, 0xd2f3, 0xc1ec, 0xd28e, 0xbe93,
0xd27b, 0xbdb6, 0xd323, 0xbdd3, 0xd286, 0xbd4f, 0xd192, 0xbdd4, 0xcf57, 0xbe03,
0xcef8, 0xbfcb, 0xcffe, 0xbe82, 0xd23e, 0xbdfb, 0xd201, 0xbeb3, 0xcf2f, 0xbe91,
0xcd5c, 0xbd82, 0xce42, 0xbde8, 0xcfc8, 0xbe94, 0xcef6, 0xbe5a, 0xce57, 0xbed4,
0xd00a, 0xbf68, 0xd208, 0xbfd9, 0xd104, 0xbf16, 0xcff4, 0xbf5b, 0xd014, 0xc05b,
0xd27b, 0xc425, 0xd4ae, 0xc858, 0xd6fb, 0xcb71, 0xd9c6, 0xcd3d, 0xde53, 0xd15a,
0xe449, 0xd655, 0xe912, 0xdb29, 0xed9b, 0xe0dc, 0xf1b2, 0xe6ab, 0xf76b, 0xedcf,
0xfce5, 0xf203, 0xff84, 0xf4a6, 0xffdd, 0xf5c0, 0xff22, 0xf594, 0xff5a, 0xf6f1,
0xfeed, 0xf86e, 0x00c2, 0xfa59, 0x02ba, 0xf9a5, 0x0265, 0xf8b5, 0x02b9, 0xf9b3,
0x01f6, 0xf9a9, 0x0201, 0xfa64, 0x01bd, 0xf94b, 0x0278, 0xf874, 0x02b5, 0xf78d,
0x03d9, 0xf8cf, 0x02a9, 0xf8ad, 0x003a, 0xf763, 0xff9c, 0xf754, 0xff5e, 0xf6ca,
0xff61, 0xf696, 0xfd96, 0xf42f, 0xfcf0, 0xf2b0, 0xfb5c, 0xf1d2, 0xfc7e, 0xf3e8,
0xfcbd, 0xf2d1, 0xff1f, 0xf4bd, 0xfff7, 0xf756, 0x012a, 0xf9cf, 0x0235, 0xfac6,
0x0258, 0xfad2, 0x0533, 0xfdbb, 0x081f, 0x0143, 0x0969, 0x0353, 0x07b8, 0x030b,
0x0895, 0x055a, 0x091f, 0x0502, 0x09e8, 0x0624, 0x0ace, 0x076d, 0x0c48, 0x08e4,
0x0cdd, 0x08ea, 0x0cef, 0x081b, 0x0aef, 0x0741, 0x0ae2, 0x08b8, 0x0cba, 0x0abd,
0x0dcd, 0x0bc2, 0x103f, 0x0c2c, 0x1015, 0x0a88, 0x0e6e, 0x0a1c, 0x0d45, 0x0a66,
0x0d0a, 0x0ad8, 0x0d8d, 0x0b23, 0x0d3f, 0x0915, 0x0d0a, 0x05c3, 0x0ca5, 0x0559,
0x0c02, 0x0582, 0x0abe, 0x05d9, 0x09ae, 0x052f, 0x0a38, 0x04ad, 0x0b4e, 0x05ae,
0x0b73, 0x04ae, 0x0c36, 0x0396, 0x0b88, 0x02f6, 0x0a25, 0x0388, 0x0a67, 0x0329,
0x090d, 0x0086, 0x0817, 0xff6c, 0x06cd, 0xff86, 0x0807, 0x004e, 0x09ab, 0x00e3,
0x0b05, 0x024f, 0x0bcb, 0x030b, 0x0a6d, 0x0164, 0x0b7c, 0x00a5, 0x0b19, 0x00c9,
0x0ae7, 0x0272, 0x0a73, 0x02d3, 0x0cc0, 0x04e0, 0x0c0c, 0x03c3, 0x0936, 0x01bd,
0x08f6, 0x0152, 0x0b7c, 0x028f, 0x0c03, 0x02a0, 0x0a49, 0x01ef, 0x09ac, 0x02e5,
0x0966, 0x01eb, 0x08fe, 0x00e4, 0x0839, 0x01a0, 0x0655, 0x0151, 0x0661, 0x0102,
0x0660, 0x0183, 0x037f, 0xff42, 0x05e5, 0xfed6, 0x06c3, 0xfdc1, 0x05b8, 0xfee0,
0x0446, 0xff8f, 0x03a2, 0xff51, 0x02db, 0xfeee, 0x02f6, 0xfe6e, 0x0432, 0xfe99,
0x0555, 0xffa1, 0x056d, 0x00a0, 0x0486, 0x00ad, 0x04ad, 0x0213, 0x0589, 0x0306,
0x0746, 0x03fd, 0x074b, 0x0479, 0x068a, 0x041a, 0x0759, 0x046a, 0x0873, 0x04a3,
0x069e, 0x049a, 0x0520, 0x0699, 0x0679, 0x085a, 0x08d1, 0x09bd, 0x08bf, 0x0909,
0x07f7, 0x073f, 0x0928, 0x0843, 0x0cba, 0x0a14, 0x0cfc, 0x0b69, 0x0c26, 0x0d7b,
0x0b7e, 0x0e76, 0x0b5b, 0x0ede, 0x0c86, 0x0e6e, 0x0deb, 0x1001, 0x0fa7, 0x12c5,
0x0f4b, 0x1563, 0x0ec7, 0x1628, 0x0f20, 0x1636, 0x0eb0, 0x14eb, 0x0c95, 0x1177,
0x0bb3, 0x1080, 0x0be4, 0x107c, 0x0bd3, 0x1136, 0x0b10, 0x1016, 0x0954, 0x0e0d,
0x09f2, 0x103e, 0x0b66, 0x1233, 0x0ecc, 0x146c, 0x0f38, 0x13b5, 0x0e7e, 0x1350,
0x0d5c, 0x1339, 0x0d90, 0x148b, 0x0c5f, 0x155c, 0x0b3e, 0x14ee, 0x0c17, 0x14ef,
0x0e42, 0x1549, 0x0fe0, 0x1624, 0x0ffe, 0x16c1, 0x0f62, 0x171b, 0x10ab, 0x17e2,
0x108c, 0x16cb, 0x0f64, 0x1624, 0x0f49, 0x1523, 0x0e98, 0x145e, 0x0db2, 0x1499,
0x08cb, 0x1205, 0x0744, 0x12ed, 0x0664, 0x10f8, 0x0754, 0x0fc3, 0x0999, 0x10bf,
0x0968, 0x1097, 0x0710, 0x10f7, 0x06cd, 0x113f, 0x079a, 0x11b6, 0x0650, 0x114b,
0x035d, 0x0e5d, 0x0286, 0x0e3f, 0x04e1, 0x0fac, 0x069f, 0x0fb8, 0x08d2, 0x114c,
0x086e, 0x1118, 0x0943, 0x130b, 0x086e, 0x128d, 0x0944, 0x130a, 0x0933, 0x125e,
0x07c5, 0x1085, 0x074f, 0x1086, 0x063a, 0x0f92, 0x0582, 0x0eba, 0x0357, 0x0c1f,
0x04d8, 0x0d6a, 0x05f0, 0x0e11, 0x05bb, 0x0d92, 0x0413, 0x0a9b, 0x04dd, 0x0a12,
0x04f0, 0x0ac5, 0x029b, 0x0a3d, 0x0056, 0x08e7, 0x0124, 0x0920, 0x010f, 0x0a74,
0x00b9, 0x0995, 0x013c, 0x08d3, 0x0027, 0x0748, 0x0046, 0x067b, 0x0045, 0x0699,
0x0138, 0x0776, 0x0095, 0x06f9, 0x00a0, 0x0641, 0x0051, 0x0612, 0x0134, 0x0798,
0x01dd, 0x078d, 0x0092, 0x06fa, 0xff8a, 0x06d6, 0xff6e, 0x06de, 0xffa7, 0x0647,
0xfe00, 0x0369, 0xfcbc, 0x01c9, 0xfb8c, 0x007e, 0xfb7e, 0x0140, 0xfbc8, 0x0027,
0xfbc5, 0xfef4, 0xf9ac, 0xfd93, 0xf961, 0xfd91, 0xf9fb, 0xfe64, 0xfa62, 0xfea0,
0xfc5b, 0xffe4, 0xfc0f, 0xfecb, 0xfd18, 0x0052, 0xfca5, 0x0078, 0xf9bc, 0xff64,
0xf837, 0xfed1, 0xf538, 0xfcba, 0xf545, 0xfbf2, 0xf5c4, 0xf99d, 0xf417, 0xf8d4,
0xf3c1, 0xf8cf, 0xf3cf, 0xf90d, 0xf329, 0xf968, 0xf3a8, 0xf871, 0xf5e1, 0xf7c6,
0xf654, 0xf86a, 0xf713, 0xfb93, 0xf814, 0xfd62, 0xf8f5, 0xfc50, 0xf9b7, 0xfb12,
0xf75e, 0xfaab, 0xf5db, 0xfbe4, 0xf4b8, 0xfb43, 0xf4c6, 0xfab3, 0xf30d, 0xf910,
0xf241, 0xf7ad, 0xf2a0, 0xf5b4, 0xf3c4, 0xf566, 0xf420, 0xf541, 0xf544, 0xf5fd,
0xf7a8, 0xf820, 0xf7c7, 0xf8db, 0xf752, 0xfa28, 0xf631, 0xfa54, 0xf6dd, 0xfbca,
0xf881, 0xfcc0, 0xfa2e, 0xfdca, 0xfc05, 0xfe26, 0xfd09, 0xfd40, 0xfe2d, 0xff15,
0xffda, 0x01e5, 0x0045, 0x0369, 0x00a3, 0x04c2, 0x0258, 0x057c, 0x05ba, 0x071d,
0x071d, 0x08cc, 0x069a, 0x0a77, 0x05ae, 0x0b9e, 0x0709, 0x0c7c, 0x0980, 0x0c38,
0x078c, 0x0a73, 0x0768, 0x0bcd, 0x077c, 0x0ae1, 0x09ba, 0x0ba4, 0x0968, 0x0ba4,
0x07bc, 0x0b2b, 0x0764, 0x0ae6, 0x078d, 0x0983, 0x0ace, 0x0b29, 0x09cf, 0x0c63,
0x0885, 0x0b05, 0x08e5, 0x09a9, 0x0af0, 0x09a9, 0x0b89, 0x09e3, 0x0ae3, 0x09fb,
0x0a5a, 0x09b0, 0x0a4d, 0x0ada, 0x08a5, 0x09f3, 0x080f, 0x0816, 0x076e, 0x062b,
0x06b1, 0x04d5, 0x0763, 0x0492, 0x0741, 0x04bb, 0x0597, 0x0438, 0x06d3, 0x04a0,
0x0662, 0x03f2, 0x02a3, 0x016a, 0x00f1, 0xfed8, 0x0119, 0xfd28, 0x0186, 0xfddc,
0x0130, 0xfe87, 0x0086, 0xfe0c, 0x0161, 0xfdf5, 0x028f, 0xfe25, 0x026a, 0xfcdf,
0x038f, 0xfcb3, 0x0134, 0xfa5e, 0xff6e, 0xf929, 0xff13, 0xf994, 0xff7f, 0xfaaa,
0xff0d, 0xfb78, 0xfe2f, 0xfaf3, 0xfc9c, 0xf875, 0xfb66, 0xf6c0, 0xfc37, 0xf693,
0xfc5a, 0xf638, 0xfdf3, 0xf81c, 0xfd7a, 0xf7a8, 0xfe91, 0xf8b9, 0xfece, 0xf93e,
0xfe4f, 0xfa05, 0xfe4c, 0xfa49, 0xfd18, 0xf7fb, 0xfb36, 0xf5ba, 0xf92e, 0xf3b4,
0xf8ba, 0xf2d1, 0xf872, 0xf2ad, 0xf93b, 0xf2f3, 0xfa78, 0xf2ac, 0xfa69, 0xf2bd,
0xf75b, 0xf0c8, 0xf77a, 0xf0b2, 0xfa2b, 0xf287, 0xfadd, 0xf42d, 0xfae9, 0xf492,
0xfb51, 0xf5a8, 0xfcf5, 0xf7da, 0xfe4c, 0xf864, 0x0030, 0xf9cc, 0x0123, 0xfbc4,
0x0216, 0xfe73, 0x0296, 0x004f, 0x028e, 0x0156, 0x01a0, 0x00c9, 0x00db, 0x0229,
0x00c1, 0x03b2, 0x015b, 0x0306, 0x02dc, 0x02ab, 0x02a5, 0x021f, 0x01ae, 0x01dd,
0x00da, 0x01d7, 0x00b9, 0x02f1, 0xfda1, 0x0198, 0xfcd3, 0x0058, 0xfc5b, 0xfce6,
0xfe74, 0xfd25, 0xfe4e, 0xfd17, 0xfc26, 0xfc30, 0xfc20, 0xfc68, 0xfb08, 0xfae6,
0xfd5f, 0xfc41, 0xfcee, 0xfc21, 0xffe8, 0xff44, 0x0258, 0x002a, 0x03ea, 0x0234,
0x03bc, 0x0378, 0x0274, 0x02e8, 0x02c0, 0x0289, 0x00f6, 0x0048, 0x019b, 0x0068,
0x03d8, 0x01c2, 0x059e, 0x0336, 0x0614, 0x05ba, 0x05af, 0x06a5, 0x0792, 0x0834,
0x0716, 0x076a, 0x0864, 0x07cc, 0x0af9, 0x09fd, 0x0bf3, 0x0a7a, 0x0cbe, 0x0bb0,
0x0d3d, 0x0c11, 0x0efc, 0x0dc6, 0x0f23, 0x0eb6, 0x0f57, 0x1052, 0x1002, 0x119b,
0x1283, 0x138b, 0x143d, 0x156a, 0x1692, 0x172d, 0x192e, 0x190b, 0x1b9e, 0x1ada,
0x1f38, 0x1e92, 0x1e91, 0x1f72, 0x1e54, 0x210c, 0x200a, 0x21c8, 0x2266, 0x21d2,
0x22e0, 0x221a, 0x2168, 0x22cc, 0x20d4, 0x2383, 0x2183, 0x22bc, 0x223b, 0x22c8,
0x2338, 0x23ae, 0x22bf, 0x2417, 0x21ba, 0x2459, 0x20e8, 0x23e6, 0x212c, 0x22bb,
0x2067, 0x226d, 0x1e38, 0x2142, 0x1e4c, 0x2101, 0x1ef2, 0x2119, 0x1f48, 0x215e,
0x1e8a, 0x21a8, 0x1cf6, 0x1f88, 0x1b75, 0x1d91, 0x1c04, 0x1dba, 0x1da6, 0x2021,
0x1b65, 0x1fbf, 0x1a1b, 0x1ead, 0x1bb7, 0x1e0d, 0x1db3, 0x1f04, 0x1c54, 0x1ed1,
0x19f7, 0x1daa, 0x19a5, 0x1e0f, 0x19eb, 0x1e23, 0x1aea, 0x1dac, 0x1bc4, 0x1d59,
0x1b56, 0x1de9, 0x1c3f, 0x2098, 0x1d56, 0x2188, 0x1c47, 0x2030, 0x1b28, 0x1f91,
0x1a92, 0x1ea5, 0x1a81, 0x1f18, 0x19d7, 0x1f6f, 0x1a7a, 0x2051, 0x1a37, 0x1f43,
0x1a4a, 0x1df8, 0x17f0, 0x1ad4, 0x177b, 0x1ae4, 0x1878, 0x1c65, 0x177a, 0x1c8d,
0x1541, 0x1c46, 0x133c, 0x1b23, 0x112f, 0x19e4, 0x11af, 0x19d4, 0x13a7, 0x1a31,
0x12a5, 0x19ec, 0x1315, 0x19ea, 0x1454, 0x1a50, 0x15fd, 0x1c5b, 0x1709, 0x1de7,
0x14d2, 0x1d66, 0x123e, 0x1c04, 0x1249, 0x1ca8, 0x1341, 0x1d37, 0x15d8, 0x1e2c,
0x1657, 0x1ea1, 0x146b, 0x1eb3, 0x13cd, 0x1f9b, 0x1408, 0x1fbc, 0x12ae, 0x1d81,
0x1208, 0x1b22, 0x13b7, 0x1c78, 0x14d2, 0x1f1e, 0x1292, 0x1f45, 0x0f5d, 0x1d26,
0x0ebf, 0x1b7f, 0x0dc6, 0x1b4e, 0x0ddd, 0x1bc3, 0x0ebe, 0x1c09, 0x0f84, 0x1d48,
0x10ac, 0x1de2, 0x10ff, 0x1c6e, 0x0ff1, 0x1be4, 0x0da6, 0x1c3f, 0x0b02, 0x1c23,
0x0abf, 0x1bc3, 0x0ccf, 0x1b49, 0x0ef4, 0x1bc8, 0x0f20, 0x1c95, 0x0e4e, 0x1c39,
0x0d4f, 0x1afa, 0x0dec, 0x1ab6, 0x0d21, 0x1924, 0x0c14, 0x17e5, 0x0af3, 0x1652,
0x0ab8, 0x1706, 0x0bef, 0x1865, 0x0b1b, 0x171d, 0x0bd9, 0x17de, 0x0b8a, 0x1710,
0x0bf3, 0x167d, 0x0cae, 0x16d6, 0x0cfa, 0x16da, 0x0d44, 0x16e0, 0x0bfb, 0x15eb,
0x0a5b, 0x143b, 0x0845, 0x12ce, 0x07b3, 0x124e, 0x0559, 0x10a1, 0x05b1, 0x1126,
0x06b2, 0x1003, 0x0613, 0x0e3a, 0x0537, 0x0d7a, 0x05af, 0x0e0a, 0x064f, 0x0ec9,
0x061c, 0x0e18, 0x0641, 0x0ea1, 0x04a4, 0x0f3c, 0x0476, 0x0e42, 0x0419, 0x0c62,
0x0348, 0x0c49, 0x0321, 0x0cc7, 0x0350, 0x0d3c, 0x03b1, 0x0c30, 0x032b, 0x098b,
0x016e, 0x090c, 0x014d, 0x08c5, 0x0158, 0x07b4, 0x01cc, 0x098b, 0x01bd, 0x0a05,
0xfeb1, 0x07b6, 0xfd4b, 0x05be, 0xfc28, 0x03dd, 0xfb58, 0x0461, 0xf9a8, 0x03e7,
0xf9c4, 0x0340, 0xfa20, 0x020a, 0xf8da, 0x001a, 0xf80b, 0xff84, 0xf87f, 0xff64,
0xf8a4, 0xff18, 0xf747, 0xfeed, 0xf559, 0xfd93, 0xf4a3, 0xfc18, 0xf6b0, 0xfc78,
0xf6cb, 0xfcb3, 0xf849, 0xfe3f, 0xf919, 0xfdee, 0xf8ed, 0xfd63, 0xf7bb, 0xfc49,
0xf806, 0xfc0b, 0xf7c0, 0xfc87, 0xf7d1, 0xfbf6, 0xf8a8, 0xfb19, 0xf8cc, 0xfc7c,
0xf869, 0xfe09, 0xf76e, 0xfdc5, 0xf897, 0xfdf8, 0xf8d5, 0xfd15, 0xfa47, 0xfce4,
0xfa2f, 0xfc4d, 0xf836, 0xfbc7, 0xf4e1, 0xf9f4, 0xf4c0, 0xfa3a, 0xf5ab, 0xfa08,
0xf5d0, 0xf98c, 0xf3c3, 0xf7ec, 0xf206, 0xf5ed, 0xf1ab, 0xf544, 0xf121, 0xf486,
0xf0b8, 0xf3f5, 0xefa1, 0xf200, 0xed97, 0xeefd, 0xec5d, 0xeea5, 0xebb6, 0xef62,
0xead0, 0xee32, 0xebf5, 0xed36, 0xec66, 0xecfd, 0xecdd, 0xee33, 0xeac2, 0xede0,
0xe928, 0xec22, 0xe924, 0xeaa6, 0xe9fb, 0xea1d, 0xe928, 0xe8d5, 0xe909, 0xe90b,
0xe781, 0xe8a9, 0xe68b, 0xe963, 0xe5ad, 0xe886, 0xe460, 0xe723, 0xe4c0, 0xe619,
0xe316, 0xe51b, 0xe14e, 0xe4ff, 0xe18e, 0xe547, 0xe2df, 0xe56e, 0xe29a, 0xe3a6,
0xe214, 0xe28d, 0xe09e, 0xe183, 0xdedd, 0xe1f2, 0xddb6, 0xe145, 0xdefe, 0xe0af,
0xdfba, 0xe129, 0xdf28, 0xe0f7, 0xddf9, 0xdf33, 0xdd13, 0xdea8, 0xdc31, 0xde1d,
0xdb2d, 0xdc3e, 0xdd23, 0xdcb8, 0xddd3, 0xde35, 0xde4d, 0xe00a, 0xddf7, 0xe02f,
0xe03c, 0xe1fc, 0xe1d3, 0xe203, 0xe3f2, 0xe3f2, 0xe46c, 0xe4f1, 0xe22f, 0xe2cb,
0xe161, 0xe181, 0xe02e, 0xe093, 0xe051, 0xe138, 0xe03c, 0xdf2f, 0xe10d, 0xde05,
0xe0c2, 0xde45, 0xe238, 0xe009, 0xe21c, 0xdf51, 0xe0c4, 0xde12, 0xe004, 0xdd03,
0xe0c5, 0xdd45, 0xe1ea, 0xdd39, 0xe1a3, 0xdb0b, 0xe10f, 0xd8db, 0xe047, 0xd843,
0xe100, 0xd9ec, 0xe143, 0xda00, 0xe1f4, 0xda65, 0xe3a2, 0xda7c, 0xe298, 0xd83d,
0xe109, 0xd576, 0xe08f, 0xd332, 0xe212, 0xd348, 0xe29a, 0xd337, 0xdfec, 0xd16c,
0xdfa6, 0xd1e3, 0xdf0e, 0xd0b7, 0xe010, 0xd0fb, 0xe034, 0xcfd8, 0xdfcd, 0xcea9,
0xe064, 0xcf58, 0xde1d, 0xce7f, 0xdc04, 0xcc48, 0xdbc2, 0xc92e, 0xdbf5, 0xc86b,
0xdb54, 0xc867, 0xd99c, 0xc7a9, 0xd9cd, 0xc6e3, 0xdb44, 0xc69f, 0xdb25, 0xc671,
0xdb6c, 0xc710, 0xda28, 0xc53c, 0xd8af, 0xc363, 0xd4bd, 0xc104, 0xd45f, 0xc0c6,
0xd66e, 0xc202, 0xd4e5, 0xc0dd, 0xd388, 0xbed0, 0xd3af, 0xbd45, 0xd570, 0xbedd,
0xd529, 0xc002, 0xd6a4, 0xc07f, 0xd55e, 0xbf76, 0xd614, 0xc082, 0xd541, 0xbf84,
0xd62f, 0xc06d, 0xd665, 0xc01e, 0xd4ab, 0xc0cf, 0xd3ab, 0xc0c0, 0xd192, 0xbeac,
0xd292, 0xbfcf, 0xd299, 0xc03c, 0xd338, 0xc0d3, 0xd160, 0xbdb2, 0xd0aa, 0xbc58,
0xce6a, 0xbb56, 0xce0a, 0xbc6c, 0xcd45, 0xbc69, 0xcdc4, 0xbd65, 0xcf9e, 0xbe25,
0xd122, 0xbf38, 0xd27b, 0xc14a, 0xd2f4, 0xc202, 0xd48e, 0xc425, 0xd6d0, 0xc67a,
0xd8c7, 0xc7e9, 0xd7f8, 0xc85a, 0xd8fe, 0xcaa7, 0xdc83, 0xcdf8, 0xe0d3, 0xd0ed,
0xe152, 0xd1d9, 0xe30b, 0xd544, 0xe3bb, 0xd722, 0xe5ce, 0xd996, 0xeb0d, 0xde67,
0xed5e, 0xe042, 0xee8d, 0xe1e5, 0xee32, 0xe198, 0xf0a4, 0xe387, 0xf2bc, 0xe646,
0xf395, 0xe917, 0xf44d, 0xeb4d, 0xf60f, 0xed4b, 0xf876, 0xef51, 0xfa12, 0xf06a,
0xfb7a, 0xf295, 0xfbbb, 0xf38b, 0xfb39, 0xf375, 0xfc92, 0xf492, 0xfbd0, 0xf46c,
0xfbb7, 0xf4e8, 0xfc14, 0xf5c5, 0xfc10, 0xf67c, 0xfcb7, 0xf761, 0xfd38, 0xf6b2,
0xfea7, 0xf7ca, 0xff38, 0xf99c, 0x003c, 0xfa72, 0x026b, 0xfb5c, 0x03d4, 0xfb33,
0x0513, 0xfd03, 0x05b9, 0xff0f, 0x0431, 0xfeca, 0x0518, 0xff8f, 0x0782, 0x0136,
0x0a2e, 0x044e, 0x0a24, 0x0545, 0x0b7c, 0x065e, 0x0c8a, 0x06a1, 0x0c09, 0x075e,
0x0c01, 0x074f, 0x0cc3, 0x0776, 0x0e7a, 0x091f, 0x0cac, 0x0878, 0x0b95, 0x088f,
0x0883, 0x071a, 0x08be, 0x0783, 0x0b75, 0x0867, 0x0d47, 0x09b8, 0x0e40, 0x0b06,
0x0de0, 0x0a84, 0x0c88, 0x08a2, 0x0c5a, 0x0887, 0x0d90, 0x08f2, 0x0df6, 0x096c,
0x0d8b, 0x0a2c, 0x0d06, 0x09f9, 0x0f91, 0x0b4b, 0x106c, 0x0bbc, 0x1006, 0x0b5a,
0x0f6f, 0x0a7b, 0x0f01, 0x09de, 0x0fdd, 0x09a2, 0x1146, 0x097a, 0x1085, 0x08ee,
0x0efb, 0x093d, 0x0f27, 0x092f, 0x0f77, 0x0948, 0x0e1b, 0x08b0, 0x0d34, 0x0878,
0x0df4, 0x08a4, 0x0e01, 0x075b, 0x0e9d, 0x0791, 0x0d33, 0x05e4, 0x0b4a, 0x04ce,
0x0cd7, 0x05f0, 0x0ec6, 0x0674, 0x104f, 0x0809, 0x0ee6, 0x08f8, 0x0e3d, 0x0a82,
0x0ea0, 0x0b19, 0x0ebf, 0x0bb6, 0x0e8d, 0x0b4c, 0x0d0e, 0x09cd, 0x0cb6, 0x0913,
0x0cad, 0x0839, 0x0c35, 0x0865, 0x0d03, 0x0972, 0x0c83, 0x0916, 0x0baf, 0x092f,
0x0adc, 0x0943, 0x0af6, 0x0922, 0x0bf4, 0x0950, 0x0b9c, 0x099d, 0x0ab3, 0x09b2,
0x09ef, 0x087e, 0x0a15, 0x07a8, 0x098c, 0x084a, 0x0a2f, 0x0969, 0x08e7, 0x0823,
0x080c, 0x08cb, 0x0638, 0x0824, 0x068c, 0x0832, 0x090f, 0x09e2, 0x0a05, 0x0a88,
0x08b1, 0x0a87, 0x06e3, 0x09f4, 0x07c9, 0x0a27, 0x0951, 0x0ad9, 0x0c52, 0x0db1,
0x0d7a, 0x0f18, 0x0db7, 0x0efa, 0x0c56, 0x0d8e, 0x0a63, 0x0d1c, 0x0b57, 0x0f11,
0x0e72, 0x1191, 0x106f, 0x13af, 0x1067, 0x13a7, 0x1036, 0x13c8, 0x0faf, 0x141c,
0x1032, 0x1404, 0x1068, 0x1340, 0x0fca, 0x1348, 0x0db0, 0x12db, 0x0dae, 0x1353,
0x0d07, 0x1337, 0x0d78, 0x144e, 0x0e2c, 0x14fc, 0x0e09, 0x14db, 0x0ca7, 0x13b9,
0x0c6f, 0x133b, 0x0d43, 0x131c, 0x0c19, 0x130d, 0x0ba7, 0x1418, 0x0dae, 0x14f9,
0x111d, 0x17b9, 0x10f9, 0x1913, 0x1085, 0x19f1, 0x0fae, 0x198f, 0x107f, 0x1a4e,
0x1172, 0x1ac7, 0x12fa, 0x1c71, 0x142f, 0x1db7, 0x13e3, 0x1de3, 0x121b, 0x1bed,
0x125c, 0x1af1, 0x128d, 0x1af2, 0x1245, 0x1ac7, 0x1245, 0x1ab4, 0x0efd, 0x186b,
0x0dac, 0x17e0, 0x0d6b, 0x1768, 0x0db9, 0x174b, 0x0df8, 0x16a8, 0x0f28, 0x1716,
0x10aa, 0x178c, 0x0f1d, 0x1661, 0x0dd8, 0x165b, 0x0edf, 0x171f, 0x0f99, 0x17ba,
0x10b9, 0x185e, 0x106f, 0x1847, 0x0f90, 0x1714, 0x0c7f, 0x147f, 0x0c07, 0x142e,
0x0d8a, 0x145b, 0x0e5c, 0x1540, 0x0f30, 0x16ca, 0x0deb, 0x1555, 0x0b01, 0x1346,
0x0a39, 0x131c, 0x0bee, 0x11cd, 0x0de9, 0x11a0, 0x0dcb, 0x1210, 0x0b6f, 0x11bd,
0x0a0e, 0x10e4, 0x090c, 0x0ee3, 0x09ca, 0x0d8b, 0x09f4, 0x0c52, 0x08e1, 0x0b78,
0x08ab, 0x0bb9, 0x09f4, 0x0d66, 0x08fe, 0x0d87, 0x078e, 0x0d12, 0x076e, 0x0c8e,
0x0a03, 0x0e3d, 0x0a8c, 0x0e30, 0x093f, 0x0d6f, 0x093c, 0x0d76, 0x0a62, 0x0ddc,
0x0a2a, 0x0c9c, 0x077b, 0x09dc, 0x06ff, 0x08d8, 0x052a, 0x0742, 0x0436, 0x0714,
0x0494, 0x0618, 0x0610, 0x062e, 0x05b1, 0x05cf, 0x03fa, 0x057a, 0x04fa, 0x063b,
0x054e, 0x0558, 0x03a3, 0x0433, 0x01ee, 0x0334, 0x033b, 0x0377, 0x03f4, 0x03c6,
0x028d, 0x03c3, 0x008c, 0x0293, 0xfd52, 0x0058, 0xfbc1, 0xfed2, 0xfc87, 0xfe33,
0xfdc1, 0xfe42, 0xfe4e, 0xff7a, 0xfe03, 0x0000, 0xfd58, 0xfe63, 0xfc8a, 0xfd4e,
0xfdd1, 0xfeaa, 0xfd9f, 0xff31, 0xfda6, 0x0099, 0xfd06, 0x0050, 0xfc86, 0xfeea,
0xfc5c, 0xfe63, 0xfc39, 0xfe77, 0xfb8e, 0xfe22, 0xfa1f, 0xfde6, 0xf9d7, 0xfdb8,
0xf986, 0xfc2f, 0xfa21, 0xfbef, 0xf896, 0xfade, 0xf7d4, 0xfb79, 0xf6a5, 0xfa61,
0xf604, 0xf8c0, 0xf58d, 0xf741, 0xf532, 0xf6e5, 0xf5e2, 0xf816, 0xf67a, 0xf890,
0xf6c0, 0xf901, 0xf5d1, 0xf871, 0xf5e6, 0xf807, 0xf5f9, 0xf6b1, 0xf432, 0xf51f,
0xf3c5, 0xf64e, 0xf4b9, 0xf729, 0xf596, 0xf6e7, 0xf70b, 0xf706, 0xf900, 0xf899,
0xf8b5, 0xf860, 0xf82c, 0xf80d, 0xf8e5, 0xf81e, 0xf9ea, 0xf943, 0xf955, 0xf96f,
0xf9fd, 0xf93b, 0xfba7, 0xfa3f, 0xfb7d, 0xfa3e, 0xfc01, 0xfaa6, 0xfb59, 0xfa34,
0xfb19, 0xf9af, 0xfc3a, 0xfa63, 0xfcb5, 0xfc53, 0xfd7e, 0xfded, 0x00b7, 0xff93,
0x0136, 0xff5a, 0x00e8, 0x00a8, 0xff7e, 0x006b, 0xff80, 0x0083, 0x0129, 0x0132,
0x0136, 0x00b5, 0x0256, 0x01cc, 0x019f, 0x0169, 0x0117, 0x014d, 0xff52, 0xfeca,
0x00d9, 0xfeff, 0x02c8, 0xffd2, 0x0392, 0x002c, 0x02a5, 0x0093, 0x01ff, 0x00f2,
0x0329, 0x00e3, 0x0413, 0x0098, 0x04e3, 0x007c, 0x04e5, 0x00bf, 0x062d, 0x0236,
0x0708, 0x02ff, 0x08ab, 0x0550, 0x08fa, 0x0618, 0x0a32, 0x07fa, 0x0a3c, 0x079d,
0x0adf, 0x06de, 0x0a9a, 0x05f1, 0x0a31, 0x05a6, 0x0a47, 0x04d5, 0x0a27, 0x036a,
0x09b7, 0x0365, 0x07f4, 0x030e, 0x0746, 0x0249, 0x067d, 0x012c, 0x0722, 0x012a,
0x0775, 0xffec, 0x07af, 0xff75, 0x0679, 0xfeda, 0x0530, 0xfe67, 0x04d1, 0xfe98,
0x0465, 0xfdf3, 0x0506, 0xfd10, 0x0539, 0xfce6, 0x05c0, 0xfd8f, 0x05cb, 0xfe0d,
0x03f4, 0xfd3f, 0x0346, 0xfcd2, 0x02c6, 0xfc5f, 0x0484, 0xfc7c, 0x0510, 0xfbce,
0x043e, 0xfbb8, 0x033b, 0xfbf4, 0x03c4, 0xfcf4, 0x047f, 0xfbcd, 0x0394, 0xfad2,
0x0312, 0xfb7f, 0x036f, 0xfc44, 0x0379, 0xfd6f, 0x02b0, 0xfdb2, 0x01d4, 0xfce0,
0x0376, 0xfd1d, 0x0283, 0xfbbb, 0x016a, 0xfb4e, 0x0066, 0xf9af, 0xff6a, 0xf968,
0xff6e, 0xfa7d, 0x0067, 0xfb6d, 0x025d, 0xfcb7, 0x01cf, 0xfbba, 0x0204, 0xfc94,
0x01e3, 0xfd8e, 0x0409, 0xfff5, 0x050e, 0x0083, 0x0662, 0x027f, 0x060b, 0x02cc,
0x04bc, 0x0384, 0x0371, 0x03b5, 0x03bf, 0x040e, 0x0563, 0x0483, 0x04ca, 0x047a,
0x04d6, 0x055d, 0x0476, 0x04de, 0x0436, 0x0504, 0x0451, 0x0471, 0x04d4, 0x0497,
0x03e0, 0x03d6, 0x026a, 0x035f, 0x00cf, 0x0282, 0x00ec, 0x023d, 0x0159, 0x02f3,
0x0173, 0x03e3, 0x01f6, 0x03e4, 0x0306, 0x0383, 0x04dd, 0x0554, 0x04a7, 0x0619,
0x05ea, 0x07ef, 0x060e, 0x07fd, 0x06ec, 0x07bd, 0x0733, 0x0751, 0x076a, 0x0650,
0x080f, 0x0642, 0x0710, 0x067b, 0x0562, 0x07a6, 0x0532, 0x08b2, 0x0739, 0x081e,
0x0954, 0x07cc, 0x0a57, 0x0968, 0x0895, 0x09a6, 0x065f, 0x08b6, 0x046f, 0x0773,
0x0622, 0x07e4, 0x0835, 0x0919, 0x080e, 0x09b2, 0x082d, 0x0ad8, 0x094d, 0x0cff,
0x0915, 0x0d48, 0x0975, 0x0db0, 0x08ee, 0x0d13, 0x08aa, 0x0d5a, 0x0881, 0x0e34,
0x0975, 0x0f1d, 0x0b7d, 0x107a, 0x0d9f, 0x11c0, 0x0f90, 0x1310, 0x0f10, 0x138f,
0x0f83, 0x14f5, 0x0fe3, 0x1578, 0x1124, 0x1592, 0x12a3, 0x162d, 0x13c7, 0x17bc,
0x1396, 0x1825, 0x1309, 0x17dd, 0x137a, 0x1865, 0x147c, 0x19e7, 0x15ad, 0x1ac7,
0x15bf, 0x1b6d, 0x159d, 0x1c08, 0x175f, 0x1d5b, 0x1896, 0x1e8f, 0x1950, 0x1fac,
0x19aa, 0x2084, 0x1a9e, 0x22b1, 0x1b4f, 0x23f1, 0x1aa5, 0x2350, 0x19c7, 0x223d,
0x18f1, 0x21d8, 0x1979, 0x22d2, 0x1908, 0x21d6, 0x1a0e, 0x2205, 0x1aad, 0x21dc,
0x1a22, 0x218d, 0x1a1a, 0x218b, 0x1930, 0x20a5, 0x18e2, 0x2046, 0x1900, 0x20bb,
0x1b86, 0x2426, 0x1c5d, 0x25a6, 0x1bbc, 0x25d3, 0x1cd6, 0x2642, 0x1c4c, 0x257a,
0x1b86, 0x2487, 0x1a7a, 0x2294, 0x1a70, 0x236e, 0x1abb, 0x24e1, 0x1b60, 0x2526,
0x1c4d, 0x24d7, 0x1c11, 0x2406, 0x1a7f, 0x238a, 0x1a00, 0x23d6, 0x1927, 0x2365,
0x18d6, 0x230c, 0x19ba, 0x22d3, 0x19a9, 0x22dc, 0x19a4, 0x23e8, 0x1921, 0x24bd,
0x184a, 0x24c6, 0x1868, 0x236b, 0x1899, 0x2113, 0x1806, 0x2156, 0x1674, 0x21c1,
0x1593, 0x21b5, 0x164e, 0x2156, 0x1635, 0x20fe, 0x16c2, 0x21de, 0x17d0, 0x22e8,
0x18ac, 0x23d2, 0x17b6, 0x21fd, 0x1780, 0x2134, 0x1766, 0x20fb, 0x1708, 0x2199,
0x1624, 0x2259, 0x1565, 0x2353, 0x1553, 0x237b, 0x1687, 0x22d0, 0x1701, 0x2256,
0x15b5, 0x21b7, 0x1353, 0x208d, 0x145b, 0x21d4, 0x1504, 0x226a, 0x1434, 0x219a,
0x13b9, 0x209a, 0x11ff, 0x1edd, 0x11d7, 0x1f5e, 0x0e8a, 0x1dea, 0x0cb8, 0x1ca3,
0x0d4f, 0x1b90, 0x0f7c, 0x1cbb, 0x0f1e, 0x1c56, 0x0e1a, 0x1c05, 0x0ed3, 0x1dad,
0x0eba, 0x1d19, 0x0eb4, 0x1d1f, 0x0d57, 0x1c8b, 0x0d1e, 0x1cd3, 0x0e59, 0x1d82,
0x0ff3, 0x1dc3, 0x109c, 0x1d2f, 0x0f6a, 0x1b80, 0x0df7, 0x1ac2, 0x0d8b, 0x1a52,
0x0d3d, 0x1a13, 0x0daf, 0x1a3a, 0x0eb7, 0x1a47, 0x0d0d, 0x189e, 0x09ad, 0x1679,
0x0957, 0x1561, 0x0a55, 0x151c, 0x0b31, 0x14d0, 0x0ad7, 0x137a, 0x09b5, 0x136a,
0x09c1, 0x13cb, 0x09d5, 0x130e, 0x08bd, 0x11a5, 0x08a6, 0x118f, 0x0927, 0x11a3,
0x0924, 0x11a2, 0x072b, 0x1009, 0x05b9, 0x0e2b, 0x0697, 0x0d53, 0x072c, 0x0d5b,
0x062a, 0x0d48, 0x0307, 0x0a60, 0x0279, 0x087a, 0x0268, 0x0687, 0x01db, 0x0637,
0x0119, 0x05e3, 0x0184, 0x05f9, 0x012b, 0x0537, 0x0093, 0x03d3, 0x00d4, 0x031d,
0x0126, 0x0385, 0x00ce, 0x047b, 0xff18, 0x032f, 0xff0e, 0x02df, 0xff2b, 0x0258,
0xff16, 0x0293, 0xfdfd, 0x01d2, 0xfbf0, 0x003a, 0xfa60, 0xffb0, 0xf8c6, 0xfe00,
0xf9fa, 0xfd91, 0xf8cd, 0xfbbb, 0xf6d7, 0xfac3, 0xf798, 0xfb5b, 0xf764, 0xfa17,
0xf808, 0xf9c9, 0xf731, 0xf936, 0xf6d9, 0xf9db, 0xf657, 0xf989, 0xf686, 0xf964,
0xf6e1, 0xf97d, 0xf6fd, 0xf99b, 0xf6b9, 0xf914, 0xf581, 0xf74f, 0xf41a, 0xf5ce,
0xf486, 0xf556, 0xf5a2, 0xf59c, 0xf5af, 0xf57a, 0xf4da, 0xf54b, 0xf51a, 0xf642,
0xf462, 0xf5de, 0xf38b, 0xf5f3, 0xf470, 0xf5f3, 0xf447, 0xf4c7, 0xf3eb, 0xf452,
0xf153, 0xf1f9, 0xf09d, 0xf1a5, 0xf07a, 0xf0bf, 0xf11e, 0xf0fe, 0xf221, 0xf1ff,
0xf1cd, 0xf208, 0xf0fd, 0xf17c, 0xf047, 0xf030, 0xf053, 0xefa6, 0xf0d4, 0xef00,
0xf025, 0xee4f, 0xeedd, 0xee35, 0xef09, 0xef0c, 0xee14, 0xedbe, 0xefaf, 0xee57,
0xf0a1, 0xee0c, 0xef16, 0xece2, 0xec06, 0xebe7, 0xea7a, 0xea41, 0xeaef, 0xe884,
0xe9c8, 0xe684, 0xe819, 0xe5f9, 0xe859, 0xe698, 0xe8c8, 0xe6f4, 0xe7c1, 0xe636,
0xe5a9, 0xe46e, 0xe41b, 0xe314, 0xe47b, 0xe32e, 0xe4d8, 0xe34e, 0xe55d, 0xe2e8,
0xe454, 0xe20b, 0xe2f9, 0xe110, 0xe284, 0xe00b, 0xe29e, 0xe02c, 0xe1b5, 0xdf8e,
0xe1c8, 0xdf70, 0xe15c, 0xdf2c, 0xdfe9, 0xdecc, 0xde06, 0xdde5, 0xde32, 0xdd74,
0xdef1, 0xdcfa, 0xdebf, 0xdcd6, 0xdfe1, 0xde23, 0xe04b, 0xde02, 0xdf74, 0xddf5,
0xde73, 0xde48, 0xddd7, 0xdd5d, 0xdea2, 0xdc87, 0xdfa4, 0xdc15, 0xdf95, 0xdc72,
0xe0bb, 0xdeb6, 0xdf5c, 0xdedf, 0xdecf, 0xdf29, 0xe0c9, 0xdf13, 0xe123, 0xde39,
0xdf55, 0xdcda, 0xdf78, 0xdd9f, 0xdfdb, 0xde44, 0xdfd5, 0xdd05, 0xdefa, 0xdb78,
0xdf0a, 0xdac7, 0xde71, 0xd9d6, 0xdbfd, 0xd818, 0xdbc1, 0xd7ea, 0xdd7f, 0xd803,
0xded4, 0xd7a4, 0xdf9f, 0xd79a, 0xde4f, 0xd739, 0xdde2, 0xd829, 0xde4d, 0xd765,
0xde14, 0xd675, 0xddaa, 0xd5d7, 0xdd4c, 0xd47f, 0xde74, 0xd526, 0xdf09, 0xd4d4,
0xded9, 0xd3d4, 0xdf95, 0xd3f6, 0xdf72, 0xd30f, 0xdde6, 0xd0b8, 0xdde6, 0xd00a,
0xdcf0, 0xce78, 0xdcca, 0xcde6, 0xdd41, 0xcdb3, 0xdc77, 0xcd6e, 0xdbb1, 0xcd2c,
0xdb69, 0xcb21, 0xdc6f, 0xc9e3, 0xdcd8, 0xc9fc, 0xdb9f, 0xca17, 0xda08, 0xc909,
0xd8b3, 0xc816, 0xd942, 0xc77a, 0xd9f1, 0xc6b4, 0xd969, 0xc5c8, 0xd6f6, 0xc430,
0xd671, 0xc484, 0xd875, 0xc4ff, 0xd904, 0xc496, 0xd9be, 0xc50d, 0xd925, 0xc515,
0xda66, 0xc68a, 0xdbad, 0xc68d, 0xda28, 0xc4de, 0xd8fd, 0xc3fb, 0xd74a, 0xc249,
0xd656, 0xc17a, 0xd5c8, 0xc119, 0xd5c8, 0xc171, 0xd670, 0xc251, 0xd799, 0xc2fb,
0xd82c, 0xc352, 0xd683, 0xc312, 0xd47f, 0xc206, 0xd4da, 0xc111, 0xd6a2, 0xc185,
0xd5cd, 0xc12f, 0xd576, 0xc21c, 0xd55c, 0xc27d, 0xd533, 0xc2f3, 0xd5c3, 0xc340,
0xd58b, 0xc234, 0xd61d, 0xc2b5, 0xd566, 0xc170, 0xd4e6, 0xc129, 0xd5e0, 0xc204,
0xd696, 0xc2a5, 0xd72b, 0xc405, 0xd6cd, 0xc48b, 0xd66c, 0xc63f, 0xd6a1, 0xc7bf,
0xd771, 0xc845, 0xd9cc, 0xc9b0, 0xdb8a, 0xcb16, 0xdc1e, 0xcc63, 0xdd41, 0xce48,
0xde04, 0xcf64, 0xde27, 0xcfb6, 0xdec7, 0xd0cd, 0xdfc8, 0xd223, 0xe067, 0xd2f2,
0xe078, 0xd40a, 0xe1b3, 0xd6c6, 0xe430, 0xd946, 0xe57c, 0xd9e7, 0xe65f, 0xda74,
0xe7ae, 0xdc6d, 0xe9fa, 0xde8f, 0xeae3, 0xdfd8, 0xeb52, 0xe223, 0xecf1, 0xe457,
0xedab, 0xe573, 0xef32, 0xe71c, 0xef6f, 0xe7a1, 0xf10b, 0xe948, 0xf256, 0xeb10,
0xf34e, 0xed2c, 0xf5fa, 0xf056, 0xf76b, 0xf173, 0xf80b, 0xf194, 0xf9c7, 0xf255,
0xfa85, 0xf3c0, 0xfa7b, 0xf52f, 0xf9dd, 0xf597, 0xfa94, 0xf6a6, 0xfcae, 0xf740,
0xfce0, 0xf687, 0xfd47, 0xf758, 0xfd89, 0xf915, 0x0015, 0xfb8b, 0x009d, 0xfb7b,
0x0139, 0xfcc5, 0x02b7, 0xfde4, 0x0390, 0xfefe, 0x031b, 0xffb6, 0x038c, 0x0017,
0x05d4, 0x017d, 0x06d3, 0x0233, 0x070a, 0x02b2, 0x075e, 0x02fd, 0x0904, 0x03bd,
0x0a76, 0x04ad, 0x095e, 0x04b6, 0x08b6, 0x05c0, 0x095f, 0x0709, 0x0976, 0x0790,
0x0a91, 0x0852, 0x0a7b, 0x0755, 0x0b56, 0x07af, 0x09f6, 0x06fa, 0x097e, 0x07b4,
0x082c, 0x06c4, 0x0818, 0x0709, 0x08b8, 0x0774, 0x0924, 0x073a, 0x0a56, 0x0790,
0x099e, 0x0750, 0x08b8, 0x0735, 0x07b5, 0x06f8, 0x0966, 0x08ed, 0x0af2, 0x0944,
0x0c4e, 0x0a4f, 0x0c04, 0x09a3, 0x0d0c, 0x097e, 0x0ca1, 0x0915, 0x0c87, 0x0a64,
0x0bf5, 0x0b27, 0x0bf9, 0x0b45, 0x0d52, 0x0bff, 0x0b9a, 0x0ada, 0x0b4b, 0x0a93,
0x0c4f, 0x0b69, 0x0dd5, 0x0d0d, 0x0d0f, 0x0bc5, 0x0c34, 0x09c4, 0x0a9c, 0x0899,
0x0a7c, 0x097c, 0x0ae9, 0x09c4, 0x0c2b, 0x0a92, 0x0cd5, 0x0a61, 0x0cce, 0x0a1c,
0x0cb4, 0x0a7e, 0x0a99, 0x0a50, 0x0adb, 0x0afd, 0x0c98, 0x0b54, 0x0d7d, 0x0b82,
0x0c3c, 0x0b00, 0x0ac9, 0x0aeb, 0x0a27, 0x0ae7, 0x0a85, 0x0ba9, 0x0af8, 0x0ca6,
0x0b85, 0x0ce9, 0x0cbe, 0x0d32, 0x0cd2, 0x0d48, 0x0bf1, 0x0cb4, 0x0c28, 0x0d28,
0x0ba5, 0x0d84, 0x0d14, 0x0f85, 0x0d58, 0x0fe5, 0x0c47, 0x1079, 0x0b12, 0x1035,
0x0ade, 0x0fd2, 0x0c46, 0x104b, 0x0b72, 0x0f1a, 0x0bd8, 0x0ffd, 0x0a8e, 0x0f59,
0x0a32, 0x0fe2, 0x093a, 0x0f77, 0x093f, 0x0f34, 0x090b, 0x0e72, 0x0a66, 0x0ff9,
0x0b87, 0x1130, 0x0a0d, 0x1110, 0x0b26, 0x1255, 0x0ca3, 0x136c, 0x0da6, 0x14bd,
0x0ead, 0x1544, 0x0fdd, 0x1600, 0x0f40, 0x1604, 0x0d1e, 0x1551, 0x0bd3, 0x15b0,
0x0dbf, 0x17de, 0x0ed4, 0x1818, 0x0f40, 0x1839, 0x0e45, 0x1704, 0x0f87, 0x1867,
0x0fc0, 0x18b8, 0x0f24, 0x192a, 0x0f94, 0x19b7, 0x107e, 0x1915, 0x1147, 0x18ac,
0x0f8e, 0x1801, 0x0e14, 0x1871, 0x0d64, 0x1736, 0x0eba, 0x1755, 0x0e34, 0x1783,
0x0e2d, 0x17fa, 0x0f27, 0x1768, 0x0f66, 0x165c, 0x0e54, 0x1621, 0x0d79, 0x16f5,
0x0d55, 0x17d9, 0x0dc2, 0x17b4, 0x0ecc, 0x17cc, 0x0e86, 0x17da, 0x0dbd, 0x175e,
0x0d88, 0x1639, 0x0e1f, 0x15cb, 0x0edd, 0x173e, 0x0fb4, 0x17cc, 0x0f26, 0x160f,
0x0eb3, 0x1512, 0x0e4d, 0x1533, 0x0ea9, 0x15ac, 0x0e9e, 0x152f, 0x0e25, 0x1511,
0x0d06, 0x1471, 0x0c63, 0x14b0, 0x0c24, 0x13d5, 0x0b00, 0x1144, 0x0b84, 0x1102,
0x0b5b, 0x118b, 0x0b88, 0x125d, 0x0d74, 0x133a, 0x0ede, 0x134d, 0x0d7f, 0x1273,
0x0c6f, 0x1202, 0x0c48, 0x11ee, 0x0c8a, 0x1215, 0x0c59, 0x111a, 0x0c43, 0x1056,
0x0c4f, 0x1096, 0x0c43, 0x10c1, 0x0c9b, 0x0fc5, 0x0cec, 0x0e70, 0x0bf5, 0x0d43,
0x0a64, 0x0d2c, 0x0b01, 0x0e73, 0x0b98, 0x0ee6, 0x0d3e, 0x0fe7, 0x0d14, 0x0ece,
0x0c66, 0x0d16, 0x0b16, 0x0b5e, 0x0abb, 0x0bcd, 0x0ade, 0x0d0b, 0x0a7a, 0x0d4a,
0x0aef, 0x0c6e, 0x0a83, 0x0b50, 0x090f, 0x0aec, 0x073a, 0x094e, 0x0865, 0x08ea,
0x0872, 0x082a, 0x079d, 0x07cb, 0x0695, 0x063d, 0x05f2, 0x0588, 0x0571, 0x0582,
0x05b6, 0x0527, 0x0619, 0x0488, 0x0558, 0x03f5, 0x02eb, 0x03ff, 0x0160, 0x03c4,
0x012d, 0x0315, 0x016f, 0x0317, 0x0117, 0x0266, 0xffca, 0x0151, 0xff0b, 0x0016,
0x0075, 0x00d4, 0x00af, 0x0138, 0xfff8, 0x0124, 0x01f2, 0x0318, 0x01f6, 0x0277,
0x00e6, 0x022d, 0xff88, 0x0204, 0xffa8, 0x0287, 0x007f, 0x036e, 0xffe4, 0x02ee,
0xff09, 0x0222, 0xff1b, 0x0240, 0xfef3, 0x01a1, 0xfe6f, 0x00c8, 0xff2b, 0x0188,
0xff49, 0x01b2, 0xff3d, 0x0206, 0xfe5e, 0x01b4, 0xfe4c, 0x023a, 0xffbd, 0x0305,
0x006c, 0x02d8, 0xff2d, 0x01f8, 0xfe92, 0x014d, 0xfd6f, 0xffb9, 0xfdb9, 0xff35,
0xfc56, 0xfec5, 0xfb1b, 0xfeab, 0xfb3f, 0xfda6, 0xfbf6, 0xfd35, 0xfc42, 0xfd9b,
0xfb2c, 0xfdd6, 0xfc4c, 0xff40, 0xfcd4, 0xff59, 0xfd74, 0xff89, 0xfd76, 0xff7f,
0xfefa, 0x005e, 0xfe4a, 0xff39, 0xfd85, 0xff86, 0xfd6f, 0xffa9, 0xfe51, 0xffc9,
0xfe4d, 0xff7c, 0xfe7f, 0x0062, 0xff69, 0x0184, 0x00b3, 0x01fc, 0x0284, 0x02a6,
0x0257, 0x01d9, 0x02cf, 0x0270, 0x0147, 0x0119, 0x007a, 0x0082, 0xff6b, 0x0012,
0x0043, 0x00cd, 0x000c, 0xffd9, 0xffb3, 0xff9d, 0xff72, 0xfff2, 0xff91, 0xffd3,
0x00b4, 0x004a, 0x0174, 0x015f, 0x028a, 0x02ca, 0x0345, 0x025e, 0x0480, 0x01e1,
0x055e, 0x0203, 0x0532, 0x029a, 0x0401, 0x02cf, 0x0499, 0x038f, 0x04ed, 0x0370,
0x0682, 0x0447, 0x0774, 0x0481, 0x07c1, 0x04c9, 0x078f, 0x0487, 0x065e, 0x03af,
0x05bd, 0x03dd, 0x05f9, 0x03cd, 0x07dd, 0x03c6, 0x08f1, 0x041f, 0x087f, 0x049f,
0x07aa, 0x047c, 0x0754, 0x0416, 0x07a4, 0x03d2, 0x08fb, 0x0489, 0x07c1, 0x02d5,
0x0608, 0x00d7, 0x0536, 0xff84, 0x0676, 0x0026, 0x073c, 0x0086, 0x077d, 0x0087,
0x072b, 0xffec, 0x06f8, 0xffee, 0x07b2, 0x00dc, 0x0848, 0x011e, 0x08e4, 0x00b9,
0x0815, 0xff9b, 0x094b, 0x006d, 0x0a0c, 0x00b6, 0x09c5, 0x016e, 0x09e0, 0x026a,
0x0a54, 0x02ad, 0x0b05, 0x02db, 0x0b48, 0x0231, 0x0ad8, 0x01c3, 0x0ab4, 0x0237,
0x0ac9, 0x0208, 0x0ac2, 0x028d, 0x0b8c, 0x03eb, 0x0b1a, 0x0399, 0x0acf, 0x032b,
0x09e8, 0x01fc, 0x09d4, 0x01b9, 0x0996, 0x01ee, 0x092f, 0x0310, 0x09c4, 0x03b6,
0x0995, 0x0287, 0x099c, 0x0343, 0x0a37, 0x0494, 0x0b56, 0x05ea, 0x0b1c, 0x05b2,
0x0b28, 0x0535, 0x0b0a, 0x04de, 0x0bac, 0x0661, 0x0b3c, 0x075a, 0x0ae4, 0x0839,
0x0a90, 0x07fd, 0x0aa5, 0x0776, 0x0b06, 0x06db, 0x0a9a, 0x0606, 0x09dc, 0x06b6,
0x0958, 0x0790, 0x0996, 0x0869, 0x08fa, 0x0784, 0x08d3, 0x0769, 0x0920, 0x07ef,
0x0a09, 0x08c8, 0x0a3f, 0x0959, 0x088f, 0x0828, 0x0897, 0x082c, 0x08f0, 0x088a,
0x092f, 0x08f5, 0x0919, 0x095f, 0x079f, 0x08e8, 0x07c2, 0x08ee, 0x0747, 0x07eb,
0x0896, 0x0948, 0x09b6, 0x0aa7, 0x0acc, 0x0b91, 0x0b7f, 0x0b9c, 0x0b28, 0x0b4e,
0x0c12, 0x0c6f, 0x0bcb, 0x0c23, 0x0c6d, 0x0c80, 0x0bb2, 0x0c02, 0x0bf1, 0x0d47,
0x0c0d, 0x0d42, 0x0caf, 0x0d87, 0x0ca4, 0x0de0, 0x0c19, 0x0d9b, 0x0b9d, 0x0cde,
0x0ad2, 0x0b6b, 0x0af3, 0x0b55, 0x0a5e, 0x0b5d, 0x0b21, 0x0c6f, 0x0abc, 0x0c38,
0x09e1, 0x0c6a, 0x08b5, 0x0c50, 0x095f, 0x0ce4, 0x0ab2, 0x0da4, 0x0c0d, 0x0e24,
0x0ccd, 0x0ee9, 0x0c09, 0x0e3b, 0x0b85, 0x0d6e, 0x0ac9, 0x0d8d, 0x0932, 0x0d6b,
0x0784, 0x0ca5, 0x0786, 0x0cc8, 0x0893, 0x0cf3, 0x093f, 0x0d95, 0x0838, 0x0d3c,
0x08be, 0x0ddd, 0x0adf, 0x0f4f, 0x0cee, 0x10ce, 0x0c77, 0x10e6, 0x0b38, 0x10a4,
0x0bc4, 0x1187, 0x0cda, 0x121b, 0x0ea0, 0x12f2, 0x0f19, 0x1309, 0x0eba, 0x1382,
0x0e9b, 0x138b, 0x0e30, 0x13bd, 0x0eb2, 0x1436, 0x0f67, 0x142e, 0x1059, 0x14aa,
0x1015, 0x1443, 0x0edc, 0x1376, 0x0e84, 0x1329, 0x0dfe, 0x12dd, 0x0e07, 0x138b,
0x0cee, 0x13bd, 0x0c22, 0x13a5, 0x0c1f, 0x134e, 0x0c5d, 0x12b6, 0x0d49, 0x12ec,
0x0da3, 0x136b, 0x0d22, 0x13ae, 0x0c19, 0x132d, 0x0c55, 0x1336, 0x0ddb, 0x145b,
0x0de1, 0x146c, 0x0d1d, 0x1475, 0x0d78, 0x15d6, 0x0d56, 0x166b, 0x0dbd, 0x16ca,
0x0f49, 0x16b5, 0x1070, 0x1691, 0x108f, 0x16ed, 0x101c, 0x171a, 0x0edc, 0x16ba,
0x0d95, 0x15b4, 0x0c6d, 0x140a, 0x0bc5, 0x133c, 0x0c9b, 0x145f, 0x0cbc, 0x159e,
0x0d2f, 0x15fc, 0x0d15, 0x14fc, 0x0ceb, 0x146a, 0x0d0d, 0x143e, 0x0c2c, 0x1375,
0x0c29, 0x1449, 0x0cdb, 0x1539, 0x0e00, 0x15f1, 0x0d97, 0x15df, 0x0cc8, 0x157d,
0x0d7f, 0x1660, 0x0df8, 0x16a2, 0x0dbc, 0x160f, 0x0d64, 0x1509, 0x0d94, 0x1429,
0x0e86, 0x145b, 0x0d8e, 0x147a, 0x0bff, 0x13f2, 0x0b18, 0x12f0, 0x0bba, 0x1367,
0x0b7a, 0x12ff, 0x0a4b, 0x1277, 0x0a21, 0x126a, 0x0b19, 0x1275, 0x0b94, 0x129a,
0x0ab8, 0x1180, 0x0aa7, 0x1164, 0x0a2e, 0x1189, 0x0a5d, 0x11a0, 0x09a0, 0x10c5,
0x09d3, 0x1072, 0x0908, 0x0f68, 0x079f, 0x0eb6, 0x0784, 0x0e38, 0x0837, 0x0e95,
0x0890, 0x0fd7, 0x075e, 0x0f34, 0x0755, 0x0f65, 0x06e2, 0x0e8c, 0x067b, 0x0da0,
0x06b0, 0x0e21, 0x0578, 0x0de3, 0x0510, 0x0e17, 0x049f, 0x0d1f, 0x046d, 0x0cdf,
0x036c, 0x0b7d, 0x020d, 0x0977, 0x0196, 0x0957, 0x014a, 0x09a7, 0x019e, 0x0aa3,
0x0148, 0x0a19, 0x0319, 0x0a48, 0x03da, 0x0a26, 0x047e, 0x0bbe, 0x03a5, 0x0c6b,
0x028c, 0x0ba7, 0x044f, 0x0c16, 0x04e9, 0x0bde, 0x0444, 0x0b6b, 0x041e, 0x0b66,
0x050a, 0x0bb1, 0x0470, 0x0a4a, 0x0339, 0x0912, 0x01b9, 0x0789, 0x00d4, 0x069d,
0xff93, 0x060d, 0xfe5d, 0x0542, 0xfdb6, 0x0445, 0xfd71, 0x02dc, 0xfe28, 0x01e1,
0xfd14, 0x00bf, 0xfd43, 0x019e, 0xfd92, 0x01a1, 0xfd86, 0x01d9, 0xfd20, 0x01fa,
0xfd41, 0x0184, 0xfe0a, 0x0106, 0xfd4f, 0xffb5, 0xfd15, 0xff27, 0xfc4d, 0xfedc,
0xfc9e, 0x0007, 0xfab8, 0xfe7a, 0xf99c, 0xfd60, 0xf97d, 0xfbcc, 0xf8bc, 0xfad7,
0xf8b8, 0xfb47, 0xf7e4, 0xfab3, 0xf6f9, 0xfa18, 0xf591, 0xf819, 0xf541, 0xf7b4,
0xf502, 0xf7c3, 0xf5e3, 0xf822, 0xf663, 0xf840, 0xf666, 0xf894, 0xf680, 0xf8d1,
0xf5c0, 0xf91a, 0xf611, 0xf966, 0xf5d8, 0xf861, 0xf4e9, 0xf75a, 0xf45a, 0xf663,
0xf549, 0xf665, 0xf5c2, 0xf66e, 0xf57b, 0xf6de, 0xf3de, 0xf5b6, 0xf378, 0xf4ee,
0xf402, 0xf4f6, 0xf49e, 0xf4ff, 0xf483, 0xf587, 0xf323, 0xf583, 0xf2cd, 0xf558,
0xf2d2, 0xf437, 0xf411, 0xf40d, 0xf50a, 0xf4b6, 0xf4f1, 0xf4c8, 0xf3d6, 0xf4a2,
0xf379, 0xf4da, 0xf3fc, 0xf3f2, 0xf4dd, 0xf3f1, 0xf4ab, 0xf4ce, 0xf39d, 0xf4bc,
0xf3a1, 0xf4c3, 0xf44d, 0xf49b, 0xf454, 0xf476, 0xf2f9, 0xf321, 0xf2eb, 0xf2c1,
0xf307, 0xf32f, 0xf292, 0xf376, 0xf1cd, 0xf271, 0xf1df, 0xf184, 0xf317, 0xf247,
0xf38b, 0xf337, 0xf2a2, 0xf34c, 0xf1f3, 0xf22f, 0xf26e, 0xf110, 0xf319, 0xf126,
0xf354, 0xf1c8, 0xf2fc, 0xf1f1, 0xf223, 0xf1ca, 0xf258, 0xf28b, 0xf340, 0xf2ec,
0xf3d8, 0xf2c1, 0xf3a1, 0xf311, 0xf2e0, 0xf38d, 0xf236, 0xf3a3, 0xf291, 0xf294,
0xf3b0, 0xf1e1, 0xf357, 0xf142, 0xf238, 0xf164, 0xf058, 0xf0d2, 0xef6b, 0xf004,
0xef63, 0xefd2, 0xef1a, 0xef27, 0xee85, 0xeeb0, 0xed66, 0xeddf, 0xedd4, 0xed90,
0xee7a, 0xee2c, 0xeeab, 0xef3c, 0xef11, 0xefa7, 0xef42, 0xef42, 0xef41, 0xeec2,
0xeff0, 0xeff4, 0xf078, 0xf16b, 0xf149, 0xf1fb, 0xf1b8, 0xf1cd, 0xf0e8, 0xf186,
0xf06b, 0xf11e, 0xf05b, 0xf0af, 0xefad, 0xf095, 0xef7b, 0xf079, 0xf04c, 0xf05a,
0xeffa, 0xef1a, 0xef51, 0xeecb, 0xee20, 0xef67, 0xeec4, 0xf11e, 0xef27, 0xf085,
0xef4a, 0xefc9, 0xefc3, 0xf031, 0xef3d, 0xefd1, 0xefe0, 0xefe3, 0xf040, 0xeee5,
0xf079, 0xeef4, 0xefa6, 0xeec8, 0xf043, 0xef05, 0xf191, 0xef00, 0xf21d, 0xeefc,
0xf231, 0xef57, 0xf1e4, 0xef57, 0xf1b3, 0xef3f, 0xf0ec, 0xee58, 0xf143, 0xeece,
0xf1c9, 0xeef0, 0xf2dc, 0xee8b, 0xf2cc, 0xed96, 0xf200, 0xed68, 0xf1a4, 0xece2,
0xf150, 0xeba6, 0xf01c, 0xeada, 0xef2a, 0xea45, 0xef7c, 0xe9ff, 0xf013, 0xe94b,
0xf08a, 0xe864, 0xf0b7, 0xe750, 0xf18c, 0xe736, 0xf19e, 0xe7b4, 0xf0eb, 0xe7a8,
0xf022, 0xe78f, 0xf048, 0xe7d3, 0xf27b, 0xe7c1, 0xf396, 0xe717, 0xf2aa, 0xe6ba,
0xf16e, 0xe673, 0xf292, 0xe705, 0xf335, 0xe6e2, 0xf32e, 0xe6b9, 0xf227, 0xe552,
0xf184, 0xe506, 0xf222, 0xe68b, 0xf223, 0xe6ec, 0xf2d5, 0xe6fb, 0xf1ff, 0xe516,
0xf18e, 0xe435, 0xf173, 0xe3f8, 0xf14a, 0xe415, 0xf141, 0xe4b8, 0xf156, 0xe487,
0xf1f4, 0xe4df, 0xf2a1, 0xe4c3, 0xf2b1, 0xe47f, 0xf28e, 0xe543, 0xf344, 0xe661,
0xf398, 0xe6c5, 0xf354, 0xe5b1, 0xf2c2, 0xe3f4, 0xf3df, 0xe476, 0xf4b9, 0xe615,
0xf493, 0xe741, 0xf491, 0xe838, 0xf526, 0xe855, 0xf545, 0xe7a2, 0xf53c, 0xe71c,
0xf3a5, 0xe60b, 0xf27b, 0xe5ac, 0xf284, 0xe5a5, 0xf2fc, 0xe678, 0xf41c, 0xe732,
0xf4a4, 0xe6c5, 0xf5fd, 0xe7ca, 0xf63d, 0xe929, 0xf6cc, 0xeab4, 0xf6e3, 0xeaad,
0xf7bc, 0xebdf, 0xf85b, 0xed86, 0xf7b0, 0xed8b, 0xf6c8, 0xed00, 0xf692, 0xecf9,
0xf827, 0xee89, 0xf8fc, 0xef94, 0xf917, 0xf010, 0xf871, 0xf054, 0xf8dd, 0xf147,
0xf9a2, 0xf24b, 0xfac6, 0xf338, 0xfb47, 0xf3e2, 0xfaff, 0xf4c6, 0xfb56, 0xf4d7,
0xfc5a, 0xf52d, 0xfcda, 0xf5fb, 0xfd3d, 0xf6f2, 0xfdc7, 0xf78a, 0xfeae, 0xf83e,
0xff96, 0xf8db, 0x00ea, 0xf95f, 0x01c6, 0xfaa5, 0x01b6, 0xfca2, 0x0189, 0xfe32,
0x01b1, 0xfdf1, 0x02bf, 0xfd90, 0x02f3, 0xfd04, 0x0330, 0xfd6e, 0x0329, 0xfe38,
0x03df, 0xff26, 0x0408, 0xff38, 0x0402, 0xff3d, 0x03a5, 0xff13, 0x02f6, 0xfee8,
0x035f, 0x00ce, 0x03f5, 0x0213, 0x0539, 0x026f, 0x04fc, 0x0250, 0x04ca, 0x0259,
0x055e, 0x025b, 0x05d7, 0x02a5, 0x04e7, 0x0311, 0x0470, 0x037a, 0x03f9, 0x0280,
0x03cb, 0x026b, 0x0486, 0x03b1, 0x053b, 0x047f, 0x0616, 0x0540, 0x0649, 0x051b,
0x06aa, 0x0521, 0x05b8, 0x040b, 0x0495, 0x0394, 0x0345, 0x038a, 0x038b, 0x049d,
0x044e, 0x059c, 0x0533, 0x05ba, 0x061f, 0x05a0, 0x0626, 0x0557, 0x05cb, 0x05a7,
0x046c, 0x05b8, 0x0415, 0x062b, 0x0496, 0x0625, 0x04f8, 0x05dc, 0x057e, 0x0579,
0x05c2, 0x057b, 0x0584, 0x061f, 0x05ab, 0x06fb, 0x0547, 0x0757, 0x0519, 0x07a4,
0x0529, 0x071b, 0x058b, 0x0627, 0x0599, 0x05b5, 0x04d4, 0x0561, 0x0501, 0x0616,
0x0512, 0x0607, 0x054c, 0x05e0, 0x0510, 0x05f0, 0x04f1, 0x0695, 0x0541, 0x0721,
0x0576, 0x069d, 0x0455, 0x0509, 0x0296, 0x02ba, 0x0370, 0x0229, 0x0391, 0x02ee,
0x0316, 0x0480, 0x02a2, 0x0536, 0x030b, 0x050b, 0x03a9, 0x0434, 0x0466, 0x041e,
0x040e, 0x03c1, 0x0355, 0x044e, 0x0385, 0x0544, 0x0357, 0x04d9, 0x03d6, 0x0562,
0x0357, 0x0487, 0x039f, 0x0467, 0x02ef, 0x04aa, 0x01fa, 0x051d, 0x0218, 0x04c9,
0x02cc, 0x0442, 0x0317, 0x04d6, 0x0266, 0x04d0, 0x01a1, 0x0412, 0x0139, 0x03d6,
0x01d9, 0x041d, 0x01de, 0x03c2, 0x01a4, 0x03ba, 0x0112, 0x0355, 0x0177, 0x048b,
0x00eb, 0x0515, 0x00ff, 0x05e4, 0x0247, 0x06df, 0x0360, 0x06c9, 0x0408, 0x06ca,
0x039f, 0x06f4, 0x0392, 0x083b, 0x0352, 0x0932, 0x030e, 0x0929, 0x0224, 0x0832,
0x02bc, 0x07c9, 0x01fe, 0x0672, 0x0102, 0x067a, 0x007e, 0x06b0, 0x00bb, 0x07df,
0x0151, 0x0881, 0x0150, 0x079d, 0x02bb, 0x0830, 0x02d5, 0x090c, 0x03ad, 0x0b44,
0x0313, 0x0ad6, 0x02af, 0x09bd, 0x0137, 0x07e5, 0x00ab, 0x07ab, 0x009c, 0x077d,
0x0066, 0x07c6, 0xfff4, 0x0859, 0xff6a, 0x0767, 0x00d6, 0x06e3, 0x015e, 0x06fc,
0x01bf, 0x08a8, 0x0033, 0x0885, 0x003f, 0x0815, 0x011d, 0x07b6, 0x01ea, 0x0854,
0x01bd, 0x0854, 0x013c, 0x08b4, 0x01bc, 0x093c, 0x023d, 0x0900, 0x034a, 0x08de,
0x02f6, 0x0821, 0x0203, 0x07d3, 0x0184, 0x0881, 0x01ed, 0x098a, 0x0394, 0x0a2b,
0x0431, 0x09c4, 0x0483, 0x098d, 0x03c7, 0x09b0, 0x020a, 0x0837, 0x01a6, 0x0729,
0x0130, 0x06b4, 0x0223, 0x06f1, 0x028f, 0x06a9, 0x01fd, 0x0669, 0x0051, 0x056a,
0xff4d, 0x0445, 0xff3f, 0x046a, 0x005b, 0x0531, 0x021e, 0x0590, 0x020d, 0x0553,
0x01e3, 0x058a, 0x012a, 0x04bf, 0x016c, 0x0574, 0x01b5, 0x05dc, 0x02a9, 0x06ae,
0x01c6, 0x05f9, 0x00d2, 0x041a, 0x0119, 0x035e, 0x01f4, 0x04ac, 0x02c7, 0x068c,
0x01f7, 0x0551, 0x01f3, 0x0485, 0x0281, 0x049e, 0x02da, 0x04af, 0x01f8, 0x0408,
0x00e1, 0x0388, 0x0063, 0x0374, 0x00a8, 0x02b2, 0x0023, 0x0152, 0x0005, 0x01da,
0x00ba, 0x025f, 0x013f, 0x021f, 0x00f9, 0x0144, 0x00b4, 0x00fe, 0x0062, 0x0127,
0x009d, 0x00f4, 0x0058, 0x008c, 0x005a, 0x0126, 0x00e4, 0x01dc, 0x0195, 0x01d0,
0x03e0, 0x030a, 0x0334, 0x023f, 0x028c, 0x0223, 0x0201, 0x0220, 0x01e6, 0x02a1,
0x0270, 0x02a7, 0x02d2, 0x01de, 0x0259, 0x01fa, 0x0085, 0x0185, 0x0007, 0x019b,
0x0012, 0x0157, 0x011b, 0x01aa, 0x00fc, 0x0116, 0x002c, 0x0085, 0xffb1, 0x003f,
0xff8d, 0x006d, 0x000e, 0x00cc, 0xfffd, 0x00f5, 0x0038, 0x0145, 0x0003, 0x007a,
0xfef3, 0xff95, 0xfdeb, 0xff41, 0xfdfc, 0xff9e, 0xff7d, 0x008e, 0xffc5, 0x00f5,
0x0014, 0x0124, 0xfece, 0x0008, 0xfed9, 0x001a, 0xfec0, 0xff9e, 0xfef4, 0x005b,
0xfe5f, 0x004b, 0xfdfa, 0xfef2, 0xfe4e, 0xfe77, 0xfe0f, 0xff73, 0xfe7a, 0x00d5,
0xfe41, 0x0062, 0xff62, 0x00b9, 0xffaf, 0x0097, 0x00f3, 0x01db, 0x005e, 0x01cd,
0x00bb, 0x02c4, 0x000f, 0x01b9, 0x0035, 0x0156, 0x01fd, 0x01e2, 0x02f1, 0x028f,
0x03e9, 0x0423, 0x0262, 0x02fd, 0x0237, 0x0312, 0x01e3, 0x02a6, 0x0210, 0x0304,
0x02ed, 0x039d, 0x0385, 0x03e3, 0x0379, 0x038b, 0x0355, 0x025e, 0x0292, 0x00ff,
0x0228, 0x00be, 0x0274, 0x0137, 0x02bf, 0x01e5, 0x031c, 0x01bd, 0x03ed, 0x013a,
0x054b, 0x01c0, 0x0467, 0x01bc, 0x03a3, 0x0268, 0x0317, 0x01d2, 0x0434, 0x0265,
0x040c, 0x015d, 0x04eb, 0x0171, 0x0572, 0x01dc, 0x04dd, 0x028b, 0x053e, 0x0396,
0x04c6, 0x0338, 0x04da, 0x02ed, 0x0507, 0x024e, 0x0600, 0x0304, 0x068a, 0x02d7,
0x06bd, 0x02c5, 0x06ea, 0x02f8, 0x0817, 0x035e, 0x082e, 0x02d7, 0x07eb, 0x033a,
0x06ad, 0x034a, 0x0652, 0x0388, 0x06d0, 0x02bf, 0x07ea, 0x0232, 0x08bd, 0x013a,
0x094a, 0x018d, 0x086a, 0x01b4, 0x0773, 0x00ee, 0x07a4, 0x00d7, 0x082b, 0x00a9,
0x08a8, 0x006e, 0x076f, 0xff6e, 0x068a, 0xff56, 0x0634, 0xff4f, 0x07b5, 0xffa2,
0x07cc, 0xff44, 0x0832, 0x0061, 0x07e7, 0x007c, 0x0792, 0x00c0, 0x0849, 0x00f1,
0x0847, 0x003d, 0x091a, 0x00ae, 0x094c, 0x005c, 0x091a, 0x003a, 0x08a9, 0x0079,
0x08d0, 0x015e, 0x09db, 0x01d6, 0x0a8d, 0x0183, 0x0a4c, 0x013a, 0x0a1f, 0x0106,
0x0a2d, 0x014a, 0x0a5c, 0x01c1, 0x0aa5, 0x012a, 0x0bb8, 0x0105, 0x0c12, 0x0099,
0x0aac, 0xfff7, 0x0a5a, 0x00a0, 0x0a9f, 0x013a, 0x0a80, 0x01e0, 0x0a13, 0x0193,
0x0a58, 0x0209, 0x0ab1, 0x0180, 0x0b72, 0x00f9, 0x0be3, 0x01af, 0x0b9c, 0x0305,
0x0b14, 0x03b7, 0x0bbf, 0x0360, 0x0c5e, 0x0356, 0x0ca5, 0x0374, 0x0ca9, 0x03e7,
0x0bdf, 0x045a, 0x0cac, 0x04cb, 0x0d57, 0x0454, 0x0d9b, 0x04a6, 0x0c8f, 0x04ae,
0x0c83, 0x04e1, 0x0d38, 0x049d, 0x0d03, 0x0485, 0x0cea, 0x04f7, 0x0c9d, 0x04f4,
0x0cf6, 0x062f, 0x0c13, 0x063c, 0x0b63, 0x05f0, 0x0b2e, 0x05e7, 0x0ba3, 0x062d,
0x0b9e, 0x0524, 0x0b28, 0x0457, 0x0a80, 0x0478, 0x09e1, 0x0518, 0x0a53, 0x0604,
0x0936, 0x0536, 0x0867, 0x04c9, 0x07de, 0x045d, 0x071a, 0x046b, 0x0604, 0x03ec,
0x0651, 0x039f, 0x06c7, 0x0356, 0x06bc, 0x03d5, 0x0697, 0x0408, 0x0679, 0x037a,
0x0737, 0x03c8, 0x076d, 0x0374, 0x077e, 0x041f, 0x05ed, 0x0464, 0x05bc, 0x04e6,
0x06d0, 0x04c4, 0x06e5, 0x0385, 0x0781, 0x03fb, 0x070a, 0x044f, 0x0676, 0x0459,
0x0519, 0x03cb, 0x0539, 0x03f0, 0x05de, 0x0478, 0x05a2, 0x0524, 0x052c, 0x04e8,
0x0486, 0x0470, 0x03f8, 0x04c6, 0x0389, 0x0486, 0x0390, 0x0492, 0x0350, 0x0403,
0x02a5, 0x0375, 0x0257, 0x03b8, 0x02d1, 0x03f1, 0x02dd, 0x03e5, 0x033f, 0x03f7,
0x02e9, 0x0402, 0x02ef, 0x04f4, 0x0320, 0x05c6, 0x03ba, 0x0700, 0x03f6, 0x0763,
0x0368, 0x06ce, 0x0460, 0x0720, 0x04d3, 0x06e9, 0x03cb, 0x06c9, 0x02b6, 0x0749,
0x02b1, 0x0806, 0x0385, 0x08af, 0x0399, 0x091f, 0x034a, 0x0947, 0x02f7, 0x08bb,
0x036d, 0x0902, 0x030f, 0x096a, 0x02bf, 0x0a19, 0x02af, 0x09b0, 0x018e, 0x07a6,
0x0060, 0x0677, 0x002d, 0x06c8, 0x00f1, 0x080f, 0x0029, 0x07fb, 0xff33, 0x07f2,
0xfe76, 0x0818, 0xfe71, 0x081a, 0xfddb, 0x079d, 0xfd3c, 0x06d4, 0xfda1, 0x0668,
0xfd68, 0x0604, 0xfd8b, 0x0651, 0xfe72, 0x0706, 0xff0f, 0x07f3, 0xfe76, 0x0806,
0xfd32, 0x0725, 0xfd96, 0x0749, 0xfe72, 0x0774, 0xfdd3, 0x0719, 0xfd7e, 0x07a9,
0xfe6b, 0x084a, 0xfe46, 0x07ae, 0xfd73, 0x06f1, 0xfcc6, 0x06c3, 0xfcac, 0x0760,
0xfd34, 0x075f, 0xfda6, 0x0756, 0xfdca, 0x0768, 0xfd8f, 0x078c, 0xfe03, 0x0820,
0xfda8, 0x0784, 0xfd1d, 0x070a, 0xfc9c, 0x0693, 0xfd12, 0x0707, 0xfd1f, 0x070b,
0xfd79, 0x0702, 0xfc9e, 0x05e6, 0xfb21, 0x0583, 0xfa72, 0x05d1, 0xfaf4, 0x05ed,
0xfb45, 0x050c, 0xfa44, 0x03a1, 0xfa9d, 0x03fc, 0xf9df, 0x02bb, 0xf947, 0x01c3,
0xf947, 0x0133, 0xf96b, 0x01d0, 0xf955, 0x01f4, 0xf8f5, 0x01e5, 0xf8f3, 0x02a6,
0xf94e, 0x0292, 0xfb15, 0x0266, 0xfbf6, 0x0231, 0xfbac, 0x028a, 0xfc05, 0x0391,
0xfbad, 0x0382, 0xfab6, 0x026d, 0xfa9f, 0x0191, 0xfb76, 0x0131, 0xfc8b, 0x012c,
0xfbab, 0x00a6, 0xfa84, 0x013b, 0xfa03, 0x01ad, 0xfa86, 0x020d, 0xfc06, 0x021a,
0xfc1f, 0x0116, 0xfb1e, 0x00ed, 0xfa0f, 0x010f, 0xf9de, 0x0142, 0xf9ee, 0x01fa,
0xfac9, 0x0274, 0xfbb3, 0x0216, 0xfb89, 0x0139, 0xfb3a, 0x0141, 0xfb8b, 0x0204,
0xfb15, 0x0154, 0xfa8e, 0x00d0, 0xf9cb, 0xffa3, 0xf905, 0xfe1d, 0xf7b3, 0xfcd0,
0xf73b, 0xfd92, 0xf7fe, 0xfecd, 0xf820, 0xfdfc, 0xf8a6, 0xfd6d, 0xf8de, 0xfdcd,
0xf966, 0xfee3, 0xf982, 0xff9e, 0xf9b1, 0x0048, 0xf9e0, 0xff26, 0xf95d, 0xfdcc,
0xf8b1, 0xfd81, 0xf79c, 0xfd6b, 0xf73a, 0xfdb1, 0xf70d, 0xfd68, 0xf717, 0xfccc,
0xf79d, 0xfc1c, 0xf8fe, 0xfc1c, 0xfa0c, 0xfc9b, 0xf8d8, 0xfcce, 0xf6f7, 0xfc74,
0xf67d, 0xfc29, 0xf682, 0xfc2f, 0xf78b, 0xfc1c, 0xf8da, 0xfc25, 0xf8e3, 0xfcb5,
0xf8cf, 0xfd01, 0xf83f, 0xfca3, 0xf904, 0xfd1d, 0xf90d, 0xfce9, 0xf91e, 0xfd81,
0xf943, 0xfd73, 0xf971, 0xfd42, 0xf922, 0xfd28, 0xf7ed, 0xfcb3, 0xf77f, 0xfc21,
0xf7c5, 0xfb08, 0xf731, 0xfa2f, 0xf644, 0xf99d, 0xf695, 0xfa11, 0xf66d, 0xf999,
0xf5f5, 0xf960, 0xf5ad, 0xf971, 0xf658, 0xf9d0, 0xf610, 0xfa2b, 0xf55c, 0xfa83,
0xf604, 0xfa00, 0xf746, 0xf907, 0xf80a, 0xf985, 0xf729, 0xfad3, 0xf752, 0xfc73,
0xf7f2, 0xfbc2, 0xf7fb, 0xfade, 0xf7e6, 0xfa40, 0xf7ec, 0xfae2, 0xf837, 0xfb6b,
0xf6bf, 0xfa27, 0xf617, 0xfa12, 0xf66d, 0xf90c, 0xf692, 0xf7cc, 0xf717, 0xf786,
0xf836, 0xf8d5, 0xf8e8, 0xf99f, 0xf851, 0xf912, 0xf841, 0xf8f2, 0xf8bd, 0xf964,
0xf984, 0xfa5b, 0xfa0e, 0xfa61, 0xfa1f, 0xfa19 };

#endif
