/**
 * \file  main_dsp.c
 *
 * \brief Program to illustrate buffer passing using Notify
 */

/* Copyright (c) 2011, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */

#include "ipc_buffer_io.h"

/* Globals */
int    volatile evtRcvd;
UInt32 volatile myPayload;

/* Declarations */
void AppInit(void);
void iAssert (int);
void wait_event(void);

/* Event Call back function */
void cbFxnEvent(UInt16 procId, UInt16 lineId,
                UInt32 eventId, UArg arg, UInt32 payload)
{
    myPayload = payload; /* Transfer payload */
    evtRcvd = 1;         /* Flag event to background app */
}
void main (void)
{
    char *str_buf;
    evtRcvd = 0;
    /* Initialize */
    AppInit();
    printf("DSP subsystem ready\n");

    /* Allocate I/O buffer and init with string */
    str_buf = (char *) malloc(80);
    str_buf = "Hello from DSP\n";

    /* Send buffer to remote CPU */
    iAssert (Notify_sendEvent(IPC_ARM_HOST,IPC_HOST_INTLINE, EVENTID, (UInt32) str_buf, TRUE));
    wait_event();
    printf((char *) myPayload);
    WAIT_HERE;
}

/* Initialization */
void AppInit(void)
{
    /* Structure to initialize IPC (see Ipc.h for definitions) */
    struct IPC_cfg ipcCfg = {
            IPC_DSP0,             /* local processor Id */
            IPC_ARM_HOST,         /* remote processor Id */
            IPC_HOST_INTLINE,     /* ID of interrupt line to remote CPU */
            IPC_INTERRUPT_METHOD, /* Method to receive from remote processor */
            NUM_MAX_EVENT,        /* maximum number of events to be created */
            &ipcPvMemDsp,         /* local side private IPC memory */
            &ipcPvMemArm          /* remote side private IPC memory */
    };
    IntDSPINTCInit();
    IPC_init(&ipcCfg);
    IPC_intRegister(C674X_MASK_INT5);
    iAssert (Notify_registerEvent(IPC_ARM_HOST, IPC_HOST_INTLINE, EVENTID, cbFxnEvent, 0xc0de));

    /*  Enabling interrupts for DSP C674x CPU */
    IntGlobalEnable();        /* Enable C674x global interrupt */
    iAssert (Notify_start()); /* This will enable IPC interrupt */
}

/* Trap for errors */
void    iAssert (int status)
{
    if (status != Notify_S_SUCCESS)
    {
        printf("Notify failed %d\n", status);
        WAIT_HERE;
    }
}

void    wait_event(void)
{
    int i = 0;  /* can be used as a time out check */
    while (!evtRcvd)
        i++;
/* evtRcvd = 0; */
}
