

/**
 *  @Component:   CPSW
 *
 *  @Filename:    cpsw_CPDMA_cred.h
 *
 ============================================================================ */
/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_CPSW_CPDMA_H_
#define _HW_CPSW_CPDMA_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define CPSW_CPDMA_TX_IDVER   (0x0)
#define CPSW_CPDMA_TX_CONTROL   (0x4)
#define CPSW_CPDMA_TX_TEARDOWN   (0x8)
#define CPSW_CPDMA_RX_IDVER   (0x10)
#define CPSW_CPDMA_RX_CONTROL   (0x14)
#define CPSW_CPDMA_RX_TEARDOWN   (0x18)
#define CPSW_CPDMA_CPDMA_SOFT_RESET   (0x1c)
#define CPSW_CPDMA_DMACONTROL   (0x20)
#define CPSW_CPDMA_DMASTATUS   (0x24)
#define CPSW_CPDMA_RX_BUFFER_OFFSET   (0x28)
#define CPSW_CPDMA_EMCONTROL   (0x2c)
#define CPSW_CPDMA_TX_PRI_RATE(n)   (0x30 + (n * 4))
#define CPSW_CPDMA_TX_INTSTAT_RAW   (0x80)
#define CPSW_CPDMA_TX_INTSTAT_MASKED   (0x84)
#define CPSW_CPDMA_TX_INTMASK_SET   (0x88)
#define CPSW_CPDMA_TX_INTMASK_CLEAR   (0x8c)
#define CPSW_CPDMA_CPDMA_IN_VECTOR   (0x90)
#define CPSW_CPDMA_CPDMA_EOI_VECTOR   (0x94)
#define CPSW_CPDMA_RX_INTSTAT_RAW   (0xa0)
#define CPSW_CPDMA_RX_INTSTAT_MASKED   (0xa4)
#define CPSW_CPDMA_RX_INTMASK_SET   (0xa8)
#define CPSW_CPDMA_RX_INTMASK_CLEAR   (0xac)
#define CPSW_CPDMA_DMA_INTSTAT_RAW   (0xb0)
#define CPSW_CPDMA_DMA_INTSTAT_MASKED   (0xb4)
#define CPSW_CPDMA_DMA_INTMASK_SET   (0xb8)
#define CPSW_CPDMA_DMA_INTMASK_CLEAR   (0xbc)
#define CPSW_CPDMA_RX_PENDTHRESH(n)   (0xc0 + (n * 4))
#define CPSW_CPDMA_RX_FREEBUFFER(n)   (0xe0 + (n * 4))
#define CPSW_CPDMA_TX_HDP(n)   (0x200 + (n * 4))
#define CPSW_CPDMA_RX_HDP(n)   (0x220 + (n * 4))
#define CPSW_CPDMA_TX_CP(n)   (0x240 + (n * 4))
#define CPSW_CPDMA_RX_CP(n)   (0x260 + (n * 4))

/**************************************************************************\
 * Field Definition Macros
\**************************************************************************/

/* TX_IDVER */
#define CPSW_CPDMA_TX_IDVER_TX_IDENT   (0xFFFF0000u)
#define CPSW_CPDMA_TX_IDVER_TX_IDENT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_TX_IDVER_TX_MAJOR_VER   (0x0000FF00u)
#define CPSW_CPDMA_TX_IDVER_TX_MAJOR_VER_SHIFT   (0x00000008u)

#define CPSW_CPDMA_TX_IDVER_TX_MINOR_VER   (0x000000FFu)
#define CPSW_CPDMA_TX_IDVER_TX_MINOR_VER_SHIFT   (0x00000000u)


/* TX_CONTROL */
#define CPSW_CPDMA_TX_CONTROL_TX_EN   (0x00000001u)
#define CPSW_CPDMA_TX_CONTROL_TX_EN_SHIFT   (0x00000000u)


/* TX_TEARDOWN */
#define CPSW_CPDMA_TX_TEARDOWN_TX_TDN_CH   (0x00000007u)
#define CPSW_CPDMA_TX_TEARDOWN_TX_TDN_CH_SHIFT   (0x00000000u)

#define CPSW_CPDMA_TX_TEARDOWN_TX_TDN_RDY   (0x80000000u)
#define CPSW_CPDMA_TX_TEARDOWN_TX_TDN_RDY_SHIFT   (0x0000001Fu)


/* RX_IDVER */
#define CPSW_CPDMA_RX_IDVER_RX_IDENT   (0xFFFF0000u)
#define CPSW_CPDMA_RX_IDVER_RX_IDENT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_RX_IDVER_RX_MAJOR_VER   (0x0000FF00u)
#define CPSW_CPDMA_RX_IDVER_RX_MAJOR_VER_SHIFT   (0x00000008u)

#define CPSW_CPDMA_RX_IDVER_RX_MINOR_VER   (0x000000FFu)
#define CPSW_CPDMA_RX_IDVER_RX_MINOR_VER_SHIFT   (0x00000000u)


/* RX_CONTROL */
#define CPSW_CPDMA_RX_CONTROL_RX_EN   (0x00000001u)
#define CPSW_CPDMA_RX_CONTROL_RX_EN_SHIFT   (0x00000000u)


/* RX_TEARDOWN */
#define CPSW_CPDMA_RX_TEARDOWN_RX_TDN_CH   (0x00000007u)
#define CPSW_CPDMA_RX_TEARDOWN_RX_TDN_CH_SHIFT   (0x00000000u)

#define CPSW_CPDMA_RX_TEARDOWN_RX_TDN_RDY   (0x80000000u)
#define CPSW_CPDMA_RX_TEARDOWN_RX_TDN_RDY_SHIFT   (0x0000001Fu)


/* CPDMA_SOFT_RESET */
#define CPSW_CPDMA_CPDMA_SOFT_RESET_SOFT_RESET   (0x00000001u)
#define CPSW_CPDMA_CPDMA_SOFT_RESET_SOFT_RESET_SHIFT   (0x00000000u)


/* DMACONTROL */
#define CPSW_CPDMA_DMACONTROL_CMD_IDLE   (0x00000008u)
#define CPSW_CPDMA_DMACONTROL_CMD_IDLE_SHIFT   (0x00000003u)

#define CPSW_CPDMA_DMACONTROL_RX_CEF   (0x00000010u)
#define CPSW_CPDMA_DMACONTROL_RX_CEF_SHIFT   (0x00000004u)

#define CPSW_CPDMA_DMACONTROL_RX_OFFLEN_BLOCK   (0x00000004u)
#define CPSW_CPDMA_DMACONTROL_RX_OFFLEN_BLOCK_SHIFT   (0x00000002u)

#define CPSW_CPDMA_DMACONTROL_RX_OWNERSHIP   (0x00000002u)
#define CPSW_CPDMA_DMACONTROL_RX_OWNERSHIP_SHIFT   (0x00000001u)

#define CPSW_CPDMA_DMACONTROL_TX_PTYPE   (0x00000001u)
#define CPSW_CPDMA_DMACONTROL_TX_PTYPE_SHIFT   (0x00000000u)

#define CPSW_CPDMA_DMACONTROL_TX_RLIM   (0x0000FF00u)
#define CPSW_CPDMA_DMACONTROL_TX_RLIM_SHIFT   (0x00000008u)


/* DMASTATUS */
#define CPSW_CPDMA_DMASTATUS_IDLE   (0x80000000u)
#define CPSW_CPDMA_DMASTATUS_IDLE_SHIFT   (0x0000001Fu)

#define CPSW_CPDMA_DMASTATUS_RX_ERR_CH   (0x00000700u)
#define CPSW_CPDMA_DMASTATUS_RX_ERR_CH_SHIFT   (0x00000008u)

#define CPSW_CPDMA_DMASTATUS_RX_HOST_ERR_CODE   (0x0000F000u)
#define CPSW_CPDMA_DMASTATUS_RX_HOST_ERR_CODE_SHIFT   (0x0000000Cu)

#define CPSW_CPDMA_DMASTATUS_TX_ERR_CH   (0x00070000u)
#define CPSW_CPDMA_DMASTATUS_TX_ERR_CH_SHIFT   (0x00000010u)

#define CPSW_CPDMA_DMASTATUS_TX_HOST_ERR_CODE   (0x00F00000u)
#define CPSW_CPDMA_DMASTATUS_TX_HOST_ERR_CODE_SHIFT   (0x00000014u)


/* RX_BUFFER_OFFSET */
#define CPSW_CPDMA_RX_BUFFER_OFFSET_RX_BUFFER_OFFSET   (0x0000FFFFu)
#define CPSW_CPDMA_RX_BUFFER_OFFSET_RX_BUFFER_OFFSET_SHIFT   (0x00000000u)


/* EMCONTROL */
#define CPSW_CPDMA_EMCONTROL_FREE   (0x00000001u)
#define CPSW_CPDMA_EMCONTROL_FREE_SHIFT   (0x00000000u)

#define CPSW_CPDMA_EMCONTROL_SOFT   (0x00000002u)
#define CPSW_CPDMA_EMCONTROL_SOFT_SHIFT   (0x00000001u)


/* TX_PRI0_RATE */
#define CPSW_CPDMA_TX_PRI0_RATE_PRIN_IDLE_CNT   (0x3FFF0000u)
#define CPSW_CPDMA_TX_PRI0_RATE_PRIN_IDLE_CNT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_TX_PRI0_RATE_PRIN_SEND_CNT   (0x00003FFFu)
#define CPSW_CPDMA_TX_PRI0_RATE_PRIN_SEND_CNT_SHIFT   (0x00000000u)


/* TX_PRI1_RATE */
#define CPSW_CPDMA_TX_PRI1_RATE_PRIN_IDLE_CNT   (0x3FFF0000u)
#define CPSW_CPDMA_TX_PRI1_RATE_PRIN_IDLE_CNT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_TX_PRI1_RATE_PRIN_SEND_CNT   (0x00003FFFu)
#define CPSW_CPDMA_TX_PRI1_RATE_PRIN_SEND_CNT_SHIFT   (0x00000000u)


/* TX_PRI2_RATE */
#define CPSW_CPDMA_TX_PRI2_RATE_PRIN_IDLE_CNT   (0x3FFF0000u)
#define CPSW_CPDMA_TX_PRI2_RATE_PRIN_IDLE_CNT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_TX_PRI2_RATE_PRIN_SEND_CNT   (0x00003FFFu)
#define CPSW_CPDMA_TX_PRI2_RATE_PRIN_SEND_CNT_SHIFT   (0x00000000u)


/* TX_PRI3_RATE */
#define CPSW_CPDMA_TX_PRI3_RATE_PRIN_IDLE_CNT   (0x3FFF0000u)
#define CPSW_CPDMA_TX_PRI3_RATE_PRIN_IDLE_CNT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_TX_PRI3_RATE_PRIN_SEND_CNT   (0x00003FFFu)
#define CPSW_CPDMA_TX_PRI3_RATE_PRIN_SEND_CNT_SHIFT   (0x00000000u)


/* TX_PRI4_RATE */
#define CPSW_CPDMA_TX_PRI4_RATE_PRIN_IDLE_CNT   (0x3FFF0000u)
#define CPSW_CPDMA_TX_PRI4_RATE_PRIN_IDLE_CNT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_TX_PRI4_RATE_PRIN_SEND_CNT   (0x00003FFFu)
#define CPSW_CPDMA_TX_PRI4_RATE_PRIN_SEND_CNT_SHIFT   (0x00000000u)


/* TX_PRI5_RATE */
#define CPSW_CPDMA_TX_PRI5_RATE_PRIN_IDLE_CNT   (0x3FFF0000u)
#define CPSW_CPDMA_TX_PRI5_RATE_PRIN_IDLE_CNT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_TX_PRI5_RATE_PRIN_SEND_CNT   (0x00003FFFu)
#define CPSW_CPDMA_TX_PRI5_RATE_PRIN_SEND_CNT_SHIFT   (0x00000000u)


/* TX_PRI6_RATE */
#define CPSW_CPDMA_TX_PRI6_RATE_PRIN_IDLE_CNT   (0x3FFF0000u)
#define CPSW_CPDMA_TX_PRI6_RATE_PRIN_IDLE_CNT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_TX_PRI6_RATE_PRIN_SEND_CNT   (0x00003FFFu)
#define CPSW_CPDMA_TX_PRI6_RATE_PRIN_SEND_CNT_SHIFT   (0x00000000u)


/* TX_PRI7_RATE */
#define CPSW_CPDMA_TX_PRI7_RATE_PRIN_IDLE_CNT   (0x3FFF0000u)
#define CPSW_CPDMA_TX_PRI7_RATE_PRIN_IDLE_CNT_SHIFT   (0x00000010u)

#define CPSW_CPDMA_TX_PRI7_RATE_PRIN_SEND_CNT   (0x00003FFFu)
#define CPSW_CPDMA_TX_PRI7_RATE_PRIN_SEND_CNT_SHIFT   (0x00000000u)


/* TX_INTSTAT_RAW */
#define CPSW_CPDMA_TX_INTSTAT_RAW_TX0_PEND   (0x00000001u)
#define CPSW_CPDMA_TX_INTSTAT_RAW_TX0_PEND_SHIFT   (0x00000000u)

#define CPSW_CPDMA_TX_INTSTAT_RAW_TX1_PEND   (0x00000002u)
#define CPSW_CPDMA_TX_INTSTAT_RAW_TX1_PEND_SHIFT   (0x00000001u)

#define CPSW_CPDMA_TX_INTSTAT_RAW_TX2_PEND   (0x00000004u)
#define CPSW_CPDMA_TX_INTSTAT_RAW_TX2_PEND_SHIFT   (0x00000002u)

#define CPSW_CPDMA_TX_INTSTAT_RAW_TX3_PEND   (0x00000008u)
#define CPSW_CPDMA_TX_INTSTAT_RAW_TX3_PEND_SHIFT   (0x00000003u)

#define CPSW_CPDMA_TX_INTSTAT_RAW_TX4_PEND   (0x00000010u)
#define CPSW_CPDMA_TX_INTSTAT_RAW_TX4_PEND_SHIFT   (0x00000004u)

#define CPSW_CPDMA_TX_INTSTAT_RAW_TX5_PEND   (0x00000020u)
#define CPSW_CPDMA_TX_INTSTAT_RAW_TX5_PEND_SHIFT   (0x00000005u)

#define CPSW_CPDMA_TX_INTSTAT_RAW_TX6_PEND   (0x00000040u)
#define CPSW_CPDMA_TX_INTSTAT_RAW_TX6_PEND_SHIFT   (0x00000006u)

#define CPSW_CPDMA_TX_INTSTAT_RAW_TX7_PEND   (0x00000080u)
#define CPSW_CPDMA_TX_INTSTAT_RAW_TX7_PEND_SHIFT   (0x00000007u)


/* TX_INTSTAT_MASKED */
#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX0_PEND   (0x00000001u)
#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX0_PEND_SHIFT   (0x00000000u)

#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX1_PEND   (0x00000002u)
#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX1_PEND_SHIFT   (0x00000001u)

#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX2_PEND   (0x00000004u)
#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX2_PEND_SHIFT   (0x00000002u)

#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX3_PEND   (0x00000008u)
#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX3_PEND_SHIFT   (0x00000003u)

#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX4_PEND   (0x00000010u)
#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX4_PEND_SHIFT   (0x00000004u)

#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX5_PEND   (0x00000020u)
#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX5_PEND_SHIFT   (0x00000005u)

#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX6_PEND   (0x00000040u)
#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX6_PEND_SHIFT   (0x00000006u)

#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX7_PEND   (0x00000080u)
#define CPSW_CPDMA_TX_INTSTAT_MASKED_TX7_PEND_SHIFT   (0x00000007u)


/* TX_INTMASK_SET */
#define CPSW_CPDMA_TX_INTMASK_SET_TX0_MASK   (0x00000001u)
#define CPSW_CPDMA_TX_INTMASK_SET_TX0_MASK_SHIFT   (0x00000000u)

#define CPSW_CPDMA_TX_INTMASK_SET_TX1_MASK   (0x00000002u)
#define CPSW_CPDMA_TX_INTMASK_SET_TX1_MASK_SHIFT   (0x00000001u)

#define CPSW_CPDMA_TX_INTMASK_SET_TX2_MASK   (0x00000004u)
#define CPSW_CPDMA_TX_INTMASK_SET_TX2_MASK_SHIFT   (0x00000002u)

#define CPSW_CPDMA_TX_INTMASK_SET_TX3_MASK   (0x00000008u)
#define CPSW_CPDMA_TX_INTMASK_SET_TX3_MASK_SHIFT   (0x00000003u)

#define CPSW_CPDMA_TX_INTMASK_SET_TX4_MASK   (0x00000010u)
#define CPSW_CPDMA_TX_INTMASK_SET_TX4_MASK_SHIFT   (0x00000004u)

#define CPSW_CPDMA_TX_INTMASK_SET_TX5_MASK   (0x00000020u)
#define CPSW_CPDMA_TX_INTMASK_SET_TX5_MASK_SHIFT   (0x00000005u)

#define CPSW_CPDMA_TX_INTMASK_SET_TX6_MASK   (0x00000040u)
#define CPSW_CPDMA_TX_INTMASK_SET_TX6_MASK_SHIFT   (0x00000006u)

#define CPSW_CPDMA_TX_INTMASK_SET_TX7_MASK   (0x00000080u)
#define CPSW_CPDMA_TX_INTMASK_SET_TX7_MASK_SHIFT   (0x00000007u)


/* TX_INTMASK_CLEAR */
#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX0_MASK   (0x00000001u)
#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX0_MASK_SHIFT   (0x00000000u)

#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX1_MASK   (0x00000002u)
#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX1_MASK_SHIFT   (0x00000001u)

#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX2_MASK   (0x00000004u)
#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX2_MASK_SHIFT   (0x00000002u)

#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX3_MASK   (0x00000008u)
#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX3_MASK_SHIFT   (0x00000003u)

#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX4_MASK   (0x00000010u)
#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX4_MASK_SHIFT   (0x00000004u)

#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX5_MASK   (0x00000020u)
#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX5_MASK_SHIFT   (0x00000005u)

#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX6_MASK   (0x00000040u)
#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX6_MASK_SHIFT   (0x00000006u)

#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX7_MASK   (0x00000080u)
#define CPSW_CPDMA_TX_INTMASK_CLEAR_TX7_MASK_SHIFT   (0x00000007u)


/* CPDMA_IN_VECTOR */
#define CPSW_CPDMA_CPDMA_IN_VECTOR_DMA_IN_VECTOR   (0xFFFFFFFFu)
#define CPSW_CPDMA_CPDMA_IN_VECTOR_DMA_IN_VECTOR_SHIFT   (0x00000000u)


/* CPDMA_EOI_VECTOR */
#define CPSW_CPDMA_CPDMA_EOI_VECTOR_DMA_EOI_VECTOR   (0x0000001Fu)
#define CPSW_CPDMA_CPDMA_EOI_VECTOR_DMA_EOI_VECTOR_SHIFT   (0x00000000u)


/* RX_INTSTAT_RAW */
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX0_PEND   (0x00000001u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX0_PEND_SHIFT   (0x00000000u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX0_THRESH_PEND   (0x00000100u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX0_THRESH_PEND_SHIFT   (0x00000008u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX1_PEND   (0x00000002u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX1_PEND_SHIFT   (0x00000001u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX1_THRESH_PEND   (0x00000200u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX1_THRESH_PEND_SHIFT   (0x00000009u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX2_PEND   (0x00000004u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX2_PEND_SHIFT   (0x00000002u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX2_THRESH_PEND   (0x00000400u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX2_THRESH_PEND_SHIFT   (0x0000000Au)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX3_PEND   (0x00000008u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX3_PEND_SHIFT   (0x00000003u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX3_THRESH_PEND   (0x00000800u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX3_THRESH_PEND_SHIFT   (0x0000000Bu)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX4_PEND   (0x00000010u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX4_PEND_SHIFT   (0x00000004u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX4_THRESH_PEND   (0x00001000u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX4_THRESH_PEND_SHIFT   (0x0000000Cu)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX5_PEND   (0x00000020u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX5_PEND_SHIFT   (0x00000005u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX5_THRESH_PEND   (0x00002000u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX5_THRESH_PEND_SHIFT   (0x0000000Du)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX6_PEND   (0x00000040u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX6_PEND_SHIFT   (0x00000006u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX6_THRESH_PEND   (0x00004000u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX6_THRESH_PEND_SHIFT   (0x0000000Eu)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX7_PEND   (0x00000080u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX7_PEND_SHIFT   (0x00000007u)

#define CPSW_CPDMA_RX_INTSTAT_RAW_RX7_THRESH_PEND   (0x00008000u)
#define CPSW_CPDMA_RX_INTSTAT_RAW_RX7_THRESH_PEND_SHIFT   (0x0000000Fu)


/* RX_INTSTAT_MASKED */
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX0_PEND   (0x00000001u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX0_PEND_SHIFT   (0x00000000u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX0_THRESH_PEND   (0x00000100u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX0_THRESH_PEND_SHIFT   (0x00000008u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX1_PEND   (0x00000002u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX1_PEND_SHIFT   (0x00000001u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX1_THRESH_PEND   (0x00000200u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX1_THRESH_PEND_SHIFT   (0x00000009u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX2_PEND   (0x00000004u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX2_PEND_SHIFT   (0x00000002u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX2_THRESH_PEND   (0x00000400u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX2_THRESH_PEND_SHIFT   (0x0000000Au)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX3_PEND   (0x00000008u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX3_PEND_SHIFT   (0x00000003u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX3_THRESH_PEND   (0x00000800u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX3_THRESH_PEND_SHIFT   (0x0000000Bu)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX4_PEND   (0x00000010u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX4_PEND_SHIFT   (0x00000004u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX4_THRESH_PEND   (0x00001000u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX4_THRESH_PEND_SHIFT   (0x0000000Cu)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX5_PEND   (0x00000020u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX5_PEND_SHIFT   (0x00000005u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX5_THRESH_PEND   (0x00002000u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX5_THRESH_PEND_SHIFT   (0x0000000Du)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX6_PEND   (0x00000040u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX6_PEND_SHIFT   (0x00000006u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX6_THRESH_PEND   (0x00004000u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX6_THRESH_PEND_SHIFT   (0x0000000Eu)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX7_PEND   (0x00000080u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX7_PEND_SHIFT   (0x00000007u)

#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX7_THRESH_PEND   (0x00008000u)
#define CPSW_CPDMA_RX_INTSTAT_MASKED_RX7_THRESH_PEND_SHIFT   (0x0000000Fu)


/* RX_INTMASK_SET */
#define CPSW_CPDMA_RX_INTMASK_SET_RX0_PEND_MASK   (0x00000001u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX0_PEND_MASK_SHIFT   (0x00000000u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX0_THRESH_PEND_MASK   (0x00000100u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX0_THRESH_PEND_MASK_SHIFT   (0x00000008u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX1_PEND_MASK   (0x00000002u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX1_PEND_MASK_SHIFT   (0x00000001u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX1_THRESH_PEND_MASK   (0x00000200u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX1_THRESH_PEND_MASK_SHIFT   (0x00000009u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX2_PEND_MASK   (0x00000004u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX2_PEND_MASK_SHIFT   (0x00000002u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX2_THRESH_PEND_MASK   (0x00000400u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX2_THRESH_PEND_MASK_SHIFT   (0x0000000Au)

#define CPSW_CPDMA_RX_INTMASK_SET_RX3_PEND_MASK   (0x00000008u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX3_PEND_MASK_SHIFT   (0x00000003u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX3_THRESH_PEND_MASK   (0x00000800u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX3_THRESH_PEND_MASK_SHIFT   (0x0000000Bu)

#define CPSW_CPDMA_RX_INTMASK_SET_RX4_PEND_MASK   (0x00000010u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX4_PEND_MASK_SHIFT   (0x00000004u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX4_THRESH_PEND_MASK   (0x00001000u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX4_THRESH_PEND_MASK_SHIFT   (0x0000000Cu)

#define CPSW_CPDMA_RX_INTMASK_SET_RX5_PEND_MASK   (0x00000020u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX5_PEND_MASK_SHIFT   (0x00000005u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX5_THRESH_PEND_MASK   (0x00002000u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX5_THRESH_PEND_MASK_SHIFT   (0x0000000Du)

#define CPSW_CPDMA_RX_INTMASK_SET_RX6_PEND_MASK   (0x00000040u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX6_PEND_MASK_SHIFT   (0x00000006u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX6_THRESH_PEND_MASK   (0x00004000u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX6_THRESH_PEND_MASK_SHIFT   (0x0000000Eu)

#define CPSW_CPDMA_RX_INTMASK_SET_RX7_PEND_MASK   (0x00000080u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX7_PEND_MASK_SHIFT   (0x00000007u)

#define CPSW_CPDMA_RX_INTMASK_SET_RX7_THRESH_PEND_MASK   (0x00008000u)
#define CPSW_CPDMA_RX_INTMASK_SET_RX7_THRESH_PEND_MASK_SHIFT   (0x0000000Fu)


/* RX_INTMASK_CLEAR */
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX0_PEND_MASK   (0x00000001u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX0_PEND_MASK_SHIFT   (0x00000000u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX0_THRESH_PEND_MASK   (0x00000100u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX0_THRESH_PEND_MASK_SHIFT   (0x00000008u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX1_PEND_MASK   (0x00000002u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX1_PEND_MASK_SHIFT   (0x00000001u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX1_THRESH_PEND_MASK   (0x00000200u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX1_THRESH_PEND_MASK_SHIFT   (0x00000009u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX2_PEND_MASK   (0x00000004u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX2_PEND_MASK_SHIFT   (0x00000002u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX2_THRESH_PEND_MASK   (0x00000400u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX2_THRESH_PEND_MASK_SHIFT   (0x0000000Au)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX3_PEND_MASK   (0x00000008u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX3_PEND_MASK_SHIFT   (0x00000003u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX3_THRESH_PEND_MASK   (0x00000800u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX3_THRESH_PEND_MASK_SHIFT   (0x0000000Bu)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX4_PEND_MASK   (0x00000010u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX4_PEND_MASK_SHIFT   (0x00000004u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX4_THRESH_PEND_MASK   (0x00001000u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX4_THRESH_PEND_MASK_SHIFT   (0x0000000Cu)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX5_PEND_MASK   (0x00000020u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX5_PEND_MASK_SHIFT   (0x00000005u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX5_THRESH_PEND_MASK   (0x00002000u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX5_THRESH_PEND_MASK_SHIFT   (0x0000000Du)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX6_PEND_MASK   (0x00000040u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX6_PEND_MASK_SHIFT   (0x00000006u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX6_THRESH_PEND_MASK   (0x00004000u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX6_THRESH_PEND_MASK_SHIFT   (0x0000000Eu)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX7_PEND_MASK   (0x00000080u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX7_PEND_MASK_SHIFT   (0x00000007u)

#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX7_THRESH_PEND_MASK   (0x00008000u)
#define CPSW_CPDMA_RX_INTMASK_CLEAR_RX7_THRESH_PEND_MASK_SHIFT   (0x0000000Fu)


/* DMA_INTSTAT_RAW */
#define CPSW_CPDMA_DMA_INTSTAT_RAW_HOST_PEND   (0x00000002u)
#define CPSW_CPDMA_DMA_INTSTAT_RAW_HOST_PEND_SHIFT   (0x00000001u)

#define CPSW_CPDMA_DMA_INTSTAT_RAW_STAT_PEND   (0x00000001u)
#define CPSW_CPDMA_DMA_INTSTAT_RAW_STAT_PEND_SHIFT   (0x00000000u)


/* DMA_INTSTAT_MASKED */
#define CPSW_CPDMA_DMA_INTSTAT_MASKED_HOST_PEND   (0x00000002u)
#define CPSW_CPDMA_DMA_INTSTAT_MASKED_HOST_PEND_SHIFT   (0x00000001u)

#define CPSW_CPDMA_DMA_INTSTAT_MASKED_STAT_PEND   (0x00000001u)
#define CPSW_CPDMA_DMA_INTSTAT_MASKED_STAT_PEND_SHIFT   (0x00000000u)


/* DMA_INTMASK_SET */
#define CPSW_CPDMA_DMA_INTMASK_SET_HOST_ERR_INT_MASK   (0x00000002u)
#define CPSW_CPDMA_DMA_INTMASK_SET_HOST_ERR_INT_MASK_SHIFT   (0x00000001u)

#define CPSW_CPDMA_DMA_INTMASK_SET_STAT_INT_MASK   (0x00000001u)
#define CPSW_CPDMA_DMA_INTMASK_SET_STAT_INT_MASK_SHIFT   (0x00000000u)


/* DMA_INTMASK_CLEAR */
#define CPSW_CPDMA_DMA_INTMASK_CLEAR_HOST_ERR_INT_MASK   (0x00000002u)
#define CPSW_CPDMA_DMA_INTMASK_CLEAR_HOST_ERR_INT_MASK_SHIFT   (0x00000001u)

#define CPSW_CPDMA_DMA_INTMASK_CLEAR_STAT_INT_MASK   (0x00000001u)
#define CPSW_CPDMA_DMA_INTMASK_CLEAR_STAT_INT_MASK_SHIFT   (0x00000000u)


/* RX0_PENDTHRESH */
#define CPSW_CPDMA_RX0_PENDTHRESH_RX_PENDTHRESH   (0x000000FFu)
#define CPSW_CPDMA_RX0_PENDTHRESH_RX_PENDTHRESH_SHIFT   (0x00000000u)


/* RX1_PENDTHRESH */
#define CPSW_CPDMA_RX1_PENDTHRESH_RX_PENDTHRESH   (0x000000FFu)
#define CPSW_CPDMA_RX1_PENDTHRESH_RX_PENDTHRESH_SHIFT   (0x00000000u)


/* RX2_PENDTHRESH */
#define CPSW_CPDMA_RX2_PENDTHRESH_RX_PENDTHRESH   (0x000000FFu)
#define CPSW_CPDMA_RX2_PENDTHRESH_RX_PENDTHRESH_SHIFT   (0x00000000u)


/* RX3_PENDTHRESH */
#define CPSW_CPDMA_RX3_PENDTHRESH_RX_PENDTHRESH   (0x000000FFu)
#define CPSW_CPDMA_RX3_PENDTHRESH_RX_PENDTHRESH_SHIFT   (0x00000000u)


/* RX4_PENDTHRESH */
#define CPSW_CPDMA_RX4_PENDTHRESH_RX_PENDTHRESH   (0x000000FFu)
#define CPSW_CPDMA_RX4_PENDTHRESH_RX_PENDTHRESH_SHIFT   (0x00000000u)


/* RX5_PENDTHRESH */
#define CPSW_CPDMA_RX5_PENDTHRESH_RX_PENDTHRESH   (0x000000FFu)
#define CPSW_CPDMA_RX5_PENDTHRESH_RX_PENDTHRESH_SHIFT   (0x00000000u)


/* RX6_PENDTHRESH */
#define CPSW_CPDMA_RX6_PENDTHRESH_RX_PENDTHRESH   (0x000000FFu)
#define CPSW_CPDMA_RX6_PENDTHRESH_RX_PENDTHRESH_SHIFT   (0x00000000u)


/* RX7_PENDTHRESH */
#define CPSW_CPDMA_RX7_PENDTHRESH_RX_PENDTHRESH   (0x000000FFu)
#define CPSW_CPDMA_RX7_PENDTHRESH_RX_PENDTHRESH_SHIFT   (0x00000000u)


/* RX0_FREEBUFFER */
#define CPSW_CPDMA_RX0_FREEBUFFER_RX_FREEBUFFER   (0x0000FFFFu)
#define CPSW_CPDMA_RX0_FREEBUFFER_RX_FREEBUFFER_SHIFT   (0x00000000u)


/* RX1_FREEBUFFER */
#define CPSW_CPDMA_RX1_FREEBUFFER_RX_FREEBUFFER   (0x0000FFFFu)
#define CPSW_CPDMA_RX1_FREEBUFFER_RX_FREEBUFFER_SHIFT   (0x00000000u)


/* RX2_FREEBUFFER */
#define CPSW_CPDMA_RX2_FREEBUFFER_RX_FREEBUFFER   (0x0000FFFFu)
#define CPSW_CPDMA_RX2_FREEBUFFER_RX_FREEBUFFER_SHIFT   (0x00000000u)


/* RX3_FREEBUFFER */
#define CPSW_CPDMA_RX3_FREEBUFFER_RX_FREEBUFFER   (0x0000FFFFu)
#define CPSW_CPDMA_RX3_FREEBUFFER_RX_FREEBUFFER_SHIFT   (0x00000000u)


/* RX4_FREEBUFFER */
#define CPSW_CPDMA_RX4_FREEBUFFER_RX_FREEBUFFER   (0x0000FFFFu)
#define CPSW_CPDMA_RX4_FREEBUFFER_RX_FREEBUFFER_SHIFT   (0x00000000u)


/* RX5_FREEBUFFER */
#define CPSW_CPDMA_RX5_FREEBUFFER_RX_FREEBUFFER   (0x0000FFFFu)
#define CPSW_CPDMA_RX5_FREEBUFFER_RX_FREEBUFFER_SHIFT   (0x00000000u)


/* RX6_FREEBUFFER */
#define CPSW_CPDMA_RX6_FREEBUFFER_RX_FREEBUFFER   (0x0000FFFFu)
#define CPSW_CPDMA_RX6_FREEBUFFER_RX_FREEBUFFER_SHIFT   (0x00000000u)


/* RX7_FREEBUFFER */
#define CPSW_CPDMA_RX7_FREEBUFFER_RX_FREEBUFFER   (0x0000FFFFu)
#define CPSW_CPDMA_RX7_FREEBUFFER_RX_FREEBUFFER_SHIFT   (0x00000000u)


/* RXGOODFRAMES */
#define CPSW_CPDMA_RXGOODFRAMES_RXGOODFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXGOODFRAMES_RXGOODFRAMES_SHIFT   (0x00000000u)


/* RXBROADCASTFRAMES */
#define CPSW_CPDMA_RXBROADCASTFRAMES_RXBROADCASTFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXBROADCASTFRAMES_RXBROADCASTFRAMES_SHIFT   (0x00000000u)


/* RXMULTICASTFRAMES */
#define CPSW_CPDMA_RXMULTICASTFRAMES_RXMULTICASTFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXMULTICASTFRAMES_RXMULTICASTFRAMES_SHIFT   (0x00000000u)


/* RXPAUSEFRAMES */
#define CPSW_CPDMA_RXPAUSEFRAMES_RXPAUSEFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXPAUSEFRAMES_RXPAUSEFRAMES_SHIFT   (0x00000000u)


/* RXCRCERRORS */
#define CPSW_CPDMA_RXCRCERRORS_RXCRCERRORS   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXCRCERRORS_RXCRCERRORS_SHIFT   (0x00000000u)


/* RXALIGNCODEERRORS */
#define CPSW_CPDMA_RXALIGNCODEERRORS_RXALIGNCODEERRORS   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXALIGNCODEERRORS_RXALIGNCODEERRORS_SHIFT   (0x00000000u)


/* RXOVERSIZEDFRAMES */
#define CPSW_CPDMA_RXOVERSIZEDFRAMES_RXOVERSIZEDFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXOVERSIZEDFRAMES_RXOVERSIZEDFRAMES_SHIFT   (0x00000000u)


/* RXJABBERFRAMES */
#define CPSW_CPDMA_RXJABBERFRAMES_RXJABBERFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXJABBERFRAMES_RXJABBERFRAMES_SHIFT   (0x00000000u)


/* RXUNDERSIZEDFRAMES */
#define CPSW_CPDMA_RXUNDERSIZEDFRAMES_RXUNDERSIZEDFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXUNDERSIZEDFRAMES_RXUNDERSIZEDFRAMES_SHIFT   (0x00000000u)


/* RXFRAGMENTS */
#define CPSW_CPDMA_RXFRAGMENTS_RXFRAGMENTS   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXFRAGMENTS_RXFRAGMENTS_SHIFT   (0x00000000u)


/* RXOCTETS */
#define CPSW_CPDMA_RXOCTETS_RXOCTETS   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXOCTETS_RXOCTETS_SHIFT   (0x00000000u)


/* TXGOODFRAMES */
#define CPSW_CPDMA_TXGOODFRAMES_TXGOODFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXGOODFRAMES_TXGOODFRAMES_SHIFT   (0x00000000u)


/* TXBROADCASTFRAMES */
#define CPSW_CPDMA_TXBROADCASTFRAMES_TXBROADCASTFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXBROADCASTFRAMES_TXBROADCASTFRAMES_SHIFT   (0x00000000u)


/* TXMULTICASTFRAMES */
#define CPSW_CPDMA_TXMULTICASTFRAMES_TXMULTICASTFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXMULTICASTFRAMES_TXMULTICASTFRAMES_SHIFT   (0x00000000u)


/* TXPAUSEFRAMES */
#define CPSW_CPDMA_TXPAUSEFRAMES_TXPAUSEFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXPAUSEFRAMES_TXPAUSEFRAMES_SHIFT   (0x00000000u)


/* TXDEFERREDFRAMES */
#define CPSW_CPDMA_TXDEFERREDFRAMES_TXDEFERREDFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXDEFERREDFRAMES_TXDEFERREDFRAMES_SHIFT   (0x00000000u)


/* TXCOLLISIONFRAMES */
#define CPSW_CPDMA_TXCOLLISIONFRAMES_TXCOLLISIONFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXCOLLISIONFRAMES_TXCOLLISIONFRAMES_SHIFT   (0x00000000u)


/* TXSINGLECOLLFRAMES */
#define CPSW_CPDMA_TXSINGLECOLLFRAMES_TXSINGLECOLLFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXSINGLECOLLFRAMES_TXSINGLECOLLFRAMES_SHIFT   (0x00000000u)


/* TXMULTCOLLFRAMES */
#define CPSW_CPDMA_TXMULTCOLLFRAMES_TXMULTCOLLFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXMULTCOLLFRAMES_TXMULTCOLLFRAMES_SHIFT   (0x00000000u)


/* TXEXCESSIVECOLLISIONS */
#define CPSW_CPDMA_TXEXCESSIVECOLLISIONS_TXEXCESSIVECOLLISIONS   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXEXCESSIVECOLLISIONS_TXEXCESSIVECOLLISIONS_SHIFT   (0x00000000u)


/* TXLATECOLLISIONS */
#define CPSW_CPDMA_TXLATECOLLISIONS_TXLATECOLLISIONS   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXLATECOLLISIONS_TXLATECOLLISIONS_SHIFT   (0x00000000u)


/* TXUNDERRUN */
#define CPSW_CPDMA_TXUNDERRUN_TXUNDERRUN   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXUNDERRUN_TXUNDERRUN_SHIFT   (0x00000000u)


/* TXCARRIERSENSEERRORS */
#define CPSW_CPDMA_TXCARRIERSENSEERRORS_TXCARRIERSENSEERRORS   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXCARRIERSENSEERRORS_TXCARRIERSENSEERRORS_SHIFT   (0x00000000u)


/* TXOCTETS */
#define CPSW_CPDMA_TXOCTETS_TXOCTETS   (0xFFFFFFFFu)
#define CPSW_CPDMA_TXOCTETS_TXOCTETS_SHIFT   (0x00000000u)


/* 64OCTETFRAMES */
#define CPSW_CPDMA_64OCTETFRAMES_64OCTETFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_64OCTETFRAMES_64OCTETFRAMES_SHIFT   (0x00000000u)


/* 65T127OCTETFRAMES */
#define CPSW_CPDMA_65T127OCTETFRAMES_65T127OCTETFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_65T127OCTETFRAMES_65T127OCTETFRAMES_SHIFT   (0x00000000u)


/* 128T255OCTETFRAMES */
#define CPSW_CPDMA_128T255OCTETFRAMES_128T255OCTETFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_128T255OCTETFRAMES_128T255OCTETFRAMES_SHIFT   (0x00000000u)


/* 256T511OCTETFRAMES */
#define CPSW_CPDMA_256T511OCTETFRAMES_256T511OCTETFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_256T511OCTETFRAMES_256T511OCTETFRAMES_SHIFT   (0x00000000u)


/* 512T1023OCTETFRAMES */
#define CPSW_CPDMA_512T1023OCTETFRAMES_512T1023OCTETFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_512T1023OCTETFRAMES_512T1023OCTETFRAMES_SHIFT   (0x00000000u)


/* 1024TUPOCTETFRAMES */
#define CPSW_CPDMA_1024TUPOCTETFRAMES_1024TUPOCTETFRAMES   (0xFFFFFFFFu)
#define CPSW_CPDMA_1024TUPOCTETFRAMES_1024TUPOCTETFRAMES_SHIFT   (0x00000000u)


/* NETOCTETS */
#define CPSW_CPDMA_NETOCTETS_NETOCTETS   (0xFFFFFFFFu)
#define CPSW_CPDMA_NETOCTETS_NETOCTETS_SHIFT   (0x00000000u)


/* RXSOFOVERRUNS */
#define CPSW_CPDMA_RXSOFOVERRUNS_RXSOFOVERRUNS   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXSOFOVERRUNS_RXSOFOVERRUNS_SHIFT   (0x00000000u)


/* RXMOFOVERRUNS */
#define CPSW_CPDMA_RXMOFOVERRUNS_RXMOFOVERRUNS   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXMOFOVERRUNS_RXMOFOVERRUNS_SHIFT   (0x00000000u)


/* RXDMAOVERRUNS */
#define CPSW_CPDMA_RXDMAOVERRUNS_RXDMAOVERRUNS   (0xFFFFFFFFu)
#define CPSW_CPDMA_RXDMAOVERRUNS_RXDMAOVERRUNS_SHIFT   (0x00000000u)


/* TX0_HDP */
#define CPSW_CPDMA_TX0_HDP_TX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX0_HDP_TX_HDP_SHIFT   (0x00000000u)


/* TX1_HDP */
#define CPSW_CPDMA_TX1_HDP_TX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX1_HDP_TX_HDP_SHIFT   (0x00000000u)


/* TX2_HDP */
#define CPSW_CPDMA_TX2_HDP_TX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX2_HDP_TX_HDP_SHIFT   (0x00000000u)


/* TX3_HDP */
#define CPSW_CPDMA_TX3_HDP_TX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX3_HDP_TX_HDP_SHIFT   (0x00000000u)


/* TX4_HDP */
#define CPSW_CPDMA_TX4_HDP_TX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX4_HDP_TX_HDP_SHIFT   (0x00000000u)


/* TX5_HDP */
#define CPSW_CPDMA_TX5_HDP_TX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX5_HDP_TX_HDP_SHIFT   (0x00000000u)


/* TX6_HDP */
#define CPSW_CPDMA_TX6_HDP_TX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX6_HDP_TX_HDP_SHIFT   (0x00000000u)


/* TX7_HDP */
#define CPSW_CPDMA_TX7_HDP_TX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX7_HDP_TX_HDP_SHIFT   (0x00000000u)


/* RX0_HDP */
#define CPSW_CPDMA_RX0_HDP_RX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX0_HDP_RX_HDP_SHIFT   (0x00000000u)


/* RX1_HDP */
#define CPSW_CPDMA_RX1_HDP_RX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX1_HDP_RX_HDP_SHIFT   (0x00000000u)


/* RX2_HDP */
#define CPSW_CPDMA_RX2_HDP_RX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX2_HDP_RX_HDP_SHIFT   (0x00000000u)


/* RX3_HDP */
#define CPSW_CPDMA_RX3_HDP_RX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX3_HDP_RX_HDP_SHIFT   (0x00000000u)


/* RX4_HDP */
#define CPSW_CPDMA_RX4_HDP_RX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX4_HDP_RX_HDP_SHIFT   (0x00000000u)


/* RX5_HDP */
#define CPSW_CPDMA_RX5_HDP_RX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX5_HDP_RX_HDP_SHIFT   (0x00000000u)


/* RX6_HDP */
#define CPSW_CPDMA_RX6_HDP_RX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX6_HDP_RX_HDP_SHIFT   (0x00000000u)


/* RX7_HDP */
#define CPSW_CPDMA_RX7_HDP_RX_HDP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX7_HDP_RX_HDP_SHIFT   (0x00000000u)


/* TX0_CP */
#define CPSW_CPDMA_TX0_CP_TX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX0_CP_TX_CP_SHIFT   (0x00000000u)


/* TX1_CP */
#define CPSW_CPDMA_TX1_CP_TX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX1_CP_TX_CP_SHIFT   (0x00000000u)


/* TX2_CP */
#define CPSW_CPDMA_TX2_CP_TX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX2_CP_TX_CP_SHIFT   (0x00000000u)


/* TX3_CP */
#define CPSW_CPDMA_TX3_CP_TX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX3_CP_TX_CP_SHIFT   (0x00000000u)


/* TX4_CP */
#define CPSW_CPDMA_TX4_CP_TX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX4_CP_TX_CP_SHIFT   (0x00000000u)


/* TX5_CP */
#define CPSW_CPDMA_TX5_CP_TX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX5_CP_TX_CP_SHIFT   (0x00000000u)


/* TX6_CP */
#define CPSW_CPDMA_TX6_CP_TX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX6_CP_TX_CP_SHIFT   (0x00000000u)


/* TX7_CP */
#define CPSW_CPDMA_TX7_CP_TX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_TX7_CP_TX_CP_SHIFT   (0x00000000u)


/* RX0_CP */
#define CPSW_CPDMA_RX0_CP_RX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX0_CP_RX_CP_SHIFT   (0x00000000u)


/* RX1_CP */
#define CPSW_CPDMA_RX1_CP_RX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX1_CP_RX_CP_SHIFT   (0x00000000u)


/* RX2_CP */
#define CPSW_CPDMA_RX2_CP_RX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX2_CP_RX_CP_SHIFT   (0x00000000u)


/* RX3_CP */
#define CPSW_CPDMA_RX3_CP_RX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX3_CP_RX_CP_SHIFT   (0x00000000u)


/* RX4_CP */
#define CPSW_CPDMA_RX4_CP_RX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX4_CP_RX_CP_SHIFT   (0x00000000u)


/* RX5_CP */
#define CPSW_CPDMA_RX5_CP_RX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX5_CP_RX_CP_SHIFT   (0x00000000u)


/* RX6_CP */
#define CPSW_CPDMA_RX6_CP_RX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX6_CP_RX_CP_SHIFT   (0x00000000u)


/* RX7_CP */
#define CPSW_CPDMA_RX7_CP_RX_CP   (0xFFFFFFFFu)
#define CPSW_CPDMA_RX7_CP_RX_CP_SHIFT   (0x00000000u)



#ifdef __cplusplus
}
#endif

#endif
