

/**
 *  @Component:   MCSPI
 *
 *  @Filename:    hw_mcspi.h
 *
 ============================================================================ */
/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_MCSPI_H_
#define _HW_MCSPI_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define MCSPI_HL_REV   (0x0)
#define MCSPI_HL_HWINFO   (0x4)
#define MCSPI_HL_SYSCONFIG   (0x10)
#define MCSPI_REVISION   (0x100)
#define MCSPI_SYSCONFIG   (0x110)
#define MCSPI_SYSSTATUS   (0x114)
#define MCSPI_IRQSTATUS   (0x118)
#define MCSPI_IRQENABLE   (0x11C)
#define MCSPI_WAKEUPENABLE   (0x120)
#define MCSPI_SYST   (0x124)
#define MCSPI_MODULCTRL   (0x128)
#define MCSPI_CHCONF(n)   (0x12C + (n * 0x14))
#define MCSPI_CHSTAT(n)   (0x130 + (n * 0x14))
#define MCSPI_CHCTRL(n)   (0x134 + (n * 0x14))
#define MCSPI_TX(n)   (0x138 + (n * 0x14))
#define MCSPI_RX(n)   (0x13C + (n * 0x14))
#define MCSPI_XFERLEVEL   (0x17C)

/**************************************************************************\ 
 * Field Definition Macros
\**************************************************************************/

/* HL_REV */
#define MCSPI_HL_REV_CUSTOM   (0x000000C0u)
#define MCSPI_HL_REV_CUSTOM_SHIFT   (0x00000006u)
#define MCSPI_HL_REV_CUSTOM_READ0   (0x0u)

#define MCSPI_HL_REV_FUNC   (0x0FFF0000u)
#define MCSPI_HL_REV_FUNC_SHIFT   (0x00000010u)

#define MCSPI_HL_REV_R_RTL   (0x0000F800u)
#define MCSPI_HL_REV_R_RTL_SHIFT   (0x0000000Bu)

#define MCSPI_HL_REV_SCHEME   (0xC0000000u)
#define MCSPI_HL_REV_SCHEME_SHIFT   (0x0000001Eu)
#define MCSPI_HL_REV_SCHEME_HIGHLANDER   (0x1u)
#define MCSPI_HL_REV_SCHEME_LEGACY   (0x0u)

#define MCSPI_HL_REV_X_MAJOR   (0x00000700u)
#define MCSPI_HL_REV_X_MAJOR_SHIFT   (0x00000008u)

#define MCSPI_HL_REV_Y_MINOR   (0x0000003Fu)
#define MCSPI_HL_REV_Y_MINOR_SHIFT   (0x00000000u)


/* HL_HWINFO */
#define MCSPI_HL_HWINFO_FFNBYTE   (0x0000003Eu)
#define MCSPI_HL_HWINFO_FFNBYTE_SHIFT   (0x00000001u)
#define MCSPI_HL_HWINFO_FFNBYTE_FF128BYTES   (0x8u)
#define MCSPI_HL_HWINFO_FFNBYTE_FF16BYTES   (0x1u)
#define MCSPI_HL_HWINFO_FFNBYTE_FF256BYTES   (0x10u)
#define MCSPI_HL_HWINFO_FFNBYTE_FF32BYTES   (0x2u)
#define MCSPI_HL_HWINFO_FFNBYTE_FF64BYTES   (0x4u)

#define MCSPI_HL_HWINFO_RETMODE   (0x00000040u)
#define MCSPI_HL_HWINFO_RETMODE_SHIFT   (0x00000006u)
#define MCSPI_HL_HWINFO_RETMODE_NORETMODE   (0x0u)
#define MCSPI_HL_HWINFO_RETMODE_RETMODEEN   (0x1u)

#define MCSPI_HL_HWINFO_USEFIFO   (0x00000001u)
#define MCSPI_HL_HWINFO_USEFIFO_SHIFT   (0x00000000u)
#define MCSPI_HL_HWINFO_USEFIFO_FIFOEN   (0x1u)
#define MCSPI_HL_HWINFO_USEFIFO_NOFIFO   (0x0u)


/* HL_SYSCONFIG */
#define MCSPI_HL_SYSCONFIG_FREEEMU   (0x00000002u)
#define MCSPI_HL_SYSCONFIG_FREEEMU_SHIFT   (0x00000001u)
#define MCSPI_HL_SYSCONFIG_FREEEMU_EMUDIS   (0x1u)
#define MCSPI_HL_SYSCONFIG_FREEEMU_EMUEN   (0x0u)

#define MCSPI_HL_SYSCONFIG_IDLEMODE   (0x0000000Cu)
#define MCSPI_HL_SYSCONFIG_IDLEMODE_SHIFT   (0x00000002u)
#define MCSPI_HL_SYSCONFIG_IDLEMODE_FORCE   (0x0u)
#define MCSPI_HL_SYSCONFIG_IDLEMODE_NOIDLE   (0x1u)
#define MCSPI_HL_SYSCONFIG_IDLEMODE_SMART   (0x2u)
#define MCSPI_HL_SYSCONFIG_IDLEMODE_WAKEUP   (0x3u)

#define MCSPI_HL_SYSCONFIG_SOFTRESET   (0x00000001u)
#define MCSPI_HL_SYSCONFIG_SOFTRESET_SHIFT   (0x00000000u)
#define MCSPI_HL_SYSCONFIG_SOFTRESET_DONE   (0x0u)
#define MCSPI_HL_SYSCONFIG_SOFTRESET_INITIATE   (0x1u)
#define MCSPI_HL_SYSCONFIG_SOFTRESET_ONGOING   (0x1u)


/* REVISION */
#define MCSPI_REVISION_REV   (0x000000FFu)
#define MCSPI_REVISION_REV_SHIFT   (0x00000000u)


/* SYSCONFIG */
#define MCSPI_SYSCONFIG_AUTOIDLE   (0x00000001u)
#define MCSPI_SYSCONFIG_AUTOIDLE_SHIFT   (0x00000000u)
#define MCSPI_SYSCONFIG_AUTOIDLE_DISABLE   (0x0u)
#define MCSPI_SYSCONFIG_AUTOIDLE_ENABLE   (0x1u)

#define MCSPI_SYSCONFIG_CLOCKACTIVITY   (0x00000300u)
#define MCSPI_SYSCONFIG_CLOCKACTIVITY_SHIFT   (0x00000008u)
#define MCSPI_SYSCONFIG_CLOCKACTIVITY_BOTH   (0x3u)
#define MCSPI_SYSCONFIG_CLOCKACTIVITY_FUNC   (0x2u)
#define MCSPI_SYSCONFIG_CLOCKACTIVITY_NONE   (0x0u)
#define MCSPI_SYSCONFIG_CLOCKACTIVITY_OCP   (0x1u)

#define MCSPI_SYSCONFIG_ENAWAKEUP   (0x00000004u)
#define MCSPI_SYSCONFIG_ENAWAKEUP_SHIFT   (0x00000002u)
#define MCSPI_SYSCONFIG_ENAWAKEUP_DISABLE   (0x0u)
#define MCSPI_SYSCONFIG_ENAWAKEUP_ENABLE   (0x1u)

#define MCSPI_SYSCONFIG_SIDLEMODE   (0x00000018u)
#define MCSPI_SYSCONFIG_SIDLEMODE_SHIFT   (0x00000003u)
#define MCSPI_SYSCONFIG_SIDLEMODE_FORCE   (0x0u)
#define MCSPI_SYSCONFIG_SIDLEMODE_NOIDLE   (0x1u)
#define MCSPI_SYSCONFIG_SIDLEMODE_SMART   (0x2u)
#define MCSPI_SYSCONFIG_SIDLEMODE_WAKEUP   (0x3u)

#define MCSPI_SYSCONFIG_SOFTRESET   (0x00000002u)
#define MCSPI_SYSCONFIG_SOFTRESET_SHIFT   (0x00000001u)
#define MCSPI_SYSCONFIG_SOFTRESET_DONE   (0x0u)
#define MCSPI_SYSCONFIG_SOFTRESET_INITIATE   (0x1u)
#define MCSPI_SYSCONFIG_SOFTRESET_ONGOING   (0x1u)


/* SYSSTATUS */
#define MCSPI_SYSSTATUS_RESETDONE   (0x00000001u)
#define MCSPI_SYSSTATUS_RESETDONE_SHIFT   (0x00000000u)
#define MCSPI_SYSSTATUS_RESETDONE_COMPLETED   (0x1u)
#define MCSPI_SYSSTATUS_RESETDONE_ONGOING   (0x0u)


/* IRQSTATUS */
#define MCSPI_IRQSTATUS_EOW   (0x00020000u)
#define MCSPI_IRQSTATUS_EOW_SHIFT   (0x00000011u)
#define MCSPI_IRQSTATUS_EOW_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_EOW_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_EOW_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_EOW_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_RX0_FULL   (0x00000004u)
#define MCSPI_IRQSTATUS_RX0_FULL_SHIFT   (0x00000002u)
#define MCSPI_IRQSTATUS_RX0_FULL_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_RX0_FULL_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_RX0_FULL_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_RX0_FULL_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_RX0_OVERFLOW   (0x00000008u)
#define MCSPI_IRQSTATUS_RX0_OVERFLOW_SHIFT   (0x00000003u)
#define MCSPI_IRQSTATUS_RX0_OVERFLOW_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_RX0_OVERFLOW_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_RX0_OVERFLOW_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_RX0_OVERFLOW_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_RX1_FULL   (0x00000040u)
#define MCSPI_IRQSTATUS_RX1_FULL_SHIFT   (0x00000006u)
#define MCSPI_IRQSTATUS_RX1_FULL_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_RX1_FULL_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_RX1_FULL_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_RX1_FULL_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_RX2_FULL   (0x00000400u)
#define MCSPI_IRQSTATUS_RX2_FULL_SHIFT   (0x0000000Au)
#define MCSPI_IRQSTATUS_RX2_FULL_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_RX2_FULL_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_RX2_FULL_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_RX2_FULL_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_RX3_FULL   (0x00004000u)
#define MCSPI_IRQSTATUS_RX3_FULL_SHIFT   (0x0000000Eu)
#define MCSPI_IRQSTATUS_RX3_FULL_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_RX3_FULL_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_RX3_FULL_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_RX3_FULL_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_TX0_EMPTY   (0x00000001u)
#define MCSPI_IRQSTATUS_TX0_EMPTY_SHIFT   (0x00000000u)
#define MCSPI_IRQSTATUS_TX0_EMPTY_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_TX0_EMPTY_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_TX0_EMPTY_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_TX0_EMPTY_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_TX0_UNDERFLOW   (0x00000002u)
#define MCSPI_IRQSTATUS_TX0_UNDERFLOW_SHIFT   (0x00000001u)
#define MCSPI_IRQSTATUS_TX0_UNDERFLOW_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_TX0_UNDERFLOW_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_TX0_UNDERFLOW_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_TX0_UNDERFLOW_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_TX1_EMPTY   (0x00000010u)
#define MCSPI_IRQSTATUS_TX1_EMPTY_SHIFT   (0x00000004u)
#define MCSPI_IRQSTATUS_TX1_EMPTY_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_TX1_EMPTY_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_TX1_EMPTY_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_TX1_EMPTY_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_TX1_UNDERFLOW   (0x00000020u)
#define MCSPI_IRQSTATUS_TX1_UNDERFLOW_SHIFT   (0x00000005u)
#define MCSPI_IRQSTATUS_TX1_UNDERFLOW_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_TX1_UNDERFLOW_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_TX1_UNDERFLOW_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_TX1_UNDERFLOW_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_TX2_EMPTY   (0x00000100u)
#define MCSPI_IRQSTATUS_TX2_EMPTY_SHIFT   (0x00000008u)
#define MCSPI_IRQSTATUS_TX2_EMPTY_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_TX2_EMPTY_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_TX2_EMPTY_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_TX2_EMPTY_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_TX2_UNDERFLOW   (0x00000200u)
#define MCSPI_IRQSTATUS_TX2_UNDERFLOW_SHIFT   (0x00000009u)
#define MCSPI_IRQSTATUS_TX2_UNDERFLOW_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_TX2_UNDERFLOW_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_TX2_UNDERFLOW_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_TX2_UNDERFLOW_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_TX3_EMPTY   (0x00001000u)
#define MCSPI_IRQSTATUS_TX3_EMPTY_SHIFT   (0x0000000Cu)
#define MCSPI_IRQSTATUS_TX3_EMPTY_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_TX3_EMPTY_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_TX3_EMPTY_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_TX3_EMPTY_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_TX3_UNDERFLOW   (0x00002000u)
#define MCSPI_IRQSTATUS_TX3_UNDERFLOW_SHIFT   (0x0000000Du)
#define MCSPI_IRQSTATUS_TX3_UNDERFLOW_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_TX3_UNDERFLOW_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_TX3_UNDERFLOW_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_TX3_UNDERFLOW_NOEVNT   (0x0u)

#define MCSPI_IRQSTATUS_WKS   (0x00010000u)
#define MCSPI_IRQSTATUS_WKS_SHIFT   (0x00000010u)
#define MCSPI_IRQSTATUS_WKS_EVNTPENDING   (0x1u)
#define MCSPI_IRQSTATUS_WKS_EVNTSTSRST   (0x1u)
#define MCSPI_IRQSTATUS_WKS_NOEFFECT   (0x0u)
#define MCSPI_IRQSTATUS_WKS_NOEVNT   (0x0u)


/* IRQENABLE */
#define MCSPI_IRQENABLE_EOW_ENABLE   (0x00020000u)
#define MCSPI_IRQENABLE_EOW_ENABLE_SHIFT   (0x00000011u)
#define MCSPI_IRQENABLE_EOW_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_EOW_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_RX0_FULL_ENABLE   (0x00000004u)
#define MCSPI_IRQENABLE_RX0_FULL_ENABLE_SHIFT   (0x00000002u)
#define MCSPI_IRQENABLE_RX0_FULL_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_RX0_FULL_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_RX0_OVERFLOW_ENABLE   (0x00000008u)
#define MCSPI_IRQENABLE_RX0_OVERFLOW_ENABLE_SHIFT   (0x00000003u)
#define MCSPI_IRQENABLE_RX0_OVERFLOW_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_RX0_OVERFLOW_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_RX1_FULL_ENABLE   (0x00000040u)
#define MCSPI_IRQENABLE_RX1_FULL_ENABLE_SHIFT   (0x00000006u)
#define MCSPI_IRQENABLE_RX1_FULL_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_RX1_FULL_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_RX2_FULL_ENABLE   (0x00000400u)
#define MCSPI_IRQENABLE_RX2_FULL_ENABLE_SHIFT   (0x0000000Au)
#define MCSPI_IRQENABLE_RX2_FULL_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_RX2_FULL_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_RX3_FULL_ENABLE   (0x00004000u)
#define MCSPI_IRQENABLE_RX3_FULL_ENABLE_SHIFT   (0x0000000Eu)
#define MCSPI_IRQENABLE_RX3_FULL_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_RX3_FULL_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_TX0_EMPTY_ENABLE   (0x00000001u)
#define MCSPI_IRQENABLE_TX0_EMPTY_ENABLE_SHIFT   (0x00000000u)
#define MCSPI_IRQENABLE_TX0_EMPTY_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_TX0_EMPTY_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_TX0_UNDERFLOW_ENABLE   (0x00000002u)
#define MCSPI_IRQENABLE_TX0_UNDERFLOW_ENABLE_SHIFT   (0x00000001u)
#define MCSPI_IRQENABLE_TX0_UNDERFLOW_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_TX0_UNDERFLOW_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_TX1_EMPTY_ENABLE   (0x00000010u)
#define MCSPI_IRQENABLE_TX1_EMPTY_ENABLE_SHIFT   (0x00000004u)
#define MCSPI_IRQENABLE_TX1_EMPTY_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_TX1_EMPTY_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_TX1_UNDERFLOW_ENABLE   (0x00000020u)
#define MCSPI_IRQENABLE_TX1_UNDERFLOW_ENABLE_SHIFT   (0x00000005u)
#define MCSPI_IRQENABLE_TX1_UNDERFLOW_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_TX1_UNDERFLOW_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_TX2_EMPTY_ENABLE   (0x00000100u)
#define MCSPI_IRQENABLE_TX2_EMPTY_ENABLE_SHIFT   (0x00000008u)
#define MCSPI_IRQENABLE_TX2_EMPTY_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_TX2_EMPTY_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_TX2_UNDERFLOW_ENABLE   (0x00000200u)
#define MCSPI_IRQENABLE_TX2_UNDERFLOW_ENABLE_SHIFT   (0x00000009u)
#define MCSPI_IRQENABLE_TX2_UNDERFLOW_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_TX2_UNDERFLOW_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_TX3_EMPTY_ENABLE   (0x00001000u)
#define MCSPI_IRQENABLE_TX3_EMPTY_ENABLE_SHIFT   (0x0000000Cu)
#define MCSPI_IRQENABLE_TX3_EMPTY_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_TX3_EMPTY_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_TX3_UNDERFLOW_ENABLE   (0x00002000u)
#define MCSPI_IRQENABLE_TX3_UNDERFLOW_ENABLE_SHIFT   (0x0000000Du)
#define MCSPI_IRQENABLE_TX3_UNDERFLOW_ENABLE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_TX3_UNDERFLOW_ENABLE_ENABLED   (0x1u)

#define MCSPI_IRQENABLE_WKE   (0x00010000u)
#define MCSPI_IRQENABLE_WKE_SHIFT   (0x00000010u)
#define MCSPI_IRQENABLE_WKE_DISABLED   (0x0u)
#define MCSPI_IRQENABLE_WKE_ENABLED   (0x1u)


/* WAKEUPENABLE */
#define MCSPI_WAKEUPENABLE_WKEN   (0x00000001u)
#define MCSPI_WAKEUPENABLE_WKEN_SHIFT   (0x00000000u)
#define MCSPI_WAKEUPENABLE_WKEN_NOWAKEUP   (0x0u)
#define MCSPI_WAKEUPENABLE_WKEN_WAKEUP   (0x1u)


/* SYST */
#define MCSPI_SYST_SPICLK   (0x00000040u)
#define MCSPI_SYST_SPICLK_SHIFT   (0x00000006u)

#define MCSPI_SYST_SPIDATDIR0   (0x00000100u)
#define MCSPI_SYST_SPIDATDIR0_SHIFT   (0x00000008u)
#define MCSPI_SYST_SPIDATDIR0_IN   (0x1u)
#define MCSPI_SYST_SPIDATDIR0_OUT   (0x0u)

#define MCSPI_SYST_SPIDATDIR1   (0x00000200u)
#define MCSPI_SYST_SPIDATDIR1_SHIFT   (0x00000009u)
#define MCSPI_SYST_SPIDATDIR1_IN   (0x1u)
#define MCSPI_SYST_SPIDATDIR1_OUT   (0x0u)

#define MCSPI_SYST_SPIDAT_0   (0x00000010u)
#define MCSPI_SYST_SPIDAT_0_SHIFT   (0x00000004u)

#define MCSPI_SYST_SPIDAT_1   (0x00000020u)
#define MCSPI_SYST_SPIDAT_1_SHIFT   (0x00000005u)

#define MCSPI_SYST_SPIENDIR   (0x00000400u)
#define MCSPI_SYST_SPIENDIR_SHIFT   (0x0000000Au)
#define MCSPI_SYST_SPIENDIR_IN   (0x1u)
#define MCSPI_SYST_SPIENDIR_OUT   (0x0u)

#define MCSPI_SYST_SPIEN_0   (0x00000001u)
#define MCSPI_SYST_SPIEN_0_SHIFT   (0x00000000u)

#define MCSPI_SYST_SPIEN_1   (0x00000002u)
#define MCSPI_SYST_SPIEN_1_SHIFT   (0x00000001u)

#define MCSPI_SYST_SPIEN_2   (0x00000004u)
#define MCSPI_SYST_SPIEN_2_SHIFT   (0x00000002u)

#define MCSPI_SYST_SPIEN_3   (0x00000008u)
#define MCSPI_SYST_SPIEN_3_SHIFT   (0x00000003u)

#define MCSPI_SYST_SSB   (0x00000800u)
#define MCSPI_SYST_SSB_SHIFT   (0x0000000Bu)
#define MCSPI_SYST_SSB_OFF   (0x0u)
#define MCSPI_SYST_SSB_SETALL   (0x1u)

#define MCSPI_SYST_WAKD   (0x00000080u)
#define MCSPI_SYST_WAKD_SHIFT   (0x00000007u)
#define MCSPI_SYST_WAKD_DRIVENHIGH   (0x1u)
#define MCSPI_SYST_WAKD_DRIVENLOW   (0x0u)


/* MODULCTRL */
#define MCSPI_MODULCTRL_FDAA   (0x00000100u)
#define MCSPI_MODULCTRL_FDAA_SHIFT   (0x00000008u)
#define MCSPI_MODULCTRL_FDAA_NOSHADOWREG   (0x0u)
#define MCSPI_MODULCTRL_FDAA_SHADOWREGEN   (0x1u)

#define MCSPI_MODULCTRL_INITDLY   (0x00000070u)
#define MCSPI_MODULCTRL_INITDLY_SHIFT   (0x00000004u)
#define MCSPI_MODULCTRL_INITDLY_16CLKDLY   (0x3u)
#define MCSPI_MODULCTRL_INITDLY_32CLKDLY   (0x4u)
#define MCSPI_MODULCTRL_INITDLY_4CLKDLY   (0x1u)
#define MCSPI_MODULCTRL_INITDLY_8CLKDLY   (0x2u)
#define MCSPI_MODULCTRL_INITDLY_NODELAY   (0x0u)

#define MCSPI_MODULCTRL_MOA   (0x00000080u)
#define MCSPI_MODULCTRL_MOA_SHIFT   (0x00000007u)
#define MCSPI_MODULCTRL_MOA_DISABLED   (0x0u)
#define MCSPI_MODULCTRL_MOA_ENABLED   (0x1u)

#define MCSPI_MODULCTRL_MS   (0x00000004u)
#define MCSPI_MODULCTRL_MS_SHIFT   (0x00000002u)
#define MCSPI_MODULCTRL_MS_MASTER   (0x0u)
#define MCSPI_MODULCTRL_MS_SLAVE   (0x1u)

#define MCSPI_MODULCTRL_PIN34   (0x00000002u)
#define MCSPI_MODULCTRL_PIN34_SHIFT   (0x00000001u)
#define MCSPI_MODULCTRL_PIN34_3PINMODE   (0x1u)
#define MCSPI_MODULCTRL_PIN34_4PINMODE   (0x0u)

#define MCSPI_MODULCTRL_SINGLE   (0x00000001u)
#define MCSPI_MODULCTRL_SINGLE_SHIFT   (0x00000000u)
#define MCSPI_MODULCTRL_SINGLE_MULTI   (0x0u)
#define MCSPI_MODULCTRL_SINGLE_SINGLE   (0x1u)

#define MCSPI_MODULCTRL_SYSTEM_TEST   (0x00000008u)
#define MCSPI_MODULCTRL_SYSTEM_TEST_SHIFT   (0x00000003u)
#define MCSPI_MODULCTRL_SYSTEM_TEST_OFF   (0x0u)
#define MCSPI_MODULCTRL_SYSTEM_TEST_ON   (0x1u)


/* CH0CONF */
#define MCSPI_CH0CONF_CLKD   (0x0000003Cu)
#define MCSPI_CH0CONF_CLKD_SHIFT   (0x00000002u)
#define MCSPI_CH0CONF_CLKD_DIVBY1   (0x0u)
#define MCSPI_CH0CONF_CLKD_DIVBY128   (0x7u)
#define MCSPI_CH0CONF_CLKD_DIVBY16   (0x4u)
#define MCSPI_CH0CONF_CLKD_DIVBY16K   (0xEu)
#define MCSPI_CH0CONF_CLKD_DIVBY1K   (0xAu)
#define MCSPI_CH0CONF_CLKD_DIVBY2   (0x1u)
#define MCSPI_CH0CONF_CLKD_DIVBY256   (0x8u)
#define MCSPI_CH0CONF_CLKD_DIVBY2K   (0xBu)
#define MCSPI_CH0CONF_CLKD_DIVBY32   (0x5u)
#define MCSPI_CH0CONF_CLKD_DIVBY32K   (0xFu)
#define MCSPI_CH0CONF_CLKD_DIVBY4   (0x2u)
#define MCSPI_CH0CONF_CLKD_DIVBY4K   (0xCu)
#define MCSPI_CH0CONF_CLKD_DIVBY512   (0x9u)
#define MCSPI_CH0CONF_CLKD_DIVBY64   (0x6u)
#define MCSPI_CH0CONF_CLKD_DIVBY8   (0x3u)
#define MCSPI_CH0CONF_CLKD_DIVBY8K   (0xDu)

#define MCSPI_CH0CONF_CLKG   (0x20000000u)
#define MCSPI_CH0CONF_CLKG_SHIFT   (0x0000001Du)
#define MCSPI_CH0CONF_CLKG_ONECYCLE   (0x1u)
#define MCSPI_CH0CONF_CLKG_POWERTWO   (0x0u)

#define MCSPI_CH0CONF_DMAR   (0x00008000u)
#define MCSPI_CH0CONF_DMAR_SHIFT   (0x0000000Fu)
#define MCSPI_CH0CONF_DMAR_DISABLED   (0x0u)
#define MCSPI_CH0CONF_DMAR_ENABLED   (0x1u)

#define MCSPI_CH0CONF_DMAW   (0x00004000u)
#define MCSPI_CH0CONF_DMAW_SHIFT   (0x0000000Eu)
#define MCSPI_CH0CONF_DMAW_DISABLED   (0x0u)
#define MCSPI_CH0CONF_DMAW_ENABLED   (0x1u)

#define MCSPI_CH0CONF_DPE0   (0x00010000u)
#define MCSPI_CH0CONF_DPE0_SHIFT   (0x00000010u)
#define MCSPI_CH0CONF_DPE0_DISABLED   (0x1u)
#define MCSPI_CH0CONF_DPE0_ENABLED   (0x0u)

#define MCSPI_CH0CONF_DPE1   (0x00020000u)
#define MCSPI_CH0CONF_DPE1_SHIFT   (0x00000011u)
#define MCSPI_CH0CONF_DPE1_DISABLED   (0x1u)
#define MCSPI_CH0CONF_DPE1_ENABLED   (0x0u)

#define MCSPI_CH0CONF_EPOL   (0x00000040u)
#define MCSPI_CH0CONF_EPOL_SHIFT   (0x00000006u)
#define MCSPI_CH0CONF_EPOL_ACTIVEHIGH   (0x0u)
#define MCSPI_CH0CONF_EPOL_ACTIVELOW   (0x1u)

#define MCSPI_CH0CONF_FFER   (0x10000000u)
#define MCSPI_CH0CONF_FFER_SHIFT   (0x0000001Cu)
#define MCSPI_CH0CONF_FFER_FFDISABLED   (0x0u)
#define MCSPI_CH0CONF_FFER_FFENABLED   (0x1u)

#define MCSPI_CH0CONF_FFEW   (0x08000000u)
#define MCSPI_CH0CONF_FFEW_SHIFT   (0x0000001Bu)
#define MCSPI_CH0CONF_FFEW_FFDISABLED   (0x0u)
#define MCSPI_CH0CONF_FFEW_FFENABLED   (0x1u)

#define MCSPI_CH0CONF_FORCE   (0x00100000u)
#define MCSPI_CH0CONF_FORCE_SHIFT   (0x00000014u)
#define MCSPI_CH0CONF_FORCE_ASSERT   (0x1u)
#define MCSPI_CH0CONF_FORCE_DEASSERT   (0x0u)

#define MCSPI_CH0CONF_IS   (0x00040000u)
#define MCSPI_CH0CONF_IS_SHIFT   (0x00000012u)
#define MCSPI_CH0CONF_IS_LINE0   (0x0u)
#define MCSPI_CH0CONF_IS_LINE1   (0x1u)

#define MCSPI_CH0CONF_PHA   (0x00000001u)
#define MCSPI_CH0CONF_PHA_SHIFT   (0x00000000u)
#define MCSPI_CH0CONF_PHA_EVEN   (0x1u)
#define MCSPI_CH0CONF_PHA_ODD   (0x0u)

#define MCSPI_CH0CONF_POL   (0x00000002u)
#define MCSPI_CH0CONF_POL_SHIFT   (0x00000001u)
#define MCSPI_CH0CONF_POL_ACTIVEHIGH   (0x0u)
#define MCSPI_CH0CONF_POL_ACTIVELOW   (0x1u)

#define MCSPI_CH0CONF_SBE   (0x00800000u)
#define MCSPI_CH0CONF_SBE_SHIFT   (0x00000017u)
#define MCSPI_CH0CONF_SBE_DISABLED   (0x0u)
#define MCSPI_CH0CONF_SBE_ENABLED   (0x1u)

#define MCSPI_CH0CONF_SBPOL   (0x01000000u)
#define MCSPI_CH0CONF_SBPOL_SHIFT   (0x00000018u)
#define MCSPI_CH0CONF_SBPOL_HIGHLEVEL   (0x1u)
#define MCSPI_CH0CONF_SBPOL_LOWLEVEL   (0x0u)

#define MCSPI_CH0CONF_SPIENSLV   (0x00600000u)
#define MCSPI_CH0CONF_SPIENSLV_SHIFT   (0x00000015u)
#define MCSPI_CH0CONF_SPIENSLV_SPIEN0   (0x0u)
#define MCSPI_CH0CONF_SPIENSLV_SPIEN1   (0x1u)
#define MCSPI_CH0CONF_SPIENSLV_SPIEN2   (0x2u)
#define MCSPI_CH0CONF_SPIENSLV_SPIEN3   (0x3u)

#define MCSPI_CH0CONF_TCS0   (0x06000000u)
#define MCSPI_CH0CONF_TCS0_SHIFT   (0x00000019u)
#define MCSPI_CH0CONF_TCS0_0P5   (0x0u)
#define MCSPI_CH0CONF_TCS0_1P5   (0x1u)
#define MCSPI_CH0CONF_TCS0_2P5   (0x2u)
#define MCSPI_CH0CONF_TCS0_3P5   (0x3u)

#define MCSPI_CH0CONF_TRM   (0x00003000u)
#define MCSPI_CH0CONF_TRM_SHIFT   (0x0000000Cu)
#define MCSPI_CH0CONF_TRM_RXONLY   (0x1u)
#define MCSPI_CH0CONF_TRM_TXONLY   (0x2u)
#define MCSPI_CH0CONF_TRM_TXRX   (0x0u)

#define MCSPI_CH0CONF_TURBO   (0x00080000u)
#define MCSPI_CH0CONF_TURBO_SHIFT   (0x00000013u)
#define MCSPI_CH0CONF_TURBO_DISABLED   (0x0u)
#define MCSPI_CH0CONF_TURBO_ENABLED   (0x1u)

#define MCSPI_CH0CONF_WL   (0x00000F80u)
#define MCSPI_CH0CONF_WL_SHIFT   (0x00000007u)
#define MCSPI_CH0CONF_WL_10BITS   (0x9u)
#define MCSPI_CH0CONF_WL_11BITS   (0xAu)
#define MCSPI_CH0CONF_WL_12BITS   (0xBu)
#define MCSPI_CH0CONF_WL_13BITS   (0xCu)
#define MCSPI_CH0CONF_WL_14BITS   (0xDu)
#define MCSPI_CH0CONF_WL_15BITS   (0xEu)
#define MCSPI_CH0CONF_WL_16BITS   (0xFu)
#define MCSPI_CH0CONF_WL_17BITS   (0x10u)
#define MCSPI_CH0CONF_WL_18BITS   (0x11u)
#define MCSPI_CH0CONF_WL_19BITS   (0x12u)
#define MCSPI_CH0CONF_WL_20BITS   (0x13u)
#define MCSPI_CH0CONF_WL_21BITS   (0x14u)
#define MCSPI_CH0CONF_WL_22BITS   (0x15u)
#define MCSPI_CH0CONF_WL_23BITS   (0x16u)
#define MCSPI_CH0CONF_WL_24BITS   (0x17u)
#define MCSPI_CH0CONF_WL_25BITS   (0x18u)
#define MCSPI_CH0CONF_WL_26BITS   (0x19u)
#define MCSPI_CH0CONF_WL_27BITS   (0x1Au)
#define MCSPI_CH0CONF_WL_28BITS   (0x1Bu)
#define MCSPI_CH0CONF_WL_29BITS   (0x1Cu)
#define MCSPI_CH0CONF_WL_30BITS   (0x1Du)
#define MCSPI_CH0CONF_WL_31BITS   (0x1Eu)
#define MCSPI_CH0CONF_WL_32BITS   (0x1Fu)
#define MCSPI_CH0CONF_WL_4BITS   (0x3u)
#define MCSPI_CH0CONF_WL_5BITS   (0x4u)
#define MCSPI_CH0CONF_WL_6BITS   (0x5u)
#define MCSPI_CH0CONF_WL_7BITS   (0x6u)
#define MCSPI_CH0CONF_WL_8BITS   (0x7u)
#define MCSPI_CH0CONF_WL_9BITS   (0x8u)


/* CH0STAT */
#define MCSPI_CH0STAT_EOT   (0x00000004u)
#define MCSPI_CH0STAT_EOT_SHIFT   (0x00000002u)
#define MCSPI_CH0STAT_EOT_COMPLETED   (0x1u)
#define MCSPI_CH0STAT_EOT_INPROGRESS   (0x0u)

#define MCSPI_CH0STAT_RXFFE   (0x00000020u)
#define MCSPI_CH0STAT_RXFFE_SHIFT   (0x00000005u)
#define MCSPI_CH0STAT_RXFFE_EMPTY   (0x1u)
#define MCSPI_CH0STAT_RXFFE_NOTEMPTY   (0x0u)

#define MCSPI_CH0STAT_RXFFF   (0x00000040u)
#define MCSPI_CH0STAT_RXFFF_SHIFT   (0x00000006u)
#define MCSPI_CH0STAT_RXFFF_FULL   (0x1u)
#define MCSPI_CH0STAT_RXFFF_NOTFULL   (0x0u)

#define MCSPI_CH0STAT_RXS   (0x00000001u)
#define MCSPI_CH0STAT_RXS_SHIFT   (0x00000000u)
#define MCSPI_CH0STAT_RXS_EMPTY   (0x0u)
#define MCSPI_CH0STAT_RXS_FULL   (0x1u)

#define MCSPI_CH0STAT_TXFFE   (0x00000008u)
#define MCSPI_CH0STAT_TXFFE_SHIFT   (0x00000003u)
#define MCSPI_CH0STAT_TXFFE_EMPTY   (0x1u)
#define MCSPI_CH0STAT_TXFFE_NOTEMPTY   (0x0u)

#define MCSPI_CH0STAT_TXFFF   (0x00000010u)
#define MCSPI_CH0STAT_TXFFF_SHIFT   (0x00000004u)
#define MCSPI_CH0STAT_TXFFF_FULL   (0x1u)
#define MCSPI_CH0STAT_TXFFF_NOTFULL   (0x0u)

#define MCSPI_CH0STAT_TXS   (0x00000002u)
#define MCSPI_CH0STAT_TXS_SHIFT   (0x00000001u)
#define MCSPI_CH0STAT_TXS_EMPTY   (0x1u)
#define MCSPI_CH0STAT_TXS_FULL   (0x0u)


/* CH0CTRL */
#define MCSPI_CH0CTRL_EN   (0x00000001u)
#define MCSPI_CH0CTRL_EN_SHIFT   (0x00000000u)
#define MCSPI_CH0CTRL_EN_ACTIVE   (0x1u)
#define MCSPI_CH0CTRL_EN_INACTIVE   (0x0u)

#define MCSPI_CH0CTRL_EXTCLK   (0x0000FF00u)
#define MCSPI_CH0CTRL_EXTCLK_SHIFT   (0x00000008u)
#define MCSPI_CH0CTRL_EXTCLK_EXT4080   (0xFFu)
#define MCSPI_CH0CTRL_EXTCLK_EXTONE   (0x1u)
#define MCSPI_CH0CTRL_EXTCLK_EXTZERO   (0x0u)


/* TX0 */
#define MCSPI_TX0_TDATA   (0xFFFFFFFFu)
#define MCSPI_TX0_TDATA_SHIFT   (0x00000000u)


/* RX0 */
#define MCSPI_RX0_RDATA   (0xFFFFFFFFu)
#define MCSPI_RX0_RDATA_SHIFT   (0x00000000u)


/* CH1CONF */
#define MCSPI_CH1CONF_CLKD   (0x0000003Cu)
#define MCSPI_CH1CONF_CLKD_SHIFT   (0x00000002u)
#define MCSPI_CH1CONF_CLKD_DIVBY1   (0x0u)
#define MCSPI_CH1CONF_CLKD_DIVBY128   (0x7u)
#define MCSPI_CH1CONF_CLKD_DIVBY16   (0x4u)
#define MCSPI_CH1CONF_CLKD_DIVBY16K   (0xEu)
#define MCSPI_CH1CONF_CLKD_DIVBY1K   (0xAu)
#define MCSPI_CH1CONF_CLKD_DIVBY2   (0x1u)
#define MCSPI_CH1CONF_CLKD_DIVBY256   (0x8u)
#define MCSPI_CH1CONF_CLKD_DIVBY2K   (0xBu)
#define MCSPI_CH1CONF_CLKD_DIVBY32   (0x5u)
#define MCSPI_CH1CONF_CLKD_DIVBY32K   (0xFu)
#define MCSPI_CH1CONF_CLKD_DIVBY4   (0x2u)
#define MCSPI_CH1CONF_CLKD_DIVBY4K   (0xCu)
#define MCSPI_CH1CONF_CLKD_DIVBY512   (0x9u)
#define MCSPI_CH1CONF_CLKD_DIVBY64   (0x6u)
#define MCSPI_CH1CONF_CLKD_DIVBY8   (0x3u)
#define MCSPI_CH1CONF_CLKD_DIVBY8K   (0xDu)

#define MCSPI_CH1CONF_CLKG   (0x20000000u)
#define MCSPI_CH1CONF_CLKG_SHIFT   (0x0000001Du)
#define MCSPI_CH1CONF_CLKG_ONECYCLE   (0x1u)
#define MCSPI_CH1CONF_CLKG_POWERTWO   (0x0u)

#define MCSPI_CH1CONF_DMAR   (0x00008000u)
#define MCSPI_CH1CONF_DMAR_SHIFT   (0x0000000Fu)
#define MCSPI_CH1CONF_DMAR_DISABLED   (0x0u)
#define MCSPI_CH1CONF_DMAR_ENABLED   (0x1u)

#define MCSPI_CH1CONF_DMAW   (0x00004000u)
#define MCSPI_CH1CONF_DMAW_SHIFT   (0x0000000Eu)
#define MCSPI_CH1CONF_DMAW_DISABLED   (0x0u)
#define MCSPI_CH1CONF_DMAW_ENABLED   (0x1u)

#define MCSPI_CH1CONF_DPE0   (0x00010000u)
#define MCSPI_CH1CONF_DPE0_SHIFT   (0x00000010u)
#define MCSPI_CH1CONF_DPE0_DISABLED   (0x1u)
#define MCSPI_CH1CONF_DPE0_ENABLED   (0x0u)

#define MCSPI_CH1CONF_DPE1   (0x00020000u)
#define MCSPI_CH1CONF_DPE1_SHIFT   (0x00000011u)
#define MCSPI_CH1CONF_DPE1_DISABLED   (0x1u)
#define MCSPI_CH1CONF_DPE1_ENABLED   (0x0u)

#define MCSPI_CH1CONF_EPOL   (0x00000040u)
#define MCSPI_CH1CONF_EPOL_SHIFT   (0x00000006u)
#define MCSPI_CH1CONF_EPOL_ACTIVEHIGH   (0x0u)
#define MCSPI_CH1CONF_EPOL_ACTIVELOW   (0x1u)

#define MCSPI_CH1CONF_FFER   (0x10000000u)
#define MCSPI_CH1CONF_FFER_SHIFT   (0x0000001Cu)
#define MCSPI_CH1CONF_FFER_FFDISABLED   (0x0u)
#define MCSPI_CH1CONF_FFER_FFENABLED   (0x1u)

#define MCSPI_CH1CONF_FFEW   (0x08000000u)
#define MCSPI_CH1CONF_FFEW_SHIFT   (0x0000001Bu)
#define MCSPI_CH1CONF_FFEW_FFDISABLED   (0x0u)
#define MCSPI_CH1CONF_FFEW_FFENABLED   (0x1u)

#define MCSPI_CH1CONF_FORCE   (0x00100000u)
#define MCSPI_CH1CONF_FORCE_SHIFT   (0x00000014u)
#define MCSPI_CH1CONF_FORCE_ASSERT   (0x1u)
#define MCSPI_CH1CONF_FORCE_DEASSERT   (0x0u)

#define MCSPI_CH1CONF_IS   (0x00040000u)
#define MCSPI_CH1CONF_IS_SHIFT   (0x00000012u)
#define MCSPI_CH1CONF_IS_LINE0   (0x0u)
#define MCSPI_CH1CONF_IS_LINE1   (0x1u)

#define MCSPI_CH1CONF_PHA   (0x00000001u)
#define MCSPI_CH1CONF_PHA_SHIFT   (0x00000000u)
#define MCSPI_CH1CONF_PHA_EVEN   (0x1u)
#define MCSPI_CH1CONF_PHA_ODD   (0x0u)

#define MCSPI_CH1CONF_POL   (0x00000002u)
#define MCSPI_CH1CONF_POL_SHIFT   (0x00000001u)
#define MCSPI_CH1CONF_POL_ACTIVEHIGH   (0x0u)
#define MCSPI_CH1CONF_POL_ACTIVELOW   (0x1u)

#define MCSPI_CH1CONF_SBE   (0x00800000u)
#define MCSPI_CH1CONF_SBE_SHIFT   (0x00000017u)
#define MCSPI_CH1CONF_SBE_DISABLED   (0x0u)
#define MCSPI_CH1CONF_SBE_ENABLED   (0x1u)

#define MCSPI_CH1CONF_SBPOL   (0x01000000u)
#define MCSPI_CH1CONF_SBPOL_SHIFT   (0x00000018u)
#define MCSPI_CH1CONF_SBPOL_HIGHLEVEL   (0x1u)
#define MCSPI_CH1CONF_SBPOL_LOWLEVEL   (0x0u)

#define MCSPI_CH1CONF_TCS1   (0x06000000u)
#define MCSPI_CH1CONF_TCS1_SHIFT   (0x00000019u)
#define MCSPI_CH1CONF_TCS1_0P5   (0x0u)
#define MCSPI_CH1CONF_TCS1_1P5   (0x1u)
#define MCSPI_CH1CONF_TCS1_2P5   (0x2u)
#define MCSPI_CH1CONF_TCS1_3P5   (0x3u)

#define MCSPI_CH1CONF_TRM   (0x00003000u)
#define MCSPI_CH1CONF_TRM_SHIFT   (0x0000000Cu)
#define MCSPI_CH1CONF_TRM_RXONLY   (0x1u)
#define MCSPI_CH1CONF_TRM_TXONLY   (0x2u)
#define MCSPI_CH1CONF_TRM_TXRX   (0x0u)

#define MCSPI_CH1CONF_TURBO   (0x00080000u)
#define MCSPI_CH1CONF_TURBO_SHIFT   (0x00000013u)
#define MCSPI_CH1CONF_TURBO_DISABLED   (0x0u)
#define MCSPI_CH1CONF_TURBO_ENABLED   (0x1u)

#define MCSPI_CH1CONF_WL   (0x00000F80u)
#define MCSPI_CH1CONF_WL_SHIFT   (0x00000007u)
#define MCSPI_CH1CONF_WL_10BITS   (0x9u)
#define MCSPI_CH1CONF_WL_11BITS   (0xAu)
#define MCSPI_CH1CONF_WL_12BITS   (0xBu)
#define MCSPI_CH1CONF_WL_13BITS   (0xCu)
#define MCSPI_CH1CONF_WL_14BITS   (0xDu)
#define MCSPI_CH1CONF_WL_15BITS   (0xEu)
#define MCSPI_CH1CONF_WL_16BITS   (0xFu)
#define MCSPI_CH1CONF_WL_17BITS   (0x10u)
#define MCSPI_CH1CONF_WL_18BITS   (0x11u)
#define MCSPI_CH1CONF_WL_19BITS   (0x12u)
#define MCSPI_CH1CONF_WL_20BITS   (0x13u)
#define MCSPI_CH1CONF_WL_21BITS   (0x14u)
#define MCSPI_CH1CONF_WL_22BITS   (0x15u)
#define MCSPI_CH1CONF_WL_23BITS   (0x16u)
#define MCSPI_CH1CONF_WL_24BITS   (0x17u)
#define MCSPI_CH1CONF_WL_25BITS   (0x18u)
#define MCSPI_CH1CONF_WL_26BITS   (0x19u)
#define MCSPI_CH1CONF_WL_27BITS   (0x1Au)
#define MCSPI_CH1CONF_WL_28BITS   (0x1Bu)
#define MCSPI_CH1CONF_WL_29BITS   (0x1Cu)
#define MCSPI_CH1CONF_WL_30BITS   (0x1Du)
#define MCSPI_CH1CONF_WL_31BITS   (0x1Eu)
#define MCSPI_CH1CONF_WL_32BITS   (0x1Fu)
#define MCSPI_CH1CONF_WL_4BITS   (0x3u)
#define MCSPI_CH1CONF_WL_5BITS   (0x4u)
#define MCSPI_CH1CONF_WL_6BITS   (0x5u)
#define MCSPI_CH1CONF_WL_7BITS   (0x6u)
#define MCSPI_CH1CONF_WL_8BITS   (0x7u)
#define MCSPI_CH1CONF_WL_9BITS   (0x8u)


/* CH1STAT */
#define MCSPI_CH1STAT_EOT   (0x00000004u)
#define MCSPI_CH1STAT_EOT_SHIFT   (0x00000002u)
#define MCSPI_CH1STAT_EOT_COMPLETED   (0x1u)
#define MCSPI_CH1STAT_EOT_INPROGRESS   (0x0u)

#define MCSPI_CH1STAT_RXFFE   (0x00000020u)
#define MCSPI_CH1STAT_RXFFE_SHIFT   (0x00000005u)
#define MCSPI_CH1STAT_RXFFE_EMPTY   (0x1u)
#define MCSPI_CH1STAT_RXFFE_NOTEMPTY   (0x0u)

#define MCSPI_CH1STAT_RXFFF   (0x00000040u)
#define MCSPI_CH1STAT_RXFFF_SHIFT   (0x00000006u)
#define MCSPI_CH1STAT_RXFFF_FULL   (0x1u)
#define MCSPI_CH1STAT_RXFFF_NOTFULL   (0x0u)

#define MCSPI_CH1STAT_RXS   (0x00000001u)
#define MCSPI_CH1STAT_RXS_SHIFT   (0x00000000u)
#define MCSPI_CH1STAT_RXS_EMPTY   (0x0u)
#define MCSPI_CH1STAT_RXS_FULL   (0x1u)

#define MCSPI_CH1STAT_TXFFE   (0x00000008u)
#define MCSPI_CH1STAT_TXFFE_SHIFT   (0x00000003u)
#define MCSPI_CH1STAT_TXFFE_EMPTY   (0x1u)
#define MCSPI_CH1STAT_TXFFE_NOTEMPTY   (0x0u)

#define MCSPI_CH1STAT_TXFFF   (0x00000010u)
#define MCSPI_CH1STAT_TXFFF_SHIFT   (0x00000004u)
#define MCSPI_CH1STAT_TXFFF_FULL   (0x1u)
#define MCSPI_CH1STAT_TXFFF_NOTFULL   (0x0u)

#define MCSPI_CH1STAT_TXS   (0x00000002u)
#define MCSPI_CH1STAT_TXS_SHIFT   (0x00000001u)
#define MCSPI_CH1STAT_TXS_EMPTY   (0x1u)
#define MCSPI_CH1STAT_TXS_FULL   (0x0u)


/* CH1CTRL */
#define MCSPI_CH1CTRL_EN   (0x00000001u)
#define MCSPI_CH1CTRL_EN_SHIFT   (0x00000000u)
#define MCSPI_CH1CTRL_EN_ACTIVE   (0x1u)
#define MCSPI_CH1CTRL_EN_INACTIVE   (0x0u)

#define MCSPI_CH1CTRL_EXTCLK   (0x0000FF00u)
#define MCSPI_CH1CTRL_EXTCLK_SHIFT   (0x00000008u)
#define MCSPI_CH1CTRL_EXTCLK_EXT4080   (0xFFu)
#define MCSPI_CH1CTRL_EXTCLK_EXTONE   (0x1u)
#define MCSPI_CH1CTRL_EXTCLK_EXTZERO   (0x0u)


/* TX1 */
#define MCSPI_TX1_TDATA   (0xFFFFFFFFu)
#define MCSPI_TX1_TDATA_SHIFT   (0x00000000u)


/* RX1 */
#define MCSPI_RX1_RDATA   (0xFFFFFFFFu)
#define MCSPI_RX1_RDATA_SHIFT   (0x00000000u)


/* CH2CONF */
#define MCSPI_CH2CONF_CLKD   (0x0000003Cu)
#define MCSPI_CH2CONF_CLKD_SHIFT   (0x00000002u)
#define MCSPI_CH2CONF_CLKD_DIVBY1   (0x0u)
#define MCSPI_CH2CONF_CLKD_DIVBY128   (0x7u)
#define MCSPI_CH2CONF_CLKD_DIVBY16   (0x4u)
#define MCSPI_CH2CONF_CLKD_DIVBY16K   (0xEu)
#define MCSPI_CH2CONF_CLKD_DIVBY1K   (0xAu)
#define MCSPI_CH2CONF_CLKD_DIVBY2   (0x1u)
#define MCSPI_CH2CONF_CLKD_DIVBY256   (0x8u)
#define MCSPI_CH2CONF_CLKD_DIVBY2K   (0xBu)
#define MCSPI_CH2CONF_CLKD_DIVBY32   (0x5u)
#define MCSPI_CH2CONF_CLKD_DIVBY32K   (0xFu)
#define MCSPI_CH2CONF_CLKD_DIVBY4   (0x2u)
#define MCSPI_CH2CONF_CLKD_DIVBY4K   (0xCu)
#define MCSPI_CH2CONF_CLKD_DIVBY512   (0x9u)
#define MCSPI_CH2CONF_CLKD_DIVBY64   (0x6u)
#define MCSPI_CH2CONF_CLKD_DIVBY8   (0x3u)
#define MCSPI_CH2CONF_CLKD_DIVBY8K   (0xDu)

#define MCSPI_CH2CONF_CLKG   (0x20000000u)
#define MCSPI_CH2CONF_CLKG_SHIFT   (0x0000001Du)
#define MCSPI_CH2CONF_CLKG_ONECYCLE   (0x1u)
#define MCSPI_CH2CONF_CLKG_POWERTWO   (0x0u)

#define MCSPI_CH2CONF_DMAR   (0x00008000u)
#define MCSPI_CH2CONF_DMAR_SHIFT   (0x0000000Fu)
#define MCSPI_CH2CONF_DMAR_DISABLED   (0x0u)
#define MCSPI_CH2CONF_DMAR_ENABLED   (0x1u)

#define MCSPI_CH2CONF_DMAW   (0x00004000u)
#define MCSPI_CH2CONF_DMAW_SHIFT   (0x0000000Eu)
#define MCSPI_CH2CONF_DMAW_DISABLED   (0x0u)
#define MCSPI_CH2CONF_DMAW_ENABLED   (0x1u)

#define MCSPI_CH2CONF_DPE0   (0x00010000u)
#define MCSPI_CH2CONF_DPE0_SHIFT   (0x00000010u)
#define MCSPI_CH2CONF_DPE0_DISABLED   (0x1u)
#define MCSPI_CH2CONF_DPE0_ENABLED   (0x0u)

#define MCSPI_CH2CONF_DPE1   (0x00020000u)
#define MCSPI_CH2CONF_DPE1_SHIFT   (0x00000011u)
#define MCSPI_CH2CONF_DPE1_DISABLED   (0x1u)
#define MCSPI_CH2CONF_DPE1_ENABLED   (0x0u)

#define MCSPI_CH2CONF_EPOL   (0x00000040u)
#define MCSPI_CH2CONF_EPOL_SHIFT   (0x00000006u)
#define MCSPI_CH2CONF_EPOL_ACTIVEHIGH   (0x0u)
#define MCSPI_CH2CONF_EPOL_ACTIVELOW   (0x1u)

#define MCSPI_CH2CONF_FFER   (0x10000000u)
#define MCSPI_CH2CONF_FFER_SHIFT   (0x0000001Cu)
#define MCSPI_CH2CONF_FFER_FFDISABLED   (0x0u)
#define MCSPI_CH2CONF_FFER_FFENABLED   (0x1u)

#define MCSPI_CH2CONF_FFEW   (0x08000000u)
#define MCSPI_CH2CONF_FFEW_SHIFT   (0x0000001Bu)
#define MCSPI_CH2CONF_FFEW_FFDISABLED   (0x0u)
#define MCSPI_CH2CONF_FFEW_FFENABLED   (0x1u)

#define MCSPI_CH2CONF_FORCE   (0x00100000u)
#define MCSPI_CH2CONF_FORCE_SHIFT   (0x00000014u)
#define MCSPI_CH2CONF_FORCE_ASSERT   (0x1u)
#define MCSPI_CH2CONF_FORCE_DEASSERT   (0x0u)

#define MCSPI_CH2CONF_IS   (0x00040000u)
#define MCSPI_CH2CONF_IS_SHIFT   (0x00000012u)
#define MCSPI_CH2CONF_IS_LINE0   (0x0u)
#define MCSPI_CH2CONF_IS_LINE1   (0x1u)

#define MCSPI_CH2CONF_PHA   (0x00000001u)
#define MCSPI_CH2CONF_PHA_SHIFT   (0x00000000u)
#define MCSPI_CH2CONF_PHA_EVEN   (0x1u)
#define MCSPI_CH2CONF_PHA_ODD   (0x0u)

#define MCSPI_CH2CONF_POL   (0x00000002u)
#define MCSPI_CH2CONF_POL_SHIFT   (0x00000001u)
#define MCSPI_CH2CONF_POL_ACTIVEHIGH   (0x0u)
#define MCSPI_CH2CONF_POL_ACTIVELOW   (0x1u)

#define MCSPI_CH2CONF_SBE   (0x00800000u)
#define MCSPI_CH2CONF_SBE_SHIFT   (0x00000017u)
#define MCSPI_CH2CONF_SBE_DISABLED   (0x0u)
#define MCSPI_CH2CONF_SBE_ENABLED   (0x1u)

#define MCSPI_CH2CONF_SBPOL   (0x01000000u)
#define MCSPI_CH2CONF_SBPOL_SHIFT   (0x00000018u)
#define MCSPI_CH2CONF_SBPOL_HIGHLEVEL   (0x1u)
#define MCSPI_CH2CONF_SBPOL_LOWLEVEL   (0x0u)

#define MCSPI_CH2CONF_TCS2   (0x06000000u)
#define MCSPI_CH2CONF_TCS2_SHIFT   (0x00000019u)
#define MCSPI_CH2CONF_TCS2_0P5   (0x0u)
#define MCSPI_CH2CONF_TCS2_1P5   (0x1u)
#define MCSPI_CH2CONF_TCS2_2P5   (0x2u)
#define MCSPI_CH2CONF_TCS2_3P5   (0x3u)

#define MCSPI_CH2CONF_TRM   (0x00003000u)
#define MCSPI_CH2CONF_TRM_SHIFT   (0x0000000Cu)
#define MCSPI_CH2CONF_TRM_RXONLY   (0x1u)
#define MCSPI_CH2CONF_TRM_TXONLY   (0x2u)
#define MCSPI_CH2CONF_TRM_TXRX   (0x0u)

#define MCSPI_CH2CONF_TURBO   (0x00080000u)
#define MCSPI_CH2CONF_TURBO_SHIFT   (0x00000013u)
#define MCSPI_CH2CONF_TURBO_DISABLED   (0x0u)
#define MCSPI_CH2CONF_TURBO_ENABLED   (0x1u)

#define MCSPI_CH2CONF_WL   (0x00000F80u)
#define MCSPI_CH2CONF_WL_SHIFT   (0x00000007u)
#define MCSPI_CH2CONF_WL_10BITS   (0x9u)
#define MCSPI_CH2CONF_WL_11BITS   (0xAu)
#define MCSPI_CH2CONF_WL_12BITS   (0xBu)
#define MCSPI_CH2CONF_WL_13BITS   (0xCu)
#define MCSPI_CH2CONF_WL_14BITS   (0xDu)
#define MCSPI_CH2CONF_WL_15BITS   (0xEu)
#define MCSPI_CH2CONF_WL_16BITS   (0xFu)
#define MCSPI_CH2CONF_WL_17BITS   (0x10u)
#define MCSPI_CH2CONF_WL_18BITS   (0x11u)
#define MCSPI_CH2CONF_WL_19BITS   (0x12u)
#define MCSPI_CH2CONF_WL_20BITS   (0x13u)
#define MCSPI_CH2CONF_WL_21BITS   (0x14u)
#define MCSPI_CH2CONF_WL_22BITS   (0x15u)
#define MCSPI_CH2CONF_WL_23BITS   (0x16u)
#define MCSPI_CH2CONF_WL_24BITS   (0x17u)
#define MCSPI_CH2CONF_WL_25BITS   (0x18u)
#define MCSPI_CH2CONF_WL_26BITS   (0x19u)
#define MCSPI_CH2CONF_WL_27BITS   (0x1Au)
#define MCSPI_CH2CONF_WL_28BITS   (0x1Bu)
#define MCSPI_CH2CONF_WL_29BITS   (0x1Cu)
#define MCSPI_CH2CONF_WL_30BITS   (0x1Du)
#define MCSPI_CH2CONF_WL_31BITS   (0x1Eu)
#define MCSPI_CH2CONF_WL_32BITS   (0x1Fu)
#define MCSPI_CH2CONF_WL_4BITS   (0x3u)
#define MCSPI_CH2CONF_WL_5BITS   (0x4u)
#define MCSPI_CH2CONF_WL_6BITS   (0x5u)
#define MCSPI_CH2CONF_WL_7BITS   (0x6u)
#define MCSPI_CH2CONF_WL_8BITS   (0x7u)
#define MCSPI_CH2CONF_WL_9BITS   (0x8u)


/* CH2STAT */
#define MCSPI_CH2STAT_EOT   (0x00000004u)
#define MCSPI_CH2STAT_EOT_SHIFT   (0x00000002u)
#define MCSPI_CH2STAT_EOT_COMPLETED   (0x1u)
#define MCSPI_CH2STAT_EOT_INPROGRESS   (0x0u)

#define MCSPI_CH2STAT_RXFFE   (0x00000020u)
#define MCSPI_CH2STAT_RXFFE_SHIFT   (0x00000005u)
#define MCSPI_CH2STAT_RXFFE_EMPTY   (0x1u)
#define MCSPI_CH2STAT_RXFFE_NOTEMPTY   (0x0u)

#define MCSPI_CH2STAT_RXFFF   (0x00000040u)
#define MCSPI_CH2STAT_RXFFF_SHIFT   (0x00000006u)
#define MCSPI_CH2STAT_RXFFF_FULL   (0x1u)
#define MCSPI_CH2STAT_RXFFF_NOTFULL   (0x0u)

#define MCSPI_CH2STAT_RXS   (0x00000001u)
#define MCSPI_CH2STAT_RXS_SHIFT   (0x00000000u)
#define MCSPI_CH2STAT_RXS_EMPTY   (0x0u)
#define MCSPI_CH2STAT_RXS_FULL   (0x1u)

#define MCSPI_CH2STAT_TXFFE   (0x00000008u)
#define MCSPI_CH2STAT_TXFFE_SHIFT   (0x00000003u)
#define MCSPI_CH2STAT_TXFFE_EMPTY   (0x1u)
#define MCSPI_CH2STAT_TXFFE_NOTEMPTY   (0x0u)

#define MCSPI_CH2STAT_TXFFF   (0x00000010u)
#define MCSPI_CH2STAT_TXFFF_SHIFT   (0x00000004u)
#define MCSPI_CH2STAT_TXFFF_FULL   (0x1u)
#define MCSPI_CH2STAT_TXFFF_NOTFULL   (0x0u)

#define MCSPI_CH2STAT_TXS   (0x00000002u)
#define MCSPI_CH2STAT_TXS_SHIFT   (0x00000001u)
#define MCSPI_CH2STAT_TXS_EMPTY   (0x1u)
#define MCSPI_CH2STAT_TXS_FULL   (0x0u)


/* CH2CTRL */
#define MCSPI_CH2CTRL_EN   (0x00000001u)
#define MCSPI_CH2CTRL_EN_SHIFT   (0x00000000u)
#define MCSPI_CH2CTRL_EN_ACTIVE   (0x1u)
#define MCSPI_CH2CTRL_EN_INACTIVE   (0x0u)

#define MCSPI_CH2CTRL_EXTCLK   (0x0000FF00u)
#define MCSPI_CH2CTRL_EXTCLK_SHIFT   (0x00000008u)
#define MCSPI_CH2CTRL_EXTCLK_EXT4080   (0xFFu)
#define MCSPI_CH2CTRL_EXTCLK_EXTONE   (0x1u)
#define MCSPI_CH2CTRL_EXTCLK_EXTZERO   (0x0u)


/* TX2 */
#define MCSPI_TX2_TDATA   (0xFFFFFFFFu)
#define MCSPI_TX2_TDATA_SHIFT   (0x00000000u)


/* RX2 */
#define MCSPI_RX2_RDATA   (0xFFFFFFFFu)
#define MCSPI_RX2_RDATA_SHIFT   (0x00000000u)


/* CH3CONF */
#define MCSPI_CH3CONF_CLKD   (0x0000003Cu)
#define MCSPI_CH3CONF_CLKD_SHIFT   (0x00000002u)
#define MCSPI_CH3CONF_CLKD_DIVBY1   (0x0u)
#define MCSPI_CH3CONF_CLKD_DIVBY128   (0x7u)
#define MCSPI_CH3CONF_CLKD_DIVBY16   (0x4u)
#define MCSPI_CH3CONF_CLKD_DIVBY16K   (0xEu)
#define MCSPI_CH3CONF_CLKD_DIVBY1K   (0xAu)
#define MCSPI_CH3CONF_CLKD_DIVBY2   (0x1u)
#define MCSPI_CH3CONF_CLKD_DIVBY256   (0x8u)
#define MCSPI_CH3CONF_CLKD_DIVBY2K   (0xBu)
#define MCSPI_CH3CONF_CLKD_DIVBY32   (0x5u)
#define MCSPI_CH3CONF_CLKD_DIVBY32K   (0xFu)
#define MCSPI_CH3CONF_CLKD_DIVBY4   (0x2u)
#define MCSPI_CH3CONF_CLKD_DIVBY4K   (0xCu)
#define MCSPI_CH3CONF_CLKD_DIVBY512   (0x9u)
#define MCSPI_CH3CONF_CLKD_DIVBY64   (0x6u)
#define MCSPI_CH3CONF_CLKD_DIVBY8   (0x3u)
#define MCSPI_CH3CONF_CLKD_DIVBY8K   (0xDu)

#define MCSPI_CH3CONF_CLKG   (0x20000000u)
#define MCSPI_CH3CONF_CLKG_SHIFT   (0x0000001Du)
#define MCSPI_CH3CONF_CLKG_ONECYCLE   (0x1u)
#define MCSPI_CH3CONF_CLKG_POWERTWO   (0x0u)

#define MCSPI_CH3CONF_DMAR   (0x00008000u)
#define MCSPI_CH3CONF_DMAR_SHIFT   (0x0000000Fu)
#define MCSPI_CH3CONF_DMAR_DISABLED   (0x0u)
#define MCSPI_CH3CONF_DMAR_ENABLED   (0x1u)

#define MCSPI_CH3CONF_DMAW   (0x00004000u)
#define MCSPI_CH3CONF_DMAW_SHIFT   (0x0000000Eu)
#define MCSPI_CH3CONF_DMAW_DISABLED   (0x0u)
#define MCSPI_CH3CONF_DMAW_ENABLED   (0x1u)

#define MCSPI_CH3CONF_DPE0   (0x00010000u)
#define MCSPI_CH3CONF_DPE0_SHIFT   (0x00000010u)
#define MCSPI_CH3CONF_DPE0_DISABLED   (0x1u)
#define MCSPI_CH3CONF_DPE0_ENABLED   (0x0u)

#define MCSPI_CH3CONF_DPE1   (0x00020000u)
#define MCSPI_CH3CONF_DPE1_SHIFT   (0x00000011u)
#define MCSPI_CH3CONF_DPE1_DISABLED   (0x1u)
#define MCSPI_CH3CONF_DPE1_ENABLED   (0x0u)

#define MCSPI_CH3CONF_EPOL   (0x00000040u)
#define MCSPI_CH3CONF_EPOL_SHIFT   (0x00000006u)
#define MCSPI_CH3CONF_EPOL_ACTIVEHIGH   (0x0u)
#define MCSPI_CH3CONF_EPOL_ACTIVELOW   (0x1u)

#define MCSPI_CH3CONF_FFER   (0x10000000u)
#define MCSPI_CH3CONF_FFER_SHIFT   (0x0000001Cu)
#define MCSPI_CH3CONF_FFER_FFDISABLED   (0x0u)
#define MCSPI_CH3CONF_FFER_FFENABLED   (0x1u)

#define MCSPI_CH3CONF_FFEW   (0x08000000u)
#define MCSPI_CH3CONF_FFEW_SHIFT   (0x0000001Bu)
#define MCSPI_CH3CONF_FFEW_FFDISABLED   (0x0u)
#define MCSPI_CH3CONF_FFEW_FFENABLED   (0x1u)

#define MCSPI_CH3CONF_FORCE   (0x00100000u)
#define MCSPI_CH3CONF_FORCE_SHIFT   (0x00000014u)
#define MCSPI_CH3CONF_FORCE_ASSERT   (0x1u)
#define MCSPI_CH3CONF_FORCE_DEASSERT   (0x0u)

#define MCSPI_CH3CONF_IS   (0x00040000u)
#define MCSPI_CH3CONF_IS_SHIFT   (0x00000012u)
#define MCSPI_CH3CONF_IS_LINE0   (0x0u)
#define MCSPI_CH3CONF_IS_LINE1   (0x1u)

#define MCSPI_CH3CONF_PHA   (0x00000001u)
#define MCSPI_CH3CONF_PHA_SHIFT   (0x00000000u)
#define MCSPI_CH3CONF_PHA_EVEN   (0x1u)
#define MCSPI_CH3CONF_PHA_ODD   (0x0u)

#define MCSPI_CH3CONF_POL   (0x00000002u)
#define MCSPI_CH3CONF_POL_SHIFT   (0x00000001u)
#define MCSPI_CH3CONF_POL_ACTIVEHIGH   (0x0u)
#define MCSPI_CH3CONF_POL_ACTIVELOW   (0x1u)

#define MCSPI_CH3CONF_SBE   (0x00800000u)
#define MCSPI_CH3CONF_SBE_SHIFT   (0x00000017u)
#define MCSPI_CH3CONF_SBE_DISABLED   (0x0u)
#define MCSPI_CH3CONF_SBE_ENABLED   (0x1u)

#define MCSPI_CH3CONF_SBPOL   (0x01000000u)
#define MCSPI_CH3CONF_SBPOL_SHIFT   (0x00000018u)
#define MCSPI_CH3CONF_SBPOL_HIGHLEVEL   (0x1u)
#define MCSPI_CH3CONF_SBPOL_LOWLEVEL   (0x0u)

#define MCSPI_CH3CONF_TCS3   (0x06000000u)
#define MCSPI_CH3CONF_TCS3_SHIFT   (0x00000019u)
#define MCSPI_CH3CONF_TCS3_0P5   (0x0u)
#define MCSPI_CH3CONF_TCS3_1P5   (0x1u)
#define MCSPI_CH3CONF_TCS3_2P5   (0x2u)
#define MCSPI_CH3CONF_TCS3_3P5   (0x3u)

#define MCSPI_CH3CONF_TRM   (0x00003000u)
#define MCSPI_CH3CONF_TRM_SHIFT   (0x0000000Cu)
#define MCSPI_CH3CONF_TRM_RXONLY   (0x1u)
#define MCSPI_CH3CONF_TRM_TXONLY   (0x2u)
#define MCSPI_CH3CONF_TRM_TXRX   (0x0u)

#define MCSPI_CH3CONF_TURBO   (0x00080000u)
#define MCSPI_CH3CONF_TURBO_SHIFT   (0x00000013u)
#define MCSPI_CH3CONF_TURBO_DISABLED   (0x0u)
#define MCSPI_CH3CONF_TURBO_ENABLED   (0x1u)

#define MCSPI_CH3CONF_WL   (0x00000F80u)
#define MCSPI_CH3CONF_WL_SHIFT   (0x00000007u)
#define MCSPI_CH3CONF_WL_10BITS   (0x9u)
#define MCSPI_CH3CONF_WL_11BITS   (0xAu)
#define MCSPI_CH3CONF_WL_12BITS   (0xBu)
#define MCSPI_CH3CONF_WL_13BITS   (0xCu)
#define MCSPI_CH3CONF_WL_14BITS   (0xDu)
#define MCSPI_CH3CONF_WL_15BITS   (0xEu)
#define MCSPI_CH3CONF_WL_16BITS   (0xFu)
#define MCSPI_CH3CONF_WL_17BITS   (0x10u)
#define MCSPI_CH3CONF_WL_18BITS   (0x11u)
#define MCSPI_CH3CONF_WL_19BITS   (0x12u)
#define MCSPI_CH3CONF_WL_20BITS   (0x13u)
#define MCSPI_CH3CONF_WL_21BITS   (0x14u)
#define MCSPI_CH3CONF_WL_22BITS   (0x15u)
#define MCSPI_CH3CONF_WL_23BITS   (0x16u)
#define MCSPI_CH3CONF_WL_24BITS   (0x17u)
#define MCSPI_CH3CONF_WL_25BITS   (0x18u)
#define MCSPI_CH3CONF_WL_26BITS   (0x19u)
#define MCSPI_CH3CONF_WL_27BITS   (0x1Au)
#define MCSPI_CH3CONF_WL_28BITS   (0x1Bu)
#define MCSPI_CH3CONF_WL_29BITS   (0x1Cu)
#define MCSPI_CH3CONF_WL_30BITS   (0x1Du)
#define MCSPI_CH3CONF_WL_31BITS   (0x1Eu)
#define MCSPI_CH3CONF_WL_32BITS   (0x1Fu)
#define MCSPI_CH3CONF_WL_4BITS   (0x3u)
#define MCSPI_CH3CONF_WL_5BITS   (0x4u)
#define MCSPI_CH3CONF_WL_6BITS   (0x5u)
#define MCSPI_CH3CONF_WL_7BITS   (0x6u)
#define MCSPI_CH3CONF_WL_8BITS   (0x7u)
#define MCSPI_CH3CONF_WL_9BITS   (0x8u)


/* CH3STAT */
#define MCSPI_CH3STAT_EOT   (0x00000004u)
#define MCSPI_CH3STAT_EOT_SHIFT   (0x00000002u)
#define MCSPI_CH3STAT_EOT_COMPLETED   (0x1u)
#define MCSPI_CH3STAT_EOT_INPROGRESS   (0x0u)

#define MCSPI_CH3STAT_RXFFE   (0x00000020u)
#define MCSPI_CH3STAT_RXFFE_SHIFT   (0x00000005u)
#define MCSPI_CH3STAT_RXFFE_EMPTY   (0x1u)
#define MCSPI_CH3STAT_RXFFE_NOTEMPTY   (0x0u)

#define MCSPI_CH3STAT_RXFFF   (0x00000040u)
#define MCSPI_CH3STAT_RXFFF_SHIFT   (0x00000006u)
#define MCSPI_CH3STAT_RXFFF_FULL   (0x1u)
#define MCSPI_CH3STAT_RXFFF_NOTFULL   (0x0u)

#define MCSPI_CH3STAT_RXS   (0x00000001u)
#define MCSPI_CH3STAT_RXS_SHIFT   (0x00000000u)
#define MCSPI_CH3STAT_RXS_EMPTY   (0x0u)
#define MCSPI_CH3STAT_RXS_FULL   (0x1u)

#define MCSPI_CH3STAT_TXFFE   (0x00000008u)
#define MCSPI_CH3STAT_TXFFE_SHIFT   (0x00000003u)
#define MCSPI_CH3STAT_TXFFE_EMPTY   (0x1u)
#define MCSPI_CH3STAT_TXFFE_NOTEMPTY   (0x0u)

#define MCSPI_CH3STAT_TXFFF   (0x00000010u)
#define MCSPI_CH3STAT_TXFFF_SHIFT   (0x00000004u)
#define MCSPI_CH3STAT_TXFFF_FULL   (0x1u)
#define MCSPI_CH3STAT_TXFFF_NOTFULL   (0x0u)

#define MCSPI_CH3STAT_TXS   (0x00000002u)
#define MCSPI_CH3STAT_TXS_SHIFT   (0x00000001u)
#define MCSPI_CH3STAT_TXS_EMPTY   (0x1u)
#define MCSPI_CH3STAT_TXS_FULL   (0x0u)


/* CH3CTRL */
#define MCSPI_CH3CTRL_EN   (0x00000001u)
#define MCSPI_CH3CTRL_EN_SHIFT   (0x00000000u)
#define MCSPI_CH3CTRL_EN_ACTIVE   (0x1u)
#define MCSPI_CH3CTRL_EN_INACTIVE   (0x0u)

#define MCSPI_CH3CTRL_EXTCLK   (0x0000FF00u)
#define MCSPI_CH3CTRL_EXTCLK_SHIFT   (0x00000008u)
#define MCSPI_CH3CTRL_EXTCLK_EXT4080   (0xFFu)
#define MCSPI_CH3CTRL_EXTCLK_EXTONE   (0x1u)
#define MCSPI_CH3CTRL_EXTCLK_EXTZERO   (0x0u)


/* TX3 */
#define MCSPI_TX3_TDATA   (0xFFFFFFFFu)
#define MCSPI_TX3_TDATA_SHIFT   (0x00000000u)


/* RX3 */
#define MCSPI_RX3_RDATA   (0xFFFFFFFFu)
#define MCSPI_RX3_RDATA_SHIFT   (0x00000000u)


/* XFERLEVEL */
#define MCSPI_XFERLEVEL_AEL   (0x000000FFu)
#define MCSPI_XFERLEVEL_AEL_SHIFT   (0x00000000u)
#define MCSPI_XFERLEVEL_AEL_1BYTE   (0x0u)
#define MCSPI_XFERLEVEL_AEL_255BYTES   (0xFEu)
#define MCSPI_XFERLEVEL_AEL_256BYTES   (0xFFu)
#define MCSPI_XFERLEVEL_AEL_2BYTES   (0x1u)

#define MCSPI_XFERLEVEL_AFL   (0x0000FF00u)
#define MCSPI_XFERLEVEL_AFL_SHIFT   (0x00000008u)
#define MCSPI_XFERLEVEL_AFL_1BYTE   (0x0u)
#define MCSPI_XFERLEVEL_AFL_255BYTES   (0xFEu)
#define MCSPI_XFERLEVEL_AFL_256BYTES   (0xFFu)
#define MCSPI_XFERLEVEL_AFL_2BYTES   (0x1u)

#define MCSPI_XFERLEVEL_WCNT   (0xFFFF0000u)
#define MCSPI_XFERLEVEL_WCNT_SHIFT   (0x00000010u)
#define MCSPI_XFERLEVEL_WCNT_1WORD   (0x1u)
#define MCSPI_XFERLEVEL_WCNT_65534WORD   (0xFFFEu)
#define MCSPI_XFERLEVEL_WCNT_65535WORD   (0xFFFFu)
#define MCSPI_XFERLEVEL_WCNT_DISABLE   (0x0u)


#ifdef __cplusplus
}
#endif

#endif

