/**
 * \file  ipc_pv.h
 *
 * \brief IPC module internal declarations
 */

/* Copyright (c) 2011, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */


#ifndef IPCIPC_PV_H_
#define IPCIPC_PV_H_
#if defined (__cplusplus)
extern "C" {
#endif

/* State defs for IPC run-time status */
#define IPC_STATE_NOTREADY          0xA5A5    /* IPC not setup, synced nor attached */
#define IPC_STATE_READY             0x1001    /* IPC instance set up, synced & attached */
#define IPC_STATE_STOPPED           0x2002    /*  "    "     no longer exists (tear down) */
#define IPC_STATE_RUNNING           0x3003    /* Notification received via interrupt */
#define IPC_STATE_RUNNINGPOLLEDINT  0x4004    /* Notification received via int disabled (if enabled) */

/* IPC module control bloc (subject to change) */
struct IPC_modControl
{
        UInt16 ipcState;            /* state of IPC module */
        UInt16 remoteProcId;        /* remote processor Id */
        UInt16 remoteIntLine;       /* ID of interrupt line to remote CPU */
        Void   *NotifyObjHandle;    /* link to Notify configuration object */
};

/* Internal IPC module function declarations */

#if defined (__cplusplus)
}
#endif /* defined (__cplusplus) */
#endif /* IPCIPC_PV_H_ */
