/**
 * \file  hw_edma3cc.h
 *
 * \brief EDMA3CC register definitions
 */

/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


#ifndef _HW_EDMA3CC_H_
#define _HW_EDMA3CC_H_

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************\
* Register macros for PARAMENTRY
\**************************************************************************/
#define EDMA3CC_PaRAM_BASE            (0x4000)
#define EDMA3CC_OPT(n)                (EDMA3CC_PaRAM_BASE + 0x0 + (0x20 * n))
#define EDMA3CC_SRC(n)                (EDMA3CC_PaRAM_BASE + 0x4 + (0x20 * n))
#define EDMA3CC_A_B_CNT(n)            (EDMA3CC_PaRAM_BASE + 0x8 + (0x20 * n))
#define EDMA3CC_DST(n)                (EDMA3CC_PaRAM_BASE + 0xC + (0x20 * n))
#define EDMA3CC_SRC_DST_BIDX(n)       (EDMA3CC_PaRAM_BASE + 0x10 + (0x20 * n))
#define EDMA3CC_LINK_BCNTRLD(n)       (EDMA3CC_PaRAM_BASE + 0x14 + (0x20 * n))
#define EDMA3CC_SRC_DST_CIDX(n)       (EDMA3CC_PaRAM_BASE + 0x18 + (0x20 * n))
#define EDMA3CC_CCNT(n)               (EDMA3CC_PaRAM_BASE + 0x1C + (0x20 * n))

/**************************************************************************\
* Register macros for Structure
\**************************************************************************/
#define EDMA3CC_REVID                (0x0)
#define EDMA3CC_CCCFG                (0x4)
#define EDMA3CC_DCHMAP(n)            (0x100 + (n * 4))
#define EDMA3CC_QCHMAP(n)            (0x200 + (n * 4))
#define EDMA3CC_DMAQNUM(n)           (0x240 + ((n) * 4))
#define EDMA3CC_QDMAQNUM             (0x260)
#define EDMA3CC_QUEPRI               (0x284)
#define EDMA3CC_EMR                  (0x300)
#define EDMA3CC_EMRH                 (0x304)
#define EDMA3CC_EMCR                 (0x308)
#define EDMA3CC_EMCRH                (0x30C)
#define EDMA3CC_QEMR                 (0x310)
#define EDMA3CC_QEMCR                (0x314)
#define EDMA3CC_CCERR                (0x318)
#define EDMA3CC_CCERRCLR             (0x31C)
#define EDMA3CC_EEVAL                (0x320)
#define EDMA3CC_DRAE(n)              (0x340 + (n * 8))
#define EDMA3CC_DRAEH(n)             (0x344 + (n * 8))
#define EDMA3CC_QRAE(n)              (0x380 + (n * 4))
#define EDMA3CC_QEVENT(que, reg)     (0x400 + (0x40 * que) + (4 * reg))
#define EDMA3CC_QSTAT(n)             (0x600 + (n * 4))
#define EDMA3CC_QWMTHRA(n)           (0x620 + (n * 4))
#define EDMA3CC_CCSTAT               (0x640)
#define EDMA3CC_ER                   (0x1000)
#define EDMA3CC_ECR                  (0x1008)
#define EDMA3CC_ESR                  (0x1010)
#define EDMA3CC_CER                  (0x1018)
#define EDMA3CC_EER                  (0x1020)
#define EDMA3CC_EECR                 (0x1028)
#define EDMA3CC_EESR                 (0x1030)
#define EDMA3CC_SER                  (0x1038)
#define EDMA3CC_SECR                 (0x1040)
#define EDMA3CC_IER                  (0x1050)
#define EDMA3CC_IECR                 (0x1058)
#define EDMA3CC_IESR                 (0x1060)
#define EDMA3CC_IPR                  (0x1068)
#define EDMA3CC_ICR                  (0x1070)
#define EDMA3CC_IEVAL                (0x1078)
#define EDMA3CC_QER                  (0x1080)
#define EDMA3CC_QEER                 (0x1084)
#define EDMA3CC_QEECR                (0x1088)
#define EDMA3CC_QEESR                (0x108C)
#define EDMA3CC_QSER                 (0x1090)
#define EDMA3CC_QSECR                (0x1094)
#define EDMA3CC_S_ER(n)              (0x2000 + (0x200 * n))
#define EDMA3CC_S_ECR(n)             (0x2008 + (0x200 * n))
#define EDMA3CC_S_ECRH(n)            (0x200C + (0x200 * n))
#define EDMA3CC_S_ESR(n)             (0x2010 + (0x200 * n))
#define EDMA3CC_S_ESRH(n)            (0x2014+ (0x200 * n))
#define EDMA3CC_S_CER(n)             (0x2018 + (0x200 * n))
#define EDMA3CC_S_EER(n)             (0x2020 + (0x200 * n))
#define EDMA3CC_S_EERH(n)            (0x2024 + (0x200 * n))
#define EDMA3CC_S_EECR(n)            (0x2028 + (0x200 * n))
#define EDMA3CC_S_EECRH(n)           (0x202C + (0x200 * n))
#define EDMA3CC_S_EESR(n)            (0x2030 + (0x200 * n))
#define EDMA3CC_S_EESRH(n)           (0x2034 + (0x200 * n))
#define EDMA3CC_S_SER(n)             (0x2038 + (0x200 * n))
#define EDMA3CC_S_SERH(n)            (0x203C + (0x200 * n))
#define EDMA3CC_S_SECR(n)            (0x2040 + (0x200 * n))
#define EDMA3CC_S_SECRH(n)           (0x2044 + (0x200 * n))
#define EDMA3CC_S_IER(n)             (0x2050 + (0x200 * n))
#define EDMA3CC_S_IERH(n)            (0x2054 + (0x200 * n))
#define EDMA3CC_S_IECR(n)            (0x2058 + (0x200 * n))
#define EDMA3CC_S_IECRH(n)           (0x205C + (0x200 * n))
#define EDMA3CC_S_IESR(n)            (0x2060 + (0x200 * n))
#define EDMA3CC_S_IESRH(n)           (0x2064 + (0x200 * n))
#define EDMA3CC_S_IPR(n)             (0x2068 + (0x200 * n))
#define EDMA3CC_S_IPRH(n)            (0x206C + (0x200 * n))
#define EDMA3CC_S_ICR(n)             (0x2070 + (0x200 * n))
#define EDMA3CC_S_ICRH(n)            (0x2074 + (0x200 * n))
#define EDMA3CC_S_IEVAL(n)           (0x2078 + (0x200 * n))
#define EDMA3CC_S_QER(n)             (0x2080 + (0x200 * n))
#define EDMA3CC_S_QEER(n)            (0x2084 + (0x200 * n))
#define EDMA3CC_S_QEECR(n)           (0x2088 + (0x200 * n))
#define EDMA3CC_S_QEESR(n)           (0x208C + (0x200 * n))
#define EDMA3CC_S_QSER(n)            (0x2090 + (0x200 * n))
#define EDMA3CC_S_QSECR(n)           (0x2094 + (0x200 * n))

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DRAE */

#define EDMA3CC_DRAE_E31 (0x80000000u)
#define EDMA3CC_DRAE_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_DRAE_E30 (0x40000000u)
#define EDMA3CC_DRAE_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_DRAE_E29 (0x20000000u)
#define EDMA3CC_DRAE_E29_SHIFT (0x0000001Du)
#define EDMA3CC_DRAE_E28 (0x10000000u)
#define EDMA3CC_DRAE_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_DRAE_E27 (0x08000000u)
#define EDMA3CC_DRAE_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_DRAE_E26 (0x04000000u)
#define EDMA3CC_DRAE_E26_SHIFT (0x0000001Au)
#define EDMA3CC_DRAE_E25 (0x02000000u)
#define EDMA3CC_DRAE_E25_SHIFT (0x00000019u)
#define EDMA3CC_DRAE_E24 (0x01000000u)
#define EDMA3CC_DRAE_E24_SHIFT (0x00000018u)
#define EDMA3CC_DRAE_E23 (0x00800000u)
#define EDMA3CC_DRAE_E23_SHIFT (0x00000017u)
#define EDMA3CC_DRAE_E22 (0x00400000u)
#define EDMA3CC_DRAE_E22_SHIFT (0x00000016u)
#define EDMA3CC_DRAE_E21 (0x00200000u)
#define EDMA3CC_DRAE_E21_SHIFT (0x00000015u)
#define EDMA3CC_DRAE_E20 (0x00100000u)
#define EDMA3CC_DRAE_E20_SHIFT (0x00000014u)
#define EDMA3CC_DRAE_E19 (0x00080000u)
#define EDMA3CC_DRAE_E19_SHIFT (0x00000013u)
#define EDMA3CC_DRAE_E18 (0x00040000u)
#define EDMA3CC_DRAE_E18_SHIFT (0x00000012u)
#define EDMA3CC_DRAE_E17 (0x00020000u)
#define EDMA3CC_DRAE_E17_SHIFT (0x00000011u)
#define EDMA3CC_DRAE_E16 (0x00010000u)
#define EDMA3CC_DRAE_E16_SHIFT (0x00000010u)
#define EDMA3CC_DRAE_E15 (0x00008000u)
#define EDMA3CC_DRAE_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_DRAE_E14 (0x00004000u)
#define EDMA3CC_DRAE_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_DRAE_E13 (0x00002000u)
#define EDMA3CC_DRAE_E13_SHIFT (0x0000000Du)
#define EDMA3CC_DRAE_E12 (0x00001000u)
#define EDMA3CC_DRAE_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_DRAE_E11 (0x00000800u)
#define EDMA3CC_DRAE_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_DRAE_E10 (0x00000400u)
#define EDMA3CC_DRAE_E10_SHIFT (0x0000000Au)
#define EDMA3CC_DRAE_E9 (0x00000200u)
#define EDMA3CC_DRAE_E9_SHIFT (0x00000009u)
#define EDMA3CC_DRAE_E8 (0x00000100u)
#define EDMA3CC_DRAE_E8_SHIFT (0x00000008u)
#define EDMA3CC_DRAE_E7 (0x00000080u)
#define EDMA3CC_DRAE_E7_SHIFT (0x00000007u)
#define EDMA3CC_DRAE_E6 (0x00000040u)
#define EDMA3CC_DRAE_E6_SHIFT (0x00000006u)
#define EDMA3CC_DRAE_E5 (0x00000020u)
#define EDMA3CC_DRAE_E5_SHIFT (0x00000005u)
#define EDMA3CC_DRAE_E4 (0x00000010u)
#define EDMA3CC_DRAE_E4_SHIFT (0x00000004u)
#define EDMA3CC_DRAE_E3 (0x00000008u)
#define EDMA3CC_DRAE_E3_SHIFT (0x00000003u)
#define EDMA3CC_DRAE_E2 (0x00000004u)
#define EDMA3CC_DRAE_E2_SHIFT (0x00000002u)
#define EDMA3CC_DRAE_E1 (0x00000002u)
#define EDMA3CC_DRAE_E1_SHIFT (0x00000001u)
#define EDMA3CC_DRAE_E0 (0x00000001u)
#define EDMA3CC_DRAE_E0_SHIFT (0x00000000u)


/* EVENT */

#define EDMA3CC_EVENT_RESV (0xFFFFFF00u)
#define EDMA3CC_EVENT_RESV_SHIFT (0x00000008u)

#define EDMA3CC_EVENT_ETYPE (0x000000C0u)
#define EDMA3CC_EVENT_ETYPE_SHIFT (0x00000006u)
#define EDMA3CC_EVENT_ETYPE_ER (0x00000000u)
#define EDMA3CC_EVENT_ETYPE_ESR (0x00000001u)
#define EDMA3CC_EVENT_ETYPE_CER (0x00000002u)
#define EDMA3CC_EVENT_ETYPE_QER (0x00000003u)

#define EDMA3CC_EVENT_ENUM (0x0000003Fu)
#define EDMA3CC_EVENT_ENUM_SHIFT (0x00000000u)

/* ER */

#define EDMA3CC_ER_REG (0xFFFFFFFFu)
#define EDMA3CC_ER_REG_SHIFT (0x00000000u)


/* ECR */

#define EDMA3CC_ECR_REG (0xFFFFFFFFu)
#define EDMA3CC_ECR_REG_SHIFT (0x00000000u)


/* ESR */

#define EDMA3CC_ESR_REG (0xFFFFFFFFu)
#define EDMA3CC_ESR_REG_SHIFT (0x00000000u)


/* CER */

#define EDMA3CC_CER_REG (0xFFFFFFFFu)
#define EDMA3CC_CER_REG_SHIFT (0x00000000u)


/* EER */

#define EDMA3CC_EER_REG (0xFFFFFFFFu)
#define EDMA3CC_EER_REG_SHIFT (0x00000000u)


/* EECR */

#define EDMA3CC_EECR_REG (0xFFFFFFFFu)
#define EDMA3CC_EECR_REG_SHIFT (0x00000000u)


/* EESR */

#define EDMA3CC_EESR_REG (0xFFFFFFFFu)
#define EDMA3CC_EESR_REG_SHIFT (0x00000000u)


/* SER */

#define EDMA3CC_SER_REG (0xFFFFFFFFu)
#define EDMA3CC_SER_REG_SHIFT (0x00000000u)


/* SECR */

#define EDMA3CC_SECR_REG (0xFFFFFFFFu)
#define EDMA3CC_SECR_REG_SHIFT (0x00000000u)


/* IER */

#define EDMA3CC_IER_REG (0xFFFFFFFFu)
#define EDMA3CC_IER_REG_SHIFT (0x00000000u)


/* IECR */

#define EDMA3CC_IECR_REG (0xFFFFFFFFu)
#define EDMA3CC_IECR_REG_SHIFT (0x00000000u)


/* IESR */

#define EDMA3CC_IESR_REG (0xFFFFFFFFu)
#define EDMA3CC_IESR_REG_SHIFT (0x00000000u)


/* IPR */

#define EDMA3CC_IPR_REG (0xFFFFFFFFu)
#define EDMA3CC_IPR_REG_SHIFT (0x00000000u)


/* ICR */

#define EDMA3CC_ICR_REG (0xFFFFFFFFu)
#define EDMA3CC_ICR_REG_SHIFT (0x00000000u)


/* IEVAL */

#define EDMA3CC_IEVAL_REG (0xFFFFFFFFu)
#define EDMA3CC_IEVAL_REG_SHIFT (0x00000000u)


/* QER */

#define EDMA3CC_QER_REG (0xFFFFFFFFu)
#define EDMA3CC_QER_REG_SHIFT (0x00000000u)


/* QEER */

#define EDMA3CC_QEER_REG (0xFFFFFFFFu)
#define EDMA3CC_QEER_REG_SHIFT (0x00000000u)


/* QEECR */

#define EDMA3CC_QEECR_REG (0xFFFFFFFFu)
#define EDMA3CC_QEECR_REG_SHIFT (0x00000000u)


/* QEESR */

#define EDMA3CC_QEESR_REG (0xFFFFFFFFu)
#define EDMA3CC_QEESR_REG_SHIFT (0x00000000u)


/* QSER */

#define EDMA3CC_QSER_REG (0xFFFFFFFFu)
#define EDMA3CC_QSER_REG_SHIFT (0x00000000u)


/* QSECR */

#define EDMA3CC_QSECR_REG (0xFFFFFFFFu)
#define EDMA3CC_QSECR_REG_SHIFT (0x00000000u)


/* OPT */


#define EDMA3CC_OPT_PRIVID (0x0F000000u)
#define EDMA3CC_OPT_PRIVID_SHIFT (0x00000018u)
#define EDMA3CC_OPT_ITCCHEN (0x00800000u)
#define EDMA3CC_OPT_ITCCHEN_SHIFT (0x00000017u)
#define EDMA3CC_OPT_TCCHEN (0x00400000u)
#define EDMA3CC_OPT_TCCHEN_SHIFT (0x00000016u)
#define EDMA3CC_OPT_ITCINTEN (0x00200000u)
#define EDMA3CC_OPT_ITCINTEN_SHIFT (0x00000015u)
#define EDMA3CC_OPT_TCINTEN (0x00100000u)
#define EDMA3CC_OPT_TCINTEN_SHIFT (0x00000014u)
#define EDMA3CC_OPT_TCC (0x0003F000u)
#define EDMA3CC_OPT_TCC_SHIFT (0x0000000Cu)
#define EDMA3CC_OPT_TCCMOD (0x00000800u)
#define EDMA3CC_OPT_TCCMOD_SHIFT (0x0000000Bu)
#define EDMA3CC_OPT_TCCMOD_NORMAL (0x00000000u)
#define EDMA3CC_OPT_TCCMOD_EARLY (0x00000001u)
#define EDMA3CC_OPT_FWID (0x00000700u)
#define EDMA3CC_OPT_FWID_SHIFT (0x00000008u)
#define EDMA3CC_OPT_FWID_8BIT (0x00000000u)
#define EDMA3CC_OPT_FWID_16BIT (0x00000001u)
#define EDMA3CC_OPT_FWID_32BIT (0x00000002u)
#define EDMA3CC_OPT_FWID_64BIT (0x00000003u)
#define EDMA3CC_OPT_FWID_128BIT (0x00000004u)
#define EDMA3CC_OPT_FWID_256BIT (0x00000005u)
#define EDMA3CC_OPT_STATIC (0x00000008u)
#define EDMA3CC_OPT_STATIC_SHIFT (0x00000003u)
#define EDMA3CC_OPT_SYNCDIM (0x00000004u)
#define EDMA3CC_OPT_SYNCDIM_SHIFT (0x00000002u)
#define EDMA3CC_OPT_DAM (0x00000002u)
#define EDMA3CC_OPT_DAM_SHIFT (0x00000001u)
#define EDMA3CC_OPT_SAM (0x00000001u)
#define EDMA3CC_OPT_SAM_SHIFT (0x00000000u)


/* SRC */

#define EDMA3CC_SRC_SRC (0xFFFFFFFFu)
#define EDMA3CC_SRC_SRC_SHIFT (0x00000000u)


/* A_B_CNT */

#define EDMA3CC_A_B_CNT_BCNT (0xFFFF0000u)
#define EDMA3CC_A_B_CNT_BCNT_SHIFT (0x00000010u)

/* DST */

#define EDMA3CC_DST_DST (0xFFFFFFFFu)
#define EDMA3CC_DST_DST_SHIFT (0x00000000u)


/* SRC_DST_BIDX */

#define EDMA3CC_SRC_DST_BIDX_DSTBIDX (0xFFFF0000u)
#define EDMA3CC_SRC_DST_BIDX_DSTBIDX_SHIFT (0x00000010u)

#define EDMA3CC_SRC_DST_BIDX_SRCBIDX (0x0000FFFFu)
#define EDMA3CC_SRC_DST_BIDX_SRCBIDX_SHIFT (0x00000000u)


/* LINK_BCNTRLD */

#define EDMA3CC_LINK_BCNTRLD_BCNTRLD (0xFFFF0000u)
#define EDMA3CC_LINK_BCNTRLD_BCNTRLD_SHIFT (0x00000010u)

#define EDMA3CC_LINK_BCNTRLD_LINK (0x0000FFFFu)
#define EDMA3CC_LINK_BCNTRLD_LINK_SHIFT (0x00000000u)


/* SRC_DST_CIDX */

#define EDMA3CC_SRC_DST_CIDX_DSTCIDX (0xFFFF0000u)
#define EDMA3CC_SRC_DST_CIDX_DSTCIDX_SHIFT (0x00000010u)

#define EDMA3CC_SRC_DST_CIDX_SRCCIDX (0x0000FFFFu)
#define EDMA3CC_SRC_DST_CIDX_SRCCIDX_SHIFT (0x00000000u)


/* CCNT */


#define EDMA3CC_CCNT_CCNT (0x0000FFFFu)
#define EDMA3CC_CCNT_CCNT_SHIFT (0x00000000u)


/* PID */

#define EDMA3CC_PID_PID (0xFFFFFFFFu)
#define EDMA3CC_PID_PID_SHIFT (0x00000000u)


/* CCCFG */


#define EDMA3CC_CCCFG_MP_EXIST (0x02000000u)
#define EDMA3CC_CCCFG_MP_EXIST_SHIFT (0x00000019u)
#define EDMA3CC_CCCFG_CHMAP_EXIST (0x01000000u)
#define EDMA3CC_CCCFG_CHMAP_EXIST_SHIFT (0x00000018u)
#define EDMA3CC_CCCFG_NUM_REGN (0x00300000u)
#define EDMA3CC_CCCFG_NUM_REGN_SHIFT (0x00000014u)
/*----NUM_REGN Tokens----*/
#define EDMA3CC_CCCFG_NUM_REGN_0REGIONS (0x00000000u)
#define EDMA3CC_CCCFG_NUM_REGN_2REGIONS (0x00000001u)
#define EDMA3CC_CCCFG_NUM_REGN_4REGIONS (0x00000002u)
#define EDMA3CC_CCCFG_NUM_REGN_8REGIONS (0x00000003u)


#define EDMA3CC_CCCFG_NUM_EVQUE (0x00070000u)
#define EDMA3CC_CCCFG_NUM_EVQUE_SHIFT (0x00000010u)
#define EDMA3CC_CCCFG_NUM_EVQUE_1EVTQ (0x00000000u)
#define EDMA3CC_CCCFG_NUM_EVQUE_2EVTQ (0x00000001u)
#define EDMA3CC_CCCFG_NUM_EVQUE_3EVTQ (0x00000002u)
#define EDMA3CC_CCCFG_NUM_EVQUE_4EVTQ (0x00000003u)
#define EDMA3CC_CCCFG_NUM_EVQUE_5EVTQ (0x00000004u)
#define EDMA3CC_CCCFG_NUM_EVQUE_6EVTQ (0x00000005u)
#define EDMA3CC_CCCFG_NUM_EVQUE_7EVTQ (0x00000006u)
#define EDMA3CC_CCCFG_NUM_EVQUE_8EVTQ (0x00000007u)
#define EDMA3CC_CCCFG_NUM_PAENTRY (0x00007000u)
#define EDMA3CC_CCCFG_NUM_PAENTRY_SHIFT (0x0000000Cu)
/*----NUM_PAENTRY Tokens----*/
#define EDMA3CC_CCCFG_NUM_PAENTRY_16 (0x00000000u)
#define EDMA3CC_CCCFG_NUM_PAENTRY_32 (0x00000001u)
#define EDMA3CC_CCCFG_NUM_PAENTRY_64 (0x00000002u)
#define EDMA3CC_CCCFG_NUM_PAENTRY_128 (0x00000003u)
#define EDMA3CC_CCCFG_NUM_PAENTRY_256 (0x00000004u)
#define EDMA3CC_CCCFG_NUM_PAENTRY_512 (0x00000005u)

#define EDMA3CC_CCCFG_NUM_INTCH (0x00000700u)
#define EDMA3CC_CCCFG_NUM_INTCH_SHIFT (0x00000008u)
/*----NUM_INTCH Tokens----*/
#define EDMA3CC_CCCFG_NUM_INTCH_8 (0x00000001u)
#define EDMA3CC_CCCFG_NUM_INTCH_16 (0x00000002u)
#define EDMA3CC_CCCFG_NUM_INTCH_32 (0x00000003u)
#define EDMA3CC_CCCFG_NUM_INTCH_64 (0x00000004u)

#define EDMA3CC_CCCFG_NUM_QDMACH (0x00000070u)
#define EDMA3CC_CCCFG_NUM_QDMACH_SHIFT (0x00000004u)
/*----NUM_QDMACH Tokens----*/
#define EDMA3CC_CCCFG_NUM_QDMACH_NONE (0x00000000u)
#define EDMA3CC_CCCFG_NUM_QDMACH_2 (0x00000001u)
#define EDMA3CC_CCCFG_NUM_QDMACH_4 (0x00000002u)
#define EDMA3CC_CCCFG_NUM_QDMACH_6 (0x00000003u)
#define EDMA3CC_CCCFG_NUM_QDMACH_8 (0x00000004u)


#define EDMA3CC_CCCFG_NUM_DMACH (0x00000007u)
#define EDMA3CC_CCCFG_NUM_DMACH_SHIFT (0x00000000u)
/*----NUM_DMACH Tokens----*/
#define EDMA3CC_CCCFG_NUM_DMACH_NONE (0x00000000u)
#define EDMA3CC_CCCFG_NUM_DMACH_4 (0x00000001u)
#define EDMA3CC_CCCFG_NUM_DMACH_8 (0x00000002u)
#define EDMA3CC_CCCFG_NUM_DMACH_16 (0x00000003u)
#define EDMA3CC_CCCFG_NUM_DMACH_32 (0x00000004u)
#define EDMA3CC_CCCFG_NUM_DMACH_64 (0x00000005u)


/* QCHMAP */


#define EDMA3CC_QCHMAP_PAENTRY (0x00003FE0u)
#define EDMA3CC_QCHMAP_PAENTRY_SHIFT (0x00000005u)
#define EDMA3CC_QCHMAP_TRWORD (0x0000001Cu)
#define EDMA3CC_QCHMAP_TRWORD_SHIFT (0x00000002u)


/* DMAQNUM */


#define EDMA3CC_DMAQNUM_E7 (0x70000000u)
#define EDMA3CC_DMAQNUM_E7_SHIFT (0x0000001Cu)
#define EDMA3CC_DMAQNUM_E6 (0x07000000u)
#define EDMA3CC_DMAQNUM_E6_SHIFT (0x00000018u)
#define EDMA3CC_DMAQNUM_E5 (0x00700000u)
#define EDMA3CC_DMAQNUM_E5_SHIFT (0x00000014u)
#define EDMA3CC_DMAQNUM_E4 (0x00070000u)
#define EDMA3CC_DMAQNUM_E4_SHIFT (0x00000010u)
#define EDMA3CC_DMAQNUM_E3 (0x00007000u)
#define EDMA3CC_DMAQNUM_E3_SHIFT (0x0000000Cu)
#define EDMA3CC_DMAQNUM_E2 (0x00000700u)
#define EDMA3CC_DMAQNUM_E2_SHIFT (0x00000008u)
#define EDMA3CC_DMAQNUM_E1 (0x00000070u)
#define EDMA3CC_DMAQNUM_E1_SHIFT (0x00000004u)
#define EDMA3CC_DMAQNUM_E0 (0x00000007u)
#define EDMA3CC_DMAQNUM_E0_SHIFT (0x00000000u)


/* QDMAQNUM */

#define EDMA3CC_QDMAQNUM_E7 (0x70000000u)
#define EDMA3CC_QDMAQNUM_E7_SHIFT (0x0000001Cu)
#define EDMA3CC_QDMAQNUM_E6 (0x07000000u)
#define EDMA3CC_QDMAQNUM_E6_SHIFT (0x00000018u)
#define EDMA3CC_QDMAQNUM_E5 (0x00700000u)
#define EDMA3CC_QDMAQNUM_E5_SHIFT (0x00000014u)
#define EDMA3CC_QDMAQNUM_E4 (0x00070000u)
#define EDMA3CC_QDMAQNUM_E4_SHIFT (0x00000010u)
#define EDMA3CC_QDMAQNUM_E3 (0x00007000u)
#define EDMA3CC_QDMAQNUM_E3_SHIFT (0x0000000Cu)
#define EDMA3CC_QDMAQNUM_E2 (0x00000700u)
#define EDMA3CC_QDMAQNUM_E2_SHIFT (0x00000008u)
#define EDMA3CC_QDMAQNUM_E1 (0x00000070u)
#define EDMA3CC_QDMAQNUM_E1_SHIFT (0x00000004u)
#define EDMA3CC_QDMAQNUM_E0 (0x00000007u)
#define EDMA3CC_QDMAQNUM_E0_SHIFT (0x00000000u)


/* QUEPRI */


#define EDMA3CC_QUEPRI_PRIQ2 (0x00000700u)
#define EDMA3CC_QUEPRI_PRIQ2_SHIFT (0x00000008u)
#define EDMA3CC_QUEPRI_PRIQ1 (0x00000070u)
#define EDMA3CC_QUEPRI_PRIQ1_SHIFT (0x00000004u)
#define EDMA3CC_QUEPRI_PRIQ0 (0x00000007u)
#define EDMA3CC_QUEPRI_PRIQ0_SHIFT (0x00000000u)


/* EMR */

#define EDMA3CC_EMR_E31 (0x80000000u)
#define EDMA3CC_EMR_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_EMR_E30 (0x40000000u)
#define EDMA3CC_EMR_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_EMR_E29 (0x20000000u)
#define EDMA3CC_EMR_E29_SHIFT (0x0000001Du)
#define EDMA3CC_EMR_E28 (0x10000000u)
#define EDMA3CC_EMR_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_EMR_E27 (0x08000000u)
#define EDMA3CC_EMR_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_EMR_E26 (0x04000000u)
#define EDMA3CC_EMR_E26_SHIFT (0x0000001Au)
#define EDMA3CC_EMR_E25 (0x02000000u)
#define EDMA3CC_EMR_E25_SHIFT (0x00000019u)
#define EDMA3CC_EMR_E24 (0x01000000u)
#define EDMA3CC_EMR_E24_SHIFT (0x00000018u)
#define EDMA3CC_EMR_E23 (0x00800000u)
#define EDMA3CC_EMR_E23_SHIFT (0x00000017u)
#define EDMA3CC_EMR_E22 (0x00400000u)
#define EDMA3CC_EMR_E22_SHIFT (0x00000016u)
#define EDMA3CC_EMR_E21 (0x00200000u)
#define EDMA3CC_EMR_E21_SHIFT (0x00000015u)
#define EDMA3CC_EMR_E20 (0x00100000u)
#define EDMA3CC_EMR_E20_SHIFT (0x00000014u)
#define EDMA3CC_EMR_E19 (0x00080000u)
#define EDMA3CC_EMR_E19_SHIFT (0x00000013u)
#define EDMA3CC_EMR_E18 (0x00040000u)
#define EDMA3CC_EMR_E18_SHIFT (0x00000012u)
#define EDMA3CC_EMR_E17 (0x00020000u)
#define EDMA3CC_EMR_E17_SHIFT (0x00000011u)
#define EDMA3CC_EMR_E16 (0x00010000u)
#define EDMA3CC_EMR_E16_SHIFT (0x00000010u)
#define EDMA3CC_EMR_E15 (0x00008000u)
#define EDMA3CC_EMR_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_EMR_E14 (0x00004000u)
#define EDMA3CC_EMR_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_EMR_E13 (0x00002000u)
#define EDMA3CC_EMR_E13_SHIFT (0x0000000Du)
#define EDMA3CC_EMR_E12 (0x00001000u)
#define EDMA3CC_EMR_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_EMR_E11 (0x00000800u)
#define EDMA3CC_EMR_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_EMR_E10 (0x00000400u)
#define EDMA3CC_EMR_E10_SHIFT (0x0000000Au)
#define EDMA3CC_EMR_E9 (0x00000200u)
#define EDMA3CC_EMR_E9_SHIFT (0x00000009u)
#define EDMA3CC_EMR_E8 (0x00000100u)
#define EDMA3CC_EMR_E8_SHIFT (0x00000008u)
#define EDMA3CC_EMR_E7 (0x00000080u)
#define EDMA3CC_EMR_E7_SHIFT (0x00000007u)
#define EDMA3CC_EMR_E6 (0x00000040u)
#define EDMA3CC_EMR_E6_SHIFT (0x00000006u)
#define EDMA3CC_EMR_E5 (0x00000020u)
#define EDMA3CC_EMR_E5_SHIFT (0x00000005u)
#define EDMA3CC_EMR_E4 (0x00000010u)
#define EDMA3CC_EMR_E4_SHIFT (0x00000004u)
#define EDMA3CC_EMR_E3 (0x00000008u)
#define EDMA3CC_EMR_E3_SHIFT (0x00000003u)
#define EDMA3CC_EMR_E2 (0x00000004u)
#define EDMA3CC_EMR_E2_SHIFT (0x00000002u)
#define EDMA3CC_EMR_E1 (0x00000002u)
#define EDMA3CC_EMR_E1_SHIFT (0x00000001u)
#define EDMA3CC_EMR_E0 (0x00000001u)
#define EDMA3CC_EMR_E0_SHIFT (0x00000000u)

/* EMCR */

#define EDMA3CC_EMCR_E31 (0x80000000u)
#define EDMA3CC_EMCR_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_EMCR_E30 (0x40000000u)
#define EDMA3CC_EMCR_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_EMCR_E29 (0x20000000u)
#define EDMA3CC_EMCR_E29_SHIFT (0x0000001Du)
#define EDMA3CC_EMCR_E28 (0x10000000u)
#define EDMA3CC_EMCR_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_EMCR_E27 (0x08000000u)
#define EDMA3CC_EMCR_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_EMCR_E26 (0x04000000u)
#define EDMA3CC_EMCR_E26_SHIFT (0x0000001Au)
#define EDMA3CC_EMCR_E25 (0x02000000u)
#define EDMA3CC_EMCR_E25_SHIFT (0x00000019u)
#define EDMA3CC_EMCR_E24 (0x01000000u)
#define EDMA3CC_EMCR_E24_SHIFT (0x00000018u)
#define EDMA3CC_EMCR_E23 (0x00800000u)
#define EDMA3CC_EMCR_E23_SHIFT (0x00000017u)
#define EDMA3CC_EMCR_E22 (0x00400000u)
#define EDMA3CC_EMCR_E22_SHIFT (0x00000016u)
#define EDMA3CC_EMCR_E21 (0x00200000u)
#define EDMA3CC_EMCR_E21_SHIFT (0x00000015u)
#define EDMA3CC_EMCR_E20 (0x00100000u)
#define EDMA3CC_EMCR_E20_SHIFT (0x00000014u)
#define EDMA3CC_EMCR_E19 (0x00080000u)
#define EDMA3CC_EMCR_E19_SHIFT (0x00000013u)
#define EDMA3CC_EMCR_E18 (0x00040000u)
#define EDMA3CC_EMCR_E18_SHIFT (0x00000012u)
#define EDMA3CC_EMCR_E17 (0x00020000u)
#define EDMA3CC_EMCR_E17_SHIFT (0x00000011u)
#define EDMA3CC_EMCR_E16 (0x00010000u)
#define EDMA3CC_EMCR_E16_SHIFT (0x00000010u)
#define EDMA3CC_EMCR_E15 (0x00008000u)
#define EDMA3CC_EMCR_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_EMCR_E14 (0x00004000u)
#define EDMA3CC_EMCR_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_EMCR_E13 (0x00002000u)
#define EDMA3CC_EMCR_E13_SHIFT (0x0000000Du)
#define EDMA3CC_EMCR_E12 (0x00001000u)
#define EDMA3CC_EMCR_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_EMCR_E11 (0x00000800u)
#define EDMA3CC_EMCR_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_EMCR_E10 (0x00000400u)
#define EDMA3CC_EMCR_E10_SHIFT (0x0000000Au)
#define EDMA3CC_EMCR_E9 (0x00000200u)
#define EDMA3CC_EMCR_E9_SHIFT (0x00000009u)
#define EDMA3CC_EMCR_E8 (0x00000100u)
#define EDMA3CC_EMCR_E8_SHIFT (0x00000008u)
#define EDMA3CC_EMCR_E7 (0x00000080u)
#define EDMA3CC_EMCR_E7_SHIFT (0x00000007u)
#define EDMA3CC_EMCR_E6 (0x00000040u)
#define EDMA3CC_EMCR_E6_SHIFT (0x00000006u)
#define EDMA3CC_EMCR_E5 (0x00000020u)
#define EDMA3CC_EMCR_E5_SHIFT (0x00000005u)
#define EDMA3CC_EMCR_E4 (0x00000010u)
#define EDMA3CC_EMCR_E4_SHIFT (0x00000004u)
#define EDMA3CC_EMCR_E3 (0x00000008u)
#define EDMA3CC_EMCR_E3_SHIFT (0x00000003u)
#define EDMA3CC_EMCR_E2 (0x00000004u)
#define EDMA3CC_EMCR_E2_SHIFT (0x00000002u)
#define EDMA3CC_EMCR_E1 (0x00000002u)
#define EDMA3CC_EMCR_E1_SHIFT (0x00000001u)
#define EDMA3CC_EMCR_E0 (0x00000001u)
#define EDMA3CC_EMCR_E0_SHIFT (0x00000000u)

/* QEMR */


#define EDMA3CC_QEMR_E7 (0x00000080u)
#define EDMA3CC_QEMR_E7_SHIFT (0x00000007u)
#define EDMA3CC_QEMR_E6 (0x00000040u)
#define EDMA3CC_QEMR_E6_SHIFT (0x00000006u)
#define EDMA3CC_QEMR_E5 (0x00000020u)
#define EDMA3CC_QEMR_E5_SHIFT (0x00000005u)
#define EDMA3CC_QEMR_E4 (0x00000010u)
#define EDMA3CC_QEMR_E4_SHIFT (0x00000004u)
#define EDMA3CC_QEMR_E3 (0x00000008u)
#define EDMA3CC_QEMR_E3_SHIFT (0x00000003u)
#define EDMA3CC_QEMR_E2 (0x00000004u)
#define EDMA3CC_QEMR_E2_SHIFT (0x00000002u)
#define EDMA3CC_QEMR_E1 (0x00000002u)
#define EDMA3CC_QEMR_E1_SHIFT (0x00000001u)
#define EDMA3CC_QEMR_E0 (0x00000001u)
#define EDMA3CC_QEMR_E0_SHIFT (0x00000000u)

/* QEMCR */


#define EDMA3CC_QEMCR_E7 (0x00000080u)
#define EDMA3CC_QEMCR_E7_SHIFT (0x00000007u)
#define EDMA3CC_QEMCR_E6 (0x00000040u)
#define EDMA3CC_QEMCR_E6_SHIFT (0x00000006u)
#define EDMA3CC_QEMCR_E5 (0x00000020u)
#define EDMA3CC_QEMCR_E5_SHIFT (0x00000005u)
#define EDMA3CC_QEMCR_E4 (0x00000010u)
#define EDMA3CC_QEMCR_E4_SHIFT (0x00000004u)
#define EDMA3CC_QEMCR_E3 (0x00000008u)
#define EDMA3CC_QEMCR_E3_SHIFT (0x00000003u)
#define EDMA3CC_QEMCR_E2 (0x00000004u)
#define EDMA3CC_QEMCR_E2_SHIFT (0x00000002u)
#define EDMA3CC_QEMCR_E1 (0x00000002u)
#define EDMA3CC_QEMCR_E1_SHIFT (0x00000001u)
#define EDMA3CC_QEMCR_E0 (0x00000001u)
#define EDMA3CC_QEMCR_E0_SHIFT (0x00000000u)

/* CCERR */

#define EDMA3CC_CCERR_TCCERR (0x00010000u)
#define EDMA3CC_CCERR_TCCERR_SHIFT (0x00000010u)
#define EDMA3CC_CCERR_QTHRXCD2 (0x00000004u)
#define EDMA3CC_CCERR_QTHRXCD2_SHIFT (0x00000002u)
#define EDMA3CC_CCERR_QTHRXCD1 (0x00000002u)
#define EDMA3CC_CCERR_QTHRXCD1_SHIFT (0x00000001u)
#define EDMA3CC_CCERR_QTHRXCD0 (0x00000001u)
#define EDMA3CC_CCERR_QTHRXCD0_SHIFT (0x00000000u)

/* CCERRCLR */

#define EDMA3CC_CCERRCLR_TCCERR (0x00010000u)
#define EDMA3CC_CCERRCLR_TCCERR_SHIFT (0x00000010u)
#define EDMA3CC_CCERRCLR_QTHRXCD3 (0x00000008u)
#define EDMA3CC_CCERRCLR_QTHRXCD3_SHIFT (0x00000003u)
#define EDMA3CC_CCERRCLR_QTHRXCD2 (0x00000004u)
#define EDMA3CC_CCERRCLR_QTHRXCD2_SHIFT (0x00000002u)
#define EDMA3CC_CCERRCLR_QTHRXCD1 (0x00000002u)
#define EDMA3CC_CCERRCLR_QTHRXCD1_SHIFT (0x00000001u)
#define EDMA3CC_CCERRCLR_QTHRXCD0 (0x00000001u)
#define EDMA3CC_CCERRCLR_QTHRXCD0_SHIFT (0x00000000u)

/* EEVAL */

#define EDMA3CC_EEVAL_EVAL (0x00000001u)
#define EDMA3CC_EEVAL_EVAL_SHIFT (0x00000000u)

/* QRAE */


#define EDMA3CC_QRAE_E7 (0x00000080u)
#define EDMA3CC_QRAE_E7_SHIFT (0x00000007u)
#define EDMA3CC_QRAE_E6 (0x00000040u)
#define EDMA3CC_QRAE_E6_SHIFT (0x00000006u)
#define EDMA3CC_QRAE_E5 (0x00000020u)
#define EDMA3CC_QRAE_E5_SHIFT (0x00000005u)
#define EDMA3CC_QRAE_E4 (0x00000010u)
#define EDMA3CC_QRAE_E4_SHIFT (0x00000004u)
#define EDMA3CC_QRAE_E3 (0x00000008u)
#define EDMA3CC_QRAE_E3_SHIFT (0x00000003u)
#define EDMA3CC_QRAE_E2 (0x00000004u)
#define EDMA3CC_QRAE_E2_SHIFT (0x00000002u)
#define EDMA3CC_QRAE_E1 (0x00000002u)
#define EDMA3CC_QRAE_E1_SHIFT (0x00000001u)
#define EDMA3CC_QRAE_E0 (0x00000001u)
#define EDMA3CC_QRAE_E0_SHIFT (0x00000000u)

/* QSTAT */


#define EDMA3CC_QSTAT_THRXCD (0x01000000u)
#define EDMA3CC_QSTAT_THRXCD_SHIFT (0x00000018u)
#define EDMA3CC_QSTAT_WM (0x001F0000u)
#define EDMA3CC_QSTAT_WM_SHIFT (0x00000010u)
#define EDMA3CC_QSTAT_NUMVAL (0x00001F00u)
#define EDMA3CC_QSTAT_NUMVAL_SHIFT (0x00000008u)
#define EDMA3CC_QSTAT_NUMVAL_EMPTY (0x00000000u)
#define EDMA3CC_QSTAT_NUMVAL_FULL (0x00000010u)
#define EDMA3CC_QSTAT_STRTPTR (0x0000000Fu)
#define EDMA3CC_QSTAT_STRTPTR_SHIFT (0x00000000u)


/* QWMTHRA */


#define EDMA3CC_QWMTHRA_Q2 (0x001F0000u)
#define EDMA3CC_QWMTHRA_Q2_SHIFT (0x00000010u)
#define EDMA3CC_QWMTHRA_Q2_MAX (0x00000010u)
#define EDMA3CC_QWMTHRA_Q1 (0x00001F00u)
#define EDMA3CC_QWMTHRA_Q1_SHIFT (0x00000008u)
#define EDMA3CC_QWMTHRA_Q1_MAX (0x00000010u)
#define EDMA3CC_QWMTHRA_Q0 (0x0000001Fu)
#define EDMA3CC_QWMTHRA_Q0_SHIFT (0x00000000u)
#define EDMA3CC_QWMTHRA_Q0_MAX (0x00000010u)


/* CCSTAT */


#define EDMA3CC_CCSTAT_QUEACTV2 (0x00040000u)
#define EDMA3CC_CCSTAT_QUEACTV2_SHIFT (0x00000012u)
#define EDMA3CC_CCSTAT_QUEACTV1 (0x00020000u)
#define EDMA3CC_CCSTAT_QUEACTV1_SHIFT (0x00000011u)
#define EDMA3CC_CCSTAT_QUEACTV0 (0x00010000u)
#define EDMA3CC_CCSTAT_QUEACTV0_SHIFT (0x00000010u)
#define EDMA3CC_CCSTAT_COMPACTV (0x00003F00u)
#define EDMA3CC_CCSTAT_COMPACTV_SHIFT (0x00000008u)
#define EDMA3CC_CCSTAT_ACTV (0x00000010u)
#define EDMA3CC_CCSTAT_ACTV_SHIFT (0x00000004u)
#define EDMA3CC_CCSTAT_WSTATACTV (0x00000008u)
#define EDMA3CC_CCSTAT_WSTATACTV_SHIFT (0x00000003u)
#define EDMA3CC_CCSTAT_TRACTV (0x00000004u)
#define EDMA3CC_CCSTAT_TRACTV_SHIFT (0x00000002u)
#define EDMA3CC_CCSTAT_QEVTACTV (0x00000002u)
#define EDMA3CC_CCSTAT_QEVTACTV_SHIFT (0x00000001u)
#define EDMA3CC_CCSTAT_EVTACTV (0x00000001u)
#define EDMA3CC_CCSTAT_EVTACTV_SHIFT (0x00000000u)

/* ER */

#define EDMA3CC_ER_E31 (0x80000000u)
#define EDMA3CC_ER_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_ER_E30 (0x40000000u)
#define EDMA3CC_ER_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_ER_E29 (0x20000000u)
#define EDMA3CC_ER_E29_SHIFT (0x0000001Du)
#define EDMA3CC_ER_E28 (0x10000000u)
#define EDMA3CC_ER_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_ER_E27 (0x08000000u)
#define EDMA3CC_ER_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_ER_E26 (0x04000000u)
#define EDMA3CC_ER_E26_SHIFT (0x0000001Au)
#define EDMA3CC_ER_E25 (0x02000000u)
#define EDMA3CC_ER_E25_SHIFT (0x00000019u)
#define EDMA3CC_ER_E24 (0x01000000u)
#define EDMA3CC_ER_E24_SHIFT (0x00000018u)
#define EDMA3CC_ER_E23 (0x00800000u)
#define EDMA3CC_ER_E23_SHIFT (0x00000017u)
#define EDMA3CC_ER_E22 (0x00400000u)
#define EDMA3CC_ER_E22_SHIFT (0x00000016u)
#define EDMA3CC_ER_E21 (0x00200000u)
#define EDMA3CC_ER_E21_SHIFT (0x00000015u)
#define EDMA3CC_ER_E20 (0x00100000u)
#define EDMA3CC_ER_E20_SHIFT (0x00000014u)
#define EDMA3CC_ER_E19 (0x00080000u)
#define EDMA3CC_ER_E19_SHIFT (0x00000013u)
#define EDMA3CC_ER_E18 (0x00040000u)
#define EDMA3CC_ER_E18_SHIFT (0x00000012u)
#define EDMA3CC_ER_E17 (0x00020000u)
#define EDMA3CC_ER_E17_SHIFT (0x00000011u)
#define EDMA3CC_ER_E16 (0x00010000u)
#define EDMA3CC_ER_E16_SHIFT (0x00000010u)
#define EDMA3CC_ER_E15 (0x00008000u)
#define EDMA3CC_ER_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_ER_E14 (0x00004000u)
#define EDMA3CC_ER_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_ER_E13 (0x00002000u)
#define EDMA3CC_ER_E13_SHIFT (0x0000000Du)
#define EDMA3CC_ER_E12 (0x00001000u)
#define EDMA3CC_ER_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_ER_E11 (0x00000800u)
#define EDMA3CC_ER_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_ER_E10 (0x00000400u)
#define EDMA3CC_ER_E10_SHIFT (0x0000000Au)
#define EDMA3CC_ER_E9 (0x00000200u)
#define EDMA3CC_ER_E9_SHIFT (0x00000009u)
#define EDMA3CC_ER_E8 (0x00000100u)
#define EDMA3CC_ER_E8_SHIFT (0x00000008u)
#define EDMA3CC_ER_E7 (0x00000080u)
#define EDMA3CC_ER_E7_SHIFT (0x00000007u)
#define EDMA3CC_ER_E6 (0x00000040u)
#define EDMA3CC_ER_E6_SHIFT (0x00000006u)
#define EDMA3CC_ER_E5 (0x00000020u)
#define EDMA3CC_ER_E5_SHIFT (0x00000005u)
#define EDMA3CC_ER_E4 (0x00000010u)
#define EDMA3CC_ER_E4_SHIFT (0x00000004u)
#define EDMA3CC_ER_E3 (0x00000008u)
#define EDMA3CC_ER_E3_SHIFT (0x00000003u)
#define EDMA3CC_ER_E2 (0x00000004u)
#define EDMA3CC_ER_E2_SHIFT (0x00000002u)
#define EDMA3CC_ER_E1 (0x00000002u)
#define EDMA3CC_ER_E1_SHIFT (0x00000001u)
#define EDMA3CC_ER_E0 (0x00000001u)
#define EDMA3CC_ER_E0_SHIFT (0x00000000u)

/* ECR */

#define EDMA3CC_ECR_E31 (0x80000000u)
#define EDMA3CC_ECR_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_ECR_E30 (0x40000000u)
#define EDMA3CC_ECR_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_ECR_E29 (0x20000000u)
#define EDMA3CC_ECR_E29_SHIFT (0x0000001Du)
#define EDMA3CC_ECR_E28 (0x10000000u)
#define EDMA3CC_ECR_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_ECR_E27 (0x08000000u)
#define EDMA3CC_ECR_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_ECR_E26 (0x04000000u)
#define EDMA3CC_ECR_E26_SHIFT (0x0000001Au)
#define EDMA3CC_ECR_E25 (0x02000000u)
#define EDMA3CC_ECR_E25_SHIFT (0x00000019u)
#define EDMA3CC_ECR_E24 (0x01000000u)
#define EDMA3CC_ECR_E24_SHIFT (0x00000018u)
#define EDMA3CC_ECR_E23 (0x00800000u)
#define EDMA3CC_ECR_E23_SHIFT (0x00000017u)
#define EDMA3CC_ECR_E22 (0x00400000u)
#define EDMA3CC_ECR_E22_SHIFT (0x00000016u)
#define EDMA3CC_ECR_E21 (0x00200000u)
#define EDMA3CC_ECR_E21_SHIFT (0x00000015u)
#define EDMA3CC_ECR_E20 (0x00100000u)
#define EDMA3CC_ECR_E20_SHIFT (0x00000014u)
#define EDMA3CC_ECR_E19 (0x00080000u)
#define EDMA3CC_ECR_E19_SHIFT (0x00000013u)
#define EDMA3CC_ECR_E18 (0x00040000u)
#define EDMA3CC_ECR_E18_SHIFT (0x00000012u)
#define EDMA3CC_ECR_E17 (0x00020000u)
#define EDMA3CC_ECR_E17_SHIFT (0x00000011u)
#define EDMA3CC_ECR_E16 (0x00010000u)
#define EDMA3CC_ECR_E16_SHIFT (0x00000010u)
#define EDMA3CC_ECR_E15 (0x00008000u)
#define EDMA3CC_ECR_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_ECR_E14 (0x00004000u)
#define EDMA3CC_ECR_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_ECR_E13 (0x00002000u)
#define EDMA3CC_ECR_E13_SHIFT (0x0000000Du)
#define EDMA3CC_ECR_E12 (0x00001000u)
#define EDMA3CC_ECR_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_ECR_E11 (0x00000800u)
#define EDMA3CC_ECR_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_ECR_E10 (0x00000400u)
#define EDMA3CC_ECR_E10_SHIFT (0x0000000Au)
#define EDMA3CC_ECR_E9 (0x00000200u)
#define EDMA3CC_ECR_E9_SHIFT (0x00000009u)
#define EDMA3CC_ECR_E8 (0x00000100u)
#define EDMA3CC_ECR_E8_SHIFT (0x00000008u)
#define EDMA3CC_ECR_E7 (0x00000080u)
#define EDMA3CC_ECR_E7_SHIFT (0x00000007u)
#define EDMA3CC_ECR_E6 (0x00000040u)
#define EDMA3CC_ECR_E6_SHIFT (0x00000006u)
#define EDMA3CC_ECR_E5 (0x00000020u)
#define EDMA3CC_ECR_E5_SHIFT (0x00000005u)
#define EDMA3CC_ECR_E4 (0x00000010u)
#define EDMA3CC_ECR_E4_SHIFT (0x00000004u)
#define EDMA3CC_ECR_E3 (0x00000008u)
#define EDMA3CC_ECR_E3_SHIFT (0x00000003u)
#define EDMA3CC_ECR_E2 (0x00000004u)
#define EDMA3CC_ECR_E2_SHIFT (0x00000002u)
#define EDMA3CC_ECR_E1 (0x00000002u)
#define EDMA3CC_ECR_E1_SHIFT (0x00000001u)
#define EDMA3CC_ECR_E0 (0x00000001u)
#define EDMA3CC_ECR_E0_SHIFT (0x00000000u)

/* ESR */

#define EDMA3CC_ESR_E31 (0x80000000u)
#define EDMA3CC_ESR_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_ESR_E30 (0x40000000u)
#define EDMA3CC_ESR_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_ESR_E29 (0x20000000u)
#define EDMA3CC_ESR_E29_SHIFT (0x0000001Du)
#define EDMA3CC_ESR_E28 (0x10000000u)
#define EDMA3CC_ESR_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_ESR_E27 (0x08000000u)
#define EDMA3CC_ESR_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_ESR_E26 (0x04000000u)
#define EDMA3CC_ESR_E26_SHIFT (0x0000001Au)
#define EDMA3CC_ESR_E25 (0x02000000u)
#define EDMA3CC_ESR_E25_SHIFT (0x00000019u)
#define EDMA3CC_ESR_E24 (0x01000000u)
#define EDMA3CC_ESR_E24_SHIFT (0x00000018u)
#define EDMA3CC_ESR_E23 (0x00800000u)
#define EDMA3CC_ESR_E23_SHIFT (0x00000017u)
#define EDMA3CC_ESR_E22 (0x00400000u)
#define EDMA3CC_ESR_E22_SHIFT (0x00000016u)
#define EDMA3CC_ESR_E21 (0x00200000u)
#define EDMA3CC_ESR_E21_SHIFT (0x00000015u)
#define EDMA3CC_ESR_E20 (0x00100000u)
#define EDMA3CC_ESR_E20_SHIFT (0x00000014u)
#define EDMA3CC_ESR_E19 (0x00080000u)
#define EDMA3CC_ESR_E19_SHIFT (0x00000013u)
#define EDMA3CC_ESR_E18 (0x00040000u)
#define EDMA3CC_ESR_E18_SHIFT (0x00000012u)
#define EDMA3CC_ESR_E17 (0x00020000u)
#define EDMA3CC_ESR_E17_SHIFT (0x00000011u)
#define EDMA3CC_ESR_E16 (0x00010000u)
#define EDMA3CC_ESR_E16_SHIFT (0x00000010u)
#define EDMA3CC_ESR_E15 (0x00008000u)
#define EDMA3CC_ESR_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_ESR_E14 (0x00004000u)
#define EDMA3CC_ESR_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_ESR_E13 (0x00002000u)
#define EDMA3CC_ESR_E13_SHIFT (0x0000000Du)
#define EDMA3CC_ESR_E12 (0x00001000u)
#define EDMA3CC_ESR_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_ESR_E11 (0x00000800u)
#define EDMA3CC_ESR_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_ESR_E10 (0x00000400u)
#define EDMA3CC_ESR_E10_SHIFT (0x0000000Au)
#define EDMA3CC_ESR_E9 (0x00000200u)
#define EDMA3CC_ESR_E9_SHIFT (0x00000009u)
#define EDMA3CC_ESR_E8 (0x00000100u)
#define EDMA3CC_ESR_E8_SHIFT (0x00000008u)
#define EDMA3CC_ESR_E7 (0x00000080u)
#define EDMA3CC_ESR_E7_SHIFT (0x00000007u)
#define EDMA3CC_ESR_E6 (0x00000040u)
#define EDMA3CC_ESR_E6_SHIFT (0x00000006u)
#define EDMA3CC_ESR_E5 (0x00000020u)
#define EDMA3CC_ESR_E5_SHIFT (0x00000005u)
#define EDMA3CC_ESR_E4 (0x00000010u)
#define EDMA3CC_ESR_E4_SHIFT (0x00000004u)
#define EDMA3CC_ESR_E3 (0x00000008u)
#define EDMA3CC_ESR_E3_SHIFT (0x00000003u)
#define EDMA3CC_ESR_E2 (0x00000004u)
#define EDMA3CC_ESR_E2_SHIFT (0x00000002u)
#define EDMA3CC_ESR_E1 (0x00000002u)
#define EDMA3CC_ESR_E1_SHIFT (0x00000001u)
#define EDMA3CC_ESR_E0 (0x00000001u)
#define EDMA3CC_ESR_E0_SHIFT (0x00000000u)

/* CER */

#define EDMA3CC_CER_E31 (0x80000000u)
#define EDMA3CC_CER_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_CER_E30 (0x40000000u)
#define EDMA3CC_CER_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_CER_E29 (0x20000000u)
#define EDMA3CC_CER_E29_SHIFT (0x0000001Du)
#define EDMA3CC_CER_E28 (0x10000000u)
#define EDMA3CC_CER_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_CER_E27 (0x08000000u)
#define EDMA3CC_CER_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_CER_E26 (0x04000000u)
#define EDMA3CC_CER_E26_SHIFT (0x0000001Au)
#define EDMA3CC_CER_E25 (0x02000000u)
#define EDMA3CC_CER_E25_SHIFT (0x00000019u)
#define EDMA3CC_CER_E24 (0x01000000u)
#define EDMA3CC_CER_E24_SHIFT (0x00000018u)
#define EDMA3CC_CER_E23 (0x00800000u)
#define EDMA3CC_CER_E23_SHIFT (0x00000017u)
#define EDMA3CC_CER_E22 (0x00400000u)
#define EDMA3CC_CER_E22_SHIFT (0x00000016u)
#define EDMA3CC_CER_E21 (0x00200000u)
#define EDMA3CC_CER_E21_SHIFT (0x00000015u)
#define EDMA3CC_CER_E20 (0x00100000u)
#define EDMA3CC_CER_E20_SHIFT (0x00000014u)
#define EDMA3CC_CER_E19 (0x00080000u)
#define EDMA3CC_CER_E19_SHIFT (0x00000013u)
#define EDMA3CC_CER_E18 (0x00040000u)
#define EDMA3CC_CER_E18_SHIFT (0x00000012u)
#define EDMA3CC_CER_E17 (0x00020000u)
#define EDMA3CC_CER_E17_SHIFT (0x00000011u)
#define EDMA3CC_CER_E16 (0x00010000u)
#define EDMA3CC_CER_E16_SHIFT (0x00000010u)
#define EDMA3CC_CER_E15 (0x00008000u)
#define EDMA3CC_CER_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_CER_E14 (0x00004000u)
#define EDMA3CC_CER_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_CER_E13 (0x00002000u)
#define EDMA3CC_CER_E13_SHIFT (0x0000000Du)
#define EDMA3CC_CER_E12 (0x00001000u)
#define EDMA3CC_CER_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_CER_E11 (0x00000800u)
#define EDMA3CC_CER_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_CER_E10 (0x00000400u)
#define EDMA3CC_CER_E10_SHIFT (0x0000000Au)
#define EDMA3CC_CER_E9 (0x00000200u)
#define EDMA3CC_CER_E9_SHIFT (0x00000009u)
#define EDMA3CC_CER_E8 (0x00000100u)
#define EDMA3CC_CER_E8_SHIFT (0x00000008u)
#define EDMA3CC_CER_E7 (0x00000080u)
#define EDMA3CC_CER_E7_SHIFT (0x00000007u)
#define EDMA3CC_CER_E6 (0x00000040u)
#define EDMA3CC_CER_E6_SHIFT (0x00000006u)
#define EDMA3CC_CER_E5 (0x00000020u)
#define EDMA3CC_CER_E5_SHIFT (0x00000005u)
#define EDMA3CC_CER_E4 (0x00000010u)
#define EDMA3CC_CER_E4_SHIFT (0x00000004u)
#define EDMA3CC_CER_E3 (0x00000008u)
#define EDMA3CC_CER_E3_SHIFT (0x00000003u)
#define EDMA3CC_CER_E2 (0x00000004u)
#define EDMA3CC_CER_E2_SHIFT (0x00000002u)
#define EDMA3CC_CER_E1 (0x00000002u)
#define EDMA3CC_CER_E1_SHIFT (0x00000001u)
#define EDMA3CC_CER_E0 (0x00000001u)
#define EDMA3CC_CER_E0_SHIFT (0x00000000u)


/* EER */

#define EDMA3CC_EER_E31 (0x80000000u)
#define EDMA3CC_EER_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_EER_E30 (0x40000000u)
#define EDMA3CC_EER_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_EER_E29 (0x20000000u)
#define EDMA3CC_EER_E29_SHIFT (0x0000001Du)
#define EDMA3CC_EER_E28 (0x10000000u)
#define EDMA3CC_EER_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_EER_E27 (0x08000000u)
#define EDMA3CC_EER_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_EER_E26 (0x04000000u)
#define EDMA3CC_EER_E26_SHIFT (0x0000001Au)
#define EDMA3CC_EER_E25 (0x02000000u)
#define EDMA3CC_EER_E25_SHIFT (0x00000019u)
#define EDMA3CC_EER_E24 (0x01000000u)
#define EDMA3CC_EER_E24_SHIFT (0x00000018u)
#define EDMA3CC_EER_E23 (0x00800000u)
#define EDMA3CC_EER_E23_SHIFT (0x00000017u)
#define EDMA3CC_EER_E22 (0x00400000u)
#define EDMA3CC_EER_E22_SHIFT (0x00000016u)
#define EDMA3CC_EER_E21 (0x00200000u)
#define EDMA3CC_EER_E21_SHIFT (0x00000015u)
#define EDMA3CC_EER_E20 (0x00100000u)
#define EDMA3CC_EER_E20_SHIFT (0x00000014u)
#define EDMA3CC_EER_E19 (0x00080000u)
#define EDMA3CC_EER_E19_SHIFT (0x00000013u)
#define EDMA3CC_EER_E18 (0x00040000u)
#define EDMA3CC_EER_E18_SHIFT (0x00000012u)
#define EDMA3CC_EER_E17 (0x00020000u)
#define EDMA3CC_EER_E17_SHIFT (0x00000011u)
#define EDMA3CC_EER_E16 (0x00010000u)
#define EDMA3CC_EER_E16_SHIFT (0x00000010u)
#define EDMA3CC_EER_E15 (0x00008000u)
#define EDMA3CC_EER_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_EER_E14 (0x00004000u)
#define EDMA3CC_EER_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_EER_E13 (0x00002000u)
#define EDMA3CC_EER_E13_SHIFT (0x0000000Du)
#define EDMA3CC_EER_E12 (0x00001000u)
#define EDMA3CC_EER_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_EER_E11 (0x00000800u)
#define EDMA3CC_EER_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_EER_E10 (0x00000400u)
#define EDMA3CC_EER_E10_SHIFT (0x0000000Au)
#define EDMA3CC_EER_E9 (0x00000200u)
#define EDMA3CC_EER_E9_SHIFT (0x00000009u)
#define EDMA3CC_EER_E8 (0x00000100u)
#define EDMA3CC_EER_E8_SHIFT (0x00000008u)
#define EDMA3CC_EER_E7 (0x00000080u)
#define EDMA3CC_EER_E7_SHIFT (0x00000007u)
#define EDMA3CC_EER_E6 (0x00000040u)
#define EDMA3CC_EER_E6_SHIFT (0x00000006u)
#define EDMA3CC_EER_E5 (0x00000020u)
#define EDMA3CC_EER_E5_SHIFT (0x00000005u)
#define EDMA3CC_EER_E4 (0x00000010u)
#define EDMA3CC_EER_E4_SHIFT (0x00000004u)
#define EDMA3CC_EER_E3 (0x00000008u)
#define EDMA3CC_EER_E3_SHIFT (0x00000003u)
#define EDMA3CC_EER_E2 (0x00000004u)
#define EDMA3CC_EER_E2_SHIFT (0x00000002u)
#define EDMA3CC_EER_E1 (0x00000002u)
#define EDMA3CC_EER_E1_SHIFT (0x00000001u)

#define EDMA3CC_EER_E0 (0x00000001u)
#define EDMA3CC_EER_E0_SHIFT (0x00000000u)


/* EECR */

#define EDMA3CC_EECR_E31 (0x80000000u)
#define EDMA3CC_EECR_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_EECR_E30 (0x40000000u)
#define EDMA3CC_EECR_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_EECR_E29 (0x20000000u)
#define EDMA3CC_EECR_E29_SHIFT (0x0000001Du)
#define EDMA3CC_EECR_E28 (0x10000000u)
#define EDMA3CC_EECR_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_EECR_E27 (0x08000000u)
#define EDMA3CC_EECR_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_EECR_E26 (0x04000000u)
#define EDMA3CC_EECR_E26_SHIFT (0x0000001Au)
#define EDMA3CC_EECR_E25 (0x02000000u)
#define EDMA3CC_EECR_E25_SHIFT (0x00000019u)
#define EDMA3CC_EECR_E24 (0x01000000u)
#define EDMA3CC_EECR_E24_SHIFT (0x00000018u)
#define EDMA3CC_EECR_E23 (0x00800000u)
#define EDMA3CC_EECR_E23_SHIFT (0x00000017u)
#define EDMA3CC_EECR_E22 (0x00400000u)
#define EDMA3CC_EECR_E22_SHIFT (0x00000016u)
#define EDMA3CC_EECR_E21 (0x00200000u)
#define EDMA3CC_EECR_E21_SHIFT (0x00000015u)
#define EDMA3CC_EECR_E20 (0x00100000u)
#define EDMA3CC_EECR_E20_SHIFT (0x00000014u)
#define EDMA3CC_EECR_E19 (0x00080000u)
#define EDMA3CC_EECR_E19_SHIFT (0x00000013u)
#define EDMA3CC_EECR_E18 (0x00040000u)
#define EDMA3CC_EECR_E18_SHIFT (0x00000012u)
#define EDMA3CC_EECR_E17 (0x00020000u)
#define EDMA3CC_EECR_E17_SHIFT (0x00000011u)
#define EDMA3CC_EECR_E16 (0x00010000u)
#define EDMA3CC_EECR_E16_SHIFT (0x00000010u)
#define EDMA3CC_EECR_E15 (0x00008000u)
#define EDMA3CC_EECR_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_EECR_E14 (0x00004000u)
#define EDMA3CC_EECR_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_EECR_E13 (0x00002000u)
#define EDMA3CC_EECR_E13_SHIFT (0x0000000Du)
#define EDMA3CC_EECR_E12 (0x00001000u)
#define EDMA3CC_EECR_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_EECR_E11 (0x00000800u)
#define EDMA3CC_EECR_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_EECR_E10 (0x00000400u)
#define EDMA3CC_EECR_E10_SHIFT (0x0000000Au)
#define EDMA3CC_EECR_E9 (0x00000200u)
#define EDMA3CC_EECR_E9_SHIFT (0x00000009u)
#define EDMA3CC_EECR_E8 (0x00000100u)
#define EDMA3CC_EECR_E8_SHIFT (0x00000008u)
#define EDMA3CC_EECR_E7 (0x00000080u)
#define EDMA3CC_EECR_E7_SHIFT (0x00000007u)
#define EDMA3CC_EECR_E6 (0x00000040u)
#define EDMA3CC_EECR_E6_SHIFT (0x00000006u)
#define EDMA3CC_EECR_E5 (0x00000020u)
#define EDMA3CC_EECR_E5_SHIFT (0x00000005u)
#define EDMA3CC_EECR_E4 (0x00000010u)
#define EDMA3CC_EECR_E4_SHIFT (0x00000004u)
#define EDMA3CC_EECR_E3 (0x00000008u)
#define EDMA3CC_EECR_E3_SHIFT (0x00000003u)
#define EDMA3CC_EECR_E2 (0x00000004u)
#define EDMA3CC_EECR_E2_SHIFT (0x00000002u)
#define EDMA3CC_EECR_E1 (0x00000002u)
#define EDMA3CC_EECR_E1_SHIFT (0x00000001u)
#define EDMA3CC_EECR_E0 (0x00000001u)
#define EDMA3CC_EECR_E0_SHIFT (0x00000000u)

/* EESR */

#define EDMA3CC_EESR_E31 (0x80000000u)
#define EDMA3CC_EESR_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_EESR_E30 (0x40000000u)
#define EDMA3CC_EESR_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_EESR_E29 (0x20000000u)
#define EDMA3CC_EESR_E29_SHIFT (0x0000001Du)
#define EDMA3CC_EESR_E28 (0x10000000u)
#define EDMA3CC_EESR_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_EESR_E27 (0x08000000u)
#define EDMA3CC_EESR_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_EESR_E26 (0x04000000u)
#define EDMA3CC_EESR_E26_SHIFT (0x0000001Au)
#define EDMA3CC_EESR_E25 (0x02000000u)
#define EDMA3CC_EESR_E25_SHIFT (0x00000019u)
#define EDMA3CC_EESR_E24 (0x01000000u)
#define EDMA3CC_EESR_E24_SHIFT (0x00000018u)
#define EDMA3CC_EESR_E23 (0x00800000u)
#define EDMA3CC_EESR_E23_SHIFT (0x00000017u)
#define EDMA3CC_EESR_E22 (0x00400000u)
#define EDMA3CC_EESR_E22_SHIFT (0x00000016u)
#define EDMA3CC_EESR_E21 (0x00200000u)
#define EDMA3CC_EESR_E21_SHIFT (0x00000015u)
#define EDMA3CC_EESR_E20 (0x00100000u)
#define EDMA3CC_EESR_E20_SHIFT (0x00000014u)
#define EDMA3CC_EESR_E19 (0x00080000u)
#define EDMA3CC_EESR_E19_SHIFT (0x00000013u)
#define EDMA3CC_EESR_E18 (0x00040000u)
#define EDMA3CC_EESR_E18_SHIFT (0x00000012u)
#define EDMA3CC_EESR_E17 (0x00020000u)
#define EDMA3CC_EESR_E17_SHIFT (0x00000011u)
#define EDMA3CC_EESR_E16 (0x00010000u)
#define EDMA3CC_EESR_E16_SHIFT (0x00000010u)
#define EDMA3CC_EESR_E15 (0x00008000u)
#define EDMA3CC_EESR_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_EESR_E14 (0x00004000u)
#define EDMA3CC_EESR_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_EESR_E13 (0x00002000u)
#define EDMA3CC_EESR_E13_SHIFT (0x0000000Du)
#define EDMA3CC_EESR_E12 (0x00001000u)
#define EDMA3CC_EESR_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_EESR_E11 (0x00000800u)
#define EDMA3CC_EESR_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_EESR_E10 (0x00000400u)
#define EDMA3CC_EESR_E10_SHIFT (0x0000000Au)
#define EDMA3CC_EESR_E9 (0x00000200u)
#define EDMA3CC_EESR_E9_SHIFT (0x00000009u)
#define EDMA3CC_EESR_E8 (0x00000100u)
#define EDMA3CC_EESR_E8_SHIFT (0x00000008u)
#define EDMA3CC_EESR_E7 (0x00000080u)
#define EDMA3CC_EESR_E7_SHIFT (0x00000007u)
#define EDMA3CC_EESR_E6 (0x00000040u)
#define EDMA3CC_EESR_E6_SHIFT (0x00000006u)
#define EDMA3CC_EESR_E5 (0x00000020u)
#define EDMA3CC_EESR_E5_SHIFT (0x00000005u)
#define EDMA3CC_EESR_E4 (0x00000010u)
#define EDMA3CC_EESR_E4_SHIFT (0x00000004u)
#define EDMA3CC_EESR_E3 (0x00000008u)
#define EDMA3CC_EESR_E3_SHIFT (0x00000003u)
#define EDMA3CC_EESR_E2 (0x00000004u)
#define EDMA3CC_EESR_E2_SHIFT (0x00000002u)
#define EDMA3CC_EESR_E1 (0x00000002u)
#define EDMA3CC_EESR_E1_SHIFT (0x00000001u)
#define EDMA3CC_EESR_E0 (0x00000001u)
#define EDMA3CC_EESR_E0_SHIFT (0x00000000u)

/* SER */

#define EDMA3CC_SER_E31 (0x80000000u)
#define EDMA3CC_SER_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_SER_E30 (0x40000000u)
#define EDMA3CC_SER_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_SER_E29 (0x20000000u)
#define EDMA3CC_SER_E29_SHIFT (0x0000001Du)
#define EDMA3CC_SER_E28 (0x10000000u)
#define EDMA3CC_SER_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_SER_E27 (0x08000000u)
#define EDMA3CC_SER_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_SER_E26 (0x04000000u)
#define EDMA3CC_SER_E26_SHIFT (0x0000001Au)
#define EDMA3CC_SER_E25 (0x02000000u)
#define EDMA3CC_SER_E25_SHIFT (0x00000019u)
#define EDMA3CC_SER_E24 (0x01000000u)
#define EDMA3CC_SER_E24_SHIFT (0x00000018u)
#define EDMA3CC_SER_E23 (0x00800000u)
#define EDMA3CC_SER_E23_SHIFT (0x00000017u)
#define EDMA3CC_SER_E22 (0x00400000u)
#define EDMA3CC_SER_E22_SHIFT (0x00000016u)
#define EDMA3CC_SER_E21 (0x00200000u)
#define EDMA3CC_SER_E21_SHIFT (0x00000015u)
#define EDMA3CC_SER_E20 (0x00100000u)
#define EDMA3CC_SER_E20_SHIFT (0x00000014u)
#define EDMA3CC_SER_E19 (0x00080000u)
#define EDMA3CC_SER_E19_SHIFT (0x00000013u)
#define EDMA3CC_SER_E18 (0x00040000u)
#define EDMA3CC_SER_E18_SHIFT (0x00000012u)
#define EDMA3CC_SER_E17 (0x00020000u)
#define EDMA3CC_SER_E17_SHIFT (0x00000011u)
#define EDMA3CC_SER_E16 (0x00010000u)
#define EDMA3CC_SER_E16_SHIFT (0x00000010u)
#define EDMA3CC_SER_E15 (0x00008000u)
#define EDMA3CC_SER_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_SER_E14 (0x00004000u)
#define EDMA3CC_SER_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_SER_E13 (0x00002000u)
#define EDMA3CC_SER_E13_SHIFT (0x0000000Du)
#define EDMA3CC_SER_E12 (0x00001000u)
#define EDMA3CC_SER_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_SER_E11 (0x00000800u)
#define EDMA3CC_SER_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_SER_E10 (0x00000400u)
#define EDMA3CC_SER_E10_SHIFT (0x0000000Au)
#define EDMA3CC_SER_E9 (0x00000200u)
#define EDMA3CC_SER_E9_SHIFT (0x00000009u)
#define EDMA3CC_SER_E8 (0x00000100u)
#define EDMA3CC_SER_E8_SHIFT (0x00000008u)
#define EDMA3CC_SER_E7 (0x00000080u)
#define EDMA3CC_SER_E7_SHIFT (0x00000007u)
#define EDMA3CC_SER_E6 (0x00000040u)
#define EDMA3CC_SER_E6_SHIFT (0x00000006u)
#define EDMA3CC_SER_E5 (0x00000020u)
#define EDMA3CC_SER_E5_SHIFT (0x00000005u)
#define EDMA3CC_SER_E4 (0x00000010u)
#define EDMA3CC_SER_E4_SHIFT (0x00000004u)
#define EDMA3CC_SER_E3 (0x00000008u)
#define EDMA3CC_SER_E3_SHIFT (0x00000003u)
#define EDMA3CC_SER_E2 (0x00000004u)
#define EDMA3CC_SER_E2_SHIFT (0x00000002u)
#define EDMA3CC_SER_E1 (0x00000002u)
#define EDMA3CC_SER_E1_SHIFT (0x00000001u)
#define EDMA3CC_SER_E0 (0x00000001u)
#define EDMA3CC_SER_E0_SHIFT (0x00000000u)

/* SECR */

#define EDMA3CC_SECR_E31 (0x80000000u)
#define EDMA3CC_SECR_E31_SHIFT (0x0000001Fu)
#define EDMA3CC_SECR_E30 (0x40000000u)
#define EDMA3CC_SECR_E30_SHIFT (0x0000001Eu)
#define EDMA3CC_SECR_E29 (0x20000000u)
#define EDMA3CC_SECR_E29_SHIFT (0x0000001Du)
#define EDMA3CC_SECR_E28 (0x10000000u)
#define EDMA3CC_SECR_E28_SHIFT (0x0000001Cu)
#define EDMA3CC_SECR_E27 (0x08000000u)
#define EDMA3CC_SECR_E27_SHIFT (0x0000001Bu)
#define EDMA3CC_SECR_E26 (0x04000000u)
#define EDMA3CC_SECR_E26_SHIFT (0x0000001Au)
#define EDMA3CC_SECR_E25 (0x02000000u)
#define EDMA3CC_SECR_E25_SHIFT (0x00000019u)
#define EDMA3CC_SECR_E24 (0x01000000u)
#define EDMA3CC_SECR_E24_SHIFT (0x00000018u)
#define EDMA3CC_SECR_E23 (0x00800000u)
#define EDMA3CC_SECR_E23_SHIFT (0x00000017u)
#define EDMA3CC_SECR_E22 (0x00400000u)
#define EDMA3CC_SECR_E22_SHIFT (0x00000016u)
#define EDMA3CC_SECR_E21 (0x00200000u)
#define EDMA3CC_SECR_E21_SHIFT (0x00000015u)
#define EDMA3CC_SECR_E20 (0x00100000u)
#define EDMA3CC_SECR_E20_SHIFT (0x00000014u)
#define EDMA3CC_SECR_E19 (0x00080000u)
#define EDMA3CC_SECR_E19_SHIFT (0x00000013u)
#define EDMA3CC_SECR_E18 (0x00040000u)
#define EDMA3CC_SECR_E18_SHIFT (0x00000012u)
#define EDMA3CC_SECR_E17 (0x00020000u)
#define EDMA3CC_SECR_E17_SHIFT (0x00000011u)
#define EDMA3CC_SECR_E16 (0x00010000u)
#define EDMA3CC_SECR_E16_SHIFT (0x00000010u)
#define EDMA3CC_SECR_E15 (0x00008000u)
#define EDMA3CC_SECR_E15_SHIFT (0x0000000Fu)
#define EDMA3CC_SECR_E14 (0x00004000u)
#define EDMA3CC_SECR_E14_SHIFT (0x0000000Eu)
#define EDMA3CC_SECR_E13 (0x00002000u)
#define EDMA3CC_SECR_E13_SHIFT (0x0000000Du)
#define EDMA3CC_SECR_E12 (0x00001000u)
#define EDMA3CC_SECR_E12_SHIFT (0x0000000Cu)
#define EDMA3CC_SECR_E11 (0x00000800u)
#define EDMA3CC_SECR_E11_SHIFT (0x0000000Bu)
#define EDMA3CC_SECR_E10 (0x00000400u)
#define EDMA3CC_SECR_E10_SHIFT (0x0000000Au)
#define EDMA3CC_SECR_E9 (0x00000200u)
#define EDMA3CC_SECR_E9_SHIFT (0x00000009u)
#define EDMA3CC_SECR_E8 (0x00000100u)
#define EDMA3CC_SECR_E8_SHIFT (0x00000008u)
#define EDMA3CC_SECR_E7 (0x00000080u)
#define EDMA3CC_SECR_E7_SHIFT (0x00000007u)
#define EDMA3CC_SECR_E6 (0x00000040u)
#define EDMA3CC_SECR_E6_SHIFT (0x00000006u)
#define EDMA3CC_SECR_E5 (0x00000020u)
#define EDMA3CC_SECR_E5_SHIFT (0x00000005u)
#define EDMA3CC_SECR_E4 (0x00000010u)
#define EDMA3CC_SECR_E4_SHIFT (0x00000004u)
#define EDMA3CC_SECR_E3 (0x00000008u)
#define EDMA3CC_SECR_E3_SHIFT (0x00000003u)
#define EDMA3CC_SECR_E2 (0x00000004u)
#define EDMA3CC_SECR_E2_SHIFT (0x00000002u)
#define EDMA3CC_SECR_E1 (0x00000002u)
#define EDMA3CC_SECR_E1_SHIFT (0x00000001u)
#define EDMA3CC_SECR_E0 (0x00000001u)
#define EDMA3CC_SECR_E0_SHIFT (0x00000000u)

/* IER */

#define EDMA3CC_IER_I31 (0x80000000u)
#define EDMA3CC_IER_I31_SHIFT (0x0000001Fu)
#define EDMA3CC_IER_I30 (0x40000000u)
#define EDMA3CC_IER_I30_SHIFT (0x0000001Eu)
#define EDMA3CC_IER_I29 (0x20000000u)
#define EDMA3CC_IER_I29_SHIFT (0x0000001Du)
#define EDMA3CC_IER_I28 (0x10000000u)
#define EDMA3CC_IER_I28_SHIFT (0x0000001Cu)
#define EDMA3CC_IER_I27 (0x08000000u)
#define EDMA3CC_IER_I27_SHIFT (0x0000001Bu)
#define EDMA3CC_IER_I26 (0x04000000u)
#define EDMA3CC_IER_I26_SHIFT (0x0000001Au)
#define EDMA3CC_IER_I25 (0x02000000u)
#define EDMA3CC_IER_I25_SHIFT (0x00000019u)
#define EDMA3CC_IER_I24 (0x01000000u)
#define EDMA3CC_IER_I24_SHIFT (0x00000018u)
#define EDMA3CC_IER_I23 (0x00800000u)
#define EDMA3CC_IER_I23_SHIFT (0x00000017u)
#define EDMA3CC_IER_I22 (0x00400000u)
#define EDMA3CC_IER_I22_SHIFT (0x00000016u)
#define EDMA3CC_IER_I21 (0x00200000u)
#define EDMA3CC_IER_I21_SHIFT (0x00000015u)
#define EDMA3CC_IER_I20 (0x00100000u)
#define EDMA3CC_IER_I20_SHIFT (0x00000014u)
#define EDMA3CC_IER_I19 (0x00080000u)
#define EDMA3CC_IER_I19_SHIFT (0x00000013u)
#define EDMA3CC_IER_I18 (0x00040000u)
#define EDMA3CC_IER_I18_SHIFT (0x00000012u)
#define EDMA3CC_IER_I17 (0x00020000u)
#define EDMA3CC_IER_I17_SHIFT (0x00000011u)
#define EDMA3CC_IER_I16 (0x00010000u)
#define EDMA3CC_IER_I16_SHIFT (0x00000010u)
#define EDMA3CC_IER_I15 (0x00008000u)
#define EDMA3CC_IER_I15_SHIFT (0x0000000Fu)
#define EDMA3CC_IER_I14 (0x00004000u)
#define EDMA3CC_IER_I14_SHIFT (0x0000000Eu)
#define EDMA3CC_IER_I13 (0x00002000u)
#define EDMA3CC_IER_I13_SHIFT (0x0000000Du)
#define EDMA3CC_IER_I12 (0x00001000u)
#define EDMA3CC_IER_I12_SHIFT (0x0000000Cu)
#define EDMA3CC_IER_I11 (0x00000800u)
#define EDMA3CC_IER_I11_SHIFT (0x0000000Bu)
#define EDMA3CC_IER_I10 (0x00000400u)
#define EDMA3CC_IER_I10_SHIFT (0x0000000Au)
#define EDMA3CC_IER_I9 (0x00000200u)
#define EDMA3CC_IER_I9_SHIFT (0x00000009u)
#define EDMA3CC_IER_I8 (0x00000100u)
#define EDMA3CC_IER_I8_SHIFT (0x00000008u)
#define EDMA3CC_IER_I7 (0x00000080u)
#define EDMA3CC_IER_I7_SHIFT (0x00000007u)
#define EDMA3CC_IER_I6 (0x00000040u)
#define EDMA3CC_IER_I6_SHIFT (0x00000006u)
#define EDMA3CC_IER_I5 (0x00000020u)
#define EDMA3CC_IER_I5_SHIFT (0x00000005u)
#define EDMA3CC_IER_I4 (0x00000010u)
#define EDMA3CC_IER_I4_SHIFT (0x00000004u)
#define EDMA3CC_IER_I3 (0x00000008u)
#define EDMA3CC_IER_I3_SHIFT (0x00000003u)
#define EDMA3CC_IER_I2 (0x00000004u)
#define EDMA3CC_IER_I2_SHIFT (0x00000002u)
#define EDMA3CC_IER_I1 (0x00000002u)
#define EDMA3CC_IER_I1_SHIFT (0x00000001u)
#define EDMA3CC_IER_I0 (0x00000001u)
#define EDMA3CC_IER_I0_SHIFT (0x00000000u)

/* IECR */

#define EDMA3CC_IECR_I31 (0x80000000u)
#define EDMA3CC_IECR_I31_SHIFT (0x0000001Fu)
#define EDMA3CC_IECR_I30 (0x40000000u)
#define EDMA3CC_IECR_I30_SHIFT (0x0000001Eu)
#define EDMA3CC_IECR_I29 (0x20000000u)
#define EDMA3CC_IECR_I29_SHIFT (0x0000001Du)
#define EDMA3CC_IECR_I28 (0x10000000u)
#define EDMA3CC_IECR_I28_SHIFT (0x0000001Cu)
#define EDMA3CC_IECR_I27 (0x08000000u)
#define EDMA3CC_IECR_I27_SHIFT (0x0000001Bu)
#define EDMA3CC_IECR_I26 (0x04000000u)
#define EDMA3CC_IECR_I26_SHIFT (0x0000001Au)
#define EDMA3CC_IECR_I25 (0x02000000u)
#define EDMA3CC_IECR_I25_SHIFT (0x00000019u)
#define EDMA3CC_IECR_I24 (0x01000000u)
#define EDMA3CC_IECR_I24_SHIFT (0x00000018u)
#define EDMA3CC_IECR_I23 (0x00800000u)
#define EDMA3CC_IECR_I23_SHIFT (0x00000017u)
#define EDMA3CC_IECR_I22 (0x00400000u)
#define EDMA3CC_IECR_I22_SHIFT (0x00000016u)
#define EDMA3CC_IECR_I21 (0x00200000u)
#define EDMA3CC_IECR_I21_SHIFT (0x00000015u)
#define EDMA3CC_IECR_I20 (0x00100000u)
#define EDMA3CC_IECR_I20_SHIFT (0x00000014u)
#define EDMA3CC_IECR_I19 (0x00080000u)
#define EDMA3CC_IECR_I19_SHIFT (0x00000013u)
#define EDMA3CC_IECR_I18 (0x00040000u)
#define EDMA3CC_IECR_I18_SHIFT (0x00000012u)
#define EDMA3CC_IECR_I17 (0x00020000u)
#define EDMA3CC_IECR_I17_SHIFT (0x00000011u)
#define EDMA3CC_IECR_I16 (0x00010000u)
#define EDMA3CC_IECR_I16_SHIFT (0x00000010u)
#define EDMA3CC_IECR_I15 (0x00008000u)
#define EDMA3CC_IECR_I15_SHIFT (0x0000000Fu)
#define EDMA3CC_IECR_I14 (0x00004000u)
#define EDMA3CC_IECR_I14_SHIFT (0x0000000Eu)
#define EDMA3CC_IECR_I13 (0x00002000u)
#define EDMA3CC_IECR_I13_SHIFT (0x0000000Du)
#define EDMA3CC_IECR_I12 (0x00001000u)
#define EDMA3CC_IECR_I12_SHIFT (0x0000000Cu)
#define EDMA3CC_IECR_I11 (0x00000800u)
#define EDMA3CC_IECR_I11_SHIFT (0x0000000Bu)
#define EDMA3CC_IECR_I10 (0x00000400u)
#define EDMA3CC_IECR_I10_SHIFT (0x0000000Au)
#define EDMA3CC_IECR_I9 (0x00000200u)
#define EDMA3CC_IECR_I9_SHIFT (0x00000009u)
#define EDMA3CC_IECR_I8 (0x00000100u)
#define EDMA3CC_IECR_I8_SHIFT (0x00000008u)
#define EDMA3CC_IECR_I7 (0x00000080u)
#define EDMA3CC_IECR_I7_SHIFT (0x00000007u)
#define EDMA3CC_IECR_I6 (0x00000040u)
#define EDMA3CC_IECR_I6_SHIFT (0x00000006u)
#define EDMA3CC_IECR_I5 (0x00000020u)
#define EDMA3CC_IECR_I5_SHIFT (0x00000005u)
#define EDMA3CC_IECR_I4 (0x00000010u)
#define EDMA3CC_IECR_I4_SHIFT (0x00000004u)
#define EDMA3CC_IECR_I3 (0x00000008u)
#define EDMA3CC_IECR_I3_SHIFT (0x00000003u)
#define EDMA3CC_IECR_I2 (0x00000004u)
#define EDMA3CC_IECR_I2_SHIFT (0x00000002u)
#define EDMA3CC_IECR_I1 (0x00000002u)
#define EDMA3CC_IECR_I1_SHIFT (0x00000001u)
#define EDMA3CC_IECR_I0 (0x00000001u)
#define EDMA3CC_IECR_I0_SHIFT (0x00000000u)


/* IESR */

#define EDMA3CC_IESR_I31 (0x80000000u)
#define EDMA3CC_IESR_I31_SHIFT (0x0000001Fu)
#define EDMA3CC_IESR_I30 (0x40000000u)
#define EDMA3CC_IESR_I30_SHIFT (0x0000001Eu)
#define EDMA3CC_IESR_I29 (0x20000000u)
#define EDMA3CC_IESR_I29_SHIFT (0x0000001Du)
#define EDMA3CC_IESR_I28 (0x10000000u)
#define EDMA3CC_IESR_I28_SHIFT (0x0000001Cu)
#define EDMA3CC_IESR_I27 (0x08000000u)
#define EDMA3CC_IESR_I27_SHIFT (0x0000001Bu)
#define EDMA3CC_IESR_I26 (0x04000000u)
#define EDMA3CC_IESR_I26_SHIFT (0x0000001Au)
#define EDMA3CC_IESR_I25 (0x02000000u)
#define EDMA3CC_IESR_I25_SHIFT (0x00000019u)
#define EDMA3CC_IESR_I24 (0x01000000u)
#define EDMA3CC_IESR_I24_SHIFT (0x00000018u)
#define EDMA3CC_IESR_I23 (0x00800000u)
#define EDMA3CC_IESR_I23_SHIFT (0x00000017u)
#define EDMA3CC_IESR_I22 (0x00400000u)
#define EDMA3CC_IESR_I22_SHIFT (0x00000016u)
#define EDMA3CC_IESR_I21 (0x00200000u)
#define EDMA3CC_IESR_I21_SHIFT (0x00000015u)
#define EDMA3CC_IESR_I20 (0x00100000u)
#define EDMA3CC_IESR_I20_SHIFT (0x00000014u)
#define EDMA3CC_IESR_I19 (0x00080000u)
#define EDMA3CC_IESR_I19_SHIFT (0x00000013u)
#define EDMA3CC_IESR_I18 (0x00040000u)
#define EDMA3CC_IESR_I18_SHIFT (0x00000012u)
#define EDMA3CC_IESR_I17 (0x00020000u)
#define EDMA3CC_IESR_I17_SHIFT (0x00000011u)
#define EDMA3CC_IESR_I16 (0x00010000u)
#define EDMA3CC_IESR_I16_SHIFT (0x00000010u)
#define EDMA3CC_IESR_I15 (0x00008000u)
#define EDMA3CC_IESR_I15_SHIFT (0x0000000Fu)
#define EDMA3CC_IESR_I14 (0x00004000u)
#define EDMA3CC_IESR_I14_SHIFT (0x0000000Eu)
#define EDMA3CC_IESR_I13 (0x00002000u)
#define EDMA3CC_IESR_I13_SHIFT (0x0000000Du)
#define EDMA3CC_IESR_I12 (0x00001000u)
#define EDMA3CC_IESR_I12_SHIFT (0x0000000Cu)
#define EDMA3CC_IESR_I11 (0x00000800u)
#define EDMA3CC_IESR_I11_SHIFT (0x0000000Bu)
#define EDMA3CC_IESR_I10 (0x00000400u)
#define EDMA3CC_IESR_I10_SHIFT (0x0000000Au)
#define EDMA3CC_IESR_I9 (0x00000200u)
#define EDMA3CC_IESR_I9_SHIFT (0x00000009u)
#define EDMA3CC_IESR_I8 (0x00000100u)
#define EDMA3CC_IESR_I8_SHIFT (0x00000008u)
#define EDMA3CC_IESR_I7 (0x00000080u)
#define EDMA3CC_IESR_I7_SHIFT (0x00000007u)
#define EDMA3CC_IESR_I6 (0x00000040u)
#define EDMA3CC_IESR_I6_SHIFT (0x00000006u)
#define EDMA3CC_IESR_I5 (0x00000020u)
#define EDMA3CC_IESR_I5_SHIFT (0x00000005u)
#define EDMA3CC_IESR_I4 (0x00000010u)
#define EDMA3CC_IESR_I4_SHIFT (0x00000004u)
#define EDMA3CC_IESR_I3 (0x00000008u)
#define EDMA3CC_IESR_I3_SHIFT (0x00000003u)
#define EDMA3CC_IESR_I2 (0x00000004u)
#define EDMA3CC_IESR_I2_SHIFT (0x00000002u)
#define EDMA3CC_IESR_I1 (0x00000002u)
#define EDMA3CC_IESR_I1_SHIFT (0x00000001u)
#define EDMA3CC_IESR_I0 (0x00000001u)
#define EDMA3CC_IESR_I0_SHIFT (0x00000000u)

/* IPR */

#define EDMA3CC_IPR_I31 (0x80000000u)
#define EDMA3CC_IPR_I31_SHIFT (0x0000001Fu)
#define EDMA3CC_IPR_I30 (0x40000000u)
#define EDMA3CC_IPR_I30_SHIFT (0x0000001Eu)
#define EDMA3CC_IPR_I29 (0x20000000u)
#define EDMA3CC_IPR_I29_SHIFT (0x0000001Du)
#define EDMA3CC_IPR_I28 (0x10000000u)
#define EDMA3CC_IPR_I28_SHIFT (0x0000001Cu)
#define EDMA3CC_IPR_I27 (0x08000000u)
#define EDMA3CC_IPR_I27_SHIFT (0x0000001Bu)
#define EDMA3CC_IPR_I26 (0x04000000u)
#define EDMA3CC_IPR_I26_SHIFT (0x0000001Au)
#define EDMA3CC_IPR_I25 (0x02000000u)
#define EDMA3CC_IPR_I25_SHIFT (0x00000019u)
#define EDMA3CC_IPR_I24 (0x01000000u)
#define EDMA3CC_IPR_I24_SHIFT (0x00000018u)
#define EDMA3CC_IPR_I23 (0x00800000u)
#define EDMA3CC_IPR_I23_SHIFT (0x00000017u)
#define EDMA3CC_IPR_I22 (0x00400000u)
#define EDMA3CC_IPR_I22_SHIFT (0x00000016u)
#define EDMA3CC_IPR_I21 (0x00200000u)
#define EDMA3CC_IPR_I21_SHIFT (0x00000015u)
#define EDMA3CC_IPR_I20 (0x00100000u)
#define EDMA3CC_IPR_I20_SHIFT (0x00000014u)
#define EDMA3CC_IPR_I19 (0x00080000u)
#define EDMA3CC_IPR_I19_SHIFT (0x00000013u)
#define EDMA3CC_IPR_I18 (0x00040000u)
#define EDMA3CC_IPR_I18_SHIFT (0x00000012u)
#define EDMA3CC_IPR_I17 (0x00020000u)
#define EDMA3CC_IPR_I17_SHIFT (0x00000011u)
#define EDMA3CC_IPR_I16 (0x00010000u)
#define EDMA3CC_IPR_I16_SHIFT (0x00000010u)
#define EDMA3CC_IPR_I15 (0x00008000u)
#define EDMA3CC_IPR_I15_SHIFT (0x0000000Fu)
#define EDMA3CC_IPR_I14 (0x00004000u)
#define EDMA3CC_IPR_I14_SHIFT (0x0000000Eu)
#define EDMA3CC_IPR_I13 (0x00002000u)
#define EDMA3CC_IPR_I13_SHIFT (0x0000000Du)
#define EDMA3CC_IPR_I12 (0x00001000u)
#define EDMA3CC_IPR_I12_SHIFT (0x0000000Cu)
#define EDMA3CC_IPR_I11 (0x00000800u)
#define EDMA3CC_IPR_I11_SHIFT (0x0000000Bu)
#define EDMA3CC_IPR_I10 (0x00000400u)
#define EDMA3CC_IPR_I10_SHIFT (0x0000000Au)
#define EDMA3CC_IPR_I9 (0x00000200u)
#define EDMA3CC_IPR_I9_SHIFT (0x00000009u)
#define EDMA3CC_IPR_I8 (0x00000100u)
#define EDMA3CC_IPR_I8_SHIFT (0x00000008u)
#define EDMA3CC_IPR_I7 (0x00000080u)
#define EDMA3CC_IPR_I7_SHIFT (0x00000007u)
#define EDMA3CC_IPR_I6 (0x00000040u)
#define EDMA3CC_IPR_I6_SHIFT (0x00000006u)
#define EDMA3CC_IPR_I5 (0x00000020u)
#define EDMA3CC_IPR_I5_SHIFT (0x00000005u)
#define EDMA3CC_IPR_I4 (0x00000010u)
#define EDMA3CC_IPR_I4_SHIFT (0x00000004u)
#define EDMA3CC_IPR_I3 (0x00000008u)
#define EDMA3CC_IPR_I3_SHIFT (0x00000003u)
#define EDMA3CC_IPR_I2 (0x00000004u)
#define EDMA3CC_IPR_I2_SHIFT (0x00000002u)
#define EDMA3CC_IPR_I1 (0x00000002u)
#define EDMA3CC_IPR_I1_SHIFT (0x00000001u)
#define EDMA3CC_IPR_I0 (0x00000001u)
#define EDMA3CC_IPR_I0_SHIFT (0x00000000u)

/* ICR */

#define EDMA3CC_ICR_I31 (0x80000000u)
#define EDMA3CC_ICR_I31_SHIFT (0x0000001Fu)
#define EDMA3CC_ICR_I30 (0x40000000u)
#define EDMA3CC_ICR_I30_SHIFT (0x0000001Eu)
#define EDMA3CC_ICR_I29 (0x20000000u)
#define EDMA3CC_ICR_I29_SHIFT (0x0000001Du)
#define EDMA3CC_ICR_I28 (0x10000000u)
#define EDMA3CC_ICR_I28_SHIFT (0x0000001Cu)
#define EDMA3CC_ICR_I27 (0x08000000u)
#define EDMA3CC_ICR_I27_SHIFT (0x0000001Bu)
#define EDMA3CC_ICR_I26 (0x04000000u)
#define EDMA3CC_ICR_I26_SHIFT (0x0000001Au)
#define EDMA3CC_ICR_I25 (0x02000000u)
#define EDMA3CC_ICR_I25_SHIFT (0x00000019u)
#define EDMA3CC_ICR_I24 (0x01000000u)
#define EDMA3CC_ICR_I24_SHIFT (0x00000018u)
#define EDMA3CC_ICR_I23 (0x00800000u)
#define EDMA3CC_ICR_I23_SHIFT (0x00000017u)
#define EDMA3CC_ICR_I22 (0x00400000u)
#define EDMA3CC_ICR_I22_SHIFT (0x00000016u)
#define EDMA3CC_ICR_I21 (0x00200000u)
#define EDMA3CC_ICR_I21_SHIFT (0x00000015u)
#define EDMA3CC_ICR_I20 (0x00100000u)
#define EDMA3CC_ICR_I20_SHIFT (0x00000014u)
#define EDMA3CC_ICR_I19 (0x00080000u)
#define EDMA3CC_ICR_I19_SHIFT (0x00000013u)
#define EDMA3CC_ICR_I18 (0x00040000u)
#define EDMA3CC_ICR_I18_SHIFT (0x00000012u)
#define EDMA3CC_ICR_I17 (0x00020000u)
#define EDMA3CC_ICR_I17_SHIFT (0x00000011u)
#define EDMA3CC_ICR_I16 (0x00010000u)
#define EDMA3CC_ICR_I16_SHIFT (0x00000010u)
#define EDMA3CC_ICR_I15 (0x00008000u)
#define EDMA3CC_ICR_I15_SHIFT (0x0000000Fu)
#define EDMA3CC_ICR_I14 (0x00004000u)
#define EDMA3CC_ICR_I14_SHIFT (0x0000000Eu)
#define EDMA3CC_ICR_I13 (0x00002000u)
#define EDMA3CC_ICR_I13_SHIFT (0x0000000Du)
#define EDMA3CC_ICR_I12 (0x00001000u)
#define EDMA3CC_ICR_I12_SHIFT (0x0000000Cu)
#define EDMA3CC_ICR_I11 (0x00000800u)
#define EDMA3CC_ICR_I11_SHIFT (0x0000000Bu)
#define EDMA3CC_ICR_I10 (0x00000400u)
#define EDMA3CC_ICR_I10_SHIFT (0x0000000Au)
#define EDMA3CC_ICR_I9 (0x00000200u)
#define EDMA3CC_ICR_I9_SHIFT (0x00000009u)
#define EDMA3CC_ICR_I8 (0x00000100u)
#define EDMA3CC_ICR_I8_SHIFT (0x00000008u)
#define EDMA3CC_ICR_I7 (0x00000080u)
#define EDMA3CC_ICR_I7_SHIFT (0x00000007u)
#define EDMA3CC_ICR_I6 (0x00000040u)
#define EDMA3CC_ICR_I6_SHIFT (0x00000006u)
#define EDMA3CC_ICR_I5 (0x00000020u)
#define EDMA3CC_ICR_I5_SHIFT (0x00000005u)
#define EDMA3CC_ICR_I4 (0x00000010u)
#define EDMA3CC_ICR_I4_SHIFT (0x00000004u)
#define EDMA3CC_ICR_I3 (0x00000008u)
#define EDMA3CC_ICR_I3_SHIFT (0x00000003u)
#define EDMA3CC_ICR_I2 (0x00000004u)
#define EDMA3CC_ICR_I2_SHIFT (0x00000002u)
#define EDMA3CC_ICR_I1 (0x00000002u)
#define EDMA3CC_ICR_I1_SHIFT (0x00000001u)
#define EDMA3CC_ICR_I0 (0x00000001u)
#define EDMA3CC_ICR_I0_SHIFT (0x00000000u)

/* IEVAL */



#define EDMA3CC_IEVAL_EVAL (0x00000001u)
#define EDMA3CC_IEVAL_EVAL_SHIFT (0x00000000u)

/* QER */


#define EDMA3CC_QER_E7 (0x00000080u)
#define EDMA3CC_QER_E7_SHIFT (0x00000007u)
#define EDMA3CC_QER_E6 (0x00000040u)
#define EDMA3CC_QER_E6_SHIFT (0x00000006u)
#define EDMA3CC_QER_E5 (0x00000020u)
#define EDMA3CC_QER_E5_SHIFT (0x00000005u)
#define EDMA3CC_QER_E4 (0x00000010u)
#define EDMA3CC_QER_E4_SHIFT (0x00000004u)
#define EDMA3CC_QER_E3 (0x00000008u)
#define EDMA3CC_QER_E3_SHIFT (0x00000003u)
#define EDMA3CC_QER_E2 (0x00000004u)
#define EDMA3CC_QER_E2_SHIFT (0x00000002u)
#define EDMA3CC_QER_E1 (0x00000002u)
#define EDMA3CC_QER_E1_SHIFT (0x00000001u)
#define EDMA3CC_QER_E0 (0x00000001u)
#define EDMA3CC_QER_E0_SHIFT (0x00000000u)

/* QEER */


#define EDMA3CC_QEER_E7 (0x00000080u)
#define EDMA3CC_QEER_E7_SHIFT (0x00000007u)
#define EDMA3CC_QEER_E6 (0x00000040u)
#define EDMA3CC_QEER_E6_SHIFT (0x00000006u)
#define EDMA3CC_QEER_E5_SHIFT (0x00000005u)
#define EDMA3CC_QEER_E4_SHIFT (0x00000004u)
#define EDMA3CC_QEER_E3_SHIFT (0x00000003u)
#define EDMA3CC_QEER_E2_SHIFT (0x00000002u)
#define EDMA3CC_QEER_E1_SHIFT (0x00000001u)
#define EDMA3CC_QEER_E0_SHIFT (0x00000000u)

/* QEECR */


#define EDMA3CC_QEECR_E7 (0x00000080u)
#define EDMA3CC_QEECR_E7_SHIFT (0x00000007u)
#define EDMA3CC_QEECR_E6 (0x00000040u)
#define EDMA3CC_QEECR_E6_SHIFT (0x00000006u)
#define EDMA3CC_QEECR_E5 (0x00000020u)
#define EDMA3CC_QEECR_E5_SHIFT (0x00000005u)
#define EDMA3CC_QEECR_E4 (0x00000010u)
#define EDMA3CC_QEECR_E4_SHIFT (0x00000004u)
#define EDMA3CC_QEECR_E3 (0x00000008u)
#define EDMA3CC_QEECR_E3_SHIFT (0x00000003u)
#define EDMA3CC_QEECR_E2 (0x00000004u)
#define EDMA3CC_QEECR_E2_SHIFT (0x00000002u)
#define EDMA3CC_QEECR_E1 (0x00000002u)
#define EDMA3CC_QEECR_E1_SHIFT (0x00000001u)
#define EDMA3CC_QEECR_E0 (0x00000001u)
#define EDMA3CC_QEECR_E0_SHIFT (0x00000000u)

/* QEESR */


#define EDMA3CC_QEESR_E7 (0x00000080u)
#define EDMA3CC_QEESR_E7_SHIFT (0x00000007u)
#define EDMA3CC_QEESR_E6 (0x00000040u)
#define EDMA3CC_QEESR_E6_SHIFT (0x00000006u)
#define EDMA3CC_QEESR_E5 (0x00000020u)
#define EDMA3CC_QEESR_E5_SHIFT (0x00000005u)
#define EDMA3CC_QEESR_E4 (0x00000010u)
#define EDMA3CC_QEESR_E4_SHIFT (0x00000004u)
#define EDMA3CC_QEESR_E3 (0x00000008u)
#define EDMA3CC_QEESR_E3_SHIFT (0x00000003u)
#define EDMA3CC_QEESR_E2 (0x00000004u)
#define EDMA3CC_QEESR_E2_SHIFT (0x00000002u)
#define EDMA3CC_QEESR_E1 (0x00000002u)
#define EDMA3CC_QEESR_E1_SHIFT (0x00000001u)
#define EDMA3CC_QEESR_E0 (0x00000001u)
#define EDMA3CC_QEESR_E0_SHIFT (0x00000000u)

/* QSER */


#define EDMA3CC_QSER_E7 (0x00000080u)
#define EDMA3CC_QSER_E7_SHIFT (0x00000007u)
#define EDMA3CC_QSER_E6 (0x00000040u)
#define EDMA3CC_QSER_E6_SHIFT (0x00000006u)
#define EDMA3CC_QSER_E5 (0x00000020u)
#define EDMA3CC_QSER_E5_SHIFT (0x00000005u)
#define EDMA3CC_QSER_E4 (0x00000010u)
#define EDMA3CC_QSER_E4_SHIFT (0x00000004u)
#define EDMA3CC_QSER_E3 (0x00000008u)
#define EDMA3CC_QSER_E3_SHIFT (0x00000003u)
#define EDMA3CC_QSER_E2 (0x00000004u)
#define EDMA3CC_QSER_E2_SHIFT (0x00000002u)
#define EDMA3CC_QSER_E1 (0x00000002u)
#define EDMA3CC_QSER_E1_SHIFT (0x00000001u)
#define EDMA3CC_QSER_E0 (0x00000001u)
#define EDMA3CC_QSER_E0_SHIFT (0x00000000u)

/* QSECR */


#define EDMA3CC_QSECR_E7 (0x00000080u)
#define EDMA3CC_QSECR_E7_SHIFT (0x00000007u)
#define EDMA3CC_QSECR_E6 (0x00000040u)
#define EDMA3CC_QSECR_E6_SHIFT (0x00000006u)
#define EDMA3CC_QSECR_E5 (0x00000020u)
#define EDMA3CC_QSECR_E5_SHIFT (0x00000005u)
#define EDMA3CC_QSECR_E4 (0x00000010u)
#define EDMA3CC_QSECR_E4_SHIFT (0x00000004u)
#define EDMA3CC_QSECR_E3 (0x00000008u)
#define EDMA3CC_QSECR_E3_SHIFT (0x00000003u)
#define EDMA3CC_QSECR_E2 (0x00000004u)
#define EDMA3CC_QSECR_E2_SHIFT (0x00000002u)
#define EDMA3CC_QSECR_E1 (0x00000002u)
#define EDMA3CC_QSECR_E1_SHIFT (0x00000001u)
#define EDMA3CC_QSECR_E0 (0x00000001u)
#define EDMA3CC_QSECR_E0_SHIFT (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif

