

/**
 *  @Component:   GPMC
 *
 *  @Filename:    ../../CredDataBase/gpmc_cred.h
 *
 ============================================================================ */
/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_GPMC_H_
#define _HW_GPMC_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/

#define GPMC_BCH_RESULT (0x240u)
#define GPMC_BCH_RESULT_ELSIZE (0x10u)
#define GPMC_BCH_RESULT_NELEMS  8
#define GPMC_BCH_RESULT_EXTENSION (0x300u)
#define GPMC_BCH_RESULT_EXTENSION_ELSIZE (0x10u)
#define GPMC_BCH_RESULT_EXTENSION_NELEMS  8

/***********************************************************************\
 * Bundles Definition
\***********************************************************************/

#define GPMC_BCH_RESULT_0_OFFSET (0x0u)
#define GPMC_BCH_RESULT_1_OFFSET (0x4u)
#define GPMC_BCH_RESULT_2_OFFSET (0x8u)
#define GPMC_BCH_RESULT_3_OFFSET (0xCu)
#define GPMC_BCH_RESULT_4_OFFSET (0x0u)
#define GPMC_BCH_RESULT_5_OFFSET (0x4u)
#define GPMC_BCH_RESULT_6_OFFSET (0x8u)


/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define GPMC_REVISION   (0x0)
#define GPMC_SYSCONFIG   (0x10)
#define GPMC_SYSSTATUS   (0x14)
#define GPMC_IRQSTATUS   (0x18)
#define GPMC_IRQENABLE   (0x1C)
#define GPMC_TIMEOUT_CONTROL   (0x40)
#define GPMC_ERR_ADDRESS   (0x44)
#define GPMC_ERR_TYPE   (0x48)
#define GPMC_CONFIG   (0x50)
#define GPMC_STATUS   (0x54)
#define GPMC_CONFIG1(n)   (0x60 + (n * (0x30)))
#define GPMC_CONFIG2(n)   (0x64 + (n * (0x30)))
#define GPMC_CONFIG3(n)   (0x68 + (n * (0x30)))
#define GPMC_CONFIG4(n)   (0x6C + (n * (0x30)))
#define GPMC_CONFIG5(n)   (0x70 + (n * (0x30)))
#define GPMC_CONFIG6(n)   (0x74 + (n * (0x30)))
#define GPMC_CONFIG7(n)   (0x78 + (n * (0x30)))
#define GPMC_NAND_COMMAND(n)   (0x7C + (n * (0x30)))
#define GPMC_NAND_ADDRESS(n)   (0x80 + (n * (0x30)))
#define GPMC_NAND_DATA(n)   (0x84 + (n * (0x30)))
#define GPMC_PREFETCH_CONFIG(n)   (0x1E0 + ((n-1) * (0x4)))
#define GPMC_PREFETCH_CONTROL   (0x1EC)
#define GPMC_PREFETCH_STATUS   (0x1F0)
#define GPMC_ECC_CONFIG   (0x1F4)
#define GPMC_ECC_CONTROL   (0x1F8)
#define GPMC_ECC_SIZE_CONFIG   (0x1FC)
#define GPMC_ECC_RESULT(j)    (0x200 + ((j-1) * (0x4)))
#define GPMC_BCH_RESULT0(n)   (0x240 + (n * (0x10)))
#define GPMC_BCH_RESULT1(n)   (0x244 + (n * (0x10)))
#define GPMC_BCH_RESULT2(n)   (0x248 + (n * (0x10)))
#define GPMC_BCH_RESULT3(n)   (0x24C + (n * (0x10)))
#define GPMC_BCH_SWDATA   (0x2D0)
#define GPMC_BCH_RESULT4(n)   (0x300 + (n * (0x10)))
#define GPMC_BCH_RESULT5(n)   (0x304 + (n * (0x10)))
#define GPMC_BCH_RESULT6(n)   (0x308 + (n * (0x10)))

/**************************************************************************\ 
 * Field Definition Macros
\**************************************************************************/

/* REVISION */
#define GPMC_REVISION_REVISION   (0x000000FFu)
#define GPMC_REVISION_REVISION_SHIFT   (0x00000000u)


/* SYSCONFIG */
#define GPMC_SYSCONFIG_AUTOIDLE   (0x00000001u)
#define GPMC_SYSCONFIG_AUTOIDLE_SHIFT   (0x00000000u)
#define GPMC_SYSCONFIG_AUTOIDLE_AUTORUN   (0x1u)
#define GPMC_SYSCONFIG_AUTOIDLE_FREERUN   (0x0u)

#define GPMC_SYSCONFIG_IDLEMODE   (0x00000018u)
#define GPMC_SYSCONFIG_IDLEMODE_SHIFT   (0x00000003u)
#define GPMC_SYSCONFIG_IDLEMODE_FORCEIDLE   (0x0u)
#define GPMC_SYSCONFIG_IDLEMODE_NOIDLE   (0x1u)
#define GPMC_SYSCONFIG_IDLEMODE_RESERVED   (0x3u)
#define GPMC_SYSCONFIG_IDLEMODE_SMARTIDLE   (0x2u)

#define GPMC_SYSCONFIG_SOFTRESET   (0x00000002u)
#define GPMC_SYSCONFIG_SOFTRESET_SHIFT   (0x00000001u)
#define GPMC_SYSCONFIG_SOFTRESET_NORMAL   (0x0u)
#define GPMC_SYSCONFIG_SOFTRESET_RESET   (0x1u)


/* SYSSTATUS */
#define GPMC_SYSSTATUS_RESETDONE   (0x00000001u)
#define GPMC_SYSSTATUS_RESETDONE_SHIFT   (0x00000000u)
#define GPMC_SYSSTATUS_RESETDONE_RSTDONE   (0x1u)
#define GPMC_SYSSTATUS_RESETDONE_RSTONGOING   (0x0u)


/* IRQSTATUS */
#define GPMC_IRQSTATUS_FIFOEVENTSTATUS   (0x00000001u)
#define GPMC_IRQSTATUS_FIFOEVENTSTATUS_SHIFT   (0x00000000u)
#define GPMC_IRQSTATUS_FIFOEVENTSTATUS_ATLEAST   (0x1u)
#define GPMC_IRQSTATUS_FIFOEVENTSTATUS_FIFOSTAT0   (0x0u)
#define GPMC_IRQSTATUS_FIFOEVENTSTATUS_FIFOSTAT1   (0x1u)
#define GPMC_IRQSTATUS_FIFOEVENTSTATUS_LESS   (0x0u)
#define GPMC_IRQSTATUS_FIFOEVENTSTATUS_NO   (0x0u)
#define GPMC_IRQSTATUS_FIFOEVENTSTATUS_RESET   (0x1u)

#define GPMC_IRQSTATUS_TERMINALCOUNTSTATUS   (0x00000002u)
#define GPMC_IRQSTATUS_TERMINALCOUNTSTATUS_SHIFT   (0x00000001u)
#define GPMC_IRQSTATUS_TERMINALCOUNTSTATUS_GREATER_THAN_0   (0x0u)
#define GPMC_IRQSTATUS_TERMINALCOUNTSTATUS_NO   (0x0u)
#define GPMC_IRQSTATUS_TERMINALCOUNTSTATUS_RESET   (0x1u)
#define GPMC_IRQSTATUS_TERMINALCOUNTSTATUS_TCSTAT0   (0x0u)
#define GPMC_IRQSTATUS_TERMINALCOUNTSTATUS_TCSTAT1   (0x1u)
#define GPMC_IRQSTATUS_TERMINALCOUNTSTATUS_ZERO   (0x1u)

#define GPMC_IRQSTATUS_WAIT0EDGEDETECTIONSTATUS   (0x00000100u)
#define GPMC_IRQSTATUS_WAIT0EDGEDETECTIONSTATUS_SHIFT   (0x00000008u)
#define GPMC_IRQSTATUS_WAIT0EDGEDETECTIONSTATUS_DETECTED   (0x0u)
#define GPMC_IRQSTATUS_WAIT0EDGEDETECTIONSTATUS_NO   (0x1u)
#define GPMC_IRQSTATUS_WAIT0EDGEDETECTIONSTATUS_NOTDETECTED   (0x0u)
#define GPMC_IRQSTATUS_WAIT0EDGEDETECTIONSTATUS_RESET   (0x1u)
#define GPMC_IRQSTATUS_WAIT0EDGEDETECTIONSTATUS_W0DET0   (0x0u)
#define GPMC_IRQSTATUS_WAIT0EDGEDETECTIONSTATUS_W0DET1   (0x1u)

#define GPMC_IRQSTATUS_WAIT1EDGEDETECTIONSTATUS   (0x00000200u)
#define GPMC_IRQSTATUS_WAIT1EDGEDETECTIONSTATUS_SHIFT   (0x00000009u)
#define GPMC_IRQSTATUS_WAIT1EDGEDETECTIONSTATUS_DETECTED   (0x0u)
#define GPMC_IRQSTATUS_WAIT1EDGEDETECTIONSTATUS_NO   (0x1u)
#define GPMC_IRQSTATUS_WAIT1EDGEDETECTIONSTATUS_NOTDETECTED   (0x0u)
#define GPMC_IRQSTATUS_WAIT1EDGEDETECTIONSTATUS_RESET   (0x1u)
#define GPMC_IRQSTATUS_WAIT1EDGEDETECTIONSTATUS_W1DET0   (0x0u)
#define GPMC_IRQSTATUS_WAIT1EDGEDETECTIONSTATUS_W1DET1   (0x1u)

#define GPMC_IRQSTATUS_WAIT2EDGEDETECTIONSTATUS   (0x00000400u)
#define GPMC_IRQSTATUS_WAIT2EDGEDETECTIONSTATUS_SHIFT   (0x0000000Au)
#define GPMC_IRQSTATUS_WAIT2EDGEDETECTIONSTATUS_DETECTED   (0x0u)
#define GPMC_IRQSTATUS_WAIT2EDGEDETECTIONSTATUS_NO   (0x1u)
#define GPMC_IRQSTATUS_WAIT2EDGEDETECTIONSTATUS_NOTDETECTED   (0x0u)
#define GPMC_IRQSTATUS_WAIT2EDGEDETECTIONSTATUS_RESET   (0x1u)
#define GPMC_IRQSTATUS_WAIT2EDGEDETECTIONSTATUS_W2DET0   (0x0u)
#define GPMC_IRQSTATUS_WAIT2EDGEDETECTIONSTATUS_W2DET1   (0x1u)

#define GPMC_IRQSTATUS_WAIT3EDGEDETECTIONSTATUS   (0x00000800u)
#define GPMC_IRQSTATUS_WAIT3EDGEDETECTIONSTATUS_SHIFT   (0x0000000Bu)
#define GPMC_IRQSTATUS_WAIT3EDGEDETECTIONSTATUS_W3DET0   (0x0u)
#define GPMC_IRQSTATUS_WAIT3EDGEDETECTIONSTATUS_W3DET1   (0x1u)


/* IRQENABLE */
#define GPMC_IRQENABLE_FIFOEVENTENABLE   (0x00000001u)
#define GPMC_IRQENABLE_FIFOEVENTENABLE_SHIFT   (0x00000000u)
#define GPMC_IRQENABLE_FIFOEVENTENABLE_FIFOENABLED   (0x1u)
#define GPMC_IRQENABLE_FIFOEVENTENABLE_FIFOMASKED   (0x0u)

#define GPMC_IRQENABLE_TERMINALCOUNTEVENTENABLE   (0x00000002u)
#define GPMC_IRQENABLE_TERMINALCOUNTEVENTENABLE_SHIFT   (0x00000001u)
#define GPMC_IRQENABLE_TERMINALCOUNTEVENTENABLE_TCENABLED   (0x1u)
#define GPMC_IRQENABLE_TERMINALCOUNTEVENTENABLE_TCMASKED   (0x0u)

#define GPMC_IRQENABLE_WAIT0EDGEDETECTIONENABLE   (0x00000100u)
#define GPMC_IRQENABLE_WAIT0EDGEDETECTIONENABLE_SHIFT   (0x00000008u)
#define GPMC_IRQENABLE_WAIT0EDGEDETECTIONENABLE_W0ENABLED   (0x1u)
#define GPMC_IRQENABLE_WAIT0EDGEDETECTIONENABLE_W0MASKED   (0x0u)

#define GPMC_IRQENABLE_WAIT1EDGEDETECTIONENABLE   (0x00000200u)
#define GPMC_IRQENABLE_WAIT1EDGEDETECTIONENABLE_SHIFT   (0x00000009u)
#define GPMC_IRQENABLE_WAIT1EDGEDETECTIONENABLE_W1ENABLED   (0x1u)
#define GPMC_IRQENABLE_WAIT1EDGEDETECTIONENABLE_W1MASKED   (0x0u)

#define GPMC_IRQENABLE_WAIT2EDGEDETECTIONENABLE   (0x00000400u)
#define GPMC_IRQENABLE_WAIT2EDGEDETECTIONENABLE_SHIFT   (0x0000000Au)
#define GPMC_IRQENABLE_WAIT2EDGEDETECTIONENABLE_W2ENABLED   (0x1u)
#define GPMC_IRQENABLE_WAIT2EDGEDETECTIONENABLE_W2MASKED   (0x0u)

#define GPMC_IRQENABLE_WAIT3EDGEDETECTIONENABLE   (0x00000800u)
#define GPMC_IRQENABLE_WAIT3EDGEDETECTIONENABLE_SHIFT   (0x0000000Bu)


/* TIMEOUT_CONTROL */
#define GPMC_TIMEOUT_CONTROL_TIMEOUTENABLE   (0x00000001u)
#define GPMC_TIMEOUT_CONTROL_TIMEOUTENABLE_SHIFT   (0x00000000u)
#define GPMC_TIMEOUT_CONTROL_TIMEOUTENABLE_TODISABLED   (0x0u)
#define GPMC_TIMEOUT_CONTROL_TIMEOUTENABLE_TOENABLED   (0x1u)

#define GPMC_TIMEOUT_CONTROL_TIMEOUTSTARTVALUE   (0x00001FF0u)
#define GPMC_TIMEOUT_CONTROL_TIMEOUTSTARTVALUE_SHIFT   (0x00000004u)


/* ERR_ADDRESS */
#define GPMC_ERR_ADDRESS_ILLEGALADD   (0x7FFFFFFFu)
#define GPMC_ERR_ADDRESS_ILLEGALADD_SHIFT   (0x00000000u)


/* ERR_TYPE */
#define GPMC_ERR_TYPE_ERRORNOTSUPPADD   (0x00000010u)
#define GPMC_ERR_TYPE_ERRORNOTSUPPADD_SHIFT   (0x00000004u)
#define GPMC_ERR_TYPE_ERRORNOTSUPPADD_ERR   (0x1u)
#define GPMC_ERR_TYPE_ERRORNOTSUPPADD_NOERR   (0x0u)

#define GPMC_ERR_TYPE_ERRORNOTSUPPMCMD   (0x00000008u)
#define GPMC_ERR_TYPE_ERRORNOTSUPPMCMD_SHIFT   (0x00000003u)
#define GPMC_ERR_TYPE_ERRORNOTSUPPMCMD_ERR   (0x1u)
#define GPMC_ERR_TYPE_ERRORNOTSUPPMCMD_NOERR   (0x0u)

#define GPMC_ERR_TYPE_ERRORTIMEOUT   (0x00000004u)
#define GPMC_ERR_TYPE_ERRORTIMEOUT_SHIFT   (0x00000002u)
#define GPMC_ERR_TYPE_ERRORTIMEOUT_ERR   (0x1u)
#define GPMC_ERR_TYPE_ERRORTIMEOUT_NOERR   (0x0u)

#define GPMC_ERR_TYPE_ERRORVALID   (0x00000001u)
#define GPMC_ERR_TYPE_ERRORVALID_SHIFT   (0x00000000u)
#define GPMC_ERR_TYPE_ERRORVALID_ERRDETECT   (0x1u)
#define GPMC_ERR_TYPE_ERRORVALID_NOTVALID   (0x0u)

#define GPMC_ERR_TYPE_ILLEGALMCMD   (0x00000700u)
#define GPMC_ERR_TYPE_ILLEGALMCMD_SHIFT   (0x00000008u)


/* CONFIG */
#define GPMC_CONFIG_LIMITEDADDRESS   (0x00000002u)
#define GPMC_CONFIG_LIMITEDADDRESS_SHIFT   (0x00000001u)
#define GPMC_CONFIG_LIMITEDADDRESS_LIMITED   (0x1u)
#define GPMC_CONFIG_LIMITEDADDRESS_NOLIMITED   (0x0u)

#define GPMC_CONFIG_NANDFORCEPOSTEDWRITE   (0x00000001u)
#define GPMC_CONFIG_NANDFORCEPOSTEDWRITE_SHIFT   (0x00000000u)
#define GPMC_CONFIG_NANDFORCEPOSTEDWRITE_FORCEPWR   (0x1u)
#define GPMC_CONFIG_NANDFORCEPOSTEDWRITE_NOFORCEPWR   (0x0u)

#define GPMC_CONFIG_WAIT0PINPOLARITY   (0x00000100u)
#define GPMC_CONFIG_WAIT0PINPOLARITY_SHIFT   (0x00000008u)
#define GPMC_CONFIG_WAIT0PINPOLARITY_W0ACTIVEH   (0x1u)
#define GPMC_CONFIG_WAIT0PINPOLARITY_W0ACTIVEL   (0x0u)

#define GPMC_CONFIG_WAIT1PINPOLARITY   (0x00000200u)
#define GPMC_CONFIG_WAIT1PINPOLARITY_SHIFT   (0x00000009u)
#define GPMC_CONFIG_WAIT1PINPOLARITY_W1ACTIVEH   (0x1u)
#define GPMC_CONFIG_WAIT1PINPOLARITY_W1ACTIVEL   (0x0u)

#define GPMC_CONFIG_WAIT2PINPOLARITY   (0x00000400u)
#define GPMC_CONFIG_WAIT2PINPOLARITY_SHIFT   (0x0000000Au)
#define GPMC_CONFIG_WAIT2PINPOLARITY_W2ACTIVEH   (0x1u)
#define GPMC_CONFIG_WAIT2PINPOLARITY_W2ACTIVEL   (0x0u)

#define GPMC_CONFIG_WAIT3PINPOLARITY   (0x00000800u)
#define GPMC_CONFIG_WAIT3PINPOLARITY_SHIFT   (0x0000000Bu)

#define GPMC_CONFIG_WRITEPROTECT   (0x00000010u)
#define GPMC_CONFIG_WRITEPROTECT_SHIFT   (0x00000004u)
#define GPMC_CONFIG_WRITEPROTECT_WPHIGH   (0x1u)
#define GPMC_CONFIG_WRITEPROTECT_WPLOW   (0x0u)


/* STATUS */
#define GPMC_STATUS_EMPTYWRITEBUFFERSTATUS   (0x00000001u)
#define GPMC_STATUS_EMPTYWRITEBUFFERSTATUS_SHIFT   (0x00000000u)
#define GPMC_STATUS_EMPTYWRITEBUFFERSTATUS_EMPTY   (0x1u)
#define GPMC_STATUS_EMPTYWRITEBUFFERSTATUS_NOTEMPTY   (0x0u)

#define GPMC_STATUS_WAIT0STATUS   (0x00000100u)
#define GPMC_STATUS_WAIT0STATUS_SHIFT   (0x00000008u)
#define GPMC_STATUS_WAIT0STATUS_W0ACTIVEH   (0x1u)
#define GPMC_STATUS_WAIT0STATUS_W0ACTIVEL   (0x0u)

#define GPMC_STATUS_WAIT1STATUS   (0x00000200u)
#define GPMC_STATUS_WAIT1STATUS_SHIFT   (0x00000009u)
#define GPMC_STATUS_WAIT1STATUS_W1ACTIVEH   (0x1u)
#define GPMC_STATUS_WAIT1STATUS_W1ACTIVEL   (0x0u)

#define GPMC_STATUS_WAIT2STATUS   (0x00000400u)
#define GPMC_STATUS_WAIT2STATUS_SHIFT   (0x0000000Au)
#define GPMC_STATUS_WAIT2STATUS_W2ACTIVEH   (0x1u)
#define GPMC_STATUS_WAIT2STATUS_W2ACTIVEL   (0x0u)

#define GPMC_STATUS_WAIT3STATUS   (0x00000800u)
#define GPMC_STATUS_WAIT3STATUS_SHIFT   (0x0000000Bu)


/* CONFIG1_0 */
#define GPMC_CONFIG1_0_ATTACHEDDEVICEPAGELENGTH   (0x01800000u)
#define GPMC_CONFIG1_0_ATTACHEDDEVICEPAGELENGTH_SHIFT   (0x00000017u)
#define GPMC_CONFIG1_0_ATTACHEDDEVICEPAGELENGTH_EIGHT   (0x1u)
#define GPMC_CONFIG1_0_ATTACHEDDEVICEPAGELENGTH_FOUR   (0x0u)
#define GPMC_CONFIG1_0_ATTACHEDDEVICEPAGELENGTH_RESERVED   (0x3u)
#define GPMC_CONFIG1_0_ATTACHEDDEVICEPAGELENGTH_SIXTEEN   (0x2u)

#define GPMC_CONFIG1_0_CLKACTIVATIONTIME   (0x06000000u)
#define GPMC_CONFIG1_0_CLKACTIVATIONTIME_SHIFT   (0x00000019u)
#define GPMC_CONFIG1_0_CLKACTIVATIONTIME_ATSTART   (0x0u)
#define GPMC_CONFIG1_0_CLKACTIVATIONTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_0_CLKACTIVATIONTIME_ONECLKB4   (0x1u)
#define GPMC_CONFIG1_0_CLKACTIVATIONTIME_TWOCLKB4   (0x2u)

#define GPMC_CONFIG1_0_DEVICESIZE   (0x00003000u)
#define GPMC_CONFIG1_0_DEVICESIZE_SHIFT   (0x0000000Cu)
#define GPMC_CONFIG1_0_DEVICESIZE_EIGHTBITS   (0x0u)
#define GPMC_CONFIG1_0_DEVICESIZE_RES   (0x3u)
#define GPMC_CONFIG1_0_DEVICESIZE_RESERVED   (0x2u)
#define GPMC_CONFIG1_0_DEVICESIZE_SIXTEENBITS   (0x1u)

#define GPMC_CONFIG1_0_DEVICETYPE   (0x00000C00u)
#define GPMC_CONFIG1_0_DEVICETYPE_SHIFT   (0x0000000Au)
#define GPMC_CONFIG1_0_DEVICETYPE_NANDLIKE   (0x2u)
#define GPMC_CONFIG1_0_DEVICETYPE_NORLIKE   (0x0u)
#define GPMC_CONFIG1_0_DEVICETYPE_RES1   (0x1u)
#define GPMC_CONFIG1_0_DEVICETYPE_RES2   (0x3u)

#define GPMC_CONFIG1_0_GPMCFCLKDIVIDER   (0x00000003u)
#define GPMC_CONFIG1_0_GPMCFCLKDIVIDER_SHIFT   (0x00000000u)
#define GPMC_CONFIG1_0_GPMCFCLKDIVIDER_DIVBY1   (0x0u)
#define GPMC_CONFIG1_0_GPMCFCLKDIVIDER_DIVBY2   (0x1u)
#define GPMC_CONFIG1_0_GPMCFCLKDIVIDER_DIVBY3   (0x2u)
#define GPMC_CONFIG1_0_GPMCFCLKDIVIDER_DIVBY4   (0x3u)

#define GPMC_CONFIG1_0_MUXADDDATA   (0x00000300u)
#define GPMC_CONFIG1_0_MUXADDDATA_SHIFT   (0x00000008u)
#define GPMC_CONFIG1_0_MUXADDDATA_AADMUX   (0x1u)
#define GPMC_CONFIG1_0_MUXADDDATA_MUX   (0x2u)
#define GPMC_CONFIG1_0_MUXADDDATA_NONMUX   (0x0u)
#define GPMC_CONFIG1_0_MUXADDDATA_RESERVED   (0x3u)

#define GPMC_CONFIG1_0_READMULTIPLE   (0x40000000u)
#define GPMC_CONFIG1_0_READMULTIPLE_SHIFT   (0x0000001Eu)
#define GPMC_CONFIG1_0_READMULTIPLE_RDMULTIPLE   (0x1u)
#define GPMC_CONFIG1_0_READMULTIPLE_RDSINGLE   (0x0u)

#define GPMC_CONFIG1_0_READTYPE   (0x20000000u)
#define GPMC_CONFIG1_0_READTYPE_SHIFT   (0x0000001Du)
#define GPMC_CONFIG1_0_READTYPE_RDASYNC   (0x0u)
#define GPMC_CONFIG1_0_READTYPE_RDSYNC   (0x1u)

#define GPMC_CONFIG1_0_TIMEPARAGRANULARITY   (0x00000010u)
#define GPMC_CONFIG1_0_TIMEPARAGRANULARITY_SHIFT   (0x00000004u)
#define GPMC_CONFIG1_0_TIMEPARAGRANULARITY_X1   (0x0u)
#define GPMC_CONFIG1_0_TIMEPARAGRANULARITY_X2   (0x1u)

#define GPMC_CONFIG1_0_WAITMONITORINGTIME   (0x000C0000u)
#define GPMC_CONFIG1_0_WAITMONITORINGTIME_SHIFT   (0x00000012u)
#define GPMC_CONFIG1_0_WAITMONITORINGTIME_ATVALID   (0x0u)
#define GPMC_CONFIG1_0_WAITMONITORINGTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_0_WAITMONITORINGTIME_ONEDEVICEB4   (0x1u)
#define GPMC_CONFIG1_0_WAITMONITORINGTIME_TWODEVICEB4   (0x2u)

#define GPMC_CONFIG1_0_WAITPINSELECT   (0x00030000u)
#define GPMC_CONFIG1_0_WAITPINSELECT_SHIFT   (0x00000010u)
#define GPMC_CONFIG1_0_WAITPINSELECT_RESERVED   (0x3u)
#define GPMC_CONFIG1_0_WAITPINSELECT_W0   (0x0u)
#define GPMC_CONFIG1_0_WAITPINSELECT_W1   (0x1u)
#define GPMC_CONFIG1_0_WAITPINSELECT_W2   (0x2u)

#define GPMC_CONFIG1_0_WAITREADMONITORING   (0x00400000u)
#define GPMC_CONFIG1_0_WAITREADMONITORING_SHIFT   (0x00000016u)
#define GPMC_CONFIG1_0_WAITREADMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_0_WAITREADMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_0_WAITWRITEMONITORING   (0x00200000u)
#define GPMC_CONFIG1_0_WAITWRITEMONITORING_SHIFT   (0x00000015u)
#define GPMC_CONFIG1_0_WAITWRITEMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_0_WAITWRITEMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_0_WRAPBURST   (0x80000000u)
#define GPMC_CONFIG1_0_WRAPBURST_SHIFT   (0x0000001Fu)
#define GPMC_CONFIG1_0_WRAPBURST_WRAPNOTSUPP   (0x0u)
#define GPMC_CONFIG1_0_WRAPBURST_WRAPSUPP   (0x1u)

#define GPMC_CONFIG1_0_WRITEMULTIPLE   (0x10000000u)
#define GPMC_CONFIG1_0_WRITEMULTIPLE_SHIFT   (0x0000001Cu)
#define GPMC_CONFIG1_0_WRITEMULTIPLE_WRMULTIPLE   (0x1u)
#define GPMC_CONFIG1_0_WRITEMULTIPLE_WRSINGLE   (0x0u)

#define GPMC_CONFIG1_0_WRITETYPE   (0x08000000u)
#define GPMC_CONFIG1_0_WRITETYPE_SHIFT   (0x0000001Bu)
#define GPMC_CONFIG1_0_WRITETYPE_WRASYNC   (0x0u)
#define GPMC_CONFIG1_0_WRITETYPE_WRSYNC   (0x1u)


/* CONFIG2_0 */
#define GPMC_CONFIG2_0_CSEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG2_0_CSEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG2_0_CSEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG2_0_CSEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG2_0_CSONTIME   (0x0000000Fu)
#define GPMC_CONFIG2_0_CSONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG2_0_CSRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG2_0_CSRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG2_0_CSWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG2_0_CSWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG3_0 */
#define GPMC_CONFIG3_0_ADVAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG3_0_ADVAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG3_0_ADVAADMUXRDOFFTIME   (0x07000000u)
#define GPMC_CONFIG3_0_ADVAADMUXRDOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG3_0_ADVAADMUXWROFFTIME   (0x70000000u)
#define GPMC_CONFIG3_0_ADVAADMUXWROFFTIME_SHIFT   (0x0000001Cu)

#define GPMC_CONFIG3_0_ADVEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG3_0_ADVEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG3_0_ADVEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG3_0_ADVEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG3_0_ADVONTIME   (0x0000000Fu)
#define GPMC_CONFIG3_0_ADVONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG3_0_ADVRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG3_0_ADVRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG3_0_ADVWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG3_0_ADVWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG4_0 */
#define GPMC_CONFIG4_0_OEAADMUXOFFTIME   (0x0000E000u)
#define GPMC_CONFIG4_0_OEAADMUXOFFTIME_SHIFT   (0x0000000Du)

#define GPMC_CONFIG4_0_OEAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG4_0_OEAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG4_0_OEEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG4_0_OEEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG4_0_OEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_0_OEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_0_OEOFFTIME   (0x00001F00u)
#define GPMC_CONFIG4_0_OEOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG4_0_OEONTIME   (0x0000000Fu)
#define GPMC_CONFIG4_0_OEONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG4_0_WEEXTRADELAY   (0x00800000u)
#define GPMC_CONFIG4_0_WEEXTRADELAY_SHIFT   (0x00000017u)
#define GPMC_CONFIG4_0_WEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_0_WEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_0_WEOFFTIME   (0x1F000000u)
#define GPMC_CONFIG4_0_WEOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG4_0_WEONTIME   (0x000F0000u)
#define GPMC_CONFIG4_0_WEONTIME_SHIFT   (0x00000010u)


/* CONFIG5_0 */
#define GPMC_CONFIG5_0_PAGEBURSTACCESSTIME   (0x0F000000u)
#define GPMC_CONFIG5_0_PAGEBURSTACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG5_0_RDACCESSTIME   (0x001F0000u)
#define GPMC_CONFIG5_0_RDACCESSTIME_SHIFT   (0x00000010u)

#define GPMC_CONFIG5_0_RDCYCLETIME   (0x0000001Fu)
#define GPMC_CONFIG5_0_RDCYCLETIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG5_0_WRCYCLETIME   (0x00001F00u)
#define GPMC_CONFIG5_0_WRCYCLETIME_SHIFT   (0x00000008u)


/* CONFIG6_0 */
#define GPMC_CONFIG6_0_BUSTURNAROUND   (0x0000000Fu)
#define GPMC_CONFIG6_0_BUSTURNAROUND_SHIFT   (0x00000000u)

#define GPMC_CONFIG6_0_CYCLE2CYCLEDELAY   (0x00000F00u)
#define GPMC_CONFIG6_0_CYCLE2CYCLEDELAY_SHIFT   (0x00000008u)

#define GPMC_CONFIG6_0_CYCLE2CYCLEDIFFCSEN   (0x00000040u)
#define GPMC_CONFIG6_0_CYCLE2CYCLEDIFFCSEN_SHIFT   (0x00000006u)
#define GPMC_CONFIG6_0_CYCLE2CYCLEDIFFCSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_0_CYCLE2CYCLEDIFFCSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_0_CYCLE2CYCLESAMECSEN   (0x00000080u)
#define GPMC_CONFIG6_0_CYCLE2CYCLESAMECSEN_SHIFT   (0x00000007u)
#define GPMC_CONFIG6_0_CYCLE2CYCLESAMECSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_0_CYCLE2CYCLESAMECSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_0_WRACCESSTIME   (0x1F000000u)
#define GPMC_CONFIG6_0_WRACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG6_0_WRDATAONADMUXBUS   (0x000F0000u)
#define GPMC_CONFIG6_0_WRDATAONADMUXBUS_SHIFT   (0x00000010u)


/* CONFIG7_0 */
#define GPMC_CONFIG7_0_BASEADDRESS   (0x0000003Fu)
#define GPMC_CONFIG7_0_BASEADDRESS_SHIFT   (0x00000000u)

#define GPMC_CONFIG7_0_CSVALID   (0x00000040u)
#define GPMC_CONFIG7_0_CSVALID_SHIFT   (0x00000006u)
#define GPMC_CONFIG7_0_CSVALID_CSDISABLED   (0x0u)
#define GPMC_CONFIG7_0_CSVALID_CSENABLED   (0x1u)

#define GPMC_CONFIG7_0_MASKADDRESS   (0x00000F00u)
#define GPMC_CONFIG7_0_MASKADDRESS_SHIFT   (0x00000008u)


/* NAND_COMMAND_0 */
#define GPMC_NAND_COMMAND_0_GPMC_NAND_COMMAND_0   (0xFFFFFFFFu)
#define GPMC_NAND_COMMAND_0_GPMC_NAND_COMMAND_0_SHIFT   (0x00000000u)


/* NAND_ADDRESS_0 */
#define GPMC_NAND_ADDRESS_0_GPMC_NAND_ADDRESS_0   (0xFFFFFFFFu)
#define GPMC_NAND_ADDRESS_0_GPMC_NAND_ADDRESS_0_SHIFT   (0x00000000u)


/* NAND_DATA_0 */
#define GPMC_NAND_DATA_0_GPMC_NAND_DATA_0   (0xFFFFFFFFu)
#define GPMC_NAND_DATA_0_GPMC_NAND_DATA_0_SHIFT   (0x00000000u)


/* CONFIG1_1 */
#define GPMC_CONFIG1_1_ATTACHEDDEVICEPAGELENGTH   (0x01800000u)
#define GPMC_CONFIG1_1_ATTACHEDDEVICEPAGELENGTH_SHIFT   (0x00000017u)
#define GPMC_CONFIG1_1_ATTACHEDDEVICEPAGELENGTH_EIGHT   (0x1u)
#define GPMC_CONFIG1_1_ATTACHEDDEVICEPAGELENGTH_FOUR   (0x0u)
#define GPMC_CONFIG1_1_ATTACHEDDEVICEPAGELENGTH_RESERVED   (0x3u)
#define GPMC_CONFIG1_1_ATTACHEDDEVICEPAGELENGTH_SIXTEEN   (0x2u)

#define GPMC_CONFIG1_1_CLKACTIVATIONTIME   (0x06000000u)
#define GPMC_CONFIG1_1_CLKACTIVATIONTIME_SHIFT   (0x00000019u)
#define GPMC_CONFIG1_1_CLKACTIVATIONTIME_ATSTART   (0x0u)
#define GPMC_CONFIG1_1_CLKACTIVATIONTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_1_CLKACTIVATIONTIME_ONECLKB4   (0x1u)
#define GPMC_CONFIG1_1_CLKACTIVATIONTIME_TWOCLKB4   (0x2u)

#define GPMC_CONFIG1_1_DEVICESIZE   (0x00003000u)
#define GPMC_CONFIG1_1_DEVICESIZE_SHIFT   (0x0000000Cu)
#define GPMC_CONFIG1_1_DEVICESIZE_EIGHTBITS   (0x0u)
#define GPMC_CONFIG1_1_DEVICESIZE_RES   (0x3u)
#define GPMC_CONFIG1_1_DEVICESIZE_RESERVED   (0x2u)
#define GPMC_CONFIG1_1_DEVICESIZE_SIXTEENBITS   (0x1u)

#define GPMC_CONFIG1_1_DEVICETYPE   (0x00000C00u)
#define GPMC_CONFIG1_1_DEVICETYPE_SHIFT   (0x0000000Au)
#define GPMC_CONFIG1_1_DEVICETYPE_NANDLIKE   (0x2u)
#define GPMC_CONFIG1_1_DEVICETYPE_NORLIKE   (0x0u)
#define GPMC_CONFIG1_1_DEVICETYPE_RES1   (0x1u)
#define GPMC_CONFIG1_1_DEVICETYPE_RES2   (0x3u)

#define GPMC_CONFIG1_1_GPMCFCLKDIVIDER   (0x00000003u)
#define GPMC_CONFIG1_1_GPMCFCLKDIVIDER_SHIFT   (0x00000000u)
#define GPMC_CONFIG1_1_GPMCFCLKDIVIDER_DIVBY1   (0x0u)
#define GPMC_CONFIG1_1_GPMCFCLKDIVIDER_DIVBY2   (0x1u)
#define GPMC_CONFIG1_1_GPMCFCLKDIVIDER_DIVBY3   (0x2u)
#define GPMC_CONFIG1_1_GPMCFCLKDIVIDER_DIVBY4   (0x3u)

#define GPMC_CONFIG1_1_MUXADDDATA   (0x00000300u)
#define GPMC_CONFIG1_1_MUXADDDATA_SHIFT   (0x00000008u)
#define GPMC_CONFIG1_1_MUXADDDATA_AADMUX   (0x1u)
#define GPMC_CONFIG1_1_MUXADDDATA_MUX   (0x2u)
#define GPMC_CONFIG1_1_MUXADDDATA_NONMUX   (0x0u)
#define GPMC_CONFIG1_1_MUXADDDATA_RESERVED   (0x3u)

#define GPMC_CONFIG1_1_READMULTIPLE   (0x40000000u)
#define GPMC_CONFIG1_1_READMULTIPLE_SHIFT   (0x0000001Eu)
#define GPMC_CONFIG1_1_READMULTIPLE_RDMULTIPLE   (0x1u)
#define GPMC_CONFIG1_1_READMULTIPLE_RDSINGLE   (0x0u)

#define GPMC_CONFIG1_1_READTYPE   (0x20000000u)
#define GPMC_CONFIG1_1_READTYPE_SHIFT   (0x0000001Du)
#define GPMC_CONFIG1_1_READTYPE_RDASYNC   (0x0u)
#define GPMC_CONFIG1_1_READTYPE_RDSYNC   (0x1u)

#define GPMC_CONFIG1_1_TIMEPARAGRANULARITY   (0x00000010u)
#define GPMC_CONFIG1_1_TIMEPARAGRANULARITY_SHIFT   (0x00000004u)
#define GPMC_CONFIG1_1_TIMEPARAGRANULARITY_X1   (0x0u)
#define GPMC_CONFIG1_1_TIMEPARAGRANULARITY_X2   (0x1u)

#define GPMC_CONFIG1_1_WAITMONITORINGTIME   (0x000C0000u)
#define GPMC_CONFIG1_1_WAITMONITORINGTIME_SHIFT   (0x00000012u)
#define GPMC_CONFIG1_1_WAITMONITORINGTIME_ATVALID   (0x0u)
#define GPMC_CONFIG1_1_WAITMONITORINGTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_1_WAITMONITORINGTIME_ONEDEVICEB4   (0x1u)
#define GPMC_CONFIG1_1_WAITMONITORINGTIME_TWODEVICEB4   (0x2u)

#define GPMC_CONFIG1_1_WAITPINSELECT   (0x00030000u)
#define GPMC_CONFIG1_1_WAITPINSELECT_SHIFT   (0x00000010u)
#define GPMC_CONFIG1_1_WAITPINSELECT_RESERVED   (0x3u)
#define GPMC_CONFIG1_1_WAITPINSELECT_W0   (0x0u)
#define GPMC_CONFIG1_1_WAITPINSELECT_W1   (0x1u)
#define GPMC_CONFIG1_1_WAITPINSELECT_W2   (0x2u)

#define GPMC_CONFIG1_1_WAITREADMONITORING   (0x00400000u)
#define GPMC_CONFIG1_1_WAITREADMONITORING_SHIFT   (0x00000016u)
#define GPMC_CONFIG1_1_WAITREADMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_1_WAITREADMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_1_WAITWRITEMONITORING   (0x00200000u)
#define GPMC_CONFIG1_1_WAITWRITEMONITORING_SHIFT   (0x00000015u)
#define GPMC_CONFIG1_1_WAITWRITEMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_1_WAITWRITEMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_1_WRAPBURST   (0x80000000u)
#define GPMC_CONFIG1_1_WRAPBURST_SHIFT   (0x0000001Fu)
#define GPMC_CONFIG1_1_WRAPBURST_WRAPNOTSUPP   (0x0u)
#define GPMC_CONFIG1_1_WRAPBURST_WRAPSUPP   (0x1u)

#define GPMC_CONFIG1_1_WRITEMULTIPLE   (0x10000000u)
#define GPMC_CONFIG1_1_WRITEMULTIPLE_SHIFT   (0x0000001Cu)
#define GPMC_CONFIG1_1_WRITEMULTIPLE_WRMULTIPLE   (0x1u)
#define GPMC_CONFIG1_1_WRITEMULTIPLE_WRSINGLE   (0x0u)

#define GPMC_CONFIG1_1_WRITETYPE   (0x08000000u)
#define GPMC_CONFIG1_1_WRITETYPE_SHIFT   (0x0000001Bu)
#define GPMC_CONFIG1_1_WRITETYPE_WRASYNC   (0x0u)
#define GPMC_CONFIG1_1_WRITETYPE_WRSYNC   (0x1u)


/* CONFIG2_1 */
#define GPMC_CONFIG2_1_CSEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG2_1_CSEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG2_1_CSEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG2_1_CSEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG2_1_CSONTIME   (0x0000000Fu)
#define GPMC_CONFIG2_1_CSONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG2_1_CSRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG2_1_CSRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG2_1_CSWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG2_1_CSWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG3_1 */
#define GPMC_CONFIG3_1_ADVAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG3_1_ADVAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG3_1_ADVAADMUXRDOFFTIME   (0x07000000u)
#define GPMC_CONFIG3_1_ADVAADMUXRDOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG3_1_ADVAADMUXWROFFTIME   (0x70000000u)
#define GPMC_CONFIG3_1_ADVAADMUXWROFFTIME_SHIFT   (0x0000001Cu)

#define GPMC_CONFIG3_1_ADVEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG3_1_ADVEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG3_1_ADVEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG3_1_ADVEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG3_1_ADVONTIME   (0x0000000Fu)
#define GPMC_CONFIG3_1_ADVONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG3_1_ADVRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG3_1_ADVRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG3_1_ADVWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG3_1_ADVWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG4_1 */
#define GPMC_CONFIG4_1_OEAADMUXOFFTIME   (0x0000E000u)
#define GPMC_CONFIG4_1_OEAADMUXOFFTIME_SHIFT   (0x0000000Du)

#define GPMC_CONFIG4_1_OEAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG4_1_OEAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG4_1_OEEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG4_1_OEEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG4_1_OEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_1_OEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_1_OEOFFTIME   (0x00001F00u)
#define GPMC_CONFIG4_1_OEOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG4_1_OEONTIME   (0x0000000Fu)
#define GPMC_CONFIG4_1_OEONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG4_1_WEEXTRADELAY   (0x00800000u)
#define GPMC_CONFIG4_1_WEEXTRADELAY_SHIFT   (0x00000017u)
#define GPMC_CONFIG4_1_WEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_1_WEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_1_WEOFFTIME   (0x1F000000u)
#define GPMC_CONFIG4_1_WEOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG4_1_WEONTIME   (0x000F0000u)
#define GPMC_CONFIG4_1_WEONTIME_SHIFT   (0x00000010u)


/* CONFIG5_1 */
#define GPMC_CONFIG5_1_PAGEBURSTACCESSTIME   (0x0F000000u)
#define GPMC_CONFIG5_1_PAGEBURSTACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG5_1_RDACCESSTIME   (0x001F0000u)
#define GPMC_CONFIG5_1_RDACCESSTIME_SHIFT   (0x00000010u)

#define GPMC_CONFIG5_1_RDCYCLETIME   (0x0000001Fu)
#define GPMC_CONFIG5_1_RDCYCLETIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG5_1_WRCYCLETIME   (0x00001F00u)
#define GPMC_CONFIG5_1_WRCYCLETIME_SHIFT   (0x00000008u)


/* CONFIG6_1 */
#define GPMC_CONFIG6_1_BUSTURNAROUND   (0x0000000Fu)
#define GPMC_CONFIG6_1_BUSTURNAROUND_SHIFT   (0x00000000u)

#define GPMC_CONFIG6_1_CYCLE2CYCLEDELAY   (0x00000F00u)
#define GPMC_CONFIG6_1_CYCLE2CYCLEDELAY_SHIFT   (0x00000008u)

#define GPMC_CONFIG6_1_CYCLE2CYCLEDIFFCSEN   (0x00000040u)
#define GPMC_CONFIG6_1_CYCLE2CYCLEDIFFCSEN_SHIFT   (0x00000006u)
#define GPMC_CONFIG6_1_CYCLE2CYCLEDIFFCSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_1_CYCLE2CYCLEDIFFCSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_1_CYCLE2CYCLESAMECSEN   (0x00000080u)
#define GPMC_CONFIG6_1_CYCLE2CYCLESAMECSEN_SHIFT   (0x00000007u)
#define GPMC_CONFIG6_1_CYCLE2CYCLESAMECSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_1_CYCLE2CYCLESAMECSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_1_WRACCESSTIME   (0x1F000000u)
#define GPMC_CONFIG6_1_WRACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG6_1_WRDATAONADMUXBUS   (0x000F0000u)
#define GPMC_CONFIG6_1_WRDATAONADMUXBUS_SHIFT   (0x00000010u)


/* CONFIG7_1 */
#define GPMC_CONFIG7_1_BASEADDRESS   (0x0000003Fu)
#define GPMC_CONFIG7_1_BASEADDRESS_SHIFT   (0x00000000u)

#define GPMC_CONFIG7_1_CSVALID   (0x00000040u)
#define GPMC_CONFIG7_1_CSVALID_SHIFT   (0x00000006u)
#define GPMC_CONFIG7_1_CSVALID_CSDISABLED   (0x0u)
#define GPMC_CONFIG7_1_CSVALID_CSENABLED   (0x1u)

#define GPMC_CONFIG7_1_MASKADDRESS   (0x00000F00u)
#define GPMC_CONFIG7_1_MASKADDRESS_SHIFT   (0x00000008u)


/* NAND_COMMAND_1 */
#define GPMC_NAND_COMMAND_1_GPMC_NAND_COMMAND_1   (0xFFFFFFFFu)
#define GPMC_NAND_COMMAND_1_GPMC_NAND_COMMAND_1_SHIFT   (0x00000000u)


/* NAND_ADDRESS_1 */
#define GPMC_NAND_ADDRESS_1_GPMC_NAND_ADDRESS_1   (0xFFFFFFFFu)
#define GPMC_NAND_ADDRESS_1_GPMC_NAND_ADDRESS_1_SHIFT   (0x00000000u)


/* NAND_DATA_1 */
#define GPMC_NAND_DATA_1_GPMC_NAND_DATA_1   (0xFFFFFFFFu)
#define GPMC_NAND_DATA_1_GPMC_NAND_DATA_1_SHIFT   (0x00000000u)


/* CONFIG1_2 */
#define GPMC_CONFIG1_2_ATTACHEDDEVICEPAGELENGTH   (0x01800000u)
#define GPMC_CONFIG1_2_ATTACHEDDEVICEPAGELENGTH_SHIFT   (0x00000017u)
#define GPMC_CONFIG1_2_ATTACHEDDEVICEPAGELENGTH_EIGHT   (0x1u)
#define GPMC_CONFIG1_2_ATTACHEDDEVICEPAGELENGTH_FOUR   (0x0u)
#define GPMC_CONFIG1_2_ATTACHEDDEVICEPAGELENGTH_RESERVED   (0x3u)
#define GPMC_CONFIG1_2_ATTACHEDDEVICEPAGELENGTH_SIXTEEN   (0x2u)

#define GPMC_CONFIG1_2_CLKACTIVATIONTIME   (0x06000000u)
#define GPMC_CONFIG1_2_CLKACTIVATIONTIME_SHIFT   (0x00000019u)
#define GPMC_CONFIG1_2_CLKACTIVATIONTIME_ATSTART   (0x0u)
#define GPMC_CONFIG1_2_CLKACTIVATIONTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_2_CLKACTIVATIONTIME_ONECLKB4   (0x1u)
#define GPMC_CONFIG1_2_CLKACTIVATIONTIME_TWOCLKB4   (0x2u)

#define GPMC_CONFIG1_2_DEVICESIZE   (0x00003000u)
#define GPMC_CONFIG1_2_DEVICESIZE_SHIFT   (0x0000000Cu)
#define GPMC_CONFIG1_2_DEVICESIZE_EIGHTBITS   (0x0u)
#define GPMC_CONFIG1_2_DEVICESIZE_RES   (0x3u)
#define GPMC_CONFIG1_2_DEVICESIZE_RESERVED   (0x2u)
#define GPMC_CONFIG1_2_DEVICESIZE_SIXTEENBITS   (0x1u)

#define GPMC_CONFIG1_2_DEVICETYPE   (0x00000C00u)
#define GPMC_CONFIG1_2_DEVICETYPE_SHIFT   (0x0000000Au)
#define GPMC_CONFIG1_2_DEVICETYPE_NANDLIKE   (0x2u)
#define GPMC_CONFIG1_2_DEVICETYPE_NORLIKE   (0x0u)
#define GPMC_CONFIG1_2_DEVICETYPE_RES1   (0x1u)
#define GPMC_CONFIG1_2_DEVICETYPE_RES2   (0x3u)

#define GPMC_CONFIG1_2_GPMCFCLKDIVIDER   (0x00000003u)
#define GPMC_CONFIG1_2_GPMCFCLKDIVIDER_SHIFT   (0x00000000u)
#define GPMC_CONFIG1_2_GPMCFCLKDIVIDER_DIVBY1   (0x0u)
#define GPMC_CONFIG1_2_GPMCFCLKDIVIDER_DIVBY2   (0x1u)
#define GPMC_CONFIG1_2_GPMCFCLKDIVIDER_DIVBY3   (0x2u)
#define GPMC_CONFIG1_2_GPMCFCLKDIVIDER_DIVBY4   (0x3u)

#define GPMC_CONFIG1_2_MUXADDDATA   (0x00000300u)
#define GPMC_CONFIG1_2_MUXADDDATA_SHIFT   (0x00000008u)
#define GPMC_CONFIG1_2_MUXADDDATA_AADMUX   (0x1u)
#define GPMC_CONFIG1_2_MUXADDDATA_MUX   (0x2u)
#define GPMC_CONFIG1_2_MUXADDDATA_NONMUX   (0x0u)
#define GPMC_CONFIG1_2_MUXADDDATA_RESERVED   (0x3u)

#define GPMC_CONFIG1_2_READMULTIPLE   (0x40000000u)
#define GPMC_CONFIG1_2_READMULTIPLE_SHIFT   (0x0000001Eu)
#define GPMC_CONFIG1_2_READMULTIPLE_RDMULTIPLE   (0x1u)
#define GPMC_CONFIG1_2_READMULTIPLE_RDSINGLE   (0x0u)

#define GPMC_CONFIG1_2_READTYPE   (0x20000000u)
#define GPMC_CONFIG1_2_READTYPE_SHIFT   (0x0000001Du)
#define GPMC_CONFIG1_2_READTYPE_RDASYNC   (0x0u)
#define GPMC_CONFIG1_2_READTYPE_RDSYNC   (0x1u)

#define GPMC_CONFIG1_2_TIMEPARAGRANULARITY   (0x00000010u)
#define GPMC_CONFIG1_2_TIMEPARAGRANULARITY_SHIFT   (0x00000004u)
#define GPMC_CONFIG1_2_TIMEPARAGRANULARITY_X1   (0x0u)
#define GPMC_CONFIG1_2_TIMEPARAGRANULARITY_X2   (0x1u)

#define GPMC_CONFIG1_2_WAITMONITORINGTIME   (0x000C0000u)
#define GPMC_CONFIG1_2_WAITMONITORINGTIME_SHIFT   (0x00000012u)
#define GPMC_CONFIG1_2_WAITMONITORINGTIME_ATVALID   (0x0u)
#define GPMC_CONFIG1_2_WAITMONITORINGTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_2_WAITMONITORINGTIME_ONEDEVICEB4   (0x1u)
#define GPMC_CONFIG1_2_WAITMONITORINGTIME_TWODEVICEB4   (0x2u)

#define GPMC_CONFIG1_2_WAITPINSELECT   (0x00030000u)
#define GPMC_CONFIG1_2_WAITPINSELECT_SHIFT   (0x00000010u)
#define GPMC_CONFIG1_2_WAITPINSELECT_RESERVED   (0x3u)
#define GPMC_CONFIG1_2_WAITPINSELECT_W0   (0x0u)
#define GPMC_CONFIG1_2_WAITPINSELECT_W1   (0x1u)
#define GPMC_CONFIG1_2_WAITPINSELECT_W2   (0x2u)

#define GPMC_CONFIG1_2_WAITREADMONITORING   (0x00400000u)
#define GPMC_CONFIG1_2_WAITREADMONITORING_SHIFT   (0x00000016u)
#define GPMC_CONFIG1_2_WAITREADMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_2_WAITREADMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_2_WAITWRITEMONITORING   (0x00200000u)
#define GPMC_CONFIG1_2_WAITWRITEMONITORING_SHIFT   (0x00000015u)
#define GPMC_CONFIG1_2_WAITWRITEMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_2_WAITWRITEMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_2_WRAPBURST   (0x80000000u)
#define GPMC_CONFIG1_2_WRAPBURST_SHIFT   (0x0000001Fu)
#define GPMC_CONFIG1_2_WRAPBURST_WRAPNOTSUPP   (0x0u)
#define GPMC_CONFIG1_2_WRAPBURST_WRAPSUPP   (0x1u)

#define GPMC_CONFIG1_2_WRITEMULTIPLE   (0x10000000u)
#define GPMC_CONFIG1_2_WRITEMULTIPLE_SHIFT   (0x0000001Cu)
#define GPMC_CONFIG1_2_WRITEMULTIPLE_WRMULTIPLE   (0x1u)
#define GPMC_CONFIG1_2_WRITEMULTIPLE_WRSINGLE   (0x0u)

#define GPMC_CONFIG1_2_WRITETYPE   (0x08000000u)
#define GPMC_CONFIG1_2_WRITETYPE_SHIFT   (0x0000001Bu)
#define GPMC_CONFIG1_2_WRITETYPE_WRASYNC   (0x0u)
#define GPMC_CONFIG1_2_WRITETYPE_WRSYNC   (0x1u)


/* CONFIG2_2 */
#define GPMC_CONFIG2_2_CSEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG2_2_CSEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG2_2_CSEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG2_2_CSEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG2_2_CSONTIME   (0x0000000Fu)
#define GPMC_CONFIG2_2_CSONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG2_2_CSRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG2_2_CSRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG2_2_CSWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG2_2_CSWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG3_2 */
#define GPMC_CONFIG3_2_ADVAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG3_2_ADVAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG3_2_ADVAADMUXRDOFFTIME   (0x07000000u)
#define GPMC_CONFIG3_2_ADVAADMUXRDOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG3_2_ADVAADMUXWROFFTIME   (0x70000000u)
#define GPMC_CONFIG3_2_ADVAADMUXWROFFTIME_SHIFT   (0x0000001Cu)

#define GPMC_CONFIG3_2_ADVEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG3_2_ADVEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG3_2_ADVEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG3_2_ADVEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG3_2_ADVONTIME   (0x0000000Fu)
#define GPMC_CONFIG3_2_ADVONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG3_2_ADVRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG3_2_ADVRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG3_2_ADVWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG3_2_ADVWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG4_2 */
#define GPMC_CONFIG4_2_OEAADMUXOFFTIME   (0x0000E000u)
#define GPMC_CONFIG4_2_OEAADMUXOFFTIME_SHIFT   (0x0000000Du)

#define GPMC_CONFIG4_2_OEAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG4_2_OEAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG4_2_OEEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG4_2_OEEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG4_2_OEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_2_OEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_2_OEOFFTIME   (0x00001F00u)
#define GPMC_CONFIG4_2_OEOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG4_2_OEONTIME   (0x0000000Fu)
#define GPMC_CONFIG4_2_OEONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG4_2_WEEXTRADELAY   (0x00800000u)
#define GPMC_CONFIG4_2_WEEXTRADELAY_SHIFT   (0x00000017u)
#define GPMC_CONFIG4_2_WEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_2_WEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_2_WEOFFTIME   (0x1F000000u)
#define GPMC_CONFIG4_2_WEOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG4_2_WEONTIME   (0x000F0000u)
#define GPMC_CONFIG4_2_WEONTIME_SHIFT   (0x00000010u)


/* CONFIG5_2 */
#define GPMC_CONFIG5_2_PAGEBURSTACCESSTIME   (0x0F000000u)
#define GPMC_CONFIG5_2_PAGEBURSTACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG5_2_RDACCESSTIME   (0x001F0000u)
#define GPMC_CONFIG5_2_RDACCESSTIME_SHIFT   (0x00000010u)

#define GPMC_CONFIG5_2_RDCYCLETIME   (0x0000001Fu)
#define GPMC_CONFIG5_2_RDCYCLETIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG5_2_WRCYCLETIME   (0x00001F00u)
#define GPMC_CONFIG5_2_WRCYCLETIME_SHIFT   (0x00000008u)


/* CONFIG6_2 */
#define GPMC_CONFIG6_2_BUSTURNAROUND   (0x0000000Fu)
#define GPMC_CONFIG6_2_BUSTURNAROUND_SHIFT   (0x00000000u)

#define GPMC_CONFIG6_2_CYCLE2CYCLEDELAY   (0x00000F00u)
#define GPMC_CONFIG6_2_CYCLE2CYCLEDELAY_SHIFT   (0x00000008u)

#define GPMC_CONFIG6_2_CYCLE2CYCLEDIFFCSEN   (0x00000040u)
#define GPMC_CONFIG6_2_CYCLE2CYCLEDIFFCSEN_SHIFT   (0x00000006u)
#define GPMC_CONFIG6_2_CYCLE2CYCLEDIFFCSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_2_CYCLE2CYCLEDIFFCSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_2_CYCLE2CYCLESAMECSEN   (0x00000080u)
#define GPMC_CONFIG6_2_CYCLE2CYCLESAMECSEN_SHIFT   (0x00000007u)
#define GPMC_CONFIG6_2_CYCLE2CYCLESAMECSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_2_CYCLE2CYCLESAMECSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_2_WRACCESSTIME   (0x1F000000u)
#define GPMC_CONFIG6_2_WRACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG6_2_WRDATAONADMUXBUS   (0x000F0000u)
#define GPMC_CONFIG6_2_WRDATAONADMUXBUS_SHIFT   (0x00000010u)


/* CONFIG7_2 */
#define GPMC_CONFIG7_2_BASEADDRESS   (0x0000003Fu)
#define GPMC_CONFIG7_2_BASEADDRESS_SHIFT   (0x00000000u)

#define GPMC_CONFIG7_2_CSVALID   (0x00000040u)
#define GPMC_CONFIG7_2_CSVALID_SHIFT   (0x00000006u)
#define GPMC_CONFIG7_2_CSVALID_CSDISABLED   (0x0u)
#define GPMC_CONFIG7_2_CSVALID_CSENABLED   (0x1u)

#define GPMC_CONFIG7_2_MASKADDRESS   (0x00000F00u)
#define GPMC_CONFIG7_2_MASKADDRESS_SHIFT   (0x00000008u)


/* NAND_COMMAND_2 */
#define GPMC_NAND_COMMAND_2_GPMC_NAND_COMMAND_2   (0xFFFFFFFFu)
#define GPMC_NAND_COMMAND_2_GPMC_NAND_COMMAND_2_SHIFT   (0x00000000u)


/* NAND_ADDRESS_2 */
#define GPMC_NAND_ADDRESS_2_GPMC_NAND_ADDRESS_2   (0xFFFFFFFFu)
#define GPMC_NAND_ADDRESS_2_GPMC_NAND_ADDRESS_2_SHIFT   (0x00000000u)


/* NAND_DATA_2 */
#define GPMC_NAND_DATA_2_GPMC_NAND_DATA_2   (0xFFFFFFFFu)
#define GPMC_NAND_DATA_2_GPMC_NAND_DATA_2_SHIFT   (0x00000000u)


/* CONFIG1_3 */
#define GPMC_CONFIG1_3_ATTACHEDDEVICEPAGELENGTH   (0x01800000u)
#define GPMC_CONFIG1_3_ATTACHEDDEVICEPAGELENGTH_SHIFT   (0x00000017u)
#define GPMC_CONFIG1_3_ATTACHEDDEVICEPAGELENGTH_EIGHT   (0x1u)
#define GPMC_CONFIG1_3_ATTACHEDDEVICEPAGELENGTH_FOUR   (0x0u)
#define GPMC_CONFIG1_3_ATTACHEDDEVICEPAGELENGTH_RESERVED   (0x3u)
#define GPMC_CONFIG1_3_ATTACHEDDEVICEPAGELENGTH_SIXTEEN   (0x2u)

#define GPMC_CONFIG1_3_CLKACTIVATIONTIME   (0x06000000u)
#define GPMC_CONFIG1_3_CLKACTIVATIONTIME_SHIFT   (0x00000019u)
#define GPMC_CONFIG1_3_CLKACTIVATIONTIME_ATSTART   (0x0u)
#define GPMC_CONFIG1_3_CLKACTIVATIONTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_3_CLKACTIVATIONTIME_ONECLKB4   (0x1u)
#define GPMC_CONFIG1_3_CLKACTIVATIONTIME_TWOCLKB4   (0x2u)

#define GPMC_CONFIG1_3_DEVICESIZE   (0x00003000u)
#define GPMC_CONFIG1_3_DEVICESIZE_SHIFT   (0x0000000Cu)
#define GPMC_CONFIG1_3_DEVICESIZE_EIGHTBITS   (0x0u)
#define GPMC_CONFIG1_3_DEVICESIZE_RES   (0x3u)
#define GPMC_CONFIG1_3_DEVICESIZE_RESERVED   (0x2u)
#define GPMC_CONFIG1_3_DEVICESIZE_SIXTEENBITS   (0x1u)

#define GPMC_CONFIG1_3_DEVICETYPE   (0x00000C00u)
#define GPMC_CONFIG1_3_DEVICETYPE_SHIFT   (0x0000000Au)
#define GPMC_CONFIG1_3_DEVICETYPE_NANDLIKE   (0x2u)
#define GPMC_CONFIG1_3_DEVICETYPE_NORLIKE   (0x0u)
#define GPMC_CONFIG1_3_DEVICETYPE_RES1   (0x1u)
#define GPMC_CONFIG1_3_DEVICETYPE_RES2   (0x3u)

#define GPMC_CONFIG1_3_GPMCFCLKDIVIDER   (0x00000003u)
#define GPMC_CONFIG1_3_GPMCFCLKDIVIDER_SHIFT   (0x00000000u)
#define GPMC_CONFIG1_3_GPMCFCLKDIVIDER_DIVBY1   (0x0u)
#define GPMC_CONFIG1_3_GPMCFCLKDIVIDER_DIVBY2   (0x1u)
#define GPMC_CONFIG1_3_GPMCFCLKDIVIDER_DIVBY3   (0x2u)
#define GPMC_CONFIG1_3_GPMCFCLKDIVIDER_DIVBY4   (0x3u)

#define GPMC_CONFIG1_3_MUXADDDATA   (0x00000300u)
#define GPMC_CONFIG1_3_MUXADDDATA_SHIFT   (0x00000008u)
#define GPMC_CONFIG1_3_MUXADDDATA_AADMUX   (0x1u)
#define GPMC_CONFIG1_3_MUXADDDATA_MUX   (0x2u)
#define GPMC_CONFIG1_3_MUXADDDATA_NONMUX   (0x0u)
#define GPMC_CONFIG1_3_MUXADDDATA_RESERVED   (0x3u)

#define GPMC_CONFIG1_3_READMULTIPLE   (0x40000000u)
#define GPMC_CONFIG1_3_READMULTIPLE_SHIFT   (0x0000001Eu)
#define GPMC_CONFIG1_3_READMULTIPLE_RDMULTIPLE   (0x1u)
#define GPMC_CONFIG1_3_READMULTIPLE_RDSINGLE   (0x0u)

#define GPMC_CONFIG1_3_READTYPE   (0x20000000u)
#define GPMC_CONFIG1_3_READTYPE_SHIFT   (0x0000001Du)
#define GPMC_CONFIG1_3_READTYPE_RDASYNC   (0x0u)
#define GPMC_CONFIG1_3_READTYPE_RDSYNC   (0x1u)

#define GPMC_CONFIG1_3_TIMEPARAGRANULARITY   (0x00000010u)
#define GPMC_CONFIG1_3_TIMEPARAGRANULARITY_SHIFT   (0x00000004u)
#define GPMC_CONFIG1_3_TIMEPARAGRANULARITY_X1   (0x0u)
#define GPMC_CONFIG1_3_TIMEPARAGRANULARITY_X2   (0x1u)

#define GPMC_CONFIG1_3_WAITMONITORINGTIME   (0x000C0000u)
#define GPMC_CONFIG1_3_WAITMONITORINGTIME_SHIFT   (0x00000012u)
#define GPMC_CONFIG1_3_WAITMONITORINGTIME_ATVALID   (0x0u)
#define GPMC_CONFIG1_3_WAITMONITORINGTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_3_WAITMONITORINGTIME_ONEDEVICEB4   (0x1u)
#define GPMC_CONFIG1_3_WAITMONITORINGTIME_TWODEVICEB4   (0x2u)

#define GPMC_CONFIG1_3_WAITPINSELECT   (0x00030000u)
#define GPMC_CONFIG1_3_WAITPINSELECT_SHIFT   (0x00000010u)
#define GPMC_CONFIG1_3_WAITPINSELECT_RESERVED   (0x3u)
#define GPMC_CONFIG1_3_WAITPINSELECT_W0   (0x0u)
#define GPMC_CONFIG1_3_WAITPINSELECT_W1   (0x1u)
#define GPMC_CONFIG1_3_WAITPINSELECT_W2   (0x2u)

#define GPMC_CONFIG1_3_WAITREADMONITORING   (0x00400000u)
#define GPMC_CONFIG1_3_WAITREADMONITORING_SHIFT   (0x00000016u)
#define GPMC_CONFIG1_3_WAITREADMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_3_WAITREADMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_3_WAITWRITEMONITORING   (0x00200000u)
#define GPMC_CONFIG1_3_WAITWRITEMONITORING_SHIFT   (0x00000015u)
#define GPMC_CONFIG1_3_WAITWRITEMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_3_WAITWRITEMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_3_WRAPBURST   (0x80000000u)
#define GPMC_CONFIG1_3_WRAPBURST_SHIFT   (0x0000001Fu)
#define GPMC_CONFIG1_3_WRAPBURST_WRAPNOTSUPP   (0x0u)
#define GPMC_CONFIG1_3_WRAPBURST_WRAPSUPP   (0x1u)

#define GPMC_CONFIG1_3_WRITEMULTIPLE   (0x10000000u)
#define GPMC_CONFIG1_3_WRITEMULTIPLE_SHIFT   (0x0000001Cu)
#define GPMC_CONFIG1_3_WRITEMULTIPLE_WRMULTIPLE   (0x1u)
#define GPMC_CONFIG1_3_WRITEMULTIPLE_WRSINGLE   (0x0u)

#define GPMC_CONFIG1_3_WRITETYPE   (0x08000000u)
#define GPMC_CONFIG1_3_WRITETYPE_SHIFT   (0x0000001Bu)
#define GPMC_CONFIG1_3_WRITETYPE_WRASYNC   (0x0u)
#define GPMC_CONFIG1_3_WRITETYPE_WRSYNC   (0x1u)


/* CONFIG2_3 */
#define GPMC_CONFIG2_3_CSEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG2_3_CSEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG2_3_CSEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG2_3_CSEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG2_3_CSONTIME   (0x0000000Fu)
#define GPMC_CONFIG2_3_CSONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG2_3_CSRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG2_3_CSRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG2_3_CSWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG2_3_CSWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG3_3 */
#define GPMC_CONFIG3_3_ADVAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG3_3_ADVAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG3_3_ADVAADMUXRDOFFTIME   (0x07000000u)
#define GPMC_CONFIG3_3_ADVAADMUXRDOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG3_3_ADVAADMUXWROFFTIME   (0x70000000u)
#define GPMC_CONFIG3_3_ADVAADMUXWROFFTIME_SHIFT   (0x0000001Cu)

#define GPMC_CONFIG3_3_ADVEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG3_3_ADVEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG3_3_ADVEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG3_3_ADVEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG3_3_ADVONTIME   (0x0000000Fu)
#define GPMC_CONFIG3_3_ADVONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG3_3_ADVRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG3_3_ADVRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG3_3_ADVWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG3_3_ADVWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG4_3 */
#define GPMC_CONFIG4_3_OEAADMUXOFFTIME   (0x0000E000u)
#define GPMC_CONFIG4_3_OEAADMUXOFFTIME_SHIFT   (0x0000000Du)

#define GPMC_CONFIG4_3_OEAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG4_3_OEAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG4_3_OEEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG4_3_OEEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG4_3_OEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_3_OEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_3_OEOFFTIME   (0x00001F00u)
#define GPMC_CONFIG4_3_OEOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG4_3_OEONTIME   (0x0000000Fu)
#define GPMC_CONFIG4_3_OEONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG4_3_WEEXTRADELAY   (0x00800000u)
#define GPMC_CONFIG4_3_WEEXTRADELAY_SHIFT   (0x00000017u)
#define GPMC_CONFIG4_3_WEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_3_WEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_3_WEOFFTIME   (0x1F000000u)
#define GPMC_CONFIG4_3_WEOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG4_3_WEONTIME   (0x000F0000u)
#define GPMC_CONFIG4_3_WEONTIME_SHIFT   (0x00000010u)


/* CONFIG5_3 */
#define GPMC_CONFIG5_3_PAGEBURSTACCESSTIME   (0x0F000000u)
#define GPMC_CONFIG5_3_PAGEBURSTACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG5_3_RDACCESSTIME   (0x001F0000u)
#define GPMC_CONFIG5_3_RDACCESSTIME_SHIFT   (0x00000010u)

#define GPMC_CONFIG5_3_RDCYCLETIME   (0x0000001Fu)
#define GPMC_CONFIG5_3_RDCYCLETIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG5_3_WRCYCLETIME   (0x00001F00u)
#define GPMC_CONFIG5_3_WRCYCLETIME_SHIFT   (0x00000008u)


/* CONFIG6_3 */
#define GPMC_CONFIG6_3_BUSTURNAROUND   (0x0000000Fu)
#define GPMC_CONFIG6_3_BUSTURNAROUND_SHIFT   (0x00000000u)

#define GPMC_CONFIG6_3_CYCLE2CYCLEDELAY   (0x00000F00u)
#define GPMC_CONFIG6_3_CYCLE2CYCLEDELAY_SHIFT   (0x00000008u)

#define GPMC_CONFIG6_3_CYCLE2CYCLEDIFFCSEN   (0x00000040u)
#define GPMC_CONFIG6_3_CYCLE2CYCLEDIFFCSEN_SHIFT   (0x00000006u)
#define GPMC_CONFIG6_3_CYCLE2CYCLEDIFFCSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_3_CYCLE2CYCLEDIFFCSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_3_CYCLE2CYCLESAMECSEN   (0x00000080u)
#define GPMC_CONFIG6_3_CYCLE2CYCLESAMECSEN_SHIFT   (0x00000007u)
#define GPMC_CONFIG6_3_CYCLE2CYCLESAMECSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_3_CYCLE2CYCLESAMECSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_3_WRACCESSTIME   (0x1F000000u)
#define GPMC_CONFIG6_3_WRACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG6_3_WRDATAONADMUXBUS   (0x000F0000u)
#define GPMC_CONFIG6_3_WRDATAONADMUXBUS_SHIFT   (0x00000010u)


/* CONFIG7_3 */
#define GPMC_CONFIG7_3_BASEADDRESS   (0x0000003Fu)
#define GPMC_CONFIG7_3_BASEADDRESS_SHIFT   (0x00000000u)

#define GPMC_CONFIG7_3_CSVALID   (0x00000040u)
#define GPMC_CONFIG7_3_CSVALID_SHIFT   (0x00000006u)
#define GPMC_CONFIG7_3_CSVALID_CSDISABLED   (0x0u)
#define GPMC_CONFIG7_3_CSVALID_CSENABLED   (0x1u)

#define GPMC_CONFIG7_3_MASKADDRESS   (0x00000F00u)
#define GPMC_CONFIG7_3_MASKADDRESS_SHIFT   (0x00000008u)


/* NAND_COMMAND_3 */
#define GPMC_NAND_COMMAND_3_GPMC_NAND_COMMAND_3   (0xFFFFFFFFu)
#define GPMC_NAND_COMMAND_3_GPMC_NAND_COMMAND_3_SHIFT   (0x00000000u)


/* NAND_ADDRESS_3 */
#define GPMC_NAND_ADDRESS_3_GPMC_NAND_ADDRESS_3   (0xFFFFFFFFu)
#define GPMC_NAND_ADDRESS_3_GPMC_NAND_ADDRESS_3_SHIFT   (0x00000000u)


/* NAND_DATA_3 */
#define GPMC_NAND_DATA_3_GPMC_NAND_DATA_3   (0xFFFFFFFFu)
#define GPMC_NAND_DATA_3_GPMC_NAND_DATA_3_SHIFT   (0x00000000u)


/* CONFIG1_4 */
#define GPMC_CONFIG1_4_ATTACHEDDEVICEPAGELENGTH   (0x01800000u)
#define GPMC_CONFIG1_4_ATTACHEDDEVICEPAGELENGTH_SHIFT   (0x00000017u)
#define GPMC_CONFIG1_4_ATTACHEDDEVICEPAGELENGTH_EIGHT   (0x1u)
#define GPMC_CONFIG1_4_ATTACHEDDEVICEPAGELENGTH_FOUR   (0x0u)
#define GPMC_CONFIG1_4_ATTACHEDDEVICEPAGELENGTH_RESERVED   (0x3u)
#define GPMC_CONFIG1_4_ATTACHEDDEVICEPAGELENGTH_SIXTEEN   (0x2u)

#define GPMC_CONFIG1_4_CLKACTIVATIONTIME   (0x06000000u)
#define GPMC_CONFIG1_4_CLKACTIVATIONTIME_SHIFT   (0x00000019u)
#define GPMC_CONFIG1_4_CLKACTIVATIONTIME_ATSTART   (0x0u)
#define GPMC_CONFIG1_4_CLKACTIVATIONTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_4_CLKACTIVATIONTIME_ONECLKB4   (0x1u)
#define GPMC_CONFIG1_4_CLKACTIVATIONTIME_TWOCLKB4   (0x2u)

#define GPMC_CONFIG1_4_DEVICESIZE   (0x00003000u)
#define GPMC_CONFIG1_4_DEVICESIZE_SHIFT   (0x0000000Cu)
#define GPMC_CONFIG1_4_DEVICESIZE_EIGHTBITS   (0x0u)
#define GPMC_CONFIG1_4_DEVICESIZE_RES   (0x3u)
#define GPMC_CONFIG1_4_DEVICESIZE_RESERVED   (0x2u)
#define GPMC_CONFIG1_4_DEVICESIZE_SIXTEENBITS   (0x1u)

#define GPMC_CONFIG1_4_DEVICETYPE   (0x00000C00u)
#define GPMC_CONFIG1_4_DEVICETYPE_SHIFT   (0x0000000Au)
#define GPMC_CONFIG1_4_DEVICETYPE_NANDLIKE   (0x2u)
#define GPMC_CONFIG1_4_DEVICETYPE_NORLIKE   (0x0u)
#define GPMC_CONFIG1_4_DEVICETYPE_RES1   (0x1u)
#define GPMC_CONFIG1_4_DEVICETYPE_RES2   (0x3u)

#define GPMC_CONFIG1_4_GPMCFCLKDIVIDER   (0x00000003u)
#define GPMC_CONFIG1_4_GPMCFCLKDIVIDER_SHIFT   (0x00000000u)
#define GPMC_CONFIG1_4_GPMCFCLKDIVIDER_DIVBY1   (0x0u)
#define GPMC_CONFIG1_4_GPMCFCLKDIVIDER_DIVBY2   (0x1u)
#define GPMC_CONFIG1_4_GPMCFCLKDIVIDER_DIVBY3   (0x2u)
#define GPMC_CONFIG1_4_GPMCFCLKDIVIDER_DIVBY4   (0x3u)

#define GPMC_CONFIG1_4_MUXADDDATA   (0x00000300u)
#define GPMC_CONFIG1_4_MUXADDDATA_SHIFT   (0x00000008u)
#define GPMC_CONFIG1_4_MUXADDDATA_AADMUX   (0x1u)
#define GPMC_CONFIG1_4_MUXADDDATA_MUX   (0x2u)
#define GPMC_CONFIG1_4_MUXADDDATA_NONMUX   (0x0u)
#define GPMC_CONFIG1_4_MUXADDDATA_RESERVED   (0x3u)

#define GPMC_CONFIG1_4_READMULTIPLE   (0x40000000u)
#define GPMC_CONFIG1_4_READMULTIPLE_SHIFT   (0x0000001Eu)
#define GPMC_CONFIG1_4_READMULTIPLE_RDMULTIPLE   (0x1u)
#define GPMC_CONFIG1_4_READMULTIPLE_RDSINGLE   (0x0u)

#define GPMC_CONFIG1_4_READTYPE   (0x20000000u)
#define GPMC_CONFIG1_4_READTYPE_SHIFT   (0x0000001Du)
#define GPMC_CONFIG1_4_READTYPE_RDASYNC   (0x0u)
#define GPMC_CONFIG1_4_READTYPE_RDSYNC   (0x1u)

#define GPMC_CONFIG1_4_TIMEPARAGRANULARITY   (0x00000010u)
#define GPMC_CONFIG1_4_TIMEPARAGRANULARITY_SHIFT   (0x00000004u)
#define GPMC_CONFIG1_4_TIMEPARAGRANULARITY_X1   (0x0u)
#define GPMC_CONFIG1_4_TIMEPARAGRANULARITY_X2   (0x1u)

#define GPMC_CONFIG1_4_WAITMONITORINGTIME   (0x000C0000u)
#define GPMC_CONFIG1_4_WAITMONITORINGTIME_SHIFT   (0x00000012u)
#define GPMC_CONFIG1_4_WAITMONITORINGTIME_ATVALID   (0x0u)
#define GPMC_CONFIG1_4_WAITMONITORINGTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_4_WAITMONITORINGTIME_ONEDEVICEB4   (0x1u)
#define GPMC_CONFIG1_4_WAITMONITORINGTIME_TWODEVICEB4   (0x2u)

#define GPMC_CONFIG1_4_WAITPINSELECT   (0x00030000u)
#define GPMC_CONFIG1_4_WAITPINSELECT_SHIFT   (0x00000010u)
#define GPMC_CONFIG1_4_WAITPINSELECT_RESERVED   (0x3u)
#define GPMC_CONFIG1_4_WAITPINSELECT_W0   (0x0u)
#define GPMC_CONFIG1_4_WAITPINSELECT_W1   (0x1u)
#define GPMC_CONFIG1_4_WAITPINSELECT_W2   (0x2u)

#define GPMC_CONFIG1_4_WAITREADMONITORING   (0x00400000u)
#define GPMC_CONFIG1_4_WAITREADMONITORING_SHIFT   (0x00000016u)
#define GPMC_CONFIG1_4_WAITREADMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_4_WAITREADMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_4_WAITWRITEMONITORING   (0x00200000u)
#define GPMC_CONFIG1_4_WAITWRITEMONITORING_SHIFT   (0x00000015u)
#define GPMC_CONFIG1_4_WAITWRITEMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_4_WAITWRITEMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_4_WRAPBURST   (0x80000000u)
#define GPMC_CONFIG1_4_WRAPBURST_SHIFT   (0x0000001Fu)
#define GPMC_CONFIG1_4_WRAPBURST_WRAPNOTSUPP   (0x0u)
#define GPMC_CONFIG1_4_WRAPBURST_WRAPSUPP   (0x1u)

#define GPMC_CONFIG1_4_WRITEMULTIPLE   (0x10000000u)
#define GPMC_CONFIG1_4_WRITEMULTIPLE_SHIFT   (0x0000001Cu)
#define GPMC_CONFIG1_4_WRITEMULTIPLE_WRMULTIPLE   (0x1u)
#define GPMC_CONFIG1_4_WRITEMULTIPLE_WRSINGLE   (0x0u)

#define GPMC_CONFIG1_4_WRITETYPE   (0x08000000u)
#define GPMC_CONFIG1_4_WRITETYPE_SHIFT   (0x0000001Bu)
#define GPMC_CONFIG1_4_WRITETYPE_WRASYNC   (0x0u)
#define GPMC_CONFIG1_4_WRITETYPE_WRSYNC   (0x1u)


/* CONFIG2_4 */
#define GPMC_CONFIG2_4_CSEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG2_4_CSEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG2_4_CSEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG2_4_CSEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG2_4_CSONTIME   (0x0000000Fu)
#define GPMC_CONFIG2_4_CSONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG2_4_CSRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG2_4_CSRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG2_4_CSWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG2_4_CSWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG3_4 */
#define GPMC_CONFIG3_4_ADVAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG3_4_ADVAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG3_4_ADVAADMUXRDOFFTIME   (0x07000000u)
#define GPMC_CONFIG3_4_ADVAADMUXRDOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG3_4_ADVAADMUXWROFFTIME   (0x70000000u)
#define GPMC_CONFIG3_4_ADVAADMUXWROFFTIME_SHIFT   (0x0000001Cu)

#define GPMC_CONFIG3_4_ADVEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG3_4_ADVEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG3_4_ADVEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG3_4_ADVEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG3_4_ADVONTIME   (0x0000000Fu)
#define GPMC_CONFIG3_4_ADVONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG3_4_ADVRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG3_4_ADVRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG3_4_ADVWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG3_4_ADVWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG4_4 */
#define GPMC_CONFIG4_4_OEAADMUXOFFTIME   (0x0000E000u)
#define GPMC_CONFIG4_4_OEAADMUXOFFTIME_SHIFT   (0x0000000Du)

#define GPMC_CONFIG4_4_OEAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG4_4_OEAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG4_4_OEEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG4_4_OEEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG4_4_OEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_4_OEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_4_OEOFFTIME   (0x00001F00u)
#define GPMC_CONFIG4_4_OEOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG4_4_OEONTIME   (0x0000000Fu)
#define GPMC_CONFIG4_4_OEONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG4_4_WEEXTRADELAY   (0x00800000u)
#define GPMC_CONFIG4_4_WEEXTRADELAY_SHIFT   (0x00000017u)
#define GPMC_CONFIG4_4_WEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_4_WEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_4_WEOFFTIME   (0x1F000000u)
#define GPMC_CONFIG4_4_WEOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG4_4_WEONTIME   (0x000F0000u)
#define GPMC_CONFIG4_4_WEONTIME_SHIFT   (0x00000010u)


/* CONFIG5_4 */
#define GPMC_CONFIG5_4_PAGEBURSTACCESSTIME   (0x0F000000u)
#define GPMC_CONFIG5_4_PAGEBURSTACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG5_4_RDACCESSTIME   (0x001F0000u)
#define GPMC_CONFIG5_4_RDACCESSTIME_SHIFT   (0x00000010u)

#define GPMC_CONFIG5_4_RDCYCLETIME   (0x0000001Fu)
#define GPMC_CONFIG5_4_RDCYCLETIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG5_4_WRCYCLETIME   (0x00001F00u)
#define GPMC_CONFIG5_4_WRCYCLETIME_SHIFT   (0x00000008u)


/* CONFIG6_4 */
#define GPMC_CONFIG6_4_BUSTURNAROUND   (0x0000000Fu)
#define GPMC_CONFIG6_4_BUSTURNAROUND_SHIFT   (0x00000000u)

#define GPMC_CONFIG6_4_CYCLE2CYCLEDELAY   (0x00000F00u)
#define GPMC_CONFIG6_4_CYCLE2CYCLEDELAY_SHIFT   (0x00000008u)

#define GPMC_CONFIG6_4_CYCLE2CYCLEDIFFCSEN   (0x00000040u)
#define GPMC_CONFIG6_4_CYCLE2CYCLEDIFFCSEN_SHIFT   (0x00000006u)
#define GPMC_CONFIG6_4_CYCLE2CYCLEDIFFCSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_4_CYCLE2CYCLEDIFFCSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_4_CYCLE2CYCLESAMECSEN   (0x00000080u)
#define GPMC_CONFIG6_4_CYCLE2CYCLESAMECSEN_SHIFT   (0x00000007u)
#define GPMC_CONFIG6_4_CYCLE2CYCLESAMECSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_4_CYCLE2CYCLESAMECSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_4_WRACCESSTIME   (0x1F000000u)
#define GPMC_CONFIG6_4_WRACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG6_4_WRDATAONADMUXBUS   (0x000F0000u)
#define GPMC_CONFIG6_4_WRDATAONADMUXBUS_SHIFT   (0x00000010u)


/* CONFIG7_4 */
#define GPMC_CONFIG7_4_BASEADDRESS   (0x0000003Fu)
#define GPMC_CONFIG7_4_BASEADDRESS_SHIFT   (0x00000000u)

#define GPMC_CONFIG7_4_CSVALID   (0x00000040u)
#define GPMC_CONFIG7_4_CSVALID_SHIFT   (0x00000006u)
#define GPMC_CONFIG7_4_CSVALID_CSDISABLED   (0x0u)
#define GPMC_CONFIG7_4_CSVALID_CSENABLED   (0x1u)

#define GPMC_CONFIG7_4_MASKADDRESS   (0x00000F00u)
#define GPMC_CONFIG7_4_MASKADDRESS_SHIFT   (0x00000008u)


/* NAND_COMMAND_4 */
#define GPMC_NAND_COMMAND_4_GPMC_NAND_COMMAND_4   (0xFFFFFFFFu)
#define GPMC_NAND_COMMAND_4_GPMC_NAND_COMMAND_4_SHIFT   (0x00000000u)


/* NAND_ADDRESS_4 */
#define GPMC_NAND_ADDRESS_4_GPMC_NAND_ADDRESS_4   (0xFFFFFFFFu)
#define GPMC_NAND_ADDRESS_4_GPMC_NAND_ADDRESS_4_SHIFT   (0x00000000u)


/* NAND_DATA_4 */
#define GPMC_NAND_DATA_4_GPMC_NAND_DATA_4   (0xFFFFFFFFu)
#define GPMC_NAND_DATA_4_GPMC_NAND_DATA_4_SHIFT   (0x00000000u)


/* CONFIG1_5 */
#define GPMC_CONFIG1_5_ATTACHEDDEVICEPAGELENGTH   (0x01800000u)
#define GPMC_CONFIG1_5_ATTACHEDDEVICEPAGELENGTH_SHIFT   (0x00000017u)
#define GPMC_CONFIG1_5_ATTACHEDDEVICEPAGELENGTH_EIGHT   (0x1u)
#define GPMC_CONFIG1_5_ATTACHEDDEVICEPAGELENGTH_FOUR   (0x0u)
#define GPMC_CONFIG1_5_ATTACHEDDEVICEPAGELENGTH_RESERVED   (0x3u)
#define GPMC_CONFIG1_5_ATTACHEDDEVICEPAGELENGTH_SIXTEEN   (0x2u)

#define GPMC_CONFIG1_5_CLKACTIVATIONTIME   (0x06000000u)
#define GPMC_CONFIG1_5_CLKACTIVATIONTIME_SHIFT   (0x00000019u)
#define GPMC_CONFIG1_5_CLKACTIVATIONTIME_ATSTART   (0x0u)
#define GPMC_CONFIG1_5_CLKACTIVATIONTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_5_CLKACTIVATIONTIME_ONECLKB4   (0x1u)
#define GPMC_CONFIG1_5_CLKACTIVATIONTIME_TWOCLKB4   (0x2u)

#define GPMC_CONFIG1_5_DEVICESIZE   (0x00003000u)
#define GPMC_CONFIG1_5_DEVICESIZE_SHIFT   (0x0000000Cu)
#define GPMC_CONFIG1_5_DEVICESIZE_EIGHTBITS   (0x0u)
#define GPMC_CONFIG1_5_DEVICESIZE_RES   (0x3u)
#define GPMC_CONFIG1_5_DEVICESIZE_RESERVED   (0x2u)
#define GPMC_CONFIG1_5_DEVICESIZE_SIXTEENBITS   (0x1u)

#define GPMC_CONFIG1_5_DEVICETYPE   (0x00000C00u)
#define GPMC_CONFIG1_5_DEVICETYPE_SHIFT   (0x0000000Au)
#define GPMC_CONFIG1_5_DEVICETYPE_NANDLIKE   (0x2u)
#define GPMC_CONFIG1_5_DEVICETYPE_NORLIKE   (0x0u)
#define GPMC_CONFIG1_5_DEVICETYPE_RES1   (0x1u)
#define GPMC_CONFIG1_5_DEVICETYPE_RES2   (0x3u)

#define GPMC_CONFIG1_5_GPMCFCLKDIVIDER   (0x00000003u)
#define GPMC_CONFIG1_5_GPMCFCLKDIVIDER_SHIFT   (0x00000000u)
#define GPMC_CONFIG1_5_GPMCFCLKDIVIDER_DIVBY1   (0x0u)
#define GPMC_CONFIG1_5_GPMCFCLKDIVIDER_DIVBY2   (0x1u)
#define GPMC_CONFIG1_5_GPMCFCLKDIVIDER_DIVBY3   (0x2u)
#define GPMC_CONFIG1_5_GPMCFCLKDIVIDER_DIVBY4   (0x3u)

#define GPMC_CONFIG1_5_MUXADDDATA   (0x00000300u)
#define GPMC_CONFIG1_5_MUXADDDATA_SHIFT   (0x00000008u)
#define GPMC_CONFIG1_5_MUXADDDATA_AADMUX   (0x1u)
#define GPMC_CONFIG1_5_MUXADDDATA_MUX   (0x2u)
#define GPMC_CONFIG1_5_MUXADDDATA_NONMUX   (0x0u)
#define GPMC_CONFIG1_5_MUXADDDATA_RESERVED   (0x3u)

#define GPMC_CONFIG1_5_READMULTIPLE   (0x40000000u)
#define GPMC_CONFIG1_5_READMULTIPLE_SHIFT   (0x0000001Eu)
#define GPMC_CONFIG1_5_READMULTIPLE_RDMULTIPLE   (0x1u)
#define GPMC_CONFIG1_5_READMULTIPLE_RDSINGLE   (0x0u)

#define GPMC_CONFIG1_5_READTYPE   (0x20000000u)
#define GPMC_CONFIG1_5_READTYPE_SHIFT   (0x0000001Du)
#define GPMC_CONFIG1_5_READTYPE_RDASYNC   (0x0u)
#define GPMC_CONFIG1_5_READTYPE_RDSYNC   (0x1u)

#define GPMC_CONFIG1_5_TIMEPARAGRANULARITY   (0x00000010u)
#define GPMC_CONFIG1_5_TIMEPARAGRANULARITY_SHIFT   (0x00000004u)
#define GPMC_CONFIG1_5_TIMEPARAGRANULARITY_X1   (0x0u)
#define GPMC_CONFIG1_5_TIMEPARAGRANULARITY_X2   (0x1u)

#define GPMC_CONFIG1_5_WAITMONITORINGTIME   (0x000C0000u)
#define GPMC_CONFIG1_5_WAITMONITORINGTIME_SHIFT   (0x00000012u)
#define GPMC_CONFIG1_5_WAITMONITORINGTIME_ATVALID   (0x0u)
#define GPMC_CONFIG1_5_WAITMONITORINGTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_5_WAITMONITORINGTIME_ONEDEVICEB4   (0x1u)
#define GPMC_CONFIG1_5_WAITMONITORINGTIME_TWODEVICEB4   (0x2u)

#define GPMC_CONFIG1_5_WAITPINSELECT   (0x00030000u)
#define GPMC_CONFIG1_5_WAITPINSELECT_SHIFT   (0x00000010u)
#define GPMC_CONFIG1_5_WAITPINSELECT_RESERVED   (0x3u)
#define GPMC_CONFIG1_5_WAITPINSELECT_W0   (0x0u)
#define GPMC_CONFIG1_5_WAITPINSELECT_W1   (0x1u)
#define GPMC_CONFIG1_5_WAITPINSELECT_W2   (0x2u)

#define GPMC_CONFIG1_5_WAITREADMONITORING   (0x00400000u)
#define GPMC_CONFIG1_5_WAITREADMONITORING_SHIFT   (0x00000016u)
#define GPMC_CONFIG1_5_WAITREADMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_5_WAITREADMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_5_WAITWRITEMONITORING   (0x00200000u)
#define GPMC_CONFIG1_5_WAITWRITEMONITORING_SHIFT   (0x00000015u)
#define GPMC_CONFIG1_5_WAITWRITEMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_5_WAITWRITEMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_5_WRAPBURST   (0x80000000u)
#define GPMC_CONFIG1_5_WRAPBURST_SHIFT   (0x0000001Fu)
#define GPMC_CONFIG1_5_WRAPBURST_WRAPNOTSUPP   (0x0u)
#define GPMC_CONFIG1_5_WRAPBURST_WRAPSUPP   (0x1u)

#define GPMC_CONFIG1_5_WRITEMULTIPLE   (0x10000000u)
#define GPMC_CONFIG1_5_WRITEMULTIPLE_SHIFT   (0x0000001Cu)
#define GPMC_CONFIG1_5_WRITEMULTIPLE_WRMULTIPLE   (0x1u)
#define GPMC_CONFIG1_5_WRITEMULTIPLE_WRSINGLE   (0x0u)

#define GPMC_CONFIG1_5_WRITETYPE   (0x08000000u)
#define GPMC_CONFIG1_5_WRITETYPE_SHIFT   (0x0000001Bu)
#define GPMC_CONFIG1_5_WRITETYPE_WRASYNC   (0x0u)
#define GPMC_CONFIG1_5_WRITETYPE_WRSYNC   (0x1u)


/* CONFIG2_5 */
#define GPMC_CONFIG2_5_CSEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG2_5_CSEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG2_5_CSEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG2_5_CSEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG2_5_CSONTIME   (0x0000000Fu)
#define GPMC_CONFIG2_5_CSONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG2_5_CSRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG2_5_CSRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG2_5_CSWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG2_5_CSWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG3_5 */
#define GPMC_CONFIG3_5_ADVAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG3_5_ADVAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG3_5_ADVAADMUXRDOFFTIME   (0x07000000u)
#define GPMC_CONFIG3_5_ADVAADMUXRDOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG3_5_ADVAADMUXWROFFTIME   (0x70000000u)
#define GPMC_CONFIG3_5_ADVAADMUXWROFFTIME_SHIFT   (0x0000001Cu)

#define GPMC_CONFIG3_5_ADVEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG3_5_ADVEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG3_5_ADVEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG3_5_ADVEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG3_5_ADVONTIME   (0x0000000Fu)
#define GPMC_CONFIG3_5_ADVONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG3_5_ADVRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG3_5_ADVRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG3_5_ADVWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG3_5_ADVWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG4_5 */
#define GPMC_CONFIG4_5_OEAADMUXOFFTIME   (0x0000E000u)
#define GPMC_CONFIG4_5_OEAADMUXOFFTIME_SHIFT   (0x0000000Du)

#define GPMC_CONFIG4_5_OEAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG4_5_OEAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG4_5_OEEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG4_5_OEEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG4_5_OEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_5_OEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_5_OEOFFTIME   (0x00001F00u)
#define GPMC_CONFIG4_5_OEOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG4_5_OEONTIME   (0x0000000Fu)
#define GPMC_CONFIG4_5_OEONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG4_5_WEEXTRADELAY   (0x00800000u)
#define GPMC_CONFIG4_5_WEEXTRADELAY_SHIFT   (0x00000017u)
#define GPMC_CONFIG4_5_WEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_5_WEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_5_WEOFFTIME   (0x1F000000u)
#define GPMC_CONFIG4_5_WEOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG4_5_WEONTIME   (0x000F0000u)
#define GPMC_CONFIG4_5_WEONTIME_SHIFT   (0x00000010u)


/* CONFIG5_5 */
#define GPMC_CONFIG5_5_PAGEBURSTACCESSTIME   (0x0F000000u)
#define GPMC_CONFIG5_5_PAGEBURSTACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG5_5_RDACCESSTIME   (0x001F0000u)
#define GPMC_CONFIG5_5_RDACCESSTIME_SHIFT   (0x00000010u)

#define GPMC_CONFIG5_5_RDCYCLETIME   (0x0000001Fu)
#define GPMC_CONFIG5_5_RDCYCLETIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG5_5_WRCYCLETIME   (0x00001F00u)
#define GPMC_CONFIG5_5_WRCYCLETIME_SHIFT   (0x00000008u)


/* CONFIG6_5 */
#define GPMC_CONFIG6_5_BUSTURNAROUND   (0x0000000Fu)
#define GPMC_CONFIG6_5_BUSTURNAROUND_SHIFT   (0x00000000u)

#define GPMC_CONFIG6_5_CYCLE2CYCLEDELAY   (0x00000F00u)
#define GPMC_CONFIG6_5_CYCLE2CYCLEDELAY_SHIFT   (0x00000008u)

#define GPMC_CONFIG6_5_CYCLE2CYCLEDIFFCSEN   (0x00000040u)
#define GPMC_CONFIG6_5_CYCLE2CYCLEDIFFCSEN_SHIFT   (0x00000006u)
#define GPMC_CONFIG6_5_CYCLE2CYCLEDIFFCSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_5_CYCLE2CYCLEDIFFCSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_5_CYCLE2CYCLESAMECSEN   (0x00000080u)
#define GPMC_CONFIG6_5_CYCLE2CYCLESAMECSEN_SHIFT   (0x00000007u)
#define GPMC_CONFIG6_5_CYCLE2CYCLESAMECSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_5_CYCLE2CYCLESAMECSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_5_WRACCESSTIME   (0x1F000000u)
#define GPMC_CONFIG6_5_WRACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG6_5_WRDATAONADMUXBUS   (0x000F0000u)
#define GPMC_CONFIG6_5_WRDATAONADMUXBUS_SHIFT   (0x00000010u)


/* CONFIG7_5 */
#define GPMC_CONFIG7_5_BASEADDRESS   (0x0000003Fu)
#define GPMC_CONFIG7_5_BASEADDRESS_SHIFT   (0x00000000u)

#define GPMC_CONFIG7_5_CSVALID   (0x00000040u)
#define GPMC_CONFIG7_5_CSVALID_SHIFT   (0x00000006u)
#define GPMC_CONFIG7_5_CSVALID_CSDISABLED   (0x0u)
#define GPMC_CONFIG7_5_CSVALID_CSENABLED   (0x1u)

#define GPMC_CONFIG7_5_MASKADDRESS   (0x00000F00u)
#define GPMC_CONFIG7_5_MASKADDRESS_SHIFT   (0x00000008u)


/* NAND_COMMAND_5 */
#define GPMC_NAND_COMMAND_5_GPMC_NAND_COMMAND_5   (0xFFFFFFFFu)
#define GPMC_NAND_COMMAND_5_GPMC_NAND_COMMAND_5_SHIFT   (0x00000000u)


/* NAND_ADDRESS_5 */
#define GPMC_NAND_ADDRESS_5_GPMC_NAND_ADDRESS_5   (0xFFFFFFFFu)
#define GPMC_NAND_ADDRESS_5_GPMC_NAND_ADDRESS_5_SHIFT   (0x00000000u)


/* NAND_DATA_5 */
#define GPMC_NAND_DATA_5_GPMC_NAND_DATA_5   (0xFFFFFFFFu)
#define GPMC_NAND_DATA_5_GPMC_NAND_DATA_5_SHIFT   (0x00000000u)


/* CONFIG1_6 */
#define GPMC_CONFIG1_6_ATTACHEDDEVICEPAGELENGTH   (0x01800000u)
#define GPMC_CONFIG1_6_ATTACHEDDEVICEPAGELENGTH_SHIFT   (0x00000017u)
#define GPMC_CONFIG1_6_ATTACHEDDEVICEPAGELENGTH_EIGHT   (0x1u)
#define GPMC_CONFIG1_6_ATTACHEDDEVICEPAGELENGTH_FOUR   (0x0u)
#define GPMC_CONFIG1_6_ATTACHEDDEVICEPAGELENGTH_RESERVED   (0x3u)
#define GPMC_CONFIG1_6_ATTACHEDDEVICEPAGELENGTH_SIXTEEN   (0x2u)

#define GPMC_CONFIG1_6_CLKACTIVATIONTIME   (0x06000000u)
#define GPMC_CONFIG1_6_CLKACTIVATIONTIME_SHIFT   (0x00000019u)
#define GPMC_CONFIG1_6_CLKACTIVATIONTIME_ATSTART   (0x0u)
#define GPMC_CONFIG1_6_CLKACTIVATIONTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_6_CLKACTIVATIONTIME_ONECLKB4   (0x1u)
#define GPMC_CONFIG1_6_CLKACTIVATIONTIME_TWOCLKB4   (0x2u)

#define GPMC_CONFIG1_6_DEVICESIZE   (0x00003000u)
#define GPMC_CONFIG1_6_DEVICESIZE_SHIFT   (0x0000000Cu)
#define GPMC_CONFIG1_6_DEVICESIZE_EIGHTBITS   (0x0u)
#define GPMC_CONFIG1_6_DEVICESIZE_RES   (0x3u)
#define GPMC_CONFIG1_6_DEVICESIZE_RESERVED   (0x2u)
#define GPMC_CONFIG1_6_DEVICESIZE_SIXTEENBITS   (0x1u)

#define GPMC_CONFIG1_6_DEVICETYPE   (0x00000C00u)
#define GPMC_CONFIG1_6_DEVICETYPE_SHIFT   (0x0000000Au)
#define GPMC_CONFIG1_6_DEVICETYPE_NANDLIKE   (0x2u)
#define GPMC_CONFIG1_6_DEVICETYPE_NORLIKE   (0x0u)
#define GPMC_CONFIG1_6_DEVICETYPE_RES1   (0x1u)
#define GPMC_CONFIG1_6_DEVICETYPE_RES2   (0x3u)

#define GPMC_CONFIG1_6_GPMCFCLKDIVIDER   (0x00000003u)
#define GPMC_CONFIG1_6_GPMCFCLKDIVIDER_SHIFT   (0x00000000u)
#define GPMC_CONFIG1_6_GPMCFCLKDIVIDER_DIVBY1   (0x0u)
#define GPMC_CONFIG1_6_GPMCFCLKDIVIDER_DIVBY2   (0x1u)
#define GPMC_CONFIG1_6_GPMCFCLKDIVIDER_DIVBY3   (0x2u)
#define GPMC_CONFIG1_6_GPMCFCLKDIVIDER_DIVBY4   (0x3u)

#define GPMC_CONFIG1_6_MUXADDDATA   (0x00000300u)
#define GPMC_CONFIG1_6_MUXADDDATA_SHIFT   (0x00000008u)
#define GPMC_CONFIG1_6_MUXADDDATA_AADMUX   (0x1u)
#define GPMC_CONFIG1_6_MUXADDDATA_MUX   (0x2u)
#define GPMC_CONFIG1_6_MUXADDDATA_NONMUX   (0x0u)
#define GPMC_CONFIG1_6_MUXADDDATA_RESERVED   (0x3u)

#define GPMC_CONFIG1_6_READMULTIPLE   (0x40000000u)
#define GPMC_CONFIG1_6_READMULTIPLE_SHIFT   (0x0000001Eu)
#define GPMC_CONFIG1_6_READMULTIPLE_RDMULTIPLE   (0x1u)
#define GPMC_CONFIG1_6_READMULTIPLE_RDSINGLE   (0x0u)

#define GPMC_CONFIG1_6_READTYPE   (0x20000000u)
#define GPMC_CONFIG1_6_READTYPE_SHIFT   (0x0000001Du)
#define GPMC_CONFIG1_6_READTYPE_RDASYNC   (0x0u)
#define GPMC_CONFIG1_6_READTYPE_RDSYNC   (0x1u)

#define GPMC_CONFIG1_6_TIMEPARAGRANULARITY   (0x00000010u)
#define GPMC_CONFIG1_6_TIMEPARAGRANULARITY_SHIFT   (0x00000004u)
#define GPMC_CONFIG1_6_TIMEPARAGRANULARITY_X1   (0x0u)
#define GPMC_CONFIG1_6_TIMEPARAGRANULARITY_X2   (0x1u)

#define GPMC_CONFIG1_6_WAITMONITORINGTIME   (0x000C0000u)
#define GPMC_CONFIG1_6_WAITMONITORINGTIME_SHIFT   (0x00000012u)
#define GPMC_CONFIG1_6_WAITMONITORINGTIME_ATVALID   (0x0u)
#define GPMC_CONFIG1_6_WAITMONITORINGTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_6_WAITMONITORINGTIME_ONEDEVICEB4   (0x1u)
#define GPMC_CONFIG1_6_WAITMONITORINGTIME_TWODEVICEB4   (0x2u)

#define GPMC_CONFIG1_6_WAITPINSELECT   (0x00030000u)
#define GPMC_CONFIG1_6_WAITPINSELECT_SHIFT   (0x00000010u)
#define GPMC_CONFIG1_6_WAITPINSELECT_RESERVED   (0x3u)
#define GPMC_CONFIG1_6_WAITPINSELECT_W0   (0x0u)
#define GPMC_CONFIG1_6_WAITPINSELECT_W1   (0x1u)
#define GPMC_CONFIG1_6_WAITPINSELECT_W2   (0x2u)

#define GPMC_CONFIG1_6_WAITREADMONITORING   (0x00400000u)
#define GPMC_CONFIG1_6_WAITREADMONITORING_SHIFT   (0x00000016u)
#define GPMC_CONFIG1_6_WAITREADMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_6_WAITREADMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_6_WAITWRITEMONITORING   (0x00200000u)
#define GPMC_CONFIG1_6_WAITWRITEMONITORING_SHIFT   (0x00000015u)
#define GPMC_CONFIG1_6_WAITWRITEMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_6_WAITWRITEMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_6_WRAPBURST   (0x80000000u)
#define GPMC_CONFIG1_6_WRAPBURST_SHIFT   (0x0000001Fu)
#define GPMC_CONFIG1_6_WRAPBURST_WRAPNOTSUPP   (0x0u)
#define GPMC_CONFIG1_6_WRAPBURST_WRAPSUPP   (0x1u)

#define GPMC_CONFIG1_6_WRITEMULTIPLE   (0x10000000u)
#define GPMC_CONFIG1_6_WRITEMULTIPLE_SHIFT   (0x0000001Cu)
#define GPMC_CONFIG1_6_WRITEMULTIPLE_WRMULTIPLE   (0x1u)
#define GPMC_CONFIG1_6_WRITEMULTIPLE_WRSINGLE   (0x0u)

#define GPMC_CONFIG1_6_WRITETYPE   (0x08000000u)
#define GPMC_CONFIG1_6_WRITETYPE_SHIFT   (0x0000001Bu)
#define GPMC_CONFIG1_6_WRITETYPE_WRASYNC   (0x0u)
#define GPMC_CONFIG1_6_WRITETYPE_WRSYNC   (0x1u)


/* CONFIG2_6 */
#define GPMC_CONFIG2_6_CSEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG2_6_CSEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG2_6_CSEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG2_6_CSEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG2_6_CSONTIME   (0x0000000Fu)
#define GPMC_CONFIG2_6_CSONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG2_6_CSRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG2_6_CSRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG2_6_CSWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG2_6_CSWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG3_6 */
#define GPMC_CONFIG3_6_ADVAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG3_6_ADVAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG3_6_ADVAADMUXRDOFFTIME   (0x07000000u)
#define GPMC_CONFIG3_6_ADVAADMUXRDOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG3_6_ADVAADMUXWROFFTIME   (0x70000000u)
#define GPMC_CONFIG3_6_ADVAADMUXWROFFTIME_SHIFT   (0x0000001Cu)

#define GPMC_CONFIG3_6_ADVEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG3_6_ADVEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG3_6_ADVEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG3_6_ADVEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG3_6_ADVONTIME   (0x0000000Fu)
#define GPMC_CONFIG3_6_ADVONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG3_6_ADVRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG3_6_ADVRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG3_6_ADVWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG3_6_ADVWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG4_6 */
#define GPMC_CONFIG4_6_OEAADMUXOFFTIME   (0x0000E000u)
#define GPMC_CONFIG4_6_OEAADMUXOFFTIME_SHIFT   (0x0000000Du)

#define GPMC_CONFIG4_6_OEAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG4_6_OEAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG4_6_OEEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG4_6_OEEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG4_6_OEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_6_OEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_6_OEOFFTIME   (0x00001F00u)
#define GPMC_CONFIG4_6_OEOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG4_6_OEONTIME   (0x0000000Fu)
#define GPMC_CONFIG4_6_OEONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG4_6_WEEXTRADELAY   (0x00800000u)
#define GPMC_CONFIG4_6_WEEXTRADELAY_SHIFT   (0x00000017u)
#define GPMC_CONFIG4_6_WEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_6_WEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_6_WEOFFTIME   (0x1F000000u)
#define GPMC_CONFIG4_6_WEOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG4_6_WEONTIME   (0x000F0000u)
#define GPMC_CONFIG4_6_WEONTIME_SHIFT   (0x00000010u)


/* CONFIG5_6 */
#define GPMC_CONFIG5_6_PAGEBURSTACCESSTIME   (0x0F000000u)
#define GPMC_CONFIG5_6_PAGEBURSTACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG5_6_RDACCESSTIME   (0x001F0000u)
#define GPMC_CONFIG5_6_RDACCESSTIME_SHIFT   (0x00000010u)

#define GPMC_CONFIG5_6_RDCYCLETIME   (0x0000001Fu)
#define GPMC_CONFIG5_6_RDCYCLETIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG5_6_WRCYCLETIME   (0x00001F00u)
#define GPMC_CONFIG5_6_WRCYCLETIME_SHIFT   (0x00000008u)


/* CONFIG6_6 */
#define GPMC_CONFIG6_6_BUSTURNAROUND   (0x0000000Fu)
#define GPMC_CONFIG6_6_BUSTURNAROUND_SHIFT   (0x00000000u)

#define GPMC_CONFIG6_6_CYCLE2CYCLEDELAY   (0x00000F00u)
#define GPMC_CONFIG6_6_CYCLE2CYCLEDELAY_SHIFT   (0x00000008u)

#define GPMC_CONFIG6_6_CYCLE2CYCLEDIFFCSEN   (0x00000040u)
#define GPMC_CONFIG6_6_CYCLE2CYCLEDIFFCSEN_SHIFT   (0x00000006u)
#define GPMC_CONFIG6_6_CYCLE2CYCLEDIFFCSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_6_CYCLE2CYCLEDIFFCSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_6_CYCLE2CYCLESAMECSEN   (0x00000080u)
#define GPMC_CONFIG6_6_CYCLE2CYCLESAMECSEN_SHIFT   (0x00000007u)
#define GPMC_CONFIG6_6_CYCLE2CYCLESAMECSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_6_CYCLE2CYCLESAMECSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_6_WRACCESSTIME   (0x1F000000u)
#define GPMC_CONFIG6_6_WRACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG6_6_WRDATAONADMUXBUS   (0x000F0000u)
#define GPMC_CONFIG6_6_WRDATAONADMUXBUS_SHIFT   (0x00000010u)


/* CONFIG7_6 */
#define GPMC_CONFIG7_6_BASEADDRESS   (0x0000003Fu)
#define GPMC_CONFIG7_6_BASEADDRESS_SHIFT   (0x00000000u)

#define GPMC_CONFIG7_6_CSVALID   (0x00000040u)
#define GPMC_CONFIG7_6_CSVALID_SHIFT   (0x00000006u)
#define GPMC_CONFIG7_6_CSVALID_CSDISABLED   (0x0u)
#define GPMC_CONFIG7_6_CSVALID_CSENABLED   (0x1u)

#define GPMC_CONFIG7_6_MASKADDRESS   (0x00000F00u)
#define GPMC_CONFIG7_6_MASKADDRESS_SHIFT   (0x00000008u)


/* NAND_COMMAND_6 */
#define GPMC_NAND_COMMAND_6_GPMC_NAND_COMMAND_6   (0xFFFFFFFFu)
#define GPMC_NAND_COMMAND_6_GPMC_NAND_COMMAND_6_SHIFT   (0x00000000u)


/* NAND_ADDRESS_6 */
#define GPMC_NAND_ADDRESS_6_GPMC_NAND_ADDRESS_6   (0xFFFFFFFFu)
#define GPMC_NAND_ADDRESS_6_GPMC_NAND_ADDRESS_6_SHIFT   (0x00000000u)


/* NAND_DATA_6 */
#define GPMC_NAND_DATA_6_GPMC_NAND_DATA_6   (0xFFFFFFFFu)
#define GPMC_NAND_DATA_6_GPMC_NAND_DATA_6_SHIFT   (0x00000000u)


/* CONFIG1_7 */
#define GPMC_CONFIG1_7_ATTACHEDDEVICEPAGELENGTH   (0x01800000u)
#define GPMC_CONFIG1_7_ATTACHEDDEVICEPAGELENGTH_SHIFT   (0x00000017u)
#define GPMC_CONFIG1_7_ATTACHEDDEVICEPAGELENGTH_EIGHT   (0x1u)
#define GPMC_CONFIG1_7_ATTACHEDDEVICEPAGELENGTH_FOUR   (0x0u)
#define GPMC_CONFIG1_7_ATTACHEDDEVICEPAGELENGTH_RESERVED   (0x3u)
#define GPMC_CONFIG1_7_ATTACHEDDEVICEPAGELENGTH_SIXTEEN   (0x2u)

#define GPMC_CONFIG1_7_CLKACTIVATIONTIME   (0x06000000u)
#define GPMC_CONFIG1_7_CLKACTIVATIONTIME_SHIFT   (0x00000019u)
#define GPMC_CONFIG1_7_CLKACTIVATIONTIME_ATSTART   (0x0u)
#define GPMC_CONFIG1_7_CLKACTIVATIONTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_7_CLKACTIVATIONTIME_ONECLKB4   (0x1u)
#define GPMC_CONFIG1_7_CLKACTIVATIONTIME_TWOCLKB4   (0x2u)

#define GPMC_CONFIG1_7_DEVICESIZE   (0x00003000u)
#define GPMC_CONFIG1_7_DEVICESIZE_SHIFT   (0x0000000Cu)
#define GPMC_CONFIG1_7_DEVICESIZE_EIGHTBITS   (0x0u)
#define GPMC_CONFIG1_7_DEVICESIZE_RES   (0x3u)
#define GPMC_CONFIG1_7_DEVICESIZE_RESERVED   (0x2u)
#define GPMC_CONFIG1_7_DEVICESIZE_SIXTEENBITS   (0x1u)

#define GPMC_CONFIG1_7_DEVICETYPE   (0x00000C00u)
#define GPMC_CONFIG1_7_DEVICETYPE_SHIFT   (0x0000000Au)
#define GPMC_CONFIG1_7_DEVICETYPE_NANDLIKE   (0x2u)
#define GPMC_CONFIG1_7_DEVICETYPE_NORLIKE   (0x0u)
#define GPMC_CONFIG1_7_DEVICETYPE_RES1   (0x1u)
#define GPMC_CONFIG1_7_DEVICETYPE_RES2   (0x3u)

#define GPMC_CONFIG1_7_GPMCFCLKDIVIDER   (0x00000003u)
#define GPMC_CONFIG1_7_GPMCFCLKDIVIDER_SHIFT   (0x00000000u)
#define GPMC_CONFIG1_7_GPMCFCLKDIVIDER_DIVBY1   (0x0u)
#define GPMC_CONFIG1_7_GPMCFCLKDIVIDER_DIVBY2   (0x1u)
#define GPMC_CONFIG1_7_GPMCFCLKDIVIDER_DIVBY3   (0x2u)
#define GPMC_CONFIG1_7_GPMCFCLKDIVIDER_DIVBY4   (0x3u)

#define GPMC_CONFIG1_7_MUXADDDATA   (0x00000300u)
#define GPMC_CONFIG1_7_MUXADDDATA_SHIFT   (0x00000008u)
#define GPMC_CONFIG1_7_MUXADDDATA_AADMUX   (0x1u)
#define GPMC_CONFIG1_7_MUXADDDATA_MUX   (0x2u)
#define GPMC_CONFIG1_7_MUXADDDATA_NONMUX   (0x0u)
#define GPMC_CONFIG1_7_MUXADDDATA_RESERVED   (0x3u)

#define GPMC_CONFIG1_7_READMULTIPLE   (0x40000000u)
#define GPMC_CONFIG1_7_READMULTIPLE_SHIFT   (0x0000001Eu)
#define GPMC_CONFIG1_7_READMULTIPLE_RDMULTIPLE   (0x1u)
#define GPMC_CONFIG1_7_READMULTIPLE_RDSINGLE   (0x0u)

#define GPMC_CONFIG1_7_READTYPE   (0x20000000u)
#define GPMC_CONFIG1_7_READTYPE_SHIFT   (0x0000001Du)
#define GPMC_CONFIG1_7_READTYPE_RDASYNC   (0x0u)
#define GPMC_CONFIG1_7_READTYPE_RDSYNC   (0x1u)

#define GPMC_CONFIG1_7_TIMEPARAGRANULARITY   (0x00000010u)
#define GPMC_CONFIG1_7_TIMEPARAGRANULARITY_SHIFT   (0x00000004u)
#define GPMC_CONFIG1_7_TIMEPARAGRANULARITY_X1   (0x0u)
#define GPMC_CONFIG1_7_TIMEPARAGRANULARITY_X2   (0x1u)

#define GPMC_CONFIG1_7_WAITMONITORINGTIME   (0x000C0000u)
#define GPMC_CONFIG1_7_WAITMONITORINGTIME_SHIFT   (0x00000012u)
#define GPMC_CONFIG1_7_WAITMONITORINGTIME_ATVALID   (0x0u)
#define GPMC_CONFIG1_7_WAITMONITORINGTIME_NOTDEFINED   (0x3u)
#define GPMC_CONFIG1_7_WAITMONITORINGTIME_ONEDEVICEB4   (0x1u)
#define GPMC_CONFIG1_7_WAITMONITORINGTIME_TWODEVICEB4   (0x2u)

#define GPMC_CONFIG1_7_WAITPINSELECT   (0x00030000u)
#define GPMC_CONFIG1_7_WAITPINSELECT_SHIFT   (0x00000010u)
#define GPMC_CONFIG1_7_WAITPINSELECT_RESERVED   (0x3u)
#define GPMC_CONFIG1_7_WAITPINSELECT_W0   (0x0u)
#define GPMC_CONFIG1_7_WAITPINSELECT_W1   (0x1u)
#define GPMC_CONFIG1_7_WAITPINSELECT_W2   (0x2u)

#define GPMC_CONFIG1_7_WAITREADMONITORING   (0x00400000u)
#define GPMC_CONFIG1_7_WAITREADMONITORING_SHIFT   (0x00000016u)
#define GPMC_CONFIG1_7_WAITREADMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_7_WAITREADMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_7_WAITWRITEMONITORING   (0x00200000u)
#define GPMC_CONFIG1_7_WAITWRITEMONITORING_SHIFT   (0x00000015u)
#define GPMC_CONFIG1_7_WAITWRITEMONITORING_WMONIT   (0x1u)
#define GPMC_CONFIG1_7_WAITWRITEMONITORING_WNOTMONIT   (0x0u)

#define GPMC_CONFIG1_7_WRAPBURST   (0x80000000u)
#define GPMC_CONFIG1_7_WRAPBURST_SHIFT   (0x0000001Fu)
#define GPMC_CONFIG1_7_WRAPBURST_WRAPNOTSUPP   (0x0u)
#define GPMC_CONFIG1_7_WRAPBURST_WRAPSUPP   (0x1u)

#define GPMC_CONFIG1_7_WRITEMULTIPLE   (0x10000000u)
#define GPMC_CONFIG1_7_WRITEMULTIPLE_SHIFT   (0x0000001Cu)
#define GPMC_CONFIG1_7_WRITEMULTIPLE_WRMULTIPLE   (0x1u)
#define GPMC_CONFIG1_7_WRITEMULTIPLE_WRSINGLE   (0x0u)

#define GPMC_CONFIG1_7_WRITETYPE   (0x08000000u)
#define GPMC_CONFIG1_7_WRITETYPE_SHIFT   (0x0000001Bu)
#define GPMC_CONFIG1_7_WRITETYPE_WRASYNC   (0x0u)
#define GPMC_CONFIG1_7_WRITETYPE_WRSYNC   (0x1u)


/* CONFIG2_7 */
#define GPMC_CONFIG2_7_CSEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG2_7_CSEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG2_7_CSEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG2_7_CSEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG2_7_CSONTIME   (0x0000000Fu)
#define GPMC_CONFIG2_7_CSONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG2_7_CSRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG2_7_CSRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG2_7_CSWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG2_7_CSWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG3_7 */
#define GPMC_CONFIG3_7_ADVAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG3_7_ADVAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG3_7_ADVAADMUXRDOFFTIME   (0x07000000u)
#define GPMC_CONFIG3_7_ADVAADMUXRDOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG3_7_ADVAADMUXWROFFTIME   (0x70000000u)
#define GPMC_CONFIG3_7_ADVAADMUXWROFFTIME_SHIFT   (0x0000001Cu)

#define GPMC_CONFIG3_7_ADVEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG3_7_ADVEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG3_7_ADVEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG3_7_ADVEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG3_7_ADVONTIME   (0x0000000Fu)
#define GPMC_CONFIG3_7_ADVONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG3_7_ADVRDOFFTIME   (0x00001F00u)
#define GPMC_CONFIG3_7_ADVRDOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG3_7_ADVWROFFTIME   (0x001F0000u)
#define GPMC_CONFIG3_7_ADVWROFFTIME_SHIFT   (0x00000010u)


/* CONFIG4_7 */
#define GPMC_CONFIG4_7_OEAADMUXOFFTIME   (0x0000E000u)
#define GPMC_CONFIG4_7_OEAADMUXOFFTIME_SHIFT   (0x0000000Du)

#define GPMC_CONFIG4_7_OEAADMUXONTIME   (0x00000070u)
#define GPMC_CONFIG4_7_OEAADMUXONTIME_SHIFT   (0x00000004u)

#define GPMC_CONFIG4_7_OEEXTRADELAY   (0x00000080u)
#define GPMC_CONFIG4_7_OEEXTRADELAY_SHIFT   (0x00000007u)
#define GPMC_CONFIG4_7_OEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_7_OEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_7_OEOFFTIME   (0x00001F00u)
#define GPMC_CONFIG4_7_OEOFFTIME_SHIFT   (0x00000008u)

#define GPMC_CONFIG4_7_OEONTIME   (0x0000000Fu)
#define GPMC_CONFIG4_7_OEONTIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG4_7_WEEXTRADELAY   (0x00800000u)
#define GPMC_CONFIG4_7_WEEXTRADELAY_SHIFT   (0x00000017u)
#define GPMC_CONFIG4_7_WEEXTRADELAY_DELAYED   (0x1u)
#define GPMC_CONFIG4_7_WEEXTRADELAY_NOTDELAYED   (0x0u)

#define GPMC_CONFIG4_7_WEOFFTIME   (0x1F000000u)
#define GPMC_CONFIG4_7_WEOFFTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG4_7_WEONTIME   (0x000F0000u)
#define GPMC_CONFIG4_7_WEONTIME_SHIFT   (0x00000010u)


/* CONFIG5_7 */
#define GPMC_CONFIG5_7_PAGEBURSTACCESSTIME   (0x0F000000u)
#define GPMC_CONFIG5_7_PAGEBURSTACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG5_7_RDACCESSTIME   (0x001F0000u)
#define GPMC_CONFIG5_7_RDACCESSTIME_SHIFT   (0x00000010u)

#define GPMC_CONFIG5_7_RDCYCLETIME   (0x0000001Fu)
#define GPMC_CONFIG5_7_RDCYCLETIME_SHIFT   (0x00000000u)

#define GPMC_CONFIG5_7_WRCYCLETIME   (0x00001F00u)
#define GPMC_CONFIG5_7_WRCYCLETIME_SHIFT   (0x00000008u)


/* CONFIG6_7 */
#define GPMC_CONFIG6_7_BUSTURNAROUND   (0x0000000Fu)
#define GPMC_CONFIG6_7_BUSTURNAROUND_SHIFT   (0x00000000u)

#define GPMC_CONFIG6_7_CYCLE2CYCLEDELAY   (0x00000F00u)
#define GPMC_CONFIG6_7_CYCLE2CYCLEDELAY_SHIFT   (0x00000008u)

#define GPMC_CONFIG6_7_CYCLE2CYCLEDIFFCSEN   (0x00000040u)
#define GPMC_CONFIG6_7_CYCLE2CYCLEDIFFCSEN_SHIFT   (0x00000006u)
#define GPMC_CONFIG6_7_CYCLE2CYCLEDIFFCSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_7_CYCLE2CYCLEDIFFCSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_7_CYCLE2CYCLESAMECSEN   (0x00000080u)
#define GPMC_CONFIG6_7_CYCLE2CYCLESAMECSEN_SHIFT   (0x00000007u)
#define GPMC_CONFIG6_7_CYCLE2CYCLESAMECSEN_C2CDELAY   (0x1u)
#define GPMC_CONFIG6_7_CYCLE2CYCLESAMECSEN_NOC2CDELAY   (0x0u)

#define GPMC_CONFIG6_7_WRACCESSTIME   (0x1F000000u)
#define GPMC_CONFIG6_7_WRACCESSTIME_SHIFT   (0x00000018u)

#define GPMC_CONFIG6_7_WRDATAONADMUXBUS   (0x000F0000u)
#define GPMC_CONFIG6_7_WRDATAONADMUXBUS_SHIFT   (0x00000010u)


/* CONFIG7_7 */
#define GPMC_CONFIG7_7_BASEADDRESS   (0x0000003Fu)
#define GPMC_CONFIG7_7_BASEADDRESS_SHIFT   (0x00000000u)

#define GPMC_CONFIG7_7_CSVALID   (0x00000040u)
#define GPMC_CONFIG7_7_CSVALID_SHIFT   (0x00000006u)
#define GPMC_CONFIG7_7_CSVALID_CSDISABLED   (0x0u)
#define GPMC_CONFIG7_7_CSVALID_CSENABLED   (0x1u)

#define GPMC_CONFIG7_7_MASKADDRESS   (0x00000F00u)
#define GPMC_CONFIG7_7_MASKADDRESS_SHIFT   (0x00000008u)


/* NAND_COMMAND_7 */
#define GPMC_NAND_COMMAND_7_GPMC_NAND_COMMAND_7   (0xFFFFFFFFu)
#define GPMC_NAND_COMMAND_7_GPMC_NAND_COMMAND_7_SHIFT   (0x00000000u)


/* NAND_ADDRESS_7 */
#define GPMC_NAND_ADDRESS_7_GPMC_NAND_ADDRESS_7   (0xFFFFFFFFu)
#define GPMC_NAND_ADDRESS_7_GPMC_NAND_ADDRESS_7_SHIFT   (0x00000000u)


/* NAND_DATA_7 */
#define GPMC_NAND_DATA_7_GPMC_NAND_DATA_7   (0xFFFFFFFFu)
#define GPMC_NAND_DATA_7_GPMC_NAND_DATA_7_SHIFT   (0x00000000u)


/* PREFETCH_CONFIG1 */
#define GPMC_PREFETCH_CONFIG1_ACCESSMODE   (0x00000001u)
#define GPMC_PREFETCH_CONFIG1_ACCESSMODE_SHIFT   (0x00000000u)
#define GPMC_PREFETCH_CONFIG1_ACCESSMODE_PREFETCHREAD   (0x0u)
#define GPMC_PREFETCH_CONFIG1_ACCESSMODE_PREFETCH_READ   (0x0u)
#define GPMC_PREFETCH_CONFIG1_ACCESSMODE_WRITEPOSTING   (0x1u)
#define GPMC_PREFETCH_CONFIG1_ACCESSMODE_WRITE_POST   (0x1u)

#define GPMC_PREFETCH_CONFIG1_CYCLEOPTIMIZATION   (0x70000000u)
#define GPMC_PREFETCH_CONFIG1_CYCLEOPTIMIZATION_SHIFT   (0x0000001Cu)

#define GPMC_PREFETCH_CONFIG1_DMAMODE   (0x00000004u)
#define GPMC_PREFETCH_CONFIG1_DMAMODE_SHIFT   (0x00000002u)
#define GPMC_PREFETCH_CONFIG1_DMAMODE_DMAENABLED   (0x1u)
#define GPMC_PREFETCH_CONFIG1_DMAMODE_DMAREQSYNC   (0x1u)
#define GPMC_PREFETCH_CONFIG1_DMAMODE_INTERRUPTSYNC   (0x0u)
#define GPMC_PREFETCH_CONFIG1_DMAMODE_NODMA   (0x0u)

#define GPMC_PREFETCH_CONFIG1_ENABLEENGINE   (0x00000080u)
#define GPMC_PREFETCH_CONFIG1_ENABLEENGINE_SHIFT   (0x00000007u)
#define GPMC_PREFETCH_CONFIG1_ENABLEENGINE_DISABLED   (0x0u)
#define GPMC_PREFETCH_CONFIG1_ENABLEENGINE_ENABLED   (0x1u)
#define GPMC_PREFETCH_CONFIG1_ENABLEENGINE_PPDISABLED   (0x0u)
#define GPMC_PREFETCH_CONFIG1_ENABLEENGINE_PPENABLED   (0x1u)

#define GPMC_PREFETCH_CONFIG1_ENABLEOPTIMIZEDACCESS   (0x08000000u)
#define GPMC_PREFETCH_CONFIG1_ENABLEOPTIMIZEDACCESS_SHIFT   (0x0000001Bu)
#define GPMC_PREFETCH_CONFIG1_ENABLEOPTIMIZEDACCESS_DISABLED   (0x0u)
#define GPMC_PREFETCH_CONFIG1_ENABLEOPTIMIZEDACCESS_ENABLED   (0x1u)
#define GPMC_PREFETCH_CONFIG1_ENABLEOPTIMIZEDACCESS_OPTDISABLED   (0x0u)
#define GPMC_PREFETCH_CONFIG1_ENABLEOPTIMIZEDACCESS_OPTENABLED   (0x1u)

#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR   (0x07000000u)
#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR_SHIFT   (0x00000018u)
#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR_CS0   (0x0u)
#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR_CS1   (0x1u)
#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR_CS2   (0x2u)
#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR_CS3   (0x3u)
#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR_CS4   (0x4u)
#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR_CS5   (0x5u)
#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR_CS6   (0x6u)
#define GPMC_PREFETCH_CONFIG1_ENGINECSSELECTOR_CS7   (0x7u)

#define GPMC_PREFETCH_CONFIG1_FIFOTHRESHOLD   (0x00007F00u)
#define GPMC_PREFETCH_CONFIG1_FIFOTHRESHOLD_SHIFT   (0x00000008u)

#define GPMC_PREFETCH_CONFIG1_PFPWENROUNDROBIN   (0x00800000u)
#define GPMC_PREFETCH_CONFIG1_PFPWENROUNDROBIN_SHIFT   (0x00000017u)
#define GPMC_PREFETCH_CONFIG1_PFPWENROUNDROBIN_DISABLED   (0x0u)
#define GPMC_PREFETCH_CONFIG1_PFPWENROUNDROBIN_ENABLED   (0x1u)
#define GPMC_PREFETCH_CONFIG1_PFPWENROUNDROBIN_RRDISABLED   (0x0u)
#define GPMC_PREFETCH_CONFIG1_PFPWENROUNDROBIN_RRENABLED   (0x1u)

#define GPMC_PREFETCH_CONFIG1_PFPWWEIGHTEDPRIO   (0x000F0000u)
#define GPMC_PREFETCH_CONFIG1_PFPWWEIGHTEDPRIO_SHIFT   (0x00000010u)

#define GPMC_PREFETCH_CONFIG1_SYNCHROMODE   (0x00000008u)
#define GPMC_PREFETCH_CONFIG1_SYNCHROMODE_SHIFT   (0x00000003u)
#define GPMC_PREFETCH_CONFIG1_SYNCHROMODE_ATSTART   (0x0u)
#define GPMC_PREFETCH_CONFIG1_SYNCHROMODE_ATSTARTANDWAIT   (0x1u)

#define GPMC_PREFETCH_CONFIG1_WAITPINSELECTOR   (0x00000030u)
#define GPMC_PREFETCH_CONFIG1_WAITPINSELECTOR_SHIFT   (0x00000004u)
#define GPMC_PREFETCH_CONFIG1_WAITPINSELECTOR_W0   (0x0u)
#define GPMC_PREFETCH_CONFIG1_WAITPINSELECTOR_W1   (0x1u)
#define GPMC_PREFETCH_CONFIG1_WAITPINSELECTOR_W2   (0x2u)
#define GPMC_PREFETCH_CONFIG1_WAITPINSELECTOR_W3   (0x3u)
#define GPMC_PREFETCH_CONFIG1_WAITPINSELECTOR_WAIT0   (0x0u)
#define GPMC_PREFETCH_CONFIG1_WAITPINSELECTOR_WAIT1   (0x1u)
#define GPMC_PREFETCH_CONFIG1_WAITPINSELECTOR_WAIT2   (0x2u)


/* PREFETCH_CONFIG2 */
#define GPMC_PREFETCH_CONFIG2_TRANSFERCOUNT   (0x00003FFFu)
#define GPMC_PREFETCH_CONFIG2_TRANSFERCOUNT_SHIFT   (0x00000000u)


/* PREFETCH_CONTROL */
#define GPMC_PREFETCH_CONTROL_STARTENGINE   (0x00000001u)
#define GPMC_PREFETCH_CONTROL_STARTENGINE_SHIFT   (0x00000000u)
#define GPMC_PREFETCH_CONTROL_STARTENGINE_RUNNING   (0x1u)
#define GPMC_PREFETCH_CONTROL_STARTENGINE_START   (0x1u)
#define GPMC_PREFETCH_CONTROL_STARTENGINE_STOP   (0x0u)
#define GPMC_PREFETCH_CONTROL_STARTENGINE_STOPPED   (0x0u)


/* PREFETCH_STATUS */
#define GPMC_PREFETCH_STATUS_COUNTVALUE   (0x00003FFFu)
#define GPMC_PREFETCH_STATUS_COUNTVALUE_SHIFT   (0x00000000u)

#define GPMC_PREFETCH_STATUS_FIFOPOINTER   (0x7F000000u)
#define GPMC_PREFETCH_STATUS_FIFOPOINTER_SHIFT   (0x00000018u)

#define GPMC_PREFETCH_STATUS_FIFOTHRESHOLDSTATUS   (0x00010000u)
#define GPMC_PREFETCH_STATUS_FIFOTHRESHOLDSTATUS_SHIFT   (0x00000010u)
#define GPMC_PREFETCH_STATUS_FIFOTHRESHOLDSTATUS_GREATERTHANTHRES   (0x1u)
#define GPMC_PREFETCH_STATUS_FIFOTHRESHOLDSTATUS_SMALLERTHANTHRES   (0x0u)


/* ECC_CONFIG */
#define GPMC_ECC_CONFIG_ECC16B   (0x00000080u)
#define GPMC_ECC_CONFIG_ECC16B_SHIFT   (0x00000007u)
#define GPMC_ECC_CONFIG_ECC16B_EIGHTCOL   (0x0u)
#define GPMC_ECC_CONFIG_ECC16B_SIXTEENCOL   (0x1u)

#define GPMC_ECC_CONFIG_ECCALGORITHM   (0x00010000u)
#define GPMC_ECC_CONFIG_ECCALGORITHM_SHIFT   (0x00000010u)
#define GPMC_ECC_CONFIG_ECCALGORITHM_BCH_CODE   (0x1u)
#define GPMC_ECC_CONFIG_ECCALGORITHM_HAMMING_CODE   (0x0u)

#define GPMC_ECC_CONFIG_ECCBCHTSEL   (0x00003000u)
#define GPMC_ECC_CONFIG_ECCBCHTSEL_SHIFT   (0x0000000Cu)
#define GPMC_ECC_CONFIG_ECCBCHTSEL_UPTO_16BITS   (0x2u)
#define GPMC_ECC_CONFIG_ECCBCHTSEL_UPTO_4BITS   (0x0u)
#define GPMC_ECC_CONFIG_ECCBCHTSEL_UPTO_8BITS   (0x1u)

#define GPMC_ECC_CONFIG_ECCCS   (0x0000000Eu)
#define GPMC_ECC_CONFIG_ECCCS_SHIFT   (0x00000001u)
#define GPMC_ECC_CONFIG_ECCCS_CS0   (0x0u)
#define GPMC_ECC_CONFIG_ECCCS_CS1   (0x1u)
#define GPMC_ECC_CONFIG_ECCCS_CS2   (0x2u)
#define GPMC_ECC_CONFIG_ECCCS_CS3   (0x3u)
#define GPMC_ECC_CONFIG_ECCCS_CS4   (0x4u)
#define GPMC_ECC_CONFIG_ECCCS_CS5   (0x5u)
#define GPMC_ECC_CONFIG_ECCCS_CS6   (0x6u)
#define GPMC_ECC_CONFIG_ECCCS_CS7   (0x7u)

#define GPMC_ECC_CONFIG_ECCENABLE   (0x00000001u)
#define GPMC_ECC_CONFIG_ECCENABLE_SHIFT   (0x00000000u)
#define GPMC_ECC_CONFIG_ECCENABLE_ECCDISABLED   (0x0u)
#define GPMC_ECC_CONFIG_ECCENABLE_ECCENABLED   (0x1u)

#define GPMC_ECC_CONFIG_ECCTOPSECTOR   (0x00000070u)
#define GPMC_ECC_CONFIG_ECCTOPSECTOR_SHIFT   (0x00000004u)

#define GPMC_ECC_CONFIG_ECCWRAPMODE   (0x00000F00u)
#define GPMC_ECC_CONFIG_ECCWRAPMODE_SHIFT   (0x00000008u)


/* ECC_CONTROL */
#define GPMC_ECC_CONTROL_ECCCLEAR   (0x00000100u)
#define GPMC_ECC_CONTROL_ECCCLEAR_SHIFT   (0x00000008u)

#define GPMC_ECC_CONTROL_ECCPOINTER   (0x0000000Fu)
#define GPMC_ECC_CONTROL_ECCPOINTER_SHIFT   (0x00000000u)
#define GPMC_ECC_CONTROL_ECCPOINTER_ECCRES1   (0x1u)
#define GPMC_ECC_CONTROL_ECCPOINTER_ECCRES2   (0x2u)
#define GPMC_ECC_CONTROL_ECCPOINTER_ECCRES3   (0x3u)
#define GPMC_ECC_CONTROL_ECCPOINTER_ECCRES4   (0x4u)
#define GPMC_ECC_CONTROL_ECCPOINTER_ECCRES5   (0x5u)
#define GPMC_ECC_CONTROL_ECCPOINTER_ECCRES6   (0x6u)
#define GPMC_ECC_CONTROL_ECCPOINTER_ECCRES7   (0x7u)
#define GPMC_ECC_CONTROL_ECCPOINTER_ECCRES8   (0x8u)
#define GPMC_ECC_CONTROL_ECCPOINTER_ECCRES9   (0x9u)
#define GPMC_ECC_CONTROL_ECCPOINTER_NOEFFECT1   (0x0u)


/* ECC_SIZE_CONFIG */
#define GPMC_ECC_SIZE_CONFIG_ECC1RESULTSIZE   (0x00000001u)
#define GPMC_ECC_SIZE_CONFIG_ECC1RESULTSIZE_SHIFT   (0x00000000u)
#define GPMC_ECC_SIZE_CONFIG_ECC1RESULTSIZE_SIZE0SEL   (0x0u)
#define GPMC_ECC_SIZE_CONFIG_ECC1RESULTSIZE_SIZE1SEL   (0x1u)

#define GPMC_ECC_SIZE_CONFIG_ECC2RESULTSIZE   (0x00000002u)
#define GPMC_ECC_SIZE_CONFIG_ECC2RESULTSIZE_SHIFT   (0x00000001u)
#define GPMC_ECC_SIZE_CONFIG_ECC2RESULTSIZE_SIZE0SEL   (0x0u)
#define GPMC_ECC_SIZE_CONFIG_ECC2RESULTSIZE_SIZE1SEL   (0x1u)

#define GPMC_ECC_SIZE_CONFIG_ECC3RESULTSIZE   (0x00000004u)
#define GPMC_ECC_SIZE_CONFIG_ECC3RESULTSIZE_SHIFT   (0x00000002u)
#define GPMC_ECC_SIZE_CONFIG_ECC3RESULTSIZE_SIZE0SEL   (0x0u)
#define GPMC_ECC_SIZE_CONFIG_ECC3RESULTSIZE_SIZE1SEL   (0x1u)

#define GPMC_ECC_SIZE_CONFIG_ECC4RESULTSIZE   (0x00000008u)
#define GPMC_ECC_SIZE_CONFIG_ECC4RESULTSIZE_SHIFT   (0x00000003u)
#define GPMC_ECC_SIZE_CONFIG_ECC4RESULTSIZE_SIZE0SEL   (0x0u)
#define GPMC_ECC_SIZE_CONFIG_ECC4RESULTSIZE_SIZE1SEL   (0x1u)

#define GPMC_ECC_SIZE_CONFIG_ECC5RESULTSIZE   (0x00000010u)
#define GPMC_ECC_SIZE_CONFIG_ECC5RESULTSIZE_SHIFT   (0x00000004u)
#define GPMC_ECC_SIZE_CONFIG_ECC5RESULTSIZE_SIZE0SEL   (0x0u)
#define GPMC_ECC_SIZE_CONFIG_ECC5RESULTSIZE_SIZE1SEL   (0x1u)

#define GPMC_ECC_SIZE_CONFIG_ECC6RESULTSIZE   (0x00000020u)
#define GPMC_ECC_SIZE_CONFIG_ECC6RESULTSIZE_SHIFT   (0x00000005u)
#define GPMC_ECC_SIZE_CONFIG_ECC6RESULTSIZE_SIZE0SEL   (0x0u)
#define GPMC_ECC_SIZE_CONFIG_ECC6RESULTSIZE_SIZE1SEL   (0x1u)

#define GPMC_ECC_SIZE_CONFIG_ECC7RESULTSIZE   (0x00000040u)
#define GPMC_ECC_SIZE_CONFIG_ECC7RESULTSIZE_SHIFT   (0x00000006u)
#define GPMC_ECC_SIZE_CONFIG_ECC7RESULTSIZE_SIZE0SEL   (0x0u)
#define GPMC_ECC_SIZE_CONFIG_ECC7RESULTSIZE_SIZE1SEL   (0x1u)

#define GPMC_ECC_SIZE_CONFIG_ECC8RESULTSIZE   (0x00000080u)
#define GPMC_ECC_SIZE_CONFIG_ECC8RESULTSIZE_SHIFT   (0x00000007u)
#define GPMC_ECC_SIZE_CONFIG_ECC8RESULTSIZE_SIZE0SEL   (0x0u)
#define GPMC_ECC_SIZE_CONFIG_ECC8RESULTSIZE_SIZE1SEL   (0x1u)

#define GPMC_ECC_SIZE_CONFIG_ECC9RESULTSIZE   (0x00000100u)
#define GPMC_ECC_SIZE_CONFIG_ECC9RESULTSIZE_SHIFT   (0x00000008u)
#define GPMC_ECC_SIZE_CONFIG_ECC9RESULTSIZE_SIZE0SEL   (0x0u)
#define GPMC_ECC_SIZE_CONFIG_ECC9RESULTSIZE_SIZE1SEL   (0x1u)

#define GPMC_ECC_SIZE_CONFIG_ECCSIZE0   (0x000FF000u)
#define GPMC_ECC_SIZE_CONFIG_ECCSIZE0_SHIFT   (0x0000000Cu)

#define GPMC_ECC_SIZE_CONFIG_ECCSIZE1   (0x3FC00000u)
#define GPMC_ECC_SIZE_CONFIG_ECCSIZE1_SHIFT   (0x00000016u)


/* ECC1_RESULT */
#define GPMC_ECC1_RESULT_P1024E   (0x00000400u)
#define GPMC_ECC1_RESULT_P1024E_SHIFT   (0x0000000Au)

#define GPMC_ECC1_RESULT_P1024O   (0x04000000u)
#define GPMC_ECC1_RESULT_P1024O_SHIFT   (0x0000001Au)

#define GPMC_ECC1_RESULT_P128E   (0x00000080u)
#define GPMC_ECC1_RESULT_P128E_SHIFT   (0x00000007u)

#define GPMC_ECC1_RESULT_P128O   (0x00800000u)
#define GPMC_ECC1_RESULT_P128O_SHIFT   (0x00000017u)

#define GPMC_ECC1_RESULT_P16E   (0x00000010u)
#define GPMC_ECC1_RESULT_P16E_SHIFT   (0x00000004u)

#define GPMC_ECC1_RESULT_P16O   (0x00100000u)
#define GPMC_ECC1_RESULT_P16O_SHIFT   (0x00000014u)

#define GPMC_ECC1_RESULT_P1E   (0x00000001u)
#define GPMC_ECC1_RESULT_P1E_SHIFT   (0x00000000u)

#define GPMC_ECC1_RESULT_P1O   (0x00010000u)
#define GPMC_ECC1_RESULT_P1O_SHIFT   (0x00000010u)

#define GPMC_ECC1_RESULT_P2048E   (0x00000800u)
#define GPMC_ECC1_RESULT_P2048E_SHIFT   (0x0000000Bu)

#define GPMC_ECC1_RESULT_P2048O   (0x08000000u)
#define GPMC_ECC1_RESULT_P2048O_SHIFT   (0x0000001Bu)

#define GPMC_ECC1_RESULT_P256E   (0x00000100u)
#define GPMC_ECC1_RESULT_P256E_SHIFT   (0x00000008u)

#define GPMC_ECC1_RESULT_P256O   (0x01000000u)
#define GPMC_ECC1_RESULT_P256O_SHIFT   (0x00000018u)

#define GPMC_ECC1_RESULT_P2E   (0x00000002u)
#define GPMC_ECC1_RESULT_P2E_SHIFT   (0x00000001u)

#define GPMC_ECC1_RESULT_P2O   (0x00020000u)
#define GPMC_ECC1_RESULT_P2O_SHIFT   (0x00000011u)

#define GPMC_ECC1_RESULT_P32E   (0x00000020u)
#define GPMC_ECC1_RESULT_P32E_SHIFT   (0x00000005u)

#define GPMC_ECC1_RESULT_P32O   (0x00200000u)
#define GPMC_ECC1_RESULT_P32O_SHIFT   (0x00000015u)

#define GPMC_ECC1_RESULT_P4E   (0x00000004u)
#define GPMC_ECC1_RESULT_P4E_SHIFT   (0x00000002u)

#define GPMC_ECC1_RESULT_P4O   (0x00040000u)
#define GPMC_ECC1_RESULT_P4O_SHIFT   (0x00000012u)

#define GPMC_ECC1_RESULT_P512E   (0x00000200u)
#define GPMC_ECC1_RESULT_P512E_SHIFT   (0x00000009u)

#define GPMC_ECC1_RESULT_P512O   (0x02000000u)
#define GPMC_ECC1_RESULT_P512O_SHIFT   (0x00000019u)

#define GPMC_ECC1_RESULT_P64E   (0x00000040u)
#define GPMC_ECC1_RESULT_P64E_SHIFT   (0x00000006u)

#define GPMC_ECC1_RESULT_P64O   (0x00400000u)
#define GPMC_ECC1_RESULT_P64O_SHIFT   (0x00000016u)

#define GPMC_ECC1_RESULT_P8E   (0x00000008u)
#define GPMC_ECC1_RESULT_P8E_SHIFT   (0x00000003u)

#define GPMC_ECC1_RESULT_P8O   (0x00080000u)
#define GPMC_ECC1_RESULT_P8O_SHIFT   (0x00000013u)


/* ECC2_RESULT */
#define GPMC_ECC2_RESULT_P1024E   (0x00000400u)
#define GPMC_ECC2_RESULT_P1024E_SHIFT   (0x0000000Au)

#define GPMC_ECC2_RESULT_P1024O   (0x04000000u)
#define GPMC_ECC2_RESULT_P1024O_SHIFT   (0x0000001Au)

#define GPMC_ECC2_RESULT_P128E   (0x00000080u)
#define GPMC_ECC2_RESULT_P128E_SHIFT   (0x00000007u)

#define GPMC_ECC2_RESULT_P128O   (0x00800000u)
#define GPMC_ECC2_RESULT_P128O_SHIFT   (0x00000017u)

#define GPMC_ECC2_RESULT_P16E   (0x00000010u)
#define GPMC_ECC2_RESULT_P16E_SHIFT   (0x00000004u)

#define GPMC_ECC2_RESULT_P16O   (0x00100000u)
#define GPMC_ECC2_RESULT_P16O_SHIFT   (0x00000014u)

#define GPMC_ECC2_RESULT_P1E   (0x00000001u)
#define GPMC_ECC2_RESULT_P1E_SHIFT   (0x00000000u)

#define GPMC_ECC2_RESULT_P1O   (0x00010000u)
#define GPMC_ECC2_RESULT_P1O_SHIFT   (0x00000010u)

#define GPMC_ECC2_RESULT_P2048E   (0x00000800u)
#define GPMC_ECC2_RESULT_P2048E_SHIFT   (0x0000000Bu)

#define GPMC_ECC2_RESULT_P2048O   (0x08000000u)
#define GPMC_ECC2_RESULT_P2048O_SHIFT   (0x0000001Bu)

#define GPMC_ECC2_RESULT_P256E   (0x00000100u)
#define GPMC_ECC2_RESULT_P256E_SHIFT   (0x00000008u)

#define GPMC_ECC2_RESULT_P256O   (0x01000000u)
#define GPMC_ECC2_RESULT_P256O_SHIFT   (0x00000018u)

#define GPMC_ECC2_RESULT_P2E   (0x00000002u)
#define GPMC_ECC2_RESULT_P2E_SHIFT   (0x00000001u)

#define GPMC_ECC2_RESULT_P2O   (0x00020000u)
#define GPMC_ECC2_RESULT_P2O_SHIFT   (0x00000011u)

#define GPMC_ECC2_RESULT_P32E   (0x00000020u)
#define GPMC_ECC2_RESULT_P32E_SHIFT   (0x00000005u)

#define GPMC_ECC2_RESULT_P32O   (0x00200000u)
#define GPMC_ECC2_RESULT_P32O_SHIFT   (0x00000015u)

#define GPMC_ECC2_RESULT_P4E   (0x00000004u)
#define GPMC_ECC2_RESULT_P4E_SHIFT   (0x00000002u)

#define GPMC_ECC2_RESULT_P4O   (0x00040000u)
#define GPMC_ECC2_RESULT_P4O_SHIFT   (0x00000012u)

#define GPMC_ECC2_RESULT_P512E   (0x00000200u)
#define GPMC_ECC2_RESULT_P512E_SHIFT   (0x00000009u)

#define GPMC_ECC2_RESULT_P512O   (0x02000000u)
#define GPMC_ECC2_RESULT_P512O_SHIFT   (0x00000019u)

#define GPMC_ECC2_RESULT_P64E   (0x00000040u)
#define GPMC_ECC2_RESULT_P64E_SHIFT   (0x00000006u)

#define GPMC_ECC2_RESULT_P64O   (0x00400000u)
#define GPMC_ECC2_RESULT_P64O_SHIFT   (0x00000016u)

#define GPMC_ECC2_RESULT_P8E   (0x00000008u)
#define GPMC_ECC2_RESULT_P8E_SHIFT   (0x00000003u)

#define GPMC_ECC2_RESULT_P8O   (0x00080000u)
#define GPMC_ECC2_RESULT_P8O_SHIFT   (0x00000013u)


/* ECC3_RESULT */
#define GPMC_ECC3_RESULT_P1024E   (0x00000400u)
#define GPMC_ECC3_RESULT_P1024E_SHIFT   (0x0000000Au)

#define GPMC_ECC3_RESULT_P1024O   (0x04000000u)
#define GPMC_ECC3_RESULT_P1024O_SHIFT   (0x0000001Au)

#define GPMC_ECC3_RESULT_P128E   (0x00000080u)
#define GPMC_ECC3_RESULT_P128E_SHIFT   (0x00000007u)

#define GPMC_ECC3_RESULT_P128O   (0x00800000u)
#define GPMC_ECC3_RESULT_P128O_SHIFT   (0x00000017u)

#define GPMC_ECC3_RESULT_P16E   (0x00000010u)
#define GPMC_ECC3_RESULT_P16E_SHIFT   (0x00000004u)

#define GPMC_ECC3_RESULT_P16O   (0x00100000u)
#define GPMC_ECC3_RESULT_P16O_SHIFT   (0x00000014u)

#define GPMC_ECC3_RESULT_P1E   (0x00000001u)
#define GPMC_ECC3_RESULT_P1E_SHIFT   (0x00000000u)

#define GPMC_ECC3_RESULT_P1O   (0x00010000u)
#define GPMC_ECC3_RESULT_P1O_SHIFT   (0x00000010u)

#define GPMC_ECC3_RESULT_P2048E   (0x00000800u)
#define GPMC_ECC3_RESULT_P2048E_SHIFT   (0x0000000Bu)

#define GPMC_ECC3_RESULT_P2048O   (0x08000000u)
#define GPMC_ECC3_RESULT_P2048O_SHIFT   (0x0000001Bu)

#define GPMC_ECC3_RESULT_P256E   (0x00000100u)
#define GPMC_ECC3_RESULT_P256E_SHIFT   (0x00000008u)

#define GPMC_ECC3_RESULT_P256O   (0x01000000u)
#define GPMC_ECC3_RESULT_P256O_SHIFT   (0x00000018u)

#define GPMC_ECC3_RESULT_P2E   (0x00000002u)
#define GPMC_ECC3_RESULT_P2E_SHIFT   (0x00000001u)

#define GPMC_ECC3_RESULT_P2O   (0x00020000u)
#define GPMC_ECC3_RESULT_P2O_SHIFT   (0x00000011u)

#define GPMC_ECC3_RESULT_P32E   (0x00000020u)
#define GPMC_ECC3_RESULT_P32E_SHIFT   (0x00000005u)

#define GPMC_ECC3_RESULT_P32O   (0x00200000u)
#define GPMC_ECC3_RESULT_P32O_SHIFT   (0x00000015u)

#define GPMC_ECC3_RESULT_P4E   (0x00000004u)
#define GPMC_ECC3_RESULT_P4E_SHIFT   (0x00000002u)

#define GPMC_ECC3_RESULT_P4O   (0x00040000u)
#define GPMC_ECC3_RESULT_P4O_SHIFT   (0x00000012u)

#define GPMC_ECC3_RESULT_P512E   (0x00000200u)
#define GPMC_ECC3_RESULT_P512E_SHIFT   (0x00000009u)

#define GPMC_ECC3_RESULT_P512O   (0x02000000u)
#define GPMC_ECC3_RESULT_P512O_SHIFT   (0x00000019u)

#define GPMC_ECC3_RESULT_P64E   (0x00000040u)
#define GPMC_ECC3_RESULT_P64E_SHIFT   (0x00000006u)

#define GPMC_ECC3_RESULT_P64O   (0x00400000u)
#define GPMC_ECC3_RESULT_P64O_SHIFT   (0x00000016u)

#define GPMC_ECC3_RESULT_P8E   (0x00000008u)
#define GPMC_ECC3_RESULT_P8E_SHIFT   (0x00000003u)

#define GPMC_ECC3_RESULT_P8O   (0x00080000u)
#define GPMC_ECC3_RESULT_P8O_SHIFT   (0x00000013u)


/* ECC4_RESULT */
#define GPMC_ECC4_RESULT_P1024E   (0x00000400u)
#define GPMC_ECC4_RESULT_P1024E_SHIFT   (0x0000000Au)

#define GPMC_ECC4_RESULT_P1024O   (0x04000000u)
#define GPMC_ECC4_RESULT_P1024O_SHIFT   (0x0000001Au)

#define GPMC_ECC4_RESULT_P128E   (0x00000080u)
#define GPMC_ECC4_RESULT_P128E_SHIFT   (0x00000007u)

#define GPMC_ECC4_RESULT_P128O   (0x00800000u)
#define GPMC_ECC4_RESULT_P128O_SHIFT   (0x00000017u)

#define GPMC_ECC4_RESULT_P16E   (0x00000010u)
#define GPMC_ECC4_RESULT_P16E_SHIFT   (0x00000004u)

#define GPMC_ECC4_RESULT_P16O   (0x00100000u)
#define GPMC_ECC4_RESULT_P16O_SHIFT   (0x00000014u)

#define GPMC_ECC4_RESULT_P1E   (0x00000001u)
#define GPMC_ECC4_RESULT_P1E_SHIFT   (0x00000000u)

#define GPMC_ECC4_RESULT_P1O   (0x00010000u)
#define GPMC_ECC4_RESULT_P1O_SHIFT   (0x00000010u)

#define GPMC_ECC4_RESULT_P2048E   (0x00000800u)
#define GPMC_ECC4_RESULT_P2048E_SHIFT   (0x0000000Bu)

#define GPMC_ECC4_RESULT_P2048O   (0x08000000u)
#define GPMC_ECC4_RESULT_P2048O_SHIFT   (0x0000001Bu)

#define GPMC_ECC4_RESULT_P256E   (0x00000100u)
#define GPMC_ECC4_RESULT_P256E_SHIFT   (0x00000008u)

#define GPMC_ECC4_RESULT_P256O   (0x01000000u)
#define GPMC_ECC4_RESULT_P256O_SHIFT   (0x00000018u)

#define GPMC_ECC4_RESULT_P2E   (0x00000002u)
#define GPMC_ECC4_RESULT_P2E_SHIFT   (0x00000001u)

#define GPMC_ECC4_RESULT_P2O   (0x00020000u)
#define GPMC_ECC4_RESULT_P2O_SHIFT   (0x00000011u)

#define GPMC_ECC4_RESULT_P32E   (0x00000020u)
#define GPMC_ECC4_RESULT_P32E_SHIFT   (0x00000005u)

#define GPMC_ECC4_RESULT_P32O   (0x00200000u)
#define GPMC_ECC4_RESULT_P32O_SHIFT   (0x00000015u)

#define GPMC_ECC4_RESULT_P4E   (0x00000004u)
#define GPMC_ECC4_RESULT_P4E_SHIFT   (0x00000002u)

#define GPMC_ECC4_RESULT_P4O   (0x00040000u)
#define GPMC_ECC4_RESULT_P4O_SHIFT   (0x00000012u)

#define GPMC_ECC4_RESULT_P512E   (0x00000200u)
#define GPMC_ECC4_RESULT_P512E_SHIFT   (0x00000009u)

#define GPMC_ECC4_RESULT_P512O   (0x02000000u)
#define GPMC_ECC4_RESULT_P512O_SHIFT   (0x00000019u)

#define GPMC_ECC4_RESULT_P64E   (0x00000040u)
#define GPMC_ECC4_RESULT_P64E_SHIFT   (0x00000006u)

#define GPMC_ECC4_RESULT_P64O   (0x00400000u)
#define GPMC_ECC4_RESULT_P64O_SHIFT   (0x00000016u)

#define GPMC_ECC4_RESULT_P8E   (0x00000008u)
#define GPMC_ECC4_RESULT_P8E_SHIFT   (0x00000003u)

#define GPMC_ECC4_RESULT_P8O   (0x00080000u)
#define GPMC_ECC4_RESULT_P8O_SHIFT   (0x00000013u)


/* ECC5_RESULT */
#define GPMC_ECC5_RESULT_P1024E   (0x00000400u)
#define GPMC_ECC5_RESULT_P1024E_SHIFT   (0x0000000Au)

#define GPMC_ECC5_RESULT_P1024O   (0x04000000u)
#define GPMC_ECC5_RESULT_P1024O_SHIFT   (0x0000001Au)

#define GPMC_ECC5_RESULT_P128E   (0x00000080u)
#define GPMC_ECC5_RESULT_P128E_SHIFT   (0x00000007u)

#define GPMC_ECC5_RESULT_P128O   (0x00800000u)
#define GPMC_ECC5_RESULT_P128O_SHIFT   (0x00000017u)

#define GPMC_ECC5_RESULT_P16E   (0x00000010u)
#define GPMC_ECC5_RESULT_P16E_SHIFT   (0x00000004u)

#define GPMC_ECC5_RESULT_P16O   (0x00100000u)
#define GPMC_ECC5_RESULT_P16O_SHIFT   (0x00000014u)

#define GPMC_ECC5_RESULT_P1E   (0x00000001u)
#define GPMC_ECC5_RESULT_P1E_SHIFT   (0x00000000u)

#define GPMC_ECC5_RESULT_P1O   (0x00010000u)
#define GPMC_ECC5_RESULT_P1O_SHIFT   (0x00000010u)

#define GPMC_ECC5_RESULT_P2048E   (0x00000800u)
#define GPMC_ECC5_RESULT_P2048E_SHIFT   (0x0000000Bu)

#define GPMC_ECC5_RESULT_P2048O   (0x08000000u)
#define GPMC_ECC5_RESULT_P2048O_SHIFT   (0x0000001Bu)

#define GPMC_ECC5_RESULT_P256E   (0x00000100u)
#define GPMC_ECC5_RESULT_P256E_SHIFT   (0x00000008u)

#define GPMC_ECC5_RESULT_P256O   (0x01000000u)
#define GPMC_ECC5_RESULT_P256O_SHIFT   (0x00000018u)

#define GPMC_ECC5_RESULT_P2E   (0x00000002u)
#define GPMC_ECC5_RESULT_P2E_SHIFT   (0x00000001u)

#define GPMC_ECC5_RESULT_P2O   (0x00020000u)
#define GPMC_ECC5_RESULT_P2O_SHIFT   (0x00000011u)

#define GPMC_ECC5_RESULT_P32E   (0x00000020u)
#define GPMC_ECC5_RESULT_P32E_SHIFT   (0x00000005u)

#define GPMC_ECC5_RESULT_P32O   (0x00200000u)
#define GPMC_ECC5_RESULT_P32O_SHIFT   (0x00000015u)

#define GPMC_ECC5_RESULT_P4E   (0x00000004u)
#define GPMC_ECC5_RESULT_P4E_SHIFT   (0x00000002u)

#define GPMC_ECC5_RESULT_P4O   (0x00040000u)
#define GPMC_ECC5_RESULT_P4O_SHIFT   (0x00000012u)

#define GPMC_ECC5_RESULT_P512E   (0x00000200u)
#define GPMC_ECC5_RESULT_P512E_SHIFT   (0x00000009u)

#define GPMC_ECC5_RESULT_P512O   (0x02000000u)
#define GPMC_ECC5_RESULT_P512O_SHIFT   (0x00000019u)

#define GPMC_ECC5_RESULT_P64E   (0x00000040u)
#define GPMC_ECC5_RESULT_P64E_SHIFT   (0x00000006u)

#define GPMC_ECC5_RESULT_P64O   (0x00400000u)
#define GPMC_ECC5_RESULT_P64O_SHIFT   (0x00000016u)

#define GPMC_ECC5_RESULT_P8E   (0x00000008u)
#define GPMC_ECC5_RESULT_P8E_SHIFT   (0x00000003u)

#define GPMC_ECC5_RESULT_P8O   (0x00080000u)
#define GPMC_ECC5_RESULT_P8O_SHIFT   (0x00000013u)


/* ECC6_RESULT */
#define GPMC_ECC6_RESULT_P1024E   (0x00000400u)
#define GPMC_ECC6_RESULT_P1024E_SHIFT   (0x0000000Au)

#define GPMC_ECC6_RESULT_P1024O   (0x04000000u)
#define GPMC_ECC6_RESULT_P1024O_SHIFT   (0x0000001Au)

#define GPMC_ECC6_RESULT_P128E   (0x00000080u)
#define GPMC_ECC6_RESULT_P128E_SHIFT   (0x00000007u)

#define GPMC_ECC6_RESULT_P128O   (0x00800000u)
#define GPMC_ECC6_RESULT_P128O_SHIFT   (0x00000017u)

#define GPMC_ECC6_RESULT_P16E   (0x00000010u)
#define GPMC_ECC6_RESULT_P16E_SHIFT   (0x00000004u)

#define GPMC_ECC6_RESULT_P16O   (0x00100000u)
#define GPMC_ECC6_RESULT_P16O_SHIFT   (0x00000014u)

#define GPMC_ECC6_RESULT_P1E   (0x00000001u)
#define GPMC_ECC6_RESULT_P1E_SHIFT   (0x00000000u)

#define GPMC_ECC6_RESULT_P1O   (0x00010000u)
#define GPMC_ECC6_RESULT_P1O_SHIFT   (0x00000010u)

#define GPMC_ECC6_RESULT_P2048E   (0x00000800u)
#define GPMC_ECC6_RESULT_P2048E_SHIFT   (0x0000000Bu)

#define GPMC_ECC6_RESULT_P2048O   (0x08000000u)
#define GPMC_ECC6_RESULT_P2048O_SHIFT   (0x0000001Bu)

#define GPMC_ECC6_RESULT_P256E   (0x00000100u)
#define GPMC_ECC6_RESULT_P256E_SHIFT   (0x00000008u)

#define GPMC_ECC6_RESULT_P256O   (0x01000000u)
#define GPMC_ECC6_RESULT_P256O_SHIFT   (0x00000018u)

#define GPMC_ECC6_RESULT_P2E   (0x00000002u)
#define GPMC_ECC6_RESULT_P2E_SHIFT   (0x00000001u)

#define GPMC_ECC6_RESULT_P2O   (0x00020000u)
#define GPMC_ECC6_RESULT_P2O_SHIFT   (0x00000011u)

#define GPMC_ECC6_RESULT_P32E   (0x00000020u)
#define GPMC_ECC6_RESULT_P32E_SHIFT   (0x00000005u)

#define GPMC_ECC6_RESULT_P32O   (0x00200000u)
#define GPMC_ECC6_RESULT_P32O_SHIFT   (0x00000015u)

#define GPMC_ECC6_RESULT_P4E   (0x00000004u)
#define GPMC_ECC6_RESULT_P4E_SHIFT   (0x00000002u)

#define GPMC_ECC6_RESULT_P4O   (0x00040000u)
#define GPMC_ECC6_RESULT_P4O_SHIFT   (0x00000012u)

#define GPMC_ECC6_RESULT_P512E   (0x00000200u)
#define GPMC_ECC6_RESULT_P512E_SHIFT   (0x00000009u)

#define GPMC_ECC6_RESULT_P512O   (0x02000000u)
#define GPMC_ECC6_RESULT_P512O_SHIFT   (0x00000019u)

#define GPMC_ECC6_RESULT_P64E   (0x00000040u)
#define GPMC_ECC6_RESULT_P64E_SHIFT   (0x00000006u)

#define GPMC_ECC6_RESULT_P64O   (0x00400000u)
#define GPMC_ECC6_RESULT_P64O_SHIFT   (0x00000016u)

#define GPMC_ECC6_RESULT_P8E   (0x00000008u)
#define GPMC_ECC6_RESULT_P8E_SHIFT   (0x00000003u)

#define GPMC_ECC6_RESULT_P8O   (0x00080000u)
#define GPMC_ECC6_RESULT_P8O_SHIFT   (0x00000013u)


/* ECC7_RESULT */
#define GPMC_ECC7_RESULT_P1024E   (0x00000400u)
#define GPMC_ECC7_RESULT_P1024E_SHIFT   (0x0000000Au)

#define GPMC_ECC7_RESULT_P1024O   (0x04000000u)
#define GPMC_ECC7_RESULT_P1024O_SHIFT   (0x0000001Au)

#define GPMC_ECC7_RESULT_P128E   (0x00000080u)
#define GPMC_ECC7_RESULT_P128E_SHIFT   (0x00000007u)

#define GPMC_ECC7_RESULT_P128O   (0x00800000u)
#define GPMC_ECC7_RESULT_P128O_SHIFT   (0x00000017u)

#define GPMC_ECC7_RESULT_P16E   (0x00000010u)
#define GPMC_ECC7_RESULT_P16E_SHIFT   (0x00000004u)

#define GPMC_ECC7_RESULT_P16O   (0x00100000u)
#define GPMC_ECC7_RESULT_P16O_SHIFT   (0x00000014u)

#define GPMC_ECC7_RESULT_P1E   (0x00000001u)
#define GPMC_ECC7_RESULT_P1E_SHIFT   (0x00000000u)

#define GPMC_ECC7_RESULT_P1O   (0x00010000u)
#define GPMC_ECC7_RESULT_P1O_SHIFT   (0x00000010u)

#define GPMC_ECC7_RESULT_P2048E   (0x00000800u)
#define GPMC_ECC7_RESULT_P2048E_SHIFT   (0x0000000Bu)

#define GPMC_ECC7_RESULT_P2048O   (0x08000000u)
#define GPMC_ECC7_RESULT_P2048O_SHIFT   (0x0000001Bu)

#define GPMC_ECC7_RESULT_P256E   (0x00000100u)
#define GPMC_ECC7_RESULT_P256E_SHIFT   (0x00000008u)

#define GPMC_ECC7_RESULT_P256O   (0x01000000u)
#define GPMC_ECC7_RESULT_P256O_SHIFT   (0x00000018u)

#define GPMC_ECC7_RESULT_P2E   (0x00000002u)
#define GPMC_ECC7_RESULT_P2E_SHIFT   (0x00000001u)

#define GPMC_ECC7_RESULT_P2O   (0x00020000u)
#define GPMC_ECC7_RESULT_P2O_SHIFT   (0x00000011u)

#define GPMC_ECC7_RESULT_P32E   (0x00000020u)
#define GPMC_ECC7_RESULT_P32E_SHIFT   (0x00000005u)

#define GPMC_ECC7_RESULT_P32O   (0x00200000u)
#define GPMC_ECC7_RESULT_P32O_SHIFT   (0x00000015u)

#define GPMC_ECC7_RESULT_P4E   (0x00000004u)
#define GPMC_ECC7_RESULT_P4E_SHIFT   (0x00000002u)

#define GPMC_ECC7_RESULT_P4O   (0x00040000u)
#define GPMC_ECC7_RESULT_P4O_SHIFT   (0x00000012u)

#define GPMC_ECC7_RESULT_P512E   (0x00000200u)
#define GPMC_ECC7_RESULT_P512E_SHIFT   (0x00000009u)

#define GPMC_ECC7_RESULT_P512O   (0x02000000u)
#define GPMC_ECC7_RESULT_P512O_SHIFT   (0x00000019u)

#define GPMC_ECC7_RESULT_P64E   (0x00000040u)
#define GPMC_ECC7_RESULT_P64E_SHIFT   (0x00000006u)

#define GPMC_ECC7_RESULT_P64O   (0x00400000u)
#define GPMC_ECC7_RESULT_P64O_SHIFT   (0x00000016u)

#define GPMC_ECC7_RESULT_P8E   (0x00000008u)
#define GPMC_ECC7_RESULT_P8E_SHIFT   (0x00000003u)

#define GPMC_ECC7_RESULT_P8O   (0x00080000u)
#define GPMC_ECC7_RESULT_P8O_SHIFT   (0x00000013u)


/* ECC8_RESULT */
#define GPMC_ECC8_RESULT_P1024E   (0x00000400u)
#define GPMC_ECC8_RESULT_P1024E_SHIFT   (0x0000000Au)

#define GPMC_ECC8_RESULT_P1024O   (0x04000000u)
#define GPMC_ECC8_RESULT_P1024O_SHIFT   (0x0000001Au)

#define GPMC_ECC8_RESULT_P128E   (0x00000080u)
#define GPMC_ECC8_RESULT_P128E_SHIFT   (0x00000007u)

#define GPMC_ECC8_RESULT_P128O   (0x00800000u)
#define GPMC_ECC8_RESULT_P128O_SHIFT   (0x00000017u)

#define GPMC_ECC8_RESULT_P16E   (0x00000010u)
#define GPMC_ECC8_RESULT_P16E_SHIFT   (0x00000004u)

#define GPMC_ECC8_RESULT_P16O   (0x00100000u)
#define GPMC_ECC8_RESULT_P16O_SHIFT   (0x00000014u)

#define GPMC_ECC8_RESULT_P1E   (0x00000001u)
#define GPMC_ECC8_RESULT_P1E_SHIFT   (0x00000000u)

#define GPMC_ECC8_RESULT_P1O   (0x00010000u)
#define GPMC_ECC8_RESULT_P1O_SHIFT   (0x00000010u)

#define GPMC_ECC8_RESULT_P2048E   (0x00000800u)
#define GPMC_ECC8_RESULT_P2048E_SHIFT   (0x0000000Bu)

#define GPMC_ECC8_RESULT_P2048O   (0x08000000u)
#define GPMC_ECC8_RESULT_P2048O_SHIFT   (0x0000001Bu)

#define GPMC_ECC8_RESULT_P256E   (0x00000100u)
#define GPMC_ECC8_RESULT_P256E_SHIFT   (0x00000008u)

#define GPMC_ECC8_RESULT_P256O   (0x01000000u)
#define GPMC_ECC8_RESULT_P256O_SHIFT   (0x00000018u)

#define GPMC_ECC8_RESULT_P2E   (0x00000002u)
#define GPMC_ECC8_RESULT_P2E_SHIFT   (0x00000001u)

#define GPMC_ECC8_RESULT_P2O   (0x00020000u)
#define GPMC_ECC8_RESULT_P2O_SHIFT   (0x00000011u)

#define GPMC_ECC8_RESULT_P32E   (0x00000020u)
#define GPMC_ECC8_RESULT_P32E_SHIFT   (0x00000005u)

#define GPMC_ECC8_RESULT_P32O   (0x00200000u)
#define GPMC_ECC8_RESULT_P32O_SHIFT   (0x00000015u)

#define GPMC_ECC8_RESULT_P4E   (0x00000004u)
#define GPMC_ECC8_RESULT_P4E_SHIFT   (0x00000002u)

#define GPMC_ECC8_RESULT_P4O   (0x00040000u)
#define GPMC_ECC8_RESULT_P4O_SHIFT   (0x00000012u)

#define GPMC_ECC8_RESULT_P512E   (0x00000200u)
#define GPMC_ECC8_RESULT_P512E_SHIFT   (0x00000009u)

#define GPMC_ECC8_RESULT_P512O   (0x02000000u)
#define GPMC_ECC8_RESULT_P512O_SHIFT   (0x00000019u)

#define GPMC_ECC8_RESULT_P64E   (0x00000040u)
#define GPMC_ECC8_RESULT_P64E_SHIFT   (0x00000006u)

#define GPMC_ECC8_RESULT_P64O   (0x00400000u)
#define GPMC_ECC8_RESULT_P64O_SHIFT   (0x00000016u)

#define GPMC_ECC8_RESULT_P8E   (0x00000008u)
#define GPMC_ECC8_RESULT_P8E_SHIFT   (0x00000003u)

#define GPMC_ECC8_RESULT_P8O   (0x00080000u)
#define GPMC_ECC8_RESULT_P8O_SHIFT   (0x00000013u)


/* ECC9_RESULT */
#define GPMC_ECC9_RESULT_P1024E   (0x00000400u)
#define GPMC_ECC9_RESULT_P1024E_SHIFT   (0x0000000Au)

#define GPMC_ECC9_RESULT_P1024O   (0x04000000u)
#define GPMC_ECC9_RESULT_P1024O_SHIFT   (0x0000001Au)

#define GPMC_ECC9_RESULT_P128E   (0x00000080u)
#define GPMC_ECC9_RESULT_P128E_SHIFT   (0x00000007u)

#define GPMC_ECC9_RESULT_P128O   (0x00800000u)
#define GPMC_ECC9_RESULT_P128O_SHIFT   (0x00000017u)

#define GPMC_ECC9_RESULT_P16E   (0x00000010u)
#define GPMC_ECC9_RESULT_P16E_SHIFT   (0x00000004u)

#define GPMC_ECC9_RESULT_P16O   (0x00100000u)
#define GPMC_ECC9_RESULT_P16O_SHIFT   (0x00000014u)

#define GPMC_ECC9_RESULT_P1E   (0x00000001u)
#define GPMC_ECC9_RESULT_P1E_SHIFT   (0x00000000u)

#define GPMC_ECC9_RESULT_P1O   (0x00010000u)
#define GPMC_ECC9_RESULT_P1O_SHIFT   (0x00000010u)

#define GPMC_ECC9_RESULT_P2048E   (0x00000800u)
#define GPMC_ECC9_RESULT_P2048E_SHIFT   (0x0000000Bu)

#define GPMC_ECC9_RESULT_P2048O   (0x08000000u)
#define GPMC_ECC9_RESULT_P2048O_SHIFT   (0x0000001Bu)

#define GPMC_ECC9_RESULT_P256E   (0x00000100u)
#define GPMC_ECC9_RESULT_P256E_SHIFT   (0x00000008u)

#define GPMC_ECC9_RESULT_P256O   (0x01000000u)
#define GPMC_ECC9_RESULT_P256O_SHIFT   (0x00000018u)

#define GPMC_ECC9_RESULT_P2E   (0x00000002u)
#define GPMC_ECC9_RESULT_P2E_SHIFT   (0x00000001u)

#define GPMC_ECC9_RESULT_P2O   (0x00020000u)
#define GPMC_ECC9_RESULT_P2O_SHIFT   (0x00000011u)

#define GPMC_ECC9_RESULT_P32E   (0x00000020u)
#define GPMC_ECC9_RESULT_P32E_SHIFT   (0x00000005u)

#define GPMC_ECC9_RESULT_P32O   (0x00200000u)
#define GPMC_ECC9_RESULT_P32O_SHIFT   (0x00000015u)

#define GPMC_ECC9_RESULT_P4E   (0x00000004u)
#define GPMC_ECC9_RESULT_P4E_SHIFT   (0x00000002u)

#define GPMC_ECC9_RESULT_P4O   (0x00040000u)
#define GPMC_ECC9_RESULT_P4O_SHIFT   (0x00000012u)

#define GPMC_ECC9_RESULT_P512E   (0x00000200u)
#define GPMC_ECC9_RESULT_P512E_SHIFT   (0x00000009u)

#define GPMC_ECC9_RESULT_P512O   (0x02000000u)
#define GPMC_ECC9_RESULT_P512O_SHIFT   (0x00000019u)

#define GPMC_ECC9_RESULT_P64E   (0x00000040u)
#define GPMC_ECC9_RESULT_P64E_SHIFT   (0x00000006u)

#define GPMC_ECC9_RESULT_P64O   (0x00400000u)
#define GPMC_ECC9_RESULT_P64O_SHIFT   (0x00000016u)

#define GPMC_ECC9_RESULT_P8E   (0x00000008u)
#define GPMC_ECC9_RESULT_P8E_SHIFT   (0x00000003u)

#define GPMC_ECC9_RESULT_P8O   (0x00080000u)
#define GPMC_ECC9_RESULT_P8O_SHIFT   (0x00000013u)


/* TESTMODE_CTRL */

/* BCH_RESULT0_0 */
#define GPMC_BCH_RESULT0_0_BCH_RESULT_0   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT0_0_BCH_RESULT_0_SHIFT   (0x00000000u)


/* BCH_RESULT_0 */

/* BCH_RESULT1_0 */
#define GPMC_BCH_RESULT1_0_BCH_RESULT_1   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT1_0_BCH_RESULT_1_SHIFT   (0x00000000u)


/* BCH_RESULT_1 */

/* BCH_RESULT2_0 */
#define GPMC_BCH_RESULT2_0_BCH_RESULT_2   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT2_0_BCH_RESULT_2_SHIFT   (0x00000000u)


/* BCH_RESULT_2 */

/* BCH_RESULT3_0 */
#define GPMC_BCH_RESULT3_0_BCH_RESULT_3   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT3_0_BCH_RESULT_3_SHIFT   (0x00000000u)


/* BCH_RESULT_3 */

/* BCH_RESULT0_1 */
#define GPMC_BCH_RESULT0_1_BCH_RESULT_0   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT0_1_BCH_RESULT_0_SHIFT   (0x00000000u)


/* BCH_RESULT1_1 */
#define GPMC_BCH_RESULT1_1_BCH_RESULT_1   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT1_1_BCH_RESULT_1_SHIFT   (0x00000000u)


/* BCH_RESULT2_1 */
#define GPMC_BCH_RESULT2_1_BCH_RESULT_2   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT2_1_BCH_RESULT_2_SHIFT   (0x00000000u)


/* BCH_RESULT3_1 */
#define GPMC_BCH_RESULT3_1_BCH_RESULT_3   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT3_1_BCH_RESULT_3_SHIFT   (0x00000000u)


/* BCH_RESULT0_2 */
#define GPMC_BCH_RESULT0_2_BCH_RESULT_0   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT0_2_BCH_RESULT_0_SHIFT   (0x00000000u)


/* BCH_RESULT1_2 */
#define GPMC_BCH_RESULT1_2_BCH_RESULT_1   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT1_2_BCH_RESULT_1_SHIFT   (0x00000000u)


/* BCH_RESULT2_2 */
#define GPMC_BCH_RESULT2_2_BCH_RESULT_2   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT2_2_BCH_RESULT_2_SHIFT   (0x00000000u)


/* BCH_RESULT3_2 */
#define GPMC_BCH_RESULT3_2_BCH_RESULT_3   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT3_2_BCH_RESULT_3_SHIFT   (0x00000000u)


/* BCH_RESULT0_3 */
#define GPMC_BCH_RESULT0_3_BCH_RESULT_0   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT0_3_BCH_RESULT_0_SHIFT   (0x00000000u)


/* BCH_RESULT1_3 */
#define GPMC_BCH_RESULT1_3_BCH_RESULT_1   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT1_3_BCH_RESULT_1_SHIFT   (0x00000000u)


/* BCH_RESULT2_3 */
#define GPMC_BCH_RESULT2_3_BCH_RESULT_2   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT2_3_BCH_RESULT_2_SHIFT   (0x00000000u)


/* BCH_RESULT3_3 */
#define GPMC_BCH_RESULT3_3_BCH_RESULT_3   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT3_3_BCH_RESULT_3_SHIFT   (0x00000000u)


/* BCH_RESULT0_4 */
#define GPMC_BCH_RESULT0_4_BCH_RESULT_0   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT0_4_BCH_RESULT_0_SHIFT   (0x00000000u)


/* BCH_RESULT1_4 */
#define GPMC_BCH_RESULT1_4_BCH_RESULT_1   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT1_4_BCH_RESULT_1_SHIFT   (0x00000000u)


/* BCH_RESULT2_4 */
#define GPMC_BCH_RESULT2_4_BCH_RESULT_2   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT2_4_BCH_RESULT_2_SHIFT   (0x00000000u)


/* BCH_RESULT3_4 */
#define GPMC_BCH_RESULT3_4_BCH_RESULT_3   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT3_4_BCH_RESULT_3_SHIFT   (0x00000000u)


/* BCH_RESULT0_5 */
#define GPMC_BCH_RESULT0_5_BCH_RESULT_0   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT0_5_BCH_RESULT_0_SHIFT   (0x00000000u)


/* BCH_RESULT1_5 */
#define GPMC_BCH_RESULT1_5_BCH_RESULT_1   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT1_5_BCH_RESULT_1_SHIFT   (0x00000000u)


/* BCH_RESULT2_5 */
#define GPMC_BCH_RESULT2_5_BCH_RESULT_2   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT2_5_BCH_RESULT_2_SHIFT   (0x00000000u)


/* BCH_RESULT3_5 */
#define GPMC_BCH_RESULT3_5_BCH_RESULT_3   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT3_5_BCH_RESULT_3_SHIFT   (0x00000000u)


/* BCH_RESULT0_6 */
#define GPMC_BCH_RESULT0_6_BCH_RESULT_0   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT0_6_BCH_RESULT_0_SHIFT   (0x00000000u)


/* BCH_RESULT1_6 */
#define GPMC_BCH_RESULT1_6_BCH_RESULT_1   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT1_6_BCH_RESULT_1_SHIFT   (0x00000000u)


/* BCH_RESULT2_6 */
#define GPMC_BCH_RESULT2_6_BCH_RESULT_2   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT2_6_BCH_RESULT_2_SHIFT   (0x00000000u)


/* BCH_RESULT3_6 */
#define GPMC_BCH_RESULT3_6_BCH_RESULT_3   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT3_6_BCH_RESULT_3_SHIFT   (0x00000000u)


/* BCH_RESULT0_7 */
#define GPMC_BCH_RESULT0_7_BCH_RESULT_0   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT0_7_BCH_RESULT_0_SHIFT   (0x00000000u)


/* BCH_RESULT1_7 */
#define GPMC_BCH_RESULT1_7_BCH_RESULT_1   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT1_7_BCH_RESULT_1_SHIFT   (0x00000000u)


/* BCH_RESULT2_7 */
#define GPMC_BCH_RESULT2_7_BCH_RESULT_2   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT2_7_BCH_RESULT_2_SHIFT   (0x00000000u)


/* BCH_RESULT3_7 */
#define GPMC_BCH_RESULT3_7_BCH_RESULT_3   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT3_7_BCH_RESULT_3_SHIFT   (0x00000000u)


/* BCH_SWDATA */
#define GPMC_BCH_SWDATA_BCH_DATA   (0x0000FFFFu)
#define GPMC_BCH_SWDATA_BCH_DATA_SHIFT   (0x00000000u)


/* BCH_RESULT4_0 */
#define GPMC_BCH_RESULT4_0_BCH_RESULT_4   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT4_0_BCH_RESULT_4_SHIFT   (0x00000000u)


/* BCH_RESULT_4 */

/* BCH_RESULT5_0 */
#define GPMC_BCH_RESULT5_0_BCH_RESULT_5   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT5_0_BCH_RESULT_5_SHIFT   (0x00000000u)


/* BCH_RESULT_5 */

/* BCH_RESULT6_0 */
#define GPMC_BCH_RESULT6_0_BCH_RESULT_6   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT6_0_BCH_RESULT_6_SHIFT   (0x00000000u)


/* BCH_RESULT_6 */

/* BCH_RESULT4_1 */
#define GPMC_BCH_RESULT4_1_BCH_RESULT_4   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT4_1_BCH_RESULT_4_SHIFT   (0x00000000u)


/* BCH_RESULT5_1 */
#define GPMC_BCH_RESULT5_1_BCH_RESULT_5   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT5_1_BCH_RESULT_5_SHIFT   (0x00000000u)


/* BCH_RESULT6_1 */
#define GPMC_BCH_RESULT6_1_BCH_RESULT_6   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT6_1_BCH_RESULT_6_SHIFT   (0x00000000u)


/* BCH_RESULT4_2 */
#define GPMC_BCH_RESULT4_2_BCH_RESULT_4   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT4_2_BCH_RESULT_4_SHIFT   (0x00000000u)


/* BCH_RESULT5_2 */
#define GPMC_BCH_RESULT5_2_BCH_RESULT_5   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT5_2_BCH_RESULT_5_SHIFT   (0x00000000u)


/* BCH_RESULT6_2 */
#define GPMC_BCH_RESULT6_2_BCH_RESULT_6   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT6_2_BCH_RESULT_6_SHIFT   (0x00000000u)


/* BCH_RESULT4_3 */
#define GPMC_BCH_RESULT4_3_BCH_RESULT_4   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT4_3_BCH_RESULT_4_SHIFT   (0x00000000u)


/* BCH_RESULT5_3 */
#define GPMC_BCH_RESULT5_3_BCH_RESULT_5   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT5_3_BCH_RESULT_5_SHIFT   (0x00000000u)


/* BCH_RESULT6_3 */
#define GPMC_BCH_RESULT6_3_BCH_RESULT_6   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT6_3_BCH_RESULT_6_SHIFT   (0x00000000u)


/* BCH_RESULT4_4 */
#define GPMC_BCH_RESULT4_4_BCH_RESULT_4   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT4_4_BCH_RESULT_4_SHIFT   (0x00000000u)


/* BCH_RESULT5_4 */
#define GPMC_BCH_RESULT5_4_BCH_RESULT_5   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT5_4_BCH_RESULT_5_SHIFT   (0x00000000u)


/* BCH_RESULT6_4 */
#define GPMC_BCH_RESULT6_4_BCH_RESULT_6   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT6_4_BCH_RESULT_6_SHIFT   (0x00000000u)


/* BCH_RESULT4_5 */
#define GPMC_BCH_RESULT4_5_BCH_RESULT_4   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT4_5_BCH_RESULT_4_SHIFT   (0x00000000u)


/* BCH_RESULT5_5 */
#define GPMC_BCH_RESULT5_5_BCH_RESULT_5   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT5_5_BCH_RESULT_5_SHIFT   (0x00000000u)


/* BCH_RESULT6_5 */
#define GPMC_BCH_RESULT6_5_BCH_RESULT_6   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT6_5_BCH_RESULT_6_SHIFT   (0x00000000u)


/* BCH_RESULT4_6 */
#define GPMC_BCH_RESULT4_6_BCH_RESULT_4   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT4_6_BCH_RESULT_4_SHIFT   (0x00000000u)


/* BCH_RESULT5_6 */
#define GPMC_BCH_RESULT5_6_BCH_RESULT_5   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT5_6_BCH_RESULT_5_SHIFT   (0x00000000u)


/* BCH_RESULT6_6 */
#define GPMC_BCH_RESULT6_6_BCH_RESULT_6   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT6_6_BCH_RESULT_6_SHIFT   (0x00000000u)


/* BCH_RESULT4_7 */
#define GPMC_BCH_RESULT4_7_BCH_RESULT_4   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT4_7_BCH_RESULT_4_SHIFT   (0x00000000u)


/* BCH_RESULT5_7 */
#define GPMC_BCH_RESULT5_7_BCH_RESULT_5   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT5_7_BCH_RESULT_5_SHIFT   (0x00000000u)


/* BCH_RESULT6_7 */
#define GPMC_BCH_RESULT6_7_BCH_RESULT_6   (0xFFFFFFFFu)
#define GPMC_BCH_RESULT6_7_BCH_RESULT_6_SHIFT   (0x00000000u)



#ifdef __cplusplus
}
#endif

#endif
