/**
 * \file  hw_mcasp.h
 *
 * \brief McASP register definitions
 */

/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_MCASP_H_
#define _HW_MCASP_H_

#ifdef __cplusplus
extern "C" {
#endif

#define MCASP_DATA_PORT			(0x0)
#define MCASP_FIFO_REVID		(0x0)

#if defined(am1808) || defined(omapl138) || defined(c6748)
#define MCASP_FIFO_WFIFOCTL		(0x10)
#define MCASP_FIFO_WFIFOSTS		(0x14)
#define MCASP_FIFO_RFIFOCTL		(0x18)
#define MCASP_FIFO_RFIFOSTS		(0x1C)
#endif

#if defined(am335x) || defined(am335x_13x13) || defined(am335x_15x15) || \
    defined(c6a811x) || defined(am386x) || defined(c6741x)
#define MCASP_FIFO_WFIFOCTL             (0x00)
#define MCASP_FIFO_WFIFOSTS             (0x04)
#define MCASP_FIFO_RFIFOCTL             (0x08)
#define MCASP_FIFO_RFIFOSTS             (0x0C)
#endif

/**************************************************************************\
* McASP Register Overlay Structure (module block)
\**************************************************************************/
#define MCASP_REVID			(0x0)
#define MCASP_PFUNC			(0x10)
#define MCASP_PDIR			(0x14)
#define MCASP_PDOUT			(0x18)
#define MCASP_PDIN			(0x1C)
#define MCASP_PDSET			(0x1C)
#define MCASP_PDCLR			(0x20)
#define MCASP_GBLCTL			(0x44)
#define MCASP_AMUTE			(0x48)
#define MCASP_DLBCTL			(0x4C)
#define MCASP_DITCTL			(0x50)
#define MCASP_RGBLCTL			(0x60)
#define MCASP_RMASK			(0x64)
#define MCASP_RFMT			(0x68)
#define MCASP_AFSRCTL			(0x6C)
#define MCASP_ACLKRCTL			(0x70)
#define MCASP_AHCLKRCTL			(0x74)
#define MCASP_RTDM			(0x78)
#define MCASP_RINTCTL			(0x7C)
#define MCASP_RSTAT			(0x80)
#define MCASP_RSLOT			(0x84)
#define MCASP_RCLKCHK			(0x88)
#define MCASP_REVTCTL			(0x8C)
#define MCASP_XGBLCTL			(0xA0)
#define MCASP_XMASK			(0xA4)
#define MCASP_XFMT			(0xA8)
#define MCASP_AFSXCTL			(0xAC)
#define MCASP_ACLKXCTL			(0xB0)
#define MCASP_AHCLKXCTL			(0xB4)
#define MCASP_XTDM			(0xB8)
#define MCASP_XINTCTL			(0xBC)
#define MCASP_XSTAT			(0xC0)
#define MCASP_XSLOT			(0xC4)
#define MCASP_XCLKCHK			(0xC8)
#define MCASP_XEVTCTL			(0xCC)
#define MCASP_DITCSRA(n)		(0x100 + (n * 4))
#define MCASP_DITCSRB(n)		(0x118 + (n * 4))
#define MCASP_DITUDRA(n)		(0x130 + (n * 4))
#define MCASP_DITUDRB(n)		(0x148 + (n * 4))
#define MCASP_SRCTL(n)			(0x180 + (n * 4))
#define MCASP_XBUF(n)			(0x200 + (n * 4))
#define MCASP_RBUF(n)			(0x280 + (n * 4))

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define MCASP_REVID_REV (0xFFFFFFFFu)
#define MCASP_REVID_REV_SHIFT (0x00000000u)


/* PFUNC */

#define MCASP_PFUNC_AFSR (0x80000000u)
#define MCASP_PFUNC_AFSR_SHIFT (0x0000001Fu)

#define MCASP_PFUNC_AHCLKR (0x40000000u)
#define MCASP_PFUNC_AHCLKR_SHIFT (0x0000001Eu)

#define MCASP_PFUNC_ACLKR (0x20000000u)
#define MCASP_PFUNC_ACLKR_SHIFT (0x0000001Du)

#define MCASP_PFUNC_AFSX (0x10000000u)
#define MCASP_PFUNC_AFSX_SHIFT (0x0000001Cu)

#define MCASP_PFUNC_AHCLKX (0x08000000u)
#define MCASP_PFUNC_AHCLKX_SHIFT (0x0000001Bu)

#define MCASP_PFUNC_ACLKX (0x04000000u)
#define MCASP_PFUNC_ACLKX_SHIFT (0x0000001Au)

#define MCASP_PFUNC_AMUTE (0x02000000u)
#define MCASP_PFUNC_AMUTE_SHIFT (0x00000019u)

#define MCASP_PFUNC_AXR15 (0x00008000u)
#define MCASP_PFUNC_AXR15_SHIFT (0x0000000Fu)
#define MCASP_PFUNC_AXR15_MCASP (0x00000000u)
#define MCASP_PFUNC_AXR15_GPIO (0x00000001u)

#define MCASP_PFUNC_AXR14 (0x00004000u)
#define MCASP_PFUNC_AXR14_SHIFT (0x0000000Eu)
#define MCASP_PFUNC_AXR14_MCASP (0x00000000u)
#define MCASP_PFUNC_AXR14_GPIO (0x00000001u)

#define MCASP_PFUNC_AXR13 (0x00002000u)
#define MCASP_PFUNC_AXR13_SHIFT (0x0000000Du)
#define MCASP_PFUNC_AXR13_MCASP (0x00000000u)
#define MCASP_PFUNC_AXR13_GPIO (0x00000001u)

#define MCASP_PFUNC_AXR12 (0x00001000u)
#define MCASP_PFUNC_AXR12_SHIFT (0x0000000Cu)
#define MCASP_PFUNC_AXR12_MCASP (0x00000000u)
#define MCASP_PFUNC_AXR12_GPIO (0x00000001u)

#define MCASP_PFUNC_AXR11 (0x00000800u)
#define MCASP_PFUNC_AXR11_SHIFT (0x0000000Bu)
#define MCASP_PFUNC_AXR11_MCASP (0x00000000u)
#define MCASP_PFUNC_AXR11_GPIO (0x00000001u)

#define MCASP_PFUNC_AXR10 (0x00000400u)
#define MCASP_PFUNC_AXR10_SHIFT (0x0000000Au)

#define MCASP_PFUNC_AXR9 (0x00000200u)
#define MCASP_PFUNC_AXR9_SHIFT (0x00000009u)

#define MCASP_PFUNC_AXR8 (0x00000100u)
#define MCASP_PFUNC_AXR8_SHIFT (0x00000008u)

#define MCASP_PFUNC_AXR7 (0x00000080u)
#define MCASP_PFUNC_AXR7_SHIFT (0x00000007u)

#define MCASP_PFUNC_AXR6 (0x00000040u)
#define MCASP_PFUNC_AXR6_SHIFT (0x00000006u)

#define MCASP_PFUNC_AXR5 (0x00000020u)
#define MCASP_PFUNC_AXR5_SHIFT (0x00000005u)

#define MCASP_PFUNC_AXR4 (0x00000010u)
#define MCASP_PFUNC_AXR4_SHIFT (0x00000004u)

#define MCASP_PFUNC_AXR3 (0x00000008u)
#define MCASP_PFUNC_AXR3_SHIFT (0x00000003u)

#define MCASP_PFUNC_AXR2 (0x00000004u)
#define MCASP_PFUNC_AXR2_SHIFT (0x00000002u)

#define MCASP_PFUNC_AXR1 (0x00000002u)
#define MCASP_PFUNC_AXR1_SHIFT (0x00000001u)

#define MCASP_PFUNC_AXR0 (0x00000001u)
#define MCASP_PFUNC_AXR0_SHIFT (0x00000000u)


/* PDIR */

#define MCASP_PDIR_AFSR (0x80000000u)
#define MCASP_PDIR_AFSR_SHIFT (0x0000001Fu)

#define MCASP_PDIR_AHCLKR (0x40000000u)
#define MCASP_PDIR_AHCLKR_SHIFT (0x0000001Eu)

#define MCASP_PDIR_ACLKR (0x20000000u)
#define MCASP_PDIR_ACLKR_SHIFT (0x0000001Du)

#define MCASP_PDIR_AFSX (0x10000000u)
#define MCASP_PDIR_AFSX_SHIFT (0x0000001Cu)

#define MCASP_PDIR_AHCLKX (0x08000000u)
#define MCASP_PDIR_AHCLKX_SHIFT (0x0000001Bu)

#define MCASP_PDIR_ACLKX (0x04000000u)
#define MCASP_PDIR_ACLKX_SHIFT (0x0000001Au)

#define MCASP_PDIR_AMUTE (0x02000000u)
#define MCASP_PDIR_AMUTE_SHIFT (0x00000019u)

#define MCASP_PDIR_AXR15 (0x00008000u)
#define MCASP_PDIR_AXR15_SHIFT (0x0000000Fu)

#define MCASP_PDIR_AXR14 (0x00004000u)
#define MCASP_PDIR_AXR14_SHIFT (0x0000000Eu)

#define MCASP_PDIR_AXR13 (0x00002000u)
#define MCASP_PDIR_AXR13_SHIFT (0x0000000Du)

#define MCASP_PDIR_AXR12 (0x00001000u)
#define MCASP_PDIR_AXR12_SHIFT (0x0000000Cu)

#define MCASP_PDIR_AXR11 (0x00000800u)
#define MCASP_PDIR_AXR11_SHIFT (0x0000000Bu)

#define MCASP_PDIR_AXR10 (0x00000400u)
#define MCASP_PDIR_AXR10_SHIFT (0x0000000Au)

#define MCASP_PDIR_AXR9 (0x00000200u)
#define MCASP_PDIR_AXR9_SHIFT (0x00000009u)

#define MCASP_PDIR_AXR8 (0x00000100u)
#define MCASP_PDIR_AXR8_SHIFT (0x00000008u)

#define MCASP_PDIR_AXR7 (0x00000080u)
#define MCASP_PDIR_AXR7_SHIFT (0x00000007u)

#define MCASP_PDIR_AXR6 (0x00000040u)
#define MCASP_PDIR_AXR6_SHIFT (0x00000006u)

#define MCASP_PDIR_AXR5 (0x00000020u)
#define MCASP_PDIR_AXR5_SHIFT (0x00000005u)

#define MCASP_PDIR_AXR4 (0x00000010u)
#define MCASP_PDIR_AXR4_SHIFT (0x00000004u)

#define MCASP_PDIR_AXR3 (0x00000008u)
#define MCASP_PDIR_AXR3_SHIFT (0x00000003u)

#define MCASP_PDIR_AXR2 (0x00000004u)
#define MCASP_PDIR_AXR2_SHIFT (0x00000002u)

#define MCASP_PDIR_AXR1 (0x00000002u)
#define MCASP_PDIR_AXR1_SHIFT (0x00000001u)

#define MCASP_PDIR_AXR0 (0x00000001u)
#define MCASP_PDIR_AXR0_SHIFT (0x00000000u)


/* PDOUT */

#define MCASP_PDOUT_AFSR (0x80000000u)
#define MCASP_PDOUT_AFSR_SHIFT (0x0000001Fu)

#define MCASP_PDOUT_AHCLKR (0x40000000u)
#define MCASP_PDOUT_AHCLKR_SHIFT (0x0000001Eu)

#define MCASP_PDOUT_ACLKR (0x20000000u)
#define MCASP_PDOUT_ACLKR_SHIFT (0x0000001Du)

#define MCASP_PDOUT_AFSX (0x10000000u)
#define MCASP_PDOUT_AFSX_SHIFT (0x0000001Cu)

#define MCASP_PDOUT_AHCLKX (0x08000000u)
#define MCASP_PDOUT_AHCLKX_SHIFT (0x0000001Bu)

#define MCASP_PDOUT_ACLKX (0x04000000u)
#define MCASP_PDOUT_ACLKX_SHIFT (0x0000001Au)

#define MCASP_PDOUT_AMUTE (0x02000000u)
#define MCASP_PDOUT_AMUTE_SHIFT (0x00000019u)


#define MCASP_PDOUT_AXR15 (0x00008000u)
#define MCASP_PDOUT_AXR15_SHIFT (0x0000000Fu)

#define MCASP_PDOUT_AXR14 (0x00004000u)
#define MCASP_PDOUT_AXR14_SHIFT (0x0000000Eu)

#define MCASP_PDOUT_AXR13 (0x00002000u)
#define MCASP_PDOUT_AXR13_SHIFT (0x0000000Du)

#define MCASP_PDOUT_AXR12 (0x00001000u)
#define MCASP_PDOUT_AXR12_SHIFT (0x0000000Cu)

#define MCASP_PDOUT_AXR11 (0x00000800u)
#define MCASP_PDOUT_AXR11_SHIFT (0x0000000Bu)

#define MCASP_PDOUT_AXR10 (0x00000400u)
#define MCASP_PDOUT_AXR10_SHIFT (0x0000000Au)

#define MCASP_PDOUT_AXR9 (0x00000200u)
#define MCASP_PDOUT_AXR9_SHIFT (0x00000009u)

#define MCASP_PDOUT_AXR8 (0x00000100u)
#define MCASP_PDOUT_AXR8_SHIFT (0x00000008u)

#define MCASP_PDOUT_AXR7 (0x00000080u)
#define MCASP_PDOUT_AXR7_SHIFT (0x00000007u)

#define MCASP_PDOUT_AXR6 (0x00000040u)
#define MCASP_PDOUT_AXR6_SHIFT (0x00000006u)

#define MCASP_PDOUT_AXR5 (0x00000020u)
#define MCASP_PDOUT_AXR5_SHIFT (0x00000005u)

#define MCASP_PDOUT_AXR4 (0x00000010u)
#define MCASP_PDOUT_AXR4_SHIFT (0x00000004u)

#define MCASP_PDOUT_AXR3 (0x00000008u)
#define MCASP_PDOUT_AXR3_SHIFT (0x00000003u)

#define MCASP_PDOUT_AXR2 (0x00000004u)
#define MCASP_PDOUT_AXR2_SHIFT (0x00000002u)

#define MCASP_PDOUT_AXR1 (0x00000002u)
#define MCASP_PDOUT_AXR1_SHIFT (0x00000001u)

#define MCASP_PDOUT_AXR0 (0x00000001u)
#define MCASP_PDOUT_AXR0_SHIFT (0x00000000u)


/* PDIN */

#define MCASP_PDIN_AFSR (0x80000000u)
#define MCASP_PDIN_AFSR_SHIFT (0x0000001Fu)

#define MCASP_PDIN_AHCLKR (0x40000000u)
#define MCASP_PDIN_AHCLKR_SHIFT (0x0000001Eu)

#define MCASP_PDIN_ACLKR (0x20000000u)
#define MCASP_PDIN_ACLKR_SHIFT (0x0000001Du)

#define MCASP_PDIN_AFSX (0x10000000u)
#define MCASP_PDIN_AFSX_SHIFT (0x0000001Cu)

#define MCASP_PDIN_AHCLKX (0x08000000u)
#define MCASP_PDIN_AHCLKX_SHIFT (0x0000001Bu)

#define MCASP_PDIN_ACLKX (0x04000000u)
#define MCASP_PDIN_ACLKX_SHIFT (0x0000001Au)

#define MCASP_PDIN_AMUTE (0x02000000u)
#define MCASP_PDIN_AMUTE_SHIFT (0x00000019u)


#define MCASP_PDIN_AXR15 (0x00008000u)
#define MCASP_PDIN_AXR15_SHIFT (0x0000000Fu)

#define MCASP_PDIN_AXR14 (0x00004000u)
#define MCASP_PDIN_AXR14_SHIFT (0x0000000Eu)

#define MCASP_PDIN_AXR13 (0x00002000u)
#define MCASP_PDIN_AXR13_SHIFT (0x0000000Du)

#define MCASP_PDIN_AXR12 (0x00001000u)
#define MCASP_PDIN_AXR12_SHIFT (0x0000000Cu)

#define MCASP_PDIN_AXR11 (0x00000800u)
#define MCASP_PDIN_AXR11_SHIFT (0x0000000Bu)

#define MCASP_PDIN_AXR10 (0x00000400u)
#define MCASP_PDIN_AXR10_SHIFT (0x0000000Au)

#define MCASP_PDIN_AXR9 (0x00000200u)
#define MCASP_PDIN_AXR9_SHIFT (0x00000009u)

#define MCASP_PDIN_AXR8 (0x00000100u)
#define MCASP_PDIN_AXR8_SHIFT (0x00000008u)

#define MCASP_PDIN_AXR7 (0x00000080u)
#define MCASP_PDIN_AXR7_SHIFT (0x00000007u)

#define MCASP_PDIN_AXR6 (0x00000040u)
#define MCASP_PDIN_AXR6_SHIFT (0x00000006u)

#define MCASP_PDIN_AXR5 (0x00000020u)
#define MCASP_PDIN_AXR5_SHIFT (0x00000005u)

#define MCASP_PDIN_AXR4 (0x00000010u)
#define MCASP_PDIN_AXR4_SHIFT (0x00000004u)

#define MCASP_PDIN_AXR3 (0x00000008u)
#define MCASP_PDIN_AXR3_SHIFT (0x00000003u)

#define MCASP_PDIN_AXR2 (0x00000004u)
#define MCASP_PDIN_AXR2_SHIFT (0x00000002u)

#define MCASP_PDIN_AXR1 (0x00000002u)
#define MCASP_PDIN_AXR1_SHIFT (0x00000001u)

#define MCASP_PDIN_AXR0 (0x00000001u)
#define MCASP_PDIN_AXR0_SHIFT (0x00000000u)


/* PDSET */

#define MCASP_PDSET_AFSR (0x80000000u)
#define MCASP_PDSET_AFSR_SHIFT (0x0000001Fu)

#define MCASP_PDSET_AHCLKR (0x40000000u)
#define MCASP_PDSET_AHCLKR_SHIFT (0x0000001Eu)

#define MCASP_PDSET_ACLKR (0x20000000u)
#define MCASP_PDSET_ACLKR_SHIFT (0x0000001Du)

#define MCASP_PDSET_AFSX (0x10000000u)
#define MCASP_PDSET_AFSX_SHIFT (0x0000001Cu)

#define MCASP_PDSET_AHCLKX (0x08000000u)
#define MCASP_PDSET_AHCLKX_SHIFT (0x0000001Bu)

#define MCASP_PDSET_ACLKX (0x04000000u)
#define MCASP_PDSET_ACLKX_SHIFT (0x0000001Au)

#define MCASP_PDSET_AMUTE (0x02000000u)
#define MCASP_PDSET_AMUTE_SHIFT (0x00000019u)


#define MCASP_PDSET_AXR15 (0x00008000u)
#define MCASP_PDSET_AXR15_SHIFT (0x0000000Fu)

#define MCASP_PDSET_AXR14 (0x00004000u)
#define MCASP_PDSET_AXR14_SHIFT (0x0000000Eu)

#define MCASP_PDSET_AXR13 (0x00002000u)
#define MCASP_PDSET_AXR13_SHIFT (0x0000000Du)

#define MCASP_PDSET_AXR12 (0x00001000u)
#define MCASP_PDSET_AXR12_SHIFT (0x0000000Cu)

#define MCASP_PDSET_AXR11 (0x00000800u)
#define MCASP_PDSET_AXR11_SHIFT (0x0000000Bu)

#define MCASP_PDSET_AXR10 (0x00000400u)
#define MCASP_PDSET_AXR10_SHIFT (0x0000000Au)

#define MCASP_PDSET_AXR9 (0x00000200u)
#define MCASP_PDSET_AXR9_SHIFT (0x00000009u)

#define MCASP_PDSET_AXR8 (0x00000100u)
#define MCASP_PDSET_AXR8_SHIFT (0x00000008u)

#define MCASP_PDSET_AXR7 (0x00000080u)
#define MCASP_PDSET_AXR7_SHIFT (0x00000007u)

#define MCASP_PDSET_AXR6 (0x00000040u)
#define MCASP_PDSET_AXR6_SHIFT (0x00000006u)

#define MCASP_PDSET_AXR5 (0x00000020u)
#define MCASP_PDSET_AXR5_SHIFT (0x00000005u)

#define MCASP_PDSET_AXR4 (0x00000010u)
#define MCASP_PDSET_AXR4_SHIFT (0x00000004u)

#define MCASP_PDSET_AXR3 (0x00000008u)
#define MCASP_PDSET_AXR3_SHIFT (0x00000003u)

#define MCASP_PDSET_AXR2 (0x00000004u)
#define MCASP_PDSET_AXR2_SHIFT (0x00000002u)

#define MCASP_PDSET_AXR1 (0x00000002u)
#define MCASP_PDSET_AXR1_SHIFT (0x00000001u)

#define MCASP_PDSET_AXR0 (0x00000001u)
#define MCASP_PDSET_AXR0_SHIFT (0x00000000u)


/* PDCLR */

#define MCASP_PDCLR_AFSR (0x80000000u)
#define MCASP_PDCLR_AFSR_SHIFT (0x0000001Fu)

#define MCASP_PDCLR_AHCLKR (0x40000000u)
#define MCASP_PDCLR_AHCLKR_SHIFT (0x0000001Eu)

#define MCASP_PDCLR_ACLKR (0x20000000u)
#define MCASP_PDCLR_ACLKR_SHIFT (0x0000001Du)

#define MCASP_PDCLR_AFSX (0x10000000u)
#define MCASP_PDCLR_AFSX_SHIFT (0x0000001Cu)

#define MCASP_PDCLR_AHCLKX (0x08000000u)
#define MCASP_PDCLR_AHCLKX_SHIFT (0x0000001Bu)

#define MCASP_PDCLR_ACLKX (0x04000000u)
#define MCASP_PDCLR_ACLKX_SHIFT (0x0000001Au)

#define MCASP_PDCLR_AMUTE (0x02000000u)
#define MCASP_PDCLR_AMUTE_SHIFT (0x00000019u)


#define MCASP_PDCLR_AXR15 (0x00008000u)
#define MCASP_PDCLR_AXR15_SHIFT (0x0000000Fu)

#define MCASP_PDCLR_AXR14 (0x00004000u)
#define MCASP_PDCLR_AXR14_SHIFT (0x0000000Eu)

#define MCASP_PDCLR_AXR13 (0x00002000u)
#define MCASP_PDCLR_AXR13_SHIFT (0x0000000Du)

#define MCASP_PDCLR_AXR12 (0x00001000u)
#define MCASP_PDCLR_AXR12_SHIFT (0x0000000Cu)

#define MCASP_PDCLR_AXR11 (0x00000800u)
#define MCASP_PDCLR_AXR11_SHIFT (0x0000000Bu)

#define MCASP_PDCLR_AXR10 (0x00000400u)
#define MCASP_PDCLR_AXR10_SHIFT (0x0000000Au)

#define MCASP_PDCLR_AXR9 (0x00000200u)
#define MCASP_PDCLR_AXR9_SHIFT (0x00000009u)

#define MCASP_PDCLR_AXR8 (0x00000100u)
#define MCASP_PDCLR_AXR8_SHIFT (0x00000008u)

#define MCASP_PDCLR_AXR7 (0x00000080u)
#define MCASP_PDCLR_AXR7_SHIFT (0x00000007u)

#define MCASP_PDCLR_AXR6 (0x00000040u)
#define MCASP_PDCLR_AXR6_SHIFT (0x00000006u)

#define MCASP_PDCLR_AXR5 (0x00000020u)
#define MCASP_PDCLR_AXR5_SHIFT (0x00000005u)

#define MCASP_PDCLR_AXR4 (0x00000010u)
#define MCASP_PDCLR_AXR4_SHIFT (0x00000004u)

#define MCASP_PDCLR_AXR3 (0x00000008u)
#define MCASP_PDCLR_AXR3_SHIFT (0x00000003u)

#define MCASP_PDCLR_AXR2 (0x00000004u)
#define MCASP_PDCLR_AXR2_SHIFT (0x00000002u)

#define MCASP_PDCLR_AXR1 (0x00000002u)
#define MCASP_PDCLR_AXR1_SHIFT (0x00000001u)

#define MCASP_PDCLR_AXR0 (0x00000001u)
#define MCASP_PDCLR_AXR0_SHIFT (0x00000000u)

/* GBLCTL */


#define MCASP_GBLCTL_XFRST (0x00001000u)
#define MCASP_GBLCTL_XFRST_SHIFT (0x0000000Cu)

#define MCASP_GBLCTL_XSMRST (0x00000800u)
#define MCASP_GBLCTL_XSMRST_SHIFT (0x0000000Bu)

#define MCASP_GBLCTL_XSRCLR (0x00000400u)
#define MCASP_GBLCTL_XSRCLR_SHIFT (0x0000000Au)

#define MCASP_GBLCTL_XHCLKRST (0x00000200u)
#define MCASP_GBLCTL_XHCLKRST_SHIFT (0x00000009u)

#define MCASP_GBLCTL_XCLKRST (0x00000100u)
#define MCASP_GBLCTL_XCLKRST_SHIFT (0x00000008u)

#define MCASP_GBLCTL_RFRST (0x00000010u)
#define MCASP_GBLCTL_RFRST_SHIFT (0x00000004u)

#define MCASP_GBLCTL_RSMRST (0x00000008u)
#define MCASP_GBLCTL_RSMRST_SHIFT (0x00000003u)

#define MCASP_GBLCTL_RSRCLR (0x00000004u)
#define MCASP_GBLCTL_RSRCLR_SHIFT (0x00000002u)

#define MCASP_GBLCTL_RHCLKRST (0x00000002u)
#define MCASP_GBLCTL_RHCLKRST_SHIFT (0x00000001u)

#define MCASP_GBLCTL_RCLKRST (0x00000001u)
#define MCASP_GBLCTL_RCLKRST_SHIFT (0x00000000u)

/* AMUTE */


#define MCASP_AMUTE_XDMAERR (0x00001000u)
#define MCASP_AMUTE_XDMAERR_SHIFT (0x0000000Cu)

#define MCASP_AMUTE_RDMAERR (0x00000800u)
#define MCASP_AMUTE_RDMAERR_SHIFT (0x0000000Bu)

#define MCASP_AMUTE_XCKFAIL (0x00000400u)
#define MCASP_AMUTE_XCKFAIL_SHIFT (0x0000000Au)

#define MCASP_AMUTE_RCKFAIL (0x00000200u)
#define MCASP_AMUTE_RCKFAIL_SHIFT (0x00000009u)

#define MCASP_AMUTE_XSYNCERR (0x00000100u)
#define MCASP_AMUTE_XSYNCERR_SHIFT (0x00000008u)

#define MCASP_AMUTE_RSYNCERR (0x00000080u)
#define MCASP_AMUTE_RSYNCERR_SHIFT (0x00000007u)

#define MCASP_AMUTE_XUNDRN (0x00000040u)
#define MCASP_AMUTE_XUNDRN_SHIFT (0x00000006u)

#define MCASP_AMUTE_ROVRN (0x00000020u)
#define MCASP_AMUTE_ROVRN_SHIFT (0x00000005u)

#define MCASP_AMUTE_INSTAT (0x00000010u)
#define MCASP_AMUTE_INSTAT_SHIFT (0x00000004u)

#define MCASP_AMUTE_INEN (0x00000008u)
#define MCASP_AMUTE_INEN_SHIFT (0x00000003u)

#define MCASP_AMUTE_INPOL (0x00000004u)
#define MCASP_AMUTE_INPOL_SHIFT (0x00000002u)

#define MCASP_AMUTE_MUTEN (0x00000003u)
#define MCASP_AMUTE_MUTEN_SHIFT (0x00000000u)


/* DLBCTL */


#define MCASP_DLBCTL_IOLBEN (0x00000010u)
#define MCASP_DLBCTL_IOLBEN_SHIFT (0x00000004u)
#define MCASP_DLBCTL_MODE (0x0000000Cu)
#define MCASP_DLBCTL_MODE_SHIFT (0x00000002u)

#define MCASP_DLBCTL_ORD (0x00000002u)
#define MCASP_DLBCTL_ORD_SHIFT (0x00000001u)

#define MCASP_DLBCTL_DLBEN (0x00000001u)
#define MCASP_DLBCTL_DLBEN_SHIFT (0x00000000u)


/* DITCTL */


#define MCASP_DITCTL_VB (0x00000008u)
#define MCASP_DITCTL_VB_SHIFT (0x00000003u)

#define MCASP_DITCTL_VA (0x00000004u)
#define MCASP_DITCTL_VA_SHIFT (0x00000002u)


#define MCASP_DITCTL_DITEN (0x00000001u)
#define MCASP_DITCTL_DITEN_SHIFT (0x00000000u)


/* RGBLCTL */


#define MCASP_RGBLCTL_XFRST (0x00001000u)
#define MCASP_RGBLCTL_XFRST_SHIFT (0x0000000Cu)

#define MCASP_RGBLCTL_XSMRST (0x00000800u)
#define MCASP_RGBLCTL_XSMRST_SHIFT (0x0000000Bu)

#define MCASP_RGBLCTL_XSRCLR (0x00000400u)
#define MCASP_RGBLCTL_XSRCLR_SHIFT (0x0000000Au)

#define MCASP_RGBLCTL_XHCLKRST (0x00000200u)
#define MCASP_RGBLCTL_XHCLKRST_SHIFT (0x00000009u)

#define MCASP_RGBLCTL_XCLKRST (0x00000100u)
#define MCASP_RGBLCTL_XCLKRST_SHIFT (0x00000008u)

#define MCASP_RGBLCTL_RFRST (0x00000010u)
#define MCASP_RGBLCTL_RFRST_SHIFT (0x00000004u)

#define MCASP_RGBLCTL_RSMRST (0x00000008u)
#define MCASP_RGBLCTL_RSMRST_SHIFT (0x00000003u)

#define MCASP_RGBLCTL_RSRCLR (0x00000004u)
#define MCASP_RGBLCTL_RSRCLR_SHIFT (0x00000002u)

#define MCASP_RGBLCTL_RHCLKRST (0x00000002u)
#define MCASP_RGBLCTL_RHCLKRST_SHIFT (0x00000001u)

#define MCASP_RGBLCTL_RCLKRST (0x00000001u)
#define MCASP_RGBLCTL_RCLKRST_SHIFT (0x00000000u)


/* RMASK */

#define MCASP_RMASK_RMASK31 (0x80000000u)
#define MCASP_RMASK_RMASK31_SHIFT (0x0000001Fu)

#define MCASP_RMASK_RMASK30 (0x40000000u)
#define MCASP_RMASK_RMASK30_SHIFT (0x0000001Eu)

#define MCASP_RMASK_RMASK29 (0x20000000u)
#define MCASP_RMASK_RMASK29_SHIFT (0x0000001Du)

#define MCASP_RMASK_RMASK28 (0x10000000u)
#define MCASP_RMASK_RMASK28_SHIFT (0x0000001Cu)

#define MCASP_RMASK_RMASK27 (0x08000000u)
#define MCASP_RMASK_RMASK27_SHIFT (0x0000001Bu)

#define MCASP_RMASK_RMASK26 (0x04000000u)
#define MCASP_RMASK_RMASK26_SHIFT (0x0000001Au)

#define MCASP_RMASK_RMASK25 (0x02000000u)
#define MCASP_RMASK_RMASK25_SHIFT (0x00000019u)

#define MCASP_RMASK_RMASK24 (0x01000000u)
#define MCASP_RMASK_RMASK24_SHIFT (0x00000018u)

#define MCASP_RMASK_RMASK23 (0x00800000u)
#define MCASP_RMASK_RMASK23_SHIFT (0x00000017u)

#define MCASP_RMASK_RMASK22 (0x00400000u)
#define MCASP_RMASK_RMASK22_SHIFT (0x00000016u)

#define MCASP_RMASK_RMASK21 (0x00200000u)
#define MCASP_RMASK_RMASK21_SHIFT (0x00000015u)

#define MCASP_RMASK_RMASK20 (0x00100000u)
#define MCASP_RMASK_RMASK20_SHIFT (0x00000014u)

#define MCASP_RMASK_RMASK19 (0x00080000u)
#define MCASP_RMASK_RMASK19_SHIFT (0x00000013u)

#define MCASP_RMASK_RMASK18 (0x00040000u)
#define MCASP_RMASK_RMASK18_SHIFT (0x00000012u)

#define MCASP_RMASK_RMASK17 (0x00020000u)
#define MCASP_RMASK_RMASK17_SHIFT (0x00000011u)

#define MCASP_RMASK_RMASK16 (0x00010000u)
#define MCASP_RMASK_RMASK16_SHIFT (0x00000010u)

#define MCASP_RMASK_RMASK15 (0x00008000u)
#define MCASP_RMASK_RMASK15_SHIFT (0x0000000Fu)

#define MCASP_RMASK_RMASK14 (0x00004000u)
#define MCASP_RMASK_RMASK14_SHIFT (0x0000000Eu)

#define MCASP_RMASK_RMASK13 (0x00002000u)
#define MCASP_RMASK_RMASK13_SHIFT (0x0000000Du)

#define MCASP_RMASK_RMASK12 (0x00001000u)
#define MCASP_RMASK_RMASK12_SHIFT (0x0000000Cu)

#define MCASP_RMASK_RMASK11 (0x00000800u)
#define MCASP_RMASK_RMASK11_SHIFT (0x0000000Bu)

#define MCASP_RMASK_RMASK10 (0x00000400u)
#define MCASP_RMASK_RMASK10_SHIFT (0x0000000Au)

#define MCASP_RMASK_RMASK9 (0x00000200u)
#define MCASP_RMASK_RMASK9_SHIFT (0x00000009u)

#define MCASP_RMASK_RMASK8 (0x00000100u)
#define MCASP_RMASK_RMASK8_SHIFT (0x00000008u)

#define MCASP_RMASK_RMASK7 (0x00000080u)
#define MCASP_RMASK_RMASK7_SHIFT (0x00000007u)

#define MCASP_RMASK_RMASK6 (0x00000040u)
#define MCASP_RMASK_RMASK6_SHIFT (0x00000006u)

#define MCASP_RMASK_RMASK5 (0x00000020u)
#define MCASP_RMASK_RMASK5_SHIFT (0x00000005u)

#define MCASP_RMASK_RMASK4 (0x00000010u)
#define MCASP_RMASK_RMASK4_SHIFT (0x00000004u)

#define MCASP_RMASK_RMASK3 (0x00000008u)
#define MCASP_RMASK_RMASK3_SHIFT (0x00000003u)

#define MCASP_RMASK_RMASK2 (0x00000004u)
#define MCASP_RMASK_RMASK2_SHIFT (0x00000002u)

#define MCASP_RMASK_RMASK1 (0x00000002u)
#define MCASP_RMASK_RMASK1_SHIFT (0x00000001u)

#define MCASP_RMASK_RMASK0 (0x00000001u)
#define MCASP_RMASK_RMASK0_SHIFT (0x00000000u)


/* RFMT */


#define MCASP_RFMT_RDATDLY (0x00030000u)
#define MCASP_RFMT_RDATDLY_SHIFT (0x00000010u)
/*----RDATDLY Tokens----*/
#define MCASP_RFMT_RDATDLY_0BIT (0x00000000u)
#define MCASP_RFMT_RDATDLY_1BIT (0x00000001u)
#define MCASP_RFMT_RDATDLY_2BIT (0x00000002u)
#define MCASP_RFMT_RDATDLY_RESV (0x00000003u)

#define MCASP_RFMT_RRVRS (0x00008000u)
#define MCASP_RFMT_RRVRS_SHIFT (0x0000000Fu)

#define MCASP_RFMT_RPAD (0x00006000u)
#define MCASP_RFMT_RPAD_SHIFT (0x0000000Du)
/*----RPAD Tokens----*/
#define MCASP_RFMT_RPAD_ZERO (0x00000000u)
#define MCASP_RFMT_RPAD_ONE (0x00000001u)
#define MCASP_RFMT_RPAD_RPBIT (0x00000002u)
#define MCASP_RFMT_RPAD_RESV (0x00000003u)

#define MCASP_RFMT_RPBIT (0x00001F00u)
#define MCASP_RFMT_RPBIT_SHIFT (0x00000008u)

#define MCASP_RFMT_RSSZ (0x000000F0u)
#define MCASP_RFMT_RSSZ_SHIFT (0x00000004u)
/*----RSSZ Tokens----*/
#define MCASP_RFMT_RSSZ_8BITS (0x00000003u)
#define MCASP_RFMT_RSSZ_12BITS (0x00000005u)
#define MCASP_RFMT_RSSZ_16BITS (0x00000007u)
#define MCASP_RFMT_RSSZ_20BITS (0x00000009u)
#define MCASP_RFMT_RSSZ_24BITS (0x0000000Bu)
#define MCASP_RFMT_RSSZ_28BITS (0x0000000Du)
#define MCASP_RFMT_RSSZ_32BITS (0x0000000Fu)

#define MCASP_RFMT_RBUSEL (0x00000008u)
#define MCASP_RFMT_RBUSEL_SHIFT (0x00000003u)

#define MCASP_RFMT_RROT (0x00000007u)
#define MCASP_RFMT_RROT_SHIFT (0x00000000u)
/*----RROT Tokens----*/
#define MCASP_RFMT_RROT_NONE (0x00000000u)
#define MCASP_RFMT_RROT_4BITS (0x00000001u)
#define MCASP_RFMT_RROT_8BITS (0x00000002u)
#define MCASP_RFMT_RROT_12BITS (0x00000003u)
#define MCASP_RFMT_RROT_16BITS (0x00000004u)
#define MCASP_RFMT_RROT_20BITS (0x00000005u)
#define MCASP_RFMT_RROT_24BITS (0x00000006u)
#define MCASP_RFMT_RROT_28BITS (0x00000007u)


/* AFSRCTL */


#define MCASP_AFSRCTL_RMOD (0x0000FF80u)
#define MCASP_AFSRCTL_RMOD_SHIFT (0x00000007u)

#define MCASP_AFSRCTL_FRWID (0x00000010u)
#define MCASP_AFSRCTL_FRWID_SHIFT (0x00000004u)

#define MCASP_AFSRCTL_FSRM (0x00000002u)
#define MCASP_AFSRCTL_FSRM_SHIFT (0x00000001u)

#define MCASP_AFSRCTL_FSRP (0x00000001u)
#define MCASP_AFSRCTL_FSRP_SHIFT (0x00000000u)


/* ACLKRCTL */


#define MCASP_ACLKRCTL_CLKRP (0x00000080u)
#define MCASP_ACLKRCTL_CLKRP_SHIFT (0x00000007u)


#define MCASP_ACLKRCTL_CLKRM (0x00000020u)
#define MCASP_ACLKRCTL_CLKRM_SHIFT (0x00000005u)

#define MCASP_ACLKRCTL_CLKRDIV (0x0000001Fu)
#define MCASP_ACLKRCTL_CLKRDIV_SHIFT (0x00000000u)


/* AHCLKRCTL */


#define MCASP_AHCLKRCTL_HCLKRM (0x00008000u)
#define MCASP_AHCLKRCTL_HCLKRM_SHIFT (0x0000000Fu)

#define MCASP_AHCLKRCTL_HCLKRP (0x00004000u)
#define MCASP_AHCLKRCTL_HCLKRP_SHIFT (0x0000000Eu)


#define MCASP_AHCLKRCTL_HCLKRDIV (0x00000FFFu)
#define MCASP_AHCLKRCTL_HCLKRDIV_SHIFT (0x00000000u)


/* RTDM */

#define MCASP_RTDM_RTDMS31 (0x80000000u)
#define MCASP_RTDM_RTDMS31_SHIFT (0x0000001Fu)

#define MCASP_RTDM_RTDMS30 (0x40000000u)
#define MCASP_RTDM_RTDMS30_SHIFT (0x0000001Eu)

#define MCASP_RTDM_RTDMS29 (0x20000000u)
#define MCASP_RTDM_RTDMS29_SHIFT (0x0000001Du)

#define MCASP_RTDM_RTDMS28 (0x10000000u)
#define MCASP_RTDM_RTDMS28_SHIFT (0x0000001Cu)

#define MCASP_RTDM_RTDMS27 (0x08000000u)
#define MCASP_RTDM_RTDMS27_SHIFT (0x0000001Bu)

#define MCASP_RTDM_RTDMS26 (0x04000000u)
#define MCASP_RTDM_RTDMS26_SHIFT (0x0000001Au)

#define MCASP_RTDM_RTDMS25 (0x02000000u)
#define MCASP_RTDM_RTDMS25_SHIFT (0x00000019u)

#define MCASP_RTDM_RTDMS24 (0x01000000u)
#define MCASP_RTDM_RTDMS24_SHIFT (0x00000018u)

#define MCASP_RTDM_RTDMS23 (0x00800000u)
#define MCASP_RTDM_RTDMS23_SHIFT (0x00000017u)

#define MCASP_RTDM_RTDMS22 (0x00400000u)
#define MCASP_RTDM_RTDMS22_SHIFT (0x00000016u)

#define MCASP_RTDM_RTDMS21 (0x00200000u)
#define MCASP_RTDM_RTDMS21_SHIFT (0x00000015u)

#define MCASP_RTDM_RTDMS20 (0x00100000u)
#define MCASP_RTDM_RTDMS20_SHIFT (0x00000014u)

#define MCASP_RTDM_RTDMS19 (0x00080000u)
#define MCASP_RTDM_RTDMS19_SHIFT (0x00000013u)

#define MCASP_RTDM_RTDMS18 (0x00040000u)
#define MCASP_RTDM_RTDMS18_SHIFT (0x00000012u)

#define MCASP_RTDM_RTDMS17 (0x00020000u)
#define MCASP_RTDM_RTDMS17_SHIFT (0x00000011u)

#define MCASP_RTDM_RTDMS16 (0x00010000u)
#define MCASP_RTDM_RTDMS16_SHIFT (0x00000010u)

#define MCASP_RTDM_RTDMS15 (0x00008000u)
#define MCASP_RTDM_RTDMS15_SHIFT (0x0000000Fu)

#define MCASP_RTDM_RTDMS14 (0x00004000u)
#define MCASP_RTDM_RTDMS14_SHIFT (0x0000000Eu)

#define MCASP_RTDM_RTDMS13 (0x00002000u)
#define MCASP_RTDM_RTDMS13_SHIFT (0x0000000Du)

#define MCASP_RTDM_RTDMS12 (0x00001000u)
#define MCASP_RTDM_RTDMS12_SHIFT (0x0000000Cu)

#define MCASP_RTDM_RTDMS11 (0x00000800u)
#define MCASP_RTDM_RTDMS11_SHIFT (0x0000000Bu)

#define MCASP_RTDM_RTDMS10 (0x00000400u)
#define MCASP_RTDM_RTDMS10_SHIFT (0x0000000Au)

#define MCASP_RTDM_RTDMS9 (0x00000200u)
#define MCASP_RTDM_RTDMS9_SHIFT (0x00000009u)

#define MCASP_RTDM_RTDMS8 (0x00000100u)
#define MCASP_RTDM_RTDMS8_SHIFT (0x00000008u)

#define MCASP_RTDM_RTDMS7 (0x00000080u)
#define MCASP_RTDM_RTDMS7_SHIFT (0x00000007u)

#define MCASP_RTDM_RTDMS6 (0x00000040u)
#define MCASP_RTDM_RTDMS6_SHIFT (0x00000006u)

#define MCASP_RTDM_RTDMS5 (0x00000020u)
#define MCASP_RTDM_RTDMS5_SHIFT (0x00000005u)

#define MCASP_RTDM_RTDMS4 (0x00000010u)
#define MCASP_RTDM_RTDMS4_SHIFT (0x00000004u)

#define MCASP_RTDM_RTDMS3 (0x00000008u)
#define MCASP_RTDM_RTDMS3_SHIFT (0x00000003u)

#define MCASP_RTDM_RTDMS2 (0x00000004u)
#define MCASP_RTDM_RTDMS2_SHIFT (0x00000002u)

#define MCASP_RTDM_RTDMS1 (0x00000002u)
#define MCASP_RTDM_RTDMS1_SHIFT (0x00000001u)

#define MCASP_RTDM_RTDMS0 (0x00000001u)
#define MCASP_RTDM_RTDMS0_SHIFT (0x00000000u)


/* RINTCTL */


#define MCASP_RINTCTL_RSTAFRM (0x00000080u)
#define MCASP_RINTCTL_RSTAFRM_SHIFT (0x00000007u)

#define MCASP_RINTCTL_RDATA (0x00000020u)
#define MCASP_RINTCTL_RDATA_SHIFT (0x00000005u)

#define MCASP_RINTCTL_RLAST (0x00000010u)
#define MCASP_RINTCTL_RLAST_SHIFT (0x00000004u)

#define MCASP_RINTCTL_RDMAERR (0x00000008u)
#define MCASP_RINTCTL_RDMAERR_SHIFT (0x00000003u)

#define MCASP_RINTCTL_RCKFAIL (0x00000004u)
#define MCASP_RINTCTL_RCKFAIL_SHIFT (0x00000002u)

#define MCASP_RINTCTL_RSYNCERR (0x00000002u)
#define MCASP_RINTCTL_RSYNCERR_SHIFT (0x00000001u)

#define MCASP_RINTCTL_ROVRN (0x00000001u)
#define MCASP_RINTCTL_ROVRN_SHIFT (0x00000000u)


/* RSTAT */


#define MCASP_RSTAT_RERR (0x00000100u)
#define MCASP_RSTAT_RERR_SHIFT (0x00000008u)

#define MCASP_RSTAT_RDMAERR (0x00000080u)
#define MCASP_RSTAT_RDMAERR_SHIFT (0x00000007u)

#define MCASP_RSTAT_RSTAFRM (0x00000040u)
#define MCASP_RSTAT_RSTAFRM_SHIFT (0x00000006u)

#define MCASP_RSTAT_RDATA (0x00000020u)
#define MCASP_RSTAT_RDATA_SHIFT (0x00000005u)

#define MCASP_RSTAT_RLAST (0x00000010u)
#define MCASP_RSTAT_RLAST_SHIFT (0x00000004u)

#define MCASP_RSTAT_RTDMSLOT (0x00000008u)
#define MCASP_RSTAT_RTDMSLOT_SHIFT (0x00000003u)

#define MCASP_RSTAT_RCKFAIL (0x00000004u)
#define MCASP_RSTAT_RCKFAIL_SHIFT (0x00000002u)

#define MCASP_RSTAT_RSYNCERR (0x00000002u)
#define MCASP_RSTAT_RSYNCERR_SHIFT (0x00000001u)

#define MCASP_RSTAT_ROVRN (0x00000001u)
#define MCASP_RSTAT_ROVRN_SHIFT (0x00000000u)


/* RSLOT */


#define MCASP_RSLOT_RSLOTCNT (0x000003FFu)
#define MCASP_RSLOT_RSLOTCNT_SHIFT (0x00000000u)


/* RCLKCHK */

#define MCASP_RCLKCHK_RCNT (0xFF000000u)
#define MCASP_RCLKCHK_RCNT_SHIFT (0x00000018u)

#define MCASP_RCLKCHK_RMAX (0x00FF0000u)
#define MCASP_RCLKCHK_RMAX_SHIFT (0x00000010u)

#define MCASP_RCLKCHK_RMIN (0x0000FF00u)
#define MCASP_RCLKCHK_RMIN_SHIFT (0x00000008u)


#define MCASP_RCLKCHK_RPS (0x0000000Fu)
#define MCASP_RCLKCHK_RPS_SHIFT (0x00000000u)
/*----RPS Tokens----*/
#define MCASP_RCLKCHK_RPS_DIVBY1 (0x00000000u)
#define MCASP_RCLKCHK_RPS_DIVBY2 (0x00000001u)
#define MCASP_RCLKCHK_RPS_DIVBY4 (0x00000002u)
#define MCASP_RCLKCHK_RPS_DIVBY8 (0x00000003u)
#define MCASP_RCLKCHK_RPS_DIVBY16 (0x00000004u)
#define MCASP_RCLKCHK_RPS_DIVBY32 (0x00000005u)
#define MCASP_RCLKCHK_RPS_DIVBY64 (0x00000006u)
#define MCASP_RCLKCHK_RPS_DIVBY128 (0x00000007u)
#define MCASP_RCLKCHK_RPS_DIVBY256 (0x00000008u)


/* REVTCTL */


#define MCASP_REVTCTL_RDATDMA (0x00000001u)
#define MCASP_REVTCTL_RDATDMA_SHIFT (0x00000000u)


/* XGBLCTL */


#define MCASP_XGBLCTL_XFRST (0x00001000u)
#define MCASP_XGBLCTL_XFRST_SHIFT (0x0000000Cu)

#define MCASP_XGBLCTL_XSMRST (0x00000800u)
#define MCASP_XGBLCTL_XSMRST_SHIFT (0x0000000Bu)

#define MCASP_XGBLCTL_XSRCLR (0x00000400u)
#define MCASP_XGBLCTL_XSRCLR_SHIFT (0x0000000Au)

#define MCASP_XGBLCTL_XHCLKRST (0x00000200u)
#define MCASP_XGBLCTL_XHCLKRST_SHIFT (0x00000009u)

#define MCASP_XGBLCTL_XCLKRST (0x00000100u)
#define MCASP_XGBLCTL_XCLKRST_SHIFT (0x00000008u)


#define MCASP_XGBLCTL_RFRST (0x00000010u)
#define MCASP_XGBLCTL_RFRST_SHIFT (0x00000004u)

#define MCASP_XGBLCTL_RSMRST (0x00000008u)
#define MCASP_XGBLCTL_RSMRST_SHIFT (0x00000003u)

#define MCASP_XGBLCTL_RSRCLKR (0x00000004u)
#define MCASP_XGBLCTL_RSRCLKR_SHIFT (0x00000002u)

#define MCASP_XGBLCTL_RHCLKRST (0x00000002u)
#define MCASP_XGBLCTL_RHCLKRST_SHIFT (0x00000001u)

#define MCASP_XGBLCTL_RCLKRST (0x00000001u)
#define MCASP_XGBLCTL_RCLKRST_SHIFT (0x00000000u)


/* XMASK */

#define MCASP_XMASK_XMASK31 (0x80000000u)
#define MCASP_XMASK_XMASK31_SHIFT (0x0000001Fu)

#define MCASP_XMASK_XMASK30 (0x40000000u)
#define MCASP_XMASK_XMASK30_SHIFT (0x0000001Eu)

#define MCASP_XMASK_XMASK29 (0x20000000u)
#define MCASP_XMASK_XMASK29_SHIFT (0x0000001Du)

#define MCASP_XMASK_XMASK28 (0x10000000u)
#define MCASP_XMASK_XMASK28_SHIFT (0x0000001Cu)

#define MCASP_XMASK_XMASK27 (0x08000000u)
#define MCASP_XMASK_XMASK27_SHIFT (0x0000001Bu)

#define MCASP_XMASK_XMASK26 (0x04000000u)
#define MCASP_XMASK_XMASK26_SHIFT (0x0000001Au)

#define MCASP_XMASK_XMASK25 (0x02000000u)
#define MCASP_XMASK_XMASK25_SHIFT (0x00000019u)

#define MCASP_XMASK_XMASK24 (0x01000000u)
#define MCASP_XMASK_XMASK24_SHIFT (0x00000018u)

#define MCASP_XMASK_XMASK23 (0x00800000u)
#define MCASP_XMASK_XMASK23_SHIFT (0x00000017u)

#define MCASP_XMASK_XMASK22 (0x00400000u)
#define MCASP_XMASK_XMASK22_SHIFT (0x00000016u)

#define MCASP_XMASK_XMASK21 (0x00200000u)
#define MCASP_XMASK_XMASK21_SHIFT (0x00000015u)

#define MCASP_XMASK_XMASK20 (0x00100000u)
#define MCASP_XMASK_XMASK20_SHIFT (0x00000014u)

#define MCASP_XMASK_XMASK19 (0x00080000u)
#define MCASP_XMASK_XMASK19_SHIFT (0x00000013u)

#define MCASP_XMASK_XMASK18 (0x00040000u)
#define MCASP_XMASK_XMASK18_SHIFT (0x00000012u)

#define MCASP_XMASK_XMASK17 (0x00020000u)
#define MCASP_XMASK_XMASK17_SHIFT (0x00000011u)

#define MCASP_XMASK_XMASK16 (0x00010000u)
#define MCASP_XMASK_XMASK16_SHIFT (0x00000010u)

#define MCASP_XMASK_XMASK15 (0x00008000u)
#define MCASP_XMASK_XMASK15_SHIFT (0x0000000Fu)

#define MCASP_XMASK_XMASK14 (0x00004000u)
#define MCASP_XMASK_XMASK14_SHIFT (0x0000000Eu)

#define MCASP_XMASK_XMASK13 (0x00002000u)
#define MCASP_XMASK_XMASK13_SHIFT (0x0000000Du)

#define MCASP_XMASK_XMASK12 (0x00001000u)
#define MCASP_XMASK_XMASK12_SHIFT (0x0000000Cu)

#define MCASP_XMASK_XMASK11 (0x00000800u)
#define MCASP_XMASK_XMASK11_SHIFT (0x0000000Bu)

#define MCASP_XMASK_XMASK10 (0x00000400u)
#define MCASP_XMASK_XMASK10_SHIFT (0x0000000Au)

#define MCASP_XMASK_XMASK9 (0x00000200u)
#define MCASP_XMASK_XMASK9_SHIFT (0x00000009u)

#define MCASP_XMASK_XMASK8 (0x00000100u)
#define MCASP_XMASK_XMASK8_SHIFT (0x00000008u)

#define MCASP_XMASK_XMASK7 (0x00000080u)
#define MCASP_XMASK_XMASK7_SHIFT (0x00000007u)

#define MCASP_XMASK_XMASK6 (0x00000040u)
#define MCASP_XMASK_XMASK6_SHIFT (0x00000006u)

#define MCASP_XMASK_XMASK5 (0x00000020u)
#define MCASP_XMASK_XMASK5_SHIFT (0x00000005u)

#define MCASP_XMASK_XMASK4 (0x00000010u)
#define MCASP_XMASK_XMASK4_SHIFT (0x00000004u)

#define MCASP_XMASK_XMASK3 (0x00000008u)
#define MCASP_XMASK_XMASK3_SHIFT (0x00000003u)

#define MCASP_XMASK_XMASK2 (0x00000004u)
#define MCASP_XMASK_XMASK2_SHIFT (0x00000002u)

#define MCASP_XMASK_XMASK1 (0x00000002u)
#define MCASP_XMASK_XMASK1_SHIFT (0x00000001u)

#define MCASP_XMASK_XMASK0 (0x00000001u)
#define MCASP_XMASK_XMASK0_SHIFT (0x00000000u)


/* XFMT */


#define MCASP_XFMT_XDATDLY (0x00030000u)
#define MCASP_XFMT_XDATDLY_SHIFT (0x00000010u)
/*----XDATDLY Tokens----*/
#define MCASP_XFMT_XDATDLY_0BIT (0x00000000u)
#define MCASP_XFMT_XDATDLY_1BIT (0x00000001u)
#define MCASP_XFMT_XDATDLY_2BIT (0x00000002u)

#define MCASP_XFMT_XRVRS (0x00008000u)
#define MCASP_XFMT_XRVRS_SHIFT (0x0000000Fu)

#define MCASP_XFMT_XPAD (0x00006000u)
#define MCASP_XFMT_XPAD_SHIFT (0x0000000Du)

#define MCASP_XFMT_XPBIT (0x00001F00u)
#define MCASP_XFMT_XPBIT_SHIFT (0x00000008u)

#define MCASP_XFMT_XSSZ (0x000000F0u)
#define MCASP_XFMT_XSSZ_SHIFT (0x00000004u)
/*----XSSZ Tokens----*/
#define MCASP_XFMT_XSSZ_8BITS (0x00000003u)
#define MCASP_XFMT_XSSZ_12BITS (0x00000005u)
#define MCASP_XFMT_XSSZ_16BITS (0x00000007u)
#define MCASP_XFMT_XSSZ_20BITS (0x00000009u)
#define MCASP_XFMT_XSSZ_24BITS (0x0000000Bu)
#define MCASP_XFMT_XSSZ_28BITS (0x0000000Du)
#define MCASP_XFMT_XSSZ_32BITS (0x0000000Fu)

#define MCASP_XFMT_XBUSEL (0x00000008u)
#define MCASP_XFMT_XBUSEL_SHIFT (0x00000003u)

#define MCASP_XFMT_XROT (0x00000007u)
#define MCASP_XFMT_XROT_SHIFT (0x00000000u)
/*----XROT Tokens----*/
#define MCASP_XFMT_XROT_NONE (0x00000000u)
#define MCASP_XFMT_XROT_4BITS (0x00000001u)
#define MCASP_XFMT_XROT_8BITS (0x00000002u)
#define MCASP_XFMT_XROT_12BITS (0x00000003u)
#define MCASP_XFMT_XROT_16BITS (0x00000004u)
#define MCASP_XFMT_XROT_20BITS (0x00000005u)
#define MCASP_XFMT_XROT_24BITS (0x00000006u)
#define MCASP_XFMT_XROT_28BITS (0x00000007u)


/* AFSXCTL */


#define MCASP_AFSXCTL_XMOD (0x0000FF80u)
#define MCASP_AFSXCTL_XMOD_SHIFT (0x00000007u)

#define MCASP_AFSXCTL_FXWID (0x00000010u)
#define MCASP_AFSXCTL_FXWID_SHIFT (0x00000004u)

#define MCASP_AFSXCTL_FSXM (0x00000002u)
#define MCASP_AFSXCTL_FSXM_SHIFT (0x00000001u)

#define MCASP_AFSXCTL_FSXP (0x00000001u)
#define MCASP_AFSXCTL_FSXP_SHIFT (0x00000000u)

/* ACLKXCTL */


#define MCASP_ACLKXCTL_CLKXP (0x00000080u)
#define MCASP_ACLKXCTL_CLKXP_SHIFT (0x00000007u)

#define MCASP_ACLKXCTL_ASYNC (0x00000040u)
#define MCASP_ACLKXCTL_ASYNC_SHIFT (0x00000006u)

#define MCASP_ACLKXCTL_CLKXM (0x00000020u)
#define MCASP_ACLKXCTL_CLKXM_SHIFT (0x00000005u)

#define MCASP_ACLKXCTL_CLKXDIV (0x0000001Fu)
#define MCASP_ACLKXCTL_CLKXDIV_SHIFT (0x00000000u)


/* AHCLKXCTL */


#define MCASP_AHCLKXCTL_HCLKXM (0x00008000u)
#define MCASP_AHCLKXCTL_HCLKXM_SHIFT (0x0000000Fu)

#define MCASP_AHCLKXCTL_HCLKXP (0x00004000u)
#define MCASP_AHCLKXCTL_HCLKXP_SHIFT (0x0000000Eu)


#define MCASP_AHCLKXCTL_HCLKXDIV (0x00000FFFu)
#define MCASP_AHCLKXCTL_HCLKXDIV_SHIFT (0x00000000u)


/* XTDM */

#define MCASP_XTDM_XTDMS31 (0x80000000u)
#define MCASP_XTDM_XTDMS31_SHIFT (0x0000001Fu)

#define MCASP_XTDM_XTDMS30 (0x40000000u)
#define MCASP_XTDM_XTDMS30_SHIFT (0x0000001Eu)

#define MCASP_XTDM_XTDMS29 (0x20000000u)
#define MCASP_XTDM_XTDMS29_SHIFT (0x0000001Du)

#define MCASP_XTDM_XTDMS28 (0x10000000u)
#define MCASP_XTDM_XTDMS28_SHIFT (0x0000001Cu)

#define MCASP_XTDM_XTDMS27 (0x08000000u)
#define MCASP_XTDM_XTDMS27_SHIFT (0x0000001Bu)

#define MCASP_XTDM_XTDMS26 (0x04000000u)
#define MCASP_XTDM_XTDMS26_SHIFT (0x0000001Au)

#define MCASP_XTDM_XTDMS25 (0x02000000u)
#define MCASP_XTDM_XTDMS25_SHIFT (0x00000019u)

#define MCASP_XTDM_XTDMS24 (0x01000000u)
#define MCASP_XTDM_XTDMS24_SHIFT (0x00000018u)

#define MCASP_XTDM_XTDMS23 (0x00800000u)
#define MCASP_XTDM_XTDMS23_SHIFT (0x00000017u)

#define MCASP_XTDM_XTDMS22 (0x00400000u)
#define MCASP_XTDM_XTDMS22_SHIFT (0x00000016u)

#define MCASP_XTDM_XTDMS21 (0x00200000u)
#define MCASP_XTDM_XTDMS21_SHIFT (0x00000015u)

#define MCASP_XTDM_XTDMS20 (0x00100000u)
#define MCASP_XTDM_XTDMS20_SHIFT (0x00000014u)

#define MCASP_XTDM_XTDMS19 (0x00080000u)
#define MCASP_XTDM_XTDMS19_SHIFT (0x00000013u)

#define MCASP_XTDM_XTDMS18 (0x00040000u)
#define MCASP_XTDM_XTDMS18_SHIFT (0x00000012u)

#define MCASP_XTDM_XTDMS17 (0x00020000u)
#define MCASP_XTDM_XTDMS17_SHIFT (0x00000011u)

#define MCASP_XTDM_XTDMS16 (0x00010000u)
#define MCASP_XTDM_XTDMS16_SHIFT (0x00000010u)

#define MCASP_XTDM_XTDMS15 (0x00008000u)
#define MCASP_XTDM_XTDMS15_SHIFT (0x0000000Fu)

#define MCASP_XTDM_XTDMS14 (0x00004000u)
#define MCASP_XTDM_XTDMS14_SHIFT (0x0000000Eu)

#define MCASP_XTDM_XTDMS13 (0x00002000u)
#define MCASP_XTDM_XTDMS13_SHIFT (0x0000000Du)

#define MCASP_XTDM_XTDMS12 (0x00001000u)
#define MCASP_XTDM_XTDMS12_SHIFT (0x0000000Cu)

#define MCASP_XTDM_XTDMS11 (0x00000800u)
#define MCASP_XTDM_XTDMS11_SHIFT (0x0000000Bu)

#define MCASP_XTDM_XTDMS10 (0x00000400u)
#define MCASP_XTDM_XTDMS10_SHIFT (0x0000000Au)

#define MCASP_XTDM_XTDMS9 (0x00000200u)
#define MCASP_XTDM_XTDMS9_SHIFT (0x00000009u)

#define MCASP_XTDM_XTDMS8 (0x00000100u)
#define MCASP_XTDM_XTDMS8_SHIFT (0x00000008u)

#define MCASP_XTDM_XTDMS7 (0x00000080u)
#define MCASP_XTDM_XTDMS7_SHIFT (0x00000007u)

#define MCASP_XTDM_XTDMS6 (0x00000040u)
#define MCASP_XTDM_XTDMS6_SHIFT (0x00000006u)

#define MCASP_XTDM_XTDMS5 (0x00000020u)
#define MCASP_XTDM_XTDMS5_SHIFT (0x00000005u)

#define MCASP_XTDM_XTDMS4 (0x00000010u)
#define MCASP_XTDM_XTDMS4_SHIFT (0x00000004u)

#define MCASP_XTDM_XTDMS3 (0x00000008u)
#define MCASP_XTDM_XTDMS3_SHIFT (0x00000003u)

#define MCASP_XTDM_XTDMS2 (0x00000004u)
#define MCASP_XTDM_XTDMS2_SHIFT (0x00000002u)

#define MCASP_XTDM_XTDMS1 (0x00000002u)
#define MCASP_XTDM_XTDMS1_SHIFT (0x00000001u)

#define MCASP_XTDM_XTDMS0 (0x00000001u)
#define MCASP_XTDM_XTDMS0_SHIFT (0x00000000u)


/* XINTCTL */


#define MCASP_XINTCTL_XSTAFRM (0x00000080u)
#define MCASP_XINTCTL_XSTAFRM_SHIFT (0x00000007u)

#define MCASP_XINTCTL_XDATA (0x00000020u)
#define MCASP_XINTCTL_XDATA_SHIFT (0x00000005u)

#define MCASP_XINTCTL_XLAST (0x00000010u)
#define MCASP_XINTCTL_XLAST_SHIFT (0x00000004u)

#define MCASP_XINTCTL_XDMAERR (0x00000008u)
#define MCASP_XINTCTL_XDMAERR_SHIFT (0x00000003u)

#define MCASP_XINTCTL_XCKFAIL (0x00000004u)
#define MCASP_XINTCTL_XCKFAIL_SHIFT (0x00000002u)

#define MCASP_XINTCTL_XSYNCERR (0x00000002u)
#define MCASP_XINTCTL_XSYNCERR_SHIFT (0x00000001u)

#define MCASP_XINTCTL_XUNDRN (0x00000001u)
#define MCASP_XINTCTL_XUNDRN_SHIFT (0x00000000u)


/* XSTAT */


#define MCASP_XSTAT_XERR (0x00000100u)
#define MCASP_XSTAT_XERR_SHIFT (0x00000008u)

#define MCASP_XSTAT_XDMAERR (0x00000080u)
#define MCASP_XSTAT_XDMAERR_SHIFT (0x00000007u)

#define MCASP_XSTAT_XSTAFRM (0x00000040u)
#define MCASP_XSTAT_XSTAFRM_SHIFT (0x00000006u)

#define MCASP_XSTAT_XDATA (0x00000020u)
#define MCASP_XSTAT_XDATA_SHIFT (0x00000005u)

#define MCASP_XSTAT_XLAST (0x00000010u)
#define MCASP_XSTAT_XLAST_SHIFT (0x00000004u)

#define MCASP_XSTAT_XTDMSLOT (0x00000008u)
#define MCASP_XSTAT_XTDMSLOT_SHIFT (0x00000003u)

#define MCASP_XSTAT_XCKFAIL (0x00000004u)
#define MCASP_XSTAT_XCKFAIL_SHIFT (0x00000002u)

#define MCASP_XSTAT_XSYNCERR (0x00000002u)
#define MCASP_XSTAT_XSYNCERR_SHIFT (0x00000001u)

#define MCASP_XSTAT_XUNDRN (0x00000001u)
#define MCASP_XSTAT_XUNDRN_SHIFT (0x00000000u)


/* XSLOT */


#define MCASP_XSLOT_XSLOTCNT (0x000003FFu)
#define MCASP_XSLOT_XSLOTCNT_SHIFT (0x00000000u)


/* XCLKCHK */

#define MCASP_XCLKCHK_XCNT (0xFF000000u)
#define MCASP_XCLKCHK_XCNT_SHIFT (0x00000018u)

#define MCASP_XCLKCHK_XMAX (0x00FF0000u)
#define MCASP_XCLKCHK_XMAX_SHIFT (0x00000010u)

#define MCASP_XCLKCHK_XMIN (0x0000FF00u)
#define MCASP_XCLKCHK_XMIN_SHIFT (0x00000008u)



#define MCASP_XCLKCHK_XPS (0x0000000Fu)
#define MCASP_XCLKCHK_XPS_SHIFT (0x00000000u)
/*----XPS Tokens----*/
#define MCASP_XCLKCHK_XPS_DIVBY1 (0x00000000u)
#define MCASP_XCLKCHK_XPS_DIVBY2 (0x00000001u)
#define MCASP_XCLKCHK_XPS_DIVBY4 (0x00000002u)
#define MCASP_XCLKCHK_XPS_DIVBY8 (0x00000003u)
#define MCASP_XCLKCHK_XPS_DIVBY16 (0x00000004u)
#define MCASP_XCLKCHK_XPS_DIVBY32 (0x00000005u)
#define MCASP_XCLKCHK_XPS_DIVBY64 (0x00000006u)
#define MCASP_XCLKCHK_XPS_DIVBY128 (0x00000007u)
#define MCASP_XCLKCHK_XPS_DIVBY256 (0x00000008u)


/* XEVTCTL */


#define MCASP_XEVTCTL_XDATDMA (0x00000001u)
#define MCASP_XEVTCTL_XDATDMA_SHIFT (0x00000000u)


/* DITCSRA0 */

#define MCASP_DITCSRA0_DITCSRA0 (0xFFFFFFFFu)
#define MCASP_DITCSRA0_DITCSRA0_SHIFT (0x00000000u)


/* DITCSRA1 */

#define MCASP_DITCSRA1_DITCSRA1 (0xFFFFFFFFu)
#define MCASP_DITCSRA1_DITCSRA1_SHIFT (0x00000000u)


/* DITCSRA2 */

#define MCASP_DITCSRA2_DITCSRA2 (0xFFFFFFFFu)
#define MCASP_DITCSRA2_DITCSRA2_SHIFT (0x00000000u)


/* DITCSRA3 */

#define MCASP_DITCSRA3_DITCSRA3 (0xFFFFFFFFu)
#define MCASP_DITCSRA3_DITCSRA3_SHIFT (0x00000000u)


/* DITCSRA4 */

#define MCASP_DITCSRA4_DITCSRA4 (0xFFFFFFFFu)
#define MCASP_DITCSRA4_DITCSRA4_SHIFT (0x00000000u)


/* DITCSRA5 */

#define MCASP_DITCSRA5_DITCSRA5 (0xFFFFFFFFu)
#define MCASP_DITCSRA5_DITCSRA5_SHIFT (0x00000000u)


/* DITCSRB0 */

#define MCASP_DITCSRB0_DITCSRB0 (0xFFFFFFFFu)
#define MCASP_DITCSRB0_DITCSRB0_SHIFT (0x00000000u)


/* DITCSRB1 */

#define MCASP_DITCSRB1_DITCSRB1 (0xFFFFFFFFu)
#define MCASP_DITCSRB1_DITCSRB1_SHIFT (0x00000000u)


/* DITCSRB2 */

#define MCASP_DITCSRB2_DITCSRB2 (0xFFFFFFFFu)
#define MCASP_DITCSRB2_DITCSRB2_SHIFT (0x00000000u)


/* DITCSRB3 */

#define MCASP_DITCSRB3_DITCSRB3 (0xFFFFFFFFu)
#define MCASP_DITCSRB3_DITCSRB3_SHIFT (0x00000000u)


/* DITCSRB4 */

#define MCASP_DITCSRB4_DITCSRB4 (0xFFFFFFFFu)
#define MCASP_DITCSRB4_DITCSRB4_SHIFT (0x00000000u)


/* DITCSRB5 */

#define MCASP_DITCSRB5_DITCSRB5 (0xFFFFFFFFu)
#define MCASP_DITCSRB5_DITCSRB5_SHIFT (0x00000000u)


/* DITUDRA0 */

#define MCASP_DITUDRA0_DITUDRA0 (0xFFFFFFFFu)
#define MCASP_DITUDRA0_DITUDRA0_SHIFT (0x00000000u)


/* DITUDRA1 */

#define MCASP_DITUDRA1_DITUDRA1 (0xFFFFFFFFu)
#define MCASP_DITUDRA1_DITUDRA1_SHIFT (0x00000000u)


/* DITUDRA2 */

#define MCASP_DITUDRA2_DITUDRA2 (0xFFFFFFFFu)
#define MCASP_DITUDRA2_DITUDRA2_SHIFT (0x00000000u)


/* DITUDRA3 */

#define MCASP_DITUDRA3_DITUDRA3 (0xFFFFFFFFu)
#define MCASP_DITUDRA3_DITUDRA3_SHIFT (0x00000000u)


/* DITUDRA4 */

#define MCASP_DITUDRA4_DITUDRA4 (0xFFFFFFFFu)
#define MCASP_DITUDRA4_DITUDRA4_SHIFT (0x00000000u)


/* DITUDRA5 */

#define MCASP_DITUDRA5_DITUDRA5 (0xFFFFFFFFu)
#define MCASP_DITUDRA5_DITUDRA5_SHIFT (0x00000000u)


/* DITUDRB0 */

#define MCASP_DITUDRB0_DITUDRB0 (0xFFFFFFFFu)
#define MCASP_DITUDRB0_DITUDRB0_SHIFT (0x00000000u)


/* DITUDRB1 */

#define MCASP_DITUDRB1_DITUDRB1 (0xFFFFFFFFu)
#define MCASP_DITUDRB1_DITUDRB1_SHIFT (0x00000000u)


/* DITUDRB2 */

#define MCASP_DITUDRB2_DITUDRB2 (0xFFFFFFFFu)
#define MCASP_DITUDRB2_DITUDRB2_SHIFT (0x00000000u)


/* DITUDRB3 */

#define MCASP_DITUDRB3_DITUDRB3 (0xFFFFFFFFu)
#define MCASP_DITUDRB3_DITUDRB3_SHIFT (0x00000000u)


/* DITUDRB4 */

#define MCASP_DITUDRB4_DITUDRB4 (0xFFFFFFFFu)
#define MCASP_DITUDRB4_DITUDRB4_SHIFT (0x00000000u)


/* DITUDRB5 */

#define MCASP_DITUDRB5_DITUDRB5 (0xFFFFFFFFu)
#define MCASP_DITUDRB5_DITUDRB5_SHIFT (0x00000000u)

#define MCASP_SRCTL_SRMOD_TX  (0x00000001u)
#define MCASP_SRCTL_SRMOD_RX  (0x00000002u)

/* SRCTL0 */


#define MCASP_SRCTL0_RRDY (0x00000020u)
#define MCASP_SRCTL0_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL0_XRDY (0x00000010u)
#define MCASP_SRCTL0_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL0_DISMOD (0x0000000Cu)
#define MCASP_SRCTL0_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL0_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL0_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL0_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL0_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL0_SRMOD (0x00000003u)
#define MCASP_SRCTL0_SRMOD_SHIFT (0x00000000u)


/* SRCTL1 */


#define MCASP_SRCTL1_RRDY (0x00000020u)
#define MCASP_SRCTL1_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL1_XRDY (0x00000010u)
#define MCASP_SRCTL1_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL1_DISMOD (0x0000000Cu)
#define MCASP_SRCTL1_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL1_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL1_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL1_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL1_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL1_SRMOD (0x00000003u)
#define MCASP_SRCTL1_SRMOD_SHIFT (0x00000000u)
/*----SRMOD Tokens----*/
#define MCASP_SRCTL1_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL1_SRMOD_RCV (0x00000002u)


/* SRCTL2 */


#define MCASP_SRCTL2_RRDY (0x00000020u)
#define MCASP_SRCTL2_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL2_XRDY (0x00000010u)
#define MCASP_SRCTL2_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL2_DISMOD (0x0000000Cu)
#define MCASP_SRCTL2_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL2_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL2_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL2_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL2_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL2_SRMOD (0x00000003u)
#define MCASP_SRCTL2_SRMOD_SHIFT (0x00000000u)
/*----SRMOD Tokens----*/
#define MCASP_SRCTL2_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL2_SRMOD_RCV (0x00000002u)


/* SRCTL3 */


#define MCASP_SRCTL3_RRDY (0x00000020u)
#define MCASP_SRCTL3_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL3_XRDY (0x00000010u)
#define MCASP_SRCTL3_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL3_DISMOD (0x0000000Cu)
#define MCASP_SRCTL3_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL3_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL3_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL3_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL3_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL3_SRMOD (0x00000003u)
#define MCASP_SRCTL3_SRMOD_SHIFT (0x00000000u)


/* SRCTL4 */


#define MCASP_SRCTL4_RRDY (0x00000020u)
#define MCASP_SRCTL4_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL4_XRDY (0x00000010u)
#define MCASP_SRCTL4_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL4_DISMOD (0x0000000Cu)
#define MCASP_SRCTL4_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL4_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL4_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL4_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL4_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL4_SRMOD (0x00000003u)
#define MCASP_SRCTL4_SRMOD_SHIFT (0x00000000u)


/* SRCTL5 */


#define MCASP_SRCTL5_RRDY (0x00000020u)
#define MCASP_SRCTL5_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL5_XRDY (0x00000010u)
#define MCASP_SRCTL5_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL5_DISMOD (0x0000000Cu)
#define MCASP_SRCTL5_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL5_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL5_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL5_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL5_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL5_SRMOD (0x00000003u)
#define MCASP_SRCTL5_SRMOD_SHIFT (0x00000000u)
/*----SRMOD Tokens----*/
#define MCASP_SRCTL5_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL5_SRMOD_RCV (0x00000002u)


/* SRCTL6 */


#define MCASP_SRCTL6_RRDY (0x00000020u)
#define MCASP_SRCTL6_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL6_XRDY (0x00000010u)
#define MCASP_SRCTL6_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL6_DISMOD (0x0000000Cu)
#define MCASP_SRCTL6_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL6_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL6_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL6_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL6_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL6_SRMOD (0x00000003u)
#define MCASP_SRCTL6_SRMOD_SHIFT (0x00000000u)
/*----SRMOD Tokens----*/
#define MCASP_SRCTL6_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL6_SRMOD_RCV (0x00000002u)


/* SRCTL7 */


#define MCASP_SRCTL7_RRDY (0x00000020u)
#define MCASP_SRCTL7_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL7_XRDY (0x00000010u)
#define MCASP_SRCTL7_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL7_DISMOD (0x0000000Cu)
#define MCASP_SRCTL7_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL7_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL7_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL7_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL7_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL7_SRMOD (0x00000003u)
#define MCASP_SRCTL7_SRMOD_SHIFT (0x00000000u)
/*----SRMOD Tokens----*/
#define MCASP_SRCTL7_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL7_SRMOD_RCV (0x00000002u)


/* SRCTL8 */


#define MCASP_SRCTL8_RRDY (0x00000020u)
#define MCASP_SRCTL8_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL8_XRDY (0x00000010u)
#define MCASP_SRCTL8_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL8_DISMOD (0x0000000Cu)
#define MCASP_SRCTL8_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL8_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL8_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL8_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL8_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL8_SRMOD (0x00000003u)
#define MCASP_SRCTL8_SRMOD_SHIFT (0x00000000u)
/*----SRMOD Tokens----*/
#define MCASP_SRCTL8_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL8_SRMOD_RCV (0x00000002u)


/* SRCTL9 */


#define MCASP_SRCTL9_RRDY (0x00000020u)
#define MCASP_SRCTL9_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL9_XRDY (0x00000010u)
#define MCASP_SRCTL9_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL9_DISMOD (0x0000000Cu)
#define MCASP_SRCTL9_DISMOD_SHIFT (0x00000002u)
/*----DISMOD Tokens----*/
#define MCASP_SRCTL9_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL9_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL9_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL9_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL9_SRMOD (0x00000003u)
#define MCASP_SRCTL9_SRMOD_SHIFT (0x00000000u)
/*----SRMOD Tokens----*/
#define MCASP_SRCTL9_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL9_SRMOD_RCV (0x00000002u)

/* SRCTL10 */


#define MCASP_SRCTL10_RRDY (0x00000020u)
#define MCASP_SRCTL10_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL10_XRDY (0x00000010u)
#define MCASP_SRCTL10_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL10_DISMOD (0x0000000Cu)
#define MCASP_SRCTL10_DISMOD_SHIFT (0x00000002u)
#define MCASP_SRCTL10_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL10_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL10_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL10_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL10_SRMOD (0x00000003u)
#define MCASP_SRCTL10_SRMOD_SHIFT (0x00000000u)
#define MCASP_SRCTL10_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL10_SRMOD_RCV (0x00000002u)


/* SRCTL11 */


#define MCASP_SRCTL11_RRDY (0x00000020u)
#define MCASP_SRCTL11_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL11_XRDY (0x00000010u)
#define MCASP_SRCTL11_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL11_DISMOD (0x0000000Cu)
#define MCASP_SRCTL11_DISMOD_SHIFT (0x00000002u)
#define MCASP_SRCTL11_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL11_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL11_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL11_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL11_SRMOD (0x00000003u)
#define MCASP_SRCTL11_SRMOD_SHIFT (0x00000000u)
#define MCASP_SRCTL11_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL11_SRMOD_RCV (0x00000002u)


/* SRCTL12 */


#define MCASP_SRCTL12_RRDY (0x00000020u)
#define MCASP_SRCTL12_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL12_XRDY (0x00000010u)
#define MCASP_SRCTL12_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL12_DISMOD (0x0000000Cu)
#define MCASP_SRCTL12_DISMOD_SHIFT (0x00000002u)
#define MCASP_SRCTL12_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL12_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL12_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL12_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL12_SRMOD (0x00000003u)
#define MCASP_SRCTL12_SRMOD_SHIFT (0x00000000u)
#define MCASP_SRCTL12_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL12_SRMOD_RCV (0x00000002u)


/* SRCTL13 */


#define MCASP_SRCTL13_RRDY (0x00000020u)
#define MCASP_SRCTL13_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL13_XRDY (0x00000010u)
#define MCASP_SRCTL13_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL13_DISMOD (0x0000000Cu)
#define MCASP_SRCTL13_DISMOD_SHIFT (0x00000002u)
#define MCASP_SRCTL13_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL13_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL13_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL13_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL13_SRMOD (0x00000003u)
#define MCASP_SRCTL13_SRMOD_SHIFT (0x00000000u)
#define MCASP_SRCTL13_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL13_SRMOD_RCV (0x00000002u)


/* SRCTL14 */


#define MCASP_SRCTL14_RRDY (0x00000020u)
#define MCASP_SRCTL14_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL14_XRDY (0x00000010u)
#define MCASP_SRCTL14_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL14_DISMOD (0x0000000Cu)
#define MCASP_SRCTL14_DISMOD_SHIFT (0x00000002u)
#define MCASP_SRCTL14_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL14_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL14_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL14_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL14_SRMOD (0x00000003u)
#define MCASP_SRCTL14_SRMOD_SHIFT (0x00000000u)
#define MCASP_SRCTL14_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL14_SRMOD_RCV (0x00000002u)


/* SRCTL15 */


#define MCASP_SRCTL15_RRDY (0x00000020u)
#define MCASP_SRCTL15_RRDY_SHIFT (0x00000005u)

#define MCASP_SRCTL15_XRDY (0x00000010u)
#define MCASP_SRCTL15_XRDY_SHIFT (0x00000004u)

#define MCASP_SRCTL15_DISMOD (0x0000000Cu)
#define MCASP_SRCTL15_DISMOD_SHIFT (0x00000002u)
#define MCASP_SRCTL15_DISMOD_3STATE (0x00000000u)
#define MCASP_SRCTL15_DISMOD_RSV (0x00000001u)
#define MCASP_SRCTL15_DISMOD_LOW (0x00000002u)
#define MCASP_SRCTL15_DISMOD_HIGH (0x00000003u)

#define MCASP_SRCTL15_SRMOD (0x00000003u)
#define MCASP_SRCTL15_SRMOD_SHIFT (0x00000000u)
#define MCASP_SRCTL15_SRMOD_XMT (0x00000001u)
#define MCASP_SRCTL15_SRMOD_RCV (0x00000002u)


/* XBUF0 */

#define MCASP_XBUF0_XBUF0 (0xFFFFFFFFu)
#define MCASP_XBUF0_XBUF0_SHIFT (0x00000000u)


/* XBUF1 */

#define MCASP_XBUF1_XBUF1 (0xFFFFFFFFu)
#define MCASP_XBUF1_XBUF1_SHIFT (0x00000000u)


/* XBUF2 */

#define MCASP_XBUF2_XBUF2 (0xFFFFFFFFu)
#define MCASP_XBUF2_XBUF2_SHIFT (0x00000000u)


/* XBUF3 */

#define MCASP_XBUF3_XBUF3 (0xFFFFFFFFu)
#define MCASP_XBUF3_XBUF3_SHIFT (0x00000000u)


/* XBUF4 */

#define MCASP_XBUF4_XBUF4 (0xFFFFFFFFu)
#define MCASP_XBUF4_XBUF4_SHIFT (0x00000000u)


/* XBUF5 */

#define MCASP_XBUF5_XBUF5 (0xFFFFFFFFu)
#define MCASP_XBUF5_XBUF5_SHIFT (0x00000000u)


/* XBUF6 */

#define MCASP_XBUF6_XBUF6 (0xFFFFFFFFu)
#define MCASP_XBUF6_XBUF6_SHIFT (0x00000000u)


/* XBUF7 */

#define MCASP_XBUF7_XBUF7 (0xFFFFFFFFu)
#define MCASP_XBUF7_XBUF7_SHIFT (0x00000000u)


/* XBUF8 */

#define MCASP_XBUF8_XBUF8 (0xFFFFFFFFu)
#define MCASP_XBUF8_XBUF8_SHIFT (0x00000000u)


/* XBUF9 */

#define MCASP_XBUF9_XBUF9 (0xFFFFFFFFu)
#define MCASP_XBUF9_XBUF9_SHIFT (0x00000000u)


/* XBUF10 */

#define MCASP_XBUF10_XBUF10 (0xFFFFFFFFu)
#define MCASP_XBUF10_XBUF10_SHIFT (0x00000000u)


/* XBUF11 */

#define MCASP_XBUF11_XBUF11 (0xFFFFFFFFu)
#define MCASP_XBUF11_XBUF11_SHIFT (0x00000000u)


/* XBUF12 */

#define MCASP_XBUF12_XBUF12 (0xFFFFFFFFu)
#define MCASP_XBUF12_XBUF12_SHIFT (0x00000000u)


/* XBUF13 */

#define MCASP_XBUF13_XBUF13 (0xFFFFFFFFu)
#define MCASP_XBUF13_XBUF13_SHIFT (0x00000000u)


/* XBUF14 */

#define MCASP_XBUF14_XBUF14 (0xFFFFFFFFu)
#define MCASP_XBUF14_XBUF14_SHIFT (0x00000000u)


/* XBUF15 */

#define MCASP_XBUF15_XBUF15 (0xFFFFFFFFu)
#define MCASP_XBUF15_XBUF15_SHIFT (0x00000000u)

/* RBUF0 */

#define MCASP_RBUF0_RBUF0 (0xFFFFFFFFu)
#define MCASP_RBUF0_RBUF0_SHIFT (0x00000000u)


/* RBUF1 */

#define MCASP_RBUF1_RBUF1 (0xFFFFFFFFu)
#define MCASP_RBUF1_RBUF1_SHIFT (0x00000000u)


/* RBUF2 */

#define MCASP_RBUF2_RBUF2 (0xFFFFFFFFu)
#define MCASP_RBUF2_RBUF2_SHIFT (0x00000000u)


/* RBUF3 */

#define MCASP_RBUF3_RBUF3 (0xFFFFFFFFu)
#define MCASP_RBUF3_RBUF3_SHIFT (0x00000000u)


/* RBUF4 */

#define MCASP_RBUF4_RBUF4 (0xFFFFFFFFu)
#define MCASP_RBUF4_RBUF4_SHIFT (0x00000000u)


/* RBUF5 */

#define MCASP_RBUF5_RBUF5 (0xFFFFFFFFu)
#define MCASP_RBUF5_RBUF5_SHIFT (0x00000000u)


/* RBUF6 */

#define MCASP_RBUF6_RBUF6 (0xFFFFFFFFu)
#define MCASP_RBUF6_RBUF6_SHIFT (0x00000000u)


/* RBUF7 */

#define MCASP_RBUF7_RBUF7 (0xFFFFFFFFu)
#define MCASP_RBUF7_RBUF7_SHIFT (0x00000000u)


/* RBUF8 */

#define MCASP_RBUF8_RBUF8 (0xFFFFFFFFu)
#define MCASP_RBUF8_RBUF8_SHIFT (0x00000000u)


/* RBUF9 */

#define MCASP_RBUF9_RBUF9 (0xFFFFFFFFu)
#define MCASP_RBUF9_RBUF9_SHIFT (0x00000000u)


/* RBUF10 */

#define MCASP_RBUF10_RBUF10 (0xFFFFFFFFu)
#define MCASP_RBUF10_RBUF10_SHIFT (0x00000000u)


/* RBUF11 */

#define MCASP_RBUF11_RBUF11 (0xFFFFFFFFu)
#define MCASP_RBUF11_RBUF11_SHIFT (0x00000000u)


/* RBUF12 */

#define MCASP_RBUF12_RBUF12 (0xFFFFFFFFu)
#define MCASP_RBUF12_RBUF12_SHIFT (0x00000000u)


/* RBUF13 */

#define MCASP_RBUF13_RBUF13 (0xFFFFFFFFu)
#define MCASP_RBUF13_RBUF13_SHIFT (0x00000000u)


/* RBUF14 */

#define MCASP_RBUF14_RBUF14 (0xFFFFFFFFu)
#define MCASP_RBUF14_RBUF14_SHIFT (0x00000000u)


/* RBUF15 */

#define MCASP_RBUF15_RBUF15 (0xFFFFFFFFu)
#define MCASP_RBUF15_RBUF15_SHIFT (0x00000000u)



/**************************************************************************\
* Field Definition Macros (AFIFO)
\**************************************************************************/

#define AFIFO_REVID_REV (0xFFFFFFFFu)
#define AFIFO_REVID_REV_SHIFT (0x00000000u)


/* WFIFOCTL */


#define AFIFO_WFIFOCTL_WENA (0x00010000u)
#define AFIFO_WFIFOCTL_WENA_SHIFT (0x00000010u)

#define AFIFO_WFIFOCTL_WNUMEVT (0x0000FF00u)
#define AFIFO_WFIFOCTL_WNUMEVT_SHIFT (0x00000008u)
#define AFIFO_WFIFOCTL_WNUMEVT_0WORDS (0x00000000u)
#define AFIFO_WFIFOCTL_WNUMEVT_4WORDS (0x00000004u)
#define AFIFO_WFIFOCTL_WNUMEVT_8WORDS (0x00000008u)
#define AFIFO_WFIFOCTL_WNUMEVT_12WORDS (0x0000000Cu)
#define AFIFO_WFIFOCTL_WNUMEVT_16WORDS (0x00000010u)
#define AFIFO_WFIFOCTL_WNUMEVT_20WORDS (0x00000014u)
#define AFIFO_WFIFOCTL_WNUMEVT_24WORDS (0x00000018u)
#define AFIFO_WFIFOCTL_WNUMEVT_28WORDS (0x0000001Cu)
#define AFIFO_WFIFOCTL_WNUMEVT_32WORDS (0x00000020u)
#define AFIFO_WFIFOCTL_WNUMEVT_36WORDS (0x00000024u)
#define AFIFO_WFIFOCTL_WNUMEVT_40WORDS (0x00000028u)
#define AFIFO_WFIFOCTL_WNUMEVT_44WORDS (0x0000002Cu)
#define AFIFO_WFIFOCTL_WNUMEVT_48WORDS (0x00000030u)
#define AFIFO_WFIFOCTL_WNUMEVT_52WORDS (0x00000034u)
#define AFIFO_WFIFOCTL_WNUMEVT_56WORDS (0x00000038u)
#define AFIFO_WFIFOCTL_WNUMEVT_60WORDS (0x0000003Cu)
#define AFIFO_WFIFOCTL_WNUMEVT_64WORDS (0x00000040u)

#define AFIFO_WFIFOCTL_WNUMDMA (0x000000FFu)
#define AFIFO_WFIFOCTL_WNUMDMA_SHIFT (0x00000000u)
#define AFIFO_WFIFOCTL_WNUMDMA_0WORDS (0x00000000u)
#define AFIFO_WFIFOCTL_WNUMDMA_1WORDS (0x00000001u)
#define AFIFO_WFIFOCTL_WNUMDMA_2WORDS (0x00000002u)
#define AFIFO_WFIFOCTL_WNUMDMA_3WORDS (0x00000003u)
#define AFIFO_WFIFOCTL_WNUMDMA_4WORDS (0x00000004u)
#define AFIFO_WFIFOCTL_WNUMDMA_5WORDS (0x00000005u)
#define AFIFO_WFIFOCTL_WNUMDMA_6WORDS (0x00000006u)
#define AFIFO_WFIFOCTL_WNUMDMA_7WORDS (0x00000007u)
#define AFIFO_WFIFOCTL_WNUMDMA_8WORDS (0x00000008u)
#define AFIFO_WFIFOCTL_WNUMDMA_9WORDS (0x00000009u)
#define AFIFO_WFIFOCTL_WNUMDMA_10WORDS (0x0000000Au)
#define AFIFO_WFIFOCTL_WNUMDMA_11WORDS (0x0000000Bu)
#define AFIFO_WFIFOCTL_WNUMDMA_12WORDS (0x0000000Cu)
#define AFIFO_WFIFOCTL_WNUMDMA_13WORDS (0x0000000Du)
#define AFIFO_WFIFOCTL_WNUMDMA_14WORDS (0x0000000Eu)
#define AFIFO_WFIFOCTL_WNUMDMA_15WORDS (0x0000000Fu)
#define AFIFO_WFIFOCTL_WNUMDMA_16WORDS (0x00000010u)


/* WFIFOSTS */


#define AFIFO_WFIFOSTS_WLVL (0x000000FFu)
#define AFIFO_WFIFOSTS_WLVL_SHIFT (0x00000000u)


/* RFIFOCTL */


#define AFIFO_RFIFOCTL_RENA (0x00010000u)
#define AFIFO_RFIFOCTL_RENA_SHIFT (0x00000010u)

#define AFIFO_RFIFOCTL_RNUMEVT (0x0000FF00u)
#define AFIFO_RFIFOCTL_RNUMEVT_SHIFT (0x00000008u)
#define AFIFO_RFIFOCTL_RNUMEVT_0WORDS (0x00000000u)
#define AFIFO_RFIFOCTL_RNUMEVT_4WORDS (0x00000004u)
#define AFIFO_RFIFOCTL_RNUMEVT_8WORDS (0x00000008u)
#define AFIFO_RFIFOCTL_RNUMEVT_12WORDS (0x0000000Cu)
#define AFIFO_RFIFOCTL_RNUMEVT_16WORDS (0x00000010u)
#define AFIFO_RFIFOCTL_RNUMEVT_20WORDS (0x00000014u)
#define AFIFO_RFIFOCTL_RNUMEVT_24WORDS (0x00000018u)
#define AFIFO_RFIFOCTL_RNUMEVT_28WORDS (0x0000001Cu)
#define AFIFO_RFIFOCTL_RNUMEVT_32WORDS (0x00000020u)
#define AFIFO_RFIFOCTL_RNUMEVT_36WORDS (0x00000024u)
#define AFIFO_RFIFOCTL_RNUMEVT_40WORDS (0x00000028u)
#define AFIFO_RFIFOCTL_RNUMEVT_44WORDS (0x0000002Cu)
#define AFIFO_RFIFOCTL_RNUMEVT_48WORDS (0x00000030u)
#define AFIFO_RFIFOCTL_RNUMEVT_52WORDS (0x00000034u)
#define AFIFO_RFIFOCTL_RNUMEVT_56WORDS (0x00000038u)
#define AFIFO_RFIFOCTL_RNUMEVT_60WORDS (0x0000003Cu)
#define AFIFO_RFIFOCTL_RNUMEVT_64WORDS (0x00000040u)

#define AFIFO_RFIFOCTL_RNUMDMA (0x000000FFu)
#define AFIFO_RFIFOCTL_RNUMDMA_SHIFT (0x00000000u)
#define AFIFO_RFIFOCTL_RNUMDMA_0WORDS (0x00000000u)
#define AFIFO_RFIFOCTL_RNUMDMA_1WORDS (0x00000001u)
#define AFIFO_RFIFOCTL_RNUMDMA_2WORDS (0x00000002u)
#define AFIFO_RFIFOCTL_RNUMDMA_3WORDS (0x00000003u)
#define AFIFO_RFIFOCTL_RNUMDMA_4WORDS (0x00000004u)
#define AFIFO_RFIFOCTL_RNUMDMA_5WORDS (0x00000005u)
#define AFIFO_RFIFOCTL_RNUMDMA_6WORDS (0x00000006u)
#define AFIFO_RFIFOCTL_RNUMDMA_7WORDS (0x00000007u)
#define AFIFO_RFIFOCTL_RNUMDMA_8WORDS (0x00000008u)
#define AFIFO_RFIFOCTL_RNUMDMA_9WORDS (0x00000009u)
#define AFIFO_RFIFOCTL_RNUMDMA_10WORDS (0x0000000Au)
#define AFIFO_RFIFOCTL_RNUMDMA_11WORDS (0x0000000Bu)
#define AFIFO_RFIFOCTL_RNUMDMA_12WORDS (0x0000000Cu)
#define AFIFO_RFIFOCTL_RNUMDMA_13WORDS (0x0000000Du)
#define AFIFO_RFIFOCTL_RNUMDMA_14WORDS (0x0000000Eu)
#define AFIFO_RFIFOCTL_RNUMDMA_15WORDS (0x0000000Fu)
#define AFIFO_RFIFOCTL_RNUMDMA_16WORDS (0x00000010u)


/* RFIFOSTS */


#define AFIFO_RFIFOSTS_RLVL (0x000000FFu)
#define AFIFO_RFIFOSTS_RLVL_SHIFT (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif

