/**
 * \file  hw_mcbsp.h
 *
 * \brief McBSP register definitions
 */

/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



/*********************************************************************
* file: hw_mcbsp.h
*
* Brief: This file contains the Register Description for mcbsp
*
*********************************************************************/
#ifndef _HW_MCBSP_H_
#define _HW_MCBSP_H_

#ifdef __cplusplus
extern "C" {
#endif

#define MCBSP_DRR	(0x0)
#define MCBSP_DXR	(0x4)
#define MCBSP_SPCR	(0x8)
#define MCBSP_RCR	(0xC)
#define MCBSP_XCR	(0x10)
#define MCBSP_SRGR	(0x14)
#define MCBSP_MCR	(0x18)
#define MCBSP_RCERE0	(0x1C)
#define MCBSP_XCERE0	(0x20)
#define MCBSP_PCR	(0x24)
#define MCBSP_RCERE1	(0x28)
#define MCBSP_XCERE1	(0x2C)
#define MCBSP_RCERE2	(0x30)
#define MCBSP_XCERE2	(0x34)
#define MCBSP_RCERE3	(0x38)
#define MCBSP_XCERE3	(0x3C)


#define MCBSP_FIFO_REVID	(0x0)
#define MCBSP_FIFO_WFIFOCTL	(0x10)
#define MCBSP_FIFO_WFIFOSTS	(0x14)
#define MCBSP_FIFO_RFIFOCTL	(0x18)
#define MCBSP_FIFO_RFIFOSTS	(0x1C)

#define MCBSP_DATA_PORT		(0x0)


/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DRR */

#define MCBSP_DRR_DRR           (0xFFFFFFFFu)
#define MCBSP_DRR_DRR_SHIFT          (0x00000000u)


/* DXR */

#define MCBSP_DXR_DXR           (0xFFFFFFFFu)
#define MCBSP_DXR_DXR_SHIFT          (0x00000000u)


/* SPCR */

#define MCBSP_SPCR__RSV         (0xFC000000u)
#define MCBSP_SPCR__RSV_SHIFT        (0x0000001Au)

#define MCBSP_SPCR_FREE         (0x02000000u)
#define MCBSP_SPCR_FREE_SHIFT        (0x00000019u)

#define MCBSP_SPCR_SOFT         (0x01000000u)
#define MCBSP_SPCR_SOFT_SHIFT        (0x00000018u)

#define MCBSP_SPCR_FRST         (0x00800000u)
#define MCBSP_SPCR_FRST_SHIFT        (0x00000017u)

#define MCBSP_SPCR_GRST         (0x00400000u)
#define MCBSP_SPCR_GRST_SHIFT        (0x00000016u)

#define MCBSP_SPCR_XINTM        (0x00300000u)
#define MCBSP_SPCR_XINTM_SHIFT       (0x00000014u)
/*----XINTM Tokens----*/
#define MCBSP_SPCR_XINTM_XRDY        (0x00000000u)
#define MCBSP_SPCR_XINTM_FRM         (0x00000002u)
#define MCBSP_SPCR_XINTM_XSYNCERR    (0x00000003u)

#define MCBSP_SPCR_XSYNCERR     (0x00080000u)
#define MCBSP_SPCR_XSYNCERR_SHIFT    (0x00000013u)

#define MCBSP_SPCR_XEMPTY       (0x00040000u)
#define MCBSP_SPCR_XEMPTY_SHIFT      (0x00000012u)

#define MCBSP_SPCR_XRDY         (0x00020000u)
#define MCBSP_SPCR_XRDY_SHIFT        (0x00000011u)

#define MCBSP_SPCR_XRST         (0x00010000u)
#define MCBSP_SPCR_XRST_SHIFT        (0x00000010u)

#define MCBSP_SPCR_DLB          (0x00008000u)
#define MCBSP_SPCR_DLB_SHIFT         (0x0000000Fu)

#define MCBSP_SPCR_RJUST        (0x00006000u)
#define MCBSP_SPCR_RJUST_SHIFT       (0x0000000Du)
/*----RJUST Tokens----*/
#define MCBSP_SPCR_RJUST_RZF         (0x00000000u)
#define MCBSP_SPCR_RJUST_RSE         (0x00000001u)
#define MCBSP_SPCR_RJUST_LZF         (0x00000002u)

#define MCBSP_SPCR_CLKSTP       (0x00001800u)
#define MCBSP_SPCR_CLKSTP_SHIFT      (0x0000000Bu)
/*----CLKSTP Tokens----*/
#define MCBSP_SPCR_CLKSTP_DISABLE_00 (0x00000000u)
#define MCBSP_SPCR_CLKSTP_DISABLE_01 (0x00000001u)
#define MCBSP_SPCR_CLKSTP_NODELAY    (0x00000002u)
#define MCBSP_SPCR_CLKSTP_DELAY      (0x00000003u)


#define MCBSP_SPCR_DXENA        (0x00000080u)
#define MCBSP_SPCR_DXENA_SHIFT       (0x00000007u)

#define MCBSP_SPCR_RINTM        (0x00000030u)
#define MCBSP_SPCR_RINTM_SHIFT       (0x00000004u)
/*----RINTM Tokens----*/
#define MCBSP_SPCR_RINTM_RRDY        (0x00000000u)
#define MCBSP_SPCR_RINTM_FRM         (0x00000002u)
#define MCBSP_SPCR_RINTM_RSYNCERR    (0x00000003u)

#define MCBSP_SPCR_RSYNCERR     (0x00000008u)
#define MCBSP_SPCR_RSYNCERR_SHIFT    (0x00000003u)

#define MCBSP_SPCR_RFULL        (0x00000004u)
#define MCBSP_SPCR_RFULL_SHIFT       (0x00000002u)

#define MCBSP_SPCR_RRDY         (0x00000002u)
#define MCBSP_SPCR_RRDY_SHIFT        (0x00000001u)

#define MCBSP_SPCR_RRST         (0x00000001u)
#define MCBSP_SPCR_RRST_SHIFT        (0x00000000u)


/* RCR */

#define MCBSP_RCR_RPHASE        (0x80000000u)
#define MCBSP_RCR_RPHASE_SHIFT       (0x0000001Fu)

#define MCBSP_RCR_RFRLEN2       (0x7F000000u)
#define MCBSP_RCR_RFRLEN2_SHIFT      (0x00000018u)

#define MCBSP_RCR_RWDLEN2       (0x00E00000u)
#define MCBSP_RCR_RWDLEN2_SHIFT      (0x00000015u)
/*----RWDLEN2 Tokens----*/
#define MCBSP_RCR_RWDLEN2_8BIT       (0x00000000u)
#define MCBSP_RCR_RWDLEN2_12BIT      (0x00000001u)
#define MCBSP_RCR_RWDLEN2_16BIT      (0x00000002u)
#define MCBSP_RCR_RWDLEN2_20BIT      (0x00000003u)
#define MCBSP_RCR_RWDLEN2_24BIT      (0x00000004u)
#define MCBSP_RCR_RWDLEN2_32BIT      (0x00000005u)

#define MCBSP_RCR_RCOMPAND      (0x00180000u)
#define MCBSP_RCR_RCOMPAND_SHIFT     (0x00000013u)
/*----RCOMPAND Tokens----*/
#define MCBSP_RCR_RCOMPAND_MSB       (0x00000000u)
#define MCBSP_RCR_RCOMPAND_8BITLSB   (0x00000001u)
#define MCBSP_RCR_RCOMPAND_ULAW      (0x00000002u)
#define MCBSP_RCR_RCOMPAND_ALAW      (0x00000003u)

#define MCBSP_RCR_RFIG          (0x00040000u)
#define MCBSP_RCR_RFIG_SHIFT         (0x00000012u)

#define MCBSP_RCR_RDATDLY       (0x00030000u)
#define MCBSP_RCR_RDATDLY_SHIFT      (0x00000010u)
/*----RDATDLY Tokens----*/
#define MCBSP_RCR_RDATDLY_0BIT       (0x00000000u)
#define MCBSP_RCR_RDATDLY_1BIT       (0x00000001u)
#define MCBSP_RCR_RDATDLY_2BIT       (0x00000002u)


#define MCBSP_RCR_RFRLEN1       (0x00007F00u)
#define MCBSP_RCR_RFRLEN1_SHIFT      (0x00000008u)

#define MCBSP_RCR_RWDLEN1       (0x000000E0u)
#define MCBSP_RCR_RWDLEN1_SHIFT      (0x00000005u)
/*----RWDLEN1 Tokens----*/
#define MCBSP_RCR_RWDLEN1_8BIT       (0x00000000u)
#define MCBSP_RCR_RWDLEN1_12BIT      (0x00000001u)
#define MCBSP_RCR_RWDLEN1_16BIT      (0x00000002u)
#define MCBSP_RCR_RWDLEN1_20BIT      (0x00000003u)
#define MCBSP_RCR_RWDLEN1_24BIT      (0x00000004u)
#define MCBSP_RCR_RWDLEN1_32BIT      (0x00000005u)

#define MCBSP_RCR_RWDREVRS      (0x00000010u)
#define MCBSP_RCR_RWDREVRS_SHIFT     (0x00000004u)
/*----RWDREVRS Tokens----*/



/* XCR */

#define MCBSP_XCR_XPHASE        (0x80000000u)
#define MCBSP_XCR_XPHASE_SHIFT       (0x0000001Fu)

#define MCBSP_XCR_XFRLEN2       (0x7F000000u)
#define MCBSP_XCR_XFRLEN2_SHIFT      (0x00000018u)

#define MCBSP_XCR_XWDLEN2       (0x00E00000u)
#define MCBSP_XCR_XWDLEN2_SHIFT      (0x00000015u)
/*----XWDLEN2 Tokens----*/
#define MCBSP_XCR_XWDLEN2_8BIT       (0x00000000u)
#define MCBSP_XCR_XWDLEN2_12BIT      (0x00000001u)
#define MCBSP_XCR_XWDLEN2_16BIT      (0x00000002u)
#define MCBSP_XCR_XWDLEN2_20BIT      (0x00000003u)
#define MCBSP_XCR_XWDLEN2_24BIT      (0x00000004u)
#define MCBSP_XCR_XWDLEN2_32BIT      (0x00000005u)

#define MCBSP_XCR_XCOMPAND      (0x00180000u)
#define MCBSP_XCR_XCOMPAND_SHIFT     (0x00000013u)
/*----XCOMPAND Tokens----*/
#define MCBSP_XCR_XCOMPAND_MSB       (0x00000000u)
#define MCBSP_XCR_XCOMPAND_8BITLSB   (0x00000001u)
#define MCBSP_XCR_XCOMPAND_ULAW      (0x00000002u)
#define MCBSP_XCR_XCOMPAND_ALAW      (0x00000003u)

#define MCBSP_XCR_XFIG          (0x00040000u)
#define MCBSP_XCR_XFIG_SHIFT         (0x00000012u)

#define MCBSP_XCR_XDATDLY       (0x00030000u)
#define MCBSP_XCR_XDATDLY_SHIFT      (0x00000010u)
/*----XDATDLY Tokens----*/
#define MCBSP_XCR_XDATDLY_0BIT       (0x00000000u)
#define MCBSP_XCR_XDATDLY_1BIT       (0x00000001u)
#define MCBSP_XCR_XDATDLY_2BIT       (0x00000002u)


#define MCBSP_XCR_XFRLEN1       (0x00007F00u)
#define MCBSP_XCR_XFRLEN1_SHIFT      (0x00000008u)

#define MCBSP_XCR_XWDLEN1       (0x000000E0u)
#define MCBSP_XCR_XWDLEN1_SHIFT      (0x00000005u)
/*----XWDLEN1 Tokens----*/
#define MCBSP_XCR_XWDLEN1_8BIT       (0x00000000u)
#define MCBSP_XCR_XWDLEN1_12BIT      (0x00000001u)
#define MCBSP_XCR_XWDLEN1_16BIT      (0x00000002u)
#define MCBSP_XCR_XWDLEN1_20BIT      (0x00000003u)
#define MCBSP_XCR_XWDLEN1_24BIT      (0x00000004u)
#define MCBSP_XCR_XWDLEN1_32BIT      (0x00000005u)

#define MCBSP_XCR_XWDREVRS      (0x00000010u)
#define MCBSP_XCR_XWDREVRS_SHIFT     (0x00000004u)


/* SRGR */

#define MCBSP_SRGR_GSYNC        (0x80000000u)
#define MCBSP_SRGR_GSYNC_SHIFT       (0x0000001Fu)

#define MCBSP_SRGR_CLKSP        (0x40000000u)
#define MCBSP_SRGR_CLKSP_SHIFT       (0x0000001Eu)

#define MCBSP_SRGR_CLKSM        (0x20000000u)
#define MCBSP_SRGR_CLKSM_SHIFT       (0x0000001Du)

#define MCBSP_SRGR_FSGM         (0x10000000u)
#define MCBSP_SRGR_FSGM_SHIFT        (0x0000001Cu)

#define MCBSP_SRGR_FPER         (0x0FFF0000u)
#define MCBSP_SRGR_FPER_SHIFT        (0x00000010u)

#define MCBSP_SRGR_FWID         (0x0000FF00u)
#define MCBSP_SRGR_FWID_SHIFT        (0x00000008u)

#define MCBSP_SRGR_CLKGDV       (0x000000FFu)
#define MCBSP_SRGR_CLKGDV_SHIFT      (0x00000000u)


/* MCR */


#define MCBSP_MCR_XMCME         (0x02000000u)
#define MCBSP_MCR_XMCME_SHIFT        (0x00000019u)

#define MCBSP_MCR_XPBBLK        (0x01800000u)
#define MCBSP_MCR_XPBBLK_SHIFT       (0x00000017u)
/*----XPBBLK Tokens----*/
#define MCBSP_MCR_XPBBLK_BLOCK1      (0x00000000u)
#define MCBSP_MCR_XPBBLK_BLOCK3      (0x00000001u)
#define MCBSP_MCR_XPBBLK_BLOCK5      (0x00000002u)
#define MCBSP_MCR_XPBBLK_BLOCK7      (0x00000003u)

#define MCBSP_MCR_XPABLK        (0x00600000u)
#define MCBSP_MCR_XPABLK_SHIFT       (0x00000015u)
/*----XPABLK Tokens----*/
#define MCBSP_MCR_XPABLK_BLOCK0      (0x00000000u)
#define MCBSP_MCR_XPABLK_BLOCK2      (0x00000001u)
#define MCBSP_MCR_XPABLK_BLOCK4      (0x00000002u)
#define MCBSP_MCR_XPABLK_BLOCK6      (0x00000003u)

#define MCBSP_MCR_XCBLK         (0x001C0000u)
#define MCBSP_MCR_XCBLK_SHIFT        (0x00000012u)
/*----XCBLK Tokens----*/
#define MCBSP_MCR_XCBLK_BLOCK0       (0x00000000u)
#define MCBSP_MCR_XCBLK_BLOCK1       (0x00000001u)
#define MCBSP_MCR_XCBLK_BLOCK2       (0x00000002u)
#define MCBSP_MCR_XCBLK_BLOCK3       (0x00000003u)
#define MCBSP_MCR_XCBLK_BLOCK4       (0x00000004u)
#define MCBSP_MCR_XCBLK_BLOCK5       (0x00000005u)
#define MCBSP_MCR_XCBLK_BLOCK6       (0x00000006u)
#define MCBSP_MCR_XCBLK_BLOCK7       (0x00000007u)

#define MCBSP_MCR_XMCM          (0x00030000u)
#define MCBSP_MCR_XMCM_SHIFT         (0x00000010u)

#define MCBSP_MCR_RMCME         (0x00000200u)
#define MCBSP_MCR_RMCME_SHIFT        (0x00000009u)

#define MCBSP_MCR_RPBBLK        (0x00000180u)
#define MCBSP_MCR_RPBBLK_SHIFT       (0x00000007u)
/*----RPBBLK Tokens----*/
#define MCBSP_MCR_RPBBLK_BLOCK1      (0x00000000u)
#define MCBSP_MCR_RPBBLK_BLOCK3      (0x00000001u)
#define MCBSP_MCR_RPBBLK_BLOCK5      (0x00000002u)
#define MCBSP_MCR_RPBBLK_BLOCK7      (0x00000003u)

#define MCBSP_MCR_RPABLK        (0x00000060u)
#define MCBSP_MCR_RPABLK_SHIFT       (0x00000005u)
/*----RPABLK Tokens----*/
#define MCBSP_MCR_RPABLK_BLOCK0      (0x00000000u)
#define MCBSP_MCR_RPABLK_BLOCK2      (0x00000001u)
#define MCBSP_MCR_RPABLK_BLOCK4      (0x00000002u)
#define MCBSP_MCR_RPABLK_BLOCK6      (0x00000003u)

#define MCBSP_MCR_RCBLK         (0x0000001Cu)
#define MCBSP_MCR_RCBLK_SHIFT        (0x00000002u)
/*----RCBLK Tokens----*/
#define MCBSP_MCR_RCBLK_BLOCK0       (0x00000000u)
#define MCBSP_MCR_RCBLK_BLOCK1       (0x00000001u)
#define MCBSP_MCR_RCBLK_BLOCK2       (0x00000002u)
#define MCBSP_MCR_RCBLK_BLOCK3       (0x00000003u)
#define MCBSP_MCR_RCBLK_BLOCK4       (0x00000004u)
#define MCBSP_MCR_RCBLK_BLOCK5       (0x00000005u)
#define MCBSP_MCR_RCBLK_BLOCK6       (0x00000006u)
#define MCBSP_MCR_RCBLK_BLOCK7       (0x00000007u)


#define MCBSP_MCR_RMCM          (0x00000001u)
#define MCBSP_MCR_RMCM_SHIFT         (0x00000000u)

/* RCERE0 */

#define MCBSP_RCERE0_RCE31      (0x80000000u)
#define MCBSP_RCERE0_RCE31_SHIFT     (0x0000001Fu)

#define MCBSP_RCERE0_RCE30      (0x40000000u)
#define MCBSP_RCERE0_RCE30_SHIFT     (0x0000001Eu)

#define MCBSP_RCERE0_RCE29      (0x20000000u)
#define MCBSP_RCERE0_RCE29_SHIFT     (0x0000001Du)

#define MCBSP_RCERE0_RCE28      (0x10000000u)
#define MCBSP_RCERE0_RCE28_SHIFT     (0x0000001Cu)

#define MCBSP_RCERE0_RCE27      (0x08000000u)
#define MCBSP_RCERE0_RCE27_SHIFT     (0x0000001Bu)

#define MCBSP_RCERE0_RCE26      (0x04000000u)
#define MCBSP_RCERE0_RCE26_SHIFT     (0x0000001Au)

#define MCBSP_RCERE0_RCE25      (0x02000000u)
#define MCBSP_RCERE0_RCE25_SHIFT     (0x00000019u)

#define MCBSP_RCERE0_RCE24      (0x01000000u)
#define MCBSP_RCERE0_RCE24_SHIFT     (0x00000018u)

#define MCBSP_RCERE0_RCE23      (0x00800000u)
#define MCBSP_RCERE0_RCE23_SHIFT     (0x00000017u)

#define MCBSP_RCERE0_RCE22      (0x00400000u)
#define MCBSP_RCERE0_RCE22_SHIFT     (0x00000016u)

#define MCBSP_RCERE0_RCE21      (0x00200000u)
#define MCBSP_RCERE0_RCE21_SHIFT     (0x00000015u)

#define MCBSP_RCERE0_RCE20      (0x00100000u)
#define MCBSP_RCERE0_RCE20_SHIFT     (0x00000014u)

#define MCBSP_RCERE0_RCE19      (0x00080000u)
#define MCBSP_RCERE0_RCE19_SHIFT     (0x00000013u)

#define MCBSP_RCERE0_RCE18      (0x00040000u)
#define MCBSP_RCERE0_RCE18_SHIFT     (0x00000012u)

#define MCBSP_RCERE0_RCE17      (0x00020000u)
#define MCBSP_RCERE0_RCE17_SHIFT     (0x00000011u)

#define MCBSP_RCERE0_RCE16      (0x00010000u)
#define MCBSP_RCERE0_RCE16_SHIFT     (0x00000010u)

#define MCBSP_RCERE0_RCE15      (0x00008000u)
#define MCBSP_RCERE0_RCE15_SHIFT     (0x0000000Fu)

#define MCBSP_RCERE0_RCE14      (0x00004000u)
#define MCBSP_RCERE0_RCE14_SHIFT     (0x0000000Eu)

#define MCBSP_RCERE0_RCE13      (0x00002000u)
#define MCBSP_RCERE0_RCE13_SHIFT     (0x0000000Du)

#define MCBSP_RCERE0_RCE12      (0x00001000u)
#define MCBSP_RCERE0_RCE12_SHIFT     (0x0000000Cu)

#define MCBSP_RCERE0_RCE11      (0x00000800u)
#define MCBSP_RCERE0_RCE11_SHIFT     (0x0000000Bu)

#define MCBSP_RCERE0_RCE10      (0x00000400u)
#define MCBSP_RCERE0_RCE10_SHIFT     (0x0000000Au)

#define MCBSP_RCERE0_RCE9       (0x00000200u)
#define MCBSP_RCERE0_RCE9_SHIFT      (0x00000009u)

#define MCBSP_RCERE0_RCE8       (0x00000100u)
#define MCBSP_RCERE0_RCE8_SHIFT      (0x00000008u)

#define MCBSP_RCERE0_RCE7       (0x00000080u)
#define MCBSP_RCERE0_RCE7_SHIFT      (0x00000007u)

#define MCBSP_RCERE0_RCE6       (0x00000040u)
#define MCBSP_RCERE0_RCE6_SHIFT      (0x00000006u)

#define MCBSP_RCERE0_RCE5       (0x00000020u)
#define MCBSP_RCERE0_RCE5_SHIFT      (0x00000005u)

#define MCBSP_RCERE0_RCE4       (0x00000010u)
#define MCBSP_RCERE0_RCE4_SHIFT      (0x00000004u)

#define MCBSP_RCERE0_RCE3       (0x00000008u)
#define MCBSP_RCERE0_RCE3_SHIFT      (0x00000003u)

#define MCBSP_RCERE0_RCE2       (0x00000004u)
#define MCBSP_RCERE0_RCE2_SHIFT      (0x00000002u)

#define MCBSP_RCERE0_RCE1       (0x00000002u)
#define MCBSP_RCERE0_RCE1_SHIFT      (0x00000001u)

#define MCBSP_RCERE0_RCE0       (0x00000001u)
#define MCBSP_RCERE0_RCE0_SHIFT      (0x00000000u)


/* XCERE0 */

#define MCBSP_XCERE0_XCE31      (0x80000000u)
#define MCBSP_XCERE0_XCE31_SHIFT     (0x0000001Fu)

#define MCBSP_XCERE0_XCE30      (0x40000000u)
#define MCBSP_XCERE0_XCE30_SHIFT     (0x0000001Eu)

#define MCBSP_XCERE0_XCE29      (0x20000000u)
#define MCBSP_XCERE0_XCE29_SHIFT     (0x0000001Du)

#define MCBSP_XCERE0_XCE28      (0x10000000u)
#define MCBSP_XCERE0_XCE28_SHIFT     (0x0000001Cu)

#define MCBSP_XCERE0_XCE27      (0x08000000u)
#define MCBSP_XCERE0_XCE27_SHIFT     (0x0000001Bu)

#define MCBSP_XCERE0_XCE26      (0x04000000u)
#define MCBSP_XCERE0_XCE26_SHIFT     (0x0000001Au)

#define MCBSP_XCERE0_XCE25      (0x02000000u)
#define MCBSP_XCERE0_XCE25_SHIFT     (0x00000019u)

#define MCBSP_XCERE0_XCE24      (0x01000000u)
#define MCBSP_XCERE0_XCE24_SHIFT     (0x00000018u)

#define MCBSP_XCERE0_XCE23      (0x00800000u)
#define MCBSP_XCERE0_XCE23_SHIFT     (0x00000017u)

#define MCBSP_XCERE0_XCE22      (0x00400000u)
#define MCBSP_XCERE0_XCE22_SHIFT     (0x00000016u)

#define MCBSP_XCERE0_XCE21      (0x00200000u)
#define MCBSP_XCERE0_XCE21_SHIFT     (0x00000015u)

#define MCBSP_XCERE0_XCE20      (0x00100000u)
#define MCBSP_XCERE0_XCE20_SHIFT     (0x00000014u)

#define MCBSP_XCERE0_XCE19      (0x00080000u)
#define MCBSP_XCERE0_XCE19_SHIFT     (0x00000013u)

#define MCBSP_XCERE0_XCE18      (0x00040000u)
#define MCBSP_XCERE0_XCE18_SHIFT     (0x00000012u)

#define MCBSP_XCERE0_XCE17      (0x00020000u)
#define MCBSP_XCERE0_XCE17_SHIFT     (0x00000011u)

#define MCBSP_XCERE0_XCE16      (0x00010000u)
#define MCBSP_XCERE0_XCE16_SHIFT     (0x00000010u)

#define MCBSP_XCERE0_XCE15      (0x00008000u)
#define MCBSP_XCERE0_XCE15_SHIFT     (0x0000000Fu)

#define MCBSP_XCERE0_XCE14      (0x00004000u)
#define MCBSP_XCERE0_XCE14_SHIFT     (0x0000000Eu)

#define MCBSP_XCERE0_XCE13      (0x00002000u)
#define MCBSP_XCERE0_XCE13_SHIFT     (0x0000000Du)

#define MCBSP_XCERE0_XCE12      (0x00001000u)
#define MCBSP_XCERE0_XCE12_SHIFT     (0x0000000Cu)

#define MCBSP_XCERE0_XCE11      (0x00000800u)
#define MCBSP_XCERE0_XCE11_SHIFT     (0x0000000Bu)

#define MCBSP_XCERE0_XCE10      (0x00000400u)
#define MCBSP_XCERE0_XCE10_SHIFT     (0x0000000Au)

#define MCBSP_XCERE0_XCE9       (0x00000200u)
#define MCBSP_XCERE0_XCE9_SHIFT      (0x00000009u)

#define MCBSP_XCERE0_XCE8       (0x00000100u)
#define MCBSP_XCERE0_XCE8_SHIFT      (0x00000008u)

#define MCBSP_XCERE0_XCE7       (0x00000080u)
#define MCBSP_XCERE0_XCE7_SHIFT      (0x00000007u)

#define MCBSP_XCERE0_XCE6       (0x00000040u)
#define MCBSP_XCERE0_XCE6_SHIFT      (0x00000006u)

#define MCBSP_XCERE0_XCE5       (0x00000020u)
#define MCBSP_XCERE0_XCE5_SHIFT      (0x00000005u)

#define MCBSP_XCERE0_XCE4       (0x00000010u)
#define MCBSP_XCERE0_XCE4_SHIFT      (0x00000004u)

#define MCBSP_XCERE0_XCE3       (0x00000008u)
#define MCBSP_XCERE0_XCE3_SHIFT      (0x00000003u)

#define MCBSP_XCERE0_XCE2       (0x00000004u)
#define MCBSP_XCERE0_XCE2_SHIFT      (0x00000002u)

#define MCBSP_XCERE0_XCE1       (0x00000002u)
#define MCBSP_XCERE0_XCE1_SHIFT      (0x00000001u)

#define MCBSP_XCERE0_XCE0       (0x00000001u)
#define MCBSP_XCERE0_XCE0_SHIFT      (0x00000000u)


/* PCR */


#define MCBSP_PCR_FSXM          (0x00000800u)
#define MCBSP_PCR_FSXM_SHIFT         (0x0000000Bu)

#define MCBSP_PCR_FSRM          (0x00000400u)
#define MCBSP_PCR_FSRM_SHIFT         (0x0000000Au)

#define MCBSP_PCR_CLKXM         (0x00000200u)
#define MCBSP_PCR_CLKXM_SHIFT        (0x00000009u)

#define MCBSP_PCR_CLKRM         (0x00000100u)
#define MCBSP_PCR_CLKRM_SHIFT        (0x00000008u)

#define MCBSP_PCR_SCLKME        (0x00000080u)
#define MCBSP_PCR_SCLKME_SHIFT       (0x00000007u)

#define MCBSP_PCR_FSXP          (0x00000008u)
#define MCBSP_PCR_FSXP_SHIFT         (0x00000003u)

#define MCBSP_PCR_FSRP          (0x00000004u)
#define MCBSP_PCR_FSRP_SHIFT         (0x00000002u)

#define MCBSP_PCR_CLKXP         (0x00000002u)
#define MCBSP_PCR_CLKXP_SHIFT        (0x00000001u)

#define MCBSP_PCR_CLKRP         (0x00000001u)
#define MCBSP_PCR_CLKRP_SHIFT        (0x00000000u)


/* RCERE1 */

#define MCBSP_RCERE1_RCE31      (0x80000000u)
#define MCBSP_RCERE1_RCE31_SHIFT     (0x0000001Fu)

#define MCBSP_RCERE1_RCE30      (0x40000000u)
#define MCBSP_RCERE1_RCE30_SHIFT     (0x0000001Eu)

#define MCBSP_RCERE1_RCE29      (0x20000000u)
#define MCBSP_RCERE1_RCE29_SHIFT     (0x0000001Du)

#define MCBSP_RCERE1_RCE28      (0x10000000u)
#define MCBSP_RCERE1_RCE28_SHIFT     (0x0000001Cu)

#define MCBSP_RCERE1_RCE27      (0x08000000u)
#define MCBSP_RCERE1_RCE27_SHIFT     (0x0000001Bu)

#define MCBSP_RCERE1_RCE26      (0x04000000u)
#define MCBSP_RCERE1_RCE26_SHIFT     (0x0000001Au)

#define MCBSP_RCERE1_RCE25      (0x02000000u)
#define MCBSP_RCERE1_RCE25_SHIFT     (0x00000019u)

#define MCBSP_RCERE1_RCE24      (0x01000000u)
#define MCBSP_RCERE1_RCE24_SHIFT     (0x00000018u)

#define MCBSP_RCERE1_RCE23      (0x00800000u)
#define MCBSP_RCERE1_RCE23_SHIFT     (0x00000017u)

#define MCBSP_RCERE1_RCE22      (0x00400000u)
#define MCBSP_RCERE1_RCE22_SHIFT     (0x00000016u)

#define MCBSP_RCERE1_RCE21      (0x00200000u)
#define MCBSP_RCERE1_RCE21_SHIFT     (0x00000015u)

#define MCBSP_RCERE1_RCE20      (0x00100000u)
#define MCBSP_RCERE1_RCE20_SHIFT     (0x00000014u)

#define MCBSP_RCERE1_RCE19      (0x00080000u)
#define MCBSP_RCERE1_RCE19_SHIFT     (0x00000013u)

#define MCBSP_RCERE1_RCE18      (0x00040000u)
#define MCBSP_RCERE1_RCE18_SHIFT     (0x00000012u)

#define MCBSP_RCERE1_RCE17      (0x00020000u)
#define MCBSP_RCERE1_RCE17_SHIFT     (0x00000011u)

#define MCBSP_RCERE1_RCE16      (0x00010000u)
#define MCBSP_RCERE1_RCE16_SHIFT     (0x00000010u)

#define MCBSP_RCERE1_RCE15      (0x00008000u)
#define MCBSP_RCERE1_RCE15_SHIFT     (0x0000000Fu)

#define MCBSP_RCERE1_RCE14      (0x00004000u)
#define MCBSP_RCERE1_RCE14_SHIFT     (0x0000000Eu)

#define MCBSP_RCERE1_RCE13      (0x00002000u)
#define MCBSP_RCERE1_RCE13_SHIFT     (0x0000000Du)

#define MCBSP_RCERE1_RCE12      (0x00001000u)
#define MCBSP_RCERE1_RCE12_SHIFT     (0x0000000Cu)

#define MCBSP_RCERE1_RCE11      (0x00000800u)
#define MCBSP_RCERE1_RCE11_SHIFT     (0x0000000Bu)

#define MCBSP_RCERE1_RCE10      (0x00000400u)
#define MCBSP_RCERE1_RCE10_SHIFT     (0x0000000Au)

#define MCBSP_RCERE1_RCE9       (0x00000200u)
#define MCBSP_RCERE1_RCE9_SHIFT      (0x00000009u)

#define MCBSP_RCERE1_RCE8       (0x00000100u)
#define MCBSP_RCERE1_RCE8_SHIFT      (0x00000008u)

#define MCBSP_RCERE1_RCE7       (0x00000080u)
#define MCBSP_RCERE1_RCE7_SHIFT      (0x00000007u)

#define MCBSP_RCERE1_RCE6       (0x00000040u)
#define MCBSP_RCERE1_RCE6_SHIFT      (0x00000006u)

#define MCBSP_RCERE1_RCE5       (0x00000020u)
#define MCBSP_RCERE1_RCE5_SHIFT      (0x00000005u)

#define MCBSP_RCERE1_RCE4       (0x00000010u)
#define MCBSP_RCERE1_RCE4_SHIFT      (0x00000004u)

#define MCBSP_RCERE1_RCE3       (0x00000008u)
#define MCBSP_RCERE1_RCE3_SHIFT      (0x00000003u)

#define MCBSP_RCERE1_RCE2       (0x00000004u)
#define MCBSP_RCERE1_RCE2_SHIFT      (0x00000002u)

#define MCBSP_RCERE1_RCE1       (0x00000002u)
#define MCBSP_RCERE1_RCE1_SHIFT      (0x00000001u)

#define MCBSP_RCERE1_RCE0       (0x00000001u)
#define MCBSP_RCERE1_RCE0_SHIFT      (0x00000000u)


/* XCERE1 */

#define MCBSP_XCERE1_XCE31      (0x80000000u)
#define MCBSP_XCERE1_XCE31_SHIFT     (0x0000001Fu)

#define MCBSP_XCERE1_XCE30      (0x40000000u)
#define MCBSP_XCERE1_XCE30_SHIFT     (0x0000001Eu)

#define MCBSP_XCERE1_XCE29      (0x20000000u)
#define MCBSP_XCERE1_XCE29_SHIFT     (0x0000001Du)

#define MCBSP_XCERE1_XCE28      (0x10000000u)
#define MCBSP_XCERE1_XCE28_SHIFT     (0x0000001Cu)

#define MCBSP_XCERE1_XCE27      (0x08000000u)
#define MCBSP_XCERE1_XCE27_SHIFT     (0x0000001Bu)

#define MCBSP_XCERE1_XCE26      (0x04000000u)
#define MCBSP_XCERE1_XCE26_SHIFT     (0x0000001Au)

#define MCBSP_XCERE1_XCE25      (0x02000000u)
#define MCBSP_XCERE1_XCE25_SHIFT     (0x00000019u)

#define MCBSP_XCERE1_XCE24      (0x01000000u)
#define MCBSP_XCERE1_XCE24_SHIFT     (0x00000018u)

#define MCBSP_XCERE1_XCE23      (0x00800000u)
#define MCBSP_XCERE1_XCE23_SHIFT     (0x00000017u)

#define MCBSP_XCERE1_XCE22      (0x00400000u)
#define MCBSP_XCERE1_XCE22_SHIFT     (0x00000016u)

#define MCBSP_XCERE1_XCE21      (0x00200000u)
#define MCBSP_XCERE1_XCE21_SHIFT     (0x00000015u)

#define MCBSP_XCERE1_XCE20      (0x00100000u)
#define MCBSP_XCERE1_XCE20_SHIFT     (0x00000014u)

#define MCBSP_XCERE1_XCE19      (0x00080000u)
#define MCBSP_XCERE1_XCE19_SHIFT     (0x00000013u)

#define MCBSP_XCERE1_XCE18      (0x00040000u)
#define MCBSP_XCERE1_XCE18_SHIFT     (0x00000012u)

#define MCBSP_XCERE1_XCE17      (0x00020000u)
#define MCBSP_XCERE1_XCE17_SHIFT     (0x00000011u)

#define MCBSP_XCERE1_XCE16      (0x00010000u)
#define MCBSP_XCERE1_XCE16_SHIFT     (0x00000010u)

#define MCBSP_XCERE1_XCE15      (0x00008000u)
#define MCBSP_XCERE1_XCE15_SHIFT     (0x0000000Fu)

#define MCBSP_XCERE1_XCE14      (0x00004000u)
#define MCBSP_XCERE1_XCE14_SHIFT     (0x0000000Eu)

#define MCBSP_XCERE1_XCE13      (0x00002000u)
#define MCBSP_XCERE1_XCE13_SHIFT     (0x0000000Du)

#define MCBSP_XCERE1_XCE12      (0x00001000u)
#define MCBSP_XCERE1_XCE12_SHIFT     (0x0000000Cu)

#define MCBSP_XCERE1_XCE11      (0x00000800u)
#define MCBSP_XCERE1_XCE11_SHIFT     (0x0000000Bu)

#define MCBSP_XCERE1_XCE10      (0x00000400u)
#define MCBSP_XCERE1_XCE10_SHIFT     (0x0000000Au)

#define MCBSP_XCERE1_XCE9       (0x00000200u)
#define MCBSP_XCERE1_XCE9_SHIFT      (0x00000009u)

#define MCBSP_XCERE1_XCE8       (0x00000100u)
#define MCBSP_XCERE1_XCE8_SHIFT      (0x00000008u)

#define MCBSP_XCERE1_XCE7       (0x00000080u)
#define MCBSP_XCERE1_XCE7_SHIFT      (0x00000007u)

#define MCBSP_XCERE1_XCE6       (0x00000040u)
#define MCBSP_XCERE1_XCE6_SHIFT      (0x00000006u)

#define MCBSP_XCERE1_XCE5       (0x00000020u)
#define MCBSP_XCERE1_XCE5_SHIFT      (0x00000005u)

#define MCBSP_XCERE1_XCE4       (0x00000010u)
#define MCBSP_XCERE1_XCE4_SHIFT      (0x00000004u)

#define MCBSP_XCERE1_XCE3       (0x00000008u)
#define MCBSP_XCERE1_XCE3_SHIFT      (0x00000003u)

#define MCBSP_XCERE1_XCE2       (0x00000004u)
#define MCBSP_XCERE1_XCE2_SHIFT      (0x00000002u)

#define MCBSP_XCERE1_XCE1       (0x00000002u)
#define MCBSP_XCERE1_XCE1_SHIFT      (0x00000001u)

#define MCBSP_XCERE1_XCE0       (0x00000001u)
#define MCBSP_XCERE1_XCE0_SHIFT      (0x00000000u)

/* RCERE2 */

#define MCBSP_RCERE2_RCE31      (0x80000000u)
#define MCBSP_RCERE2_RCE31_SHIFT     (0x0000001Fu)

#define MCBSP_RCERE2_RCE30      (0x40000000u)
#define MCBSP_RCERE2_RCE30_SHIFT     (0x0000001Eu)

#define MCBSP_RCERE2_RCE29      (0x20000000u)
#define MCBSP_RCERE2_RCE29_SHIFT     (0x0000001Du)

#define MCBSP_RCERE2_RCE28      (0x10000000u)
#define MCBSP_RCERE2_RCE28_SHIFT     (0x0000001Cu)

#define MCBSP_RCERE2_RCE27      (0x08000000u)
#define MCBSP_RCERE2_RCE27_SHIFT     (0x0000001Bu)

#define MCBSP_RCERE2_RCE26      (0x04000000u)
#define MCBSP_RCERE2_RCE26_SHIFT     (0x0000001Au)

#define MCBSP_RCERE2_RCE25      (0x02000000u)
#define MCBSP_RCERE2_RCE25_SHIFT     (0x00000019u)

#define MCBSP_RCERE2_RCE24      (0x01000000u)
#define MCBSP_RCERE2_RCE24_SHIFT     (0x00000018u)

#define MCBSP_RCERE2_RCE23      (0x00800000u)
#define MCBSP_RCERE2_RCE23_SHIFT     (0x00000017u)

#define MCBSP_RCERE2_RCE22      (0x00400000u)
#define MCBSP_RCERE2_RCE22_SHIFT     (0x00000016u)

#define MCBSP_RCERE2_RCE21      (0x00200000u)
#define MCBSP_RCERE2_RCE21_SHIFT     (0x00000015u)

#define MCBSP_RCERE2_RCE20      (0x00100000u)
#define MCBSP_RCERE2_RCE20_SHIFT     (0x00000014u)

#define MCBSP_RCERE2_RCE19      (0x00080000u)
#define MCBSP_RCERE2_RCE19_SHIFT     (0x00000013u)

#define MCBSP_RCERE2_RCE18      (0x00040000u)
#define MCBSP_RCERE2_RCE18_SHIFT     (0x00000012u)

#define MCBSP_RCERE2_RCE17      (0x00020000u)
#define MCBSP_RCERE2_RCE17_SHIFT     (0x00000011u)

#define MCBSP_RCERE2_RCE16      (0x00010000u)
#define MCBSP_RCERE2_RCE16_SHIFT     (0x00000010u)

#define MCBSP_RCERE2_RCE15      (0x00008000u)
#define MCBSP_RCERE2_RCE15_SHIFT     (0x0000000Fu)

#define MCBSP_RCERE2_RCE14      (0x00004000u)
#define MCBSP_RCERE2_RCE14_SHIFT     (0x0000000Eu)

#define MCBSP_RCERE2_RCE13      (0x00002000u)
#define MCBSP_RCERE2_RCE13_SHIFT     (0x0000000Du)

#define MCBSP_RCERE2_RCE12      (0x00001000u)
#define MCBSP_RCERE2_RCE12_SHIFT     (0x0000000Cu)

#define MCBSP_RCERE2_RCE11      (0x00000800u)
#define MCBSP_RCERE2_RCE11_SHIFT     (0x0000000Bu)

#define MCBSP_RCERE2_RCE10      (0x00000400u)
#define MCBSP_RCERE2_RCE10_SHIFT     (0x0000000Au)

#define MCBSP_RCERE2_RCE9       (0x00000200u)
#define MCBSP_RCERE2_RCE9_SHIFT      (0x00000009u)

#define MCBSP_RCERE2_RCE8       (0x00000100u)
#define MCBSP_RCERE2_RCE8_SHIFT      (0x00000008u)

#define MCBSP_RCERE2_RCE7       (0x00000080u)
#define MCBSP_RCERE2_RCE7_SHIFT      (0x00000007u)

#define MCBSP_RCERE2_RCE6       (0x00000040u)
#define MCBSP_RCERE2_RCE6_SHIFT      (0x00000006u)

#define MCBSP_RCERE2_RCE5       (0x00000020u)
#define MCBSP_RCERE2_RCE5_SHIFT      (0x00000005u)

#define MCBSP_RCERE2_RCE4       (0x00000010u)
#define MCBSP_RCERE2_RCE4_SHIFT      (0x00000004u)

#define MCBSP_RCERE2_RCE3       (0x00000008u)
#define MCBSP_RCERE2_RCE3_SHIFT      (0x00000003u)

#define MCBSP_RCERE2_RCE2       (0x00000004u)
#define MCBSP_RCERE2_RCE2_SHIFT      (0x00000002u)

#define MCBSP_RCERE2_RCE1       (0x00000002u)
#define MCBSP_RCERE2_RCE1_SHIFT      (0x00000001u)

#define MCBSP_RCERE2_RCE0       (0x00000001u)
#define MCBSP_RCERE2_RCE0_SHIFT      (0x00000000u)


/* XCERE2 */

#define MCBSP_XCERE2_XCE31      (0x80000000u)
#define MCBSP_XCERE2_XCE31_SHIFT     (0x0000001Fu)

#define MCBSP_XCERE2_XCE30      (0x40000000u)
#define MCBSP_XCERE2_XCE30_SHIFT     (0x0000001Eu)

#define MCBSP_XCERE2_XCE29      (0x20000000u)
#define MCBSP_XCERE2_XCE29_SHIFT     (0x0000001Du)

#define MCBSP_XCERE2_XCE28      (0x10000000u)
#define MCBSP_XCERE2_XCE28_SHIFT     (0x0000001Cu)

#define MCBSP_XCERE2_XCE27      (0x08000000u)
#define MCBSP_XCERE2_XCE27_SHIFT     (0x0000001Bu)

#define MCBSP_XCERE2_XCE26      (0x04000000u)
#define MCBSP_XCERE2_XCE26_SHIFT     (0x0000001Au)

#define MCBSP_XCERE2_XCE25      (0x02000000u)
#define MCBSP_XCERE2_XCE25_SHIFT     (0x00000019u)

#define MCBSP_XCERE2_XCE24      (0x01000000u)
#define MCBSP_XCERE2_XCE24_SHIFT     (0x00000018u)

#define MCBSP_XCERE2_XCE23      (0x00800000u)
#define MCBSP_XCERE2_XCE23_SHIFT     (0x00000017u)

#define MCBSP_XCERE2_XCE22      (0x00400000u)
#define MCBSP_XCERE2_XCE22_SHIFT     (0x00000016u)

#define MCBSP_XCERE2_XCE21      (0x00200000u)
#define MCBSP_XCERE2_XCE21_SHIFT     (0x00000015u)

#define MCBSP_XCERE2_XCE20      (0x00100000u)
#define MCBSP_XCERE2_XCE20_SHIFT     (0x00000014u)

#define MCBSP_XCERE2_XCE19      (0x00080000u)
#define MCBSP_XCERE2_XCE19_SHIFT     (0x00000013u)

#define MCBSP_XCERE2_XCE18      (0x00040000u)
#define MCBSP_XCERE2_XCE18_SHIFT     (0x00000012u)

#define MCBSP_XCERE2_XCE17      (0x00020000u)
#define MCBSP_XCERE2_XCE17_SHIFT     (0x00000011u)

#define MCBSP_XCERE2_XCE16      (0x00010000u)
#define MCBSP_XCERE2_XCE16_SHIFT     (0x00000010u)

#define MCBSP_XCERE2_XCE15      (0x00008000u)
#define MCBSP_XCERE2_XCE15_SHIFT     (0x0000000Fu)

#define MCBSP_XCERE2_XCE14      (0x00004000u)
#define MCBSP_XCERE2_XCE14_SHIFT     (0x0000000Eu)

#define MCBSP_XCERE2_XCE13      (0x00002000u)
#define MCBSP_XCERE2_XCE13_SHIFT     (0x0000000Du)

#define MCBSP_XCERE2_XCE12      (0x00001000u)
#define MCBSP_XCERE2_XCE12_SHIFT     (0x0000000Cu)

#define MCBSP_XCERE2_XCE11      (0x00000800u)
#define MCBSP_XCERE2_XCE11_SHIFT     (0x0000000Bu)

#define MCBSP_XCERE2_XCE10      (0x00000400u)
#define MCBSP_XCERE2_XCE10_SHIFT     (0x0000000Au)

#define MCBSP_XCERE2_XCE9       (0x00000200u)
#define MCBSP_XCERE2_XCE9_SHIFT      (0x00000009u)

#define MCBSP_XCERE2_XCE8       (0x00000100u)
#define MCBSP_XCERE2_XCE8_SHIFT      (0x00000008u)

#define MCBSP_XCERE2_XCE7       (0x00000080u)
#define MCBSP_XCERE2_XCE7_SHIFT      (0x00000007u)

#define MCBSP_XCERE2_XCE6       (0x00000040u)
#define MCBSP_XCERE2_XCE6_SHIFT      (0x00000006u)

#define MCBSP_XCERE2_XCE5       (0x00000020u)
#define MCBSP_XCERE2_XCE5_SHIFT      (0x00000005u)

#define MCBSP_XCERE2_XCE4       (0x00000010u)
#define MCBSP_XCERE2_XCE4_SHIFT      (0x00000004u)

#define MCBSP_XCERE2_XCE3       (0x00000008u)
#define MCBSP_XCERE2_XCE3_SHIFT      (0x00000003u)

#define MCBSP_XCERE2_XCE2       (0x00000004u)
#define MCBSP_XCERE2_XCE2_SHIFT      (0x00000002u)

#define MCBSP_XCERE2_XCE1       (0x00000002u)
#define MCBSP_XCERE2_XCE1_SHIFT      (0x00000001u)

#define MCBSP_XCERE2_XCE0       (0x00000001u)
#define MCBSP_XCERE2_XCE0_SHIFT      (0x00000000u)


/* RCERE3 */

#define MCBSP_RCERE3_RCE31      (0x80000000u)
#define MCBSP_RCERE3_RCE31_SHIFT     (0x0000001Fu)

#define MCBSP_RCERE3_RCE30      (0x40000000u)
#define MCBSP_RCERE3_RCE30_SHIFT     (0x0000001Eu)

#define MCBSP_RCERE3_RCE29      (0x20000000u)
#define MCBSP_RCERE3_RCE29_SHIFT     (0x0000001Du)

#define MCBSP_RCERE3_RCE28      (0x10000000u)
#define MCBSP_RCERE3_RCE28_SHIFT     (0x0000001Cu)

#define MCBSP_RCERE3_RCE27      (0x08000000u)
#define MCBSP_RCERE3_RCE27_SHIFT     (0x0000001Bu)

#define MCBSP_RCERE3_RCE26      (0x04000000u)
#define MCBSP_RCERE3_RCE26_SHIFT     (0x0000001Au)

#define MCBSP_RCERE3_RCE25      (0x02000000u)
#define MCBSP_RCERE3_RCE25_SHIFT     (0x00000019u)

#define MCBSP_RCERE3_RCE24      (0x01000000u)
#define MCBSP_RCERE3_RCE24_SHIFT     (0x00000018u)

#define MCBSP_RCERE3_RCE23      (0x00800000u)
#define MCBSP_RCERE3_RCE23_SHIFT     (0x00000017u)

#define MCBSP_RCERE3_RCE22      (0x00400000u)
#define MCBSP_RCERE3_RCE22_SHIFT     (0x00000016u)

#define MCBSP_RCERE3_RCE21      (0x00200000u)
#define MCBSP_RCERE3_RCE21_SHIFT     (0x00000015u)

#define MCBSP_RCERE3_RCE20      (0x00100000u)
#define MCBSP_RCERE3_RCE20_SHIFT     (0x00000014u)

#define MCBSP_RCERE3_RCE19      (0x00080000u)
#define MCBSP_RCERE3_RCE19_SHIFT     (0x00000013u)

#define MCBSP_RCERE3_RCE18      (0x00040000u)
#define MCBSP_RCERE3_RCE18_SHIFT     (0x00000012u)

#define MCBSP_RCERE3_RCE17      (0x00020000u)
#define MCBSP_RCERE3_RCE17_SHIFT     (0x00000011u)

#define MCBSP_RCERE3_RCE16      (0x00010000u)
#define MCBSP_RCERE3_RCE16_SHIFT     (0x00000010u)

#define MCBSP_RCERE3_RCE15      (0x00008000u)
#define MCBSP_RCERE3_RCE15_SHIFT     (0x0000000Fu)

#define MCBSP_RCERE3_RCE14      (0x00004000u)
#define MCBSP_RCERE3_RCE14_SHIFT     (0x0000000Eu)

#define MCBSP_RCERE3_RCE13      (0x00002000u)
#define MCBSP_RCERE3_RCE13_SHIFT     (0x0000000Du)

#define MCBSP_RCERE3_RCE12      (0x00001000u)
#define MCBSP_RCERE3_RCE12_SHIFT     (0x0000000Cu)

#define MCBSP_RCERE3_RCE11      (0x00000800u)
#define MCBSP_RCERE3_RCE11_SHIFT     (0x0000000Bu)

#define MCBSP_RCERE3_RCE10      (0x00000400u)
#define MCBSP_RCERE3_RCE10_SHIFT     (0x0000000Au)

#define MCBSP_RCERE3_RCE9       (0x00000200u)
#define MCBSP_RCERE3_RCE9_SHIFT      (0x00000009u)

#define MCBSP_RCERE3_RCE8       (0x00000100u)
#define MCBSP_RCERE3_RCE8_SHIFT      (0x00000008u)

#define MCBSP_RCERE3_RCE7       (0x00000080u)
#define MCBSP_RCERE3_RCE7_SHIFT      (0x00000007u)

#define MCBSP_RCERE3_RCE6       (0x00000040u)
#define MCBSP_RCERE3_RCE6_SHIFT      (0x00000006u)

#define MCBSP_RCERE3_RCE5       (0x00000020u)
#define MCBSP_RCERE3_RCE5_SHIFT      (0x00000005u)

#define MCBSP_RCERE3_RCE4       (0x00000010u)
#define MCBSP_RCERE3_RCE4_SHIFT      (0x00000004u)

#define MCBSP_RCERE3_RCE3       (0x00000008u)
#define MCBSP_RCERE3_RCE3_SHIFT      (0x00000003u)

#define MCBSP_RCERE3_RCE2       (0x00000004u)
#define MCBSP_RCERE3_RCE2_SHIFT      (0x00000002u)

#define MCBSP_RCERE3_RCE1       (0x00000002u)
#define MCBSP_RCERE3_RCE1_SHIFT      (0x00000001u)

#define MCBSP_RCERE3_RCE0       (0x00000001u)
#define MCBSP_RCERE3_RCE0_SHIFT      (0x00000000u)


/* XCERE3 */

#define MCBSP_XCERE3_XCE31      (0x80000000u)
#define MCBSP_XCERE3_XCE31_SHIFT     (0x0000001Fu)

#define MCBSP_XCERE3_XCE30      (0x40000000u)
#define MCBSP_XCERE3_XCE30_SHIFT     (0x0000001Eu)

#define MCBSP_XCERE3_XCE29      (0x20000000u)
#define MCBSP_XCERE3_XCE29_SHIFT     (0x0000001Du)

#define MCBSP_XCERE3_XCE28      (0x10000000u)
#define MCBSP_XCERE3_XCE28_SHIFT     (0x0000001Cu)

#define MCBSP_XCERE3_XCE27      (0x08000000u)
#define MCBSP_XCERE3_XCE27_SHIFT     (0x0000001Bu)

#define MCBSP_XCERE3_XCE26      (0x04000000u)
#define MCBSP_XCERE3_XCE26_SHIFT     (0x0000001Au)

#define MCBSP_XCERE3_XCE25      (0x02000000u)
#define MCBSP_XCERE3_XCE25_SHIFT     (0x00000019u)

#define MCBSP_XCERE3_XCE24      (0x01000000u)
#define MCBSP_XCERE3_XCE24_SHIFT     (0x00000018u)

#define MCBSP_XCERE3_XCE23      (0x00800000u)
#define MCBSP_XCERE3_XCE23_SHIFT     (0x00000017u)

#define MCBSP_XCERE3_XCE22      (0x00400000u)
#define MCBSP_XCERE3_XCE22_SHIFT     (0x00000016u)

#define MCBSP_XCERE3_XCE21      (0x00200000u)
#define MCBSP_XCERE3_XCE21_SHIFT     (0x00000015u)

#define MCBSP_XCERE3_XCE20      (0x00100000u)
#define MCBSP_XCERE3_XCE20_SHIFT     (0x00000014u)

#define MCBSP_XCERE3_XCE19      (0x00080000u)
#define MCBSP_XCERE3_XCE19_SHIFT     (0x00000013u)

#define MCBSP_XCERE3_XCE18      (0x00040000u)
#define MCBSP_XCERE3_XCE18_SHIFT     (0x00000012u)

#define MCBSP_XCERE3_XCE17      (0x00020000u)
#define MCBSP_XCERE3_XCE17_SHIFT     (0x00000011u)

#define MCBSP_XCERE3_XCE16      (0x00010000u)
#define MCBSP_XCERE3_XCE16_SHIFT     (0x00000010u)

#define MCBSP_XCERE3_XCE15      (0x00008000u)
#define MCBSP_XCERE3_XCE15_SHIFT     (0x0000000Fu)

#define MCBSP_XCERE3_XCE14      (0x00004000u)
#define MCBSP_XCERE3_XCE14_SHIFT     (0x0000000Eu)

#define MCBSP_XCERE3_XCE13      (0x00002000u)
#define MCBSP_XCERE3_XCE13_SHIFT     (0x0000000Du)

#define MCBSP_XCERE3_XCE12      (0x00001000u)
#define MCBSP_XCERE3_XCE12_SHIFT     (0x0000000Cu)

#define MCBSP_XCERE3_XCE11      (0x00000800u)
#define MCBSP_XCERE3_XCE11_SHIFT     (0x0000000Bu)

#define MCBSP_XCERE3_XCE10      (0x00000400u)
#define MCBSP_XCERE3_XCE10_SHIFT     (0x0000000Au)

#define MCBSP_XCERE3_XCE9       (0x00000200u)
#define MCBSP_XCERE3_XCE9_SHIFT      (0x00000009u)

#define MCBSP_XCERE3_XCE8       (0x00000100u)
#define MCBSP_XCERE3_XCE8_SHIFT      (0x00000008u)

#define MCBSP_XCERE3_XCE7       (0x00000080u)
#define MCBSP_XCERE3_XCE7_SHIFT      (0x00000007u)

#define MCBSP_XCERE3_XCE6       (0x00000040u)
#define MCBSP_XCERE3_XCE6_SHIFT      (0x00000006u)

#define MCBSP_XCERE3_XCE5       (0x00000020u)
#define MCBSP_XCERE3_XCE5_SHIFT      (0x00000005u)

#define MCBSP_XCERE3_XCE4       (0x00000010u)
#define MCBSP_XCERE3_XCE4_SHIFT      (0x00000004u)

#define MCBSP_XCERE3_XCE3       (0x00000008u)
#define MCBSP_XCERE3_XCE3_SHIFT      (0x00000003u)

#define MCBSP_XCERE3_XCE2       (0x00000004u)
#define MCBSP_XCERE3_XCE2_SHIFT      (0x00000002u)

#define MCBSP_XCERE3_XCE1       (0x00000002u)
#define MCBSP_XCERE3_XCE1_SHIFT      (0x00000001u)

#define MCBSP_XCERE3_XCE0       (0x00000001u)
#define MCBSP_XCERE3_XCE0_SHIFT      (0x00000000u)


/* REVID */

#define BFIFO_REVID_REV         (0xFFFFFFFFu)
#define BFIFO_REVID_REV_SHIFT        (0x00000000u)


/* WFIFOCTL */


#define BFIFO_WFIFOCTL_WENA        (0x00010000u)
#define BFIFO_WFIFOCTL_WENA_SHIFT       (0x00000010u)

#define BFIFO_WFIFOCTL_WNUMEVT     (0x0000FF00u)
#define BFIFO_WFIFOCTL_WNUMEVT_SHIFT    (0x00000008u)
#define BFIFO_WFIFOCTL_WNUMEVT_0WORDS   (0x00000000u)
#define BFIFO_WFIFOCTL_WNUMEVT_4WORDS   (0x00000004u)
#define BFIFO_WFIFOCTL_WNUMEVT_8WORDS   (0x00000008u)
#define BFIFO_WFIFOCTL_WNUMEVT_12WORDS  (0x0000000cu)
#define BFIFO_WFIFOCTL_WNUMEVT_16WORDS  (0x00000010u)
#define BFIFO_WFIFOCTL_WNUMEVT_20WORDS  (0x00000014u)
#define BFIFO_WFIFOCTL_WNUMEVT_24WORDS  (0x00000018u)
#define BFIFO_WFIFOCTL_WNUMEVT_28WORDS  (0x0000001cu)
#define BFIFO_WFIFOCTL_WNUMEVT_32WORDS  (0x00000020u)
#define BFIFO_WFIFOCTL_WNUMEVT_36WORDS  (0x00000024u)
#define BFIFO_WFIFOCTL_WNUMEVT_40WORDS  (0x00000028u)
#define BFIFO_WFIFOCTL_WNUMEVT_44WORDS  (0x0000002cu)
#define BFIFO_WFIFOCTL_WNUMEVT_48WORDS  (0x00000030u)
#define BFIFO_WFIFOCTL_WNUMEVT_52WORDS  (0x00000034u)
#define BFIFO_WFIFOCTL_WNUMEVT_56WORDS  (0x00000038u)
#define BFIFO_WFIFOCTL_WNUMEVT_60WORDS  (0x0000003cu)
#define BFIFO_WFIFOCTL_WNUMEVT_64WORDS  (0x00000040u)

#define BFIFO_WFIFOCTL_WNUMDMA     (0x000000FFu)
#define BFIFO_WFIFOCTL_WNUMDMA_SHIFT    (0x00000000u)
#define BFIFO_WFIFOCTL_WNUMDMA_0WORDS   (0x00000000u)
#define BFIFO_WFIFOCTL_WNUMDMA_1WORDS   (0x00000001u)
#define BFIFO_WFIFOCTL_WNUMDMA_2WORDS   (0x00000002u)
#define BFIFO_WFIFOCTL_WNUMDMA_3WORDS   (0x00000003u)
#define BFIFO_WFIFOCTL_WNUMDMA_4WORDS   (0x00000004u)
#define BFIFO_WFIFOCTL_WNUMDMA_5WORDS   (0x00000005u)
#define BFIFO_WFIFOCTL_WNUMDMA_6WORDS   (0x00000006u)
#define BFIFO_WFIFOCTL_WNUMDMA_7WORDS   (0x00000007u)
#define BFIFO_WFIFOCTL_WNUMDMA_8WORDS   (0x00000008u)
#define BFIFO_WFIFOCTL_WNUMDMA_9WORDS   (0x00000009u)
#define BFIFO_WFIFOCTL_WNUMDMA_10WORDS  (0x0000000au)
#define BFIFO_WFIFOCTL_WNUMDMA_11WORDS  (0x0000000bu)
#define BFIFO_WFIFOCTL_WNUMDMA_12WORDS  (0x0000000cu)
#define BFIFO_WFIFOCTL_WNUMDMA_13WORDS  (0x0000000du)
#define BFIFO_WFIFOCTL_WNUMDMA_14WORDS  (0x0000000eu)
#define BFIFO_WFIFOCTL_WNUMDMA_15WORDS  (0x0000000fu)
#define BFIFO_WFIFOCTL_WNUMDMA_16WORDS  (0x00000010u)


/* WFIFOSTS */


#define BFIFO_WFIFOSTS_WLVL        (0x000000FFu)
#define BFIFO_WFIFOSTS_WLVL_SHIFT       (0x00000000u)


/* RFIFOCTL */


#define BFIFO_RFIFOCTL_RENA        (0x00010000u)
#define BFIFO_RFIFOCTL_RENA_SHIFT       (0x00000010u)

#define BFIFO_RFIFOCTL_RNUMEVT     (0x0000FF00u)
#define BFIFO_RFIFOCTL_RNUMEVT_SHIFT    (0x00000008u)
#define BFIFO_RFIFOCTL_RNUMEVT_0WORDS   (0x00000000u)
#define BFIFO_RFIFOCTL_RNUMEVT_4WORDS   (0x00000004u)
#define BFIFO_RFIFOCTL_RNUMEVT_8WORDS   (0x00000008u)
#define BFIFO_RFIFOCTL_RNUMEVT_12WORDS  (0x0000000cu)
#define BFIFO_RFIFOCTL_RNUMEVT_16WORDS  (0x00000010u)
#define BFIFO_RFIFOCTL_RNUMEVT_20WORDS  (0x00000014u)
#define BFIFO_RFIFOCTL_RNUMEVT_24WORDS  (0x00000018u)
#define BFIFO_RFIFOCTL_RNUMEVT_28WORDS  (0x0000001cu)
#define BFIFO_RFIFOCTL_RNUMEVT_32WORDS  (0x00000020u)
#define BFIFO_RFIFOCTL_RNUMEVT_36WORDS  (0x00000024u)
#define BFIFO_RFIFOCTL_RNUMEVT_40WORDS  (0x00000028u)
#define BFIFO_RFIFOCTL_RNUMEVT_44WORDS  (0x0000002cu)
#define BFIFO_RFIFOCTL_RNUMEVT_48WORDS  (0x00000030u)
#define BFIFO_RFIFOCTL_RNUMEVT_52WORDS  (0x00000034u)
#define BFIFO_RFIFOCTL_RNUMEVT_56WORDS  (0x00000038u)
#define BFIFO_RFIFOCTL_RNUMEVT_60WORDS  (0x0000003cu)
#define BFIFO_RFIFOCTL_RNUMEVT_64WORDS  (0x00000040u)

#define BFIFO_RFIFOCTL_RNUMDMA     (0x000000FFu)
#define BFIFO_RFIFOCTL_RNUMDMA_SHIFT    (0x00000000u)
#define BFIFO_RFIFOCTL_RNUMDMA_0WORDS   (0x00000000u)
#define BFIFO_RFIFOCTL_RNUMDMA_1WORDS   (0x00000001u)
#define BFIFO_RFIFOCTL_RNUMDMA_2WORDS   (0x00000002u)
#define BFIFO_RFIFOCTL_RNUMDMA_3WORDS   (0x00000003u)
#define BFIFO_RFIFOCTL_RNUMDMA_4WORDS   (0x00000004u)
#define BFIFO_RFIFOCTL_RNUMDMA_5WORDS   (0x00000005u)
#define BFIFO_RFIFOCTL_RNUMDMA_6WORDS   (0x00000006u)
#define BFIFO_RFIFOCTL_RNUMDMA_7WORDS   (0x00000007u)
#define BFIFO_RFIFOCTL_RNUMDMA_8WORDS   (0x00000008u)
#define BFIFO_RFIFOCTL_RNUMDMA_9WORDS   (0x00000009u)
#define BFIFO_RFIFOCTL_RNUMDMA_10WORDS  (0x0000000au)
#define BFIFO_RFIFOCTL_RNUMDMA_11WORDS  (0x0000000bu)
#define BFIFO_RFIFOCTL_RNUMDMA_12WORDS  (0x0000000cu)
#define BFIFO_RFIFOCTL_RNUMDMA_13WORDS  (0x0000000du)
#define BFIFO_RFIFOCTL_RNUMDMA_14WORDS  (0x0000000eu)
#define BFIFO_RFIFOCTL_RNUMDMA_15WORDS  (0x0000000fu)
#define BFIFO_RFIFOCTL_RNUMDMA_16WORDS  (0x00000010u)


/* RFIFOSTS */


#define BFIFO_RFIFOSTS_RLVL        (0x000000FFu)
#define BFIFO_RFIFOSTS_RLVL_SHIFT       (0x00000000u)




/* DATA_PORT */

#define BDATA_DATA_PORT_DATA      (0xFFFFFFFFu)
#define BDATA_DATA_PORT_DATA_SHIFT     (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif

