/**
 * \file  hw_spi.h
 *
 * \brief SPI register definitions
 */

/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_SPI_H_
#define _HW_SPI_H_

#ifdef __cplusplus
extern "C" {
#endif

#define SPI_SPIGCR0		(0x0)
#define SPI_SPIGCR1		(0x4)
#define SPI_SPIINT0		(0x8)
#define SPI_SPILVL		(0xC)
#define SPI_SPIFLG		(0x10)
#define SPI_SPIPC(n)		(0x14 + (4 * n))
#define SPI_SPIDAT0		(0x38)
#define SPI_SPIDAT1		(0x3C)
#define SPI_SPIBUF		(0x40)
#define SPI_SPIEMU		(0x44)
#define SPI_SPIDELAY		(0x48)
#define SPI_SPIDEF		(0x4C)
#define SPI_SPIFMT(n)		(0x50 + (n * 4))
#define SPI_INTVEC1		(0x64)

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* SPIGCR0 */


#define SPI_SPIGCR0_RESET       (0x00000001u)
#define SPI_SPIGCR0_RESET_SHIFT      (0x00000000u)

/* SPIGCR1 */

#define SPI_SPIGCR1_ENABLE           (0x01000000)
#define SPI_SPIGCR1_ENABLE_SHIFT     (0x00000018u)

#define SPI_SPIGCR1_LOOPBACK    (0x00010000u)
#define SPI_SPIGCR1_LOOPBACK_SHIFT   (0x00000010u)

#define SPI_SPIGCR1_POWERDOWN   (0x00000100u)
#define SPI_SPIGCR1_POWERDOWN_SHIFT  (0x00000008u)

#define SPI_SPIGCR1_CLKMOD      (0x00000002u)
#define SPI_SPIGCR1_CLKMOD_SHIFT     (0x00000001u)

#define SPI_SPIGCR1_MASTER      (0x00000001u)
#define SPI_SPIGCR1_MASTER_SHIFT     (0x00000000u)

/* SPIINT0 */


#define SPI_SPIINT0_ENABLEHIGHZ (0x01000000u)
#define SPI_SPIINT0_ENABLEHIGHZ_SHIFT (0x00000018u)

#define SPI_SPIINT0_DMAREQEN    (0x00010000u)
#define SPI_SPIINT0_DMAREQEN_SHIFT   (0x00000010u)

#define SPI_SPIINT0_TXINTENA    (0x00000200u)
#define SPI_SPIINT0_TXINTENA_SHIFT   (0x00000009u)

#define SPI_SPIINT0_RXINTENA    (0x00000100u)
#define SPI_SPIINT0_RXINTENA_SHIFT   (0x00000008u)

#define SPI_SPIINT0_OVRNINTENA  (0x00000040u)
#define SPI_SPIINT0_OVRNINTENA_SHIFT (0x00000006u)

#define SPI_SPIINT0_BITERRENA   (0x00000010u)
#define SPI_SPIINT0_BITERRENA_SHIFT  (0x00000004u)

#define SPI_SPIINT0_DESYNCENA   (0x00000008u)
#define SPI_SPIINT0_DESYNCENA_SHIFT  (0x00000003u)

#define SPI_SPIINT0_PARERRENA   (0x00000004u)
#define SPI_SPIINT0_PARERRENA_SHIFT  (0x00000002u)

#define SPI_SPIINT0_TIMEOUTENA  (0x00000002u)
#define SPI_SPIINT0_TIMEOUTENA_SHIFT (0x00000001u)

#define SPI_SPIINT0_DLENERRENA  (0x00000001u)
#define SPI_SPIINT0_DLENERRENA_SHIFT (0x00000000u)


/* SPILVL */


#define SPI_SPILVL_TXINTLVL     (0x00000200u)
#define SPI_SPILVL_TXINTLVL_SHIFT    (0x00000009u)

#define SPI_SPILVL_RXINTLVL     (0x00000100u)
#define SPI_SPILVL_RXINTLVL_SHIFT    (0x00000008u)


#define SPI_SPILVL_OVRNINTLVL   (0x00000040u)
#define SPI_SPILVL_OVRNINTLVL_SHIFT  (0x00000006u)


#define SPI_SPILVL_BITERRLVL    (0x00000010u)
#define SPI_SPILVL_BITERRLVL_SHIFT   (0x00000004u)

#define SPI_SPILVL_DESYNCLVL    (0x00000008u)
#define SPI_SPILVL_DESYNCLVL_SHIFT   (0x00000003u)

#define SPI_SPILVL_PARERRLVL    (0x00000004u)
#define SPI_SPILVL_PARERRLVL_SHIFT   (0x00000002u)

#define SPI_SPILVL_TIMEOUTLVL   (0x00000002u)
#define SPI_SPILVL_TIMEOUTLVL_SHIFT  (0x00000001u)

#define SPI_SPILVL_DLENERRLVL   (0x00000001u)
#define SPI_SPILVL_DLENERRLVL_SHIFT  (0x00000000u)


/* SPIFLG */


#define SPI_SPIFLG_TXINTFLG     (0x00000200u)
#define SPI_SPIFLG_TXINTFLG_SHIFT    (0x00000009u)

#define SPI_SPIFLG_RXINTFLG     (0x00000100u)
#define SPI_SPIFLG_RXINTFLG_SHIFT    (0x00000008u)


#define SPI_SPIFLG_OVRNINTFLG   (0x00000040u)
#define SPI_SPIFLG_OVRNINTFLG_SHIFT  (0x00000006u)


#define SPI_SPIFLG_BITERRFLG    (0x00000010u)
#define SPI_SPIFLG_BITERRFLG_SHIFT   (0x00000004u)

#define SPI_SPIFLG_DESYNCFLG    (0x00000008u)
#define SPI_SPIFLG_DESYNCFLG_SHIFT   (0x00000003u)

#define SPI_SPIFLG_PARERRFLG    (0x00000004u)
#define SPI_SPIFLG_PARERRFLG_SHIFT   (0x00000002u)

#define SPI_SPIFLG_TIMEOUTFLG   (0x00000002u)
#define SPI_SPIFLG_TIMEOUTFLG_SHIFT  (0x00000001u)

#define SPI_SPIFLG_DLENERRFLG   (0x00000001u)
#define SPI_SPIFLG_DLENERRFLG_SHIFT  (0x00000000u)


/* SPIPC0 */


#define SPI_SPIPC0_SOMIFUN      (0x00000800u)
#define SPI_SPIPC0_SOMIFUN_SHIFT     (0x0000000Bu)

#define SPI_SPIPC0_SIMOFUN      (0x00000400u)
#define SPI_SPIPC0_SIMOFUN_SHIFT     (0x0000000Au)

#define SPI_SPIPC0_CLKFUN       (0x00000200u)
#define SPI_SPIPC0_CLKFUN_SHIFT      (0x00000009u)

#define SPI_SPIPC0_ENAFUN       (0x00000100u)
#define SPI_SPIPC0_ENAFUN_SHIFT      (0x00000008u)

#define SPI_SPIPC0_SCS0FUN7     (0x00000080u)
#define SPI_SPIPC0_SCS0FUN7_SHIFT    (0x00000007u)

#define SPI_SPIPC0_SCS0FUN6     (0x00000040u)
#define SPI_SPIPC0_SCS0FUN6_SHIFT    (0x00000006u)

#define SPI_SPIPC0_SCS0FUN5     (0x00000020u)
#define SPI_SPIPC0_SCS0FUN5_SHIFT    (0x00000005u)

#define SPI_SPIPC0_SCS0FUN4     (0x00000010u)
#define SPI_SPIPC0_SCS0FUN4_SHIFT    (0x00000004u)

#define SPI_SPIPC0_SCS0FUN3     (0x00000008u)
#define SPI_SPIPC0_SCS0FUN3_SHIFT    (0x00000003u)

#define SPI_SPIPC0_SCS0FUN2     (0x00000004u)
#define SPI_SPIPC0_SCS0FUN2_SHIFT    (0x00000002u)

#define SPI_SPIPC0_SCS0FUN1     (0x00000002u)
#define SPI_SPIPC0_SCS0FUN1_SHIFT    (0x00000001u)

#define SPI_SPIPC0_SCS0FUN0     (0x00000001u)
#define SPI_SPIPC0_SCS0FUN0_SHIFT    (0x00000000u)


/* SPIPC1 */


#define SPI_SPIPC1_SOMIDIR      (0x00000800u)
#define SPI_SPIPC1_SOMIDIR_SHIFT     (0x0000000Bu)

#define SPI_SPIPC1_SIMODIR      (0x00000400u)
#define SPI_SPIPC1_SIMODIR_SHIFT     (0x0000000Au)

#define SPI_SPIPC1_CLKDIR       (0x00000200u)
#define SPI_SPIPC1_CLKDIR_SHIFT      (0x00000009u)

#define SPI_SPIPC1_ENADIR       (0x00000100u)
#define SPI_SPIPC1_ENADIR_SHIFT      (0x00000008u)

#define SPI_SPIPC1_SCS0DIR7     (0x00000080u)
#define SPI_SPIPC1_SCS0DIR7_SHIFT    (0x00000007u)

#define SPI_SPIPC1_SCS0DIR6     (0x00000040u)
#define SPI_SPIPC1_SCS0DIR6_SHIFT    (0x00000006u)

#define SPI_SPIPC1_SCS0DIR5     (0x00000020u)
#define SPI_SPIPC1_SCS0DIR5_SHIFT    (0x00000005u)

#define SPI_SPIPC1_SCS0DIR4     (0x00000010u)
#define SPI_SPIPC1_SCS0DIR4_SHIFT    (0x00000004u)

#define SPI_SPIPC1_SCS0DIR3     (0x00000008u)
#define SPI_SPIPC1_SCS0DIR3_SHIFT    (0x00000003u)

#define SPI_SPIPC1_SCS0DIR2     (0x00000004u)
#define SPI_SPIPC1_SCS0DIR2_SHIFT    (0x00000002u)

#define SPI_SPIPC1_SCS0DIR1     (0x00000002u)
#define SPI_SPIPC1_SCS0DIR1_SHIFT    (0x00000001u)

#define SPI_SPIPC1_SCS0DIR0     (0x00000001u)
#define SPI_SPIPC1_SCS0DIR0_SHIFT    (0x00000000u)


/* SPIPC2 */


#define SPI_SPIPC2_SOMIDIN      (0x00000800u)
#define SPI_SPIPC2_SOMIDIN_SHIFT     (0x0000000Bu)

#define SPI_SPIPC2_SIMODIN      (0x00000400u)
#define SPI_SPIPC2_SIMODIN_SHIFT     (0x0000000Au)

#define SPI_SPIPC2_CLKDIN       (0x00000200u)
#define SPI_SPIPC2_CLKDIN_SHIFT      (0x00000009u)

#define SPI_SPIPC2_ENADIN       (0x00000100u)
#define SPI_SPIPC2_ENADIN_SHIFT      (0x00000008u)

#define SPI_SPIPC2_SCS0DIN7     (0x00000080u)
#define SPI_SPIPC2_SCS0DIN7_SHIFT    (0x00000007u)

#define SPI_SPIPC2_SCS0DIN6     (0x00000040u)
#define SPI_SPIPC2_SCS0DIN6_SHIFT    (0x00000006u)

#define SPI_SPIPC2_SCS0DIN5     (0x00000020u)
#define SPI_SPIPC2_SCS0DIN5_SHIFT    (0x00000005u)

#define SPI_SPIPC2_SCS0DIN4     (0x00000010u)
#define SPI_SPIPC2_SCS0DIN4_SHIFT    (0x00000004u)

#define SPI_SPIPC2_SCS0DIN3     (0x00000008u)
#define SPI_SPIPC2_SCS0DIN3_SHIFT    (0x00000003u)

#define SPI_SPIPC2_SCS0DIN2     (0x00000004u)
#define SPI_SPIPC2_SCS0DIN2_SHIFT    (0x00000002u)

#define SPI_SPIPC2_SCS0DIN1     (0x00000002u)
#define SPI_SPIPC2_SCS0DIN1_SHIFT    (0x00000001u)

#define SPI_SPIPC2_SCS0DIN0     (0x00000001u)
#define SPI_SPIPC2_SCS0DIN0_SHIFT    (0x00000000u)


/* SPIPC3 */


#define SPI_SPIPC3_SOMIDOUT     (0x00000800u)
#define SPI_SPIPC3_SOMIDOUT_SHIFT    (0x0000000Bu)

#define SPI_SPIPC3_SIMODOUT     (0x00000400u)
#define SPI_SPIPC3_SIMODOUT_SHIFT    (0x0000000Au)

#define SPI_SPIPC3_CLKDOUT      (0x00000200u)
#define SPI_SPIPC3_CLKDOUT_SHIFT     (0x00000009u)

#define SPI_SPIPC3_ENADOUT      (0x00000100u)
#define SPI_SPIPC3_ENADOUT_SHIFT     (0x00000008u)

#define SPI_SPIPC3_SCS0DOUT7    (0x00000080u)
#define SPI_SPIPC3_SCS0DOUT7_SHIFT   (0x00000007u)

#define SPI_SPIPC3_SCS0DOUT6    (0x00000040u)
#define SPI_SPIPC3_SCS0DOUT6_SHIFT   (0x00000006u)

#define SPI_SPIPC3_SCS0DOUT5    (0x00000020u)
#define SPI_SPIPC3_SCS0DOUT5_SHIFT   (0x00000005u)

#define SPI_SPIPC3_SCS0DOUT4    (0x00000010u)
#define SPI_SPIPC3_SCS0DOUT4_SHIFT   (0x00000004u)

#define SPI_SPIPC3_SCS0DOUT3    (0x00000008u)
#define SPI_SPIPC3_SCS0DOUT3_SHIFT   (0x00000003u)

#define SPI_SPIPC3_SCS0DOUT2    (0x00000004u)
#define SPI_SPIPC3_SCS0DOUT2_SHIFT   (0x00000002u)

#define SPI_SPIPC3_SCS0DOUT1    (0x00000002u)
#define SPI_SPIPC3_SCS0DOUT1_SHIFT   (0x00000001u)

#define SPI_SPIPC3_SCS0DOUT0    (0x00000001u)
#define SPI_SPIPC3_SCS0DOUT0_SHIFT   (0x00000000u)


/* SPIPC4 */


#define SPI_SPIPC4_SOMISET      (0x00000800u)
#define SPI_SPIPC4_SOMISET_SHIFT     (0x0000000Bu)

#define SPI_SPIPC4_SIMOSET      (0x00000400u)
#define SPI_SPIPC4_SIMOSET_SHIFT     (0x0000000Au)

#define SPI_SPIPC4_CLKSET       (0x00000200u)
#define SPI_SPIPC4_CLKSET_SHIFT      (0x00000009u)

#define SPI_SPIPC4_ENASET       (0x00000100u)
#define SPI_SPIPC4_ENASET_SHIFT      (0x00000008u)

#define SPI_SPIPC4_SCS0SET7     (0x00000080u)
#define SPI_SPIPC4_SCS0SET7_SHIFT    (0x00000007u)

#define SPI_SPIPC4_SCS0SET6     (0x00000040u)
#define SPI_SPIPC4_SCS0SET6_SHIFT    (0x00000006u)

#define SPI_SPIPC4_SCS0SET5     (0x00000020u)
#define SPI_SPIPC4_SCS0SET5_SHIFT    (0x00000005u)

#define SPI_SPIPC4_SCS0SET4     (0x00000010u)
#define SPI_SPIPC4_SCS0SET4_SHIFT    (0x00000004u)

#define SPI_SPIPC4_SCS0SET3     (0x00000008u)
#define SPI_SPIPC4_SCS0SET3_SHIFT    (0x00000003u)

#define SPI_SPIPC4_SCS0SET2     (0x00000004u)
#define SPI_SPIPC4_SCS0SET2_SHIFT    (0x00000002u)

#define SPI_SPIPC4_SCS0SET1     (0x00000002u)
#define SPI_SPIPC4_SCS0SET1_SHIFT    (0x00000001u)

#define SPI_SPIPC4_SCS0SET0     (0x00000001u)
#define SPI_SPIPC4_SCS0SET0_SHIFT    (0x00000000u)


/* SPIPC5 */


#define SPI_SPIPC5_SOMICLR      (0x00000800u)
#define SPI_SPIPC5_SOMICLR_SHIFT     (0x0000000Bu)

#define SPI_SPIPC5_SIMOCLR      (0x00000400u)
#define SPI_SPIPC5_SIMOCLR_SHIFT     (0x0000000Au)

#define SPI_SPIPC5_CLKCLR       (0x00000200u)
#define SPI_SPIPC5_CLKCLR_SHIFT      (0x00000009u)

#define SPI_SPIPC5_ENACLR       (0x00000100u)
#define SPI_SPIPC5_ENACLR_SHIFT      (0x00000008u)

#define SPI_SPIPC5_SCS0CLR7     (0x00000080u)
#define SPI_SPIPC5_SCS0CLR7_SHIFT    (0x00000007u)

#define SPI_SPIPC5_SCS0CLR6     (0x00000040u)
#define SPI_SPIPC5_SCS0CLR6_SHIFT    (0x00000006u)

#define SPI_SPIPC5_SCS0CLR5     (0x00000020u)
#define SPI_SPIPC5_SCS0CLR5_SHIFT    (0x00000005u)

#define SPI_SPIPC5_SCS0CLR4     (0x00000010u)
#define SPI_SPIPC5_SCS0CLR4_SHIFT    (0x00000004u)

#define SPI_SPIPC5_SCS0CLR3     (0x00000008u)
#define SPI_SPIPC5_SCS0CLR3_SHIFT    (0x00000003u)

#define SPI_SPIPC5_SCS0CLR2     (0x00000004u)
#define SPI_SPIPC5_SCS0CLR2_SHIFT    (0x00000002u)

#define SPI_SPIPC5_SCS0CLR1     (0x00000002u)
#define SPI_SPIPC5_SCS0CLR1_SHIFT    (0x00000001u)

#define SPI_SPIPC5_SCS0CLR0     (0x00000001u)
#define SPI_SPIPC5_SCS0CLR0_SHIFT    (0x00000000u)


/* SPIDAT0 */


#define SPI_SPIDAT0_TXDATA      (0x0000FFFFu)
#define SPI_SPIDAT0_TXDATA_SHIFT     (0x00000000u)


/* SPIDAT1 */


#define SPI_SPIDAT1_CSHOLD      (0x10000000u)
#define SPI_SPIDAT1_CSHOLD_SHIFT     (0x0000001Cu)

#define SPI_SPIDAT1_WDEL        (0x04000000u)
#define SPI_SPIDAT1_WDEL_SHIFT       (0x0000001Au)

#define SPI_SPIDAT1_DFSEL       (0x03000000u)
#define SPI_SPIDAT1_DFSEL_SHIFT      (0x00000018u)
/*----DFSEL Tokens----*/
#define SPI_SPIDAT1_DFSEL_FORMAT0    (0x00000000u)
#define SPI_SPIDAT1_DFSEL_FORMAT1    (0x00000001u)
#define SPI_SPIDAT1_DFSEL_FORMAT2    (0x00000002u)
#define SPI_SPIDAT1_DFSEL_FORMAT3    (0x00000003u)

#define SPI_SPIDAT1_CSNR        (0x00FF0000u)
#define SPI_SPIDAT1_CSNR_SHIFT       (0x00000010u)

#define SPI_SPIDAT1_TXDATA      (0x0000FFFFu)
#define SPI_SPIDAT1_TXDATA_SHIFT     (0x00000000u)


/* SPIBUF */

#define SPI_SPIBUF_RXEMPTY      (0x80000000u)
#define SPI_SPIBUF_RXEMPTY_SHIFT     (0x0000001Fu)

#define SPI_SPIBUF_RXOVR        (0x40000000u)
#define SPI_SPIBUF_RXOVR_SHIFT       (0x0000001Eu)

#define SPI_SPIBUF_TXFULL       (0x20000000u)
#define SPI_SPIBUF_TXFULL_SHIFT      (0x0000001Du)

#define SPI_SPIBUF_BITERR       (0x10000000u)
#define SPI_SPIBUF_BITERR_SHIFT      (0x0000001Cu)

#define SPI_SPIBUF_DESYNC       (0x08000000u)
#define SPI_SPIBUF_DESYNC_SHIFT      (0x0000001Bu)

#define SPI_SPIBUF_PARERR       (0x04000000u)
#define SPI_SPIBUF_PARERR_SHIFT      (0x0000001Au)

#define SPI_SPIBUF_TIMEOUT      (0x02000000u)
#define SPI_SPIBUF_TIMEOUT_SHIFT     (0x00000019u)

#define SPI_SPIBUF_DLENERR      (0x01000000u)
#define SPI_SPIBUF_DLENERR_SHIFT     (0x00000018u)

#define SPI_SPIBUF_RXDATA       (0x0000FFFFu)
#define SPI_SPIBUF_RXDATA_SHIFT      (0x00000000u)


/* SPIEMU */


#define SPI_SPIEMU_RXDATA       (0x0000FFFFu)
#define SPI_SPIEMU_RXDATA_SHIFT      (0x00000000u)


/* SPIDELAY */

#define SPI_SPIDELAY_C2TDELAY   (0xFF000000u)
#define SPI_SPIDELAY_C2TDELAY_SHIFT  (0x00000018u)

#define SPI_SPIDELAY_T2CDELAY   (0x00FF0000u)
#define SPI_SPIDELAY_T2CDELAY_SHIFT  (0x00000010u)

#define SPI_SPIDELAY_T2EDELAY   (0x0000FF00u)
#define SPI_SPIDELAY_T2EDELAY_SHIFT  (0x00000008u)

#define SPI_SPIDELAY_C2EDELAY   (0x000000FFu)
#define SPI_SPIDELAY_C2EDELAY_SHIFT  (0x00000000u)


/* SPIDEF */


#define SPI_SPIDEF_CSDEF       (0x0000000FFu)
#define SPI_SPIDEF_CSDEFN(n)   (1 << n)
#define SPI_SPIDEF_CSDEF_SHIFT (0x00000000u)


/* SPIFMT */


#define SPI_SPIFMT_WDELAY       (0x3F000000u)
#define SPI_SPIFMT_WDELAY_SHIFT      (0x00000018u)

#define SPI_SPIFMT_PARPOL       (0x00800000u)
#define SPI_SPIFMT_PARPOL_SHIFT      (0x00000017u)

#define SPI_SPIFMT_PARENA       (0x00400000u)
#define SPI_SPIFMT_PARENA_SHIFT      (0x00000016u)

#define SPI_SPIFMT_WAITENA      (0x00200000u)
#define SPI_SPIFMT_WAITENA_SHIFT     (0x00000015u)

#define SPI_SPIFMT_SHIFTDIR     (0x00100000u)
#define SPI_SPIFMT_SHIFTDIR_SHIFT    (0x00000014u)

#define SPI_SPIFMT_DISCSTIMERS  (0x00040000u)
#define SPI_SPIFMT_DISCSTIMERS_SHIFT (0x00000012u)

#define SPI_SPIFMT_POLARITY     (0x00020000u)
#define SPI_SPIFMT_POLARITY_SHIFT    (0x00000011u)

#define SPI_SPIFMT_PHASE        (0x00010000u)
#define SPI_SPIFMT_PHASE_SHIFT       (0x00000010u)

#define SPI_SPIFMT_PRESCALE     (0x0000FF00u)
#define SPI_SPIFMT_PRESCALE_SHIFT    (0x00000008u)


#define SPI_SPIFMT_CHARLEN      (0x0000001Fu)
#define SPI_SPIFMT_CHARLEN_SHIFT     (0x00000000u)


/* INTVEC */

#define SPI_INTVEC_INTVECT      (0x0000003Eu)
#define SPI_INTVEC_INTVECT_SHIFT     (0x00000001u)


#ifdef __cplusplus
}
#endif

#endif
