--- Title: ads5560.vhd
--- Description: 
---
---     o  0
---     | /       Copyright (c) 2012
---    (CL)---o   Critical Link, LLC
---      \
---       O
---
--- Company: Critical Link, LLC.
--- Date: 11/27/2012
--- Version: 1.00
--- Revisions: 
---   1.00 - Initial release.

library IEEE;
library UNISIM;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use UNISIM.VCOMPONENTS.ALL;

library WORK;
use WORK.MityDSP_L138_pkg.ALL;

entity ads5560 is
   Port ( 
      clk             : in  std_logic;
      i_ABus          : in  std_logic_vector(5 downto 0);
      i_DBus          : in  std_logic_vector(15 downto 0);
      o_DBus          : out std_logic_vector(15 downto 0);
      i_wr_en         : in  std_logic;
      i_rd_en         : in  std_logic;
      i_cs            : in  std_logic;
      o_irq           : out std_logic := '0';
      i_ilevel        : in  std_logic_vector(1 downto 0) := "00";      
      i_ivector       : in  std_logic_vector(3 downto 0) := "0000";   
      
      -- ADC interface
      i_adc_in_p      : in  std_logic_vector(7 downto 0);  -- DDR inputs
      i_adc_in_n      : in  std_logic_vector(7 downto 0);  -- DDR inputs
      i_adc_clk_p     : in  std_logic;
      i_adc_clk_n     : in  std_logic;
      i_adc_ovr       : in  std_logic;
		o_adc_clk       : out std_logic;
      
      -- UPP interface
      i_upp_clock      : in  std_logic; -- from fabric, minimum 40 MHz
      o_upp_clock      : out std_logic;
      o_upp_d          : out std_logic_vector(15 downto 0);
      o_upp_enable     : out std_logic;
      o_upp_start      : out std_logic;
      i_upp_wait       : in  std_logic
                  
   );
end ads5560;

architecture rtl of ads5560 is

constant CORE_VERSION_MAJOR:  std_logic_vector(3 downto 0) := CONV_STD_LOGIC_VECTOR( 01, 4);
constant CORE_VERSION_MINOR:  std_logic_vector(3 downto 0) := CONV_STD_LOGIC_VECTOR( 00, 4);
constant CORE_ID:             std_logic_vector(7 downto 0) := CONV_STD_LOGIC_VECTOR( 255,8);
constant CORE_YEAR:           std_logic_vector(4 downto 0) := CONV_STD_LOGIC_VECTOR( 12, 5);
constant CORE_MONTH:          std_logic_vector(3 downto 0) := CONV_STD_LOGIC_VECTOR( 13, 4);
constant CORE_DAY:            std_logic_vector(4 downto 0) := CONV_STD_LOGIC_VECTOR( 29, 5);

signal version_reg : std_logic_vector(15 downto 0) := x"0000";
signal ver_rd      : std_logic := '0';
signal enable      : std_logic := '0';
signal adc_clk     : std_logic := '0';
signal adc_data    : std_logic_vector(15 downto 0) := x"0000";
signal adc_raw_se  : std_logic_vector(7 downto 0) := x"00";
signal upp_d       : std_logic_vector(15 downto 0) := x"0000";

signal fifo_din, fifo_dout : std_logic_vector(15 downto 0) := x"0000";
signal fifo_wr, fifo_rd : std_logic := '0';
signal fifo_rst : std_logic := '0';
signal fifo_data_valid : std_logic := '0';
signal upp_start, upp_started : std_logic := '0';
signal upp_enable : std_logic := '0';

COMPONENT fifo_dpram2048x16
  PORT (
    rst : IN STD_LOGIC;
    wr_clk : IN STD_LOGIC;
    rd_clk : IN STD_LOGIC;
    din : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
    wr_en : IN STD_LOGIC;
    rd_en : IN STD_LOGIC;
    dout : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
    full : OUT STD_LOGIC;
    empty : OUT STD_LOGIC;
    valid : OUT STD_LOGIC
  );
END COMPONENT;

begin

o_irq <= '0';
o_adc_clk <= adc_clk;

adc_clock_buf : IBUFGDS
   generic map (
      DIFF_TERM => TRUE, -- Differential Termination 
      IBUF_LOW_PWR => TRUE, -- Low power (TRUE) vs. performance (FALSE) setting for referenced I/O standards
      IOSTANDARD => "LVDS_33")
   port map (
      O  => adc_clk,      -- Clock buffer output
      I  => i_adc_clk_p,  -- Diff_p clock buffer input (connect directly to top-level port)
      IB => i_adc_clk_n   -- Diff_n clock buffer input (connect directly to top-level port)
   );

gen_ios : for i in 0 to 7 generate
begin

adc_ibufds : IBUFDS
   generic map (
      DIFF_TERM    => TRUE, -- Differential Termination 
      IBUF_LOW_PWR => TRUE, -- Low power (TRUE) vs. performance (FALSE) setting for referenced I/O standards
      IOSTANDARD   => "LVDS_33")
   port map (
      O  => adc_raw_se(i),  -- Buffer output
      I  => i_adc_in_p(i),  -- Diff_p buffer input (connect directly to top-level port)
      IB => i_adc_in_n(i)   -- Diff_n buffer input (connect directly to top-level port)
   );
   
adc_ddr_data : IDDR2
   generic map(
      DDR_ALIGNMENT => "NONE", -- Sets output alignment to "NONE", "C0", "C1" 
      INIT_Q0       => '0', -- Sets initial state of the Q0 output to '0' or '1'
      INIT_Q1       => '0', -- Sets initial state of the Q1 output to '0' or '1'
      SRTYPE        => "SYNC") -- Specifies "SYNC" or "ASYNC" set/reset
   port map (
      Q0 => adc_data(i*2),   -- 1-bit output captured with C0 clock
      Q1 => adc_data(i*2+1), -- 1-bit output captured with C1 clock
      C0 => adc_clk,     -- 1-bit clock input
      C1 => not adc_clk,         -- 1-bit clock input
      CE => '1',             -- 1-bit clock enable input
      D  => adc_raw_se(i),   -- 1-bit data input 
      R  => '0',             -- 1-bit reset input
      S  => '0'              -- 1-bit set input
   );

end generate gen_ios;
   
reg_read : process(clk)
begin
   if rising_edge(clk) then

       ver_rd <= '0';

       if i_cs='1' then
           case i_ABus is
           
           when "000000" =>
               o_DBus <= version_reg;
               ver_rd <= i_rd_en;
           
           when "000001" => 
               o_DBus <= x"000" & "000" & enable;
               
           when others => NULL;
           
           end case;
       else
           o_DBus <= (others=>'0');
       end if;   
   end if;
end process reg_read;

reg_write : process(clk)
begin
   if rising_edge(clk) then
      
       if i_cs='1' and i_wr_en='1' then
           case i_ABus is
           
           when "000001" => 
              enable <= i_DBus(0);
                         
           when others => NULL;
           
           end case;
       end if;   
   end if;
end process reg_write;      

data_latch : process(adc_clk)
begin
    if rising_edge(adc_clk) then
        fifo_din <= adc_data;
        fifo_wr  <= '1';
    end if;
end process data_latch;

upp_output : process(i_upp_clock)
begin
    if enable='0' then
        upp_started <= '0';
        upp_start   <= '0';
        upp_enable  <= '0';
    elsif rising_edge(i_upp_clock) then
        upp_d <= fifo_dout;
        
        if i_upp_wait='0' then
            fifo_rd  <= '1';
            if fifo_data_valid='1' then
                upp_started <= '1';
                upp_start   <= not upp_started;
                upp_enable <= '1';
            else
                upp_enable <= '0';
            end if;
        else
            fifo_rd <= '0';
            upp_start <= '0';
            upp_enable <= '0';
        end if;    
    end if;
end process;

fifo_rst      <= not enable;
o_upp_d       <= upp_d;
o_upp_clock   <= i_upp_clock;
o_upp_enable  <= upp_enable;
o_upp_start   <= upp_start;

data_fifo : fifo_dpram2048x16
  PORT MAP (
    rst    => fifo_rst,
    wr_clk => adc_clk,
    rd_clk => i_upp_clock,
    din    => fifo_din,
    wr_en  => fifo_wr,
    rd_en  => fifo_rd,
    dout   => fifo_dout,
    full   => open,
    empty  => open,
    valid  => fifo_data_valid
  );

end rtl;