/**
 * @file 		UppSignalDAC.h
 * @author		James Thesing <james.thesing@criticallink.com>
 * @version		1.0
 *
 * @section LICENSE
 *
 *
 *    o  0
 *    | /       Copyright (c) 2005-2011
 *  (CL)---o   Critical Link, LLC
 *    \
 *     O
 *
 *
 * @section DESCRIPTION
 *
 * This class handles exercising the DAC5672 on the DSP. Input data is
 * generated by the DSPAPP and then sent over upp to the DAC. Output
 * is generated as two analog signals to two coaxial outputs.
 */

#ifndef UppSignalDAC_H_
#define UppSignalDAC_H_

//#include "UppSignalDAC.h"
#include "core/DspUpp.h"

#include <stdint.h>
#include <std.h>
#include <tsk.h>
#include <clk.h>
#include <vector>
#include <string>


class DAC5672/*UppSignalDAC*/{
public:

	/**
	 * Get a pointer to the singleton UppSignalDAC object.
	 *
	 * @return A pointer to the singleton object.
	 */

	static DAC5672/*UppSignalDAC*/* getInstance();

	/**
	 * starts an endless loop of sending 32k * 2 bytes of data
	 * @param buff1 - buffer used to send data to upp
	 * @param buff2 - buffer used to send data to upp
	 * @param buff3 - buffer used to send data to upp
	 * @param data - table used to store values that are sent to buffers
	 */
	void communicate(int16_t* buff1, int16_t* buff2, int16_t* buff3, int16_t *data );

	/**
	 * Generates data to fill buffer, in this case a sign wave at designated frequency and amplitude
	 * @param amplitude - value (0,1] - the amplitude of the sign wave
	 * @param frequency - the desired output frequency of signwave
	 * @param data - the int16_t array to put generated data
	 */
	void fillData( float amplitude, int32_t frequency, int16_t* data);


private:

	/**
	 * Private Constructor - forces getInstance() use
	 */
	DAC5672/*UppSignalDAC*/();

	/**
	 * Destructor
	 */
	~DAC5672/*UppSignalDAC*/();

	void init();


	static DAC5672/*UppSignalDAC*/* mpDAC5672/*mpUppSignalDAC*/; //!< Pointer to the singleton.
	bool filled; //!<ensures table is filled only once
	const MityDSP::tcDspUpp::teUppChan meXmitChan; //!< Constant for
			//!< transmit channel.
	static const uint32_t uppFreq = 50000000; //!<freq of upp
	MityDSP::tcDspUpp* mpDspUpp; //!< Pointer to uPP driver singleton.
	MBX_Handle mhXmitMbx; //!< Handle to transmit mailbox.
	const MityDSP::tcDspUpp::teUppChan meRecvChan; //!< Constant for
			//!< receive channel.
	MBX_Handle mhRecvMbx; //!< Handle to receive mailbox.

};

#endif /*UppSignalDAC_H_*/
