/**
 * \file qwatchdog.h
 *
 * \brief Simple QT based watchdog class definition
 *
 * \author Tim Iskander
 *
 *     o  0
 *     | /       Copyright (c) 2005-2012
 *    (CL)---o   Critical Link, LLC
 *      \
 *       O
 */
#ifndef TCWATCHDOG_H_
#define TCWATCHDOG_H_

#include <QObject>

/**
 * @brief Watchdog Class. Pings the System watchdog
 */
class tcQWatchDog : public QObject
{
    Q_OBJECT
public:
    tcQWatchDog  (int anBarkMs = 10000, QObject* apParent=NULL);
    virtual ~tcQWatchDog ();

protected:
    void timerEvent(QTimerEvent *);

    int     mnBarkMs;   //!< Watchdog Ping Interval in ms
    int     mnFd;       //!< File descripter for Watchdog
    int     mnTimerId;  //!< TimerID
};

#endif  // TCWATCHDOG_H_

