# to execute this script using quartus_sh for generating Quartus QPF and QSF accordingly
#   quartus_sh --script=create_ghrd_quartus.tcl
#
set devicefamily CYCLONEV
set device 5CSXFC6D6F31C7
set projectname pcie_rp_ed_5csxfc6
set qipfiles "pcie_rp_ed_5csxfc6/synthesis/pcie_rp_ed_5csxfc6.qip,ip/altsource_probe/hps_reset.qip"
set hdlfiles "ip/debounce/debounce.v,pcie_rp_ed_top.v,ip/edge_detect/altera_edge_detector.v"
set sdcfiles "soc_system_timing.sdc"
set topname pcie_rp_ed_top

# ... alternatively, above parameters can be passed in as script arguments
#   quartus_sh --script=create_ed_quartus.tcl <parameter1 value1 parameter2 value2 ...>
# parameters of this TCL includes
#   devicefamily  : FPGA device family
#   device        : FPGA device number
#   projectname   : Quartus project name
#   qipfiles      : QIP file path(s), multiple paths need seperator of ","
#   hdlfiles      : HDL file path(s), multiple paths need seperator of ","
#   topname       : top module name


proc show_arguments {} {
  global quartus
  global devicefamily
  global device
  global projectname
  global topname
  global qipfiles
  global hdlfiles

  foreach {key value} $quartus(args) {
    puts "-> Accepted parameter: $key,  \tValue: $value"
    if {$key == "devicefamily"} {
      set devicefamily $value
    }
    if {$key == "device"} {
      set device $value
    }
    if {$key == "projectname"} {
      set projectname $value
    }
    if {$key == "topname"} {
      set topname $value
    }
    if {$key == "qipfiles"} {
      set qipfiles $value
    }
    if {$key == "hdlfiles"} {
      set hdlfiles $value
    }

  }
}
show_arguments

#regsub -all {\mfoo\M} $string bar string
#set wordList [regexp -inline -all -- {\S+} $text]
if {[regexp {,} $qipfiles]} {
  set qipfilelist [split $qipfiles ,]
} else {
  set qipfilelist $qipfiles
}

if {[regexp {,} $hdlfiles]} {
  set hdlfilelist [split $hdlfiles ,]
} else {
  set hdlfilelist $hdlfiles
}

if {[regexp {,} $sdcfiles]} {
  set sdcfilelist [split $sdcfiles ,]
} else {
  set sdcfilelist $sdcfiles
}

project_new -overwrite -family $devicefamily -part $device $projectname

set_global_assignment -name TOP_LEVEL_ENTITY $topname

foreach qipfile $qipfilelist {
  set_global_assignment -name QIP_FILE $qipfile
}

foreach hdlfile $hdlfilelist {
  set_global_assignment -name VERILOG_FILE $hdlfile
}

foreach sdcfile $sdcfilelist {
  set_global_assignment -name SDC_FILE $sdcfile
}


set_global_assignment -name PROJECT_OUTPUT_DIRECTORY output_files
set_global_assignment -name EDA_SIMULATION_TOOL "<None>"
set_global_assignment -name EDA_OUTPUT_DATA_FORMAT NONE -section_id eda_simulation

set_location_assignment PIN_AC18 -to fpga_clk_50
set_location_assignment PIN_AA13 -to fpga_button_pio[0]
set_location_assignment PIN_AB13 -to fpga_button_pio[1]
set_location_assignment PIN_AG11 -to fpga_dipsw_pio[3]
set_location_assignment PIN_AF11 -to fpga_dipsw_pio[2]
set_location_assignment PIN_AH9 -to fpga_dipsw_pio[1]
set_location_assignment PIN_AG10 -to fpga_dipsw_pio[0]
set_location_assignment PIN_AB17 -to fpga_led_pio[3]
set_location_assignment PIN_W15 -to fpga_led_pio[2]
set_location_assignment PIN_Y16 -to fpga_led_pio[1]
set_location_assignment PIN_AK2 -to fpga_led_pio[0]
set_location_assignment PIN_AD27 -to fpga_rst_n
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_clk_50
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_button_pio[1]
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_button_pio[0]
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_dipsw_pio[3]
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_dipsw_pio[2]
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_dipsw_pio[1]
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_dipsw_pio[0]
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_led_pio[3]
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_led_pio[2]
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_led_pio[1]
set_instance_assignment -name IO_STANDARD "1.5 V" -to fpga_led_pio[0]
set_location_assignment PIN_AE2 -to pcie_hip_rx_in0
set_location_assignment PIN_AC2 -to pcie_hip_rx_in1
set_location_assignment PIN_AA2 -to pcie_hip_rx_in2
set_location_assignment PIN_W2 -to pcie_hip_rx_in3
set_location_assignment PIN_AD4 -to pcie_hip_tx_out0
set_location_assignment PIN_AB4 -to pcie_hip_tx_out1
set_location_assignment PIN_Y4 -to pcie_hip_tx_out2
set_location_assignment PIN_V4 -to pcie_hip_tx_out3
set_location_assignment PIN_W22 -to pcie_npor_pin_perst
set_instance_assignment -name WEAK_PULL_UP_RESISTOR ON -to pcie_npor_pin_perst
set_location_assignment PIN_W8 -to pcie_refclk_clk
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to pcie_hip_rx_in0
set_location_assignment PIN_AE1 -to "pcie_hip_rx_in0(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to pcie_hip_rx_in1
set_location_assignment PIN_AC1 -to "pcie_hip_rx_in1(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to pcie_hip_rx_in2
set_location_assignment PIN_AA1 -to "pcie_hip_rx_in2(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to pcie_hip_rx_in3
set_location_assignment PIN_W1 -to "pcie_hip_rx_in3(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to pcie_hip_tx_out0
set_location_assignment PIN_AD3 -to "pcie_hip_tx_out0(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to pcie_hip_tx_out1
set_location_assignment PIN_AB3 -to "pcie_hip_tx_out1(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to pcie_hip_tx_out2
set_location_assignment PIN_Y3 -to "pcie_hip_tx_out2(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to pcie_hip_tx_out3
set_location_assignment PIN_V3 -to "pcie_hip_tx_out3(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to "pcie_hip_rx_in0(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to "pcie_hip_rx_in1(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to "pcie_hip_rx_in2(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to "pcie_hip_tx_out0(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to "pcie_hip_tx_out1(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to "pcie_hip_tx_out2(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to "pcie_hip_tx_out3(n)"
set_instance_assignment -name IO_STANDARD "1.5-V PCML" -to pcie_refclk_clk
set_location_assignment PIN_W7 -to "pcie_refclk_clk(n)"
set_location_assignment PIN_AG6 -to pcie_perstn_out
set_instance_assignment -name AUTO_OPEN_DRAIN_PINS ON -to pcie_perstn_out
set_location_assignment PIN_P9 -to fpga_clk_100
set_instance_assignment -name IO_STANDARD LVDS -to fpga_clk_100
set_location_assignment PIN_P8 -to "fpga_clk_100(n)"

# Quartus setting options
set_global_assignment -name SEED 1
set_global_assignment -name OPTIMIZATION_TECHNIQUE SPEED
set_global_assignment -name SYNTH_TIMING_DRIVEN_SYNTHESIS ON
set_global_assignment -name OPTIMIZE_HOLD_TIMING "ALL PATHS"
set_global_assignment -name FITTER_EFFORT "STANDARD FIT"
set_global_assignment -name PRE_MAPPING_RESYNTHESIS ON
set_global_assignment -name FINAL_PLACEMENT_OPTIMIZATION ALWAYS

# enabling signaltap 
set_global_assignment -name ENABLE_SIGNALTAP OFF
#set_global_assignment -name USE_SIGNALTAP_FILE tput_measure.stp
#set_global_assignment -name SIGNALTAP_FILE tput_measure.stp

#set_instance_assignment -name PARTITION_HIERARCHY root_partition -to | -section_id Top

project_close
