#include <semaphore.h>

namespace MityDSP {

/**
 *  The tcWatchdog class provides a simple abstraction for the linux
 *  watchdog device management.  Typical use pattern:
 *
 *  @code {
 *      
 *  tcWatchdog* pW = new tcWatchdog();
 *  int handle = pW->RegisterCheckpoint();
 *  pW->StartWatchDog(10);
 *
 *  while (!done)
 *  {
 *     /// do stuff
 *     pW->Checkin(handle);
 *  }
 *
 *  delete pW;
 *  
 *  @code }
 */
class tcWatchdog
{
public:
	tcWatchdog(const char* apDevice = "/dev/watchdog");
	virtual ~tcWatchdog(void);

	int StartWatchDog(int TimeoutSecs);

	int RegisterCheckpoint(void);

	int UnRegisterCheckpoint(int handle);

	int Checkin(int Checkpoint);

protected:
	volatile int	mnMask;
	volatile int	mnSet;
	sem_t		mhSem;
	char*		mpFileName;
	int		mnFd;
};

}
