#!/bin/sh
# returns the current ftdimage type for the system (cl or gige) from uBoot.env
# or updates it if first argument contains data

if [ "x$1" = "x" ];
then
	result=`grep "^fdtimage" /etc/uBoot.env | awk -F"=" '{ print $2}' \
		| sed -e 's/.*_//' | sed -e 's/\.dtb//'`
	echo $result
else
	newfile=`cd /boot && ls *$1.dtb`
	# update interface list based on selected interface type
        if [ "$1" = "gige" ];
        then
		config_file=`cd /home/root/application && ls *_GIGE`
                sed -e 's/INTERFACES=.*/INTERFACES="eth0"/' /etc/ifplugd/ifplugd.conf > /tmp/ifplugd.conf
        else
		config_file=`cd /home/root/application && ls *_TEC_CAMLINK*`
		if [ "x${config_file}" = "x" ];
		then
			config_file=`cd /home/root/application && ls *_CAMLINK*`
		fi
                sed -e 's/INTERFACES=.*/INTERFACES=""/' /etc/ifplugd/ifplugd.conf > /tmp/ifplugd.conf
        fi
	mv /tmp/ifplugd.conf /etc/ifplugd
	sed -e "s/config_file=.*/config_file=${config_file}/" /etc/init.d/soc_camera.sh > /tmp/soc_camera.sh
	mv /tmp/soc_camera.sh /etc/init.d/soc_camera.sh
	sed -e "s/fdtimage=.*/fdtimage=\/boot\/$newfile/" /etc/uBoot.env > /tmp/uBoot.env
	mv /tmp/uBoot.env /etc/uBoot.env
fi

