#!/usr/bin/env python
"""
Created on Fri Jul 31 10:56:26 2015

@author: dpearlman
"""
import os, subprocess
from optparse import OptionParser

p = subprocess.Popen(['/www/pages/getnetdata.sh'], shell=False, stdout=subprocess.PIPE);
curnetstatus = p.communicate()
ifaces = curnetstatus[0].split()




#Process command line arguments 
parser = OptionParser()
parser.add_option("-d", "--dhcp_enable_usb0", 
                  action="store_true", dest="dhcp_usb0", default=False,
                  help="Enable DHCP for usb0")
parser.add_option("-D", "--dhcp_enable_eth0", 
                  action="store_true", dest="dhcp_eth0", default=False,
                  help="Enable DHCP for eth0")
parser.add_option("-a", "--addr_usb0", dest="addr_usb0",
                  help="Specify the IP address of usb0")
parser.add_option("-A", "--addr_eth0", dest="addr_eth0",
                  help="Specify the IP address of eth0")
parser.add_option("-n", "--network_mask_usb0", dest="netmask_usb0",
                  help="Specify the network mask of usb0")
parser.add_option("-N", "--network_mask_eth0", dest="netmask_eth0",
                  help="Specify the network mask of eth0")
parser.add_option("-g", "--gateway", dest="gateway",
                  help="Specify the default gateway")             
parser.add_option("-u", "--usb0_configuration_enable", 
                  action="store_true", dest="usb_enable", default=False,
                  help="Enable configuration of usb0. Without this set, usb parameters will have no effect.")
(options, args) = parser.parse_args();

if(not options.dhcp_eth0):
    try:
        if(options.addr_eth0):
            eth0_addr = options.addr_eth0
        else:
            eth0_addr = ifaces[10]
        if(options.netmask_eth0):
            eth0_nm = options.netmask_eth0
        else:
            eth0_nm = ifaces[12]
        if(options.gateway):
            eth0_gw = options.gateway
        else:
            eth0_gw = ifaces[13]
    except:
        print len(ifaces)
        eth0_addr = "10.0.47.2"
        eth0_nm = "255.255.0.0"
        eth0_gw = "10.0.0.1"
        
if(options.usb_enable):        
    if(not options.dhcp_usb0):
        try:
            if(options.addr_usb0):
                usb0_addr = options.addr_usb0
            else:
                usb0_addr = ifaces[3]
            if(options.netmask_usb0):
                usb0_gw = options.netmask_usb0
            else:
                usb0_nm = ifaces[5]
            if(options.gateway_usb0):
                usb0_nm = options.gateway
            else:
                usb0_gw = ifaces[6]
        except:
            usb0_addr = "10.1.47.2"
            usb0_nm = "255.255.0.0"
            usb0_gw = "10.0.0.1"
else:
    options.dhcp_usb0 = (ifaces[2] == "dhcp")
    usb0_addr = ifaces[3]
    usb0_nm = ifaces[5]
    usb0_gw = ifaces[4]

interfaces = open('/etc/network/interfaces','w')      
foo = """
# This file is auto generated from /www/pages/netconfig.py
#

auto lo
iface lo inet loopback

# Wireless interfaces
# none present now, but may be in future
iface wlan0 inet dhcp
        wireless_mode managed
        wireless_essid any
        wpa-driver wext
        wpa-conf /etc/wpa_supplicant.conf

# Bluetooth networking
# none present now, but may be in future
iface bnep0 inet dhcp

# We'll never have this interface
# iface atml0 inet dhcp

# default second ethernet device, if enabled, for DHCP
iface eth1 inet dhcp

"""
interfaces.write(foo)
foo = """
# Wired ethernet 0 interface
auto eth0 """
if(options.dhcp_eth0):
    foo = foo + """
iface eth0 inet dhcp
    pre-up ifconfig eth0 mtu 4000
"""
else:
    foo = foo + """
iface eth0 inet static
    pre-up ifconfig eth0 mtu 4000
    address %s
    netmask %s
    gateway %s
    """ % (eth0_addr,eth0_nm,eth0_gw)
interfaces.write(foo)

foo = """
# Wired usb0 RNDIS interface
auto usb0 """

if(options.dhcp_usb0):
    foo = foo + """
iface usb0 inet dhcp
"""
else:
    foo = foo + """
iface usb0 inet static
    address %s
    netmask %s
    gateway %s
    """ % (usb0_addr,usb0_nm,usb0_gw)
    

interfaces.write(foo)
interfaces.flush()
os.fsync(interfaces.fileno())
interfaces.close()



