#! /bin/sh
#
# Controls the camera application background process.

case "$1" in
start)
	
	if ! pidof camera_application >/dev/null; then
		echo "Launching camera control software"
######### This is no longer used with the updated CameraLink boards. ##########
		# set PSW into CMOS mode (not OS or OD)
#		memtool -32 ffb40034=0x26F8877

		# set VBUS to use ext VBUS control, disable VBUS
#		memtool -32 ffb40034=0x24A0041
###############################################################################

		# tune up the networking
		ethtool -C eth0 tx-frames 2 
		sysctl -w net.ipv4.tcp_sack=0
		sysctl -w net.ipv4.tcp_no_metrics_save=1
		ifconfig eth0 txqueuelen 10000

		#ensure cmemk is ready to go
		rmmod cmemk
		insmod /lib/modules/3.12.0/kernel/extra/cmemk.ko phys_start=0x20000000 phys_end=0x40000000

		# If the kernel version has not been written, write it now.
		if [ ! -z /home/root/application/version/kernel_version.txt ]
		then
			uname -a > /home/root/application/version/kernel_version.txt
		fi

modprobe spi-cl 
 modprobe gpio-camio 
 modprobe uio 
 modprobe uio_pdrv_genirq of_id="uio,irq"

		# Go to the application directory and start the software.
		cd /home/root/application/
		echo starting application
		(nohup ./camera_application -f CIS1910_TEC_CAMLINK 2>&1 | logger) &
		echo application started
	else
		echo "Camera Application already running"
	fi
	;;

stop)

	if pidof camera_application >/dev/null; then
		killall -9 camera_application  >/dev/null
		echo "camera application stopped.."
	else
		echo "camera application not running.."
	fi
	;;
	

restart)
	$0 stop
	$0 start
	;;

*)
	echo "Usage: $0 {start|stop|restart}"
	exit 1
	;;

esac

echo exiting with return code 0
exit 0

