#!/usr/bin/env python

import cgi, os, subprocess

form = cgi.FieldStorage()

p = subprocess.Popen(['/www/pages/getnetdata.sh'], shell=False, stdout=subprocess.PIPE);
curnetstatus = p.communicate()
ifaces = curnetstatus[0].split()

print "Content-type: text/html"
print
print """
<html>
<head><title>MityCAM Network Configuration Page</title></head>
<body>
"""

if form.getvalue('usb0_addr'):
	print """
	<h1> Updating...</h1>
"""
	interfaces = open('/etc/network/interfaces','w')
	foo = """
# This file is auto generated from /www/pages/netconfig.py
#

auto lo
iface lo inet loopback

# Wireless interfaces
# none present now, but may be in future
iface wlan0 inet dhcp
        wireless_mode managed
        wireless_essid any
        wpa-driver wext
        wpa-conf /etc/wpa_supplicant.conf

# Bluetooth networking
# none present now, but may be in future
iface bnep0 inet dhcp

# We'll never have this interface
# iface atml0 inet dhcp

# default second ethernet device, if enabled, for DHCP
iface eth1 inet dhcp

"""
	interfaces.write(foo)
	foo = """
# Wired ethernet 0 interface
auto eth0 """
	if form.getvalue('eth0_dhcp'):
		foo = foo + """
iface eth0 inet dhcp
"""
	else:
		foo = foo + """
iface eth0 inet static
	address %s
	netmask %s
	network %s
	gateway %s
""" % (form.getvalue('eth0_addr'),form.getvalue('eth0_nm'),form.getvalue('eth0_nm'),form.getvalue('eth0_gw'))
	interfaces.write(foo)

	foo = """
# Wired usb0 RNDIS interface
auto usb0 """

	if form.getvalue('usb0_dhcp'):
		foo = foo + """
iface usb0 inet dhcp
"""
	else:
		foo = foo + """
iface usb0 inet static
	address %s
	netmask %s
	network %s
	gateway %s
""" % (form.getvalue('usb0_addr'),form.getvalue('usb0_nm'),form.getvalue('usb0_nm'),form.getvalue('usb0_gw'))

	interfaces.write(foo)
	interfaces.flush()
	os.fsync(interfaces.fileno())
	interfaces.close()

	p = subprocess.Popen(['/sbin/ifdown','-f','eth0'], shell=False, stdout=subprocess.PIPE, env={"PATH": "/usr/bin:/sbin:/bin:/usr/bin"});
	currentstatus = p.communicate()
	p = subprocess.Popen(['/sbin/ifup','eth0'], shell=False, stdout=subprocess.PIPE, env={"PATH": "/usr/bin:/sbin:/bin:/usr/bin"});
	currentstatus = p.communicate()
	p = subprocess.Popen(['/sbin/ifdown','-f','usb0'], shell=False, stdout=subprocess.PIPE, env={"PATH": "/usr/bin:/sbin:/bin:/usr/bin"});
	currentstatus = p.communicate()
	p = subprocess.Popen(['/sbin/ifup','usb0'], shell=False, stdout=subprocess.PIPE, env={"PATH": "/usr/bin:/sbin:/bin:/usr/bin"});
	currentstatus = p.communicate()
	subprocess.check_output(['/bin/sync'], stderr=subprocess.STDOUT, shell=True)


print """

  <h1> MityCAM-SoC Network Configuration Page </h1>

"""

usb0_dhcp="";
if ifaces[0*6+2]=='dhcp':
	usb0_dhcp="checked";

print """

   <h2> Network Configuration Update </h2>

   <form enctype="multipart/form-data" 
                     action="netconfig.py" method="post">
   <table border=1>
   <tr><th>Interface</th><th>MAC Address</th><th>DHCP?</th><th>Address</th><th>Network Mask</th><th>Gateway</th></tr>
   <tr>
	   <td>%s</td>
	   <td>%s</td>
	   <td><input type="checkbox" name="%s_dhcp" value="dhcp" %s></td>
	   <td><input type="text" name="%s_addr" value="%s"></td>
	   <td><input type="text" name="%s_nm" value="%s"></td>
	   <td><input type="text" name="%s_gw" value="%s"></td>
   </tr>
""" % (ifaces[0*6], ifaces[0*6+1], ifaces[0*6], usb0_dhcp, ifaces[0*6], ifaces[0*6+3], ifaces[0*6],
ifaces[0*6+5], ifaces[0*6], ifaces[0*6+5])

eth0_dhcp="";
if ifaces[1*6+2]=='dhcp':
	eth0_dhcp="checked";

print """
   <tr>
	   <td>%s</td>
	   <td>%s</td>
	   <td><input type="checkbox" name="%s_dhcp" value="dhcp" %s></td>
	   <td><input type="text" name="%s_addr" value="%s"></td>
	   <td><input type="text" name="%s_nm" value="%s"></td>
	   <td><input type="text" name="%s_gw" value="%s"></td>
   </tr>
""" % (ifaces[1*6], ifaces[1*6+1], ifaces[1*6], eth0_dhcp, ifaces[1*6], ifaces[1*6+3], ifaces[1*6],
ifaces[1*6+5], ifaces[1*6], ifaces[1*6+5])
print """
   </table>
   <br>
   <input type="submit" value="Update" /></p>
   </form>

   <br>
   <A href='/index.py'>Main Page</a>

</body>
</html>
"""
